(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     53774,       2003]*)
(*NotebookOutlinePosition[     57303,       2118]*)
(*  CellTagsIndexPosition[     56902,       2101]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 8",
    FontSize->18],
  "\nIsomorphisms"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.8"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["8.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.9.8"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell["8.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.10.8"],

Cell["\<\
To complete this lab, you should be familiar enough with the basic \
properties of groups to be able to compare the various pairs of groups that \
you will be asked to examine. No previous labs are necessary.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["8.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.11.8"],

Cell[TextData[{
  "This lab explores the notion of isomorphisms. First we define an ",
  StyleBox["isomorphism",
    FontSlant->"Italic"],
  " and then we see how one can be constructed. Next we explore when two \
groups are isomorphic."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["8.3 What is an isomorphism?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.12.8"],

Cell["\<\
Before beginning, we read in the necessary code for this lab.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s consider two groups, ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[G]\), 
    \(G\_1 = U[10]\), 
    \(G\_2 = Z[4]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "An important question in abstract algebra (and in mathematics in general) \
is \[OpenCurlyDoubleQuote]When are two objects the \[OpenCurlyQuote]same\
\[CloseCurlyQuote] by some appropriate measurement?\[CloseCurlyDoubleQuote] \
In this case, are groups ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " the same? Clearly they have different elements and different operations, \
so they are not identical. They do, however, both have four elements and in \
this way they are the same. Therefore, we can construct a one-to-one, onto \
function (bijection) from ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  ". In fact, there are 24 different ways of setting up such functions."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Explain how one comes up with 24 different bijections from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  ". How many functions (bijections or not) are there from ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  "?"
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If we consider only the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["number",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " of elements (four in each, in our case), we ignore a large portion of the \
richness of groups and we ignore the operation altogether. Since each group \
has a special element, the identity, it may be reasonable to want to match \
these up.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(GroupIdentity[G\_1]\), 
    \(GroupIdentity[G\_2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Thus, if we want to define a function ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f : G\_1\), 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], \(G\_2\)}], TraditionalForm]]],
  " that somehow illustrates \[OpenCurlyDoubleQuote]sameness,\
\[CloseCurlyDoubleQuote] we might want to define ",
  Cell[BoxData[
      \(TraditionalForm\`f(1) = 0\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[1] = 0\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". With this assumption, how many different bijections are there from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "We need three more matches to make a bijection. Consider the element 3 in \
",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  ". To what should it be mapped? Is there any special property related to 3 \
that should also exist with the element in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " to which it will be mapped? What about the order of 3?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfElement[G\_1, 3]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "It would seem reasonable to want to map 3 to an element in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " of the same order. What are the orders of the elements in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  "?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfAllElements[G\_2]\)], "Input",
  AspectRatioFixed->True],

Cell["If the output is not clear, ask about the function:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?OrderOfAllElements\)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "So we see that the two elements 1 and 3 in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " both have order 4. (Of course, you may have already known this; we are \
illustrating a general process we might take.) Suppose we map 3 in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " to 1 in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f[3] = 1\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". With this assumption, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["now ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["how many different bijections are there from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Since we are mapping 3 to 1, it might be reasonable to map the inverse of \
3 in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " to the inverse of 1 in ",
  Cell[BoxData[
      \(TraditionalForm\`\(G\_2 . \)\)]],
  " (Again, you should already know the results of the following; we are \
illustrating a general procedure.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(GroupInverse[G\_1, 3]\), 
    \(GroupInverse[G\_2, 1]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "So we map 7 in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " to 3 in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f[7] = 3\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(| g\) | \) = \(\(| g\)\^\(-1\) | \)\)]],
  ", we know that the orders in this assignment match. The two remaining \
elements are put together by default."
}], "Text",
  ShowShortBoxForm->True,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f[9] = 2\)], "Input",
  AspectRatioFixed->True],

Cell["Do the orders match in this case?", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(OrderOfElement[G\_1, 9]\), 
    \(OrderOfElement[G\_2, 2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Indeed. If all we care about is whether orders match up, we are done and \
we might call these two groups the same. There might be other issues to \
consider, however. In ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  ", when we multiply 7 by 9 we get 3."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[op]\), 
    \(op\_1 = Operation[G\_1]; \nop\_1[7, 9]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s review our definition of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?f\)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We see that 7 is mapped to 3 and 9 is mapped to 2. What happens if we add \
3 (the image of 7) and 2 (the image of 9) in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  "? Surely we get 1."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(op\_2 = Operation[G\_2]; \nop\_2[3, 2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["More important, observe that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`1 = \(3 + 2 = f(7) + f(9)\)\)]],
  StyleBox[" but also ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`1 = \(f(3) = f(7*9)\)\)]],
  StyleBox[". In other words, ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`f(7*9) = f(7) + f(9)\)]],
  StyleBox[".",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that on the left-hand side, the operation inside the parentheses is \
taking place inside ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " (the domain of ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "), while the operation on the right-hand side is taking place inside ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  ". In this case, we say ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is \[OpenCurlyDoubleQuote]operation preserving\[CloseCurlyDoubleQuote] \
for the elements 7 and 9. What about other pairs? We can make a table and \
check all possibilities:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(els = Elements[G\_1]\), 
    \(Table[
      f[op\_1[els\[LeftDoubleBracket]i\[RightDoubleBracket], 
            els\[LeftDoubleBracket]j\[RightDoubleBracket]]] == 
        op\_2[f[els\[LeftDoubleBracket]i\[RightDoubleBracket]], 
          f[els\[LeftDoubleBracket]j\[RightDoubleBracket]]], {i, 4}, {j, 4}]
      \)}], "Input",
  AspectRatioFixed->True],

Cell["Or if you want to see more details:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ListOperationPreservingElements[f, G\_1, G\_2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "This shows that the function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is operation preserving for all the elements in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  ". This is when algebraists are satisfied with calling two groups ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " the same: there exists a bijection ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f : G\_1\), 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], \(G\_2\)}], TraditionalForm]]],
  " that is operation-preserving in the sense that "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`f(x*y) = \(f(x)\)*\(f(y)\)\)]]], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["for all elements ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[
  " (with the understanding that on the left-hand side the operation taking \
place between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" is the operation in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" and the operation taking place on the right-hand side between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(y)\)]],
  StyleBox[" is taking place in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  StyleBox["). In such a case, the two groups are said to be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["isomorphic",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" and the defining function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is said to be an",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" isomorphism.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Change ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_8\)]],
  StyleBox[" and determine whether ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_8\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_4\)]],
  StyleBox[
  " are isomorphic. If so, provide the isomorphism; if not, indicate why not. \
(",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Clear[f]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" before beginning.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["8.4 Creating Morphoids", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.13.8"],

Cell[TextData[{
  StyleBox["In previous labs, we have used a structure called a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" when we worked with groups. Now we use a structure called a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " to work with morphisms, including homomorphisms and isomorphisms. Recall \
from the previous section that an isomorphism ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[
  " between two groups is a bijective (one-to-one and onto) mapping such that \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x*y) = \(f(x)\)*\(f(y)\)\)]],
  StyleBox[" for all elements ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" in the domain. If we relax the condition that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[
  " is bijective and require only the \
\[OpenCurlyDoubleQuote]operation-preserving\[CloseCurlyDoubleQuote] part, we \
have a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["homomorphism.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" A ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is a structure that has the potential of being a homomorphism (and \
therefore potentially also an isomorphism).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Recall that our function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" was defined as follows.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[1] = 0; \nf[3] = 1; \nf[7] = 3; \nf[9] = 2; \)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We can use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FormMorphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to create a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" based on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(func1 = FormMorphoid[f, U[10], Z[4]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Alternatively we can set up a list of rules that are equivalent to ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(rules = Map[Rule[#, f[#]]&, Elements[U[10]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FormMorphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function can also handle a list of rules to create a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(func1alt = FormMorphoid[rules, U[10], Z[4]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The two ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["func1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["func1alt",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" appear to be different, but they are really the same. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " can be defined either by a list of rules or a function. If the underlying \
correspondences between the elements of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" are the same, the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" are considered to be equal.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(EqualMorphoidQ[func1, func1alt]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We already know that ",
  Cell[BoxData[
      FormBox[
        StyleBox["func1",
          FontFamily->"Courier"], TraditionalForm]]],
  " is an isomorphism. Let\[CloseCurlyQuote]s set this knowledge aside for \
the moment (for the sake of learning how to use some of the available tools \
in situations where we don\[CloseCurlyQuote]t know if we have an \
isomorphism). What we want to know is whether, for any given pair of elements \
in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  ", the operations are preserved?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["First we will take a specific pair, 9 and 3.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PreservesQ[func1, {9, 3}, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["In this case, we see that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(9*3)\)]],
  StyleBox[" does equal ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(9) + f(3)\)]],
  StyleBox[", since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`9*3\)]],
  StyleBox[" is 7 in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[
  " and the image of 7 is 3, which happens to be the sum of 2 (the image of \
9) and 1 (the image of 3). Note that the operation in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" is multiplication (hence, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`*\)]],
  StyleBox["), whereas it is addition in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  StyleBox[" (and so + is used).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s pick two random elements and check out whether the operations of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  StyleBox[" are preserved under the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["func1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (based on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[").",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \({g, h} = RandomElements[G\_1, 2]\), 
    \(PreservesQ[func1, {g, h}, Mode \[Rule] Visual]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Evaluate the two lines of code again several times. Do you find any case \
where the operations were ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["not ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["preserved? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Note that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PreservesQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is used when one wishes to explore whether a function is operation \
preserving for a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["particular",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " pair of elements. More generally, we are interested in doing this for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["all",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" possible pairs. The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MorphismQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" does this for us. Here we use it in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Visual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " mode; pairs that are preserved are colored at their point of intersection \
in the table.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[func1, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We can also check to see if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["func1",
    FontFamily->"Courier"],
  StyleBox[" is an isomorphism as well as a homomorphism.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(IsomorphismQ[func1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "In case one begins to think that having a homomorphism happens naturally, \
let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s take a look at an example where not all the elements preserve the \
operation. We define a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid func2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" that has ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_4\)]],
  StyleBox[" as its domain and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  StyleBox[
  " for its codomain, and the rule to get from the domain to the codomain is \
to take an element from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_4\)]],
  StyleBox[", add 1, and then reduce this result mod 5.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(func2 = FormMorphoid[Mod[#1 + 1, 5]&, Z[4], Z[5]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Now let\[CloseCurlyQuote]s check out which elements preserve the \
operations."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[func2, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We see that some do and some do not. In particular, since the entry at the \
intersection of the row headed by 1 and the column headed by 2 is not \
colored, ",
  StyleBox["func2",
    FontFamily->"Courier"],
  " is not operation-preserving for the pair ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, 2)\)\)]],
  ". Let\[CloseCurlyQuote]s look at this in detail."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PreservesQ[func2, {1, 2}, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Explain in your own words how and why this failed. Why were the \
operations not preserved?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "As you work with homomorphisms in greater detail, you will learn about the \
kernel and the image of a homomorphism. For the two ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " created here, we illustrate how to obtain the kernel and image.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(K\_1 = Kernel[func1]\), 
    \(I\_1 = Image[func1]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(K\_2 = Kernel[func2]\), 
    \(I\_2 = Image[func2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The operations of these ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" are as follows.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[Operation, {K\_1, I\_1, K\_2, I\_2}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Which of the four (the two kernels and the two images) are groups? \
Justify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["8.5 Seeing isomorphisms", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.14.8"],

Cell[TextData[
"Often, by looking at appropriate data, one can almost literally \
\[OpenCurlyDoubleQuote]see\[CloseCurlyDoubleQuote] an isomorphism at hand. \
Here we look at some examples."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["8.5.1 Example 1", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.14.9.8"],

Cell["Consider the example with which we first started.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G\_1 = U[10]\), 
    \(G\_2 = Z[4]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s look at the Cayley tables of these two groups."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[{G\_1, G\_2}, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"We have shown that these two groups were isomorphic. Shouldn\
\[CloseCurlyQuote]t their Cayley tables be identical? Think about why they \
are not. Perhaps if we ordered the elements in the second table in the order \
corresponding to the first (via our isomorphism), we might obtain different \
results."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[{{G\_1}, {G\_2, TheSet \[Rule] {0, 1, 3, 2}}}, 
      Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["This looks better. Now the isomorphism is clear.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["8.5.2 Example 2", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.14.10.8"],

Cell[TextData[{
  "We now consider ",
  Cell[BoxData[
      \(TraditionalForm\`U\_10\)]],
  " and another group of order four."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G\_1 = U[10]\), 
    \(G\_2 = U[12]\)}], "Input",
  AspectRatioFixed->True],

Cell["Are these two isomorphic?", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[{G\_1, G\_2}, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Certainly the two tables do not look alike, but we know that this does not \
necessarily mean that the two groups are not isomorphic. Below we rearrange \
the elements of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_10\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[{{G\_1, TheSet \[Rule] {1, 9, 3, 7}}, {G\_2}}, 
      Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Try other arrangements for the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_10\)]],
  StyleBox[
  " until you show that the two groups are isomorphic or conclude that they \
are not isomorphic. If they are isomorphic, describe how the isomorphism map \
works; if they are not isomorphic, explain why not.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["8.5.3 Example 3", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.14.11.8"],

Cell[TextData[{
  StyleBox["We now consider the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_2\)]],
  StyleBox[" and its Cayley table.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G\_1 = Dihedral[2]\), 
    \(\(CayleyTable[G\_1, Mode \[Rule] Visual]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "We have seen several other groups of order four. Find one that is \
isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_2\)]],
  StyleBox[". Define it and then show the Cayley tables side by side.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SubscriptBox[
          StyleBox["G",
            AspectRatioFixed->True], "2"], 
        StyleBox[" ",
          AspectRatioFixed->True], 
        StyleBox["=",
          AspectRatioFixed->True]}], 
      StyleBox[" ",
        AspectRatioFixed->True]}]], "Input"],

Cell[BoxData[
    \(CayleyTable[{G\_1, G\_2}, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "If the elements in ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " are not arranged to properly reflect the isomorphism, do so below."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(CayleyTable[{{G\_1}, {G\_2, TheSet \[Rule] {}}}, Mode \[Rule] Visual]
      \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the other group to which ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_2\)]],
  StyleBox[
  " is isomorphic and what are the details of the isomorphism? (Specify which \
elements are mapped to which.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["8.5.4 Example 4", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.14.12.8"],

Cell["Following are several groups of order six.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(SL22 = 
      FormGroupoid[{{{0, 1}, {1, 0}}, {{0, 1}, {1, 1}}, {{1, 0}, {0, 1}}, {{
              1, 0}, {1, 1}}, {{1, 1}, {0, 1}}, {{1, 1}, {1, 0}}}, 
        Mod[#1 . #2, 2]&, WideElements \[Rule] True, 
        GroupoidName \[Rule] "\<SL[2, 2]\>"]; 
    \n (*\ two - by - 
        two\ matrices\ with\ determinant\ 1\ and\ entries\ from\ 
          \[DoubleStruckCapitalZ]\_2\ *) \nG\_1 = U[9]\), 
    \(G\_2 = Z[6]\), 
    \(G\_3 = Symmetric[3]\), 
    \(G\_4 = Dihedral[3]\), 
    \(G\_5 = SL22\ \), 
    \(G\_6 = DirectSum[Z[2], Z[3]]\ \)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
Are any of these isomorphic to one another? Here are some tools you \
may wish to use.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(CayleyTable[{G\_1, G\_2, G\_3, G\_4, G\_5, G\_6}, 
      Mode \[Rule] Visual]; 
    \)\n (*\ After\ evaluating\ this, \ 
      you\ may\ wish\ to\ enlarge\ the\ graphic\ by\ selecting\ it\ and\ then
        \ dragging\ from\ a\ \(corner . \)\ *) \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(AbelianQ[{G\_1, G\_2, G\_3, G\_4, G\_5, G\_6}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(CyclicQ[{G\_1, G\_2, G\_3, G\_4, G\_5, G\_6}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[OrderOfAllElements[{G\_1, G\_2, G\_3, G\_4, G\_5, G\_6}], 
      TableDepth \[Rule] 1]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(OrderOfAllElements[{G\_1, G\_2, G\_3, G\_4, G\_5, G\_6}, 
      Mode \[Rule] Textual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?GroupCenter\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[GroupCenter, \ {G\_1, G\_2, G\_3, G\_4, G\_5, G\_6}] // ColumnForm
      \)], "Input"],

Cell[BoxData[
    \(\(?CommutatorSubgroup\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[Elements[CommutatorSubgroup[#]]&, \ 
        \ {G\_1, G\_2, G\_3, G\_4, G\_5, G\_6}] // ColumnForm\)], "Input"],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". If groups ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\_2\)]],
  StyleBox[" are isomorphic, we denote this by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\_1 \[TildeFullEqual] H\_2\)]],
  StyleBox[". For every pair ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((G\_i, G\_j)\)\)]],
  StyleBox[" of groups in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{G\_1, G\_2, G\_3, G\_4, G\_5, G\_6}\)]],
  StyleBox[", determine whether ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_i \[TildeFullEqual] G\_j\)]],
  StyleBox[
  ". Note: There are \[OpenCurlyDoubleQuote]six-choose-two\
\[CloseCurlyDoubleQuote]",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[LongDash]",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", "\[NegativeThinSpace]", GridBox[{
              {"6"},
              {"2"}
              }], "\[NegativeThinSpace]", ")"}], TraditionalForm]]],
  "\[LongDash]",
  StyleBox[" such pairs to consider.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". You probably found that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox[
  " was isomorphic to at least one of the other groups. Below, we use the \
variable ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["otherGroup",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to denote the group you had in mind; change ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_4\)]],
  StyleBox[
  " to the group you have in mind and evaluate the following cell. You now \
see the list of elements in your chosen group. Between the {} on the \
right-hand side of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["orderedElementsOfOtherGroup",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", place the elements of your chosen group matched up according to the \
elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox[
  ". After double-checking your ordering, evaluate the cell and the cell that \
defines the rules for this isomorphism, as well as the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" itself. Now use the tools illustrated earlier and verify that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[
  " is indeed an isomorphism (assuming that you correctly found an isomorphic \
group).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(otherGroup = G\_4\), 
    \(Elements[otherGroup]\), 
    \(Elements[Dihedral[3]]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(orderedElementsOfOtherGroup = {}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(rules = 
      Transpose[{Elements[Dihedral[3]], orderedElementsOfOtherGroup}] /. {x_, 
            y_} :> \(x \[Rule] y\)\), 
    \(f = FormMorphoid[rules, Dihedral[3], otherGroup]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Consider the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H = {1, Rot, Rot\^2}\)]],
  StyleBox[", which is a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox[". What is the image of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" under ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[
  "? (You may wish to use the following line.) Is this also a subgroup of the \
image of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Image[f, {1, Rot, Rot\^2}]\)], "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "8.6 ",
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.15.8"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?GroupIdentity", "Input"],

Cell["?OrderOfElement", "Input"],

Cell["?OrderOfAllElements", "Input"],

Cell["?GroupInverse", "Input"],

Cell["?Operation", "Input"],

Cell["?Elements", "Input"],

Cell["?FormMorphoid", "Input"],

Cell["?EqualMorphoidQ", "Input"],

Cell["?PreservesQ", "Input"],

Cell["?RandomElements", "Input"],

Cell["?MorphismQ", "Input"],

Cell["?IsomorphismQ", "Input"],

Cell["?Kernel", "Input"],

Cell["?Image", "Input"],

Cell["?CayleyTable", "Input"],

Cell["?TheSet", "Input"],

Cell["?Symmetric", "Input"],

Cell["?DirectSum", "Input"],

Cell["?AbelianQ", "Input"],

Cell["?CyclicQ", "Input"],

Cell["?GroupCenter", "Input"],

Cell["?CommutatorSubgroup", "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{627, 430},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{3, 4},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Lab 8 Isomorphisms", FontSlant -> "Italic"], "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:8.8"->{
    Cell[2382, 76, 161, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:8.8"]},
  "a:8.9.8"->{
    Cell[2568, 87, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:8.9.8"]},
  "a:8.10.8"->{
    Cell[6935, 234, 108, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:8.10.8"]},
  "a:8.11.8"->{
    Cell[7363, 250, 100, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:8.11.8"]},
  "a:8.12.8"->{
    Cell[7800, 268, 118, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:8.12.8"]},
  "a:8.13.8"->{
    Cell[23066, 845, 113, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:8.13.8"]},
  "a:8.14.8"->{
    Cell[38820, 1434, 114, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:8.14.8"]},
  "a:8.14.9.8"->{
    Cell[39210, 1448, 111, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:8.14.9.8"]},
  "a:8.14.10.8"->{
    Cell[40487, 1493, 112, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:8.14.10.8"]},
  "a:8.14.11.8"->{
    Cell[42291, 1563, 112, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:8.14.11.8"]},
  "a:8.14.12.8"->{
    Cell[44668, 1658, 112, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:8.14.12.8"]},
  "a:8.15.8"->{
    Cell[52395, 1932, 309, 12, 35, "Section",
      Evaluatable->False,
      CellTags->"a:8.15.8"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:8.8", 55473, 2049},
  {"a:8.9.8", 55581, 2053},
  {"a:8.10.8", 55695, 2057},
  {"a:8.11.8", 55810, 2061},
  {"a:8.12.8", 55925, 2065},
  {"a:8.13.8", 56040, 2069},
  {"a:8.14.8", 56156, 2073},
  {"a:8.14.9.8", 56275, 2077},
  {"a:8.14.10.8", 56400, 2081},
  {"a:8.14.11.8", 56526, 2085},
  {"a:8.14.12.8", 56652, 2089},
  {"a:8.15.8", 56775, 2093}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 161, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:8.8"],

Cell[CellGroupData[{
Cell[2568, 87, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:8.9.8"],
Cell[2894, 100, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3745, 124, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5115, 166, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5267, 171, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5889, 193, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6581, 219, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6935, 234, 108, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:8.10.8"],
Cell[7046, 239, 280, 6, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7363, 250, 100, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:8.11.8"],
Cell[7466, 255, 297, 8, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7800, 268, 118, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:8.12.8"],
Cell[7921, 273, 136, 5, 33, "Text",
  Evaluatable->False],
Cell[8060, 280, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[8235, 286, 244, 10, 33, "Text",
  Evaluatable->False],
Cell[8482, 298, 114, 4, 59, "Input"],
Cell[8599, 304, 895, 22, 128, "Text",
  Evaluatable->False],
Cell[9497, 328, 656, 24, 67, "Question",
  Evaluatable->False],
Cell[10156, 354, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[10233, 358, 577, 17, 71, "Text",
  Evaluatable->False],
Cell[10813, 377, 110, 3, 43, "Input"],
Cell[10926, 382, 455, 14, 52, "Text",
  Evaluatable->False],
Cell[11384, 398, 88, 3, 43, "Input"],
Cell[11475, 403, 555, 21, 48, "Question",
  Evaluatable->False],
Cell[12033, 426, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[12110, 430, 444, 12, 71, "Text",
  Evaluatable->False],
Cell[12557, 444, 82, 2, 27, "Input"],
Cell[12642, 448, 313, 10, 52, "Text",
  Evaluatable->False],
Cell[12958, 460, 83, 2, 27, "Input"],
Cell[13044, 464, 115, 2, 33, "Text",
  Evaluatable->False],
Cell[13162, 468, 82, 2, 27, "Input"],
Cell[13247, 472, 445, 14, 71, "Text",
  Evaluatable->False],
Cell[13695, 488, 67, 2, 27, "Input"],
Cell[13765, 492, 717, 27, 48, "Question",
  Evaluatable->False],
Cell[14485, 521, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[14562, 525, 412, 12, 71, "Text",
  Evaluatable->False],
Cell[14977, 539, 114, 3, 43, "Input"],
Cell[15094, 544, 219, 10, 33, "Text",
  Evaluatable->False],
Cell[15316, 556, 67, 2, 27, "Input"],
Cell[15386, 560, 313, 9, 52, "Text",
  Evaluatable->False],
Cell[15702, 571, 67, 2, 27, "Input"],
Cell[15772, 575, 97, 2, 33, "Text",
  Evaluatable->False],
Cell[15872, 579, 118, 3, 43, "Input"],
Cell[15993, 584, 343, 9, 71, "Text",
  Evaluatable->False],
Cell[16339, 595, 119, 3, 60, "Input"],
Cell[16461, 600, 183, 7, 33, "Text",
  Evaluatable->False],
Cell[16647, 609, 65, 2, 27, "Input"],
Cell[16715, 613, 276, 8, 52, "Text",
  Evaluatable->False],
Cell[16994, 623, 97, 2, 44, "Input"],
Cell[17094, 627, 477, 16, 33, "Text",
  Evaluatable->False],
Cell[17574, 645, 262, 10, 33, "Text",
  Evaluatable->False],
Cell[17839, 657, 679, 19, 90, "Text",
  Evaluatable->False],
Cell[18521, 678, 373, 8, 60, "Input"],
Cell[18897, 688, 99, 2, 33, "Text",
  Evaluatable->False],
Cell[18999, 692, 105, 2, 27, "Input"],
Cell[19107, 696, 703, 22, 71, "Text",
  Evaluatable->False],
Cell[19813, 720, 164, 4, 29, "Text",
  Evaluatable->False],
Cell[19980, 726, 1919, 69, 90, "Text",
  Evaluatable->False],
Cell[21902, 797, 1050, 39, 67, "Question",
  Evaluatable->False],
Cell[22955, 838, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[23066, 845, 113, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:8.13.8"],
Cell[23182, 850, 2067, 68, 147, "Text",
  Evaluatable->False],
Cell[25252, 920, 307, 11, 33, "Text",
  Evaluatable->False],
Cell[25562, 933, 126, 3, 91, "Input"],
Cell[25691, 938, 639, 25, 33, "Text",
  Evaluatable->False],
Cell[26333, 965, 95, 2, 27, "Input"],
Cell[26431, 969, 202, 7, 33, "Text",
  Evaluatable->False],
Cell[26636, 978, 103, 2, 27, "Input"],
Cell[26742, 982, 547, 20, 33, "Text",
  Evaluatable->False],
Cell[27292, 1004, 102, 2, 27, "Input"],
Cell[27397, 1008, 1409, 50, 90, "Text",
  Evaluatable->False],
Cell[28809, 1060, 90, 2, 27, "Input"],
Cell[28902, 1064, 608, 16, 90, "Text",
  Evaluatable->False],
Cell[29513, 1082, 108, 2, 33, "Text",
  Evaluatable->False],
Cell[29624, 1086, 105, 2, 27, "Input"],
Cell[29732, 1090, 1243, 43, 71, "Text",
  Evaluatable->False],
Cell[30978, 1135, 1044, 40, 52, "Text",
  Evaluatable->False],
Cell[32025, 1177, 150, 3, 43, "Input"],
Cell[32178, 1182, 537, 19, 67, "Question",
  Evaluatable->False],
Cell[32718, 1203, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32795, 1207, 1329, 46, 90, "Text",
  Evaluatable->False],
Cell[34127, 1255, 96, 2, 27, "Input"],
Cell[34226, 1259, 331, 11, 33, "Text",
  Evaluatable->False],
Cell[34560, 1272, 78, 2, 27, "Input"],
Cell[34641, 1276, 1187, 38, 90, "Text",
  Evaluatable->False],
Cell[35831, 1316, 108, 2, 27, "Input"],
Cell[35942, 1320, 153, 4, 33, "Text",
  Evaluatable->False],
Cell[36098, 1326, 96, 2, 27, "Input"],
Cell[36197, 1330, 445, 12, 71, "Text",
  Evaluatable->False],
Cell[36645, 1344, 105, 2, 27, "Input"],
Cell[36753, 1348, 336, 12, 67, "Question",
  Evaluatable->False],
Cell[37092, 1362, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[37169, 1366, 513, 16, 71, "Text",
  Evaluatable->False],
Cell[37685, 1384, 111, 3, 43, "Input"],
Cell[37799, 1389, 111, 3, 43, "Input"],
Cell[37913, 1394, 354, 13, 33, "Text",
  Evaluatable->False],
Cell[38270, 1409, 99, 2, 27, "Input"],
Cell[38372, 1413, 334, 12, 48, "Question",
  Evaluatable->False],
Cell[38709, 1427, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[38820, 1434, 114, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:8.14.8"],
Cell[38937, 1439, 248, 5, 52, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[39210, 1448, 111, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:8.14.9.8"],
Cell[39324, 1453, 113, 2, 33, "Text",
  Evaluatable->False],
Cell[39440, 1457, 95, 3, 43, "Input"],
Cell[39538, 1462, 147, 4, 33, "Text",
  Evaluatable->False],
Cell[39688, 1468, 111, 2, 27, "Input"],
Cell[39802, 1472, 379, 7, 71, "Text",
  Evaluatable->False],
Cell[40184, 1481, 151, 3, 27, "Input"],
Cell[40338, 1486, 112, 2, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[40487, 1493, 112, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:8.14.10.8"],
Cell[40602, 1498, 187, 7, 33, "Text",
  Evaluatable->False],
Cell[40792, 1507, 96, 3, 43, "Input"],
Cell[40891, 1512, 89, 2, 33, "Text",
  Evaluatable->False],
Cell[40983, 1516, 111, 2, 27, "Input"],
Cell[41097, 1520, 310, 9, 52, "Text",
  Evaluatable->False],
Cell[41410, 1531, 151, 3, 27, "Input"],
Cell[41564, 1536, 613, 18, 86, "Question",
  Evaluatable->False],
Cell[42180, 1556, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[42291, 1563, 112, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:8.14.11.8"],
Cell[42406, 1568, 309, 11, 33, "Text",
  Evaluatable->False],
Cell[42718, 1581, 134, 3, 43, "Input"],
Cell[42855, 1586, 403, 13, 52, "Text",
  Evaluatable->False],
Cell[43261, 1601, 314, 11, 27, "Input"],
Cell[43578, 1614, 105, 2, 27, "Input"],
Cell[43686, 1618, 223, 7, 33, "Text",
  Evaluatable->False],
Cell[43912, 1627, 135, 3, 27, "Input"],
Cell[44050, 1632, 504, 17, 67, "Question",
  Evaluatable->False],
Cell[44557, 1651, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[44668, 1658, 112, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:8.14.12.8"],
Cell[44783, 1663, 106, 2, 33, "Text",
  Evaluatable->False],
Cell[44892, 1667, 604, 14, 187, "Input"],
Cell[45499, 1683, 158, 5, 33, "Text",
  Evaluatable->False],
Cell[45660, 1690, 311, 6, 59, "Input"],
Cell[45974, 1698, 105, 2, 27, "Input"],
Cell[46082, 1702, 104, 2, 27, "Input"],
Cell[46189, 1706, 155, 3, 43, "Input"],
Cell[46347, 1711, 150, 3, 27, "Input"],
Cell[46500, 1716, 75, 2, 27, "Input"],
Cell[46578, 1720, 110, 2, 27, "Input"],
Cell[46691, 1724, 82, 2, 27, "Input"],
Cell[46776, 1728, 135, 2, 43, "Input"],
Cell[46914, 1732, 1554, 53, 100, "Question",
  Evaluatable->False],
Cell[48471, 1787, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[48548, 1791, 2060, 67, 181, "Question",
  Evaluatable->False],
Cell[50611, 1860, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[50688, 1864, 141, 4, 59, "Input"],
Cell[50832, 1870, 91, 2, 27, "Input"],
Cell[50926, 1874, 242, 5, 59, "Input"],
Cell[51171, 1881, 1010, 37, 67, "Question",
  Evaluatable->False],
Cell[52184, 1920, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[52261, 1924, 85, 2, 31, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[52395, 1932, 309, 12, 35, "Section",
  Evaluatable->False,
  CellTags->"a:8.15.8"],
Cell[52707, 1946, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[53052, 1957, 31, 0, 27, "Input"],
Cell[53086, 1959, 32, 0, 27, "Input"],
Cell[53121, 1961, 36, 0, 27, "Input"],
Cell[53160, 1963, 30, 0, 27, "Input"],
Cell[53193, 1965, 27, 0, 27, "Input"],
Cell[53223, 1967, 26, 0, 27, "Input"],
Cell[53252, 1969, 30, 0, 27, "Input"],
Cell[53285, 1971, 32, 0, 27, "Input"],
Cell[53320, 1973, 28, 0, 27, "Input"],
Cell[53351, 1975, 32, 0, 27, "Input"],
Cell[53386, 1977, 27, 0, 27, "Input"],
Cell[53416, 1979, 30, 0, 27, "Input"],
Cell[53449, 1981, 24, 0, 27, "Input"],
Cell[53476, 1983, 23, 0, 27, "Input"],
Cell[53502, 1985, 29, 0, 27, "Input"],
Cell[53534, 1987, 24, 0, 27, "Input"],
Cell[53561, 1989, 27, 0, 27, "Input"],
Cell[53591, 1991, 27, 0, 27, "Input"],
Cell[53621, 1993, 26, 0, 27, "Input"],
Cell[53650, 1995, 25, 0, 27, "Input"],
Cell[53678, 1997, 29, 0, 27, "Input"],
Cell[53710, 1999, 36, 0, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

