(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     43349,       1636]*)
(*NotebookOutlinePosition[     45936,       1721]*)
(*  CellTagsIndexPosition[     45690,       1709]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 9",
    FontSize->18],
  "\nAutomorphisms"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.9"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["9.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.10.9"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["9.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.11.9"],

Cell["To complete this lab, you should have completed Group Lab 8.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["9.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.12.9"],

Cell["\<\
This lab continues the exploration of isomorphisms begun in Group \
Lab 8. In this lab, we look at a collection of isomorphisms from a group to \
itself and ask what kind of structure, if any, might be present.\
\>", "Text",\

  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["9.3 Automorphisms on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.13.9"],

Cell["\<\
Before beginning, we read in the necessary code for this lab.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  "In Group Lab 8 we considered questions such as \[OpenCurlyDoubleQuote]Is ",
  
  Cell[BoxData[
      \(TraditionalForm\`U\_12\)]],
  " isomorphic to ",
  Cell[BoxData[
      \(TraditionalForm\`U\_10\)]],
  " (or other groups besides ",
  Cell[BoxData[
      \(TraditionalForm\`U\_10\)]],
  ")?\[CloseCurlyDoubleQuote] Consider the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  ". We never asked \[OpenCurlyDoubleQuote]Is ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  " isomorphic to ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  " (i.e., itself)?\[CloseCurlyDoubleQuote] Why not ask this? Is the answer \
obvious? On the one hand, since isomorphisms indicate that two groups are the \
\[OpenCurlyDoubleQuote]same\[CloseCurlyDoubleQuote] in some sense, if two \
groups are identical (as in this case), we should certainly expect them to be \
isomorphic. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Indeed, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[
  " is isomorphic to itself. Which isomorphism (map) will show this? Try the \
identity function that takes every element to itself. All the properties \
hold. Since we are mapping from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[" to itself, we call this kind of isomorphism an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["auto",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["morphism. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["We illustrate the use of the identity function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f\_1 = FormMorphoid[Identity, Z[12], Z[12]]\), 
    \(IsomorphismQ[f\_1]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We can see the details of this ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" by looking at the rules used in its definition.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ToRules[f\_1]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
A more important question to ask at this time is whether there are \
any other automorphisms besides the identity map. We know that we must map 0 \
to 0. (Why?) What about the element 5? Since it is a generator and has order \
12, to what must it be mapped? Clearly it needs to go to another generator, \
if we wish to preserve orders. So it could be mapped to 1, 5, 7, or 11. \
\>",
   "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " be any other element of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  ". Since 5 is a generator, ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(n\ 5 = 5 + 5 + \[CenterEllipsis] + 5\)\)]],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " summands) for some integer ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". To what should we map ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "? Suppose our function is ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". Then,"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`f(x) = \(f(5 + 5 + \[CenterEllipsis] + 5) = 
        f(5) + f(5) + \[CenterEllipsis] + f(5)\)\)]]], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  "with ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " summands in both instances. This should indicate that once we know where \
5 is mapped, we know where every element is mapped."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Explain this last statement (in such a way that would convince a \
classmate who may not have heard this yet).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Since we know we can send the generator 5 to any one of the four \
generators, let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s make a function for each possibility. Below we use a function called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Automorphism",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " that allows us to specify a rule as a generator and build the complete \
morphism from that single piece of information. Asking for more information \
about a function is always a good idea.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Automorphism\)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We can also get further information by specifying the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Textual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" mode of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Automorphism",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f\_2 = Automorphism[Z[12], 5 \[Rule] 1, Mode \[Rule] Textual]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Instead of checking to see if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox[
  " are morphisms, we can check whether they are isomorphisms directly with ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["IsomorphismQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(IsomorphismQ[f\_1]\), 
    \(IsomorphismQ[f\_2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s create our last two automorphisms and check them."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f\_3 = Automorphism[Z[12], 5 \[Rule] 7]\), 
    \(IsomorphismQ[f\_3, Cautious \[Rule] True]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f\_4 = Automorphism[Z[12], 5 \[Rule] 11]\), 
    \(IsomorphismQ[f\_4, Cautious \[Rule] True]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We now have four automorphisms. What can we do with these functions? Is \
this set of four functions anything special? What would happen if we follow \
one by another (i.e., compose the functions)? In particular, what do we get \
if we follow ",
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`f\_3\)]],
  "?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["First, define ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Els",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to be the elements of the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  " ",
  StyleBox["under consideration.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Els = Elements[Z[12]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We want the output of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox[" to be the input for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_3\)]],
  StyleBox[", so let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s evaluate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox[" at the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Els",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f\_2[Els]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This maps ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox[" over each element in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Els",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". We could also have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox[" mapped onto each element by using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Map",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" command.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f2Output = Map[f\_2, \ Els]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we use this as input for ",
  Cell[BoxData[
      \(TraditionalForm\`f\_3\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[f\_3, \ f2Output]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Now the question is which function, if any, has the same output (in this \
order) when mapped over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Els",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["? Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s try each one.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Map[f\_1, Els]\), 
    \(Map[f\_2, Els]\), 
    \(Map[f\_3, Els]\), 
    \(Map[f\_4, Els]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Great! The function ",
  Cell[BoxData[
      \(TraditionalForm\`f\_4\)]],
  " has the same images as the images of ",
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  " followed by ",
  Cell[BoxData[
      \(TraditionalForm\`f\_3\)]],
  ". But what does this mean?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the relationship, if any, between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_3\)]],
  ",",
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_4\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Modify the steps above and determine the result of taking ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_4\)]],
  ".",
  StyleBox[" Which function, if any, does this yield?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Where are we going with all this? What seems to be lurking around the \
corner (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" computation)?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Suppose we try to automate all this work. First we define our list of \
automorphisms but redefine ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  StyleBox[" using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Automorphism",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", converting it into a rules-based ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". (This is necessary to form a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f\_1 = Automorphism[Z[12], 5 \[Rule] 5]\), 
    \(automorphisms = {f\_1, f\_2, f\_3, f\_4}\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We can operate on these automorphisms with the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MorphoidComposition",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?MorphoidComposition\)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "If we want to know ",
  Cell[BoxData[
      \(TraditionalForm\`f\_4\)]],
  " followed by ",
  Cell[BoxData[
      \(TraditionalForm\`f\_3\)]],
  ", we use the following. (Notice that the ordering is from right to left.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphoidComposition[f\_3, f\_4]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Or ",
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  " followed by ",
  Cell[BoxData[
      \(TraditionalForm\`f\_4\)]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphoidComposition[f\_4, f\_1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "The next question we might ask concerns a Cayley table. First we need to \
turn this set and operation into a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". We will call it ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Automorphisms",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Automorphisms = 
      FormGroupoid[automorphisms, MorphoidComposition[#1, #2]&, 
        WideElements \[Rule] True, KeyForm \[Rule] OutputForm]\)], "Input",
  AspectRatioFixed->True],

Cell["Now for the moment for which we have all been waiting:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[Automorphisms, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Does this appear to be a group? Why? Is there an identity? If so, what \
is it; if not, why not? Since this is of order four, to what familiar group \
is this isomorphic?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["All the work above is automated in the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AutomorphismGroup",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?AutomorphismGroup\)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s change our modulus from 12 to 10 and see what kind of \
group we get."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = AutomorphismGroup[Z[10]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Now take a look at its Cayley table.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[G, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". To what familiar group is this isomorphic?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Let\[CloseCurlyQuote]s try one more."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(G = AutomorphismGroup[Z[14]]; \)\), 
    \(\(CayleyTable[G, Mode \[Rule] Visual]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". To what familiar group is this isomorphic?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["9.4 Inner automorphisms", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.14.9"],

Cell[TextData[StyleBox[
"We have seen how we obtain all the automorphisms on a cyclic group. If the \
group is not cyclic, the question is a bit harder. There are certain \
automorphisms, however, that are easy to generate for any group. ",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" be any group and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" by any element in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[". Consider the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\(f\_g\) : G\), 
            StyleBox["\[Rule]",
              FontFamily->"Courier"], "G"}], " "}], TraditionalForm]]],
  StyleBox["defined by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(f\_g\)(h) = g\ h\ g\^\(-1\)\)]],
  StyleBox[". We call ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ h\ g\^\(-1\)\)]],
  StyleBox[" the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["conjugate of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" by ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and the process of applying ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_g\)]],
  StyleBox[" to an element is called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["conjugation. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". If the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" is Abelian, what happens when we conjugate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox["? What is the map ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_g\)]],
  StyleBox[" in this case?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Consider the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = D\_4\)]],
  StyleBox[" and let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s try conjugating some elements using the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ElementConjugate",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Dihedral[4]\n (*\ 
      recall\ Rot\ is\ the\ element\ corresponding\ to\ the\ lowest\ order\ 
        rotation, \ 90  \[Degree]\ in\ this\ case, \ 
      and\ Ref\ is\ any\ reflection\ *) \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?ElementConjugate\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(ElementConjugate[Dihedral[4], Rot\^3, Rot]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(ElementConjugate[Dihedral[4], Ref, Rot]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
We can speed this up by looking at all the conjugates at once.\
\>",
   "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ConjugatingElement = Rot; 
    TableForm[
      Transpose[{els\ \  = \ Elements[Dihedral[4]], 
          Map[ElementConjugate[Dihedral[4], #1, ConjugatingElement]&, els]}], 
      TableHeadings 
        \[Rule] {None, 
          \n{"\<h\>", 
            "\<h conjugated by \>"<>ToString[ConjugatingElement]<>"\<\n\>"}}, 
      TableSpacing \[Rule] {0.5, 5}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Which elements were not changed when they were conjugated by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["? Is there anything special about this set?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["What if we conjugate by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ConjugatingElement = Ref; \n
    TableForm[
      Transpose[{Elements[Dihedral[4]], 
          \((ElementConjugate[Dihedral[4], #1, ConjugatingElement]&)\)/@
            Elements[Dihedral[4]]}], 
      TableHeadings 
        \[Rule] {
          None, {"\<h\>", 
            "\<h conjugated by \>"<>ToString[ConjugatingElement]<>"\<\n\>"}}, 
      TableSpacing \[Rule] {0.5, 5}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For each element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in a group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", there is a conjugation function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_g\)]],
  " (that takes an element to its conjugation by ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ")",
  StyleBox[". Note that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_g\)]],
  StyleBox[" is a function from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[
  " and therefore a candidate for being an automorphism. In fact, each of \
these functions is an automorphism and is called an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["inner automorphism of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" induced by ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" We can use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to help us construct them.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?InnerAutomorphism\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f\_1 = InnerAutomorphism[Dihedral[4], Rot\^2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s look at some details of this function. One way of \
seeing the action is to map ",
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  " onto the elements of the group."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[f\_1, Elements[Dihedral[4]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Is ",
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  " really an automorphism?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(IsomorphismQ[f\_1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Suppose we call ",
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  " the inner automorphism induced by ",
  Cell[BoxData[
      \(TraditionalForm\`Rot\^3\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f\_2 = InnerAutomorphism[Dihedral[4], Rot\^3]\), 
    \(Map[f\_2, Elements[Dihedral[4]]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox[
  " are functions, it is legitimate to ask about the composition. Will this \
be another inner automorphism? If so, which one? Perhaps we should try to \
find all the inner automorphisms by mapping the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["InnerAutomorphism",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function onto the elements of the group. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(funcs = 
      Map[InnerAutomorphism[Dihedral[4], #]&, Elements[Dihedral[4]]]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[
" Now let\[CloseCurlyQuote]s map each of these onto the elements of the group \
to see if any of these functions are the same."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(images = Map[Map[#, Elements[Dihedral[4]]]&, \ funcs]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". By looking at this list, would you say that any of these functions are \
the same? If so, which ones?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Sorting this list, we remove any duplicates.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Union[images]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "At this stage, you should be able to match up each of these lists with \
those in ",
  StyleBox["images",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  " and likewise determine the inner automorphisms with which they are \
associated. We put all of this (and more) together in one function."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = InnerAutomorphismGroup[Dihedral[4]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The elements of this ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" are suppressed until we ask for them.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Elements[G]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s look at the details of the second element."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphoidRules[\(Elements[G]\)\[LeftDoubleBracket]2\[RightDoubleBracket]]
      \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Here is the Cayley table for this group.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[G, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". You now know about the different groups of order four. To what (common) \
group is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" isomorphic?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Consider the following groups. ", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(K = InnerAutomorphismGroup[Dihedral[5]]; \)\), 
    \(\(CayleyTable[K, Mode \[Rule] Visual]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(L = InnerAutomorphismGroup[Dihedral[6]]; \)\), 
    \(\(CayleyTable[L, Mode \[Rule] Visual, ShowKey \[Rule] False]; \)\)}], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Make a conjecture about the inner automorphism group of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_n\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.5 ",
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.9"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Automorphism", "Input"],

Cell["?MorphoidComposition", "Input"],

Cell["?AutomorphismGroup", "Input"],

Cell["?ElementConjugate", "Input"],

Cell["?InnerAutomorphism", "Input",
  AspectRatioFixed->True],

Cell["?InnerAutomorphismGroup", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{624, 427},
WindowMargins->{{2, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{5, 6},
PageHeaders->{{Inherited, Inherited, None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Lab 9 Automorphisms", FontSlant -> "Italic"], "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:9.9"->{
    Cell[2382, 76, 162, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:9.9"]},
  "a:9.10.9"->{
    Cell[2569, 87, 324, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:9.10.9"]},
  "a:9.11.9"->{
    Cell[7093, 240, 108, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:9.11.9"]},
  "a:9.12.9"->{
    Cell[7365, 252, 100, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:9.12.9"]},
  "a:9.13.9"->{
    Cell[7789, 269, 263, 9, 35, "Section",
      Evaluatable->False,
      CellTags->"a:9.13.9"]},
  "a:9.14.9"->{
    Cell[28161, 1055, 114, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:9.14.9"]},
  "a:9.15.9"->{
    Cell[42386, 1595, 309, 12, 55, "Section",
      Evaluatable->False,
      CellTags->"a:9.15.9"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:9.9", 44877, 1677},
  {"a:9.10.9", 44986, 1681},
  {"a:9.11.9", 45101, 1685},
  {"a:9.12.9", 45216, 1689},
  {"a:9.13.9", 45331, 1693},
  {"a:9.14.9", 45446, 1697},
  {"a:9.15.9", 45563, 1701}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 162, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:9.9"],

Cell[CellGroupData[{
Cell[2569, 87, 324, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:9.10.9"],
Cell[2896, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3773, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5169, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5347, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[5995, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6713, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7093, 240, 108, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:9.11.9"],
Cell[7204, 245, 124, 2, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7365, 252, 100, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:9.12.9"],
Cell[7468, 257, 284, 7, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7789, 269, 263, 9, 35, "Section",
  Evaluatable->False,
  CellTags->"a:9.13.9"],
Cell[8055, 280, 136, 5, 33, "Text",
  Evaluatable->False],
Cell[8194, 287, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[8369, 293, 1038, 27, 109, "Text",
  Evaluatable->False],
Cell[9410, 322, 1007, 31, 91, "Text",
  Evaluatable->False],
Cell[10420, 355, 152, 4, 59, "Input"],
Cell[10575, 361, 392, 13, 33, "Text",
  Evaluatable->False],
Cell[10970, 376, 72, 2, 27, "Input"],
Cell[11045, 380, 452, 9, 90, "Text",
  Evaluatable->False],
Cell[11500, 391, 669, 25, 52, "Text",
  Evaluatable->False],
Cell[12172, 418, 236, 6, 29, "Text",
  Evaluatable->False],
Cell[12411, 426, 266, 8, 52, "Text",
  Evaluatable->False],
Cell[12680, 436, 355, 12, 67, "Question",
  Evaluatable->False],
Cell[13038, 450, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[13115, 454, 762, 23, 90, "Text",
  Evaluatable->False],
Cell[13880, 479, 76, 2, 27, "Input"],
Cell[13959, 483, 551, 20, 33, "Text",
  Evaluatable->False],
Cell[14513, 505, 123, 3, 27, "Input"],
Cell[14639, 510, 672, 25, 52, "Text",
  Evaluatable->False],
Cell[15314, 537, 108, 3, 43, "Input"],
Cell[15425, 542, 150, 4, 33, "Text",
  Evaluatable->False],
Cell[15578, 548, 152, 3, 43, "Input"],
Cell[15733, 553, 153, 3, 43, "Input"],
Cell[15889, 558, 442, 13, 71, "Text",
  Evaluatable->False],
Cell[16334, 573, 524, 19, 33, "Text",
  Evaluatable->False],
Cell[16861, 594, 80, 2, 27, "Input"],
Cell[16944, 598, 832, 32, 33, "Text",
  Evaluatable->False],
Cell[17779, 632, 68, 2, 27, "Input"],
Cell[17850, 636, 813, 30, 52, "Text",
  Evaluatable->False],
Cell[18666, 668, 86, 2, 27, "Input"],
Cell[18755, 672, 167, 7, 33, "Text",
  Evaluatable->False],
Cell[18925, 681, 80, 2, 27, "Input"],
Cell[19008, 685, 522, 19, 52, "Text",
  Evaluatable->False],
Cell[19533, 706, 150, 5, 75, "Input"],
Cell[19686, 713, 348, 13, 52, "Text",
  Evaluatable->False],
Cell[20037, 728, 656, 26, 48, "Question",
  Evaluatable->False],
Cell[20696, 756, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[20773, 760, 599, 21, 67, "Question",
  Evaluatable->False],
Cell[21375, 783, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[21452, 787, 591, 23, 67, "Question",
  Evaluatable->False],
Cell[22046, 812, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[22123, 816, 1131, 41, 71, "Text",
  Evaluatable->False],
Cell[23257, 859, 151, 3, 43, "Input"],
Cell[23411, 864, 381, 13, 33, "Text",
  Evaluatable->False],
Cell[23795, 879, 83, 2, 27, "Input"],
Cell[23881, 883, 299, 10, 52, "Text",
  Evaluatable->False],
Cell[24183, 895, 90, 2, 27, "Input"],
Cell[24276, 899, 211, 10, 33, "Text",
  Evaluatable->False],
Cell[24490, 911, 90, 2, 27, "Input"],
Cell[24583, 915, 621, 22, 52, "Text",
  Evaluatable->False],
Cell[25207, 939, 203, 4, 59, "Input"],
Cell[25413, 945, 118, 2, 33, "Text",
  Evaluatable->False],
Cell[25534, 949, 112, 2, 27, "Input"],
Cell[25649, 953, 415, 13, 67, "Question",
  Evaluatable->False],
Cell[26067, 968, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[26144, 972, 371, 13, 33, "Text",
  Evaluatable->False],
Cell[26518, 987, 81, 2, 27, "Input"],
Cell[26602, 991, 167, 4, 33, "Text",
  Evaluatable->False],
Cell[26772, 997, 87, 2, 27, "Input"],
Cell[26862, 1001, 168, 4, 33, "Text",
  Evaluatable->False],
Cell[27033, 1007, 100, 2, 27, "Input"],
Cell[27136, 1011, 284, 10, 48, "Question",
  Evaluatable->False],
Cell[27423, 1023, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[27500, 1027, 110, 2, 33, "Text",
  Evaluatable->False],
Cell[27613, 1031, 147, 3, 43, "Input"],
Cell[27763, 1036, 284, 10, 48, "Question",
  Evaluatable->False],
Cell[28050, 1048, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[28161, 1055, 114, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:9.14.9"],
Cell[28278, 1060, 346, 7, 71, "Text",
  Evaluatable->False],
Cell[28627, 1069, 1758, 64, 72, "Text",
  Evaluatable->False],
Cell[30388, 1135, 802, 30, 67, "Question",
  Evaluatable->False],
Cell[31193, 1167, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[31270, 1171, 615, 22, 52, "Text",
  Evaluatable->False],
Cell[31888, 1195, 253, 5, 75, "Input"],
Cell[32144, 1202, 80, 2, 27, "Input"],
Cell[32227, 1206, 101, 2, 31, "Input"],
Cell[32331, 1210, 98, 2, 27, "Input"],
Cell[32432, 1214, 137, 5, 33, "Text",
  Evaluatable->False],
Cell[32572, 1221, 416, 10, 107, "Input"],
Cell[32991, 1233, 512, 17, 67, "Question",
  Evaluatable->False],
Cell[33506, 1252, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[33583, 1256, 333, 13, 33, "Text",
  Evaluatable->False],
Cell[33919, 1271, 436, 11, 123, "Input"],
Cell[34358, 1284, 1867, 68, 90, "Text",
  Evaluatable->False],
Cell[36228, 1354, 81, 2, 27, "Input"],
Cell[36312, 1358, 125, 3, 47, "Input"],
Cell[36440, 1363, 272, 8, 52, "Text",
  Evaluatable->False],
Cell[36715, 1373, 91, 2, 27, "Input"],
Cell[36809, 1377, 164, 7, 33, "Text",
  Evaluatable->False],
Cell[36976, 1386, 77, 2, 27, "Input"],
Cell[37056, 1390, 248, 10, 33, "Text",
  Evaluatable->False],
Cell[37307, 1402, 149, 3, 48, "Input"],
Cell[37459, 1407, 815, 26, 71, "Text",
  Evaluatable->False],
Cell[38277, 1435, 139, 4, 43, "Input"],
Cell[38419, 1441, 200, 4, 52, "Text",
  Evaluatable->False],
Cell[38622, 1447, 112, 2, 27, "Input"],
Cell[38737, 1451, 347, 12, 67, "Question",
  Evaluatable->False],
Cell[39087, 1465, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[39164, 1469, 108, 2, 33, "Text",
  Evaluatable->False],
Cell[39275, 1473, 72, 2, 27, "Input"],
Cell[39350, 1477, 406, 11, 71, "Text",
  Evaluatable->False],
Cell[39759, 1490, 98, 2, 27, "Input"],
Cell[39860, 1494, 372, 13, 33, "Text",
  Evaluatable->False],
Cell[40235, 1509, 70, 2, 27, "Input"],
Cell[40308, 1513, 140, 3, 33, "Text",
  Evaluatable->False],
Cell[40451, 1518, 138, 3, 27, "Input"],
Cell[40592, 1523, 172, 4, 33, "Text",
  Evaluatable->False],
Cell[40767, 1529, 100, 2, 27, "Input"],
Cell[40870, 1533, 457, 17, 67, "Question",
  Evaluatable->False],
Cell[41330, 1552, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[41407, 1556, 95, 2, 33, "Text",
  Evaluatable->False],
Cell[41505, 1560, 158, 3, 43, "Input"],
Cell[41666, 1565, 184, 4, 43, "Input"],
Cell[41853, 1571, 419, 15, 48, "Question",
  Evaluatable->False],
Cell[42275, 1588, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[42386, 1595, 309, 12, 55, "Section",
  Evaluatable->False,
  CellTags->"a:9.15.9"],
Cell[42698, 1609, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[43043, 1620, 30, 0, 27, "Input"],
Cell[43076, 1622, 37, 0, 27, "Input"],
Cell[43116, 1624, 35, 0, 27, "Input"],
Cell[43154, 1626, 34, 0, 27, "Input"],
Cell[43191, 1628, 61, 1, 27, "Input"],
Cell[43255, 1631, 66, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

