(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40789,       1513]*)
(*NotebookOutlinePosition[     44061,       1618]*)
(*  CellTagsIndexPosition[     43705,       1603]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 10",
    FontSize->18],
  "\nDirect Products"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.10"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.11.10"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["10.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.12.10"],

Cell["\<\
To complete the last section of this lab, you should have completed \
the lab on isomorphisms (Group Lab 8).\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["10.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.13.10"],

Cell[TextData[{
  "This lab explores the direct product of two groups. First we define the \
concept of a direct product and how to determine its order. Next we determine \
the order of an element in a direct product. We also consider when a direct \
product might be cyclic, given that its factors are cyclic. Finally, we \
consider when ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  " groups are isomorphic to direct products of other ",
  Cell[BoxData[
      \(TraditionalForm\`U\)]],
  " groups."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["10.3 What is a direct product?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.14.10"],

Cell["\<\
In abstract algebra, when an object (such as a group) is being \
studied, there are a couple of natural questions that are often asked: (1) \
When does a subset still have the algebraic properties of the parent set? (2) \
Can we take two (or more) objects and combine them to build a new one with \
similar properties? (We pursue a third natural question in Group Lab \
12.)\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Since we have already spent some time looking at subgroups, we now \
consider the second question. Let\[CloseCurlyQuote]s consider two groups, ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  ", as defined below. First we read in code from the ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"],
  " packages."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G1 = U[10]\), 
    \(G2 = Z[4]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "How can we combine them to form a new group where both ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " can be viewed as \[OpenCurlyDoubleQuote]subgroups\[CloseCurlyDoubleQuote] \
in some sense? From linear algebra, we know what it means to view vectors as \
ordered pairs and then use component-wise addition, so perhaps we can \
implement a similar strategy."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["What we want to do is form all ordered pairs of the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  StyleBox[" where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" is obtained from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" is obtained from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  ".",
  StyleBox[
  " The set of all these ordered pairs can be given a group structure by \
considering the operation defined by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\ \((a, b)\) = \((x\ a, y\ b)\)\)]],
  StyleBox[
  ", where the operation in the first component on the right-hand side takes \
place in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" and in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " ",
  StyleBox["in the second component.",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" We call this group the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["direct product of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  ".",
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["We denote this direct product by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\[Cross]G\_2\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = DirectProduct[G1, G2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Here we see there are 16 elements. If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\( | G\_1\) | \) = n\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\( | G\_2\) | \) = m\)]],
  StyleBox[", what is the order of the direct product ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\[Cross]G\_2\)]],
  StyleBox["? Why?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s look at another direct product. "], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(H = DirectProduct[U[10], Z[2]]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
As we have seen in the past, studying the Cayley table of a group \
can reveal significant information. Study the following.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[H, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What observations can you make about the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  "? Can you \[OpenCurlyDoubleQuote]see\[CloseCurlyDoubleQuote] any \
subgroups? Can you identify the order of any elements? Is this Abelian? What \
other observations can you make?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["10.4 Order of an element in a direct product", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.15.10"],

Cell[TextData[{
  "We continue to use the same ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " as in section 10.3. (Evaluate the following only if you have changed your \
definition of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ".)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = DirectProduct[U[10], Z[4]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s pick a random element from ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(?RandomElement\)\n (*\ 
      if\ you\ are\ not\ sure\ how\ RandomElement\ works, \ try\ this\ *) 
      \)\)], "Input"],

Cell[BoxData[
    \(g = RandomElement[G, SelectFrom \[Rule] NonIdentity]\)], "Input",
  AspectRatioFixed->True],

Cell["What is the order of this element?", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfElement[G, g]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s determine the order of each component in its respective group. That is, \
we would like to know the order (in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[") of the first component of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and the order (in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  StyleBox[") of the second component of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ".",
  StyleBox[" In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", one uses ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g[\([k]\)]\)]],
  StyleBox[" to obtain the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox["th component of a list, so here we use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["g\[LeftDoubleBracket]1\[RightDoubleBracket]",
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["g\[LeftDoubleBracket]2\[RightDoubleBracket]",
    FontFamily->"Courier"],
  StyleBox[" to find the coordinates of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  StyleBox[" respectively.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfElement[{{G1, g\[LeftDoubleBracket]1\[RightDoubleBracket]}, {G2, 
          g\[LeftDoubleBracket]2\[RightDoubleBracket]}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Recall that the first number is the order of the first coordinate of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " in the group ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " and the second number is the order of the second coordinate of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " in the group ",
  Cell[BoxData[
      \(TraditionalForm\`\(G\_2 . \)\)]],
  " Let\[CloseCurlyQuote]s look at a table and see if we can come to any \
conclusions."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[g = RandomElement[G, SelectFrom \[Rule] NonIdentity]; {g, 
          OrderOfElement[G, g], 
          OrderOfElement[{{G1, First[g]}, {G2, Last[g]}}]}, {8}], 
      TableDepth \[Rule] 2, 
      TableHeadings 
        \[Rule] {None, {"\<g = {x, y}\>", "\<|g|\>", "\<{|x|, |y|}\n\>"}}, 
      TableSpacing \[Rule] {0.5, 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Evaluate the cell at least one more time. Make a conjecture about a \
relationship between the order of the element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g = {x, y}\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\[Cross]G\_2\)]],
  StyleBox[" and the orders ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\(| x\) | \)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\(| y\) | \)\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Change the groups ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  StyleBox[" to some other groups (use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Z",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["U",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Symmetric",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Dihedral",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or any other groups you might know).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    RowBox[{\(Clear[G1, \ G2]\)}], 
    RowBox[{\(G1 = \), "  ", 
      RowBox[{
        StyleBox["(*",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[\( < \(--\(-\ fill\)\)\ in\ your\ group\ here\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["*)",
          FontColor->RGBColor[0, 0, 1]]}]}]}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{\(G2 = \), "  ", 
      RowBox[{
        StyleBox["(*",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[\( < \(--\(-\ fill\)\)\ in\ your\ group\ here\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["*)",
          FontColor->RGBColor[0, 0, 1]]}]}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = DirectProduct[G1, G2]; \nElements[G]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[g = RandomElement[G, SelectFrom \[Rule] NonIdentity]; {g, 
          OrderOfElement[G, g], 
          OrderOfElement[{{G1, First[g]}, {G2, Last[g]}}]}, {5}], 
      TableDepth\  \[Rule] \ 2, 
      TableHeadings 
        \[Rule] {None, {"\<g = {x, y}\>", "\<|g|\>", "\<{|x|, |y|}\n\>"}}]
      \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Test your conjecture from question 3. Does it still hold? What are your \
groups ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  StyleBox[
  " in your direct product? Try this again by changing groups (again listing \
your component groups). State your final conjecture. How might you prove it?",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["10.5 When is a direct product of cyclic groups cyclic?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.16.10"],

Cell["Consider the following two groups and their direct product.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G1 = Z[6]\), 
    \(G2 = Z[4]\), 
    \(G = DirectProduct[G1, G2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We know that both ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " are cyclic; what about ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(CyclicQ[{G1, G2, G}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "In this case, we see that ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is not cyclic. Let\[CloseCurlyQuote]s make a table of some random indices \
for ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_m\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " and then consider the cyclicity of the direct product ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_m\[Cross]\[DoubleStruckCapitalZ]\_n\)]],
  ". (The following is already evaluated; just open up the cell.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(numberToSample = 6; \)\), 
    \(TableForm[
      Table[n = Random[Integer, {2, 10}]; 
        m = Random[Integer, {2, 11}]; {m, n, 
          CyclicQ[DirectProduct[Z[m], Z[n]]]}, {numberToSample}], 
      TableHeadings 
        \[Rule] {
          None, {"\<m\>", "\<n\>", 
            \*"\"\<\!\(\[DoubleStruckCapitalZ]\_m\) \[Cross] \!\(\
\[DoubleStruckCapitalZ]\_n\) cyclic?\\n\>\""}}]\)}], "Input",
  CellDingbat->"\[WatchIcon]",
  AspectRatioFixed->True],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"m\"\>", "\<\"n\"\>", 
            \("\!\(\[DoubleStruckCapitalZ]\_m\) \[Cross] \!\(\
\[DoubleStruckCapitalZ]\_n\) cyclic?\n"\)},
          {"7", "10", "True"},
          {"2", "2", "False"},
          {"6", "3", "False"},
          {"7", "3", "True"},
          {"10", "3", "True"},
          {"8", "3", "True"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableHeadings -> {None, {"m", "n", 
        "\!\(\[DoubleStruckCapitalZ]\_m\) \[Cross] \
\!\(\[DoubleStruckCapitalZ]\_n\) cyclic?\n"}}]&)]], "Output",
  Editable->False,
  Deletable->False]
}, Closed]],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". By either repeating the preceding code or substituting values for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  " below, try enough examples until you can make a conjecture about a \
relationship between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" that will guarantee that the direct product ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_m\[Cross]\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" is cyclic.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(m = 7\), 
    \(n = 8\), 
    \(CyclicQ[DirectProduct[Z[m], Z[n]]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Give a reasonable explanation why your conjecture makes sense.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["What are the generators of a cyclic direct product? ", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.16.11.10"],

Cell[TextData[{
  StyleBox["One of the examples you may have tested, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_4\[Cross]\[DoubleStruckCapitalZ]\_5\)]],
  StyleBox[
  ", turns out to be cyclic. A natural question to ask concerns the \
generators of this cyclic group. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Before",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " you evaluate the following cell, think about what the list of generators \
might be.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?CyclicGenerators\)\)], "Input"],

Cell[BoxData[
    \(CyclicGenerators[DirectProduct[Z[4], Z[5]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is another example of indices ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" for which ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_m\[Cross]\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" is cyclic? Without using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", determine the generators for this group. Test yourself using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Fill in values for ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " for which the direct product is cyclic."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(m = 4\), 
    \(n = 5\), 
    \(CyclicGenerators[DirectProduct[Z[m], Z[n]]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". When is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_m\[Cross]\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_\(m  n\)\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "10.6 Isomorphisms among ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " groups"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.17.10"],

Cell[TextData[{
  "Consider the following, where we form the groups ",
  Cell[BoxData[
      \(TraditionalForm\`U\_m\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`U\_\(m  n\)\)]],
  " and the direct product ",
  Cell[BoxData[
      \(TraditionalForm\`U\_m\[Cross]U\_n\)]],
  ". "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(m = 5; \)\), 
    \(\(n = 4; \)\), 
    \(G1 = U[m]\), 
    \(G2 = U[n]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = DirectProduct[G1, G2]\)], "Input",
  AspectRatioFixed->True],

Cell["U[m * n]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that ",
  Cell[BoxData[
      \(TraditionalForm\`U\_\(m  n\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`U\_m\[Cross]U\_n\)]],
  " have the same number of elements."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Length[Elements[U[m\ *\ n]]] == 
      Length[Elements[DirectProduct[U[m], U[n]]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Suppose we define a function from ",
  Cell[BoxData[
      \(TraditionalForm\`U\_\(m  n\)\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`U\_m\[Cross]U\_n\)]],
  ". To do so, we need to make sure that the image of any element lands in ",
  Cell[BoxData[
      \(TraditionalForm\`U\_m\[Cross]U\_n\)]],
  ", which means that the first component must be in ",
  Cell[BoxData[
      \(TraditionalForm\`U\_m\)]],
  " and the second in ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  ". The following function is one way to accomplish this."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f]\), 
    \(f[x_] := {Mod[x, m], Mod[x, n]}\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "What is the image of this function on ",
  Cell[BoxData[
      \(TraditionalForm\`U\_\(m\ n\)\)]],
  "?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[f, \ Elements[U[m*n]]]\)], "Input"],

Cell[TextData[{
  "How does this compare to the elements of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_m\[Cross]U\_n\)]],
  "?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SameSetQ[%, \ Elements[DirectProduct[U[m], \ U[n]]]]\)], "Input"],

Cell[TextData[{
  StyleBox[
  "Thus, we see that we have the same set of elements. Could this possibly be \
an isomorphism? First, let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s set up a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(func = FormMorphoid[f, U[m\ *\ n], DirectProduct[U[m], U[n]]]\)], 
  "Input",
  AspectRatioFixed->True],

Cell["\<\
Since we see that the map is onto (and one-to-one), what we really \
need to do is check to see if it is a morphism.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[func, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Indeed. We have an isomorphism. Is there anything special about the ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " we chose? Let\[CloseCurlyQuote]s try some random values and see what \
happens."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(numberToSample = 6; \nOff[Morphoid::dff]; \n
    TableForm[
      Table[m = Random[Integer, {2, 10}]; n = Random[Integer, {2, 10}]; 
        G\_1 = U[m]; G\_2 = U[n]; G = DirectProduct[G\_1, G\_2]; H = U[m\ n]; 
        Clear[f]; 
        f[x_] := {Mod[x, m], Mod[x, n]}; {m, n, 
          IsomorphismQ[FormMorphoid[f, U[m\ n], DirectProduct[U[m], U[n]]], 
            Cautious \[Rule] True]}, {numberToSample}], 
      TableHeadings \[Rule] {None, {"\<m\>", "\<n\>", "\<isomorphic?\n\>"}}]
      \), 
    \(\(On[Morphoid::dff]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". By either repeating the preceding code or substituting values for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[
  " below, try enough examples until you can make a conjecture about a \
relationship between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" that will guarantee that the direct product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_m\)]],
  StyleBox[" is isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_\(m\ n\)\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = \n\(m = \nClear[f]\); \n\(f[x_] := {Mod[x, m], Mod[x, n]}; \)\), 
    \(IsomorphismQ[FormMorphoid[f, U[m\ n], DirectProduct[U[m], U[n]]]]\)}], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_30\)]],
  StyleBox[" isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_2\[Cross]U\_3\[Cross]U\_5\)]],
  StyleBox[
  "? Why or why not? If so, set up an isomorphism; if not, explain why not.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_30\)]],
  StyleBox[" isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_2\[Cross]\[DoubleStruckCapitalZ]\_3
          \[Cross]\[DoubleStruckCapitalZ]\_5\)]],
  StyleBox[
  "? Why or why not? If so, set up an isomorphism; if not, explain why not.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_\(m\ n\)\)]],
  StyleBox[" isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_m\[Cross]\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[
  "? Set up an isomorphism when it is and explain why not when it is not.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "10.7 ",
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.18.10"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?U", "Input",
  AspectRatioFixed->True],

Cell["?Z", "Input",
  AspectRatioFixed->True],

Cell["?DirectProduct", "Input",
  AspectRatioFixed->True],

Cell["?CayleyTable", "Input",
  AspectRatioFixed->True],

Cell["?RandomElement", "Input",
  AspectRatioFixed->True],

Cell["?SelectFrom", "Input",
  AspectRatioFixed->True],

Cell["?NonIdentity", "Input",
  AspectRatioFixed->True],

Cell["?OrderOfElement", "Input",
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell["?CyclicQ", "Input",
  AspectRatioFixed->True],

Cell["?CyclicGenerators", "Input",
  AspectRatioFixed->True],

Cell["?Length", "Input",
  AspectRatioFixed->True],

Cell["?SameSetQ", "Input",
  AspectRatioFixed->True],

Cell["?FormMorphoid", "Input",
  AspectRatioFixed->True],

Cell["?MorphismQ", "Input",
  AspectRatioFixed->True],

Cell["?IsomorphismQ", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{627, 433},
WindowMargins->{{3, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, 2},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Lab 10 Direct products", FontSlant -> "Italic"], "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:10.10"->{
    Cell[2382, 76, 167, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:10.10"]},
  "a:10.11.10"->{
    Cell[2574, 87, 327, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:10.11.10"]},
  "a:10.12.10"->{
    Cell[7101, 240, 111, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:10.12.10"]},
  "a:10.13.10"->{
    Cell[7432, 255, 103, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:10.13.10"]},
  "a:10.14.10"->{
    Cell[8142, 279, 123, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:10.14.10"]},
  "a:10.15.10"->{
    Cell[14262, 499, 137, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:10.15.10"]},
  "a:10.16.10"->{
    Cell[23126, 823, 147, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:10.16.10"]},
  "a:10.16.11.10"->{
    Cell[27520, 986, 154, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:10.16.11.10"]},
  "a:10.17.10"->{
    Cell[30902, 1118, 197, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:10.17.10"]},
  "a:10.18.10"->{
    Cell[39200, 1438, 312, 12, 55, "Section",
      Evaluatable->False,
      CellTags->"a:10.18.10"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:10.10", 42494, 1559},
  {"a:10.11.10", 42607, 1563},
  {"a:10.12.10", 42726, 1567},
  {"a:10.13.10", 42845, 1571},
  {"a:10.14.10", 42964, 1575},
  {"a:10.15.10", 43083, 1579},
  {"a:10.16.10", 43203, 1583},
  {"a:10.16.11.10", 43326, 1587},
  {"a:10.17.10", 43455, 1591},
  {"a:10.18.10", 43576, 1595}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 167, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:10.10"],

Cell[CellGroupData[{
Cell[2574, 87, 327, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:10.11.10"],
Cell[2904, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3781, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5177, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5355, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6003, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6721, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7101, 240, 111, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:10.12.10"],
Cell[7215, 245, 180, 5, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7432, 255, 103, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:10.13.10"],
Cell[7538, 260, 567, 14, 90, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8142, 279, 123, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:10.14.10"],
Cell[8268, 284, 446, 9, 90, "Text",
  Evaluatable->False],
Cell[8717, 295, 467, 14, 71, "Text",
  Evaluatable->False],
Cell[9187, 311, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[9362, 317, 91, 3, 43, "Input"],
Cell[9456, 322, 511, 13, 90, "Text",
  Evaluatable->False],
Cell[9970, 337, 2157, 78, 109, "Text",
  Evaluatable->False],
Cell[12130, 417, 84, 2, 27, "Input"],
Cell[12217, 421, 738, 25, 67, "Question",
  Evaluatable->False],
Cell[12958, 448, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[13035, 452, 130, 3, 33, "Text",
  Evaluatable->False],
Cell[13168, 457, 89, 2, 27, "Input"],
Cell[13260, 461, 196, 5, 52, "Text",
  Evaluatable->False],
Cell[13459, 468, 100, 2, 27, "Input"],
Cell[13562, 472, 586, 18, 67, "Question",
  Evaluatable->False],
Cell[14151, 492, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[14262, 499, 137, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:10.15.10"],
Cell[14402, 504, 309, 11, 52, "Text",
  Evaluatable->False],
Cell[14714, 517, 89, 2, 27, "Input"],
Cell[14806, 521, 185, 7, 33, "Text",
  Evaluatable->False],
Cell[14994, 530, 144, 3, 43, "Input"],
Cell[15141, 535, 111, 2, 27, "Input"],
Cell[15255, 539, 98, 2, 33, "Text",
  Evaluatable->False],
Cell[15356, 543, 79, 2, 27, "Input"],
Cell[15438, 547, 2109, 75, 90, "Text",
  Evaluatable->False],
Cell[17550, 624, 188, 3, 27, "Input"],
Cell[17741, 629, 554, 17, 71, "Text",
  Evaluatable->False],
Cell[18298, 648, 403, 9, 107, "Input"],
Cell[18704, 659, 901, 32, 67, "Question",
  Evaluatable->False],
Cell[19608, 693, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[19685, 697, 1144, 44, 52, "Text",
  Evaluatable->False],
Cell[20832, 743, 501, 14, 43, "Input"],
Cell[21336, 759, 463, 13, 27, "Input"],
Cell[21802, 774, 99, 2, 43, "Input"],
Cell[21904, 778, 376, 9, 91, "Input"],
Cell[22283, 789, 729, 25, 86, "Question",
  Evaluatable->False],
Cell[23015, 816, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[23126, 823, 147, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:10.16.10"],
Cell[23276, 828, 123, 2, 33, "Text",
  Evaluatable->False],
Cell[23402, 832, 126, 4, 59, "Input"],
Cell[23531, 838, 296, 13, 33, "Text",
  Evaluatable->False],
Cell[23830, 853, 79, 2, 27, "Input"],
Cell[23912, 857, 641, 18, 71, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[24578, 879, 483, 12, 91, "Input"],
Cell[25064, 893, 705, 20, 137, "Output"]
}, Closed]],
Cell[25784, 916, 1117, 39, 84, "Question",
  Evaluatable->False],
Cell[26904, 957, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[26981, 961, 127, 4, 59, "Input"],
Cell[27111, 967, 307, 11, 48, "Question",
  Evaluatable->False],
Cell[27421, 980, 74, 2, 47, "Answer",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[27520, 986, 154, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:10.16.11.10"],
Cell[27677, 991, 723, 23, 71, "Text",
  Evaluatable->False],
Cell[28403, 1016, 54, 1, 27, "Input"],
Cell[28460, 1019, 102, 2, 27, "Input"],
Cell[28565, 1023, 1141, 40, 67, "Question",
  Evaluatable->False],
Cell[29709, 1065, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[29786, 1069, 252, 10, 33, "Text",
  Evaluatable->False],
Cell[30041, 1081, 136, 4, 59, "Input"],
Cell[30180, 1087, 596, 21, 48, "Question",
  Evaluatable->False],
Cell[30779, 1110, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[30902, 1118, 197, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:10.17.10"],
Cell[31102, 1128, 406, 16, 33, "Text",
  Evaluatable->False],
Cell[31511, 1146, 134, 5, 75, "Input"],
Cell[31648, 1153, 84, 2, 27, "Input"],
Cell[31735, 1157, 51, 1, 27, "Input"],
Cell[31789, 1160, 262, 10, 33, "Text",
  Evaluatable->False],
Cell[32054, 1172, 141, 3, 43, "Input"],
Cell[32198, 1177, 630, 19, 71, "Text",
  Evaluatable->False],
Cell[32831, 1198, 111, 3, 43, "Input"],
Cell[32945, 1203, 183, 7, 33, "Text",
  Evaluatable->False],
Cell[33131, 1212, 59, 1, 27, "Input"],
Cell[33193, 1215, 191, 7, 33, "Text",
  Evaluatable->False],
Cell[33387, 1224, 85, 1, 27, "Input"],
Cell[33475, 1227, 523, 19, 52, "Text",
  Evaluatable->False],
Cell[34001, 1248, 123, 3, 27, "Input"],
Cell[34127, 1253, 188, 5, 52, "Text",
  Evaluatable->False],
Cell[34318, 1260, 95, 2, 27, "Input"],
Cell[34416, 1264, 341, 11, 52, "Text",
  Evaluatable->False],
Cell[34760, 1277, 592, 12, 171, "Input"],
Cell[35355, 1291, 1315, 48, 86, "Question",
  Evaluatable->False],
Cell[36673, 1341, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[36750, 1345, 205, 4, 91, "Input"],
Cell[36958, 1351, 599, 21, 67, "Question",
  Evaluatable->False],
Cell[37560, 1374, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[37637, 1378, 705, 23, 67, "Question",
  Evaluatable->False],
Cell[38345, 1403, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[38422, 1407, 664, 22, 67, "Question",
  Evaluatable->False],
Cell[39089, 1431, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[39200, 1438, 312, 12, 55, "Section",
  Evaluatable->False,
  CellTags->"a:10.18.10"],
Cell[39515, 1452, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[39860, 1463, 45, 1, 27, "Input"],
Cell[39908, 1466, 45, 1, 27, "Input"],
Cell[39956, 1469, 57, 1, 27, "Input"],
Cell[40016, 1472, 55, 1, 27, "Input"],
Cell[40074, 1475, 57, 1, 27, "Input"],
Cell[40134, 1478, 54, 1, 27, "Input"],
Cell[40191, 1481, 55, 1, 27, "Input"],
Cell[40249, 1484, 58, 1, 27, "Input"],
Cell[40310, 1487, 52, 1, 27, "Input"],
Cell[40365, 1490, 51, 1, 27, "Input"],
Cell[40419, 1493, 60, 1, 27, "Input"],
Cell[40482, 1496, 50, 1, 27, "Input"],
Cell[40535, 1499, 52, 1, 27, "Input"],
Cell[40590, 1502, 56, 1, 27, "Input"],
Cell[40649, 1505, 53, 1, 27, "Input"],
Cell[40705, 1508, 56, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

