(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     44879,       1695]*)
(*NotebookOutlinePosition[     47674,       1785]*)
(*  CellTagsIndexPosition[     47414,       1773]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 11",
    FontSize->18],
  "\nCosets"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.11"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["11.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.12.11"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["11.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.13.11"],

Cell[TextData[{
  "This lab is self-contained. No prior labs need to be completed to attempt \
this one, but familiarity with the basic groups such as ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`D\_n\)]],
  " is helpful."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["11.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.14.11"],

Cell["\<\
This lab explores the notion of cosets. We will look at how cosets \
are determined, the different types of cosets, and some of the properties of \
cosets.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["11.3 Cosets, left and right", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.15.11"],

Cell[TextData[{
  StyleBox["Suppose we start with some group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", say the dihedral group of order 8, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  StyleBox[". First we read in the necessary ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" code.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Dihedral[4]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now consider a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", say ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H = {1, Rot\^2}\)]],
  StyleBox[
  ", consisting of the identity and the 180\[Degree] rotation (when we view ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  StyleBox[" as the symmetries of the square).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(H = {1, Rot\^2}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We would like to take another element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and multiply it by all the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[". Suppose we choose one of the reflections, say ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". Before multiplying, we need to first choose on which side to multiply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", since this group is not Abelian. We also need to find a way of \
calculating this product in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If we have a function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" of two variables (such as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(f(x, y) = x\^2 + y\^2)\)\)]],
  StyleBox[
  " and we want to hold one variable fixed and let the other roam over some \
fixed set, we can use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Map",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function as follows.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f, x, y]\), 
    \(f[x_, y_] := x\^2 + y\^2\), 
    \(Map[f[2, \ #]&, \ {\(-2\), \ \(-1\), \ 0, \ 1, \ 2}]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The expression ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["f[2, #]&",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" indicates that all the elements in the list ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{\(-2\), \(-1\), 0, 1, 2}\)]],
  StyleBox[" should, one at a time, be placed in for the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["#",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and then ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[
  " can be properly evaluated with the two arguments (the first always being \
2, in this example). Think about what the following will return; don",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t evaluate it until you have made some (educated) guess.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[f[#, \ 1]&, \ {\(-2\), \ \(-1\), \ 0, \ 1, \ 2}]\)], "Input"],

Cell[TextData[{
  StyleBox["We will use this mapping principle to calculate our product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" times the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[". First we need the group",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s operation, which is a function of two variables. The following allows us \
to use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["op",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " as a short name for the operation. (The semicolon suppresses the actual \
definition, since its details are not important.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(op\  = \ Operation[G]; 
    \)\n (*\ the\ ; \ suppresses\ output, \ so\ do\ not\ expect\ any\ *) 
      \)\)], "Input"],

Cell[TextData[{
  StyleBox["Now we will use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["op",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to do the calculations, placing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" on the left (as the first operand).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[op[Ref, \ #]&, \ H]\)], "Input"],

Cell[TextData[{
  StyleBox["This result is called the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["left coset of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["containing ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " (where ",
  Cell[BoxData[
      \(TraditionalForm\`H = {1, Rot\^2}\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`g = Ref\)]],
  ")",
  StyleBox[". In general, we denote the left coset of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" containing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" by the notation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  StyleBox[". This coset is the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{g*h | h \[Element] H}\)]],
  StyleBox[". We define the right coset of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" containing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in a similar fashion: ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\ g = {h*g | h \[Element] H}\)]],
  StyleBox[
  ". (Note that when a group is written additively, we denote these cosets by \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g + H\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H + g\)]],
  StyleBox[".) We can calculate the right coset in a similar fashion.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Map[op[#, \ Ref]&, \ H]\n (*\ note\ that\ Ref\ is\ now\ the\ second, 
      \ or\ right, \ operand\ *) \)\)], "Input"],

Cell[TextData[{
  StyleBox[
  "Observe that, in this case, the right coset and the left coset are the \
same. Suppose we use a new element, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g = Rot\^2\[NonBreakingSpace]Ref\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["A technical ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" note might be useful here, since in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" we enter ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`Rot\^2\[NonBreakingSpace]Ref\)]],
  StyleBox[" as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rot^2\[NonBreakingSpace]**\[NonBreakingSpace]Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", multiplication is denoted either by juxtaposition, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`6\ \ 7\)]],
  ",",
  StyleBox[" or by using the asterisk, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`6*7\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(6\ 7\), 
    \(6\ *\ 7\)}], "Input"],

Cell[BoxData[{
    \(Clear[g, \ h]\), 
    \(g\ *\ h\), 
    \(h\ *\ g\)}], "Input"],

Cell[TextData[{
  StyleBox["Note that both ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g*h\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h*g\)]],
  StyleBox[" return ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ h\)]],
  StyleBox[". In other words, by default ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" assumes that the multiplication ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`*\)]],
  StyleBox[
  " is commutative and the elements are returned in some canonical order \
(alphabetically in this case). To force a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["noncommutative",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" multiplication we use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`**\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(g**h\), 
    \(h**g\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s try calculating the left coset of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" containing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`Rot\^2\ Ref\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[op[Rot\^2**Ref, #1]&, H]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that this is the same result (as sets they don\[CloseCurlyQuote]t \
need to be in the same order) as the left coset of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " containing Ref."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Calculate both the left and right cosets of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" containing Rot. Are they the same?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Since this is a somewhat awkward way of calculating cosets (though it \
conveys exactly what is happening), let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s use another method. We have functions ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["LeftCoset",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RightCoset",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" that give us what we want.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(LeftCoset[G, H, Rot\^2**Ref]\), 
    \(RightCoset[G, H, Rot\^2**Ref]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?LeftCoset\)\)], "Input"],

Cell[TextData[{
  StyleBox["Suppose we consider another group, say ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  StyleBox[", and let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H = {0, 2, 4, 6}\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G = Z[8]\), 
    \(H = {0, 2, 4, 6}\), 
    \(SubgroupQ[H, G]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["(",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SubgroupQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is a function that one can use to test to see if a set is truly a \
subgroup or not. We want to make sure that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" is a subgroup before we try making cosets.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s try some cosets.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(LeftCoset[G, H, 0]\), 
    \(LeftCoset[G, H, 1]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For a little more information, try the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Textual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" mode.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(LeftCoset[G, H, 1, Mode \[Rule] Textual]\)], "Input",
  AspectRatioFixed->True],

Cell["Here is the last coset from another perspective:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(LeftCoset[G, H, 1, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["To get all the cosets, we can use our ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Map",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function and map the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["LeftCoset",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function across the whole set of elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[LeftCoset[G, \ H, \ #]&, \ Elements[G]]\)], "Input"],

Cell["\<\
This can be understood better, perhaps, by viewing both the coset \
and the element that generates the coset; try the following.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[{#, \ LeftCoset[G, H, #]}&, \ Elements[G]] // ColumnForm\)], "Input"],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What observations can you make about these cosets? If you can",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "t think of anything, try the following (but try to think of something \
first).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[{#, \ Sort[LeftCoset[G, \ H, \ #]]}&, \ Elements[G]] // ColumnForm
      \)], "Input"],

Cell[TextData[{
  StyleBox["Now compare the left cosets and the right cosets of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H = {0, 2, 4, 6}\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_8\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Map[{#, \ LeftCoset[G, \ H, \ #], \ RightCoset[G, \ H, \ #]}&, \ 
        Elements[G]], \ 
      TableHeadings\  \[Rule] 
        \ {None, \ {"\<g\>", \ "\<g+H\>", \ "\<H+g\n\>"}}, \ 
      TableDepth\  \[Rule] \ 2]\)], "Input"],

Cell[TextData[{
  StyleBox[
  "In each row, the first element is the element that we are multiplying by \
(adding to, in this case) the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[". (This element is usually called a",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" coset representative.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ") The second item is the left coset and the third is the corresponding \
right coset.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What observations can you make about the relationship between these left \
and right cosets?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Lest you jump to a false conclusion, let\[CloseCurlyQuote]s consider another \
example."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G = Symmetric[3]\), 
    \(H = {{1, 2, 3}, {1, 3, 2}}\), 
    \(SubgroupQ[H, G]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now that we know that ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " is a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", we can consider the various left and right cosets."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Map[{#, \ LeftCoset[G, \ H, \ #], \ RightCoset[G, \ H, \ #]}&, \ 
        Elements[G]], \ 
      TableHeadings\  \[Rule] 
        \ {None, \ {"\<g\>", \ "\<gH\>", \ "\<Hg\n\>"}}, \ 
      TableDepth\  \[Rule] \ 2]\)], "Input"],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What observations can you make about the relationship between these left \
and right cosets?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["11.4 Properties of cosets", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.16.11"],

Cell[TextData[
"Let\[CloseCurlyQuote]s look for some common properties among the three \
collections of cosets is section 11.3."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G\  = \ Dihedral[4]; \nH\  = \ {1, \ Rot^2}; \n
    TableForm[
      Map[{#, \ LeftCoset[G, \ H, \ #], \ RightCoset[G, \ H, \ #]}&, \ 
        Elements[G]], \ 
      TableHeadings\  \[Rule] 
        \ {None, \ {"\<g\>", \ "\<gH\>", \ "\<Hg\n\>"}}, \ 
      TableDepth\  \[Rule] \ 2]\)], "Input"],

Cell[BoxData[
    \(G\  = \ Z[8]; \nH\  = \ {0, \ 2, \ 4, \ 6}; \n
    TableForm[
      Map[{#, \ LeftCoset[G, \ H, \ #], \ RightCoset[G, \ H, \ #]}&, \ 
        Elements[G]], \ 
      TableHeadings\  \[Rule] 
        \ {None, \ {"\<g\>", \ "\<gH\>", \ "\<Hg\n\>"}}, \ 
      TableDepth\  \[Rule] \ 2]\)], "Input"],

Cell[BoxData[
    \(G\  = \ Symmetric[3]; \nH\  = \ {{1, \ 2, \ 3}, \ {1, \ 3, \ 2}}; \n
    TableForm[
      Map[{#, \ LeftCoset[G, \ H, \ #], \ RightCoset[G, \ H, \ #]}&, \ 
        Elements[G]], \ 
      TableHeadings\  \[Rule] 
        \ {None, \ {"\<g\>", \ "\<gH\>", \ "\<Hg\n\>"}}, \ 
      TableDepth\  \[Rule] \ 2]\)], "Input"],

Cell[TextData[{
  "For each of the following questions, consider the preceding examples and \
see if you can provide an answer. (Note that in the following questions we \
use ",
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`H\ g\)]],
  " generically, independent of whether the group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " writes the cosets additively or multiplicatively.) "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Recall that when we talk about the left (or right) coset of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" containing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[", we call the element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" the coset representative of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  StyleBox[" (or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\ g\)]],
  StyleBox["). Does it appear that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" is one of the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\ g\)]],
  StyleBox["? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". As you look at the cosets above, when is it the case that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\ g\)]],
  StyleBox[" actually is the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox["? Why is this the case?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Pick any two elements ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[". What can you say about the two cosets ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\ H\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\ H\)]],
  StyleBox[
  " (or, for that matter, the corresponding right cosets)? Justify your \
answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". How many (different) cosets are there for a given group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and subgroup ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox["? Why is this the case?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Although there is only limited evidence (you could produce more, \
however), what can you say about when the left coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  StyleBox[" might be equal to the right coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\ g\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". When is the left coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\ H\)]],
  StyleBox[" (or right coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\ g\)]],
  StyleBox[") a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox["? Are there any conditions that guarantee it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s consider two more examples of cosets. Instead of using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Map",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function to get cosets, we can use the functions ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["LeftCosets",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RightCosets",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?LeftCosets\)\)], "Input"],

Cell[BoxData[{
    \(\(G = U[35]; \)\), 
    \(\(H = {4, 16, 29, 11, 9, 1}; \)\), 
    \(SubgroupQ[H, G]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(LeftCosets[G, H]\), 
    \(RightCosets[G, H]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(G = Z[35]; \)\), 
    \(\(H = {5, 10, 15, 20, 25, 30, 0}; \)\), 
    \(SubgroupQ[H, G]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(LeftCosets[G, H]\), 
    \(RightCosets[G, H]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". For both of the preceding groups, count the number of cosets (either \
left or right), and calculate the orders of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[". Now offer a conjecture.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`H = 2\ \[DoubleStruckCapitalZ]\)]],
  ", the even integers. Verify that ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " is a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ". Describe the coset ",
  Cell[BoxData[
      \(TraditionalForm\`3 + H\)]],
  "."
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`H = 5\ \[DoubleStruckCapitalZ]\)]],
  ", the multiples of 5. Suppose ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " are the scores of two opponents playing table tennis. There is a change \
of service whenever the sum of the scores ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " is a multiple of 5 (and so in ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "). Each score belongs to one of the following cosets: ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`1 + H\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`2 + H\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`3 + H\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`4 + H\)]],
  ". (Why?) Is there any relationship between the coset to which ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " belongs and the one to which ",
  Cell[BoxData[
      \(TraditionalForm\`\(-y\)\)]],
  " belongs at the time of the change of service? Can you give a reasonable \
explanation for it?"
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = U\_5\[Cross]\[DoubleStruckCapitalZ]\_4\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`H = {{2, 2}, {4, 0}, {3, 2}, {1, 0}}\)]],
  " is a subgroup. Determine the other left cosets by hand. See if you can \
use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to confirm your answer."
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "11.5 ",
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.17.11"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Dihedral", "Input",
  AspectRatioFixed->True],

Cell["?Map", "Input",
  AspectRatioFixed->True],

Cell["?Operation", "Input",
  AspectRatioFixed->True],

Cell["?NonCommutativeMultiply", "Input",
  AspectRatioFixed->True],

Cell["?LeftCoset", "Input",
  AspectRatioFixed->True],

Cell["?RightCoset", "Input",
  AspectRatioFixed->True],

Cell["?SubgroupQ", "Input",
  AspectRatioFixed->True],

Cell["?Textual", "Input",
  AspectRatioFixed->True],

Cell["?Visual", "Input",
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell["?Symmetric", "Input",
  AspectRatioFixed->True],

Cell["?LeftCosets", "Input",
  AspectRatioFixed->True],

Cell["?RightCosets", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{627, 430},
WindowMargins->{{6, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{1, 2},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Lab 11 Cosets", FontSlant -> "Italic"], "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:11.11"->{
    Cell[2382, 76, 158, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:11.11"]},
  "a:11.12.11"->{
    Cell[2565, 87, 327, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:11.12.11"]},
  "a:11.13.11"->{
    Cell[7092, 240, 111, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.13.11"]},
  "a:11.14.11"->{
    Cell[7667, 264, 103, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.14.11"]},
  "a:11.15.11"->{
    Cell[8037, 280, 120, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.15.11"]},
  "a:11.16.11"->{
    Cell[30966, 1151, 118, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:11.16.11"]},
  "a:11.17.11"->{
    Cell[43462, 1629, 312, 12, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.17.11"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:11.11", 46575, 1741},
  {"a:11.12.11", 46688, 1745},
  {"a:11.13.11", 46807, 1749},
  {"a:11.14.11", 46926, 1753},
  {"a:11.15.11", 47045, 1757},
  {"a:11.16.11", 47164, 1761},
  {"a:11.17.11", 47285, 1765}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 158, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:11.11"],

Cell[CellGroupData[{
Cell[2565, 87, 327, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:11.12.11"],
Cell[2895, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3772, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5168, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5346, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[5994, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6712, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7092, 240, 111, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.13.11"],
Cell[7206, 245, 424, 14, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7667, 264, 103, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.14.11"],
Cell[7773, 269, 227, 6, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8037, 280, 120, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.15.11"],
Cell[8160, 285, 658, 23, 52, "Text",
  Evaluatable->False],
Cell[8821, 310, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[8996, 316, 74, 2, 27, "Input"],
Cell[9073, 320, 655, 23, 52, "Text",
  Evaluatable->False],
Cell[9731, 345, 74, 2, 31, "Input"],
Cell[9808, 349, 1301, 45, 90, "Text",
  Evaluatable->False],
Cell[11112, 396, 739, 25, 52, "Text",
  Evaluatable->False],
Cell[11854, 423, 173, 4, 61, "Input"],
Cell[12030, 429, 1143, 36, 90, "Text",
  Evaluatable->False],
Cell[13176, 467, 85, 1, 27, "Input"],
Cell[13264, 470, 1006, 33, 90, "Text",
  Evaluatable->False],
Cell[14273, 505, 143, 3, 43, "Input"],
Cell[14419, 510, 558, 20, 33, "Text",
  Evaluatable->False],
Cell[14980, 532, 56, 1, 27, "Input"],
Cell[15039, 535, 2620, 97, 109, "Text",
  Evaluatable->False],
Cell[17662, 634, 140, 2, 43, "Input"],
Cell[17805, 638, 402, 13, 52, "Text",
  Evaluatable->False],
Cell[18210, 653, 1407, 50, 71, "Text",
  Evaluatable->False],
Cell[19620, 705, 57, 2, 43, "Input"],
Cell[19680, 709, 84, 3, 59, "Input"],
Cell[19767, 714, 1309, 47, 71, "Text",
  Evaluatable->False],
Cell[21079, 763, 80, 3, 43, "Input"],
Cell[21162, 768, 652, 25, 33, "Text",
  Evaluatable->False],
Cell[21817, 795, 87, 2, 31, "Input"],
Cell[21907, 799, 332, 11, 52, "Text",
  Evaluatable->False],
Cell[22242, 812, 557, 20, 48, "Question",
  Evaluatable->False],
Cell[22802, 834, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[22879, 838, 765, 26, 71, "Text",
  Evaluatable->False],
Cell[23647, 866, 129, 3, 51, "Input"],
Cell[23779, 871, 47, 1, 27, "Input"],
Cell[23829, 874, 465, 16, 33, "Text",
  Evaluatable->False],
Cell[24297, 892, 122, 4, 59, "Input"],
Cell[24422, 898, 590, 20, 52, "Text",
  Evaluatable->False],
Cell[25015, 920, 255, 10, 33, "Text",
  Evaluatable->False],
Cell[25273, 932, 108, 3, 43, "Input"],
Cell[25384, 937, 357, 13, 33, "Text",
  Evaluatable->False],
Cell[25744, 952, 99, 2, 27, "Input"],
Cell[25846, 956, 112, 2, 33, "Text",
  Evaluatable->False],
Cell[25961, 960, 98, 2, 27, "Input"],
Cell[26062, 964, 703, 25, 52, "Text",
  Evaluatable->False],
Cell[26768, 991, 76, 1, 27, "Input"],
Cell[26847, 994, 200, 5, 52, "Text",
  Evaluatable->False],
Cell[27050, 1001, 93, 1, 27, "Input"],
Cell[27146, 1004, 477, 16, 67, "Question",
  Evaluatable->False],
Cell[27626, 1022, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[27703, 1026, 110, 2, 27, "Input"],
Cell[27816, 1030, 475, 16, 33, "Text",
  Evaluatable->False],
Cell[28294, 1048, 265, 6, 59, "Input"],
Cell[28562, 1056, 676, 22, 71, "Text",
  Evaluatable->False],
Cell[29241, 1080, 337, 12, 48, "Question",
  Evaluatable->False],
Cell[29581, 1094, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[29658, 1098, 162, 4, 33, "Text",
  Evaluatable->False],
Cell[29823, 1104, 140, 4, 59, "Input"],
Cell[29966, 1110, 280, 10, 33, "Text",
  Evaluatable->False],
Cell[30249, 1122, 263, 6, 59, "Input"],
Cell[30515, 1130, 337, 12, 48, "Question",
  Evaluatable->False],
Cell[30855, 1144, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[30966, 1151, 118, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:11.16.11"],
Cell[31087, 1156, 186, 4, 33, "Text",
  Evaluatable->False],
Cell[31276, 1162, 315, 7, 91, "Input"],
Cell[31594, 1171, 314, 7, 91, "Input"],
Cell[31911, 1180, 336, 7, 91, "Input"],
Cell[32250, 1189, 508, 15, 71, "Text",
  Evaluatable->False],
Cell[32761, 1206, 1502, 55, 86, "Question",
  Evaluatable->False],
Cell[34266, 1263, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[34343, 1267, 702, 25, 67, "Question",
  Evaluatable->False],
Cell[35048, 1294, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[35125, 1298, 985, 37, 67, "Question",
  Evaluatable->False],
Cell[36113, 1337, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[36190, 1341, 567, 20, 67, "Question",
  Evaluatable->False],
Cell[36760, 1363, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[36837, 1367, 639, 22, 67, "Question",
  Evaluatable->False],
Cell[37479, 1391, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[37556, 1395, 698, 25, 67, "Question",
  Evaluatable->False],
Cell[38257, 1422, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[38334, 1426, 798, 28, 52, "Text",
  Evaluatable->False],
Cell[39135, 1456, 48, 1, 27, "Input"],
Cell[39186, 1459, 144, 4, 59, "Input"],
Cell[39333, 1465, 105, 3, 43, "Input"],
Cell[39441, 1470, 149, 4, 59, "Input"],
Cell[39593, 1476, 105, 3, 43, "Input"],
Cell[39701, 1481, 623, 22, 67, "Question",
  Evaluatable->False],
Cell[40327, 1505, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[40404, 1509, 658, 25, 67, "Question",
  Evaluatable->False],
Cell[41065, 1536, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[41142, 1540, 1526, 54, 143, "Question",
  Evaluatable->False],
Cell[42671, 1596, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[42748, 1600, 600, 20, 67, "Question",
  Evaluatable->False],
Cell[43351, 1622, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[43462, 1629, 312, 12, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.17.11"],
Cell[43777, 1643, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[44122, 1654, 52, 1, 27, "Input"],
Cell[44177, 1657, 47, 1, 27, "Input"],
Cell[44227, 1660, 53, 1, 27, "Input"],
Cell[44283, 1663, 66, 1, 27, "Input"],
Cell[44352, 1666, 53, 1, 27, "Input"],
Cell[44408, 1669, 54, 1, 27, "Input"],
Cell[44465, 1672, 53, 1, 27, "Input"],
Cell[44521, 1675, 51, 1, 27, "Input"],
Cell[44575, 1678, 50, 1, 27, "Input"],
Cell[44628, 1681, 52, 1, 27, "Input"],
Cell[44683, 1684, 53, 1, 27, "Input"],
Cell[44739, 1687, 54, 1, 27, "Input"],
Cell[44796, 1690, 55, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

