(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32625,       1176]*)
(*NotebookOutlinePosition[     36080,       1286]*)
(*  CellTagsIndexPosition[     35684,       1270]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 14",
    FontSize->18],
  "\nRotational Groups of Regular Polyhedra"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.14"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["14.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.15.14"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["14.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.16.14"],

Cell["\<\
To complete this lab, you should know how a group can be generated \
from a set of elements and a binary operation. You should also be familiar \
with Euler angles (see the Rotations Lab on the CD for a review) and group \
actions.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["14.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.17.14"],

Cell["\<\
The goal of this lab is to learn how to generate the rotational \
groups of polyhedra.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["14.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "The rotational group of the tetrahedron"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.18.14"],

Cell[CellGroupData[{

Cell["14.3.1 Statement of the problem, first rotation", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.18.15.14"],

Cell[TextData[
"First let\[CloseCurlyQuote]s read in the packages and definitions needed for \
this lab. "], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Needs[\"Graphics`Polyhedra`\"];
Needs[\"AbstractAlgebra`Master`\"];
SwitchStructureTo[Group];
Needs[\"Geometry`Rotations`\"];
Needs[\"Graphics`Shapes`\"];
Needs[\"NumberTheory`Recognize`\"];

wireFrame::usage=\"wireFrame[polyhedron] draws a labeled wireframe
picture of the polyhedron.\";
 
wireFrame[obj_]:=Graphics3D[
  Map[Text[ToString[#],Vertices[obj][[#]]]&,
        Range[1,Length[Vertices[obj]]]]]//
        Show[{WireFrame[obj[]],#},DefaultFont->{\"Times\",36}]&;

Exact::usage=\"Exact[x_Real] converts x to an exact number involving
integers and roots (square and cube roots only).\";

Exact=Module[{x,t},
   If[Abs[#]<=0.00000001,
         0,
         ((x=#)//Recognize[x,3,t]&//Solve[#==0,t]&//(t/.#)&//
           Select[#,(Abs[x-N[#]]<=0.000001)&]&//First)]]&;

ActionOn::usage=\"ActionOn[obj, g] is the 3D-graphics object obtained
when rotation matrix g acts on 3D-graphics object obj. This is accomplished
by multiplying every triple of numbers appearing in obj by g.\";

ActionOn[obj_,g_]:=
 obj/.{{a_,b_,c_}/;And@@NumberQ/@{a,b,c}:>g.{a,b,c}};

disp::usage=\"disp[obj] displays list of 3D graphics primitives
in a standard display mode.\";

disp=Show[Graphics3D[#],PlotRange->{{-2,2},{-2,2},{-2,2}}]& ;

Compare::usage=\"Compare[obj, g] displays the 3D-graphics objects
obj and ActionOn[obj, g] side by side.\";

Compare=Show[GraphicsArray[
         {Graphics3D[#1,PlotRange->{{-2,2},{-2,2},{-2,2}}],
          Graphics3D[ActionOn[#1,#2],PlotRange->{{-2,2},{-2,2},{-2,2}}]}]]& ;

\
\>", "Input",
  InitializationCell->True,
  CellSize->{Inherited, 95.125},
  AspectRatioFixed->True],

Cell["Consider the tetrahedron.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(object\  = \ Tetrahedron[]; \nobject // disp\)], "Input"],

Cell[TextData[{
  StyleBox[
  "We examine certain rotation matrices that act on graphics objects like the \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Tetrahedron",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ActionOn",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is used extensively in this lab.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?ActionOn\)\)], "Input"],

Cell[TextData[{
  StyleBox[
  "We want to consider the rotations that make up the so-called rotational \
group of the tetrahedron, specifically the ones that rotate a tetrahedron so \
that it occupies the same space as the original object. We can use the \
function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Compare",
    FontFamily->"Courier"],
  StyleBox[
  " to visually confirm whether a rotation is in the rotation group.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Compare\)\)], "Input"],

Cell["\<\
Here is an example of a rotation we will not want to consider, \
because the matrix clearly does not return the object to its original \
position. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Compare[object, RotationMatrix3D[\[Pi]\/6, \[Pi]\/4, \[Pi]\/8]]; 
    \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "One example of an element in the rotational group of this tetrahedron is ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RotationMatrix3D[2Pi/3, 0, 0]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". The specific Euler angles that describe this matrix depend on the \
position of the tetrahedron. One of the faces of our object lies on a plane \
that is parallel to the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" plane, so a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(2  \[Pi]\)\/3\)]],
  StyleBox[" rotation about the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[
  "-axis is in the rotation group. Also, it is important to note that the \
tetrahedron needs to be centered about the origin. All polyhedra in the \
standard ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" package ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Polyhedra.m",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" are centered about the origin.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[r]\), 
    \(r\_1 = RotationMatrix3D[\(2\ \[Pi]\)\/3, 0, 0]; \nMatrixForm[r\_1]\)}], 
  "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Compare[object, r\_1]; \)\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["14.3.2 Generation of more rotations", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.18.16.14"],

Cell[TextData[{
  StyleBox["It is not too difficult to identify ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\_1\)]],
  StyleBox[
  " as a member of the rotational group, but how do we identify more \
complicated rotations? One way is by multiplying rotations. Given any set of \
rotations, we can generate a group.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[G]\), 
    \(G\_1 = GenerateGroupoid[{r\_1}, Simplify[#1 . #2]&]\)}], "Input",
  AspectRatioFixed->True],

Cell["This is a cyclic subgroup of order three. ", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Order[G\_1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Is this the whole rotation group? Based on the fact that the faces of a \
tetrahedron are four identical equilateral triangles, how many elements would \
you expect to find in its rotational group?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["14.3.3 Procedure for finding more complicated rotations", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.18.17.14"],

Cell["\<\
Although it may be clear that there are more elements, it is \
probably not obvious what the other rotation matrices are. At this point, we \
outline a systematic process to find these matrices.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s look at a labeled wire-frame picture of the object."],
   "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?wireFrame\)\)], "Input"],

Cell[BoxData[
    \(\(wireFrame[Tetrahedron]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The first rotation that we identified, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\_1\)]],
  StyleBox[", maps the (ordered) face ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, 3, 4}\)]],
  StyleBox[" into the face ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, 2, 3}\)]],
  StyleBox[" and, by applying it again, into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, 4, 2}\)]],
  StyleBox[". Now suppose we want to map, for example, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, 3, 4}\)]],
  StyleBox[" into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{4, 3, 2}\)]],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" be the unknown matrix.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(R = Array[r, {3, 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Before setting up a system of equations to solve for the rotation matrix, \
we need to take the vertex coordinates given in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Polyhedra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" package and make them ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["exact",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". For this we use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exact",
    FontFamily->"Courier"],
  StyleBox[
  ". This function is not very sophisticated, but it works for the kinds of \
numbers we are using.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Exact\)\)], "Input"],

Cell["Here are the vertices given in the package.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Vertices[Tetrahedron]\)], "Input",
  AspectRatioFixed->True],

Cell["The following are exact values.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Xvertices = Map[Exact, Vertices[Tetrahedron], {2}]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Although a system can be generated more efficiently, here we write \
it out a bit more descriptively.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(sys\  = \ 
      \n{R . Xvertices[\([1]\)] == Xvertices[\([4]\)]\ \ , \n
        R . Xvertices[\([3]\)] == Xvertices[\([3]\)]\ \ , \n
        R . Xvertices[\([4]\)] == Xvertices[\([2]\)]\ \ }\)], "Input"],

Cell[TextData[{
  StyleBox["Now we solve the system, use the rules to get values for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[
  ", pick out the one and only solution, and finally, simplify the solution.",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(r\_2 = Simplify[First[R /. Solve[sys, Flatten[R]]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now the moment of truth: Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\_2\)]],
  StyleBox[" in the rotational group?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Compare[object, r\_2]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "This is the rotation matrix that we were looking for. It would be nice to \
know the values of \[Phi], \[Theta] and \[Psi] that produce ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(r\_2 . \)\)]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Determining Euler Angles from a Rotation Matrix",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["\nDetermine the values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Phi]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Theta],",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Psi]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for which ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RotationMatrix3D[\[Phi], \[Theta], \[Psi]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is equal to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(r\_2 . \)\)]],
  StyleBox[" Hint: To equate two matrices, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  StyleBox[
  ", and convert to a list of equations, you can use code something like ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["(A == B)//Thread[#]&//Map[Thread[#]&,#]&//Flatten.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Now that we have two distinct rotations of the tetrahedron, we \
might be able to generate a larger group.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G\_2 = GenerateGroupoid[{r\_1, r\_2}, Simplify[#1 . #2]&]; \n
    Order[G\_2]\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
14.3.4 Verification that we have the complete rotational group\
\>",
   "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.18.18.14"],

Cell["\<\
This should be the whole group for which we are searching. To \
demonstrate how the group generates all the rotations, we mark one face and a \
vertex of the tetrahedron. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(markedFace\  = \ 
      \(object[\([2]\)] // 
          \ {#, \ RGBColor[0.022, \ 0.688, \ 0.717], \ Thickness[0.01], \ 
              Line[{Apply[Plus, \ object[\([2, \ 1]\)]]/3, \ 
                  1.1\ #[\([1, 1]\)]}], \ RGBColor[0.701, \ 0.038, \ 0.038], 
              \ PointSize[0.03], \ Point[1.1\ #[\([1, \ 1]\)]]}&\) // disp; 
    \)\)], "Input"],

Cell["\<\
First we look at the individual effects of each group element on \
this face. You may want to enlarge the graphic you get here.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Show[
      GraphicsArray[
        \((Partition[#1, 4]&)\)[
          \((ActionOn[markedFace, #1]&)\)/@First[G\_2]]]]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Taken together, we get a single tetrahedron with three marks on \
each face. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Show[\((ActionOn[markedFace, #1]&)\)/@First[G\_2]]; \)\)], "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["14.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Further exercises"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.19.14"],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rotational Group of the Cube",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "\n\ta. How many elements would you expect to find in the group of \
rotations of the cube?\n\tb. Generate the group of rotations of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Cube[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" that is contained in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Polyhedra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" package. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(wireFrame[Cube]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rotational Group of the Icosahedron",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "\n\ta. How many elements would you expect to find in the group of \
rotations of the icosahedron?\n\tb. Generate the group of rotations of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Icosahedron[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" that is contained in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Polyhedra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" package. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(wireFrame[Icosahedron]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rotational Groups of the Octahedron and Dodecahedron",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "\nThe octahedron is the dual of the cube. If each face of the cube is \
replaced with a point at its center and points that are derived from adjacent \
faces are connected, then the wire frame of an octahedron appears. Explain \
why the rotational group of the octahedron should be isomorphic to that of \
the cube. The icosahedron and dodecahedron pair up in the same way.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". The cuboctahedron can be formed by taking a cube and slicing its eight \
corners off so that the exposed triangular faces just barely meet at one \
point. It can also be created in the same way starting with an octahedron, \
thus its name. Determine the number of elements in the rotational group of \
the cuboctahedron. Is it isomorphic to a group you",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["ve already seen?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(AppendTo[Polyhedra, Cuboctahedron]; \)\), 
    \(Cuboctahedron[Graphics`Polyhedra`Private`opts___] := 
      \(Polyhedron[Cuboctahedron, Graphics`Polyhedra`Private`opts]
          \)\[LeftDoubleBracket]1\[RightDoubleBracket]\), 
    \(\(Vertices[Cuboctahedron] ^= 
      Map[N, {{0, \(-\(1\/\@2\)\), \(-\(1\/\@2\)\)}, {0, \(-\(1\/\@2\)\), 
            1\/\@2}, {0, 1\/\@2, \(-\(1\/\@2\)\)}, {0, 1\/\@2, 1\/\@2}, {
            \(-\(1\/\@2\)\), 0, \(-\(1\/\@2\)\)}, {\(-\(1\/\@2\)\), 0, 
            1\/\@2}, {\(-\(1\/\@2\)\), \(-\(1\/\@2\)\), 0}, {\(-\(1\/\@2\)\), 
            1\/\@2, 0}, {1\/\@2, 0, \(-\(1\/\@2\)\)}, {1\/\@2, 0, 1\/\@2}, {
            1\/\@2, \(-\(1\/\@2\)\), 0}, {1\/\@2, 1\/\@2, 0}}, {2}]; \)\), 
    \(\(Faces[
        Cuboctahedron] ^= {{2, 6, 7}, {2, 6, 4, 10}, {2, 10, 11}, {2, 11, 1, 
          7}, {11, 10, 12, 9}, {6, 8, 5, 7}, {4, 6, 8}, {3, 5, 8}, {1, 5, 3, 
          9}, {4, 8, 3, 12}, {4, 10, 12}, {1, 11, 9}, {1, 5, 7}, {3, 9, 12}}; 
    \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(wireFrame[Cuboctahedron]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" Why should this method of finding rotation matrices work?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  StyleBox[
  " be a triangle in three-dimensional real space whose vertices are linearly \
independent. Prove that if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[
  " is a three-by-three matrix with the property that the triangle ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  StyleBox[" (i.e., ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Dot[R,T]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[") is congruent to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" is a rotation matrix.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["14.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:14.20.14"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Tetrahedron", "Input",
  AspectRatioFixed->True],

Cell["?Polyhedra", "Input",
  AspectRatioFixed->True],

Cell["?Vertices", "Input",
  AspectRatioFixed->True],

Cell["?RotationMatrix3D", "Input",
  AspectRatioFixed->True],

Cell["?GenerateGroupoid", "Input",
  AspectRatioFixed->True],

Cell["?Order", "Input",
  AspectRatioFixed->True],

Cell["?Solve", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 422},
WindowMargins->{{7, Automatic}, {Automatic, 5}},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Lab 14 Rotational groups of regular polyhedra", FontSlant -> 
            "Italic"], "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:14.14"->{
    Cell[2382, 76, 190, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:14.14"]},
  "a:14.15.14"->{
    Cell[2597, 87, 327, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:14.15.14"]},
  "a:14.16.14"->{
    Cell[7124, 240, 195, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:14.16.14"]},
  "a:14.17.14"->{
    Cell[7662, 262, 187, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:14.17.14"]},
  "a:14.18.14"->{
    Cell[8047, 282, 221, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:14.18.14"]},
  "a:14.18.15.14"->{
    Cell[8293, 294, 146, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:14.18.15.14"]},
  "a:14.18.16.14"->{
    Cell[13892, 490, 134, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:14.18.16.14"]},
  "a:14.18.17.14"->{
    Cell[15386, 546, 154, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:14.18.17.14"]},
  "a:14.18.18.14"->{
    Cell[22815, 823, 172, 6, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:14.18.18.14"]},
  "a:14.19.14"->{
    Cell[24321, 877, 199, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:14.19.14"]},
  "a:14.20.14"->{
    Cell[31479, 1126, 374, 14, 55, "Section",
      Evaluatable->False,
      CellTags->"a:14.20.14"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:14.14", 34331, 1222},
  {"a:14.15.14", 34444, 1226},
  {"a:14.16.14", 34563, 1230},
  {"a:14.17.14", 34682, 1234},
  {"a:14.18.14", 34801, 1238},
  {"a:14.18.15.14", 34923, 1242},
  {"a:14.18.16.14", 35051, 1246},
  {"a:14.18.17.14", 35180, 1250},
  {"a:14.18.18.14", 35309, 1254},
  {"a:14.19.14", 35435, 1258},
  {"a:14.20.14", 35555, 1262}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 190, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:14.14"],

Cell[CellGroupData[{
Cell[2597, 87, 327, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:14.15.14"],
Cell[2927, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3804, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5200, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5378, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6026, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6744, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7124, 240, 195, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:14.16.14"],
Cell[7322, 250, 303, 7, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7662, 262, 187, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:14.17.14"],
Cell[7852, 272, 158, 5, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8047, 282, 221, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:14.18.14"],

Cell[CellGroupData[{
Cell[8293, 294, 146, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:14.18.15.14"],
Cell[8442, 299, 164, 4, 33, "Text",
  Evaluatable->False],
Cell[8609, 305, 1610, 48, 108, "Input",
  InitializationCell->True],
Cell[10222, 355, 89, 2, 33, "Text",
  Evaluatable->False],
Cell[10314, 359, 77, 1, 43, "Input"],
Cell[10394, 362, 615, 22, 52, "Text",
  Evaluatable->False],
Cell[11012, 386, 46, 1, 27, "Input"],
Cell[11061, 389, 566, 16, 90, "Text",
  Evaluatable->False],
Cell[11630, 407, 45, 1, 27, "Input"],
Cell[11678, 410, 219, 6, 52, "Text",
  Evaluatable->False],
Cell[11900, 418, 133, 3, 40, "Input"],
Cell[12036, 423, 1578, 52, 131, "Text",
  Evaluatable->False],
Cell[13617, 477, 149, 4, 78, "Input"],
Cell[13769, 483, 86, 2, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[13892, 490, 134, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:14.18.16.14"],
Cell[14029, 495, 482, 14, 71, "Text",
  Evaluatable->False],
Cell[14514, 511, 131, 3, 43, "Input"],
Cell[14648, 516, 106, 2, 33, "Text",
  Evaluatable->False],
Cell[14757, 520, 70, 2, 27, "Input"],
Cell[14830, 524, 442, 13, 86, "Question",
  Evaluatable->False],
Cell[15275, 539, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[15386, 546, 154, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:14.18.17.14"],
Cell[15543, 551, 266, 6, 52, "Text",
  Evaluatable->False],
Cell[15812, 559, 152, 4, 33, "Text",
  Evaluatable->False],
Cell[15967, 565, 47, 1, 27, "Input"],
Cell[16017, 568, 87, 2, 27, "Input"],
Cell[16107, 572, 1188, 41, 71, "Text",
  Evaluatable->False],
Cell[17298, 615, 79, 2, 27, "Input"],
Cell[17380, 619, 1053, 36, 90, "Text",
  Evaluatable->False],
Cell[18436, 657, 43, 1, 27, "Input"],
Cell[18482, 660, 107, 2, 33, "Text",
  Evaluatable->False],
Cell[18592, 664, 80, 2, 27, "Input"],
Cell[18675, 668, 95, 2, 33, "Text",
  Evaluatable->False],
Cell[18773, 672, 109, 2, 27, "Input"],
Cell[18885, 676, 173, 5, 52, "Text",
  Evaluatable->False],
Cell[19061, 683, 224, 4, 75, "Input"],
Cell[19288, 689, 396, 13, 52, "Text",
  Evaluatable->False],
Cell[19687, 704, 110, 2, 27, "Input"],
Cell[19800, 708, 314, 11, 33, "Text",
  Evaluatable->False],
Cell[20117, 721, 86, 2, 27, "Input"],
Cell[20206, 725, 339, 10, 52, "Text",
  Evaluatable->False],
Cell[20548, 737, 1833, 65, 105, "Question",
  Evaluatable->False],
Cell[22384, 804, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[22461, 808, 178, 5, 52, "Text",
  Evaluatable->False],
Cell[22642, 815, 136, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[22815, 823, 172, 6, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:14.18.18.14"],
Cell[22990, 831, 243, 6, 52, "Text",
  Evaluatable->False],
Cell[23236, 839, 379, 7, 107, "Input"],
Cell[23618, 848, 199, 5, 52, "Text",
  Evaluatable->False],
Cell[23820, 855, 182, 5, 43, "Input"],
Cell[24005, 862, 149, 5, 33, "Text",
  Evaluatable->False],
Cell[24157, 869, 115, 2, 27, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24321, 877, 199, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:14.19.14"],
Cell[24523, 887, 942, 33, 105, "Question",
  Evaluatable->False],
Cell[25468, 922, 80, 2, 27, "Input"],
Cell[25551, 926, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[25628, 930, 963, 33, 124, "Question",
  Evaluatable->False],
Cell[26594, 965, 87, 2, 27, "Input"],
Cell[26684, 969, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[26761, 973, 830, 22, 124, "Question",
  Evaluatable->False],
Cell[27594, 997, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[27671, 1001, 705, 19, 105, "Question",
  Evaluatable->False],
Cell[28379, 1022, 1065, 18, 303, "Input",
  InitializationCell->True],
Cell[29447, 1042, 89, 2, 27, "Input"],
Cell[29539, 1046, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[29616, 1050, 299, 10, 48, "Question",
  Evaluatable->False],
Cell[29918, 1062, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[29995, 1066, 1370, 51, 86, "Question",
  Evaluatable->False],
Cell[31368, 1119, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[31479, 1126, 374, 14, 55, "Section",
  Evaluatable->False,
  CellTags->"a:14.20.14"],
Cell[31856, 1142, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[32201, 1153, 55, 1, 27, "Input"],
Cell[32259, 1156, 53, 1, 27, "Input"],
Cell[32315, 1159, 52, 1, 27, "Input"],
Cell[32370, 1162, 60, 1, 27, "Input"],
Cell[32433, 1165, 60, 1, 27, "Input"],
Cell[32496, 1168, 49, 1, 27, "Input"],
Cell[32548, 1171, 49, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

