(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25331,        991]*)
(*NotebookOutlinePosition[     26223,       1020]*)
(*  CellTagsIndexPosition[     26179,       1016]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  ScriptMinSize->12,
  FontSize->14],

Cell[StyleData[All, "Condensed"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Margins"->{1, 1},
  "Widths"->{0, 5}},
  ScriptMinSize->8,
  FontSize->11],

Cell[StyleData[All, "Printout"],
  PageWidth->366,
  PrintingOptions->{"PrintingMargins"->{{0, 0}, {0, 22}},
  "PrintRegistrationMarks"->True},
  ScriptMinSize->5,
  FontSize->11,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellFrame->True,
  CellMargins->{{12, Inherited}, {20, 10}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  TextAlignment->Center,
  LineSpacing->{1, 16},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Times",
  FontSize->24,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell[StyleData["Title", "Presentation"],
  CellFrame->True,
  CellMargins->{{24, 10}, {20, 40}},
  LineSpacing->{1, 0},
  Background->GrayLevel[1]],

Cell[StyleData["Title", "Condensed"],
  CellFrame->True,
  CellMargins->{{8, 10}, {4, 8}},
  FontSize->20,
  Background->GrayLevel[1]],

Cell[StyleData["Title", "Printout"],
  CellFrame->False,
  CellMargins->{{2, 2}, {120, 30}},
  CellBracketOptions->{"Color"->RGBColor[0, 0, 1]},
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{12, Inherited}, {10, 15}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  TextAlignment->Center,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Times",
  FontSize->24,
  FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{24, 10}, {15, 20}},
  TextAlignment->Center,
  LineSpacing->{1, 0},
  FontFamily->"Times",
  FontSize->36,
  FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Condensed"],
  CellMargins->{{8, 10}, {4, 4}},
  TextAlignment->Center,
  FontFamily->"Times",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{2, 10}, {10, 15}},
  TextAlignment->Center,
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  TextAlignment->Center,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Times",
  FontSize->24,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
  CellMargins->{{24, 10}, {10, 20}},
  LineSpacing->{1, 0},
  FontSize->36],

Cell[StyleData["Subsubtitle", "Condensed"],
  CellMargins->{{8, 10}, {8, 12}},
  FontSize->20],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellDingbat->"\[GraySquare]",
  CellMargins->{{25, Inherited}, {8, 24}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
  CellDingbat->"\[GraySquare]",
  CellMargins->{{40, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontFamily->"Times",
  FontSize->24],

Cell[StyleData["Section", "Condensed"],
  CellDingbat->"\[GraySquare]",
  CellMargins->{{18, Inherited}, {6, 12}},
  FontFamily->"Times",
  FontSize->12],

Cell[StyleData["Section", "Printout"],
  CellDingbat->"\[GraySquare]",
  CellMargins->{{13, 0}, {7, 22}},
  FontFamily->"Times",
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{22, Inherited}, {8, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{36, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontSize->22],

Cell[StyleData["Subsection", "Condensed"],
  CellMargins->{{16, Inherited}, {6, 12}},
  FontSize->12],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {7, 22}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{22, Inherited}, {8, 18}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{34, 10}, {11, 26}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Subsubsection", "Condensed"],
  CellMargins->{{17, Inherited}, {6, 12}},
  FontSize->10],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{9, 0}, {7, 14}},
  FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{12, 10}, {7, 7}},
  LineSpacing->{1, 3},
  CounterIncrements->"Text",
  FontSize->14],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5},
  FontSize->16],

Cell[StyleData["Text", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{0, 0}, {3, 3}},
  TextJustification->1,
  LineSpacing->{1, 2},
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{12, 10}, {6, 6}},
  LineSpacing->{1, 3},
  CounterIncrements->"SmallText",
  FontFamily->"Times",
  FontSize->10],

Cell[StyleData["SmallText", "Presentation"],
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontFamily->"Times",
  FontSize->12],

Cell[StyleData["SmallText", "Condensed"],
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontFamily->"Times",
  FontSize->9],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{2, 2}, {5, 5}},
  FontFamily->"Times",
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["unique styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Question"],
  Deletable->False,
  CellFrame->True,
  CellMargins->{{12, 10}, {6, 6}},
  Evaluatable->False,
  LineSpacing->{1, 3},
  FontFamily->"Times",
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Question", "Presentation"],
  CellFrame->True,
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontSize->16],

Cell[StyleData["Question", "Condensed"],
  CellFrame->True,
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontSize->12],

Cell[StyleData["Question", "Printout"],
  CellFrame->True,
  CellMargins->{{0, 0}, {3, 3}},
  CellFrameMargins->5,
  LineSpacing->{1, 2},
  FontSize->11,
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Answer"],
  Deletable->True,
  CellFrame->True,
  CellMargins->{{12, 10}, {6, 6}},
  Evaluatable->False,
  LineSpacing->{1, 3},
  FontFamily->"Times",
  FontSize->14,
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.8]],

Cell[StyleData["Answer", "Presentation"],
  CellFrame->True,
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontSize->16,
  Background->GrayLevel[0.800015]],

Cell[StyleData["Answer", "Condensed"],
  CellFrame->True,
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontSize->12,
  Background->GrayLevel[0.800015]],

Cell[StyleData["Answer", "Printout"],
  CellFrame->True,
  CellMargins->{{2, 2}, {5, 5}},
  FontSize->12,
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{45, 10}, {5, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
  CellMargins->{{72, Inherited}, {8, 10}},
  LineSpacing->{1, 0}],

Cell[StyleData["Input", "Condensed"],
  CellMargins->{{40, 10}, {2, 3}}],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9]
}, Closed]],

Cell[StyleData["InputOnly"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{47, 10}, {7, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Presentation"],
  CellMargins->{{72, Inherited}, {10, 8}},
  LineSpacing->{1, 0}],

Cell[StyleData["Output", "Condensed"],
  CellMargins->{{41, Inherited}, {3, 2}}],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0}],

Cell[StyleData["Message", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None,
  FontSize->14],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0},
  FontSize->16],

Cell[StyleData["Print", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{4, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
  ImageMargins->{{62, Inherited}, {Inherited, 0}}],

Cell[StyleData["Graphics", "Condensed"],
  ImageSize->{175, 175},
  ImageMargins->{{38, Inherited}, {Inherited, 0}}],

Cell[StyleData["Graphics", "Printout"],
  ImageSize->{250, 250},
  ImageMargins->{{30, Inherited}, {Inherited, 0}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->12],

Cell[StyleData["CellLabel", "Condensed"],
  FontSize->9],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["InlineFormula"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ScriptLevel->1,
  SingleLetterItalics->True,
  FontSize->14],

Cell[StyleData["InlineFormula", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5}],

Cell[StyleData["InlineFormula", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1}],

Cell[StyleData["InlineFormula", "Printout"],
  CellMargins->{{2, 0}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{42, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  ScriptLevel->0,
  SingleLetterItalics->True,
  StyleMenuListing->None,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
  LineSpacing->{1, 5}],

Cell[StyleData["DisplayFormula", "Condensed"],
  LineSpacing->{1, 1}],

Cell[StyleData["DisplayFormula", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontSize->10,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"]],

Cell[StyleData["Hyperlink", "Condensed"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"]],

Cell[StyleData["MainBookLink", "Condensed"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"]],

Cell[StyleData["AddOnsLink", "Condensed"]],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"]],

Cell[StyleData["RefGuideLink", "Condensed"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"]],

Cell[StyleData["GettingStartedLink", "Condensed"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"]],

Cell[StyleData["OtherInformationLink", "Condensed"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Placeholder Styles", "Section"],

Cell["\<\
The cells below define styles useful for making placeholder objects \
in palette templates.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Placeholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->True,
  StyleMenuListing->None],

Cell[StyleData["Placeholder", "Presentation"]],

Cell[StyleData["Placeholder", "Condensed"]],

Cell[StyleData["Placeholder", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SelectionPlaceholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  StyleMenuListing->None,
  DrawHighlighted->True],

Cell[StyleData["SelectionPlaceholder", "Presentation"]],

Cell[StyleData["SelectionPlaceholder", "Condensed"]],

Cell[StyleData["SelectionPlaceholder", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of \
most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],

Cell[StyleData["CellExpression"],
  PageWidth->Infinity,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
  AllowInlineCells->False,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
  PageWidth->Infinity,
  TextAlignment->Left,
  LineSpacing->{1, -5},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
  LineSpacing->{1.25, 0},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
  LineSpacing->{1.25, 0},
  SingleLetterItalics->True,
  TraditionalFunctionNotation->True,
  DelimiterMatching->None,
  StyleMenuListing->None],

Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],

Cell[StyleData["InlineCell"],
  TextAlignment->Left,
  ScriptLevel->1,
  StyleMenuListing->None],

Cell[StyleData["InlineCellEditing"],
  StyleMenuListing->None,
  Background->RGBColor[1, 0.749996, 0.8]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
CellGrouping->Manual,
WindowSize->{615, 402},
WindowMargins->{{63, Automatic}, {Automatic, 43}},
ShowGroupOpenCloseIcon->True,
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 62, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 42, 0, 50, "Section"],
Cell[2034, 63, 77, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2114, 67, 99, 3, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[2216, 72, 158, 5, 70, 33, 0, "StyleData", "All", "Condensed"],
Cell[2377, 79, 226, 6, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2640, 90, 35, 0, 30, "Section"],
Cell[2678, 92, 101, 3, 70, "Text"],
Cell[2782, 97, 81, 2, 70, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[2900, 104, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[2963, 108, 471, 14, 70, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3437, 124, 147, 4, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[3587, 130, 134, 4, 70, 37, 0, "StyleData", "Title", "Condensed"],
Cell[3724, 136, 171, 4, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3932, 145, 359, 10, 70, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4294, 157, 190, 6, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[4487, 165, 161, 5, 70, 40, 0, "StyleData", "Subtitle", "Condensed"],
Cell[4651, 172, 162, 5, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4850, 182, 338, 9, 70, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[5191, 193, 122, 3, 70, 46, 0, "StyleData", "Subsubtitle", 
"Presentation"],
Cell[5316, 198, 94, 2, 70, 43, 0, "StyleData", "Subsubtitle", "Condensed"],
Cell[5413, 202, 93, 2, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5543, 209, 330, 9, 70, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[5876, 220, 173, 5, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[6052, 227, 153, 4, 70, 39, 0, "StyleData", "Section", "Condensed"],
Cell[6208, 233, 144, 4, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6389, 242, 301, 8, 70, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[6693, 252, 121, 3, 70, 45, 0, "StyleData", "Subsection", 
"Presentation"],
Cell[6817, 257, 101, 2, 70, 42, 0, "StyleData", "Subsection", "Condensed"],
Cell[6921, 261, 91, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7049, 268, 245, 6, 70, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[7297, 276, 124, 3, 70, 48, 0, "StyleData", "Subsubsection", 
"Presentation"],
Cell[7424, 281, 104, 2, 70, 45, 0, "StyleData", "Subsubsection", 
"Condensed"],
Cell[7531, 285, 94, 2, 70, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7674, 293, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[7738, 297, 126, 4, 70, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[7867, 303, 115, 3, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[7985, 308, 93, 2, 70, 36, 0, "StyleData", "Text", "Condensed"],
Cell[8081, 312, 131, 4, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8249, 321, 159, 5, 70, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[8411, 328, 141, 4, 70, 44, 0, "StyleData", "SmallText", "Presentation"],
Cell[8555, 334, 136, 4, 70, 41, 0, "StyleData", "SmallText", "Condensed"],
Cell[8694, 340, 112, 3, 70, 40, 0, "StyleData", "SmallText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8855, 349, 32, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[8912, 353, 220, 8, 59, 27, 0, "StyleData", "Question", "All"],
Cell[9135, 363, 136, 4, 64, 43, 0, "StyleData", "Question", "Presentation"],
Cell[9274, 369, 132, 4, 54, 40, 0, "StyleData", "Question", "Condensed"],
Cell[9409, 375, 181, 6, 43, 39, 0, "StyleData", "Question", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9627, 386, 244, 9, 59, 25, 0, "StyleData", "Answer", "All"],
Cell[9874, 397, 169, 5, 70, 41, 0, "StyleData", "Answer", "Presentation"],
Cell[10046, 404, 165, 5, 70, 38, 0, "StyleData", "Answer", "Condensed"],
Cell[10214, 411, 133, 4, 70, 37, 0, "StyleData", "Answer", "Printout"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10396, 421, 42, 0, 30, "Section"],
Cell[10441, 423, 248, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[10714, 432, 467, 14, 70, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[11184, 448, 106, 2, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[11293, 452, 72, 1, 70, 37, 0, "StyleData", "Input", "Condensed"],
Cell[11368, 455, 85, 2, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[11468, 460, 342, 11, 70, 28, 0, "StyleData", "InputOnly", "All",
  CounterIncrements->"Input",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[11835, 475, 454, 13, 70, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[12292, 490, 107, 2, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[12402, 494, 80, 1, 70, 38, 0, "StyleData", "Output", "Condensed"],
Cell[12485, 497, 86, 2, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12608, 504, 501, 14, 70, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[13112, 520, 123, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[13238, 524, 97, 1, 70, 39, 0, "StyleData", "Message", "Condensed"],
Cell[13338, 527, 138, 3, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13513, 535, 514, 15, 70, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[14030, 552, 137, 3, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[14170, 557, 95, 1, 70, 37, 0, "StyleData", "Print", "Condensed"],
Cell[14268, 560, 109, 2, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14414, 567, 439, 12, 70, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[14856, 581, 94, 1, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[14953, 584, 116, 2, 70, 40, 0, "StyleData", "Graphics", "Condensed"],
Cell[15072, 588, 130, 3, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15239, 596, 128, 4, 70, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[15370, 602, 60, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[15433, 605, 56, 1, 70, 41, 0, "StyleData", "CellLabel", "Condensed"],
Cell[15492, 608, 130, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15671, 618, 43, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[15739, 622, 162, 5, 70, 32, 0, "StyleData", "InlineFormula", "All"],
Cell[15904, 629, 108, 2, 70, 48, 0, "StyleData", "InlineFormula", 
"Presentation"],
Cell[16015, 633, 102, 2, 70, 45, 0, "StyleData", "InlineFormula", 
"Condensed"],
Cell[16120, 637, 77, 1, 70, 44, 0, "StyleData", "InlineFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16234, 643, 253, 6, 70, 33, 0, "StyleData", "DisplayFormula", "All",
  StyleMenuListing->None],
Cell[16490, 651, 72, 1, 70, 49, 0, "StyleData", "DisplayFormula", 
"Presentation"],
Cell[16565, 654, 69, 1, 70, 46, 0, "StyleData", "DisplayFormula", 
"Condensed"],
Cell[16637, 657, 45, 0, 70, 45, 0, "StyleData", "DisplayFormula", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16731, 663, 49, 0, 30, "Section"],
Cell[16783, 665, 123, 4, 70, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[16909, 671, 122, 4, 70, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[17034, 677, 127, 4, 70, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[17198, 686, 33, 0, 30, "Section"],
Cell[17234, 688, 121, 3, 70, "Text"],
Cell[17358, 693, 226, 5, 70, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17587, 700, 295, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17885, 709, 400, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[18288, 720, 387, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[18678, 731, 401, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[19116, 745, 35, 0, 70, "Section"],
Cell[19154, 747, 184, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[19363, 755, 302, 8, 70, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19668, 765, 44, 0, 70, 44, 0, "StyleData", "Hyperlink", "Presentation"],
Cell[19715, 767, 41, 0, 70, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[19759, 769, 107, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[19881, 774, 104, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[20010, 781, 316, 8, 70, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20329, 791, 47, 0, 70, 47, 0, "StyleData", "MainBookLink", 
"Presentation"],
Cell[20379, 793, 44, 0, 70, 44, 0, "StyleData", "MainBookLink", "Condensed"],
Cell[20426, 795, 110, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20573, 802, 337, 9, 70, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20913, 813, 45, 0, 70, 45, 0, "StyleData", "AddOnsLink", 
"Presentation"],
Cell[20961, 815, 42, 0, 70, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[21006, 817, 107, 2, 70, 40, 0, "StyleData", "AddOnLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21150, 824, 345, 9, 70, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[21498, 835, 47, 0, 70, 47, 0, "StyleData", "RefGuideLink", 
"Presentation"],
Cell[21548, 837, 44, 0, 70, 44, 0, "StyleData", "RefGuideLink", "Condensed"],
Cell[21595, 839, 110, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21742, 846, 328, 8, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[22073, 856, 53, 0, 70, 53, 0, "StyleData", "GettingStartedLink", 
"Presentation"],
Cell[22129, 858, 50, 0, 70, 50, 0, "StyleData", "GettingStartedLink", 
"Condensed"],
Cell[22182, 860, 116, 2, 70, 49, 0, "StyleData", "GettingStartedLink", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22335, 867, 332, 8, 70, 39, 0, "StyleData", "OtherInformationLink", 
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[22670, 877, 55, 0, 70, 55, 0, "StyleData", "OtherInformationLink", 
"Presentation"],
Cell[22728, 879, 52, 0, 70, 52, 0, "StyleData", "OtherInformationLink", 
"Condensed"],
Cell[22783, 881, 118, 2, 70, 51, 0, "StyleData", "OtherInformationLink", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[22950, 889, 37, 0, 70, "Section"],
Cell[22990, 891, 115, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[23130, 898, 145, 5, 70, 30, 0, "StyleData", "Placeholder", "All",
  StyleMenuListing->None],
Cell[23278, 905, 46, 0, 70, 46, 0, "StyleData", "Placeholder", 
"Presentation"],
Cell[23327, 907, 43, 0, 70, 43, 0, "StyleData", "Placeholder", "Condensed"],
Cell[23373, 909, 42, 0, 70, 42, 0, "StyleData", "Placeholder", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23452, 914, 158, 5, 70, 39, 0, "StyleData", "SelectionPlaceholder", 
"All",
  StyleMenuListing->None],
Cell[23613, 921, 55, 0, 70, 55, 0, "StyleData", "SelectionPlaceholder", 
"Presentation"],
Cell[23671, 923, 52, 0, 70, 52, 0, "StyleData", "SelectionPlaceholder", 
"Condensed"],
Cell[23726, 925, 51, 0, 70, 51, 0, "StyleData", "SelectionPlaceholder", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23826, 931, 36, 0, 70, "Section"],
Cell[23865, 933, 258, 5, 70, "Text"],
Cell[24126, 940, 298, 9, 70, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None],
Cell[24427, 951, 106, 3, 70, 28, 0, "StyleData", "InputForm", "All",
  StyleMenuListing->None],
Cell[24536, 956, 150, 5, 70, 29, 0, "StyleData", "OutputForm", "All",
  StyleMenuListing->None],
Cell[24689, 963, 108, 3, 70, 31, 0, "StyleData", "StandardForm", "All",
  StyleMenuListing->None],
Cell[24800, 968, 179, 5, 70, 34, 0, "StyleData", "TraditionalForm", "All",
  StyleMenuListing->None],
Cell[24982, 975, 115, 3, 70, "Text"],
Cell[25100, 980, 96, 3, 70, 29, 0, "StyleData", "InlineCell", "All",
  StyleMenuListing->None],
Cell[25199, 985, 104, 2, 70, 36, 0, "StyleData", "InlineCellEditing", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

