(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)

(* :Title:  AbstractAlgebra`LabCode *)

(* :Context: AbstractAlgebra`LabCode` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)

incomingStructure = DefaultStructure;

BeginPackage["AbstractAlgebra`LabCode`",{"AbstractAlgebra`Core`", 
	"AbstractAlgebra`GroupProperties`",	"AbstractAlgebra`Groupoids`",
	"AbstractAlgebra`Joint`","Graphics`Graphics`",
	"Utilities`FilterOptions`","Graphics`Colors`"}];

Off[General::spell,General::spell1];
SetOptions[Graphics,AspectRatio->Automatic];
Format[LineBreak[_]] = "";
Format[Indent[_]] = "";
Format[StringBreak[_]] = "";

myDiv::usage = ""; 
trivProd::usage = ""; 
myMod::usage = "";
myDivisorSigma::usage = ""; 
myDot::usage = "";
myPower::usage = ""; 
quatOp::usage = ""; 
undef::usage = "";
CInf::usage = ""; 
Ind::usage = "";
myZees::usage = "";

D1Prod::usage = "";

D2Prod::usage = "";

LG::usage = "LG[n] is the nth groupoid found in a list
called 'Lab Groupoids.' These are groupoids used in a
variety of labs.";

SE::usage = "SE[n] is the nth 'Standard Example' group from
a list of commonly used groups.";

Lab2::usage = "";

AddPermToGroup::usage = 
"AddPermToGroup[p] will add the permutation p to the list of
alleged symmetries (which is called MySymmetryGroup). Note that
p can be in the form of a list ({1,3,4,2}) or a list of rules
({1->1, 2->3, 3->4, 4->2}).";

DropPermFromGroup::usage = 
"DropPermFromGroup[p] deletes the permutation p from the list of
alleged symmetries (which is called MySymmetryGroup). Note that
p can be in the form of a list ({1,3,4,2}) or a list of rules
({1->1, 2->3, 3->4, 4->2}).";

MySymmetryGroup::usage = 
"MySymmetryGroup is a global variable which contains the 
accumulated list of alleged permutations representing the 
symmetries of the object given by ShowOne[Lab2]. Note that since
it is a variable, it does not need [] following it.";

TestPermutationQ::usage = 
"TestPermutationQ[p] tests to see if p is indeed a symmetry
of the object given by ShowOne[Lab2]. True or False is returned. The
permutation p can be as a simple list or as a list of rules.";

GoodGroupElementsQ::usage = 
"GoodGroupElementsQ[] will return True or False depending on 
whether or not the list of alleged symmetries found in 
MySymmetryGroup are all elements of the actual symmetry group.";

CompleteGroupQ::usage = 
"CompleteGroupQ[] will return True or False depending on 
whether or not the list of alleged symmetries found in 
MySymmetryGroup is the complete actual symmetry group.
Other messages may be generated as well, if incomplete or in
error.";

ReduceList::usage = "ReduceList[polyList] effectively is the equivalent to
Union[polyList, SameTest -> Equal] where polyList is a list of polynomials
formed using the Poly function and Equal is the function designed to test
when two polynomials built from Poly are equal.";

ShowPossiblePermutations::usage = 
"ShowPossiblePermutations[n] shows the complete list of all
possible permutations of the integers {1,2,3,...n} where n
must be 5 or less. If the object in question is an n-gon, then
use n as the parameter. Note that the permutations are labeled 
ppp[i] and these labels can be used to refer to the given 
permutation.";

ShowPossiblePermsAsRules::usage = 
"ShowPossiblePermsAsRules[n] shows the complete list of all
possible permutations of the integers {1,2,3,...n} where n
must be 5 or less. If the object in question is an n-gon, then
use n as the parameter. This differs from ShowPossiblePermutations
only in the way they are presented - here as rules. Note that
the permutations are labeled ppp[i] and these labels can be
used to refer to the given permutation.";

RestrictList::usage = 
"RestrictList[r], given a rule r given as either {i -> j}
or as i -> j, will produce output similar to what is given in
ShowPossiblePermsAsRules except that only those permutations
containing r will be shown. This can be useful if you are 
exploring what possibilities exist given vertex i is to go to
vertex j. 
RestrictList[{r1, r2,..}] is similar except it will take the
intersection of what is obtained by RestrictList[r1],
RestrictList[r2]...";

Lab3::usage = "";

ShowGroupOrders::usage = "ShowGroupOrders[G] displays a ListPlot
containing pairs {g,|g|} for all g in the Groupoid G. It also shows
a bar chart indicating how\.08many elements there are of each order
in the Groupoid G";

CollectOrders::usage = "CollectOrders[G], when given the output
of the function OrderOfAllElements, will organize the data in the form
{p, A} where p is one of the orders of the elements g in the Groupoid
G and A is the set of all elements from G with the order being p.";

GroupsToConsider::usage = "GroupsToConsider is a list of
groups to consider for this lab.";

ShowOne::usage = "ShowOne[Labx] shows the appropriate
information needed for lab numbered x.";

Verbal::usage = "";

Lab4::usage = "";

ListOperationPreservingElements::usage = "";

Begin["`Private`"];

GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]


groups = {"D6", "Z7", "Z9", "Z6", "Z2", "D4", "D3", "Z4", "Z5", 
"D5", "D7", "D2", "Z3", "Z8", "Z10"};

remaining = groups;

typesOfFigures = {cyclic, dihedral, other};

fullcount = 0;

numOfFigures[cyclic] = 10; (* max n for Zn *)

numOfFigures[dihedral] = 7; (* max n for Dn *)

otherList = {Rectangle, theZee}; (* description of other
	figures *)

numOfFigures[other] = Length[otherList];

otherListSymGrp = {"D2","Z2"}; (* symmetry group for figures
	in otherList - ordered as otherList *)

findOtherOrder[ord_] := 
	StringDrop[ToString[otherListSymGrp[[ord]]],1]//
		ToExpression (* determine the order of the 
		symmetry group for an element in otherList *)

fullTable = Module[{i,list},
	list = {};
	AppendTo[list,
		Table[{cyclic,i},{i,3,numOfFigures[cyclic]}]];
	AppendTo[list,
		Table[{dihedral,i},{i,3,numOfFigures[dihedral]}]];
	AppendTo[list,
		Table[{other,i},{i,1,numOfFigures[other]}]];
	Flatten[list,1]//Sort];
	(* complete list of all possible symmetry groups to find
	*)

theGroupName[fig_,ord_] := (*theGroupName[fig,ord] =*)
	Switch[fig,
		cyclic, StringJoin["Z", ToString[ord]],
		dihedral, StringJoin["D", ToString[ord]],
		other, ToString[otherListSymGrp[[ord]]]];
		(* determines the name of the symmetry group of
		a figure *)

theSymmetryGroup[fig_,ord_] := theSymmetryGroup[fig, ord] =
	Module[{gpname, gpletter},
		gpname = theGroupName[fig,ord];
		gpletter = StringTake[gpname,1];
		Switch[gpletter,
			"D", DnAsPermutations[ord],
			"Z", ZnAsPermutations[ord],
			_,"This is not possible"]
	] (* determines the group of permutations for the 
	symmetry group *)

picked = {}; (* keeps track of which figures have been
	already done (drawn) *)

chooseFigure[] := Module[{type,chosen,typename,index,stype},
	If[remaining === {}, remaining = groups];
	chosen = remaining[[Random[Integer,{1, Length[remaining]}]]];
	remaining = ComplementNoSort[remaining,{chosen}];
	index = StringDrop[chosen,1]//ToExpression;
	stype = StringTake[chosen,1];
	type = If[index === 2, 3, If[stype==="Z", 1, 2]];
	typename = typesOfFigures[[type]];
	GroupNumber = Position[groups,chosen]//First//First;
	{figureType,theIndex} = {typename,index};		
	] (* does the random choosing of the figure type
	and order *)
	
chooseFigure[n_Integer] := Module[{type,chosen,typename,index,stype},
	chosen = groups[[n]];
	remaining = ComplementNoSort[remaining,{chosen}];
	index = StringDrop[chosen,1]//ToExpression;
	stype = StringTake[chosen,1];
	type = If[index === 2, 3, If[stype==="Z", 1, 2]];
	typename = typesOfFigures[[type]];
	GroupNumber = Position[groups,chosen]//First//First;
	{figureType,theIndex} = {typename,index};		
	] (* takes care of finding a previously used group, numbered n *)

(*chooseFigure[] := Module[{found = False, type,typename,index},
	While[Not[found],
		type = Random[Integer,{1,3}];(* note that other
			is 'weighted' to being chosen sooner *)
		typename = typesOfFigures[[type]];
		index = Switch[typename,cyclic, 
			Random[Integer, {3,numOfFigures[cyclic]}],
			dihedral, 
			Random[Integer, {3,numOfFigures[dihedral]}],
			other,
			Random[Integer, {1,numOfFigures[other]}]];
		found = Not[MemberQ[picked, {typename,index}]];
		If[Union[picked] == fullTable, 
			fullcount = fullcount + Length[picked];picked = {}];
	];
	AppendTo[picked, {typename,index}];
	{figureType,theIndex} = {typename,index};		
	] *)(* does the random choosing of the figure type
	and order *)

fromCycles[cyc_List] :=
           Last /@ Sort[Transpose[Flatten /@ {RotateRight /@ cyc, cyc}]]
(* from DiscreteMath`Permutations - quick and dirty form *)

makeLambda[(n_Integer)?OddQ] := Module[{i, list = {}}, 
   Do[AppendTo[list, {i, n - i}], {i, (n - 1)/2}]; 
   AppendTo[list, {n}]; 
   fromCycles[list] (* this is the reflection element
   used in forming the dihedral group *)
]

makeLambda[(n_Integer)?EvenQ] := Module[{i, list = {}}, 
   Do[AppendTo[list, {i, n - i}], {i, n/2 - 1}]; 
   AppendTo[list, {n}]; 
   AppendTo[list, {n/2}]; 
   fromCycles[list](* this is the reflection element
   used in forming the dihedral group *)
]

ZnAsPermutations[2] = {{1,2,3,4},{3,4,1,2}};

ZnAsPermutations[(n_Integer)?Positive] := 
	ZnAsPermutations[n] = Module[{i, list = {Range[n]}, 
		iden = Range[n]}, 
    Do[AppendTo[list, RotateRight[iden, i]], 
    	{i, n - 1}]; 
    list]

DnAsPermutations[1] = {{1,2,3,4},{3,4,1,2},{2,1,4,3},
	{4,3,2,1}};

permutationComposition=Module[{k},
	Map[Function[k,Part[#1,k]],#2]&];

DnAsPermutations[(n_Integer)?Positive] := 
	DnAsPermutations[n] = Module[{list, i, 
		zn = ZnAsPermutations[n]}, 
	list = zn;
	Do[AppendTo[list, 
   		(*MultiplyPermutations*)permutationComposition[makeLambda[n], zn[[i]]]], 
        {i, n}]; 
	list]

ShowOne[Lab2] :=
	Module[{ind,perm,typ},
		chooseFigure[];
		MySymmetryGroup = {};
		Xpermlist = {};
		Switch[figureType,
			cyclic, {ShowFigure[theIndex,Range[theIndex],
				"Z"],StringJoin["Attempts: ",
					ToString[Length[picked]+fullcount],"; group #: ",ToString[GroupNumber]]},
			dihedral, {ShowFigure[theIndex,Range[theIndex],"D"],
					StringJoin["Attempts: ",
					ToString[Length[picked]+fullcount],"; group #: ",ToString[GroupNumber]]},
			other, Switch[theIndex,
				1, {ShowFigure[2,Range[4],"D"],StringJoin["Attempts: ",
					ToString[Length[picked]+fullcount],"; group #: ",ToString[GroupNumber]]},
				2, {ShowFigure[2,Range[4],"Z"],StringJoin["Attempts: ",
					ToString[Length[picked]+fullcount],"; group #: ",ToString[GroupNumber]]}
					]
		]
	]
	
ShowOne[Lab2] :=
	Module[{ind,perm,typ},
		chooseFigure[];
		MySymmetryGroup = {};
		Xpermlist = {};
		{ind,perm,typ} = Switch[figureType,
			cyclic, {theIndex, Range[theIndex],"Z"},
			dihedral, {theIndex, Range[theIndex],"D"},
			other, Switch[theIndex,
				1, {2,Range[4],"D"},
				2, {2,Range[4],"Z"}]];
		{ShowFigure[ind,perm,typ],StringJoin["Attempts: ",
					ToString[Length[groups]-Length[remaining]],"; group #: ",ToString[GroupNumber]]}
	]
	
ShowOne[Lab2, n_Integer] :=
	Module[{ind,perm,typ},
		chooseFigure[n];
		MySymmetryGroup = {};
		Xpermlist = {};
		{ind,perm,typ} = Switch[figureType,
			cyclic, {theIndex, Range[theIndex],"Z"},
			dihedral, {theIndex, Range[theIndex],"D"},
			other, Switch[theIndex,
				1, {2,Range[4],"D"},
				2, {2,Range[4],"Z"}]];
		{ShowFigure[ind,perm,typ],StringJoin["Attempts: ",
					ToString[Length[groups]-Length[remaining]],"; group #: ",ToString[GroupNumber]]}
	]
	
AddPermToGroup[p_?PermutationQ] :=
	MySymmetryGroup = Union[AppendTo[MySymmetryGroup,p]]
	
AddPermToGroup[p_?myRuleQ] :=
	MySymmetryGroup = Union[AppendTo[MySymmetryGroup,
		ToPermutation[p]]]

DropPermFromGroup[p_?PermutationQ] :=
	MySymmetryGroup=Drop[MySymmetryGroup,
		Flatten[Position[MySymmetryGroup,p]]]

DropPermFromGroup[p_?myRuleQ] :=
	MySymmetryGroup=Delete[MySymmetryGroup,
		Flatten[Position[MySymmetryGroup,
		ToPermutation[p]]]]

TestPermutationQ[p_?PermutationQ] :=
	MemberQ[theSymmetryGroup[figureType,theIndex],p]

TestPermutationQ[p_?myRuleQ] :=
	MemberQ[theSymmetryGroup[figureType,theIndex],ToPermutation[p]]

CompleteGroupQ[] := Module[{same,diff},
	diff = Length[theSymmetryGroup[figureType,theIndex]]-
		Length[MySymmetryGroup];
	same = SameSetQ[theSymmetryGroup[figureType,theIndex], 
		MySymmetryGroup];
	If[same,Print["Good job! You found them all."]];
	If[Not[GoodGroupElementsQ[]],
		Print["You have added some elements which are not in the
group. You need to check what you have added. You may wish to
try TestPermutationQ and then DropPermFromGroup."]];
	If[diff>0,Print["You may need ", diff, " more."]];
	same
	]
	
GoodGroupElementsQ[] := SubsetQ[MySymmetryGroup, theSymmetryGroup[figureType,
	theIndex]]
	

ManyRulesQ[rules_] := Head[rules[[1]]] === List

RestrictList[rules_?ManyRulesQ] := Module[{i,perms,len,temp},
	len = Length[rules];
	perms = doRestricting[rules[[1]]];
	Do[temp = doRestricting[rules[[i]]];
		perms = Intersection[perms,temp],{i,2,len}];
	perms//TableForm]
	
OneruleQ[rule_] := Head[rule[[1]]] === Rule

doRestricting[rule_?OneruleQ] := Module[{i,temp={}},
	Do[If[StringMatchQ[Xpermlistppp[[i]],
		StringJoin["*",ToString[rule],"*"]],
		AppendTo[temp,Xpermlistppp[[i]]]],
			{i,Length[Xpermlistppp]}];
	temp]
	
RestrictList[rule_?OneruleQ] := doRestricting[rule]//TableForm
		
permutationToRules[perm_?PermutationQ] :=  
 	MapThread[Rule,{Range[Length[perm]],perm}]

RestrictList[rule_Rule] := RestrictList[{rule}]
makeXpermlist[n_Integer] := Module[{i,perms},
	If[n < 6, (* do it, otherwise forget it *)
	perms = Permutations[Range[If[n==2,4,n]]];
	Xpermlist = Map[permutationToRules,perms];
	];
	Xpermlist]
	
ShowPossiblePermsAsRules[n_Integer?Positive] := 
	Module[{ord, i, perm,temp},
		If[n==2,ord = 4!,ord = n!];
		If[n > 5,Print["No way am I going to show you all ",
			n!," possibilities!"],
		Xpermlistppp = {};
		temp = makeXpermlist[n];
    	Do[ppp[i] = temp[[i]]; 
       		AppendTo[Xpermlistppp, 
       			StringJoin["ppp[",ToString[i],"] = ",
       				ToString[ppp[i]]]];
       		Print[Last[Xpermlistppp]], {i, ord}]; 
    	]
 	]
ShowPossiblePermutations[n_Integer?Positive] := 
	Module[{ord, i, perm},
		If[n==2,ord = 4!,ord = n!];
		If[n > 5,Print["No way am I going to show you all ",
				n!," possibilities!"],
			perm = Permutations[Range[If[n==2,4,n]]];
			Xpermlist = {};
    		Do[ppp[i] = perm[[i]]; 
       			AppendTo[Xpermlist, 
       				StringJoin["ppp[",ToString[i],"] = ",
       				ToString[perm[[i]]]]];
       			Print[Last[Xpermlist]], {i, ord}]; 
    	]
 	]
	

picked = {};

numGroups = 22;

chooseIndex[] := Module[{new = False, i},
	While[!new,
		i = 1+Random[Integer, numGroups-1];
		new = !MemberQ[picked,i];
		If[Union[picked] == Range[1,numGroups],picked = {}];
	];
	AppendTo[picked,i];
	i
]

ShowOne[Lab3] := Module[{i},
	i = chooseIndex[];
	Clear[op];
	op = LG[i][[2]];
	Print["The alleged group consists of the
	set of elements"];
	Print[LG[i][[1]]];
	Print[StringJoin[" and the operator is ",ToString[op],
	". This is case number ",ToString[i],
	". Below is the Cayley table for this alleged group."]];
	If[i==20 || i==23,Print[StringJoin["Note that a 2x2 matrix",
		" is written as {{a,b},{c,d}}, so this is a list of these"]]];
	CayleyTable[LG[i],Mode -> Visual,
		TheSet -> Randomize[LG[i][[1]]]];
];

ShowOne[Lab3, n_Integer] := Module[{i},
	i = n;
	Clear[op];
	op = LG[i][[2]];
	Print["The alleged group consists of the
	set of elements"];
	Print[LG[i][[1]]];
	Print[StringJoin[" and the operator is ",ToString[op],
	". This is case number ",ToString[i],
	". Below is the Cayley table for this alleged group."]];
	If[i==20 || i==23,Print[StringJoin["Note that a 2x2 matrix",
		" is written as {{a,b},{c,d}}, so this is a list of these"]]];
	CayleyTable[LG[i],Mode -> Visual,
		TheSet -> Randomize[LG[i][[1]]]];
];

CollectOrders[list_List] := Module[{temp,ords,el,i},
	temp = Sort[Map[Reverse,list]];
	ords = temp//Transpose//First//Union;
	Table[{el = ords[[i]],Transpose[Select[temp,
		First[#]===el&]][[2]]}, {i,Length[ords]}]
];

Frequencies[list_List] :=
        Map[ {Count[list, #], #}&, Union[list] ]
(* from Statistics`DataManipulation` *)
        
ShowGroupOrders[G_?GroupoidQ, opts___?OptionQ] :=
	Module[{S =  Elements[G],i,data,mdata,wideQ=False,max, gr, tick},
	Needs["Graphics`Graphics`"];
	If[Not[AbstractAlgebra`Core`Private`untestedQ[AbstractAlgebra`Core`Private`WideElementsQ[G]]],
		wideQ=AbstractAlgebra`Core`Private`WideElementsQ[G],
		If[widthNeeded[Els]>.95,wideQ=True]];
	data = Table[{S[[i]],Order[G,S[[i]]]},{i,Length[S]}];
	max = Max[Transpose[data][[2]]];
	mdata = {Range[Length[S]],Transpose[data][[2]]}//Transpose;
	ListPlot[mdata, PlotStyle -> {PointSize[0.025],
		RGBColor[0,0,1]}, PlotRange -> {{0,Length[S]},
		{0,max}}, Ticks ->
		{Table[{i,If[wideQ,StringJoin["g",ToString[i]],
			ToString[S[[i]]]]},{i,1,Length[S]}],(*Range[0,max]*)
			Transpose[data][[2]]},
			AxesOrigin -> {0,0},
			PlotLabel -> GroupoidName[G]];
	data = Transpose[data]//Last;
	data = Frequencies[data];
	max = Max[Transpose[data][[1]]];
	gr = Graphics`Graphics`BarChart[data, PlotRange -> {0,max+.5},
		Graphics`Graphics`BarLabels -> Transpose[data][[2]],
		Graphics`Graphics`BarValues -> True, Graphics`Graphics`BarStyle -> (Hue[#/max]&),
		DisplayFunction -> Identity];
	tic = FullOptions[gr,Ticks];
	tic = Map[{#[[1]],Rationalize[#[[2]]],#[[3]],#[[4]]}&,
		tic[[1]]];
	Show[gr,Ticks->{tic,Transpose[data][[1]]},
		DisplayFunction -> $DisplayFunction,
		AxesLabel -> {"orders","frequency"}]
]

GroupsToConsider = {{Z,{2,30}},{U,{3,40}},{Dihedral,{2,7}},
	{GaussianUnits}, {IntegerUnits}};
	
numchoices = 29 + 38 + 6 + 1 + 1;
groupfamily[n_] := Which[n <= 29, 1,
	n <= 29 + 38, 2, n <= 29 + 38 + 6, 3, n <= 29 + 38 + 6 + 1, 4, 
	n <= 29 + 38 + 6 + 1 + 1, 5]

Options[ShowOne] = {Verbal -> True};

ShowOne[Lab4,opts___] := Module[{g,n,index,G, temp,verb=True},
	verb = Verbal/.Flatten[{opts, Options[ShowOne]}];
	n = Random[Integer,{1,numchoices}];
	temp = GroupsToConsider[[groupfamily[n]]];
	If[Length[temp]===1,G = Evaluate[temp[[1]]]];
	If[Length[temp]=!=1,G = 
		Evaluate[temp[[1]][Random[Integer,
			{temp[[2,1]],temp[[2,2]]}]]]];
	g = RandomElement[G];
	If[verb,Print[StringJoin["The group's name is ",
		GroupoidName[G],". The
	following pair is the group and a random element."]]];
	{G,g}
]

ListOperationPreservingElements[f_,G1_?GroupoidQ, G2_?GroupoidQ] :=
Module[{els = Elements[G1], op1 = Operation[G1], op2 = 
	Operation[G2]},
Print["g and h are elements in the domain group."];
TableForm[Flatten[Table[{els[[i]],els[[j]],f[op1[els[[i]],els[[j]]]] === 
	op2[f[els[[i]]],f[els[[j]]]]},{i,4},{j,4}],1],
	TableHeadings -> {None,{"g","h","operation-preserving?\n"}},
	TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0],2}]]

ReduceList[in_] := 
	Module[{out, good, bad, temp}, 
		out = Union[in]; 
		good =  First[Transpose[Cases[Transpose[{out, 
			Table[Or @@ (out[[k]] == #1 & ) /@ Complement[out, {out[[k]]}], 
			{k, 1, Length[out]}]}], {a_, False}]]]; 
    bad = Complement[out, good]; 
		temp = Select[Position[Apply[Equal, CartesianProduct[bad, bad,
			Partition -> True], {2}], True], First[#1] =!= Last[#1] & ]; 
    temp = bad[[Map[First, Union[Map[Sort, temp, 1]], 1]]]; 
    Sort[Join[good, temp]]]

Clear[a, b, e, z, pp, qq, u];

GroupoidFunctionComposition[G_?GroupoidQ,funcSet_List,f2_,f1_] := 
	Module[{S= Elements[G],compimage,allimages,n},
compimage = Map[f2,Map[f1,S]];
allimages = Map[Map[#,S]&,funcSet];
n=Position[allimages, compimage]//Flatten//First;
funcSet[[n]]
]

myDiv[a_,b_] := Module[{temp},
	Off[Power::infy];
	Off[Infinity::indet];
	temp = N[a/b,3]/.{Indeterminate -> Ind,
		ComplexInfinity-> CInf};
	On[Power::infy];
	On[Infinity::indet];
	temp]

myPower[a_,b_] := Module[{temp},
	Off[Power::indet];
	temp = Power[a,b]/.{Indeterminate -> Ind};
	On[Power::indet];
	temp]

myDot[a_,b_] := Mod[a[[1]].b[[1]],3]

myMod[a_,b_] := Module[{temp},
	Off[Infinity::trace];
	Off[Mod::divz];
	temp = Mod[a,b] /.Mod[_,0]->undef;
	On[Infinity::trace];
	On[Mod::divz];
	temp]

myDivisorSigma[a_,b_] := DivisorSigma[a,b] /.
	DivisorSigma[_,0]->undef;

trivProd[a_,a_] := a;

compToPr[op1_,op2_] := Module[{z},
	z= Times[Apply[Complex,op1],Apply[Complex,op2]];
	{Re[z],Im[z]}]

compToPr[op1_?MatrixQ,op2_] := 
	Module[{i,len=Length[op1],newlist={}},
	For[i=1,i<=len, i++,AppendTo[newlist,
		compToPr[op1[[i]],op2]]];
	newlist
	]

compToPr[op1_,op2_?MatrixQ] := 
	Module[{i,len=Length[op2],newlist={}},
	For[i=1,i<=len, i++,AppendTo[newlist,
		compToPr[op1,op2[[i]]]]];
	newlist
	]

AbstractAlgebra`Groupoids`Private`CyclicProd[a_^b_:1,c_^d_:1, order_Integer?Positive] := 
	Which[a===1 && c===1, 1,
		a===1 && c=!=1, c^Mod[d,order],
		a=!=1 && c===1, a^Mod[b,order],
		a=!=1 && c=!=1 && a===c, c^Mod[b+d,order],
		(* note in this case, a = c *)
		True,Print["Nonsense!"]
	];

SetAttributes[AbstractAlgebra`Groupoids`Private`CyclicProd,Listable]

myZees[a_,b_] := AbstractAlgebra`Groupoids`Private`CyclicProd[a,b,4];

D1Prod[Global`pp,Global`qq] := Global`pp; 
D1Prod[Global`pp,Global`pp] := Global`qq; 
D1Prod[Global`qq,Global`pp] := Global`pp; 
D1Prod[Global`qq,Global`qq] := Global`qq;

D2Prod[a_,b_] := Times[a,b] //. _^_?EvenQ -> 1 //.
	 c_^_?OddQ :> c

D2Prod2[a_,b_] := Times[a,b] //. _^_?EvenQ -> "e" //.
	 c_^_?OddQ :> c //. x_ e -> x //. a b -> "c" //.
	 b c -> "a" //. a c -> "b"


theSet[1] = {2,1,3};
theSet[2] = Range[0,3];
theSet[3] = {1,3,5,7};
theSet[4] = {I,-1,1,-I};
theSet[5] = {1,Global`z,Global`z^2,Global`z^3};
theSet[6] = {4,0,1,3,2};
theSet[7] = {1, Global`a, Global`b, Global`a Global`b};
theSet[8] = {{1,0},{0,1},{-1,0},{0,-1}};
theSet[9] = {{{1,0},{0,1}},
	{{1,1},{0,1}},
	{{1,2},{0,1}}};
theSet[10] = {Global`p, Global`q};
theSet[11] = {Global`u};
theSet[12] = {Global`e, Global`a, Global`a^2, Global`a^3, Global`b, Global`b Global`a, Global`b Global`a^2, Global`b Global`a^3};
theSet[13] = Permutations[{1,2,3}];
quatTable = {{Global`e, Global`a, Global`a^2, Global`a^3, Global`b, Global`b Global`a, Global`b Global`a^2, Global`b Global`a^3},
	{Global`a, Global`a^2, Global`a^3, Global`e, Global`b Global`a^3, Global`b, Global`b Global`a, Global`b Global`a^2},
	{Global`a^2, Global`a^3, Global`e, Global`a, Global`b Global`a^2, Global`b Global`a^3, Global`b, Global`b Global`a},
	{Global`a^3, Global`e, Global`a, Global`a^2, Global`b Global`a, Global`b Global`a^2, Global`b Global`a^3, Global`b},
	{Global`b, Global`b Global`a, Global`b Global`a^2, Global`b Global`a^3, Global`a^2, Global`a^3, Global`e, Global`a},
	{Global`b Global`a, Global`b Global`a^2, Global`b Global`a^3, Global`b,Global`a, Global`a^2, Global`a^3, Global`e},
	{Global`b Global`a^2, Global`b Global`a^3, Global`b, Global`b Global`a, Global`e, Global`a, Global`a^2, Global`a^3},
	{Global`b Global`a^3, Global`b, Global`b Global`a, Global`b Global`a^2, Global`a^3, Global`e, Global`a, Global`a^2}};
Do[quatOp[theSet[12][[i]],theSet[12][[j]]] = 
	quatTable[[i,j]],{i,8},{j,8}];

LG[1] := FormGroupoid[{2,1,3}, Mod[#1 + #2,6]&,"+", GroupoidName -> "LG[1]"];

LG[2] := FormGroupoid[Range[0,3], Mod[#1 + #2,4]&,"+", GroupoidName -> "LG[2]"];

LG[3] := FormGroupoid[{1,3,5,7}, Mod[#1 #2,8]&, GroupoidName -> "LG[3]"];

LG[4] := FormGroupoid[{1,3,5,7}, Mod[#1 + #2,8]&,"+", GroupoidName -> "LG[4]"];

LG[5] := FormGroupoid[{I,-1,1,-I}, Times, GroupoidName -> "LG[5]"];

LG[6] := FormGroupoid[{1,3,5,7}, Plus,"+", GroupoidName -> "LG[6]"];

LG[7] := FormGroupoid[{1,Global`z,Global`z^2,Global`z^3}, myZees, 
	GroupoidName -> "LG[7]"];
	
LG[8] := FormGroupoid[{Global`e, Global`a, Global`a^2, 
	Global`a^3, Global`b, Global`b Global`a, Global`b Global`a^2, 
	Global`b Global`a^3}, quatOp, GroupoidName -> "LG[8]"];
	
LG[9] := FormGroupoid[{4,0,1,3,2}, Times, GroupoidName -> "LG[9]"];

LG[10] := FormGroupoid[{4,0,1,3,2}, Plus,"+", GroupoidName -> "LG[10]"];

LG[11] := FormGroupoid[{4,0,1,3,2}, Mod[#1 + #2,5]&,"+", GroupoidName -> "LG[11]"];

LG[12] := FormGroupoid[{4,0,1,3,2}, Mod[#1 #2,5]&, GroupoidName -> "LG[12]"];

LG[13] := FormGroupoid[{4,0,1,3,2}, Subtract,"-", GroupoidName -> "LG[13]"];

LG[14] := FormGroupoid[{4,0,1,3,2}, myDiv,"/", GroupoidName -> "LG[14]"];

LG[15] := FormGroupoid[{4,0,1,3,2}, myPower,"^", GroupoidName -> "LG[15]"];

LG[16] := FormGroupoid[{4,0,1,3,2}, myMod, GroupoidName -> "LG[16]"];

LG[17] := FormGroupoid[{4,0,1,3,2}, Binomial, GroupoidName -> "LG[17]"];

LG[18] := FormGroupoid[{4,0,1,3,2}, myDivisorSigma, GroupoidName -> "LG[18]"];

LG[19] := FormGroupoid[{Global`pp, Global`qq}, D1Prod, GroupoidName -> "LG[19]"];

LG[20] := FormGroupoid[{{{1,0},{0,1}},
	{{1,1},{0,1}},
	{{1,2},{0,1}}}, myDot, WideElements -> True, GroupoidName -> "LG[20]"];

LG[22] := FormGroupoid[{1, Global`a, Global`b, Global`a Global`b}, D2Prod, 
	GroupoidName -> "LG[22]"];

LG[21] := FormGroupoid[{Global`u}, trivProd, GroupoidName -> "LG[21]"];
(*LG[21] := {{{1,0},{0,1},{-1,0},{0,-1}}, compToPr}; needs repair - 
in particular the Thread is going to deep into the list and 
causing 4-tuples. *)
numGroups := 22;  (* this is the number of potential groups *)

End[];

EndPackage[];

DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];