(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     30099,        605]*)
(*NotebookOutlinePosition[     54637,       1491]*)
(*  CellTagsIndexPosition[     54533,       1484]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[{
    \(NeedsOperandQ\ \  := \ \(! \ \ NeedsOperatorQ\); \ \n
    EqualsLastQ\  = \ False; \nCalculatorNumber\  = \ 0; \n
    \n (*\ The\ following\ are\ functions\ that\ various\ buttons\ call\ *) 
      \n (*\ This\ first\ collection\ are\ on\ the\ actual\ GroupCalculator
        \ *) \n\nPushOperand[elm_, \ \ tag_]\ \  := \ 
      Module[{nb, \ el\ \  = \ \ elm[\([1]\)]}, \ \n\t
        If[NeedsOperandQ, \ \n\t\tnb\ \  = \ SelectedNotebook[]; \ \n\t\t
          NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
            AutoScroll\  -> \ False]; \ \n\t\t
          If[Operands\ \  === \ \ {}, PushClear[tag]]; \ \n\t\t
          SelectionMove[nb, \ After, \ CellContents, 
            AutoScroll\  -> \ False]; \n\t\t
          NotebookWrite[nb, \ Cell[FormBox[el, \ StandardForm]], 
            AutoScroll\  -> \ False]; \ \n\t\tAppendTo[Operands, \ \ elm]; \ 
          \n\t\tNeedsOperatorQ\ \  = \ \ True; \n\t\tEqualsLastQ\  = \ False; 
          \ ]]\n\), 
    \(\ PushRandEl[\ tag_]\ \  := \ \ 
      Module[{nb, \ el}, \ \ \ \n\t
        If[NeedsOperandQ, \ \ \n\t\tnb\ \  = \ SelectedNotebook[]; \ \n\t\t
          NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
            AutoScroll\  -> \ False]; \ \n\t\t
          If[Operands\ \  === \ \ {}, \ PushClear[tag]]; \ \n\t\t
          SelectionMove[nb, \ After, \ CellContents, 
            AutoScroll\  -> \ False]; \ \n\t\t
          el\ \  = \ \ 
            randElement[pushedGroup\  // \ Elements]\  // \ ToBoxes; \ \n\t\t
          NotebookWrite[nb, \ Cell[FormBox[el, \ StandardForm]], 
            AutoScroll\  -> \ False]; \ \n\t\tel\ \  = \ el\  // \ BoxData; \ 
          \n\t\tAppendTo[Operands, \ \ el]; \n\t\t
          NeedsOperatorQ\ \  = \ \ True; \n\t\tEqualsLastQ\  = \ False; \ ]]\ 
    \n\), 
    \(\ PushBinOp[tag_]\  := \ 
      Module[{nb}, \ \ \n\t
        If[NeedsOperatorQ\  || \ EqualsLastQ, \ \n\t\t
          nb\ \  = \ SelectedNotebook[]; \ \n\t\t
          NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
            AutoScroll\  -> \ False]; \n\t\t
          If[EqualsLastQ, \ PushBinOpWithResult[tag, \ nb]]; \ \n\t\t
          SelectionMove[nb, After, CellContents, AutoScroll\  -> \ False]; \n
          \t\tNotebookWrite[nb, \ \ TextData[{"\< \>", opSymb, "\< \>"}], \ 
            AutoScroll\  -> \ False]; \n\t\tNeedsOperatorQ\  = \ False; \n\t\t
          EqualsLastQ\  = \ False; ]]\n\), 
    \(PushBinOpWithResult[tag_, \ nb_]\  := \ 
      Module[{el\  = \ groupResult}, \n\tClearCell[tag]; \n\t
        SelectionMove[nb, \ After, \ CellContents, AutoScroll\  -> \ False]; 
        \n\tNotebookWrite[nb, \ Cell[FormBox[el // First, \ StandardForm]], 
          AutoScroll\  -> \ False]; \ \n\tAppendTo[Operands, \ el]; \n]\n\), 
    \(\ PushEqual[tag_]\  := \ 
      Module[{nb, g, ops, el}, \ \ \n\t
        If[NeedsOperatorQ, \ \n\t\tnb\ \  = \ SelectedNotebook[]; \ \n\t\t
          NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
            AutoScroll\  -> \ False]; \ \n\t\t
          ops\  = \ Map[ToExpression, Operands]; \n\t\t
          SelectionMove[nb, After, CellContents, AutoScroll\  -> \ False]; \n
          \t\tg\  = \ Fold[Operation[pushedGroup], First[ops], Rest[ops]]; \n
          \t\tel\  = \ g // ToBoxes; \n\t\t
          NotebookWrite[nb, TextData[{"\< = \>"}], AutoScroll\  -> \ False]; 
          \n\t\tNotebookWrite[nb, Cell[FormBox[el, StandardForm]], 
            AutoScroll\  -> \ False]; \n\t\tNeedsOperatorQ\  = \ False; \n\t\t
          Operands\  = \ {}; \n\t\tEqualsLastQ\  = \ True; \n\t\t
          groupResult\  = \ BoxData[el]]]; \n\n\ \ 
    WipeLastItem[tag_]\  := \ 
      Module[{nb, read}, \n\t\tnb\ \  = \ SelectedNotebook[]; \ \n\t\t
        NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
          AutoScroll\  -> \ False]; \ \n\t\t
        SelectionMove[nb, All, CellContents, AutoScroll\  -> \ False]; \n\t\t
        read\  = \ NotebookRead[nb]; \n\t\t
        If[Head[read]\  === \ List, \n\t\t\t
          NotebookWrite[nb, TextData[Drop[read, \(-1\)]], 
            AutoScroll\  -> \ False], \n\t\t\tNotebookDelete[nb]]; \n\t\t
        SelectionMove[nb, After, CellContents, AutoScroll\  -> \ False]; \n
        \t\tnb]\n\), 
    \(PushInverse[tag_]\  := \ 
      Module[{nb, g, \ inv}, \ \ \n\t
        If[NeedsOperatorQ, \n\t\tnb\  = WipeLastItem[tag]; \n\t\t
          g\  = \ Last[Operands]; \n\t\t
          inv\  = \ GroupInverse[pushedGroup, ToExpression[g]]; \n\t\t
          Operands\  = \ 
            Join[Drop[Operands, \(-1\)], {BoxData[ToBoxes[inv]]}]; \n\t\t
          NotebookWrite[nb, Cell[FormBox[ToBoxes[inv], StandardForm]], 
            AutoScroll\  -> \ False]]]\n\), 
    \(PushSquare[tag_]\  := \ 
      Module[{nb, g, sq}, \ \ \n\t
        If[NeedsOperatorQ, \ \n\t\tnb\  = WipeLastItem[tag]; \n\t\t
          g\  = \ \(Last[Operands] // First\) // ToExpression; \n\t\t
          sq\  = \ \(Operation[pushedGroup]\)[g, g]; \n\t\t
          Operands\  = \ 
            Join[Drop[Operands, \(-1\)], {BoxData[ToBoxes[sq]]}]; \n\t\t
          NotebookWrite[nb, Cell[FormBox[ToBoxes[sq], StandardForm]], 
            AutoScroll\  -> \ False]]]\n\), 
    \(\ PushDelete[tag_]\  := \ 
      Module[{nb}, \ \ \n\t
        \(If[Operands\ \  =!= \ \ {}, \n\t\t\tnb\  = WipeLastItem[tag]; \n
          \t\t\tNeedsOperatorQ\  = \ \(! \ NeedsOperatorQ\); \n\t\t\t
          If[NeedsOperandQ, \ Operands\  = \ \ Drop[Operands, \(-1\)]]]; \)]\n
    \), 
    \(\ PushClear[tag_]\  := \ 
      Module[{nb}, \ \ \n\tnb\ \  = \ SelectedNotebook[]; \n\t
        ClearCell["\<memory\>"]; \n\t
        NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
          AutoScroll\  -> \ False]; \ \n\tOperands\  = \ {}; \n\t
        NeedsOperatorQ\  = \ False; \n\t
        SelectionMove[nb, All, CellContents, AutoScroll\  -> \ False]; \n\t
        NotebookDelete[nb]; \n\tgroupResult\  = \ BoxData["\<\>"]; \n\t
        MemoryItem\  = \ "\<\>"; ]\n\), 
    \(ClearCell[tag_]\  := \ 
      Module[{nb}, \ \ \n\t\tnb\ \  = \ SelectedNotebook[]; \ \n\t\t
        NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
          AutoScroll\  -> \ False]; \ \n\t\t
        SelectionMove[nb, All, CellContents, AutoScroll\  -> \ False]; \n\t\t
        NotebookDelete[nb]]; \n\n\ 
    PushStore[tag_]\  := \ 
      Module[{nb, \ ok\  = \ False, \ item}, \ \ \n\t
        If[NeedsOperatorQ, \n\t\t\tok\  = \ True; \n\t\t\t
          MemoryItem\  = \ \(item\  = \ Last[Operands] // First\)]; \n\t
        If[NeedsOperandQ\  && \ Operands\  === {}, \n\t\t\tok\  = \ True; \n
          \t\t\tMemoryItem\  = \ \(item\  = groupResult // First\)]; \n\t
        If[ok, \n\t\tnb\ \  = \ SelectedNotebook[]; \ \n\t\t
          NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
            AutoScroll\  -> \ False]; \ \n\t\t
          SelectionMove[nb, All, CellContents, AutoScroll\  -> \ False]; \n
          \t\tNotebookDelete[nb]; \n\t\t
          NotebookWrite[nb, Cell[FormBox[item, StandardForm]], 
            AutoScroll\  -> \ False]]]\n\), 
    \(PushRecall[tag_]\ \  := \ 
      Module[{nb, \ el\ \  = \ MemoryItem}, \ \n\t
        If[NeedsOperandQ\  && \ MemoryItem\  =!= \ "\<\>", \ \n\t\t
          nb\ \  = \ SelectedNotebook[]; \ \n\t\t
          NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
            AutoScroll\  -> \ False]; \ \n\t\t
          If[Operands\ \  === \ \ {}, \ PushClear[tag]]; \ \n\t\t
          SelectionMove[nb, \ After, \ CellContents, 
            AutoScroll\  -> \ False]; \n\t\t
          NotebookWrite[nb, \ Cell[FormBox[el, \ StandardForm]], 
            AutoScroll\  -> \ False]; \ \n\t\t
          AppendTo[Operands, \ \ BoxData[el]]; \ \n\t\t
          NeedsOperatorQ\ \  = \ \ True; \ ]]; \ \n
    \n (*\ The\ following\ functions\ provide\ functionality\ for\ the\ 
        initial\ GroupCalculator\ \(palette . \)\ *) \n\n
    groupString[Zn]\  = \ \*"\"\<\!\(\[DoubleStruckCapitalZ]\_n\)\>\""; \n
    groupString[Un]\  = \ \*"\"\<\!\(U\_n\)\>\""; \n
    groupString[Dn1]\  = \ \*"\"\<\!\(D\_n\)\>\""; \n
    groupString[Dn2]\  = \ \*"\"\<\!\(D\_n\)\>\""; \n
    groupString[Sn]\  = \ \*"\"\<\!\(S\_n\)\>\""; \n
    groupString[An]\  = \ \*"\"\<\!\(A\_n\)\>\""; \n\nindices[Zn]\  = \ 30; \n
    indices[Un]\  = \ 45; \nindices[Dn1]\  = \ 7; \nindices[Dn2]\  = \ 9; \n
    indices[Sn]\  = \ 4; \nindices[An]\  = \ 5; \n\n
    DisplayIndices[n_, \ nb_]\  := \n\t
      NotebookWrite[nb, \t
        Cell[BoxData[
            RowBox[Join[{"\<Choose an index for the group:\>"}, \ 
                Map[ButtonBox[#, ButtonSource -> ButtonContents, \n
                      \t\t\t\t\t\t\t\t\ \ 
                      ButtonFunction :> 
                        \((PushIndex[ToExpression[#], "\<group2use\>"]&)\), \n
                      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
                      ButtonEvaluator -> "\<Automatic\>"]&, 
                  Table[i, {i, n}]]]]], \n\t\t\t\t\t\t\ Active -> True, 
          AutoIndent -> True, \ LineIndent -> 0, FontFamily -> "\<Courier\>", 
          FontWeight -> "\<Plain\>", FontSize\  -> \ 14, \ 
          TextAlignment -> Center, LineSpacing -> {1.25, \ 0}, 
          ShowCellBracket -> False, \ CellTags\  -> \ "\<indices\>"], 
        AutoScroll\  -> \ False]\n\), 
    \(PushGroup[G_, tag_]\  := \ 
      Module[{nb, groupMessage}, \n\tgroupFamily\  = \ G; \n\t
        groupMessage\  = 
          groupString[groupFamily]<>"\< - now choose a value for n\>"; \n\t
        nb\ \  = \ SelectedNotebook[]; \ \n\t
        NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
          AutoScroll\  -> \ False]; \ \n\t
        SelectionMove[nb, All, CellContents, AutoScroll\  -> \ False]; \n\t
        NotebookWrite[nb, \ 
          Cell[FormBox[groupMessage, StandardForm], FontSize\  -> \ 14], 
          AutoScroll\  -> \ False]; \n\t
        NotebookFind[nb, "\<indices\>", \ All, \ CellTags, \ 
          AutoScroll\  -> \ False]; \n\t
        SelectionMove[nb, All, Cell, AutoScroll\  -> \ False]; \n\t
        NotebookDelete[nb]; \n\tDisplayIndices[indices[G], nb]; ]\n\), 
    \(PushIndex[n_, tag_]\  := \ \ 
      Module[{nb}, \n\t
        Switch[groupFamily, \n\t\t\t\t\tZn, 
          pushedGroupName\  = \ 
            SubscriptBox["\<\[DoubleStruckCapitalZ]\>", ToString[n]]; \ 
          pushedGroup\  = \ Z[n], \n\t\t\t\t\tUn, 
          pushedGroupName\  = \ SubscriptBox["\<U\>", ToString[n]]; \ 
          pushedGroup\  = \ U[n], \n\t\t\t\t\tDn1, 
          pushedGroupName\  = \ SubscriptBox["\<D\>", ToString[n]]; \n
          \t\t\t\t\t\t\tpushedGroup\  = \ D[n, \ Form\  -> \ Permutations], \n
          \t\t\t\t\tDn2, 
          pushedGroupName\  = \ SubscriptBox["\<D\>", ToString[n]]; \ \ \ \ \ 
          \n\t\t\t\t\t\t\tpushedGroup\  = D[n, \ Form\  -> \ RotRef], \n
          \t\t\t\t\tSn, 
          pushedGroupName\  = \ SubscriptBox["\<S\>", ToString[n]]; \ 
          pushedGroup\  = \ S[n], \n\t\t\t\t\tAn, 
          pushedGroupName\  = \ SubscriptBox["\<A\>", ToString[n]]; \ 
          pushedGroup\  = \ A[n]]; \n\tnb\ \  = \ SelectedNotebook[]; \ \n\t
        NotebookFind[nb, \ tag, \ All, \ CellTags, \ 
          AutoScroll\  -> \ False]; \ \n\t
        SelectionMove[nb, All, CellContents, AutoScroll\  -> \ False]; \n\t
        NotebookWrite[nb, 
          Cell[FormBox[pushedGroupName, StandardForm], FontSize\  -> \ 14], 
          AutoScroll\  -> \ False]; \n\t
        NotebookWrite[nb, 
          Cell["\< - press the bottom button when ready\>", "\<Text\>", 
            FontSize\  -> \ 14], AutoScroll\  -> \ False]]\n\), 
    \(PushInstructions\ \  := \ 
      NotebookPut[\ \ 
        Notebook[{
            Cell[TextData[{\n\ \ 
                  "\<This notebook is used to generate various calculators to
perform elementary group operations with 5 different groups
(ie., families of groups). Making a GroupCalculator is easy
as 1-2-3:\n\n\>", 
                  StyleBox["\<First\>", \ 
                    FontColor\  -> \ RGBColor[0, 0, 1]], 
                  "\<, select one of the families of
groups.(\>", \n\ 
                  StyleBox[
                    "\<Note that the permutation \[Pi] given by {2, 3, 1, 5, \
4}
means \[Pi](1) = 2, \[Pi](2) = 3, \[Pi](3) = 1, \[Pi](4) = 
5, and \[Pi](5) = 4.\>", FontSize -> 12], \n\ \ "\<) \>"\ , 
                  StyleBox["\<Second\>", \ 
                    FontColor\  -> \ RGBColor[0, 0, 1]], 
                  "\<, choose an appropriate index \>", \n\ \ 
                  Cell[BoxData[\ FormBox["\<n\>", \ TraditionalForm]]], \n\ \ 
                  "\< from the list that is generated.\>", 
                  StyleBox["\<Third\>", \ 
                    FontColor\  -> \ RGBColor[0, 0, 1]], "\<, make the
calculator by pressing the last button.\>"}], \ "\<Text\>", \n\ \ 
              FontSize -> 14]}, Editable -> True, \n
          WindowSize -> {180, \ 450}, \n
          WindowMargins -> {{470, \ Automatic}, \ {Automatic, \ 2}}, \n
          WindowFrame -> "\<Palette\>", \nWindowElements -> {}, \n
          WindowFrameElements -> "\<CloseBox\>", \n
          WindowClickSelect -> False, \nShowCellBracket -> False]]; \n\n
    GroupCalculator\  := \ 
      Module[{\ nb2, G\  = pushedGroup, \ square, inv}, \n\t
        NeedsOperatorQ\  = \ False; \n\tOperands\  = \ {}; \n\t
        \(CalculatorNumber++\); \n\ \ MemoryItem\  = \ "\<\>"; \n\t
        opSymb\  = \ OperatorSymbol[G]; \n\t
        inv\  = \ 
          If[opSymb\  === \ "\<+\>", 
            FormBox[\n\ \ \ \ \ \ \ \ RowBox[{"\<-\>", \ "\<x\>"}], \ 
              TraditionalForm], \ 
            FormBox[\n\ \ \ \ \ \ \ \ 
              SuperscriptBox["\<x\>", \ \n\ \ \ \ \ \ \ \ 
                RowBox[{"\<-\>", \ "\<1\>"}]], \ TraditionalForm]]; \n\t
        square\  = \ 
          If[opSymb\  === \ "\<+\>", \ 
            FormBox[\n\ \ \ \ \ \ \ \ RowBox[{"\<2\>", \ "\<x\>"}], \ 
              TraditionalForm], \ 
            FormBox[\n\ \ \ \ \ \ \ \ SuperscriptBox["\<x\>", \ "\<2\>"], \ 
              TraditionalForm]]; \n\t
        nb2\  = \ 
          NotebookCreate[WindowFrame -> "\<Normal\>", 
            WindowSize\  -> \ {480, \ 375}, 
            WindowElements -> {"\<HorizontalScrollBar\>", 
                "\<VerticalScrollBar\>"}, \n\t\t\t\t
            WindowFrameElements -> {"\<CloseBox\>", \ "\<ZoomBox\>", \ 
                "\<ResizeArea\>"}, \n\t
            WindowTitle\  -> 
              "\<GroupCalculator\>"<>ToString[CalculatorNumber], \n\t\t\t\t
            WindowMargins -> {{4, Automatic}, {Automatic, 4}}]; \n\t
        NotebookPut[
          Notebook[{\n\t\t\t
              Cell[RowBox[{"\<A calculator for the group \>", 
                    FormBox[\n\ \ \ \ \ \ \ \ \ \ \ pushedGroupName, \ 
                      TraditionalForm]}], \ "\<Text\>", FontSize\  -> \ 20, 
                TextAlignment -> Center, ShowCellBracket -> False, 
                Editable\  -> \ False, \ Selectable\  -> \ False, \ 
                Deletable\  -> \ False], \n\t\t\t
              Cell["\<\>", \ "\<Text\>", Editable -> True, PageWidth -> 450, 
                \ TextAlignment -> Center, \n\ \ \ \ \ \ \ \ \ 
                Background\  -> \ RGBColor[1, 1, 0], 
                FontColor\  -> \ RGBColor[0, 0, 1], \n\t\t\t\t
                FontSize\  -> \ 14, \ CellTags -> "\<screen\>", 
                ShowCellBracket -> False], \n\t\t\t
              Cell[BoxData[
                  RowBox[Join[{"\<Elements:\>"}, \ 
                      Map[ButtonBox[ToBoxes[#], 
                            ButtonSource -> ButtonContents, \n
                            \t\t\t\t\t\t\t\t\ \ 
                            ButtonFunction :> 
                              \((PushOperand[#, "\<screen\>"]&)\), \n
                            \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
                            ButtonEvaluator -> "\<Automatic\>"]&, \ 
                        Elements[G]]]]], \n
                \t\t\t\t\t\t (*\ NotebookDefault, *) \ Active -> True, 
                AutoIndent -> True, \ ZeroWidthTimes -> False, 
                LineIndent -> 0, FontFamily -> "\<Courier\>", 
                FontWeight -> "\<Plain\>", FontSize\  -> \ 14, \ 
                TextAlignment -> Center, LineSpacing -> {1.25, \ 0}, 
                ShowCellBracket -> False], \n\t\t\t
              Cell[BoxData[
                  GridBox[{{
                        ButtonBox[\n\t\t\topSymb, 
                          ButtonFunction :> PushBinOp[\ "\<screen\>"], \n
                          \t\t\tButtonEvaluator -> "\<Automatic\>"], \ \n
                        \t\t\t\t\t\t\t\t\t\t
                        ButtonBox["\<=\>", 
                          ButtonFunction :> PushEqual[\ "\<screen\>"], \ 
                          ButtonEvaluator -> "\<Automatic\>"], \ \n
                        \t\t\t\t\t\t\t\t\t\t
                        ButtonBox[
                          RowBox[{"\<Random\>", \ "\< \>", \ "\<element\>"}], 
                          ButtonFunction :> PushRandEl[\ "\<screen\>"], \ 
                          ButtonEvaluator -> "\<Automatic\>"]}, \ \n
                      \ \ \ \ \ \ \ \ \ \ {
                        ButtonBox[inv, 
                          ButtonFunction :> PushInverse[\ "\<screen\>"], 
                          ButtonEvaluator -> "\<Automatic\>"], \ \n
                        \t\t\t\t\t\t\t\t\t\t
                        ButtonBox["\<Store\>", 
                          ButtonFunction :> PushStore[\ "\<memory\>"], \ 
                          ButtonEvaluator -> "\<Automatic\>"], \ \n
                        \t\t\t\t\t\t\t\t\t\t
                        ButtonBox[
                          RowBox[{"\<Delete\>", \ "\< \>", \ "\<last\>", \ 
                              "\< \>", \ "\<entry\>"}], 
                          ButtonFunction :> PushDelete[\ "\<screen\>"], \ 
                          ButtonEvaluator -> "\<Automatic\>"]}, \n
                      \ \ \ \ \ \ \ \ \ \ {
                        ButtonBox[square, 
                          ButtonFunction :> PushSquare[\ "\<screen\>"], 
                          ButtonEvaluator -> "\<Automatic\>"], \ 
                        ButtonBox["\<Recall\>", 
                          ButtonFunction :> PushRecall[\ "\<screen\>"], 
                          ButtonEvaluator -> "\<Automatic\>"], \n
                        \ \ \ \ \ \ \ \ 
                        ButtonBox[
                          RowBox[{"\<Clear\>", \ "\< \>", "\<all\>"}], \ 
                          ButtonFunction :> PushClear[\ "\<screen\>"], 
                          ButtonEvaluator -> "\<Automatic\>"]}}, \ 
                    RowSpacings -> 0, ColumnSpacings -> 0]], \ 
                Active -> True, LineSpacing -> {1.25, \ 0}, 
                ShowCellBracket -> False, FontFamily -> "\<Courier\>", \ 
                TextAlignment -> Center, FontWeight -> "\<Plain\>", \ 
                FontSize\  -> \ 14], \n
              Cell["\<\>", \ "\<Text\>", \ Editable\  -> \ True, \ 
                PageWidth -> 150, \ TextAlignment -> Center, \n
                \ \ \ \ \ \ \ \ \ Background\  -> \ RGBColor[1, 1, 0], \ 
                FontColor\  -> \ RGBColor[0, 0, 1], \n\t\t\t\t
                FontSize\  -> \ 14, \ CellTags -> \n"\<memory\>", 
                CellMargins -> {{150, \ \(-150\)}, 
                    \ {Inherited, \ Inherited}}, \ ShowCellBracket -> False, 
                \ CellFrame\  -> \ False], \ \n\t\t\t
              Cell[BoxData[
                  RowBox[{\ 
                      ButtonBox[RowBox[{"\<Help\>"}], 
                        ButtonFunction :> 
                          NotebookPut[\ \ 
                            Notebook[
                              \ {\ Cell[
                                  TextData[{\n\ \ 
                                      "\<This calculator is capable of a few \
basic operations with
group elements. You can choose an element
by simply clicking on the appropriate button reflecting
the desired element. The following explains the other
buttons.
	\n\nFirst Palette:
	\n\tFirst row:\n\t\t+ (or * or  \>", \n\ \ 
                                      StyleBox["\<\[Degree]\>", \ 
                                        FontSize -> 14], 
                                      "\<) \[Rule] This is the binary \
operator symbol 
	for the group at hand; it must follow an element.
\n\t\t= \[Rule] This will calculate the value
of the sum or product in the display.
\n\t\tRandom Element \[Rule] This produces a random element
from the group.	\n\tSecond row:\n\t\t\>", \n\ \ 
                                      Cell[BoxData[\ 
                                        FormBox[RowBox[{"\<-\>", \ "\<x\>"}], 
                                        \ TraditionalForm]]], \n\ \ 
                                      "\< (or \>", \ 
                                      Cell[BoxData[
                                        FormBox[
                                        SuperscriptBox["\<x\>", \ 
                                        RowBox[{"\<-\>", \ \n\t"\<1\>"}]], \ 
                                        TraditionalForm]]], \n\ \ 
                                      "\<) \[Rule] This replaces the last \
operand with its 
	inverse (additive or multiplicative, 
	depending on the group).
	\n\t\tStore \[Rule] This will place the last operand (or result) into
	the memory cell below.
	\n\t\tDelete last entry \[Rule] This button deletes the last entry,
	whether an operand or operator.
	\n\tThird row:\n\t\t\>", \n\ \ 
                                      Cell[BoxData[
                                        FormBox[RowBox[{"\<2\>", \ "\<x\>"}], 
                                        \ TraditionalForm]]], \n\ \ 
                                      "\< (or \>", \ 
                                      Cell[BoxData[\ 
                                        FormBox[
                                        SuperscriptBox["\<x\>", \ "\<2\>"], \ 
                                        TraditionalForm]]], \n\ \ 
                                      "\<) \[Rule] This replaces the last \
operand with its
	square (or double).
	\n\t\tRecall \[Rule] This causes the stored value to become an
	operand in the calculation.
		\n\t\tClear all \[Rule] This clears all of the contents
		of the screen.
	\n\nSecond Palette:
	\n\tHelp \[Rule] Brings up this box.
	\n\tCredits \[Rule] Brings up a box indicating authorship and a copyright \
notice.
	\n\n (Note that the permutation given by 
	{2, 3, 1} means {1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 1}.)\>"}], \ 
                                  "\<Text\>"]}, \ \n
                              \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
                              ShowCellBracket\  -> \ False, \ 
                              WindowClickSelect\  -> \ False, \ \n
                              \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
                              Editable\  -> \ True, \ 
                              WindowSize\  -> \ {640, \ 390}, \ \n
                              \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
                              WindowMargins\  -> 
                                \ {{Automatic, \ Automatic}, 
                                  \ {Automatic, \ \n
                                    \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
                                    Automatic}}, \ 
                              WindowFrame\  -> \ "\<Palette\>", \ \n\ \ \ \ 
                              WindowElements\  -> \ {}, \ 
                              WindowFrameElements\  -> \ \n\t\t\t\t\t
                                "\<CloseBox\>"]], \ 
                        ButtonEvaluator -> "\<Automatic\>"], \n\t\t
                      ButtonBox[RowBox[{"\<Credits\>"}], 
                        ButtonFunction :> 
                          NotebookPut[\ \ 
                            Notebook[
                              \ {\ Cell[\ \n
                                  TextData[{\ 
                                      "\<This group calculator is brought you \
by \>", \nStyleForm["\<Exploring Abstract Algebra with Mathematica\>", \ 
                                        FontSlant\  -> \ "\<Italic\>"], \n
                                      "\<, \[Copyright]1997 Al Hibbard  \
(hibbarda@central.edu) and 
Ken Levasseur (Kenneth_Levasseur@uml.edu). Check
out the web page at \n\>", \n
                                      StyleBox[
                                        "\<http://www.central.edu/EAAM.html \
\>", \ FontColor\  -> \ \nRGBColor[0, 0, 1]], "\<\nfor information 
on available labs, packages and a forthcoming book.\>"}], \ "\<Text\>", \ 
                                  FontSize\  -> \ 14]}, \ \n
                              ShowCellBracket\  -> \ False, \ 
                              WindowClickSelect\  -> \ False, \ \ \n
                              Editable\  -> \ True, \ 
                              WindowSize\  -> \ {425, \ 140}, \ 
                              WindowMargins
                                \  -> {{Automatic, \ Automatic}, 
                                  \ {Automatic, \ \ Automatic}}, \ 
                              WindowFrame\  -> \ "\<Palette\>", \ 
                              WindowElements\  -> \ {}, \ 
                              WindowFrameElements\  -> \ "\<CloseBox\>"]], 
                        ButtonEvaluator -> "\<Automatic\>"]}]], \n\t\t\t\t\t
                "\<Text\>", Active -> True, TextAlignment -> Center, 
                ShowCellBracket -> False]}, 
            WindowFrameElements -> {"\<CloseBox\>", \ \ "\<ResizeArea\>"}, 
            WindowMargins -> {{4, Automatic}, {Automatic, 4}}, 
            WindowClickSelect -> False, \ 
            WindowSize\  -> \ {520, \ Automatic}], nb2]; \n\t\t
        NotebookLocate["\<screen\>"]; \n\t\t
        SelectionMove[nb2, After, CellContents]; ]\)}], "Input",
  ShowCellBracket->False,
  CellOpen->True,
  InitializationCell->True],

Cell[TextData[StyleBox["GroupCalculator Generator",
  FontSize->24]], "Title",
  CellFrame->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    ButtonBox[
      \(Instructions\ needed?\ Click\ 
        \(here \( . \n\) \(Otherwise, \ 
          choose\ a\ group\ by\ \(clicking . \)\)\)\),
      ButtonFunction:>PushInstructions,
      ButtonEvaluator->Automatic]], "Input",
  ShowCellBracket->False,
  Active->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[GridBox[{
        {
          
          ButtonBox[
            \(\[DoubleStruckCapitalZ]\_n - \ 
              additive\ group\ of\ integers\ mod\ n\),
            ButtonFunction:>PushGroup[ Zn, "group2use"],
            ButtonEvaluator->Automatic]},
        {
          
          ButtonBox[
            \(U\_n\  - \ 
              multiplicative\ group\ of\ units\ in\ 
                \[DoubleStruckCapitalZ]\_n\),
            ButtonFunction:>PushGroup[ Un, "group2use"],
            ButtonEvaluator->Automatic]},
        {
          ButtonBox[\(D\_n\  - Dihedral\ group, \ given\ as\ permutations\),
            ButtonFunction:>PushGroup[ Dn1, "group2use"],
            ButtonEvaluator->Automatic]},
        {
          ButtonBox[\(D\_n\  - \ using\ rotations\ and\ reflections\),
            ButtonFunction:>PushGroup[ Dn2, "group2use"],
            ButtonEvaluator->Automatic]},
        {
          ButtonBox[\(S\_n\  - \ Symmetric\ group\ on\ n\ letters\),
            ButtonFunction:>PushGroup[ Sn, "group2use"],
            ButtonEvaluator->Automatic]},
        {
          
          ButtonBox[
            \(A\_n\  - \ Alternating\ group\ of\ even\ permutations\),
            ButtonFunction:>PushGroup[ An, "group2use"],
            ButtonEvaluator->Automatic]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True],

Cell["", "Text",
  Editable->True,
  PageWidth->320,
  CellMargins->{{48, -38}, {Inherited, Inherited}},
  FontSize->16,
  FontColor->RGBColor[0, 0, 1],
  Background->RGBColor[1, 1, 0],
  CellTags->"group2use"],

Cell["",
  ShowCellBracket->False,
  Active->True,
  GeneratedCell->True,
  AutoIndent->True,
  TextAlignment->Center,
  LineSpacing->{1.25, 0},
  ZeroWidthTimes->False,
  LineIndent->0,
  FontFamily->"Courier",
  FontSize->14,
  FontWeight->"Plain",
  CellTags->"indices"],

Cell[BoxData[
    ButtonBox[\(Make\ the\ GroupCalculator\),
      ButtonFunction:>GroupCalculator,
      ButtonEvaluator->Automatic]], "Input",
  Active->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->{},
InitializationCellLoading->True,
CellGrouping->Manual,
WindowSize->{475, 450},
WindowMargins->{{7, Automatic}, {Automatic, 2}},
WindowFrame->"Palette",
WindowElements->"VerticalScrollBar",
ScrollingOptions->{"PagewiseScrolling"->False,
"PagewiseDisplay"->False,
"RealTimeScrolling"->False},
ShowCellBracket->False,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ScriptMinSize->12,
    FontSize->16],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellBracketOptions->{"Margins"->{1, 1},
    "Widths"->{0, 5}},
    ScriptMinSize->8,
    FontSize->11],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{10, Inherited}, {5, 5}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {12, 30}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{13, 0}, {7, 22}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {2, 2}},
    LineSpacing->{1, 0},
    CounterIncrements->"Text"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    LineSpacing->{1, 3},
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{45, 10}, {3, 3}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}}],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}}],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    FontSize->9,
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5}],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1}],
  
  Cell[StyleData["DisplayFormula", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"]],
  
  Cell[StyleData["Hyperlink", "Condensed"]],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"]],
  
  Cell[StyleData["MainBookLink", "Condensed"]],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"]],
  
  Cell[StyleData["AddOnsLink", "Condensed"]],
  
  Cell[StyleData["AddOnLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"]],
  
  Cell[StyleData["RefGuideLink", "Condensed"]],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"]],
  
  Cell[StyleData["GettingStartedLink", "Condensed"]],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"]],
  
  Cell[StyleData["OtherInformationLink", "Condensed"]],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SelectionPlaceholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->Primary,
    StyleMenuListing->None,
    DrawHighlighted->True],
  
  Cell[StyleData["SelectionPlaceholder", "Presentation"]],
  
  Cell[StyleData["SelectionPlaceholder", "Condensed"]],
  
  Cell[StyleData["SelectionPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    TextAlignment->Left,
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]]
  }, Open  ]]
  }],
MacintoshSystemPageSetup->"\<\
00<00018050000000_02P?oLon`2m0:D0@85:0?l00400018050000000_02P01@
0202P0b001P00@4100000BL?00410@00000000000000000000000@0000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "group2use"->{
    Cell[29447, 576, 210, 7, 36, "Text",
      CellTags->"group2use"]},
  "indices"->{
    Cell[29660, 585, 273, 12, 26, InheritFromParent,
      CellTags->"indices"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"group2use", 54339, 1474},
  {"indices", 54426, 1477}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 25845, 469, 7941, "Input",
  CellOpen->True,
  InitializationCell->True],
Cell[27558, 520, 129, 3, 57, "Title"],
Cell[27690, 525, 322, 9, 44, "Input"],
Cell[28015, 536, 1429, 38, 105, "Input"],
Cell[29447, 576, 210, 7, 36, "Text",
  CellTags->"group2use"],
Cell[29660, 585, 273, 12, 26, InheritFromParent,
  CellTags->"indices"],
Cell[29936, 599, 159, 4, 25, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

