(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     44255,       1237]*)
(*NotebookOutlinePosition[     70086,       2164]*)
(*  CellTagsIndexPosition[     69626,       2145]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox[
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"action", " ", "buttons"}], " ", "-", " ", 
                  RowBox[{"no", " ", "pasting"}]}], ")"}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"first three buttons"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"Needs", "[", "\"\<AbstractAlgebra`Master`\>\"", "]"}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>Needs[ "AbstractAlgebra`Master`"],
            ButtonEvaluator->"Local",
            Background->RGBColor[0.740001, 0.990005, 0.790005],
            ButtonNote->"Loads master package"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"SwitchStructureTo", "[", "Group", "]"}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>SwitchStructureTo[ Group],
            ButtonEvaluator->"Local",
            Background->RGBColor[0.740001, 0.990005, 0.790005],
            ButtonNote->"work with groups"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"SwitchStructureTo", "[", "Ring", "]"}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>SwitchStructureTo[ Ring],
            ButtonEvaluator->"Local",
            Background->RGBColor[0.740001, 0.990005, 0.790005],
            ButtonNote->"work with rings"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"Palettes", " ", 
                RowBox[{"Available", ":"}]}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"click below"]},
        {
          ButtonBox[
            RowBox[{"Help", " ", "with", " ", "the", " ", "palettes"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "HelpPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"Palette Help"]},
        {
          ButtonBox["Groupoids",
            ButtonData:>"groupoids",
            ButtonStyle->"Hyperlink",
            ButtonNote->"list of Groupoids"]},
        {
          ButtonBox[
            RowBox[{"Ringoids", " ", "and", " ", "Morphoids"}],
            ButtonData:>"ringoids",
            ButtonStyle->"Hyperlink",
            ButtonNote->"Ringoids and Morphoids"]},
        {
          ButtonBox[
            RowBox[{"General", " ", "AA", " ", "functions"}],
            ButtonData:>"generalAA",
            ButtonStyle->"Hyperlink",
            ButtonNote->"universal functions"]},
        {
          ButtonBox[
            RowBox[{"Group", " ", "functions"}],
            ButtonData:>"group",
            ButtonStyle->"Hyperlink",
            ButtonNote->"apply to groups"]},
        {
          ButtonBox[
            RowBox[{"Permutation", " ", "functions"}],
            ButtonData:>"permutation",
            ButtonStyle->"Hyperlink",
            ButtonNote->"permutation-related"]},
        {
          ButtonBox[
            RowBox[{"Morphism", " ", "functions"}],
            ButtonData:>"morphism",
            ButtonStyle->"Hyperlink",
            ButtonNote->"morphism-related"]},
        {
          ButtonBox[
            RowBox[{"Ring", " ", "functions"}],
            ButtonData:>"ring",
            ButtonStyle->"Hyperlink",
            ButtonNote->"ring-related"]},
        {
          ButtonBox[
            RowBox[{"Polynomial", " ", "functions"}],
            ButtonData:>"polynomial",
            ButtonStyle->"Hyperlink",
            ButtonNote->"polynomial-related"]},
        {
          ButtonBox[
            RowBox[{"Matrix", " ", "functions"}],
            ButtonData:>"matrix",
            ButtonStyle->"Hyperlink",
            ButtonNote->"matrix-related"]},
        {
          ButtonBox[
            RowBox[{"Galois", " ", "field", " ", "functions"}],
            ButtonData:>"GaloisField",
            ButtonStyle->"Hyperlink",
            ButtonNote->"work with fields"]},
        {
          ButtonBox[
            RowBox[{
              RowBox[{"\[DoubleStruckCapitalZ]", "[", 
                SqrtBox["d"], "]"}], "functions"}],
            ButtonData:>"Z[d]",
            ButtonStyle->"Hyperlink",
            ButtonNote->"special ring functions"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{
              "palettes", " ", "for", " ", "working", " ", "with", " ", 
                RowBox[{"groups", "/", "rings"}]}],
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain"],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "MultiPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            Background->GrayLevel[0.700008],
            ButtonNote->"many palettes"]},
        {
          ButtonBox[
            RowBox[{"Group", " ", "Lab", " ", "Two"}],
            ButtonData:>"GroupLabTwo",
            ButtonStyle->"Hyperlink",
            ButtonNote->"Group Lab Two palette"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"abstractalgebra"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["Groupoids",
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"built-in Groupoids"]},
        {
          ButtonBox[\(Z[\[SelectionPlaceholder]]\),
            ButtonNote->"integers mod n"]},
        {
          ButtonBox[\(Z[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"multiples of a divisor of n"]},
        {
          ButtonBox[\(Z[\[SelectionPlaceholder], I]\),
            ButtonNote->"(add.) Gaussian integers mod n"]},
        {
          ButtonBox[\(Zx[\[SelectionPlaceholder]]\),
            ButtonNote->"mult. integers mod n"]},
        {
          ButtonBox[\(U[\[SelectionPlaceholder]]\),
            ButtonNote->"units in ring Z[n]"]},
        {
          ButtonBox[\(TwistedZ[\[SelectionPlaceholder]]\),
            ButtonNote->"integers mod n w/ twisted operation"]},
        {
          ButtonBox[\(MaxTaker[\[SelectionPlaceholder]]\),
            ButtonNote->"takes maximum"]},
        {
          ButtonBox[\(MinTaker[\[SelectionPlaceholder]]\),
            ButtonNote->"takes minimum"]},
        {
          ButtonBox[\(FirstTaker[\[SelectionPlaceholder]]\),
            ButtonNote->"takes first element"]},
        {
          ButtonBox[\(MeetDivisors[\[SelectionPlaceholder]]\),
            ButtonNote->"uses GCD"]},
        {
          ButtonBox[\(JoinDivisors[\[SelectionPlaceholder]]\),
            ButtonNote->"uses LCM"]},
        {
          ButtonBox[\(\ MixedDivisors[\[SelectionPlaceholder]]\),
            ButtonNote->"uses LCM/GCD"]},
        {
          ButtonBox[\(RootsOfUnity[\[SelectionPlaceholder]]\),
            ButtonNote->"solns. of x^n=1"]},
        {
          ButtonBox[\(Dihedral[\[SelectionPlaceholder]]\),
            ButtonNote->"symmetries of reg. n-gon"]},
        {
          ButtonBox[\(Cyclic[\[SelectionPlaceholder]]\),
            ButtonNote->"cyclic group of order n"]},
        {
          ButtonBox[\(Symmetric[\[SelectionPlaceholder]]\),
            ButtonNote->"permutations on n letters"]},
        {
          ButtonBox[\(\ Alternating[\[SelectionPlaceholder]]\),
            ButtonNote->"even permutations"]},
        {
          ButtonBox[\(QuaternionGroup[]\),
            ButtonNote->"try Form option"]},
        {
          ButtonBox["Klein4",
            ButtonNote->"another version of D[2]"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"groupoids"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox["Ringoids",
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"built-in Ringoids"]},
        {
          ButtonBox[\(BooleanRing[\[SelectionPlaceholder]]\),
            ButtonNote->"ring of subsets"]},
        {
          ButtonBox[\(LatticeRing[\[SelectionPlaceholder]]\),
            ButtonNote->"ring of divisors"]},
        {
          ButtonBox[\(TrivialZR[\[SelectionPlaceholder]]\),
            ButtonNote->"trivial products"]},
        {
          ButtonBox[\(Z[\[SelectionPlaceholder]]\),
            ButtonNote->"Z mod n"]},
        {
          ButtonBox[\(Z[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"multiples of a divisor"]},
        {
          ButtonBox[\(Z[\[SelectionPlaceholder], I]\),
            ButtonNote->"Gaussian integers mod n"]},
        {
          ButtonBox["Morphoids",
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"built-in Morphoids"]},
        {
          ButtonBox[\(InducedCanonical[\[SelectionPlaceholder]]\),
            ButtonNote->"canonical induced morphism"]},
        {
          ButtonBox[\(InducedIsomorphism[\[SelectionPlaceholder]]\),
            ButtonNote->"induced from First Iso. Thm."]},
        {
          ButtonBox[\(Sgn[\[SelectionPlaceholder]]\),
            ButtonNote->"based on Parity function"]},
        {
          ButtonBox[\(ZMap[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"Z[m] to Z[n]"]},
        {
          
          ButtonBox[
            \(ZMap[\[SelectionPlaceholder], \[Placeholder], \ 
              \[Placeholder]\  \[Rule] \[Placeholder]]\),
            ButtonNote->"Z[m] to Z[n] specified by rule"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->{"ringoids", "morphoids"}],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(General\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"general functions"]},
        {
          ButtonBox[\(AssociativeQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it associative?"]},
        {
          
          ButtonBox[
            \(CartesianProduct[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"Cartesian product"]},
        {
          ButtonBox[\(CayleyTable[\[SelectionPlaceholder]]\),
            
            ButtonData:>
              RowBox[ {"CayleyTable", "[", 
                "\[SelectionPlaceholder], Mode \[Rule] Visual", "]"}],
            ButtonNote->"Visual CayleyTable"]},
        {
          ButtonBox[\(CayleyTables[\[SelectionPlaceholder]]\),
            
            ButtonData:>
              RowBox[ {"CayleyTables", "[", 
                "\[SelectionPlaceholder], Mode \[Rule] Visual", "]"}],
            ButtonNote->"Visual CayleyTables"]},
        {
          ButtonBox[\(ClosedQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it closed?"]},
        {
          ButtonBox[\(CosetToList[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"a+NS to {a,..} form"]},
        {
          
          ButtonBox[
            \(DirectProduct[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"for groups or rings"]},
        {
          ButtonBox[\(ElementQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"x \[Element] S?"]},
        {
          ButtonBox[\(Elements[\[SelectionPlaceholder]]\),
            ButtonNote->"list of elements"]},
        {
          
          ButtonBox[
            \(ElementToCoset[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"convert x to coset"]},
        {
          
          ButtonBox[
            \(ElementToPower[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"x^n in S"]},
        {
          ButtonBox[\(\ HasIdentityQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is there an identity?"]},
        {
          ButtonBox[\(HasInversesQ[\[SelectionPlaceholder]]\),
            ButtonNote->"does x have an inverse?"]},
        {
          ButtonBox[\(MultipleOfElement[ ... ]\),
            ButtonData:>RowBox[ {"MultipleOfElement", "[", 
                
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]", 
                  ",", "\[Placeholder]"}], "]"}],
            ButtonNote->"n\[CenterDot]x in S"]},
        {
          ButtonBox[\(RandomElement[\[SelectionPlaceholder]]\),
            ButtonNote->"1 random element"]},
        {
          
          ButtonBox[
            \(RandomElements[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"n random elements"]},
        {
          ButtonBox[\(\ Randomize[\[SelectionPlaceholder]]\),
            ButtonNote->"scramble elements"]},
        {
          ButtonBox[\(Size[\[SelectionPlaceholder]]\),
            ButtonNote->"how many elements?"]},
        {
          ButtonBox[\(SubsetQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"A \[Subset] B?"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"generalAA"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Group\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"work with groups"]},
        {
          ButtonBox[\(AbelianQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it commutative?"]},
        {
          ButtonBox[\(Centralizer[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"centralizer of element"]},
        {
          ButtonBox[\(Closure[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"closure of subset"]},
        {
          ButtonBox[\(CommutatorSubgroup[\[SelectionPlaceholder]]\),
            ButtonNote->"subgroup gen. by commutators"]},
        {
          
          ButtonBox[
            \(ConjugacyClass[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"conj. cl. of element"]},
        {
          ButtonBox[\(CyclicGenerators[\[SelectionPlaceholder]]\),
            ButtonNote->"generators showing cyclic"]},
        {
          ButtonBox[\(CyclicQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it cyclic?"]},
        {
          
          ButtonBox[
            \(FormGroupoid[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"create Groupoid"]},
        {
          
          ButtonBox[
            \(GenerateGroupoid[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"create Groupoid"]},
        {
          ButtonBox[\(GroupCenter[\[SelectionPlaceholder]]\),
            ButtonNote->"center of group"]},
        {
          ButtonBox[\(GroupExponent[\[SelectionPlaceholder]]\),
            ButtonNote->"exponent of group"]},
        {
          ButtonBox[\(\ GroupIdentity[\[SelectionPlaceholder]]\),
            ButtonNote->"identity of group"]},
        {
          ButtonBox[\(GroupInfo[\[SelectionPlaceholder]]\),
            ButtonNote->"info. about Groupoid"]},
        {
          
          ButtonBox[
            \(GroupInverse[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"inverse of group element"]},
        {
          ButtonBox[\(Index[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"index of group"]},
        {
          
          ButtonBox[
            \(QuotientGroup[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"form quotientgroup"]},
        {
          
          ButtonBox[\(\ 
            SubgroupGenerated[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"subgroup generated by element"]},
        {
          ButtonBox[\(SubgroupIntersection[ ... ]\),
            ButtonData:>RowBox[ {"SubgroupIntersection", "[", 
                
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]", 
                  ",", "\[Placeholder]"}], "]"}],
            ButtonNote->"intersection of subgroups"]},
        {
          
          ButtonBox[
            \(SubgroupJoin[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"join of subgroups"]},
        {
          
          ButtonBox[
            \(SubgroupProduct[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"product of subgroups"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"group"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Permutation\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"work with permutations"]},
        {
          ButtonBox[\(DisjointCyclesQ[\[SelectionPlaceholder]]\),
            ButtonNote->"are they disjoint?"]},
        {
          ButtonBox[\(EvenPermutationQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it even?"]},
        {
          
          ButtonBox[
            \(ExtendPermutation[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"extend into larger group"]},
        {
          ButtonBox[\(FormGroupoidFromCycles[\[SelectionPlaceholder]]\),
            ButtonNote->"use cycles to make Groupoid"]},
        {
          ButtonBox[\(FromCycles[\[SelectionPlaceholder]]\),
            ButtonNote->"convert cycles to permutations"]},
        {
          
          ButtonBox[
            \(MultiplyCycles[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"multiply cycles"]},
        {
          
          ButtonBox[
            \(MultiplyPermutations[\[SelectionPlaceholder], \[Placeholder]]
              \),
            ButtonNote->"multiply permutations"]},
        {
          ButtonBox[\(OddPermutationQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it an odd permutation?"]},
        {
          ButtonBox[\(Parity[\[SelectionPlaceholder]]\),
            ButtonNote->"return 1 or -1"]},
        {
          ButtonBox[\(PermutationInverse[\[SelectionPlaceholder]]\),
            ButtonNote->"give inverse of permutation"]},
        {
          ButtonBox[\(PermutationQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it a permutation?"]},
        {
          ButtonBox[\(\ RandomPermutation[\[SelectionPlaceholder]]\),
            ButtonNote->"choose random permutations"]},
        {
          ButtonBox[\(ToCycles[\[SelectionPlaceholder]]\),
            ButtonNote->"convert permutation to cycles"]},
        {
          ButtonBox[\(ToPermutation[\[SelectionPlaceholder]]\),
            ButtonNote->"convert to a permutation"]},
        {
          ButtonBox[\(ToTranspositions[\[SelectionPlaceholder]]\),
            ButtonNote->"convert to transpositions"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"permutation"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Morphism\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"work with morphisms"]},
        {
          
          ButtonBox[
            \(Automorphism[\[SelectionPlaceholder], 
              \[Placeholder] \[Rule] \[Placeholder]]\),
            ButtonNote->"create an automorphism"]},
        {
          ButtonBox[\(AutomorphismGroup[\[SelectionPlaceholder]]\),
            ButtonNote->"form all automorphisms"]},
        {
          ButtonBox[\(Codomain[\[SelectionPlaceholder]]\),
            ButtonNote->"return codomain"]},
        {
          ButtonBox[\(Domain[\[SelectionPlaceholder]]\),
            ButtonNote->"return domain"]},
        {
          
          ButtonBox[
            \(FormMorphoid[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"form a morphism"]},
        {
          
          ButtonBox[
            \(FormMorphoidSetup[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"help in forming Morphoid"]},
        {
          ButtonBox[\(Image[\[SelectionPlaceholder]]\),
            ButtonNote->"image of a morphism"]},
        {
          ButtonBox[\(InjectiveQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it one-to-one?"]},
        {
          
          ButtonBox[
            \(InnerAutomorphism[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"form an inner automorphism"]},
        {
          ButtonBox[\(InnerAutomorphismGroup[\[SelectionPlaceholder]]\),
            ButtonNote->"form all inner automorphisms"]},
        {
          
          ButtonBox[
            \(InverseImage[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"return inverse image"]},
        {
          ButtonBox[\(\ InverseImages[\[SelectionPlaceholder]]\),
            ButtonNote->"return inverse images of morphism"]},
        {
          ButtonBox[\(IsomorphismQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it an isomorphism?"]},
        {
          ButtonBox[\(Kernel[\[SelectionPlaceholder]]\),
            ButtonNote->"return the kernel"]},
        {
          ButtonBox[\(MorphismQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it a morphism?"]},
        {
          
          ButtonBox[
            \(PreservesQ[
              \[SelectionPlaceholder], {\[Placeholder], \[Placeholder]}]\),
            ButtonNote->"is a pair preserved?"]},
        {
          ButtonBox[\(\ SurjectiveQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is onto?"]},
        {
          ButtonBox[\(VisualizeMorphoid[\[SelectionPlaceholder]]\),
            ButtonNote->"graphically show Morphoid"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"morphism"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Ring\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"work with rings"]},
        {
          ButtonBox[\(AdditiveGroupoid[\[SelectionPlaceholder]]\),
            ButtonNote->"creates additive groupoid"]},
        {
          ButtonBox[\(Characteristic[\[SelectionPlaceholder]]\),
            ButtonNote->"determines characteristic"]},
        {
          ButtonBox[\(CommutativeQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is multiplication commutative?"]},
        {
          ButtonBox[\(DistributiveQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it distributive?"]},
        {
          ButtonBox[\(FieldQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it a field?"]},
        {
          
          ButtonBox[
            \(FormRingoid[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"creates a Ringoid"]},
        {
          ButtonBox[\(IdealQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it an ideal?"]},
        {
          ButtonBox[\(IdempotentQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it an idempotent?"]},
        {
          ButtonBox[\(Idempotents[\[SelectionPlaceholder]]\),
            ButtonNote->"form all idempotents"]},
        {
          ButtonBox[\(IntegralDomainQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it an integral domain?"]},
        {
          
          ButtonBox[\(\ 
            InvertibleQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it invertible?"]},
        {
          ButtonBox[\(MultiplicativeGroupoid[\[SelectionPlaceholder]]\),
            ButtonNote->"form multiplicative groupoid"]},
        {
          
          ButtonBox[
            \(MultiplicativeInverse[\[SelectionPlaceholder], \[Placeholder]]
              \),
            ButtonNote->"return mult. inverse"]},
        {
          ButtonBox[\(NegationOf[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"return add. inverse"]},
        {
          
          ButtonBox[
            \(QuotientRing[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"form quotient ring"]},
        {
          ButtonBox[\(\ RingInfo[\[SelectionPlaceholder]]\),
            ButtonNote->"return info about ring"]},
        {
          ButtonBox[\(SubringQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it a subring?"]},
        {
          ButtonBox[\(UnitQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it a unit"]},
        {
          ButtonBox[\(Units[\[SelectionPlaceholder]]\),
            ButtonNote->"return all units"]},
        {
          ButtonBox[\(WithUnityQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is there a unity?"]},
        {
          ButtonBox[\(ZeroDivisors[\[SelectionPlaceholder]]\),
            ButtonNote->"return all zero divisors"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"ring"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Polynomial\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"for working with polynomials"]},
        {
          ButtonBox[\(EisensteinsCriterionQ[\[SelectionPlaceholder]]\),
            ButtonNote->"apply Eisenstein's Criterion"]},
        {
          
          ButtonBox[
            \(ModpIrreducibilityQ[\(\[SelectionPlaceholder], \) 
              \[Placeholder] \(\ ]\)\),
            ButtonNote->"apply mod p irreducibility test"]},
        {
          ButtonBox[\(Poly[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"create a polynomial"]},
        {
          
          ButtonBox[
            \(PolynomialEvaluation[\[SelectionPlaceholder], \[Placeholder]]
              \),
            ButtonNote->"evaluate a polynomial"]},
        {
          
          ButtonBox[
            \(PolynomialsOfDegreeN[\[SelectionPlaceholder], \[Placeholder]]
              \),
            ButtonNote->"all polynomials of degree specified"]},
        {
          
          ButtonBox[
            \(PolynomialsUpToDegreeN[\[SelectionPlaceholder], \[Placeholder]]
              \),
            ButtonNote->"all polynomials up to degree specified"]},
        {
          ButtonBox[\(RationalRootCandidates[\[SelectionPlaceholder]]\),
            ButtonNote->"rational candidates for zero"]},
        {
          ButtonBox[\(RationalRootTheorem[\[SelectionPlaceholder]]\),
            ButtonNote->"apply Rational Root Theorem"]},
        {
          ButtonBox[\(Solve[\[SelectionPlaceholder] == \[Placeholder]]\),
            ButtonNote->"solve polynomial equation"]},
        {
          ButtonBox[\(ToOrdinaryPolynomial[\[SelectionPlaceholder]]\),
            ButtonNote->"convert Poly-type to ordinary type"]},
        {
          ButtonBox[\(Zeros[\[SelectionPlaceholder]]\),
            ButtonNote->"find zeros of polynomial"]},
        {
          ButtonBox[\(\[SelectionPlaceholder] /. \[Placeholder]\),
            ButtonNote->"use replace with the rules"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"polynomial"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Matrix\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"work with matrices"]},
        {
          ButtonBox[\(Adjoint[\[SelectionPlaceholder]]\),
            ButtonNote->"returns adjoint"]},
        {
          ButtonBox[\(AntiCommutingMat ... \),
            ButtonData:>RowBox[ {"AntiCommutingMatricesQ", "[", 
                
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]", 
                  ",", "\[Placeholder]"}], "]"}],
            ButtonNote->"AntiCommutingMatricesQ"]},
        {
          ButtonBox[\(DetAdjoint[\[SelectionPlaceholder]]\),
            ButtonNote->"returns (determinant) adjoint"]},
        {
          
          ButtonBox[
            \(GeneralLinear[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"returns GL[R,n]"]},
        {
          ButtonBox[\(GLQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"in GL[R,n]?"]},
        {
          ButtonBox[\(HermitianQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it hermitian?"]},
        {
          ButtonBox[\(Mat[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"ring of matrices/R"]},
        {
          
          ButtonBox[
            \(MatA[\[SelectionPlaceholder], {\[Placeholder], \[Placeholder]}]
              \),
            ButtonNote->"additive matrices/R"]},
        {
          ButtonBox[\(MatM[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"multiplicative matrices/R"]},
        {
          ButtonBox[\(MatrixConjugate[\[SelectionPlaceholder]]\),
            ButtonNote->"conjugate of matrix"]},
        {
          ButtonBox[\(OrthogonalQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is orthogonal?"]},
        {
          ButtonBox[\(RandomMatrix[\[SelectionPlaceholder] ... ]\),
            ButtonData:>RowBox[ {"RandomMatrix", "[", 
                
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]", 
                  ",", 
                  
                  RowBox[ {"MatrixType", " ", "\[Rule]", 
                    "\[Placeholder]"}]}], "]"}],
            ButtonNote->"specify type also"]},
        {
          ButtonBox[\(SkewHermitianQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it skew hermitian?"]},
        {
          
          ButtonBox[
            \(SkewSymmetricQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it skew symmetric?"]},
        {
          ButtonBox[\(SLQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it in SL[R,n]?"]},
        {
          
          ButtonBox[
            \(SpecialLinear[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"return SL[R,n]"]},
        {
          
          ButtonBox[\(\ 
            SymmetricQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it symmetric?"]},
        {
          
          ButtonBox[
            \(ToGroupoid[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"convert to groupoid"]},
        {
          
          ButtonBox[
            \(ToRingoid[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"convert to ringoid"]},
        {
          ButtonBox[\(UnitaryQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it unitary?"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"matrix"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\(Galois\ field\)\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"work with Galois fields"]},
        {
          ButtonBox[\(AdditiveToMult ... \),
            ButtonData:>RowBox[ {"AdditiveToMultiplicative", "[", 
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]"}], 
                "]"}],
            ButtonNote->"convert add. form to mult."]},
        {
          ButtonBox[\(FieldIrreducible[\[SelectionPlaceholder]]\),
            ButtonNote->"return irreducible poly used"]},
        {
          ButtonBox[\(GF[\[SelectionPlaceholder]]\),
            ButtonNote->"p^n  Galois field"]},
        {
          ButtonBox[\(GF[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"p, n  Galois field"]},
        {
          ButtonBox[\(MultiplicativeToAdd ... \),
            ButtonData:>RowBox[ {"MultiplicativeToAdditive", "[", 
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]"}], 
                "]"}],
            ButtonNote->"convert mult. form to add."]},
        {
          ButtonBox[\(PrimitivePolynomials[\[SelectionPlaceholder]]\),
            ButtonNote->"all prim. polynomials"]},
        {
          ButtonBox[\(TableOfPowers[\[SelectionPlaceholder]]\),
            ButtonNote->"convert add. form to mult."]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True]], "Input",
  Active->True,
  CellTags->"GaloisField"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(\[DoubleStruckCapitalZ][\@d]\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"working with Z[Sqrt[d]]"]},
        {
          ButtonBox[\(IntegerDivisors[\[SelectionPlaceholder]]\),
            ButtonNote->"divisors of an integer"]},
        {
          ButtonBox[\(ValuesHavingGivenNorm[ ... ]\),
            ButtonData:>RowBox[ {"ValuesHavingGivenNorm", "[", 
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]"}], 
                "]"}],
            ButtonNote->"which values have this norm"]},
        {
          
          ButtonBox[
            \(ZdAssociatesQ[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"are these associates?"]},
        {
          ButtonBox[\(ZdConjugate[\[SelectionPlaceholder]]\),
            ButtonNote->"what is the conjugate?"]},
        {
          ButtonBox[\(ZdDivide[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"perform division"]},
        {
          
          ButtonBox[
            \(ZdDividesQ[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"do these divide 'evenly'?"]},
        {
          ButtonBox[\(ZdDivisors[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"what are the divisors?"]},
        {
          
          ButtonBox[
            \(ZdIrreducibleQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is this irreducible?"]},
        {
          ButtonBox[\(ZdNorm[\[SelectionPlaceholder]]\),
            ButtonNote->"calculate the norm"]},
        {
          
          ButtonBox[
            \(ZdPossibleNormQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is this norm possible?"]},
        {
          
          ButtonBox[\(\ 
            ZdPossibleNorms[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"what norms are possible?"]},
        {
          ButtonBox[\(ZdQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is this a ring element?"]},
        {
          ButtonBox[\(ZdUnitQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is this a unit?"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  CellFrame->False,
  Active->True,
  CellTags->"Z[d]"],

Cell[BoxData[
    ButtonBox[\(return\ to\ main\ palette\),
      ButtonData:>"abstractalgebra",
      ButtonStyle->"Hyperlink"]], "Input",
  Active->True],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Group\ Lab\ Two\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"Group Lab Two"]},
        {
          ButtonBox[\(ShowOne[Lab2]\),
            ButtonStyle->"CopyEvaluateCell"]},
        {
          ButtonBox[\(ShowPermutation[\[SelectionPlaceholder]]\)]},
        {
          
          ButtonBox[
            \(MultiplyPermutations[\[Placeholder], \[SelectionPlaceholder]]
              \)]},
        {
          ButtonBox[\(AddPermToGroup[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(DropPermFromGroup[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox["MySymmetryGroup",
            ButtonStyle->"CopyEvaluate"]},
        {
          ButtonBox[\(TestPermutationQ[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(GoodGroupElementsQ[]\),
            ButtonStyle->"CopyEvaluate"]},
        {
          ButtonBox[\(CompleteGroupQ[]\),
            ButtonStyle->"CopyEvaluate"]},
        {
          ButtonBox[\(ShowPossiblePermutations[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(ShowPossiblePermsAsRules[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(RestrictList[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox[\(Permutation\ Specifier\),
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "PermutationSpecifier.nb"}], 
              None},
            ButtonStyle->"Hyperlink",
            ButtonNote->None]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input",
  Active->True,
  CellTags->"GroupLabTwo"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{250, 552},
WindowMargins->{{Automatic, 7}, {Automatic, 6}},
WindowFrame->"Palette",
WindowClickSelect->False,
ShowCellBracket->False,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    ScriptMinSize->12,
    FontSize->16],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellBracketOptions->{"Margins"->{1, 1},
    "Widths"->{0, 5}},
    ScriptMinSize->8,
    FontSize->11],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ScriptMinSize->5,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{24, 10}, {20, 40}},
    LineSpacing->{1, 0},
    FontSize->44],
  
  Cell[StyleData["Title", "Condensed"],
    CellMargins->{{8, 10}, {4, 8}},
    FontSize->20],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {12, 30}},
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "Condensed"],
    CellMargins->{{8, 10}, {4, 4}},
    FontSize->14],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "Condensed"],
    CellMargins->{{8, 10}, {8, 8}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{25, Inherited}, {8, 24}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{40, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "Condensed"],
    CellMargins->{{18, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{13, 0}, {7, 22}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 20}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{36, 10}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "Condensed"],
    CellMargins->{{16, Inherited}, {6, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 22}},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellDingbat->"\[FilledSmallSquare]",
    CellMargins->{{22, Inherited}, {8, 18}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    CounterIncrements->"Subsubsection",
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{34, 10}, {11, 26}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "Condensed"],
    CellMargins->{{17, Inherited}, {6, 12}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{9, 0}, {7, 14}},
    FontSize->11]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{12, 10}, {7, 7}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["Text", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{12, 10}, {6, 6}},
    LineSpacing->{1, 3},
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 10}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["SmallText", "Condensed"],
    CellMargins->{{8, 10}, {5, 5}},
    LineSpacing->{1, 2},
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{Inherited, Inherited}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Input", "Condensed"],
    CellMargins->{{40, 10}, {2, 3}}],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[StyleData["InputOnly"],
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    DefaultFormatType->DefaultInputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{47, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, Inherited}, {10, 8}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Output", "Condensed"],
    CellMargins->{{41, Inherited}, {3, 2}}],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Message", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{45, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    AutoItalicWords->{},
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Print", "Condensed"],
    CellMargins->{{41, Inherited}, {Inherited, Inherited}}],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Condensed"],
    ImageMargins->{{38, Inherited}, {Inherited, 0}},
    Magnification->0.6],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    FontSize->9,
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Condensed"],
    FontSize->9],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    CellMargins->{{24, 10}, {10, 10}},
    LineSpacing->{1, 5}],
  
  Cell[StyleData["InlineFormula", "Condensed"],
    CellMargins->{{8, 10}, {6, 6}},
    LineSpacing->{1, 1}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5}],
  
  Cell[StyleData["DisplayFormula", "Condensed"],
    LineSpacing->{1, 1}],
  
  Cell[StyleData["DisplayFormula", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"]],
  
  Cell[StyleData["Hyperlink", "Condensed"]],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"]],
  
  Cell[StyleData["MainBookLink", "Condensed"]],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"]],
  
  Cell[StyleData["AddOnsLink", "Condensed"]],
  
  Cell[StyleData["AddOnLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"]],
  
  Cell[StyleData["RefGuideLink", "Condensed"]],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"]],
  
  Cell[StyleData["GettingStartedLink", "Condensed"]],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"]],
  
  Cell[StyleData["OtherInformationLink", "Condensed"]],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "Condensed"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SelectionPlaceholder"],
    Editable->False,
    Selectable->False,
    StyleBoxAutoDelete->True,
    Placeholder->Primary,
    StyleMenuListing->None,
    DrawHighlighted->True],
  
  Cell[StyleData["SelectionPlaceholder", "Presentation"]],
  
  Cell[StyleData["SelectionPlaceholder", "Condensed"]],
  
  Cell[StyleData["SelectionPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    AllowInlineCells->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    TextAlignment->Left,
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[1, 0.749996, 0.8]]
  }, Closed]]
  }, Open  ]]
  }],
MacintoshSystemPageSetup->"\<\
00`0001804P000000_X2@?oaonh32@9B:P85:0?l0@00004/0B`0000036L9H001
0000I0000@400@0000000BL?0040000000000000000000000000000000000?o2
okD<Y@V[00P100000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "abstractalgebra"->{
    Cell[1710, 49, 5671, 157, 360, "Input",
      CellTags->"abstractalgebra"]},
  "groupoids"->{
    Cell[7384, 208, 2921, 78, 388, "Input",
      CellTags->"groupoids"]},
  "ringoids"->{
    Cell[10465, 294, 2337, 62, 269, "Input",
      CellTags->{"ringoids", "morphoids"}]},
  "morphoids"->{
    Cell[10465, 294, 2337, 62, 269, "Input",
      CellTags->{"ringoids", "morphoids"}]},
  "generalAA"->{
    Cell[12962, 364, 3769, 101, 388, "Input",
      CellTags->"generalAA"]},
  "group"->{
    Cell[16891, 473, 3799, 103, 405, "Input",
      CellTags->"group"]},
  "permutation"->{
    Cell[20850, 584, 2490, 65, 286, "Input",
      CellTags->"permutation"]},
  "morphism"->{
    Cell[23500, 657, 3290, 90, 371, "Input",
      CellTags->"morphism"]},
  "ring"->{
    Cell[26950, 755, 3575, 94, 422, "Input",
      CellTags->"ring"]},
  "polynomial"->{
    Cell[30685, 857, 2628, 69, 269, "Input",
      CellTags->"polynomial"]},
  "matrix"->{
    Cell[33473, 934, 4040, 109, 405, "Input",
      CellTags->"matrix"]},
  "GaloisField"->{
    Cell[37673, 1051, 1580, 39, 150, "Input",
      CellTags->"GaloisField"]},
  "Z[d]"->{
    Cell[39413, 1098, 2835, 76, 295, "Input",
      CellTags->"Z[d]"]},
  "GroupLabTwo"->{
    Cell[42408, 1182, 1843, 53, 252, "Input",
      CellTags->"GroupLabTwo"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"abstractalgebra", 68301, 2099},
  {"groupoids", 68399, 2102},
  {"ringoids", 68490, 2105},
  {"morphoids", 68597, 2108},
  {"generalAA", 68704, 2111},
  {"group", 68794, 2114},
  {"permutation", 68886, 2117},
  {"morphism", 68980, 2120},
  {"ring", 69067, 2123},
  {"polynomial", 69156, 2126},
  {"matrix", 69247, 2129},
  {"GaloisField", 69340, 2132},
  {"Z[d]", 69431, 2135},
  {"GroupLabTwo", 69522, 2138}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 5671, 157, 360, "Input",
  CellTags->"abstractalgebra"],
Cell[7384, 208, 2921, 78, 388, "Input",
  CellTags->"groupoids"],
Cell[10308, 288, 154, 4, 31, "Input"],
Cell[10465, 294, 2337, 62, 269, "Input",
  CellTags->{"ringoids", "morphoids"}],
Cell[12805, 358, 154, 4, 31, "Input"],
Cell[12962, 364, 3769, 101, 388, "Input",
  CellTags->"generalAA"],
Cell[16734, 467, 154, 4, 31, "Input"],
Cell[16891, 473, 3799, 103, 405, "Input",
  CellTags->"group"],
Cell[20693, 578, 154, 4, 31, "Input"],
Cell[20850, 584, 2490, 65, 286, "Input",
  CellTags->"permutation"],
Cell[23343, 651, 154, 4, 31, "Input"],
Cell[23500, 657, 3290, 90, 371, "Input",
  CellTags->"morphism"],
Cell[26793, 749, 154, 4, 31, "Input"],
Cell[26950, 755, 3575, 94, 422, "Input",
  CellTags->"ring"],
Cell[30528, 851, 154, 4, 31, "Input"],
Cell[30685, 857, 2628, 69, 269, "Input",
  CellTags->"polynomial"],
Cell[33316, 928, 154, 4, 31, "Input"],
Cell[33473, 934, 4040, 109, 405, "Input",
  CellTags->"matrix"],
Cell[37516, 1045, 154, 4, 31, "Input"],
Cell[37673, 1051, 1580, 39, 150, "Input",
  CellTags->"GaloisField"],
Cell[39256, 1092, 154, 4, 31, "Input"],
Cell[39413, 1098, 2835, 76, 295, "Input",
  CellTags->"Z[d]"],
Cell[42251, 1176, 154, 4, 31, "Input"],
Cell[42408, 1182, 1843, 53, 252, "Input",
  CellTags->"GroupLabTwo"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

