(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9903,        265]*)
(*NotebookOutlinePosition[     11146,        308]*)
(*  CellTagsIndexPosition[     11102,        304]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox[
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"action", " ", "buttons"}], " ", "-", " ", 
                  RowBox[{"no", " ", "pasting"}]}], ")"}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"first three buttons"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"Needs", "[", "\"\<AbstractAlgebra`Master`\>\"", "]"}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>Needs[ "AbstractAlgebra`Master`"],
            ButtonEvaluator->"Local",
            Background->RGBColor[0.740001, 0.990005, 0.790005],
            ButtonNote->"Loads master package"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"SwitchStructureTo", "[", "Group", "]"}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>SwitchStructureTo[ Group],
            ButtonEvaluator->"Local",
            Background->RGBColor[0.740001, 0.990005, 0.790005],
            ButtonNote->"work with groups"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"SwitchStructureTo", "[", "Ring", "]"}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>SwitchStructureTo[ Ring],
            ButtonEvaluator->"Local",
            Background->RGBColor[0.740001, 0.990005, 0.790005],
            ButtonNote->"work with rings"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{"Palettes", " ", 
                RowBox[{"Available", ":"}]}],
              FontFamily->"Times",
              FontSize->12],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"click below"]},
        {
          ButtonBox[
            RowBox[{"Help", " ", "with", " ", "the", " ", "palettes"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "HelpPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"Palette Help"]},
        {
          ButtonBox["Groupoids",
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "GroupoidsPalette.nb"}], 
              None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"list of Groupoids"]},
        {
          ButtonBox[
            RowBox[{"Ringoids", " ", "and", " ", "Morphoids"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", 
                "RingoidsMorphoidsPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"Ringoids and Morphoids"]},
        {
          ButtonBox[
            RowBox[{"General", " ", "AA", " ", "functions"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "GeneralPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"universal functions"]},
        {
          ButtonBox[
            RowBox[{"Group", " ", "functions"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "GroupPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"apply to groups"]},
        {
          ButtonBox[
            RowBox[{"Permutation", " ", "functions"}],
            ButtonData:>{
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "PermutationsPalette.nb"}], 
              None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"permutation-related"]},
        {
          ButtonBox[
            RowBox[{"Morphism", " ", "functions"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "MorphismPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"morphism-related"]},
        {
          ButtonBox[
            RowBox[{"Ring", " ", "functions"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "RingPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"ring-related"]},
        {
          ButtonBox[
            RowBox[{"Polynomial", " ", "functions"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "PolynomialPalette.nb"}], 
              None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"polynomial-related"]},
        {
          ButtonBox[
            RowBox[{"Matrix", " ", "functions"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "MatrixPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"matrix-related"]},
        {
          ButtonBox[
            RowBox[{"Galois", " ", "field", " ", "functions"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "GaloisFieldPalette.nb"}], 
              None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"work with fields"]},
        {
          ButtonBox[
            RowBox[{
              RowBox[{"\[DoubleStruckCapitalZ]", "[", 
                SqrtBox["d"], "]"}], "functions"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "ZdPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            ButtonNote->"special ring functions"]},
        {
          ButtonBox[
            StyleBox[
              RowBox[{
              "palettes", " ", "for", " ", "working", " ", "with", " ", 
                RowBox[{"groups", "/", "rings"}]}],
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain"],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "MultiPalette.nb"}], None},
            ButtonStyle->"Hyperlink",
            Background->GrayLevel[0.700008],
            ButtonNote->"many palettes"]},
        {
          ButtonBox[
            RowBox[{"All", " ", "AA", " ", "palettes"}],
            ButtonData:>{
              
              FrontEnd`FileName[ {$TopDirectory, "AddOns", "Applications", 
                "AbstractAlgebra", "Palettes", "AAPalettes.nb"}], None},
            ButtonStyle->"Hyperlink",
            Background->GrayLevel[0.6],
            ButtonNote->"all AA palettes"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
Editable->False,
WindowToolbars->{},
PageWidth->402,
WindowSize->{Fit, Fit},
WindowMargins->{{Automatic, 6}, {Automatic, 1}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
ScrollingOptions->{"PagewiseScrolling"->True},
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Magnification->1,
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 8189, 214, 353, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

