(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3532,         93]*)
(*NotebookOutlinePosition[      4642,        132]*)
(*  CellTagsIndexPosition[      4545,        125]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Z[4]", "Input",
  Deletable->False,
  CellFrame->True,
  Evaluatable->False,
  CellFrameLabels->{{
    StyleBox[ "enter group or ring:", FontColor -> RGBColor[ 0, 0, 1]], 
        None}, {Inherited, Inherited}},
  CellTags->"structure"],

Cell[BoxData[
    \(Module[{nb\  = \ InputNotebook[], G, \ els, out}, \n\t\t
      NotebookFind[nb, "\<structure\>", All, \ CellTags, \ 
        AutoScroll\  -> \ False]; \n\t\t
      SelectionMove[nb, All, \ Cell, AutoScroll\  -> \ False]; \n\t
      G\  = NotebookRead[nb]; \n\tG\  = \ G[[1, 1]]; \n\t
      els\  = \ Elements[ToExpression[G]]; \n\t
      out\  = \ Cell[
          BoxData[RowBox[\n
              Join[{StringJoin["\<Elements of \>", 
                    AbstractAlgebra`Core`Private`StructureName[
                      ToExpression[G]], "\<:\>"]}, \ 
                Map[ButtonBox[ToBoxes[#]]&, \ els]]]], Active -> True, \ 
          AutoIndent -> True, \n\t\t\t\t\ ZeroWidthTimes -> False, 
          LineIndent -> 0, \ \n\t\t\t\tFontFamily -> "\<Courier\>", 
          FontSize\  -> \ 14, FontWeight -> "\<Plain\>", \ 
          TextAlignment -> Center, LineSpacing -> {1.25, \ 0}, \n
          ShowCellBracket -> False]; \n\tSelectionMove[nb, After, Notebook]; 
      \n\tNotebookWrite[nb, out]]\)], "Input",
  CellElementSpacings->{"ClosedCellHeight"->0},
  CellOpen->False,
  CellTags->"code"],

Cell[BoxData[
    ButtonBox[\(click\ when\ group\ or\ ring\ has\ been\ entered\),
      ButtonFunction:>CompoundExpression[ 
          NotebookFind[ 
            ButtonNotebook[ ], "code", All, CellTags, AutoScroll -> False], 
          SelectionMove[ 
            ButtonNotebook[ ], All, Cell, AutoScroll -> False], 
          SelectionEvaluate[ 
            ButtonNotebook[ ]]],
      ButtonNote->"enter group/ring first"]], "Input",
  Active->True]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{687, 166},
WindowMargins->{{9, Automatic}, {-1, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "structure"->{
    Cell[1709, 49, 242, 7, 43, "Input",
      Evaluatable->False,
      CellTags->"structure"]},
  "code"->{
    Cell[1954, 58, 1120, 21, 0, "Input",
      CellOpen->False,
      CellTags->"code"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"structure", 4321, 113},
  {"code", 4430, 117}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 242, 7, 43, "Input",
  Evaluatable->False,
  CellTags->"structure"],
Cell[1954, 58, 1120, 21, 0, "Input",
  CellOpen->False,
  CellTags->"code"],
Cell[3077, 81, 451, 10, 31, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

