(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6028,        169]*)
(*NotebookOutlinePosition[      7563,        223]*)
(*  CellTagsIndexPosition[      7489,        217]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox[\(General\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"general functions"]},
        {
          ButtonBox[\(AssociativeQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it associative?"]},
        {
          
          ButtonBox[
            \(CartesianProduct[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"Cartesian product"]},
        {
          ButtonBox[\(CayleyTable[\[SelectionPlaceholder]]\),
            
            ButtonData:>
              RowBox[ {"CayleyTable", "[", 
                "\[SelectionPlaceholder], Mode \[Rule] Visual", "]"}],
            ButtonNote->"Visual CayleyTable"]},
        {
          ButtonBox[\(CayleyTables[\[SelectionPlaceholder]]\),
            
            ButtonData:>
              RowBox[ {"CayleyTables", "[", 
                "\[SelectionPlaceholder], Mode \[Rule] Visual", "]"}],
            ButtonNote->"Visual CayleyTables"]},
        {
          ButtonBox[\(ClosedQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it closed?"]},
        {
          ButtonBox[\(CosetToList[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"a+NS to {a,..} form"]},
        {
          
          ButtonBox[
            \(DirectProduct[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"for groups or rings"]},
        {
          ButtonBox[\(ElementQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"x \[Element] S?"]},
        {
          ButtonBox[\(Elements[\[SelectionPlaceholder]]\),
            ButtonNote->"list of elements"]},
        {
          
          ButtonBox[
            \(ElementToCoset[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"convert x to coset"]},
        {
          
          ButtonBox[
            \(ElementToPower[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"x^n in S"]},
        {
          ButtonBox[\(\ HasIdentityQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is there an identity?"]},
        {
          ButtonBox[\(HasInversesQ[\[SelectionPlaceholder]]\),
            ButtonNote->"does x have an inverse?"]},
        {
          ButtonBox[\(MultipleOfElement[ ... ]\),
            ButtonData:>RowBox[ {"MultipleOfElement", "[", 
                
                RowBox[ {"\[SelectionPlaceholder]", ",", "\[Placeholder]", 
                  ",", "\[Placeholder]"}], "]"}],
            ButtonNote->"n\[CenterDot]x in S"]},
        {
          ButtonBox[\(RandomElement[\[SelectionPlaceholder]]\),
            ButtonNote->"1 random element"]},
        {
          
          ButtonBox[
            \(RandomElements[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"n random elements"]},
        {
          ButtonBox[\(\ Randomize[\[SelectionPlaceholder]]\),
            ButtonNote->"scramble elements"]},
        {
          ButtonBox[\(Size[\[SelectionPlaceholder]]\),
            ButtonNote->"how many elements?"]},
        {
          ButtonBox[\(SubsetQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"A \[Subset] B?"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  CellTags->"generalAA"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
Editable->False,
WindowToolbars->{},
PageWidth->392,
WindowSize->{Fit, Fit},
WindowMargins->{{Automatic, 21}, {Automatic, 1}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
ScrollingOptions->{"PagewiseScrolling"->True},
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Magnification->1,
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "generalAA"->{
    Cell[1710, 49, 4314, 118, 381, NotebookDefault,
      Evaluatable->True,
      CellGroupingRules->"InputGrouping",
      PageBreakAbove->True,
      PageBreakWithin->False,
      CounterIncrements->"Input",
      CellTags->"generalAA"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"generalAA", 7222, 205}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 4314, 118, 381, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input",
  CellTags->"generalAA"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

