(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6501,        179]*)
(*NotebookOutlinePosition[      7371,        207]*)
(*  CellTagsIndexPosition[      7327,        203]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  "Help with ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"],
  " palettes"
}], "Title"],

Cell[TextData[{
  "After starting up the ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"],
  " packages (using the first button on the ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"],
  " palette), one can use the second button to establish the focus to be \
working with groups or to be working with rings by using the third button."
}], "Text"],

Cell[TextData[{
  "Below the button that brought up this window (\"Help with these \
palettes\"), are a number of other buttons that bring up a variety of \
palettes. Each palette is a list of function names with boxes for the \
parameters of each function. Each solid box (\[SelectionPlaceholder]) becomes \
filled with whatever is selected at the time of pressing the button; if \
nothing was selected, the name is pasted with this box selected so that it \
can be filled by typing or using another button. Whenever there is another \
box (\[Placeholder]), this parameter also needs to be filled in. Some of the \
functions may have an alternate syntax than what is given; typing \
?function_name will clarify what type of parameters are expected for each \
function. Of course, you can also use the Help Browser at any time for more \
definitive information about any function. The ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"],
  " help is available under the Add-ons button, or by clicking ",
  Cell[BoxData[
      FormBox[
        ButtonBox["here",
          ButtonData:>{"FormGroupoid", "FormGroupoid"},
          ButtonStyle->"AddOnsLink"], TextForm]], "Text"],
  "."
}], "Text"],

Cell[TextData[{
  "Below is a summary of what you will find for each palette:\n\n",
  StyleBox["Built-in Groupoids",
    FontWeight->"Bold"],
  ": this consists of a list of more common built-in Groupoids available in ",
  
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"],
  ".\n\n",
  StyleBox["Built-in Ringoids and Morphoids",
    FontWeight->"Bold"],
  ": this consists of a list of more common built-in Ringoids and Morphoids \
available in ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"],
  ".\n\n",
  StyleBox["general AA functions",
    FontWeight->"Bold"],
  ": here we have a list of functions that may be applicable for both groups \
and rings or are general purpose functions\n\n",
  StyleBox["Group functions",
    FontWeight->"Bold"],
  ": this is a subset of available functions specifically suited for working \
with groups or Groupoids.\n\n",
  StyleBox["Permutation functions",
    FontWeight->"Bold"],
  ": here we list functions that are related to working with permutations.\n\n\
",
  StyleBox["Morphism-related functions",
    FontWeight->"Bold"],
  ": except for the few built-in morphisms, this palette lists many of the \
functions related to working with Morphoids.\n\n",
  StyleBox["Ring functions",
    FontWeight->"Bold"],
  ": this palette lists some of the more common generic ring functions; more \
specialized ring functions can be found in the next four palettes.\n\n",
  StyleBox["Polynomial-related functions",
    FontWeight->"Bold"],
  ": some of the functions requiring the Poly-built polynomials, and those \
using standard polynomials, are listed here.\n\n",
  StyleBox["Matrix-related functions",
    FontWeight->"Bold"],
  ": some of the more common functions related to working with matrices are \
listed here, both those over general rings as well as those over the reals or \
complex numbers.\n\n",
  StyleBox["Galois field functions",
    FontWeight->"Bold"],
  ":three functions related to constructing Galois fields and then working \
with the elements are listed here.\n\n",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["d"], "]"}], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox["-related functions",
    FontWeight->"Bold"],
  ": many of the functions related to working with the ring ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["d"], "]"}], TraditionalForm]]],
  " are listed here."
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{523, 243},
WindowMargins->{{4, Automatic}, {11, Automatic}},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2304, 72, 116, 5, 76, "Title"],
Cell[2423, 79, 369, 9, 71, "Text"],
Cell[2795, 90, 1201, 22, 242, "Text"],
Cell[3999, 114, 2486, 62, 691, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

