(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5549,        158]*)
(*NotebookOutlinePosition[      7081,        212]*)
(*  CellTagsIndexPosition[      7008,        206]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Morphism\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"work with morphisms"]},
        {
          
          ButtonBox[
            \(Automorphism[\[SelectionPlaceholder], 
              \[Placeholder] \[Rule] \[Placeholder]]\),
            ButtonNote->"create an automorphism"]},
        {
          ButtonBox[\(AutomorphismGroup[\[SelectionPlaceholder]]\),
            ButtonNote->"form all automorphisms"]},
        {
          ButtonBox[\(Codomain[\[SelectionPlaceholder]]\),
            ButtonNote->"return codomain"]},
        {
          ButtonBox[\(Domain[\[SelectionPlaceholder]]\),
            ButtonNote->"return domain"]},
        {
          
          ButtonBox[
            \(FormMorphoid[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"form a morphism"]},
        {
          
          ButtonBox[
            \(FormMorphoidSetup[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"help in forming Morphoid"]},
        {
          ButtonBox[\(Image[\[SelectionPlaceholder]]\),
            ButtonNote->"image of a morphism"]},
        {
          ButtonBox[\(InjectiveQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it one-to-one?"]},
        {
          
          ButtonBox[
            \(InnerAutomorphism[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"form an inner automorphism"]},
        {
          ButtonBox[\(InnerAutomorphismGroup[\[SelectionPlaceholder]]\),
            ButtonNote->"form all inner automorphisms"]},
        {
          
          ButtonBox[
            \(InverseImage[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"return inverse image"]},
        {
          ButtonBox[\(\ InverseImages[\[SelectionPlaceholder]]\),
            ButtonNote->"return inverse images of morphism"]},
        {
          ButtonBox[\(IsomorphismQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it an isomorphism?"]},
        {
          ButtonBox[\(Kernel[\[SelectionPlaceholder]]\),
            ButtonNote->"return the kernel"]},
        {
          ButtonBox[\(MorphismQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it a morphism?"]},
        {
          
          ButtonBox[
            \(PreservesQ[
              \[SelectionPlaceholder], {\[Placeholder], \[Placeholder]}]\),
            ButtonNote->"is a pair preserved?"]},
        {
          ButtonBox[\(\ SurjectiveQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is onto?"]},
        {
          ButtonBox[\(VisualizeMorphoid[\[SelectionPlaceholder]]\),
            ButtonNote->"graphically show Morphoid"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  CellTags->"morphism"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
Editable->False,
WindowToolbars->{},
PageWidth->415,
WindowSize->{Fit, Fit},
WindowMargins->{{Automatic, 10}, {5, Automatic}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
ScrollingOptions->{"PagewiseScrolling"->True},
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Magnification->1,
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "morphism"->{
    Cell[1710, 49, 3835, 107, 364, NotebookDefault,
      Evaluatable->True,
      CellGroupingRules->"InputGrouping",
      PageBreakAbove->True,
      PageBreakWithin->False,
      CounterIncrements->"Input",
      CellTags->"morphism"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"morphism", 6742, 194}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 3835, 107, 364, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input",
  CellTags->"morphism"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

