(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     98976,       1999]*)
(*NotebookOutlinePosition[    100185,       2041]*)
(*  CellTagsIndexPosition[    100084,       2034]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Z[12]", "Input",
  Deletable->False,
  CellFrame->True,
  Evaluatable->False,
  CellFrameLabels->{{
    StyleBox[ 
        "Type in Groupoid or Ringoid:", FontColor -> RGBColor[ 0, 0, 1]], 
        None}, {Inherited, Inherited}},
  CellTags->"structure"],

Cell[CellGroupData[{

Cell["Code - eventually hide", "Section",
  ShowCellBracket->False,
  CellOpen->False],

Cell[CellGroupData[{

Cell["General", "Subsection",
  ShowCellBracket->False,
  CellOpen->False],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{"Structure", "::", "error"}], " ", "=", " ", 
          "\"\<Enter either a Groupoid or Ringoid; this is neither.\>\""}], 
        ";", "\n", "\n", 
        RowBox[{"GetStructure", " ", ":=", " ", 
          RowBox[{"Module", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{"G", ",", " ", 
                  RowBox[{"nb", "=", "InputNotebook"}]}], "}"}], ",", "\n", 
              "\t\t", 
              RowBox[{
                RowBox[{"NotebookFind", "[", 
                  RowBox[{
                  "nb", ",", "\"\<structure\>\"", ",", "All", ",", " ", 
                    "CellTags", ",", " ", 
                    RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
                ";", "\n", "\t\t", 
                RowBox[{"SelectionMove", "[", 
                  RowBox[{"nb", ",", "All", ",", " ", "Cell", ",", 
                    RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
                ";", "\n", "\t", 
                RowBox[{"G", " ", "=", 
                  RowBox[{"NotebookRead", "[", "nb", "]"}]}], ";", "\n", 
                "\t", 
                RowBox[{"G", " ", "=", " ", 
                  RowBox[{
                    RowBox[{"G", "[", 
                      RowBox[{"[", 
                        RowBox[{"1", ",", "1"}], "]"}], "]"}], "//", 
                    "ToExpression"}]}], ";", "\n", "\t", 
                RowBox[{"If", "[", 
                  RowBox[{
                    RowBox[{"ValidStructure", "[", "G", "]"}], ",", " ", 
                    RowBox[{
                      RowBox[{"pushedGroup", " ", "=", "G"}], ";", " ", 
                      RowBox[{"pushedGroupName", " ", "=", 
                        RowBox[{
                        "AbstractAlgebra`Core`Private`StructureName", "[", 
                          "G", "]"}]}], ";", " ", "G"}], ",", "\n", 
                    "\t\t\t", 
                    RowBox[{
                      RowBox[{"Message", "[", 
                        RowBox[{"Structure", "::", "error"}], "]"}], ";", 
                      " ", "$Failed"}]}], "]"}]}]}], "]"}]}]}], "\n"}], 
    RowBox[{
      RowBox[{
        RowBox[{"ValidStructure", "[", "G_", "]"}], " ", ":=", " ", 
        RowBox[{
          RowBox[{"ValidStructure", "[", "G", "]"}], " ", "=", " ", 
          RowBox[{
            RowBox[{
            "AbstractAlgebra`Core`Private`GroupoidQ", "[", "G", "]"}], " ", 
            "||", " ", 
            RowBox[{
            "AbstractAlgebra`Core`Private`RingoidQ", "[", "G", "]"}]}]}]}], 
      "\n"}], 
    RowBox[{
      RowBox[{
        RowBox[{"ValidGroupoid", "[", "G_", "]"}], " ", ":=", " ", 
        RowBox[{
          RowBox[{"ValidGroupoid", "[", "G", "]"}], " ", "=", " ", 
          RowBox[{
          "AbstractAlgebra`Core`Private`GroupoidQ", "[", "G", "]"}]}]}], " ", 
      "\n"}], 
    RowBox[{
      RowBox[{
        RowBox[{"ValidRingoid", "[", "G_", "]"}], " ", ":=", " ", 
        RowBox[{
          RowBox[{"ValidRingoid", "[", "G", "]"}], " ", "=", " ", 
          RowBox[{
          "AbstractAlgebra`Core`Private`RingoidQ", "[", "G", "]"}]}]}], 
      " "}]}], "Input",
  ShowCellBracket->False,
  CellElementSpacings->{"ClosedCellHeight"->3},
  CellOpen->False,
  InitializationCell->True,
  CellTags->"code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette of elements", "Subsection",
  ShowCellBracket->False,
  CellOpen->False],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        RowBox[{"MakeElementGrid", "[", "G_", "]"}], " ", ":=", " ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"els", " ", "=", " ", 
                RowBox[{"Elements", "[", "G", "]"}]}], "}"}], ",", 
            RowBox[{"Cell", "[", 
              RowBox[{
                RowBox[{"BoxData", "[", 
                  RowBox[{"GridBox", "[", 
                    RowBox[{
                      RowBox[{"Prepend", "[", 
                        RowBox[{
                          RowBox[{"Table", "[", 
                            RowBox[{
                              RowBox[{"{", 
                                RowBox[{"ButtonBox", "[", 
                                  RowBox[{"ToBoxes", "[", 
                                    RowBox[{"els", "[", 
                                      RowBox[{"[", "i", "]"}], "]"}], "]"}], 
                                  "]"}], "}"}], ",", 
                              RowBox[{"{", 
                                RowBox[{"i", ",", 
                                  RowBox[{"Length", "[", "els", "]"}]}], 
                                "}"}]}], "]"}], ",", 
                          RowBox[{"{", 
                            RowBox[{"ButtonBox", "[", 
                              RowBox[{"pushedGroupName", ",", 
                                RowBox[{"ButtonFunction", ":>", "Null"}], 
                                ",", 
                                RowBox[{
                                "ButtonNote", " ", "->", 
                                  "\"\<elements of structure\>\""}], ",", 
                                "\n", "            ", 
                                RowBox[{"Background", "->", 
                                  RowBox[{"RGBColor", "[", 
                                    RowBox[{
                                    "1", ",", " ", "0.749996", ",", " ", 
                                      "0.8"}], "]"}]}]}], "]"}], "}"}]}], 
                        "]"}], ",", "\n", "      ", 
                      RowBox[{"RowSpacings", "->", "0"}], ",", "\n", 
                      "      ", 
                      RowBox[{"ColumnSpacings", "->", "0"}], ",", "\n", 
                      "      ", 
                      RowBox[{"RowLines", "->", "True"}], ",", "\n", 
                      "      ", 
                      RowBox[{"ColumnLines", "->", "True"}]}], "]"}], "]"}], 
                ",", "NotebookDefault", ",", 
                RowBox[{"Active", " ", "->", " ", "True"}]}], "]"}]}], 
          "]"}]}], "\n"}], 
    RowBox[{"FormElements", " ", ":=", " ", 
      RowBox[{"Module", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{"G", ",", " ", "els", ",", "out"}], "}"}], ",", "\n", 
          "\t\t", 
          RowBox[{
            RowBox[{"G", " ", "=", " ", "GetStructure"}], ";", "\n", "\t\t", 
            RowBox[{"If", "[", 
              RowBox[{
                RowBox[{"ValidStructure", "[", "G", "]"}], ",", "\n", 
                RowBox[{
                  RowBox[{"NotebookPut", "[", 
                    RowBox[{"Notebook", "[", 
                      RowBox[{
                        RowBox[{"{", 
                          RowBox[{"MakeElementGrid", "[", "G", "]"}], "}"}], 
                        ",", 
                        RowBox[{"WindowToolbars", "->", 
                          RowBox[{"{", "}"}]}], ",", 
                        RowBox[{"PageWidth", "->", "402"}], ",", 
                        RowBox[{"WindowSize", "->", 
                          RowBox[{"{", 
                            RowBox[{"Fit", ",", " ", "Fit"}], "}"}]}], ",", 
                        "\n", 
                        RowBox[{"WindowMargins", "->", 
                          RowBox[{"{", 
                            RowBox[{
                              RowBox[{"{", 
                                RowBox[{"4", ",", "Automatic"}], "}"}], ",", 
                              " ", 
                              RowBox[{"{", 
                                RowBox[{"4", ",", "Automatic"}], "}"}]}], 
                            "}"}]}], ",", "\n", 
                        RowBox[{"WindowFrame", "->", "\"\<Palette\>\""}], 
                        ",", "\n", "\t\t", 
                        RowBox[{"CellMargins", "->", 
                          RowBox[{"{", 
                            RowBox[{
                              RowBox[{"{", 
                                RowBox[{"0", ",", " ", "0"}], "}"}], ",", 
                              " ", 
                              RowBox[{"{", 
                                RowBox[{"Inherited", ",", " ", "0"}], 
                                "}"}]}], "}"}]}], ",", "\n", 
                        RowBox[{
                        "WindowFrameElements", "->", "\"\<CloseBox\>\""}], 
                        ",", 
                        RowBox[{"WindowElements", " ", "->", " ", 
                          RowBox[{"{", "}"}]}], ",", "\n", 
                        RowBox[{"WindowClickSelect", "->", "False"}], ",", 
                        RowBox[{"Active", "->", "True"}], ",", "\n", 
                        RowBox[{"ScrollingOptions", "->", 
                          RowBox[{"{", 
                            RowBox[{
                            "\"\<PagewiseScrolling\>\"", "->", "True"}], 
                            "}"}]}], ",", "\n", 
                        RowBox[{"ShowCellBracket", "->", "False"}], ",", 
                        "\n", 
                        RowBox[{"CellMargins", "->", 
                          RowBox[{"{", 
                            RowBox[{
                              RowBox[{"{", 
                                RowBox[{"0", ",", " ", "0"}], "}"}], ",", 
                              " ", 
                              RowBox[{"{", 
                                RowBox[{"Inherited", ",", " ", "0"}], 
                                "}"}]}], "}"}]}]}], "]"}], "]"}], ";", "\n", 
                  RowBox[{"SetSelectedNotebook", "[", 
                    RowBox[{"ButtonNotebook", "[", "]"}], "]"}], ";"}]}], 
              "\n", "\t\t", 
              RowBox[{"(*", 
                RowBox[{"NotebookClose", "[", " ", "\n", "            ", 
                  RowBox[{"ButtonNotebook", "[", " ", "]"}], "]"}], "*)"}], 
              "]"}]}]}], "]"}]}]}], "Input",
  ShowCellBracket->False,
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["GroupCalculator", "Subsection",
  ShowCellBracket->False,
  CellOpen->False],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        RowBox[{"NeedsOperandQ", "  ", ":=", " ", 
          RowBox[{"!", "  ", "NeedsOperatorQ"}]}], ";", " ", "\n", 
        RowBox[{"EqualsLastQ", " ", "=", " ", "False"}], ";", "\n", 
        RowBox[{"CalculatorNumber", " ", "=", " ", "0"}], ";", "\n", "\n", 
        RowBox[{"(*", " ", 
          RowBox[{
          "The", " ", "following", " ", "are", " ", "functions", " ", "that", 
            " ", "various", " ", "buttons", " ", "call"}], " ", "*)"}], 
        "\n", 
        RowBox[{"(*", " ", 
          RowBox[{
          "This", " ", "first", " ", "collection", " ", "are", " ", "on", 
            " ", "the", " ", "actual", " ", "GroupCalculator"}], " ", "*)"}], 
        "\n", "\n", 
        RowBox[{
          RowBox[{"PushOperand", "[", 
            RowBox[{"elm_", ",", "  ", "tag_"}], "]"}], "  ", ":=", " ", 
          RowBox[{"Module", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{"nb", ",", " ", 
                  RowBox[{"el", "  ", "=", "  ", 
                    RowBox[{"elm", "[", 
                      RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
              "\n", "\t", 
              RowBox[{"If", "[", 
                RowBox[{"NeedsOperandQ", ",", " ", "\n", "\t\t", 
                  RowBox[{
                    RowBox[{"nb", "  ", "=", " ", 
                      RowBox[{"SelectedNotebook", "[", "]"}]}], ";", " ", 
                    "\n", "\t\t", 
                    RowBox[{"NotebookFind", "[", 
                      RowBox[{
                      "nb", ",", " ", "tag", ",", " ", "All", ",", " ", 
                        "CellTags", ",", " ", 
                        RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                      "]"}], ";", " ", "\n", "\t\t", 
                    RowBox[{"If", "[", 
                      RowBox[{
                        RowBox[{"Operands", "  ", "===", "  ", 
                          RowBox[{"{", "}"}]}], ",", 
                        RowBox[{"PushClear", "[", "tag", "]"}]}], "]"}], ";", 
                    " ", "\n", "\t\t", 
                    RowBox[{"SelectionMove", "[", 
                      RowBox[{
                      "nb", ",", " ", "After", ",", " ", "CellContents", 
                        ",", 
                        RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                      "]"}], ";", "\n", "\t\t", 
                    RowBox[{"NotebookWrite", "[", 
                      RowBox[{"nb", ",", " ", 
                        RowBox[{"Cell", "[", 
                          RowBox[{"FormBox", "[", 
                            RowBox[{"el", ",", " ", "StandardForm"}], "]"}], 
                          "]"}], ",", 
                        RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                      "]"}], ";", " ", "\n", "\t\t", 
                    RowBox[{"AppendTo", "[", 
                      RowBox[{"Operands", ",", "  ", "elm"}], "]"}], ";", 
                    " ", "\n", "\t\t", 
                    RowBox[{"NeedsOperatorQ", "  ", "=", "  ", "True"}], ";", 
                    "\n", "\t\t", 
                    RowBox[{"EqualsLastQ", " ", "=", " ", "False"}], ";"}]}], 
                " ", "]"}]}], "]"}]}]}], "\n"}], 
    RowBox[{" ", 
      RowBox[{
        RowBox[{"PushRandEl", "[", " ", "tag_", "]"}], "  ", ":=", "  ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"nb", ",", " ", "el"}], "}"}], ",", "   ", "\n", "\t", 
            RowBox[{"If", "[", 
              RowBox[{"NeedsOperandQ", ",", "  ", "\n", "\t\t", 
                RowBox[{
                  RowBox[{"nb", "  ", "=", " ", 
                    RowBox[{"SelectedNotebook", "[", "]"}]}], ";", " ", "\n", 
                  "\t\t", 
                  RowBox[{"NotebookFind", "[", 
                    RowBox[{
                    "nb", ",", " ", "tag", ",", " ", "All", ",", " ", 
                      "CellTags", ",", " ", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}], ";", " ", "\n", "\t\t", 
                  RowBox[{"If", "[", 
                    RowBox[{
                      RowBox[{"Operands", "  ", "===", "  ", 
                        RowBox[{"{", "}"}]}], ",", " ", 
                      RowBox[{"PushClear", "[", "tag", "]"}]}], "]"}], ";", 
                  " ", "\n", "\t\t", 
                  RowBox[{"SelectionMove", "[", 
                    RowBox[{
                    "nb", ",", " ", "After", ",", " ", "CellContents", ",", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}], ";", " ", "\n", "\t\t", 
                  RowBox[{"el", "  ", "=", "  ", 
                    RowBox[{
                      RowBox[{"RandomElement", "[", 
                        RowBox[{"pushedGroup", " ", "//", " ", "Elements"}], 
                        "]"}], " ", "//", " ", "ToBoxes"}]}], ";", " ", "\n", 
                  "\t\t", 
                  RowBox[{"NotebookWrite", "[", 
                    RowBox[{"nb", ",", " ", 
                      RowBox[{"Cell", "[", 
                        RowBox[{"FormBox", "[", 
                          RowBox[{"el", ",", " ", "StandardForm"}], "]"}], 
                        "]"}], ",", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}], ";", " ", "\n", "\t\t", 
                  RowBox[{"el", "  ", "=", " ", 
                    RowBox[{"el", " ", "//", " ", "BoxData"}]}], ";", " ", 
                  "\n", "\t\t", 
                  RowBox[{"AppendTo", "[", 
                    RowBox[{"Operands", ",", "  ", "el"}], "]"}], ";", "\n", 
                  "\t\t", 
                  RowBox[{"NeedsOperatorQ", "  ", "=", "  ", "True"}], ";", 
                  "\n", "\t\t", 
                  RowBox[{"EqualsLastQ", " ", "=", " ", "False"}], ";"}]}], 
              " ", "]"}]}], "]"}]}], " ", "\n"}], 
    RowBox[{" ", 
      RowBox[{
        RowBox[{"PushBinOp", "[", "tag_", "]"}], " ", ":=", " ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", "nb", "}"}], ",", "  ", "\n", "\t", 
            RowBox[{"If", "[", 
              RowBox[{
                RowBox[{"NeedsOperatorQ", " ", "||", " ", "EqualsLastQ"}], 
                ",", " ", "\n", "\t\t", 
                RowBox[{
                  RowBox[{"nb", "  ", "=", " ", 
                    RowBox[{"SelectedNotebook", "[", "]"}]}], ";", " ", "\n", 
                  "\t\t", 
                  RowBox[{"NotebookFind", "[", 
                    RowBox[{
                    "nb", ",", " ", "tag", ",", " ", "All", ",", " ", 
                      "CellTags", ",", " ", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}], ";", "\n", "\t\t", 
                  RowBox[{"If", "[", 
                    RowBox[{"EqualsLastQ", ",", " ", 
                      RowBox[{"PushBinOpWithResult", "[", 
                        RowBox[{"tag", ",", " ", "nb"}], "]"}]}], "]"}], ";", 
                  " ", "\n", "\t\t", 
                  RowBox[{"SelectionMove", "[", 
                    RowBox[{"nb", ",", "After", ",", "CellContents", ",", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}], ";", "\n", "\t\t", 
                  RowBox[{"NotebookWrite", "[", 
                    RowBox[{"nb", ",", "  ", 
                      RowBox[{"TextData", "[", 
                        RowBox[{"{", 
                          RowBox[{
                          "\"\< \>\"", ",", "opSymb", ",", "\"\< \>\""}], 
                          "}"}], "]"}], ",", " ", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}], ";", "\n", "\t\t", 
                  RowBox[{"NeedsOperatorQ", " ", "=", " ", "False"}], ";", 
                  "\n", "\t\t", 
                  RowBox[{"EqualsLastQ", " ", "=", " ", "False"}], ";"}]}], 
              "]"}]}], "]"}]}], "\n"}], 
    RowBox[{
      RowBox[{
        RowBox[{"PushBinOpWithResult", "[", 
          RowBox[{"tag_", ",", " ", "nb_"}], "]"}], " ", ":=", " ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"el", " ", "=", " ", "groupResult"}], "}"}], ",", "\n", 
            "\t", 
            RowBox[{
              RowBox[{"ClearCell", "[", "tag", "]"}], ";", "\n", "\t", 
              RowBox[{"SelectionMove", "[", 
                RowBox[{
                "nb", ",", " ", "After", ",", " ", "CellContents", ",", 
                  RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
              ";", "\n", "\t", 
              RowBox[{"NotebookWrite", "[", 
                RowBox[{"nb", ",", " ", 
                  RowBox[{"Cell", "[", 
                    RowBox[{"FormBox", "[", 
                      RowBox[{
                        RowBox[{"el", "//", "First"}], ",", " ", 
                        "StandardForm"}], "]"}], "]"}], ",", 
                  RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
              ";", " ", "\n", "\t", 
              RowBox[{"AppendTo", "[", 
                RowBox[{"Operands", ",", " ", "el"}], "]"}], ";"}]}], "\n", 
          "]"}]}], "\n"}], 
    RowBox[{" ", 
      RowBox[{
        RowBox[{
          RowBox[{"PushEqual", "[", "tag_", "]"}], " ", ":=", " ", 
          RowBox[{"Module", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{"nb", ",", "g", ",", "ops", ",", "el"}], "}"}], ",", 
              "  ", "\n", "\t", 
              RowBox[{"If", "[", 
                RowBox[{"NeedsOperatorQ", ",", " ", "\n", "\t\t", 
                  RowBox[{
                    RowBox[{"nb", "  ", "=", " ", 
                      RowBox[{"SelectedNotebook", "[", "]"}]}], ";", " ", 
                    "\n", "\t\t", 
                    RowBox[{"NotebookFind", "[", 
                      RowBox[{
                      "nb", ",", " ", "tag", ",", " ", "All", ",", " ", 
                        "CellTags", ",", " ", 
                        RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                      "]"}], ";", " ", "\n", "\t\t", 
                    RowBox[{"ops", " ", "=", " ", 
                      RowBox[{"Map", "[", 
                        RowBox[{"ToExpression", ",", "Operands"}], "]"}]}], 
                    ";", "\n", "\t\t", 
                    RowBox[{"SelectionMove", "[", 
                      RowBox[{"nb", ",", "After", ",", "CellContents", ",", 
                        RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                      "]"}], ";", "\n", "\t\t", 
                    RowBox[{"g", " ", "=", " ", 
                      RowBox[{"Fold", "[", 
                        RowBox[{
                          RowBox[{"Operation", "[", "pushedGroup", "]"}], 
                          ",", 
                          RowBox[{"First", "[", "ops", "]"}], ",", 
                          RowBox[{"Rest", "[", "ops", "]"}]}], "]"}]}], ";", 
                    "\n", "\t\t", 
                    RowBox[{"el", " ", "=", " ", 
                      RowBox[{"g", "//", "ToBoxes"}]}], ";", "\n", "\t\t", 
                    RowBox[{"NotebookWrite", "[", 
                      RowBox[{"nb", ",", 
                        RowBox[{"TextData", "[", 
                          RowBox[{"{", "\"\< = \>\"", "}"}], "]"}], ",", 
                        RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                      "]"}], ";", "\n", "\t\t", 
                    RowBox[{"NotebookWrite", "[", 
                      RowBox[{"nb", ",", 
                        RowBox[{"Cell", "[", 
                          RowBox[{"FormBox", "[", 
                            RowBox[{"el", ",", "StandardForm"}], "]"}], 
                          "]"}], ",", 
                        RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                      "]"}], ";", "\n", "\t\t", 
                    RowBox[{"NeedsOperatorQ", " ", "=", " ", "False"}], ";", 
                    "\n", "\t\t", 
                    RowBox[{"Operands", " ", "=", " ", 
                      RowBox[{"{", "}"}]}], ";", "\n", "\t\t", 
                    RowBox[{"EqualsLastQ", " ", "=", " ", "True"}], ";", 
                    "\n", "\t\t", 
                    RowBox[{"groupResult", " ", "=", " ", 
                      RowBox[{"BoxData", "[", "el", "]"}]}]}]}], "]"}]}], 
            "]"}]}], ";", "\n", "\n", "  ", 
        RowBox[{
          RowBox[{"WipeLastItem", "[", "tag_", "]"}], " ", ":=", " ", 
          RowBox[{"Module", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{"nb", ",", "read"}], "}"}], ",", "\n", "\t\t", 
              RowBox[{
                RowBox[{"nb", "  ", "=", " ", 
                  RowBox[{"SelectedNotebook", "[", "]"}]}], ";", " ", "\n", 
                "\t\t", 
                RowBox[{"NotebookFind", "[", 
                  RowBox[{
                  "nb", ",", " ", "tag", ",", " ", "All", ",", " ", 
                    "CellTags", ",", " ", 
                    RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
                ";", " ", "\n", "\t\t", 
                RowBox[{"SelectionMove", "[", 
                  RowBox[{"nb", ",", "All", ",", "CellContents", ",", 
                    RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
                ";", "\n", "\t\t", 
                RowBox[{"read", " ", "=", " ", 
                  RowBox[{"NotebookRead", "[", "nb", "]"}]}], ";", "\n", 
                "\t\t", 
                RowBox[{"If", "[", 
                  RowBox[{
                    RowBox[{
                      RowBox[{"Head", "[", "read", "]"}], " ", "===", " ", 
                      "List"}], ",", "\n", "\t\t\t", 
                    RowBox[{"NotebookWrite", "[", 
                      RowBox[{"nb", ",", 
                        RowBox[{"TextData", "[", 
                          RowBox[{"Drop", "[", 
                            RowBox[{"read", ",", 
                              RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
                        RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                      "]"}], ",", "\n", "\t\t\t", 
                    RowBox[{"NotebookDelete", "[", "nb", "]"}]}], "]"}], ";", 
                "\n", "\t\t", 
                RowBox[{"SelectionMove", "[", 
                  RowBox[{"nb", ",", "After", ",", "CellContents", ",", 
                    RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
                ";", "\n", "\t\t", "nb"}]}], "]"}]}]}], "\n"}], 
    RowBox[{
      RowBox[{
        RowBox[{"PushInverse", "[", "tag_", "]"}], " ", ":=", " ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"nb", ",", "g", ",", " ", "inv"}], "}"}], ",", "  ", 
            "\n", "\t", 
            RowBox[{"If", "[", 
              RowBox[{"NeedsOperatorQ", ",", "\n", "\t\t", 
                RowBox[{
                  RowBox[{"nb", " ", "=", 
                    RowBox[{"WipeLastItem", "[", "tag", "]"}]}], ";", "\n", 
                  "\t\t", 
                  RowBox[{"g", " ", "=", " ", 
                    RowBox[{"Last", "[", "Operands", "]"}]}], ";", "\n", 
                  "\t\t", 
                  RowBox[{"inv", " ", "=", " ", 
                    RowBox[{"GroupInverse", "[", 
                      RowBox[{"pushedGroup", ",", 
                        RowBox[{"ToExpression", "[", "g", "]"}]}], "]"}]}], 
                  ";", "\n", "\t\t", 
                  RowBox[{"Operands", " ", "=", " ", 
                    RowBox[{"Join", "[", 
                      RowBox[{
                        RowBox[{"Drop", "[", 
                          RowBox[{"Operands", ",", 
                            RowBox[{"-", "1"}]}], "]"}], ",", 
                        RowBox[{"{", 
                          RowBox[{"BoxData", "[", 
                            RowBox[{"ToBoxes", "[", "inv", "]"}], "]"}], 
                          "}"}]}], "]"}]}], ";", "\n", "\t\t", 
                  RowBox[{"NotebookWrite", "[", 
                    RowBox[{"nb", ",", 
                      RowBox[{"Cell", "[", 
                        RowBox[{"FormBox", "[", 
                          RowBox[{
                            RowBox[{"ToBoxes", "[", "inv", "]"}], ",", 
                            "StandardForm"}], "]"}], "]"}], ",", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}]}]}], "]"}]}], "]"}]}], "\n"}], 
    RowBox[{
      RowBox[{
        RowBox[{"PushSquare", "[", "tag_", "]"}], " ", ":=", " ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"nb", ",", "g", ",", "sq"}], "}"}], ",", "  ", "\n", 
            "\t", 
            RowBox[{"If", "[", 
              RowBox[{"NeedsOperatorQ", ",", " ", "\n", "\t\t", 
                RowBox[{
                  RowBox[{"nb", " ", "=", 
                    RowBox[{"WipeLastItem", "[", "tag", "]"}]}], ";", "\n", 
                  "\t\t", 
                  RowBox[{"g", " ", "=", " ", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"Last", "[", "Operands", "]"}], "//", 
                        "First"}], "//", "ToExpression"}]}], ";", "\n", 
                  "\t\t", 
                  RowBox[{"sq", " ", "=", " ", 
                    RowBox[{
                      RowBox[{"Operation", "[", "pushedGroup", "]"}], "[", 
                      RowBox[{"g", ",", "g"}], "]"}]}], ";", "\n", "\t\t", 
                  RowBox[{"Operands", " ", "=", " ", 
                    RowBox[{"Join", "[", 
                      RowBox[{
                        RowBox[{"Drop", "[", 
                          RowBox[{"Operands", ",", 
                            RowBox[{"-", "1"}]}], "]"}], ",", 
                        RowBox[{"{", 
                          RowBox[{"BoxData", "[", 
                            RowBox[{"ToBoxes", "[", "sq", "]"}], "]"}], 
                          "}"}]}], "]"}]}], ";", "\n", "\t\t", 
                  RowBox[{"NotebookWrite", "[", 
                    RowBox[{"nb", ",", 
                      RowBox[{"Cell", "[", 
                        RowBox[{"FormBox", "[", 
                          RowBox[{
                            RowBox[{"ToBoxes", "[", "sq", "]"}], ",", 
                            "StandardForm"}], "]"}], "]"}], ",", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}]}]}], "]"}]}], "]"}]}], "\n"}], 
    RowBox[{" ", 
      RowBox[{
        RowBox[{"PushDelete", "[", "tag_", "]"}], " ", ":=", " ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", "nb", "}"}], ",", "  ", "\n", "\t", 
            RowBox[{
              RowBox[{"If", "[", 
                RowBox[{
                  RowBox[{"Operands", "  ", "=!=", "  ", 
                    RowBox[{"{", "}"}]}], ",", "\n", "\t\t\t", 
                  RowBox[{
                    RowBox[{"nb", " ", "=", 
                      RowBox[{"WipeLastItem", "[", "tag", "]"}]}], ";", "\n", 
                    "\t\t\t", 
                    RowBox[{"NeedsOperatorQ", " ", "=", " ", 
                      RowBox[{"!", " ", "NeedsOperatorQ"}]}], ";", "\n", 
                    "\t\t\t", 
                    RowBox[{"If", "[", 
                      RowBox[{"NeedsOperandQ", ",", " ", 
                        RowBox[{"Operands", " ", "=", "  ", 
                          RowBox[{"Drop", "[", 
                            RowBox[{"Operands", ",", 
                              RowBox[{"-", "1"}]}], "]"}]}]}], "]"}]}]}], 
                "]"}], ";"}]}], "]"}]}], "\n"}], 
    RowBox[{" ", 
      RowBox[{
        RowBox[{"PushClear", "[", "tag_", "]"}], " ", ":=", " ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", "nb", "}"}], ",", "  ", "\n", "\t", 
            RowBox[{
              RowBox[{"nb", "  ", "=", " ", 
                RowBox[{"SelectedNotebook", "[", "]"}]}], ";", "\n", "\t", 
              RowBox[{"ClearCell", "[", "\"\<memory\>\"", "]"}], ";", "\n", 
              "\t", 
              RowBox[{"NotebookFind", "[", 
                RowBox[{
                "nb", ",", " ", "tag", ",", " ", "All", ",", " ", "CellTags", 
                  ",", " ", 
                  RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
              ";", " ", "\n", "\t", 
              RowBox[{"Operands", " ", "=", " ", 
                RowBox[{"{", "}"}]}], ";", "\n", "\t", 
              RowBox[{"NeedsOperatorQ", " ", "=", " ", "False"}], ";", "\n", 
              "\t", 
              RowBox[{"SelectionMove", "[", 
                RowBox[{"nb", ",", "All", ",", "CellContents", ",", 
                  RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
              ";", "\n", "\t", 
              RowBox[{"NotebookDelete", "[", "nb", "]"}], ";", "\n", "\t", 
              RowBox[{"groupResult", " ", "=", " ", 
                RowBox[{"BoxData", "[", "\"\<\>\"", "]"}]}], ";", "\n", 
              "\t", 
              RowBox[{"MemoryItem", " ", "=", " ", "\"\<\>\""}], ";"}]}], 
          "]"}]}], "\n"}], 
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{"ClearCell", "[", "tag_", "]"}], " ", ":=", " ", 
          RowBox[{"Module", "[", 
            RowBox[{
              RowBox[{"{", "nb", "}"}], ",", "  ", "\n", "\t\t", 
              RowBox[{
                RowBox[{"nb", "  ", "=", " ", 
                  RowBox[{"SelectedNotebook", "[", "]"}]}], ";", " ", "\n", 
                "\t\t", 
                RowBox[{"NotebookFind", "[", 
                  RowBox[{
                  "nb", ",", " ", "tag", ",", " ", "All", ",", " ", 
                    "CellTags", ",", " ", 
                    RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
                ";", " ", "\n", "\t\t", 
                RowBox[{"SelectionMove", "[", 
                  RowBox[{"nb", ",", "All", ",", "CellContents", ",", 
                    RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], "]"}], 
                ";", "\n", "\t\t", 
                RowBox[{"NotebookDelete", "[", "nb", "]"}]}]}], "]"}]}], ";", 
        "\n", "\n", " ", 
        RowBox[{
          RowBox[{"PushStore", "[", "tag_", "]"}], " ", ":=", " ", 
          RowBox[{"Module", "[", 
            RowBox[{
              RowBox[{"{", 
                RowBox[{"nb", ",", " ", 
                  RowBox[{"ok", " ", "=", " ", "False"}], ",", " ", "item"}], 
                "}"}], ",", "  ", "\n", "\t", 
              RowBox[{
                RowBox[{"If", "[", 
                  RowBox[{"NeedsOperatorQ", ",", "\n", "\t\t\t", 
                    RowBox[{
                      RowBox[{"ok", " ", "=", " ", "True"}], ";", "\n", 
                      "\t\t\t", 
                      RowBox[{"MemoryItem", " ", "=", " ", 
                        RowBox[{"item", " ", "=", " ", 
                          RowBox[{
                            RowBox[{"Last", "[", "Operands", "]"}], "//", 
                            "First"}]}]}]}]}], "]"}], ";", "\n", "\t", 
                RowBox[{"If", "[", 
                  RowBox[{
                    RowBox[{"NeedsOperandQ", " ", "&&", " ", 
                      RowBox[{"Operands", " ", "===", 
                        RowBox[{"{", "}"}]}]}], ",", "\n", "\t\t\t", 
                    RowBox[{
                      RowBox[{"ok", " ", "=", " ", "True"}], ";", "\n", 
                      "\t\t\t", 
                      RowBox[{"MemoryItem", " ", "=", " ", 
                        RowBox[{"item", " ", "=", 
                          RowBox[{"groupResult", "//", "First"}]}]}]}]}], 
                  "]"}], ";", "\n", "\t", 
                RowBox[{"If", "[", 
                  RowBox[{"ok", ",", "\n", "\t\t", 
                    RowBox[{
                      RowBox[{"nb", "  ", "=", " ", 
                        RowBox[{"SelectedNotebook", "[", "]"}]}], ";", " ", 
                      "\n", "\t\t", 
                      RowBox[{"NotebookFind", "[", 
                        RowBox[{
                        "nb", ",", " ", "tag", ",", " ", "All", ",", " ", 
                          "CellTags", ",", " ", 
                          RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                        "]"}], ";", " ", "\n", "\t\t", 
                      RowBox[{"SelectionMove", "[", 
                        RowBox[{"nb", ",", "All", ",", "CellContents", ",", 
                          RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                        "]"}], ";", "\n", "\t\t", 
                      RowBox[{"NotebookDelete", "[", "nb", "]"}], ";", "\n", 
                      "\t\t", 
                      RowBox[{"NotebookWrite", "[", 
                        RowBox[{"nb", ",", 
                          RowBox[{"Cell", "[", 
                            RowBox[{"FormBox", "[", 
                              RowBox[{"item", ",", "StandardForm"}], "]"}], 
                            "]"}], ",", 
                          RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                        "]"}]}]}], "]"}]}]}], "]"}]}]}], "\n"}], 
    RowBox[{
      RowBox[{
        RowBox[{"PushRecall", "[", "tag_", "]"}], "  ", ":=", " ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"nb", ",", " ", 
                RowBox[{"el", "  ", "=", " ", "MemoryItem"}]}], "}"}], ",", 
            " ", "\n", "\t", 
            RowBox[{"If", "[", 
              RowBox[{
                RowBox[{"NeedsOperandQ", " ", "&&", " ", 
                  RowBox[{"MemoryItem", " ", "=!=", " ", "\"\<\>\""}]}], ",", 
                " ", "\n", "\t\t", 
                RowBox[{
                  RowBox[{"nb", "  ", "=", " ", 
                    RowBox[{"SelectedNotebook", "[", "]"}]}], ";", " ", "\n", 
                  "\t\t", 
                  RowBox[{"NotebookFind", "[", 
                    RowBox[{
                    "nb", ",", " ", "tag", ",", " ", "All", ",", " ", 
                      "CellTags", ",", " ", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}], ";", " ", "\n", "\t\t", 
                  RowBox[{"If", "[", 
                    RowBox[{
                      RowBox[{"Operands", "  ", "===", "  ", 
                        RowBox[{"{", "}"}]}], ",", " ", 
                      RowBox[{"PushClear", "[", "tag", "]"}]}], "]"}], ";", 
                  " ", "\n", "\t\t", 
                  RowBox[{"SelectionMove", "[", 
                    RowBox[{
                    "nb", ",", " ", "After", ",", " ", "CellContents", ",", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}], ";", "\n", "\t\t", 
                  RowBox[{"NotebookWrite", "[", 
                    RowBox[{"nb", ",", " ", 
                      RowBox[{"Cell", "[", 
                        RowBox[{"FormBox", "[", 
                          RowBox[{"el", ",", " ", "StandardForm"}], "]"}], 
                        "]"}], ",", 
                      RowBox[{"AutoScroll", " ", "->", " ", "False"}]}], 
                    "]"}], ";", " ", "\n", "\t\t", 
                  RowBox[{"AppendTo", "[", 
                    RowBox[{"Operands", ",", "  ", 
                      RowBox[{"BoxData", "[", "el", "]"}]}], "]"}], ";", " ", 
                  "\n", "\t\t", 
                  RowBox[{"NeedsOperatorQ", "  ", "=", "  ", "True"}], 
                  ";"}]}], " ", "]"}]}], "]"}]}], ";", " ", "\n", "\n", 
      RowBox[{"GroupCalculator", " ", ":=", " ", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", " ", 
              RowBox[{"nb2", ",", "G", ",", " ", "square", ",", "inv"}], 
              "}"}], ",", "\n", "\t\t\t", 
            RowBox[{
              RowBox[{"G", " ", "=", " ", "GetStructure"}], ";", "\n", "\t", 
              RowBox[{"If", "[", 
                RowBox[{
                  RowBox[{"ValidGroupoid", "[", "G", "]"}], ",", "\n", "\t", 
                  RowBox[{
                    RowBox[{"NeedsOperatorQ", " ", "=", " ", "False"}], ";", 
                    "\n", "\t", 
                    RowBox[{"Operands", " ", "=", " ", 
                      RowBox[{"{", "}"}]}], ";", "\n", "\t", 
                    RowBox[{"CalculatorNumber", "++"}], ";", "\n", "  ", 
                    RowBox[{"MemoryItem", " ", "=", " ", "\"\<\>\""}], ";", 
                    "\n", "\t", 
                    RowBox[{"opSymb", " ", "=", " ", 
                      RowBox[{"OperatorSymbol", "[", "G", "]"}]}], ";", "\n", 
                    "\t", 
                    RowBox[{"inv", " ", "=", " ", 
                      RowBox[{"If", "[", 
                        RowBox[{
                          RowBox[{"opSymb", " ", "===", " ", "\"\<+\>\""}], 
                          ",", 
                          RowBox[{"FormBox", "[", "\n", "        ", 
                            RowBox[{
                              RowBox[{"RowBox", "[", 
                                RowBox[{"{", 
                                  RowBox[{
                                  "\"\<-\>\"", ",", " ", "\"\<x\>\""}], 
                                  "}"}], "]"}], ",", " ", 
                              "TraditionalForm"}], "]"}], ",", " ", 
                          RowBox[{"FormBox", "[", "\n", "        ", 
                            RowBox[{
                              RowBox[{"SuperscriptBox", "[", 
                                RowBox[{
                                "\"\<x\>\"", ",", " ", "\n", "        ", 
                                  RowBox[{"RowBox", "[", 
                                    RowBox[{"{", 
                                      RowBox[{
                                      "\"\<-\>\"", ",", " ", "\"\<1\>\""}], 
                                      "}"}], "]"}]}], "]"}], ",", " ", 
                              "TraditionalForm"}], "]"}]}], "]"}]}], ";", 
                    "\n", "\t", 
                    RowBox[{"square", " ", "=", " ", 
                      RowBox[{"If", "[", 
                        RowBox[{
                          RowBox[{"opSymb", " ", "===", " ", "\"\<+\>\""}], 
                          ",", " ", 
                          RowBox[{"FormBox", "[", "\n", "        ", 
                            RowBox[{
                              RowBox[{"RowBox", "[", 
                                RowBox[{"{", 
                                  RowBox[{
                                  "\"\<2\>\"", ",", " ", "\"\<x\>\""}], 
                                  "}"}], "]"}], ",", " ", 
                              "TraditionalForm"}], "]"}], ",", " ", 
                          RowBox[{"FormBox", "[", "\n", "        ", 
                            RowBox[{
                              RowBox[{"SuperscriptBox", "[", 
                                RowBox[{"\"\<x\>\"", ",", " ", "\"\<2\>\""}], 
                                "]"}], ",", " ", "TraditionalForm"}], 
                            "]"}]}], "]"}]}], ";", "\n", "\t", 
                    RowBox[{"nb2", " ", "=", " ", 
                      RowBox[{"NotebookCreate", "[", 
                        RowBox[{
                          RowBox[{"WindowFrame", "->", "\"\<Normal\>\""}], 
                          ",", 
                          RowBox[{"WindowSize", " ", "->", " ", 
                            RowBox[{"{", 
                              RowBox[{"480", ",", " ", "375"}], "}"}]}], 
                          ",", 
                          RowBox[{"WindowElements", "->", 
                            RowBox[{"{", 
                              RowBox[{
                              "\"\<HorizontalScrollBar\>\"", ",", 
                                "\"\<VerticalScrollBar\>\""}], "}"}]}], ",", 
                          "\n", "\t\t\t\t", 
                          RowBox[{"WindowFrameElements", "->", 
                            RowBox[{"{", 
                              RowBox[{
                              "\"\<CloseBox\>\"", ",", " ", 
                                "\"\<ZoomBox\>\"", ",", " ", 
                                "\"\<ResizeArea\>\""}], "}"}]}], ",", "\n", 
                          "\t", 
                          RowBox[{"WindowTitle", " ", "->", 
                            RowBox[{"\"\<GroupCalculator\>\"", "<>", 
                              RowBox[{
                              "ToString", "[", "CalculatorNumber", "]"}]}]}], 
                          ",", "\n", "\t\t\t\t", 
                          RowBox[{"WindowMargins", "->", 
                            RowBox[{"{", 
                              RowBox[{
                                RowBox[{"{", 
                                  RowBox[{"4", ",", "Automatic"}], "}"}], 
                                ",", 
                                RowBox[{"{", 
                                  RowBox[{"Automatic", ",", "4"}], "}"}]}], 
                              "}"}]}]}], "]"}]}], ";", "\n", "\t", 
                    RowBox[{"NotebookPut", "[", 
                      RowBox[{
                        RowBox[{"Notebook", "[", 
                          RowBox[{
                            RowBox[{"{", "\n", "\t\t\t", 
                              RowBox[{
                                RowBox[{"Cell", "[", 
                                  RowBox[{
                                    RowBox[{"RowBox", "[", 
                                      RowBox[{"{", 
                                        RowBox[{
                                        "\"\<A calculator for the group \>\"",
                                         ",", 
                                        RowBox[{
                                        "FormBox", "[", "\n", "           ", 
                                        RowBox[{
                                        "pushedGroupName", ",", " ", 
                                        "TraditionalForm"}], "]"}]}], "}"}], 
                                      "]"}], ",", " ", "\"\<Text\>\"", ",", 
                                    RowBox[{
                                    "FontSize", " ", "->", " ", "20"}], ",", 
                                    RowBox[{
                                    "TextAlignment", "->", "Center"}], ",", 
                                    RowBox[{
                                    "ShowCellBracket", "->", "False"}], ",", 
                                    RowBox[{
                                    "Editable", " ", "->", " ", "False"}], 
                                    ",", " ", 
                                    RowBox[{
                                    "Selectable", " ", "->", " ", "False"}], 
                                    ",", " ", 
                                    RowBox[{
                                    "Deletable", " ", "->", " ", "False"}]}], 
                                  "]"}], ",", "\n", "\t\t\t", 
                                RowBox[{"Cell", "[", 
                                  RowBox[{
                                  "\"\<\>\"", ",", " ", "\"\<Text\>\"", ",", 
                                    RowBox[{"Editable", "->", "True"}], ",", 
                                    RowBox[{"PageWidth", "->", "450"}], ",", 
                                    " ", 
                                    RowBox[{
                                    "TextAlignment", "->", "Center"}], ",", 
                                    "\n", "         ", 
                                    RowBox[{"Background", " ", "->", " ", 
                                      RowBox[{"RGBColor", "[", 
                                        RowBox[{"1", ",", "1", ",", "0"}], 
                                        "]"}]}], ",", 
                                    RowBox[{"FontColor", " ", "->", " ", 
                                      RowBox[{"RGBColor", "[", 
                                        RowBox[{"0", ",", "0", ",", "1"}], 
                                        "]"}]}], ",", "\n", "\t\t\t\t", 
                                    RowBox[{
                                    "FontSize", " ", "->", " ", "14"}], ",", 
                                    " ", 
                                    RowBox[{
                                    "CellTags", "->", "\"\<screen\>\""}], 
                                    ",", 
                                    RowBox[{
                                    "ShowCellBracket", "->", "False"}]}], 
                                  "]"}], ",", "\n", "\t\t\t", 
                                RowBox[{"Cell", "[", 
                                  RowBox[{
                                    RowBox[{"BoxData", "[", 
                                      RowBox[{"RowBox", "[", 
                                        RowBox[{"Join", "[", 
                                        RowBox[{
                                        RowBox[{
                                        "{", "\"\<Elements:\>\"", "}"}], ",", 
                                        " ", 
                                        RowBox[{"Map", "[", 
                                        RowBox[{
                                        RowBox[{
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{
                                        RowBox[{"ToBoxes", "[", "#", "]"}], 
                                        ",", 
                                        RowBox[{
                                        "ButtonSource", "->", 
                                        "ButtonContents"}], ",", "\n", 
                                        "\t\t\t\t\t\t\t\t  ", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{"(", 
                                        RowBox[{
                                        RowBox[{"PushOperand", "[", 
                                        RowBox[{"#", ",", "\"\<screen\>\""}], 
                                        "]"}], "&"}], ")"}]}], ",", "\n", 
                                        "                ", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}], 
                                        "&"}], ",", " ", 
                                        RowBox[{
                                        "Elements", "[", "G", "]"}]}], 
                                        "]"}]}], "]"}], "]"}], "]"}], ",", 
                                    "\n", "\t\t\t\t\t\t", 
                                    RowBox[{"(*", " ", 
                                      RowBox[{"NotebookDefault", ","}], 
                                      "*)"}], " ", 
                                    RowBox[{"Active", "->", "True"}], ",", 
                                    RowBox[{"AutoIndent", "->", "True"}], 
                                    ",", " ", 
                                    RowBox[{
                                    "ZeroWidthTimes", "->", "False"}], ",", 
                                    RowBox[{"LineIndent", "->", "0"}], ",", 
                                    RowBox[{
                                    "FontFamily", "->", "\"\<Courier\>\""}], 
                                    ",", 
                                    RowBox[{
                                    "FontWeight", "->", "\"\<Plain\>\""}], 
                                    ",", 
                                    RowBox[{
                                    "FontSize", " ", "->", " ", "14"}], ",", 
                                    " ", 
                                    RowBox[{
                                    "TextAlignment", "->", "Center"}], ",", 
                                    RowBox[{"LineSpacing", "->", 
                                      RowBox[{"{", 
                                        RowBox[{"1.25", ",", " ", "0"}], 
                                        "}"}]}], ",", 
                                    RowBox[{
                                    "ShowCellBracket", "->", "False"}]}], 
                                  "]"}], ",", "\n", "\t\t\t", 
                                RowBox[{"Cell", "[", 
                                  RowBox[{
                                    RowBox[{"BoxData", "[", 
                                      RowBox[{"GridBox", "[", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{
                                        "ButtonBox", "[", "\n", "\t\t\t", 
                                        RowBox[{"opSymb", ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{
                                        "PushBinOp", "[", " ", 
                                        "\"\<screen\>\"", "]"}]}], ",", "\n", 
                                        "\t\t\t", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}], ",", 
                                        " ", "\n", "\t\t\t\t\t\t\t\t\t\t", 
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{"\"\<=\>\"", ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{
                                        "PushEqual", "[", " ", 
                                        "\"\<screen\>\"", "]"}]}], ",", " ", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}], ",", 
                                        " ", "\n", "\t\t\t\t\t\t\t\t\t\t", 
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{
                                        RowBox[{"RowBox", "[", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        "\"\<Random\>\"", ",", " ", 
                                        "\"\< \>\"", ",", " ", 
                                        "\"\<element\>\""}], "}"}], "]"}], 
                                        ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{
                                        "PushRandEl", "[", " ", 
                                        "\"\<screen\>\"", "]"}]}], ",", " ", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}]}], 
                                        "}"}], ",", " ", "\n", "          ", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{"inv", ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{
                                        "PushInverse", "[", " ", 
                                        "\"\<screen\>\"", "]"}]}], ",", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}], ",", 
                                        " ", "\n", "\t\t\t\t\t\t\t\t\t\t", 
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{"\"\<Store\>\"", ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{
                                        "PushStore", "[", " ", 
                                        "\"\<memory\>\"", "]"}]}], ",", " ", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}], ",", 
                                        " ", "\n", "\t\t\t\t\t\t\t\t\t\t", 
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{
                                        RowBox[{"RowBox", "[", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        "\"\<Delete\>\"", ",", " ", 
                                        "\"\< \>\"", ",", " ", 
                                        "\"\<last\>\"", ",", " ", 
                                        "\"\< \>\"", ",", " ", 
                                        "\"\<entry\>\""}], "}"}], "]"}], 
                                        ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{
                                        "PushDelete", "[", " ", 
                                        "\"\<screen\>\"", "]"}]}], ",", " ", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}]}], 
                                        "}"}], ",", "\n", "          ", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{"square", ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{
                                        "PushSquare", "[", " ", 
                                        "\"\<screen\>\"", "]"}]}], ",", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}], ",", 
                                        " ", 
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{"\"\<Recall\>\"", ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{"PushRecall", "[", " ", 
                                        "\"\<screen\>\"", "]"}]}], ",", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}], ",", 
                                        "\n", "        ", 
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{
                                        RowBox[{"RowBox", "[", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        "\"\<Clear\>\"", ",", " ", 
                                        "\"\< \>\"", ",", "\"\<all\>\""}], 
                                        "}"}], "]"}], ",", " ", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{
                                        "PushClear", "[", " ", 
                                        "\"\<screen\>\"", "]"}]}], ",", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}]}], 
                                        "}"}]}], "}"}], ",", " ", 
                                        RowBox[{"RowSpacings", "->", "0"}], 
                                        ",", 
                                        RowBox[{
                                        "ColumnSpacings", "->", "0"}]}], 
                                        "]"}], "]"}], ",", " ", 
                                    RowBox[{"Active", "->", "True"}], ",", 
                                    RowBox[{"LineSpacing", "->", 
                                      RowBox[{"{", 
                                        RowBox[{"1.25", ",", " ", "0"}], 
                                        "}"}]}], ",", 
                                    RowBox[{
                                    "ShowCellBracket", "->", "False"}], ",", 
                                    RowBox[{
                                    "FontFamily", "->", "\"\<Courier\>\""}], 
                                    ",", " ", 
                                    RowBox[{
                                    "TextAlignment", "->", "Center"}], ",", 
                                    RowBox[{
                                    "FontWeight", "->", "\"\<Plain\>\""}], 
                                    ",", " ", 
                                    RowBox[{
                                    "FontSize", " ", "->", " ", "14"}]}], 
                                  "]"}], ",", "\n", 
                                RowBox[{"Cell", "[", 
                                  RowBox[{
                                  "\"\<\>\"", ",", " ", "\"\<Text\>\"", ",", 
                                    " ", 
                                    RowBox[{
                                    "Editable", " ", "->", " ", "True"}], 
                                    ",", " ", 
                                    RowBox[{"PageWidth", "->", "150"}], ",", 
                                    " ", 
                                    RowBox[{
                                    "TextAlignment", "->", "Center"}], ",", 
                                    "\n", "         ", 
                                    RowBox[{"Background", " ", "->", " ", 
                                      RowBox[{"RGBColor", "[", 
                                        RowBox[{"1", ",", "1", ",", "0"}], 
                                        "]"}]}], ",", " ", 
                                    RowBox[{"FontColor", " ", "->", " ", 
                                      RowBox[{"RGBColor", "[", 
                                        RowBox[{"0", ",", "0", ",", "1"}], 
                                        "]"}]}], ",", "\n", "\t\t\t\t", 
                                    RowBox[{
                                    "FontSize", " ", "->", " ", "14"}], ",", 
                                    " ", 
                                    RowBox[{
                                    "CellTags", "->", "\n", 
                                      "\"\<memory\>\""}], ",", 
                                    RowBox[{"CellMargins", "->", 
                                      RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{"150", ",", " ", 
                                        RowBox[{"-", "150"}]}], "}"}], ",", 
                                        " ", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        "Inherited", ",", " ", "Inherited"}], 
                                        "}"}]}], "}"}]}], ",", " ", 
                                    RowBox[{
                                    "ShowCellBracket", "->", "False"}], ",", 
                                    " ", 
                                    RowBox[{
                                    "CellFrame", " ", "->", " ", "False"}]}], 
                                  "]"}], ",", " ", "\n", "\t\t\t", 
                                RowBox[{"Cell", "[", 
                                  RowBox[{
                                    RowBox[{"BoxData", "[", 
                                      RowBox[{"RowBox", "[", 
                                        RowBox[{"{", " ", 
                                        RowBox[{
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{
                                        RowBox[{"RowBox", "[", 
                                        RowBox[{"{", "\"\<Help\>\"", "}"}], 
                                        "]"}], ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{"NotebookPut", "[", "  ", 
                                        RowBox[{"Notebook", "[", " ", 
                                        RowBox[{
                                        RowBox[{"{", " ", 
                                        RowBox[{"Cell", "[", 
                                        RowBox[{
                                        RowBox[{"TextData", "[", 
                                        RowBox[{"{", "\n", "  ", 
                                        RowBox[{
                                        "\"\<This calculator is capable of a \
few basic operations with\ngroup elements. You can choose an element\nby \
simply clicking on the appropriate button reflecting\nthe desired element. \
The following explains the other\nbuttons.\n\t\\n\\nFirst Palette:\n\t\
\\n\\tFirst row:\\n\\t\\t+ (or * or  \>\"", ",", "\n", "  ", 
                                        RowBox[{"StyleBox", "[", 
                                        RowBox[{
                                        "\"\<\[Degree]\>\"", ",", " ", 
                                        RowBox[{"FontSize", "->", "14"}]}], 
                                        "]"}], ",", 
                                        "\"\<) \[Rule] This is the binary \
operator symbol \n\tfor the group at hand; it must follow an element.\n\\n\\t\
\\t= \[Rule] This will calculate the value\nof the sum or product in the \
display.\n\\n\\t\\tRandom Element \[Rule] This produces a random element\n\
from the group.\t\\n\\tSecond row:\\n\\t\\t\>\"", ",", "\n", "  ", 
                                        RowBox[{"Cell", "[", 
                                        RowBox[{"BoxData", "[", " ", 
                                        RowBox[{"FormBox", "[", 
                                        RowBox[{
                                        RowBox[{"RowBox", "[", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        "\"\<-\>\"", ",", " ", "\"\<x\>\""}], 
                                        "}"}], "]"}], ",", " ", 
                                        "TraditionalForm"}], "]"}], "]"}], 
                                        "]"}], ",", "\n", "  ", 
                                        "\"\< (or \>\"", ",", " ", 
                                        RowBox[{"Cell", "[", 
                                        RowBox[{"BoxData", "[", 
                                        RowBox[{"FormBox", "[", 
                                        RowBox[{
                                        RowBox[{"SuperscriptBox", "[", 
                                        RowBox[{"\"\<x\>\"", ",", " ", 
                                        RowBox[{"RowBox", "[", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        "\"\<-\>\"", ",", " ", "\n", "\t", 
                                        "\"\<1\>\""}], "}"}], "]"}]}], "]"}], 
                                        ",", " ", "TraditionalForm"}], "]"}], 
                                        "]"}], "]"}], ",", "\n", "  ", 
                                        "\"\<) \[Rule] This replaces the last \
operand with its \n\tinverse (additive or multiplicative, \n\tdepending on \
the group).\n\t\\n\\t\\tStore \[Rule] This will place the last operand (or \
result) into\n\tthe memory cell below.\n\t\\n\\t\\tDelete last entry \[Rule] \
This button deletes the last entry,\n\twhether an operand or operator.\n\t\\n\
\\tThird row:\\n\\t\\t\>\"", ",", "\n", "  ", 
                                        RowBox[{"Cell", "[", 
                                        RowBox[{"BoxData", "[", 
                                        RowBox[{"FormBox", "[", 
                                        RowBox[{
                                        RowBox[{"RowBox", "[", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        "\"\<2\>\"", ",", " ", "\"\<x\>\""}], 
                                        "}"}], "]"}], ",", " ", 
                                        "TraditionalForm"}], "]"}], "]"}], 
                                        "]"}], ",", "\n", "  ", 
                                        "\"\< (or \>\"", ",", " ", 
                                        RowBox[{"Cell", "[", 
                                        RowBox[{"BoxData", "[", " ", 
                                        RowBox[{"FormBox", "[", 
                                        RowBox[{
                                        RowBox[{"SuperscriptBox", "[", 
                                        RowBox[{
                                        "\"\<x\>\"", ",", " ", "\"\<2\>\""}], 
                                        "]"}], ",", " ", "TraditionalForm"}], 
                                        "]"}], "]"}], "]"}], ",", "\n", "  ", 
                                        "\"\<) \[Rule] This replaces the last \
operand with its\n\tsquare (or double).\n\t\\n\\t\\tRecall \[Rule] This \
causes the stored value to become an\n\toperand in the calculation.\n\t\t\
\\n\\t\\tClear all \[Rule] This clears all of the contents\n\t\tof the \
screen.\n\t\\n\\nSecond Palette:\n\t\\n\\tHelp \[Rule] Brings up this box.\n\t\
\\n\\tCredits \[Rule] Brings up a box indicating authorship and a copyright \
notice.\n\t\\n\\n (Note that the permutation given by \n\t{2, 3, 1} means {1 \
\[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 1}.)\>\""}], "}"}], "]"}], ",", " ", 
                                        "\"\<Text\>\""}], "]"}], "}"}], ",", 
                                        " ", "\n", "                  ", 
                                        RowBox[{
                                        "ShowCellBracket", " ", "->", " ", 
                                        "False"}], ",", " ", 
                                        RowBox[{
                                        "WindowClickSelect", " ", "->", " ", 
                                        "False"}], ",", " ", "\n", 
                                        "                  ", 
                                        RowBox[{
                                        "Editable", " ", "->", " ", "True"}], 
                                        ",", " ", 
                                        RowBox[{"WindowSize", " ", "->", 
                                        " ", 
                                        RowBox[{"{", 
                                        RowBox[{"640", ",", " ", "390"}], 
                                        "}"}]}], ",", " ", "\n", 
                                        "                  ", 
                                        RowBox[{
                                        "WindowMargins", " ", "->", " ", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{
                                        "Automatic", ",", " ", "Automatic"}], 
                                        "}"}], ",", " ", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        "Automatic", ",", " ", "\n", 
                                        "                  ", "Automatic"}], 
                                        "}"}]}], "}"}]}], ",", " ", 
                                        RowBox[{
                                        "WindowFrame", " ", "->", " ", 
                                        "\"\<Palette\>\""}], ",", " ", "\n", 
                                        "    ", 
                                        RowBox[{
                                        "WindowElements", " ", "->", " ", 
                                        RowBox[{"{", "}"}]}], ",", " ", 
                                        RowBox[{
                                        "WindowFrameElements", " ", "->", 
                                        " ", "\n", "\t\t\t\t\t", 
                                        "\"\<CloseBox\>\""}]}], "]"}], 
                                        "]"}]}], ",", " ", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}], ",", 
                                        "\n", "\t\t", 
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{
                                        RowBox[{"RowBox", "[", 
                                        RowBox[{
                                        "{", "\"\<Credits\>\"", "}"}], "]"}], 
                                        ",", 
                                        RowBox[{"ButtonFunction", ":>", 
                                        RowBox[{"NotebookPut", "[", "  ", 
                                        RowBox[{"Notebook", "[", " ", 
                                        RowBox[{
                                        RowBox[{"{", " ", 
                                        RowBox[{"Cell", "[", " ", "\n", 
                                        RowBox[{
                                        RowBox[{"TextData", "[", 
                                        RowBox[{"{", " ", 
                                        RowBox[{
                                        "\"\<This group calculator is brought \
you by \>\"", ",", "\n", 
                                        RowBox[{"StyleForm", "[", 
                                        RowBox[{
                                        "\"\<Exploring Abstract Algebra with \
Mathematica\>\"", ",", " ", 
                                        RowBox[{
                                        "FontSlant", " ", "->", " ", 
                                        "\"\<Italic\>\""}]}], "]"}], ",", 
                                        "\n", 
                                        "\"\<, \[Copyright]1997 Al Hibbard  \
(hibbarda@central.edu) and \nKen Levasseur (Kenneth_Levasseur@uml.edu). Check\
\nout the web page at \>\"", ",", "\n", 
                                        RowBox[{"ButtonBox", "[", 
                                        RowBox[{
                                        "\"\<http://www.central.edu/eaam.html\
\>\"", ",", "\n", "    ", 
                                        RowBox[{"ButtonData", ":>", 
                                        RowBox[{"{", "\n", "      ", 
                                        RowBox[{
                                        RowBox[{
                                        "URL", "[", " ", 
                                        "\"\<http://www.central.edu/eaam.html\
\>\"", "]"}], ",", " ", "None"}], "}"}]}], ",", "\n", "    ", 
                                        RowBox[{
                                        "ButtonStyle", "->", 
                                        "\"\<Hyperlink\>\""}]}], "]"}], ",", 
                                        "\"\< for information \non available \
labs, packages and a forthcoming book.\>\""}], "}"}], "]"}], ",", " ", 
                                        "\"\<Text\>\"", ",", " ", 
                                        RowBox[{
                                        "FontSize", " ", "->", " ", "14"}]}], 
                                        "]"}], "}"}], ",", " ", "\n", 
                                        RowBox[{
                                        "ShowCellBracket", " ", "->", " ", 
                                        "False"}], ",", " ", 
                                        RowBox[{"WindowClickSelect", " ", 
                                        "->", " ", "False"}], ",", "  ", 
                                        "\n", 
                                        RowBox[{
                                        "Editable", " ", "->", " ", "True"}], 
                                        ",", " ", 
                                        RowBox[{
                                        "WindowSize", " ", "->", " ", 
                                        RowBox[{"{", 
                                        RowBox[{"425", ",", " ", "140"}], 
                                        "}"}]}], ",", " ", 
                                        RowBox[{"WindowMargins", " ", "->", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        RowBox[{"{", 
                                        RowBox[{
                                        "Automatic", ",", " ", "Automatic"}], 
                                        "}"}], ",", " ", 
                                        RowBox[{"{", 
                                        RowBox[{
                                        "Automatic", ",", "  ", 
                                        "Automatic"}], "}"}]}], "}"}]}], ",", 
                                        " ", 
                                        RowBox[{
                                        "WindowFrame", " ", "->", " ", 
                                        "\"\<Palette\>\""}], ",", " ", 
                                        RowBox[{
                                        "WindowElements", " ", "->", " ", 
                                        RowBox[{"{", "}"}]}], ",", " ", 
                                        RowBox[{
                                        "WindowFrameElements", " ", "->", 
                                        " ", "\"\<CloseBox\>\""}]}], "]"}], 
                                        "]"}]}], ",", 
                                        RowBox[{
                                        "ButtonEvaluator", "->", 
                                        "\"\<Automatic\>\""}]}], "]"}]}], 
                                        "}"}], "]"}], "]"}], ",", "\n", 
                                    "\t\t\t\t\t", "\"\<Text\>\"", ",", 
                                    RowBox[{"Active", "->", "True"}], ",", 
                                    RowBox[{
                                    "TextAlignment", "->", "Center"}], ",", 
                                    RowBox[{
                                    "ShowCellBracket", "->", "False"}]}], 
                                  "]"}]}], "}"}], ",", 
                            RowBox[{"WindowFrameElements", "->", 
                              RowBox[{"{", 
                                RowBox[{
                                "\"\<CloseBox\>\"", ",", "  ", 
                                  "\"\<ResizeArea\>\""}], "}"}]}], ",", 
                            RowBox[{"WindowMargins", "->", 
                              RowBox[{"{", 
                                RowBox[{
                                  RowBox[{"{", 
                                    RowBox[{"4", ",", "Automatic"}], "}"}], 
                                  ",", 
                                  RowBox[{"{", 
                                    RowBox[{"Automatic", ",", "4"}], "}"}]}], 
                                "}"}]}], ",", 
                            RowBox[{"WindowClickSelect", "->", "False"}], 
                            ",", " ", 
                            RowBox[{"WindowSize", " ", "->", " ", 
                              RowBox[{"{", 
                                RowBox[{"520", ",", " ", "Automatic"}], 
                                "}"}]}]}], "]"}], ",", "nb2"}], "]"}], ";", 
                    "\n", "\t\t", 
                    RowBox[{"NotebookLocate", "[", "\"\<screen\>\"", "]"}], 
                    ";", "\n", "\t\t", 
                    RowBox[{"SelectionMove", "[", 
                      RowBox[{"nb2", ",", "After", ",", "CellContents"}], 
                      "]"}], ";"}]}], "]"}]}]}], "]"}]}]}]}], "Input",
  ShowCellBracket->False,
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Group Element properties", "Subsection",
  ShowCellBracket->False,
  CellOpen->False],

Cell["\<\
ElementInformation := Module[{G, els, n, table, H, propn, \
properties, 
    blankrow, nb, funcs, FillInColumn2, FillInRow}, 
   H = GetStructure; G := H; 
    If[ValidGroupoid[G], properties = 
       {\"left\\ninverse\", \"right\\ninverse\", \"inver-\\ntible?\", 
        If[OperatorSymbol[G] === \"+\", \"2x\", \"\\!\\(x\\^2\\)\"], 
        \"order\", \"conjugacy\\nclass\",\"centra-\\nlizer\", \
\"subgroup\\ngenerated\"}; els = Elements[G]; 
      funcs := 
       {LeftInverse[G, #1] & , RightInverse[G, #1] & , 
        InvertibleQ[G, #1]&, Operation[G][#1, #1] & , 
        OrderOfElement[G, #1] & , ConjugacyClass[G, #1] &, \
Elements[Centralizer[G, #1]] &, Elements[SubgroupGenerated[G,#]]&}; 
      n = Length[els]; propn = Length[properties]; 
      blankrow = Table[\"?\", {propn}]; 
      FillInRow[n_] := 
       Module[{nb, vals, old, oldin, new, m = n + 1}, 
        nb = ButtonNotebook[]; 
         NotebookFind[nb, \"table\", All, CellTags, 
          AutoScroll -> False]; 
         SelectionMove[nb, All, Cell, AutoScroll -> False]; 
         old = NotebookRead[nb]; oldin = old[[1,1,1]]; 
         new = 
          Join[Table[oldin[[i]], {i, 1, m - 1}], 
           {Join[{oldin[[m,1]]}, 
             (ToBoxes[#1[els[[n]]]] & ) /@ funcs]}, 
           Table[oldin[[i]], {i, m + 1, Length[els] + 1}]]; 
         old = ReplacePart[old, new, {1, 1, 1}]; 
         NotebookWrite[nb, old, AutoScroll -> False]]; 
      FillInColumn2[n_, f_] := 
       Module[{nb, vals, old, oldin, new, m = propn + 1,opts}, 
        nb = ButtonNotebook[]; 
         NotebookFind[nb, \"table\", All, CellTags, 
          AutoScroll -> False]; 
         SelectionMove[nb, All, Cell, AutoScroll -> False]; 
         old = NotebookRead[nb]; oldin = old[[1,1,1]]; 
         new = 
          Transpose[Join[Table[Transpose[oldin][[i]], 
             {i, 1, n - 1}], 
            {Join[{oldin[[1,n]]}, (ToBoxes[f[#1]] & ) /@ els]}, 
            Table[Transpose[oldin][[i]], {i, n + 1, m}]]]; 
         old = ReplacePart[old, new, {1, 1, 1}]; 
         NotebookWrite[nb, old, AutoScroll -> False]]; 
      table = 
       GridBox[Prepend[(Prepend[blankrow, 
             ButtonBox[ToBoxes[#1], 
              ButtonFunction :> 
               FillInRow[First[First[Position[els, #1, 1]]]], 
              ButtonEvaluator -> Automatic, 
              ButtonNote -> \"fills in row\", 
              Background -> RGBColor[1, 0, 1]]] & ) /@ els, 
         Prepend[(ButtonBox[#1[[1]], 
              ButtonEvaluator -> Automatic, 
              ButtonNote -> \"fills in column\", 
              Background -> RGBColor[0, 1, 1], 
              ButtonFunction :> 
               FillInColumn2[#1[[2]], #1[[3]]]] & ) /@ 
           Transpose[{properties, Range[2, propn + 1], funcs}], 
          ButtonBox[\"elements\", 
           RuleDelayed[ButtonFunction, Null], 
           Rule[Background, RGBColor[1, 0.75, 0.8]]]]], 
        RowSpacings -> 0, ColumnSpacings -> 0, RowLines -> True, 
        GridFrame -> True, GridFrameMargins -> False, 
        ColumnLines -> True]; 
      nb = InputNotebook[]; 
      SelectionMove[nb, After, Cell, AutoScroll -> False]; 
      NotebookPut[Notebook[{Cell[BoxData[table], 
           NotebookDefault, Active -> True, CellTags -> \"table\",
           ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}}]},
WindowSize->{FitAll, FitAll},
WindowMargins->{{50,Automatic}, {4,Automatic}},
WindowTitle -> AbstractAlgebra`Core`Private`StructureName[G]]];
]]\
\>", "Input",
  ShowCellBracket->False,
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Group properties", "Subsection",
  ShowCellBracket->False,
  CellOpen->False],

Cell["\<\
GroupInformation := Module[{G, els, n, table, H, propn, properties, \

    blankrow, nb, funcs, FillInColumn2, FillInRow}, 
   H = GetStructure; G := H; 
    If[ValidGroupoid[G], 
    properties = 
       {\"closed?\", \"has identity?\", \"has inverses?\", 
        \"associnative?\", \"group?\", 
        \"abelian?\",\"has left identity?\",\"left identity\",\"has right \
identity?\",\"right identity\",\"non-associating triples\", \
\"order\",\"non-commuting pairs\",\"commutators\",\"commutator \
subgroup\",\"center\",\"cyclic?\", \"cyclic generators\",\"group exponent\"}; \

        els = Elements[G]; 
      funcs := 
       {ClosedQ, HasIdentityQ, HasInversesQ, AssociativeQ,
        GroupQ, AbelianQ, HasLeftIdentityQ, LeftIdentity, HasRightIdentityQ, \
RightIdentity, NonAssociatingTriples, Order, NonCommutingPairs, Commutators, \
Elements[CommutatorSubgroup[#]]&, GroupCenter, CyclicQ, CyclicGenerators, \
GroupExponent}; 
      n = Length[els]; 
      propn = Length[properties]; 
      blankrow = Table[\"?\", {propn}]; 
      FillInRow[n_, f_] := 
       Module[{nb, vals, old, oldin, new, m = n}, 
        nb = ButtonNotebook[]; 
         NotebookFind[nb, \"table\", All, CellTags, 
          AutoScroll -> False]; 
         SelectionMove[nb, All, Cell, AutoScroll -> False]; 
         old = NotebookRead[nb]; 
         oldin = old[[1,1,1]]; 
         new = 
          Join[Table[oldin[[i]], {i, 1, m - 1}], 
           {Join[{oldin[[m,1]]}, 
             {ToBoxes[funcs[[m]][G]]}]}, 
           Table[oldin[[i]], {i, m + 1, Length[funcs]}]]; 
         old = ReplacePart[old, new, {1, 1, 1}]; 
         NotebookWrite[nb, old, AutoScroll -> False]]; 
       
      table = 
       GridBox[Map[{ 
             ButtonBox[ToBoxes[#1[[1]]], 
              ButtonFunction :> 
               FillInRow[#[[3]],#[[2]]], 
              ButtonEvaluator -> Automatic, 
              ButtonNote -> \"fills in row\", 
              Background -> RGBColor[0, 1, 1]],\"?\"}&, \
Transpose[{properties,funcs,Range[1,Length[funcs]]}]], 
        RowSpacings -> 0, ColumnSpacings -> 0, RowLines -> True, 
        GridFrame -> True, GridFrameMargins -> False, 
        ColumnLines -> True,ColumnAlignments -> {Left}]; 
      nb = InputNotebook[]; 
      SelectionMove[nb, After, Cell, AutoScroll -> False]; 
      NotebookPut[Notebook[{Cell[BoxData[table], 
           NotebookDefault, Active -> True, CellTags -> \"table\",
           ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}}]},
WindowSize->{FitAll, FitAll},
WindowMargins->{{50,Automatic}, {4,Automatic}},
WindowTitle -> AbstractAlgebra`Core`Private`StructureName[G]]];
]]\
\>", "Input",
  ShowCellBracket->False,
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Ring Element properties", "Subsection",
  ShowCellBracket->False,
  CellOpen->False],

Cell["\<\
RElementInformation := Module[{G, els, n, table, H, propn, \
properties, 
    blankrow, nb, funcs, FillInColumn2, FillInRow}, 
   H = GetStructure; G := H; 
    If[ValidRingoid[G], properties = 
       {\"has\\nnegative?\", \"negative\\nof\", \"unit?\", 
        \"multiplicative\\ninverse\",\"\\!\\(x\\^2\\)\", 
        \"zero\\ndivisor?\", \"idempo\\ntent?\",\"nilpo-\\ntent?\"}; 
        els = Elements[G]; 
      funcs := 
       {HasNegativeQ[G, #1] & , NegationOf[G, #1] & , 
        InvertibleQ[G, #1, Operation -> Multiplication]&,
        MultiplicativeInverse[G, #1]&, Multiplication[G][#1, #1] & , 
        ZeroDivisorQ[G, #1] & , IdempotentQ[G, #1] &, NilpotentQ[G, #1] &}; 
      n = Length[els]; propn = Length[properties]; 
      blankrow = Table[\"?\", {propn}]; 
      FillInRow[n_] := 
       Module[{nb, vals, old, oldin, new, m = n + 1}, 
        nb = ButtonNotebook[]; 
         NotebookFind[nb, \"table\", All, CellTags, 
          AutoScroll -> False]; 
         SelectionMove[nb, All, Cell, AutoScroll -> False]; 
         old = NotebookRead[nb]; oldin = old[[1,1,1]]; 
         new = 
          Join[Table[oldin[[i]], {i, 1, m - 1}], 
           {Join[{oldin[[m,1]]}, 
             (ToBoxes[#1[els[[n]]]] & ) /@ funcs]}, 
           Table[oldin[[i]], {i, m + 1, Length[els] + 1}]]; 
         old = ReplacePart[old, new, {1, 1, 1}]; 
         NotebookWrite[nb, old, AutoScroll -> False]]; 
      FillInColumn2[n_, f_] := 
       Module[{nb, vals, old, oldin, new, m = propn + 1,opts}, 
        nb = ButtonNotebook[]; 
         NotebookFind[nb, \"table\", All, CellTags, 
          AutoScroll -> False]; 
         SelectionMove[nb, All, Cell, AutoScroll -> False]; 
         old = NotebookRead[nb]; oldin = old[[1,1,1]]; 
         new = 
          Transpose[Join[Table[Transpose[oldin][[i]], 
             {i, 1, n - 1}], 
            {Join[{oldin[[1,n]]}, (ToBoxes[f[#1]] & ) /@ els]}, 
            Table[Transpose[oldin][[i]], {i, n + 1, m}]]]; 
         old = ReplacePart[old, new, {1, 1, 1}]; 
         NotebookWrite[nb, old, AutoScroll -> False]]; 
      table = 
       GridBox[Prepend[(Prepend[blankrow, 
             ButtonBox[ToBoxes[#1], 
              ButtonFunction :> 
               FillInRow[First[First[Position[els, #1, 1]]]], 
              ButtonEvaluator -> Automatic, 
              ButtonNote -> \"fills in row\", 
              Background -> RGBColor[1, 0, 1]]] & ) /@ els, 
         Prepend[(ButtonBox[#1[[1]], 
              ButtonEvaluator -> Automatic, 
              ButtonNote -> \"fills in column\", 
              Background -> RGBColor[0, 1, 1], 
              ButtonFunction :> 
               FillInColumn2[#1[[2]], #1[[3]]]] & ) /@ 
           Transpose[{properties, Range[2, propn + 1], funcs}], 
          ButtonBox[\"elements\", 
           RuleDelayed[ButtonFunction, Null], 
           Rule[Background, RGBColor[1, 0.75, 0.8]]]]], 
        RowSpacings -> 0, ColumnSpacings -> 0, RowLines -> True, 
        GridFrame -> True, GridFrameMargins -> False, 
        ColumnLines -> True]; 
      nb = InputNotebook[]; 
      SelectionMove[nb, After, Cell, AutoScroll -> False]; 
      NotebookPut[Notebook[{Cell[BoxData[table], 
           NotebookDefault, Active -> True, CellTags -> \"table\",
           ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}}]},
WindowSize->{FitAll, FitAll},
WindowMargins->{{50,Automatic}, {4,Automatic}},
WindowTitle -> AbstractAlgebra`Core`Private`StructureName[G]]];
]]\
\>", "Input",
  ShowCellBracket->False,
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Ring properties", "Subsection",
  ShowCellBracket->False,
  CellOpen->False],

Cell["\<\
RingInformation := Module[{G, els, n, table, H, propn, properties, 
    blankrow, nb, funcs, FillInColumn2, FillInRow}, 
   H = GetStructure; G := H; 
    If[ValidRingoid[G], 
    properties = 
       {\"addition closed?\", \"multiplication closed?\", \"has zero?\", \
\"zero element\", 
        \"has unity?\", \"unity element\", \"additive inverses?\",
        \"multiplicative inverses?\",  \"addition associative?\",
        \"multiplication associative?\", \"addition commutative?\",
        \"multiplication commutative?\",
        \"distributive?\", \"ring?\", \"units\", \"idempotents\", \
\"nilpotents\", \"field?\",\"integral domain?\", \"characteristic\"}; 
        els = Elements[G]; 
      funcs := 
       {ClosedQ[#, Operation -> Addition]&, 
       ClosedQ[#, Operation -> Multiplication]&, HasZeroQ, Zero, WithUnityQ, \
Unity, HasInversesQ[#, Operation -> Addition]&,
       HasInversesQ[#, Operation -> Multiplication]&, 
       AssociativeQ[#, Operation -> Addition]&, 
       AssociativeQ[#, Operation -> Multiplication]&,
       CommutativeQ[#, Operation -> Addition]&, 
       CommutativeQ[#, Operation -> Multiplication]&, DistributiveQ,
        RingQ, Units, Idempotents, Nilpotents, FieldQ, IntegralDomainQ, \
Characteristic}; 
      n = Length[els]; 
      propn = Length[properties]; 
      blankrow = Table[\"?\", {propn}]; 
      FillInRow[n_, f_] := 
       Module[{nb, vals, old, oldin, new, m = n}, 
        nb = ButtonNotebook[]; 
         NotebookFind[nb, \"table\", All, CellTags, 
          AutoScroll -> False]; 
         SelectionMove[nb, All, Cell, AutoScroll -> False]; 
         old = NotebookRead[nb]; 
         oldin = old[[1,1,1]]; 
         new = 
          Join[Table[oldin[[i]], {i, 1, m - 1}], 
           {Join[{oldin[[m,1]]}, 
             {ToBoxes[funcs[[m]][G]]}]}, 
           Table[oldin[[i]], {i, m + 1, Length[funcs]}]]; 
         old = ReplacePart[old, new, {1, 1, 1}]; 
         NotebookWrite[nb, old, AutoScroll -> False]]; 
       
      table = 
       GridBox[Map[{ 
             ButtonBox[ToBoxes[#1[[1]]], 
              ButtonFunction :> 
               FillInRow[#[[3]],#[[2]]], 
              ButtonEvaluator -> Automatic, 
              ButtonNote -> \"fills in row\", 
              Background -> RGBColor[0, 1, 1]],\"?\"}&, \
Transpose[{properties,funcs,Range[1,Length[funcs]]}]], 
        RowSpacings -> 0, ColumnSpacings -> 0, RowLines -> True, 
        GridFrame -> True, GridFrameMargins -> False, 
        ColumnLines -> True,ColumnAlignments -> {Left}]; 
      nb = InputNotebook[]; 
      SelectionMove[nb, After, Cell, AutoScroll -> False]; 
      NotebookPut[Notebook[{Cell[BoxData[table], 
           NotebookDefault, Active -> True, CellTags -> \"table\",
           ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}}]},
WindowSize->{FitAll, FitAll},
WindowMargins->{{50,Automatic}, {4,Automatic}},
WindowTitle -> AbstractAlgebra`Core`Private`StructureName[G]]];
]]\
\>", "Input",
  ShowCellBracket->False,
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["RingCalculator", "Subsection",
  ShowCellBracket->False,
  CellOpen->False],

Cell[BoxData[
    RowBox[{"RingCalculator", " ", ":=", " ", 
      RowBox[{"Module", "[", 
        RowBox[{
          RowBox[{"{", " ", 
            RowBox[{"nb2", ",", "G", ",", " ", "square", ",", "inv"}], "}"}], 
          ",", "\n", "\t\t", 
          RowBox[{"Print", "[", "\"\<Not yet ready\>\"", "]"}]}], "]"}]}]], 
  "Input",
  ShowCellBracket->False,
  CellOpen->False,
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Choose a button, after choosing a Groupoid/Ringoid", "Section"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Palette\ of\ elements\),
            ButtonFunction:>FormElements,
            ButtonEvaluator->Automatic,
            ButtonNote->"button for each element"], 
          ButtonBox[
            
            StyleBox[\(for\ Groupoids\ or\ Ringoids, \ 
              provides\ a\ button\ for\ each\ element\),
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain"],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8]]},
        {
          ButtonBox["GroupCalculator",
            ButtonFunction:>GroupCalculator,
            ButtonEvaluator->Automatic], 
          ButtonBox[
            
            StyleBox[
              \(calculate\ products\ \((including\ inverses)\)\ in\ any\ 
                Groupoid\),
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain"],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8]]},
        {
          ButtonBox[\(Properties\ of\ \(Groupoid\ elements\)\),
            ButtonFunction:>ElementInformation,
            ButtonEvaluator->Automatic], 
          ButtonBox[
            
            StyleBox[
              \(look\ at\ information\ relative\ to\ each\ element\ in\ a\ 
                Groupoid\),
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain"],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8]]},
        {
          ButtonBox[\(Properties\ of \(\ a\ \) Groupoid\),
            ButtonFunction:>GroupInformation,
            ButtonEvaluator->Automatic], 
          ButtonBox[
            
            StyleBox[
              \(look\ at\ status\ of\ many\ possible\ properties\ in\ a\ 
                Groupoid\),
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain"],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8]]},
        {
          ButtonBox[\(Properties\ of\ \(Ringoid\ elements\)\),
            ButtonFunction:>RElementInformation,
            ButtonEvaluator->Automatic], 
          ButtonBox[
            
            StyleBox[
              \(look\ at\ information\ relative\ to\ each\ element\ in\ a\ 
                Ringoid\),
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain"],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8]]},
        {
          ButtonBox[\(Properties\ of \(\ a\ \) Ringoid\),
            ButtonFunction:>RingInformation,
            ButtonEvaluator->Automatic], 
          ButtonBox[
            
            StyleBox[
              \(look\ at\ status\ of\ many\ possible\ properties\ in\ a\ 
                Ringoid\),
              FontFamily->"Times",
              FontSize->12,
              FontWeight->"Plain"],
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8]]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      ColumnAlignments->{Left},
      GridFrame->True,
      GridFrameMargins->False,
      RowLines->True,
      ColumnLines->True]], "Input",
  Active->True]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
InitializationCellLoading->True,
WindowSize->{616, 271},
WindowMargins->{{Automatic, 2}, {11, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "structure"->{
    Cell[1709, 49, 260, 8, 43, "Input",
      Evaluatable->False,
      CellTags->"structure"]},
  "code"->{
    Cell[2182, 71, 3364, 80, 347, "Input",
      CellOpen->False,
      InitializationCell->True,
      CellTags->"code"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"structure", 99826, 2021},
  {"code", 99935, 2025}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 260, 8, 43, "Input",
  Evaluatable->False,
  CellTags->"structure"],

Cell[CellGroupData[{
Cell[1994, 61, 86, 2, 19, "Section",
  CellOpen->False],

Cell[CellGroupData[{
Cell[2105, 67, 74, 2, 46, "Subsection",
  CellOpen->False],
Cell[2182, 71, 3364, 80, 347, "Input",
  CellOpen->False,
  InitializationCell->True,
  CellTags->"code"]
}, Closed]],

Cell[CellGroupData[{
Cell[5583, 156, 86, 2, 30, "Subsection",
  CellOpen->False],
Cell[5672, 160, 6475, 130, 443, "Input",
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[12184, 295, 82, 2, 30, "Subsection",
  CellOpen->False],
Cell[12269, 299, 69317, 1247, 4667, "Input",
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[81623, 1551, 91, 2, 30, "Subsection",
  CellOpen->False],
Cell[81717, 1555, 3588, 79, 1137, "Input",
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[85342, 1639, 83, 2, 30, "Subsection",
  CellOpen->False],
Cell[85428, 1643, 2738, 65, 897, "Input",
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[88203, 1713, 90, 2, 30, "Subsection",
  CellOpen->False],
Cell[88296, 1717, 3571, 79, 1152, "Input",
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[91904, 1801, 82, 2, 30, "Subsection",
  CellOpen->False],
Cell[91989, 1805, 3055, 70, 1002, "Input",
  CellOpen->False,
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[95081, 1880, 81, 2, 30, "Subsection",
  CellOpen->False],
Cell[95165, 1884, 406, 11, 43, "Input",
  CellOpen->False,
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[95620, 1901, 69, 0, 30, "Section"],
Cell[95692, 1903, 3268, 93, 124, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

