(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5834,        162]*)
(*NotebookOutlinePosition[      7354,        216]*)
(*  CellTagsIndexPosition[      7285,        210]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox[\(Ring\ functions\),
            ButtonFunction:>Null,
            Background->RGBColor[1, 0.749996, 0.8],
            ButtonNote->"work with rings"]},
        {
          ButtonBox[\(AdditiveGroupoid[\[SelectionPlaceholder]]\),
            ButtonNote->"creates additive groupoid"]},
        {
          ButtonBox[\(Characteristic[\[SelectionPlaceholder]]\),
            ButtonNote->"determines characteristic"]},
        {
          ButtonBox[\(CommutativeQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is multiplication commutative?"]},
        {
          ButtonBox[\(DistributiveQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it distributive?"]},
        {
          ButtonBox[\(FieldQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it a field?"]},
        {
          
          ButtonBox[
            \(FormRingoid[\[SelectionPlaceholder], \[Placeholder], 
              \[Placeholder]]\),
            ButtonNote->"creates a Ringoid"]},
        {
          ButtonBox[\(IdealQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it an ideal?"]},
        {
          ButtonBox[\(IdempotentQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it an idempotent?"]},
        {
          ButtonBox[\(Idempotents[\[SelectionPlaceholder]]\),
            ButtonNote->"form all idempotents"]},
        {
          ButtonBox[\(IntegralDomainQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is it an integral domain?"]},
        {
          
          ButtonBox[\(\ 
            InvertibleQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it invertible?"]},
        {
          ButtonBox[\(MultiplicativeGroupoid[\[SelectionPlaceholder]]\),
            ButtonNote->"form multiplicative groupoid"]},
        {
          
          ButtonBox[
            \(MultiplicativeInverse[\[SelectionPlaceholder], \[Placeholder]]
              \),
            ButtonNote->"return mult. inverse"]},
        {
          ButtonBox[\(NegationOf[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"return add. inverse"]},
        {
          
          ButtonBox[
            \(QuotientRing[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"form quotient ring"]},
        {
          ButtonBox[\(\ RingInfo[\[SelectionPlaceholder]]\),
            ButtonNote->"return info about ring"]},
        {
          ButtonBox[\(SubringQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it a subring?"]},
        {
          ButtonBox[\(UnitQ[\[SelectionPlaceholder], \[Placeholder]]\),
            ButtonNote->"is it a unit"]},
        {
          ButtonBox[\(Units[\[SelectionPlaceholder]]\),
            ButtonNote->"return all units"]},
        {
          ButtonBox[\(WithUnityQ[\[SelectionPlaceholder]]\),
            ButtonNote->"is there a unity?"]},
        {
          ButtonBox[\(ZeroDivisors[\[SelectionPlaceholder]]\),
            ButtonNote->"return all zero divisors"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Textual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Textual mode"]},
        {
          ButtonBox[\(, \ Mode\  \[Rule] \ Visual\),
            Background->RGBColor[1, 1, 0],
            ButtonNote->"add Visual mode"]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      RowLines->True,
      ColumnLines->True,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], NotebookDefault,
  CellMargins->{{Inherited, Inherited}, {5, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  LineSpacing->{1.25, 0},
  AutoItalicWords->{},
  FormatType->InputForm,
  ScriptMinSize->9,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  CellTags->"ring"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
Editable->False,
WindowToolbars->{},
PageWidth->427,
WindowSize->{Fit, Fit},
WindowMargins->{{Automatic, 6}, {10, Automatic}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
ScrollingOptions->{"PagewiseScrolling"->True},
ShowCellBracket->False,
CellMargins->{{0, 0}, {Inherited, 0}},
Active->True,
CellOpen->True,
ShowCellLabel->False,
ShowCellTags->False,
ImageMargins->{{0, Inherited}, {Inherited, 0}},
Magnification->1,
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ring"->{
    Cell[1710, 49, 4120, 111, 415, NotebookDefault,
      Evaluatable->True,
      CellGroupingRules->"InputGrouping",
      PageBreakAbove->True,
      PageBreakWithin->False,
      CounterIncrements->"Input",
      CellTags->"ring"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ring", 7023, 198}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 4120, 111, 415, NotebookDefault,
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  PageBreakAbove->True,
  PageBreakWithin->False,
  CounterIncrements->"Input",
  CellTags->"ring"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

