(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)

(* :Title:  AbstractAlgebra`Permutations *)

(* :Context: AbstractAlgebra`Permutations` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)


incomingStructure = DefaultStructure;

BeginPackage["AbstractAlgebra`Permutations`",
	{"AbstractAlgebra`Core`", "Graphics`Graphics`","Utilities`FilterOptions`",
	"Graphics`Colors`", "Graphics`Arrow`"}];

Off[General::spell,General::spell1];
SetOptions[Graphics,AspectRatio->Automatic];
Format[LineBreak[_]] = "";
Format[Indent[_]] = "";
Format[StringBreak[_]] = "";

(* CycleToList::usage = "CycleToList[c] converts Cycle[a1, a2, ...] into
{a1, a2, ...}."; - doesn't need to be public *)

(* NormalizePermutations::usage = "NormalizePermutations[p1, p2] will
take two permutations of possibly different lengths and rewrite them as
a Sequence of the same permutations in S[n] where n is the maximum of
the lengths of p1 and p2.";*)

A::usage = "A[n] returns the group of even permutations on the set
{1,2,..n} under composition. See Alternating.";

Alternating::usage = "Alternating[n] returns the group of even
permutations on the set {1,2,..n} under composition. There are two
options for this function: ProductOrder and IndexLimit. Since the
elements of this group are permutations, one can specify the order that
the product is taken. See ProductOrder for more information, including
the values which can be used. IndexLimit defaults to 6 and indicates the
upper limit for the value of the index n.";

AlternatingGroup::usage = "AlternatingGroup[n] - see Alternating.";

Cycle::usage = "Cycle[e1, e2, ...] represents an object that is a cycle
of a permutation. This is also a value for the CycleAs option of the
ToCycles and FromCycles functions.";

CycleAs::usage = "CycleAs is an option for ToCycles and FromCycles that
indicates whether a cycle is given as a list or with the head Cycle. In
these packages, the default value is Cycle; to conform with the
DiscreteMath`Permutations` package's use, use the value List.";

(*CycleQ::usage = "CycleQ[c] returns True if c is a cycle, and False
otherwise. To be a cycle, c must have Head Cycle and have one or more
arguments that are distinct positive integers.";*)

DefaultOrder::usage = "DefaultOrder is a global variable that contains
the order that permutations are multiplied. It starts out with the value
RightToLeft, until changed by an option or directly.";

DisjointCyclesQ::usage = "DisjointCyclesQ[cyclist] returns True if the
cycles in cyclist are disjoint, and False otherwise. The cycles in
cyclist can be either in List form or using Cycle notation. Also,
cyclist can be of any length and either given as a list or sequence of
cycles.";

EvenPermutationQ::usage = "EvenPermutationQ[p] returns True if p is an
even permutation, and False otherwise.";

ExtendPermutation::usage = "ExtendPermutation[p, n] takes a permutation
p in S[m] (for m < n) and returns a permutation in S[n] with the
components of p in the first m positions and filling out positions m+1
to n with the integers m+1 to n, so that p is naturally extended.";

FixQ::usage = "FixQ[S, p, el] returns True if the permutation p (where p
permutes the elements of S) fixes the element el, False otherwise. If p
is a permutation in S[n], then FixQ[p, el] is equivalent to
FixQ[Range[n], p, el].";

FormGroupoidFromCycles::usage = "FormGroupoidFromCycles[cl, opts] forms
the Groupoid of permutations whose elements are (initially) written as
either cycles or products of cycles. The option opts takes on values
similar to FormGroupoid, as well as the option ProductOrder (since
working with permutations).";

FromCycles::usage ="FromCycles[{c1, c2,...,cn}] gives the permutation
that corresponds to the product of the cycles c1, c2, ...cn, assuming
the cycles ci are disjoint.";

IndexLimit::usage = "IndexLimit is an option for some groups to enable
one to obtain groups with more than the default limit on the index.
Examples where this is used is with the Symmetric and Alternating groups
with the default value of 6.";

(*ListToCycle::usage = "ListToCycle[{a1, a2, ...}] converts {a1, a2, ...}
into Cycle[a1, a2, ...].";*)

MultiplyCycles::usage = "MultiplyCycles[c2, c1, n] views both cycles c1
and c2 as in S[n] and determines the permutation representing their
product. Note that the order of multiplication is from right to left
(unless specified otherwise by ProductOrder, described below).
MultiplyCycles[c2, c1] does the same but determines n by n =
Max[Join[c1, c2]]. MultiplyCycles[c3, c2, c1] starts from the right and
multiplies the cycles as it moves left through c2 and c3.
MultiplyCycles[cyclelist] or MultiplyCycles[{cyclelist}] will work on
any length of list of cycles and finds the product, working from right
to left if the option ProductOrder is set to RightToLeft, or from left
to right if set to LeftToRight. See ProductOrder for details on its
values.";

MultiplyPermutations::usage = "MultiplyPermutations[perm2, perm1], by
default, computes the product of perm1 followed by perm2 (right to
left). The option ProductOrder is by default set to RightToLeft, but can
also be set to LeftToRight. Note that the permutations can be expressed
as rules (eg., {1->3, 2->2,3->1}), or lists (eg., {3,2,1}) or mixed,
though the output will always be a list.";

Normalize::usage = "Normalize is an option for ToCycles and FromCycles
that indicates whether a list of cycles in Cycle notation (this assumes
that we have CycleAs -> Cycle as an option) is normalized.
If the list consists
only of cycles of length 1, it drops all of them except the one with
maximal value; otherwise, all cycles of length one are dropped, the
remaining cycles are normalized by rotating until the smallest entry
occurs first, and then the list of cycles is
sorted from shortest to longest.";

(*NormalizeCycle::usage = "NormalizeCycle[c] returns the Cycle c in the
canonical form where the elements are rotated until the smallest entry
occurs first.";

NormalizeCycleList::usage = "NormalizeCycleList[cl], given a list of
cycles, returns a list of cycles in a canonical form. If cl consists
only of cycles of length 1, it drops all of them except the one with
maximal value; otherwise, all cycles of length one are dropped, the
remaining cycles are normalized by NormalizeCycle, and then the list is
sorted from shortest to longest.";*)

OddPermutationQ::usage = "OddPermutationQ[p] returns True if p is an odd
permutation, and False otherwise.";

Orbit::usage = "Orbit[G, S, x] is the orbit of x (from S) under G. Here,
G is a group of permutations of the set S. Orbit[S, x] assumes G is the
full set of all permutations of S.";

Parity::usage = "Parity[perm] returns 1 if the permutation perm is an
even permutation and -1 if odd.";

PermutationGroup::usage = "PermutationGroup[list] returns the
permutation group on the elements in list. It is assumed that the length
of list is less than 7. PermutationGroup[n] acts just as Symmetric[n].";

PermutationImage::usage = "PermutationImage[S, p, el] returns the image
of the element el under the action of the permutation p, where p
permutes the elements of S. If p is a permutation in S[n], then
PermutationImage[p, el] is equivalent to PermutationImage[Range[n], p,
el].";

PermutationMatrix::usage = "PermutationMatrix[p] shows a permutation in
matrix form, where the top row consists of 1, 2, ... Length[p] and the
bottom row is the corresponding images.";

Permutations::usage = "Permutations is an option for Form when working
with the dihedral group. See Dihedral for more information. The standard
(built-in) definition still works: Permutations[list] generates a list
of all possible permutations of the elements in list.";

PermutationToPower::usage = "PermutationToPower[perm, n] returns the nth
power of the permutation perm, where n is any integer. (If n < 0, this
returns the nth power of the inverse of perm.)";

PermuteColoredSquares::usage = "PermuteColoredSquares[p] will show
a row of randomly colored squares (as in RandomColoredSquares) and
below this a row of squares obtained by permuting the first list
using the permutation given by p. This function only works after
RandomColoredSquares has been called. See ShowColoredPermutation also.";

ProductOrder::usage = "ProductOrder is an option for the function
MultiplyPermutations and other functions that call this. The value of
this, which defaults to RightToLeft, specifies the order in which the
permutations are multiplied. Alternatively, one can specify
LeftToRight.";

RandomColoredSquares::usage = "RandomColoredSquares[n] returns
a row of n colored squares chosen randomly from a default list.
Optionally, RandomColoredSquares[n,colors] will choose the n from
the list provided in colors.";

S::usage = "S[n] returns the group of permutations on the set {1,2,..n}
under composition. See Symmetric.";

SamePermutationQ::usage =
"SamePermutationQ[cyclist1, cyclist2] returns True if the
cycle representation for permutation1 found in cyclist1 yields the same
permutation represented by cyclist2, and False otherwise.";

ShowColoredPermutation::usage = "ShowColoredPermutation[p] is
similar to PermuteColoredSquares except that it does not require
RandomColoredSquares to be called first.";

SideBySideMatrices::usage = "SideBySideMatrices[p,q] displays
permutation p as a matrix on the left and permutation q as a matrix
on the right, with some space in between. This simply illustrates
how we begin to multiply matrices.";

Stabilizer::usage = "Stabilizer[G, S, x] returns the stabilizer of the
element x (from S) in the group G. Here, G is a group of permutations of
the set S. Stabilizer[S, x] assumes G is the full set of all
permutations of S.";

Symmetric::usage = "Symmetric[n] returns the group of permutations on
the set {1,2,..n} under composition. There are two options for this
function: ProductOrder and IndexLimit. Since the elements of this group
are permutations, one can specify the order that the product is taken by
using ProductOrder; see ProductOrder for more information, including the
values which can be used. IndexLimit defaults to 6 and indicates the
upper limit for the value of the index n.";

SymmetricGroup::usage = "SymmetricGroup[n] behaves just as the function
Symmetric, but also has the functionality of PermutationGroup.";

ToCycles::usage ="ToCycles[p] writes the permutation p as a list of
disjoint cyclic permutations (i.e., cycles) whose product is p. If p is a
list of permutations, this will return a list of cycles for each
permutation. There are two options for ToCycles: CycleAs and Normalize.
Using CycleAs -> List the cycles are returned in the form of the
DiscreteMath`Permutations` package (so that the permutation {2,1,4,3} is
returned as {{2,1},{4,3}}), while CycleAs -> Cycle (default) uses
Cycle[2,1] for {2,1} in the cycle list. If CycleAs -> Cycle is used,
Normalize -> True (default) applies NormalizeCycleList to the list of
cycles; see this function for details.";

ToTranspositions::usage = "ToTranspositions[c] rewrites the
cycle c as a product of transpositions. ToTranspositions[perm]
rewrites the permutation perm as a product of transpositions.";



Cycle::disjoint = "The cycles in the list `1` need to be disjoint to
use this function.";

Group::size = "Are you sure you want `1`? This group has `2` elements in
it. By default, the index must be less than or equal to `3`. If you wish
to increase it, add the option 'IndexLimit -> k' to this function,
where k is the desired maximum for the index.";

PermutationQ::diffels = "`1` is not a permutation of `2` since they do
not have the same elements.";

PermutationQ::difflen = "`1` is not a permutation of `2` since they do
not have the same length.";

PermutationQ::duplicates = "A permutation can not have elements listed
twice as `1` does.";

PermutationQ::fail = "`1` is not a permutation.";

PermutationQ::length = "The permutation `1` should have exactly the `2`
elements from 1 to `2` in some order. If `1` is actually a cycle and you
are trying to use it as a permutation, convert it by using the
ToPermutation function.";

PermutationQ::missing = "A permutation on `1` must be a list containing
all of the integers from 1 to `2`. `3` is missing some values.";

PermutationQ::notrule = "The list `1` needs to have every element either
in the form a -> b or {a -> b} in order to represent a permutation by
using rules.";

Begin["`Private`"];

DefaultOrder = RightToLeft;

MessagePermutationQ[e_] := Module[{n = Length[e], ue = Union[e], m, max},
	m = Length[ue];
	max = Max[ue];
	If[n > m, Message[PermutationQ::duplicates,e]];
	If[n < max,	Message[PermutationQ::missing, Range[max], max, e]];
	TrueQ[Sort[e] === Range[Length[e]]]]

Parity[x_?PermutationQ] := ToCycles[x, CycleAs -> List]//
	Map[(Length[#]-1)&,#]&//Apply[Plus,#]&//((-1)^#)&

Parity[x_] := If[!MessagePermutationQ[x], $Failed]

OddPermutationQ[x_?PermutationQ] := Parity[x] == -1

EvenPermutationQ[x_?PermutationQ] := Parity[x] == 1

CycleToList[c_] := Apply[List, c]

ListToCycle[c_List] := Apply[Cycle, c]

CycleQ[c_] := Head[c] === Cycle &&
	Length[c] == Length[Union[c]] &&
	Length[c] > 0 &&
	Apply[And, Map[IntegerQ[#] && Positive[#]&,
		CycleToList[c]]]
		
PermutationOrCycleQ[c_] := PermutationQ[c] || CycleQ[c]

NormalizeCycle[c_?CycleQ] := Module[{lst},
	lst = CycleToList[c];
	ListToCycle[RotateRight[lst, Length[lst] - First[Flatten[
		Position[lst, Min[lst]]]] + 1]]]
		
NormalizeCycle[{c__}] := NormalizeCycle[Cycle[c]]
		
NormalizeCycleList[cl:{_?CycleQ..}] := Module[{reduced, a, b, x, max},
	reduced = cl //. {a___, Cycle[x_Integer], b___} :> {a, b};
	If[reduced === {}, reduced = {Cycle[Max[cl /. Cycle[x_] -> x]]}];
	If[Max[Flatten[Map[CycleToList,reduced]]] =!= 
		(max = Max[Flatten[Map[CycleToList,cl]]]), AppendTo[reduced, Cycle[max]]];
	Map[NormalizeCycle, reduced]//Sort[#, CyclesOrderedQ]&]
   
NormalizeCycleList[cl__?CycleQ] := NormalizeCycleList[{cl}]

CyclesOrderedQ[Cycle[list1__], Cycle[list2__]] := 
	If[First[{list1}] <= First[{list2}], True, False]
	
DisjointCyclesQ[list_List] := 
	Flatten[Apply[List,list,{1}]]===UnionNoSort[Flatten[Apply[List,list,{1}]]]
	
DisjointCyclesQ[cl:Sequence[_?CycleQ..]] := DisjointCyclesQ[{cl}]

Options[ToCycles]={CycleAs -> Cycle,
	Normalize -> True};
			
ToCycles[perm_?PermutationQ, opts___?OptionQ] := (* modified from Permutation.m *)
	Module[{a, t, n, l, i, len, cl,
		cyctype = CycleAs/.Flatten[{opts, Options[ToCycles]}],
		 norm = Normalize/.Flatten[{opts, Options[ToCycles]}]},
		len = Length[perm];
		a = {} ;
		t = Table[True, {len}];
		For[i=1, i<=len, i++,
			If[t[[i]], 
				For[n = perm[[i]]; l = {}, 
					t[[n]], 
					n = perm[[n]],
					t[[n]] = False; AppendTo[l, n]
				   ];
			AppendTo[a, l]
			]
		] ;
		Return[If[cyctype === List, a,
			If[cyctype === Cycle, cl = Map[Apply[Cycle,#]&, a, {1}];
				If[norm === True, NormalizeCycleList[cl], cl]]]]
	]
	
ToCycles[pl:{_?PermutationQ..}, opts___?OptionQ] := 
	Map[ToCycles[#,opts]&,pl]

ToCycles[p__, opts___?OptionQ] := Module[{out},
	out = If[MessagePermutationByRulesQ[Flatten[{p}]],
		ToCycles[ToPermutation[p], opts], $Failed];
	If[out === $Failed,
		out = If[Apply[And,Map[PermutationQ,p]], Map[ToCycles[#,opts]&,p], $Failed]];
	out] 

FromCycles[cyc_List] := Module[{cyclist = cyc/. Cycle -> List, temp,
		missing},
	If[DisjointCyclesQ[cyc],
   temp = Last /@ Sort[Transpose[Flatten /@ 
   	{RotateRight /@ cyclist, cyclist}]];
   missing = Complement[Range[Max[temp]],temp];
   Fold[Insert[#1, #2,#2]&, temp, missing],
   	Message[Cycle::disjoint,cyc];$Failed]]
	
MessagePermutationByRulesQ[e_] := Module[{t,ne,ok},
	Off[Part::partd];
	ne = Flatten[e];
	t = Apply[And,Map[(Head[#] === Rule)&,ne]];
	ok = t;
	If[!t, Message[PermutationQ::notrule,e]];
	If[t,
		If[Apply[Equal,Map[Union,Transpose[ne/.Rule->List]]],
		ok = True, Message[Rule::form,Length[e]];ok= False]];
	On[Part::partd];
	ok]

ListCycleQ[c_List] := CycleQ[ListToCycle[c]]

SamePermutationQ[cyc1_?CycleQ,cyc2_?CycleQ] :=
	MultiplyCycles[cyc1]===MultiplyCycles[cyc2]

SamePermutationQ[{cyc1__?CycleQ},{cyc2__?CycleQ}] :=
	MultiplyCycles[{cyc1}]===MultiplyCycles[{cyc2}]

SamePermutationQ[{cyc1__List},{cyc2__List}] :=
	MultiplyCycles[Map[ListToCycle,{cyc1}]]===
	MultiplyCycles[Map[ListToCycle,{cyc2}]]
	
SamePermutationQ[cyc1_List,cyc2_List] :=
	MultiplyCycles[cyc1]===MultiplyCycles[cyc2]
	
ToPermutation[cyc_?CycleQ, n_Integer?Positive] := 
		Module[{c = Apply[List,cyc]},
	Union[Map[{First[#]->Last[#]}&,{c,RotateLeft[c]}//Transpose],
	Map[{#->#}&,Complement[Range[n],c]]]//ToPermutation]
	
ToPermutation[c_Cycle] := ToPermutation[c,Max[CycleToList[c]]]

ToPermutation[c_?ListCycleQ] := ToPermutation[ListToCycle[c]]

ToPermutation[c_?ListCycleQ, n_Integer?Positive] := 
	ToPermutation[ListToCycle[c],n]
	
ToPermutation[cyclelist__Cycle] := MultiplyCycles[{cyclelist}]

ToPermutation[cyclelist:{_?CycleQ..}] := MultiplyCycles[cyclelist]

MultiplyCycles[c1_Cycle]:= ToPermutation[c1]

MultiplyCycles[c1_?ListCycleQ]:= ToPermutation[ListToCycle[c1]]

MultiplyCycles[c1_Cycle, c2_Cycle,n_Integer?Positive,opts___?OptionQ]:= 
	MultiplyPermutations[ToPermutation[c1,n],ToPermutation[c2,n],opts]
	
MultiplyCycles[c1_?ListCycleQ, c2_?ListCycleQ, n_Integer?Positive,opts___?OptionQ]:=
  MultiplyCycles[ListToCycle[c1], ListToCycle[c2], n, opts]
	
MultiplyCycles[c1_Cycle, c2_Cycle,opts___?OptionQ]:= 
		Module[{max = Max[Flatten[Apply[List, {c1, c2}, {1}]]]},
	MultiplyPermutations[ToPermutation[c1,max],
		ToPermutation[c2,max],opts]]
	
MultiplyCycles[cyclelist__Cycle,opts___?OptionQ] := MultiplyCycles[{cyclelist},opts]

MultiplyCycles[cyclelist:{_?CycleQ..},opts___?OptionQ] := 
		Module[{n = Length[{cyclelist}],rl,perms,ans,po, max},
	po = ProductOrder/.Flatten[{opts, Options[MultiplyPermutations]}];
	rl=If[po===RightToLeft,Reverse[cyclelist],cyclelist];
	max = Max[Map[CycleToList,cyclelist]//Union];
	perms = Map[ToPermutation[#,max]&, rl];
	Fold[MultiplyPermutations[#1,#2,ProductOrder -> LeftToRight]&,
		First[perms],Rest[perms]]]
		
Cycle[c1__][Cycle[c2__]] := MultiplyCycles[Cycle[c1], Cycle[c2]]

Cycle[c1__][c2_?PermutationQ] := 
	MultiplyPermutations[ToPermutation[Cycle[c1]], c2]

ToTranspositions[Cycle[1]] := {Cycle[1,2],Cycle[2,1]}

ToTranspositions[Cycle[x_]] := {Cycle[1,x], Cycle[x,1]}

ToTranspositions[cyc_Cycle] := Module[{c = Apply[List,cyc]},
	Map[Cycle[First[c],#]&, Rest[c]//Reverse]]

ToTranspositions[p_?PermutationQ] := 
	p//ToCycles//Map[ToTranspositions,#]&//Flatten[#,1]&
	
ToTranspositions[p_] := (Message[PermutationQ::fail, p]; $Failed)

Unprotect[ToRules];
 	
ToRules[perm_?PermutationQ] :=  
 	MapThread[Rule,{Range[Length[perm]],perm}]
 	
Protect[ToRules];

permutationToFunction[perm_?PermutationQ,f_] := 
   Module[{i}, 
   	Do[f[i] = perm[[i]],{i, Length[perm]}]; 
   	f]
(* given a permutation in list form, this produces a 
function representing this permutation *)

permutationToFunction[(perm_)?PermutationQ] := 
   Module[{i,f}, 
   	Do[f[i] = perm[[i]],{i, Length[perm]}]; 
   	f]
(* similar to above except here f is a local variable *)

NormalizePermutations[perm1_,perm2_] := 
	If[Union[perm1]=!=Range[Length[perm1]],
		Message[PermutationQ::length,perm1,Length[perm1]],
		If[Union[perm2]=!=Range[Length[perm2]],
			Message[PermutationQ::length,perm2,Length[perm2]],
			Apply[Sequence,Map[ExtendPermutation[#, Max[Map[Length,
				{perm1,perm2}]]]&, {perm1,perm2}]]]]
	
ExtendPermutation[p_?PermutationQ, n_Integer?Positive] :=	
	If[Length[p] <= n, Join[p, Range[Length[p] + 1, n]]]
	
permutationProductrl[(perm1_)?PermutationQ, 
		(perm2_)?PermutationQ] := 
	permutationComposition[NormalizePermutations[perm1,perm2]]

permutationProductlr[(perm1_)?PermutationQ, 
		(perm2_)?PermutationQ] := 
	permutationComposition[NormalizePermutations[perm2,perm1]]

permutationComposition=Module[{k},
	Map[Function[k,Part[#1,k]],#2]&];

Options[MultiplyPermutations]={Mode -> Computational,
	ProductOrder -> RightToLeft};

MultiplyPermutations[perm1_, perm2_, Mode -> Textual, opts___?OptionQ] :=
	Module[{p1=Flatten[perm1],p2=Flatten[perm2],mymode,po,prod,
			ok=True},
		mymode = Mode/.Flatten[{opts, Options[MultiplyPermutations]}];
		po = ProductOrder/.Flatten[{opts, Options[MultiplyPermutations]}];
		If[Head[p1[[1]]]===Rule,
			If[MessagePermutationByRulesQ[p1],p1 = ToPermutation[p1]]];
		If[Head[p2[[1]]]===Rule,
			If[MessagePermutationByRulesQ[p2],p2 = ToPermutation[p2]]];
		p1 = If[MessagePermutationQ[p1],p1,Null];
		p2 = If[MessagePermutationQ[p2],p2,Null];
		If[p1===Null || p2 === Null, $Failed,
			prod = If[po === RightToLeft,
				permutationProductrl[p1,p2], 
				If[po === LeftToRight,permutationProductlr[p1,p2],
					Message[MultiplyPermutations::optx,po,ProductOrder]]]];
		Print["The permutation resulting from the product of "];
		Print["\t", If[po === RightToLeft, perm2, perm1]];
		Print["followed by"];
		Print["\t",If[po === RightToLeft, perm1, perm2]];
		Print["can be given as "];
		Print["\t",ToRules[prod]];
		Print["or as"];
		prod
	]
	
MultiplyPermutations[perm1_, perm2_, opts___?OptionQ, Mode -> Textual] :=
	MultiplyPermutations[perm1, perm2, Mode->Textual, opts]
	
MultiplyPermutations[c1_?CycleQ, c2_?CycleQ, opts___?OptionQ] := 
	MultiplyPermutations[ToPermutation[c1], ToPermutation[c2], opts]

MultiplyPermutations[perm1_, perm2_,opts___?OptionQ] :=
	Module[{p1=Flatten[perm1],p2=Flatten[perm2],mymode,po,prod,
			ok=True},
		mymode = Mode/.Flatten[{opts, Options[MultiplyPermutations]}];
		po = ProductOrder/.Flatten[{opts, Options[MultiplyPermutations]}];
		If[Head[p1[[1]]]===Rule,
			If[MessagePermutationByRulesQ[p1],p1 = ToPermutation[p1]]];
		If[Head[p2[[1]]]===Rule,
			If[MessagePermutationByRulesQ[p2],p2 = ToPermutation[p2]]];
		p1 = If[MessagePermutationQ[p1],p1,Null];
		p2 = If[MessagePermutationQ[p2],p2,Null];
		If[p1===Null || p2 === Null, $Failed,
			If[po === RightToLeft,
				permutationProductrl[p1,p2], 
				If[po === LeftToRight,permutationProductlr[p1,p2],
					Message[MultiplyPermutations::optx,po,ProductOrder]]]]]

MultiplyPermutations[perm1_?PermutationQ, perm2_?PermutationQ,
	perm3_?PermutationQ] :=
MultiplyPermutations[perm1,MultiplyPermutations[perm2,perm3]]

PermutationToPower[perm_?PermutationQ, 0] := Table[i, {i, Length[perm]}]

PermutationToPower[perm_?PermutationQ, 1] := perm

PermutationToPower[perm_?PermutationQ, -1] := PermutationInverse[perm]

PermutationToPower[perm_?PermutationQ, n_Integer?Positive] := 
	Fold[MultiplyPermutations[#1,#2]&, perm, Table[perm, {i, n-1}]]

PermutationToPower[perm_?PermutationQ, n_Integer?Negative] := 
	Module[{p = PermutationInverse[perm]},
		Fold[MultiplyPermutations[#1,#2]&, p, Table[p, {i, n-1}]]]
		
PermutationMatrix[list_?PermutationQ]:=
		MatrixForm[{Range[Length[list]],list}]
		
PermutationMatrix[list_?AbstractAlgebra`Core`Private`PermutationByRulesQ]:=
		MatrixForm[{Range[Length[list]],list//ToPermutation}]

FixQ[S_List, p_, el_] := 
	If[Union[S]===Union[p],
		If[Length[S]==Length[p],
			If[MemberQ[S,el],
				Position[S,el]===Position[p,el],
				Message[MemberQ::elmnt,el,S];$Failed],
			Message[PermutationQ::difflen,p,S];$Failed],
		Message[PermutationQ::diffels,p,S];$Failed]

FixQ[p_?PermutationQ, el_] := FixQ[Range[Max[p]], p, el]

PermutationImage[S_List, p_, el_] := 
	If[Union[S]===Union[p],
		If[Length[S]==Length[p],
			If[MemberQ[p,el],
				p[[Flatten[Position[S,el]]]][[1]],
				Message[MemberQ::elmnt,el,S];$Failed],
			Message[PermutationQ::difflen,p,S];$Failed],
		Message[PermutationQ::diffels,p,S];$Failed]
		
PermutationImage[p_?PermutationQ, el_] := PermutationImage[Range[Max[p]], p, el]

GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]


Options[FormGroupoidFromCycles] = {WideElements -> True, IsAGroup -> False,
	Generators -> {}, GroupoidDescription -> "this is a group of permutations", 
	GroupoidName -> "TheGroup", 
	FormatOperator->True,
	FormatElements -> False, MaxElementsToList -> 25,
	KeyForm -> InputForm, CayleyForm -> OutputForm, ProductOrder -> RightToLeft};

FormGroupoidFromCycles[cl_List, opts___?OptionQ] :=
	Module[{G,wideq,groupq,genset,grpdesc,grpnm,optional,formop,
	formels,maxshow,keyForm, perms,c,po,ei},
		ei = AbstractAlgebra`Core`Private`ExtraInformation/.Flatten[{opts, 
			Options[AbstractAlgebra`Core`Private`FormGroupoidExtra]}];
		wideq = WideElements/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		groupq = IsAGroup/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		genset = Generators/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		grpdesc = GroupoidDescription/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		grpnm = GroupoidName/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		formop = FormatOperator/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		formels = FormatElements/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		keyForm = KeyForm/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		cayleyForm = CayleyForm/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		po = ProductOrder/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		maxshow = MaxElementsToList/.Flatten[{opts, Options[FormGroupoidFromCycles]}];
		If[Apply[And,Map[PermutationOrCycleQ,cl]],
			perms = cl /. Cycle[c__] :> ToPermutation[Cycle[c]];
			AppendTo[ei, {opts}];
			perms = Map[ExtendPermutation[#,Max[Map[Length,perms]]]&,perms];
			G = AbstractAlgebra`Core`Private`groupoid[perms, MultiplyPermutations[#1,#2,
				ProductOrder -> po]&, ei];
			AbstractAlgebra`Core`Private`FormatOpQ[G] = formop;
			AbstractAlgebra`Core`Private`FormatElsQ[G] = If[Length[perms] > maxshow, True, formels];
			AbstractAlgebra`Core`Private`WideElementsQ[G] = wideq;
			If[wideq, KeyForm[G] = keyForm;
				CayleyForm[G] = cayleyForm];
			GeneratingSet[G] = {};
			If[groupq, groupQ[G] = groupq];
			GroupoidDescription[G] = grpdesc;
			GroupoidName[G] = If[grpnm === "", "TheGroup", grpnm];
			If[AbstractAlgebra`Core`Private`untestedQ[GroupInfo[G]],
				GroupInfo[G] = {};
				If[grpnm =!= "", AppendTo[GroupInfo[G],grpnm]];
				If[grpdesc =!= "", AppendTo[GroupInfo[G],grpdesc]];
			];
		(* start tracking info about groupoid if not yet started *)
			OperatorSymbol[G] = "*";
			AbstractAlgebra`Core`Private`ProcessInfo[G,opts];
			G]]

FormGroupoidFromCycles[cl__?PermutationOrCycleQ, opts___?OptionQ] := 
	FormGroupoidFromCycles[{cl}, opts]

Options[Symmetric]={Mode -> Computational,
	ProductOrder -> RightToLeft, IndexLimit -> 6};

Symmetric[n_Integer?Positive] := Symmetric[n] = 
		Module[{mymode, G, po,sc,il},
	po = ProductOrder/.Flatten[{Options[Symmetric]}];
	il = IndexLimit/.Flatten[{Options[Symmetric]}];
DefaultOrder = If[po===RightToLeft,RightToLeft,LeftToRight];
If[n > il, Message[Group::size,StringJoin["S[",ToString[n],"]"],
		ToString[n!],il]; $Failed,
	G = FormGroupoid[Permutations[Range[1,n]],
  	MultiplyPermutations[#1,#2,
		ProductOrder -> DefaultOrder]&, 
		 FormatOperator->True, IsAGroup -> True,
		If[n>4,FormatElements->True,FormatElements->False],
    	GroupoidDescription -> "Symmetric group on n letters",
		GroupoidName ->StringJoin["S[",ToString[n],"]"]];
	GroupIdentity[G] = Range[1,n];
	HasIdentityQ[G] = True;
	AbstractAlgebra`Core`Private`inverseFunction[G] = PermutationInverse;
	If[n>2,AbstractAlgebra`Core`Private`WideElementsQ[G] = True];
	G]]

Symmetric[n_Integer?Positive,opts___?OptionQ] := 
		Module[{mymode, G, po,sc,il},
	mymode = Mode/.Flatten[{opts, Options[Symmetric]}];
	po = ProductOrder/.Flatten[{opts, Options[Symmetric]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	il = IndexLimit/.Flatten[{opts, Options[Symmetric]}];
DefaultOrder = If[po===RightToLeft,RightToLeft,LeftToRight];
If[n > il, Message[Group::size,StringJoin["S[",ToString[n],"]"],
		ToString[n!],il]; $Failed,
	Symmetric[n,opts] = FormGroupoid[Permutations[Range[1,n]],
  	MultiplyPermutations[#1,#2,
		ProductOrder -> DefaultOrder]&,
		  FormatOperator->True,IsAGroup -> True,
		FormatElements -> If[n>4, True,False], WideElements -> If[n>2, True,False],
    	GroupoidDescription -> "Symmetric group on n letters",
		GroupoidName ->StringJoin["S[",ToString[n],"]"]];
	G = Symmetric[n,opts];
	GroupIdentity[G] = Range[1,n];
	HasIdentityQ[G] = True;
	AbstractAlgebra`Core`Private`inverseFunction[G] = PermutationInverse;
	If[Head[G[[1,1]]]=!=List,symmetric[n,opts]=.];
	(* If[n>2,AbstractAlgebra`Core`Private`WideElementsQ[G] = True];*)
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Permutations",Symmetric,mymode,G, {n,If[n<6,Elements[G],
		"too many to show here"]}, {Null},
			{Null},{Null},sc]]]

Symmetric[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[Symmetric, many, mode])
		
Symmetric[many:{_Integer?Positive..}] :=
	Symmetric[many, Mode -> 
		(Mode/.Options[Symmetric])]
		
SymmetricTextual[n_,els_] := (
	Print["This groupoid consists of the elements (permutations)"];
	Print[els];
	Print["with the operation of permutation multiplication (composition).\n"];
	)

Symmetric[n_, opts___] := Message[Index::posint,Symmetric,n]

Unprotect[S];

S[args__] := Symmetric[args]

Protect[S];

SymmetricGroup[args__] := Symmetric[args]

PermutationGroup[args__] := Symmetric[args]

Options[SymmetricGroup] = {Mode -> Computational,
	ProductOrder -> RightToLeft};

SymmetricGroup[list_List,opts___?OptionQ] := 
		Module[{mymode, G, po, n = Length[list]},
	mymode = Mode/.Flatten[{opts, Options[Symmetric]}];
	po = ProductOrder/.Flatten[{opts, Options[Symmetric]}];
	DefaultOrder = If[po===RightToLeft,RightToLeft,LeftToRight];
	If[AbstractAlgebra`Core`Private`untestedQ[symmetricgroup[list,opts]],
		symmetricgroup[list,opts] = 
			FormGroupoid[Permutations[list],
  	MultiplyGeneralPermutations[list,#1,#2,
		ProductOrder -> DefaultOrder]&,
		 FormatOperator->True,IsAGroup -> True,
		FormatElements -> If[n>4, True,False], WideElements -> If[n>2, True,False],
    	GroupoidDescription -> "Permutation group of given list"]];
	G = symmetricgroup[list,opts];
	(* If[n>2,AbstractAlgebra`Core`Private`WideElementsQ[G] = True];*)
	If[MemberQ[textualModes,mymode], 
		out = SymmetricTextual[n]];
	G]/; Length[list]<= 6

PermutationGroup[list_List, opts___?OptionQ] := 
	SymmetricGroup[list,opts]

MultiplyGeneralPermutations[base_,g_,h_,opts___?OptionQ] :=
	Module[{rules,revrules,p,q,prod},
rules = MapThread[Rule,{base,Range[1,Length[base]]}];
revrules =Transpose[rules/.Rule->List]//Reverse//
	Transpose//Apply[Rule,#,1]&;
{p,q} = {g,h}/.rules;
prod = MultiplyPermutations[p,q,opts]/.revrules
]

Options[Alternating]={Mode -> Computational,
	ProductOrder -> RightToLeft, IndexLimit -> 6};

Alternating[n_Integer?Positive,opts___?OptionQ] := Alternating[n, opts] =
		Module[{mymode, G, po,sc,il},
	mymode = Mode/.Flatten[{opts, Options[Alternating]}];
	po = ProductOrder/.Flatten[{opts, Options[Alternating]}];
	DefaultOrder = If[po===RightToLeft,RightToLeft,LeftToRight];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	il = IndexLimit/.Flatten[{opts, Options[Alternating]}];
If[n > il, Message[Group::size,StringJoin["A[",ToString[n],"]"],
		ToString[n!/2],il]; $Failed,
	If[AbstractAlgebra`Core`Private`untestedQ[alternating[n,opts]],
		alternating[n,opts] = 
			FormGroupoid[Select[Permutations[Range[1,n]],
        	(Parity[#]==1)&],
  	MultiplyPermutations[#1,#2,
		ProductOrder -> DefaultOrder]&, 
		FormatOperator->True,IsAGroup -> True,
		FormatElements -> If[n>4, True,False], WideElements -> If[n>2, True,False],
    	GroupoidDescription -> "Alternating group on n letters",
		GroupoidName ->StringJoin["A[",ToString[n],"]"]]];
	G = alternating[n,opts];
	GroupIdentity[G] = Range[1,n];
	HasIdentityQ[G] = True;
	AbstractAlgebra`Core`Private`inverseFunction[G] = PermutationInverse;
	(* If[n>2,AbstractAlgebra`Core`Private`WideElementsQ[G] = True];*)
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Permutations",Alternating,mymode,G, {n,Elements[G]}, {Null},
			{Null},{Null},sc]]]

A[args__] := Alternating[args]

AlternatingGroup[args__] := Alternating[args]

Alternating[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[Alternating, many, mode])
		
Alternating[many:{_Integer?Positive..}] :=
	Alternating[many, Mode -> (Mode/.Options[Alternating])]

Alternating[n_, opts___] := Message[Index::posint,Alternating,n]
		
AlternatingTextual[n_,els_] := (
	Print["This groupoid consists of the even permutations"];
	Print[els];
	Print["with the operation of permutation multiplication (composition).\n"];
	)

Options[Stabilizer] = {Mode -> Computational};

Stabilizer[G_?GroupoidQ,S_,x_,opts___?OptionQ] := 
	Module[{mymode, els = Elements[G]},
	mymode = Mode/.Flatten[{opts, Options[Stabilizer]}];
If[MemberQ[S,x],
	DeleteCases[MapThread[If[FixQ[S,#2,x],els[[#1]]]&,
		{Range[Length[els]],els}],Null],
	Message[MemberQ::elmnt,x,S]]]

Stabilizer[S_,x_,opts___?OptionQ] :=
	Stabilizer[PermutationGroup[S],S,x]

Options[Orbit] = {Mode -> Computational};

Orbit[G_?GroupoidQ, S_, x_, opts___?OptionQ] := 
Module[{mymode, els = Elements[G]},
	mymode = Mode/.Flatten[{opts, Options[Orbit]}];
If[MemberQ[S,x],
	Map[PermutationImage[S,#,x]&,els]//UnionNoSort,
	Message[MemberQ::elmnt,x,S]]]
	
Orbit[S_, x_, opts___?OptionQ] :=
	Orbit[PermutationGroup[S],S,x]


RandomColoredSquares[n_Integer?Positive, colors_List:{RGBColor[1,0,0],RGBColor[0,0,1],
 RGBColor[0,1,0],RGBColor[1,0,1],RGBColor[1,1,0],RGBColor[0,1,1],
 RGBColor[1,.5,0],RGBColor[1,.752907,.796106],
 RGBColor[.250999,.878399,.815699],
 RGBColor[0.902005,0.902005,0.980407],
 RGBColor[0.498001,1,0.831401],RGBColor[0,0,0.501999]}] := 
	Module[{cl,gr,perm, dx = 0.1},
If[n > 12, 
	Print["When a value greater than 12 is used, you need to provide (as a second
	argument) a list of colors as well."]; $Failed,
perm = RandomPermutation[n];
CurrentColorList = Take[colors,n][[perm]];
CurrentPermList = {Range[n],CurrentColorList};
gr=Show[Graphics[Table[{{CurrentColorList[[i]],
	Rectangle[{(i-1)+dx, 0+dx}, {i-dx, 1-dx}]}, {RGBColor[0,0,0],Text[i, 
	{(i-1) + 0.5, 0.5}]}},{i, n}]]]
]]

PermuteColoredSquares[p_] := 
	Module[{cl,gr1,gr2,perm,i,n = Length[p], dx = 0.1,q},
If[Head[p[[1]]]===Rule,perm = ToPermutation[p]//PermutationInverse,
	perm = PermutationInverse[p]];
q = PermutationInverse[perm];
If[Length[p]===Length[CurrentColorList],
gr1=Graphics[Table[{{CurrentColorList[[i]],
	Rectangle[{(i-1)+dx, 0+dx}, {i-dx, 1-dx}]}, {RGBColor[0,0,0],Text[i, 
	{(i-1) + 0.5,0.5}]}},{i,n}]];
gr2=Graphics[Table[{{CurrentColorList[[perm[[i]]]],
	Rectangle[{(i-1)+dx, -2+dx}, {i-dx, -1-dx}]},{RGBColor[0,0,0],Text[perm[[i]], 
	{(i-1) + 0.5,-1.5}]}},{i,n}]];
gr3=Graphics[{RGBColor[0,0,0],Table[Arrow[{(i-1)+.5, 0+dx},
	{q[[i]] -.5,-1-dx}],{i,n}]}];
Show[{gr1,gr2,gr3},DisplayFunction -> $DisplayFunction]
]]

ShowColoredPermutation[p_] := 
	Module[{q,cl,gr1,gr2,perm,i,n = Length[p], colors={RGBColor[1,0,0],RGBColor[0,0,1],
 RGBColor[0,1,0],RGBColor[1,0,1], RGBColor[1,1,0],
 RGBColor[0,1,1],RGBColor[1,.5,0],RGBColor[1,.752907,.796106],
 RGBColor[.250999,.878399,.815699],
 RGBColor[0.902005,0.902005,0.980407],RGBColor[0.498001,1,0.831401],
 RGBColor[0,0,0.501999]}, dx = 0.1},
If[Head[p[[1]]]===Rule,perm = ToPermutation[p]//PermutationInverse,
	perm = PermutationInverse[p]];
q = PermutationInverse[perm];
If[Length[p]=!=Length[CurrentColorList],
	CurrentColorList = Take[colors,n][[perm]]];
gr1=Graphics[Table[{{CurrentColorList[[i]],
	Rectangle[{(i-1)+dx, 0+dx}, {i-dx, 1-dx}]}, {RGBColor[0,0,0],Text[i, 
	{(i-1) + 0.5,0.5}]}},{i,n}]];
gr2=Graphics[Table[{{CurrentColorList[[perm[[i]]]],
	Rectangle[{(i-1)+dx, -2+dx}, {i-dx, -1-dx}]}, {RGBColor[0,0,0],Text[perm[[i]], 
	{(i-1) + 0.5,-1.5}]}},{i,n}]];
gr3=Graphics[{RGBColor[0,0,0],Table[Arrow[{(i-1)+.5, 0+dx},
	{q[[i]] -.5,-1-dx}],{i,n}]}];
Show[{gr1,gr2,gr3},DisplayFunction -> $DisplayFunction]
]

SideBySideMatrices[p_,q_] := MatrixForm[{Join[Range[Length[p]],
{" "},Range[Length[q]]],Join[ToPermutation[p],{" "},
ToPermutation[q]]}]

End[];

Protect[S];

EndPackage[];

DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];