(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     49777,       1396]*)
(*NotebookOutlinePosition[     50753,       1427]*)
(*  CellTagsIndexPosition[     50709,       1423]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Table of Contents", "ContentsTitle"],

Cell[TextData[ButtonBox["Ring Lab 1. An introduction to rings and Ringoids",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.1"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"1.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.2.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.3.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.4.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.3 Getting started? Begin here",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.5.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.4 Ringoids and rings",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.6.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.5 Properties of rings",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.7.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.5.1 Additive properties",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.7.2.1"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["1.5.2 Multiplicative properties",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.7.3.1"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["1.5.3 Distributive property",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.7.4.1"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["1.5.4 Is the Ringoid a ring?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.7.5.1"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["1.5.5 \"Optional\" properties",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.7.6.1"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["1.6 Additional exercises",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.8.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.7 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.9.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 2. An introduction to rings: part two",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.2"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"2.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.3.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.4.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.5.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.3 Units & zero divisors",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.6.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.3.1 Units of a ring",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.6.3.2"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["2.3.2 Zero divisors of a ring",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.6.4.2"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["2.3.3 Working with zero divisors",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.6.5.2"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["2.4 Integral domains",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.7.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.5 Fields",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.8.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.6 Additional exercises",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.9.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.7 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.10.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 3. An ideal part of rings",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.3"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"3.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.4.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.5.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.6.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.3 What is the ideal part of a ring?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.7.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.3.1 The definition:",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.7.4.3"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["3.3.2 Another ring",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.7.5.3"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["3.4 Ideals factor into other ring properties",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.8.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.9.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(Ring\ Lab\ 4. \), " ", \(What\ does\ \), 
            
            FormBox[\(\[DoubleStruckCapitalZ][i]/
                \[LeftAngleBracket]a\  + \ b\ i\[RightAngleBracket]\),
              "TraditionalForm"], \(\ look\ \(like?\)\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab04.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:4.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "ContentsSection"],

Cell[TextData[ButtonBox[
"4.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.5.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["4.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.6.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["4.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.7.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["4.3 First example",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.8.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["4.3.1 What ring is it?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.8.5.4"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["4.4 A second example",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.9.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["4.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.10.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 5. Ring homomorphisms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.5"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"5.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.6.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.7.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.8.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.3 Morphoids on rings",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.9.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.4 Ring homomorphisms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.10.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.5 The kernel and image",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.11.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.5.1 The kernel",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.11.6.5"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["5.5.2 The image",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.11.7.5"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["5.6 The kernel is an ideal",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.12.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.6.1 Example 1",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.12.6.5"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["5.6.2 The First Isomorphism Theorem (for rings)",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.12.7.5"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["5.6.3 Example 2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.12.8.5"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["5.7 One rule Morphoids",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.13.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.8 The Chinese Remainder Theorem",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.14.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.9 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.15.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 6. Polynomial rings",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.6"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"6.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.7.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["6.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.8.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["6.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.9.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["6.3 An introduction to polynomials",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.10.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["6.4 Divide and conquer",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.11.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["6.4.1 The Euclidean Algorithm",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.11.7.6"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["6.4.2 Another approach",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.11.8.6"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["6.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.12.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 7. Factoring and irreducibility",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.7"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"7.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.8.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.9.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.10.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox[
"7.3 An introduction to factoring and irreducibility",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.11.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox[
"7.4 Some techniques on testing the irreducibility of polynomials",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.12.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(7.4  .1\ Polynomials\ over\ \),
              AspectRatioFixed->True], 
            FormBox[\(\[DoubleStruckCapitalZ]\_p\),
              "TraditionalForm"], 
            StyleBox[" ",
              AspectRatioFixed->True,
              FontVariations->{"CompatibilityType"->"Subscript"}], 
            StyleBox[\(\(--Theorem\)\ 1\),
              AspectRatioFixed->True]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.8.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(7.4  .2\ \),
              AspectRatioFixed->True], 
            FormBox[\(2 x^3\  + \ 3 x^2\  - \ 1\),
              "TraditionalForm"], \(\ 
            over\ \(\[DoubleStruckCapitalQ]\ --\)\ Rational\ Root\ Theorem
              \)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.9.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(7.4  .3\ \),
              AspectRatioFixed->True], 
            FormBox[\(x^4\  - \ 2 x^3\  - \ 7\ x^2\  - \ 11/3 x\  - \ 4/3\),
              "TraditionalForm"], \(\ over\ \), 
            FormBox["\[DoubleStruckCapitalQ]",
              "TraditionalForm"], \(\ \(--\ Mod\)\ \), 
            FormBox["p",
              "TraditionalForm"], \(\ Irreducibility\ Test\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.10.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(7.4  .4\ \),
              AspectRatioFixed->True], 
            FormBox[\(x^4\  - \ 3 x^2\  + \ 2 x\  + \ 1\),
              "TraditionalForm"], \(\ 
            over\ \(\[DoubleStruckCapitalQ]\ --\)\ how\ to\ handle\ quartics
              \)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.11.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(7.4  .5\ \), 
            FormBox[\(2 x^4 - 2 x^3 - 17 x^2 + 25 x - 7\),
              "TraditionalForm"], \(\ 
            over\ \(\[DoubleStruckCapitalZ]\ --\) Theorem\ 2\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.12.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(7.4  .6\ \), 
            FormBox[\(3 x^8\  - \ 4 x^6\  + \ 8 x^5\  - \ 10 x\  + \ 6\),
              "TraditionalForm"], \(\ over\ \), 
            FormBox["\[DoubleStruckCapitalQ]",
              "TraditionalForm"], \(\ \(--\ Eisenstein\)' s\ Criterion\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.13.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(7.4  .7\ \), 
            FormBox[\(x^4\  + \ 4\),
              "TraditionalForm"], 
            StyleBox[\(\ over\ \),
              AspectRatioFixed->True], 
            FormBox[\(\[DoubleStruckCapitalZ]\_7\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.14.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(7.4  .8\ \), 
            FormBox[\(x^4\  - \ 2 x^3\  + \ x^2\  + \ 1\),
              "TraditionalForm"], \(\ over\ \[DoubleStruckCapitalR]\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:7.12.15.7"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[ButtonBox["7.5 More polynomials for practice",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.13.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.6 Toolbox of theorems",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.14.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.7 A final perspective",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.15.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.8 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.16.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 8. Roots of unity",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.8"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"8.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.9.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.10.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.11.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.3 An introduction",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.12.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.4 A closer look -- graphically",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.13.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.5 Another look -- algebraically",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.14.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.15.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 9. Cyclotomic polynomials",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.9"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"9.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.10.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["9.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.11.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["9.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.12.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["9.3 An introduction",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.13.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(9.4\ The\ search\ for\ \),
              AspectRatioFixed->True], 
            FormBox[\(\(g\_n\)(x)\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:9.14.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(9.5\ Some\ properties\ of\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "x", ")"}],
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["9.5.1 Each cyclotomic polynomial is monic",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.15.10.9"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["9.5.2 The degrees of the cyclotomic polynomials",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.15.11.9"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox[
"9.5.3 The irreducibility of the cyclotomic polynomial",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.15.12.9"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["9.5.4 Graphs of roots of the cyclotomic polynomial",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.15.13.9"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5  .5\ \), 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ and\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], \(2 n\)], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ for\ odd\ \),
              AspectRatioFixed->True], 
            FormBox["n",
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.14.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5  .6\ \), 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "p"], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ and\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], \(p\^k\)], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ for\ prime\ \),
              AspectRatioFixed->True], 
            FormBox["p",
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.15.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5  .7\ \), 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ and\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "m"], "(", "x", ")"}],
              "TraditionalForm"], 
            StyleBox[\(\ where\ \),
              AspectRatioFixed->True], 
            FormBox["m",
              "TraditionalForm"], 
            StyleBox[\(\ and\ \),
              AspectRatioFixed->True], 
            FormBox["n",
              "TraditionalForm"], 
            StyleBox[\(\ have\ similar\ prime\ decompositions\),
              AspectRatioFixed->True]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.16.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5  .8\ \), 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "1", ")"}],
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.17.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(9.5  .9\ \), 
            StyleBox[\(How\ \),
              AspectRatioFixed->True], 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["\[CapitalPhi]",
                    AspectRatioFixed->True], "n"], "(", "x", ")"}],
              "TraditionalForm"], 
            
            StyleBox[\(\ is\ related\ to\ the\ Moebius\ function, \ 
              yielding\ a\ non - recursive\ definition\),
              AspectRatioFixed->True]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:9.15.18.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Index"],

Cell[TextData[ButtonBox["9.5.10 Disclaimer/warning",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.15.19.9"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["9.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.16.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 10. Quotient rings of polynomials",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.10"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"10.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.11.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.12.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.13.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.3 Polynomials over a field",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.14.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.4 A homomorphism based on PolynomialRemainder",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.15.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.5 Defining a quotient ring of polynomials",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.16.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.5.1 Addition",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.16.11.10"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["10.5.2 Multiplication",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.16.12.10"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["10.6 The PolynomialRemainder function ",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.17.10"},
  ButtonStyle->"Hyperlink"],
ButtonBox["\[Theta]",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.17.10"},
  ButtonStyle->"Hyperlink"],
ButtonBox[" is indeed a homomorphism",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.17.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.7 Is V a field?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.18.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.8 Is V what we claimed?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.19.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.9 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.20.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 11. Quadratic field extensions",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.11"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"11.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.12.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.13.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.14.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.3 The general problem",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.15.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.3.1 Example",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.15.12.11"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(11.4\ An\ extension\ of\ \),
              AspectRatioFixed->True], 
            FormBox[\(\[DoubleStruckCapitalZ]\_3\ \),
              "TraditionalForm"], 
            StyleBox[\(using\ \),
              AspectRatioFixed->True], 
            StyleBox["Mathematica",
              AspectRatioFixed->True,
              FontSlant->"Italic"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab11.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:11.16.11"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["11.5 Theorems that are motivated from this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.17.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.18.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(Ring\ Lab\ 12. \ Factoring\ in\ \), 
            FormBox[\(\[DoubleStruckCapitalZ] \([\[Sqrt]d\)]\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:12.12"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "ContentsSection"],

Cell[TextData[ButtonBox[
"12.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.13.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.14.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.15.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.3 An introduction to divisibility",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.16.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.4 Associates, irreducibility and norms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.17.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(12.5\ \),
              AspectRatioFixed->True], \(Units\ in\ \), 
            FormBox[\(\[DoubleStruckCapitalZ] \([\[Sqrt]d\)]\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:12.18.12"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(12.6\ \),
              AspectRatioFixed->True], \(Factoring\ 46\ in\ \), 
            FormBox[\(\[DoubleStruckCapitalZ] \([\[Sqrt]\((\(-5\))\)\)]\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:12.19.12"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(12.7\ \),
              AspectRatioFixed->True], \(Is\ \), 
            FormBox[\(\[DoubleStruckCapitalZ] \([\[Sqrt]\((\(-6\))\)\)]\),
              "TraditionalForm"], \(\ a\ \(UFD?\)\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:12.20.12"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["12.8 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.21.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Ring Lab 13. Finite fields",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.13"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"13.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.14.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.15.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.16.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.3 Creation of finite fields",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.17.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.4 Finite field theorems and illustrations",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.18.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "RngLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.19.13"},
  ButtonStyle->"Hyperlink"]], "Contents"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
ScreenStyleEnvironment->"AllBrackets",
WindowSize->{520, 509},
WindowMargins->{{156, Automatic}, {Automatic, 38}},
WindowTitle->Automatic,
TaggingRules:>{"TOCNotebook" -> True},
StyleDefinitions -> "Manual.nb",
MacintoshSystemPageSetup->"\<\
00<00018050000000_02P?oLon`2m0:D0@85:0?l00400018050000000_02P01@
0202P0b001P00@4100000BL?00410@00000000000000000000000@0000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 42, 0, 46, "ContentsTitle"],
Cell[1754, 51, 240, 4, 37, "ContentsSection"],
Cell[1997, 57, 249, 5, 22, "Contents"],
Cell[2249, 64, 203, 4, 22, "Contents"],
Cell[2455, 70, 208, 4, 22, "Contents"],
Cell[2666, 76, 217, 4, 22, "Contents"],
Cell[2886, 82, 208, 4, 22, "Contents"],
Cell[3097, 88, 209, 4, 22, "Contents"],
Cell[3309, 94, 210, 4, 14, "Index"],
Cell[3522, 100, 216, 4, 14, "Index"],
Cell[3741, 106, 212, 4, 14, "Index"],
Cell[3956, 112, 213, 4, 14, "Index"],
Cell[4172, 118, 214, 4, 14, "Index"],
Cell[4389, 124, 210, 4, 22, "Contents"],
Cell[4602, 130, 227, 4, 22, "Contents"],
Cell[4832, 136, 237, 4, 37, "ContentsSection"],
Cell[5072, 142, 249, 5, 22, "Contents"],
Cell[5324, 149, 203, 4, 22, "Contents"],
Cell[5530, 155, 208, 4, 22, "Contents"],
Cell[5741, 161, 211, 4, 22, "Contents"],
Cell[5955, 167, 206, 4, 14, "Index"],
Cell[6164, 173, 214, 4, 14, "Index"],
Cell[6381, 179, 217, 4, 14, "Index"],
Cell[6601, 185, 206, 4, 22, "Contents"],
Cell[6810, 191, 196, 4, 22, "Contents"],
Cell[7009, 197, 210, 4, 22, "Contents"],
Cell[7222, 203, 228, 4, 22, "Contents"],
Cell[7453, 209, 225, 4, 37, "ContentsSection"],
Cell[7681, 215, 249, 5, 22, "Contents"],
Cell[7933, 222, 203, 4, 22, "Contents"],
Cell[8139, 228, 208, 4, 22, "Contents"],
Cell[8350, 234, 223, 4, 22, "Contents"],
Cell[8576, 240, 206, 4, 14, "Index"],
Cell[8785, 246, 203, 4, 14, "Index"],
Cell[8991, 252, 230, 4, 22, "Contents"],
Cell[9224, 258, 227, 4, 22, "Contents"],
Cell[9454, 264, 795, 20, 35, "ContentsSection"],
Cell[10252, 286, 249, 5, 22, "Contents"],
Cell[10504, 293, 203, 4, 22, "Contents"],
Cell[10710, 299, 208, 4, 22, "Contents"],
Cell[10921, 305, 203, 4, 22, "Contents"],
Cell[11127, 311, 207, 4, 14, "Index"],
Cell[11337, 317, 206, 4, 22, "Contents"],
Cell[11546, 323, 228, 4, 22, "Contents"],
Cell[11777, 329, 221, 4, 37, "ContentsSection"],
Cell[12001, 335, 249, 5, 22, "Contents"],
Cell[12253, 342, 203, 4, 22, "Contents"],
Cell[12459, 348, 208, 4, 22, "Contents"],
Cell[12670, 354, 208, 4, 22, "Contents"],
Cell[12881, 360, 209, 4, 22, "Contents"],
Cell[13093, 366, 211, 4, 22, "Contents"],
Cell[13307, 372, 202, 4, 14, "Index"],
Cell[13512, 378, 201, 4, 14, "Index"],
Cell[13716, 384, 213, 4, 22, "Contents"],
Cell[13932, 390, 201, 4, 14, "Index"],
Cell[14136, 396, 233, 4, 14, "Index"],
Cell[14372, 402, 201, 4, 14, "Index"],
Cell[14576, 408, 209, 4, 22, "Contents"],
Cell[14788, 414, 220, 4, 22, "Contents"],
Cell[15011, 420, 228, 4, 22, "Contents"],
Cell[15242, 426, 219, 4, 37, "ContentsSection"],
Cell[15464, 432, 249, 5, 22, "Contents"],
Cell[15716, 439, 203, 4, 22, "Contents"],
Cell[15922, 445, 208, 4, 22, "Contents"],
Cell[16133, 451, 221, 4, 22, "Contents"],
Cell[16357, 457, 209, 4, 22, "Contents"],
Cell[16569, 463, 215, 4, 14, "Index"],
Cell[16787, 469, 208, 4, 14, "Index"],
Cell[16998, 475, 228, 4, 22, "Contents"],
Cell[17229, 481, 231, 4, 37, "ContentsSection"],
Cell[17463, 487, 249, 5, 22, "Contents"],
Cell[17715, 494, 203, 4, 22, "Contents"],
Cell[17921, 500, 209, 4, 22, "Contents"],
Cell[18133, 506, 239, 5, 22, "Contents"],
Cell[18375, 513, 252, 5, 22, "Contents"],
Cell[18630, 520, 952, 25, 13, "Index"],
Cell[19585, 547, 815, 22, 12, "Index"],
Cell[20403, 571, 949, 24, 12, "Index"],
Cell[21355, 597, 826, 22, 12, "Index"],
Cell[22184, 621, 734, 19, 12, "Index"],
Cell[22921, 642, 816, 20, 12, "Index"],
Cell[23740, 664, 805, 22, 13, "Index"],
Cell[24548, 688, 702, 18, 12, "Index"],
Cell[25253, 708, 220, 4, 22, "Contents"],
Cell[25476, 714, 210, 4, 22, "Contents"],
Cell[25689, 720, 210, 4, 22, "Contents"],
Cell[25902, 726, 228, 4, 22, "Contents"],
Cell[26133, 732, 217, 4, 37, "ContentsSection"],
Cell[26353, 738, 249, 5, 22, "Contents"],
Cell[26605, 745, 204, 4, 22, "Contents"],
Cell[26812, 751, 209, 4, 22, "Contents"],
Cell[27024, 757, 206, 4, 22, "Contents"],
Cell[27233, 763, 219, 4, 22, "Contents"],
Cell[27455, 769, 220, 4, 22, "Contents"],
Cell[27678, 775, 228, 4, 22, "Contents"],
Cell[27909, 781, 225, 4, 37, "ContentsSection"],
Cell[28137, 787, 250, 5, 22, "Contents"],
Cell[28390, 794, 204, 4, 22, "Contents"],
Cell[28597, 800, 209, 4, 22, "Contents"],
Cell[28809, 806, 206, 4, 22, "Contents"],
Cell[29018, 812, 718, 20, 21, "Contents"],
Cell[29739, 834, 871, 24, 23, "Contents"],
Cell[30613, 860, 228, 4, 14, "Index"],
Cell[30844, 866, 234, 4, 14, "Index"],
Cell[31081, 872, 241, 5, 14, "Index"],
Cell[31325, 879, 237, 4, 14, "Index"],
Cell[31565, 885, 1230, 34, 15, "Index"],
Cell[32798, 921, 1233, 34, 16, "Index"],
Cell[34034, 957, 1462, 40, 15, "Index"],
Cell[35499, 999, 792, 22, 15, "Index"],
Cell[36294, 1023, 1044, 28, 15, "Index"],
Cell[37341, 1053, 212, 4, 14, "Index"],
Cell[37556, 1059, 228, 4, 22, "Contents"],
Cell[37787, 1065, 235, 4, 37, "ContentsSection"],
Cell[38025, 1071, 253, 5, 22, "Contents"],
Cell[38281, 1078, 207, 4, 22, "Contents"],
Cell[38491, 1084, 212, 4, 22, "Contents"],
Cell[38706, 1090, 218, 4, 22, "Contents"],
Cell[38927, 1096, 237, 4, 22, "Contents"],
Cell[39167, 1102, 233, 4, 22, "Contents"],
Cell[39403, 1108, 204, 4, 14, "Index"],
Cell[39610, 1114, 210, 4, 14, "Index"],
Cell[39823, 1120, 586, 14, 22, "Contents"],
Cell[40412, 1136, 207, 4, 22, "Contents"],
Cell[40622, 1142, 215, 4, 22, "Contents"],
Cell[40840, 1148, 231, 4, 22, "Contents"],
Cell[41074, 1154, 232, 4, 37, "ContentsSection"],
Cell[41309, 1160, 253, 5, 22, "Contents"],
Cell[41565, 1167, 207, 4, 22, "Contents"],
Cell[41775, 1173, 212, 4, 22, "Contents"],
Cell[41990, 1179, 213, 4, 22, "Contents"],
Cell[42206, 1185, 203, 4, 14, "Index"],
Cell[42412, 1191, 924, 25, 21, "Contents"],
Cell[43339, 1218, 235, 4, 22, "Contents"],
Cell[43577, 1224, 231, 4, 22, "Contents"],
Cell[43811, 1230, 699, 18, 36, "ContentsSection"],
Cell[44513, 1250, 253, 5, 22, "Contents"],
Cell[44769, 1257, 207, 4, 22, "Contents"],
Cell[44979, 1263, 212, 4, 22, "Contents"],
Cell[45194, 1269, 225, 4, 22, "Contents"],
Cell[45422, 1275, 230, 4, 22, "Contents"],
Cell[45655, 1281, 747, 20, 25, "Contents"],
Cell[46405, 1303, 766, 20, 25, "Contents"],
Cell[47174, 1325, 770, 20, 25, "Contents"],
Cell[47947, 1347, 231, 4, 22, "Contents"],
Cell[48181, 1353, 219, 4, 37, "ContentsSection"],
Cell[48403, 1359, 253, 5, 22, "Contents"],
Cell[48659, 1366, 207, 4, 22, "Contents"],
Cell[48869, 1372, 212, 4, 22, "Contents"],
Cell[49084, 1378, 219, 4, 22, "Contents"],
Cell[49306, 1384, 233, 4, 22, "Contents"],
Cell[49542, 1390, 231, 4, 22, "Contents"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

