(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     57570,       2242]*)
(*NotebookOutlinePosition[     62290,       2399]*)
(*  CellTagsIndexPosition[     61556,       2371]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 1",
    FontSize->18],
  "\nIntroduction to Rings and ",
  StyleBox["Ringoids",
    FontFamily->"Courier"]
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.1"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.2.1"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.3.1"],

Cell["\<\
There are no prerequisites for this lab, although a brief \
introduction to the terminology related to rings might be beneficial.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.4.1"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to introduce both the mathematical concept of the \
structure of a ring and the corresponding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" structure ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". Various properties that a ring must and can have are introduced, and the \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands to explore these properties are illustrated.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Getting started? Begin here"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.5.1"],

Cell[TextData[{
  StyleBox["In most of the labs in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", we need first to read in extra ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " packages necessary to provide the functionality within the lab. This is \
done using a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Needs",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" statement. (Usually, just reading in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra`Master`",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " package is done.) On opening this notebook you were probably asked, \
\[OpenCurlyDoubleQuote]Do you want to automatically evaluate all the \
initialization cells in the Notebook?\[CloseCurlyDoubleQuote] If you answered \
affirmatively, then you do not need to evaluate the following cell, but it \
doesn",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "t hurt to do so. If you answered negatively, then you need to evaluate \
this cell.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Ringoids and rings"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.6.1"],

Cell[TextData[{
  StyleBox[
  "Consider any set and two operations on that set. We will call this \
structure a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". An example of a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is the following.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(R = FormRingoid[{0, 1, 2}, Mod[#1 + #2, 3]&, Mod[#1\ #2, 3]&]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We always refer to the first operation of a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["addition ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["and the second as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["multiplication",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". However, there is no restriction on either of the operations. (In other \
words, there is no implication that the addition could not ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["act like",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" multiplication and the multiplication ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["act like",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " some other type of operation.) One can access these operations as \
follows.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Addition[R]\), 
    \(Multiplication[R]\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
To compute the sum of 2 and 2, as well as the product of 2 and 2, \
one does as follows.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Addition[R]\)[2, 2]\), 
    \(\(Multiplication[R]\)[2, 2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Will it always be the case that the addition and multiplication return \
the same value? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The set of elements in a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is obtained using either of the following methods.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Elements[R]\), 
    \(Domain[R]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The operations on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[
  " are mod 3 addition and mod 3 multiplication, with which you may be well \
acquainted. The operation tables for any ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" may be displayed with the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["CayleyTables",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(CayleyTables[R, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The output of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["CayleyTables",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Visual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " mode, appears in two forms. There are two graphical objects that resemble \
tables that appear in an abstract algebra text and a pair of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " lists representing the tables. If you want to look at just the graphical \
tables, you need to end the input cell with a semicolon (;) so that the list \
of lists is not displayed. We often do this from now on. On the other hand, \
if you are interested only in the output, you may want to drop the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mode ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  "\[Rule]",
  StyleBox[" Visual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" argument.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We consider several types of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". Note that the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" we have been calling ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[
  " is simply the set of integers mod 3 with the appropriate operations. It \
can also be obtained by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Z[3]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Z[3]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For every integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n \[GreaterEqual] 1\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" is the ring with domain ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{0, 1, \(\( .  . \) . \), n - 1}\)]],
  StyleBox[" and operations mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" addition and mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" multiplication. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "If you did some of the group labs, you may recall that we also use ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " for the group consisting of the same set but with just addition mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". By default, when we work with rings, we intend ",
  StyleBox["Z[n]",
    FontFamily->"Courier"],
  " to refer to the ring ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ". We can always obtain the group as follows."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Z[3, Structure \[Rule] Group]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We can change the default understanding of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" to be the group or ring by specifying the options for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[". For example, when reading in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " code at startup, the equivalent of the following statement was \
evaluated.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SetOptions[Z, Structure \[Rule] Ring]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We could change ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ring",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Group",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and then ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[
  " would thereafter be understood to be the group instead of the ring. \
(Note: The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SwitchStructureTo",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " function may also be useful.) We use this family of rings extensively in \
this lab and subsequent labs. Other rings are introduced as well. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Properties of rings"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.1"],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s consider some of the properties of a ring. Execute \
the following cell to be given a random ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {8, 19}]\), 
    \(T = Z[n]\)}], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["1.5.1 Additive properties", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.2.1"],

Cell[TextData[{
  StyleBox[
  "The first few properties pertain only to the addition. To test these \
properties, we form the additive ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" consisting of the elements and the addition of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?AdditiveGroupoid\)\)], "Input"],

Cell[BoxData[
    \(AG = AdditiveGroupoid[T]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Addition must be closed", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.2.2.1"],

Cell[TextData[{
  StyleBox["Recall that a set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["closed",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" under the operation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`*\)]],
  StyleBox[" if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g*h\)]],
  StyleBox[" is in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[". We can test for this property with the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ClosedQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". We can check either the additive ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " with a restriction on the operation. (Almost all the ring properties are \
related to group properties of either the additive or multiplicative ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". In each case, we can check the particular ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or check the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" by specifying a value for the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Operation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" option.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(ClosedQ[AG]\), 
    \(ClosedQ[T, Operation \[Rule] Addition]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Operation\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Addition must be associative", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.2.3.1"],

Cell[TextData[{
  StyleBox["Recall that addition is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["associative",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" if and only if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a + \((b + c)\) = \((a + b)\) + c\)]],
  StyleBox[" for all values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ",",
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[
  " in the domain. We can test for this property with the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AssociativeQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(AssociativeQ[T, Operation \[Rule] Addition]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For larger ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", this test is time-consuming. Use of the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RandomAssociativeQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is advised for these ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". This function tests random triples ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((a, b, c)\)\)]],
  StyleBox[
  " for the associative property. If any triple violates the condition, the \
addition is known to be not associative. If no violation occurs, it is likely \
that the addition is associative.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Addition must be commutative", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.2.4.1"],

Cell[TextData[{
  StyleBox["Addition is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["commutative",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" if and only if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a + b = b + a\)]],
  StyleBox[" for all values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[
  " in the domain. You can test for this property with the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbelianQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["CommutativeQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", but the former works only with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoids.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (Thus we can use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbelianQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" with the additive ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["CommutativeQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(AbelianQ[AG]\), 
    \(CommutativeQ[T, Operation \[Rule] Addition]\)}], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Existence of a \[OpenCurlyDoubleQuote]zero\[CloseCurlyDoubleQuote]"], 
  "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.2.5.1"],

Cell[TextData[{
  StyleBox["The term ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["zero",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" is used for the additive identity of a ring. That is, if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[" is the zero, then",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`z + r = \(r + z = r\)\)]]], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  "for all ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " in the ring. To ask whether a zero exists, use the following."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(HasIdentityQ[T, Operation \[Rule] Addition]\)], "Input",
  AspectRatioFixed->True],

Cell["This test can be performed more directly as follows.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(HasZeroQ[T]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["When a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" has a zero, it can be called upon by name.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Zero[T]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the zero of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid[{0, 1, 2, 3}, Mod[#1 + #2, 4] & , Mod[#1*#2, 4] & ]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the zero of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid[{0, 1, 2, 3}, Mod[#1*#2, 4] & , Mod[#1 + #2, 4] & ]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Additive inverses", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.2.6.1"],

Cell[TextData[{
  StyleBox["Assuming a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" has a zero ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[", we say ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" is the additive inverse of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s + r = \(r + s = z\)\)]],
  ". ",
  StyleBox[
  "All elements of a ring must have an additive inverse. The additive inverse \
of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" is referred to as its ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["negation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". We can ask whether all elements have an additive inverse.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(HasInversesQ[T, Operation \[Rule] Addition]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "We can also ask for a list that displays how the elements of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " pair up as inverses. As long as the addition is associative, it can be \
proven that no element can have more than one negation. You will find that in \
some cases an element is its own negation. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Inverses[T, Operation \[Rule] Addition]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". How many elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  StyleBox[" are their own negation? (What is your ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  StyleBox["?)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The negation of an individual ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" element can be determined using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NegationOf",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(NegationOf[T, 1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Below, form another random ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[", named ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["T2",
    FontFamily->"Courier"],
  StyleBox[
  ". What ring did you get? For each element, determine its negation without \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". Use either ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Inverses",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NegationOf",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to check your work.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {5, 12}]\), 
    \(T2 = Z[n]\)}], "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5.2 Multiplicative properties", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.3.1"],

Cell[TextData[{
  StyleBox["We use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MG",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for the multiplicative ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" of the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?MultiplicativeGroupoid\)\)], "Input"],

Cell[BoxData[
    \(MG = MultiplicativeGroupoid[T]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Multiplication must be closed", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.3.2.1"],

Cell[TextData[{
  StyleBox[
  "Not only must the addition be closed, the multiplication must be closed as \
well. As noted, we can either check the multiplicative ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and restrict the operation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(ClosedQ[MG]\), 
    \(ClosedQ[T, Operation \[Rule] Multiplication]\)}], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Multiplication must be associative", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.3.3.1"],

Cell["\<\
Besides being closed, the multiplication must also be \
associative.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(AssociativeQ[T, Operation \[Rule] Multiplication]\)], "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5.3 Distributive property", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.4.1"],

Cell[TextData[{
  StyleBox[
  "There is one property that considers how the addition and multiplication \
interact: multiplication must be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["distributive",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" over addition in order for a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to be a ring. That is, we must have",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`a\ \((b + c)\) = a\ b + a\ c\)]],
  "         and         ",
  Cell[BoxData[
      \(TraditionalForm\`\((b + c)\)\ a = b\ a + c\ a\)]]
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["for all values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[" in the domain of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DistributiveQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" tests for this property.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(DistributiveQ[T]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["A function called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RandomDistributiveQ,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" which is similar to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RandomAssociativeQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", is also available.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "1.5.4 Is the ",
  StyleBox["Ringoid",
    FontFamily->"Courier"],
  " a ring?"
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.5.1"],

Cell[TextData[{
  StyleBox["If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["all",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " the properties we have tested up to this point are satisfied, then we can \
call the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ring",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". We can use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RingQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to perform all these tests in one statement.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(RingQ[T]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["As we work with a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " and is testing various properties, the results are collected and can be \
retrieved by a function called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RingInfo",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". Here is what we know so far about ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(RingInfo[T]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Given any value of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[", is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" a ring? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"1.5.5 \[OpenCurlyDoubleQuote]Optional\[CloseCurlyDoubleQuote] properties"], 
  "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.6.1"],

Cell["\<\
Additional properties are frequently satisfied by a ring. We will \
often look for rings that satisfy some combination of these properties in the \
future. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Ring with unity", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.6.2.1"],

Cell[TextData[{
  StyleBox["Unity",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " is the term that is used for the multiplicative identity of a ring. That \
is, if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  StyleBox[" is the unity, then",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`u\ r = \(r\ u = r\)\)]]], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  "for all ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " in the ring. To determine whether a unity exists, try the following."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(WithUnityQ[T]\)], "Input",
  AspectRatioFixed->True],

Cell["If there is a unity, it can be called on by name.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Unity[T]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Does ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" have a unity for all values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["? Why or why not? If so, what is it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Commutative ring", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.6.3.1"],

Cell[TextData[{
  StyleBox["A ring is said to be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["commutative",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " if its multiplication is commutative. (Recall that the addition ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["must",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" be commutative in a ring.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(CommutativeQ[T, Operation \[Rule] Multiplication]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"There are several other \[OpenCurlyDoubleQuote]optional\
\[CloseCurlyDoubleQuote] properties that we will introduce in Ring Lab 2."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" commutative for all values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Additional exercises"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.8.1"],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" is a divisor of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[", we use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Z[n, k]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to denote the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" whose elements are {0, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[", 2",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[", \[Ellipsis], ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((n\/k - 1)\) k\)]],
  StyleBox["} with addition being mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" addition and multiplication being mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" multiplication. Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Z[8, 2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " a ring? Is it commutative? Is it a ring with unity? Justify your \
answers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Z[10, 2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " a ring? Is it commutative? Is it a ring with unity? Justify your \
answers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What happens if you switch the addition and multiplication in a ring? In \
other words, if we have a ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["R = Ringoid[D, plus, times]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", then is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid[D, times, plus]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ever a ring? Try ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Z[n, k]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for various ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" and see if you can produce such a ring.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Evaluate the following cells. Study the multiplication tables. Do you \
note any differences or similarities between any of these rings?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[Z[4], Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[Z[5], Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[Z[6], Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[Z[7], Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.7 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands used in this lab"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.9.1"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?SwitchStructureTo", "Input",
  AspectRatioFixed->True],

Cell["?FormRingoid", "Input",
  AspectRatioFixed->True],

Cell["?Addition", "Input",
  AspectRatioFixed->True],

Cell["?Multiplication", "Input",
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell["?Domain", "Input",
  AspectRatioFixed->True],

Cell["?CayleyTables", "Input",
  AspectRatioFixed->True],

Cell["?Z", "Input",
  AspectRatioFixed->True],

Cell["?Structure", "Input",
  AspectRatioFixed->True],

Cell["?Group", "Input",
  AspectRatioFixed->True],

Cell["?Ring", "Input",
  AspectRatioFixed->True],

Cell["?Random", "Input",
  AspectRatioFixed->True],

Cell["?AdditiveGroupoid", "Input",
  AspectRatioFixed->True],

Cell["?Operation", "Input",
  AspectRatioFixed->True],

Cell["?ClosedQ", "Input",
  AspectRatioFixed->True],

Cell["?AssociativeQ", "Input",
  AspectRatioFixed->True],

Cell["?RandomAssociativeQ", "Input",
  AspectRatioFixed->True],

Cell["?AbelianQ", "Input",
  AspectRatioFixed->True],

Cell["?CommutativeQ", "Input",
  AspectRatioFixed->True],

Cell["?HasIdentityQ", "Input",
  AspectRatioFixed->True],

Cell["?HasZeroQ", "Input",
  AspectRatioFixed->True],

Cell["?Zero", "Input",
  AspectRatioFixed->True],

Cell["?HasInversesQ", "Input",
  AspectRatioFixed->True],

Cell["?Inverses", "Input",
  AspectRatioFixed->True],

Cell["?NegationOf", "Input",
  AspectRatioFixed->True],

Cell["?MultiplicativeGroupoid", "Input",
  AspectRatioFixed->True],

Cell["?DistributiveQ", "Input",
  AspectRatioFixed->True],

Cell["?RandomDistributiveQ", "Input",
  AspectRatioFixed->True],

Cell["?RingQ", "Input",
  AspectRatioFixed->True],

Cell["?RingInfo", "Input",
  AspectRatioFixed->True],

Cell["?WithUnityQ", "Input",
  AspectRatioFixed->True],

Cell["?Unity", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 431},
WindowMargins->{{5, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingStartingPageNumber->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@Bbem0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:1.1"->{
    Cell[2382, 76, 225, 9, 99, "Title",
      Evaluatable->False,
      CellTags->"a:1.1"]},
  "a:1.2.1"->{
    Cell[2632, 89, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.2.1"]},
  "a:1.3.1"->{
    Cell[6999, 236, 191, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:1.3.1"]},
  "a:1.4.1"->{
    Cell[7434, 257, 183, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:1.4.1"]},
  "a:1.5.1"->{
    Cell[8576, 303, 205, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:1.5.1"]},
  "a:1.6.1"->{
    Cell[10541, 371, 196, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.6.1"]},
  "a:1.7.1"->{
    Cell[21043, 759, 197, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:1.7.1"]},
  "a:1.7.2.1"->{
    Cell[21655, 786, 120, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:1.7.2.1"]},
  "a:1.7.2.2.1"->{
    Cell[22589, 824, 123, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.7.2.2.1"]},
  "a:1.7.2.3.1"->{
    Cell[25655, 941, 128, 3, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.7.2.3.1"]},
  "a:1.7.2.4.1"->{
    Cell[28162, 1034, 128, 3, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.7.2.4.1"]},
  "a:1.7.2.5.1"->{
    Cell[30552, 1127, 180, 5, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.7.2.5.1"]},
  "a:1.7.2.6.1"->{
    Cell[33510, 1249, 117, 3, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.7.2.6.1"]},
  "a:1.7.3.1"->{
    Cell[38392, 1441, 126, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:1.7.3.1"]},
  "a:1.7.3.2.1"->{
    Cell[39340, 1482, 129, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.7.3.2.1"]},
  "a:1.7.3.3.1"->{
    Cell[40293, 1519, 134, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.7.3.3.1"]},
  "a:1.7.4.1"->{
    Cell[40730, 1539, 122, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:1.7.4.1"]},
  "a:1.7.5.1"->{
    Cell[43406, 1645, 188, 8, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:1.7.5.1"]},
  "a:1.7.6.1"->{
    Cell[46145, 1759, 181, 5, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:1.7.6.1"]},
  "a:1.7.6.2.1"->{
    Cell[46582, 1776, 115, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.7.6.2.1"]},
  "a:1.7.6.3.1"->{
    Cell[48485, 1856, 116, 3, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.7.6.3.1"]},
  "a:1.8.1"->{
    Cell[50212, 1926, 198, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:1.8.1"]},
  "a:1.9.1"->{
    Cell[55118, 2121, 256, 10, 35, "Section",
      Evaluatable->False,
      CellTags->"a:1.9.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:1.1", 58759, 2275},
  {"a:1.2.1", 58867, 2279},
  {"a:1.3.1", 58980, 2283},
  {"a:1.4.1", 59093, 2287},
  {"a:1.5.1", 59206, 2291},
  {"a:1.6.1", 59319, 2295},
  {"a:1.7.1", 59433, 2299},
  {"a:1.7.2.1", 59549, 2303},
  {"a:1.7.2.2.1", 59672, 2307},
  {"a:1.7.2.3.1", 59800, 2311},
  {"a:1.7.2.4.1", 59928, 2315},
  {"a:1.7.2.5.1", 60057, 2319},
  {"a:1.7.2.6.1", 60186, 2323},
  {"a:1.7.3.1", 60313, 2327},
  {"a:1.7.3.2.1", 60437, 2331},
  {"a:1.7.3.3.1", 60566, 2335},
  {"a:1.7.4.1", 60693, 2339},
  {"a:1.7.5.1", 60815, 2343},
  {"a:1.7.6.1", 60937, 2347},
  {"a:1.7.6.2.1", 61061, 2351},
  {"a:1.7.6.3.1", 61190, 2355},
  {"a:1.8.1", 61315, 2359},
  {"a:1.9.1", 61430, 2363}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 225, 9, 99, "Title",
  Evaluatable->False,
  CellTags->"a:1.1"],

Cell[CellGroupData[{
Cell[2632, 89, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.2.1"],
Cell[2958, 102, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3809, 126, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5179, 168, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5331, 173, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5953, 195, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6645, 221, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6999, 236, 191, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:1.3.1"],
Cell[7193, 246, 204, 6, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7434, 257, 183, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:1.4.1"],
Cell[7620, 267, 919, 31, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8576, 303, 205, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:1.5.1"],
Cell[8784, 313, 1546, 47, 147, "Text",
  Evaluatable->False],
Cell[10333, 362, 171, 4, 43, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[10541, 371, 196, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.6.1"],
Cell[10740, 381, 602, 22, 52, "Text",
  Evaluatable->False],
Cell[11345, 405, 123, 3, 27, "Input"],
Cell[11471, 410, 1318, 45, 90, "Text",
  Evaluatable->False],
Cell[12792, 457, 100, 3, 43, "Input"],
Cell[12895, 462, 160, 5, 33, "Text",
  Evaluatable->False],
Cell[13058, 469, 120, 3, 43, "Input"],
Cell[13181, 474, 349, 12, 67, "Question",
  Evaluatable->False],
Cell[13533, 488, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[13610, 492, 388, 13, 33, "Text",
  Evaluatable->False],
Cell[14001, 507, 92, 3, 43, "Input"],
Cell[14096, 512, 777, 27, 71, "Text",
  Evaluatable->False],
Cell[14876, 541, 95, 2, 27, "Input"],
Cell[14974, 545, 1421, 45, 128, "Text",
  Evaluatable->False],
Cell[16398, 592, 937, 34, 52, "Text",
  Evaluatable->False],
Cell[17338, 628, 63, 2, 27, "Input"],
Cell[17404, 632, 1536, 49, 109, "Text",
  Evaluatable->False],
Cell[18943, 683, 92, 2, 27, "Input"],
Cell[19038, 687, 808, 25, 71, "Text",
  Evaluatable->False],
Cell[19849, 714, 96, 2, 27, "Input"],
Cell[19948, 718, 1058, 36, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[21043, 759, 197, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:1.7.1"],
Cell[21243, 769, 276, 8, 52, "Text",
  Evaluatable->False],
Cell[21522, 779, 108, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[21655, 786, 120, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:1.7.2.1"],
Cell[21778, 791, 643, 22, 52, "Text",
  Evaluatable->False],
Cell[22424, 815, 54, 1, 27, "Input"],
Cell[22481, 818, 83, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[22589, 824, 123, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.7.2.2.1"],
Cell[22715, 829, 2729, 99, 128, "Text",
  Evaluatable->False],
Cell[25447, 930, 121, 3, 43, "Input"],
Cell[25571, 935, 47, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[25655, 941, 128, 3, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.7.2.3.1"],
Cell[25786, 946, 1126, 42, 52, "Text",
  Evaluatable->False],
Cell[26915, 990, 102, 2, 27, "Input"],
Cell[27020, 994, 1105, 35, 90, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[28162, 1034, 128, 3, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.7.2.4.1"],
Cell[28293, 1039, 2092, 78, 90, "Text",
  Evaluatable->False],
Cell[30388, 1119, 127, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[30552, 1127, 180, 5, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.7.2.5.1"],
Cell[30735, 1134, 508, 18, 33, "Text",
  Evaluatable->False],
Cell[31246, 1154, 159, 4, 29, "Text",
  Evaluatable->False],
Cell[31408, 1160, 204, 7, 33, "Text",
  Evaluatable->False],
Cell[31615, 1169, 102, 2, 27, "Input"],
Cell[31720, 1173, 116, 2, 33, "Text",
  Evaluatable->False],
Cell[31839, 1177, 70, 2, 27, "Input"],
Cell[31912, 1181, 362, 13, 33, "Text",
  Evaluatable->False],
Cell[32277, 1196, 66, 2, 27, "Input"],
Cell[32346, 1200, 485, 17, 67, "Question",
  Evaluatable->False],
Cell[32834, 1219, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32911, 1223, 485, 17, 67, "Question",
  Evaluatable->False],
Cell[33399, 1242, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[33510, 1249, 117, 3, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.7.2.6.1"],
Cell[33630, 1254, 1318, 48, 71, "Text",
  Evaluatable->False],
Cell[34951, 1304, 102, 2, 27, "Input"],
Cell[35056, 1308, 580, 17, 71, "Text",
  Evaluatable->False],
Cell[35639, 1327, 98, 2, 27, "Input"],
Cell[35740, 1331, 541, 20, 48, "Question",
  Evaluatable->False],
Cell[36284, 1353, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[36361, 1357, 549, 20, 33, "Text",
  Evaluatable->False],
Cell[36913, 1379, 75, 2, 27, "Input"],
Cell[36991, 1383, 1163, 43, 86, "Question",
  Evaluatable->False],
Cell[38157, 1428, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[38234, 1432, 109, 3, 43, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[38392, 1441, 126, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:1.7.3.1"],
Cell[38521, 1446, 639, 25, 33, "Text",
  Evaluatable->False],
Cell[39163, 1473, 60, 1, 27, "Input"],
Cell[39226, 1476, 89, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[39340, 1482, 129, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.7.3.2.1"],
Cell[39472, 1487, 654, 22, 52, "Text",
  Evaluatable->False],
Cell[40129, 1511, 127, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[40293, 1519, 134, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.7.3.3.1"],
Cell[40430, 1524, 140, 5, 33, "Text",
  Evaluatable->False],
Cell[40573, 1531, 108, 2, 27, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[40730, 1539, 122, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:1.7.4.1"],
Cell[40855, 1544, 662, 22, 52, "Text",
  Evaluatable->False],
Cell[41520, 1568, 276, 9, 33, "Text",
  Evaluatable->False],
Cell[41799, 1579, 924, 35, 52, "Text",
  Evaluatable->False],
Cell[42726, 1616, 75, 2, 27, "Input"],
Cell[42804, 1620, 565, 20, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[43406, 1645, 188, 8, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:1.7.5.1"],
Cell[43597, 1655, 975, 36, 52, "Text",
  Evaluatable->False],
Cell[44575, 1693, 67, 2, 27, "Input"],
Cell[44645, 1697, 763, 27, 52, "Text",
  Evaluatable->False],
Cell[45411, 1726, 70, 2, 27, "Input"],
Cell[45484, 1730, 547, 20, 48, "Question",
  Evaluatable->False],
Cell[46034, 1752, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[46145, 1759, 181, 5, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:1.7.6.1"],
Cell[46329, 1766, 228, 6, 52, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[46582, 1776, 115, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.7.6.2.1"],
Cell[46700, 1781, 461, 17, 52, "Text",
  Evaluatable->False],
Cell[47164, 1800, 157, 4, 29, "Text",
  Evaluatable->False],
Cell[47324, 1806, 211, 7, 33, "Text",
  Evaluatable->False],
Cell[47538, 1815, 72, 2, 27, "Input"],
Cell[47613, 1819, 113, 2, 33, "Text",
  Evaluatable->False],
Cell[47729, 1823, 67, 2, 27, "Input"],
Cell[47799, 1827, 572, 20, 48, "Question",
  Evaluatable->False],
Cell[48374, 1849, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[48485, 1856, 116, 3, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.7.6.3.1"],
Cell[48604, 1861, 595, 21, 52, "Text",
  Evaluatable->False],
Cell[49202, 1884, 108, 2, 27, "Input"],
Cell[49313, 1888, 208, 5, 33, "Text",
  Evaluatable->False],
Cell[49524, 1895, 550, 20, 48, "Question",
  Evaluatable->False],
Cell[50077, 1917, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[50212, 1926, 198, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:1.8.1"],
Cell[50413, 1936, 1829, 68, 107, "Question",
  Evaluatable->False],
Cell[52245, 2006, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[52322, 2010, 496, 19, 48, "Question",
  Evaluatable->False],
Cell[52821, 2031, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[52898, 2035, 1216, 43, 86, "Question",
  Evaluatable->False],
Cell[54117, 2080, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[54194, 2084, 382, 12, 67, "Question",
  Evaluatable->False],
Cell[54579, 2098, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[54656, 2102, 104, 2, 27, "Input"],
Cell[54763, 2106, 104, 2, 27, "Input"],
Cell[54870, 2110, 104, 2, 27, "Input"],
Cell[54977, 2114, 104, 2, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[55118, 2121, 256, 10, 35, "Section",
  Evaluatable->False,
  CellTags->"a:1.9.1"],
Cell[55377, 2133, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[55722, 2144, 61, 1, 27, "Input"],
Cell[55786, 2147, 55, 1, 27, "Input"],
Cell[55844, 2150, 52, 1, 27, "Input"],
Cell[55899, 2153, 58, 1, 27, "Input"],
Cell[55960, 2156, 52, 1, 27, "Input"],
Cell[56015, 2159, 50, 1, 27, "Input"],
Cell[56068, 2162, 56, 1, 27, "Input"],
Cell[56127, 2165, 45, 1, 27, "Input"],
Cell[56175, 2168, 53, 1, 27, "Input"],
Cell[56231, 2171, 49, 1, 27, "Input"],
Cell[56283, 2174, 48, 1, 27, "Input"],
Cell[56334, 2177, 50, 1, 27, "Input"],
Cell[56387, 2180, 60, 1, 27, "Input"],
Cell[56450, 2183, 53, 1, 27, "Input"],
Cell[56506, 2186, 51, 1, 27, "Input"],
Cell[56560, 2189, 56, 1, 27, "Input"],
Cell[56619, 2192, 62, 1, 27, "Input"],
Cell[56684, 2195, 52, 1, 27, "Input"],
Cell[56739, 2198, 56, 1, 27, "Input"],
Cell[56798, 2201, 56, 1, 27, "Input"],
Cell[56857, 2204, 52, 1, 27, "Input"],
Cell[56912, 2207, 48, 1, 27, "Input"],
Cell[56963, 2210, 56, 1, 27, "Input"],
Cell[57022, 2213, 52, 1, 27, "Input"],
Cell[57077, 2216, 54, 1, 27, "Input"],
Cell[57134, 2219, 66, 1, 27, "Input"],
Cell[57203, 2222, 57, 1, 27, "Input"],
Cell[57263, 2225, 63, 1, 27, "Input"],
Cell[57329, 2228, 49, 1, 27, "Input"],
Cell[57381, 2231, 52, 1, 27, "Input"],
Cell[57436, 2234, 54, 1, 27, "Input"],
Cell[57493, 2237, 49, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

