(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     35475,       1400]*)
(*NotebookOutlinePosition[     39193,       1525]*)
(*  CellTagsIndexPosition[     38646,       1503]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 2",
    FontSize->18],
  "\nIntroduction to Rings, Part 2"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.2"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.3.2"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.4.2"],

Cell["You should complete Ring Lab 1 before attempting this lab.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.5.2"],

Cell[TextData[{
  StyleBox[
  "The goals of this lab are familiarization with several important types of \
rings and awareness of how to work with rings in the context of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" packages.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Units and zero divisors"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.2"],

Cell[CellGroupData[{

Cell["2.3.1 Units of a ring", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.3.2"],

Cell["\<\
First we read in the code that provides the functionality needed \
for this lab.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "In a ring with unity (i.e., multiplicative identity), an element that has \
a multiplicative inverse in the ring is called a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["unit",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". The percentage of elements that are units in a ring can vary quite a \
bit. The unity of a ring is always a unit, and the zero of a ring is never a \
unit. If all the nonzero elements of a commutative ring with unity are units, \
the ring is called a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["field",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". (We discuss fields at length in Ring Labs 10, 11, and 13.) It is also \
possible for a ring to have no units other than the unity. We now consider \
the set of units in a variety of rings.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  "Units of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]]
}], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.3.3.2"],

Cell[TextData[{
  "Consider the ring ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  ". What do the Cayley tables tell us?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[Z[8], Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the unity of the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  "?",
  StyleBox[" What are the units of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  StyleBox["? Explain how you obtained your answers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Boolean rings", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.3.4.2"],

Cell[TextData[{
  StyleBox["A ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Boolean ring",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " consists of the set of all subsets of a given set, combined with the \
operations symmetric difference for the addition, and intersection for the \
multiplication. Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s consider an example.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(R = BooleanRing[{Curly, Moe, Larry}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This is the collection of all subsets of the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["{Curly, Moe, Larry}",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". Note the cardinality of the set.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose you replaced ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["{Curly, Moe, Larry}",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " with the names of the students in your class. (This would increase the \
average intelligence of the set by a huge factor.) How many elements would \
the new ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" have? Justify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that this ",
  StyleBox["Ringoid",
    FontFamily->"Courier"],
  " has a different approach to addition and multiplication. The following \
confirms the description."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Addition[R]\), 
    \(Multiplication[R]\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
The multiplication is simply the intersection of two subsets. The \
addition, as indicated, is the symmetric difference of two subsets. In case \
you need a quick review of the symmetric difference, consider the following \
examples.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(setA = {2, 3, 4}\), 
    \(setB = {1, 3, 4, 5}\), 
    \(setC = {3, 4}\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Addition[R]\)[setA, setB]\), 
    \(\(Addition[R]\)[setA, setC]\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
You should note that the symmetric difference of two sets returns \
the union of the two sets with the elements in the intersection removed.\
\>",
   "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Consider the Cayley tables of this ring. After the tables are \
produced, enlarge them (until you can see them more clearly) by selecting the \
graphic and then stretching from one of the corners.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[BooleanRing[{Curly, Moe, Larry}], Mode \[Rule] Visual]; 
    \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the zero of this ring? Justify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we focus on the Boolean ring of subsets of ",
  Cell[BoxData[
      \(TraditionalForm\`{1, 2}\)]],
  " and its multiplication table."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(R1 = BooleanRing[2]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(MultiplicationTable[R1, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What is the zero for this ring? Is there a unity for this ring? If so, \
what is it (and explain how you obtained it). If not, explain why not.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Determine all",
  StyleBox[" the units for this ring.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Generalize by d",
    Evaluatable->False,
    AspectRatioFixed->True],
  "etermining all",
  StyleBox[" the units for the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["BooleanRing[n]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Gaussian integers mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]]
}], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.3.5.2"],

Cell[TextData[{
  "The Gaussian integers, ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]\)]],
  ", are defined as the ring whose elements are ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{\(a + b\ i | a\), ",", 
            RowBox[{"b", 
              StyleBox["\[Element]",
                FontFamily->"Courier"], "\[DoubleStruckCapitalZ]"}]}], "}"}], 
        TraditionalForm]]],
  " and whose operations are ordinary (complex) addition and multiplication. \
Note that this is an infinite subring of the complex numbers."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Prove the last statement.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "We can consider a finite variation of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]\)]],
  " by reducing the elements modulo some positive integer. Try, for example, \
3."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(R2 = Z[3, I, Structure \[Rule] Ring]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
What can we see in the tables? (Again, enlarge the graphic so that \
it is more visible.)\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[R2, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the zero of this ring?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Is there a unity for this ring? If so, what is it (and explain how you \
obtained it). If not, explain why not.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Determine all",
  StyleBox[" the units for this ring.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Units of a ring", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.3.6.2"],

Cell[TextData[{
  StyleBox[
  "There are three basic functions related to units that can be used: ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["UnitQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Units",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplicativeInverse",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?UnitQ\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Units\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?MultiplicativeInverse\)\)], "Input",
  AspectRatioFixed->True],

Cell["You can test your answer to the last question.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Units[R2]\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Trivial ring", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.3.7.2"],

Cell[TextData[
"Consider the \[OpenCurlyDoubleQuote]trivial ring,\[CloseCurlyDoubleQuote] \
for which all products are zero."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?TrivialZR\)\)], "Input"],

Cell[BoxData[
    \(\(CayleyTables[TrivialZR[5], Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(UnitQ[TrivialZR[5], 3]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Since the \[OpenCurlyDoubleQuote]trivial ring\[CloseCurlyDoubleQuote] has no \
unity, appropriate messages are given. Observe that 3 does not have a \
multiplicative inverse."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3.2 Zero divisors of a ring", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.4.2"],

Cell[TextData[{
  StyleBox["In solving a quadratic equation such as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2 - 3  x - 10 = 0\)]],
  StyleBox[", we routinely factor the left-hand side to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((x - 5)\)\ \((x + 2)\)\)]],
  StyleBox[" and then solve ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x - 5 = 0\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x + 2 = 0\)]],
  StyleBox[
  ". We are accustomed to assuming that for a product to be zero, one of the \
factors must be zero. This is an assumption that cannot be made in the \
general theory of rings. Consider the ring of integers modulo 15, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[
  ". As can be seen from the multiplication table, there are many instances \
where products of nonzero elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[" are zero.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[Z[15], Mode \[Rule] Visual, 
      Operation \[Rule] Multiplication]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["A ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["zero divisor",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " is a nonzero ring element that can produce a product of zero on \
multiplication with another nonzero element. For example, in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[", 10 is a zero divisor because its product with 3 is zero.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Determine all",
  StyleBox[" the zero divisors for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Determine all",
  StyleBox[" the zero divisors for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_11\)]],
  StyleBox[". (If you wish, change the 15 to 11 in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["CayleyTables",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" command.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Recall the two rings with which we worked earlier.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(R1 = BooleanRing[2]\), 
    \(R2 = Z[3, I, Structure \[Rule] Ring]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Determine all",
  StyleBox[" the zero divisors of both ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["R1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["R2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3.3 Working with zero divisors", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.6.5.2"],

Cell["\<\
To work with zero divisors, we can use either of the following \
functions.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?ZeroDivisors\)\)], "Input"],

Cell[BoxData[
    \(\(?ZeroDivisorQ\)\)], "Input"],

Cell["\<\
Here is how we might test our answers to questions 11 and 12.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ZeroDivisors[Z[15]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(ZeroDivisorQ[Z[15], 8]\), 
    \(ZeroDivisorQ[Z[15], 9]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The number of zero divisors can vary substantially from one ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to another.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ZeroDivisors[Z[11]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(ZeroDivisors[TrivialZR[11]]\)], "Input",
  AspectRatioFixed->True],

Cell["You may want to check your answer to question 13.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(ZeroDivisors[R1]\), 
    \(ZeroDivisors[R2]\)}], "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Integral domains"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.7.2"],

Cell["\<\
An integral domain is a commutative ring with unity with no zero \
divisors. The ring of integers is a prototypical example. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Recall the rings used in this lab thus far. Which are integral domains \
and which are not? Come up with at least one of each.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Fields"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.8.2"],

Cell["\<\
A field is a commutative ring with unity with the property that \
every nonzero element is a unit. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Recall the rings used in this lab thus far. Which are fields and which \
are not? Come up with at least one of each.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Additional exercises"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.9.2"],

Cell[TextData[{
  StyleBox["Q16",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What are the units of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Z[20, 5]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["? What are the zero divisors? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[Z[20, 5], Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q17",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Using the functions provided thus far, find a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " that has a unity and this element is the only nonzero element that is not \
a zero divisor.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q18",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Using the functions provided thus far, find a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " that has a unity and the only nonunit is the zero. Is this ring a field?",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q19",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". True or false: In a commutative ring with unity, the intersection of \
units and zero divisors is always empty. Prove that your answer is correct.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["To test if a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is an integral domain or field, appropriate functions can be used \
(besides testing the parts of the definition).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(IntegralDomainQ[Z[7]]\), 
    \(IntegralDomainQ[BooleanRing[2]]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(FieldQ[Z[7]]\), 
    \(FieldQ[Z[15]]\), 
    \(FieldQ[Z[20, 4]]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(R = Z[30, 6]\)], "Input"],

Cell[BoxData[
    \(FieldQ[R]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["2.7 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands used in this lab"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:2.10.2"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?SwitchStructureTo", "Input",
  AspectRatioFixed->True],

Cell["?Ring", "Input",
  AspectRatioFixed->True],

Cell["?CayleyTables", "Input",
  AspectRatioFixed->True],

Cell["?Z", "Input",
  AspectRatioFixed->True],

Cell["?Mode", "Input",
  AspectRatioFixed->True],

Cell["?Visual", "Input",
  AspectRatioFixed->True],

Cell["?BooleanRing", "Input",
  AspectRatioFixed->True],

Cell["?Addition", "Input",
  AspectRatioFixed->True],

Cell["?Multiplication", "Input",
  AspectRatioFixed->True],

Cell["?MultiplicationTable", "Input",
  AspectRatioFixed->True],

Cell["?Structure", "Input",
  AspectRatioFixed->True],

Cell["?UnitQ", "Input",
  AspectRatioFixed->True],

Cell["?Units", "Input",
  AspectRatioFixed->True],

Cell["?MultiplicativeInverse", "Input",
  AspectRatioFixed->True],

Cell["?TrivialZR", "Input",
  AspectRatioFixed->True],

Cell["?Operation", "Input",
  AspectRatioFixed->True],

Cell["?ZeroDivisors", "Input",
  AspectRatioFixed->True],

Cell["?ZeroDivisorQ", "Input",
  AspectRatioFixed->True],

Cell["?IntegralDomainQ", "Input",
  AspectRatioFixed->True],

Cell["?FieldQ", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 431},
WindowMargins->{{5, Automatic}, {Automatic, 5}},
PrintingStartingPageNumber->10,
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:2.2"->{
    Cell[2382, 76, 177, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:2.2"]},
  "a:2.3.2"->{
    Cell[2584, 87, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:2.3.2"]},
  "a:2.4.2"->{
    Cell[6951, 234, 191, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:2.4.2"]},
  "a:2.5.2"->{
    Cell[7304, 251, 183, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:2.5.2"]},
  "a:2.6.2"->{
    Cell[8004, 281, 201, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:2.6.2"]},
  "a:2.6.3.2"->{
    Cell[8230, 293, 116, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:2.6.3.2"]},
  "a:2.6.3.3.2"->{
    Cell[9753, 344, 198, 7, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:2.6.3.3.2"]},
  "a:2.6.3.4.2"->{
    Cell[11015, 396, 113, 3, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:2.6.3.4.2"]},
  "a:2.6.3.5.2"->{
    Cell[17032, 632, 186, 7, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:2.6.3.5.2"]},
  "a:2.6.3.6.2"->{
    Cell[20108, 758, 115, 3, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:2.6.3.6.2"]},
  "a:2.6.3.7.2"->{
    Cell[21420, 816, 112, 3, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:2.6.3.7.2"]},
  "a:2.6.4.2"->{
    Cell[22268, 849, 124, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:2.6.4.2"]},
  "a:2.6.5.2"->{
    Cell[27024, 1027, 127, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:2.6.5.2"]},
  "a:2.7.2"->{
    Cell[28575, 1097, 194, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:2.7.2"]},
  "a:2.8.2"->{
    Cell[29458, 1135, 184, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:2.8.2"]},
  "a:2.9.2"->{
    Cell[30295, 1173, 198, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:2.9.2"]},
  "a:2.10.2"->{
    Cell[33706, 1315, 257, 10, 55, "Section",
      Evaluatable->False,
      CellTags->"a:2.10.2"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:2.2", 36611, 1431},
  {"a:2.3.2", 36719, 1435},
  {"a:2.4.2", 36832, 1439},
  {"a:2.5.2", 36945, 1443},
  {"a:2.6.2", 37058, 1447},
  {"a:2.6.3.2", 37173, 1451},
  {"a:2.6.3.3.2", 37295, 1455},
  {"a:2.6.3.4.2", 37422, 1459},
  {"a:2.6.3.5.2", 37550, 1463},
  {"a:2.6.3.6.2", 37678, 1467},
  {"a:2.6.3.7.2", 37806, 1471},
  {"a:2.6.4.2", 37932, 1475},
  {"a:2.6.5.2", 38053, 1479},
  {"a:2.7.2", 38173, 1483},
  {"a:2.8.2", 38288, 1487},
  {"a:2.9.2", 38403, 1491},
  {"a:2.10.2", 38519, 1495}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 177, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:2.2"],

Cell[CellGroupData[{
Cell[2584, 87, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:2.3.2"],
Cell[2910, 100, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3761, 124, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5131, 166, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5283, 171, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5905, 193, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6597, 219, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6951, 234, 191, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:2.4.2"],
Cell[7145, 244, 122, 2, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7304, 251, 183, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:2.5.2"],
Cell[7490, 261, 477, 15, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8004, 281, 201, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:2.6.2"],

Cell[CellGroupData[{
Cell[8230, 293, 116, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:2.6.3.2"],
Cell[8349, 298, 152, 5, 33, "Text",
  Evaluatable->False],
Cell[8504, 305, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[8678, 311, 1050, 29, 128, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9753, 344, 198, 7, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:2.6.3.3.2"],
Cell[9954, 353, 213, 7, 33, "Text",
  Evaluatable->False],
Cell[10170, 362, 104, 2, 27, "Input"],
Cell[10277, 366, 624, 21, 67, "Question",
  Evaluatable->False],
Cell[10904, 389, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[11015, 396, 113, 3, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:2.6.3.4.2"],
Cell[11131, 401, 602, 20, 71, "Text",
  Evaluatable->False],
Cell[11736, 423, 95, 2, 27, "Input"],
Cell[11834, 427, 407, 13, 52, "Text",
  Evaluatable->False],
Cell[12244, 442, 804, 27, 86, "Question",
  Evaluatable->False],
Cell[13051, 471, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[13128, 475, 250, 8, 52, "Text",
  Evaluatable->False],
Cell[13381, 485, 100, 3, 43, "Input"],
Cell[13484, 490, 305, 7, 71, "Text",
  Evaluatable->False],
Cell[13792, 499, 131, 4, 59, "Input"],
Cell[13926, 505, 126, 3, 43, "Input"],
Cell[14055, 510, 215, 6, 52, "Text",
  Evaluatable->False],
Cell[14273, 518, 268, 6, 52, "Text",
  Evaluatable->False],
Cell[14544, 526, 137, 3, 27, "Input"],
Cell[14684, 531, 293, 10, 48, "Question",
  Evaluatable->False],
Cell[14980, 543, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[15057, 547, 216, 7, 33, "Text",
  Evaluatable->False],
Cell[15276, 556, 78, 2, 27, "Input"],
Cell[15357, 560, 109, 2, 27, "Input"],
Cell[15469, 564, 388, 12, 67, "Question",
  Evaluatable->False],
Cell[15860, 578, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[15937, 582, 354, 14, 48, "Question",
  Evaluatable->False],
Cell[16294, 598, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[16371, 602, 547, 21, 48, "Question",
  Evaluatable->False],
Cell[16921, 625, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[17032, 632, 186, 7, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:2.6.3.5.2"],
Cell[17221, 641, 635, 17, 71, "Text",
  Evaluatable->False],
Cell[17859, 660, 267, 10, 48, "Question",
  Evaluatable->False],
Cell[18129, 672, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[18206, 676, 275, 8, 52, "Text",
  Evaluatable->False],
Cell[18484, 686, 95, 2, 27, "Input"],
Cell[18582, 690, 161, 5, 33, "Text",
  Evaluatable->False],
Cell[18746, 697, 102, 2, 27, "Input"],
Cell[18851, 701, 272, 10, 48, "Question",
  Evaluatable->False],
Cell[19126, 713, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[19203, 717, 356, 12, 67, "Question",
  Evaluatable->False],
Cell[19562, 731, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[19639, 735, 355, 14, 48, "Question",
  Evaluatable->False],
Cell[19997, 751, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[20108, 758, 115, 3, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:2.6.3.6.2"],
Cell[20226, 763, 741, 28, 52, "Text",
  Evaluatable->False],
Cell[20970, 793, 69, 2, 27, "Input"],
Cell[21042, 797, 69, 2, 27, "Input"],
Cell[21114, 801, 85, 2, 27, "Input"],
Cell[21202, 805, 110, 2, 33, "Text",
  Evaluatable->False],
Cell[21315, 809, 68, 2, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[21420, 816, 112, 3, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:2.6.3.7.2"],
Cell[21535, 821, 183, 4, 33, "Text",
  Evaluatable->False],
Cell[21721, 827, 47, 1, 27, "Input"],
Cell[21771, 830, 112, 2, 27, "Input"],
Cell[21886, 834, 81, 2, 27, "Input"],
Cell[21970, 838, 249, 5, 52, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[22268, 849, 124, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:2.6.4.2"],
Cell[22395, 854, 1397, 41, 128, "Text",
  Evaluatable->False],
Cell[23795, 897, 146, 3, 27, "Input"],
Cell[23944, 902, 648, 20, 71, "Text",
  Evaluatable->False],
Cell[24595, 924, 496, 19, 48, "Question",
  Evaluatable->False],
Cell[25094, 945, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[25171, 949, 723, 26, 67, "Question",
  Evaluatable->False],
Cell[25897, 977, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[25974, 981, 114, 2, 33, "Text",
  Evaluatable->False],
Cell[26091, 985, 127, 3, 43, "Input"],
Cell[26221, 990, 689, 28, 48, "Question",
  Evaluatable->False],
Cell[26913, 1020, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[27024, 1027, 127, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:2.6.5.2"],
Cell[27154, 1032, 147, 5, 33, "Text",
  Evaluatable->False],
Cell[27304, 1039, 50, 1, 27, "Input"],
Cell[27357, 1042, 50, 1, 27, "Input"],
Cell[27410, 1045, 136, 5, 33, "Text",
  Evaluatable->False],
Cell[27549, 1052, 78, 2, 27, "Input"],
Cell[27630, 1056, 116, 3, 43, "Input"],
Cell[27749, 1061, 384, 13, 33, "Text",
  Evaluatable->False],
Cell[28136, 1076, 78, 2, 27, "Input"],
Cell[28217, 1080, 86, 2, 27, "Input"],
Cell[28306, 1084, 113, 2, 33, "Text",
  Evaluatable->False],
Cell[28422, 1088, 104, 3, 43, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[28575, 1097, 194, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:2.7.2"],
Cell[28772, 1107, 197, 5, 52, "Text",
  Evaluatable->False],
Cell[28972, 1114, 372, 12, 67, "Question",
  Evaluatable->False],
Cell[29347, 1128, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[29458, 1135, 184, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:2.8.2"],
Cell[29645, 1145, 171, 5, 33, "Text",
  Evaluatable->False],
Cell[29819, 1152, 362, 12, 67, "Question",
  Evaluatable->False],
Cell[30184, 1166, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[30295, 1173, 198, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:2.9.2"],
Cell[30496, 1183, 466, 17, 48, "Question",
  Evaluatable->False],
Cell[30965, 1202, 108, 2, 27, "Input"],
Cell[31076, 1206, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[31153, 1210, 554, 19, 67, "Question",
  Evaluatable->False],
Cell[31710, 1231, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[31787, 1235, 540, 19, 67, "Question",
  Evaluatable->False],
Cell[32330, 1256, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32407, 1260, 392, 12, 67, "Question",
  Evaluatable->False],
Cell[32802, 1274, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32879, 1278, 443, 15, 52, "Text",
  Evaluatable->False],
Cell[33325, 1295, 124, 3, 43, "Input"],
Cell[33452, 1300, 124, 4, 59, "Input"],
Cell[33579, 1306, 45, 1, 27, "Input"],
Cell[33627, 1309, 42, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[33706, 1315, 257, 10, 55, "Section",
  Evaluatable->False,
  CellTags->"a:2.10.2"],
Cell[33966, 1327, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[34311, 1338, 61, 1, 27, "Input"],
Cell[34375, 1341, 48, 1, 27, "Input"],
Cell[34426, 1344, 56, 1, 27, "Input"],
Cell[34485, 1347, 45, 1, 27, "Input"],
Cell[34533, 1350, 48, 1, 27, "Input"],
Cell[34584, 1353, 50, 1, 27, "Input"],
Cell[34637, 1356, 55, 1, 27, "Input"],
Cell[34695, 1359, 52, 1, 27, "Input"],
Cell[34750, 1362, 58, 1, 27, "Input"],
Cell[34811, 1365, 63, 1, 27, "Input"],
Cell[34877, 1368, 53, 1, 27, "Input"],
Cell[34933, 1371, 49, 1, 27, "Input"],
Cell[34985, 1374, 49, 1, 27, "Input"],
Cell[35037, 1377, 65, 1, 27, "Input"],
Cell[35105, 1380, 53, 1, 27, "Input"],
Cell[35161, 1383, 53, 1, 27, "Input"],
Cell[35217, 1386, 56, 1, 27, "Input"],
Cell[35276, 1389, 56, 1, 27, "Input"],
Cell[35335, 1392, 59, 1, 27, "Input"],
Cell[35397, 1395, 50, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

