(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     33701,       1344]*)
(*NotebookOutlinePosition[     36178,       1429]*)
(*  CellTagsIndexPosition[     35878,       1415]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 3",
    FontSize->18],
  "\nAn Ideal Part of Rings"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:3.3"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["3.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  CellTags->"a:3.4.3"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["3.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  CellTags->"a:3.5.3"],

Cell["\<\
Before attempting this lab, you should have completed Ring Lab 1. \
You should also be familiar with cosets of normal subgroups.\
\>", "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["3.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  CellTags->"a:3.6.3"],

Cell[TextData[{
  "The goal of this lab is to develop the concept of an ",
  StyleBox["ideal",
    FontSlant->"Italic"],
  " through examples, leading to discovery of some of the properties of \
ideals. Quotient rings are also introduced through the examples."
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["3.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "What is the ideal part of a ring?"
}], "Section",
  Evaluatable->False,
  CellTags->"a:3.7.3"],

Cell["\<\
We begin by reading in a package that provides the functionality \
needed for the lab.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s consider a subset of the integers, \
\[DoubleStruckCapitalZ]. "], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(H = Table[i, {i, \(-40\), 40, 5}]\)], "Input"],

Cell[TextData[{
  "Since we are working on a finite machine, we can only show finite subsets \
of \[DoubleStruckCapitalZ]. Imagine, however, that ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " extends infinitely (in both directions) with the same pattern."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Once ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" is extended as stated, is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  " a ring? Is it a subring of \[DoubleStruckCapitalZ]? How do you verify \
this?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "Now consider multiplying every element in the (extended) set ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " by an element in \[DoubleStruckCapitalZ], say 3."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(M = 3\ H\)], "Input"],

Cell[TextData[{
  "Of course, this only shows a finite part. Are these products in the \
(extended) set ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "?"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(M \[Intersection] H\)], "Input"],

Cell[BoxData[
    \(H\)], "Input"],

Cell[TextData[{
  StyleBox["Certainly some of the elements are in the original subset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[". Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to enlarge ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(H = Table[i, {i, \(-150\), 150, 5}]\), 
    \(SubsetQ[M, H]\)}], "Input"],

Cell[TextData[{
  "By enlarging ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " (following the given pattern), we see that ",
  Cell[BoxData[
      \(TraditionalForm\`M = 3\ H\)]],
  " is a subset of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  StyleBox[
  " was determined by multiplying by 3 on the left of every element in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[". We then found that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  StyleBox[" was a subset of (the enlarged) ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  ". Is there anything special about 3? Could this work for other integers? \
Does the multiplication need to occur on the left? Justify your answers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Consider the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  StyleBox[" we found by multiplying ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" by 3. Actually, consider the extended ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  StyleBox[" found by multiplying the extended ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  " by 3. In other words, consider 3 \
\[LeftAngleBracket]5\[RightAngleBracket]. Is this a ring? Is this a subring \
of \[DoubleStruckCapitalZ]? Is this a subring of (the extended) ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" (i.e., \[LeftAngleBracket]5\[RightAngleBracket])?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[
"Let\[CloseCurlyQuote]s try another subset of the integers."], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(P = Table[i, {i, \(-49\), 50, 5}]\)], "Input"],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What happens if we multiply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[" on the left by 3? Call this result ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  StyleBox[" (as before). What is the intersection of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox["? Adopt the notation that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["EX",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" means the infinite, extended version of the finite ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  StyleBox[
  ". (This notation is used later as well, so take note.) What can you say \
about the intersection of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["EM",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["EP",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["? Try to prove your result.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What makes ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[" different from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox["? How do they differ in their properties?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell["Consider another subset.", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(K = Table[i, {i, \(-48\), 50, 3}]\)], "Input"],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  StyleBox[" be the result of multiplying ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox[" by some integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[". Answer the kinds of questions that were asked regarding sets ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " ",
  StyleBox["in questions 3-5.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "Hopefully, you made the observation that ",
  Cell[BoxData[
      FormBox[
        StyleBox["EP",
          FontSlant->"Italic"], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        StyleBox["EH",
          FontSlant->"Italic"], TraditionalForm]]],
  " are both cosets in the group ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "/", 
          StyleBox["EH",
            FontSlant->"Italic"]}], TraditionalForm]]],
  ", with ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["EP",
            FontSlant->"Italic"], "=", 
          \(1 + \[LeftAngleBracket]5\[RightAngleBracket]\)}], 
        TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["EH",
            FontSlant->"Italic"], "=", 
          \(\[LeftAngleBracket]5\[RightAngleBracket]\)}], TraditionalForm]]],
  ". (For the moment, think of \[DoubleStruckCapitalZ]",
  Cell[BoxData[
      FormBox[
        RowBox[{"/", 
          StyleBox["EH",
            FontSlant->"Italic"]}], TraditionalForm]]],
  " as a group, not a ring.) Let\[CloseCurlyQuote]s take a look at one more \
example."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(R = Z[12]\), 
    \(els = Elements[R]\)}], "Input"],

Cell[TextData[{
  "Now consider two subsets of the elements of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(NR = {0, 3, 6, 9}\), 
    \(H = {0, 5, 7}\)}], "Input"],

Cell[TextData[{
  "What happens if we multiply the set ",
  StyleBox["NR",
    FontSlant->"Italic"],
  " and the set ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " by an element ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  "? Suppose we use ",
  Cell[BoxData[
      \(TraditionalForm\`r = 5\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(5\ NR\), 
    \(5\ H\)}], "Input"],

Cell["\<\
Whoops! We need to remember that the multiplication really has to \
be taking place mod 12.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(Mod[5\ NR, 12]\), 
    \(Mod[5\ H, 12]\)}], "Input"],

Cell[TextData[{
  "Now repeat for all elements ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(TableForm[Map[{#, \ Mod[#\ NR, \ 12]}&, \ els], \ 
      TableDepth\  \[Rule] \ 2, \ 
      TableHeadings\  \[Rule] \ {None, \ {"\<k\>", \ "\<k*{0,3,6,9}\n\>"}}]
      \n (*\ working\ with\ NR\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(TableForm[Map[{#, \ Mod[#\ H, \ 12]}&, \ els], \ 
      TableDepth\  \[Rule] \ 2, \ 
      TableHeadings\  \[Rule] \ {None, \ {"\<k\>", \ "\<k*{0,3,6,9}\n\>"}}]
      \n (*\ working\ with\ H\ *) \)\)], "Input"],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Consider the sets ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["NR",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" and let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" be any element in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[". What can you say about the sets ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox["\[NonBreakingSpace]",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["NR",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\ H\)]],
  StyleBox["? What difference between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["NR",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" causes the results shown?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[CellGroupData[{

Cell["3.3.1 Definition of an ideal", "Subsection",
  Evaluatable->False,
  CellTags->"a:3.7.4.3"],

Cell[TextData[{
  StyleBox["Given a ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" and a subring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  StyleBox[" of the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[", we call ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  " a",
  StyleBox[" (two-sided) ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ideal",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" if for every element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" and for every element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  StyleBox[" we have both ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\ x\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\ r\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Describe the examples of ideals we have seen thus far.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3.2 Another ring", "Subsection",
  Evaluatable->False,
  CellTags->"a:3.7.5.3"],

Cell[TextData[{
  "Consider the ring of two-by-two matrices with entries from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  ". "
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(M = Mat[Z[2], {2, 2}]\)], "Input"],

Cell["You can count the elements; there are 16.", "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(Elements[M]\), 
    \(Length[Elements[M]]\)}], "Input"],

Cell[TextData[{
  "As defined, although ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  " is a ring, it is not a ",
  StyleBox["Ringoid",
    FontFamily->"Courier"],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Let\[CloseCurlyQuote]s make it one."
}], "Text"],

Cell[BoxData[
    \(R\  = \ ToRingoid[Mat[Z[2], \ 2]]\)], "Input"],

Cell[TextData[{
  "Consider two subsets of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(Map[MatrixForm, 
      H = {{{1, 0}, {0, 1}}, {{0, 0}, {0, 0}}, {{1, 0}, {0, 0}}, {{0, 0}, {0, 
              1}}}]\n\), 
    \(Map[MatrixForm, 
      K = {{{1, 0}, {0, 1}}, {{0, 0}, {0, 0}}, {{1, 0}, {0, 0}}, {{0, 0}, {0, 
              1}}, {{0, 0}, {1, 0}}, {{1, 0}, {1, 0}}, {{0, 0}, {1, 1}}, {{1, 
              0}, {1, 1}}}]\)}], "Input"],

Cell[TextData[{
  StyleBox[
  "You can verify by hand, or check the following, that these are indeed \
subrings of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(SubringQ[H, R]\ \)\)], "Input"],

Cell[BoxData[
    \(\(SubringQ[K, R]\ \)\)], "Input"],

Cell[TextData[{
  "Are ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " ideals? We need to pick an element in ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " and multiply it by an element in ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " (or ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  ") and see if we land back in ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " (or ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  "). For example, let ",
  Cell[BoxData[
      \(TraditionalForm\`M\_1\)]],
  " be the following matrix in ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(Clear[M]\), 
    \(\((M\_1 = {{1, 1}, {0, 0}})\) // MatrixForm\)}], "Input"],

Cell["What happens if we try multiplying as we did earlier?", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(M\_1\ H\)], "Input"],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". This is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" question, not an algebraic one",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[LongDash]",
  StyleBox["answer it if you can. What went wrong?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "Recall that the multiplication of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " can be obtained as follows."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(\(op = Multiplication[R]; \)\  (*\ no\ output\ is\ given\ *) \)\)], 
  "Input"],

Cell[TextData[{
  StyleBox["We can ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Map",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" the operation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["op",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`M\_1\)]],
  StyleBox[" as one of the operands, across the whole set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Map[MatrixForm, \ Map[op[M\_1, #1]&, \ H]]\)], "Input"],

Cell[TextData[{
  "Is it true that ",
  Cell[BoxData[
      \(TraditionalForm\`M\_1*N\_1\)]],
  " is in ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " for every element ",
  Cell[BoxData[
      \(TraditionalForm\`N\_1\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "? If not, what does this say about ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " being an ideal? If so, what does this say about ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " being an ideal?"
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" an ideal? What about ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "Note that both ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  " are normal subgroups of the additive group of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell["\<\
NormalQ[H, AdditiveGroupoid[R]]
NormalQ[K, AdditiveGroupoid[R]] (* may take some time *)\
\>", "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["3.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Ideals factor into other ring properties"
}], "Section",
  Evaluatable->False,
  CellTags->"a:3.8.3"],

Cell[TextData[{
  "Consider the following ring ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " and subset ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(R = Z[15]\), 
    \(B = {0, 3, 6, 9, 12}\)}], "Input"],

Cell[TextData[{
  "Observe that ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " is an ideal of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(IdealQ[B, R]\)], "Input"],

Cell[TextData[{
  "We know that ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " is a normal subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " when we view ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " as an additive group. Therefore, the quotient group ",
  Cell[BoxData[
      \(TraditionalForm\`R/B\)]],
  " makes sense and we can talk about the cosets as elements. Each coset has \
the form ",
  Cell[BoxData[
      \(TraditionalForm\`x + B\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is an element of ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  ". We already know how to add cosets: ",
  Cell[BoxData[
      \(TraditionalForm\`\((x + B)\) + \((y + B)\) = x + y + B\)]],
  ". Can we form a product with these cosets? How about multiplying ",
  Cell[BoxData[
      \(TraditionalForm\`x + B\)]],
  " times ",
  Cell[BoxData[
      \(TraditionalForm\`y + B\)]],
  " to yield ",
  Cell[BoxData[
      \(TraditionalForm\`x  y + B\)]],
  "? We need to verify that this is a valid, well-defined operation, which we \
leave to your text and/or classroom. With this, we can form the ",
  StyleBox["quotient ring",
    FontSlant->"Italic"],
  " (also known as the ",
  StyleBox["factor ring",
    FontSlant->"Italic"],
  ") ",
  Cell[BoxData[
      \(TraditionalForm\`R/B\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(QR = QuotientRing[R, B]\)], "Input"],

Cell["Here is an example of how the multiplication works.", "Text"],

Cell[BoxData[
    \(\(Multiplication[QR]\)[2 + NS, 2 + NS]\)], "Input"],

Cell["Consider the Cayley tables of this quotient ring.", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(CayleyTables[QR, Mode \[Rule] Visual]\)], "Input"],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". To what ring is this quotient ring isomorphic?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["3.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  CellTags->"a:3.9.3"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Table", "Input"],

Cell["?Intersection", "Input"],

Cell["?SubsetQ", "Input"],

Cell["?Union", "Input"],

Cell["?Elements", "Input"],

Cell["?Mod", "Input"],

Cell["?Z", "Input"],

Cell["?Mat", "Input"],

Cell["?Length", "Input"],

Cell["?FormGroupoid", "Input"],

Cell["?FormRingoid", "Input"],

Cell["?SubringQ", "Input"],

Cell["?Multiplication", "Input"],

Cell["?Map", "Input"],

Cell["?NormalQ", "Input"],

Cell["?IdealQ", "Input"],

Cell["?QuotientRing", "Input"],

Cell["?CayleyTables", "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 431},
WindowMargins->{{5, Automatic}, {Automatic, 5}},
PrintingStartingPageNumber->10,
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:3.3"->{
    Cell[2382, 76, 170, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:3.3"]},
  "a:3.4.3"->{
    Cell[2577, 87, 297, 10, 55, "Section",
      Evaluatable->False,
      CellTags->"a:3.4.3"]},
  "a:3.5.3"->{
    Cell[6918, 233, 165, 7, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.5.3"]},
  "a:3.6.3"->{
    Cell[7297, 251, 157, 7, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.6.3"]},
  "a:3.7.3"->{
    Cell[7788, 272, 185, 7, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.7.3"]},
  "a:3.7.4.3"->{
    Cell[21364, 808, 97, 2, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:3.7.4.3"]},
  "a:3.7.5.3"->{
    Cell[23658, 904, 87, 2, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:3.7.5.3"]},
  "a:3.8.3"->{
    Cell[29651, 1162, 192, 7, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.8.3"]},
  "a:3.9.3"->{
    Cell[32471, 1280, 344, 13, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.9.3"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:3.3", 34837, 1375},
  {"a:3.4.3", 34945, 1379},
  {"a:3.5.3", 35058, 1383},
  {"a:3.6.3", 35171, 1387},
  {"a:3.7.3", 35284, 1391},
  {"a:3.7.4.3", 35399, 1395},
  {"a:3.7.5.3", 35519, 1399},
  {"a:3.8.3", 35637, 1403},
  {"a:3.9.3", 35752, 1407}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 170, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:3.3"],

Cell[CellGroupData[{
Cell[2577, 87, 297, 10, 55, "Section",
  Evaluatable->False,
  CellTags->"a:3.4.3"],
Cell[2877, 99, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3728, 123, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5098, 165, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5250, 170, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5872, 192, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6564, 218, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6918, 233, 165, 7, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.5.3"],
Cell[7086, 242, 174, 4, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7297, 251, 157, 7, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.6.3"],
Cell[7457, 260, 294, 7, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7788, 272, 185, 7, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.7.3"],
Cell[7976, 281, 132, 4, 33, "Text",
  Evaluatable->False],
Cell[8111, 287, 145, 3, 43, "Input",
  InitializationCell->True],
Cell[8259, 292, 134, 3, 33, "Text",
  Evaluatable->False],
Cell[8396, 297, 66, 1, 27, "Input"],
Cell[8465, 300, 298, 7, 52, "Text",
  Evaluatable->False],
Cell[8766, 309, 561, 21, 48, "Question",
  Evaluatable->False],
Cell[9330, 332, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[9381, 335, 218, 6, 33, "Text",
  Evaluatable->False],
Cell[9602, 343, 41, 1, 27, "Input"],
Cell[9646, 346, 194, 7, 33, "Text",
  Evaluatable->False],
Cell[9843, 355, 52, 1, 27, "Input"],
Cell[9898, 358, 34, 1, 27, "Input"],
Cell[9935, 361, 694, 26, 33, "Text",
  Evaluatable->False],
Cell[10632, 389, 94, 2, 43, "Input"],
Cell[10729, 393, 297, 12, 33, "Text",
  Evaluatable->False],
Cell[11029, 407, 954, 32, 86, "Question",
  Evaluatable->False],
Cell[11986, 441, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[12037, 444, 1139, 37, 86, "Question",
  Evaluatable->False],
Cell[13179, 483, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[13230, 486, 107, 2, 33, "Text",
  Evaluatable->False],
Cell[13340, 490, 66, 1, 27, "Input"],
Cell[13409, 493, 1642, 57, 105, "Question",
  Evaluatable->False],
Cell[15054, 552, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[15105, 555, 516, 19, 48, "Question",
  Evaluatable->False],
Cell[15624, 576, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[15675, 579, 62, 1, 33, "Text",
  Evaluatable->False],
Cell[15740, 582, 66, 1, 27, "Input"],
Cell[15809, 585, 939, 35, 67, "Question",
  Evaluatable->False],
Cell[16751, 622, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[16802, 625, 1214, 41, 71, "Text",
  Evaluatable->False],
Cell[18019, 668, 72, 2, 43, "Input"],
Cell[18094, 672, 153, 6, 33, "Text",
  Evaluatable->False],
Cell[18250, 680, 76, 2, 43, "Input"],
Cell[18329, 684, 409, 18, 33, "Text",
  Evaluatable->False],
Cell[18741, 704, 55, 2, 43, "Input"],
Cell[18799, 708, 137, 4, 33, "Text",
  Evaluatable->False],
Cell[18939, 714, 73, 2, 43, "Input"],
Cell[19015, 718, 195, 9, 33, "Text",
  Evaluatable->False],
Cell[19213, 729, 234, 4, 59, "Input"],
Cell[19450, 735, 232, 4, 59, "Input"],
Cell[19685, 741, 1603, 60, 67, "Question",
  Evaluatable->False],
Cell[21291, 803, 48, 1, 47, "Answer",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21364, 808, 97, 2, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:3.7.4.3"],
Cell[21464, 812, 1833, 73, 52, "Text",
  Evaluatable->False],
Cell[23300, 887, 270, 9, 48, "Question",
  Evaluatable->False],
Cell[23573, 898, 48, 1, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[23658, 904, 87, 2, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:3.7.5.3"],
Cell[23748, 908, 194, 6, 33, "Text",
  Evaluatable->False],
Cell[23945, 916, 54, 1, 27, "Input"],
Cell[24002, 919, 79, 1, 33, "Text",
  Evaluatable->False],
Cell[24084, 922, 76, 2, 43, "Input"],
Cell[24163, 926, 286, 11, 33, "Text"],
Cell[24452, 939, 66, 1, 27, "Input"],
Cell[24521, 942, 133, 6, 33, "Text",
  Evaluatable->False],
Cell[24657, 950, 365, 7, 107, "Input"],
Cell[25025, 959, 320, 12, 33, "Text",
  Evaluatable->False],
Cell[25348, 973, 53, 1, 27, "Input"],
Cell[25404, 976, 53, 1, 27, "Input"],
Cell[25460, 979, 713, 30, 52, "Text",
  Evaluatable->False],
Cell[26176, 1011, 97, 2, 43, "Input"],
Cell[26276, 1015, 91, 1, 33, "Text",
  Evaluatable->False],
Cell[26370, 1018, 40, 1, 27, "Input"],
Cell[26413, 1021, 552, 20, 67, "Question",
  Evaluatable->False],
Cell[26968, 1043, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[27019, 1046, 170, 6, 33, "Text",
  Evaluatable->False],
Cell[27192, 1054, 101, 2, 27, "Input"],
Cell[27296, 1058, 758, 29, 33, "Text",
  Evaluatable->False],
Cell[28057, 1089, 75, 1, 27, "Input"],
Cell[28135, 1092, 535, 21, 52, "Text",
  Evaluatable->False],
Cell[28673, 1115, 475, 19, 48, "Question",
  Evaluatable->False],
Cell[29151, 1136, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[29202, 1139, 284, 12, 33, "Text",
  Evaluatable->False],
Cell[29489, 1153, 113, 3, 42, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[29651, 1162, 192, 7, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.8.3"],
Cell[29846, 1171, 203, 9, 33, "Text",
  Evaluatable->False],
Cell[30052, 1182, 75, 2, 43, "Input"],
Cell[30130, 1186, 192, 9, 33, "Text",
  Evaluatable->False],
Cell[30325, 1197, 45, 1, 27, "Input"],
Cell[30373, 1200, 1378, 47, 147, "Text",
  Evaluatable->False],
Cell[31754, 1249, 56, 1, 27, "Input"],
Cell[31813, 1252, 67, 0, 33, "Text"],
Cell[31883, 1254, 71, 1, 27, "Input"],
Cell[31957, 1257, 87, 1, 33, "Text",
  Evaluatable->False],
Cell[32047, 1260, 70, 1, 27, "Input"],
Cell[32120, 1263, 263, 9, 48, "Question",
  Evaluatable->False],
Cell[32386, 1274, 48, 1, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[32471, 1280, 344, 13, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.9.3"],
Cell[32818, 1295, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[33163, 1306, 23, 0, 27, "Input"],
Cell[33189, 1308, 30, 0, 27, "Input"],
Cell[33222, 1310, 25, 0, 27, "Input"],
Cell[33250, 1312, 23, 0, 27, "Input"],
Cell[33276, 1314, 26, 0, 27, "Input"],
Cell[33305, 1316, 21, 0, 27, "Input"],
Cell[33329, 1318, 19, 0, 27, "Input"],
Cell[33351, 1320, 21, 0, 27, "Input"],
Cell[33375, 1322, 24, 0, 27, "Input"],
Cell[33402, 1324, 30, 0, 27, "Input"],
Cell[33435, 1326, 29, 0, 27, "Input"],
Cell[33467, 1328, 26, 0, 27, "Input"],
Cell[33496, 1330, 32, 0, 27, "Input"],
Cell[33531, 1332, 21, 0, 27, "Input"],
Cell[33555, 1334, 25, 0, 27, "Input"],
Cell[33583, 1336, 24, 0, 27, "Input"],
Cell[33610, 1338, 30, 0, 27, "Input"],
Cell[33643, 1340, 30, 0, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

