(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     43070,       1546]*)
(*NotebookOutlinePosition[     45448,       1628]*)
(*  CellTagsIndexPosition[     45177,       1615]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 4",
    FontSize->18],
  "\nWhat Does ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ][i]/
        \[LeftAngleBracket]a\  + \ b\ i\[RightAngleBracket]\)]],
  " Look Like?"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.4"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["4.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.5.4"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["4.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.6.4"],

Cell[TextData[{
  StyleBox[
  "Prior to working on this lab, you should be familiar with the term ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ideal",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " through discussions in class or from Ring Lab 3. You should also be \
familiar with an integral domain, a field, and the characteristic of a ring.",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["4.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.7.4"],

Cell["\<\
The goal of this lab is to explore the quotient structure of the \
Gaussian integers modulo an ideal generated by an arbitrary Gaussian integer.\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["4.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Example 1"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.8.4"],

Cell["To work on this lab, we load the necessary packages.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  "Consider the problem of investigating the ideal ",
  Cell[BoxData[
      \(TraditionalForm
      \`J = \[LeftAngleBracket]2 + 2\ i\[RightAngleBracket]\)]],
  " in the Gaussian integers, ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]\)]],
  ". In particular, what does the quotient ring ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ][i]/
        \[LeftAngleBracket]2 + 2\ i\[RightAngleBracket]\)]],
  " look like? First recall that the set of Gaussian integers is the set ",
  Cell[BoxData[
      \(TraditionalForm
      \`{a + b\ i | a, b \[Element] \[DoubleStruckCapitalZ]}\)]],
  ". This forms a lattice in the plane."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(gr = 
      IntegerLatticeGrid[{\(-6\), 6}, {\(-6\), 6}, 
        AspectRatio \[Rule] Automatic]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now consider the ideal generated by ",
  Cell[BoxData[
      \(TraditionalForm\`z = 2 + 2\ i\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(z = 2 + 2\ I\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "What elements are in this ideal? We know, by definition, that all elements \
of the form ",
  Cell[BoxData[
      \(TraditionalForm\`r\ z\)]],
  " (where ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " is in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]\)]],
  ") are in this ideal. Suppose we consider ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " to be an (ordinary) integer and multiply it by ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ". We might as well try a number of integers at a time."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(someMultipliers = Table[k, {k, \(-3\), 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(idealList = someMultipliers\ *z\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s plot them on the lattice. To use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ListPlot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", we need to convert the complex numbers to ordered pairs.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(plotOfIdeals = 
      ListPlot[Map[ComplexToPoint, idealList], 
        PlotStyle \[Rule] {PointSize[0.030], RGBColor[1, 0, 0]}, 
        DisplayFunction \[Rule] Identity]; \n\(Show[{gr, plotOfIdeals}]; 
    \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "What other multiples should we consider? We could multiply by multiples of \
",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(addToIdealList = Table[k\ I, {k, \(-3\), 3}]\ z\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(idealList = Join[idealList, addToIdealList]\)], "Input",
  AspectRatioFixed->True],

Cell["Now look at the set of multiples we have so far.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(plotOfIdeals = 
      ListPlot[Map[ComplexToPoint, idealList], 
        PlotStyle \[Rule] {PointSize[0.030], RGBColor[1, 0, 0]}, 
        AspectRatio \[Rule] Automatic, DisplayFunction \[Rule] Identity]; \n
    \(Show[{gr, plotOfIdeals}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "To make sense of this picture, recall that multiplying a complex number by \
",
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  " has the effect of increasing the argument of the complex number (the \
angle between it and the positive ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "-axis) by 90\[Degree]. This explains why the original diagonal is rotated \
to give us the preceding pattern."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "There are still quite a few elements in the ideal that reside in this \
rectangle that are not being shown. Perhaps we should multiply all the \
complex numbers in this grid by ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " and then plot all the products that are still within the grid."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(g = 6; \n
    pts = Flatten[Table[{i, j}, {i, \(-g\), g}, {j, \(-g\), g}], 1]; \n
    cpts = Map[Apply[Complex, #]&, pts]; 
    idealList = Intersection[cpts, z*cpts]\)], "Input",
  AspectRatioFixed->True],

Cell["Here is the new plot.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(plotOfIdeals = 
      ListPlot[Map[ComplexToPoint, idealList], 
        PlotStyle \[Rule] {PointSize[0.030], RGBColor[1, 0, 0]}, 
        AspectRatio \[Rule] Automatic, DisplayFunction \[Rule] Identity]; \n
    \(Show[{gr, plotOfIdeals}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". We now see all the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`J = \[LeftAngleBracket]2 + 2\ i\[RightAngleBracket]\)]],
  StyleBox[
  " that are within the window shown. How many elements are there in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]/J\)]],
  StyleBox[
  "? In other words, how many other cosets do you think there are (and then \
add 1 to account for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  StyleBox[")? Note that in the code, the variable ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["pts",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" records the lattice points and the variable ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["idealList",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" records the members of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  StyleBox[
  ", so perhaps they may be useful in helping to answer this question. What \
do you think is the size of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]/J\)]],
  StyleBox["? Why?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s refer to the list of points in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["idealList",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " by a different variable so that we can more efficiently do the \
bookkeeping as we try finding the other cosets. Suppose we use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["J[0]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[J]\), 
    \(J[0] = idealList\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now we need to find the other cosets. We will be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["adding",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " elements to the ideal, as opposed to multiplying, to generate the other \
cosets. Since we have defined ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  StyleBox[" to be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["J[0]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and we know all cosets are of the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r + J\)]],
  StyleBox[
  ", finding another coset is not too difficult. We just need to pick another \
ring element and add it to the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["J[0]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". Which ring element should we add? \nSince we clearly want to pick one \
that is not already in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`J\)]],
  StyleBox[", we may need to look at our picture again.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Show[{gr, plotOfIdeals}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["How about using 1?", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(J[1]\  = \ 1\  + \ J[0]\ 
    \n (*\ This\ conveniently\ adds\ 1\ to\ every\ element\ in\ 
        J[0] . \ This\ works\ well\ since\ we\ are\ dealing\ with\ complex\ 
        numbers . \ Equivalently, \ 
      one\ could\ use\ J[1]\  = \ \(Map[\((#\  + \ 1)\)&, \ J[0]] . \)\ *) 
      \)\)], "Input"],

Cell[TextData[{
  StyleBox["This returns all the elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["J[0]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " with 1 added to them. In other words, we are building (part of) another \
coset. Here is a graph showing what we have so far.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(cosetPlot[2] = 
      ListPlot[ComplexToPoint/@J[1], 
        PlotStyle \[Rule] {PointSize[0.030], Hue[1\/9]}, 
        AspectRatio \[Rule] Automatic, DisplayFunction \[Rule] Identity]; 
    \)\), 
    \(\(Show[{gr, plotOfIdeals, cosetPlot[2]}]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". How does this graph reflect that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["J[1] = 1 + J[0]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  " Do you want to modify your guess regarding how many cosets there will be? \
What is your current response?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s pick another element to help find another coset. Additionally, let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s begin to automate our process by using the variable ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["index",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " to keep track of the count of the cosets. Suppose we choose 2 for our new \
element.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(newElement\  = \ 2\ \ \), 
    \(index\  = \ 2\ \t\t\), 
    \(J[index]\  = \ newElement\  + \ J[0]\n (*\ 
      now\ calculate\ the\ new\ J[index]\ by\ adding\ newElement\ *) \)}], 
  "Input"],

Cell[TextData[{
  StyleBox["We have now calculated our third coset, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["J[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". (Recall that the first was ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["J[0]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and the second was ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["J[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".) Now let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s show a graph of the current situation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(cosetPlot[index + 1] = 
      ListPlot[ComplexToPoint/@J[index], 
        PlotStyle \[Rule] {PointSize[0.030], Hue[index\/9]}, 
        AspectRatio \[Rule] Automatic, DisplayFunction \[Rule] Identity]; 
    \)\), 
    \(\(Show[
      Join[{gr, plotOfIdeals}, Table[cosetPlot[k + 1], {k, 1, index}]]]; 
    \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  " Do you want to modify your guess regarding how many cosets there will be? \
What is your current response?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" By choosing a value for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["newElement",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", step through the following code until you have found all the cosets. A \
suggestion for choosing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["newElement",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ": Pick an uncolored point that is \[OpenCurlyDoubleQuote]closest\
\[CloseCurlyDoubleQuote] to the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[
  "-axis (where you measure the distance by the absolute value of the angle \
from the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox["-axis to the point) but also within a circle of radius ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(| 2 + 2\ i | \) = 2\ \@2\)]],
  StyleBox[". Keep track of your elements.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(newElement = \ \n\nindex += 1\ \), 
    \(J[index] = newElement + J[0]\), 
    \(cosetPlot[index + 1] = 
      ListPlot[ComplexToPoint/@J[index], 
        PlotStyle \[Rule] {PointSize[0.030], Hue[index\/9]}, 
        AspectRatio \[Rule] Automatic, DisplayFunction \[Rule] Identity]; \n
    Show[Join[{gr, plotOfIdeals}, Table[cosetPlot[k + 1], {k, 1, index}]]]; 
    \)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" How many cosets are there? List them.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["4.3.1 What ring is it?", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.8.5.4"],

Cell[TextData[{
  "Now that we have found the cosets, let\[CloseCurlyQuote]s explore what \
ring this quotient ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ][i]/
        \[LeftAngleBracket]2 + 2\ i\[RightAngleBracket]\)]],
  " might be. Since each coset can have one of many different names (or \
representatives, in the sense that ",
  Cell[BoxData[
      \(TraditionalForm\`2 + \[LeftAngleBracket]5\[RightAngleBracket]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`7 + \[LeftAngleBracket]5\[RightAngleBracket]\)]],
  " are the same cosets in ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]/\[LeftAngleBracket]5\[RightAngleBracket]\)]],
  " but use different representatives), we should first agree on what names \
to use so that we can use the same language. (Technically, this is not \
necessary, but it is convenient.) Therefore, here is one choice."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(cosetReps = {0, 1, 2, 2 - I, 2 + I, 1 - I, 1 + I, 1 - 2\ I}\n\), 
    \(cosetRepsPlot = 
      ListPlot[ComplexToPoint/@cosetReps, 
        PlotStyle \[Rule] {PointSize[0.030], Hue[0]}, 
        AspectRatio \[Rule] Automatic, DisplayFunction \[Rule] Identity]; \n
    Show[{gr, cosetRepsPlot, Graphics[Circle[{0, 0}, Abs[2 + 2\ I]]]}]; \)}], 
  "Input",
  AspectRatioFixed->True],

Cell["\<\
Here is another choice, with a different visualization. We use this \
choice in further analysis of the quotient ring.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(QuotientRing[Z[I], 2 + 2\ I, Mode \[Rule] Visual, 
      Form \[Rule] Representatives]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The representatives are the elements listed in this ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". Additionally, these elements can be found within and on the bold square. \
In general, the corners of the square are different representatives of the \
same coset. Also, any element that appears on a side of a square has a second \
representative of the same coset on the opposite side of the square.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "There are more Gaussian integers within or on this bold square than there \
are coset representations in this quotient ring. Which ones are not included \
in the quotient ring? How are these \[OpenCurlyDoubleQuote]extras\
\[CloseCurlyDoubleQuote] related to those in the quotient ring?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "Give an explanation for the role the collection of squares is playing. In \
particular, address how the other squares relate to the bold one.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Since we have found all the cosets, we should consider how to add and \
multiply them. We know that if we add the cosets ",
  Cell[BoxData[
      \(TraditionalForm\`\(4 + 5\ i + J\ \)\)]],
  "and ",
  Cell[BoxData[
      \(TraditionalForm\`8 + 9\ i + J\)]],
  ", we get ",
  Cell[BoxData[
      \(TraditionalForm\`12 + 14\ i + J\)]],
  ". Similarly, the product is ",
  Cell[BoxData[
      \(TraditionalForm\`\(-13\) + 76\ i + J\)]],
  ". (Double-check each of these calculations.) We would, however, like to \
have them represented by elements of the form ",
  Cell[BoxData[
      \(TraditionalForm\`z + J\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " is a representative in our quotient ring. First, let\[CloseCurlyQuote]s \
look at another version of the quotient ring, where the elements are given in \
the form ",
  Cell[BoxData[
      \(TraditionalForm\`z + J\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(QR = QuotientRing[Z[I], 2 + 2\ I]\)], "Input",
  AspectRatioFixed->True],

Cell["Now we can look at the sum and product.", "Text"],

Cell[BoxData[{
    \(\(Addition[QR]\)[4 + 5\ I + J, 8 + 9\ I + J]\), 
    \(\(Multiplication[QR]\)[4 + 5\ I + J, 8 + 9\ I + J]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["From these computations, we see that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((4 + 5\ i + J)\) + \((8 + 9\ i + J)\) = 2 + J\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((4 + 5\ i + J)\)*\((8 + 9\ i + J)\) = 3 + J\)]],
  StyleBox[
  ". Why is this the case? Look again at the plot given in the visualization \
of the quotient ring.\n\n\ta. First, find the representatives in the bold \
square for both ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`4 + 5\ i + J\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`8 + 9\ i + J\)]],
  StyleBox[
  ". (The second one may take a little ingenuity with this graph, but you can \
do it.) \n\n\tb. Now add and multiply (by hand) the two representatives. What \
are these results (before reducing mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]2 + 2\ i\[RightAngleBracket]\)]],
  StyleBox[")?\n\n\tc. Finally, reduce the preceding results mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]2 + 2\ i\[RightAngleBracket]\)]],
  StyleBox[
  " so that you can find the corresponding representative in the bold square. \
Are you convinced of these results?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
By looking at the Cayley table, we should be able to answer some \
questions regarding this ring. (You may wish to enlarge the graphics so you \
can view them better.)\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTables[QR, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["QR",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" a field? Why or why not? Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`J = \[LeftAngleBracket]2 + 2\ i\[RightAngleBracket]\)]],
  StyleBox[" a maximal ideal? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["QR",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" an integral domain? Why or why not? Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`J = \[LeftAngleBracket]2 + 2\ i\[RightAngleBracket]\)]],
  StyleBox[" a prime ideal? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["What is the characteristic of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["QR",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "Since the additive group of this ring has order eight, what are the \
candidates for a group that is isomorphic to this? In other words, what are \
the groups of order eight?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q14. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "Which one is this? What group is isomorphic to the additive group of this \
ring?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["4.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Example 2"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.9.4"],

Cell[TextData[{
  "Suppose we now let ",
  Cell[BoxData[
      \(TraditionalForm
      \`J = \[LeftAngleBracket]3 + i\[RightAngleBracket]\)]],
  " and consider the quotient ring ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]/J\)]],
  ". As before, let\[CloseCurlyQuote]s view this visually."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(QuotientRing[Z[I], 3 + I, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Try the following to see how this graphic image is built up in \
stages. (Note: The following cell uses a lot of memory; you may wish to \
delete previous graphics cells first.)\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(QuotientRing[Z[I], 3 + I, Mode \[Rule] Visual, Staged \[Rule] All]; 
    \)\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
You can now double-click on any one of the cells and animate the \
graphics. The speed can be controlled by typing a number from 1 to 9 (1 slow, \
9 fast). If you want to see just one stage at a time, the following is an \
alternative. (If you have limited memory, you may wish to first clear the \
graphics just generated.)\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(QuotientRing[Z[I], 3 + I, Mode \[Rule] Visual, Staged \[Rule] True]; 
    \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NextStage",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to advance (or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PreviousStage",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", if you wish to reverse).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(NextStage[QuotientRing]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["How many cosets are there?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q16. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "What can you say about this quotient ring? What is the size? Is it a \
field? Is it an integral domain?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The following are some Gaussian integers. You may recall that the absolute \
value of a complex number ",
  Cell[BoxData[
      \(TraditionalForm\`a + b\ i\)]],
  " is the length of the vector starting at the origin and terminating at the \
point ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  ", having the value ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(a\^2 + b\^2\)\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(someTestCases = {2 + I, 2, 3 + I, 3 + 2\ I, 2\ I, 4 - 3\ I, 7 - I}\)], 
  "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      \(({#1, Abs[#1], 
              Size[QuotientRing[Z[I], #1, Form \[Rule] Representatives]]}&)
          \)/@someTestCases, 
      TableHeadings 
        \[Rule] {
          None, {"\<z\>", "\<|z|\>", 
            "\<|\[DoubleStruckCapitalZ][i]/<z>|\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The output consists of a complex number ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", the absolute value of ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", followed by the size of the quotient ring formed by",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ][i]/
        \[LeftAngleBracket]z\[RightAngleBracket]\)]],
  " (",
  "i.e.",
  ", the number of cosets)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q17. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["Can you make a conjecture regarding the sizes measured?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q18. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["Try to prove your conjecture.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q19. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  "Which of the quotient rings above do you think are fields? Integral \
domains? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["You may be interested in trying the following.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[{#, \ PrimeQ[#, \ GaussianIntegers\  \[Rule] \ True]}&, \ 
      someTestCases]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(Map[
      QuotientRing[Z[I], #1, Form \[Rule] Representatives, 
          Mode \[Rule] Visual]&, someTestCases]; 
    \)\n (*\ This\ will\ likely\ take\ some\ time\ \[LongDash]\ good\ 
        opportunity\ for\ a\ break\ *) \)\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["4.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:4.10.4"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?IntegerLatticeGrid", "Input",
  AspectRatioFixed->True],

Cell["?ListPlot", "Input",
  AspectRatioFixed->True],

Cell["?Map", "Input",
  AspectRatioFixed->True],

Cell["?ComplexToPoint", "Input",
  AspectRatioFixed->True],

Cell["?Show", "Input",
  AspectRatioFixed->True],

Cell["?Table", "Input",
  AspectRatioFixed->True],

Cell["?QuotientRing", "Input",
  AspectRatioFixed->True],

Cell["?Form", "Input",
  AspectRatioFixed->True],

Cell["?Representatives", "Input",
  AspectRatioFixed->True],

Cell["?Cosets", "Input",
  AspectRatioFixed->True],

Cell["?Addition", "Input",
  AspectRatioFixed->True],

Cell["?Multiplication", "Input",
  AspectRatioFixed->True],

Cell["?CayleyTables", "Input",
  AspectRatioFixed->True],

Cell["?Staged", "Input",
  AspectRatioFixed->True],

Cell["?PrimeQ", "Input",
  AspectRatioFixed->True],

Cell["?GaussianIntegers", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 435},
WindowMargins->{{5, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->19,
PrintingPageRange->{1, 8},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:4.4"->{
    Cell[2382, 76, 316, 12, 99, "Title",
      Evaluatable->False,
      CellTags->"a:4.4"]},
  "a:4.5.4"->{
    Cell[2723, 92, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:4.5.4"]},
  "a:4.6.4"->{
    Cell[7246, 245, 191, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:4.6.4"]},
  "a:4.7.4"->{
    Cell[8010, 277, 183, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:4.7.4"]},
  "a:4.8.4"->{
    Cell[8451, 298, 187, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:4.8.4"]},
  "a:4.8.5.4"->{
    Cell[25242, 893, 117, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:4.8.5.4"]},
  "a:4.9.4"->{
    Cell[35256, 1232, 187, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:4.9.4"]},
  "a:4.10.4"->{
    Cell[41423, 1469, 371, 14, 55, "Section",
      Evaluatable->False,
      CellTags->"a:4.10.4"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:4.4", 44252, 1579},
  {"a:4.5.4", 44361, 1583},
  {"a:4.6.4", 44474, 1587},
  {"a:4.7.4", 44587, 1591},
  {"a:4.8.4", 44700, 1595},
  {"a:4.8.5.4", 44815, 1599},
  {"a:4.9.4", 44934, 1603},
  {"a:4.10.4", 45050, 1607}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 316, 12, 99, "Title",
  Evaluatable->False,
  CellTags->"a:4.4"],

Cell[CellGroupData[{
Cell[2723, 92, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:4.5.4"],
Cell[3049, 105, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3926, 130, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5322, 173, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5500, 179, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6148, 202, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6866, 229, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7246, 245, 191, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:4.6.4"],
Cell[7440, 255, 533, 17, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8010, 277, 183, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:4.7.4"],
Cell[8196, 287, 218, 6, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8451, 298, 187, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:4.8.4"],
Cell[8641, 308, 116, 2, 33, "Text",
  Evaluatable->False],
Cell[8760, 312, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[8934, 318, 751, 20, 71, "Text",
  Evaluatable->False],
Cell[9688, 340, 161, 4, 27, "Input"],
Cell[9852, 346, 182, 7, 33, "Text",
  Evaluatable->False],
Cell[10037, 355, 71, 2, 27, "Input"],
Cell[10111, 359, 625, 20, 71, "Text",
  Evaluatable->False],
Cell[10739, 381, 101, 2, 27, "Input"],
Cell[10843, 385, 90, 2, 27, "Input"],
Cell[10936, 389, 501, 17, 52, "Text",
  Evaluatable->False],
Cell[11440, 408, 269, 6, 75, "Input"],
Cell[11712, 416, 212, 8, 33, "Text",
  Evaluatable->False],
Cell[11927, 426, 106, 2, 27, "Input"],
Cell[12036, 430, 102, 2, 27, "Input"],
Cell[12141, 434, 112, 2, 33, "Text",
  Evaluatable->False],
Cell[12256, 438, 300, 6, 75, "Input"],
Cell[12559, 446, 480, 13, 71, "Text",
  Evaluatable->False],
Cell[13042, 461, 374, 9, 71, "Text",
  Evaluatable->False],
Cell[13419, 472, 225, 5, 75, "Input"],
Cell[13647, 479, 85, 2, 33, "Text",
  Evaluatable->False],
Cell[13735, 483, 300, 6, 75, "Input"],
Cell[14038, 491, 1690, 55, 124, "Question",
  Evaluatable->False],
Cell[15731, 548, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[15808, 552, 742, 26, 52, "Text",
  Evaluatable->False],
Cell[16553, 580, 96, 3, 43, "Input"],
Cell[16652, 585, 1466, 48, 128, "Text",
  Evaluatable->False],
Cell[18121, 635, 89, 2, 27, "Input"],
Cell[18213, 639, 82, 2, 33, "Text",
  Evaluatable->False],
Cell[18298, 643, 324, 6, 75, "Input"],
Cell[18625, 651, 471, 15, 52, "Text",
  Evaluatable->False],
Cell[19099, 668, 311, 7, 99, "Input"],
Cell[19413, 677, 454, 17, 48, "Question",
  Evaluatable->False],
Cell[19870, 696, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[19947, 700, 351, 12, 67, "Question",
  Evaluatable->False],
Cell[20301, 714, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[20378, 718, 710, 24, 71, "Text",
  Evaluatable->False],
Cell[21091, 744, 214, 5, 75, "Input"],
Cell[21308, 751, 874, 31, 52, "Text",
  Evaluatable->False],
Cell[22185, 784, 371, 9, 99, "Input"],
Cell[22559, 795, 351, 12, 67, "Question",
  Evaluatable->False],
Cell[22913, 809, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[22990, 813, 1360, 45, 124, "Question",
  Evaluatable->False],
Cell[24353, 860, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[24430, 864, 428, 9, 164, "Input"],
Cell[24861, 875, 279, 10, 48, "Question",
  Evaluatable->False],
Cell[25143, 887, 74, 2, 47, "Answer",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[25242, 893, 117, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:4.8.5.4"],
Cell[25362, 898, 980, 23, 109, "Text",
  Evaluatable->False],
Cell[26345, 923, 400, 8, 107, "Input"],
Cell[26748, 933, 190, 5, 52, "Text",
  Evaluatable->False],
Cell[26941, 940, 145, 3, 27, "Input"],
Cell[27089, 945, 669, 17, 90, "Text",
  Evaluatable->False],
Cell[27761, 964, 530, 14, 86, "Question",
  Evaluatable->False],
Cell[28294, 980, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[28371, 984, 386, 12, 67, "Question",
  Evaluatable->False],
Cell[28760, 998, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[28837, 1002, 980, 29, 109, "Text",
  Evaluatable->False],
Cell[29820, 1033, 92, 2, 27, "Input"],
Cell[29915, 1037, 55, 0, 33, "Text"],
Cell[29973, 1039, 166, 3, 43, "Input"],
Cell[30142, 1044, 1727, 48, 257, "Question",
  Evaluatable->False],
Cell[31872, 1094, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[31949, 1098, 239, 6, 52, "Text",
  Evaluatable->False],
Cell[32191, 1106, 102, 2, 27, "Input"],
Cell[32296, 1110, 655, 23, 48, "Question",
  Evaluatable->False],
Cell[32954, 1135, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[33031, 1139, 664, 23, 67, "Question",
  Evaluatable->False],
Cell[33698, 1164, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[33775, 1168, 448, 17, 48, "Question",
  Evaluatable->False],
Cell[34226, 1187, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[34303, 1191, 420, 13, 67, "Question",
  Evaluatable->False],
Cell[34726, 1206, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[34803, 1210, 327, 12, 48, "Question",
  Evaluatable->False],
Cell[35133, 1224, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[35256, 1232, 187, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:4.9.4"],
Cell[35446, 1242, 375, 11, 52, "Text",
  Evaluatable->False],
Cell[35824, 1255, 105, 2, 27, "Input"],
Cell[35932, 1259, 249, 6, 52, "Text",
  Evaluatable->False],
Cell[36184, 1267, 136, 3, 27, "Input"],
Cell[36323, 1272, 396, 8, 90, "Text",
  Evaluatable->False],
Cell[36722, 1282, 137, 3, 27, "Input"],
Cell[36862, 1287, 540, 20, 33, "Text",
  Evaluatable->False],
Cell[37405, 1309, 82, 2, 27, "Input"],
Cell[37490, 1313, 269, 10, 48, "Question",
  Evaluatable->False],
Cell[37762, 1325, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[37839, 1329, 349, 12, 67, "Question",
  Evaluatable->False],
Cell[38191, 1343, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[38268, 1347, 480, 15, 77, "Text",
  Evaluatable->False],
Cell[38751, 1364, 128, 3, 27, "Input"],
Cell[38882, 1369, 332, 9, 75, "Input"],
Cell[39217, 1380, 483, 17, 52, "Text",
  Evaluatable->False],
Cell[39703, 1399, 298, 10, 48, "Question",
  Evaluatable->False],
Cell[40004, 1411, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[40081, 1415, 272, 10, 48, "Question",
  Evaluatable->False],
Cell[40356, 1427, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[40433, 1431, 325, 12, 48, "Question",
  Evaluatable->False],
Cell[40761, 1445, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[40838, 1449, 110, 2, 33, "Text",
  Evaluatable->False],
Cell[40951, 1453, 142, 3, 27, "Input"],
Cell[41096, 1458, 290, 6, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[41423, 1469, 371, 14, 55, "Section",
  Evaluatable->False,
  CellTags->"a:4.10.4"],
Cell[41797, 1485, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[42142, 1496, 62, 1, 27, "Input"],
Cell[42207, 1499, 52, 1, 27, "Input"],
Cell[42262, 1502, 47, 1, 27, "Input"],
Cell[42312, 1505, 58, 1, 27, "Input"],
Cell[42373, 1508, 48, 1, 27, "Input"],
Cell[42424, 1511, 49, 1, 27, "Input"],
Cell[42476, 1514, 56, 1, 27, "Input"],
Cell[42535, 1517, 48, 1, 27, "Input"],
Cell[42586, 1520, 59, 1, 27, "Input"],
Cell[42648, 1523, 50, 1, 27, "Input"],
Cell[42701, 1526, 52, 1, 27, "Input"],
Cell[42756, 1529, 58, 1, 27, "Input"],
Cell[42817, 1532, 56, 1, 27, "Input"],
Cell[42876, 1535, 50, 1, 27, "Input"],
Cell[42929, 1538, 50, 1, 27, "Input"],
Cell[42982, 1541, 60, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

