(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     56964,       2140]*)
(*NotebookOutlinePosition[     60550,       2262]*)
(*  CellTagsIndexPosition[     60037,       2241]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->GrayLevel[0]],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 5",
    FontSize->18],
  "\nRing Homomorphisms"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.5"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.6.5"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.7.5"],

Cell[TextData[{
  StyleBox["Before you start this lab, you should be familiar with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " and the ideas found in Ring Labs 1 and 2, as well as normal subgroups and \
ideals.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.8.5"],

Cell[TextData[StyleBox[
"This lab explores the notion of a ring homomorphism. First we define one, \
and then we see how one can be constructed. ",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "This lab is designed to be independent of the group labs on isomorphisms \
and homomorphisms. If you have done them, you can skip the first section of \
this lab, except to evaluate the inputs that define ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Morphoids on rings"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.9.5"],

Cell[TextData[{
  StyleBox["A ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " object that consists of either a function or a set of rules followed by \
two structured sets (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "). The function or rules serve to map each element in the first structured \
set into the second one. The only principle governing construction of a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is that an actual (mathematical) function must be defined by the rules or \
function. To continue, let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s read in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" functions we will need for this lab.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The way to create a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is with the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FormMorphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". For example, to define the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" from the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[" into the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_30\)]],
  StyleBox[", where the image of each element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  StyleBox[", we evaluate the following.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f = FormMorphoid[2\ #&, Z[15], Z[30]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If you try to create a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" with an invalid function, it will fail to be created.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FormMorphoid[2\ #&, Z[15], Z[20]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["One family of built-in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ZMap",
    FontFamily->"Courier"],
  StyleBox["[m, n]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" are positive integers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?ZMap\)\)], "Input"],

Cell[BoxData[
    \(g = ZMap[15, 5, Structure \[Rule] Ring]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["You can get a graphical representation of a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" with the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["VisualizeMorphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (or by using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Visual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" mode of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FormMorphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["). ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?VisualizeMorphoid\)\)], "Input"],

Cell[BoxData[
    \(\(VisualizeMorphoid[g, ColorCodomain \[Rule] Automatic]; \)\)], "Input",\

  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Any pair of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" can potentially have a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " connecting them. Here is an example that is defined with a list of rules \
instead of a function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(w = 
      FormMorphoid[{{} \[Rule] 0, {1} \[Rule] 0, {2} \[Rule] 0, {1, 2} 
            \[Rule] 1}, BooleanRing[2], Z[2]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["You may have noticed that depending on how you create a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", the first argument that appears in the output can vary. Ideally, what \
appears is the simplest description of the function that defines the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". As you will see later, the single rule ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["1 \[Rule] 1",
    FontFamily->"Courier"],
  StyleBox[" defines the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[", so the rest of the rules that define ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" do not need to be displayed.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Ring homomorphisms"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.10.5"],

Cell[TextData[{
  StyleBox["A ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["homomorphism",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" between rings ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  StyleBox[
  " is a function that preserves the operations between the two rings. That \
is, if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is a homomorphism, then for all values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" selected from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[",",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`f(x + y) = f(x) + f(y)\)]],
  "   and   ",
  Cell[BoxData[
      \(TraditionalForm\`f(x*y) = \(f(x)\)*\(f(y)\)\)]],
  StyleBox[".",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["(Note that the operations + and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`*\)]],
  StyleBox[" on the left-hand side of each equation occur within ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(R, \)\)]],
  StyleBox[" while those on the right-hand side occur within ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  StyleBox[".) If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is also one-to-one and onto, then it is an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["isomorphism",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". The existence of an isomorphism between two rings establishes them as \
being \[OpenCurlyDoubleQuote]equal\[CloseCurlyDoubleQuote] in an algebraic \
sense.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "To review the notion of operation preserving, we start by looking at the \
first two ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[
  "), since their domains are the same. For both of them we use the pair of \
elements {11, 7} and use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PreservesQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to see if the conditions above are satisfied when ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x = 11\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y = 17\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PreservesQ[f, {11, 7}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(PreservesQ[g, {11, 7}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["To see why ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" does not preserve operations, we can use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Visual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" mode.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(PreservesQ[f, {11, 7}, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "From this graphical representation of the tests, we see that the addition \
condition is satisfied but the multiplication condition fails: ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(11*7) = 4\)]],
  StyleBox[" but ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(f(11)\)*\(f(7)\) = 8\)]],
  StyleBox[". Therefore, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is not a ring homomorphism. Although ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" did preserve the operations for the pair ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{11, 7}\)]],
  StyleBox[", we cannot conclude that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[
  " is a homomorphism, since the conditions were checked for only one of the \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`15\^2 = 225\)]],
  StyleBox[" pairs of values that need to be checked. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MorphismQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" will check them all at once. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[g, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". The third ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " that was defined in the first section of this lab is also not a \
homomorphism. Explain why this is the case with a specific example that shows \
it is not.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "The kernel and image"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.11.5"],

Cell[CellGroupData[{

Cell["5.5.1 The kernel", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.11.6.5"],

Cell[TextData[{
  StyleBox[
  "Since every ring \[OpenCurlyDoubleQuote]contains\[CloseCurlyDoubleQuote] \
the additive group consisting of the domain and the addition operation, a \
ring homomorphism can also be viewed as a group homomorphism. This \
observation extends to the more general structures of a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" on a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" on a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Groupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". If you have already studied group homomorphisms, you are aware of the \
concept of the kernel. In the group setting, the kernel of a homomorphism is \
the set of elements in the domain that map onto the identity of the codomain. \
With rings, the additive identity is the zero of the ring. Therefore it is \
natural to make the following definition: The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["kernel",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " of a ring homomorphism is the set of elements in the domain that map onto \
the zero of the codomain.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Our first true ring homomorphism was called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[". What is its kernel? The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Visual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" mode of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Kernel",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" should clearly illustrate the elements in the kernel.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Kernel[g, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". First review the definition of an ideal. Without making any assumptions \
about the kernel (except its definition), answer the following questions.\n\n\
\ta. If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" is a ring homomorphism and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" are in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"K", "=", 
          RowBox[{
            StyleBox["Kernel",
              FontFamily->"Courier"], "[", "h", "]"}]}], TraditionalForm]]],
  StyleBox[", explain why ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r - s\)]],
  StyleBox[" must also be in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox[".\n\n\tb. If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" is a ring homomorphism and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" is in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"K", "=", 
          RowBox[{
            StyleBox["Kernel",
              FontFamily->"Courier"], "[", "h", "]"}]}], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" is in the domain of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[", explain why ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\ s\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(s\ r\ \)\)]],
  StyleBox["must also be in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox[
  ".\n\n\tc. Properties from (a) and (b) imply what about the kernel?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Kernel",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" returns a result that is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". It is a well-defined ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" function, provided the codomain has a zero.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f\), 
    \(Kernel[f]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(w\), 
    \(Kernel[w]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What conclusions, if any, can be drawn from the observations made in \
question 2 and the values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Kernel[f]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Kernel[w]?",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" Assume that you do not know whether ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  StyleBox[" is a homomorphism.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer:", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["5.5.2 The image", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.11.7.5"],

Cell[TextData[{
  StyleBox[
  "The image of a ring homomorphism is the range of the function, but it \
inherits the operation of the codomain and is also a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". For our first homomorphism, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[", the image is the whole codomain, which is not uncommon.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(g\), 
    \(Image[g]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Although a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " that is not a homomorphism can have an image, and that image may also be \
a subring (as we see with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[
  " that we defined above), there is no guarantee that it will be a subring.",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Image[f]\), 
    \(ClosedQ[%]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Find an example of a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" of rings for which the image is not a subring of the codomain.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "The kernel is an ideal"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.12.5"],

Cell["\<\
It was observed at the conclusion of question 2 that the kernel of \
a ring homomorphism is an ideal of the domain. This closely parallels the \
situation with groups. The kernel of a group homomorphism is a normal \
subgroup. Ideals and normal subgroups are precisely the subsets of their \
respective systems that allow quotient structures of cosets. We illustrate \
this situation in the ring case here.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["5.6.1 Example 1", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.12.6.5"],

Cell[TextData[{
  "The first true ring homomorphism was called ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ". "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(g\), 
    \(Kernel[g]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We can create the quotient ring with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["QuotientRing",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(QR = QuotientRing[Z[15], Kernel[g]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The theory that has led up to this point assures us that ",
  Cell[BoxData[
      FormBox[
        StyleBox["QR",
          FontSlant->"Italic"], TraditionalForm]]],
  " is a ring."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". To what common ring is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["QR",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" isomorphic?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Your response to this question should be implied by the following \
theorem. (The proof appears in nearly every introductory abstract algebra \
text.)\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["5.6.2 First Isomorphism Theorem (for rings)", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.12.7.5"],

Cell[TextData[{
  StyleBox["Theorem",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{\(f : R\), 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], "S"}], TraditionalForm]]],
  StyleBox[" be a surjective (onto) homomorphism of rings with kernel ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox[". Then the quotient ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R/K\)]],
  StyleBox[" is isomorphic to the image of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[", with the isomorphism ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{\(g : R/K\), 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], \(f \((R)\)\)}], TraditionalForm]]],
  StyleBox[" defined by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(a + K) = f(a)\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["5.6.3 Example 2", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.12.8.5"],

Cell[TextData[{
  StyleBox["In the second example, we define and work with a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" based on a direct product.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(R = DirectProduct[Z[3], Z[5]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We define a ",
  StyleBox["Morphoid",
    FontFamily->"Courier"],
  " from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_30\)]],
  " into ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\[Beta] = FormMorphoid[{Mod[#1, 3], Mod[#1, 5]}&, Z[30], R]\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[\[Beta]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(K = Kernel[\[Beta]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Based on the size of the kernel, how many elements should we expect to \
have in the quotient ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_30/K\)]],
  StyleBox["? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
We can generate the quotient ring to verify a conjecture from the \
last question.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Q2 = QuotientRing[Z[30], K]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Based on the First Isomorphism Theorem, to what ring is the quotient \
ring isomorphic?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.7 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "One-rule ",
  StyleBox["Morphoids",
    FontFamily->"Courier"]
}], "Section",
  CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.13.5"],

Cell[TextData[{
  StyleBox["It was noted earlier that",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["ZMap[15, 5]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  " and similar expressions form ",
  StyleBox["Morphoids",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" with a single rule displayed. Internally, the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is actually defined with a function, but the rule may be somewhat \
shorter, so for simplicity we display the rule.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(h = ZMap[4, 2]\)], "Input",
  CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". \ta. Assuming that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" is a morphism, which is true, explain how and why the rule ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"1", 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], "1"}], TraditionalForm]]],
  StyleBox[" determines rules for the other elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_4\)]],
  StyleBox[
  ". (What are the other rules?)\n\n\tb. Explain what goes wrong with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ZMap",
    FontFamily->"Courier"],
  StyleBox["[3, 2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and why ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"1", 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], "1"}], TraditionalForm]]],
  StyleBox[" cannot define a morphism.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.8 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "The Chinese Remainder Theorem"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.14.5"],

Cell[TextData[{
  StyleBox[
  "The image of the homomorphism \[Beta], considered in section 5.6, was the \
direct product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[" with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  StyleBox[". This direct product happens to be isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[". This follows from the Chinese Remainder Theorem.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Chinese Remainder Theorem",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\_1, m\_2, \[Ellipsis], m\_r\)]],
  StyleBox[
  " are positive integers such that no two have a common divisor greater than \
one, then the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ][m\_1\ m\_2\ \[Ellipsis]\ m\_r]\)]],
  " ",
  StyleBox["is isomorphic to the direct product ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ] \([m\_1\)\)]],
  StyleBox["] \[Cross] ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ] \([m\_2\)\)]],
  StyleBox["] \[Cross] \[CenterEllipsis] \[Cross] ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ] \([m\_r\)\)]],
  StyleBox["].",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"We do not provide a proof of this theorem since it appears in many standard \
texts. We do, however, illustrate one approach from a computational point of \
view.",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["An isomorphism from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[" into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[" \[Cross] ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  " ",
  StyleBox["is easy to construct. We map each element of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[
  " into the pair of remainders on division by 3 and 5 respectively.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta] = FormMorphoid[{Mod[#1, 3], Mod[#1, 5]}&, Z[15], R]\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    \(IsomorphismQ[\[Theta]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "For this case, the matter is settled. In the general situation, if we were \
to define a similar function from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ][m\_1\ m\_2\ \[Ellipsis]\ m\_r]\)]],
  StyleBox[
  " into the direct product, it is not totally clear that the function would \
be one-to-one and onto. This can be proven, however, and there is an \
algorithm that determines the inverse of the function. The inverse, which is \
not as simple to compute, is available as a function called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ChineseRemainderTheorem",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NumberTheory`NumberTheoryFunctions",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" package. Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s load this package and learn about this function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Needs["\<NumberTheory`NumberTheoryFunctions`\>"]; \n\n
    \(?ChineseRemainderTheorem\)\)], "Input"],

Cell[TextData[{
  StyleBox[
  "In the example, we might want to know what the inverse image of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{2, 3}\)]],
  StyleBox[" is, that is, for what integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Theta](n)\)]],
  StyleBox[" equal to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{2, 3}\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " We use {2, 3} for the first argument and {3, 5} for the second, since 3 \
and 5 are the two moduli used to form the codomain of \[Theta].",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ChineseRemainderTheorem[{2, 3}, {3, 5}]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
It turns out that 8 is the smallest integer congruent to 2 mod 3 \
and also congruent to 3 mod 5. We can easily verify this result.\
\>", "Text",\

  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta][8]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
The inverse function can be used to create an inverse isomorphism\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Gamma] = 
      FormMorphoid[ChineseRemainderTheorem[#1, {3, 5}]&, R, Z[15]]\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    \(IsomorphismQ[\[Gamma]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Of course, we should also verify that \[Gamma] is really the inverse of \
\[Theta]."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphoidComposition[\[Theta], \[Gamma]]\)], "Input",
  CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphoidComposition[\[Gamma], \[Theta]]\)], "Input",
  CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Explain why the last two results verify that these two functions are \
inverses.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The power of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ChineseRemainderTheorem",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " function may not be clear, since our original function was based on a \
relatively small set. Here is a question for which the Chinese Remainder \
Theorem can be employed.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Suppose that Franklin Street Clothing is having a sale. You give ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" dollars to person ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  StyleBox[", who then buys as many $19 shirts as possible with the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" dollars and then has $3 left over. You also give ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" dollars to person ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  StyleBox[", who then buys as many $29 sweatshirts as possible with the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[
  " dollars and then has $26 left over. What is the least positive number of \
dollars that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[
  " could be? Explain how the answer to this problem can be obtained using \
isomorphisms.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["We finish up the lab with a couple of follow-up questions.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Does the Chinese Remainder Theorem tell us that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[" is isomorphic to the direct product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_6\)]],
  StyleBox["? Explain your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Explain, from what we have done in this lab, why the rings ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_30/{0, 15}\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  StyleBox[" are isomorphic.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.9 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.15.5"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?FormMorphoid", "Input",
  AspectRatioFixed->True],

Cell["?ZMap", "Input",
  AspectRatioFixed->True],

Cell["?Structure", "Input",
  AspectRatioFixed->True],

Cell["?VisualizeMorphoid", "Input",
  CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
  AspectRatioFixed->True],

Cell["?Ring", "Input",
  AspectRatioFixed->True],

Cell["?BooleanRing", "Input",
  AspectRatioFixed->True],

Cell["?PreservesQ", "Input",
  AspectRatioFixed->True],

Cell["?MorphismQ", "Input",
  AspectRatioFixed->True],

Cell["?Kernel", "Input",
  AspectRatioFixed->True],

Cell["?Image", "Input",
  AspectRatioFixed->True],

Cell["?ClosedQ", "Input",
  AspectRatioFixed->True],

Cell["?QuotientRing", "Input",
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell["?DirectProduct", "Input",
  AspectRatioFixed->True],

Cell["?IsomorphismQ", "Input",
  AspectRatioFixed->True],

Cell["?ChineseRemainderTheorem", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 431},
WindowMargins->{{3, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingStartingPageNumber->28,
PrintingPageRange->{7, 8},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T000000@0000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:5.5"->{
    Cell[2409, 77, 166, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:5.5"]},
  "a:5.6.5"->{
    Cell[2600, 88, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:5.6.5"]},
  "a:5.7.5"->{
    Cell[6967, 235, 191, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.7.5"]},
  "a:5.8.5"->{
    Cell[7653, 265, 183, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.8.5"]},
  "a:5.9.5"->{
    Cell[9012, 319, 196, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.9.5"]},
  "a:5.10.5"->{
    Cell[17419, 636, 197, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.10.5"]},
  "a:5.11.5"->{
    Cell[24679, 911, 199, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.11.5"]},
  "a:5.11.6.5"->{
    Cell[24903, 923, 112, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:5.11.6.5"]},
  "a:5.11.7.5"->{
    Cell[32202, 1192, 111, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:5.11.7.5"]},
  "a:5.12.5"->{
    Cell[34391, 1280, 201, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.12.5"]},
  "a:5.12.6.5"->{
    Cell[35098, 1303, 111, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:5.12.6.5"]},
  "a:5.12.7.5"->{
    Cell[37057, 1389, 139, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:5.12.7.5"]},
  "a:5.12.8.5"->{
    Cell[38564, 1445, 111, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:5.12.8.5"]},
  "a:5.13.5"->{
    Cell[40970, 1551, 298, 11, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.13.5"]},
  "a:5.14.5"->{
    Cell[43776, 1655, 208, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:5.14.5"]},
  "a:5.15.5"->{
    Cell[55248, 2062, 371, 14, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.15.5"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:5.5", 58146, 2173},
  {"a:5.6.5", 58254, 2177},
  {"a:5.7.5", 58367, 2181},
  {"a:5.8.5", 58480, 2185},
  {"a:5.9.5", 58593, 2189},
  {"a:5.10.5", 58707, 2193},
  {"a:5.11.5", 58823, 2197},
  {"a:5.11.6.5", 58941, 2201},
  {"a:5.11.7.5", 59064, 2205},
  {"a:5.12.5", 59186, 2209},
  {"a:5.12.6.5", 59305, 2213},
  {"a:5.12.7.5", 59429, 2217},
  {"a:5.12.8.5", 59553, 2221},
  {"a:5.13.5", 59675, 2225},
  {"a:5.14.5", 59793, 2229},
  {"a:5.15.5", 59910, 2233}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 102, 3, 47, "Answer",
  Evaluatable->False],
Cell[1814, 54, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2409, 77, 166, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:5.5"],

Cell[CellGroupData[{
Cell[2600, 88, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:5.6.5"],
Cell[2926, 101, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3777, 125, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5147, 167, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5299, 172, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5921, 194, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6613, 220, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6967, 235, 191, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.7.5"],
Cell[7161, 245, 455, 15, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7653, 265, 183, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.8.5"],
Cell[7839, 275, 253, 6, 52, "Text",
  Evaluatable->False],
Cell[8095, 283, 880, 31, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[9012, 319, 196, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.9.5"],
Cell[9211, 329, 1683, 58, 109, "Text",
  Evaluatable->False],
Cell[10897, 389, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[11071, 395, 1491, 52, 71, "Text",
  Evaluatable->False],
Cell[12565, 449, 96, 2, 27, "Input"],
Cell[12664, 453, 390, 13, 33, "Text",
  Evaluatable->False],
Cell[13057, 468, 92, 2, 27, "Input"],
Cell[13152, 472, 825, 32, 33, "Text",
  Evaluatable->False],
Cell[13980, 506, 42, 1, 27, "Input"],
Cell[14025, 509, 98, 2, 27, "Input"],
Cell[14126, 513, 930, 34, 52, "Text",
  Evaluatable->False],
Cell[15059, 549, 55, 1, 27, "Input"],
Cell[15117, 552, 120, 3, 27, "Input"],
Cell[15240, 557, 621, 22, 52, "Text",
  Evaluatable->False],
Cell[15864, 581, 181, 4, 43, "Input"],
Cell[16048, 587, 1334, 44, 90, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[17419, 636, 197, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.10.5"],
Cell[17619, 646, 1182, 45, 52, "Text",
  Evaluatable->False],
Cell[18804, 693, 352, 13, 33, "Text",
  Evaluatable->False],
Cell[19159, 708, 1128, 36, 90, "Text",
  Evaluatable->False],
Cell[20290, 746, 1229, 44, 90, "Text",
  Evaluatable->False],
Cell[21522, 792, 81, 2, 27, "Input"],
Cell[21606, 796, 81, 2, 27, "Input"],
Cell[21690, 800, 490, 18, 33, "Text",
  Evaluatable->False],
Cell[22183, 820, 108, 2, 27, "Input"],
Cell[22294, 824, 1590, 52, 109, "Text",
  Evaluatable->False],
Cell[23887, 878, 92, 2, 27, "Input"],
Cell[23982, 882, 583, 20, 67, "Question",
  Evaluatable->False],
Cell[24568, 904, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[24679, 911, 199, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.11.5"],

Cell[CellGroupData[{
Cell[24903, 923, 112, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:5.11.6.5"],
Cell[25018, 928, 1754, 52, 185, "Text",
  Evaluatable->False],
Cell[26775, 982, 729, 25, 52, "Text",
  Evaluatable->False],
Cell[27507, 1009, 89, 2, 27, "Input"],
Cell[27599, 1013, 2570, 92, 219, "Question",
  Evaluatable->False],
Cell[30172, 1107, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[30249, 1111, 680, 24, 52, "Text",
  Evaluatable->False],
Cell[30932, 1137, 82, 3, 43, "Input"],
Cell[31017, 1142, 82, 3, 43, "Input"],
Cell[31102, 1147, 987, 36, 86, "Question",
  Evaluatable->False],
Cell[32092, 1185, 73, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[32202, 1192, 111, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:5.11.7.5"],
Cell[32316, 1197, 643, 20, 71, "Text",
  Evaluatable->False],
Cell[32962, 1219, 81, 3, 43, "Input"],
Cell[33046, 1224, 626, 22, 71, "Text",
  Evaluatable->False],
Cell[33675, 1248, 90, 3, 43, "Input"],
Cell[33768, 1253, 497, 17, 67, "Question",
  Evaluatable->False],
Cell[34268, 1272, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[34391, 1280, 201, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.12.5"],
Cell[34595, 1290, 478, 9, 109, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[35098, 1303, 111, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:5.12.6.5"],
Cell[35212, 1308, 180, 7, 33, "Text",
  Evaluatable->False],
Cell[35395, 1317, 82, 3, 43, "Input"],
Cell[35480, 1322, 424, 16, 33, "Text",
  Evaluatable->False],
Cell[35907, 1340, 94, 2, 27, "Input"],
Cell[36004, 1344, 260, 9, 33, "Text",
  Evaluatable->False],
Cell[36267, 1355, 451, 17, 48, "Question",
  Evaluatable->False],
Cell[36721, 1374, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[36798, 1378, 222, 6, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[37057, 1389, 139, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:5.12.7.5"],
Cell[37199, 1394, 1328, 46, 72, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[38564, 1445, 111, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:5.12.8.5"],
Cell[38678, 1450, 389, 13, 33, "Text",
  Evaluatable->False],
Cell[39070, 1465, 88, 2, 27, "Input"],
Cell[39161, 1469, 248, 11, 33, "Text"],
Cell[39412, 1482, 120, 3, 27, "Input"],
Cell[39535, 1487, 77, 2, 27, "Input"],
Cell[39615, 1491, 78, 2, 27, "Input"],
Cell[39696, 1495, 490, 17, 67, "Question",
  Evaluatable->False],
Cell[40189, 1514, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[40266, 1518, 154, 5, 33, "Text",
  Evaluatable->False],
Cell[40423, 1525, 86, 2, 27, "Input"],
Cell[40512, 1529, 332, 12, 48, "Question",
  Evaluatable->False],
Cell[40847, 1543, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[40970, 1551, 298, 11, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.13.5"],
Cell[41271, 1564, 825, 28, 71, "Text",
  Evaluatable->False],
Cell[42099, 1594, 131, 3, 27, "Input"],
Cell[42233, 1599, 1371, 46, 124, "Question",
  Evaluatable->False],
Cell[43607, 1647, 132, 3, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[43776, 1655, 208, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:5.14.5"],
Cell[43987, 1665, 769, 23, 71, "Text",
  Evaluatable->False],
Cell[44759, 1690, 1221, 39, 72, "Text",
  Evaluatable->False],
Cell[45983, 1731, 295, 7, 52, "Text",
  Evaluatable->False],
Cell[46281, 1740, 864, 28, 52, "Text",
  Evaluatable->False],
Cell[47148, 1770, 121, 3, 27, "Input"],
Cell[47272, 1775, 81, 2, 27, "Input"],
Cell[47356, 1779, 1267, 36, 128, "Text",
  Evaluatable->False],
Cell[48626, 1817, 120, 2, 59, "Input"],
Cell[48749, 1821, 975, 33, 71, "Text",
  Evaluatable->False],
Cell[49727, 1856, 98, 2, 27, "Input"],
Cell[49828, 1860, 205, 6, 52, "Text",
  Evaluatable->False],
Cell[50036, 1868, 70, 2, 27, "Input"],
Cell[50109, 1872, 139, 5, 33, "Text",
  Evaluatable->False],
Cell[50251, 1879, 139, 4, 27, "Input"],
Cell[50393, 1885, 81, 2, 27, "Input"],
Cell[50477, 1889, 158, 4, 33, "Text",
  Evaluatable->False],
Cell[50638, 1895, 156, 3, 27, "Input"],
Cell[50797, 1900, 156, 3, 27, "Input"],
Cell[50956, 1905, 325, 12, 48, "Question",
  Evaluatable->False],
Cell[51284, 1919, 132, 3, 47, "Answer",
  Evaluatable->False],
Cell[51419, 1924, 520, 16, 71, "Text",
  Evaluatable->False],
Cell[51942, 1942, 1510, 50, 124, "Question",
  Evaluatable->False],
Cell[53455, 1994, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[53532, 1998, 122, 2, 33, "Text",
  Evaluatable->False],
Cell[53657, 2002, 782, 25, 67, "Question",
  Evaluatable->False],
Cell[54442, 2029, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[54519, 2033, 615, 20, 67, "Question",
  Evaluatable->False],
Cell[55137, 2055, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[55248, 2062, 371, 14, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.15.5"],
Cell[55622, 2078, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[55967, 2089, 56, 1, 27, "Input"],
Cell[56026, 2092, 48, 1, 27, "Input"],
Cell[56077, 2095, 53, 1, 27, "Input"],
Cell[56133, 2098, 119, 2, 27, "Input"],
Cell[56255, 2102, 48, 1, 27, "Input"],
Cell[56306, 2105, 55, 1, 27, "Input"],
Cell[56364, 2108, 54, 1, 27, "Input"],
Cell[56421, 2111, 53, 1, 27, "Input"],
Cell[56477, 2114, 50, 1, 27, "Input"],
Cell[56530, 2117, 49, 1, 27, "Input"],
Cell[56582, 2120, 51, 1, 27, "Input"],
Cell[56636, 2123, 56, 1, 27, "Input"],
Cell[56695, 2126, 52, 1, 27, "Input"],
Cell[56750, 2129, 57, 1, 27, "Input"],
Cell[56810, 2132, 56, 1, 27, "Input"],
Cell[56869, 2135, 67, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

