(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     75790,       2755]*)
(*NotebookOutlinePosition[     79737,       2886]*)
(*  CellTagsIndexPosition[     79142,       2863]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->GrayLevel[0]],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 9",
    FontSize->18],
  "\nCyclotomic Polynomials"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.9"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["9.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.10.9"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["9.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.11.9"],

Cell["\<\
Before working on this lab, you should have completed Ring Lab 8, \
on roots of unity.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["9.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.12.9"],

Cell["\<\
The goal for this lab is to formulate recursive and nonrecursive \
definitions of the cyclotomic polynomials and discover some of their \
properties. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["9.3 I",
    Evaluatable->False,
    AspectRatioFixed->True],
  "ntroduction"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.13.9"],

Cell[TextData[{
  "Recall that in Ring Lab 8 we focused on the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  " (for a positive integer ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "). Here, we continue to focus on this polynomial\[LongDash]or, more \
accurately, factors of it."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"First let\[CloseCurlyQuote]s remind ourselves what the factorizations of \
these polynomials look like."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[x]\), 
    \(TableForm[Table[{n, Factor[x\^n - 1]}, {n, 1, 11}]]\)}], "Input",
  AspectRatioFixed->True],

Cell["We also redefine two functions we created in Ring Lab 8.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(RootsOfUnityZeros[n_Integer?Positive, fractions, opts___?OptionQ] := 
      Module[{factors = First[Transpose[Drop[FactorList[x\^n - 1], 1]]], 
          zeros, len, pts, sizedpts, width = 1.3, p = Cyclotomic[n, x]}, 
        factors = Join[Complement[factors, {p}], {p}]; 
        zeros = x /. \((NSolve[#1 == 0]&)\)/@factors; len = Length[zeros]; 
        pts = Map[\((Point[{Re[#1], Im[#1]}]&)\)/@#1&, zeros, 2]; 
        sizedpts = 
          Transpose[{
              Table[{Hue[i\/len], PointSize[0.015 + i\ 0.008]}, {i, len}], 
              pts}]; Show[
          Graphics[{
              Flatten/@sizedpts, {RGBColor[0, 0, 1], 
                Table[Text[InputForm[i\/n], 
                    1.2\ {Cos[\(i\ 2\ \[Pi]\)\/n], 
                        Sin[\(i\ 2\ \[Pi]\)\/n]}], {i, 0, n - 1}]}}], 
          Axes \[Rule] True, AspectRatio \[Rule] Automatic, 
          PlotRange \[Rule] {{\(-width\), width}, {\(-width\), width}}, 
          PlotLabel \[Rule] "\<n = \>"<>ToString[n], opts]]\), 
    \(UnityFactors[n_Integer?Positive] := 
      First[Transpose[Drop[FactorList[x\^n - 1], 1]]]\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
Also, we remind ourselves how the zeros of these polynomials are \
distributed.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Do[RootsOfUnityZeros[k, fractions], {k, 2, 11}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Our goal is to consider what is called a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["cyclotomic polynomial",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". For each positive integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox[", there is a polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[CapitalPhi]", "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" called the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox["th cyclotomic polynomial.",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox[
  "Since cyclotomic polynomials are quite important, there is a built-in \
function for them in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". Here are the fifth and sixth cyclotomic polynomials.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\({Cyclotomic[5, \ x], \ Cyclotomic[6, \ x]}\n (*\ 
      x\ simply\ indicates\ with\ what\ indeterminate\ to\ express\ the\ 
        polynomial\ *) \)\)], "Input"],

Cell[TextData[{
  StyleBox[
  "The cyclotomic polynomials are related to the roots of unity. We were \
reminded earlier that these numbers are all on the unit circle. (Note that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["cyclo",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" refers to a circle and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["tomic ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["indicates a cutting.) The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox["th roots of unity take the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"u", "(", 
            RowBox[{"n", ",", "k"}], ")"}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{"cos", "(", 
                RowBox[{"2", " ", "\[Pi]", " ", 
                  RowBox[{"k", "/", "n"}]}], ")"}], "+", 
              RowBox[{"i", " ", 
                RowBox[{"sin", "(", 
                  RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"k", "/", "n"}]}], ")"}]}]}], "=", 
            SuperscriptBox["e", 
              RowBox[{"2", " ", "\[Pi]", " ", "i", " ", 
                RowBox[{"k", "/", "n"}]}]]}]}], TraditionalForm]]],
  StyleBox[", where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"k", "=", "0"}], ",", "1", ",", "2", ",", " ", "...", ",", 
          RowBox[{"n", "-", "1"}]}], TraditionalForm]]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If you have ever browsed through",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" The Mathematica Book",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ", you may have come across the description of the cyclotomic polynomials. \
The description is that the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["th cyclotomic polynomial in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" is the product of all linear factors of the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x - u(n, k)\)]],
  StyleBox[" for which ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" is relatively prime to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GCD[n, k] = 1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "). These are the factors corresponding to the so-called \
\[OpenCurlyDoubleQuote]primitive ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  "th roots of unity\[CloseCurlyDoubleQuote] that are labeled red in the \
graphs.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(u[n_, k_] := Cos[\(2\ \[Pi]\ k\)\/n] + I\ Sin[\(2\ \[Pi]\ k\)\/n]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "For example, there are two primitive sixth roots of unity, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"u", "(", 
          RowBox[{"6", ",", "1"}], ")"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"u", "(", 
          RowBox[{"6", ",", "5"}], ")"}], TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \({Expand[\((x - u[6, 1])\)\ \((x - u[6, 5])\)], Cyclotomic[6, x]}\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". \ta. Determine ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_8\)(x)\)]],
  StyleBox[", the eighth cyclotomic polynomial in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[
  ", by expanding the proper linear factors.\n\tb. Without generating ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_128\)(x)\)]],
  StyleBox[" itself, determine its degree.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Our goal at this point is to develop an alternate way of building the \
cyclotomic polynomials without using the complex numbers. We will be asking \
you to look at many patterns to see if you can come up with this alternate \
definition. First let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s compare ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[" and the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  "th cyclotomic polynomial in tandem. Note that the output consists of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[", then the factorization of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[", followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\[CapitalPhi]\_n\)(x)\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[{{n, Factor[x\^n - 1], Cyclotomic[n, x], 
            "\<--------------------------\>"}}, {n, 1, 11}]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". At least one observation regarding the relationship between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and the factorization of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[" should be obvious. What is it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox[" is a prime number. How can you formulate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" in terms of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["x", "n"], "-", "1"}], TraditionalForm]]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["In question 3, you should have found a method of formulating ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" in terms of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[", when ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" is prime. What if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" is composite? (Note: We simply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["define",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "1"], "(", "x", ")"}], 
        TraditionalForm]]],
  " to be ",
  Cell[BoxData[
      \(TraditionalForm\`x - 1\)]],
  StyleBox[", just as we ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["define",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(0!\)\)]],
  StyleBox[" to be 1.) Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s extend our table and make some more comparisons.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[{{n, Factor[x\^n - 1], Cyclotomic[n, x], 
            "\<--------------------------\>"}}, {n, 12, 30}]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["It appears that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" is a factor of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[". Recall from the last lab that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["UnityFactors",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" gave just the list of factors of the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[". Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s test some random indices and see if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" really is a factor of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[". (We use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MemberQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to see if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Cyclotomic[n, x]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" belongs to the list of factors of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {31, 120}]\), 
    \(MemberQ[UnityFactors[n], Cyclotomic[n, x]]\)}], "Input",
  AspectRatioFixed->True],

Cell["We should perhaps try this a number of times.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Table[{n = Random[Integer, {31, 120}], 
        MemberQ[UnityFactors[n], Cyclotomic[n, x]]}, {20}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "One more time with other values of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Table[{n = Random[Integer, {121, 180}], 
        MemberQ[UnityFactors[n], Cyclotomic[n, x]]}, {15}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This is not a proof, but the evidence seems to indicate that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" divides ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[". Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s assume that this is the case and that there exists some function \
(depending on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["), ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(g\_n\)(x)\)]],
  StyleBox[", such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\(\(\[CapitalPhi]\_n\)(x)\)\ \(\(g\_n\)(x)\) = x\^n - 1\)]],
  StyleBox[". We already know that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(g\_n\)(x) = x - 1\)]],
  StyleBox[" when ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" is prime. What about when ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" is composite?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Although premature for any definitive solution, do you have any thoughts \
on the nature of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(g\_n\)(x)\)]],
  StyleBox[" for composite ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["9.4 Search for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["g", "n"], "(", "x", ")"}], TraditionalForm]]]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.14.9"],

Cell[TextData[{
  StyleBox["Since we are assuming that we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\(\(\[CapitalPhi]\_n\)(x)\)\ \(\(g\_n\)(x)\) = x\^n - 1\)]],
  StyleBox[", perhaps we should solve for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(g\_n\)(x)\)]],
  StyleBox[
  " and explore the quotient of the two pieces we can calculate. (Note, of \
course, that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" knows ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[", but we do not, yet.) Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s consider this with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n = 6\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Simplify[\(x\^6 - 1\)\/Cyclotomic[6, x]]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
We want to factor this so that we can know what the pieces look \
like.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Factor[%]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
We should define and then try out a function to do all these steps \
at once.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(gFunction[n_] := Factor[Simplify[\(x\^n - 1\)\/Cyclotomic[n, x]]]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Table[{n, gFunction[n]}, {n, 1, 14}]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "This may not be so revealing. Perhaps we should also add the ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "th cyclotomic polynomial to the table. Study the following results and \
look for patterns."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[{{n, gFunction[n], Cyclotomic[n, x], 
            "\<--------------------------\>"}}, {n, 1, 14}]]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Extend the table, if you wish, by looking at six more cases (in \
conjunction with the previous ones).\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[{{n, gFunction[n], Cyclotomic[n, x], "\<------------------\>"}}, {
          n, 15, 20}]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the nature of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["g", "n"], "(", "x", ")"}], TraditionalForm]]],
  StyleBox[" for composite ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox["? For a hint, given an index ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox[", consider the (proper) divisors ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["d", TraditionalForm]]],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox[" and the corresponding collection of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "d"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[". Can they be used to construct ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["g", "n"], "(", "x", ")"}], TraditionalForm]]],
  StyleBox[
  "? Look carefully at the first 15 examples and apply the hint and see what \
you can come up with.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Now we want to give a recursive definition for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[". In other words, you should be able to write ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[CapitalPhi]",
                Evaluatable->False,
                AspectRatioFixed->True], "n"], "(", "x", ")"}], "=", "RHS"}], 
        TraditionalForm]]],
  StyleBox[", where the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`RHS\)]],
  StyleBox[" depends on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "k"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" for one or more values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" that are less than ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["9.5 Some properties of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.9"],

Cell["\<\
We now consider some properties of the cyclotomic polynomials. \
First we remind ourselves of some of these polynomials and precede each with \
its degree.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[{{n, Exponent[p = Cyclotomic[n, x], x], p, 
            "\<----------------------\>"}}, {n, 2, 15}]]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["9.5.1 Each cyclotomic polynomial is monic", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.10.9"],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Based on what you know about the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[", why is the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["th cyclotomic polynomial monic? (Recall that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["monic",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " means that the leading coefficient, the one associated with the term of \
highest degree, has the value of 1.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["9.5.2 Degrees of cyclotomic polynomials", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.11.9"],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Compare the index ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" of the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[
  " with its degree. You should be able to see an interesting relationship \
and be able to express the degree of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[
  " as a \[OpenCurlyDoubleQuote]nice\[CloseCurlyDoubleQuote] function of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[". What is it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["9.5.3 Irreducibility of the cyclotomic polynomial", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.12.9"],

Cell["\<\
In Ring Lab 7 we explored the notion of irreducibility. Which, if \
any, of the cyclotomic polynomials are irreducible over the rationals? Try \
the following to factor a random cyclotomic polynomial.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[{n = Random[Integer, {2, 50}], Factor[Cyclotomic[n, x]]}, {10}]]
      \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Repeat and/or modify the range of the random index until you are ready \
to make a conjecture regarding when (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", for what ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[") ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" is irreducible over the rationals.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s choose a prime, say 29, and consider ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n = 29\)]],
  StyleBox[". We call the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" for this example.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[h]\), 
    \(h[x_] = Cyclotomic[29, x]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now consider ",
  Cell[BoxData[
      \(TraditionalForm\`h(x + 1)\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(h[x + 1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Of course ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["we ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  "knew that we wanted this polynomial expanded, but we need to tell ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" explicitly to do so.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Expand[%]\)], "Input",
  AspectRatioFixed->True],

Cell["Now examine the coefficients more closely.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(coeffs = CoefficientList[%, x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      FormBox[
        RowBox[{"h", "(", "x", ")"}], TraditionalForm]]],
  " is monic, so is ",
  Cell[BoxData[
      FormBox[
        RowBox[{"h", "(", 
          RowBox[{"x", "+", "1"}], ")"}], TraditionalForm]]],
  ". Therefore the leading coefficient is 1. Is there any significance to the \
rest of the coefficients? Suppose we ignore the last (i.e., leading) \
coefficient and ask for the greatest common divisor of the balance."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Apply[GCD, \ Drop[coeffs, \ \(-1\)]]\)], "Input"],

Cell[TextData[{
  "This says that 29 divides each of the coefficients except the leading one. \
Note further that ",
  Cell[BoxData[
      \(TraditionalForm\`29\^2\)]],
  " does not divide the constant term, 29. We can now use Eisenstein\
\[CloseCurlyQuote]s Criterion to conclude that the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`h(x + 1)\)]],
  " is irreducible over the rationals. Consequently, the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  " is also irreducible over the rationals. This illustrates that a \
cyclotomic polynomial with prime index is irreducible. It is also true for \
composite indices, but the proof requires some understanding of extension \
fields. (See Ring Lab 11 for an introduction to quadratic extension fields.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["9.5.4 Graphs of roots of the cyclotomic polynomial", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.13.9"],

Cell[TextData[{
  "As we saw in section 9.5.3, the cyclotomic polynomial is irreducible over \
the rationals. It is, of course, reducible over the complex numbers. In fact, \
we saw this in Ring Lab 8. As was pointed out earlier, the zeros of the ",
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  "th cyclotomic polynomial are a subset of the whole set of ",
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  "th roots of unity."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s remind ourselves what these roots look like. The \
roots of the cyclotomic polynomial are the red ones plotted in the complex \
plane. ",
  StyleBox[
  "(Note: You may wish to delete all previous graphics cells before \
continuing, due to memory demand.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Do[RootsOfUnityZeros[k, fractions], {k, 5, 20, 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". The zeros of the cyclotomic polynomials (the red dots) are labeled with \
fractions of the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k/n\)]],
  StyleBox[" for certain values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[". What are the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" values? How do they relate to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  "? You may wish to modify the preceding cell to see more examples.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". In each of the graphs, the full collection of zeros forms a group under \
multiplication. To what group is this group naturally isomorphic? What is the \
relationship between the zeros of the cyclotomic polynomials and this group?",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["As a noted earlier, the roots of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["th cyclotomic polynomial are often called the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["primitive nth roots of unity. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["Can you imagine why?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.5.5 ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], \(2  n\)], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" for odd ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.14.9"],

Cell[TextData[{
  StyleBox["Here we wish to look for a relationship, if any, between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], \(2  n\)], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[". First we look at a table listing some pairs.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[{{k, Cyclotomic[k, x], 2\ k, Cyclotomic[2\ k, x], 
            "\<-----------------------------\>", "\< \>"}}, {k, 3, 13, 2}]]
      \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "You may wish to expand this table to encompass other values. A plot of an \
example might also be revealing. You may wish to modify your value of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" to see other plots. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[CapitalPhi]",
            Evaluatable->False,
            AspectRatioFixed->True], "n"], TraditionalForm]]],
  StyleBox[" is plotted in red and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[CapitalPhi]",
            Evaluatable->False,
            AspectRatioFixed->True], \(2  n\)], TraditionalForm]]],
  StyleBox[" in blue.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(n = 9; \)\), 
    \(\(Plot[
      Evaluate[{Cyclotomic[n, x], Cyclotomic[2\ n, x]}], {x, \(-2\), 2}, 
      PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}]; \)\)}], 
  "Input",
  AspectRatioFixed->True],

Cell["\<\
Note that this plot reveals that there are no real zeros (at least \
in the domain shown). We can still, however, compare the complex zeros. You \
may need to enlarge the output below to view it. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(n = 11; \)\), 
    \(\(gr1 = 
      RootsOfUnityZeros[11, fractions, DisplayFunction \[Rule] Identity]; 
    \)\), 
    \(\(gr2 = 
      RootsOfUnityZeros[22, fractions, DisplayFunction \[Rule] Identity]; 
    \)\), 
    \(\(Show[GraphicsArray[{gr1, gr2}]]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What conclusion(s), if any, can you make about how ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], \(2  n\)], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" are related?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.5.6 ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "p"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], \(p\^k\)], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" for prime ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.15.9"],

Cell[TextData[{
  StyleBox["Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["p", TraditionalForm]]],
  StyleBox[" is a prime and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["k", TraditionalForm]]],
  StyleBox[" is an integer with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"k", "\[GreaterEqual]", "1"}], TraditionalForm]]],
  StyleBox[". We wish to compare ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "p"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], 
            SuperscriptBox["p", "k"]], "(", "x", ")"}], TraditionalForm]]],
  StyleBox[" for various primes ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["p", TraditionalForm]]],
  StyleBox[". We make a table consisting of a 5-tuple ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{"p", ",", "k", ",", 
            SuperscriptBox["p", "k"], ",", 
            RowBox[{
              SubscriptBox[
                StyleBox["\[CapitalPhi]",
                  Evaluatable->False,
                  AspectRatioFixed->True], "p"], "(", "x", ")"}], ",", 
            RowBox[{
              SubscriptBox[
                StyleBox["\[CapitalPhi]",
                  Evaluatable->False,
                  AspectRatioFixed->True], 
                SuperscriptBox["p", "k"]], "(", "x", ")"}]}], "}"}], 
        TraditionalForm]]],
  ",",
  StyleBox[" where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["p", TraditionalForm]]],
  StyleBox[" runs through the first six primes and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["k", TraditionalForm]]],
  StyleBox[" is a random integer between 2 and 4. Study the results.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[k = 
          Random[Integer, {2, 4}]; {{p = Prime[n], k, p\^k, Cyclotomic[p, x], 
            Cyclotomic[p\^k, x], "\<----------------------\>"}}, {n, 1, 6}]]
      \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["k", TraditionalForm]]],
  StyleBox[
  " is generated randomly, you may wish to evaluate the cell again if it is \
not clear what relationship is being expressed. Determine how you can express \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], 
            SuperscriptBox["p", "k"]], "(", "x", ")"}], TraditionalForm]]],
  StyleBox[" in terms of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["p", TraditionalForm]]],
  StyleBox["th cyclotomic polynomial, if possible.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.5.7 ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "m"], "(", "x", ")"}], 
        TraditionalForm]]],
  ",",
  StyleBox[" where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" have similar prime decompositions",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.16.9"],

Cell[TextData[{
  StyleBox["Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" is an integer whose prime-power decomposition is given as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(p\_1\) \(p\_2\) \[Ellipsis]\ p\_k\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" is an integer whose prime-power decomposition is given as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\_1\%e\_1\)]],
  Cell[BoxData[
      \(TraditionalForm\`p\_2\%e\_2\)]],
  "\[Ellipsis] ",
  Cell[BoxData[
      \(TraditionalForm\`p\_k\%e\_k\)]],
  StyleBox[" where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`e\_1, e\_2, \[Ellipsis]\ e\_k\)]],
  StyleBox[" are the positive integral exponents belonging to primes ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\_1\)]],
  StyleBox[" through ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\_k\)]],
  StyleBox[". We wish to compare ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "m"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  ShowShortBoxForm->True,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For investigative purposes, suppose we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m = 2*3*5\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(n = \)\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2\^a\ 3\^b\ 5\^c\)]],
  StyleBox[" for some powers ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[". We make a table consisting of a 4-tuple ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{\({a, b, c}\), ",", "n", ",", 
            RowBox[{
              SubscriptBox[
                StyleBox["\[CapitalPhi]",
                  Evaluatable->False,
                  AspectRatioFixed->True], "m"], "(", "x", ")"}], ",", 
            RowBox[{
              SubscriptBox[
                StyleBox["\[CapitalPhi]",
                  Evaluatable->False,
                  AspectRatioFixed->True], "n"], "(", "x", ")"}]}], "}"}], 
        TraditionalForm]]],
  ",",
  StyleBox[" where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[" are random integers between 2 and 4. Study the results.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(m = 2\ 3\ 5; \)\), 
    \(TableForm[
      Table[{a, b, c} = Table[Random[Integer, {2, 4}], {3}]; 
        n = 2\^a\ 3\^b\ 
            5\^c; {{{{"\<a = \>"<>ToString[a], "\<b = \>"<>ToString[b], 
                "\<c = \>"<>ToString[c]}}, 
            "\<2^\>"<>ToString[a]<>"\< 3^\>"<>ToString[b]<>"\< 5^\>"<>
              ToString[c]<>"\< = \>"<>ToString[n], Cyclotomic[m, x], 
            Cyclotomic[n, x], "\<--------------------\>"}}, {6}]]\)}], "Input",\

  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[
  " are generated randomly, you may wish to evaluate the cell again if it is \
not clear what relationship is being expressed. What relationship is there \
between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "m"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" for the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" as obtained above and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m = 30\)]],
  StyleBox["? Generalize for arbitrary ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  " satisfying the hypothesis given at the beginning of this section.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.5.8 ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "1", ")"}], 
        TraditionalForm]]]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.17.9"],

Cell[TextData[{
  StyleBox["We have seen many cyclotomic polynomials ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[" and even seen a few plotted, but we haven",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "t investigated viewing them as polynomial functions and evaluating them at \
specific points. Here we consider ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "1", ")"}], 
        TraditionalForm]]],
  StyleBox[" for various values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[". Consider the table of values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "1", ")"}], 
        TraditionalForm]]],
  StyleBox[" for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" generated randomly between 1 and 150. Study the results.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[n = Random[Integer, {1, 150}]; {n, 
          Cyclotomic[n, x] /. x \[Rule] 1}, {20}], 
      TableHeadings 
        \[Rule] {None, {"\<n\>", "\<\!\(\[CapitalPhi]\_n\)(1)\n\>"}}, 
      TableSpacing \[Rule] {0.5, 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What conclusions can you make? (Evaluate again, if necessary.) State \
them as conjectures.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Evaluate the following cell.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Table[{n, Cyclotomic[n, x] /. x \[Rule] 1}, {n, 1, 25}], 
      TableHeadings 
        \[Rule] {None, {"\<n\>", \*"\"\<\!\(\[CapitalPhi]\_n\)(1)\\n\>\""}}, 
      TableSpacing \[Rule] {0.5, 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q16",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Does the result confirm or deny your previous conjecture? Reformulate, \
if necessary.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "9.5.9 ",
  StyleBox["How ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[
  " is related to the Moebius function, yielding a nonrecursive definition",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.18.9"],

Cell[TextData[
"The Moebius function (often denoted with the lower-case Greek letter \[Mu]) \
is a number-theoretic function defined as follows."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Mu](n) = 1\)]],
  StyleBox[", if ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n = 1\)]],
  StyleBox[";\n",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Mu](n) = \((\(-1\))\)\^k\)]],
  StyleBox[", if ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" is a product of ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[" distinct primes;\n",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Mu](n) = 0\)]],
  StyleBox[", if ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\^2\)]],
  StyleBox[" divides ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" for some prime ",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[".",
    Evaluatable->False,
    TextAlignment->Center,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q17",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". For ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" = 1, 2, 3, 4, 6, and 12, calculate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Mu](n)\)]],
  StyleBox[". (Note that these are all divisors of 12.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Since the Moebius function is important for various parts of mathematics, \
it is a built-in function in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". The following table can be used to confirm your answers to question 17.",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[MoebiusMu, \ {1, \ 2, \ 3, \ 4, \ 6, \ 12}]\)], "Input"],

Cell[TextData[{
  StyleBox["Applying the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MoebiusMu",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " function to the divisors of an integer proves itself useful here. In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", we can obtain the list of divisors of an integer using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Divisors",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Divisors[12]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "With ",
  Cell[BoxData[
      FormBox[
        RowBox[{"n", "=", "12"}], TraditionalForm]]],
  ", what we now want to do is raise the polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["x", 
            RowBox[{"12", "/", "d"}]], "-", "1"}], TraditionalForm]]],
  " to the power ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Mu]", "(", "d", ")"}], TraditionalForm]]],
  " for each divisor ",
  Cell[BoxData[
      FormBox["d", TraditionalForm]]],
  ". Here is one way of doing it."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(n\  = \ 12; \ \n
    polys\  = \ 
      \((\((x^\((n/#1)\)\  - \ 1)\)^MoebiusMu[#1]\ &\ )\)\ /@\ 
        Divisors[n]\)], "Input"],

Cell["Now we want to multiply these polynomials.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Apply[Times, \ polys]\)], "Input"],

Cell[BoxData[
    \(Simplify[%]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Cyclotomic[n, x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q18",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". In the previous few input cells, replace 12 with 20 and evaluate each \
cell. What is your result? Any conjectures? Try it again with another value \
or two.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q19",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". In question 6 you were asked to determine a recursive definition for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[CapitalPhi]",
              Evaluatable->False,
              AspectRatioFixed->True], "n"], "(", "x", ")"}], 
        TraditionalForm]]],
  StyleBox[". Now give a nonrecursive definition.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["9.5.10 Disclaimer/warning", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.15.19.9"],

Cell["\<\
You are not finished! Nearly all the conclusions you have reached \
in this lab were based on looking at patterns and formulating conjectures. \
Your next step should be to prove at least some of your conjectures. Your \
instructor will no doubt assign at least some of these proofs to you.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["9.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:9.16.9"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Table", "Input",
  AspectRatioFixed->True],

Cell["?Cyclotomic", "Input",
  AspectRatioFixed->True],

Cell["?Factor", "Input",
  AspectRatioFixed->True],

Cell["?Random", "Input",
  AspectRatioFixed->True],

Cell["?MemberQ", "Input",
  AspectRatioFixed->True],

Cell["?Simplify", "Input",
  AspectRatioFixed->True],

Cell["?Exponent", "Input",
  AspectRatioFixed->True],

Cell["?Expand", "Input",
  AspectRatioFixed->True],

Cell["?Apply", "Input",
  AspectRatioFixed->True],

Cell["?GCD", "Input",
  AspectRatioFixed->True],

Cell["?Drop", "Input",
  AspectRatioFixed->True],

Cell["?MoebiusMu", "Input",
  AspectRatioFixed->True],

Cell["?Divisors", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 431},
WindowMargins->{{3, Automatic}, {Automatic, -1}},
PrintingCopies->1,
PrintingStartingPageNumber->75,
PrintingPageRange->{7, 8},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:9.9"->{
    Cell[2409, 77, 170, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:9.9"]},
  "a:9.10.9"->{
    Cell[2604, 88, 324, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:9.10.9"]},
  "a:9.11.9"->{
    Cell[6972, 235, 192, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:9.11.9"]},
  "a:9.12.9"->{
    Cell[7362, 255, 184, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:9.12.9"]},
  "a:9.13.9"->{
    Cell[7808, 276, 191, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:9.13.9"]},
  "a:9.14.9"->{
    Cell[27451, 967, 303, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:9.14.9"]},
  "a:9.15.9"->{
    Cell[34219, 1219, 427, 15, 35, "Section",
      Evaluatable->False,
      CellTags->"a:9.15.9"]},
  "a:9.15.10.9"->{
    Cell[35086, 1252, 138, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.10.9"]},
  "a:9.15.11.9"->{
    Cell[36382, 1301, 136, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.11.9"]},
  "a:9.15.12.9"->{
    Cell[37950, 1360, 146, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.12.9"]},
  "a:9.15.13.9"->{
    Cell[43058, 1546, 147, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.13.9"]},
  "a:9.15.14.9"->{
    Cell[46417, 1664, 792, 29, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.14.9"]},
  "a:9.15.15.9"->{
    Cell[51138, 1833, 794, 29, 33, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.15.9"]},
  "a:9.15.16.9"->{
    Cell[55811, 1997, 1015, 38, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.16.9"]},
  "a:9.15.17.9"->{
    Cell[63483, 2273, 354, 13, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.17.9"]},
  "a:9.15.18.9"->{
    Cell[67058, 2404, 568, 20, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.18.9"]},
  "a:9.15.19.9"->{
    Cell[73811, 2668, 122, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:9.15.19.9"]},
  "a:9.16.9"->{
    Cell[74350, 2687, 371, 14, 35, "Section",
      Evaluatable->False,
      CellTags->"a:9.16.9"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:9.9", 76945, 2787},
  {"a:9.10.9", 77054, 2791},
  {"a:9.11.9", 77169, 2795},
  {"a:9.12.9", 77284, 2799},
  {"a:9.13.9", 77399, 2803},
  {"a:9.14.9", 77514, 2807},
  {"a:9.15.9", 77631, 2811},
  {"a:9.15.10.9", 77752, 2815},
  {"a:9.15.11.9", 77878, 2819},
  {"a:9.15.12.9", 78004, 2823},
  {"a:9.15.13.9", 78130, 2827},
  {"a:9.15.14.9", 78256, 2831},
  {"a:9.15.15.9", 78383, 2835},
  {"a:9.15.16.9", 78510, 2839},
  {"a:9.15.17.9", 78638, 2843},
  {"a:9.15.18.9", 78765, 2847},
  {"a:9.15.19.9", 78892, 2851},
  {"a:9.16.9", 79015, 2855}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 102, 3, 47, "Answer",
  Evaluatable->False],
Cell[1814, 54, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2409, 77, 170, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:9.9"],

Cell[CellGroupData[{
Cell[2604, 88, 324, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:9.10.9"],
Cell[2931, 101, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3782, 125, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5152, 167, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5304, 172, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5926, 194, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6618, 220, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6972, 235, 192, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:9.11.9"],
Cell[7167, 245, 158, 5, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7362, 255, 184, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:9.12.9"],
Cell[7549, 265, 222, 6, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7808, 276, 191, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:9.13.9"],
Cell[8002, 286, 371, 11, 52, "Text",
  Evaluatable->False],
Cell[8376, 299, 178, 4, 33, "Text",
  Evaluatable->False],
Cell[8557, 305, 131, 3, 43, "Input"],
Cell[8691, 310, 120, 2, 33, "Text",
  Evaluatable->False],
Cell[8814, 314, 1160, 21, 318, "Input"],
Cell[9977, 337, 151, 5, 33, "Text",
  Evaluatable->False],
Cell[10131, 344, 106, 2, 27, "Input"],
Cell[10240, 348, 1305, 44, 90, "Text",
  Evaluatable->False],
Cell[11548, 394, 184, 3, 59, "Input"],
Cell[11735, 399, 1811, 55, 90, "Text",
  Evaluatable->False],
Cell[13549, 456, 1716, 60, 109, "Text",
  Evaluatable->False],
Cell[15268, 518, 127, 3, 42, "Input"],
Cell[15398, 523, 397, 14, 33, "Text",
  Evaluatable->False],
Cell[15798, 539, 126, 3, 27, "Input"],
Cell[15927, 544, 789, 26, 86, "Question",
  Evaluatable->False],
Cell[16719, 572, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[16796, 576, 1235, 40, 109, "Text",
  Evaluatable->False],
Cell[18034, 618, 184, 4, 59, "Input"],
Cell[18221, 624, 785, 26, 67, "Question",
  Evaluatable->False],
Cell[19009, 652, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[19086, 656, 916, 33, 48, "Question",
  Evaluatable->False],
Cell[20005, 691, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[20082, 695, 1926, 69, 71, "Text",
  Evaluatable->False],
Cell[22011, 766, 185, 4, 59, "Input"],
Cell[22199, 772, 2093, 73, 90, "Text",
  Evaluatable->False],
Cell[24295, 847, 144, 3, 43, "Input"],
Cell[24442, 852, 109, 2, 33, "Text",
  Evaluatable->False],
Cell[24554, 856, 157, 3, 59, "Input"],
Cell[24714, 861, 170, 7, 33, "Text",
  Evaluatable->False],
Cell[24887, 870, 158, 3, 59, "Input"],
Cell[25048, 875, 1691, 59, 90, "Text",
  Evaluatable->False],
Cell[26742, 936, 595, 22, 67, "Question",
  Evaluatable->False],
Cell[27340, 960, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[27451, 967, 303, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:9.14.9"],
Cell[27757, 980, 1342, 46, 71, "Text",
  Evaluatable->False],
Cell[29102, 1028, 99, 2, 46, "Input"],
Cell[29204, 1032, 143, 5, 33, "Text",
  Evaluatable->False],
Cell[29350, 1039, 68, 2, 27, "Input"],
Cell[29421, 1043, 149, 5, 33, "Text",
  Evaluatable->False],
Cell[29573, 1050, 127, 3, 44, "Input"],
Cell[29703, 1055, 106, 2, 27, "Input"],
Cell[29812, 1059, 286, 8, 52, "Text",
  Evaluatable->False],
Cell[30101, 1069, 180, 4, 59, "Input"],
Cell[30284, 1075, 174, 5, 33, "Text",
  Evaluatable->False],
Cell[30461, 1082, 171, 4, 59, "Input"],
Cell[30635, 1088, 1683, 57, 105, "Question",
  Evaluatable->False],
Cell[32321, 1147, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32398, 1151, 1707, 59, 86, "Question",
  Evaluatable->False],
Cell[34108, 1212, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[34219, 1219, 427, 15, 35, "Section",
  Evaluatable->False,
  CellTags->"a:9.15.9"],
Cell[34649, 1236, 227, 6, 52, "Text",
  Evaluatable->False],
Cell[34879, 1244, 182, 4, 59, "Input"],

Cell[CellGroupData[{
Cell[35086, 1252, 138, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.10.9"],
Cell[35227, 1257, 1041, 35, 86, "Question",
  Evaluatable->False],
Cell[36271, 1294, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[36382, 1301, 136, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.11.9"],
Cell[36521, 1306, 1315, 45, 86, "Question",
  Evaluatable->False],
Cell[37839, 1353, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[37950, 1360, 146, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.12.9"],
Cell[38099, 1365, 272, 6, 71, "Text",
  Evaluatable->False],
Cell[38374, 1373, 153, 4, 43, "Input"],
Cell[38530, 1379, 900, 32, 67, "Question",
  Evaluatable->False],
Cell[39433, 1413, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[39510, 1417, 864, 31, 52, "Text",
  Evaluatable->False],
Cell[40377, 1450, 105, 3, 43, "Input"],
Cell[40485, 1455, 155, 7, 33, "Text",
  Evaluatable->False],
Cell[40643, 1464, 67, 2, 27, "Input"],
Cell[40713, 1468, 578, 21, 52, "Text",
  Evaluatable->False],
Cell[41294, 1491, 68, 2, 27, "Input"],
Cell[41365, 1495, 106, 2, 33, "Text",
  Evaluatable->False],
Cell[41474, 1499, 89, 2, 27, "Input"],
Cell[41566, 1503, 539, 15, 71, "Text",
  Evaluatable->False],
Cell[42108, 1520, 69, 1, 27, "Input"],
Cell[42180, 1523, 841, 18, 128, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[43058, 1546, 147, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.13.9"],
Cell[43208, 1551, 506, 12, 90, "Text",
  Evaluatable->False],
Cell[43717, 1565, 410, 11, 71, "Text",
  Evaluatable->False],
Cell[44130, 1578, 109, 2, 27, "Input"],
Cell[44242, 1582, 945, 33, 86, "Question",
  Evaluatable->False],
Cell[45190, 1617, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[45267, 1621, 481, 14, 86, "Question",
  Evaluatable->False],
Cell[45751, 1637, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[45828, 1641, 552, 18, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[46417, 1664, 792, 29, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.14.9"],
Cell[47212, 1695, 861, 28, 52, "Text",
  Evaluatable->False],
Cell[48076, 1725, 215, 5, 59, "Input"],
Cell[48294, 1732, 969, 31, 71, "Text",
  Evaluatable->False],
Cell[49266, 1765, 235, 6, 59, "Input"],
Cell[49504, 1773, 268, 6, 52, "Text",
  Evaluatable->False],
Cell[49775, 1781, 323, 9, 75, "Input"],
Cell[50101, 1792, 923, 32, 48, "Question",
  Evaluatable->False],
Cell[51027, 1826, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[51138, 1833, 794, 29, 33, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.15.9"],
Cell[51935, 1864, 2471, 80, 75, "Text",
  Evaluatable->False],
Cell[54409, 1946, 249, 6, 70, "Input"],
Cell[54661, 1954, 1036, 34, 88, "Question",
  Evaluatable->False],
Cell[55700, 1990, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[55811, 1997, 1015, 38, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.16.9"],
Cell[56829, 2037, 2026, 69, 90, "Text",
  Evaluatable->False],
Cell[58858, 2108, 2011, 70, 71, "Text",
  Evaluatable->False],
Cell[60872, 2180, 512, 11, 147, "Input"],
Cell[61387, 2193, 1982, 71, 105, "Question",
  Evaluatable->False],
Cell[63372, 2266, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[63483, 2273, 354, 13, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.17.9"],
Cell[63840, 2288, 1691, 55, 90, "Text",
  Evaluatable->False],
Cell[65534, 2345, 298, 7, 75, "Input"],
Cell[65835, 2354, 337, 12, 67, "Question",
  Evaluatable->False],
Cell[66175, 2368, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[66252, 2372, 92, 2, 33, "Text",
  Evaluatable->False],
Cell[66347, 2376, 262, 5, 43, "Input"],
Cell[66612, 2383, 332, 12, 48, "Question",
  Evaluatable->False],
Cell[66947, 2397, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[67058, 2404, 568, 20, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.18.9"],
Cell[67629, 2426, 203, 4, 52, "Text",
  Evaluatable->False],
Cell[67835, 2432, 1520, 58, 71, "Text",
  Evaluatable->False],
Cell[69358, 2492, 565, 20, 48, "Question",
  Evaluatable->False],
Cell[69926, 2514, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[70003, 2518, 503, 17, 52, "Text",
  Evaluatable->False],
Cell[70509, 2537, 80, 1, 27, "Input"],
Cell[70592, 2540, 814, 28, 52, "Text",
  Evaluatable->False],
Cell[71409, 2570, 71, 2, 27, "Input"],
Cell[71483, 2574, 603, 21, 52, "Text",
  Evaluatable->False],
Cell[72089, 2597, 150, 4, 43, "Input"],
Cell[72242, 2603, 106, 2, 33, "Text",
  Evaluatable->False],
Cell[72351, 2607, 54, 1, 27, "Input"],
Cell[72408, 2610, 70, 2, 27, "Input"],
Cell[72481, 2614, 75, 2, 27, "Input"],
Cell[72559, 2618, 403, 13, 67, "Question",
  Evaluatable->False],
Cell[72965, 2633, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[73042, 2637, 655, 22, 67, "Question",
  Evaluatable->False],
Cell[73700, 2661, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[73811, 2668, 122, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:9.15.19.9"],
Cell[73936, 2673, 365, 8, 71, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[74350, 2687, 371, 14, 35, "Section",
  Evaluatable->False,
  CellTags->"a:9.16.9"],
Cell[74724, 2703, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[75069, 2714, 49, 1, 27, "Input"],
Cell[75121, 2717, 54, 1, 27, "Input"],
Cell[75178, 2720, 50, 1, 27, "Input"],
Cell[75231, 2723, 50, 1, 27, "Input"],
Cell[75284, 2726, 51, 1, 27, "Input"],
Cell[75338, 2729, 52, 1, 27, "Input"],
Cell[75393, 2732, 52, 1, 27, "Input"],
Cell[75448, 2735, 50, 1, 27, "Input"],
Cell[75501, 2738, 49, 1, 27, "Input"],
Cell[75553, 2741, 47, 1, 27, "Input"],
Cell[75603, 2744, 48, 1, 27, "Input"],
Cell[75654, 2747, 53, 1, 27, "Input"],
Cell[75710, 2750, 52, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

