(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     60153,       2265]*)
(*NotebookOutlinePosition[     63327,       2370]*)
(*  CellTagsIndexPosition[     62875,       2352]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->GrayLevel[0]],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 10",
    FontSize->18],
  "\nQuotient Rings of Polynomials"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.10"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.11.10"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.12.10"],

Cell["\<\
To complete this lab, you should be familiar with the ring of \
polynomials over a field, the division property for polynomials over a field, \
and the definitions of homomorphism, kernel, and ideal. Finally, you should \
be familiar with the First Isomorphism Theorem for ring homomorphisms (Ring \
Lab 5). \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.13.10"],

Cell["\<\
Extensions of finite fields are generally motivated by the need to \
solve polynomial equations. These extensions are actually quite concrete in \
the sense that they arise from quotient rings, where the ideal from which \
cosets are formed is the kernel of a familiar homomorphism. In this case, the \
homomorphism is the remainder function for division by a fixed polynomial \
(the modulus). In this lab we introduce quotient rings, and in Ring Lab 11 we \
explore how they are used to construct roots of polynomials.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Polynomials over a field"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.14.10"],

Cell[TextData[{
  StyleBox["First we read in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" code we need for this lab.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Given any field, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["F", TraditionalForm]]],
  StyleBox[
  ", we ultimately want to be able to solve any polynomial equation over it. \
For example, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["F", TraditionalForm]]],
  StyleBox[" might be the integers modulo 3.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(F = Z[3]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["It is clear, by simple hand-evaluation of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m(x) = x\^2 + x + 2\)]],
  StyleBox[", that none of the elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" are roots of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m(x)\)]],
  StyleBox[". This can also be done using just the built-in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" functions. First define the polynomial function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[m1, x]\), 
    \(m1[x_] := x\^2 + x + 2\ 
    \n (*\ we\ call\ it\ m1\ here\ because\ we\ use\ m\ below\ *) \)}], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Then evaluate the function at each element in ",
  Cell[BoxData[
      FormBox["F", TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \({m1[0], m1[1], m1[2]}\)], "Input",
  AspectRatioFixed->True],

Cell["For larger fields, it may be easier to do this another way.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\ Map[m1, \ Elements[F]]\)\)], "Input"],

Cell["Reducing mod 3 (recall what ring we are in), we get", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Mod[%, 3]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why does this last output show that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"m", "(", "x", ")"}], TraditionalForm]]],
  StyleBox[" does not have any roots in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["F", TraditionalForm]]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "We can also use the functions built into the packages that were read in. \
First define the polynomial over ",
  Cell[BoxData[
      FormBox["F", TraditionalForm]]],
  " using the ",
  StyleBox["Poly",
    FontFamily->"Courier"],
  " function."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(m = Poly[F, x\^2 + x + 2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Then use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialEvaluation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function on the domain elements.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[PolynomialEvaluation[m, \ #]&, \ Elements[F]]\)], "Input"],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Does the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m(x) - 1\)]],
  StyleBox[" (which is really ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m(x) + 2\)]],
  StyleBox[") have any roots in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "We conclude that the field ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " does ",
  StyleBox["not",
    FontSlant->"Italic"],
  " contain the roots of ",
  Cell[BoxData[
      \(TraditionalForm\`m(x)\)]],
  ". In this lab we concentrate on the construction of a field that contains \
the roots of ",
  Cell[BoxData[
      \(TraditionalForm\`m(x)\)]],
  ". In Ring Lab 11 we discuss the factorization of ",
  Cell[BoxData[
      \(TraditionalForm\`m(x)\)]],
  " in this new field, along with other issues involving finite field \
extensions. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "We use ",
  Cell[BoxData[
      FormBox["V", TraditionalForm]]],
  " to denote the smallest extension of ",
  Cell[BoxData[
      FormBox["F", TraditionalForm]]],
  " that contains all the roots of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"m", "(", "x", ")"}], TraditionalForm]]],
  ". The first step in constructing ",
  Cell[BoxData[
      FormBox["V", TraditionalForm]]],
  " is to consider the whole ring of polynomials over ",
  Cell[BoxData[
      FormBox["F", TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(P = PolynomialsOver[F]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". In the packages these labs are based on, a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " has three arguments: the list of elements, the addition function, and the \
multiplication function. Why isn",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[" a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ringoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" in this sense? Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[" a ring?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "A homomorphism based on ",
  StyleBox["PolynomialRemainder",
    FontFamily->"Courier"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.15.10"],

Cell[TextData[{
  StyleBox["The homomorphism ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" that we consider here depends on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[". If the definition of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[
  " is altered, a different homomorphism and, at least superficially, a \
different extension is constructed. Generally, the smallest degree we \
consider for the polynomial function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" is two, as in this example.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" takes any polynomial in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["P", TraditionalForm]]],
  StyleBox[
  " and returns the polynomial that is the remainder on division by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["m", TraditionalForm]]],
  StyleBox[" (our polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["x", "2"], "+", "x", "+", "2"}], TraditionalForm]]],
  StyleBox["). ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta] = PolynomialRemainder[P, #, m]&\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["You may wish to remind yourself how the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialRemainder",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" works.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?PolynomialRemainder\)\)], "Input"],

Cell[TextData[{
  StyleBox["For a quick test of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[", let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s apply it to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" and to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m + 1 = x\^2 + x\)]],
  StyleBox[" . (Think about the answer before evaluating.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\[Theta][m]\), 
    \(\[Theta][Poly[F, x\^2 + x]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". \ta. What happens when we apply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m*x + 2 = x\^3 + x\^2 + 2  x + 2\)]],
  StyleBox[
  "? Think about it and then calculate it.\n\tb. What happens when we apply ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m*\((x + 2)\) + x\)]],
  StyleBox["? Think about it and then calculate it.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "The division property of polynomials over a field assures us that the \
remainder (the value of our function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[") will have its degree less than the divisor",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s degree. So in our examples, the remainders are all linear polynomials. \
To illustrate with a computation, we take ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["some",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of the elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[", the ones of degree three or less, and map the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialRemainder",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[
  " over them. (Note: If your computer is relatively slow, you may want to \
change the following expression to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SomePolynomials = PolynomialsUpToDegreeN[F, 2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", generating only polynomials of degree two or less.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SomePolynomials = PolynomialsUpToDegreeN[F, 3]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Next we map ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[
  " over this list. Duplicate images are removed and we can verify by \
examination that all nine linear polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[DoubleStruckCapitalZ]", "3"], TraditionalForm]]],
  StyleBox[" are in this list.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta]Range\  = \ Map[\[Theta], \ SomePolynomials] // Union\)], 
  "Input"],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why are there nine possible remainders? If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"m", "(", "x", ")"}], TraditionalForm]]],
  StyleBox[
  " were a cubic (instead of a quadratic) polynomial, how many different \
elements would be in the range of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[
  "? (In other words, how many different remainders would there be if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"m", "(", "x", ")"}], TraditionalForm]]],
  StyleBox[" were a cubic?)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s review what we have done. Since the set of all polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" (which we call ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[") is infinite in size, we cannot apply our function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" to the whole of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[". So we took a finite subset of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SomePolynomials",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[LongDash]those of degree less than four) and applied ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" to this subset to get a sense of how ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" worked. The result over this set is the set we called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox["Range",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". We now rename this set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["linPolys",
    FontFamily->"Courier"],
  StyleBox[", which is the set of linear polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(linPolys = \[Theta]Range\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["By considering ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" as a function from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[" into the linear polynomials (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["linPolys",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["), we want to establish ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" as a homomorphism. For ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[
  " to be a homomorphism, more fundamental than showing that the operations \
are preserved, is the need to make sure that both the domain and codomain are \
rings. The domain is clearly a ring",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[LongDash]",
  StyleBox["it is the ring of polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[". It is not so clear that the set of remainders, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["linPolys",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", is also a ring. How should addition and multiplication be defined? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Consider the set of remainders from division by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m(x)\)]],
  ", ",
  StyleBox["linPolys",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". Why can",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t the usual polynomial multiplication be used on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["linPolys",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to form a ring?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "The First Homomorphism Theorem gives us a clue how to operate in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["linPolys",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". This is because the range is isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P/K\)]],
  StyleBox[", where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K\)]],
  StyleBox[" is the kernel of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[". Recall that given an isomorphism ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{\(f : R\), 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], "S"}], TraditionalForm]]],
  StyleBox[", the inverse map (which exists, since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is a bijection), ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(f\^\(-1\)\) : S\), 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], "R"}], TraditionalForm]]],
  StyleBox[
  ", is also an isomorphism. We want to consider this inverse isomorphism, \
the function that maps an element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["linPolys",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to the coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g + K\)]],
  " in",
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P/K\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Here are the elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["K", TraditionalForm]]],
  StyleBox[" that come from the list ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SomePolynomials",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". Note that they are obtained by selecting those whose image under ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" is the zero of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["P", TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(partialK = Select[SomePolynomials, \[Theta][#] == Zero[P]&]\)], "Input",\

  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What do these polynomials all have in common? For a hint, take one of \
these polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["F", TraditionalForm]]],
  StyleBox[" (remember, they were all formed with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Poly",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[") and try the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialDivision",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function on it with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"m", "(", "x", ")"}], TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?PolynomialDivision\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(\(p\  = \ partialK[\([1]\)]\)\ \nPolynomialDivision[p, \ m]\),
      AspectRatioFixed->True]], "Input"],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s take a pair of elements from ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " and form two cosets from them. We select polynomials that are also in ",
  StyleBox["linPolys",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  " so that the sum and product of their cosets give us a hint at how \
addition and multiplication are defined in ",
  StyleBox["linPolys",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p = Poly[F, x + 1]\), 
    \(q = Poly[F, 2\ x + 1]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["K", TraditionalForm]]],
  StyleBox[
  " is infinite (you should ask yourself why this is true), we cannot form \
the full coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"p", "+", "K"}], TraditionalForm]]],
  StyleBox[", but we can form a portion of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"p", "+", "K"}], TraditionalForm]]],
  StyleBox[" by using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["partialK",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(pCoset\  = \ Map[\(Addition[P]\)[p, \ #]&, \ partialK]\)], "Input"],

Cell[TextData[{
  "We do the same for ",
  Cell[BoxData[
      \(TraditionalForm\`q + K\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(qCoset\  = \ Map[\(Addition[P]\)[q, \ #]&, \ partialK]\)], "Input"],

Cell[TextData[{
  StyleBox["We add the two cosets by adding arbitrary representatives of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["pcoset",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["qcoset",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". There are many possibilities here, but the easiest pair to add is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(sum = \(Addition[P]\)[p, q]\), 
    \(\[Theta][sum]\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
Now we pick random representatives and go through the same process.\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Print["\<Rep. from pCoset: \>", pRep = RandomElement[pCoset]]\), 
    \(Print["\<Rep. from qCoset: \>", qRep = RandomElement[qCoset]]\), 
    \(Print["\<Sum in P: \>", sum = \(Addition[P]\)[pRep, qRep]]\), 
    \(Print["\<Image of this sum under \[Theta]: \>", \[Theta][sum]]\)}], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Consider three more pairs of representatives from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["pCoset",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["qCoset",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" by evaluating the cell three more times. What do you observe?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". By changing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Addition",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Multiplication",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", multiply several random pairs of representatives as in the previous \
exercise. (See below.) What do you observe? Do the same using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" as representatives.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Print["\<Rep. from pCoset: \>", pRep = RandomElement[pCoset]]\), 
    \(Print["\<Rep. from qCoset: \>", qRep = RandomElement[qCoset]]\), 
    \(Print["\<Product in P: \>", prod = \(Multiplication[P]\)[pRep, qRep]]
      \), 
    \(Print["\<Image of this product under \[Theta]: \>", \[Theta][prod]]
      \)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "It can be proven that the observations that you (hopefully) made are not \
coincidence. It is reasonable to consider that the sum of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " is 2 and their product is an \[OpenCurlyDoubleQuote]obvious value.\
\[CloseCurlyDoubleQuote] The general definitions of the operations on ",
  StyleBox["linPolys",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  " are based on these observations."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Defining a quotient ring of polynomials"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.16.10"],

Cell[TextData[{
  StyleBox["For any polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"m", "=", 
          RowBox[{
            StyleBox["Poly",
              FontFamily->"Courier"], "[", \(R, 
            \(a\_n\) x\^n + \(a\_\(n - 1\)\) x\^\(n - 1\) + 
              \[CenterEllipsis] + \(a\_2\) x\^2 + \(a\_1\) x + a\_0\), 
            "]"}]}], TraditionalForm]]],
  StyleBox[", with each ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\_i\)]],
  StyleBox[" in some ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" with unity, the expression ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["QuotientRing[R, m]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" generates a quotient ring of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["modulus",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[
  ". The elements of the ring are the polynomials of degree less than the \
degree of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[". With ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" defined above, we define ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" to be the quotient ring of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(V = QuotientRing[F, m]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["10.5.1 Addition", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.16.11.10"],

Cell[TextData[{
  "Addition in ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is simply addition of polynomials. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \({p, q} = {Poly[F, 2\ x + 1], Poly[F, 2\ x]}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Addition[V]\)[p, q]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s try this addition with a few random pairs."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \({p, q} = RandomElements[V, 2]\), 
    \(\(Addition[V]\)[p, q]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" closed under the usual addition of polynomials?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["10.5.2 Multiplication", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.16.12.10"],

Cell[TextData[{
  StyleBox["Multiplication in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" is much like multiplication on the integers mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[". To multiply polynomials ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[", you perform the usual multiplication (as in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[
  ") and then divide by the modulus, retaining the remainder for the value of \
the product. In other words, you apply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" to the product. For example,",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p = Poly[F, x + 1]\), 
    \(q = Poly[F, x + 2]\), 
    \(r = \(Multiplication[P]\)[p, q]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta][r]\)], "Input",
  AspectRatioFixed->True],

Cell["This result, of course, can also be achieved as follows.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Multiplication[V]\)[p, q]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Remember, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Theta](r)\)]],
  StyleBox[" is computed by dividing the product, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[", by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[
  " and then returning the remainder. The complete division result, quotient \
and remainder, is given by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialDivision",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". (However, only the remainder is used for the product in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PolynomialDivision[P, r, m, Mode \[Rule] Textual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Compute the following in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[":\n\ta. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((2  x + 1)\) + \((x + 2)\)\)]],
  StyleBox["\n\tb. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x  x = x\^2\)]],
  StyleBox[" \n\tc. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x  x  x  x = x\^4\)]],
  StyleBox["\n\td. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x  x  x  x  x  x  x  x = x\^8\)]],
  StyleBox["\n\te. multiplicative inverse of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x + 1\)]]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "The ",
  StyleBox["PolynomialRemainder",
    FontFamily->"Courier"],
  " function \[Theta] is indeed a homomorphism"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.17.10"],

Cell[TextData[{
  StyleBox["Now that we have established the operations on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[", we can verify that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[
  " is a homomorphism. Here we verify only that the homomorphism properties \
are true for a pair of random third degree elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \({p, q} = Table[RandomElement[P, 3], {2}]\)], "Input",
  AspectRatioFixed->True],

Cell["First the addition property,", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta][\(Addition[P]\)[p, q]] == 
      \(Addition[V]\)[\[Theta][p], \[Theta][q]]\)], "Input",
  AspectRatioFixed->True],

Cell["then the multiplication property,", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta][\(Multiplication[P]\)[p, q]] == 
      \(Multiplication[V]\)[\[Theta][p], \[Theta][q]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Repeat these steps several times. Are you convinced that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta] ",
  StyleBox["is a homomorphism? Why?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Consider the situation where the multiplication on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" is defined to be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Multiplication[V][p, q] = 0",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" (with no change to the addition). Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[Theta]",
  StyleBox[" still a homomorphism? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.7 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Is V a field?"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.18.10"],

Cell[TextData[{
  "You probably have seen a theorem that states that the range or image of a \
(commutative) ring under a homomorphism is a (commutative) ring. Therefore, ",
  
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " is a commutative ring. To show that it is also a field, we need to verify \
that it has a unity and that every nonzero element has an inverse. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Does ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" have a unity? If so, what is it and why is it the unity? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". While we",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["re at it, does ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" have a zero? If so, what is it and why is it the zero? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Therefore, we know that ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " has most of the field properties. The multiplication table for ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " can answer the question regarding multiplicative inverses."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(MultiplicationTable[V, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q16",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" a field? On what do you base your conclusion?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.8 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Is V what we claimed?"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.19.10"],

Cell[TextData[{
  "Recall that at the outset we claimed that we would find a field (and call \
it ",
  Cell[BoxData[
      FormBox["V", TraditionalForm]]],
  ") that would be the smallest field containing all the roots of ",
  Cell[BoxData[
      FormBox[
        RowBox[{"m", "=", 
          RowBox[{
            SuperscriptBox["x", "2"], "+", "x", "+", "2"}]}], 
        TraditionalForm]]],
  ". We have defined ",
  Cell[BoxData[
      FormBox["V", TraditionalForm]]],
  ", but we have not yet shown that it contains any roots of ",
  Cell[BoxData[
      FormBox["m", TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "It is also true that we can do addition and multiplication in ",
  Cell[BoxData[
      FormBox["V", TraditionalForm]]],
  ". Therefore, we should be able to take any element in ",
  Cell[BoxData[
      FormBox["V", TraditionalForm]]],
  ", square it, add this to itself, and then add the constant polynomial 2 to \
this result. In other words, we should be able to do arithmetic in this \
field."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Next we define a function ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " that does what we indicated in the previous paragraph."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f, y]\), 
    \(f[y_] := 
      \(Multiplication[V]\)[y, y] + y + 
        Poly[F, 2, Indeterminate \[Rule] x]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q17",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What connection is there between the polynomial function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"m", "=", 
          RowBox[{
            SuperscriptBox["x", "2"], "+", "x", "+", "2"}]}], 
        TraditionalForm]]],
  StyleBox[" defined at the outset and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["f", TraditionalForm]]],
  StyleBox["? Justify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now we want to evaluate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["f", TraditionalForm]]],
  StyleBox[" at each of the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["V", TraditionalForm]]],
  StyleBox[". In other words, we want to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Map",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["f", TraditionalForm]]],
  StyleBox[" over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["V", TraditionalForm]]],
  StyleBox[". We form pairs of the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{"x", ",", 
            RowBox[{"f", "(", "x", ")"}]}], "}"}], TraditionalForm]]],
  StyleBox[
  " so that we can see the domain elements that create the range elements.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Map[{#, f[#]}&, Elements[V]]", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Note that two elements, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Poly[F, x]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Poly[F, 2x + 2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", yield zero.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(root1 = Poly[F, x]\), 
    \(root2 = Poly[F, 2\ x + 2]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f[root1]\), 
    \(f[root2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q18",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Does the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" we created have all the roots of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox["? Could ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  StyleBox[" have more than two roots over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox["? (Remember that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[
  " is an integral domain, since it is a field.) Is it possible that a \
smaller field contains these roots? Justify your answers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["10.9 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:10.20.10"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Z", "Input",
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell["?Mod", "Input",
  AspectRatioFixed->True],

Cell["?Poly", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialEvaluation", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialsOver", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialRemainder", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialsUpToDegreeN", "Input",
  AspectRatioFixed->True],

Cell["?Map", "Input",
  AspectRatioFixed->True],

Cell["?Select", "Input",
  AspectRatioFixed->True],

Cell["?PolynomialDivision", "Input",
  AspectRatioFixed->True],

Cell["?Addition", "Input",
  AspectRatioFixed->True],

Cell["?Multiplication", "Input",
  AspectRatioFixed->True],

Cell["?RandomElement", "Input",
  AspectRatioFixed->True],

Cell["?RandomElements", "Input",
  AspectRatioFixed->True],

Cell["?QuotientRing", "Input",
  AspectRatioFixed->True],

Cell["?MultiplicationTable", "Input",
  AspectRatioFixed->True],

Cell["?Indeterminate", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{621, 431},
WindowMargins->{{5, Automatic}, {Automatic, 5}},
PrintingStartingPageNumber->86,
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:10.10"->{
    Cell[2409, 77, 180, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:10.10"]},
  "a:10.11.10"->{
    Cell[2614, 88, 327, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:10.11.10"]},
  "a:10.12.10"->{
    Cell[6985, 235, 195, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:10.12.10"]},
  "a:10.13.10"->{
    Cell[7600, 258, 187, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:10.13.10"]},
  "a:10.14.10"->{
    Cell[8418, 283, 206, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:10.14.10"]},
  "a:10.15.10"->{
    Cell[16260, 594, 268, 10, 35, "Section",
      Evaluatable->False,
      CellTags->"a:10.15.10"]},
  "a:10.16.10"->{
    Cell[38833, 1424, 221, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:10.16.10"]},
  "a:10.16.11.10"->{
    Cell[41485, 1526, 114, 3, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:10.16.11.10"]},
  "a:10.16.12.10"->{
    Cell[42771, 1582, 120, 3, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:10.16.12.10"]},
  "a:10.17.10"->{
    Cell[46734, 1732, 297, 11, 78, "Section",
      Evaluatable->False,
      CellTags->"a:10.17.10"]},
  "a:10.18.10"->{
    Cell[49901, 1856, 195, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:10.18.10"]},
  "a:10.19.10"->{
    Cell[52618, 1964, 203, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:10.19.10"]},
  "a:10.20.10"->{
    Cell[58348, 2182, 374, 14, 35, "Section",
      Evaluatable->False,
      CellTags->"a:10.20.10"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:10.10", 61291, 2296},
  {"a:10.11.10", 61404, 2300},
  {"a:10.12.10", 61523, 2304},
  {"a:10.13.10", 61642, 2308},
  {"a:10.14.10", 61761, 2312},
  {"a:10.15.10", 61880, 2316},
  {"a:10.16.10", 62001, 2320},
  {"a:10.16.11.10", 62125, 2324},
  {"a:10.16.12.10", 62255, 2328},
  {"a:10.17.10", 62382, 2332},
  {"a:10.18.10", 62504, 2336},
  {"a:10.19.10", 62625, 2340},
  {"a:10.20.10", 62746, 2344}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 102, 3, 47, "Answer",
  Evaluatable->False],
Cell[1814, 54, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2409, 77, 180, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:10.10"],

Cell[CellGroupData[{
Cell[2614, 88, 327, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:10.11.10"],
Cell[2944, 101, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3795, 125, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5165, 167, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5317, 172, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5939, 194, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6631, 220, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6985, 235, 195, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:10.12.10"],
Cell[7183, 245, 380, 8, 90, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7600, 258, 187, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:10.13.10"],
Cell[7790, 268, 591, 10, 128, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8418, 283, 206, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:10.14.10"],
Cell[8627, 293, 362, 13, 33, "Text",
  Evaluatable->False],
Cell[8992, 308, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[9166, 314, 529, 18, 52, "Text",
  Evaluatable->False],
Cell[9698, 334, 67, 2, 27, "Input"],
Cell[9768, 338, 867, 28, 71, "Text",
  Evaluatable->False],
Cell[10638, 368, 178, 5, 61, "Input"],
Cell[10819, 375, 188, 7, 33, "Text",
  Evaluatable->False],
Cell[11010, 384, 80, 2, 27, "Input"],
Cell[11093, 388, 123, 2, 33, "Text",
  Evaluatable->False],
Cell[11219, 392, 61, 1, 27, "Input"],
Cell[11283, 395, 115, 2, 33, "Text",
  Evaluatable->False],
Cell[11401, 399, 68, 2, 27, "Input"],
Cell[11472, 403, 587, 21, 48, "Question",
  Evaluatable->False],
Cell[12062, 426, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[12139, 430, 323, 11, 52, "Text",
  Evaluatable->False],
Cell[12465, 443, 84, 2, 31, "Input"],
Cell[12552, 447, 371, 13, 33, "Text",
  Evaluatable->False],
Cell[12926, 462, 82, 1, 27, "Input"],
Cell[13011, 465, 663, 25, 48, "Question",
  Evaluatable->False],
Cell[13677, 492, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[13754, 496, 629, 21, 71, "Text",
  Evaluatable->False],
Cell[14386, 519, 580, 20, 52, "Text",
  Evaluatable->False],
Cell[14969, 541, 81, 2, 27, "Input"],
Cell[15053, 545, 1093, 40, 86, "Question",
  Evaluatable->False],
Cell[16149, 587, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[16260, 594, 268, 10, 35, "Section",
  Evaluatable->False,
  CellTags->"a:10.15.10"],
Cell[16531, 606, 857, 28, 90, "Text",
  Evaluatable->False],
Cell[17391, 636, 790, 28, 52, "Text",
  Evaluatable->False],
Cell[18184, 666, 99, 2, 27, "Input"],
Cell[18286, 670, 380, 13, 33, "Text",
  Evaluatable->False],
Cell[18669, 685, 57, 1, 27, "Input"],
Cell[18729, 688, 656, 24, 52, "Text",
  Evaluatable->False],
Cell[19388, 714, 110, 3, 47, "Input"],
Cell[19501, 719, 845, 30, 105, "Question",
  Evaluatable->False],
Cell[20349, 751, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[20426, 755, 1589, 50, 147, "Text",
  Evaluatable->False],
Cell[22018, 807, 105, 2, 27, "Input"],
Cell[22126, 811, 549, 18, 52, "Text",
  Evaluatable->False],
Cell[22678, 831, 97, 2, 27, "Input"],
Cell[22778, 835, 875, 29, 86, "Question",
  Evaluatable->False],
Cell[23656, 866, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[23733, 870, 1950, 68, 109, "Text",
  Evaluatable->False],
Cell[25686, 940, 83, 2, 27, "Input"],
Cell[25772, 944, 1534, 50, 128, "Text",
  Evaluatable->False],
Cell[27309, 996, 857, 31, 67, "Question",
  Evaluatable->False],
Cell[28169, 1029, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[28246, 1033, 2094, 74, 109, "Text",
  Evaluatable->False],
Cell[30343, 1109, 785, 28, 52, "Text",
  Evaluatable->False],
Cell[31131, 1139, 120, 3, 27, "Input"],
Cell[31254, 1144, 1042, 37, 86, "Question",
  Evaluatable->False],
Cell[32299, 1183, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32376, 1187, 56, 1, 27, "Input"],
Cell[32435, 1190, 132, 2, 43, "Input"],
Cell[32570, 1194, 588, 18, 71, "Text",
  Evaluatable->False],
Cell[33161, 1214, 111, 3, 43, "Input"],
Cell[33275, 1219, 880, 32, 52, "Text",
  Evaluatable->False],
Cell[34158, 1253, 87, 1, 27, "Input"],
Cell[34248, 1256, 158, 7, 33, "Text",
  Evaluatable->False],
Cell[34409, 1265, 87, 1, 27, "Input"],
Cell[34499, 1268, 855, 31, 52, "Text",
  Evaluatable->False],
Cell[35357, 1301, 112, 3, 43, "Input"],
Cell[35472, 1306, 141, 5, 33, "Text",
  Evaluatable->False],
Cell[35616, 1313, 339, 6, 75, "Input"],
Cell[35958, 1321, 702, 24, 67, "Question",
  Evaluatable->False],
Cell[36663, 1347, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[36740, 1351, 1000, 36, 86, "Question",
  Evaluatable->False],
Cell[37743, 1389, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[37820, 1393, 366, 7, 75, "Input"],
Cell[38189, 1402, 607, 17, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[38833, 1424, 221, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:10.16.10"],
Cell[39057, 1434, 2319, 84, 90, "Text",
  Evaluatable->False],
Cell[41379, 1520, 81, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[41485, 1526, 114, 3, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:10.16.11.10"],
Cell[41602, 1531, 182, 7, 33, "Text",
  Evaluatable->False],
Cell[41787, 1540, 102, 2, 27, "Input"],
Cell[41892, 1544, 80, 2, 27, "Input"],
Cell[41975, 1548, 140, 3, 33, "Text",
  Evaluatable->False],
Cell[42118, 1553, 122, 3, 43, "Input"],
Cell[42243, 1558, 414, 15, 48, "Question",
  Evaluatable->False],
Cell[42660, 1575, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[42771, 1582, 120, 3, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:10.16.12.10"],
Cell[42894, 1587, 1096, 37, 90, "Text",
  Evaluatable->False],
Cell[43993, 1626, 150, 4, 59, "Input"],
Cell[44146, 1632, 70, 2, 27, "Input"],
Cell[44219, 1636, 120, 2, 33, "Text",
  Evaluatable->False],
Cell[44342, 1640, 86, 2, 27, "Input"],
Cell[44431, 1644, 1016, 35, 71, "Text",
  Evaluatable->False],
Cell[45450, 1681, 108, 2, 27, "Input"],
Cell[45561, 1685, 1047, 37, 143, "Question",
  Evaluatable->False],
Cell[46611, 1724, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[46734, 1732, 297, 11, 78, "Section",
  Evaluatable->False,
  CellTags->"a:10.17.10"],
Cell[47034, 1745, 658, 22, 71, "Text",
  Evaluatable->False],
Cell[47695, 1769, 99, 2, 27, "Input"],
Cell[47797, 1773, 92, 2, 33, "Text",
  Evaluatable->False],
Cell[47892, 1777, 142, 3, 27, "Input"],
Cell[48037, 1782, 97, 2, 33, "Text",
  Evaluatable->False],
Cell[48137, 1786, 154, 3, 27, "Input"],
Cell[48294, 1791, 406, 14, 48, "Question",
  Evaluatable->False],
Cell[48703, 1807, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[48780, 1811, 1007, 36, 86, "Question",
  Evaluatable->False],
Cell[49790, 1849, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[49901, 1856, 195, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:10.18.10"],
Cell[50099, 1866, 433, 10, 90, "Text",
  Evaluatable->False],
Cell[50535, 1878, 422, 15, 48, "Question",
  Evaluatable->False],
Cell[50960, 1895, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[51037, 1899, 530, 19, 48, "Question",
  Evaluatable->False],
Cell[51570, 1920, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[51647, 1924, 335, 10, 52, "Text",
  Evaluatable->False],
Cell[51985, 1936, 108, 2, 27, "Input"],
Cell[52096, 1940, 408, 15, 48, "Question",
  Evaluatable->False],
Cell[52507, 1957, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[52618, 1964, 203, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:10.19.10"],
Cell[52824, 1974, 656, 21, 71, "Text",
  Evaluatable->False],
Cell[53483, 1997, 475, 12, 71, "Text",
  Evaluatable->False],
Cell[53961, 2011, 215, 7, 33, "Text",
  Evaluatable->False],
Cell[54179, 2020, 177, 5, 43, "Input"],
Cell[54359, 2027, 708, 24, 67, "Question",
  Evaluatable->False],
Cell[55070, 2053, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[55147, 2057, 1211, 42, 71, "Text",
  Evaluatable->False],
Cell[56361, 2101, 71, 1, 27, "Input"],
Cell[56435, 2104, 535, 20, 33, "Text",
  Evaluatable->False],
Cell[56973, 2126, 115, 3, 43, "Input"],
Cell[57091, 2131, 88, 3, 43, "Input"],
Cell[57182, 2136, 1052, 37, 86, "Question",
  Evaluatable->False],
Cell[58237, 2175, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[58348, 2182, 374, 14, 35, "Section",
  Evaluatable->False,
  CellTags->"a:10.20.10"],
Cell[58725, 2198, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[59070, 2209, 45, 1, 27, "Input"],
Cell[59118, 2212, 52, 1, 27, "Input"],
Cell[59173, 2215, 47, 1, 27, "Input"],
Cell[59223, 2218, 48, 1, 27, "Input"],
Cell[59274, 2221, 64, 1, 27, "Input"],
Cell[59341, 2224, 59, 1, 27, "Input"],
Cell[59403, 2227, 63, 1, 27, "Input"],
Cell[59469, 2230, 66, 1, 27, "Input"],
Cell[59538, 2233, 47, 1, 27, "Input"],
Cell[59588, 2236, 50, 1, 27, "Input"],
Cell[59641, 2239, 62, 1, 27, "Input"],
Cell[59706, 2242, 52, 1, 27, "Input"],
Cell[59761, 2245, 58, 1, 27, "Input"],
Cell[59822, 2248, 57, 1, 27, "Input"],
Cell[59882, 2251, 58, 1, 27, "Input"],
Cell[59943, 2254, 56, 1, 27, "Input"],
Cell[60002, 2257, 63, 1, 27, "Input"],
Cell[60068, 2260, 57, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

