(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     48796,       1849]*)
(*NotebookOutlinePosition[     51055,       1925]*)
(*  CellTagsIndexPosition[     50795,       1913]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 13",
    FontSize->18],
  "\nFinite Fields"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.13"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.14.13"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.15.13"],

Cell[TextData[{
  "To complete this lab, you should be familiar with the construction of a \
quotient ring of a ring of polynomials over a field ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ", as described in Ring Lab 10. You should also be familiar with ",
  StyleBox["Morphoids",
    FontFamily->"Courier"],
  " of rings."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  CellMargins->{{Inherited, 72}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.16.13"],

Cell[TextData[{
  StyleBox[
  "The goal of this lab is to introduce some of the properties of finite \
fields. Until now, we have mostly explored the general situation of \
polynomials over a ring mod an arbitrary polynomial. Now we assume that the \
base ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "ring",
  StyleBox[
  " is a field and that the polynomial is irreducible over that field. These \
assumptions are made easier to enforce by using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FiniteFields",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" package in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Creation of finite fields"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.17.13"],

Cell[TextData[{
  StyleBox["First we make sure that the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" packages are available and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rings",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DefaultStructure",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Rings]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The package ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra`FiniteFields.m",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" generates finite fields",
    Evaluatable->False,
    AspectRatioFixed->True],
  " in a fashion similar to the way",
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["QuotientRing",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " does but with restrictions on the allowable inputs so that only fields \
are generated. For example, the ring of polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[" mod the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 2\)]],
  StyleBox[" can be created with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["QuotientRing",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". It has ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`3\^2 = 9\)]],
  StyleBox[" elements.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[x]\), 
    \(R = QuotientRing[Z[3], Poly[Z[3], x\^2 + 2]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["As we can see by the result of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Inverses",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[" is not a field.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Inverses[R, Operation \[Rule] Multiplication]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This",
    Evaluatable->False,
    AspectRatioFixed->True],
  " is because",
  StyleBox[" the modulus polynomial, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 2\)]],
  StyleBox[", can be factored as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((x + 1)\) \((x + 2)\)\)]],
  StyleBox[" over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[". The built-in function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Factor",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" can show this.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Factor[x\^2 + 2, Modulus \[Rule] 3]\)], "Input",
  AspectRatioFixed->True],

Cell["We can also verify this reducibility as follows.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(IrreduciblePolyOverZpQ[Poly[Z[3], x\^2 + 2], 3]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The ring ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " has zero divisors. For example, the product of ",
  Cell[BoxData[
      \(TraditionalForm\`x + 1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x + 2\)]],
  " is 0."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Multiplication[R]\)[Poly[Z[3], x + 1], Poly[Z[3], x + 2]]\)], "Input",\

  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Evaluate the following cell, which creates the multiplication table for \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[". Are there any other zero divisors?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(MultiplicationTable[R, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "In the rest of this lab we can avoid this type of ring by using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF[n]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" returns the Galois field ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "(hence, GF) ",
  StyleBox["of order ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" (if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n = p\^d\)]],
  StyleBox[" for some prime ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox["), while ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF[n, poly]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " creates the finite field using the specified irreducible polynomial. Here \
is a field with nine elements. They are the same polynomials of degree one or \
less that are contained in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  StyleBox[", but the multiplication operation is different",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[F]\), 
    \(F\_1 = GF[9]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\_1\)]],
  StyleBox[", the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "product of ",
  Cell[BoxData[
      \(TraditionalForm\`x + 1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x + 2\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" zero.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Multiplication[F\_1]\)[x + 1, x + 2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Another advantage to using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is that the elements of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "ring",
  StyleBox[
  "s that are created are simply ordinary polynomial expressions, as opposed \
to the more complex structures created with the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Poly",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`F\_1\)]],
  StyleBox[" is a field because its modulus polynomial is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(FieldIrreducible[F\_1]\), 
    \(Factor[%, Modulus \[Rule] 3]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "An alternate irreducible polynomial is also allowed; one simply adds it as \
a second argument to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" does not allow a reducible polynomial, however.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(GF[9, x\^2 + 2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Here is a valid alternate irreducible polynomial over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(F\_2 = GF[9, x\^2 + 2\ x + 2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["You can check a polynomial to see if it is irreducible with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["IrreduciblePolyOverZpQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[IrreduciblePolyOverZpQ[#1, 3]&, {x\^2 + 2, x\^2 + 2\ x + 2}]\)], 
  "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Finite field theorems and illustrations"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.18.13"],

Cell["\<\
We list some of the basic theorems in the theory of finite fields. \
Your text probably contains their proofs (or the proofs may be exercises). We \
illustrate these theorems with examples to give you a better feel for what \
they say and what their implications are. The first theorem severely \
restricts the possible size (or order) of a finite field.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 1.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" Every finite field is of order ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\^k\)]],
  StyleBox[" for some prime ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "and positive integer",
  StyleBox[" ",
    FontFamily->"Palatino"],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  StyleBox["Because of Theorem 1, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" does not accept an order such as 6.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(GF[6]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
For a given order, there is really no variety among fields of that \
order.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 2.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" All finite fields of order ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\^k\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" a prime, are isomorphic.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  StyleBox[
  "The same field can appear in many different forms and be created in \
different ways. We illustrate this theorem by generating ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF[8]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" with two different irreducible polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\_1 = x\^3 + x + 1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\_2 = x\^3 + x\^2 + 1\)]],
  StyleBox[
  ". We should be able to create an isomorphism between these fields.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(F\_3 = GF[8, p1 = x\^3 + x + 1]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(F\_4 = GF[8, p2 = x\^3 + x\^2 + 1]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
One reasonable guess might be that the identity function is an \
isomorphism, since the domains are identical.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(id = FormMorphoid[Identity, F\_3, F\_4]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "This morphism is certainly one-to-one and onto, but it does not satisfy \
the morphism property for some pairs. For example, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" is such a pair. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PreservesQ[id, {x\^2, x}, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Another reasonable guess might be that the squaring function that takes \
each element in ",
  Cell[BoxData[
      \(TraditionalForm\`F\_3\)]],
  " to its square (in ",
  Cell[BoxData[
      \(TraditionalForm\`F\_4\)]],
  "). "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[Theta] = FormMorphoid[ElementToPower[F\_3, #1, 2]&, F\_3, F\_4]\)], 
  "Input",
  AspectRatioFixed->True],

Cell["This map is one-to-one.", "Text"],

Cell[BoxData[
    \(OneToOneQ[\[Theta]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Is there any need to check whether \[Theta] is onto? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["In the end, this attempt fails also. ", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[\[Theta]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Give one concrete example showing why \[Theta] is not a morphism.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "A final attempt begins by looking for the roots of ",
  Cell[BoxData[
      \(TraditionalForm\`p\_1\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`F\_3\)]],
  ". This is a bit tricky since we need to use the operations of ",
  Cell[BoxData[
      \(TraditionalForm\`F\_3\)]],
  " to evaluate a polynomial expression. Here is a function that does this \
calculation. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(evalp1[p_] := 
      \(Addition[F\_3]\)[1, \(Addition[F\_3]\)[p, ElementToPower[F\_3, p, 3]]]
        \n (*\ note\ that\ this\ defines\ f \((p)\)\  = \ 
        1\  + \ p\  + \ p^3\ *) \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we evaluate ",
  Cell[BoxData[
      \(TraditionalForm\`p\_1\)]],
  " at each element of ",
  Cell[BoxData[
      \(TraditionalForm\`F\_3\)]],
  ". The first column consists of elements in ",
  Cell[BoxData[
      \(TraditionalForm\`F\_3\)]],
  " and the second column is ",
  Cell[BoxData[
      \(TraditionalForm\`p\_1\)]],
  " evaluated at the elements."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Map[{#1, evalp1[#1]}&, Elements[F\_3]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We can see that the roots of ",
  Cell[BoxData[
      \(TraditionalForm\`p\_1 = x\^3 + x + 1\)]],
  " are ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + x\)]],
  ". (Why is this the case?) Now consider ",
  Cell[BoxData[
      \(TraditionalForm\`p\_2 = x\^3 + x\^2 + 1\)]],
  ", the irreducible polynomial for ",
  Cell[BoxData[
      \(TraditionalForm\`F\_4\)]],
  ". Let\[CloseCurlyQuote]s see if the roots for ",
  Cell[BoxData[
      \(TraditionalForm\`p\_2\)]],
  " are in ",
  Cell[BoxData[
      \(TraditionalForm\`F\_3\)]],
  ". Again, the function to do the evaluation is a bit messy. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(evalp2[p_] := 
      \(Addition[F\_3]\)[1, 
        \(Addition[F\_3]\)[ElementToPower[F\_3, p, 2], 
          ElementToPower[F\_3, p, 3]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we evaluate the modulus polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`p\_2\)]],
  " at each element of ",
  Cell[BoxData[
      \(TraditionalForm\`F\_3\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Map[{#1, evalp2[#1]}&, Elements[F\_3]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["All three roots of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\_2 = x\^3 + \ x\^2 + 1\)]],
  StyleBox[" are also in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\_3\)]],
  StyleBox[". Notice that they are the roots of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\_1\)]],
  ",",
  StyleBox[
  " with 1 added to each of them. With this observation, we make an attempt \
to find a morphism by generating a function using the rule ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox["\[RightTeeArrow]",
            FontFamily->"Courier"], \(x + 1\)}], TraditionalForm]]],
  StyleBox[
  ". After applying this rule, we simplify the expression. Therefore, the \
image of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  StyleBox[" will be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((x + 1)\)\^2\)]],
  StyleBox[", which expands to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + 1\)]],
  StyleBox[", since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x + x = \(\((1 + 1)\) x = 0\)\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". By hand, determine each of the remaining images according to the \
function just described and illustrated.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now that we have a function in mind to work with, we use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FormMorphoidSetup",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to determine a position list for forming a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(FormMorphoidSetup[F\_3, F\_4]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "With this graphic, you can describe a function using a list such as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["{a1, a2, ..., a8}",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". A list of this sort implies that the image of the first entry on the \
left is the one in position ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\_1\)]],
  StyleBox[
  " on the right, the image of the second entry on the left is the one in \
position ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\_2\)]],
  StyleBox[
  " on the right, and so on. For example, the identity function is defined by \
the list {1, 2, 3, 4, 5, 6, 7, 8}. Based on your answer to question 4, fill \
in the list corresponding to this attempt at an isomorphism. Evaluate the \
cell after you have filled in the list.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"\[Tau]", "=", 
      RowBox[{"FormMorphoid", "[", 
        RowBox[{
          RowBox[{"{", 
            
            StyleBox[
              \(replace\ this\ with\ a\ list\ consisting\ of\ an\ ordering\ of
                \ 1. \  .8\),
              FontColor->RGBColor[0, 0, 1]], "}"}], ",", \(F\_3\), ",", 
          \(F\_4\)}], "]"}]}]], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Your function will be one-to-one and onto if the position list is a \
permutation of {1, 2, 3, 4, 5, 6, 7, 8}. Now let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s see if we have an isomorphism. It should work if you answered question 4 \
correctly. You should get ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for your next output!",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MorphismQ[\[Tau]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". It follows from Theorem 2 that the two fields of order 9, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\_1\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\_2\)]],
  StyleBox[
  " that were generated earlier, are isomorphic. Is the identity function an \
isomorphism between them? If so, are there more isomorphisms? If not, find at \
least one isomorphism. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The nonzero elements of any field form a multiplicative group. In \
the finite case, the group is particularly simple.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 3.",
    FontWeight->"Bold"],
  " The multiplicative group of nonzero elements of a finite field is \
cyclic."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(G = FormGroupoid[Units[F\_3], Multiplication[F\_3]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(CyclicQ[G]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The linear monomial term, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" in this case, happens to be a generator for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF[n]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". To view the powers of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[", you can use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PowerList",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[PowerList[F\_3]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Note that this result indicates that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^6\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  StyleBox[" + 1.",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["Also, notice that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PowerList",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " acts on the whole finite field and always starts with {0, 0}, which is a \
special case since 0 is not in the group. One could evaluate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Rest",
            FontFamily->"Courier"], 
          StyleBox["[",
            FontFamily->"Courier"], 
          RowBox[{
            StyleBox["PowerList",
              FontFamily->"Courier"], 
            StyleBox["[",
              FontFamily->"Courier"], \(F\_3\)}]}], TraditionalForm]]],
  StyleBox["]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to get only the powers of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". To what more common group is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[
  " isomorphic? What cyclic groups of order 20 or less are isomorphic to the \
group of units of some finite field?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The concept of a subfield is similar to that of a subring. A subfield of a \
field ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " is a subset of ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " that is a field, using the operations of ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Find a subfield of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF[16]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" containing four elements. Use Theorem 3 to explain why ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF[16]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" has no subfield of order 8.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The previous question generalizes to the following theorem about \
subfields of a finite field.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 4.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" is a finite field of order ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\^k\)]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" has a subfield of order ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\^j\)]],
  StyleBox[" if and only if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  StyleBox[" is a divisor of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  StyleBox["For example, the field GF[",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2\^6\)]],
  StyleBox["] has proper subfields of order 2, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2\^2 = 4\)]],
  ",",
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2\^3 = 8\)]],
  StyleBox[", but not ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2\^4\)]],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2\^5\)]],
  StyleBox[". The only proper subfield of GF[",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2\^5\)]],
  StyleBox["] has 2 elements.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" is a prime, what are the divisors of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\^n - 1\)]],
  StyleBox["? What connection does this have with Theorem 4?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 5.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{\(f : GF[p\^n]\), 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], \(GF[p\^n]\)}], TraditionalForm]]],
  StyleBox[" defined by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(a) = a\^p\)]],
  StyleBox[" is an automorphism of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(GF[p\^n\)\)]],
  StyleBox["]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", called the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Frobenius automorphism",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  StyleBox[
  "Earlier, we examined a similar function between two versions of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF[",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`2\^3\)]],
  StyleBox["]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " that were based on different irreducible polynomials, and the function \
was not a morphism. However, the Frobenius automorphism has the same field \
for both domain and codomain. We can easily create the Frobenius \
automorphism. The following ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Morphoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is identical to \[Theta], defined earlier, except that the codomain is \
changed from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\_4\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\_3\)]],
  StyleBox[
  ". We convert it to the rules format to see the images of each element more \
easily.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f = ToRules[FormMorphoid[ElementToPower[F\_3, #1, 2]&, F\_3, F\_3]]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The following shows that ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is an isomorphism."
}], "Text"],

Cell[BoxData[
    \(OneToOneQ[f] && MorphismQ[f]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 6.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" The group of automorphisms of GF[",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\^n\)]],
  StyleBox["] is the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{f, f\^2,  ... , f\^n = i}\)]],
  ",",
  StyleBox[" where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is the Frobenius automorphism. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell["\<\
We can create this group of automorphisms easily enough and then \
look at its table.\
\>", "Text"],

Cell[BoxData[
    \(Auts = 
      GenerateGroupoid[{f}, MorphoidComposition[#1, #2]&, 
        WideElements \[Rule] True]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[Auts, Mode \[Rule] Visual, ShowKey \[Rule] False]; \)\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "We see that",
  StyleBox[" the automorphism group of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF[8]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is isomorphic to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[". What about the automorphism group of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GF[16]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["? To what is it isomorphic?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["13.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:13.19.13"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?QuotientRing", "Input",
  AspectRatioFixed->True],

Cell["?Inverses", "Input",
  AspectRatioFixed->True],

Cell["?ExtensionDegree", "Input",
  AspectRatioFixed->True],

Cell["?FormMorphoid", "Input",
  AspectRatioFixed->True],

Cell["?OneToOneQ", "Input",
  AspectRatioFixed->True],

Cell["?OntoQ", "Input",
  AspectRatioFixed->True],

Cell["?MorphismQ", "Input",
  AspectRatioFixed->True],

Cell["?FormMorphoidSetup", "Input",
  AspectRatioFixed->True],

Cell["?FieldIrreducible", "Input",
  AspectRatioFixed->True],

Cell["?GaloisFieldQ", "Input",
  AspectRatioFixed->True],

Cell["?GF", "Input",
  AspectRatioFixed->True],

Cell["?IrreduciblePolynomial", "Input",
  AspectRatioFixed->True],

Cell["?IrreduciblePolyOverZpQ", "Input",
  AspectRatioFixed->True],

Cell["?PowerList", "Input",
  AspectRatioFixed->True],

Cell["?PrimitivePolynomials", "Input",
  AspectRatioFixed->True],

Cell["?TableOfPowers", "Input",
  AspectRatioFixed->True],

Cell["?GenerateGroupoid", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
CellGrouping->Manual,
WindowSize->{630, 431},
WindowMargins->{{5, Automatic}, {Automatic, 5}},
PrintingStartingPageNumber->109,
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:13.13"->{
    Cell[2382, 76, 164, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:13.13"]},
  "a:13.14.13"->{
    Cell[2571, 87, 327, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:13.14.13"]},
  "a:13.15.13"->{
    Cell[6942, 234, 195, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.15.13"]},
  "a:13.16.13"->{
    Cell[7569, 260, 245, 9, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.16.13"]},
  "a:13.17.13"->{
    Cell[8799, 306, 207, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.17.13"]},
  "a:13.18.13"->{
    Cell[19764, 734, 221, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:13.18.13"]},
  "a:13.19.13"->{
    Cell[47032, 1769, 374, 14, 55, "Section",
      Evaluatable->False,
      CellTags->"a:13.19.13"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:13.13", 49957, 1881},
  {"a:13.14.13", 50070, 1885},
  {"a:13.15.13", 50189, 1889},
  {"a:13.16.13", 50308, 1893},
  {"a:13.17.13", 50427, 1897},
  {"a:13.18.13", 50546, 1901},
  {"a:13.19.13", 50666, 1905}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 164, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:13.13"],

Cell[CellGroupData[{
Cell[2571, 87, 327, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:13.14.13"],
Cell[2901, 100, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3752, 124, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5122, 166, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5274, 171, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5896, 193, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6588, 219, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6942, 234, 195, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.15.13"],
Cell[7140, 244, 392, 11, 70, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7569, 260, 245, 9, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.16.13"],
Cell[7817, 271, 945, 30, 109, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8799, 306, 207, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.17.13"],
Cell[9009, 316, 732, 27, 52, "Text",
  Evaluatable->False],
Cell[9744, 345, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[9919, 351, 1409, 48, 90, "Text",
  Evaluatable->False],
Cell[11331, 401, 124, 3, 47, "Input"],
Cell[11458, 406, 478, 18, 33, "Text",
  Evaluatable->False],
Cell[11939, 426, 104, 2, 27, "Input"],
Cell[12046, 430, 893, 32, 52, "Text",
  Evaluatable->False],
Cell[12942, 464, 94, 2, 31, "Input"],
Cell[13039, 468, 112, 2, 33, "Text",
  Evaluatable->False],
Cell[13154, 472, 106, 2, 31, "Input"],
Cell[13263, 476, 318, 13, 33, "Text",
  Evaluatable->False],
Cell[13584, 491, 120, 3, 27, "Input"],
Cell[13707, 496, 471, 17, 67, "Question",
  Evaluatable->False],
Cell[14181, 515, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[14258, 519, 108, 2, 27, "Input"],
Cell[14369, 523, 1587, 55, 109, "Text",
  Evaluatable->False],
Cell[15959, 580, 92, 3, 43, "Input"],
Cell[16054, 585, 644, 27, 33, "Text",
  Evaluatable->False],
Cell[16701, 614, 97, 2, 27, "Input"],
Cell[16801, 618, 745, 26, 71, "Text",
  Evaluatable->False],
Cell[17549, 646, 398, 13, 33, "Text",
  Evaluatable->False],
Cell[17950, 661, 122, 3, 43, "Input"],
Cell[18075, 666, 623, 22, 52, "Text",
  Evaluatable->False],
Cell[18701, 690, 74, 2, 31, "Input"],
Cell[18778, 694, 338, 11, 33, "Text",
  Evaluatable->False],
Cell[19119, 707, 88, 2, 31, "Input"],
Cell[19210, 711, 388, 13, 33, "Text",
  Evaluatable->False],
Cell[19601, 726, 126, 3, 31, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[19764, 734, 221, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:13.18.13"],
Cell[19988, 744, 426, 8, 90, "Text",
  Evaluatable->False],
Cell[20417, 754, 748, 29, 35, "Text",
  Evaluatable->False],
Cell[21168, 785, 365, 13, 33, "Text",
  Evaluatable->False],
Cell[21536, 800, 64, 2, 27, "Input"],
Cell[21603, 804, 147, 5, 33, "Text",
  Evaluatable->False],
Cell[21753, 811, 566, 21, 34, "Text",
  Evaluatable->False],
Cell[22322, 834, 977, 31, 90, "Text",
  Evaluatable->False],
Cell[23302, 867, 90, 2, 31, "Input"],
Cell[23395, 871, 93, 2, 31, "Input"],
Cell[23491, 875, 182, 5, 52, "Text",
  Evaluatable->False],
Cell[23676, 882, 98, 2, 27, "Input"],
Cell[23777, 886, 527, 18, 52, "Text",
  Evaluatable->False],
Cell[24307, 906, 105, 2, 31, "Input"],
Cell[24415, 910, 306, 11, 52, "Text",
  Evaluatable->False],
Cell[24724, 923, 127, 3, 27, "Input"],
Cell[24854, 928, 39, 0, 33, "Text"],
Cell[24896, 930, 78, 2, 27, "Input"],
Cell[24977, 934, 313, 11, 48, "Question",
  Evaluatable->False],
Cell[25293, 947, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[25370, 951, 101, 2, 33, "Text",
  Evaluatable->False],
Cell[25474, 955, 78, 2, 27, "Input"],
Cell[25555, 959, 310, 11, 48, "Question",
  Evaluatable->False],
Cell[25868, 972, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[25945, 976, 455, 14, 71, "Text",
  Evaluatable->False],
Cell[26403, 992, 248, 5, 59, "Input"],
Cell[26654, 999, 440, 16, 52, "Text",
  Evaluatable->False],
Cell[27097, 1017, 108, 2, 27, "Input"],
Cell[27208, 1021, 797, 28, 71, "Text",
  Evaluatable->False],
Cell[28008, 1051, 197, 5, 43, "Input"],
Cell[28208, 1058, 254, 10, 33, "Text",
  Evaluatable->False],
Cell[28465, 1070, 108, 2, 27, "Input"],
Cell[28576, 1074, 1598, 54, 109, "Text",
  Evaluatable->False],
Cell[30177, 1130, 352, 12, 67, "Question",
  Evaluatable->False],
Cell[30532, 1144, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[30609, 1148, 595, 20, 52, "Text",
  Evaluatable->False],
Cell[31207, 1170, 94, 2, 27, "Input"],
Cell[31304, 1174, 1093, 32, 128, "Text",
  Evaluatable->False],
Cell[32400, 1208, 402, 11, 43, "Input"],
Cell[32805, 1221, 650, 21, 71, "Text",
  Evaluatable->False],
Cell[33458, 1244, 76, 2, 27, "Input"],
Cell[33537, 1248, 725, 23, 86, "Question",
  Evaluatable->False],
Cell[34265, 1273, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[34342, 1277, 190, 5, 52, "Text",
  Evaluatable->False],
Cell[34535, 1284, 238, 8, 34, "Text",
  Evaluatable->False],
Cell[34776, 1294, 110, 2, 27, "Input"],
Cell[34889, 1298, 69, 2, 27, "Input"],
Cell[34961, 1302, 825, 30, 52, "Text",
  Evaluatable->False],
Cell[35789, 1334, 85, 2, 27, "Input"],
Cell[35877, 1338, 1503, 53, 71, "Text",
  Evaluatable->False],
Cell[37383, 1393, 502, 17, 67, "Question",
  Evaluatable->False],
Cell[37888, 1412, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[37965, 1416, 384, 14, 52, "Text",
  Evaluatable->False],
Cell[38352, 1432, 683, 24, 67, "Question",
  Evaluatable->False],
Cell[39038, 1458, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[39115, 1462, 167, 5, 33, "Text",
  Evaluatable->False],
Cell[39285, 1469, 1076, 41, 53, "Text",
  Evaluatable->False],
Cell[40364, 1512, 1001, 37, 52, "Text",
  Evaluatable->False],
Cell[41368, 1551, 570, 20, 67, "Question",
  Evaluatable->False],
Cell[41941, 1573, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[42018, 1577, 1107, 40, 53, "Text",
  Evaluatable->False],
Cell[43128, 1619, 1361, 45, 128, "Text",
  Evaluatable->False],
Cell[44492, 1666, 129, 3, 27, "Input"],
Cell[44624, 1671, 130, 5, 33, "Text"],
Cell[44757, 1678, 87, 2, 27, "Input"],
Cell[44847, 1682, 745, 27, 53, "Text",
  Evaluatable->False],
Cell[45595, 1711, 109, 3, 33, "Text"],
Cell[45707, 1716, 160, 4, 43, "Input"],
Cell[45870, 1722, 129, 3, 27, "Input"],
Cell[46002, 1727, 916, 33, 67, "Question",
  Evaluatable->False],
Cell[46921, 1762, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[47032, 1769, 374, 14, 55, "Section",
  Evaluatable->False,
  CellTags->"a:13.19.13"],
Cell[47409, 1785, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[47754, 1796, 56, 1, 27, "Input"],
Cell[47813, 1799, 52, 1, 27, "Input"],
Cell[47868, 1802, 59, 1, 27, "Input"],
Cell[47930, 1805, 56, 1, 27, "Input"],
Cell[47989, 1808, 53, 1, 27, "Input"],
Cell[48045, 1811, 49, 1, 27, "Input"],
Cell[48097, 1814, 53, 1, 27, "Input"],
Cell[48153, 1817, 61, 1, 27, "Input"],
Cell[48217, 1820, 60, 1, 27, "Input"],
Cell[48280, 1823, 56, 1, 27, "Input"],
Cell[48339, 1826, 46, 1, 27, "Input"],
Cell[48388, 1829, 65, 1, 27, "Input"],
Cell[48456, 1832, 66, 1, 27, "Input"],
Cell[48525, 1835, 53, 1, 27, "Input"],
Cell[48581, 1838, 64, 1, 27, "Input"],
Cell[48648, 1841, 57, 1, 27, "Input"],
Cell[48708, 1844, 60, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

