#############################################################################
##
#A  complexr.g                CHEVIE library     David Bessis and Jean Michel 
##
#A  $Id: complexr.g,v 1.4 1997/04/14 09:08:54 werner Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains preliminary support for complex reflection
##  group in the setting of the chevie package.
##       Jean Michel and David Bessis 20-9-96
##  
#############################################################################
#
# Complex reflection groups are groups G acting on a vector space V,
# and generated by pseudo-reflexions in V. They are represented by
# finding a set of 'roots' in V invariant by G and such that all
# reflections in G are reflections w.r.t. some roots.
#
# They are represented as Permutation group records with the following
# additional fields:
#  semisimpleRank  -- the dimension of the subspace of V generated by
#         the roots (for an irreducible parent group, equal to the
#         dimension of V).
#  roots -- a set of complex roots V (on which G has a faithful
#         permutation representation) roots{[1..semisimpleRank]}
#         are linearly independent. The roots are chosen to be
#         in minimal number but this may be greater than Size(G) !
#  degrees -- the reflection degrees of G
#  rorders -- the orders of the generators.
#  orbitRepresentative -- for each root the smallest index of
#                         a root in same orbit.

ComplexGroupOps:=OperationsRecord("ComplexGroupOps",PermGroupOps);

ComplexGroupOps.ReflectionDegrees:=W->W.degrees;

ComplexGroupOps.Size:=W->Product(ReflectionDegrees(W));

ComplexGroupOps.Print:=function(W)local n;
  Print("ComplexReflectionGroup(");
  for n in [1..Length(W.STnumber)] do
    Print(W.STnumber[n]);
    if n<>Length(W.STnumber) then Print(",");fi;
  od;
  Print(")");
end;

ComplexGroupOps.ReflectionCharValue:=function(W,w)local i;
  if not IsBound(W.nroots) then
    i:=W.semisimpleRank+1;
    W.ir:=[1..W.semisimpleRank];
    while RankMat(W.roots{W.ir})<W.semisimpleRank
    do i:=i-1;
       W.ir:=Concatenation([1..i-1],[i+1..W.semisimpleRank+1]);
    od;
    if i<>W.semisimpleRank+1 then
    InfoChevie("# independent roots are not ",[1..W.semisimpleRank]," but ",
             W.ir,"\n");
    fi;
    W.nroots:=List(W.roots,x->SolutionMat(W.roots{W.ir},x));
  fi;
  return TraceMat(W.nroots{W.ir}^-1*W.nroots{OnTuples(W.ir,w)});
end;

ComplexGroupOps.FakeDegrees:=function(W,q)
  local ct,i,p,nch,refchar,P,n,qq;
  ct:=CharTable(W);qq:=X(Cyclotomics);
  nch:=Length(ct.irreducibles);
  refchar:=Position(ct.irreducibles,List(ConjugacyClasses(W),
	    c->ReflectionCharValue(W,Representative(c))));
  if refchar=false then
    Error("FakeDegrees not implemented for non-irreducible complex reflection groups\n");
  fi;
  InfoChevie("# Reflection character is number ",refchar,"\n");
  W.eigenvalues:=[];
  for i in [1..nch] do
    p:=Eigenvalues(ct,ct.irreducibles[refchar],i);
    n:=Length(p);
    Add(W.eigenvalues,Concatenation(List([1..n],i->List([1..p[i]],j->E(n)^i))));
  od;
  P:=Product(ReflectionDegrees(W),x->qq^x-1);
  return List(ct.irreducibles*List([1..nch],
        i->P/(Product(W.eigenvalues[i],k->(qq*k^-1-1))*ct.centralizers[i])),
	x->Value(x,q));
end;

ComplexGroupOps.Hecke:=function(arg)
  ReadChv("prg/ctcychck");return ApplyFunc(ComplexGroupOps.Hecke,arg);
end;

# returns complex reflection with respect to a given root and with given
# order or permutation corresponding to root number v in g
Reflection:=function(arg)local root,order,I,dim,res,norm,g,v;
  if IsGroup(arg[1]) then
    g:=arg[1];v:=arg[2];
    if not IsBound(g.reflectionsPerm[v]) then
     g.reflectionsPerm[v]:=SortingPerm(g.roots*Reflection
     (g.roots[v],g.rorders[g.orbitRepresentative[v]]))/
     SortingPerm(g.roots);
    fi;
    return g.reflectionsPerm[v];
  else
    norm:=v->Sum(v,x->GaloisCyc(x,-1)*x); # norm of vector v
    root:=arg[1];order:=arg[2];
    dim:=Length(root);
    InfoChevie("# root:",root,"  norm:",norm(root),"\n");
    I:=IdentityMat(dim);
    res:=List([1..dim],i->I[i]+(E(order)-1)*GaloisCyc(root[i],-1)*root/
	norm(root));
    return res;
  fi;
end;

#############################################################################
##
#F  ComplexReflectionGroup( <args> ) . . . construct a complex refl. group
##  
# The function ComplexReflectionGroup has two forms:
#  ComplexReflectionGroup(d,p,n) returns the general imprimitive group g(d,p,n)
#  ComplexReflectionGroup(STnumber) returns the exceptional
#  complex reflection group of Shephard-Todd number STnumber
#
ComplexReflectionGroup:=function(arg)
  local gfromv,STnumber,d,p,n,res,q,r,v,i,G;

  gfromv:=function(g)local n,r,permrefs,j,i,p,G;
    g.refs:=List([1..Length(g.roots)],j->Reflection(g.roots[j],g.rorders[j]));
    g.semisimpleRank:=Length(g.roots[1]);
    permrefs:=List(g.refs,x->[]);
    repeat
      n:=Length(g.roots);
      for j in [1..Length(g.refs)] do
	for i in [1+Length(permrefs[j])..Length(g.roots)] do
	  r:=g.roots[i]*g.refs[j];
	  p:=Position(g.roots,r);
	  if p=false then Add(g.roots,r);p:=Length(g.roots);fi;
	  Add(permrefs[j],p);
	od;
	  InfoChevie("# roots: ",Length(g.roots),"\n");
      od;
    until Length(g.roots)=n;
    G:=Group(List(permrefs,PermList),());
    for p in RecFields(g) do G.(p):=g.(p);od;
    if not IsBound(G.name) then 
        G.name:=Concatenation("G",String(STnumber));fi;
    G.orbitRepresentative:=[1..Length(G.roots)];
    for r in Orbits(G,[1..Length(G.roots)]) do
       G.orbitRepresentative{r}:=[1..Length(r)]*0+Minimum(r);
    od;
    G.reflectionsPerm:=Copy(G.generators);
    return G;
  end;

  if IsRec(arg[1]) and IsBound(arg[1].complexGroup) then
    return arg[1].complexGroup;
  fi;
  STnumber:=arg[1];
  if Length(arg)=3 then p:=arg[1];q:=arg[2];r:=arg[3];
# construct imprimitive reflection groups
# G(p,q,r) is defined for p>1, q|p, r>0.)
# for r=1 only value of q which makes sense is 1
    if not (r>0 and IsInt(p/q) and (r>1 or q=1)) then 
      Error("(p,q,r) must satisfy: p>1, q|p, r>0, and r=1 => q=1");
    fi;
    if p=2 and q=1 then return CoxeterGroup("B",r);
    elif p=2 and q=2 then return CoxeterGroup("D",r);
    elif p=1 and q=1 then return CoxeterGroup("A",r-1);
    elif r=2 and p=q then return CoxeterGroup("I",2,p);
    elif q=1 then
      v:=[1..r]*0;v[1]:=1;
      G:=rec(roots:=[v],rorders:=[1..r]*0+2);
      G.rorders[1]:=p;
    else 
      if q<>p then v:=[1..r]*0;v[1]:=1;
	   G:=rec(roots:=[v],rorders:=[p/q]);
      else G:=rec(roots:=[],rorders:=[]);
      fi;
      Append(G.rorders,[1..r]*0+2);
      v:=[1..r]*0;v[1]:=-E(p);v[2]:=1;Add(G.roots,v);
    fi;
    for i in [2..r] do
      v:=[1..r]*0;v[i]:=1;v[i-1]:=-1;
      Add(G.roots,v);
    od;
    G.name:=Concatenation("G(",String(p),",",String(q),",",String(r),")");
    G.degrees:=Concatenation(p*[1..r-1],[r*p/q]);
    res:=gfromv(G);
  elif STnumber=4  then res:=gfromv(rec(
     roots:=[[ -2*E(12)^7-E(12)^8-E(12)^11, E(8)+E(8)^3 ],
             [ E(12)^8-E(12)^11, -E(24)+E(24)^11-E(24)^17-E(24)^19 ] ],
     rorders:=[3,3],degrees:=[4,6]));
  elif STnumber=5  then res:=gfromv(rec(
     roots:= [ [ -2*E(12)^7-E(12)^8-E(12)^11, E(8)+E(8)^3 ],
               [ -2*E(12)^4-E(12)^8+E(12)^11, -E(8)-E(8)^3 ] ],
     rorders:=[3,3],
     degrees:=[6,12]));
  elif STnumber=6  then res:=gfromv(rec(
     roots:=[[ 0, 1 ],[ -2*E(12)^7-E(12)^8-E(12)^11, E(8)+E(8)^3 ]],
     rorders:=[2,3],degrees:=[4,12]));
  elif STnumber=7  then res:=gfromv(rec(
     roots:= [ [ 0, 1 ], [ -2*E(12)^7-E(12)^8-E(12)^11, E(8)+E(8)^3 ],
               [ -2*E(12)^4-E(12)^8+E(12)^11, -E(8)-E(8)^3 ] ],
     rorders:=[2,3,3],
     degrees:=[12,12]));
  elif STnumber=8  then res:=gfromv(rec(
     roots:=[ [ E(24)^17, E(12)^7+E(12)^8+E(12)^11 ], [ -E(24),
     -E(12)^4+E(12)^11 ] ],
     rorders:=[4,4],
     degrees:=[8,12]));
  elif STnumber=9  then res:=gfromv(rec(
     roots:=[[ -E(24)^11-E(24)^14-E(24)^16-E(24)^17-E(24)^19-E(24)^22, 
           -E(24)+E(24)^16-E(24)^17 ],
	     [ E(24)^17, E(12)^7+E(12)^8+E(12)^11 ] ],
     rorders:=[2,4],
     degrees:=[8,24]));
  elif STnumber=10 then res:=gfromv(rec(
     roots:=[ [ 0, 1 ], [ E(24)^17, E(12)^7+E(12)^8+E(12)^11 ] ],
     rorders:=[3,4],
     degrees:=[12,24]));
  elif STnumber=11 then res:=gfromv(rec(
     roots:=[ [
     -E(24)^11-E(24)^14-E(24)^16-E(24)^17-E(24)^19-E(24)^22, 
           -E(24)+E(24)^16-E(24)^17 ], [ 0, 1 ], 
	     [ E(24)^17, E(12)^7+E(12)^8+E(12)^11 ] ],
     rorders:=[2,3,4],
     degrees:=[24,24]));
  elif STnumber=12 then res:=gfromv(rec(
     roots:=[ [ -E(24)^11-E(24)^14-E(24)^16-E(24)^17-E(24)^19-E(24)^22, 
           -E(24)+E(24)^16-E(24)^17 ], 
	     [ E(24)-E(24)^8-E(24)^11-E(24)^16-E(24)^19,
	     -E(24)-E(24)^14-E(24)^17 -E(24)^19-E(24)^22 ], 
	     [ -E(24)+E(24)^8-E(24)^14-E(24)^17-E(24)^22,
	     E(24)^14+E(24)^16+E(24)^19 +E(24)^22 ] ] , 
     rorders:=[2,2,2],
     degrees:=[6,8]));
  elif STnumber=13 then res:=gfromv(rec(
     roots:=[ [ E(24)^17, E(12)^7+E(12)^8+E(12)^11 ], 
       [ -E(24)^11-E(24)^14-E(24)^16-E(24)^17-E(24)^19-E(24)^22, 
             -E(24)+E(24)^16-E(24)^17 ], 
	       [ E(24)^8-E(24)^14-E(24)^17-E(24)^19-E(24)^22,
	       -E(24)^14+E(24)^19 ] ],
     rorders:=[2,2,2],
     degrees:=[8,12]));
  elif STnumber=14 then res:=gfromv(rec(
     roots:=[[-E(24)^11-E(24)^14-E(24)^16-E(24)^17-E(24)^19-E(24)^22, 
           -E(24)+E(24)^16-E(24)^17 ], [ 0, 1 ]],
     rorders:=[2,3],
     degrees:=[6,24]));
  elif STnumber=15 then res:=gfromv(rec(
     roots:=[ [ E(24)^17, E(12)^7+E(12)^8+E(12)^11 ],
              [ -E(24)^11-E(24)^14-E(24)^16-E(24)^17-E(24)^19-E(24)^22, 
           -E(24)+E(24)^16-E(24)^17 ],[ 0, 1 ]],
     rorders:=[2,2,3],
     degrees:=[12,24]));
  elif STnumber=16 then res:=gfromv(rec(
     roots:=[ [ 0, -E(20)+E(20)^9 ], 
              [ E(20)^17, E(20)^9+E(20)^13+E(20)^17 ] ],
     rorders:=[5,5],
     degrees:=[20,30]));
  elif STnumber=17 then res:=gfromv(rec(
     roots:=[ [ 1, E(20)-E(20)^8-E(20)^9-E(20)^12 ],[ 0, -E(20)+E(20)^9 ]],
     rorders:=[2,5],
     degrees:=[20,60]));
  elif STnumber=18 then res:=gfromv(rec(
    roots:=[ [ 1, E(15)+E(15)^11+E(15)^13+E(15)^14 ], 
             [ 0, -E(20)+E(20)^9 ]],
    rorders:=[3,5],
    degrees:=[30,60]));
  elif STnumber=19 then res:=gfromv(rec(
    roots:=[ [ 1, E(20)-E(20)^8-E(20)^9-E(20)^12 ],[ 1,
    E(15)+E(15)^11+E(15)^13+E(15)^14 ], [ 0, -E(20)+E(20)^9 ]],
    rorders:= [2,3,5],
    degrees:=[60,60]));
  elif STnumber=20 then res:=gfromv(rec(
    roots:=[ [ 1, E(15)+E(15)^11+E(15)^13+E(15)^14 ], 
      [ E(15)+E(15)^11+E(15)^14, -E(15)^4-E(15)^7+E(15)^11 ] ],
      rorders:=[3,3],
      degrees:=[12,30]));
  elif STnumber=21 then res:=gfromv(rec(
    roots:=[ [ 1, E(20)-E(20)^8-E(20)^9-E(20)^12 ],[ 1,
    E(15)+E(15)^11+E(15)^13+E(15)^14 ]],
    rorders:=[2,3],
    degrees:=[12,60]));
  elif STnumber=22 then res:=gfromv(rec(
    roots:=[ [ 1, E(20)-E(20)^8-E(20)^9-E(20)^12 ], 
      [ E(20)+E(20)^9+E(20)^12+E(20)^13+E(20)^16+E(20)^17, 
            -E(20)+E(20)^8-E(20)^13-E(20)^17 ], 
	      [ E(20)-E(20)^4-E(20)^8+E(20)^9+E(20)^13+E(20)^17, 
	            -E(20)^9-E(20)^12-E(20)^13-E(20)^17 ] ],
    rorders:=[2,2,2],
    degrees:=[12,20]));
  elif STnumber=23 then return CoxeterGroup("H",3);
  elif STnumber=24 then res:=gfromv(rec(
    roots:=[ [0,-EB(7)/2,-EB(7)/2],
             [0,1,0],
             [ -1/2, 1/2*E(7)^3+1/2*E(7)^5+1/2*E(7)^6, 1/2 ]
	   ],
    rorders:= [2,2,2],
    degrees:=[4,6,14]));
  elif STnumber=25 then res:=gfromv(rec(
    roots:=[[0,0,1],(-(2*E(3)^2+1)/3)*[1,1,1],[0,1,0]],
    rorders:= [3,3,3],
    degrees:=[6,9,12]));
  elif STnumber=26 then res:=gfromv(rec(
    roots:=[[0,1/ER(2),-1/ER(2)],[0,0,1],[E(4)/ER(3),E(4)/ER(3),E(4)/ER(3)]],
    rorders:= [2,3,3],
    degrees:=[6,12,18]));
  elif STnumber=27 then res:=gfromv(rec(
    roots:=[[1,0,0],
[ -1/2*E(15)^7+1/2*E(15)^11-1/2*E(15)^13+1/2*E(15)^14, -1/2*E(3)^2, -1/2*E(3) ],
[ 1/2*E(3), 1/2,
1/2*E(15)+1/2*E(15)^2+1/2*E(15)^4+1/2*E(15)^8+1/2*E(15)^11 +1/2*E(15)^14 ] ],
    rorders:= [2,2,2],
    degrees:=[6,12,30]));
  elif STnumber=28 then return CoxeterGroup("F",4);
  elif STnumber=29 then res:=gfromv(rec(
    roots:=[ [ 1/2, 1/2, 1/2, 1/2 ], 
             [ -1/2-1/2*E(4), -1/2+1/2*E(4), 0, 0 ], 
	     [ 1/2-1/2*E(4), -1/2+1/2*E(4), 0, 0 ], 
	     [ 0, 1/2-1/2*E(4), -1/2+1/2*E(4), 0 ] 
	   ],
    rorders:= [2,2,2,2],
    degrees:= [4,8,12,20]));
  elif STnumber=30 then return CoxeterGroup("H",4);
  elif STnumber=31 then res:=gfromv(rec(
    roots:=[ [-E(4), 0, 0, 0 ] ,
             [ -1/2-1/2*E(4), -1/2+1/2*E(4), 0, 0 ], 
	     [ 1/2-1/2*E(4), -1/2+1/2*E(4), 0, 0 ], 
             [ 1/2, 1/2, 1/2, 1/2 ], 
	     [ 0, 1/2-1/2*E(4), -1/2+1/2*E(4), 0 ] 
	   ],
    rorders:= [2,2,2,2,2],
    degrees:= [8,12,20,24]));
  elif STnumber=32 then res:=gfromv(rec(
    roots:=[[0,0,1,0],E(4)/ER(3)*[1,1,1,0],[0,1,0,0],E(4)/ER(3)*[-1,1,0,1]],
    rorders:= [3,3,3,3],
    degrees:=[12,18,24,30]));
  elif STnumber=33 then res:=gfromv(rec(
    roots:=[[0,0,0,0,E(3)],
    [E(3)/(2*ER(2)),-E(3)*(1+2*E(3))/(2*ER(2)),
    -E(3)/(2*ER(2)),-E(3)/(2*ER(2)),-E(3)/2],
    [1/ER(2),-1/ER(2),0,0,0],
    [0,1/ER(2),-1/ER(2),0,0],
    [0,0,1/ER(2),-1/ER(2),0]],
    rorders:= [2,2,2,2,2],
    degrees:=[4,6,10,12,18]));
  elif STnumber=34 then res:=gfromv(rec(
    roots:=[[0,0,0,0,E(3)/ER(2),E(3)/ER(2)],
    [E(3)/(2*ER(2)),-E(3)*(1+2*E(3))/(2*ER(2)),
    -E(3)/(2*ER(2)),-E(3)/(2*ER(2)),-E(3)/(2*ER(2)),-E(3)/(2*ER(2))],
    [1/ER(2),-1/ER(2),0,0,0,0],
    [0,1/ER(2),-1/ER(2),0,0,0],
    [0,0,1/ER(2),-1/ER(2),0,0],
    [-E(3)^2/(2*ER(2)),-E(3)^2/(2*ER(2)),-E(3)^2/(2*ER(2)),
     -(1+2*E(3))*E(3)^2/(2*ER(2)),-E(3)^2/(2*ER(2)),E(3)^2/(2*ER(2))]],
    rorders:= [2,2,2,2,2,2],
    degrees:=[6,12,18,24,30,42]));
  elif STnumber=35 then return CoxeterGroup("E",6);
  elif STnumber=36 then return CoxeterGroup("E",7);
  elif STnumber=37 then return CoxeterGroup("E",8);
  else Error("parameter must be in the interval [4..37]\n");
  fi;
  res.STnumber:=arg;
  res.operations:=ComplexGroupOps;
  return res;
end;
