#############################################################################
##
#A  hekcoset.g                     CHEVIE library                 Jean Michel
##
#A  $Id: hekcoset.g,v 1.1 1997/01/21 13:46:31 gap Exp $
##
#Y  Copyright (C) 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, and
#Y  Universite Paris VII.
##
##  This file contains  GAP functions for working with Hecke cosets and
##  their character tables.
##

##############################################################################
HeckeCosetOps:=OperationsRecord("HeckeCosetOps",DomainOps);

HeckeCosetOps.Hecke:=HF->HF.hecke;
HeckeCosetOps.CoxeterGroup:=HF->CoxeterGroup(HF.hecke);

HeckeCosetOps.Print:=function(HF)
Print("Hecke(",CoxeterCoset(HF),",",Hecke(HF).parameter,
      ",",Hecke(HF).sqrtParameter,")");
end;

##############################################################################
##
#F HeckeCosetCharTableIrred([type,inds {,Ibond}],orderphi{,param{,sqrtparam}})
## accepts an argument which is the type of an irreducible Coxeter group
## (like a component of the result of CartanType).
HeckeCosetCharTableIrred:=function(arg)
  local inds,param,sqrtparam,rank,tbl,type,orderphi,tmp,r,a;
  a:=arg[1]; type:=a[1]; inds:=a[2]; rank:=Length(inds);
  orderphi:=arg[2];
  arg:=arg{[3..Length(arg)]};
  if IsBound(arg[1]) then param:=ShallowCopy(arg[1]);else param:=1;fi;
  if not IsList(param) then param:=List([1..rank],x->param);fi;
  if IsBound(arg[2]) then sqrtparam:=arg[2];else sqrtparam:=[];fi;
  if not IsList(sqrtparam) then sqrtparam:=List([1..rank],x->sqrtparam);fi;
  if orderphi=1 then 
    return ApplyFunc(HeckeCharTableIrred,Concatenation(a,arg));
  fi;
  r:=CHEVIE.LoadCoset(type,rank,orderphi);
  if   type="A" or type="~A" then 
   if not IsBound(sqrtparam[1]) then
     Error("needs square root of parameters for Hecke chartable of type 2A");
   fi;
   tbl:=r.HeckeCharTable(rank,sqrtparam[1]);
  elif type="D" then 
     if orderphi=3 then tbl:=r.HeckeCharTable(param[1]);
     else tbl:=r.HeckeCharTable(rank,param[1]);
     fi;
  elif type="E" and rank=6 then
   if not IsBound(sqrtparam[1]) then
     Error("needs square root of parameters for Hecke chartable of type 2E6");
   fi;
   tbl:=r.HeckeCharTable(sqrtparam[1]);
  elif type="I" and rank=2 then
   if not IsBound(sqrtparam[1]) then
     Error("needs square root of parameters for Hecke chartable of type 2I2(",a[3],")");
   fi;
   tbl:=r.HeckeCharTable(a[3],sqrtparam[1]);
  fi;
  tbl.classtext:=List(tbl.classtext,x->OnTuples(x,MappingPermListList([1..rank],inds)));
  if not IsBound(tbl.name) then
     tbl.name:=tbl.identifier;
  fi;      
  if not IsBound(tbl.order) then
    tbl.order:=tbl.size;
  fi;
  return tbl;
end;

HeckeCosetOps.CharTable:=function(HF)local t,res,tbl,o,WF,H,tmp,cl,f;
  tmp:=[];
  WF:=CoxeterCoset(HF);
  H:=Hecke(HF);
  for o in CartanType(WF) do
    t:=o.orbit[1];
    tbl:=HeckeCosetCharTableIrred(t,OrderPerm(o.phi),
       H.parameter{t[2]},SublistUnbnd(H.sqrtParameter,t[2]));
    if Length(o.orbit)>1 then
# descent of scalars: essentially the table is that of 
# the group corresponding to o.orbit[1] with o.phi acting on it.
     tbl.name:="";
     tbl.identifier:=tbl.name;
     tbl.size:=tbl.size^Length(o.orbit);
     tbl.classes:=List(tbl.centralizers,x->tbl.size/x);
    fi;
    Add(tmp,tbl);
  od;
  res:=tmp[1];
  for tbl in tmp{[2..Length(tmp)]} do
    res:=CharTableDirectProduct(res,tbl);
  od;
  res.classes:=List(res.centralizers,x->res.size/x);

  res.irredinfo:=List(CharParams(WF),x->rec(charparam:=x,
                                            charname:=CharName(WF,x)));
  cl:=ChevieClassInfo(WF);
  for f in RecFields(cl) do res.(f):=cl.(f);od;
  res.name:=Concatenation("H(",CartanName(WF),")");
  res.identifier:=res.name;
  return res;
end;

# make a hecke coset from Coxeter coset WF and Hecke algebra H or parameters
CoxeterCosetOps.Hecke:=function(arg)local W,i,WF,H;
  WF:=arg[1];W:=CoxeterGroup(WF);
  if Length(arg)=2 and IsRec(arg[2]) and IsBound(arg[2].coxeter) then
    H:=arg[2];
  else
    arg[1]:=W;H:=ApplyFunc(Hecke,arg);
  fi;
  for i in Cycles(WF.phi,W.rootInclusion{[1..W.semisimpleRank]}) do
    if Length(Set(H.parameter{W.rootRestriction{i}}))>1 then
      Error("Hecke algebra parameters should be equal for", 
            " phi-conjugate reflections");
    fi;
  od;
  return rec(hecke:=H,coxeterCoset:=WF,isGroup:=true,
                               operations:=HeckeCosetOps);
end;
