#############################################################################
##
#A  cox2i.g                   CHEVIE library                      Jean Michel
##
#A  $Id: cox2i.g,v 1.1 1997/01/21 13:46:39 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains the character table of the Hecke algebras of type I.
##

CHEVIE.2I:=rec();

if not IsBound(CHEVIE.I) then ReadChv("tbl/coxi");fi;

#############################################################################
##
#F  CHEVIE.2I.ClassInfo( <m> ) . . . . conjugacy classes for type ^2I_2(2*k+1)
##
CHEVIE.2I.ClassInfo:=function(m)local n,v,res;
  if m mod 2 <>1 then Error("ClassInfo of I2(m) implemented only for odd m");fi; 
  res:=CHEVIE.I.ClassInfo(m);
  v:=res.classtext;n:=Length(v);
  res.classtext:=v{Concatenation([n],[1],[n-1,n-2..2])};
  return res;
end;

CHEVIE.2I.HeckeCharTable:=function(m,sqq)local W,WF,qE,H,tbl,tmp,i,cl;
   W:=CoxeterGroup("I",2,m);WF:=CoxeterCoset(W,(1,2));
   qE:=HeckeCentralMonomials(Hecke(W,sqq));
## q_E is the square root which deforms to 1 of the eigenvalue of T_{w_0}
## on E which deforms to 1; we have:
##  E~(T_w\phi)=\overline(E(T_{w^-1w_0}))q_E (trivial extension)
## where \overline means q->q^-1
   H:=Hecke(W,sqq^-2);
   tbl:=ShallowCopy(CharTable(H));
   tbl.classtext:=CHEVIE.2I.ClassInfo(m).classtext;
   tbl.classnames:=CHEVIE.2I.ClassInfo(m).classnames;
   tbl.classparam:=CHEVIE.2I.ClassInfo(m).classparams;
   tbl.identifier:=String(Concatenation("H(2I2",String(m),")"));
   cl:=List(tbl.classtext,x->PermCoxeterWord (W,x)*LongestCoxeterElement(W));
   tbl.irreducibles:=TransposedMat(List(cl,x->HeckeCharValues(Basis(H,"T")(x))));
   for i in [1..Length(tbl.irreducibles)] do
     tbl.irreducibles[i]:=qE[i]*tbl.irreducibles[i];
   od;
   return tbl;
end;

CHEVIE.2I.CharParams:=function(m)
   if m mod 2<>1 then Error("not implemented for I2(m), m even");fi;
   return CHEVIE.I.CharParams(m);
end;

CHEVIE.2I.CharName:=CHEVIE.I.CharName;

CHEVIE.2I.phifactors:=[1,-1];
