#############################################################################
##
#A  coxh3.g                 CHEVIE library                       Meinolf Geck 
##
#A  $Id: coxh3.g,v 1.1 1997/01/21 13:46:40 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains the character table of the Hecke algebras of type H3.
##

CHEVIE.H3:=rec();

CHEVIE.H3.classtext:=[ [ ], [ 1 ], [ 1, 2 ], [ 1, 3 ], [ 2, 3 ], [ 1, 2, 3 ], 
     [ 1, 2, 1, 2 ], [ 1, 2, 1, 2, 3 ], [ 1, 2, 1, 2, 3, 2, 1, 2, 3 ], 
     [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3 ] ];

#how to make a .charname from a .charparam
CHEVIE.H3.CharName:=x->String(Concatenation("phi_{",String(x[1]),
  		  ",",String(x[2]),"}"));

CHEVIE.H3.CharParams:=function() 
  return [[ 1, 15 ],[ 1, 0 ],[ 5, 5 ],[ 5, 2 ],[ 3, 6 ],
                        [ 3, 8 ],[ 3, 1 ],[ 3, 3 ],[ 4, 3 ],[ 4, 4 ]];
end;

CHEVIE.H3.cyclestructure:=[];
CHEVIE.H3.generators:=[];

CHEVIE.H3.cartan:=[[2,-(1+ER(5))/2, 0 ], [ -(1+ER(5))/2, 2, -1 ], [ 0, -1, 2 ] ];

CHEVIE.H3.powermap:=
[ , [ 1, 1, 7, 1, 5, 3, 3, 5, 7, 1 ], [ 1, 2, 7, 4, 1, 9, 3, 10, 6, 10 ],, 
  [ 1, 2, 1, 4, 5, 10, 1, 8, 10, 10 ],, [ 1, 2, 7, 4, 5, 9, 3, 8, 6, 10 ] ];

CHEVIE.H3.orders:=[ 1, 2, 5, 2, 3, 10, 5, 6, 10, 2 ];

CHEVIE.H3.centralizers:=[ 120, 8, 10, 8, 6, 10, 10, 6, 10, 120 ];

CHEVIE.H3.classes:=[ 1, 15, 12, 15, 20, 12, 12, 20, 12, 1 ];

CHEVIE.H3.PositionId:=function() return 2; end;

CHEVIE.H3.PositionSgn:=function() return 1; end;

CHEVIE.H3.PositionRefl:=function() return 7; end;

CHEVIE.H3.vpolheckeirreducibles:=
[ [ [ [ 1 ], 0 ], [ [ -1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ 1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], 
      [ [ -1 ], 0 ] ], 
  [ [ [ 1 ], 0 ], [ [ 1 ], 2 ], [ [ 1 ], 4 ], [ [ 1 ], 4 ], [ [ 1 ], 4 ], 
      [ [ 1 ], 6 ], [ [ 1 ], 8 ], [ [ 1 ], 10 ], [ [ 1 ], 18 ], [ [ 1 ], 30 ] 
     ], 
  [ [ [ 5 ], 0 ], [ [ -3, 0, 2 ], 0 ], [ [ 1, 0, -1 ], 0 ], [ [ 2, 0, -2, 0, 
              1 ], 0 ], [ [ 1, 0, -2 ], 0 ], [ [  ], 0 ], 
      [ [ 1, 0, 0, 0, -1 ], 0 ], [ [ 1 ], 4 ], [ [  ], 0 ], [ [ -5 ], 12 ] ], 
  [ [ [ 5 ], 0 ], [ [ -2, 0, 3 ], 0 ], [ [ -1, 0, 1 ], 2 ], 
      [ [ 1, 0, -2, 0, 2 ], 0 ], [ [ -2, 0, 1 ], 2 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 1 ], 4 ], [ [ -1 ], 6 ], [ [  ], 0 ], [ [ 5 ], 18 ] ], 
  [ [ [ 3 ], 0 ], [ [ -2, 0, 1 ], 0 ], [ [ 1, 0, E(5)+E(5)^4 ], 0 ], 
      [ [ 1, 0, -2 ], 0 ], [ [ 1, 0, -1 ], 0 ], [ [ -E(5)-E(5)^4 ], 2 ], 
      [ [ 1, 0, 0, 0, E(5)^2+E(5)^3 ], 0 ], [ [  ], 0 ], 
      [ [ -E(5)^2-E(5)^3 ], 6 ], [ [ 3 ], 10 ] ], 
  [ [ [ 3 ], 0 ], [ [ -2, 0, 1 ], 0 ], [ [ 1, 0, E(5)^2+E(5)^3 ], 0 ], 
      [ [ 1, 0, -2 ], 0 ], [ [ 1, 0, -1 ], 0 ], [ [ -E(5)^2-E(5)^3 ], 2 ], 
      [ [ 1, 0, 0, 0, E(5)+E(5)^4 ], 0 ], [ [  ], 0 ], 
      [ [ -E(5)-E(5)^4 ], 6 ], [ [ 3 ], 10 ] ], 
  [ [ [ 3 ], 0 ], [ [ -1, 0, 2 ], 0 ], [ [ E(5)+E(5)^4, 0, 1 ], 2 ], 
      [ [ -2, 0, 1 ], 2 ], [ [ -1, 0, 1 ], 2 ], [ [ E(5)+E(5)^4 ], 4 ], 
      [ [ E(5)^2+E(5)^3, 0, 0, 0, 1 ], 4 ], [ [  ], 0 ], 
      [ [ E(5)^2+E(5)^3 ], 12 ], [ [ -3 ], 20 ] ], 
  [ [ [ 3 ], 0 ], [ [ -1, 0, 2 ], 0 ], [ [ E(5)^2+E(5)^3, 0, 1 ], 2 ], 
      [ [ -2, 0, 1 ], 2 ], [ [ -1, 0, 1 ], 2 ], [ [ E(5)^2+E(5)^3 ], 4 ], 
      [ [ E(5)+E(5)^4, 0, 0, 0, 1 ], 4 ], [ [  ], 0 ], 
      [ [ E(5)+E(5)^4 ], 12 ], [ [ -3 ], 20 ] ], 
  [ [ [ 4 ], 0 ], [ [ -2, 0, 2 ], 0 ], [ [ -1 ], 2 ], 
      [ [ 1, 0, -2, 0, 1 ], 0 ], [ [ 1, 0, -1, 0, 1 ], 0 ], [ [ 1 ], 3 ], 
      [ [ -1 ], 4 ], [ [ -1 ], 5 ], [ [ 1 ], 9 ], [ [ -4 ], 15 ] ], 
  [ [ [ 4 ], 0 ], [ [ -2, 0, 2 ], 0 ], [ [ -1 ], 2 ], 
      [ [ 1, 0, -2, 0, 1 ], 0 ], [ [ 1, 0, -1, 0, 1 ], 0 ], [ [ -1 ], 3 ], 
      [ [ -1 ], 4 ], [ [ 1 ], 5 ], [ [ -1 ], 9 ], [ [ 4 ], 15 ] ] ];

CHEVIE.H3.vpolschurelms:=
[ [ [ 1, 3, 5, 7, 9, 11, 12, 12, 12, 12, 11, 9, 7, 5, 3, 1 ], -15 ], 
  [ [ 1, 3, 5, 7, 9, 11, 12, 12, 12, 12, 11, 9, 7, 5, 3, 1 ], 0 ], 
  [ [ 1, 3, 4, 4, 4, 4, 3, 1 ], -5 ], [ [ 1, 3, 4, 4, 4, 4, 3, 1 ], -2 ], 
  [ [ -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4, -6*E(5)-9*E(5)^2-9*E(5)^3-6*E(5)^4, 
          -7*E(5)-8*E(5)^2-8*E(5)^3-7*E(5)^4, -5*E(5)-5*E(5)^4, 
          -5*E(5)-5*E(5)^4, -7*E(5)-8*E(5)^2-8*E(5)^3-7*E(5)^4, 
          -6*E(5)-9*E(5)^2-9*E(5)^3-6*E(5)^4, 
          -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4 ], -6 ], 
  [ [ -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4, -9*E(5)-6*E(5)^2-6*E(5)^3-9*E(5)^4, 
          -8*E(5)-7*E(5)^2-7*E(5)^3-8*E(5)^4, -5*E(5)^2-5*E(5)^3, 
          -5*E(5)^2-5*E(5)^3, -8*E(5)-7*E(5)^2-7*E(5)^3-8*E(5)^4, 
          -9*E(5)-6*E(5)^2-6*E(5)^3-9*E(5)^4, 
          -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4 ], -6 ], 
  [ [ -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4, -6*E(5)-9*E(5)^2-9*E(5)^3-6*E(5)^4, 
          -7*E(5)-8*E(5)^2-8*E(5)^3-7*E(5)^4, -5*E(5)-5*E(5)^4, 
          -5*E(5)-5*E(5)^4, -7*E(5)-8*E(5)^2-8*E(5)^3-7*E(5)^4, 
          -6*E(5)-9*E(5)^2-9*E(5)^3-6*E(5)^4, 
          -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4 ], -1 ], 
  [ [ -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4, -9*E(5)-6*E(5)^2-6*E(5)^3-9*E(5)^4, 
          -8*E(5)-7*E(5)^2-7*E(5)^3-8*E(5)^4, -5*E(5)^2-5*E(5)^3, 
          -5*E(5)^2-5*E(5)^3, -8*E(5)-7*E(5)^2-7*E(5)^3-8*E(5)^4, 
          -9*E(5)-6*E(5)^2-6*E(5)^3-9*E(5)^4, 
          -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4 ], -1 ], 
  [ [ 2, 4, 6, 6, 6, 4, 2 ], -3 ], [ [ 2, 4, 6, 6, 6, 4, 2 ], -3 ] ];


CHEVIE.H3.vpolfakedegrees:=
[ [ [ 1 ], 15 ], [ [ 1 ], 0 ], [ [ 1, 0, 1, 0, 1, 0, 1, 0, 1 ], 5 ], 
  [ [ 1, 0, 1, 0, 1, 0, 1, 0, 1 ], 2 ], [ [ 1, 0, 0, 0, 1, 0, 0, 0, 1 ], 6 ], 
  [ [ 1, 0, 1, 0, 1 ], 8 ], [ [ 1, 0, 0, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ 1, 0, 1, 0, 1 ], 3 ], [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1 ], 3 ], 
  [ [ 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 4 ] ];

###########################################################################
##
#F CHEVIE.H3.HeckeCharTable( <v> )  character table of the Hecke algebra of
## type H3
##
## Note: the parameter for the Hecke algebra is <v>^2.
##

CHEVIE.H3.HeckeCharTable:=function(v) local a; a:=(1+ER(5))/2;
return rec( 
  identifier:="H(H3)",
  text:="the representing matrices are those of Lusztig (1981)",
  parameter := [ v^2, v^2, v^2 ], 
  cartan:=CHEVIE.H3.cartan, 
  size := 120, 
  powermap:=CHEVIE.H3.powermap, 
  classtext := CHEVIE.H3.classtext,
  classnames := List(CHEVIE.H3.classtext,IntListToString),
  classparam := List(CHEVIE.H3.classtext,IntListToString),
  orders := CHEVIE.H3.orders, 
  centralizers := CHEVIE.H3.centralizers, 
  classes := CHEVIE.H3.classes,
  irreducibles:=List(CHEVIE.H3.vpolheckeirreducibles,
                     i->List(i,j->FastValue(j,v))),
  irredinfo:=List(CHEVIE.H3.CharParams(),x->
                       rec(charparam:=x,charname:=CHEVIE.H3.CharName(x))),
  operations := CharTableOps );
end;

CHEVIE.H3.representations:=function(v) local a;a:=(1+ER(5))/2; return 
[[[[-1]], [[-1]], [[-1]]], [[[v^2]], [[v^2]], [[v^2]]], [[[-1, 0, 0, 0, 0]
, [0, -1, v, 0, 0], [0, 0, v^2, 0, 0], [0, 0, v, -1, v], [0, 0, 0, 0, v^2]], [[
-1, v, 0, 0, 0], [0, v^2, 0, 0, 0], [0, v, -1, v, 0], [0, 0, 0, v^2, 0], [0, 0
, 0, v, -1]], [[v^2, 0, 0, 0, 0], [v, -1, 0, 0, 0], [0, 0, -1, 0, 0], [0, 0, 0
, -1, v], [0, 0, 0, 0, v^2]]], [[[-1, v, 0, 0, 0], [0, v^2, 0, 0, 0], [0, v, -1
, v, 0], [0, 0, 0, v^2, 0], [0, 0, 0, 0, v^2]], [[v^2, 0, 0, 0, 0], [v, -1, v, 
0, 0], [0, 0, v^2, 0, 0], [0, 0, v, -1, v], [0, 0, 0, 0, v^2]], [[-1, v, 0, 0, 
0], [0, v^2, 0, 0, 0], [0, 0, v^2, 0, 0], [0, 0, 0, v^2, 0], [0, 0, 0, v, -1]]]
, [[[-1, 0, 0], [0, v^2, v+a*v], [0, 0, -1]], [[-1, 0, 0], [0, -1, 0], [v, v, v
^2]], [[v^2, 0, v], [0, -1, 0], [0, 0, -1]]], [[[v^2, 2*v-a*v, 0], [0, -1, 0], 
[0, 0, -1]], [[-1, 0, 0], [v, v^2, v], [0, 0, -1]], [[-1, 0, 0], [0, -1, 0], [0
, v, v^2]]], [[[-1, 0, 0], [v, v^2, 0], [0, 0, v^2]], [[v^2, v+a*v, 0], [0, -1
, 0], [0, v, v^2]], [[v^2, 0, 0], [0, v^2, v], [0, 0, -1]]], [[[-1, 0, 0], [v, 
v^2, 0], [0, 0, v^2]], [[v^2, 2*v-a*v, 0], [0, -1, 0], [0, v, v^2]], [[v^2, 0, 
0], [0, v^2, v], [0, 0, -1]]], [[[v^2, v, 0, 0], [0, -1, 0, 0], [0, v, v^2, v]
, [0, 0, 0, -1]], [[-1, 0, 0, 0], [v, v^2, v, 0], [0, 0, -1, 0], [0, 0, v, v^2]
], [[-1, 0, 0, 0], [0, -1, 0, 0], [v, v, v^2, 0], [0, v, 0, v^2]]], [[[v^2, v, 
0, 0], [0, -1, 0, 0], [0, v, v^2, v], [0, 0, 0, -1]], [[-1, 0, 0, 0], [v, v^2, 
v, 0], [0, 0, -1, 0], [0, 0, v, v^2]], [[-1, 0, 0, 0], [0, -1, 0, 0], [-v, v, v
^2, 0], [0, -v, 0, v^2]]]]*v^0; end;
