#############################################################################
##
#A  coxh4.g               CHEVIE library                         Meinolf Geck 
##
#A  $Id: coxh4.g,v 1.1 1997/01/21 13:46:41 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains the character table of the Hecke algebras of type H4.
##

CHEVIE.H4:=rec();

CHEVIE.H4.classtext:=[ [  ], [ 1 ], [ 1, 2 ], [ 1, 3 ], [ 2, 3 ], [ 1, 2, 3 ], 
  [ 1, 2, 4 ], [ 1, 3, 4 ], [ 2, 4, 3 ], [ 1, 2, 1, 2 ], [ 1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 3 ], [ 1, 2, 1, 2, 4 ], [ 1, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 3, 2, 1, 2, 3, 4 ], [ 1, 2, 1, 2, 3, 2, 1, 2, 3 ], 
  [ 1, 2, 1, 2, 3, 2, 1, 2, 3, 4 ], [ 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3 ], 
  [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 4, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 4, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4 ], 
  [ 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2,
      3, 4 ],
  [ 1, 2, 1, 2, 3, 2, 1, 2, 1, 3, 2, 1, 4, 3, 2, 1, 2, 1, 3, 2, 1, 4, 3, 2, 
      1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 4, 3, 2, 1, 2, 1, 3, 2, 1, 4, 
      3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 
      4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 
      2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 
      4, 3, 2, 1, 2, 1, 3, 2, 1, 4, 3, 2, 1, 2, 3, 4 ], 
  [ 1, 2, 1, 2, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 
      3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4 ]
    , [ 1, 2, 1, 2, 1, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 
      1, 2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 
      3, 4, 3, 2, 1, 2, 1, 3, 2, 1, 2, 3, 4 ] ];

#how to make a .charname from a .charparam
CHEVIE.H4.CharName:= function(x)local s;
  s:=Concatenation("phi_{",String(x[1]),",",String(x[2]),"}");
  if Length(x)=3 then Append(s,x[3]);fi;
  return String(s);
end;

CHEVIE.H4.CharParams:=function()
  return [[ 1, 0 ],[ 1, 60 ],[ 4, 1 ], [ 4, 31 ], [ 4, 7 ],
  [ 4, 37 ], [ 6, 12 ], [ 6, 20 ], [ 8, 12 ], [ 8, 13 ], [ 9, 2 ],
  [ 9, 22 ], [ 9, 6 ], [ 9, 26 ], [ 10, 12 ], [ 16, 11 ],[ 16, 13 ],
  [ 16, 3 ], [ 16, 21 ], [ 16, 6 ], [ 16, 18 ], [ 18, 10 ],[ 24, 11 ],
  [ 24, 7 ], [ 24, 12 ], [ 24, 6 ], [ 25, 4 ], [ 25, 16 ],[ 30, 10 ,"'"],
  [ 30, 10 ,"''"],[ 36, 5 ], [ 36, 15 ],[ 40, 8 ], [ 48, 9 ]];
end;

CHEVIE.H4.cartan:=[ [ 2, -(1+ER(5))/2, 0, 0 ], [ -(1+ER(5))/2, 2, -1, 0 ], 
                  [ 0, -1, 2, -1 ], [ 0, 0, -1, 2 ] ];

CHEVIE.H4.powermap:=
[ , [ 1, 1, 10, 1, 5, 3, 10, 5, 4, 3, 15, 5, 3, 18, 22, 10, 24, 26, 27, 1, 3, 
      15, 30, 32, 5, 33, 27, 22, 34, 33, 10, 32, 26, 1 ], 
  [ 1, 2, 10, 4, 1, 16, 13, 2, 9, 3, 18, 20, 7, 23, 26, 6, 29, 30, 19, 20, 
      31, 33, 14, 34, 34, 33, 27, 30, 29, 18, 21, 1, 26, 34 ],, 
  [ 1, 2, 1, 4, 5, 20, 2, 8, 9, 1, 24, 12, 2, 29, 32, 20, 17, 34, 34, 20, 34, 
      32, 29, 24, 25, 1, 1, 24, 29, 34, 34, 32, 1, 34 ],, 
  [ 1, 2, 10, 4, 5, 16, 13, 8, 9, 3, 28, 12, 7, 23, 22, 6, 17, 30, 19, 20, 
      31, 15, 14, 24, 25, 33, 27, 11, 29, 18, 21, 32, 26, 34 ],,,, 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 ],, 
  [ 1, 2, 10, 4, 5, 16, 13, 8, 9, 3, 28, 12, 7, 23, 22, 6, 17, 30, 19, 20, 
      31, 15, 14, 24, 25, 33, 27, 11, 29, 18, 21, 32, 26, 34 ],,,, 
  [ 1, 2, 10, 4, 5, 16, 13, 8, 9, 3, 28, 12, 7, 23, 22, 6, 17, 30, 19, 20, 
      31, 15, 14, 24, 25, 33, 27, 11, 29, 18, 21, 32, 26, 34 ],, 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 ],,,, 
  [ 1, 2, 10, 4, 5, 16, 13, 8, 9, 3, 28, 12, 7, 23, 22, 6, 17, 30, 19, 20, 
      31, 15, 14, 24, 25, 33, 27, 11, 29, 18, 21, 32, 26, 34 ],,,,,, 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34 ] ];

CHEVIE.H4.orders:=[ 1, 2, 5, 2, 3, 10, 10, 6, 4, 5, 30, 6, 10, 20, 15, 10, 12,
         10, 10, 2, 10, 15, 20, 6, 6, 5, 5, 30, 4, 10, 10, 3, 5, 2 ];

CHEVIE.H4.centralizers:=[ 14400, 240, 100, 32, 36, 20, 20, 12, 8, 100, 30, 12,
  20, 20, 30, 20, 12, 600, 50, 240, 100, 30, 20, 360, 36, 600, 50, 30, 240,
  600, 100, 360, 600, 14400 ];

CHEVIE.H4.classes:=[ 1, 60, 144, 450, 400, 720, 720, 1200, 1800, 144, 480, 
  1200, 720, 720, 480, 720, 1200, 24, 288, 60, 144, 480, 720, 40, 400, 24, 
  288, 480, 60, 24, 144, 40, 24, 1 ];

CHEVIE.H4.PositionId:=function() return 1; end;

CHEVIE.H4.PositionSgn:=function() return 2; end;

CHEVIE.H4.PositionRefl:=function() return 3; end;

CHEVIE.H4.vpolheckeirreducibles:=
[ [ [ [ 1 ], 0 ], [ [ 1 ], 2 ], [ [ 1 ], 4 ], [ [ 1 ], 4 ], [ [ 1 ], 4 ], 
      [ [ 1 ], 6 ], [ [ 1 ], 6 ], [ [ 1 ], 6 ], [ [ 1 ], 6 ], [ [ 1 ], 8 ], 
      [ [ 1 ], 8 ], [ [ 1 ], 10 ], [ [ 1 ], 10 ], [ [ 1 ], 12 ], 
      [ [ 1 ], 16 ], [ [ 1 ], 18 ], [ [ 1 ], 20 ], [ [ 1 ], 24 ], 
      [ [ 1 ], 28 ], [ [ 1 ], 30 ], [ [ 1 ], 32 ], [ [ 1 ], 32 ], 
      [ [ 1 ], 36 ], [ [ 1 ], 40 ], [ [ 1 ], 44 ], [ [ 1 ], 48 ], 
      [ [ 1 ], 52 ], [ [ 1 ], 56 ], [ [ 1 ], 60 ], [ [ 1 ], 72 ], 
      [ [ 1 ], 76 ], [ [ 1 ], 80 ], [ [ 1 ], 96 ], [ [ 1 ], 120 ] ], 
  [ [ [ 1 ], 0 ], [ [ -1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], 
      [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ 1 ], 0 ], [ [ -1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ] ], 
  [ [ [ 4 ], 0 ], [ [ -1, 0, 3 ], 0 ], [ [ E(5)+E(5)^4, 0, 2 ], 2 ], 
      [ [ -2, 0, 2 ], 2 ], [ [ -1, 0, 2 ], 2 ], [ [ E(5)+E(5)^4, 0, 1 ], 4 ], 
      [ [ 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4, 0, 1 ], 4 ], [ [ -2, 0, 1 ], 4 ], 
      [ [ -1, 0, 1 ], 4 ], [ [ E(5)^2+E(5)^3, 0, 0, 0, 2 ], 4 ], 
      [ [ E(5)+E(5)^4 ], 6 ], [ [ 1 ], 10 ], 
      [ [ E(5)^2+E(5)^3, 0, -1, 0, 1 ], 6 ], [ [  ], 0 ], 
      [ [ -E(5)^2-E(5)^3 ], 12 ], [ [ E(5)^2+E(5)^3, 0, 0, 0, 0, 0, 1 ], 12 ],
      [ [  ], 0 ], [ [ -2*E(5)^2-2*E(5)^3 ], 18 ], 
      [ [ -E(5)-E(5)^4, 0, -E(5)^2-E(5)^3 ], 20 ], 
      [ [ -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 20 ], 
      [ [ -2, 0, 0, 0, -E(5)^2-E(5)^3 ], 22 ], [ [ -E(5)-E(5)^4 ], 24 ], 
      [ [  ], 0 ], [ [ 2 ], 30 ], [ [ -2, 0, 1 ], 32 ], 
      [ [ 2*E(5)+2*E(5)^4 ], 36 ], [ [ E(5)^2+E(5)^3, 0, E(5)+E(5)^4 ], 38 ], 
      [ [ E(5)^2+E(5)^3 ], 42 ], [ [  ], 0 ], [ [ -2*E(5)-2*E(5)^4 ], 54 ], 
      [ [ -2, 0, -E(5)-E(5)^4 ], 56 ], [ [ -2 ], 60 ], 
      [ [ 2*E(5)^2+2*E(5)^3 ], 72 ], [ [ -4 ], 90 ] ], 
  [ [ [ 4 ], 0 ], [ [ -3, 0, 1 ], 0 ], [ [ 2, 0, E(5)+E(5)^4 ], 0 ], 
      [ [ 2, 0, -2 ], 0 ], [ [ 2, 0, -1 ], 0 ], 
      [ [ -1, 0, -E(5)-E(5)^4 ], 0 ], 
      [ [ -1, 0, -2*E(5)-E(5)^2-E(5)^3-2*E(5)^4 ], 0 ], [ [ -1, 0, 2 ], 0 ], 
      [ [ -1, 0, 1 ], 0 ], [ [ 2, 0, 0, 0, E(5)^2+E(5)^3 ], 0 ], 
      [ [ E(5)+E(5)^4 ], 2 ], [ [ -1 ], 0 ], 
      [ [ -1, 0, 1, 0, -E(5)^2-E(5)^3 ], 0 ], [ [  ], 0 ], 
      [ [ -E(5)^2-E(5)^3 ], 4 ], [ [ -1, 0, 0, 0, 0, 0, -E(5)^2-E(5)^3 ], 0 ],
      [ [  ], 0 ], [ [ -2*E(5)^2-2*E(5)^3 ], 6 ], 
      [ [ -E(5)^2-E(5)^3, 0, -E(5)-E(5)^4 ], 6 ], 
      [ [ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 ], 0 ], 
      [ [ -E(5)^2-E(5)^3, 0, 0, 0, -2 ], 6 ], [ [ -E(5)-E(5)^4 ], 8 ], 
      [ [  ], 0 ], [ [ 2 ], 10 ], [ [ 1, 0, -2 ], 10 ], 
      [ [ 2*E(5)+2*E(5)^4 ], 12 ], [ [ E(5)+E(5)^4, 0, E(5)^2+E(5)^3 ], 12 ], 
      [ [ E(5)^2+E(5)^3 ], 14 ], [ [  ], 0 ], [ [ -2*E(5)-2*E(5)^4 ], 18 ], 
      [ [ -E(5)-E(5)^4, 0, -2 ], 18 ], [ [ -2 ], 20 ], 
      [ [ 2*E(5)^2+2*E(5)^3 ], 24 ], [ [ -4 ], 30 ] ], 
  [ [ [ 4 ], 0 ], [ [ -1, 0, 3 ], 0 ], [ [ E(5)^2+E(5)^3, 0, 2 ], 2 ], 
      [ [ -2, 0, 2 ], 2 ], [ [ -1, 0, 2 ], 2 ], 
      [ [ E(5)^2+E(5)^3, 0, 1 ], 4 ], 
      [ [ E(5)+2*E(5)^2+2*E(5)^3+E(5)^4, 0, 1 ], 4 ], [ [ -2, 0, 1 ], 4 ], 
      [ [ -1, 0, 1 ], 4 ], [ [ E(5)+E(5)^4, 0, 0, 0, 2 ], 4 ], 
      [ [ E(5)^2+E(5)^3 ], 6 ], [ [ 1 ], 10 ], 
      [ [ E(5)+E(5)^4, 0, -1, 0, 1 ], 6 ], [ [  ], 0 ], 
      [ [ -E(5)-E(5)^4 ], 12 ], [ [ E(5)+E(5)^4, 0, 0, 0, 0, 0, 1 ], 12 ], 
      [ [  ], 0 ], [ [ -2*E(5)-2*E(5)^4 ], 18 ], 
      [ [ -E(5)^2-E(5)^3, 0, -E(5)-E(5)^4 ], 20 ], 
      [ [ -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 20 ], 
      [ [ -2, 0, 0, 0, -E(5)-E(5)^4 ], 22 ], [ [ -E(5)^2-E(5)^3 ], 24 ], 
      [ [  ], 0 ], [ [ 2 ], 30 ], [ [ -2, 0, 1 ], 32 ], 
      [ [ 2*E(5)^2+2*E(5)^3 ], 36 ], [ [ E(5)+E(5)^4, 0, E(5)^2+E(5)^3 ], 38 ]
        , [ [ E(5)+E(5)^4 ], 42 ], [ [  ], 0 ], 
      [ [ -2*E(5)^2-2*E(5)^3 ], 54 ], [ [ -2, 0, -E(5)^2-E(5)^3 ], 56 ], 
      [ [ -2 ], 60 ], [ [ 2*E(5)+2*E(5)^4 ], 72 ], [ [ -4 ], 90 ] ], 
  [ [ [ 4 ], 0 ], [ [ -3, 0, 1 ], 0 ], [ [ 2, 0, E(5)^2+E(5)^3 ], 0 ], 
      [ [ 2, 0, -2 ], 0 ], [ [ 2, 0, -1 ], 0 ], 
      [ [ -1, 0, -E(5)^2-E(5)^3 ], 0 ], 
      [ [ -1, 0, -E(5)-2*E(5)^2-2*E(5)^3-E(5)^4 ], 0 ], [ [ -1, 0, 2 ], 0 ], 
      [ [ -1, 0, 1 ], 0 ], [ [ 2, 0, 0, 0, E(5)+E(5)^4 ], 0 ], 
      [ [ E(5)^2+E(5)^3 ], 2 ], [ [ -1 ], 0 ], 
      [ [ -1, 0, 1, 0, -E(5)-E(5)^4 ], 0 ], [ [  ], 0 ], 
      [ [ -E(5)-E(5)^4 ], 4 ], [ [ -1, 0, 0, 0, 0, 0, -E(5)-E(5)^4 ], 0 ], 
      [ [  ], 0 ], [ [ -2*E(5)-2*E(5)^4 ], 6 ], 
      [ [ -E(5)-E(5)^4, 0, -E(5)^2-E(5)^3 ], 6 ], 
      [ [ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 ], 0 ], 
      [ [ -E(5)-E(5)^4, 0, 0, 0, -2 ], 6 ], [ [ -E(5)^2-E(5)^3 ], 8 ], 
      [ [  ], 0 ], [ [ 2 ], 10 ], [ [ 1, 0, -2 ], 10 ], 
      [ [ 2*E(5)^2+2*E(5)^3 ], 12 ], [ [ E(5)^2+E(5)^3, 0, E(5)+E(5)^4 ], 12 ]
        , [ [ E(5)+E(5)^4 ], 14 ], [ [  ], 0 ], 
      [ [ -2*E(5)^2-2*E(5)^3 ], 18 ], [ [ -E(5)^2-E(5)^3, 0, -2 ], 18 ], 
      [ [ -2 ], 20 ], [ [ 2*E(5)+2*E(5)^4 ], 24 ], [ [ -4 ], 30 ] ], 
  [ [ [ 6 ], 0 ], [ [ -3, 0, 3 ], 0 ], [ [ 1, 0, 2*E(5)+2*E(5)^4, 0, 1 ], 0 ],
      [ [ 1, 0, -4, 0, 1 ], 0 ], [ [ 1, 0, -2, 0, 1 ], 0 ], 
      [ [ -E(5)-E(5)^4, 0, E(5)+E(5)^4 ], 2 ], 
      [ [ -2*E(5)-E(5)^2-E(5)^3-2*E(5)^4, 0, 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4 ], 
          2 ], [ [ 2, 0, -2 ], 2 ], [ [ 1, 0, -1 ], 2 ], 
      [ [ 1, 0, 0, 0, 2*E(5)^2+2*E(5)^3, 0, 0, 0, 1 ], 0 ], 
      [ [ -E(5)-E(5)^4 ], 4 ], [ [  ], 0 ], 
      [ [ 1, 0, -E(5)^2-E(5)^3, 0, E(5)^2+E(5)^3, 0, -1 ], 2 ], 
      [ [ E(5)^2+E(5)^3 ], 6 ], [ [ -E(5)^2-E(5)^3 ], 8 ], 
      [ [ -E(5)^2-E(5)^3, 0, 0, 0, 0, 0, E(5)^2+E(5)^3 ], 6 ], 
      [ [ -1 ], 10 ], [ [ -3*E(5)-4*E(5)^2-4*E(5)^3-3*E(5)^4 ], 12 ], 
      [ [ 1, 0, -1, 0, 1 ], 12 ], [ [ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3 ], 10 ]
        , [ [ 1, 0, 0, 0, 2*E(5)^2+2*E(5)^3, 0, 0, 0, 1 ], 12 ], 
      [ [ -E(5)-E(5)^4 ], 16 ], [ [ E(5)+E(5)^4 ], 18 ], [ [ 3 ], 20 ], 
      [ [ 1, 0, -2, 0, 1 ], 20 ], 
      [ [ -4*E(5)-3*E(5)^2-3*E(5)^3-4*E(5)^4 ], 24 ], 
      [ [ 1, 0, -1, 0, 1 ], 24 ], [ [ -E(5)^2-E(5)^3 ], 28 ], [ [ 2 ], 30 ], 
      [ [ -4*E(5)-3*E(5)^2-3*E(5)^3-4*E(5)^4 ], 36 ], 
      [ [ 1, 0, 2*E(5)+2*E(5)^4, 0, 1 ], 36 ], [ [ 3 ], 40 ], 
      [ [ -3*E(5)-4*E(5)^2-4*E(5)^3-3*E(5)^4 ], 48 ], [ [ 6 ], 60 ] ], 
  [ [ [ 6 ], 0 ], [ [ -3, 0, 3 ], 0 ], 
      [ [ 1, 0, 2*E(5)^2+2*E(5)^3, 0, 1 ], 0 ], [ [ 1, 0, -4, 0, 1 ], 0 ], 
      [ [ 1, 0, -2, 0, 1 ], 0 ], [ [ -E(5)^2-E(5)^3, 0, E(5)^2+E(5)^3 ], 2 ], 
      [ [ -E(5)-2*E(5)^2-2*E(5)^3-E(5)^4, 0, E(5)+2*E(5)^2+2*E(5)^3+E(5)^4 ], 
          2 ], [ [ 2, 0, -2 ], 2 ], [ [ 1, 0, -1 ], 2 ], 
      [ [ 1, 0, 0, 0, 2*E(5)+2*E(5)^4, 0, 0, 0, 1 ], 0 ], 
      [ [ -E(5)^2-E(5)^3 ], 4 ], [ [  ], 0 ], 
      [ [ 1, 0, -E(5)-E(5)^4, 0, E(5)+E(5)^4, 0, -1 ], 2 ], 
      [ [ E(5)+E(5)^4 ], 6 ], [ [ -E(5)-E(5)^4 ], 8 ], 
      [ [ -E(5)-E(5)^4, 0, 0, 0, 0, 0, E(5)+E(5)^4 ], 6 ], [ [ -1 ], 10 ], 
      [ [ -4*E(5)-3*E(5)^2-3*E(5)^3-4*E(5)^4 ], 12 ], 
      [ [ 1, 0, -1, 0, 1 ], 12 ], [ [ 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3 ], 10 ]
        , [ [ 1, 0, 0, 0, 2*E(5)+2*E(5)^4, 0, 0, 0, 1 ], 12 ], 
      [ [ -E(5)^2-E(5)^3 ], 16 ], [ [ E(5)^2+E(5)^3 ], 18 ], [ [ 3 ], 20 ], 
      [ [ 1, 0, -2, 0, 1 ], 20 ], 
      [ [ -3*E(5)-4*E(5)^2-4*E(5)^3-3*E(5)^4 ], 24 ], 
      [ [ 1, 0, -1, 0, 1 ], 24 ], [ [ -E(5)-E(5)^4 ], 28 ], [ [ 2 ], 30 ], 
      [ [ -3*E(5)-4*E(5)^2-4*E(5)^3-3*E(5)^4 ], 36 ], 
      [ [ 1, 0, 2*E(5)^2+2*E(5)^3, 0, 1 ], 36 ], [ [ 3 ], 40 ], 
      [ [ -4*E(5)-3*E(5)^2-3*E(5)^3-4*E(5)^4 ], 48 ], [ [ 6 ], 60 ] ], 
  [ [ [ 8 ], 0 ], [ [ -4, 0, 4 ], 0 ], [ [ -2 ], 2 ], 
      [ [ 2, 0, -4, 0, 2 ], 0 ], [ [ 2, 0, -2, 0, 2 ], 0 ], [ [  ], 0 ], 
      [ [ 1, 0, -1 ], 2 ], [ [ -1, 0, 2, 0, -2, 0, 1 ], 0 ], 
      [ [ -1, 0, 1, 0, -1, 0, 1 ], 0 ], [ [ -2 ], 4 ], [ [  ], 0 ], 
      [ [  ], 0 ], [ [ 1, 0, -1 ], 4 ], [ [ -1 ], 6 ], [ [  ], 0 ], 
      [ [  ], 0 ], [ [ 1 ], 10 ], [ [ 3 ], 12 ], [ [ -2 ], 14 ], [ [  ], 0 ], 
      [ [ -2 ], 16 ], [ [  ], 0 ], [ [ -1 ], 18 ], [ [ 5 ], 20 ], 
      [ [ 2, 0, -2, 0, 2 ], 20 ], [ [ 3 ], 24 ], [ [ -2 ], 26 ], [ [  ], 0 ], 
      [ [ 4 ], 30 ], [ [ 3 ], 36 ], [ [ -2 ], 38 ], [ [ 5 ], 40 ], 
      [ [ 3 ], 48 ], [ [ 8 ], 60 ] ], 
  [ [ [ 8 ], 0 ], [ [ -4, 0, 4 ], 0 ], [ [ -2 ], 2 ], 
      [ [ 2, 0, -4, 0, 2 ], 0 ], [ [ 2, 0, -2, 0, 2 ], 0 ], [ [  ], 0 ], 
      [ [ 1, 0, -1 ], 2 ], [ [ -1, 0, 2, 0, -2, 0, 1 ], 0 ], 
      [ [ -1, 0, 1, 0, -1, 0, 1 ], 0 ], [ [ -2 ], 4 ], [ [ -1 ], 4 ], 
      [ [  ], 0 ], [ [ 1, 0, -1 ], 4 ], [ [  ], 0 ], [ [ 1 ], 8 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ 2 ], 12 ], [ [ -3 ], 14 ], [ [  ], 0 ], 
      [ [ 2 ], 16 ], [ [ 1 ], 16 ], [ [  ], 0 ], [ [ 4 ], 20 ], 
      [ [ 1, 0, -4, 0, 1 ], 20 ], [ [ -2 ], 24 ], [ [ 3 ], 26 ], 
      [ [ -1 ], 28 ], [ [  ], 0 ], [ [ 2 ], 36 ], [ [ 2 ], 38 ], 
      [ [ -4 ], 40 ], [ [ -2 ], 48 ], [ [ -8 ], 60 ] ], 
  [ [ [ 9 ], 0 ], [ [ -3, 0, 6 ], 0 ], 
      [ [ 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4, 0, 3 ], 2 ], 
      [ [ 1, 0, -4, 0, 4 ], 0 ], [ [ -3, 0, 3 ], 2 ], 
      [ [ E(5)+E(5)^4, 0, 1 ], 4 ], [ [ -E(5)-E(5)^4, 0, -2, 0, 2 ], 2 ], 
      [ [ 1, 0, -3, 0, 2 ], 2 ], [ [ -2, 0, 1 ], 4 ], 
      [ [ E(5)+2*E(5)^2+2*E(5)^3+E(5)^4, 0, 0, 0, 3 ], 4 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 1 ], 6 ], [ [ -E(5)^2-E(5)^3, 0, -1, 0, -1, 0, 2 ], 4 ]
        , [ [ E(5)+E(5)^4 ], 8 ], [ [  ], 0 ], 
      [ [ E(5)^2+E(5)^3, 0, 0, 0, 0, 0, 1 ], 12 ], [ [  ], 0 ], 
      [ [ -3*E(5)^2-3*E(5)^3 ], 16 ], 
      [ [ E(5)+2*E(5)^2+2*E(5)^3+E(5)^4, 0, -E(5)^2-E(5)^3 ], 18 ], 
      [ [ 5, 0, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 18 ], 
      [ [ -2*E(5)-2*E(5)^4, 0, 0, 0, -E(5)^2-E(5)^3 ], 20 ], [ [  ], 0 ], 
      [ [ E(5)^2+E(5)^3 ], 24 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -3*E(5)-3*E(5)^4 ], 32 ], 
      [ [ 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4, 0, -E(5)-E(5)^4 ], 34 ], 
      [ [  ], 0 ], [ [ -3 ], 40 ], [ [ -3*E(5)-3*E(5)^4 ], 48 ], 
      [ [ -2*E(5)^2-2*E(5)^3, 0, -E(5)-E(5)^4 ], 50 ], [ [  ], 0 ], 
      [ [ -3*E(5)^2-3*E(5)^3 ], 64 ], [ [ 9 ], 80 ] ], 
  [ [ [ 9 ], 0 ], [ [ -6, 0, 3 ], 0 ], 
      [ [ 3, 0, 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4 ], 0 ], 
      [ [ 4, 0, -4, 0, 1 ], 0 ], [ [ 3, 0, -3 ], 0 ], 
      [ [ -1, 0, -E(5)-E(5)^4 ], 0 ], [ [ -2, 0, 2, 0, E(5)+E(5)^4 ], 0 ], 
      [ [ -2, 0, 3, 0, -1 ], 0 ], [ [ -1, 0, 2 ], 0 ], 
      [ [ 3, 0, 0, 0, E(5)+2*E(5)^2+2*E(5)^3+E(5)^4 ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 1 ], 0 ], [ [ -2, 0, 1, 0, 1, 0, E(5)^2+E(5)^3 ], 0 ], 
      [ [ E(5)+E(5)^4 ], 4 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 0, 0, -E(5)^2-E(5)^3 ], 0 ], [ [  ], 0 ], 
      [ [ -3*E(5)^2-3*E(5)^3 ], 8 ], 
      [ [ -E(5)^2-E(5)^3, 0, E(5)+2*E(5)^2+2*E(5)^3+E(5)^4 ], 8 ], 
      [ [ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, -5 ], 0 ], 
      [ [ -E(5)^2-E(5)^3, 0, 0, 0, -2*E(5)-2*E(5)^4 ], 8 ], [ [  ], 0 ], 
      [ [ E(5)^2+E(5)^3 ], 12 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -3*E(5)-3*E(5)^4 ], 16 ], 
      [ [ -E(5)-E(5)^4, 0, 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4 ], 16 ], 
      [ [  ], 0 ], [ [ -3 ], 20 ], [ [ -3*E(5)-3*E(5)^4 ], 24 ], 
      [ [ -E(5)-E(5)^4, 0, -2*E(5)^2-2*E(5)^3 ], 24 ], [ [  ], 0 ], 
      [ [ -3*E(5)^2-3*E(5)^3 ], 32 ], [ [ 9 ], 40 ] ], 
  [ [ [ 9 ], 0 ], [ [ -3, 0, 6 ], 0 ], 
      [ [ E(5)+2*E(5)^2+2*E(5)^3+E(5)^4, 0, 3 ], 2 ], 
      [ [ 1, 0, -4, 0, 4 ], 0 ], [ [ -3, 0, 3 ], 2 ], 
      [ [ E(5)^2+E(5)^3, 0, 1 ], 4 ], [ [ -E(5)^2-E(5)^3, 0, -2, 0, 2 ], 2 ], 
      [ [ 1, 0, -3, 0, 2 ], 2 ], [ [ -2, 0, 1 ], 4 ], 
      [ [ 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4, 0, 0, 0, 3 ], 4 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 1 ], 6 ], [ [ -E(5)-E(5)^4, 0, -1, 0, -1, 0, 2 ], 4 ], 
      [ [ E(5)^2+E(5)^3 ], 8 ], [ [  ], 0 ], 
      [ [ E(5)+E(5)^4, 0, 0, 0, 0, 0, 1 ], 12 ], [ [  ], 0 ], 
      [ [ -3*E(5)-3*E(5)^4 ], 16 ], 
      [ [ 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4, 0, -E(5)-E(5)^4 ], 18 ], 
      [ [ 5, 0, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 18 ], 
      [ [ -2*E(5)^2-2*E(5)^3, 0, 0, 0, -E(5)-E(5)^4 ], 20 ], [ [  ], 0 ], 
      [ [ E(5)+E(5)^4 ], 24 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -3*E(5)^2-3*E(5)^3 ], 32 ], 
      [ [ E(5)+2*E(5)^2+2*E(5)^3+E(5)^4, 0, -E(5)^2-E(5)^3 ], 34 ], 
      [ [  ], 0 ], [ [ -3 ], 40 ], [ [ -3*E(5)^2-3*E(5)^3 ], 48 ], 
      [ [ -2*E(5)-2*E(5)^4, 0, -E(5)^2-E(5)^3 ], 50 ], [ [  ], 0 ], 
      [ [ -3*E(5)-3*E(5)^4 ], 64 ], [ [ 9 ], 80 ] ], 
  [ [ [ 9 ], 0 ], [ [ -6, 0, 3 ], 0 ], 
      [ [ 3, 0, E(5)+2*E(5)^2+2*E(5)^3+E(5)^4 ], 0 ], 
      [ [ 4, 0, -4, 0, 1 ], 0 ], [ [ 3, 0, -3 ], 0 ], 
      [ [ -1, 0, -E(5)^2-E(5)^3 ], 0 ], [ [ -2, 0, 2, 0, E(5)^2+E(5)^3 ], 0 ],
      [ [ -2, 0, 3, 0, -1 ], 0 ], [ [ -1, 0, 2 ], 0 ], 
      [ [ 3, 0, 0, 0, 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4 ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 1 ], 0 ], [ [ -2, 0, 1, 0, 1, 0, E(5)+E(5)^4 ], 0 ], 
      [ [ E(5)^2+E(5)^3 ], 4 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 0, 0, -E(5)-E(5)^4 ], 0 ], [ [  ], 0 ], 
      [ [ -3*E(5)-3*E(5)^4 ], 8 ], 
      [ [ -E(5)-E(5)^4, 0, 2*E(5)+E(5)^2+E(5)^3+2*E(5)^4 ], 8 ], 
      [ [ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, -5 ], 0 ], 
      [ [ -E(5)-E(5)^4, 0, 0, 0, -2*E(5)^2-2*E(5)^3 ], 8 ], [ [  ], 0 ], 
      [ [ E(5)+E(5)^4 ], 12 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -3*E(5)^2-3*E(5)^3 ], 16 ], 
      [ [ -E(5)^2-E(5)^3, 0, E(5)+2*E(5)^2+2*E(5)^3+E(5)^4 ], 16 ], 
      [ [  ], 0 ], [ [ -3 ], 20 ], [ [ -3*E(5)^2-3*E(5)^3 ], 24 ], 
      [ [ -E(5)^2-E(5)^3, 0, -2*E(5)-2*E(5)^4 ], 24 ], [ [  ], 0 ], 
      [ [ -3*E(5)-3*E(5)^4 ], 32 ], [ [ 9 ], 40 ] ], 
  [ [ [ 10 ], 0 ], [ [ -5, 0, 5 ], 0 ], [ [ 1, 0, -2, 0, 1 ], 0 ], 
      [ [ 3, 0, -4, 0, 3 ], 0 ], [ [ 1, 0, -4, 0, 1 ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 1, 0, -1, 0, 1 ], 0 ], [ [ -1, 0, 2, 0, -2, 0, 1 ], 0 ], 
      [ [ 1, 0, -1 ], 2 ], [ [ 1, 0, 0, 0, -2, 0, 0, 0, 1 ], 0 ], 
      [ [ -1 ], 4 ], [ [ 1, 0, -1 ], 4 ], 
      [ [ -1, 0, 0, 0, 1, 0, -1, 0, 0, 0, 1 ], 0 ], [ [ 1 ], 6 ], 
      [ [ -1 ], 8 ], [ [  ], 0 ], [ [  ], 0 ], [ [ 5 ], 12 ], 
      [ [ 1, 0, -2, 0, 1 ], 12 ], [ [ -5, 0, 0, 0, 0, 0, 5 ], 12 ], 
      [ [ 1, 0, 0, 0, -2, 0, 0, 0, 1 ], 12 ], [ [ -1 ], 16 ], [ [ 1 ], 18 ], 
      [ [ 4 ], 20 ], [ [ 1, 0, -4, 0, 1 ], 20 ], [ [ 5 ], 24 ], 
      [ [ 1, 0, -2, 0, 1 ], 24 ], [ [ -1 ], 28 ], [ [ 6 ], 30 ], 
      [ [ 5 ], 36 ], [ [ 1, 0, -2, 0, 1 ], 36 ], [ [ 4 ], 40 ], 
      [ [ 5 ], 48 ], [ [ 10 ], 60 ] ], 
  [ [ [ 16 ], 0 ], [ [ -8, 0, 8 ], 0 ], [ 
          [ 2, 0, 4*E(5)+2*E(5)^2+2*E(5)^3+4*E(5)^4, 0, 2 ], 0 ], 
      [ [ 4, 0, -8, 0, 4 ], 0 ], [ [ 2, 0, -6, 0, 2 ], 0 ], 
      [ [ -E(5)-E(5)^4, 0, E(5)+E(5)^4 ], 2 ], 
      [ [ -1, 0, -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4, 0, 
              3*E(5)+2*E(5)^2+2*E(5)^3+3*E(5)^4, 0, 1 ], 0 ], 
      [ [ -1, 0, 4, 0, -4, 0, 1 ], 0 ], [ [ 2, 0, -2 ], 2 ], 
      [ [ 2, 0, 0, 0, 2*E(5)+4*E(5)^2+4*E(5)^3+2*E(5)^4, 0, 0, 0, 2 ], 0 ], 
      [ [ E(5)^2+E(5)^3 ], 4 ], [ [ 1, 0, -1 ], 4 ], 
      [ [ -1, 0, 1, 0, -E(5)-2*E(5)^2-2*E(5)^3-E(5)^4, 0, 
              E(5)+2*E(5)^2+2*E(5)^3+E(5)^4, 0, -1, 0, 1 ], 0 ], [ [  ], 0 ], 
      [ [ -E(5)-E(5)^4 ], 8 ], 
      [ [ -E(5)^2-E(5)^3, 0, 0, 0, 0, 0, E(5)^2+E(5)^3 ], 6 ], [ [  ], 0 ], 
      [ [ -2*E(5)-6*E(5)^2-6*E(5)^3-2*E(5)^4 ], 12 ], 
      [ [ -E(5)^2-E(5)^3, 0, E(5)+3*E(5)^2+3*E(5)^3+E(5)^4, 0, -E(5)^2-E(5)^3 
             ], 12 ], [ [ 3, 0, -5, 0, 0, 0, 0, 0, 5, 0, -3 ], 10 ], 
      [ [ -E(5)^2-E(5)^3, 0, 0, 0, -2, 0, 0, 0, -E(5)^2-E(5)^3 ], 12 ], 
      [ [ -E(5)^2-E(5)^3 ], 16 ], [ [  ], 0 ], [ [ 2 ], 20 ], 
      [ [ 1, 0, 0, 0, 1 ], 20 ], [ [ 6*E(5)+2*E(5)^2+2*E(5)^3+6*E(5)^4 ], 24 ]
        , 
      [ [ E(5)+E(5)^4, 0, -3*E(5)-E(5)^2-E(5)^3-3*E(5)^4, 0, E(5)+E(5)^4 ], 
          24 ], [ [ E(5)+E(5)^4 ], 28 ], [ [  ], 0 ], 
      [ [ -6*E(5)-2*E(5)^2-2*E(5)^3-6*E(5)^4 ], 36 ], 
      [ [ -E(5)-E(5)^4, 0, -2, 0, -E(5)-E(5)^4 ], 36 ], [ [ -2 ], 40 ], 
      [ [ 2*E(5)+6*E(5)^2+6*E(5)^3+2*E(5)^4 ], 48 ], [ [ -16 ], 60 ] ], 
  [ [ [ 16 ], 0 ], [ [ -8, 0, 8 ], 0 ], 
      [ [ 2, 0, 2*E(5)+4*E(5)^2+4*E(5)^3+2*E(5)^4, 0, 2 ], 0 ], 
      [ [ 4, 0, -8, 0, 4 ], 0 ], [ [ 2, 0, -6, 0, 2 ], 0 ], 
      [ [ -E(5)^2-E(5)^3, 0, E(5)^2+E(5)^3 ], 2 ], 
      [ [ -1, 0, -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4, 0, 
              2*E(5)+3*E(5)^2+3*E(5)^3+2*E(5)^4, 0, 1 ], 0 ], 
      [ [ -1, 0, 4, 0, -4, 0, 1 ], 0 ], [ [ 2, 0, -2 ], 2 ], 
      [ [ 2, 0, 0, 0, 4*E(5)+2*E(5)^2+2*E(5)^3+4*E(5)^4, 0, 0, 0, 2 ], 0 ], 
      [ [ E(5)+E(5)^4 ], 4 ], [ [ 1, 0, -1 ], 4 ], 
      [ [ -1, 0, 1, 0, -2*E(5)-E(5)^2-E(5)^3-2*E(5)^4, 0, 
              2*E(5)+E(5)^2+E(5)^3+2*E(5)^4, 0, -1, 0, 1 ], 0 ], [ [  ], 0 ], 
      [ [ -E(5)^2-E(5)^3 ], 8 ], 
      [ [ -E(5)-E(5)^4, 0, 0, 0, 0, 0, E(5)+E(5)^4 ], 6 ], [ [  ], 0 ], 
      [ [ -6*E(5)-2*E(5)^2-2*E(5)^3-6*E(5)^4 ], 12 ], 
      [ [ -E(5)-E(5)^4, 0, 3*E(5)+E(5)^2+E(5)^3+3*E(5)^4, 0, -E(5)-E(5)^4 ], 
          12 ], [ [ 3, 0, -5, 0, 0, 0, 0, 0, 5, 0, -3 ], 10 ], 
      [ [ -E(5)-E(5)^4, 0, 0, 0, -2, 0, 0, 0, -E(5)-E(5)^4 ], 12 ], 
      [ [ -E(5)-E(5)^4 ], 16 ], [ [  ], 0 ], [ [ 2 ], 20 ], 
      [ [ 1, 0, 0, 0, 1 ], 20 ], [ [ 2*E(5)+6*E(5)^2+6*E(5)^3+2*E(5)^4 ], 24 ]
        , 
      [ [ E(5)^2+E(5)^3, 0, -E(5)-3*E(5)^2-3*E(5)^3-E(5)^4, 0, E(5)^2+E(5)^3 ]
            , 24 ], [ [ E(5)^2+E(5)^3 ], 28 ], [ [  ], 0 ], 
      [ [ -2*E(5)-6*E(5)^2-6*E(5)^3-2*E(5)^4 ], 36 ], 
      [ [ -E(5)^2-E(5)^3, 0, -2, 0, -E(5)^2-E(5)^3 ], 36 ], [ [ -2 ], 40 ], 
      [ [ 6*E(5)+2*E(5)^2+2*E(5)^3+6*E(5)^4 ], 48 ], [ [ -16 ], 60 ] ], 
  [ [ [ 16 ], 0 ], [ [ -6, 0, 10 ], 0 ], [ [ -3, 0, 4 ], 2 ], 
      [ [ 2, 0, -8, 0, 6 ], 0 ], [ [ 1, 0, -5, 0, 5 ], 0 ], 
      [ [ 1, -1, 0, 1 ], 3 ], [ [ 1, 0, -4, 0, 2 ], 2 ], 
      [ [ 3, 0, -5, 0, 3 ], 2 ], [ [ 1, 0, -3, 0, 2 ], 2 ], 
      [ [ -3, 0, 0, 0, 4 ], 4 ], [ [ 1 ], 5 ], [ [ -1, -1, 0, 0, 0, 1 ], 5 ], 
      [ [ 1, 0, -2, 0, -2, 0, 2 ], 4 ], [ [  ], 0 ], [ [ -1 ], 10 ], 
      [ [ 1, 0, 0, -1, 0, 0, 0, 0, 0, 1 ], 9 ], [ [  ], 0 ], [ [ 4 ], 15 ], 
      [ [ -2, 0, 1 ], 17 ], 
      [ [ -4, 0, 0, 5, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 15 ], 
      [ [ -2, 0, 0, 0, 1 ], 19 ], [ [ -1 ], 20 ], [ [  ], 0 ], 
      [ [ -4 ], 25 ], [ [ -1, 0, 2, 0, -2 ], 25 ], [ [ -4 ], 30 ], 
      [ [ 2, 0, -1 ], 32 ], [ [ 1 ], 35 ], [ [  ], 0 ], [ [ 4 ], 45 ], 
      [ [ -2, 0, 1 ], 47 ], [ [ 4 ], 50 ], [ [ -4 ], 60 ], [ [ -16 ], 75 ] ], 
  [ [ [ 16 ], 0 ], [ [ -10, 0, 6 ], 0 ], [ [ 4, 0, -3 ], 0 ], 
      [ [ 6, 0, -8, 0, 2 ], 0 ], [ [ 5, 0, -5, 0, 1 ], 0 ], 
      [ [ -1, 0, 1, -1 ], 0 ], [ [ -2, 0, 4, 0, -1 ], 0 ], 
      [ [ -3, 0, 5, 0, -3 ], 0 ], [ [ -2, 0, 3, 0, -1 ], 0 ], 
      [ [ 4, 0, 0, 0, -3 ], 0 ], [ [ 1 ], 3 ], [ [ -1, 0, 0, 0, 1, 1 ], 0 ], 
      [ [ -2, 0, 2, 0, 2, 0, -1 ], 0 ], [ [  ], 0 ], [ [ -1 ], 6 ], 
      [ [ -1, 0, 0, 0, 0, 0, 1, 0, 0, -1 ], 0 ], [ [  ], 0 ], [ [ 4 ], 9 ], 
      [ [ 1, 0, -2 ], 9 ], 
      [ [ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, -5, 0, 0, 4 ], 0 ], 
      [ [ 1, 0, 0, 0, -2 ], 9 ], [ [ -1 ], 12 ], [ [  ], 0 ], [ [ -4 ], 15 ], 
      [ [ -2, 0, 2, 0, -1 ], 15 ], [ [ -4 ], 18 ], [ [ -1, 0, 2 ], 18 ], 
      [ [ 1 ], 21 ], [ [  ], 0 ], [ [ 4 ], 27 ], [ [ 1, 0, -2 ], 27 ], 
      [ [ 4 ], 30 ], [ [ -4 ], 36 ], [ [ -16 ], 45 ] ], 
  [ [ [ 16 ], 0 ], [ [ -6, 0, 10 ], 0 ], [ [ -3, 0, 4 ], 2 ], 
      [ [ 2, 0, -8, 0, 6 ], 0 ], [ [ 1, 0, -5, 0, 5 ], 0 ], 
      [ [ -1, -1, 0, 1 ], 3 ], [ [ 1, 0, -4, 0, 2 ], 2 ], 
      [ [ 3, 0, -5, 0, 3 ], 2 ], [ [ 1, 0, -3, 0, 2 ], 2 ], 
      [ [ -3, 0, 0, 0, 4 ], 4 ], [ [ -1 ], 5 ], [ [ 1, -1, 0, 0, 0, 1 ], 5 ], 
      [ [ 1, 0, -2, 0, -2, 0, 2 ], 4 ], [ [  ], 0 ], [ [ -1 ], 10 ], 
      [ [ -1, 0, 0, -1, 0, 0, 0, 0, 0, 1 ], 9 ], [ [  ], 0 ], [ [ -4 ], 15 ], 
      [ [ 2, 0, -1 ], 17 ], 
      [ [ 4, 0, 0, 5, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 15 ], 
      [ [ 2, 0, 0, 0, -1 ], 19 ], [ [ -1 ], 20 ], [ [  ], 0 ], [ [ 4 ], 25 ], 
      [ [ 1, 0, -2, 0, 2 ], 25 ], [ [ -4 ], 30 ], [ [ 2, 0, -1 ], 32 ], 
      [ [ -1 ], 35 ], [ [  ], 0 ], [ [ -4 ], 45 ], [ [ 2, 0, -1 ], 47 ], 
      [ [ 4 ], 50 ], [ [ -4 ], 60 ], [ [ 16 ], 75 ] ], 
  [ [ [ 16 ], 0 ], [ [ -10, 0, 6 ], 0 ], [ [ 4, 0, -3 ], 0 ], 
      [ [ 6, 0, -8, 0, 2 ], 0 ], [ [ 5, 0, -5, 0, 1 ], 0 ], 
      [ [ -1, 0, 1, 1 ], 0 ], [ [ -2, 0, 4, 0, -1 ], 0 ], 
      [ [ -3, 0, 5, 0, -3 ], 0 ], [ [ -2, 0, 3, 0, -1 ], 0 ], 
      [ [ 4, 0, 0, 0, -3 ], 0 ], [ [ -1 ], 3 ], [ [ -1, 0, 0, 0, 1, -1 ], 0 ],
      [ [ -2, 0, 2, 0, 2, 0, -1 ], 0 ], [ [  ], 0 ], [ [ -1 ], 6 ], 
      [ [ -1, 0, 0, 0, 0, 0, 1, 0, 0, 1 ], 0 ], [ [  ], 0 ], [ [ -4 ], 9 ], 
      [ [ -1, 0, 2 ], 9 ], 
      [ [ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, -5, 0, 0, -4 ], 0 ], 
      [ [ -1, 0, 0, 0, 2 ], 9 ], [ [ -1 ], 12 ], [ [  ], 0 ], [ [ 4 ], 15 ], 
      [ [ 2, 0, -2, 0, 1 ], 15 ], [ [ -4 ], 18 ], [ [ -1, 0, 2 ], 18 ], 
      [ [ -1 ], 21 ], [ [  ], 0 ], [ [ -4 ], 27 ], [ [ -1, 0, 2 ], 27 ], 
      [ [ 4 ], 30 ], [ [ -4 ], 36 ], [ [ 16 ], 45 ] ], 
  [ [ [ 18 ], 0 ], [ [ -9, 0, 9 ], 0 ], [ [ 1, 0, -4, 0, 1 ], 0 ], 
      [ [ 5, 0, -8, 0, 5 ], 0 ], [ [ 3, 0, -6, 0, 3 ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 2, 0, -2, 0, 1 ], 0 ], [ [ -2, 0, 4, 0, -4, 0, 2 ], 0 ], 
      [ [ -1, 0, 2, 0, -2, 0, 1 ], 0 ], [ [ 1, 0, 0, 0, -4, 0, 0, 0, 1 ], 0 ],
      [ [  ], 0 ], [ [ 1, 0, -1 ], 4 ], 
      [ [ -1, 0, 0, 0, 2, 0, -2, 0, 0, 0, 1 ], 0 ], [ [ -1 ], 6 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [ 3 ], 12 ], 
      [ [ 1, 0, 1, 0, 1 ], 12 ], [ [ -5, 0, 0, 0, 0, 0, 5 ], 12 ], 
      [ [ 1, 0, 0, 0, -4, 0, 0, 0, 1 ], 12 ], [ [  ], 0 ], [ [ -1 ], 18 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ 3 ], 24 ], [ [ 1, 0, 1, 0, 1 ], 24 ], 
      [ [  ], 0 ], [ [ -6 ], 30 ], [ [ 3 ], 36 ], [ [ 1, 0, -4, 0, 1 ], 36 ], 
      [ [  ], 0 ], [ [ 3 ], 48 ], [ [ 18 ], 60 ] ], 
  [ [ [ 24 ], 0 ], [ [ -12, 0, 12 ], 0 ], 
      [ [ 2, 0, 4*E(5)+6*E(5)^2+6*E(5)^3+4*E(5)^4, 0, 2 ], 0 ], 
      [ [ 6, 0, -12, 0, 6 ], 0 ], [ [ 4, 0, -8, 0, 4 ], 0 ], 
      [ [ -E(5)^2-E(5)^3, 0, E(5)^2+E(5)^3 ], 2 ], 
      [ [ -1, 0, -3*E(5)-4*E(5)^2-4*E(5)^3-3*E(5)^4, 0, 
              3*E(5)+4*E(5)^2+4*E(5)^3+3*E(5)^4, 0, 1 ], 0 ], 
      [ [ -2, 0, 6, 0, -6, 0, 2 ], 0 ], [ [ -1, 0, 3, 0, -3, 0, 1 ], 0 ], 
      [ [ 2, 0, 0, 0, 6*E(5)+4*E(5)^2+4*E(5)^3+6*E(5)^4, 0, 0, 0, 2 ], 0 ], 
      [ [ 1 ], 4 ], [ [ 1, 0, -1 ], 4 ], 
      [ [ -1, 0, 1, 0, -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4, 0, 
              3*E(5)+2*E(5)^2+2*E(5)^3+3*E(5)^4, 0, -1, 0, 1 ], 0 ], 
      [ [  ], 0 ], [ [ -1 ], 8 ], 
      [ [ -E(5)-E(5)^4, 0, 0, 0, 0, 0, E(5)+E(5)^4 ], 6 ], [ [  ], 0 ], 
      [ [ 2*E(5)-4*E(5)^2-4*E(5)^3+2*E(5)^4 ], 12 ], 
      [ [ -E(5)^2-E(5)^3, 0, -E(5)+E(5)^2+E(5)^3-E(5)^4, 0, -E(5)^2-E(5)^3 ], 
          12 ], [ [ 3, 0, -5, 0, 0, 0, 0, 0, 5, 0, -3 ], 10 ], 
      [ [ -E(5)^2-E(5)^3, 0, 0, 0, -2*E(5)+2*E(5)^2+2*E(5)^3-2*E(5)^4, 0, 0, 
              0, -E(5)^2-E(5)^3 ], 12 ], [ [ -1 ], 16 ], [ [  ], 0 ], 
      [ [ 6 ], 20 ], [ [ 2, 0, -4, 0, 2 ], 20 ], 
      [ [ 4*E(5)-2*E(5)^2-2*E(5)^3+4*E(5)^4 ], 24 ], 
      [ [ E(5)+E(5)^4, 0, -E(5)+E(5)^2+E(5)^3-E(5)^4, 0, E(5)+E(5)^4 ], 24 ], 
      [ [ 1 ], 28 ], [ [  ], 0 ], 
      [ [ -4*E(5)+2*E(5)^2+2*E(5)^3-4*E(5)^4 ], 36 ], 
      [ [ -E(5)-E(5)^4, 0, 2*E(5)-2*E(5)^2-2*E(5)^3+2*E(5)^4, 0, -E(5)-E(5)^4 
             ], 36 ], [ [ -6 ], 40 ], 
      [ [ -2*E(5)+4*E(5)^2+4*E(5)^3-2*E(5)^4 ], 48 ], [ [ -24 ], 60 ] ], 
  [ [ [ 24 ], 0 ], [ [ -12, 0, 12 ], 0 ], 
      [ [ 2, 0, 6*E(5)+4*E(5)^2+4*E(5)^3+6*E(5)^4, 0, 2 ], 0 ], 
      [ [ 6, 0, -12, 0, 6 ], 0 ], [ [ 4, 0, -8, 0, 4 ], 0 ], 
      [ [ -E(5)-E(5)^4, 0, E(5)+E(5)^4 ], 2 ], 
      [ [ -1, 0, -4*E(5)-3*E(5)^2-3*E(5)^3-4*E(5)^4, 0, 
              4*E(5)+3*E(5)^2+3*E(5)^3+4*E(5)^4, 0, 1 ], 0 ], 
      [ [ -2, 0, 6, 0, -6, 0, 2 ], 0 ], [ [ -1, 0, 3, 0, -3, 0, 1 ], 0 ], 
      [ [ 2, 0, 0, 0, 4*E(5)+6*E(5)^2+6*E(5)^3+4*E(5)^4, 0, 0, 0, 2 ], 0 ], 
      [ [ 1 ], 4 ], [ [ 1, 0, -1 ], 4 ], 
      [ [ -1, 0, 1, 0, -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4, 0, 
              2*E(5)+3*E(5)^2+3*E(5)^3+2*E(5)^4, 0, -1, 0, 1 ], 0 ], 
      [ [  ], 0 ], [ [ -1 ], 8 ], 
      [ [ -E(5)^2-E(5)^3, 0, 0, 0, 0, 0, E(5)^2+E(5)^3 ], 6 ], [ [  ], 0 ], 
      [ [ -4*E(5)+2*E(5)^2+2*E(5)^3-4*E(5)^4 ], 12 ], 
      [ [ -E(5)-E(5)^4, 0, E(5)-E(5)^2-E(5)^3+E(5)^4, 0, -E(5)-E(5)^4 ], 12 ],
      [ [ 3, 0, -5, 0, 0, 0, 0, 0, 5, 0, -3 ], 10 ], 
      [ [ -E(5)-E(5)^4, 0, 0, 0, 2*E(5)-2*E(5)^2-2*E(5)^3+2*E(5)^4, 0, 0, 0, 
              -E(5)-E(5)^4 ], 12 ], [ [ -1 ], 16 ], [ [  ], 0 ], 
      [ [ 6 ], 20 ], [ [ 2, 0, -4, 0, 2 ], 20 ], 
      [ [ -2*E(5)+4*E(5)^2+4*E(5)^3-2*E(5)^4 ], 24 ], 
      [ [ E(5)^2+E(5)^3, 0, E(5)-E(5)^2-E(5)^3+E(5)^4, 0, E(5)^2+E(5)^3 ], 24 
         ], [ [ 1 ], 28 ], [ [  ], 0 ], 
      [ [ 2*E(5)-4*E(5)^2-4*E(5)^3+2*E(5)^4 ], 36 ], 
      [ [ -E(5)^2-E(5)^3, 0, -2*E(5)+2*E(5)^2+2*E(5)^3-2*E(5)^4, 0, 
              -E(5)^2-E(5)^3 ], 36 ], [ [ -6 ], 40 ], 
      [ [ 4*E(5)-2*E(5)^2-2*E(5)^3+4*E(5)^4 ], 48 ], [ [ -24 ], 60 ] ], 
  [ [ [ 24 ], 0 ], [ [ -12, 0, 12 ], 0 ], 
      [ [ 2, 0, 4*E(5)+6*E(5)^2+6*E(5)^3+4*E(5)^4, 0, 2 ], 0 ], 
      [ [ 6, 0, -12, 0, 6 ], 0 ], [ [ 4, 0, -8, 0, 4 ], 0 ], 
      [ [ -E(5)^2-E(5)^3, 0, E(5)^2+E(5)^3 ], 2 ], 
      [ [ -1, 0, -3*E(5)-4*E(5)^2-4*E(5)^3-3*E(5)^4, 0, 
              3*E(5)+4*E(5)^2+4*E(5)^3+3*E(5)^4, 0, 1 ], 0 ], 
      [ [ -2, 0, 6, 0, -6, 0, 2 ], 0 ], [ [ -1, 0, 3, 0, -3, 0, 1 ], 0 ], 
      [ [ 2, 0, 0, 0, 6*E(5)+4*E(5)^2+4*E(5)^3+6*E(5)^4, 0, 0, 0, 2 ], 0 ], 
      [ [ -E(5)-E(5)^4 ], 4 ], [ [ 1, 0, -1 ], 4 ], 
      [ [ -1, 0, 1, 0, -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4, 0, 
              3*E(5)+2*E(5)^2+2*E(5)^3+3*E(5)^4, 0, -1, 0, 1 ], 0 ], 
      [ [ 1 ], 6 ], [ [ -E(5)^2-E(5)^3 ], 8 ], 
      [ [ -E(5)-E(5)^4, 0, 0, 0, 0, 0, E(5)+E(5)^4 ], 6 ], [ [ -1 ], 10 ], 
      [ [ 3*E(5)-E(5)^2-E(5)^3+3*E(5)^4 ], 12 ], 
      [ [ E(5)+E(5)^4, 0, -E(5)+E(5)^2+E(5)^3-E(5)^4, 0, E(5)+E(5)^4 ], 12 ], 
      [ [ 3, 0, -5, 0, 0, 0, 0, 0, 5, 0, -3 ], 10 ], 
      [ [ E(5)+E(5)^4, 0, 0, 0, 0, 0, 0, 0, E(5)+E(5)^4 ], 12 ], 
      [ [ -E(5)-E(5)^4 ], 16 ], [ [ 1 ], 18 ], [ [ 3 ], 20 ], 
      [ [ 1, 0, -2, 0, 1 ], 20 ], [ [ -E(5)+3*E(5)^2+3*E(5)^3-E(5)^4 ], 24 ], 
      [ [ E(5)^2+E(5)^3, 0, E(5)-E(5)^2-E(5)^3+E(5)^4, 0, E(5)^2+E(5)^3 ], 24 
         ], [ [ -E(5)^2-E(5)^3 ], 28 ], [ [ -4 ], 30 ], 
      [ [ -E(5)+3*E(5)^2+3*E(5)^3-E(5)^4 ], 36 ], 
      [ [ E(5)^2+E(5)^3, 0, 0, 0, E(5)^2+E(5)^3 ], 36 ], [ [ 3 ], 40 ], 
      [ [ 3*E(5)-E(5)^2-E(5)^3+3*E(5)^4 ], 48 ], [ [ 24 ], 60 ] ], 
  [ [ [ 24 ], 0 ], [ [ -12, 0, 12 ], 0 ], 
      [ [ 2, 0, 6*E(5)+4*E(5)^2+4*E(5)^3+6*E(5)^4, 0, 2 ], 0 ], 
      [ [ 6, 0, -12, 0, 6 ], 0 ], [ [ 4, 0, -8, 0, 4 ], 0 ], 
      [ [ -E(5)-E(5)^4, 0, E(5)+E(5)^4 ], 2 ], 
      [ [ -1, 0, -4*E(5)-3*E(5)^2-3*E(5)^3-4*E(5)^4, 0, 
              4*E(5)+3*E(5)^2+3*E(5)^3+4*E(5)^4, 0, 1 ], 0 ], 
      [ [ -2, 0, 6, 0, -6, 0, 2 ], 0 ], [ [ -1, 0, 3, 0, -3, 0, 1 ], 0 ], 
      [ [ 2, 0, 0, 0, 4*E(5)+6*E(5)^2+6*E(5)^3+4*E(5)^4, 0, 0, 0, 2 ], 0 ], 
      [ [ -E(5)^2-E(5)^3 ], 4 ], [ [ 1, 0, -1 ], 4 ], 
      [ [ -1, 0, 1, 0, -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4, 0, 
              2*E(5)+3*E(5)^2+3*E(5)^3+2*E(5)^4, 0, -1, 0, 1 ], 0 ], 
      [ [ 1 ], 6 ], [ [ -E(5)-E(5)^4 ], 8 ], 
      [ [ -E(5)^2-E(5)^3, 0, 0, 0, 0, 0, E(5)^2+E(5)^3 ], 6 ], 
      [ [ -1 ], 10 ], [ [ -E(5)+3*E(5)^2+3*E(5)^3-E(5)^4 ], 12 ], 
      [ [ E(5)^2+E(5)^3, 0, E(5)-E(5)^2-E(5)^3+E(5)^4, 0, E(5)^2+E(5)^3 ], 12 
         ], [ [ 3, 0, -5, 0, 0, 0, 0, 0, 5, 0, -3 ], 10 ], 
      [ [ E(5)^2+E(5)^3, 0, 0, 0, 0, 0, 0, 0, E(5)^2+E(5)^3 ], 12 ], 
      [ [ -E(5)^2-E(5)^3 ], 16 ], [ [ 1 ], 18 ], [ [ 3 ], 20 ], 
      [ [ 1, 0, -2, 0, 1 ], 20 ], [ [ 3*E(5)-E(5)^2-E(5)^3+3*E(5)^4 ], 24 ], 
      [ [ E(5)+E(5)^4, 0, -E(5)+E(5)^2+E(5)^3-E(5)^4, 0, E(5)+E(5)^4 ], 24 ], 
      [ [ -E(5)-E(5)^4 ], 28 ], [ [ -4 ], 30 ], 
      [ [ 3*E(5)-E(5)^2-E(5)^3+3*E(5)^4 ], 36 ], 
      [ [ E(5)+E(5)^4, 0, 0, 0, E(5)+E(5)^4 ], 36 ], [ [ 3 ], 40 ], 
      [ [ -E(5)+3*E(5)^2+3*E(5)^3-E(5)^4 ], 48 ], [ [ 24 ], 60 ] ], 
  [ [ [ 25 ], 0 ], [ [ -10, 0, 15 ], 0 ], [ [ -5, 0, 5 ], 2 ], 
      [ [ 4, 0, -12, 0, 9 ], 0 ], [ [ 2, 0, -8, 0, 7 ], 0 ], 
      [ [ -1, 0, 1 ], 4 ], [ [ 2, 0, -5, 0, 3 ], 2 ], 
      [ [ -1, 0, 4, 0, -8, 0, 4 ], 0 ], [ [ 2, 0, -4, 0, 3 ], 2 ], 
      [ [ -5, 0, 0, 0, 5 ], 4 ], [ [  ], 0 ], [ [ -2, 0, 0, 0, 1 ], 6 ], 
      [ [ 2, 0, -3, 0, -2, 0, 3 ], 4 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 0, 0, 1 ], 12 ], [ [ -1 ], 12 ], [ [  ], 0 ], 
      [ [  ], 0 ], [ [ 10, 0, -6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 18 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -5 ], 24 ], 
      [ [ -1, 0, 4, 0, -2 ], 24 ], [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ 5 ], 36 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -5 ], 48 ], [ [  ], 0 ], 
      [ [ 25 ], 72 ] ], 
  [ [ [ 25 ], 0 ], [ [ -15, 0, 10 ], 0 ], [ [ 5, 0, -5 ], 0 ], 
      [ [ 9, 0, -12, 0, 4 ], 0 ], [ [ 7, 0, -8, 0, 2 ], 0 ], 
      [ [ -1, 0, 1 ], 0 ], [ [ -3, 0, 5, 0, -2 ], 0 ], 
      [ [ -4, 0, 8, 0, -4, 0, 1 ], 0 ], [ [ -3, 0, 4, 0, -2 ], 0 ], 
      [ [ 5, 0, 0, 0, -5 ], 0 ], [ [  ], 0 ], [ [ -1, 0, 0, 0, 2 ], 0 ], 
      [ [ -3, 0, 2, 0, 3, 0, -2 ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 0, 0, 1 ], 0 ], [ [ -1 ], 8 ], [ [  ], 0 ], 
      [ [  ], 0 ], [ [ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, -10 ], 0 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -5 ], 16 ], 
      [ [ -2, 0, 4, 0, -1 ], 16 ], [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ 5 ], 24 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -5 ], 32 ], [ [  ], 0 ], 
      [ [ 25 ], 48 ] ], 
  [ [ [ 30 ], 0 ], [ [ -15, 0, 15 ], 0 ], [ [ 3, 0, -6, 0, 3 ], 0 ], 
      [ [ 7, 0, -16, 0, 7 ], 0 ], [ [ 5, 0, -10, 0, 5 ], 0 ], 
      [ [ 1, 0, -1 ], 2 ], [ [ -1, 0, 5, 0, -5, 0, 1 ], 0 ], 
      [ [ -2, 0, 8, 0, -8, 0, 2 ], 0 ], [ [ -1, 0, 4, 0, -4, 0, 1 ], 0 ], 
      [ [ 3, 0, 0, 0, -6, 0, 0, 0, 3 ], 0 ], [ [ E(5)+E(5)^4 ], 4 ], 
      [ [ 1, 0, -1 ], 4 ], [ [ -1, 0, 2, 0, 3, 0, -3, 0, -2, 0, 1 ], 0 ], 
      [ [ -E(5)-E(5)^4 ], 6 ], [ [ E(5)^2+E(5)^3 ], 8 ], 
      [ [ 1, 0, 0, 0, 0, 0, -1 ], 6 ], [ [ 1 ], 10 ], 
      [ [ -5*E(5)^2-5*E(5)^3 ], 12 ], 
      [ [ -E(5)^2-E(5)^3, 0, 2*E(5)^2+2*E(5)^3, 0, -E(5)^2-E(5)^3 ], 12 ], 
      [ [ 6, 0, -5, 0, 0, 0, 0, 0, 5, 0, -6 ], 10 ], 
      [ [ -E(5)^2-E(5)^3, 0, 0, 0, 2*E(5)^2+2*E(5)^3, 0, 0, 0, -E(5)^2-E(5)^3 
             ], 12 ], [ [ E(5)+E(5)^4 ], 16 ], [ [ -E(5)^2-E(5)^3 ], 18 ], 
      [ [ -3 ], 20 ], [ [ -1, 0, 2, 0, -1 ], 20 ], 
      [ [ -5*E(5)-5*E(5)^4 ], 24 ], 
      [ [ -E(5)-E(5)^4, 0, 2*E(5)+2*E(5)^4, 0, -E(5)-E(5)^4 ], 24 ], 
      [ [ E(5)^2+E(5)^3 ], 28 ], [ [ -2 ], 30 ], [ [ -5*E(5)-5*E(5)^4 ], 36 ],
      [ [ -E(5)-E(5)^4, 0, 2*E(5)+2*E(5)^4, 0, -E(5)-E(5)^4 ], 36 ], 
      [ [ -3 ], 40 ], [ [ -5*E(5)^2-5*E(5)^3 ], 48 ], [ [ 30 ], 60 ] ], 
  [ [ [ 30 ], 0 ], [ [ -15, 0, 15 ], 0 ], [ [ 3, 0, -6, 0, 3 ], 0 ], 
      [ [ 7, 0, -16, 0, 7 ], 0 ], [ [ 5, 0, -10, 0, 5 ], 0 ], 
      [ [ 1, 0, -1 ], 2 ], [ [ -1, 0, 5, 0, -5, 0, 1 ], 0 ], 
      [ [ -2, 0, 8, 0, -8, 0, 2 ], 0 ], [ [ -1, 0, 4, 0, -4, 0, 1 ], 0 ], 
      [ [ 3, 0, 0, 0, -6, 0, 0, 0, 3 ], 0 ], [ [ E(5)^2+E(5)^3 ], 4 ], 
      [ [ 1, 0, -1 ], 4 ], [ [ -1, 0, 2, 0, 3, 0, -3, 0, -2, 0, 1 ], 0 ], 
      [ [ -E(5)^2-E(5)^3 ], 6 ], [ [ E(5)+E(5)^4 ], 8 ], 
      [ [ 1, 0, 0, 0, 0, 0, -1 ], 6 ], [ [ 1 ], 10 ], 
      [ [ -5*E(5)-5*E(5)^4 ], 12 ], 
      [ [ -E(5)-E(5)^4, 0, 2*E(5)+2*E(5)^4, 0, -E(5)-E(5)^4 ], 12 ], 
      [ [ 6, 0, -5, 0, 0, 0, 0, 0, 5, 0, -6 ], 10 ], 
      [ [ -E(5)-E(5)^4, 0, 0, 0, 2*E(5)+2*E(5)^4, 0, 0, 0, -E(5)-E(5)^4 ], 12 
         ], [ [ E(5)^2+E(5)^3 ], 16 ], [ [ -E(5)-E(5)^4 ], 18 ], 
      [ [ -3 ], 20 ], [ [ -1, 0, 2, 0, -1 ], 20 ], 
      [ [ -5*E(5)^2-5*E(5)^3 ], 24 ], 
      [ [ -E(5)^2-E(5)^3, 0, 2*E(5)^2+2*E(5)^3, 0, -E(5)^2-E(5)^3 ], 24 ], 
      [ [ E(5)+E(5)^4 ], 28 ], [ [ -2 ], 30 ], [ [ -5*E(5)^2-5*E(5)^3 ], 36 ],
      [ [ -E(5)^2-E(5)^3, 0, 2*E(5)^2+2*E(5)^3, 0, -E(5)^2-E(5)^3 ], 36 ], 
      [ [ -3 ], 40 ], [ [ -5*E(5)-5*E(5)^4 ], 48 ], [ [ 30 ], 60 ] ], 
  [ [ [ 36 ], 0 ], [ [ -15, 0, 21 ], 0 ], [ [ 1, 0, -7, 0, 7 ], 0 ], 
      [ [ 6, 0, -18, 0, 12 ], 0 ], [ [ 3, 0, -12, 0, 9 ], 0 ], 
      [ [ -2, 0, 1 ], 4 ], [ [ 4, 0, -7, 0, 4 ], 2 ], 
      [ [ -1, 0, 7, 0, -11, 0, 5 ], 0 ], [ [ 3, 0, -6, 0, 3 ], 2 ], 
      [ [ 1, 0, 0, 0, -7, 0, 0, 0, 7 ], 0 ], [ [  ], 0 ], 
      [ [ 1, 0, -2, 0, 0, 0, 1 ], 4 ], [ [ 1, 0, 3, 0, -4, 0, -3, 0, 4 ], 2 ],
      [ [  ], 0 ], [ [  ], 0 ], [ [ -2, 0, 0, 0, 0, 0, 1 ], 12 ], 
      [ [  ], 0 ], [ [ -6 ], 14 ], [ [ -1, 0, 2, 0, -2 ], 14 ], 
      [ [ -5, 0, 0, 0, 0, 0, 10, 0, -12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 12 ],
      [ [ -1, 0, 0, 0, 2, 0, 0, 0, -2 ], 14 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ 6 ], 28 ], [ [ 1, 0, -2, 0, 2 ], 28 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ -6 ], 42 ], [ [ -1, 0, 2, 0, -2 ], 42 ], 
      [ [  ], 0 ], [ [ 6 ], 56 ], [ [ -36 ], 70 ] ], 
  [ [ [ 36 ], 0 ], [ [ -21, 0, 15 ], 0 ], [ [ 7, 0, -7, 0, 1 ], 0 ], 
      [ [ 12, 0, -18, 0, 6 ], 0 ], [ [ 9, 0, -12, 0, 3 ], 0 ], 
      [ [ -1, 0, 2 ], 0 ], [ [ -4, 0, 7, 0, -4 ], 0 ], 
      [ [ -5, 0, 11, 0, -7, 0, 1 ], 0 ], [ [ -3, 0, 6, 0, -3 ], 0 ], 
      [ [ 7, 0, 0, 0, -7, 0, 0, 0, 1 ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 2, 0, -1 ], 0 ], 
      [ [ -4, 0, 3, 0, 4, 0, -3, 0, -1 ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 0, 0, 2 ], 0 ], [ [  ], 0 ], [ [ -6 ], 10 ], 
      [ [ -2, 0, 2, 0, -1 ], 10 ], 
      [ [ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, -10, 0, 0, 0, 0, 0, 5 ], 0 ], 
      [ [ -2, 0, 0, 0, 2, 0, 0, 0, -1 ], 10 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ 6 ], 20 ], [ [ 2, 0, -2, 0, 1 ], 20 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ -6 ], 30 ], [ [ -2, 0, 2, 0, -1 ], 30 ], 
      [ [  ], 0 ], [ [ 6 ], 40 ], [ [ -36 ], 50 ] ], 
  [ [ [ 40 ], 0 ], [ [ -20, 0, 20 ], 0 ], [ [ 4, 0, -8, 0, 4 ], 0 ], 
      [ [ 10, 0, -20, 0, 10 ], 0 ], [ [ 6, 0, -14, 0, 6 ], 0 ], 
      [ [ 1, 0, -1 ], 2 ], [ [ -2, 0, 6, 0, -6, 0, 2 ], 0 ], 
      [ [ -3, 0, 10, 0, -10, 0, 3 ], 0 ], [ [ -1, 0, 5, 0, -5, 0, 1 ], 0 ], 
      [ [ 4, 0, 0, 0, -8, 0, 0, 0, 4 ], 0 ], [ [ 1 ], 4 ], 
      [ [ 2, 0, -2 ], 4 ], [ [ -2, 0, 2, 0, 4, 0, -4, 0, -2, 0, 2 ], 0 ], 
      [ [ -1 ], 6 ], [ [ 1 ], 8 ], [ [ 1, 0, 0, 0, 0, 0, -1 ], 6 ], 
      [ [ 1 ], 10 ], [ [ -5 ], 12 ], [ [ -1, 0, 2, 0, -1 ], 12 ], 
      [ [ 6, 0, -10, 0, 0, 0, 0, 0, 10, 0, -6 ], 10 ], 
      [ [ -1, 0, 0, 0, 2, 0, 0, 0, -1 ], 12 ], [ [ 1 ], 16 ], [ [ -1 ], 18 ], 
      [ [ 1 ], 20 ], [ [ -2 ], 22 ], [ [ -5 ], 24 ], 
      [ [ -1, 0, 2, 0, -1 ], 24 ], [ [ 1 ], 28 ], [ [ 4 ], 30 ], 
      [ [ -5 ], 36 ], [ [ -1, 0, 2, 0, -1 ], 36 ], [ [ 1 ], 40 ], 
      [ [ -5 ], 48 ], [ [ 40 ], 60 ] ], 
  [ [ [ 48 ], 0 ], [ [ -24, 0, 24 ], 0 ], [ [ 4, 0, -10, 0, 4 ], 0 ], 
      [ [ 12, 0, -24, 0, 12 ], 0 ], [ [ 8, 0, -16, 0, 8 ], 0 ], 
      [ [ 1, 0, -1 ], 2 ], [ [ -2, 0, 7, 0, -7, 0, 2 ], 0 ], 
      [ [ -4, 0, 12, 0, -12, 0, 4 ], 0 ], [ [ -2, 0, 6, 0, -6, 0, 2 ], 0 ], 
      [ [ 4, 0, 0, 0, -10, 0, 0, 0, 4 ], 0 ], [ [ -1 ], 4 ], 
      [ [ 2, 0, -2 ], 4 ], [ [ -2, 0, 2, 0, 5, 0, -5, 0, -2, 0, 2 ], 0 ], 
      [ [  ], 0 ], [ [ 1 ], 8 ], [ [ 1, 0, 0, 0, 0, 0, -1 ], 6 ], 
      [ [  ], 0 ], [ [ 2 ], 12 ], [ [ 1, 0, 0, 0, 1 ], 12 ], 
      [ [ 6, 0, -10, 0, 0, 0, 0, 0, 10, 0, -6 ], 10 ], 
      [ [ 1, 0, 0, 0, 0, 0, 0, 0, 1 ], 12 ], [ [ 1 ], 16 ], [ [  ], 0 ], 
      [ [ -6 ], 20 ], [ [ -2, 0, 4, 0, -2 ], 20 ], [ [ -2 ], 24 ], 
      [ [ -1, 0, 0, 0, -1 ], 24 ], [ [ -1 ], 28 ], [ [  ], 0 ], 
      [ [ 2 ], 36 ], [ [ 1, 0, 0, 0, 1 ], 36 ], [ [ 6 ], 40 ], 
      [ [ -2 ], 48 ], [ [ -48 ], 60 ] ] ];

CHEVIE.H4.vpolschurelms:=
[ [ [ 1, 4, 9, 16, 25, 36, 49, 64, 81, 100, 121, 144, 168, 192, 216, 240, 
          264, 288, 312, 336, 359, 380, 399, 416, 431, 444, 455, 464, 471, 
          476, 478, 476, 471, 464, 455, 444, 431, 416, 399, 380, 359, 336, 
          312, 288, 264, 240, 216, 192, 168, 144, 121, 100, 81, 64, 49, 36, 
          25, 16, 9, 4, 1 ], 0 ], 
  [ [ 1, 4, 9, 16, 25, 36, 49, 64, 81, 100, 121, 144, 168, 192, 216, 240, 
          264, 288, 312, 336, 359, 380, 399, 416, 431, 444, 455, 464, 471, 
          476, 478, 476, 471, 464, 455, 444, 431, 416, 399, 380, 359, 336, 
          312, 288, 264, 240, 216, 192, 168, 144, 121, 100, 81, 64, 49, 36, 
          25, 16, 9, 4, 1 ], -60 ], 
  [ [ -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4, -8*E(5)-12*E(5)^2-12*E(5)^3-8*E(5)^4
            , -18*E(5)-27*E(5)^2-27*E(5)^3-18*E(5)^4, 
          -32*E(5)-48*E(5)^2-48*E(5)^3-32*E(5)^4, 
          -50*E(5)-75*E(5)^2-75*E(5)^3-50*E(5)^4, 
          -72*E(5)-108*E(5)^2-108*E(5)^3-72*E(5)^4, 
          -95*E(5)-140*E(5)^2-140*E(5)^3-95*E(5)^4, 
          -116*E(5)-164*E(5)^2-164*E(5)^3-116*E(5)^4, 
          -135*E(5)-180*E(5)^2-180*E(5)^3-135*E(5)^4, 
          -152*E(5)-188*E(5)^2-188*E(5)^3-152*E(5)^4, 
          -165*E(5)-185*E(5)^2-185*E(5)^3-165*E(5)^4, 
          -172*E(5)-168*E(5)^2-168*E(5)^3-172*E(5)^4, 
          -175*E(5)-145*E(5)^2-145*E(5)^3-175*E(5)^4, 
          -176*E(5)-124*E(5)^2-124*E(5)^3-176*E(5)^4, 
          -175*E(5)-105*E(5)^2-105*E(5)^3-175*E(5)^4, 
          -172*E(5)-88*E(5)^2-88*E(5)^3-172*E(5)^4, 
          -170*E(5)-80*E(5)^2-80*E(5)^3-170*E(5)^4, 
          -172*E(5)-88*E(5)^2-88*E(5)^3-172*E(5)^4, 
          -175*E(5)-105*E(5)^2-105*E(5)^3-175*E(5)^4, 
          -176*E(5)-124*E(5)^2-124*E(5)^3-176*E(5)^4, 
          -175*E(5)-145*E(5)^2-145*E(5)^3-175*E(5)^4, 
          -172*E(5)-168*E(5)^2-168*E(5)^3-172*E(5)^4, 
          -165*E(5)-185*E(5)^2-185*E(5)^3-165*E(5)^4, 
          -152*E(5)-188*E(5)^2-188*E(5)^3-152*E(5)^4, 
          -135*E(5)-180*E(5)^2-180*E(5)^3-135*E(5)^4, 
          -116*E(5)-164*E(5)^2-164*E(5)^3-116*E(5)^4, 
          -95*E(5)-140*E(5)^2-140*E(5)^3-95*E(5)^4, 
          -72*E(5)-108*E(5)^2-108*E(5)^3-72*E(5)^4, 
          -50*E(5)-75*E(5)^2-75*E(5)^3-50*E(5)^4, 
          -32*E(5)-48*E(5)^2-48*E(5)^3-32*E(5)^4, 
          -18*E(5)-27*E(5)^2-27*E(5)^3-18*E(5)^4, 
          -8*E(5)-12*E(5)^2-12*E(5)^3-8*E(5)^4, 
          -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4 ], -1 ], 
  [ [ -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4, -8*E(5)-12*E(5)^2-12*E(5)^3-8*E(5)^4
            , -18*E(5)-27*E(5)^2-27*E(5)^3-18*E(5)^4, 
          -32*E(5)-48*E(5)^2-48*E(5)^3-32*E(5)^4, 
          -50*E(5)-75*E(5)^2-75*E(5)^3-50*E(5)^4, 
          -72*E(5)-108*E(5)^2-108*E(5)^3-72*E(5)^4, 
          -95*E(5)-140*E(5)^2-140*E(5)^3-95*E(5)^4, 
          -116*E(5)-164*E(5)^2-164*E(5)^3-116*E(5)^4, 
          -135*E(5)-180*E(5)^2-180*E(5)^3-135*E(5)^4, 
          -152*E(5)-188*E(5)^2-188*E(5)^3-152*E(5)^4, 
          -165*E(5)-185*E(5)^2-185*E(5)^3-165*E(5)^4, 
          -172*E(5)-168*E(5)^2-168*E(5)^3-172*E(5)^4, 
          -175*E(5)-145*E(5)^2-145*E(5)^3-175*E(5)^4, 
          -176*E(5)-124*E(5)^2-124*E(5)^3-176*E(5)^4, 
          -175*E(5)-105*E(5)^2-105*E(5)^3-175*E(5)^4, 
          -172*E(5)-88*E(5)^2-88*E(5)^3-172*E(5)^4, 
          -170*E(5)-80*E(5)^2-80*E(5)^3-170*E(5)^4, 
          -172*E(5)-88*E(5)^2-88*E(5)^3-172*E(5)^4, 
          -175*E(5)-105*E(5)^2-105*E(5)^3-175*E(5)^4, 
          -176*E(5)-124*E(5)^2-124*E(5)^3-176*E(5)^4, 
          -175*E(5)-145*E(5)^2-145*E(5)^3-175*E(5)^4, 
          -172*E(5)-168*E(5)^2-168*E(5)^3-172*E(5)^4, 
          -165*E(5)-185*E(5)^2-185*E(5)^3-165*E(5)^4, 
          -152*E(5)-188*E(5)^2-188*E(5)^3-152*E(5)^4, 
          -135*E(5)-180*E(5)^2-180*E(5)^3-135*E(5)^4, 
          -116*E(5)-164*E(5)^2-164*E(5)^3-116*E(5)^4, 
          -95*E(5)-140*E(5)^2-140*E(5)^3-95*E(5)^4, 
          -72*E(5)-108*E(5)^2-108*E(5)^3-72*E(5)^4, 
          -50*E(5)-75*E(5)^2-75*E(5)^3-50*E(5)^4, 
          -32*E(5)-48*E(5)^2-48*E(5)^3-32*E(5)^4, 
          -18*E(5)-27*E(5)^2-27*E(5)^3-18*E(5)^4, 
          -8*E(5)-12*E(5)^2-12*E(5)^3-8*E(5)^4, 
          -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4 ], -31 ], 
  [ [ -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4, -12*E(5)-8*E(5)^2-8*E(5)^3-12*E(5)^4
            , -27*E(5)-18*E(5)^2-18*E(5)^3-27*E(5)^4, 
          -48*E(5)-32*E(5)^2-32*E(5)^3-48*E(5)^4, 
          -75*E(5)-50*E(5)^2-50*E(5)^3-75*E(5)^4, 
          -108*E(5)-72*E(5)^2-72*E(5)^3-108*E(5)^4, 
          -140*E(5)-95*E(5)^2-95*E(5)^3-140*E(5)^4, 
          -164*E(5)-116*E(5)^2-116*E(5)^3-164*E(5)^4, 
          -180*E(5)-135*E(5)^2-135*E(5)^3-180*E(5)^4, 
          -188*E(5)-152*E(5)^2-152*E(5)^3-188*E(5)^4, 
          -185*E(5)-165*E(5)^2-165*E(5)^3-185*E(5)^4, 
          -168*E(5)-172*E(5)^2-172*E(5)^3-168*E(5)^4, 
          -145*E(5)-175*E(5)^2-175*E(5)^3-145*E(5)^4, 
          -124*E(5)-176*E(5)^2-176*E(5)^3-124*E(5)^4, 
          -105*E(5)-175*E(5)^2-175*E(5)^3-105*E(5)^4, 
          -88*E(5)-172*E(5)^2-172*E(5)^3-88*E(5)^4, 
          -80*E(5)-170*E(5)^2-170*E(5)^3-80*E(5)^4, 
          -88*E(5)-172*E(5)^2-172*E(5)^3-88*E(5)^4, 
          -105*E(5)-175*E(5)^2-175*E(5)^3-105*E(5)^4, 
          -124*E(5)-176*E(5)^2-176*E(5)^3-124*E(5)^4, 
          -145*E(5)-175*E(5)^2-175*E(5)^3-145*E(5)^4, 
          -168*E(5)-172*E(5)^2-172*E(5)^3-168*E(5)^4, 
          -185*E(5)-165*E(5)^2-165*E(5)^3-185*E(5)^4, 
          -188*E(5)-152*E(5)^2-152*E(5)^3-188*E(5)^4, 
          -180*E(5)-135*E(5)^2-135*E(5)^3-180*E(5)^4, 
          -164*E(5)-116*E(5)^2-116*E(5)^3-164*E(5)^4, 
          -140*E(5)-95*E(5)^2-95*E(5)^3-140*E(5)^4, 
          -108*E(5)-72*E(5)^2-72*E(5)^3-108*E(5)^4, 
          -75*E(5)-50*E(5)^2-50*E(5)^3-75*E(5)^4, 
          -48*E(5)-32*E(5)^2-32*E(5)^3-48*E(5)^4, 
          -27*E(5)-18*E(5)^2-18*E(5)^3-27*E(5)^4, 
          -12*E(5)-8*E(5)^2-8*E(5)^3-12*E(5)^4, 
          -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4 ], -1 ], 
  [ [ -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4, -12*E(5)-8*E(5)^2-8*E(5)^3-12*E(5)^4
            , -27*E(5)-18*E(5)^2-18*E(5)^3-27*E(5)^4, 
          -48*E(5)-32*E(5)^2-32*E(5)^3-48*E(5)^4, 
          -75*E(5)-50*E(5)^2-50*E(5)^3-75*E(5)^4, 
          -108*E(5)-72*E(5)^2-72*E(5)^3-108*E(5)^4, 
          -140*E(5)-95*E(5)^2-95*E(5)^3-140*E(5)^4, 
          -164*E(5)-116*E(5)^2-116*E(5)^3-164*E(5)^4, 
          -180*E(5)-135*E(5)^2-135*E(5)^3-180*E(5)^4, 
          -188*E(5)-152*E(5)^2-152*E(5)^3-188*E(5)^4, 
          -185*E(5)-165*E(5)^2-165*E(5)^3-185*E(5)^4, 
          -168*E(5)-172*E(5)^2-172*E(5)^3-168*E(5)^4, 
          -145*E(5)-175*E(5)^2-175*E(5)^3-145*E(5)^4, 
          -124*E(5)-176*E(5)^2-176*E(5)^3-124*E(5)^4, 
          -105*E(5)-175*E(5)^2-175*E(5)^3-105*E(5)^4, 
          -88*E(5)-172*E(5)^2-172*E(5)^3-88*E(5)^4, 
          -80*E(5)-170*E(5)^2-170*E(5)^3-80*E(5)^4, 
          -88*E(5)-172*E(5)^2-172*E(5)^3-88*E(5)^4, 
          -105*E(5)-175*E(5)^2-175*E(5)^3-105*E(5)^4, 
          -124*E(5)-176*E(5)^2-176*E(5)^3-124*E(5)^4, 
          -145*E(5)-175*E(5)^2-175*E(5)^3-145*E(5)^4, 
          -168*E(5)-172*E(5)^2-172*E(5)^3-168*E(5)^4, 
          -185*E(5)-165*E(5)^2-165*E(5)^3-185*E(5)^4, 
          -188*E(5)-152*E(5)^2-152*E(5)^3-188*E(5)^4, 
          -180*E(5)-135*E(5)^2-135*E(5)^3-180*E(5)^4, 
          -164*E(5)-116*E(5)^2-116*E(5)^3-164*E(5)^4, 
          -140*E(5)-95*E(5)^2-95*E(5)^3-140*E(5)^4, 
          -108*E(5)-72*E(5)^2-72*E(5)^3-108*E(5)^4, 
          -75*E(5)-50*E(5)^2-50*E(5)^3-75*E(5)^4, 
          -48*E(5)-32*E(5)^2-32*E(5)^3-48*E(5)^4, 
          -27*E(5)-18*E(5)^2-18*E(5)^3-27*E(5)^4, 
          -12*E(5)-8*E(5)^2-8*E(5)^3-12*E(5)^4, 
          -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4 ], -31 ], 
  [ [ -30*E(5)-60*E(5)^2-60*E(5)^3-30*E(5)^4, 
          -180*E(5)-390*E(5)^2-390*E(5)^3-180*E(5)^4, 
          -480*E(5)-1080*E(5)^2-1080*E(5)^3-480*E(5)^4, 
          -690*E(5)-1500*E(5)^2-1500*E(5)^3-690*E(5)^4, 
          -420*E(5)-630*E(5)^2-630*E(5)^3-420*E(5)^4, 
          270*E(5)+1290*E(5)^2+1290*E(5)^3+270*E(5)^4, 
          660*E(5)+2340*E(5)^2+2340*E(5)^3+660*E(5)^4, 
          270*E(5)+1290*E(5)^2+1290*E(5)^3+270*E(5)^4, 
          -420*E(5)-630*E(5)^2-630*E(5)^3-420*E(5)^4, 
          -690*E(5)-1500*E(5)^2-1500*E(5)^3-690*E(5)^4, 
          -480*E(5)-1080*E(5)^2-1080*E(5)^3-480*E(5)^4, 
          -180*E(5)-390*E(5)^2-390*E(5)^3-180*E(5)^4, 
          -30*E(5)-60*E(5)^2-60*E(5)^3-30*E(5)^4 ], -6 ], 
  [ [ -60*E(5)-30*E(5)^2-30*E(5)^3-60*E(5)^4, 
          -390*E(5)-180*E(5)^2-180*E(5)^3-390*E(5)^4, 
          -1080*E(5)-480*E(5)^2-480*E(5)^3-1080*E(5)^4, 
          -1500*E(5)-690*E(5)^2-690*E(5)^3-1500*E(5)^4, 
          -630*E(5)-420*E(5)^2-420*E(5)^3-630*E(5)^4, 
          1290*E(5)+270*E(5)^2+270*E(5)^3+1290*E(5)^4, 
          2340*E(5)+660*E(5)^2+660*E(5)^3+2340*E(5)^4, 
          1290*E(5)+270*E(5)^2+270*E(5)^3+1290*E(5)^4, 
          -630*E(5)-420*E(5)^2-420*E(5)^3-630*E(5)^4, 
          -1500*E(5)-690*E(5)^2-690*E(5)^3-1500*E(5)^4, 
          -1080*E(5)-480*E(5)^2-480*E(5)^3-1080*E(5)^4, 
          -390*E(5)-180*E(5)^2-180*E(5)^3-390*E(5)^4, 
          -60*E(5)-30*E(5)^2-30*E(5)^3-60*E(5)^4 ], -6 ], 
  [ [ 8, 32, 80, 144, 216, 272, 296, 272, 216, 144, 80, 32, 8 ], -6 ], 
  [ [ 10, 30, 80, 140, 220, 270, 300, 270, 220, 140, 80, 30, 10 ], -6 ], 
  [ [ -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4, -8*E(5)-12*E(5)^2-12*E(5)^3-8*E(5)^4
            , -18*E(5)-27*E(5)^2-27*E(5)^3-18*E(5)^4, 
          -32*E(5)-48*E(5)^2-48*E(5)^3-32*E(5)^4, 
          -47*E(5)-68*E(5)^2-68*E(5)^3-47*E(5)^4, 
          -60*E(5)-80*E(5)^2-80*E(5)^3-60*E(5)^4, 
          -71*E(5)-84*E(5)^2-84*E(5)^3-71*E(5)^4, 80, 
          -89*E(5)-76*E(5)^2-76*E(5)^3-89*E(5)^4, 
          -100*E(5)-80*E(5)^2-80*E(5)^3-100*E(5)^4, 
          -111*E(5)-89*E(5)^2-89*E(5)^3-111*E(5)^4, 
          -120*E(5)-100*E(5)^2-100*E(5)^3-120*E(5)^4, 
          -124*E(5)-106*E(5)^2-106*E(5)^3-124*E(5)^4, 
          -120*E(5)-100*E(5)^2-100*E(5)^3-120*E(5)^4, 
          -111*E(5)-89*E(5)^2-89*E(5)^3-111*E(5)^4, 
          -100*E(5)-80*E(5)^2-80*E(5)^3-100*E(5)^4, 
          -89*E(5)-76*E(5)^2-76*E(5)^3-89*E(5)^4, 80, 
          -71*E(5)-84*E(5)^2-84*E(5)^3-71*E(5)^4, 
          -60*E(5)-80*E(5)^2-80*E(5)^3-60*E(5)^4, 
          -47*E(5)-68*E(5)^2-68*E(5)^3-47*E(5)^4, 
          -32*E(5)-48*E(5)^2-48*E(5)^3-32*E(5)^4, 
          -18*E(5)-27*E(5)^2-27*E(5)^3-18*E(5)^4, 
          -8*E(5)-12*E(5)^2-12*E(5)^3-8*E(5)^4, 
          -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4 ], -2 ], 
  [ [ -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4, -8*E(5)-12*E(5)^2-12*E(5)^3-8*E(5)^4
            , -18*E(5)-27*E(5)^2-27*E(5)^3-18*E(5)^4, 
          -32*E(5)-48*E(5)^2-48*E(5)^3-32*E(5)^4, 
          -47*E(5)-68*E(5)^2-68*E(5)^3-47*E(5)^4, 
          -60*E(5)-80*E(5)^2-80*E(5)^3-60*E(5)^4, 
          -71*E(5)-84*E(5)^2-84*E(5)^3-71*E(5)^4, 80, 
          -89*E(5)-76*E(5)^2-76*E(5)^3-89*E(5)^4, 
          -100*E(5)-80*E(5)^2-80*E(5)^3-100*E(5)^4, 
          -111*E(5)-89*E(5)^2-89*E(5)^3-111*E(5)^4, 
          -120*E(5)-100*E(5)^2-100*E(5)^3-120*E(5)^4, 
          -124*E(5)-106*E(5)^2-106*E(5)^3-124*E(5)^4, 
          -120*E(5)-100*E(5)^2-100*E(5)^3-120*E(5)^4, 
          -111*E(5)-89*E(5)^2-89*E(5)^3-111*E(5)^4, 
          -100*E(5)-80*E(5)^2-80*E(5)^3-100*E(5)^4, 
          -89*E(5)-76*E(5)^2-76*E(5)^3-89*E(5)^4, 80, 
          -71*E(5)-84*E(5)^2-84*E(5)^3-71*E(5)^4, 
          -60*E(5)-80*E(5)^2-80*E(5)^3-60*E(5)^4, 
          -47*E(5)-68*E(5)^2-68*E(5)^3-47*E(5)^4, 
          -32*E(5)-48*E(5)^2-48*E(5)^3-32*E(5)^4, 
          -18*E(5)-27*E(5)^2-27*E(5)^3-18*E(5)^4, 
          -8*E(5)-12*E(5)^2-12*E(5)^3-8*E(5)^4, 
          -2*E(5)-3*E(5)^2-3*E(5)^3-2*E(5)^4 ], -22 ], 
  [ [ -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4, -12*E(5)-8*E(5)^2-8*E(5)^3-12*E(5)^4
            , -27*E(5)-18*E(5)^2-18*E(5)^3-27*E(5)^4, 
          -48*E(5)-32*E(5)^2-32*E(5)^3-48*E(5)^4, 
          -68*E(5)-47*E(5)^2-47*E(5)^3-68*E(5)^4, 
          -80*E(5)-60*E(5)^2-60*E(5)^3-80*E(5)^4, 
          -84*E(5)-71*E(5)^2-71*E(5)^3-84*E(5)^4, 80, 
          -76*E(5)-89*E(5)^2-89*E(5)^3-76*E(5)^4, 
          -80*E(5)-100*E(5)^2-100*E(5)^3-80*E(5)^4, 
          -89*E(5)-111*E(5)^2-111*E(5)^3-89*E(5)^4, 
          -100*E(5)-120*E(5)^2-120*E(5)^3-100*E(5)^4, 
          -106*E(5)-124*E(5)^2-124*E(5)^3-106*E(5)^4, 
          -100*E(5)-120*E(5)^2-120*E(5)^3-100*E(5)^4, 
          -89*E(5)-111*E(5)^2-111*E(5)^3-89*E(5)^4, 
          -80*E(5)-100*E(5)^2-100*E(5)^3-80*E(5)^4, 
          -76*E(5)-89*E(5)^2-89*E(5)^3-76*E(5)^4, 80, 
          -84*E(5)-71*E(5)^2-71*E(5)^3-84*E(5)^4, 
          -80*E(5)-60*E(5)^2-60*E(5)^3-80*E(5)^4, 
          -68*E(5)-47*E(5)^2-47*E(5)^3-68*E(5)^4, 
          -48*E(5)-32*E(5)^2-32*E(5)^3-48*E(5)^4, 
          -27*E(5)-18*E(5)^2-18*E(5)^3-27*E(5)^4, 
          -12*E(5)-8*E(5)^2-8*E(5)^3-12*E(5)^4, 
          -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4 ], -2 ], 
  [ [ -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4, -12*E(5)-8*E(5)^2-8*E(5)^3-12*E(5)^4
            , -27*E(5)-18*E(5)^2-18*E(5)^3-27*E(5)^4, 
          -48*E(5)-32*E(5)^2-32*E(5)^3-48*E(5)^4, 
          -68*E(5)-47*E(5)^2-47*E(5)^3-68*E(5)^4, 
          -80*E(5)-60*E(5)^2-60*E(5)^3-80*E(5)^4, 
          -84*E(5)-71*E(5)^2-71*E(5)^3-84*E(5)^4, 80, 
          -76*E(5)-89*E(5)^2-89*E(5)^3-76*E(5)^4, 
          -80*E(5)-100*E(5)^2-100*E(5)^3-80*E(5)^4, 
          -89*E(5)-111*E(5)^2-111*E(5)^3-89*E(5)^4, 
          -100*E(5)-120*E(5)^2-120*E(5)^3-100*E(5)^4, 
          -106*E(5)-124*E(5)^2-124*E(5)^3-106*E(5)^4, 
          -100*E(5)-120*E(5)^2-120*E(5)^3-100*E(5)^4, 
          -89*E(5)-111*E(5)^2-111*E(5)^3-89*E(5)^4, 
          -80*E(5)-100*E(5)^2-100*E(5)^3-80*E(5)^4, 
          -76*E(5)-89*E(5)^2-89*E(5)^3-76*E(5)^4, 80, 
          -84*E(5)-71*E(5)^2-71*E(5)^3-84*E(5)^4, 
          -80*E(5)-60*E(5)^2-60*E(5)^3-80*E(5)^4, 
          -68*E(5)-47*E(5)^2-47*E(5)^3-68*E(5)^4, 
          -48*E(5)-32*E(5)^2-32*E(5)^3-48*E(5)^4, 
          -27*E(5)-18*E(5)^2-18*E(5)^3-27*E(5)^4, 
          -12*E(5)-8*E(5)^2-8*E(5)^3-12*E(5)^4, 
          -3*E(5)-2*E(5)^2-2*E(5)^3-3*E(5)^4 ], -22 ], 
  [ [ 10, 50, 120, 180, 180, 130, 100, 130, 180, 180, 120, 50, 10 ], -6 ], 
  [ [ 20, -40*E(5)-80*E(5)^2-80*E(5)^3-40*E(5)^4, 
          -120*E(5)-200*E(5)^2-200*E(5)^3-120*E(5)^4, 
          -120*E(5)-240*E(5)^2-240*E(5)^3-120*E(5)^4, 140, 
          120*E(5)^2+120*E(5)^3, -20*E(5)+220*E(5)^2+220*E(5)^3-20*E(5)^4, 
          120*E(5)^2+120*E(5)^3, 140, 
          -120*E(5)-240*E(5)^2-240*E(5)^3-120*E(5)^4, 
          -120*E(5)-200*E(5)^2-200*E(5)^3-120*E(5)^4, 
          -40*E(5)-80*E(5)^2-80*E(5)^3-40*E(5)^4, 20 ], -6 ], 
  [ [ 20, -80*E(5)-40*E(5)^2-40*E(5)^3-80*E(5)^4, 
          -200*E(5)-120*E(5)^2-120*E(5)^3-200*E(5)^4, 
          -240*E(5)-120*E(5)^2-120*E(5)^3-240*E(5)^4, 140, 
          120*E(5)+120*E(5)^4, 220*E(5)-20*E(5)^2-20*E(5)^3+220*E(5)^4, 
          120*E(5)+120*E(5)^4, 140, -240*E(5)-120*E(5)^2-120*E(5)^3-240*E(5)^4
            , -200*E(5)-120*E(5)^2-120*E(5)^3-200*E(5)^4, 
          -80*E(5)-40*E(5)^2-40*E(5)^3-80*E(5)^4, 20 ], -6 ], 
  [ [ 2, 8, 18, 30, 42, 52, 58, 60, 60, 60, 60, 60, 60, 60, 60, 58, 52, 42, 
          30, 18, 8, 2 ], -3 ], 
  [ [ 2, 8, 18, 30, 42, 52, 58, 60, 60, 60, 60, 60, 60, 60, 60, 58, 52, 42, 
          30, 18, 8, 2 ], -18 ], 
  [ [ 2, 8, 18, 30, 42, 52, 58, 60, 60, 60, 60, 60, 60, 60, 60, 58, 52, 42, 
          30, 18, 8, 2 ], -3 ], 
  [ [ 2, 8, 18, 30, 42, 52, 58, 60, 60, 60, 60, 60, 60, 60, 60, 58, 52, 42, 
          30, 18, 8, 2 ], -18 ], 
  [ [ 10, 30, 40, 60, 100, 110, 100, 110, 100, 60, 40, 30, 10 ], -6 ], 
  [ [ -150*E(5)-60*E(5)^2-60*E(5)^3-150*E(5)^4, 
          420*E(5)+150*E(5)^2+150*E(5)^3+420*E(5)^4, 
          -1200*E(5)-480*E(5)^2-480*E(5)^3-1200*E(5)^4, 
          2130*E(5)+780*E(5)^2+780*E(5)^3+2130*E(5)^4, 
          -3420*E(5)-1350*E(5)^2-1350*E(5)^3-3420*E(5)^4, 
          4290*E(5)+1590*E(5)^2+1590*E(5)^3+4290*E(5)^4, 
          -4740*E(5)-1860*E(5)^2-1860*E(5)^3-4740*E(5)^4, 
          4290*E(5)+1590*E(5)^2+1590*E(5)^3+4290*E(5)^4, 
          -3420*E(5)-1350*E(5)^2-1350*E(5)^3-3420*E(5)^4, 
          2130*E(5)+780*E(5)^2+780*E(5)^3+2130*E(5)^4, 
          -1200*E(5)-480*E(5)^2-480*E(5)^3-1200*E(5)^4, 
          420*E(5)+150*E(5)^2+150*E(5)^3+420*E(5)^4, 
          -150*E(5)-60*E(5)^2-60*E(5)^3-150*E(5)^4 ], -6 ], 
  [ [ -60*E(5)-150*E(5)^2-150*E(5)^3-60*E(5)^4, 
          150*E(5)+420*E(5)^2+420*E(5)^3+150*E(5)^4, 
          -480*E(5)-1200*E(5)^2-1200*E(5)^3-480*E(5)^4, 
          780*E(5)+2130*E(5)^2+2130*E(5)^3+780*E(5)^4, 
          -1350*E(5)-3420*E(5)^2-3420*E(5)^3-1350*E(5)^4, 
          1590*E(5)+4290*E(5)^2+4290*E(5)^3+1590*E(5)^4, 
          -1860*E(5)-4740*E(5)^2-4740*E(5)^3-1860*E(5)^4, 
          1590*E(5)+4290*E(5)^2+4290*E(5)^3+1590*E(5)^4, 
          -1350*E(5)-3420*E(5)^2-3420*E(5)^3-1350*E(5)^4, 
          780*E(5)+2130*E(5)^2+2130*E(5)^3+780*E(5)^4, 
          -480*E(5)-1200*E(5)^2-1200*E(5)^3-480*E(5)^4, 
          150*E(5)+420*E(5)^2+420*E(5)^3+150*E(5)^4, 
          -60*E(5)-150*E(5)^2-150*E(5)^3-60*E(5)^4 ], -6 ], 
  [ [ -1560*E(5)-600*E(5)^2-600*E(5)^3-1560*E(5)^4, 
          10080*E(5)+3840*E(5)^2+3840*E(5)^3+10080*E(5)^4, 
          -35760*E(5)-13680*E(5)^2-13680*E(5)^3-35760*E(5)^4, 
          86160*E(5)+32880*E(5)^2+32880*E(5)^3+86160*E(5)^4, 
          -155400*E(5)-59400*E(5)^2-59400*E(5)^3-155400*E(5)^4, 
          218160*E(5)+83280*E(5)^2+83280*E(5)^3+218160*E(5)^4, 
          -243960*E(5)-93240*E(5)^2-93240*E(5)^3-243960*E(5)^4, 
          218160*E(5)+83280*E(5)^2+83280*E(5)^3+218160*E(5)^4, 
          -155400*E(5)-59400*E(5)^2-59400*E(5)^3-155400*E(5)^4, 
          86160*E(5)+32880*E(5)^2+32880*E(5)^3+86160*E(5)^4, 
          -35760*E(5)-13680*E(5)^2-13680*E(5)^3-35760*E(5)^4, 
          10080*E(5)+3840*E(5)^2+3840*E(5)^3+10080*E(5)^4, 
          -1560*E(5)-600*E(5)^2-600*E(5)^3-1560*E(5)^4 ], -6 ], 
  [ [ -600*E(5)-1560*E(5)^2-1560*E(5)^3-600*E(5)^4, 
          3840*E(5)+10080*E(5)^2+10080*E(5)^3+3840*E(5)^4, 
          -13680*E(5)-35760*E(5)^2-35760*E(5)^3-13680*E(5)^4, 
          32880*E(5)+86160*E(5)^2+86160*E(5)^3+32880*E(5)^4, 
          -59400*E(5)-155400*E(5)^2-155400*E(5)^3-59400*E(5)^4, 
          83280*E(5)+218160*E(5)^2+218160*E(5)^3+83280*E(5)^4, 
          -93240*E(5)-243960*E(5)^2-243960*E(5)^3-93240*E(5)^4, 
          83280*E(5)+218160*E(5)^2+218160*E(5)^3+83280*E(5)^4, 
          -59400*E(5)-155400*E(5)^2-155400*E(5)^3-59400*E(5)^4, 
          32880*E(5)+86160*E(5)^2+86160*E(5)^3+32880*E(5)^4, 
          -13680*E(5)-35760*E(5)^2-35760*E(5)^3-13680*E(5)^4, 
          3840*E(5)+10080*E(5)^2+10080*E(5)^3+3840*E(5)^4, 
          -600*E(5)-1560*E(5)^2-1560*E(5)^3-600*E(5)^4 ], -6 ], 
  [ [ 1, 4, 9, 16, 24, 32, 39, 44, 47, 48, 48, 48, 47, 44, 39, 32, 24, 16, 9, 
          4, 1 ], -4 ], 
  [ [ 1, 4, 9, 16, 24, 32, 39, 44, 47, 48, 48, 48, 47, 44, 39, 32, 24, 16, 9, 
          4, 1 ], -16 ], 
  [ [ -60*E(5)-30*E(5)^2-30*E(5)^3-60*E(5)^4, -90*E(5)-60*E(5)^2-60*E(5)^3
             -90*E(5)^4, 120*E(5)+120*E(5)^4, 
          60*E(5)-30*E(5)^2-30*E(5)^3+60*E(5)^4, 
          -390*E(5)-180*E(5)^2-180*E(5)^3-390*E(5)^4, 
          -90*E(5)-30*E(5)^2-30*E(5)^3-90*E(5)^4, 
          420*E(5)+180*E(5)^2+180*E(5)^3+420*E(5)^4, 
          -90*E(5)-30*E(5)^2-30*E(5)^3-90*E(5)^4, 
          -390*E(5)-180*E(5)^2-180*E(5)^3-390*E(5)^4, 
          60*E(5)-30*E(5)^2-30*E(5)^3+60*E(5)^4, 120*E(5)+120*E(5)^4, 
          -90*E(5)-60*E(5)^2-60*E(5)^3-90*E(5)^4, 
          -60*E(5)-30*E(5)^2-30*E(5)^3-60*E(5)^4 ], -6 ], 
  [ [ -30*E(5)-60*E(5)^2-60*E(5)^3-30*E(5)^4, 
          -60*E(5)-90*E(5)^2-90*E(5)^3-60*E(5)^4, 120*E(5)^2+120*E(5)^3, 
          -30*E(5)+60*E(5)^2+60*E(5)^3-30*E(5)^4, 
          -180*E(5)-390*E(5)^2-390*E(5)^3-180*E(5)^4, 
          -30*E(5)-90*E(5)^2-90*E(5)^3-30*E(5)^4, 
          180*E(5)+420*E(5)^2+420*E(5)^3+180*E(5)^4, 
          -30*E(5)-90*E(5)^2-90*E(5)^3-30*E(5)^4, 
          -180*E(5)-390*E(5)^2-390*E(5)^3-180*E(5)^4, 
          -30*E(5)+60*E(5)^2+60*E(5)^3-30*E(5)^4, 120*E(5)^2+120*E(5)^3, 
          -60*E(5)-90*E(5)^2-90*E(5)^3-60*E(5)^4, 
          -30*E(5)-60*E(5)^2-60*E(5)^3-30*E(5)^4 ], -6 ], 
  [ [ 1, 4, 8, 12, 16, 20, 24, 28, 32, 36, 38, 36, 32, 28, 24, 20, 16, 12, 8, 
          4, 1 ], -5 ], 
  [ [ 1, 4, 8, 12, 16, 20, 24, 28, 32, 36, 38, 36, 32, 28, 24, 20, 16, 12, 8, 
          4, 1 ], -15 ], 
  [ [ 40, 0, 80, -80, 120, -80, 200, -80, 120, -80, 80, 0, 40 ], -6 ], 
  [ [ 12, 24, 24, 24, 36, 24, 12, 24, 36, 24, 24, 24, 12 ], -6 ] ];

CHEVIE.H4.vpolfakedegrees:=
[ [ [ 1 ], 0 ], [ [ 1 ], 60 ], 
  [ [ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 1 ], 1 ], 
  [ [ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 1 ], 31 ], 
  [ [ 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ], 7 ], 
  [ [ 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ], 37 ], 
  [ [ 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1 ], 12 ], 
  [ [ 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1 ], 20 ], 
  [ [ 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 
          1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1 ], 12 ], 
  [ [ 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 
          1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ], 13 ], 
  [ [ 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 
          0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 
          0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1 ], 22 ], 
  [ [ 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
          1, 0, 0, 0, 1 ], 6 ], 
  [ [ 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
          1, 0, 0, 0, 1 ], 26 ], 
  [ [ 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 
          1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 1 ], 12 ], 
  [ [ 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 2, 0, 1, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 
          0, 0, 1, 0, 2, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1 ], 11 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 2, 0, 0, 0, 2, 0, 1, 0, 1, 0, 2, 0, 0, 0, 
          2, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1 ], 13 ], 
  [ [ 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 2, 0, 1, 0, 0, 0, 
          2, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1 ], 3 ], 
  [ [ 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 2, 0, 0, 0, 1, 0, 2, 0, 1, 0, 1, 0, 
          0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1 ], 21 ], 
  [ [ 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 2, 0, 0, 0, 1, 0, 2, 0, 1, 0, 1, 0, 
          0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 2, 0, 1, 0, 0, 0, 
          2, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1 ], 18 ], 
  [ [ 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 
          1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1 ], 10 ], 
  [ [ 1, 0, 1, 0, 0, 0, 0, 0, 2, 0, 2, 0, 1, 0, 2, 0, 0, 0, 3, 0, 3, 0, 0, 0, 
          2, 0, 1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 1, 0, 1 ], 11 ], 
  [ [ 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 1, 0, 0, 0, 2, 0, 2, 0, 2, 0, 1, 0, 
          1, 0, 2, 0, 2, 0, 2, 0, 0, 0, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 
         ], 7 ], 
  [ [ 1, 0, 1, 0, 0, 0, 2, 0, 1, 0, 2, 0, 1, 0, 1, 0, 2, 0, 2, 0, 2, 0, 1, 0, 
          1, 0, 2, 0, 1, 0, 2, 0, 0, 0, 1, 0, 1 ], 12 ], 
  [ [ 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 1, 0, 
          2, 0, 1, 0, 2, 0, 2, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 
          0, 0, 1 ], 6 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 2, 0, 2, 0, 1, 0, 2, 0, 
          2, 0, 1, 0, 2, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 4 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 2, 0, 2, 0, 1, 0, 2, 0, 
          2, 0, 1, 0, 2, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 16 ], 
  [ [ 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 2, 0, 3, 0, 1, 0, 1, 0, 3, 0, 2, 0, 3, 0, 
          1, 0, 1, 0, 3, 0, 2, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1 ], 10 ], 
  [ [ 1, 0, 0, 0, 1, 0, 2, 0, 1, 0, 2, 0, 1, 0, 2, 0, 3, 0, 1, 0, 2, 0, 1, 0, 
          3, 0, 2, 0, 1, 0, 2, 0, 1, 0, 2, 0, 1, 0, 0, 0, 1 ], 10 ], 
  [ [ 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 4, 0, 2, 0, 
          2, 0, 2, 0, 2, 0, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1 ], 5 ], 
  [ [ 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 4, 0, 2, 0, 
          2, 0, 2, 0, 2, 0, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1 ], 15 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 2, 0, 2, 0, 1, 0, 2, 0, 3, 0, 3, 0, 3, 0, 2, 0, 
          3, 0, 3, 0, 3, 0, 2, 0, 1, 0, 2, 0, 2, 0, 1, 0, 1, 0, 0, 0, 1 ], 8 ]
    , 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 2, 0, 3, 0, 3, 0, 2, 0, 4, 0, 3, 0, 3, 0, 
          4, 0, 2, 0, 3, 0, 3, 0, 2, 0, 2, 0, 2, 0, 1, 0, 1, 0, 1 ], 9 ] ];

###########################################################################
##
#F CHEVIE.H4.HeckeCharTable( <v> ) character table of the Hecke algebra of type H4
##
## Note: the parameter for the Hecke algebra is <v>^2.
##
CHEVIE.H4.HeckeCharTable:=function(v) local a,c; a:=(1+ER(5))/2; 
 return rec( 
  identifier:="H(H4)",
  text := "the ordering of the characters is that of Alvis-Lusztig (1982)",
  parameter := [ v^2, v^2, v^2, v^2 ], 
  cartan:=CHEVIE.H4.cartan, 
  size := 14400, 
  powermap:=CHEVIE.H4.powermap, 
  classtext := CHEVIE.H4.classtext,
  classnames := List(CHEVIE.H4.classtext,IntListToString),
  classparam := List(CHEVIE.H4.classtext,IntListToString),
  orders := CHEVIE.H4.orders, 
  centralizers := CHEVIE.H4.centralizers, 
  classes := CHEVIE.H4.classes,
  irreducibles:=List(CHEVIE.H4.vpolheckeirreducibles,
                     i->List(i,j->FastValue(j,v))),
  irredinfo:=List(CHEVIE.H4.CharParams(),x->
                       rec(charparam:=x,charname:=CHEVIE.H4.CharName(x))),
  operations:=CharTableOps);
end;
