#############################################################################
##
#A  coxi.g                  CHEVIE library                       Meinolf Geck
##
#A  $Id: coxi.g,v 1.1 1997/01/21 13:46:42 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains the character table of the Hecke algebras of type I.
##
##  The characters of the groups I_2(m) are parametrized by [d,b] where
##  d is their degree and b is their b-function, i.e. the valuation
##  of the fake degrees. This identifies uniquely the characters when
##  m is odd. When m is even, there are two characters with
##  [d,b]=[1,m/2]. The one which maps the generators [1,2] to [1,-1]
##  is denoted [1,m/2,"'"] and the one which maps [1,2] to [-1,1] is
##  denoted [1,m/2,"''"].
##  

CHEVIE.I:=rec();

#how to make a .charname from a .charparam
CHEVIE.I.CharName:= function(x)local s;
  s:=Concatenation("phi_{",String(x[1]),",",String(x[2]),"}");
  if Length(x)=3 then Append(s,x[3]);fi;
  return String(s);
end;

CHEVIE.I.CharParams:=function(m)local res;
  res:=[[1,0]];
  if m mod 2=0 then Append(res,[[1,m/2,"'"],[1,m/2,"''"]]);fi;
  Add(res,[1,m]);
  Append(res,List([1..QuoInt(m-1,2)],i->[2,i]));
  return res;
end;

CHEVIE.I.PositionId:=function(m) return 1; end;

CHEVIE.I.PositionSgn:=function(m) 
  if IsInt(m/2) then return 4; else return 2; fi; end;

CHEVIE.I.PositionRefl:=function(m) 
  if IsInt(m/2) then return 5; else return 3; fi;
end;

#############################################################################
##
#F  CHEVIE.I.ClassInfo( <m> ) . . . . conjugacy classes for type I.
##
CHEVIE.I.ClassInfo:=function(m)
  local x,i,r;
  if IsInt(m/2) then
    r:=[[],[1],[2]];
    x:=[1,2];
    for i in [1..m/2] do
      Add(r,Copy(x));
      Append(x,[1,2]);
    od;
  else
    r:=[[],[1]];
    x:=[1,2];
    for i in [1..(m-1)/2] do
      Add(r,Copy(x));
      Append(x,[1,2]);
    od;
  fi;
  return rec(classtext:=r,
	     classnames:=List(r,IntListToString),
	     classparams:=List(r,IntListToString));
end;

##########################################################################
##
#F  CHEVIE.I.HeckeCharTable( <m>, <u> [, <v> [,<squv>]] )  . . . . . . . . .
##  . . . . . . . .  character table of the Hecke algebra of dihedral type
##
##
CHEVIE.I.HeckeCharTable:=function(arg)
  local W,x,i,j,k,r,pr,t,u,v,squv,e,ct,cl,m;
  m:=arg[1]; u:=arg[2];
  if Length(arg)=2 then
    v:=u;squv:=u;
  elif Length(arg)=3 then
    v:=arg[3];
    if u<>v then
      if m mod 2=0 then 
 Error("need sqrtParameters or equal parameters for CharTable(H(I2(",m,")))");
      else Error("only one parameter for H(I2(",m,"))");
      fi;
    else squv:=u;
    fi;
  else
    v:=arg[3];
    squv:=arg[4];
  fi;
  cl:=[1];
  r:=CHEVIE.I.ClassInfo(m).classtext;
  e:=E(m);
  if IsInt(m/2) then
    Append(cl,[m/2,m/2]);
    for i in [1..m/2] do
      Add(cl,2);
    od;
    cl[Length(cl)]:=1;
    t:=[];
    t[1]:=[[[u]],[[v]]];
    t[2]:=[[[u]],[[-u^0]]];
    t[3]:=[[[-v^0]],[[v]]];
    t[4]:=[[[-v^0]],[[-v^0]]];
    ct:=List(t,i->CharRepresentationWords(i,r));
    for j in [1..m/2-1] do
      ct[j+4]:=[];
      for i in [1..Length(r)] do
        k:=Length(r[i])/2;
        if r[i]=[] then
          ct[j+4][i]:=2*v^0;
        elif r[i]=[1] then
          ct[j+4][i]:=u-1;
        elif r[i]=[2] then
          ct[j+4][i]:=v-1;
        else
          ct[j+4][i]:=squv^k*(e^(k*j)+e^(-k*j));
        fi;
      od;
    od;
   # for j in [1..m/2-1] do
   #   Add(t,[[[-u^0,u^0],[0*u,u]],
   #          [[v,0*v],[u+v+squv*(e^j+e^-j),-v^0]]]);
   # od;
  else
    Add(cl,m);
    for i in [1..(m-1)/2] do
      Add(cl,2);
    od;
    t:=[];
    t[1]:=[[[u]],[[v]]];
    t[2]:=[[[-v^0]],[[-v^0]]];
    ct:=List(t,i->CharRepresentationWords(i,r));
    for j in [1..(m-1)/2] do
      ct[j+2]:=[];
      for i in [1..Length(r)] do
        k:=Length(r[i])/2;
        if r[i]=[] then
          ct[j+2][i]:=2*v^0;
        elif r[i]=[1] then
          ct[j+2][i]:=u-1;
        elif r[i]=[2] then
          ct[j+2][i]:=v-1;
        else
          ct[j+2][i]:=squv^k*(e^(k*j)+e^(-k*j));
        fi;
      od;
    od;
   #for j in [1..(m-1)/2] do
   #   Add(t,[[[-u^0,u^0],[0*u,u]],
   #          [[v,0*v],[u+v+squv*(e^j+e^-j),-v^0]]]);
   # od;
  fi;
  if m=2 then 
    W:=CoxeterGroup([[2,0],[0,2]]);
  elif m mod 2=0 then
    W:=CoxeterGroup([[2,-1],[-2-E(m)-E(m)^-1,2]]);
  else 
    W:=CoxeterGroup([[2,-E(2*m)-E(2*m)^-1],[-E(2*m)-E(2*m)^-1,2]]);
  fi;
  return rec(identifier:=ConcatenationString("H(I2(",String(m),"))"), 
           cartan:=W.cartan, size:=2*m, 
	   classtext:=r, 
	   classnames:=CHEVIE.I.ClassInfo(m).classnames, 
	   classparam:=CHEVIE.I.ClassInfo(m).classparams, 
	   irredinfo:=List(CHEVIE.I.CharParams(m),x->rec(
	              charparam:=x,charname:=CHEVIE.I.CharName(x))),
	   parameter:=[u,v], 
           classes:=cl, centralizers:=List(cl,i->2*m/i),
           orders:=List(r,i->OrderPerm(PermCoxeterWord (W,i))), 
           powermap:=[], irreducibles:=ct*v^0, operations:=CharTableOps);
end;

CHEVIE.I.representations:=function(arg)
  local W,x,i,j,k,r,pr,t,u,v,squv,e,ct,cl,m;
  m:=arg[1]; u:=arg[2];
  if Length(arg)=2 then
    v:=u;squv:=u;
  elif Length(arg)=3 then
    v:=arg[3];
    if u<>v then
      if m mod 2=0 then 
 Error("need sqrtParameters or equal parameters for CharTable(H(I2(",m,")))");
      else Error("only one parameter for H(I2(",m,"))");
      fi;
    else squv:=u;
    fi;
  else
    v:=arg[3];
    squv:=arg[4];
  fi;
  e:=E(m);
  if IsInt(m/2) then
    t:=[];
    t[1]:=[[[u]],[[v]]];
    t[2]:=[[[u]],[[-u^0]]];
    t[3]:=[[[-v^0]],[[v]]];
    t[4]:=[[[-v^0]],[[-v^0]]];
    for j in [1..m/2-1] do
      Add(t,[[[-u^0,u^0],[0*u,u]],
             [[v,0*v],[u+v+squv*(e^j+e^-j),-v^0]]]);
    od;
  else
    t:=[];
    t[1]:=[[[u]],[[v]]];
    t[2]:=[[[-v^0]],[[-v^0]]];
   for j in [1..(m-1)/2] do
      Add(t,[[[-u^0,u^0],[0*u,u]],
             [[v,0*v],[u+v+squv*(e^j+e^-j),-v^0]]]);
    od;
  fi;
  return t;
end;

CHEVIE.I.Frobenius:=function(m,sqrtu,j)
  return [[0,1/sqrtu/(E(2*m)^j+E(2*m)^-j)], 
                           [sqrtu*(E(2*m)^j+E(2*m)^-j),0]]*sqrtu^0;
end;
  
CHEVIE.I.PoincarePolynomial:=function(m,u,v)
  if IsInt(m/2) then return Sum([1..m/2],i->(u*v)^(i-1))*(u+1)*(v+1);
  else return Sum([1..m],i->u^(i-1))*(u+1);
  fi;
end;

#############################################################################
##
#F  WEIL.I.SchurElement( <m>, <phi>, <u> [, <v> [,<squv>]] )   . . . . . . .
#F  . . . . . . . . . . . . . . . . . . . . Schur element for dihedral type
##
##  'CHEVIE.I.SchurElement'  returns the constant arising from the
##  Schur relations for the irreducible characters with charparam phi
##  of the Hecke algebra  of type  I  with parameters  u, v.
##
##  The constant corresponding to phi  is  defined  
##  to  be P/D where  P is the Poincare   polynomial and D  is the generic 
##  degree of phi.
##
CHEVIE.I.SchurElement:=function(arg) local m,phi,u,v,squv,i,e,b;
  m:=arg[1]; phi:=arg[2]; u:=arg[3];
  if Length(arg)=3 then v:=u;squv:=u;
  elif Length(arg)=4 then v:=arg[4]; if u=v then squv:=u;fi;
  else v:=arg[4]; squv:=arg[5];
  fi;
  b:=phi[2];
  if phi[1]=1 then
    if b=0 then 
      if IsInt(m/2) then return Sum([1..m/2],i->(u*v)^(i-1))*(u+1)*(v+1);
      else return Sum([1..m],i->u^(i-1))*(u+1);
      fi;
    elif b=m/2 then 
      if phi[3]="'" then 
	   return v^(-m/2)*Sum([1..m/2],i->u^(i-1)*v^(m/2-i))*(u+1)*(v+1);
      else return u^(-m/2)*Sum([1..m/2],i->u^(i-1)*v^(m/2-i))*(u+1)*(v+1);
      fi;
    elif IsInt(m/2) then
           return (u*v)^(-m/2)*Sum([1..m/2],i->(u*v)^(i-1))*(u+1)*(v+1);
    else return u^(-m)*Sum([1..m],i->u^(i-1))*(u+1);
    fi;
  else e:=E(m);
    if not IsBound(squv) then Error(
  "need sqrtParameters or equal parameters for deg.2 SchurElements(I2(",m,"))");
    fi;
    return (squv-e^b)*(squv-e^(-b))*(u+(e^b+e^(-b))*squv+v)*
                                        (-m)/u/v/(e^b-e^(-b))^2;
  fi;
end;

CHEVIE.I.FakeDegree:=function(m,phi,q)
  if phi[1]=1 then return q^phi[2];
  else return q^phi[2]+q^(m-phi[2]);
  fi;
end;

CHEVIE.I.CharB:=function(m,phi)
  if phi[1]=1 then return phi[2];
  else return m-phi[2];
  fi;
end;

CHEVIE.I.Chara:=function(m,phi)
  if phi[1]=1 then 
    if phi[2]=m/2 then return 1;
    else return phi[2];
    fi;
  else return 1;
  fi;
end;

CHEVIE.I.CharA:=function(m,phi)
  if phi[1]=1 then 
    if phi[2]=m/2 then return m-1;
    else return phi[2];
    fi;
  else return m-1;
  fi;
end;
