#############################################################################
##
#A  weyle8.g                   CHEVIE library                     Jean Michel
##
#A  $Id: weyle8.g,v 1.1 1997/01/21 13:46:54 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains the character table of the Hecke algebras of type E8.
##

CHEVIE.E8:=rec();

CHEVIE.E8.classtext:=
    [[],[8,7,8,6,7,8,5,6,7,8,4,5,6,7,8,2,4,5,6,7,
    8,3,4,5,6,7,8,2,4,5,6,7,3,4,5,6,2,4,5,3,4,2,1,
    3,4,5,6,7,8,2,4,5,6,7,3,4,5,6,2,4,5,3,4,2,1,3,
    4,5,6,7,8,2,4,5,6,7,3,4,5,6,2,4,5,3,4,2,1,3,
    4,5,6,7,8,2,4,5,6,3,4,5,2,4,3,1,3,4,5,6,7,2,
    4,5,6,3,4,5,2,4,3,1],
    [5,4,5,2,4,5,3,4,5,2,4,3],[6,1],
    [7,6,7,5,6,7,4,5,6,7,2,4,5,6,7,3,4,5,6,7,2,4,5,
    6,3,4,5,2,4,3],
    [8,7,6,7,5,6,4,5,6,7,2,4,5,6,3,4,5,6,7,8,2,4,5,
    6,3,4,5,1,3,4,5,6,7,8,2,4,5,6,7,3,4,5,6,2,4,
    5,3,4,2,1,3,4,5,6,7,2,4,5,3,1],[7,5,2,3],
    [6,7],
    [1,2,3,1,4,2,3,1,4,3,5,4,2,3,1,4,3,5,4,2,6,5,4,
    2,3,1,4,3,5,4,2,6,5,4,3,1,7,6,5,4,2,3,1,4,3,
    5,4,2,6,5,4,3,1,7,6,5,4,2,3,4,5,6,7,8],
    [8,7,8,6,7,5,6,7,4,2,4,5,3,4,5,6,7,8,2,4,5,6,3,
    4,5,2,1,3,4,5,6,7,8,2,4,5,6,7,3,4,5,6,2,4,5,
    3,4,1,3,4,5,6,7,8,2,4,5,6,7,3,4,5,6,2,4,5,3,
    4,2,1,3,4,5,6,2,4,5,3,4,1],
    [5,6,4,3,4,5,6,7,8,2,4,5,6,3,4,2,1,3,4,5,6,7,8,
    2,4,5,6,7,3,4,5,2,1,3,4,5,6,7,8,2],
    [6,5,2,4,5,6,3,4,5,2,4,3,1,3,4,5,6,2,4,5,3,4,1,
    3],
    [2,3,4,2,3,4,5,4,2,3,1,4,5,6,8,7,6,5,4,2,3,1,4,
    3,5,4,2,6,5,4,3,1,7,6,5,4,2,3,4,5,6,7],
    [7,8,2,4],
    [2,4,2,5,4,2,6,5,4,2,3,4,5,6,7,6,5,4,2,3,4,5,6,
    7,8,7,6,5,4,2,3,1,4,3,5,4,2,6,5,4,3,1,7,8],
    [4,2,4,3,4,5],
    [1,2,3,1,4,2,3,1,4,3,5,4,2,3,1,4,3,5,4,2,6,5,4,
    2,3,1,4,3,5,4,2,6,5,4,3,1,7,6,5,4,2,3,1,4,3,
    5,4,2,6,5,4,3,1,7,8,7,6,5,4,2,3,4,5,6,7,8],
    [2,3,4,2,3,4,6,5,7,6,5,4,2,3,4,5],[3,7,6,8],
    [1,2,3,4,2,3,4,5,4,2,3,4,5,7],
    [4,5,6,7,3,4,5,2,4,3,1,3,4,5,6,7,8,2,4,5,3,4,2,
    1,3,4,5,6,7,8],[7,6,8,1,4,3],[5,6,3,4],
    [3,4,3,5,4,3,6,5,4,3,8,7,6,5,4,2,3,1,4,3,5,4,2,
    6,5,4,3,7,6,5,4,2],
    [7,5,6,2,4,5,3,4,5,6,7,8,2,4,5,6,7,1,3,4,5,6,7,
    8,2,4,5,6,7,3,4,5,2,4,3,1,3,4,5,6,7,8,2,4,5,
    6,3,4],
    [8,7,6,7,5,4,5,6,2,4,3,4,5,6,7,1,3,4,5,6,2,4,5,
    3],[8,7,5,4,5,2,4,5,3,4,5,2,4,3],[5,4,2,3],
    [1,2,3,1,4,2,3,1,4,5,4,2,3,1,4,3,6,5,4,2,3,1,4,
    3,5,4,2,6,5,4,3,1,7,6,5,4,2,3,4,5,6,7,8,7],
    [7,4,5,1],[5,4,5,2,4,5,3,4,5,6,7,2,4,3],
    [8,7,6,7,5,2,4,3,4,5,2,4,1,3,4,5,6,2,4,5],
    [3,4,2,3,5,4,2,3,1,4,5,6],
    [4,3,5,4,2,3,4,5,6,5,4,2,3,4,5,6,7,6,5,4,2,3,4,
    5,6,7,8,7,6,5,4,2,3,1,4,3,5,4,2,6,5,4,3,1,7,8
    ],[2,3,4,2,3,4,5,4,2,3,1,4,5,6],
    [8,7,5,2,4,3],[7,8,5,2,3,1],
    [6,5,6,7,4,2,4,5,3,4],
    [5,4,6,5,4,2,3,7,6,5,4,2,3,8,7,6,5,4,2,3,1,4],
    [6,4,5,2,7,1],[8,5,6,7,2,4],
    [2,7,6,5,4,2,3,4,8,7,6,5,4,2,3,1,4,3],
    [8,5,6,2,3,4],[2,4,2,3,4,5,6,7],
    [2,4,2,5,4,2,3,6,5,4,2,3,4,5,6,7,6,5,4,2,3,1,4,
    3,5,4,2,6,5,4,3,1,7,8],[5,3,4,5,6,2,4,1],
    [3,4,3,5,4,2,3,1,4,3,5,4,2,8,7,6],
    [1,3,4,3,1,5,4,2,3,4,5,8,7,6,5,4,2,3,1,4,3,5,4,
    2,6,5,7,6],[2,3,4,3,1,5,4,2,3,4,5,6,7,8],
    [6,7,8,5,2,1],[7,5,6,2,3,4],
    [6,7,8,5,6,7,4,5,3,4,2,1],[7,8,4,2,3,4,5,2],
    [1,3,1,4,5,4,3,6,5,4,2,3,1,4,3,5,4,2,7,6,5,4,2,
    3,1,4,3,5,4,2,6,5,4,3,1,7,6,5,4,2,3,4,5,6,7,8
    ],[1,2,3,4,2,3,1,4,3,5,4,2,3,1,4,5,6,5,4,2,3,
    4,5,6,8,7],
    [1,2,3,1,4,2,5,4,2,3,1,4,6,5,4,2,3,4,5,6,7,8],
    [6,4,1,5,3,2],
    [1,2,3,1,4,2,3,1,4,3,5,4,3,1,6,5,4,2,3,4,5,6,7,
    8],[5,7,6,2,1,3],[8,1,2,3,4,2,5,4],
    [8,7,6,2,4,5,3,4,1,3],[8,7,6,5,3,1],
    [3,4,2,3,5,4,2,3,4,6,5,4,2,3,7,6,5,4,2,3,1,4,5,
    6,7,8],[8,6,5,4,2,3,4,5,6,7,1,3,4,5,2,4],
    [7,8,6,2,1,3,4,5],[3],
    [7,6,7,5,6,7,4,5,6,7,2,4,5,6,7,3,4,5,6,7,2,4,5,
    6,3,4,5,2,4,3,1,3,4,5,6,7,2,4,5,6,3,4,5,2,4,
    3,1,3,4,5,6,7,2,4,5,6,3,4,5,2,4,3,1],
    [8,6,1],[7,5,4,5,2,4,5,3,4,5,2,4,3],[4,1,3],
    [2,3,4,2,3,4,5,4,2,3,4,5,6,5,4,2,3,4,5,6,7,6,5,
    4,2,3,4,5,6,7,8],[2,3,4,2,3,4,5,4,2,3,4,5,6],
    [8,5,4,2,3,4,2],
    [2,4,2,3,4,5,4,2,3,1,4,3,5,6,5,4,2,3,4,5,6,7,6,
    5,4,2,3,1,4,3,5,6,7],
    [2,3,4,5,4,2,3,4,5,7,6,8,7,6,5,4,2,3,4,5,6],
    [8,5,2,4,1],[4,2,1],
    [2,3,4,2,3,4,5,4,2,3,4,5,6,5,4,2,3,4,5,6,7,6,5,
    4,2,3,1,4,5,6,7],
    [8,5,6,4,5,6,3,4,5,6,2,4,3,1,3,4,5,6,2,4,5,3,4,
    2,1],
    [5,2,4,5,1,3,4,5,6,2,4,5,3,4,2,1,3,4,5,6,7],
    [8,5,2,3,1],[7,5,4,2,3],[8,6,5,3,1],
    [2,3,4,2,3,1,4,5,4,2,6,5,4,2,3,1,4,3,5,4,6,5,7],
    [1,2,3,1,4,2,3,5,4,2,3,1,4,3,5,4,6,5,4,2,3,4,5,
    6,7],[1,2,3,4,2,6,5,4,2,3,4,5,8],
    [7,5,2,6,4],[8,2,3,4,2,3,4,5,4,2,3,1,4,5,6],
    [2,3,5,1,4],[2,3,4,2,3,4,5,4,2,3,4,5,7,6,8],
    [2,3,5,6,5,4,2,3,4,7,6,5,4,2,3,1,4],
    [4,6,8,1,3,5,7],[5,6,2,4,1],
    [6,7,5,4,5,2,4,5,1,3,4,5,2,4,3],
    [2,3,4,2,3,4,5,4,2,3,1,4,5,8,7],
    [4,2,5,4,2,3,1],[7,6,4,2,3],
    [2,3,4,2,3,4,5,7,6,5,4,2,3,4,5,6,8],
    [1,4,2,5,4,2,3,7,8],[6,7,8,5,4,2,3],
    [8,6,4,1,2,3,5],[4,2,5,4,3,1,6,5,7,6,5],
    [8,6,7,2,4,5,1],[5,3,4,5,6,7,2,4,1],
    [8,5,6,3,4,2,1,3,4],[6,7,5,2,4,3,1],
    [8,6,7,4,1,2,3],[7,8,5,6,4,2,4,3,4],
    [7,8,4,5,2,3,1],[4,3,5,4,2,3,4,5,6,8,7],
    [8,6,7,5,2,3,1],[2,4,2,3,1,6,5,4,2,3,4,5,7]];

CHEVIE.E8.classnames:=
[ " ", "8A_1", "4A_1'", "2A_1", "6A_1", "2D_4(a_1)", 
  "4A_1''", "A_2", "D_4+4A_1", "4A_2", "E_8(a_8)", "3A_2", "E_7(a_4)+A_1", 
  "2A_2", "2D_4", "D_4(a_1)", "2A_3+2A_1", "2A_3'", "A_3+A_1", 
  "A_3+3A_1", "D_8(a_3)", "2A_3''", "A_4", "D_6+2A_1", "2A_4", 
  "E_8(a_6)", "A_2+4A_1", "D_4", "E_6(a_2)+A_2", "A_2+2A_1", 
  "D_4+2A_1", "E_8(a_3)", "E_6(a_2)", "A_5+A_2+A_1", "A_5+A_1'", 
  "D_4+A_2", "2A_2+2A_1", "D_6(a_2)", 
  "D_8(a_1)", "A_5+A_1''", "A_6", "D_8", "D_5+A_1", "D_6(a_1)", 
  "A_7+A_1", "E_6(a_1)", "E_7+A_1", "A_8", "E_8(a_4)", "A_4+2A_1", 
  "D_6", "E_8(a_2)", "D_4(a_1)+A_2", "D_5(a_1)+A_3", "E_6+A_2", 
  "E_8(a_7)", "E_6", "E_7(a_2)+A_1", "A_3+A_2+A_1", "D_5(a_1)+A_1", 
  "E_8(a_1)", "A_4+A_2", "D_8(a_2)", "E_8(a_5)", "E_8", "A_1", "7A_1", 
  "3A_1", "5A_1", "A_3", "A_3+4A_1", "A_3+2A_1'", "D_4(a_1)+A_1", 
  "2A_3+A_1", "D_4(a_1)+A_3", "A_3+2A_1''", "A_2+A_1", "D_4+3A_1", 
  "3A_2+A_1", "E_7(a_4)", "A_2+3A_1", "D_4+A_1", "2A_2+A_1", 
  "D_6(a_2)+A_1", "A_5+A_2", "E_6(a_2)+A_1", "A_5", "A_5+2A_1", 
  "D_5", "D_5+2A_1", "A_7'", "A_7''", "A_4+A_1", "D_6+A_1", 
  "A_3+A_2+2A_1", "D_5(a_1)", "A_3+A_2", "D_4+A_3", "D_5(a_1)+A_2", 
  "D_7", "E_6+A_1", "E_7(a_2)", "A_6+A_1", "E_7(a_1)", "E_6(a_1)+A_1", 
  "E_7", "A_4+A_3", "D_7(a_1)", "D_5+A_2", "D_7(a_2)", "A_4+A_2+1", 
  "E_7(a_3)" ];

#how to make a .charname from a .charparam
CHEVIE.E8.CharName:=x->String(Concatenation("phi_{",String(x[1]),
                                        ",",String(x[2]),"}"));

CHEVIE.E8.CharParams:=function()
  return [[1, 0], [1, 120], [28, 8], [28, 68], [35, 2],
     [35, 74], [70, 32], [50, 8], [50, 56], [84, 4], [84, 64],
     [168, 24], [175, 12], [175, 36], [210, 4], [210, 52], [420, 20],
     [300, 8], [300, 44], [350, 14], [350, 38], [525, 12], [525, 36],
     [567, 6], [567, 46], [1134, 20], [700, 16], [700, 28], [700, 6],
     [700, 42], [1400, 20], [840, 14], [840, 26], [1680, 22], [972, 12],
     [972, 32], [1050, 10], [1050, 34], [2100, 20], [1344, 8], [1344, 38],
     [2688, 20], [1400, 8], [1400, 32], [1575, 10], [1575, 34], [3150, 18],
     [2100, 16], [2100, 28], [4200, 18], [2240, 10], [2240, 28], [4480, 16],
     [2268, 10], [2268, 30], [4536, 18], [2835, 14], [2835, 22], [5670, 18],
     [3200, 16], [3200, 22], [4096, 12], [4096, 26], [4200, 12], [4200, 24],
     [6075, 14], [6075, 22], [8, 1], [8, 91], [56, 19], [56, 49],
     [112, 3], [112, 63], [160, 7], [160, 55], [448, 25], [400, 7],
     [400, 43], [448, 9], [448, 39], [560, 5], [560, 47], [1344, 19],
     [840, 13], [840, 31], [1008, 9], [1008, 39], [2016, 19], [1296, 13],
     [1296, 33], [1400, 11], [1400, 29], [1400, 7], [1400, 37], [2400, 17],
     [2400, 23], [2800, 13], [2800, 25], [5600, 19], [3240, 9], [3240, 31],
     [3360, 13], [3360, 25], [7168, 17], [4096, 11], [4096, 27], [4200, 15],
     [4200, 21], [4536, 13], [4536, 23], [5600, 15], [5600, 21]];
end;

CHEVIE.E8.frame:=
[ "1_x", "1_x'", "28_x", "28_x'", "35_x", "35_x'", "70_y", "50_x", "50_x'", 
  "84_x", "84_x'", "168_y", "175_x", "175_x'", "210_x", "210_x'", "420_y", 
  "300_x", "300_x'", "350_x", "350_x'", "525_x", "525_x'", "567_x", "567_x'", 
  "1134_y", "700_xx", "700_xx'", "700_x", "700_x'", "1400_y", "840_x", 
  "840_x'", "1680_y", "972_x", "972_x'", "1050_x", "1050_x'", "2100_y", 
  "1344_x", "1344_x'", "2688_y", "1400_x", "1400_x'", "1575_x", "1575_x'", 
  "3150_y", "2100_x", "2100_x'", "4200_y", "2240_x", "2240_x'", "4480_y", 
  "2268_x", "2268_x'", "4536_y", "2835_x", "2835_x'", "5670_y", "3200_x", 
  "3200_x'", "4096_x", "4096_x'", "4200_x", "4200_x'", "6075_x", "6075_x'", 
  "8_z", "8_z'", "56_z", "56_z'", "112_z", "112_z'", "160_z", "160_z'", 
  "448_w", "400_z", "400_z'", "448_z", "448_z'", "560_z", "560_z'", "1344_w", 
  "840_z", "840_z'", "1008_z", "1008_z'", "2016_w", "1296_z", "1296_z'", 
  "1400_zz", "1400_zz'", "1400_z", "1400_z'", "2400_z", "2400_z'", "2800_z", 
  "2800_z'", "5600_w", "3240_z", "3240_z'", "3360_z", "3360_z'", "7168_w", 
  "4096_z", "4096_z'", "4200_z", "4200_z'", "4536_z", "4536_z'", "5600_z", 
  "5600_z'" ];

CHEVIE.E8.cyclestructure:=
[ [  ], [ 120 ], [ 108 ], [ 90 ], [ 118 ], [ ,, 60 ], [ 116 ], [ , 56 ], 
  [ 36,,,, 28 ], [ , 80 ], [ ,,,, 40 ], [ , 78 ], [ 3,,,, 39 ], [ , 76 ], 
  [ 6,,,, 38 ], [ ,, 54 ], [ 12,, 54 ], [ 10,, 54 ], [ 23,, 45 ], 
  [ 29,, 45 ], [ ,,,,,, 30 ], [ 4,, 58 ], [ ,,, 44 ], [ 10,,,,,,,, 22 ], 
  [ ,,, 48 ], [ ,,,,,,,, 24 ], [ 36, 8,,, 24 ], [ 24,,,, 28 ], [ , 8,,, 36 ], 
  [ 30, 16,,, 20 ], [ 34,,,, 28 ], [ ,,,,,,,,,, 20 ], [ , 6,,, 36 ], 
  [ 3, 8,,, 35 ], [ 3, 6,,, 35 ], [ 6, 8,,, 34 ], [ 6, 20,,, 28 ], 
  [ 4,,,, 38 ], [ ,, 3,,,,,,,, 19 ], [ 5, 2,,, 37 ], [ ,,,,, 34 ], 
  [ 1,,,,,,,,,,,, 17 ], [ 11,,,,,, 27 ], [ ,, 5,,,, 27 ], [ 2,, 5,,,, 27 ], 
  [ ,,,,,,, 26 ], [ 3,,,,,,,,,,,,,,,, 13 ], [ , 2,,,,,, 26 ], 
  [ ,,,, 1,,,,,,,,,,,, 13 ], [ 10,,, 12,,,,, 16 ], [ 8,,,,,,,, 22 ], 
  [ ,,,,,,,,,,,,,,,,,, 12 ], [ , 8, 18,,,,,,,, 12 ], [ ,, 18,, 4,,,,,, 12 ], 
  [ , 8,,,,,,,,, 18 ], [ ,,,, 4,,,,,, 18 ], [ , 6,,,,,,,,, 18 ], 
  [ 3,,,, 3,,,,,, 18 ], [ 5, 4, 15,, 6,,,,,, 10 ], [ 5,, 15,, 8,,,,,, 10 ], 
  [ ,,,,,,,,,,,,,,,,,,,,,, 10 ], [ , 6,, 14,,,,,,,,,, 10 ], 
  [ 1,,,, 3,,,, 7,,,,,,,,,,,,,,,,,,,, 5 ], [ ,,,,,,,,,,,,, 16 ], 
  [ ,,,,,,,,,,,,,,,,,,,,,,,,,,,, 8 ], [ 57 ], [ 119 ], [ 107 ], [ 117 ], 
  [ 10,, 45 ], [ 30,, 45 ], [ 24,, 45 ], [ 9,, 54 ], [ 11,, 54 ], [ 2,, 59 ], 
  [ 28,, 45 ], [ 21, 32,,, 12 ], [ 35,,,, 28 ], [ 3, 42,,, 18 ], 
  [ 2,,,, 39 ], [ 35, 8,,, 24 ], [ 33,,,, 28 ], [ 3, 40,,, 18 ], 
  [ 5,,,, 38 ], [ 2, 8,,, 35 ], [ 3, 2,,, 38 ], [ 2, 6,,, 35 ], 
  [ 6, 2,,, 37 ], [ 6,,,,,, 27 ], [ 12,,,,,, 27 ], [ 1,, 5,,,, 27 ], 
  [ ,, 2,,,, 29 ], [ 7,,, 24,,,,, 10 ], [ 9,,,,,,,, 22 ], 
  [ 6, 4, 15,, 6,,,,,, 10 ], [ ,, 15,, 8,,,,,, 10 ], 
  [ 4, 12, 15,, 2,,,,,, 10 ], [ 6,, 15,, 8,,,,,, 10 ], 
  [ , 4, 3,, 8,,,,,, 14 ], [ 2,, 2,,,,,,,, 19 ], [ 3, 2,,, 2,,,,,, 18 ], 
  [ 2,,,, 3,,,,,, 18 ], [ 1,,,,, 18,,,,,,, 8 ], [ ,,,,,,,,,,,, 17 ], 
  [ 3,,,,,,, 14,,,,,,,,, 6 ], [ 2,,,,,,,,,,,,,,,, 13 ], 
  [ ,, 5, 8,,,,, 2,,,,,,,,,, 8 ], [ ,, 5,,,,,, 6,,,,,,,,,, 8 ], 
  [ , 4,,, 2,, 9,,,,,,,,,,,,,,,, 6 ], [ ,,,, 4,, 9,,,,,,,,,,,,,,,, 6 ], 
  [ 1, 2,, 6, 2,,,, 4,,,,, 6,,,,,,,,,,,,,,, 2 ], 
  [ ,,,, 3,,,, 7,,,,,,,,,,,,,,,,,,,, 5 ] ];

CHEVIE.E8.generators:=[ (  1,121)(  3,  9)( 11, 16)
        ( 17, 23)( 19, 24)( 25, 30)( 27, 31)( 32, 37)
    ( 33, 38)( 35, 39)( 40, 45)( 41, 46)( 43, 47)( 48, 52)( 49, 53)( 50, 54)
    ( 55, 59)( 56, 60)( 61, 66)( 62, 67)( 68, 73)( 74, 79)( 93, 97)( 98,101)
    (102,104)(105,107)(108,109)(110,111)(112,113)(123,129)(131,136)(137,143)
    (139,144)(145,150)(147,151)(152,157)(153,158)(155,159)(160,165)(161,166)
    (163,167)(168,172)(169,173)(170,174)(175,179)(176,180)(181,186)(182,187)
    (188,193)(194,199)(213,217)(218,221)(222,224)(225,227)(228,229)(230,231)
    (232,233), (  2,122)(  4, 10)( 11, 17)( 12, 18)( 16, 23)( 19, 25)( 20, 26)
    ( 24, 30)( 27, 33)( 28, 34)( 31, 38)( 35, 41)( 36, 42)( 39, 46)( 43, 50)
    ( 47, 54)( 63, 69)( 70, 75)( 76, 80)( 77, 81)( 82, 85)( 83, 86)( 87, 90)
    ( 88, 91)( 92, 95)( 96,100)(110,112)(111,113)(114,115)(124,130)(131,137)
    (132,138)(136,143)(139,145)(140,146)(144,150)(147,153)(148,154)(151,158)
    (155,161)(156,162)(159,166)(163,170)(167,174)(183,189)(190,195)(196,200)
    (197,201)(202,205)(203,206)(207,210)(208,211)(212,215)(216,220)(230,232)
    (231,233)(234,235), (  1,  9)(  3,123)(  4, 11)( 10, 17)( 12, 19)( 18, 25)
    ( 20, 27)( 26, 33)( 28, 35)( 34, 41)( 36, 43)( 37, 44)( 42, 50)( 45, 51)
    ( 52, 57)( 53, 58)( 59, 64)( 60, 65)( 66, 71)( 67, 72)( 73, 78)( 79, 84)
    ( 89, 93)( 94, 98)( 99,102)(103,105)(106,108)(111,114)(113,115)(121,129)
    (124,131)(130,137)(132,139)(138,145)(140,147)(146,153)(148,155)(154,161)
    (156,163)(157,164)(162,170)(165,171)(172,177)(173,178)(179,184)(180,185)
    (186,191)(187,192)(193,198)(199,204)(209,213)(214,218)(219,222)(223,225)
    (226,228)(231,234)(233,235), (  2, 10)(  3, 11)(  4,124)(  5, 12)(  9, 16)
    ( 13, 20)( 21, 28)( 25, 32)( 29, 36)( 30, 37)( 33, 40)( 38, 45)( 41, 49)
    ( 46, 53)( 50, 56)( 54, 60)( 57, 63)( 64, 70)( 71, 76)( 72, 77)( 78, 83)
    ( 84, 88)( 85, 89)( 90, 94)( 95, 99)(100,103)(108,110)(109,111)(115,116)
    (122,130)(123,131)(125,132)(129,136)(133,140)(141,148)(145,152)(149,156)
    (150,157)(153,160)(158,165)(161,169)(166,173)(170,176)(174,180)(177,183)
    (184,190)(191,196)(192,197)(198,203)(204,208)(205,209)(210,214)(215,219)
    (220,223)(228,230)(229,231)(235,236), (  4, 12)(  5,125)(  6, 13)( 10, 18)
    ( 11, 19)( 14, 21)( 16, 24)( 17, 25)( 22, 29)( 23, 30)( 40, 48)( 45, 52)
    ( 49, 55)( 51, 57)( 53, 59)( 56, 62)( 58, 64)( 60, 67)( 65, 72)( 76, 82)
    ( 80, 85)( 83, 87)( 86, 90)( 88, 92)( 91, 95)(103,106)(105,108)(107,109)
    (116,117)(124,132)(126,133)(130,138)(131,139)(134,141)(136,144)(137,145)
    (142,149)(143,150)(160,168)(165,172)(169,175)(171,177)(173,179)(176,182)
    (178,184)(180,187)(185,192)(196,202)(200,205)(203,207)(206,210)(208,212)
    (211,215)(223,226)(225,228)(227,229)(236,237), 
  (  5, 13)(  6,126)(  7, 14)( 12, 20)( 15, 22)( 18, 26)( 19, 27)( 24, 31)
    ( 25, 33)( 30, 38)( 32, 40)( 37, 45)( 44, 51)( 55, 61)( 59, 66)( 62, 68)
    ( 64, 71)( 67, 73)( 70, 76)( 72, 78)( 75, 80)( 77, 83)( 81, 86)( 92, 96)
    ( 95,100)( 99,103)(102,105)(104,107)(117,118)(125,133)(127,134)(132,140)
    (135,142)(138,146)(139,147)(144,151)(145,153)(150,158)(152,160)(157,165)
    (164,171)(175,181)(179,186)(182,188)(184,191)(187,193)(190,196)(192,198)
    (195,200)(197,203)(201,206)(212,216)(215,220)(219,223)(222,225)(224,227)
    (237,238), (  6, 14)(  7,127)(  8, 15)( 13, 21)( 20, 28)( 26, 34)( 27, 35)
    ( 31, 39)( 33, 41)( 38, 46)( 40, 49)( 45, 53)( 48, 55)( 51, 58)( 52, 59)
    ( 57, 64)( 63, 70)( 68, 74)( 69, 75)( 73, 79)( 78, 84)( 83, 88)( 86, 91)
    ( 87, 92)( 90, 95)( 94, 99)( 98,102)(101,104)(118,119)(126,134)(128,135)
    (133,141)(140,148)(146,154)(147,155)(151,159)(153,161)(158,166)(160,169)
    (165,173)(168,175)(171,178)(172,179)(177,184)(183,190)(188,194)(189,195)
    (193,199)(198,204)(203,208)(206,211)(207,212)(210,215)(214,219)(218,222)
    (221,224)(238,239), (  7, 15)(  8,128)( 14, 22)( 21, 29)( 28, 36)( 34, 42)
    ( 35, 43)( 39, 47)( 41, 50)( 46, 54)( 49, 56)( 53, 60)( 55, 62)( 58, 65)
    ( 59, 67)( 61, 68)( 64, 72)( 66, 73)( 70, 77)( 71, 78)( 75, 81)( 76, 83)
    ( 80, 86)( 82, 87)( 85, 90)( 89, 94)( 93, 98)( 97,101)(119,120)(127,135)
    (134,142)(141,149)(148,156)(154,162)(155,163)(159,167)(161,170)(166,174)
    (169,176)(173,180)(175,182)(178,185)(179,187)(181,188)(184,192)(186,193)
    (190,197)(191,198)(195,201)(196,203)(200,206)(202,207)(205,210)(209,214)
    (213,218)(217,221)(239,240) ];

CHEVIE.E8.cartan:=[ [ 2, 0, -1, 0, 0, 0, 0, 0 ], [ 0, 2, 0, -1, 0, 0, 0, 0 ], 
      [ -1, 0, 2, -1, 0, 0, 0, 0 ], [ 0, -1, -1, 2, -1, 0, 0, 0 ], 
      [ 0, 0, 0, -1, 2, -1, 0, 0 ], [ 0, 0, 0, 0, -1, 2, -1, 0 ], 
      [ 0, 0, 0, 0, 0, -1, 2, -1 ], [ 0, 0, 0, 0, 0, 0, -1, 2 ] ];

CHEVIE.E8.powermap:=
  [ , [ 1, 1, 1, 1, 1, 2, 1, 8, 8, 10, 10, 12, 12, 14, 14, 3, 3, 3, 4, 4, 6, 7, 
      23, 23, 25, 25, 8, 8, 10, 8, 8, 11, 12, 12, 14, 14, 14, 14, 15, 14, 41, 
      41, 16, 18, 18, 46, 46, 48, 48, 23, 23, 26, 27, 27, 29, 29, 33, 33, 30, 
      30, 32, 62, 62, 64, 64, 1, 1, 1, 1, 4, 4, 4, 3, 3, 5, 4, 8, 8, 12, 12, 
      8, 8, 14, 14, 12, 12, 14, 14, 16, 16, 18, 22, 23, 23, 30, 30, 30, 30, 
      37, 38, 33, 33, 41, 41, 46, 46, 50, 50, 53, 53, 62, 62 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 1, 2, 1, 2, 1, 2, 1, 2, 16, 17, 18, 19, 20, 21, 22, 
      23, 24, 25, 26, 3, 3, 3, 4, 5, 6, 3, 3, 3, 3, 4, 5, 6, 7, 41, 42, 43, 
      44, 45, 12, 13, 12, 13, 50, 51, 52, 16, 17, 16, 17, 16, 17, 19, 20, 21, 
      23, 24, 25, 26, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 66, 67, 66, 
      67, 68, 69, 66, 67, 68, 69, 68, 69, 89, 90, 91, 92, 93, 94, 72, 72, 70, 
      71, 72, 75, 73, 74, 103, 104, 79, 80, 107, 108, 89, 90, 93, 94 ],, 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 1, 2, 1, 2, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 4, 5, 6, 53, 54, 55, 56, 57, 
      58, 59, 60, 61, 8, 9, 10, 11, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
      76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 66, 
      67, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 70, 71, 109, 
      110, 77, 78 ],, 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
      39, 40, 1, 2, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 66, 67, 105, 106, 107, 108, 
      109, 110, 111, 112 ] ];

CHEVIE.E8.orders:=
[ 1, 2, 2, 2, 2, 4, 2, 3, 6, 3, 6, 3, 6, 3, 6, 4, 4, 4, 4, 4, 
  8, 4, 5, 10, 5, 10, 6, 6, 6, 6, 6, 12, 6, 6, 6, 6, 6, 6, 12, 6, 7, 14, 8, 
  8, 8, 9, 18, 9, 18, 10, 10, 20, 12, 12, 12, 12, 12, 12, 12, 12, 24, 15, 30, 
  15, 30, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
  6, 8, 8, 8, 8, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 14, 14, 18, 18, 20, 
  20, 24, 24, 30, 30 ];

CHEVIE.E8.centralizers:=[ 696729600, 696729600, 221184, 
  184320, 184320, 46080, 6144, 311040, 311040, 155520, 155520, 7776, 7776, 
  2592, 2592, 18432, 18432, 1024, 768, 768, 192, 128, 1200, 1200, 600, 600, 
  6912, 6912, 1728, 1152, 1152, 288, 864, 864, 432, 216, 288, 288, 72, 48, 
  28, 28, 64, 128, 128, 108, 108, 54, 54, 80, 80, 20, 576, 576, 288, 288, 
  144, 144, 96, 96, 24, 60, 60, 30, 30, 5806080, 5806080, 18432, 18432, 
  15360, 15360, 4608, 1536, 1536, 768, 256, 8640, 8640, 2592, 2592, 576, 576, 
  432, 432, 288, 288, 144, 144, 384, 384, 64, 16, 120, 120, 576, 576, 192, 
  192, 72, 24, 48, 48, 28, 28, 36, 36, 40, 40, 48, 48, 60, 60 ];

CHEVIE.E8.classes:=
[ 1, 1, 3150, 3780, 3780, 15120, 113400, 2240, 2240, 4480, 4480, 89600, 
  89600, 268800, 268800, 37800, 37800, 680400, 907200, 907200, 3628800, 
  5443200, 580608, 580608, 1161216, 1161216, 100800, 100800, 403200, 604800, 
  604800, 2419200, 806400, 806400, 1612800, 3225600, 2419200, 2419200, 
  9676800, 14515200, 24883200, 24883200, 10886400, 5443200, 5443200, 6451200, 
  6451200, 12902400, 12902400, 8709120, 8709120, 34836480, 1209600, 1209600, 
  2419200, 2419200, 4838400, 4838400, 7257600, 7257600, 29030400, 11612160, 
  11612160, 23224320, 23224320, 120, 120, 37800, 37800, 45360, 45360, 151200, 
  453600, 453600, 907200, 2721600, 80640, 80640, 268800, 268800, 1209600, 
  1209600, 1612800, 1612800, 2419200, 2419200, 4838400, 4838400, 1814400, 
  1814400, 10886400, 43545600, 5806080, 5806080, 1209600, 1209600, 3628800, 
  3628800, 9676800, 29030400, 14515200, 14515200, 24883200, 24883200, 
  19353600, 19353600, 17418240, 17418240, 14515200, 14515200, 11612160, 
  11612160 ];

CHEVIE.E8.PositionId:=function() return 1; end;

CHEVIE.E8.PositionSgn:=function() return 2; end;

CHEVIE.E8.PositionRefl:=function() return 68; end;

CHEVIE.E8.vpolheckeirreducibles:=
   [[[[1],0],[[1],240],[[1],24],[[1],4],[[1],60],
    [[1],120],[[1],8],[[1],4],[[1],128],
    [[1],160],[[1],80],[[1],48],[[1],84],
    [[1],8],[[1],88],[[1],12],[[1],132],
    [[1],32],[[1],8],[[1],28],[[1],60],
    [[1],12],[[1],8],[[1],64],[[1],96],
    [[1],48],[[1],28],[[1],8],[[1],88],
    [[1],8],[[1],28],[[1],40],[[1],24],
    [[1],92],[[1],28],[[1],12],[[1],12],
    [[1],20],[[1],44],[[1],12],[[1],12],
    [[1],36],[[1],12],[[1],16],[[1],68],
    [[1],16],[[1],32],[[1],56],[[1],28],
    [[1],12],[[1],12],[[1],24],[[1],16],
    [[1],92],[[1],52],[[1],44],[[1],12],
    [[1],48],[[1],12],[[1],16],[[1],20],
    [[1],12],[[1],52],[[1],32],[[1],16],
    [[1],2],[[1],126],[[1],6],[[1],26],
    [[1],6],[[1],62],[[1],26],[[1],14],
    [[1],66],[[1],42],[[1],10],[[1],6],
    [[1],62],[[1],50],[[1],42],[[1],10],
    [[1],10],[[1],10],[[1],46],[[1],50],
    [[1],26],[[1],10],[[1],30],[[1],10],
    [[1],30],[[1],34],[[1],14],[[1],10],
    [[1],30],[[1],30],[[1],14],[[1],10],
    [[1],34],[[1],18],[[1],14],[[1],14],
    [[1],22],[[1],14],[[1],18],[[1],18],
    [[1],14],[[1],14],[[1],18],[[1],14],
    [[1],22],[[1],14],[[1],26]],
    [[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0],[[-1],0],
    [[-1],0],[[-1],0],[[-1],0]],
    [[[28],0],[[28],180],
    [[6,0,0,0,0,0,-16,0,0,0,0,0,6],12],
    [[1,0,-12,0,15],0],
    [[15,0,0,0,0,0,0,0,0,0,-12,0,0,0,0,0,0,0,0,0,1],
    40],[[4],90],[[6,0,-16,0,6],4],
    [[1,0,-6,0,15],0],
    [[15,0,0,0,0,0,0,0,-6,0,0,0,0,0,0,0,1],92],
    [[10],120],[[10],60],
    [[6,0,0,0,0,0,0,0,-6,0,0,0,0,0,0,0,1],32],
    [[1,0,-6,0,6],60],[[3,0,-8,0,6],4],
    [[6,0,-8,0,3],64],[[2,0,0,0,0,0,6],6],
    [[6,0,0,0,0,0,2],96],
    [[1,0,2,0,0,0,-4,0,0,0,0,0,1],20],
    [[2,0,-8,0,6],4],
    [[3,0,0,0,4,0,-6,0,0,0,-2,0,1],16],[[],0],
    [[3,0,-4,0,1],8],[[1,0,-4,0,6],4],
    [[6,0,0,0,-4,0,0,0,1],44],[[3],72],[[3],36],
    [[6,0,0,0,4,0,-8,0,1,0,-2,0,1],16],
    [[-4,0,6],6],[[3,0,-4,0,3],64],
    [[4,0,-12,0,6],4],
    [[3,0,0,0,0,0,-6,0,0,0,0,0,1],16],[[-2],30],
    [[2,0,0,0,2,0,0,0,1],16],[[8,0,-4,0,1],68],
    [[1,0,0,0,1,0,-4,0,0,0,0,0,1],16],
    [[2,0,-4,0,1],8],[[8,0,-8,0,1],8],[[1],20],
    [[2,0,-1],32],[[2,0,-4,0,1],8],
    [[1,0,-2,0,1],8],[[],0],[[1,0,-4,0,1],8],
    [[1,0,0,0,0,0,1],10],[[1,0,1],48],[[1],16],
    [[1],20],[[1],40],[[1],20],[[4,0,-6,0,1],8],
    [[-2,0,1],10],[[-1],18],[[2,0,1,0,-2,0,1],10],
    [[3,0,-2,0,1],68],[[3,0,0,0,0,0,-1],36],
    [[3,0,-1],32],[[-2,0,1],10],
    [[1,0,-2,0,1,0,-1],32],[[5,0,-6,0,1],8],
    [[1,0,0,0,-2,0,1],10],[[],0],
    [[3,0,-4,0,1],8],[[-1,0,1],38],[[],0],
    [[],0],[[-7,0,21],0],
    [[21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-7],90],
    [[3,0,-15,0,10],2],
    [[6,0,0,0,4,0,-12,0,0,0,-3,0,3],14],
    [[1,0,-5,0,10],2],
    [[10,0,0,0,0,0,0,0,1,0,-5],42],
    [[3,0,0,0,1,0,-9,0,0,0,0,0,3],14],
    [[2,0,0,0,-3,0,3],8],
    [[3,0,2,0,0,0,0,0,0,0,-3],46],
    [[3,0,0,0,0,0,-1],30],[[4,0,-9,0,3],6],
    [[2,0,-10,0,10],2],
    [[10,0,0,0,-5,0,0,0,1,0,-5,0,0,0,1],42],
    [[6,0,0,0,0,0,3,0,-3,0,0,0,0,0,-1],34],
    [[3,0,0,0,0,0,2],30],[[7,0,-12,0,3],6],
    [[1,0,-6,0,3],6],[[5,0,-9,0,3],6],
    [[1,0,-2,0,1,0,0,0,-2,0,1],30],
    [[3,0,0,0,0,0,0,0,-2],34],
    [[2,0,-1,0,1,0,-1],18],[[1,0,-3,0,3],6],
    [[1,0,0,0,3,0,-2,0,0,0,-1],18],[[-3,0,3],8],
    [[3,0,0,0,0,0,-3],18],[[1,0,0,0,-1],24],
    [[1,0,-1],10],[[2,0,-6,0,3],6],
    [[1,0,0,0,0,0,-2],18],
    [[3,0,0,0,4,0,-3,0,1,0,-1],18],
    [[1,0,0,0,0,0,3],8],[[3,0,-6,0,3],6],
    [[1,0,1,0,0,0,-2],22],[[1,0,1,0,-1],12],
    [[-1],12],[[1,0,-2],10],[[-1],16],
    [[2,0,-2],10],[[],0],[[-1],16],[[-1],12],
    [[3,0,-2],10],[[1],12],[[2,0,-2],10],[[],0],
    [[5,0,-3],10],[[1,0,0,0,1],18]],
    [[[28],0],[[28],60],
    [[6,0,0,0,0,0,-16,0,0,0,0,0,6],0],
    [[15,0,-12,0,1],0],
    [[1,0,0,0,0,0,0,0,0,0,-12,0,0,0,0,0,0,0,0,0,15],
    0],[[4],30],[[6,0,-16,0,6],0],
    [[15,0,-6,0,1],0],
    [[1,0,0,0,0,0,0,0,-6,0,0,0,0,0,0,0,15],20],
    [[10],40],[[10],20],
    [[1,0,0,0,0,0,0,0,-6,0,0,0,0,0,0,0,6],0],
    [[6,0,-6,0,1],20],[[6,0,-8,0,3],0],
    [[3,0,-8,0,6],20],[[6,0,0,0,0,0,2],0],
    [[2,0,0,0,0,0,6],30],
    [[1,0,0,0,0,0,-4,0,0,0,2,0,1],0],
    [[6,0,-8,0,2],0],
    [[1,0,-2,0,0,0,-6,0,4,0,0,0,3],0],[[],0],
    [[1,0,-4,0,3],0],[[6,0,-4,0,1],0],
    [[1,0,0,0,-4,0,0,0,6],12],[[3],24],[[3],12],
    [[1,0,-2,0,1,0,-8,0,4,0,0,0,6],0],[[6,0,-4],0],
    [[3,0,-4,0,3],20],[[6,0,-12,0,4],0],
    [[1,0,0,0,0,0,-6,0,0,0,0,0,3],0],[[-2],10],
    [[1,0,0,0,2,0,0,0,2],0],[[1,0,-4,0,8],20],
    [[1,0,0,0,0,0,-4,0,1,0,0,0,1],0],
    [[1,0,-4,0,2],0],[[1,0,-8,0,8],0],[[1],0],
    [[-1,0,2],10],[[1,0,-4,0,2],0],
    [[1,0,-2,0,1],0],[[],0],[[1,0,-4,0,1],0],
    [[1,0,0,0,0,0,1],0],[[1,0,1],18],[[1],0],
    [[1],12],[[1],16],[[1],8],[[1,0,-6,0,4],0],
    [[1,0,-2],0],[[-1],6],[[1,0,-2,0,1,0,2],0],
    [[1,0,-2,0,3],20],[[-1,0,0,0,0,0,3],10],
    [[-1,0,3],10],[[1,0,-2],0],
    [[-1,0,1,0,-2,0,1],10],[[1,0,-6,0,5],0],
    [[1,0,-2,0,0,0,1],0],[[],0],[[1,0,-4,0,3],0],
    [[1,0,-1],12],[[],0],[[],0],[[-21,0,7],0],
    [[7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-21],18],
    [[-10,0,15,0,-3],0],
    [[-3,0,3,0,0,0,12,0,-4,0,0,0,-6],0],
    [[-10,0,5,0,-1],0],
    [[5,0,-1,0,0,0,0,0,0,0,-10],10],
    [[-3,0,0,0,0,0,9,0,-1,0,0,0,-3],0],
    [[-3,0,3,0,0,0,-2],0],
    [[3,0,0,0,0,0,0,0,-2,0,-3],10],
    [[1,0,0,0,0,0,-3],6],[[-3,0,9,0,-4],0],
    [[-10,0,10,0,-2],0],
    [[-1,0,0,0,5,0,-1,0,0,0,5,0,0,0,-10],6],
    [[1,0,0,0,0,0,3,0,-3,0,0,0,0,0,-6],2],
    [[-2,0,0,0,0,0,-3],6],[[-3,0,12,0,-7],0],
    [[-3,0,6,0,-1],0],[[-3,0,9,0,-5],0],
    [[-1,0,2,0,0,0,-1,0,2,0,-1],6],
    [[2,0,0,0,0,0,0,0,-3],8],[[1,0,-1,0,1,0,-2],2],
    [[-3,0,3,0,-1],0],[[1,0,0,0,2,0,-3,0,0,0,-1],2]
    ,[[-3,0,3],0],[[3,0,0,0,0,0,-3],6],
    [[1,0,0,0,-1],6],[[1,0,-1],2],
    [[-3,0,6,0,-2],0],[[2,0,0,0,0,0,-1],6],
    [[1,0,-1,0,3,0,-4,0,0,0,-3],2],
    [[-3,0,0,0,0,0,-1],0],[[-3,0,6,0,-3],0],
    [[2,0,0,0,-1,0,-1],6],[[1,0,-1,0,-1],2],
    [[1],2],[[2,0,-1],2],[[1],6],[[2,0,-2],2],
    [[],0],[[1],2],[[1],2],[[2,0,-3],2],
    [[-1],6],[[2,0,-2],2],[[],0],[[3,0,-5],2],
    [[-1,0,0,0,-1],4]],
    [[[35],0],[[35],192],[[9,0,-16,0,0,0,0,0,10],16],
    [[1,0,-12,0,22],0],
    [[15,0,0,0,5,0,-12,0,0,0,0,0,0,0,0,0,3],44],
    [[-5],96],[[6,0,-16,0,13],4],[[-7,0,21],2],
    [[20,0,0,0,-6],100],[[5],128],[[5],64],
    [[2,0,0,0,-6,0,0,0,0,0,0,0,3],36],
    [[-4,0,3],66],[[1,0,-10,0,11],4],
    [[4,0,-4,0,2],68],[[-3,0,0,0,10],8],
    [[9,0,0,0,-2],104],[[-4,0,0,0,0,0,3],26],
    [[1,0,-9,0,11],4],[[8,0,-7,0,0,0,-2,0,4],20],
    [[-1],48],[[1,0,-6,0,4],8],[[-5,0,10],6],
    [[5],48],[[],0],[[],0],
    [[13,0,-8,0,0,0,-3,0,4],20],[[-4,0,10],6],
    [[-4,0,1],70],[[3,0,-13,0,12],4],
    [[5,0,-6,0,0,0,0,0,3],20],[[1],32],
    [[-2,0,2,0,0,0,3],18],[[4,0,-2,0,1],72],
    [[2,0,-5,0,0,0,0,0,3],20],[[1,0,-5,0,4],8],
    [[6,0,-10,0,6],8],[[-1,0,0,0,3],16],[[-2],34],
    [[1,0,-5,0,4],8],[[-3,0,3],10],[[],0],
    [[1,0,-4,0,4],8],[[-2,0,0,0,3],12],[[1],52],
    [[-1,0,0,0,3],12],[[2],24],[[-1],44],
    [[-1],22],[[3,0,-7,0,5],8],[[-2,0,3],10],
    [[],0],[[-3,0,-3,0,4],12],[[-2],74],
    [[1],44],[[1],36],[[-2,0,3],10],[[1],40],
    [[3,0,-8,0,5],8],[[-2,0,-2,0,4],12],[[-1],16],
    [[1,0,-6,0,4],8],[[-1],40],[[],0],[[],0],
    [[-7,0,28],0],
    [[27,0,0,0,0,0,0,0,0,0,-7,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,1],98],[[3,0,-15,0,17],2],
    [[13,0,-12,0,0,0,-3,0,7],18],[[-6,0,15],4],
    [[10,0,0,0,4,0,-6,0,0,0,0,0,0,0,0,0,1],46],
    [[5,0,-10,0,0,0,0,0,6],18],[[-3,0,-3,0,7],10],
    [[3,0,0,0,0,0,-3,0,0,0,0,0,0,0,0,0,1],50],
    [[-3,0,0,0,-1,0,0,0,0,0,1],32],
    [[3,0,-10,0,8],6],[[1,0,-11,0,16],2],
    [[9,0,0,0,0,0,-5,0,0,0,1,0,0,0,0,0,1],46],
    [[2,0,3,0,-3,0,0,0,0,0,-1,0,2],38],
    [[2,0,0,0,0,0,1],36],[[6,0,-13,0,9],6],
    [[1,0,-6,0,7],6],[[3,0,-11,0,8],6],
    [[-2,0,1,0,0,0,0,0,1],38],
    [[-2,0,0,0,0,0,0,0,1],42],
    [[-3,0,1,0,-1,0,2],20],[[-4,0,6],8],
    [[4,0,-3,0,0,0,-1,0,2],22],[[-3,0,6],8],
    [[5,0,-3,0,0,0,0,0,1],22],
    [[-1,0,-1,0,0,0,0,0,1],26],[[-2,0,1],12],
    [[1,0,-7,0,7],6],[[2,0,-2,0,0,0,0,0,1],22],
    [[8,0,-4,0,0,0,-2,0,2],22],[[-2,0,0,0,6],10],
    [[1,0,-8,0,7],6],[[1,0,-2,0,0,0,0,0,1],26],
    [[-2,0,-2,0,2],14],[[-1,0,1],12],
    [[1,0,-2,0,2],10],[[1],22],[[1,0,-3,0,2],10],
    [[-1,0,0,0,1],14],[[-1,0,-1,0,2],14],
    [[-1,0,1],12],[[1,0,-4,0,2],10],
    [[-2,0,0,0,1],14],[[1,0,-3,0,2],10],
    [[-1,0,0,0,1],18],[[3,0,-5,0,3],10],
    [[-1,0,1,0,0,0,1],20]],
    [[[35],0],[[35],48],[[10,0,0,0,0,0,-16,0,9],0],
    [[22,0,-12,0,1],0],
    [[3,0,0,0,0,0,0,0,0,0,-12,0,5,0,0,0,15],0],
    [[-5],24],[[13,0,-16,0,6],0],[[21,0,-7],0],
    [[-6,0,0,0,20],24],[[5],32],[[5],16],
    [[3,0,0,0,0,0,0,0,-6,0,0,0,2],0],[[3,0,-4],16],
    [[11,0,-10,0,1],0],[[2,0,-4,0,4],16],
    [[10,0,0,0,-3],0],[[-2,0,0,0,9],24],
    [[3,0,0,0,0,0,-4],0],[[11,0,-9,0,1],0],
    [[4,0,-2,0,0,0,-7,0,8],0],[[-1],12],
    [[4,0,-6,0,1],0],[[10,0,-5],0],[[5],16],
    [[],0],[[],0],[[4,0,-3,0,0,0,-8,0,13],0],
    [[10,0,-4],0],[[1,0,-4],16],[[12,0,-13,0,3],0],
    [[3,0,0,0,0,0,-6,0,5],0],[[1],8],
    [[3,0,0,0,2,0,-2],0],[[1,0,-2,0,4],16],
    [[3,0,0,0,0,0,-5,0,2],0],[[4,0,-5,0,1],0],
    [[6,0,-10,0,6],0],[[3,0,0,0,-1],0],[[-2],10],
    [[4,0,-5,0,1],0],[[3,0,-3],0],[[],0],
    [[4,0,-4,0,1],0],[[3,0,0,0,-2],0],[[1],16],
    [[3,0,0,0,-1],0],[[2],8],[[-1],12],[[-1],6],
    [[5,0,-7,0,3],0],[[3,0,-2],0],[[],0],
    [[4,0,-3,0,-3],0],[[-2],18],[[1],8],[[1],8],
    [[3,0,-2],0],[[1],8],[[5,0,-8,0,3],0],
    [[4,0,-2,0,-2],0],[[-1],4],[[4,0,-6,0,1],0],
    [[-1],12],[[],0],[[],0],[[-28,0,7],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,
    0,0,0,0,0,0,-27],0],[[-17,0,15,0,-3],0],
    [[-7,0,3,0,0,0,12,0,-13],0],[[-15,0,6],0],
    [[-1,0,0,0,0,0,0,0,0,0,6,0,-4,0,0,0,-10],0],
    [[-6,0,0,0,0,0,10,0,-5],0],[[-7,0,3,0,3],0],
    [[-1,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,-3],0],
    [[-1,0,0,0,0,0,1,0,0,0,3],0],
    [[-8,0,10,0,-3],0],[[-16,0,11,0,-1],0],
    [[-1,0,0,0,0,0,-1,0,0,0,5,0,0,0,0,0,-9],0],
    [[-2,0,1,0,0,0,0,0,3,0,-3,0,-2],0],
    [[-1,0,0,0,0,0,-2],0],[[-9,0,13,0,-6],0],
    [[-7,0,6,0,-1],0],[[-8,0,11,0,-3],0],
    [[-1,0,0,0,0,0,-1,0,2],0],
    [[-1,0,0,0,0,0,0,0,2],0],[[-2,0,1,0,-1,0,3],0],
    [[-6,0,4],0],[[-2,0,1,0,0,0,3,0,-4],0],
    [[-6,0,3],0],[[-1,0,0,0,0,0,3,0,-5],0],
    [[-1,0,0,0,0,0,1,0,1],0],[[-1,0,2],0],
    [[-7,0,7,0,-1],0],[[-1,0,0,0,0,0,2,0,-2],0],
    [[-2,0,2,0,0,0,4,0,-8],0],[[-6,0,0,0,2],0],
    [[-7,0,8,0,-1],0],[[-1,0,0,0,0,0,2,0,-1],0],
    [[-2,0,2,0,2],0],[[-1,0,1],0],
    [[-2,0,2,0,-1],0],[[-1],0],[[-2,0,3,0,-1],0],
    [[-1,0,0,0,1],0],[[-2,0,1,0,1],0],
    [[-1,0,1],0],[[-2,0,4,0,-1],0],
    [[-1,0,0,0,2],0],[[-2,0,3,0,-1],0],
    [[-1,0,0,0,1],0],[[-3,0,5,0,-3],0],
    [[-1,0,0,0,-1,0,1],0]],
    [[[70],0],[[70],120],[[1,0,0,0,0,0,-16,0,0,0,0,0,
    36,0,0,0,0,0,-16,0,0,0,0,0,1],0],
    [[15,0,-40,0,15],0],
    [[15,0,0,0,0,0,0,0,0,0,-40,0,0,0,0,0,0,0,0,0,15],
    20],[[6],60],[[1,0,-16,0,36,0,-16,0,1],0],
    [[15,0,-20,0,15],0],
    [[15,0,0,0,0,0,0,0,-20,0,0,0,0,0,0,0,15],56],
    [[19],80],[[19],40],
    [[6,0,0,0,0,0,0,0,-14,0,0,0,0,0,0,0,6],16],
    [[6,0,-14,0,6],40],[[1,0,-8,0,18,0,-8,0,1],0],
    [[1,0,-8,0,18,0,-8,0,1],40],
    [[1,0,0,0,0,0,12,0,0,0,0,0,1],0],
    [[1,0,0,0,0,0,12,0,0,0,0,0,1],60],
    [[2,0,1,0,0,0,-8,0,0,0,1,0,2],10],
    [[1,0,-8,0,12,0,-8,0,1],0],
    [[4,0,-2,0,3,0,-12,0,3,0,-2,0,4],8],[[2],30],
    [[3,0,-8,0,3],4],[[1,0,-4,0,6,0,-4,0,1],0],
    [[1,0,0,0,-4,0,0,0,6,0,0,0,-4,0,0,0,1],24],
    [[5],48],[[5],24],
    [[1,0,0,0,4,0,-8,0,6,0,-12,0,6,0,-8,0,4,0,0,0,1],
    4],[[1,0,-4,0,0,0,-4,0,1],0],
    [[1,0,-4,0,9,0,-4,0,1],40],
    [[1,0,-12,0,24,0,-12,0,1],0],
    [[-2,0,3,0,0,0,3,0,-2],10],[[3],20],
    [[2,0,0,0,2,0,0,0,2],8],[[8,0,-10,0,8],44],
    [[1,0,0,0,1,0,-4,0,1,0,0,0,1],8],
    [[2,0,-4,0,2],4],[[8,0,-20,0,8],4],[[-4],10],
    [[1,0,-2,0,1],20],[[2,0,-4,0,2],4],
    [[1,0,-2,0,1],4],[[],0],[[1,0,0,0,1],4],
    [[1,0,0,0,1],6],[[1,0,0,0,0,0,0,0,1],30],
    [[-2],8],[[-2],16],[[1],28],[[1],14],
    [[4,0,-8,0,4],4],[[],0],[[1],12],
    [[1,0,2,0,-4,0,2,0,1],4],[[3,0,-4,0,3],44],
    [[1,0,0,0,0,0,-3,0,0,0,0,0,1],20],
    [[1,0,-3,0,1],20],[[2],6],
    [[1,0,-1,0,2,0,-1,0,1],20],[[5,0,-12,0,5],4],
    [[1,0,-4,0,1],6],[[-1],10],[[3,0,-6,0,3],4],
    [[1,0,-2,0,1],24],[[-1],16],[[-1],8],
    [[-35,0,35],0],
    [[35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-35],54],
    [[-5,0,30,0,-30,0,5],0],
    [[1,0,0,0,4,0,-12,0,0,0,-18,0,18,0,0,0,12,0,-4,0,
    0,0,-1],2],[[-5,0,10,0,-10,0,5],0],
    [[5,0,0,0,0,0,0,0,10,0,-10,0,0,0,0,0,0,0,-5],22],
    [[3,0,-3,0,0,0,-9,0,9,0,0,0,3,0,-3],6],
    [[1,0,0,0,-6,0,6,0,0,0,-1],2],
    [[6,0,1,0,0,0,0,0,-1,0,-6],28],
    [[3,0,0,0,0,0,-3],18],[[3,0,-12,0,12,0,-3],2],
    [[-5,0,20,0,-20,0,5],0],
    [[5,0,0,0,-10,0,0,0,10,0,-10,0,0,0,10,0,0,0,-5],
    22],[[6,0,0,0,0,0,7,0,-7,0,0,0,0,0,-6],18],
    [[-1,0,0,0,0,0,1],18],[[4,0,-21,0,21,0,-4],2],
    [[2,0,-3,0,3,0,-2],2],[[3,0,-15,0,15,0,-3],2],
    [[1,0,2,0,-1,0,1,0,-2,0,-1],18],
    [[1,0,0,0,0,0,2,0,-2,0,0,0,0,0,-1],18],
    [[2,0,-1,0,1,0,-2],10],[[1,0,-3,0,3,0,-1],2],
    [[1,0,0,0,3,0,-3,0,0,0,-1],10],
    [[1,0,0,0,0,0,-1],2],[[-1,0,0,0,0,0,1],12],
    [[1,0,-1],16],[[1,0,-1],6],
    [[2,0,-6,0,6,0,-2],2],[[],0],
    [[4,0,-1,0,6,0,-6,0,1,0,-4],10],[[-3,0,3],6],
    [[2,0,-9,0,9,0,-2],2],
    [[1,0,0,0,2,0,-2,0,0,0,-1],12],[[2,0,-2],8],
    [[],0],[[-1,0,1],6],[[1,0,-1],10],
    [[2,0,-2],6],[[],0],[[1,0,-1],8],
    [[-1,0,1],6],[[4,0,-4],6],[[],0],
    [[1,0,-1],6],[[1,0,-1],10],[[6,0,-6],6],
    [[],0]],
    [[[50],0],[[50],168],[[4,0,0,0,27,0,-16,0,0,0,0,
    0,3],12],[[5,0,-20,0,25],0],
    [[5,0,0,0,9,0,-20,0,15,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,1],36],[[10],84],
    [[1,0,-4,0,12,0,-20,0,13],0],[[-15,0,20],2],
    [[-15,0,0,0,20],88],[[5],112],[[5],56],
    [[-6,0,0,0,2],32],[[-6,0,2],58],
    [[5,0,-10,0,10],4],[[8,0,-4,0,1],60],
    [[4,0,-9,0,0,0,3],6],[[4,0,-9,0,0,0,3],90],
    [[2,0,-2,0,6,0,-1,0,0,0,0,0,0,0,1],18],
    [[3,0,-9,0,8],4],
    [[-4,0,10,0,-5,0,0,0,0,0,1],18],[[2],42],
    [[2,0,-4,0,4],8],[[-5,0,5],6],[[],0],
    [[],0],[[],0],
    [[-2,0,0,0,-9,0,13,0,-8,0,0,0,0,0,3],14],
    [[-2,0,-4,0,3],4],[[1,0,-4],60],
    [[-2,0,7,0,-15,0,11],2],
    [[-2,0,0,0,4,0,-2,0,0,0,0,0,1],16],[[1],28],
    [[2,0,-2],16],[[-2,0,4,0,-2],62],[[4,0,-1],20],
    [[1,0,1,0,-2,0,3],6],[[1,0,-2,0,7,0,-10,0,5],4]
    ,[[2,0,-2,0,0,0,0,0,1],12],[[1],32],
    [[-3,0,2],10],[[-1,0,2],10],[[1],24],
    [[1,0,-1,0,-1,0,1],6],[[-1,0,0,0,1],12],
    [[-1,0,0,0,1],46],[[-1],12],[[-1],24],
    [[-1],40],[[-1],20],[[2,0,-5,0,3],8],
    [[-1,0,0,0,1],8],[[],0],
    [[-2,0,3,0,-3,0,0,0,3],8],[[1],64],[[1],34],
    [[1],30],[[-2],8],[[-2],32],
    [[-1,0,3,0,-7,0,4],6],[[-1,0,2,0,-3,0,0,0,1],8]
    ,[[-1],14],[[1,0,-4,0,3],8],[[],0],
    [[],0],[[],0],[[-15,0,35],0],
    [[-15,0,0,0,0,0,35],84],[[-2,0,9,0,-21,0,18],0],
    [[-2,0,2,0,-9,0,22,0,-12,0,0,0,0,0,3],12],
    [[-10,0,10],4],
    [[4,0,-10,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
    42],[[13,0,-6,0,0,0,0,0,1],18],
    [[-2,0,5,0,-6,0,0,0,3],6],
    [[-2,0,3,0,-3,0,2],42],
    [[3,0,0,0,0,0,0,0,0,0,0,0,1],30],
    [[-1,0,4,0,-9,0,6],4],[[5,0,-15,0,15],2],
    [[5,0,0,0,-5,0,5],40],[[3,0,-3,0,0,0,2],32],
    [[3,0,-1],28],[[1,0,-3,0,9,0,-14,0,8],2],
    [[1,0,0,0,-3,0,3],4],[[-2,0,5,0,-11,0,7],4],
    [[-4,0,3],30],[[1,0,-3],32],[[-1,0,1,0,-2],16],
    [[-2,0,3],8],[[-1,0,3,0,-1],20],
    [[-2,0,-1,0,1],6],
    [[-2,0,0,0,0,0,-1,0,0,0,0,0,1],18],
    [[1,0,1],22],[[-1,0,1],12],[[1,0,-5,0,4],6],
    [[],0],[[-4,0,6,0,-4,0,0,0,0,0,1],20],
    [[2,0,-4,0,0,0,1],8],[[3,0,-6,0,6],6],
    [[1,0,-1,0,3,0,-1,0,0,0,0,0,0,0,1],20],
    [[-1,0,1,0,-2,0,0,0,1],10],[[1],14],
    [[1,0,-1],8],[[1,0,-1],14],[[-2,0,1],12],
    [[-1],12],[[-1],14],[[-1],10],
    [[1,0,-3,0,2],10],[[-1,0,0,0,0,0,1],12],
    [[1,0,0,0,-1,0,1],8],[[1,0,-1,0,0,0,0,0,1],14],
    [[2,0,-4,0,2],10],[[],0]],
    [[[50],0],[[50],72],
    [[3,0,0,0,0,0,-16,0,27,0,0,0,4],0],
    [[25,0,-20,0,5],0],
    [[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,-20,0,9,
    0,0,0,5],0],[[10],36],
    [[13,0,-20,0,12,0,-4,0,1],0],[[20,0,-15],0],
    [[20,0,0,0,-15],36],[[5],48],[[5],24],
    [[2,0,0,0,-6],12],[[2,0,-6],24],
    [[10,0,-10,0,5],0],[[1,0,-4,0,8],24],
    [[3,0,0,0,-9,0,4],0],[[3,0,0,0,-9,0,4],36],
    [[1,0,0,0,0,0,0,0,-1,0,6,0,-2,0,2],0],
    [[8,0,-9,0,3],0],[[1,0,0,0,0,0,-5,0,10,0,-4],0]
    ,[[2],18],[[4,0,-4,0,2],0],[[5,0,-5],0],
    [[],0],[[],0],[[],0],
    [[3,0,0,0,0,0,-8,0,13,0,-9,0,0,0,-2],0],
    [[3,0,-4,0,-2],0],[[-4,0,1],26],
    [[11,0,-15,0,7,0,-2],0],
    [[1,0,0,0,0,0,-2,0,4,0,0,0,-2],0],[[1],12],
    [[-2,0,2],6],[[-2,0,4,0,-2],26],[[-1,0,4],6],
    [[3,0,-2,0,1,0,1],0],[[5,0,-10,0,7,0,-2,0,1],0]
    ,[[1,0,0,0,0,0,-2,0,2],0],[[1],12],
    [[2,0,-3],0],[[2,0,-1],0],[[1],12],
    [[1,0,-1,0,-1,0,1],0],[[1,0,0,0,-1],0],
    [[1,0,0,0,-1],18],[[-1],4],[[-1],8],
    [[-1],16],[[-1],8],[[3,0,-5,0,2],0],
    [[1,0,0,0,-1],0],[[],0],
    [[3,0,0,0,-3,0,3,0,-2],0],[[1],28],[[1],18],
    [[1],14],[[-2],4],[[-2],16],
    [[4,0,-7,0,3,0,-1],0],[[1,0,0,0,-3,0,2,0,-1],0]
    ,[[-1],6],[[3,0,-4,0,1],0],[[],0],[[],0],
    [[],0],[[-35,0,15],0],[[-35,0,0,0,0,0,15],36],
    [[-18,0,21,0,-9,0,2],0],
    [[-3,0,0,0,0,0,12,0,-22,0,9,0,-2,0,2],0],
    [[-10,0,10],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-5,0,10,0,-4],
    0],[[-1,0,0,0,0,0,6,0,-13],0],
    [[-3,0,0,0,6,0,-5,0,2],0],
    [[-2,0,3,0,-3,0,2],18],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,-3],0],
    [[-6,0,9,0,-4,0,1],0],[[-15,0,15,0,-5],0],
    [[-5,0,5,0,0,0,-5],16],[[-2,0,0,0,3,0,-3],12],
    [[1,0,-3],12],[[-8,0,14,0,-9,0,3,0,-1],0],
    [[-3,0,3,0,0,0,-1],0],[[-7,0,11,0,-5,0,2],0],
    [[-3,0,4],14],[[3,0,-1],16],[[2,0,-1,0,1],6],
    [[-3,0,2],0],[[1,0,-3,0,1],6],
    [[-1,0,1,0,2],0],
    [[-1,0,0,0,0,0,1,0,0,0,0,0,2],0],
    [[-1,0,-1],10],[[-1,0,1],0],[[-4,0,5,0,-1],0],
    [[],0],[[-1,0,0,0,0,0,4,0,-6,0,4],0],
    [[-1,0,0,0,4,0,-2],0],[[-6,0,6,0,-3],0],
    [[-1,0,0,0,0,0,0,0,1,0,-3,0,1,0,-1],0],
    [[-1,0,0,0,2,0,-1,0,1],0],[[-1],0],
    [[1,0,-1],4],[[1,0,-1],6],[[-1,0,2],0],
    [[1],6],[[1],4],[[1],4],[[-2,0,3,0,-1],0],
    [[-1,0,0,0,0,0,1],0],[[-1,0,1,0,0,0,-1],0],
    [[-1,0,0,0,0,0,1,0,-1],0],[[-2,0,4,0,-2],0],
    [[],0]],
    [[[84],0],[[84],180],[[2,0,0,0,36,0,-32,0,0,0,0,
    0,14],12],[[5,0,-32,0,47],0],
    [[9,0,-20,0,30,0,0,0,10,0,-12,0,0,0,0,0,0,0,0,0,3
    ],40],[[4],90],[[-4,0,18,0,-36,0,26],2],
    [[-21,0,42],2],[[15,0,0,0,0,0,0,0,6],92],
    [[-6],120],[[-6],60],
    [[-3,0,0,0,6,0,0,0,-3,0,0,0,0,0,0,0,3],32],
    [[6,0,-3],62],[[5,0,-22,0,20],4],
    [[-4,0,8,0,-1],64],[[2,0,-12,0,0,0,14],6],
    [[2,0,0,0,0,0,2],96],
    [[-1,0,6,0,0,0,-4,0,0,0,0,0,3],20],
    [[4,0,-19,0,19],4],
    [[-5,0,18,0,-12,0,0,0,-2,0,5],18],[[],0],
    [[3,0,-10,0,7],8],[[-11,0,15],6],[[4],48],
    [[-1],72],[[-1],36],
    [[2,0,-9,0,26,0,-16,0,0,0,-4,0,6],16],
    [[-1,0,-8,0,14],4],[[-1,0,4,0,-1],64],
    [[-1,0,11,0,-28,0,23],2],
    [[10,0,-8,0,0,0,0,0,3],20],[[-2],30],
    [[1,0,-6,0,1,0,0,0,3],16],[[-5,0,4],68],
    [[7,0,-5,0,0,0,0,0,3],20],[[1,0,-8,0,6],8],
    [[-4,0,12,0,-20,0,11],6],[[-2,0,-2,0,0,0,3],14],
    [[2,0,-1],32],[[2,0,-7,0,6],8],[[-4,0,4],10],
    [[],0],[[-5,0,5],10],[[1,0,-4,0,0,0,3],10],
    [[-1,0,1],48],[[-3,0,0,0,3],12],[[],0],
    [[],0],[[],0],[[-1,0,5,0,-12,0,8],6],
    [[-1,0,-2,0,3],8],[[-1],18],
    [[5,0,-6,0,-4,0,6],10],[[-1,0,2],68],
    [[-1,0,0,0,0,0,-1],36],[[-1,0,-1],32],
    [[-1,0,-1,0,3],8],[[2,0,0,0,-1],34],
    [[-1,0,7,0,-14,0,9],6],[[3,0,-5,0,-2,0,5],10],
    [[],0],[[3,0,-9,0,7],8],[[1],38],[[-1],24],
    [[-1],12],[[-21,0,63],0],
    [[35,0,0,0,0,0,-21,0,27,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],90],
    [[-1,0,12,0,-36,0,35],0],
    [[2,0,-9,0,35,0,-24,0,0,0,-4,0,10],14],
    [[-16,0,26],4],
    [[5,0,-10,0,15,0,0,0,5,0,-6,0,0,0,0,0,0,0,0,0,1],
    42],[[19,0,-16,0,0,0,0,0,7],18],
    [[5,0,-9,0,-4,0,10],8],
    [[-3,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
    46],[[5,0,-3,0,0,0,-1,0,0,0,0,0,1],30],
    [[-1,0,8,0,-19,0,14],4],[[5,0,-27,0,31],2],
    [[-5,0,14,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,1],44],
    [[-3,0,-2,0,4,0,0,0,-3,0,0,0,0,0,-1,0,2],34],
    [[-1,0,-3,0,0,0,0,0,0,0,0,0,1],30],
    [[-4,0,15,0,-27,0,17],4],[[1,0,-10,0,10],6],
    [[-1,0,10,0,-21,0,15],4],
    [[2,0,2,0,-2,0,0,0,0,0,0,0,0,0,1],32],
    [[-1,0,0,0,2,0,-1,0,0,0,0,0,0,0,0,0,1],34],
    [[3,0,-4,0,1,0,-1,0,2],18],[[-7,0,8],8],
    [[-2,0,6,0,-4,0,0,0,-1,0,2],20],
    [[-1,0,-4,0,7],6],[[5,0,-4,0,0,0,0,0,1],22],
    [[2,0,-1,0,0,0,0,0,0,0,1],24],[[-2,0,2],12],
    [[3,0,-12,0,11],6],[[2,0,-1,0,0,0,0,0,1],22],
    [[-5,0,13,0,-8,0,0,0,-2,0,3],20],
    [[1,0,-7,0,0,0,7],8],[[4,0,-15,0,12],6],
    [[-1,0,3,0,0,0,-2,0,0,0,0,0,1],22],
    [[3,0,-3,0,-2,0,3],12],[[-1,0,-1,0,1],10],
    [[-1,0,-2,0,2],10],[[-2,0,0,0,0,0,1],16],
    [[1,0,-4,0,3],10],[[-1,0,0,0,1],14],
    [[1,0,-2,0,-1,0,2],12],[[-1,0,0,0,1],10],
    [[2,0,-6,0,4],10],[[1,0,-2,0,0,0,1],12],
    [[-4,0,3],12],[[-1,0,-1,0,0,0,1],16],
    [[-1,0,4,0,-9,0,5],8],[[-2,0,0,0,0,0,1],20]],
    [[[84],0],[[84],60],
    [[14,0,0,0,0,0,-32,0,36,0,0,0,2],0],
    [[47,0,-32,0,5],0],
    [[3,0,0,0,0,0,0,0,0,0,-12,0,10,0,0,0,30,0,-20,0,9
    ],0],[[4],30],[[26,0,-36,0,18,0,-4],0],
    [[42,0,-21],0],[[6,0,0,0,0,0,0,0,15],28],
    [[-6],40],[[-6],20],
    [[3,0,0,0,0,0,0,0,-3,0,0,0,6,0,0,0,-3],0],
    [[-3,0,6],20],[[20,0,-22,0,5],0],
    [[-1,0,8,0,-4],20],[[14,0,0,0,-12,0,2],0],
    [[2,0,0,0,0,0,2],30],
    [[3,0,0,0,0,0,-4,0,0,0,6,0,-1],0],
    [[19,0,-19,0,4],0],
    [[5,0,-2,0,0,0,-12,0,18,0,-5],0],[[],0],
    [[7,0,-10,0,3],0],[[15,0,-11],0],[[4],16],
    [[-1],24],[[-1],12],
    [[6,0,-4,0,0,0,-16,0,26,0,-9,0,2],0],
    [[14,0,-8,0,-1],0],[[-1,0,4,0,-1],20],
    [[23,0,-28,0,11,0,-1],0],
    [[3,0,0,0,0,0,-8,0,10],0],[[-2],10],
    [[3,0,0,0,1,0,-6,0,1],0],[[4,0,-5],22],
    [[3,0,0,0,0,0,-5,0,7],0],[[6,0,-8,0,1],0],
    [[11,0,-20,0,12,0,-4],0],[[3,0,0,0,-2,0,-2],0],
    [[-1,0,2],10],[[6,0,-7,0,2],0],[[4,0,-4],0],
    [[],0],[[5,0,-5],0],[[3,0,0,0,-4,0,1],0],
    [[1,0,-1],18],[[3,0,0,0,-3],0],[[],0],
    [[],0],[[],0],[[8,0,-12,0,5,0,-1],0],
    [[3,0,-2,0,-1],0],[[-1],6],
    [[6,0,-4,0,-6,0,5],0],[[2,0,-1],22],
    [[-1,0,0,0,0,0,-1],10],[[-1,0,-1],10],
    [[3,0,-1,0,-1],0],[[-1,0,0,0,2],10],
    [[9,0,-14,0,7,0,-1],0],[[5,0,-2,0,-5,0,3],0],
    [[],0],[[7,0,-9,0,3],0],[[1],14],[[-1],8],
    [[-1],4],[[-63,0,21],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,-27,0,21,0,0,0,0,0,-35],0],
    [[-35,0,36,0,-12,0,1],0],
    [[-10,0,4,0,0,0,24,0,-35,0,9,0,-2],0],
    [[-26,0,16],0],
    [[-1,0,0,0,0,0,0,0,0,0,6,0,-5,0,0,0,-15,0,10,0,-5
    ],0],[[-7,0,0,0,0,0,16,0,-19],0],
    [[-10,0,4,0,9,0,-5],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-3,0,-1,0,3],
    0],[[-1,0,0,0,0,0,1,0,0,0,3,0,-5],0],
    [[-14,0,19,0,-8,0,1],0],[[-31,0,27,0,-5],0],
    [[-1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,-14,0,5],0],
    [[-2,0,1,0,0,0,0,0,3,0,0,0,-4,0,2,0,3],0],
    [[-1,0,0,0,0,0,0,0,0,0,3,0,1],0],
    [[-17,0,27,0,-15,0,4],0],[[-10,0,10,0,-1],0],
    [[-15,0,21,0,-10,0,1],0],
    [[-1,0,0,0,0,0,0,0,0,0,2,0,-2,0,-2],0],
    [[-1,0,0,0,0,0,0,0,0,0,1,0,-2,0,0,0,1],0],
    [[-2,0,1,0,-1,0,4,0,-3],0],[[-8,0,7],0],
    [[-2,0,1,0,0,0,4,0,-6,0,2],0],[[-7,0,4,0,1],0],
    [[-1,0,0,0,0,0,4,0,-5],0],
    [[-1,0,0,0,0,0,0,0,1,0,-2],0],[[-2,0,2],0],
    [[-11,0,12,0,-3],0],[[-1,0,0,0,0,0,1,0,-2],0],
    [[-3,0,2,0,0,0,8,0,-13,0,5],0],
    [[-7,0,0,0,7,0,-1],0],[[-12,0,15,0,-4],0],
    [[-1,0,0,0,0,0,2,0,0,0,-3,0,1],0],
    [[-3,0,2,0,3,0,-3],0],[[-1,0,1,0,1],0],
    [[-2,0,2,0,1],0],[[-1,0,0,0,0,0,2],0],
    [[-3,0,4,0,-1],0],[[-1,0,0,0,1],0],
    [[-2,0,1,0,2,0,-1],0],[[-1,0,0,0,1],0],
    [[-4,0,6,0,-2],0],[[-1,0,0,0,2,0,-1],0],
    [[-3,0,4],0],[[-1,0,0,0,1,0,1],0],
    [[-5,0,9,0,-4,0,1],0],[[-1,0,0,0,0,0,2],0]],
    [[[168],0],[[168],120],
    [[1,0,0,0,0,0,0,0,27,0,0,0,-16,0,0,0,27,0,0,0,0,
    0,0,0,1],0],[[44,0,-80,0,44],0],
    [[9,0,0,0,5,0,0,0,30,0,-80,0,30,0,0,0,5,0,0,0,9],
    20],[[24],60],[[14,0,-40,0,60,0,-40,0,14],0],
    [[24,0,-60,0,24],0],[[24,0,0,0,-60,0,0,0,24],60],
    [[15],80],[[15],40],[[6,0,0,0,-6,0,0,0,6],20],
    [[6,0,-6,0,6],40],[[6,0,-16,0,26,0,-16,0,6],0],
    [[3,0,-4,0,8,0,-4,0,3],40],
    [[1,0,0,0,-9,0,24,0,-9,0,0,0,1],0],
    [[1,0,0,0,-9,0,24,0,-9,0,0,0,1],60],
    [[2,0,-2,0,2,0,4,0,2,0,-2,0,2],10],
    [[3,0,-12,0,18,0,-12,0,3],0],
    [[3,0,-1,0,-7,0,10,0,-7,0,-1,0,3],8],[[4],30],
    [[1,0,-2,0,3,0,-4,0,3,0,-2,0,1],0],
    [[-4,0,6,0,-4],2],[[-4,0,0,0,6,0,0,0,-4],28],
    [[3],48],[[3],24],
    [[1,0,0,0,0,0,0,0,9,0,-9,0,-2,0,6,0,-2,0,-9,0,9,
    0,0,0,0,0,0,0,1],0],
    [[1,0,0,0,2,0,0,0,1],0],
    [[1,0,0,0,5,0,0,0,1],40],
    [[8,0,-28,0,36,0,-28,0,8],0],
    [[1,0,0,0,-5,0,4,0,-5,0,0,0,1],8],[[3],20],
    [[2,0,-6,0,2],10],
    [[1,0,0,0,1,0,-6,0,1,0,0,0,1],40],
    [[1,0,-4,0,4,0,-4,0,1],10],
    [[1,0,0,0,1,0,0,0,1,0,0,0,1],0],
    [[2,0,-8,0,16,0,-18,0,16,0,-8,0,2],0],
    [[2,0,-2,0,2],8],[[1,0,-2,0,1],20],
    [[1,0,0,0,1],4],[[],0],[[],0],
    [[-1,0,2,0,-1],4],[[],0],
    [[1,0,0,0,-2,0,0,0,1],30],[[],0],[[],0],
    [[],0],[[],0],[[-2,0,3,0,-4,0,3,0,-2],2],
    [[-1,0,0,0,-1],4],[[-1],12],
    [[1,0,0,0,-3,0,5,0,-10,0,5,0,-3,0,0,0,1],0],
    [[-4],46],[[1,0,0,0,0,0,-3,0,0,0,0,0,1],20],
    [[1,0,-3,0,1],20],[[2],6],
    [[1,0,-1,0,2,0,-1,0,1],20],
    [[1,0,-4,0,7,0,-8,0,7,0,-4,0,1],0],
    [[-1,0,3,0,-4,0,3,0,-1],4],[[1],10],
    [[-2,0,2,0,-2,0,2,0,-2],2],[[-2],26],[[],0],
    [[],0],[[-84,0,84],0],[[-84,0,0,0,0,0,84],60],
    [[-24,0,60,0,-60,0,24],0],
    [[-1,0,0,0,0,0,0,0,-18,0,9,0,8,0,-8,0,-9,0,18,0,
    0,0,0,0,0,0,1],0],[[-4,0,20,0,-20,0,4],0],
    [[-4,0,0,0,0,0,0,0,0,0,20,0,-20,0,0,0,0,0,0,0,0,
    0,4],20],[[-4,0,0,0,12,0,-12,0,0,0,4],8],
    [[-1,0,0,0,6,0,-15,0,15,0,-6,0,0,0,1],0],
    [[-4,0,0,0,0,0,4],30],[[],0],
    [[-2,0,8,0,-14,0,14,0,-8,0,2],0],
    [[-14,0,40,0,-40,0,14],0],[[26,0,-26],30],
    [[-6,0,0,0,3,0,-3,0,0,0,6],20],[[-3,0,3],20],
    [[-5,0,18,0,-31,0,31,0,-18,0,5],0],
    [[-1,0,0,0,-1,0,1,0,0,0,1],0],
    [[-3,0,13,0,-19,0,19,0,-13,0,3],0],
    [[-2,0,1,0,-1,0,2],20],
    [[-1,0,0,0,2,0,-2,0,0,0,1],20],
    [[-2,0,3,0,-3,0,2],10],[[-1,0,1],4],
    [[-1,0,3,0,-3,0,3,0,-3,0,1],10],[[2,0,-2],4],
    [[2,0,0,0,0,0,-2],12],[[],0],[[],0],
    [[3,0,-4,0,4,0,-3],2],[[1,0,0,0,0,0,-1],12],
    [[-2,0,1,0,2,0,-5,0,5,0,-2,0,-1,0,2],8],
    [[1,0,-5,0,5,0,-1],4],
    [[-2,0,5,0,-9,0,9,0,-5,0,2],0],
    [[-1,0,1,0,-1,0,-1,0,1,0,1,0,-1,0,1],10],
    [[1,0,-1,0,2,0,-2,0,1,0,-1],4],[[],0],
    [[-1,0,1],6],[[-1,0,1],10],[[],0],[[],0],
    [[],0],[[],0],[[1,0,-1,0,1,0,-1,0,1,0,-1],2],
    [[1,0,0,0,0,0,-1],6],[[-1,0,1],6],
    [[-1,0,0,0,0,0,1],8],
    [[1,0,-2,0,2,0,-2,0,2,0,-1],2],[[1,0,-1],12]],
    [[[175],0],[[175],144],
    [[-40,0,0,0,54,0,-32,0,0,0,0,0,1],12],
    [[30,0,-80,0,65],0],
    [[30,0,-60,0,50,0,0,0,0,0,-20,0,15],32],
    [[15],72],[[7,0,-28,0,54,0,-60,0,26],0],
    [[10,0,-60,0,45],0],[[10,0,0,0,-60,0,0,0,45],72],
    [[-5],96],[[-5],48],[[1,0,0,0,12],24],
    [[1,0,12],48],[[1,0,-8,0,23,0,-28,0,16],0],
    [[1,0,4,0,-10,0,8,0,1],48],
    [[16,0,-18,0,0,0,1],6],[[16,0,-18,0,0,0,1],78],
    [[2,0,-4,0,-2,0,4,0,-1],16],
    [[-5,0,16,0,-23,0,11],2],
    [[-6,0,14,0,-11,0,-4,0,12,0,-6],12],[[-1],36],
    [[1,0,-2,0,6,0,-6,0,4],4],[[5,0,-10,0,5],4],
    [[],0],[[],0],[[],0],
    [[-6,0,14,0,-6,0,-18,0,26,0,-16,0,0,0,0,0,1],12],
    [[2,0,-8,0,1],4],[[-10,0,4,0,1],52],
    [[3,0,-15,0,36,0,-41,0,20],0],
    [[6,0,-5,0,0,0,4,0,-2],14],[[3],24],
    [[-3,0,4],12],[[-3,0,8,0,-7,0,2,0,1],52],
    [[-1,0,4,0,-6,0,0,0,1],12],
    [[-1,0,2,0,-4,0,1],6],
    [[1,0,-2,0,8,0,-16,0,22,0,-20,0,7],0],
    [[2,0,-2],12],[[1,0,-2,0,1],24],
    [[2,0,-2,0,2],8],[[-1,0,1],10],[[],0],
    [[-1],10],[[-1],12],[[-1],44],[[1],8],
    [[1],16],[[1],32],[[1],16],
    [[1,0,-3,0,6,0,-7,0,3],4],[[],0],[[],0],
    [[2,0,-6,0,8,0,-6,0,0,0,1],6],[[2,0,-3],54],
    [[-2,0,0,0,0,0,1],30],[[-2,0,1],26],[[-1],6],
    [[-1,0,0,0,-1,0,1],26],
    [[-1,0,2,0,-7,0,11,0,-11,0,5],2],
    [[-2,0,4,0,-3],8],[[-1],12],
    [[-2,0,4,0,-5,0,3],6],[[],0],[[],0],
    [[],0],[[-70,0,105],0],[[-70,0,0,0,0,0,105],72]
    ,[[-14,0,48,0,-72,0,41],0],
    [[20,0,-20,0,-18,0,44,0,-24,0,0,0,0,0,1],12],
    [[10,0,-30,0,15],2],
    [[10,0,-20,0,10,0,0,0,0,0,-10,0,5],34],
    [[9,0,-22,0,0,0,15,0,-7],12],
    [[-8,0,14,0,-12,0,0,0,1],6],
    [[-2,0,0,0,0,0,-3],36],[[3],30],
    [[3,0,-8,0,18,0,-18,0,8],2],
    [[-5,0,30,0,-50,0,30],0],
    [[-5,0,16,0,-21,0,15,0,0,0,0,0,-1,0,1],32],
    [[-1,0,0,0,-6,0,6],24],[[-7,0,6],24],
    [[-2,0,8,0,-23,0,35,0,-34,0,13],0],
    [[-1,0,3,0,-6,0,1],4],
    [[-1,0,4,0,-13,0,24,0,-23,0,11],0],
    [[-2,0,6,0,-5,0,3],24],[[-1,0,3,0,0,0,1],28],
    [[3,0,-2,0,2],12],[[1,0,-3,0,2],6],
    [[1,0,-3,0,4,0,-3,0,0,0,1],12],[[-1],8],
    [[-1],24],[[-1],22],[[1],14],
    [[-2,0,6,0,-8,0,4],4],[[],0],
    [[3,0,-6,0,8,0,-3,0,-4,0,8,0,-5],12],
    [[5,0,-4],8],[[1,0,-5,0,11,0,-13,0,7],2],
    [[1,0,-1,0,0,0,2,0,-1],18],[[-2,0,2,0,-2],10],
    [[],0],[[1],6],[[1],12],[[-1,0,1],12],
    [[],0],[[-1],8],[[-1],8],
    [[-1,0,2,0,-3,0,2],8],[[],0],[[-1],12],
    [[-1],16],[[1,0,-2,0,4,0,-5,0,2],6],[[],0]],
    [[[175],0],[[175],96],
    [[1,0,0,0,0,0,-32,0,54,0,0,0,-40],0],
    [[65,0,-80,0,30],0],
    [[15,0,-20,0,0,0,0,0,50,0,-60,0,30],16],
    [[15],48],[[26,0,-60,0,54,0,-28,0,7],0],
    [[45,0,-60,0,10],0],[[45,0,0,0,-60,0,0,0,10],48],
    [[-5],64],[[-5],32],[[12,0,0,0,1],20],
    [[12,0,1],34],[[16,0,-28,0,23,0,-8,0,1],0],
    [[1,0,8,0,-10,0,4,0,1],32],
    [[1,0,0,0,-18,0,16],0],[[1,0,0,0,-18,0,16],48],
    [[-1,0,4,0,-2,0,-4,0,2],8],
    [[11,0,-23,0,16,0,-5],0],
    [[-6,0,12,0,-4,0,-11,0,14,0,-6],6],[[-1],24],
    [[4,0,-6,0,6,0,-2,0,1],0],[[5,0,-10,0,5],0],
    [[],0],[[],0],[[],0],
    [[1,0,0,0,0,0,-16,0,26,0,-18,0,-6,0,14,0,-6],0],
    [[1,0,-8,0,2],0],[[1,0,4,0,-10],32],
    [[20,0,-41,0,36,0,-15,0,3],0],
    [[-2,0,4,0,0,0,-5,0,6],6],[[3],16],
    [[4,0,-3],10],[[1,0,2,0,-7,0,8,0,-3],32],
    [[1,0,0,0,-6,0,4,0,-1],8],[[1,0,-4,0,2,0,-1],0]
    ,[[7,0,-20,0,22,0,-16,0,8,0,-2,0,1],0],
    [[-2,0,2],6],[[1,0,-2,0,1],16],
    [[2,0,-2,0,2],0],[[1,0,-1],0],[[],0],
    [[-1],2],[[-1],4],[[-1],24],[[1],8],
    [[1],16],[[1],24],[[1],12],
    [[3,0,-7,0,6,0,-3,0,1],0],[[],0],[[],0],
    [[1,0,0,0,-6,0,8,0,-6,0,2],0],[[-3,0,2],36],
    [[1,0,0,0,0,0,-2],16],[[1,0,-2],16],[[-1],6],
    [[1,0,-1,0,0,0,-1],16],
    [[5,0,-11,0,11,0,-7,0,2,0,-1],0],
    [[-3,0,4,0,-2],4],[[-1],8],
    [[3,0,-5,0,4,0,-2],0],[[],0],[[],0],
    [[],0],[[-105,0,70],0],[[-105,0,0,0,0,0,70],48]
    ,[[-41,0,72,0,-48,0,14],0],
    [[-1,0,0,0,0,0,24,0,-44,0,18,0,20,0,-20],0],
    [[-15,0,30,0,-10],0],
    [[-5,0,10,0,0,0,0,0,-10,0,20,0,-10],16],
    [[7,0,-15,0,0,0,22,0,-9],6],
    [[-1,0,0,0,12,0,-14,0,8],0],
    [[3,0,0,0,0,0,2],24],[[-3],12],
    [[-8,0,18,0,-18,0,8,0,-3],0],
    [[-30,0,50,0,-30,0,5],0],
    [[-1,0,1,0,0,0,0,0,-15,0,21,0,-16,0,5],16],
    [[-6,0,6,0,0,0,1],20],[[-6,0,7],16],
    [[-13,0,34,0,-35,0,23,0,-8,0,2],0],
    [[-1,0,6,0,-3,0,1],0],
    [[-11,0,23,0,-24,0,13,0,-4,0,1],0],
    [[-3,0,5,0,-6,0,2],16],[[-1,0,0,0,-3,0,1],16],
    [[-2,0,2,0,-3],10],[[-2,0,3,0,-1],0],
    [[-1,0,0,0,3,0,-4,0,3,0,-1],8],[[1],2],
    [[1],6],[[1],12],[[-1],0],
    [[-4,0,8,0,-6,0,2],0],[[],0],
    [[5,0,-8,0,4,0,3,0,-8,0,6,0,-3],6],
    [[4,0,-5],4],[[-7,0,13,0,-11,0,5,0,-1],0],
    [[1,0,-2,0,0,0,1,0,-1],8],[[2,0,-2,0,2],4],
    [[],0],[[-1],8],[[-1],10],[[-1,0,1],0],
    [[],0],[[1],10],[[1],6],
    [[-2,0,3,0,-2,0,1],0],[[],0],[[1],2],
    [[1],6],[[-2,0,5,0,-4,0,2,0,-1],0],[[],0]],
    [[[210],0],[[210],168],
    [[-20,0,0,0,63,0,-80,0,0,0,0,0,23],12],
    [[17,0,-92,0,101],0],
    [[45,0,0,0,-33,0,-20,0,45,0,0,0,10,0,-24,0,0,0,0,
    0,0,0,0,0,3],36],[[10],84],
    [[1,0,-12,0,60,0,-92,0,45],0],[[6,0,-57,0,90],0],
    [[64,0,-30,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,-1],86],
    [[-15],112],[[-15],56],
    [[-8,0,6,0,0,0,6,0,0,0,-12,0,0,0,0,0,0,0,2],30],
    [[-3,0,6,0,-9],56],[[-2,0,23,0,-52,0,34],2],
    [[4,0,-4,0,8,0,-5],58],[[4,0,-21,0,0,0,23],6],
    [[12,0,-9,0,0,0,3],90],
    [[-2,0,0,0,6,0,-1,0,-8,0,0,0,0,0,3],18],
    [[-1,0,17,0,-46,0,32],2],
    [[3,0,-5,0,-8,0,33,0,-22,0,0,0,-4,0,5],14],
    [[-2],42],[[-2,0,14,0,-18,0,8],6],
    [[5,0,-25,0,25],4],[[5],40],[[],0],[[],0],
    [[8,0,-4,0,-22,0,51,0,-28,0,2,0,-7,0,7],14],
    [[4,0,-20,0,23],4],[[1,0,4,0,-4],60],
    [[-6,0,37,0,-71,0,39],2],
    [[-3,0,0,0,13,0,-14,0,0,0,0,0,3],16],[[1],28],
    [[-2,0,-6,0,4,0,0,0,2],16],
    [[-2,0,-2,0,4,0,-2],62],
    [[-2,0,0,0,6,0,-11,0,0,0,0,0,2],16],
    [[-2,0,10,0,-14,0,7],6],
    [[1,0,-16,0,41,0,-40,0,13],4],
    [[-2,0,-2,0,0,0,3],14],[[1],32],
    [[-1,0,8,0,-14,0,6],6],[[3,0,-7,0,4],8],
    [[],0],[[-1,0,6,0,-10,0,5],6],
    [[2,0,-5,0,0,0,3],10],[[1,0,0,0,-1],46],
    [[1,0,-3,0,0,0,2],10],[[],0],[[],0],
    [[],0],[[-4,0,19,0,-23,0,9],6],
    [[2,0,-4,0,3],8],[[],0],
    [[10,0,-7,0,-7,0,7],10],[[2,0,2,0,-1],64],
    [[-3],34],[[-3],30],[[2,0,-4,0,2],8],
    [[-1,0,2,0,-1],30],[[-7,0,24,0,-28,0,10],6],
    [[5,0,-7,0,-4,0,5],10],[[1],14],
    [[-2,0,12,0,-18,0,7],6],[[-1],36],[[],0],
    [[],0],[[-63,0,147],0],
    [[120,0,0,0,0,0,-56,0,0,0,0,0,0,0,27,0,0,0,0,0,0,
    0,0,0,-7],84],[[-4,0,39,0,-99,0,68],0],
    [[8,0,-12,0,-18,0,73,0,-52,0,0,0,-9,0,14],12],
    [[6,0,-40,0,50],2],
    [[20,0,0,0,-9,0,-10,0,15,0,0,0,5,0,-6,0,0,0,0,0,
    0,0,0,0,1],38],
    [[-8,0,0,0,27,0,-36,0,0,0,0,0,9],14],
    [[10,0,-15,0,-9,0,14],8],[[3,0,0,0,0,0,-3],50],
    [[7,0,-3,0,0,0,-1,0,0,0,0,0,1],30],
    [[-5,0,28,0,-43,0,20],4],[[-1,0,21,0,-71,0,60],0]
    ,
    [[16,0,-5,0,-10,0,5,0,9,0,-1,0,-1,0,-5,0,0,0,1],
    38],
    [[-11,0,3,0,-2,0,4,0,6,0,-6,0,0,0,0,0,-1,0,1],32]
    ,[[-6,0,-2,0,0,0,0,0,2],28],
    [[1,0,-14,0,51,0,-62,0,25],2],
    [[-1,0,10,0,-22,0,14],4],[[-8,0,33,0,-49,0,21],4]
    ,[[-1,0,3,0,-3,0,-1,0,0,0,-2,0,1],28],
    [[-3,0,4,0,-1,0,0,0,0,0,-2],32],
    [[1,0,1,0,-6,0,2,0,-1,0,1],16],
    [[4,0,-14,0,11],6],
    [[1,0,-1,0,-2,0,9,0,-6,0,0,0,-1,0,1],16],
    [[3,0,-10,0,9],6],[[5,0,-4,0,0,0,0,0,1],22],
    [[-1,0,-1],26],[[2,0,-3,0,1],10],
    [[-1,0,12,0,-27,0,15],4],[[-1,0,0,0,2,0,-2],18],
    [[3,0,-2,0,-11,0,22,0,-11,0,1,0,-3,0,2],16],
    [[2,0,-10,0,0,0,9],8],[[-2,0,18,0,-32,0,17],4],
    [[-1,0,0,0,3,0,0,0,-2,0,0,0,0,0,1],20],
    [[5,0,-3,0,-3,0,2],12],[[1,0,-1,0,1],10],
    [[-1,0,3,0,-3,0,1],8],[[],0],
    [[-1,0,5,0,-6,0,2],8],[[1,0,-1],12],
    [[2,0,-2,0,-1,0,1],12],[[1,0,-1],10],
    [[-2,0,9,0,-9,0,3],8],[[2,0,-2,0,0,0,1],12],
    [[-2,0,5,0,-6,0,2],8],[[-1,0,-1,0,0,0,1],16],
    [[-6,0,15,0,-14,0,4],8],[[-1,0,-1,0,1],18]],
    [[[210],0],[[210],72],
    [[23,0,0,0,0,0,-80,0,63,0,0,0,-20],0],
    [[101,0,-92,0,17],0],
    [[3,0,0,0,0,0,0,0,0,0,-24,0,10,0,0,0,45,0,-20,0,
    -33,0,0,0,45],0],[[10],36],
    [[45,0,-92,0,60,0,-12,0,1],0],[[90,0,-57,0,6],0],
    [[-1,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,-30,0,64],24],
    [[-15],48],[[-15],24],
    [[2,0,0,0,0,0,0,0,-12,0,0,0,6,0,0,0,6,0,-8],0],
    [[-9,0,6,0,-3],24],[[34,0,-52,0,23,0,-2],0],
    [[-5,0,8,0,-4,0,4],24],[[23,0,0,0,-21,0,4],0],
    [[3,0,0,0,-9,0,12],36],
    [[3,0,0,0,0,0,-8,0,-1,0,6,0,0,0,-2],0],
    [[32,0,-46,0,17,0,-1],0],
    [[5,0,-4,0,0,0,-22,0,33,0,-8,0,-5,0,3],0],
    [[-2],18],[[8,0,-18,0,14,0,-2],0],
    [[25,0,-25,0,5],0],[[5],24],[[],0],[[],0],
    [[7,0,-7,0,2,0,-28,0,51,0,-22,0,-4,0,8],0],
    [[23,0,-20,0,4],0],[[-4,0,4,0,1],24],
    [[39,0,-71,0,37,0,-6],0],
    [[3,0,0,0,0,0,-14,0,13,0,0,0,-3],0],[[1],12],
    [[2,0,0,0,4,0,-6,0,-2],0],
    [[-2,0,4,0,-2,0,-2],24],
    [[2,0,0,0,0,0,-11,0,6,0,0,0,-2],0],
    [[7,0,-14,0,10,0,-2],0],
    [[13,0,-40,0,41,0,-16,0,1],0],
    [[3,0,0,0,-2,0,-2],0],[[1],12],
    [[6,0,-14,0,8,0,-1],0],[[4,0,-7,0,3],0],
    [[],0],[[5,0,-10,0,6,0,-1],0],
    [[3,0,0,0,-5,0,2],0],[[-1,0,0,0,1],18],
    [[2,0,0,0,-3,0,1],0],[[],0],[[],0],[[],0],
    [[9,0,-23,0,19,0,-4],0],[[3,0,-4,0,2],0],
    [[],0],[[7,0,-7,0,-7,0,10],0],
    [[-1,0,2,0,2],24],[[-3],18],[[-3],14],
    [[2,0,-4,0,2],0],[[-1,0,2,0,-1],14],
    [[10,0,-28,0,24,0,-7],0],[[5,0,-4,0,-7,0,5],0],
    [[1],6],[[7,0,-18,0,12,0,-2],0],[[-1],16],
    [[],0],[[],0],[[-147,0,63],0],
    [[7,0,0,0,0,0,0,0,0,0,-27,0,0,0,0,0,0,0,56,0,0,
    0,0,0,-120],18],[[-68,0,99,0,-39,0,4],0],
    [[-14,0,9,0,0,0,52,0,-73,0,18,0,12,0,-8],0],
    [[-50,0,40,0,-6],0],
    [[-1,0,0,0,0,0,0,0,0,0,6,0,-5,0,0,0,-15,0,10,0,9,
    0,0,0,-20],0],
    [[-9,0,0,0,0,0,36,0,-27,0,0,0,8],0],
    [[-14,0,9,0,15,0,-10],0],[[3,0,0,0,0,0,-3],10],
    [[-1,0,0,0,0,0,1,0,0,0,3,0,-7],0],
    [[-20,0,43,0,-28,0,5],0],[[-60,0,71,0,-21,0,1],0]
    ,
    [[-1,0,0,0,5,0,1,0,1,0,-9,0,-5,0,10,0,5,0,-16],6]
    ,[[-1,0,1,0,0,0,0,0,6,0,-6,0,-4,0,2,0,-3,0,11],
    0],[[-2,0,0,0,0,0,2,0,6],6],
    [[-25,0,62,0,-51,0,14,0,-1],0],
    [[-14,0,22,0,-10,0,1],0],[[-21,0,49,0,-33,0,8],0]
    ,[[-1,0,2,0,0,0,1,0,3,0,-3,0,1],6],
    [[2,0,0,0,0,0,1,0,-4,0,3],8],
    [[-1,0,1,0,-2,0,6,0,-1,0,-1],0],
    [[-11,0,14,0,-4],0],
    [[-1,0,1,0,0,0,6,0,-9,0,2,0,1,0,-1],0],
    [[-9,0,10,0,-3],0],[[-1,0,0,0,0,0,4,0,-5],0],
    [[1,0,1],6],[[-1,0,3,0,-2],0],
    [[-15,0,27,0,-12,0,1],0],[[2,0,-2,0,0,0,1],6],
    [[-2,0,3,0,-1,0,11,0,-22,0,11,0,2,0,-3],0],
    [[-9,0,0,0,10,0,-2],0],[[-17,0,32,0,-18,0,2],0],
    [[-1,0,0,0,0,0,2,0,0,0,-3,0,0,0,1],0],
    [[-2,0,3,0,3,0,-5],0],[[-1,0,1,0,-1],0],
    [[-1,0,3,0,-3,0,1],0],[[],0],
    [[-2,0,6,0,-5,0,1],0],[[1,0,-1],4],
    [[-1,0,1,0,2,0,-2],0],[[1,0,-1],2],
    [[-3,0,9,0,-9,0,2],0],[[-1,0,0,0,2,0,-2],0],
    [[-2,0,6,0,-5,0,2],0],[[-1,0,0,0,1,0,1],0],
    [[-4,0,14,0,-15,0,6],0],[[-1,0,1,0,1],4]],
    [[[420],0],[[420],120],
    [[-16,0,54,0,0,0,-104,0,0,0,54,0,-16],6],
    [[110,0,-200,0,110],0],
    [[50,0,-60,0,60,0,-80,0,60,0,-60,0,50],24],
    [[36],60],[[34,0,-104,0,144,0,-104,0,34],0],
    [[60,0,-150,0,60],0],
    [[60,0,0,0,-150,0,0,0,60],60],[[24],80],
    [[24],40],[[6,0,0,0,-24,0,0,0,6],20],
    [[6,0,-24,0,6],40],[[14,0,-42,0,62,0,-42,0,14],0]
    ,[[2,0,-12,0,26,0,-12,0,2],40],
    [[-18,0,48,0,-18],4],[[-18,0,48,0,-18],64],
    [[-2,0,-4,0,8,0,-4,0,-2],12],
    [[7,0,-31,0,44,0,-31,0,7],0],
    [[-1,0,5,0,-1,0,-24,0,38,0,-24,0,-1,0,5,0,-1],6],
    [[],0],[[2,0,-4,0,8,0,-8,0,8,0,-4,0,2],0],
    [[1,0,-9,0,16,0,-9,0,1],0],
    [[1,0,0,0,-4,0,0,0,6,0,0,0,-4,0,0,0,1],24],
    [[5],48],[[5],24],
    [[-8,0,22,0,-18,0,-14,0,38,0,-14,0,-18,0,22,0,-8],6
    ],[[-4,0,10,0,-4],2],[[-4,0,16,0,-4],42],
    [[21,0,-67,0,94,0,-67,0,21],0],
    [[1,0,0,0,-8,0,16,0,-8,0,0,0,1],8],[[],0],
    [[2,0,-8,0,2],10],[[-2,0,8,0,-16,0,8,0,-2],42],
    [[-4,0,10,0,-4],12],[[-2,0,2,0,-4,0,2,0,-2],2],
    [[6,0,-20,0,38,0,-46,0,38,0,-20,0,6],0],
    [[2,0,-2,0,2],8],[[],0],
    [[-1,0,1,0,-2,0,1,0,-1],2],[[],0],[[],0],
    [[],0],[[],0],[[],0],[[],0],[[],0],
    [[],0],[[],0],
    [[1,0,-4,0,8,0,-10,0,8,0,-4,0,1],0],[[],0],
    [[1],12],[[-6,0,12,0,-18,0,12,0,-6],4],
    [[-6],46],[[],0],[[],0],[[],0],[[],0],
    [[3,0,-9,0,17,0,-20,0,17,0,-9,0,3],0],
    [[-1,0,5,0,-6,0,5,0,-1],4],[[],0],
    [[1,0,-3,0,5,0,-6,0,5,0,-3,0,1],0],
    [[1,0,-2,0,1],24],[[-1],16],[[-1],8],
    [[-210,0,210],0],[[-210,0,0,0,0,0,210],60],
    [[-60,0,150,0,-150,0,60],0],
    [[12,0,-40,0,18,0,52,0,-52,0,-18,0,40,0,-12],6],
    [[-10,0,50,0,-50,0,10],0],
    [[-10,0,20,0,-10,0,20,0,-20,0,10,0,-20,0,10],24],
    [[1,0,-6,0,0,0,43,0,-43,0,0,0,6,0,-1],6],
    [[12,0,-30,0,30,0,-12],4],[[-6,0,6],32],
    [[],0],[[-5,0,20,0,-35,0,35,0,-20,0,5],0],
    [[-35,0,100,0,-100,0,35],0],
    [[-5,0,0,0,15,0,-5,0,5,0,-15,0,0,0,5],24],
    [[-6,0,0,0,12,0,-12,0,0,0,6],20],[[6,0,-6],20],
    [[-13,0,45,0,-77,0,77,0,-45,0,13],0],
    [[3,0,-6,0,6,0,-3],2],
    [[-9,0,29,0,-49,0,49,0,-29,0,9],0],
    [[1,0,-8,0,8,0,-1],20],[[6,0,-6],24],
    [[-2,0,4,0,-4,0,2],10],[[1,0,-2,0,2,0,-1],2],
    [[3,0,-6,0,6,0,-3],12],[[],0],[[],0],
    [[],0],[[],0],
    [[-1,0,6,0,-11,0,11,0,-6,0,1],0],[[],0],
    [[1,0,-4,0,1,0,8,0,-19,0,19,0,-8,0,-1,0,4,0,-1],6
    ],[[1,0,-8,0,8,0,-1],4],
    [[-4,0,13,0,-22,0,22,0,-13,0,4],0],
    [[1,0,-2,0,2,0,-1],14],
    [[1,0,-2,0,3,0,-3,0,2,0,-1],4],[[],0],
    [[],0],[[],0],[[],0],[[],0],[[],0],
    [[],0],[[-1,0,1,0,-2,0,2,0,-2,0,2,0,-1,0,1],0],
    [[],0],[[],0],[[],0],
    [[-1,0,2,0,-4,0,5,0,-5,0,4,0,-2,0,1],0],[[],0]
    ],
    [[[300],0],[[300],156],[[-18,0,0,0,90,0,-80,0,0,0,
    0,0,20],12],[[35,0,-140,0,125],0],
    [[30,0,0,0,-35,0,0,0,-24,0,0,0,45,0,0,0,15,0,-12,
    0,0,0,0,0,0,0,0,0,1],32],[[20],78],
    [[2,0,-32,0,102,0,-112,0,52],0],
    [[15,0,-90,0,105],0],
    [[84,0,-64,0,15,0,0,0,0,0,0,0,-6,0,0,0,0,0,0,0,1]
    ,80],[[30],104],[[30],52],
    [[12,0,-16,0,6,0,0,0,6,0,0,0,-6,0,0,0,0,0,0,0,1],
    28],[[6,0,-18,0,15],52],
    [[1,0,-8,0,38,0,-68,0,31],0],
    [[1,0,-8,0,14,0,-20,0,7],52],
    [[18,0,-30,0,0,0,20],6],[[22,0,-18,0,0,0,4],84],
    [[2,0,-2,0,-1,0,4,0,0,0,-4,0,0,0,0,0,1],16],
    [[-5,0,30,0,-55,0,30],2],
    [[2,0,-12,0,-12,0,36,0,-16,0,0,0,-2,0,4],14],
    [[],0],[[1,0,-6,0,16,0,-16,0,5],4],
    [[10,0,-30,0,20],4],[[],0],[[],0],[[],0],
    [[6,0,4,0,-16,0,-35,0,64,0,-16,0,1,0,-7,0,5],12],
    [[6,0,-20,0,20],4],[[9,0,-8,0,5],56],
    [[1,0,-17,0,64,0,-87,0,41],0],
    [[-10,0,0,0,17,0,-6,0,0,0,0,0,1],16],[[2],26],
    [[4,0,2,0,-6,0,2,0,0,0,1],14],
    [[3,0,-4,0,10,0,-8,0,2],56],
    [[1,0,-3,0,1,0,7,0,-7,0,0,0,0,0,1],14],
    [[-4,0,10,0,-11,0,5],6],
    [[9,0,-34,0,51,0,-38,0,14],4],
    [[4,0,0,0,-3,0,0,0,1],12],[[1,0,0,0,1],26],
    [[-3,0,9,0,-10,0,4],6],[[3,0,-5,0,1],8],
    [[-1],24],[[-1,0,5,0,-6,0,4],6],
    [[3,0,-6,0,0,0,1],10],[[-1,0,-1],42],
    [[2,0,-3,0,0,0,1],10],[[],0],[[],0],
    [[],0],[[1,0,-11,0,21,0,-19,0,8],4],
    [[1,0,-2,0,1],8],[[],0],
    [[2,0,-4,0,17,0,-11,0,-7,0,5],6],
    [[3,0,-2,0,1],60],[[1,0,0,0,0,0,1],32],
    [[1,0,1],28],[[-2,0,1],10],[[-2,0,0,0,1],30],
    [[3,0,-16,0,29,0,-25,0,9],4],
    [[-3,0,9,0,-8,0,-2,0,4],8],[[],0],
    [[1,0,-5,0,14,0,-15,0,5],4],[[],0],[[],0],
    [[],0],[[-105,0,195],0],
    [[168,0,0,0,0,0,-105,0,0,0,0,0,0,0,0,0,0,0,0,0,27
    ],78],[[-10,0,75,0,-135,0,80],0],
    [[-2,0,-20,0,-27,0,99,0,-44,0,0,0,-8,0,12],12],
    [[15,0,-55,0,50],2],
    [[10,0,10,0,-10,0,0,0,-14,0,0,0,10,0,0,0,5,0,-1],
    34],[[3,0,-11,0,0,0,34,0,-30,0,0,0,0,0,6],12],
    [[-6,0,21,0,-21,0,-8,0,12],6],
    [[-2,0,-3,0,0,0,0,0,3],42],
    [[6,0,0,0,0,0,3,0,-3],24],
    [[1,0,-15,0,41,0,-44,0,19],2],
    [[-5,0,40,0,-100,0,65],0],
    [[5,0,0,0,-11,0,0,0,-5,0,0,0,10,0,1],34],
    [[20,0,-14,0,0,0,-2,0,4,0,3,0,-3,0,0,0,0,0,0,0,1]
    ,30],[[6,0,3],26],
    [[5,0,-36,0,75,0,-67,0,27],2],
    [[-2,0,13,0,-19,0,12],4],
    [[3,0,-20,0,50,0,-53,0,20],2],
    [[1,0,-5,0,2,0,2],26],[[4,0,-4,0,0,0,1],30],
    [[2,0,2,0,-5,0,1,0,0,0,1],16],
    [[6,0,-14,0,6],6],
    [[-4,0,-2,0,7,0,-4,0,0,0,0,0,1],18],
    [[2,0,-8,0,6],6],[[-5,0,0,0,5],18],
    [[1,0,0,0,-1],22],[[1,0,-1],10],
    [[-4,0,18,0,-26,0,12],4],[[-2,0,0,0,2],18],
    [[3,0,5,0,-9,0,-14,0,22,0,-5,0,0,0,-2,0,2],14],
    [[8,0,-12,0,0,0,6],8],
    [[1,0,-7,0,26,0,-35,0,13],2],
    [[1,0,-4,0,-2,0,2,0,1],18],
    [[1,0,-2,0,7,0,-4,0,-2,0,2],8],[[],0],
    [[1,0,-1,0,1],10],[[1],14],
    [[-2,0,3,0,-3,0,1],8],[[-1],14],
    [[-1,0,2,0,-2,0,0,0,1],10],[[],0],
    [[1,0,-4,0,7,0,-6,0,2],6],[[2,0,-2],12],
    [[-2,0,3,0,-3,0,2],8],[[1,0,0,0,-1],14],
    [[3,0,-10,0,13,0,-10,0,4],6],[[1,0,0,0,-1],16]],
    [[[300],0],[[300],84],
    [[20,0,0,0,0,0,-80,0,90,0,0,0,-18],0],
    [[125,0,-140,0,35],0],
    [[1,0,0,0,0,0,0,0,0,0,-12,0,15,0,0,0,45,0,0,0,
    -24,0,0,0,-35,0,0,0,30],0],[[20],42],
    [[52,0,-112,0,102,0,-32,0,2],0],
    [[105,0,-90,0,15],0],
    [[1,0,0,0,0,0,0,0,-6,0,0,0,0,0,0,0,15,0,-64,0,84]
    ,28],[[30],56],[[30],28],
    [[1,0,0,0,0,0,0,0,-6,0,0,0,6,0,0,0,6,0,-16,0,12],
    0],[[15,0,-18,0,6],28],
    [[31,0,-68,0,38,0,-8,0,1],0],
    [[7,0,-20,0,14,0,-8,0,1],28],
    [[20,0,0,0,-30,0,18],0],[[4,0,0,0,-18,0,22],42],
    [[1,0,0,0,0,0,-4,0,0,0,4,0,-1,0,-2,0,2],0],
    [[30,0,-55,0,30,0,-5],0],
    [[4,0,-2,0,0,0,-16,0,36,0,-12,0,-12,0,2],0],
    [[],0],[[5,0,-16,0,16,0,-6,0,1],0],
    [[20,0,-30,0,10],0],[[],0],[[],0],[[],0],
    [[5,0,-7,0,1,0,-16,0,64,0,-35,0,-16,0,4,0,6],0],
    [[20,0,-20,0,6],0],[[5,0,-8,0,9],28],
    [[41,0,-87,0,64,0,-17,0,1],0],
    [[1,0,0,0,0,0,-6,0,17,0,0,0,-10],0],[[2],14],
    [[1,0,0,0,2,0,-6,0,2,0,4],0],
    [[2,0,-8,0,10,0,-4,0,3],28],
    [[1,0,0,0,0,0,-7,0,7,0,1,0,-3,0,1],0],
    [[5,0,-11,0,10,0,-4],0],
    [[14,0,-38,0,51,0,-34,0,9],0],
    [[1,0,0,0,-3,0,0,0,4],0],[[1,0,0,0,1],14],
    [[4,0,-10,0,9,0,-3],0],[[1,0,-5,0,3],0],
    [[-1],12],[[4,0,-6,0,5,0,-1],0],
    [[1,0,0,0,-6,0,3],0],[[-1,0,-1],24],
    [[1,0,0,0,-3,0,2],0],[[],0],[[],0],[[],0],
    [[8,0,-19,0,21,0,-11,0,1],0],[[1,0,-2,0,1],0],
    [[],0],[[5,0,-7,0,-11,0,17,0,-4,0,2],0],
    [[1,0,-2,0,3],28],[[1,0,0,0,0,0,1],14],
    [[1,0,1],14],[[1,0,-2],0],[[1,0,0,0,-2],14],
    [[9,0,-25,0,29,0,-16,0,3],0],
    [[4,0,-2,0,-8,0,9,0,-3],0],[[],0],
    [[5,0,-15,0,14,0,-5,0,1],0],[[],0],[[],0],
    [[],0],[[-195,0,105],0],
    [[-27,0,0,0,0,0,0,0,0,0,0,0,0,0,105,0,0,0,0,0,
    -168],28],[[-80,0,135,0,-75,0,10],0],
    [[-12,0,8,0,0,0,44,0,-99,0,27,0,20,0,2],0],
    [[-50,0,55,0,-15],0],
    [[1,0,-5,0,0,0,-10,0,0,0,14,0,0,0,10,0,-10,0,-10],
    10],[[-6,0,0,0,0,0,30,0,-34,0,0,0,11,0,-3],0],
    [[-12,0,8,0,21,0,-21,0,6],0],
    [[-3,0,0,0,0,0,3,0,2],16],
    [[3,0,-3,0,0,0,0,0,-6],10],
    [[-19,0,44,0,-41,0,15,0,-1],0],
    [[-65,0,100,0,-40,0,5],0],
    [[-1,0,-10,0,0,0,5,0,0,0,11,0,0,0,-5],14],
    [[-1,0,0,0,0,0,0,0,3,0,-3,0,-4,0,2,0,0,0,14,0,-20
    ],0],[[-3,0,-6],14],
    [[-27,0,67,0,-75,0,36,0,-5],0],
    [[-12,0,19,0,-13,0,2],0],
    [[-20,0,53,0,-50,0,20,0,-3],0],
    [[-2,0,-2,0,5,0,-1],14],[[-1,0,0,0,4,0,-4],14],
    [[-1,0,0,0,-1,0,5,0,-2,0,-2],0],
    [[-6,0,14,0,-6],0],
    [[-1,0,0,0,0,0,4,0,-7,0,2,0,4],0],
    [[-6,0,8,0,-2],0],[[-5,0,0,0,5],8],
    [[1,0,0,0,-1],8],[[1,0,-1],2],
    [[-12,0,26,0,-18,0,4],0],[[-2,0,0,0,2],8],
    [[-2,0,2,0,0,0,5,0,-22,0,14,0,9,0,-5,0,-3],0],
    [[-6,0,0,0,12,0,-8],0],
    [[-13,0,35,0,-26,0,7,0,-1],0],
    [[-1,0,-2,0,2,0,4,0,-1],8],
    [[-2,0,2,0,4,0,-7,0,2,0,-1],0],[[],0],
    [[-1,0,1,0,-1],0],[[-1],8],
    [[-1,0,3,0,-3,0,2],0],[[1],4],
    [[-1,0,0,0,2,0,-2,0,1],0],[[],0],
    [[-2,0,6,0,-7,0,4,0,-1],0],[[2,0,-2],4],
    [[-2,0,3,0,-3,0,2],0],[[1,0,0,0,-1],4],
    [[-4,0,10,0,-13,0,10,0,-3],0],[[1,0,0,0,-1],6]],
    [[[350],0],[[350],144],
    [[-16,0,9,0,0,0,32,0,0,0,54,0,-96,0,0,0,0,0,15],6
    ],[[50,0,-180,0,120],0],
    [[45,0,-40,0,45,0,0,0,-80,0,0,0,12,0,0,0,15,0,0,0,
    5,0,-12],28],[[-10],72],
    [[3,0,-48,0,138,0,-128,0,33],0],
    [[35,0,-105,0,105],0],
    [[70,0,0,0,0,0,-64,0,15,0,0,0,20,0,0,0,-6],72],
    [[35],96],[[35],48],
    [[-5,0,0,0,0,0,-16,0,24,0,0,0,2,0,0,0,-6],24],
    [[8,0,-24,0,15],48],[[1,0,-18,0,63,0,-68,0,21],0]
    ,[[1,0,-12,0,24,0,-20,0,6],48],
    [[-3,0,32,0,-18,0,0,0,15],4],
    [[9,0,0,0,18,0,0,0,-1],76],
    [[-6,0,0,0,4,0,8,0,0,0,-4],16],
    [[1,0,-13,0,47,0,-58,0,21],0],
    [[1,0,-2,0,3,0,-8,0,5,0,-14,0,27,0,-13,0,0,0,-2,0,
    1],8],[[-2],36],
    [[3,0,-16,0,24,0,-10,0,1],4],
    [[-5,0,20,0,-30,0,15],2],[[],0],[[],0],
    [[],0],
    [[4,0,-8,0,15,0,-14,0,7,0,-34,0,41,0,-16,0,4,0,-5,
    0,1],8],[[-4,0,8,0,-24,0,15],2],
    [[-4,0,8,0,-12,0,3],50],
    [[2,0,-29,0,93,0,-94,0,27],0],
    [[-2,0,0,0,0,0,2,0,-2,0,7,0,-6],10],[[-1],24],
    [[-1,0,0,0,8,0,-2,0,2],12],
    [[7,0,-8,0,13,0,-6,0,1],52],
    [[-1,0,-2,0,3,0,0,0,6,0,-5],12],
    [[1,0,-8,0,16,0,-9,0,1],4],
    [[16,0,-56,0,66,0,-30,0,3],4],
    [[-4,0,4,0,0,0,-1],10],[[-1],24],
    [[1,0,-8,0,14,0,-7,0,1],4],[[-3,0,6,0,-3],6],
    [[],0],[[-2,0,7,0,-6,0,1],6],
    [[-2,0,4,0,-2],8],[[1,0,0,0,-1],40],
    [[-2,0,2,0,-1],8],[[-1],16],[[-1],32],
    [[-1],16],[[4,0,-20,0,29,0,-15,0,2],4],
    [[2,0,-2],8],[[],0],
    [[2,0,-16,0,16,0,1,0,-5,0,1],6],
    [[-2,0,3,0,-2],54],[[-1],36],[[-1],28],
    [[1,0,0,0,-2],6],[[-1],32],
    [[7,0,-30,0,40,0,-18,0,2],4],
    [[1,0,-8,0,11,0,-2,0,-2,0,1],6],[[1],12],
    [[2,0,-14,0,21,0,-10,0,1],4],[[],0],[[],0],
    [[],0],[[-140,0,210],0],
    [[189,0,-35,0,0,0,0,0,0,0,0,0,0,0,-105,0,0,0,0,0,
    21],70],[[-15,0,105,0,-165,0,65],0],
    [[4,0,-12,0,9,0,-20,0,12,0,-27,0,75,0,-48,0,0,0,-9,
    0,6],6],[[-5,0,30,0,-60,0,45],0],
    [[15,0,-10,0,20,0,10,0,-20,0,-1,0,-5,0,0,0,0,0,0,
    0,1],30],
    [[-3,0,0,0,-4,0,12,0,0,0,24,0,-30,0,0,0,0,0,3],8]
    ,[[-15,0,29,0,-9,0,-9,0,6],6],
    [[5,0,-3,0,0,0,-2,0,-3,0,3,0,2],36],
    [[-3,0,-3,0,0,0,0,0,4],22],
    [[4,0,-27,0,58,0,-42,0,9],2],
    [[-10,0,65,0,-115,0,55],0],
    [[9,0,-10,0,0,0,10,0,-16,0,-5,0,10,0,0,0,-5,0,1,0,
    1],30],
    [[7,0,2,0,0,0,8,0,-20,0,12,0,-2,0,0,0,3,0,-3],24]
    ,[[1,0,0,0,3,0,3],24],
    [[9,0,-57,0,101,0,-66,0,12],2],
    [[1,0,-5,0,18,0,-21,0,6],2],
    [[5,0,-37,0,72,0,-48,0,9],2],
    [[1,0,-2,0,0,0,1,0,0,0,1],24],
    [[-2,0,0,0,0,0,-3,0,3,0,1],26],
    [[-1,0,-2,0,-4,0,6,0,-1,0,1],12],
    [[-4,0,12,0,-12,0,3],4],
    [[1,0,-2,0,1,0,-4,0,5,0,-2],14],
    [[-1,0,3,0,-9,0,3],4],
    [[-1,0,0,0,0,0,-2,0,-1],12],
    [[-1,0,-1,0,1,0,1],18],[[-2,0,2],8],
    [[1,0,-11,0,28,0,-24,0,6],2],[[-1,0,0,0,1],14],
    [[1,0,-1,0,6,0,-2,0,7,0,-15,0,12,0,-3,0,1,0,-1],
    10],[[-4,0,12,0,-6,0,0,0,3],6],
    [[2,0,-18,0,41,0,-30,0,6],2],
    [[-1,0,0,0,0,0,2],18],[[2,0,-8,0,5,0,1,0,-1],8]
    ,[[1],10],[[-1,0,0,0,1,0,-1],6],
    [[-1,0,1,0,-1],12],[[1,0,-5,0,5,0,-1],6],
    [[],0],[[1,0,-2,0,2],8],[[1],8],
    [[3,0,-11,0,10,0,-2],6],[[-1,0,1],10],
    [[-4,0,5,0,-2],8],[[-2,0,1],12],
    [[7,0,-19,0,17,0,-5],6],[[-1,0,0,0,1],14]],
    [[[350],0],[[350],96],
    [[15,0,0,0,0,0,-96,0,54,0,0,0,32,0,0,0,9,0,-16],0
    ],[[120,0,-180,0,50],0],
    [[-12,0,5,0,0,0,15,0,0,0,12,0,0,0,-80,0,0,0,45,0,
    -40,0,45],10],[[-10],48],
    [[33,0,-128,0,138,0,-48,0,3],0],
    [[105,0,-105,0,35],0],
    [[-6,0,0,0,20,0,0,0,15,0,-64,0,0,0,0,0,70],40],
    [[35],64],[[35],32],
    [[-6,0,0,0,2,0,0,0,24,0,-16,0,0,0,0,0,-5],8],
    [[15,0,-24,0,8],32],[[21,0,-68,0,63,0,-18,0,1],0]
    ,[[6,0,-20,0,24,0,-12,0,1],32],
    [[15,0,0,0,-18,0,32,0,-3],0],
    [[-1,0,0,0,18,0,0,0,9],48],
    [[-4,0,0,0,8,0,4,0,0,0,-6],6],
    [[21,0,-58,0,47,0,-13,0,1],0],
    [[1,0,-2,0,0,0,-13,0,27,0,-14,0,5,0,-8,0,3,0,-2,0,
    1],0],[[-2],24],
    [[1,0,-10,0,24,0,-16,0,3],0],
    [[15,0,-30,0,20,0,-5],0],[[],0],[[],0],
    [[],0],
    [[1,0,-5,0,4,0,-16,0,41,0,-34,0,7,0,-14,0,15,0,-8,
    0,4],0],[[15,0,-24,0,8,0,-4],0],
    [[3,0,-12,0,8,0,-4],32],
    [[27,0,-94,0,93,0,-29,0,2],0],
    [[-6,0,7,0,-2,0,2,0,0,0,0,0,-2],6],[[-1],16],
    [[2,0,-2,0,8,0,0,0,-1],4],
    [[1,0,-6,0,13,0,-8,0,7],32],
    [[-5,0,6,0,0,0,3,0,-2,0,-1],6],
    [[1,0,-9,0,16,0,-8,0,1],0],
    [[3,0,-30,0,66,0,-56,0,16],0],
    [[-1,0,0,0,4,0,-4],4],[[-1],20],
    [[1,0,-7,0,14,0,-8,0,1],0],[[-3,0,6,0,-3],2],
    [[],0],[[1,0,-6,0,7,0,-2],0],
    [[-2,0,4,0,-2],4],[[-1,0,0,0,1],24],
    [[-1,0,2,0,-2],4],[[-1],16],[[-1],24],
    [[-1],12],[[2,0,-15,0,29,0,-20,0,4],0],
    [[-2,0,2],2],[[],0],
    [[1,0,-5,0,1,0,16,0,-16,0,2],0],
    [[-2,0,3,0,-2],34],[[-1],16],[[-1],16],
    [[-2,0,0,0,1],2],[[-1],16],
    [[2,0,-18,0,40,0,-30,0,7],0],
    [[1,0,-2,0,-2,0,11,0,-8,0,1],0],[[1],8],
    [[1,0,-10,0,21,0,-14,0,2],0],[[],0],[[],0],
    [[],0],[[-210,0,140],0],
    [[-21,0,0,0,0,0,105,0,0,0,0,0,0,0,0,0,0,0,35,0,
    -189],36],[[-65,0,165,0,-105,0,15],0],
    [[-6,0,9,0,0,0,48,0,-75,0,27,0,-12,0,20,0,-9,0,12,
    0,-4],0],[[-45,0,60,0,-30,0,5],0],
    [[-1,0,0,0,0,0,0,0,5,0,1,0,20,0,-10,0,-20,0,10,0,
    -15],12],
    [[-3,0,0,0,0,0,30,0,-24,0,0,0,-12,0,4,0,0,0,3],0]
    ,[[-6,0,9,0,9,0,-29,0,15],0],
    [[-2,0,-3,0,3,0,2,0,0,0,3,0,-5],18],
    [[-4,0,0,0,0,0,3,0,3],12],
    [[-9,0,42,0,-58,0,27,0,-4],0],
    [[-55,0,115,0,-65,0,10],0],
    [[-1,0,-1,0,5,0,0,0,-10,0,5,0,16,0,-10,0,0,0,10,0,
    -9],12],
    [[3,0,-3,0,0,0,2,0,-12,0,20,0,-8,0,0,0,-2,0,-7],8
    ],[[-3,0,-3,0,0,0,-1],12],
    [[-12,0,66,0,-101,0,57,0,-9],0],
    [[-6,0,21,0,-18,0,5,0,-1],0],
    [[-9,0,48,0,-72,0,37,0,-5],0],
    [[-1,0,0,0,-1,0,0,0,2,0,-1],12],
    [[-1,0,-3,0,3,0,0,0,0,0,2],14],
    [[-1,0,1,0,-6,0,4,0,2,0,1],4],
    [[-3,0,12,0,-12,0,4],0],
    [[2,0,-5,0,4,0,-1,0,2,0,-1],6],
    [[-3,0,9,0,-3,0,1],0],[[1,0,2,0,0,0,0,0,1],10],
    [[-1,0,-1,0,1,0,1],10],[[-2,0,2],4],
    [[-6,0,24,0,-28,0,11,0,-1],0],[[-1,0,0,0,1],12],
    [[1,0,-1,0,3,0,-12,0,15,0,-7,0,2,0,-6,0,1,0,-1],2
    ],[[-3,0,0,0,6,0,-12,0,4],0],
    [[-6,0,30,0,-41,0,18,0,-2],0],
    [[-2,0,0,0,0,0,1],10],
    [[1,0,-1,0,-5,0,8,0,-2],2],[[-1],4],
    [[1,0,-1,0,0,0,1],2],[[1,0,-1,0,1],6],
    [[1,0,-5,0,5,0,-1],2],[[],0],
    [[-2,0,2,0,-1],6],[[-1],6],
    [[2,0,-10,0,11,0,-3],2],[[-1,0,1],6],
    [[2,0,-5,0,4],2],[[-1,0,2],8],
    [[5,0,-17,0,19,0,-7],2],[[-1,0,0,0,1],8]],
    [[[525],0],[[525],144],
    [[1,0,0,0,0,0,0,0,36,0,0,0,-32,0,0,0,135,0,-112,0,
    0,0,0,0,17],0],[[80,0,-260,0,185],0],
    [[10,0,0,0,0,0,-80,0,90,0,0,0,30,0,0,0,-18,0,-40,
    0,15,0,0,0,10,0,-12],24],[[5],72],
    [[9,0,-80,0,186,0,-192,0,58],0],
    [[45,0,-165,0,150],0],
    [[24,0,0,0,0,0,0,0,24,0,-64,0,45,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,1],68],[[30],96],[[30],48],
    [[6,0,0,0,0,0,0,0,6,0,-16,0,9,0,0,0,6,0,0,0,0,0,
    0,0,0,0,0,0,1],20],[[9,0,-12,0,15],48],
    [[2,0,-26,0,86,0,-96,0,37],0],
    [[2,0,-8,0,14,0,-12,0,7],48],
    [[1,0,0,0,-12,0,32,0,-45,0,0,0,17],0],
    [[1,0,0,0,0,0,0,0,-9,0,0,0,1],72],
    [[-2,0,0,0,2,0,-4,0,-4,0,12,0,1,0,-4],12],
    [[1,0,-18,0,63,0,-81,0,32],0],
    [[-3,0,0,0,12,0,-5,0,-24,0,36,0,-17,0,0,0,-3,0,1],
    10],[[-3],36],[[4,0,-18,0,29,0,-18,0,4],4],
    [[-5,0,25,0,-40,0,20],2],[[],0],[[],0],
    [[],0],
    [[1,0,0,0,0,0,-9,0,16,0,10,0,8,0,-53,0,63,0,-32,0,
    5,0,-5,0,2],4],[[1,0,0,0,16,0,-28,0,17],0],
    [[1,0,0,0,4,0,-4,0,5],48],
    [[5,0,-44,0,129,0,-135,0,47],0],
    [[2,0,4,0,-3,0,0,0,9,0,-10],12],[[2],24],
    [[2,0,0,0,2,0,1,0,-6,0,0,0,0,0,1],10],
    [[2,0,-4,0,4,0,-4,0,2],52],
    [[1,0,-2,0,0,0,-2,0,1,0,7,0,-3,0,0,0,0,0,1],10],
    [[2,0,-7,0,19,0,-13,0,2],4],
    [[-4,0,25,0,-68,0,89,0,-52,0,9],2],
    [[1,0,-2,0,6,0,-4,0,-2],8],[[-2,0,1],26],
    [[1,0,-8,0,15,0,-11,0,2],4],
    [[-3,0,6,0,-4,0,1],6],[[],0],
    [[-2,0,7,0,-7,0,1],6],[[-2,0,4,0,-3],8],
    [[-1,0,0,0,1,0,0,0,-1],36],
    [[2,0,-3,0,0,0,1],10],[[],0],[[],0],
    [[],0],[[6,0,-21,0,35,0,-24,0,4],4],
    [[2,0,-2],8],[[],0],
    [[1,0,5,0,-22,0,25,0,-4,0,-5,0,2],4],
    [[1,0,0,0,1],56],
    [[1,0,0,0,0,0,0,0,0,0,0,0,1],24],
    [[1,0,0,0,1],24],[[1,0,0,0,1],8],
    [[1,0,0,0,0,0,0,0,1],24],
    [[-1,0,10,0,-35,0,51,0,-31,0,6],2],
    [[2,0,-8,0,15,0,-7,0,-3,0,1],6],[[],0],
    [[2,0,-16,0,25,0,-15,0,4],4],[[],0],[[],0],
    [[],0],[[-210,0,315],0],
    [[105,0,0,0,0,0,0,0,0,0,-189,0,210,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,-21],66],
    [[-29,0,153,0,-237,0,106],0],
    [[1,0,0,0,0,0,-9,0,27,0,12,0,-20,0,-63,0,116,0,-68,
    0,0,0,-10,0,7],2],[[-5,0,40,0,-90,0,60],0],
    [[4,0,0,0,0,0,-20,0,20,0,-4,0,11,0,4,0,-5,0,-10,0,
    5,0,-1,0,1],26],
    [[-2,0,3,0,8,0,-12,0,-3,0,45,0,-30,0,0,0,0,0,4],8
    ],[[1,0,3,0,-21,0,41,0,-24,0,-10,0,7],2],
    [[-3,0,0,0,0,0,3,0,-2,0,0,0,0,0,-1],34],
    [[-3,0,-3,0,7],26],[[7,0,-36,0,73,0,-63,0,16],2],
    [[-15,0,95,0,-165,0,85],0],
    [[5,0,-25,0,20,0,0,0,5,0,0,0,1,0,-5,0,0,0,0,0,0,
    0,-1],30],
    [[6,0,0,0,0,0,-6,0,8,0,-8,0,9,0,-4,0,2,0,0,0,0,
    0,0,0,0,0,-1],22],
    [[6,0,0,0,3,0,0,0,0,0,-3],22],
    [[-1,0,20,0,-78,0,134,0,-103,0,24],0],
    [[1,0,-6,0,21,0,-27,0,7],2],
    [[-1,0,9,0,-50,0,96,0,-71,0,20],0],
    [[3,0,-2,0,2,0,-2,0,2,0,0,0,2,0,-2],22],
    [[1,0,0,0,1,0,0,0,0,0,-2,0,1,0,0,0,2,0,-1],22],
    [[2,0,-2,0,0,0,5,0,-2,0,0,0,-1],12],
    [[-4,0,13,0,-15,0,5],4],
    [[1,0,-2,0,2,0,-1,0,-4,0,5,0,-1,0,0,0,-1],12],
    [[6,0,-7,0,4],6],[[1,0,2,0,0,0,0,0,1,0,-1],14],
    [[-1,0,-1,0,0,0,1],18],[[-2,0,2,0,-1],8],
    [[1,0,-13,0,34,0,-32,0,10],2],[[1,0,0,0,-1],20],
    [[-3,0,-3,0,8,0,6,0,-20,0,17,0,-8,0,2,0,-1],12],
    [[1,0,-4,0,12,0,-15,0,0,0,4],4],
    [[3,0,-23,0,52,0,-43,0,13],2],
    [[-1,0,0,0,1,0,0,0,0,0,3,0,-1],14],
    [[3,0,-9,0,8,0,0,0,-1],8],[[1],10],
    [[1,0,-1],10],[[1,0,-1],14],
    [[1,0,-4,0,6,0,-3],6],[[],0],
    [[-1,0,3,0,-1,0,-1],10],[[],0],
    [[3,0,-11,0,13,0,-6,0,1],6],[[-1,0,1],10],
    [[-3,0,6,0,-3],8],[[-1,0,2,0,-1],12],
    [[-1,0,7,0,-19,0,23,0,-11,0,1],4],
    [[1,0,0,0,-1],16]],
    [[[525],0],[[525],96],[[17,0,0,0,0,0,-112,0,135,0,
    0,0,-32,0,0,0,36,0,0,0,0,0,0,0,1],0],
    [[185,0,-260,0,80],0],
    [[-12,0,10,0,0,0,15,0,-40,0,-18,0,0,0,30,0,0,0,90,
    0,-80,0,0,0,0,0,10],10],[[5],48],
    [[58,0,-192,0,186,0,-80,0,9],0],
    [[150,0,-165,0,45],0],
    [[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,0,-64,0,24,
    0,0,0,0,0,0,0,24],32],[[30],64],
    [[30],32],
    [[1,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,9,0,-16,0,6,0,
    0,0,0,0,0,0,6],0],[[15,0,-12,0,9],32],
    [[37,0,-96,0,86,0,-26,0,2],0],
    [[7,0,-12,0,14,0,-8,0,2],32],
    [[17,0,0,0,-45,0,32,0,-12,0,0,0,1],0],
    [[1,0,0,0,-9,0,0,0,0,0,0,0,1],48],
    [[-4,0,1,0,12,0,-4,0,-4,0,2,0,0,0,-2],6],
    [[32,0,-81,0,63,0,-18,0,1],0],
    [[1,0,-3,0,0,0,-17,0,36,0,-24,0,-5,0,12,0,0,0,-3],
    0],[[-3],24],[[4,0,-18,0,29,0,-18,0,4],0],
    [[20,0,-40,0,25,0,-5],0],[[],0],[[],0],
    [[],0],
    [[2,0,-5,0,5,0,-32,0,63,0,-53,0,8,0,10,0,16,0,-9,
    0,0,0,0,0,1],0],
    [[17,0,-28,0,16,0,0,0,1],0],
    [[5,0,-4,0,4,0,0,0,1],32],
    [[47,0,-135,0,129,0,-44,0,5],0],
    [[-10,0,9,0,0,0,-3,0,4,0,2],6],[[2],16],
    [[1,0,0,0,0,0,-6,0,1,0,2,0,0,0,2],0],
    [[2,0,-4,0,4,0,-4,0,2],32],
    [[1,0,0,0,0,0,-3,0,7,0,1,0,-2,0,0,0,-2,0,1],0],
    [[2,0,-13,0,19,0,-7,0,2],0],
    [[9,0,-52,0,89,0,-68,0,25,0,-4],0],
    [[-2,0,-4,0,6,0,-2,0,1],4],[[1,0,-2],16],
    [[2,0,-11,0,15,0,-8,0,1],0],
    [[1,0,-4,0,6,0,-3],0],[[],0],
    [[1,0,-7,0,7,0,-2],0],[[-3,0,4,0,-2],4],
    [[-1,0,0,0,1,0,0,0,-1],24],
    [[1,0,0,0,-3,0,2],0],[[],0],[[],0],[[],0],
    [[4,0,-24,0,35,0,-21,0,6],0],[[-2,0,2],2],
    [[],0],[[2,0,-5,0,-4,0,25,0,-22,0,5,0,1],0],
    [[1,0,0,0,1],32],
    [[1,0,0,0,0,0,0,0,0,0,0,0,1],16],
    [[1,0,0,0,1],16],[[1,0,0,0,1],0],
    [[1,0,0,0,0,0,0,0,1],16],
    [[6,0,-31,0,51,0,-35,0,10,0,-1],0],
    [[1,0,-3,0,-7,0,15,0,-8,0,2],0],[[],0],
    [[4,0,-15,0,25,0,-16,0,2],0],[[],0],[[],0],
    [[],0],[[-315,0,210],0],
    [[21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-210,0,
    189,0,0,0,0,0,0,0,0,0,-105],30],
    [[-106,0,237,0,-153,0,29],0],
    [[-7,0,10,0,0,0,68,0,-116,0,63,0,20,0,-12,0,-27,0,
    9,0,0,0,0,0,-1],0],[[-60,0,90,0,-40,0,5],0]
    ,
    [[-1,0,1,0,-5,0,10,0,5,0,-4,0,-11,0,4,0,-20,0,20,
    0,0,0,0,0,-4],12],
    [[-4,0,0,0,0,0,30,0,-45,0,3,0,12,0,-8,0,-3,0,2],0
    ],[[-7,0,10,0,24,0,-41,0,21,0,-3,0,-1],0],
    [[1,0,0,0,0,0,2,0,-3,0,0,0,0,0,3],18],
    [[-7,0,3,0,3],12],[[-16,0,63,0,-73,0,36,0,-7],0],
    [[-85,0,165,0,-95,0,15],0],
    [[1,0,0,0,0,0,0,0,5,0,-1,0,0,0,-5,0,0,0,-20,0,25,
    0,-5],10],
    [[1,0,0,0,0,0,0,0,0,0,-2,0,4,0,-9,0,8,0,-8,0,6,
    0,0,0,0,0,-6],2],
    [[3,0,0,0,0,0,-3,0,0,0,-6],10],
    [[-24,0,103,0,-134,0,78,0,-20,0,1],0],
    [[-7,0,27,0,-21,0,6,0,-1],0],
    [[-20,0,71,0,-96,0,50,0,-9,0,1],0],
    [[2,0,-2,0,0,0,-2,0,2,0,-2,0,2,0,-3],10],
    [[1,0,-2,0,0,0,-1,0,2,0,0,0,0,0,-1,0,0,0,-1],10],
    [[1,0,0,0,2,0,-5,0,0,0,2,0,-2],2],
    [[-5,0,15,0,-13,0,4],0],
    [[1,0,0,0,1,0,-5,0,4,0,1,0,-2,0,2,0,-1],2],
    [[-4,0,7,0,-6],0],
    [[1,0,-1,0,0,0,0,0,-2,0,-1],6],
    [[-1,0,0,0,1,0,1],10],[[1,0,-2,0,2],2],
    [[-10,0,32,0,-34,0,13,0,-1],0],[[1,0,0,0,-1],6],
    [[1,0,-2,0,8,0,-17,0,20,0,-6,0,-8,0,3,0,3],2],
    [[-4,0,0,0,15,0,-12,0,4,0,-1],0],
    [[-13,0,43,0,-52,0,23,0,-3],0],
    [[1,0,-3,0,0,0,0,0,-1,0,0,0,1],8],
    [[1,0,0,0,-8,0,9,0,-3],2],[[-1],4],
    [[1,0,-1],2],[[1,0,-1],6],
    [[3,0,-6,0,4,0,-1],2],[[],0],
    [[1,0,1,0,-3,0,1],2],[[],0],
    [[-1,0,6,0,-13,0,11,0,-3],0],[[-1,0,1],6],
    [[3,0,-6,0,3],2],[[1,0,-2,0,1],6],
    [[-1,0,11,0,-23,0,19,0,-7,0,1],0],
    [[1,0,0,0,-1],6]],
    [[[567],0],[[567],160],[[9,0,0,0,-24,0,0,0,153,0,
    -192,0,0,0,0,0,45],8],[[57,0,-264,0,246],0],
    [[45,0,0,0,20,0,0,0,-36,0,-40,0,75,0,0,0,20,0,-48,
    0,0,0,0,0,0,0,0,0,3],32],[[-9],80],
    [[3,0,-48,0,180,0,-240,0,96],0],
    [[27,0,-162,0,216],0],[[81],80],[[],0],
    [[],0],
    [[-24,0,27,0,0,0,12,0,0,0,-18,0,0,0,0,0,0,0,3],30
    ],[[],0],[[-12,0,75,0,-132,0,69],2],[[],0],
    [[-3,0,24,0,-51,0,0,0,45],4],
    [[9,0,0,0,9,0,0,0,-3],84],
    [[1,0,-4,0,0,0,16,0,-1,0,-16,0,0,0,0,0,3],16],
    [[-7,0,56,0,-115,0,65],2],
    [[1,0,4,0,-6,0,-26,0,71,0,-44,0,0,0,-8,0,7],12],
    [[3],40],[[-12,0,38,0,-38,0,11],6],
    [[-1,0,20,0,-61,0,49],2],
    [[4,0,0,0,0,0,0,0,4,0,0,0,-1],36],[[-3],64],
    [[-3],32],
    [[9,0,6,0,-3,0,-57,0,114,0,-60,0,6,0,-15,0,9],12],
    [[12,0,-48,0,45],4],[[],0],
    [[1,0,-24,0,118,0,-180,0,82],0],
    [[1,0,0,0,-4,0,0,0,25,0,-28,0,0,0,0,0,3],12],
    [[],0],[[3,0,-12,0,6,0,0,0,3],16],[[],0],
    [[15,0,-18,0,0,0,0,0,3],20],
    [[-6,0,27,0,-30,0,9],6],
    [[9,0,-56,0,113,0,-88,0,22],4],
    [[5,0,-4,0,-4,0,0,0,3],12],[[],0],
    [[-5,0,23,0,-27,0,9],6],[[-1,0,9,0,-13,0,5],6],
    [[],0],[[-2,0,14,0,-20,0,7],6],
    [[-1,0,6,0,-9,0,0,0,3],8],[[-2,0,0,0,1],44],
    [[3,0,-6,0,0,0,3],10],[[],0],[[],0],
    [[],0],[[1,0,-17,0,50,0,-49,0,14],4],
    [[4,0,-8,0,3],8],[[1],16],
    [[-12,0,27,0,-12,0,-15,0,9],8],[[-3],60],
    [[],0],[[],0],[[3,0,-6,0,3],8],[[],0],
    [[2,0,-27,0,67,0,-59,0,16],4],
    [[-4,0,17,0,-13,0,-8,0,7],8],[[],0],
    [[-10,0,35,0,-35,0,11],6],[[2,0,-1],34],
    [[],0],[[],0],[[-189,0,378],0],
    [[210,0,0,0,0,0,15,0,0,0,0,0,-35,0,0,0,0,0,-21,0,
    27,0,0,0,0,0,0,0,0,0,-7],78],
    [[-15,0,126,0,-270,0,156],0],
    [[9,0,6,0,-18,0,-54,0,171,0,-120,0,0,0,-21,0,24],10
    ],[[-1,0,26,0,-106,0,110],0],
    [[20,0,0,0,11,0,4,0,-14,0,-10,0,25,0,-1,0,6,0,-12],
    34],
    [[1,0,2,0,-8,0,-1,0,64,0,-76,0,0,0,0,0,15],10],
    [[-9,0,36,0,-33,0,-21,0,24],6],
    [[-4,0,-3,0,3,0,1,0,3,0,0,0,0,0,-3],42],
    [[-3,0,-3,0,11,0,-6,0,0,0,-2],26],
    [[1,0,-22,0,82,0,-101,0,37],2],
    [[-6,0,72,0,-192,0,135],0],
    [[10,0,0,0,5,0,-5,0,0,0,0,0,4,0,0,0,0,0,-6,0,0,
    0,1],34],
    [[8,0,-25,0,18,0,-6,0,6,0,9,0,-9,0,0,0,0,0,-2,0,1
    ],30],[[3,0,-3,0,1,0,-3,0,0,0,2],26],
    [[6,0,-54,0,147,0,-150,0,48],2],
    [[-3,0,27,0,-51,0,24],4],
    [[2,0,-31,0,102,0,-113,0,40],2],
    [[-2,0,6,0,-3,0,2,0,-2,0,-2,0,1],28],
    [[-7,0,8,0,0,0,2,0,-1,0,-2],32],
    [[-1,0,8,0,-9,0,3,0,-2,0,1],16],
    [[-1,0,14,0,-31,0,18],4],
    [[-7,0,17,0,-9,0,0,0,-2,0,1],20],
    [[7,0,-21,0,15],6],
    [[1,0,0,0,-2,0,0,0,9,0,-7],14],
    [[1,0,2,0,-1,0,-1],22],[[-1,0,5,0,-4,0,1],8],
    [[-6,0,38,0,-60,0,27],4],[[2,0,-3],22],
    [[1,0,4,0,1,0,-28,0,44,0,-19,0,3,0,-5,0,2],14],
    [[-1,0,11,0,-22,0,0,0,15],6],
    [[-12,0,55,0,-74,0,30],4],
    [[-2,0,0,0,5,0,0,0,-4],20],
    [[-6,0,12,0,-3,0,-5,0,2],10],[[2,0,-2],10],
    [[-1,0,5,0,-5,0,1],8],[[2,0,-2],14],
    [[-4,0,12,0,-10,0,2],8],[[1,0,-1],12],
    [[-1,0,5,0,-3,0,-2,0,1],10],[[1,0,-1],10],
    [[-10,0,22,0,-16,0,3],8],[[-1,0,3,0,-3],10],
    [[-4,0,13,0,-10,0,2],8],[[3,0,-1,0,-1],14],
    [[2,0,-20,0,38,0,-26,0,5],6],[[-2,0,1],20]],
    [[[567],0],[[567],80],
    [[45,0,0,0,0,0,-192,0,153,0,0,0,-24,0,0,0,9],0],
    [[246,0,-264,0,57],0],
    [[3,0,0,0,0,0,0,0,0,0,-48,0,20,0,0,0,75,0,-40,0,
    -36,0,0,0,20,0,0,0,45],0],[[-9],40],
    [[96,0,-240,0,180,0,-48,0,3],0],
    [[216,0,-162,0,27],0],[[81],48],[[],0],
    [[],0],
    [[3,0,0,0,0,0,0,0,-18,0,0,0,12,0,0,0,27,0,-24],0]
    ,[[],0],[[69,0,-132,0,75,0,-12],0],[[],0],
    [[45,0,0,0,-51,0,24,0,-3],0],
    [[-3,0,0,0,9,0,0,0,9],40],
    [[3,0,0,0,0,0,-16,0,-1,0,16,0,0,0,-4,0,1],0],
    [[65,0,-115,0,56,0,-7],0],
    [[7,0,-8,0,0,0,-44,0,71,0,-26,0,-6,0,4,0,1],0],
    [[3],20],[[11,0,-38,0,38,0,-12],0],
    [[49,0,-61,0,20,0,-1],0],
    [[-1,0,0,0,4,0,0,0,0,0,0,0,4],16],[[-3],32],
    [[-3],16],
    [[9,0,-15,0,6,0,-60,0,114,0,-57,0,-3,0,6,0,9],0],
    [[45,0,-48,0,12],0],[[],0],
    [[82,0,-180,0,118,0,-24,0,1],0],
    [[3,0,0,0,0,0,-28,0,25,0,0,0,-4,0,0,0,1],0],
    [[],0],[[3,0,0,0,6,0,-12,0,3],0],[[],0],
    [[3,0,0,0,0,0,-18,0,15],0],
    [[9,0,-30,0,27,0,-6],0],
    [[22,0,-88,0,113,0,-56,0,9],0],
    [[3,0,0,0,-4,0,-4,0,5],0],[[],0],
    [[9,0,-27,0,23,0,-5],0],[[5,0,-13,0,9,0,-1],0],
    [[],0],[[7,0,-20,0,14,0,-2],0],
    [[3,0,0,0,-9,0,6,0,-1],0],[[1,0,0,0,-2],20],
    [[3,0,0,0,-6,0,3],0],[[],0],[[],0],[[],0],
    [[14,0,-49,0,50,0,-17,0,1],0],[[3,0,-8,0,4],0],
    [[1],8],[[9,0,-15,0,-12,0,27,0,-12],0],
    [[-3],32],[[],0],[[],0],[[3,0,-6,0,3],0],
    [[],0],[[16,0,-59,0,67,0,-27,0,2],0],
    [[7,0,-8,0,-13,0,17,0,-4],0],[[],0],
    [[11,0,-35,0,35,0,-10],0],[[-1,0,2],16],
    [[],0],[[],0],[[-378,0,189],0],
    [[7,0,0,0,0,0,0,0,0,0,-27,0,21,0,0,0,0,0,35,0,0,
    0,0,0,-15,0,0,0,0,0,-210],18],
    [[-156,0,270,0,-126,0,15],0],
    [[-24,0,21,0,0,0,120,0,-171,0,54,0,18,0,-6,0,-9],0]
    ,[[-110,0,106,0,-26,0,1],0],
    [[12,0,-6,0,1,0,-25,0,10,0,14,0,-4,0,-11,0,0,0,-20]
    ,10],
    [[-15,0,0,0,0,0,76,0,-64,0,1,0,8,0,-2,0,-1],0],
    [[-24,0,21,0,33,0,-36,0,9],0],
    [[3,0,0,0,0,0,-3,0,-1,0,-3,0,3,0,4],10],
    [[2,0,0,0,6,0,-11,0,3,0,3],6],
    [[-37,0,101,0,-82,0,22,0,-1],0],
    [[-135,0,192,0,-72,0,6],0],
    [[-1,0,0,0,6,0,0,0,0,0,-4,0,0,0,0,0,5,0,-5,0,0,
    0,-10],6],
    [[-1,0,2,0,0,0,0,0,9,0,-9,0,-6,0,6,0,-18,0,25,0,
    -8],0],[[-2,0,0,0,3,0,-1,0,3,0,-3],6],
    [[-48,0,150,0,-147,0,54,0,-6],0],
    [[-24,0,51,0,-27,0,3],0],
    [[-40,0,113,0,-102,0,31,0,-2],0],
    [[-1,0,2,0,2,0,-2,0,3,0,-6,0,2],6],
    [[2,0,1,0,-2,0,0,0,-8,0,7],8],
    [[-1,0,2,0,-3,0,9,0,-8,0,1],0],
    [[-18,0,31,0,-14,0,1],0],
    [[-1,0,2,0,0,0,9,0,-17,0,7],0],
    [[-15,0,21,0,-7],0],
    [[7,0,-9,0,0,0,2,0,0,0,-1],6],
    [[1,0,1,0,-2,0,-1],6],[[-1,0,4,0,-5,0,1],0],
    [[-27,0,60,0,-38,0,6],0],[[3,0,-2],6],
    [[-2,0,5,0,-3,0,19,0,-44,0,28,0,-1,0,-4,0,-1],0],
    [[-15,0,0,0,22,0,-11,0,1],0],
    [[-30,0,74,0,-55,0,12],0],
    [[4,0,0,0,-5,0,0,0,2],6],
    [[-2,0,5,0,3,0,-12,0,6],0],[[2,0,-2],2],
    [[-1,0,5,0,-5,0,1],0],[[2,0,-2],6],
    [[-2,0,10,0,-12,0,4],0],[[1,0,-1],4],
    [[-1,0,2,0,3,0,-5,0,1],0],[[1,0,-1],2],
    [[-3,0,16,0,-22,0,10],0],[[3,0,-3,0,1],4],
    [[-2,0,10,0,-13,0,4],0],[[1,0,1,0,-3],4],
    [[-5,0,26,0,-38,0,20,0,-2],0],[[-1,0,2],4]],
    [[[1134],0],[[1134],120],
    [[6,0,0,0,0,0,-96,0,135,0,0,0,-108,0,0,0,135,0,-96,
    0,0,0,0,0,6],0],[[279,0,-576,0,279],0],
    [[-24,0,0,0,-35,0,-60,0,210,0,-200,0,210,0,-60,0,-35,
    0,0,0,-24],20],[[30],60],
    [[63,0,-288,0,432,0,-288,0,63],0],
    [[189,0,-378,0,189],0],
    [[15,0,-64,0,84,0,0,0,-70,0,0,0,84,0,-64,0,15],56],
    [[81],80],[[81],40],
    [[6,0,-16,0,12,0,0,0,-4,0,0,0,12,0,-16,0,6],16],
    [[27,0,-54,0,27],40],
    [[27,0,-126,0,198,0,-126,0,27],0],
    [[9,0,-36,0,54,0,-36,0,9],40],
    [[6,0,0,0,-45,0,108,0,-45,0,0,0,6],0],
    [[2,0,0,0,-9,0,44,0,-9,0,0,0,2],60],
    [[4,0,-1,0,-6,0,4,0,-6,0,-1,0,4],10],
    [[21,0,-93,0,150,0,-93,0,21],0],
    [[-7,0,16,0,-16,0,-16,0,52,0,-16,0,-16,0,16,0,-7],6
    ],[[2],30],
    [[1,0,-10,0,30,0,-44,0,30,0,-10,0,1],0],
    [[6,0,-39,0,60,0,-39,0,6],0],
    [[1,0,0,0,-4,0,0,0,0,0,0,0,-4,0,0,0,1],24],
    [[4],48],[[4],24],
    [[1,0,-2,0,1,0,-16,0,41,0,-61,0,18,0,36,0,18,0,-61,
    0,41,0,-16,0,1,0,-2,0,1],0],
    [[6,0,-24,0,36,0,-24,0,6],0],
    [[3,0,-12,0,27,0,-12,0,3],40],
    [[42,0,-189,0,294,0,-189,0,42],0],
    [[2,0,-2,0,-10,0,20,0,-10,0,-2,0,2],8],
    [[-3],20],[[2,0,4,0,-12,0,4,0,2],8],
    [[1,0,-6,0,18,0,-26,0,18,0,-6,0,1],40],
    [[1,0,1,0,-7,0,10,0,-7,0,1,0,1],8],
    [[1,0,-6,0,15,0,-20,0,15,0,-6,0,1],0],
    [[4,0,-44,0,122,0,-164,0,122,0,-44,0,4],0],
    [[4,0,-8,0,4],8],[[-1,0,2,0,-1],20],
    [[-3,0,12,0,-18,0,12,0,-3],2],[[3,0,-6,0,3],4],
    [[],0],[[-2,0,4,0,-6,0,4,0,-2],2],
    [[3,0,-8,0,3],6],[[-2],34],[[2,0,-4,0,2],6],
    [[],0],[[],0],[[],0],
    [[1,0,-12,0,37,0,-50,0,37,0,-12,0,1],0],
    [[1,0,0,0,1],4],[[],0],
    [[1,0,-2,0,-2,0,33,0,-60,0,33,0,-2,0,-2,0,1],0],
    [[3,0,-6,0,3],44],
    [[-1,0,0,0,0,0,-1,0,0,0,0,0,-1],20],
    [[-1,0,-1,0,-1],20],[[],0],
    [[-1,0,0,0,2,0,0,0,-1],20],
    [[2,0,-21,0,61,0,-84,0,61,0,-21,0,2],0],
    [[-2,0,15,0,-26,0,15,0,-2],4],[[-1],10],
    [[1,0,-7,0,24,0,-36,0,24,0,-7,0,1],0],
    [[1,0,-2,0,1],24],[[1],16],[[1],8],
    [[-567,0,567],0],
    [[-189,0,378,0,0,0,0,0,0,0,0,0,-378,0,189],56],
    [[-135,0,432,0,-432,0,135],0],
    [[-3,0,3,0,0,0,48,0,-102,0,81,0,54,0,-54,0,-81,0,
    102,0,-48,0,0,0,-3,0,3],0],
    [[-45,0,144,0,-144,0,45],0],
    [[5,0,-4,0,0,0,0,0,-35,0,35,0,-35,0,35,0,0,0,0,0,
    4,0,-5],20],
    [[12,0,-27,0,0,0,42,0,-42,0,0,0,27,0,-12],6],
    [[-3,0,3,0,18,0,-81,0,81,0,-18,0,-3,0,3],0],
    [[-3,0,0,0,0,0,0,0,0,0,3],28],
    [[3,0,0,0,0,0,0,0,0,0,-3],16],
    [[-9,0,57,0,-123,0,123,0,-57,0,9],0],
    [[-90,0,288,0,-288,0,90],0],
    [[-9,0,0,0,9,0,-9,0,0,0,9],26],
    [[-6,0,8,0,-8,0,12,0,2,0,-2,0,-12,0,8,0,-8,0,6],
    16],[[],0],
    [[-18,0,117,0,-243,0,243,0,-117,0,18],0],
    [[-3,0,15,0,-30,0,30,0,-15,0,3],0],
    [[-12,0,75,0,-165,0,165,0,-75,0,12],0],[[],0],
    [[],0],[[-2,0,0,0,10,0,-10,0,0,0,2],8],
    [[6,0,-18,0,18,0,-6],2],
    [[-1,0,0,0,2,0,-11,0,11,0,-2,0,0,0,1],8],
    [[3,0,-6,0,6,0,-3],2],
    [[1,0,0,0,-8,0,8,0,0,0,-1],10],
    [[1,0,0,0,0,0,-1],14],[[1,0,-1],6],
    [[-3,0,21,0,-51,0,51,0,-21,0,3],0],[[-3,0,3],14],
    [[3,0,-6,0,10,0,-5,0,-26,0,26,0,5,0,-10,0,6,0,-3],
    6],[[6,0,-24,0,24,0,-6],4],
    [[-6,0,36,0,-84,0,84,0,-36,0,6],0],[[-2,0,2],16],
    [[-5,0,15,0,-15,0,5],6],[[],0],[[],0],
    [[],0],[[-2,0,4,0,-4,0,2],4],[[],0],
    [[-1,0,3,0,-3,0,1],6],[[],0],
    [[2,0,-8,0,15,0,-15,0,8,0,-2],2],[[1,0,-1],8],
    [[1,0,-2,0,3,0,-3,0,2,0,-1],2],[[2,0,-2],10],
    [[4,0,-17,0,29,0,-29,0,17,0,-4],2],[[2,0,-2],12]
    ],
    [[[700],0],[[700],132],[[2,0,0,0,0,0,0,0,72,0,0,
    0,-66,0,0,0,162,0,-80,0,0,0,0,0,2],0],
    [[145,0,-340,0,215],0],
    [[9,0,0,0,10,0,0,0,60,0,-128,0,120,0,-60,0,25,0,0,
    0,9,0,-40,0,15],20],[[20],66],
    [[36,0,-136,0,246,0,-216,0,66],0],
    [[75,0,-240,0,145],0],
    [[-24,0,0,0,0,0,0,0,-60,0,64],64],[[-20],88],
    [[-20],44],[[12,0,0,0,-9,0,0,0,12,0,-8,0,-9],20],
    [[-6,0,12,0,-8],44],
    [[8,0,-54,0,109,0,-94,0,38],0],
    [[-1,0,12,0,-8,0,8,0,-4],44],
    [[2,0,0,0,-24,0,74,0,-54,0,0,0,2],0],
    [[2,0,0,0,0,0,14,0,-18,0,0,0,2],66],
    [[2,0,-3,0,0,0,8,0,-2,0,-6,0,10,0,-1],10],
    [[5,0,-35,0,80,0,-75,0,25],0],
    [[4,0,-4,0,-15,0,34,0,-18,0,-20,0,27,0,-8],8],
    [[],0],[[-2,0,8,0,-18,0,23,0,-16,0,5],2],
    [[-10,0,30,0,-30,0,10],2],[[],0],[[],0],
    [[],0],
    [[-1,0,0,0,0,0,9,0,-27,0,5,0,26,0,8,0,-58,0,60,0,
    -28,0,0,0,0,0,2],2],
    [[2,0,0,0,12,0,-20,0,2],0],
    [[-1,0,0,0,-6,0,4,0,-1],44],
    [[18,0,-86,0,162,0,-146,0,48],0],
    [[-2,0,-6,0,14,0,-12,0,-2,0,8,0,-4],10],
    [[-4],22],[[4,0,-9,0,4,0,3],10],
    [[2,0,-4,0,4,0,-1,0,2,0,-1],46],
    [[2,0,-7,0,8,0,-7,0,0,0,3],10],
    [[-1,0,-1,0,-5,0,11,0,-7,0,2],2],
    [[3,0,-18,0,46,0,-82,0,92,0,-52,0,10],0],
    [[1,0,-8,0,10,0,-4],8],[[-1,0,2,0,-2],22],
    [[2,0,-5,0,8,0,-7,0,1],4],[[-1,0,2,0,-2,0,1],6]
    ,[[],0],[[-2,0,4,0,1,0,-1],4],
    [[1,0,-2,0,0,0,-1],6],[[-1,0,-1],36],[[1],10],
    [[1],20],[[1],32],[[1],16],
    [[-3,0,9,0,-20,0,28,0,-17,0,3],2],
    [[-1,0,2,0,-1],4],[[],0],
    [[-1,0,-3,0,21,0,-35,0,28,0,-12,0,0,0,2],2],
    [[],0],[[-1,0,0,0,0,0,2,0,0,0,0,0,-1],22],
    [[-1,0,2,0,-1],22],[[3,0,-3],6],
    [[-1,0,1,0,0,0,1,0,-1],22],
    [[1,0,-6,0,20,0,-38,0,46,0,-29,0,6],0],
    [[-1,0,7,0,-15,0,15,0,-6],4],[[],0],
    [[-1,0,6,0,-13,0,18,0,-13,0,3],2],[[],0],
    [[],0],[[],0],[[-315,0,385],0],
    [[-84,0,0,0,0,0,105,0,0,0,-216,0,280,0,0,0,0,0,0,
    0,0,0,0,0,-15],60],
    [[-70,0,225,0,-285,0,120],0],
    [[-1,0,1,0,0,0,0,0,-36,0,36,0,30,0,-36,0,-72,0,118,
    0,-52,0,0,0,0,0,2],0],
    [[-10,0,65,0,-105,0,40],0],
    [[10,0,-34,0,25,0,-15,0,5,0,0,0,4,0,-10,0,5],30],
    [[-7,0,3,0,31,0,-39,0,-3,0,41,0,-12],8],
    [[-1,0,1,0,12,0,-50,0,60,0,-30,0,0,0,2],0],
    [[-4,0,0,0,-3,0,0,0,0,0,0,0,-2,0,3],30],
    [[-1,0,0,0,0,0,3,0,-3,0,0,0,3],18],
    [[-3,0,19,0,-52,0,76,0,-56,0,14],0],
    [[-35,0,150,0,-190,0,85],0],
    [[30,0,-41,0,26,0,-5,0,0,0,5,0,1,0,-6],30],
    [[-6,0,6,0,6,0,-3,0,-6,0,6,0,-2,0,-3],20],
    [[-3,0,6,0,-8,0,0,0,3],20],
    [[-10,0,50,0,-113,0,155,0,-106,0,26],0],
    [[-1,0,1,0,-3,0,16,0,-13,0,2],0],
    [[-5,0,29,0,-75,0,100,0,-74,0,20],0],
    [[-2,0,3,0,-5,0,6,0,-4,0,-4,0,1],20],
    [[-1,0,1,0,2,0,1,0,-1,0,2,0,0,0,-2],20],
    [[-2,0,8,0,-5,0,0,0,1],10],
    [[-5,0,8,0,-7,0,3],4],
    [[-1,0,5,0,-8,0,7,0,-3,0,-2,0,1],10],
    [[3,0,-2,0,-1],4],
    [[-3,0,2,0,2,0,-1,0,1,0,-1],14],
    [[-1,0,0,0,1],18],[[1,0,-1],10],
    [[5,0,-17,0,29,0,-23,0,6],2],[[1,0,-1],12],
    [[-1,0,3,0,4,0,-16,0,17,0,2,0,-15,0,13,0,-5],8],
    [[2,0,-11,0,21,0,-10],4],
    [[-1,0,11,0,-34,0,50,0,-37,0,13],0],
    [[1,0,0,0,-1,0,3,0,-2,0,-1,0,3,0,-1],12],
    [[-3,0,7,0,-9,0,7,0,-3],6],[[-1],6],
    [[-2,0,3,0,-1],6],[[-1,0,0,0,1],10],
    [[-1,0,3,0,-2],8],[[1,0,-1],10],[[1],12],
    [[1],8],[[-1,0,3,0,-7,0,10,0,-6,0,1],4],
    [[1,0,-1],10],[[1,0,-3,0,1,0,2,0,-1],4],
    [[1,0,-2,0,2,0,-1],10],
    [[1,0,-3,0,7,0,-15,0,18,0,-9,0,1],2],
    [[1,0,-1],12]],
    [[[700],0],[[700],108],[[2,0,0,0,0,0,-80,0,162,0,
    0,0,-66,0,0,0,72,0,0,0,0,0,0,0,2],0],
    [[215,0,-340,0,145],0],
    [[15,0,-40,0,9,0,0,0,25,0,-60,0,120,0,-128,0,60,0,
    0,0,10,0,0,0,9],16],[[20],54],
    [[66,0,-216,0,246,0,-136,0,36],0],
    [[145,0,-240,0,75],0],
    [[64,0,-60,0,0,0,0,0,0,0,-24],54],[[-20],72],
    [[-20],36],[[-9,0,-8,0,12,0,0,0,-9,0,0,0,12],16],
    [[-8,0,12,0,-6],36],
    [[38,0,-94,0,109,0,-54,0,8],0],
    [[-4,0,8,0,-8,0,12,0,-1],36],
    [[2,0,0,0,-54,0,74,0,-24,0,0,0,2],0],
    [[2,0,0,0,-18,0,14,0,0,0,0,0,2],54],
    [[-1,0,10,0,-6,0,-2,0,8,0,0,0,-3,0,2],8],
    [[25,0,-75,0,80,0,-35,0,5],0],
    [[-8,0,27,0,-20,0,-18,0,34,0,-15,0,-4,0,4],6],
    [[],0],[[5,0,-16,0,23,0,-18,0,8,0,-2],0],
    [[10,0,-30,0,30,0,-10],0],[[],0],[[],0],
    [[],0],
    [[2,0,0,0,0,0,-28,0,60,0,-58,0,8,0,26,0,5,0,-27,0,
    9,0,0,0,0,0,-1],0],
    [[2,0,-20,0,12,0,0,0,2],0],
    [[-1,0,4,0,-6,0,0,0,-1],36],
    [[48,0,-146,0,162,0,-86,0,18],0],
    [[-4,0,8,0,-2,0,-12,0,14,0,-6,0,-2],6],
    [[-4],18],[[3,0,4,0,-9,0,4],8],
    [[-1,0,2,0,-1,0,4,0,-4,0,2],36],
    [[3,0,0,0,-7,0,8,0,-7,0,2],8],
    [[2,0,-7,0,11,0,-5,0,-1,0,-1],0],
    [[10,0,-52,0,92,0,-82,0,46,0,-18,0,3],0],
    [[-4,0,10,0,-8,0,1],6],[[-2,0,2,0,-1],18],
    [[1,0,-7,0,8,0,-5,0,2],0],[[1,0,-2,0,2,0,-1],0]
    ,[[],0],[[-1,0,1,0,4,0,-2],2],
    [[-1,0,0,0,-2,0,1],4],[[-1,0,-1],30],[[1],6],
    [[1],12],[[1],24],[[1],12],
    [[3,0,-17,0,28,0,-20,0,9,0,-3],0],
    [[-1,0,2,0,-1],4],[[],0],
    [[2,0,0,0,-12,0,28,0,-35,0,21,0,-3,0,-1],0],
    [[],0],[[-1,0,0,0,0,0,2,0,0,0,0,0,-1],18],
    [[-1,0,2,0,-1],18],[[-3,0,3],4],
    [[-1,0,1,0,0,0,1,0,-1],18],
    [[6,0,-29,0,46,0,-38,0,20,0,-6,0,1],0],
    [[-6,0,15,0,-15,0,7,0,-1],4],[[],0],
    [[3,0,-13,0,18,0,-13,0,6,0,-1],0],[[],0],
    [[],0],[[],0],[[-385,0,315],0],
    [[15,0,0,0,0,0,0,0,0,0,0,0,-280,0,216,0,0,0,-105,
    0,0,0,0,0,84],42],
    [[-120,0,285,0,-225,0,70],0],
    [[-2,0,0,0,0,0,52,0,-118,0,72,0,36,0,-30,0,-36,0,
    36,0,0,0,0,0,-1,0,1],0],
    [[-40,0,105,0,-65,0,10],0],
    [[-5,0,10,0,-4,0,0,0,-5,0,15,0,-25,0,34,0,-10],16],
    [[12,0,-41,0,3,0,39,0,-31,0,-3,0,7],6],
    [[-2,0,0,0,30,0,-60,0,50,0,-12,0,-1,0,1],0],
    [[-3,0,2,0,0,0,0,0,0,0,3,0,0,0,4],22],
    [[-3,0,0,0,3,0,-3,0,0,0,0,0,1],12],
    [[-14,0,56,0,-76,0,52,0,-19,0,3],0],
    [[-85,0,190,0,-150,0,35],0],
    [[6,0,-1,0,-5,0,0,0,5,0,-26,0,41,0,-30],18],
    [[3,0,2,0,-6,0,6,0,3,0,-6,0,-6,0,6],16],
    [[-3,0,0,0,8,0,-6,0,3],14],
    [[-26,0,106,0,-155,0,113,0,-50,0,10],0],
    [[-2,0,13,0,-16,0,3,0,-1,0,1],0],
    [[-20,0,74,0,-100,0,75,0,-29,0,5],0],
    [[-1,0,4,0,4,0,-6,0,5,0,-3,0,2],14],
    [[2,0,0,0,-2,0,1,0,-1,0,-2,0,-1,0,1],16],
    [[-1,0,0,0,5,0,-8,0,2],8],[[-3,0,7,0,-8,0,5],0]
    ,[[-1,0,2,0,3,0,-7,0,8,0,-5,0,1],8],
    [[1,0,2,0,-3],2],[[1,0,-1,0,1,0,-2,0,-2,0,3],6]
    ,[[-1,0,0,0,1],12],[[1,0,-1],2],
    [[-6,0,23,0,-29,0,17,0,-5],0],[[1,0,-1],16],
    [[5,0,-13,0,15,0,-2,0,-17,0,16,0,-4,0,-3,0,1],6],
    [[10,0,-21,0,11,0,-2],4],
    [[-13,0,37,0,-50,0,34,0,-11,0,1],0],
    [[1,0,-3,0,1,0,2,0,-3,0,1,0,0,0,-1],8],
    [[3,0,-7,0,9,0,-7,0,3],4],[[1],8],
    [[1,0,-3,0,2],4],[[-1,0,0,0,1],8],
    [[2,0,-3,0,1],2],[[1,0,-1],6],[[-1],6],
    [[-1],6],[[-1,0,6,0,-10,0,7,0,-3,0,1],0],
    [[1,0,-1],6],[[1,0,-2,0,-1,0,3,0,-1],2],
    [[1,0,-2,0,2,0,-1],6],
    [[-1,0,9,0,-18,0,15,0,-7,0,3,0,-1],0],
    [[1,0,-1],12]],
    [[[700],0],[[700],156],[[-82,0,0,0,234,0,-192,0,0,
    0,0,0,36],12],[[85,0,-320,0,295],0],
    [[30,0,-60,0,105,0,0,0,-54,0,-60,0,105,0,0,0,15,0,
    -24,0,0,0,0,0,0,0,0,0,3],32],[[-20],78],
    [[10,0,-76,0,222,0,-268,0,124],0],
    [[30,0,-215,0,240],0],
    [[24,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
    80],[[10],104],[[10],52],
    [[24,0,-24,0,3,0,0,0,12,0,0,0,-9,0,0,0,0,0,0,0,1]
    ,28],[[3,0,-2,0,6],52],
    [[1,0,-18,0,88,0,-148,0,81],0],
    [[1,0,0,0,4,0,-4,0,3],52],
    [[38,0,-78,0,0,0,36],6],[[-18,0,18,0,0,0,-4],84],
    [[2,0,-10,0,-7,0,20,0,-4,0,-8,0,0,0,0,0,3],16],
    [[-10,0,66,0,-123,0,71],2],
    [[-3,0,22,0,-28,0,-30,0,81,0,-42,0,0,0,-3,0,7],12],
    [[],0],[[1,0,-12,0,34,0,-40,0,17],4],
    [[20,0,-65,0,45],4],[[],0],[[],0],[[],0],
    [[-8,0,24,0,-17,0,-84,0,141,0,-60,0,1,0,-11,0,13],
    12],[[11,0,-48,0,36],4],[[-1,0,0,0,3],56],
    [[3,0,-40,0,141,0,-201,0,100],0],
    [[6,0,-18,0,0,0,30,0,-18,0,0,0,0,0,3],14],
    [[-2],26],[[8,0,-1,0,-12,0,3,0,0,0,1],14],
    [[-2,0,0,0,2,0,-2,0,1],56],
    [[3,0,-12,0,1,0,15,0,-12,0,0,0,0,0,1],14],
    [[1,0,-6,0,20,0,-26,0,13],4],
    [[-2,0,19,0,-68,0,115,0,-98,0,34],2],
    [[6,0,-6,0,-3,0,0,0,3],12],[[-1,0,0,0,-1],26],
    [[-4,0,17,0,-24,0,11],6],[[5,0,-11,0,6],8],
    [[],0],[[-2,0,8,0,-13,0,7],6],
    [[7,0,-10,0,0,0,3],10],[[1,0,-1],42],
    [[3,0,-6,0,0,0,1],10],[[-2],20],[[1],36],
    [[1],18],[[2,0,-18,0,44,0,-47,0,19],4],
    [[1,0,-4,0,3],8],[[],0],
    [[-15,0,38,0,-26,0,-11,0,13],8],
    [[-2,0,0,0,1],60],[[3,0,0,0,0,0,-1],32],
    [[3,0,-1],28],[[1,0,-3,0,1],8],
    [[1,0,-2,0,1,0,-1],28],
    [[6,0,-30,0,64,0,-63,0,24],4],
    [[-5,0,21,0,-19,0,-3,0,7],8],[[],0],
    [[1,0,-9,0,29,0,-36,0,15],4],[[],0],[[],0],
    [[],0],[[-245,0,455],0],
    [[273,0,-189,0,0,0,120,0,0,0,0,0,-21,0,0,0,0,0,0,
    0,27],78],[[-29,0,168,0,-312,0,191],0],
    [[32,0,-50,0,-81,0,225,0,-120,0,0,0,-12,0,24],12],
    [[30,0,-130,0,110],2],
    [[-15,0,35,0,0,0,-19,0,-20,0,30,0,0,0,5,0,-7,0,0,
    0,0,0,0,0,0,0,1],36],
    [[9,0,-44,0,0,0,86,0,-67,0,0,0,0,0,10],12],
    [[-12,0,53,0,-51,0,-12,0,24],6],
    [[3,0,-3,0,0,0,-3,0,2,0,3],40],
    [[-3,0,-6,0,0,0,9,0,-6,0,0,0,-1,0,0,0,0,0,1],24],
    [[3,0,-30,0,87,0,-104,0,46],2],
    [[-10,0,95,0,-225,0,155],0],
    [[5,0,-16,0,36,0,-14,0,-15,0,5,0,16,0,-1,0,-1],34],
    [[-6,0,26,0,-19,0,0,0,-4,0,8,0,3,0,-6,0,0,0,0,0,
    0,0,1],28],[[12,0,-6,0,-3],26],
    [[-1,0,15,0,-76,0,164,0,-164,0,65],0],
    [[-4,0,25,0,-42,0,24],4],
    [[7,0,-43,0,109,0,-125,0,52],2],
    [[3,0,-9,0,8,0,-1,0,-1],26],
    [[5,0,-5,0,4,0,-1],30],
    [[-2,0,7,0,4,0,-9,0,2,0,0,0,1],14],
    [[11,0,-28,0,17],6],
    [[-1,0,6,0,-8,0,-4,0,14,0,-8,0,0,0,0,0,1],14],
    [[4,0,-16,0,10],6],
    [[3,0,-10,0,0,0,9,0,-5,0,0,0,0,0,1],16],
    [[-1,0,-1,0,1,0,-1],20],[[2,0,-4,0,2],10],
    [[-7,0,36,0,-58,0,29],4],[[1,0,-3,0,0,0,2],16],
    [[-6,0,16,0,-12,0,-31,0,50,0,-21,0,0,0,-3,0,4],14],
    [[16,0,-29,0,0,0,10],8],
    [[1,0,-15,0,56,0,-78,0,37],2],
    [[1,0,-1,0,-4,0,7,0,-1,0,-2,0,0,0,0,0,1],18],
    [[-6,0,15,0,-10,0,-3,0,4],10],[[-1,0,1],12],
    [[-1,0,1,0,-2,0,1],8],[[-1],16],
    [[-2,0,7,0,-9,0,4],8],[[1,0,-1],12],
    [[-1,0,4,0,-4,0,0,0,1],10],[[],0],
    [[1,0,-7,0,17,0,-18,0,7],6],
    [[2,0,-3,0,0,0,1],12],[[1,0,-2,0,6,0,-8,0,4],6]
    ,[[3,0,-2,0,-1,0,0,0,1],14],
    [[4,0,-17,0,31,0,-28,0,10],6],[[2,0,-1,0,-1],16]
    ],
    [[[700],0],[[700],84],[[36,0,0,0,0,0,-192,0,234,0,
    0,0,-82],0],[[295,0,-320,0,85],0],
    [[3,0,0,0,0,0,0,0,0,0,-24,0,15,0,0,0,105,0,-60,0,
    -54,0,0,0,105,0,-60,0,30],0],[[-20],42],
    [[124,0,-268,0,222,0,-76,0,10],0],
    [[240,0,-215,0,30],0],
    [[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,0,0,24],
    28],[[10],56],[[10],28],
    [[1,0,0,0,0,0,0,0,-9,0,0,0,12,0,0,0,3,0,-24,0,24]
    ,0],[[6,0,-2,0,3],28],
    [[81,0,-148,0,88,0,-18,0,1],0],
    [[3,0,-4,0,4,0,0,0,1],28],
    [[36,0,0,0,-78,0,38],0],[[-4,0,0,0,18,0,-18],42],
    [[3,0,0,0,0,0,-8,0,-4,0,20,0,-7,0,-10,0,2],0],
    [[71,0,-123,0,66,0,-10],0],
    [[7,0,-3,0,0,0,-42,0,81,0,-30,0,-28,0,22,0,-3],0],
    [[],0],[[17,0,-40,0,34,0,-12,0,1],0],
    [[45,0,-65,0,20],0],[[],0],[[],0],[[],0],
    [[13,0,-11,0,1,0,-60,0,141,0,-84,0,-17,0,24,0,-8],0
    ],[[36,0,-48,0,11],0],[[3,0,0,0,-1],28],
    [[100,0,-201,0,141,0,-40,0,3],0],
    [[3,0,0,0,0,0,-18,0,30,0,0,0,-18,0,6],0],
    [[-2],14],[[1,0,0,0,3,0,-12,0,-1,0,8],0],
    [[1,0,-2,0,2,0,0,0,-2],28],
    [[1,0,0,0,0,0,-12,0,15,0,1,0,-12,0,3],0],
    [[13,0,-26,0,20,0,-6,0,1],0],
    [[34,0,-98,0,115,0,-68,0,19,0,-2],0],
    [[3,0,0,0,-3,0,-6,0,6],0],[[-1,0,0,0,-1],14],
    [[11,0,-24,0,17,0,-4],0],[[6,0,-11,0,5],0],
    [[],0],[[7,0,-13,0,8,0,-2],0],
    [[3,0,0,0,-10,0,7],0],[[-1,0,1],24],
    [[1,0,0,0,-6,0,3],0],[[-2],12],[[1],20],
    [[1],10],[[19,0,-47,0,44,0,-18,0,2],0],
    [[3,0,-4,0,1],0],[[],0],
    [[13,0,-11,0,-26,0,38,0,-15],0],
    [[1,0,0,0,-2],28],[[-1,0,0,0,0,0,3],14],
    [[-1,0,3],14],[[1,0,-3,0,1],0],
    [[-1,0,1,0,-2,0,1],14],
    [[24,0,-63,0,64,0,-30,0,6],0],
    [[7,0,-3,0,-19,0,21,0,-5],0],[[],0],
    [[15,0,-36,0,29,0,-9,0,1],0],[[],0],[[],0],
    [[],0],[[-455,0,245],0],
    [[-27,0,0,0,0,0,0,0,21,0,0,0,0,0,-120,0,0,0,189,0,
    -273],28],[[-191,0,312,0,-168,0,29],0],
    [[-24,0,12,0,0,0,120,0,-225,0,81,0,50,0,-32],0],
    [[-110,0,130,0,-30],0],
    [[-1,0,0,0,0,0,0,0,0,0,7,0,-5,0,0,0,-30,0,20,0,
    19,0,0,0,-35,0,15],0],
    [[-10,0,0,0,0,0,67,0,-86,0,0,0,44,0,-9],0],
    [[-24,0,12,0,51,0,-53,0,12],0],
    [[-3,0,-2,0,3,0,0,0,3,0,-3],16],
    [[-1,0,0,0,0,0,1,0,0,0,6,0,-9,0,0,0,6,0,3],0],
    [[-46,0,104,0,-87,0,30,0,-3],0],
    [[-155,0,225,0,-95,0,10],0],
    [[1,0,1,0,-16,0,-5,0,15,0,14,0,-36,0,16,0,-5],12],
    [[-1,0,0,0,0,0,0,0,6,0,-3,0,-8,0,4,0,0,0,19,0,
    -26,0,6],0],[[3,0,6,0,-12],12],
    [[-65,0,164,0,-164,0,76,0,-15,0,1],0],
    [[-24,0,42,0,-25,0,4],0],
    [[-52,0,125,0,-109,0,43,0,-7],0],
    [[1,0,1,0,-8,0,9,0,-3],12],
    [[1,0,-4,0,5,0,-5],14],
    [[-1,0,0,0,-2,0,9,0,-4,0,-7,0,2],0],
    [[-17,0,28,0,-11],0],
    [[-1,0,0,0,0,0,8,0,-14,0,4,0,8,0,-6,0,1],0],
    [[-10,0,16,0,-4],0],
    [[-1,0,0,0,0,0,5,0,-9,0,0,0,10,0,-3],0],
    [[1,0,-1,0,1,0,1],8],[[-2,0,4,0,-2],0],
    [[-29,0,58,0,-36,0,7],0],[[-2,0,0,0,3,0,-1],8],
    [[-4,0,3,0,0,0,21,0,-50,0,31,0,12,0,-16,0,6],0],
    [[-10,0,0,0,29,0,-16],0],
    [[-37,0,78,0,-56,0,15,0,-1],0],
    [[-1,0,0,0,0,0,2,0,1,0,-7,0,4,0,1,0,-1],0],
    [[-4,0,3,0,10,0,-15,0,6],0],[[-1,0,1],0],
    [[-1,0,2,0,-1,0,1],0],[[1],6],
    [[-4,0,9,0,-7,0,2],0],[[1,0,-1],4],
    [[-1,0,0,0,4,0,-4,0,1],0],[[],0],
    [[-7,0,18,0,-17,0,7,0,-1],0],
    [[-1,0,0,0,3,0,-2],0],
    [[-4,0,8,0,-6,0,2,0,-1],0],
    [[-1,0,0,0,1,0,2,0,-3],0],
    [[-10,0,28,0,-31,0,17,0,-4],0],[[1,0,1,0,-2],6]]
    ,
    [[[1400],0],[[1400],120],[[7,0,0,0,0,0,-128,0,189,
    0,0,0,-144,0,0,0,189,0,-128,0,0,0,0,0,7],0],
    [[340,0,-720,0,340],0],
    [[15,0,0,0,-33,0,0,0,65,0,0,0,165,0,-464,0,165,0,0,
    0,65,0,0,0,-33,0,0,0,15],16],[[40],60],
    [[74,0,-344,0,564,0,-344,0,74],0],
    [[240,0,-460,0,240],0],
    [[45,0,-64,0,24,0,0,0,10,0,0,0,24,0,-64,0,45],56],
    [[65],80],[[65],40],
    [[9,0,-16,0,6,0,0,0,16,0,0,0,6,0,-16,0,9],16],
    [[24,0,-34,0,24],40],
    [[32,0,-156,0,256,0,-156,0,32],0],
    [[8,0,-24,0,40,0,-24,0,8],40],
    [[7,0,0,0,-63,0,104,0,-63,0,0,0,7],0],
    [[3,0,0,0,-27,0,40,0,-27,0,0,0,3],60],
    [[-1,0,2,0,-4,0,-6,0,10,0,-6,0,-4,0,2,0,-1],8],
    [[25,0,-120,0,190,0,-120,0,25],0],
    [[-5,0,27,0,-23,0,-19,0,40,0,-19,0,-23,0,27,0,-5],6
    ],[[4],30],
    [[1,0,-10,0,41,0,-64,0,41,0,-10,0,1],0],
    [[10,0,-50,0,80,0,-50,0,10],0],[[],0],[[],0],
    [[],0],
    [[1,0,-2,0,2,0,-8,0,67,0,-103,0,18,0,54,0,18,0,
    -103,0,67,0,-8,0,2,0,-2,0,1],0],
    [[7,0,-32,0,54,0,-32,0,7],0],
    [[4,0,-8,0,9,0,-8,0,4],40],
    [[48,0,-236,0,372,0,-236,0,48],0],
    [[5,0,-4,0,-9,0,12,0,-9,0,-4,0,5],8],[[1],20],
    [[1,0,2,0,-8,0,2,0,1],8],
    [[1,0,-4,0,9,0,-14,0,9,0,-4,0,1],40],
    [[1,0,1,0,-4,0,8,0,-4,0,1,0,1],8],
    [[1,0,-4,0,21,0,-38,0,21,0,-4,0,1],0],
    [[5,0,-46,0,152,0,-226,0,152,0,-46,0,5],0],
    [[5,0,-14,0,5],8],[[-2],22],
    [[-4,0,18,0,-28,0,18,0,-4],2],
    [[-1,0,6,0,-10,0,6,0,-1],2],[[],0],
    [[-1,0,8,0,-14,0,8,0,-1],2],
    [[-1,0,4,0,-6,0,4,0,-1],4],
    [[1,0,0,0,-2,0,0,0,1],30],[[2,0,-2,0,2],6],
    [[2],16],[[-1],28],[[-1],14],
    [[1,0,-13,0,49,0,-74,0,49,0,-13,0,1],0],
    [[2,0,-4,0,2],4],[[],0],
    [[1,0,-2,0,-7,0,39,0,-58,0,39,0,-7,0,-2,0,1],0],
    [[1,0,2,0,1],44],[[1],26],[[1],22],
    [[1,0,-4,0,1],4],[[-2],24],
    [[2,0,-22,0,79,0,-118,0,79,0,-22,0,2],0],
    [[-4,0,17,0,-26,0,17,0,-4],4],[[1],10],
    [[-9,0,34,0,-50,0,34,0,-9],2],[[],0],[[],0],
    [[],0],[[-700,0,700],0],
    [[280,0,0,0,0,0,-420,0,0,0,0,0,420,0,0,0,0,0,-280],
    54],[[-160,0,540,0,-540,0,160],0],
    [[-3,0,4,0,0,0,48,0,-170,0,99,0,72,0,-72,0,-99,0,
    170,0,-48,0,0,0,-4,0,3],0],
    [[-60,0,180,0,-180,0,60],0],
    [[4,0,0,0,-20,0,0,0,0,0,96,0,-96,0,0,0,0,0,20,0,
    0,0,-4],20],
    [[18,0,-34,0,6,0,42,0,-42,0,-6,0,34,0,-18],6],
    [[-3,0,4,0,30,0,-85,0,85,0,-30,0,-4,0,3],0],
    [[4,0,0,0,0,0,-4],30],[[1,0,-3,0,3,0,-1],18],
    [[-10,0,68,0,-162,0,162,0,-68,0,10],0],
    [[-110,0,360,0,-360,0,110],0],
    [[1,0,0,0,-5,0,0,0,20,0,-11,0,15,0,-15,0,11,0,-20,
    0,0,0,5,0,0,0,-1],18],
    [[17,0,-14,0,0,0,-8,0,8,0,0,0,14,0,-17],18],
    [[10,0,3,0,-3,0,-10],18],
    [[-21,0,134,0,-315,0,315,0,-134,0,21],0],
    [[-3,0,16,0,-47,0,47,0,-16,0,3],0],
    [[-12,0,92,0,-212,0,212,0,-92,0,12],0],
    [[4,0,-5,0,-1,0,1,0,5,0,-4],18],
    [[1,0,-2,0,-1,0,-1,0,1,0,1,0,2,0,-1],18],
    [[-1,0,4,0,-4,0,1],10],
    [[-1,0,9,0,-26,0,26,0,-9,0,1],0],
    [[3,0,-5,0,5,0,-3],12],[[4,0,-12,0,12,0,-4],2],
    [[1,0,-1,0,-2,0,2,0,1,0,-1],10],[[],0],
    [[-1,0,3,0,-3,0,1],4],
    [[-3,0,29,0,-68,0,68,0,-29,0,3],0],[[],0],
    [[-8,0,20,0,-5,0,-19,0,19,0,5,0,-20,0,8],8],
    [[9,0,-25,0,25,0,-9],4],
    [[-6,0,45,0,-111,0,111,0,-45,0,6],0],
    [[2,0,1,0,-3,0,3,0,-1,0,-2],12],
    [[1,0,-7,0,15,0,-15,0,7,0,-1],4],[[1,0,-1],6],
    [[3,0,-3],6],[[1,0,-1],10],
    [[-3,0,9,0,-9,0,3],4],[[],0],
    [[-1,0,2,0,-2,0,1],6],[[1,0,-1],6],
    [[1,0,-10,0,25,0,-25,0,10,0,-1],2],
    [[-1,0,1,0,-1,0,1],6],[[-2,0,9,0,-9,0,2],4],
    [[3,0,-3],10],[[3,0,-19,0,46,0,-46,0,19,0,-3],2],
    [[],0]],
    [[[840],0],[[840],132],[[-16,0,54,0,0,0,-140,0,0,0,
    180,0,-80,0,0,0,0,0,10],6],
    [[174,0,-408,0,258],0],
    [[5,0,-60,0,75,0,-160,0,165,0,-60,0,60,0,0,0,-21,0,
    0,0,15,0,0,0,5],24],[[-40],66],
    [[36,0,-176,0,300,0,-240,0,88],0],
    [[90,0,-288,0,174],0],
    [[20,0,0,0,0,0,-64,0,0,0,0,0,20],68],[[30],88],
    [[30],44],[[-19,0,0,0,36,0,-16,0,0,0,0,0,2],24],
    [[9,0,-18,0,12],44],
    [[15,0,-60,0,129,0,-120,0,39],0],
    [[3,0,-12,0,18,0,-12,0,6],44],
    [[-18,0,84,0,-60,0,0,0,10],4],
    [[18,0,-36,0,36,0,0,0,-2],70],
    [[-1,0,-2,0,12,0,-8,0,-7,0,6],12],
    [[6,0,-43,0,96,0,-89,0,30],0],
    [[2,0,-2,0,-18,0,54,0,-43,0,-14,0,30,0,-10,0,0,0,0,
    0,1],8],[[],0],
    [[1,0,-4,0,12,0,-22,0,24,0,-16,0,5],0],
    [[-10,0,35,0,-40,0,10],2],[[-5],36],[[],0],
    [[],0],
    [[-8,0,13,0,-18,0,1,0,52,0,-19,0,-71,0,73,0,-16,0,
    0,0,-3,0,4],6],[[-4,0,22,0,-20,0,10],2],
    [[-4,0,1,0,-8,0,1],46],
    [[21,0,-107,0,196,0,-169,0,59],0],
    [[1,0,0,0,-5,0,20,0,-24,0,0,0,8],8],[[2],22],
    [[-11,0,12,0,0,0,-2],12],
    [[-2,0,5,0,-4,0,3,0,-4,0,1],46],
    [[-3,0,13,0,-15,0,3,0,2,0,-1],12],
    [[-2,0,5,0,-10,0,9,0,-7,0,4],2],
    [[2,0,-22,0,67,0,-102,0,97,0,-56,0,17],0],
    [[2,0,-4,0,6,0,0,0,-1],8],[[1,0,-2],22],
    [[3,0,-7,0,8,0,-6,0,1],4],[[-1,0,2,0,-1],6],
    [[],0],[[1,0,-1,0,1,0,-2,0,1],4],
    [[-1,0,-2,0,5,0,-2],6],[[],0],
    [[-1,0,2,0,-1],8],[[],0],[[],0],[[],0],
    [[-3,0,15,0,-27,0,27,0,-18,0,5],2],[[-1],8],
    [[],0],[[-3,0,14,0,-34,0,41,0,-15,0,-3,0,4],4],
    [[4],50],[[-3,0,0,0,0,0,1],28],[[-3,0,1],24],
    [[1],6],[[-1,0,2,0,-1,0,1],24],
    [[1,0,-9,0,29,0,-48,0,48,0,-30,0,9],0],
    [[5,0,-15,0,17,0,-8,0,0,0,1],6],[[],0],
    [[-3,0,9,0,-16,0,19,0,-12,0,4],2],[[1],28],
    [[],0],[[],0],[[-378,0,462],0],
    [[294,0,-378,0,0,0,0,0,0,0,0,0,168],66],
    [[-80,0,282,0,-330,0,148],0],
    [[12,0,-31,0,27,0,60,0,-80,0,-72,0,144,0,-44,0,0,0,
    -3,0,7],6],[[-10,0,80,0,-124,0,50],0],
    [[15,0,-25,0,20,0,-40,0,10,0,-5,0,20,0,0,0,0,0,0,
    0,0,0,0,0,1],26],
    [[-4,0,0,0,45,0,-70,0,0,0,39,0,-15,0,0,0,0,0,1],8
    ],[[9,0,-45,0,72,0,-36,0,-3,0,7],4],
    [[6,0,-2],34],
    [[-3,0,-3,0,0,0,3,0,-3,0,0,0,2],18],
    [[-3,0,24,0,-69,0,87,0,-62,0,19],0],
    [[-45,0,174,0,-234,0,99],0],
    [[5,0,-16,0,-10,0,9,0,10,0,0,0,-5,0,0,0,1],30],
    [[4,0,-15,0,-12,0,32,0,-8,0,0,0,0,0,2],24],
    [[-3,0,0,0,6],22],
    [[-9,0,63,0,-149,0,177,0,-117,0,37],0],
    [[3,0,-13,0,19,0,-14,0,7],2],
    [[-6,0,39,0,-92,0,119,0,-82,0,25],0],
    [[-1,0,6,0,2,0,-6,0,2],22],
    [[2,0,-6,0,0,0,5,0,-2],24],
    [[4,0,-11,0,8,0,0,0,-2],12],
    [[-4,0,11,0,-9,0,1],4],
    [[1,0,-7,0,13,0,-11,0,2,0,2,0,-1],12],
    [[2,0,-3,0,1],6],[[-3,0,0,0,8,0,-5],12],
    [[],0],[[],0],[[6,0,-22,0,34,0,-26,0,7],2],
    [[2,0,-3],16],
    [[-1,0,1,0,1,0,-18,0,36,0,-17,0,-13,0,17,0,-5,0,0,
    0,0,0,1],8],[[-10,0,23,0,-12,0,0,0,1],6],
    [[-3,0,15,0,-40,0,60,0,-43,0,13],0],
    [[2,0,-1,0,4,0,-2,0,-3,0,2],14],
    [[-2,0,5,0,-10,0,9,0,-4,0,0,0,1],6],[[-1],10],
    [[1],8],[[1],12],[[1,0,-1,0,1,0,-1],6],
    [[],0],[[1,0,-1,0,1,0,-1],8],[[],0],
    [[1,0,-3,0,6,0,-7,0,7,0,-5,0,2],2],[[1],12],
    [[-1,0,1,0,0,0,0,0,-1,0,1],4],[[-1,0,1],12],
    [[1,0,-7,0,13,0,-16,0,14,0,-9,0,3],2],
    [[-2,0,1],14]],
    [[[840],0],[[840],108],[[10,0,0,0,0,0,-80,0,180,0,
    0,0,-140,0,0,0,54,0,-16],0],
    [[258,0,-408,0,174],0],
    [[5,0,0,0,15,0,0,0,-21,0,0,0,60,0,-60,0,165,0,-160,
    0,75,0,-60,0,5],12],[[-40],54],
    [[88,0,-240,0,300,0,-176,0,36],0],
    [[174,0,-288,0,90],0],
    [[20,0,0,0,0,0,-64,0,0,0,0,0,20],48],[[30],72],
    [[30],36],[[2,0,0,0,0,0,-16,0,36,0,0,0,-19],12],
    [[12,0,-18,0,9],36],
    [[39,0,-120,0,129,0,-60,0,15],0],
    [[6,0,-12,0,18,0,-12,0,3],36],
    [[10,0,0,0,-60,0,84,0,-18],0],
    [[-2,0,0,0,36,0,-36,0,18],54],
    [[6,0,-7,0,-8,0,12,0,-2,0,-1],10],
    [[30,0,-89,0,96,0,-43,0,6],0],
    [[1,0,0,0,0,0,-10,0,30,0,-14,0,-43,0,54,0,-18,0,-2,
    0,2],0],[[],0],
    [[5,0,-16,0,24,0,-22,0,12,0,-4,0,1],0],
    [[10,0,-40,0,35,0,-10],0],[[-5],28],[[],0],
    [[],0],
    [[4,0,-3,0,0,0,-16,0,73,0,-71,0,-19,0,52,0,1,0,-18,
    0,13,0,-8],0],[[10,0,-20,0,22,0,-4],0],
    [[1,0,-8,0,1,0,-4],36],
    [[59,0,-169,0,196,0,-107,0,21],0],
    [[8,0,0,0,-24,0,20,0,-5,0,0,0,1],8],[[2],18],
    [[-2,0,0,0,12,0,-11],6],
    [[1,0,-4,0,3,0,-4,0,5,0,-2],36],
    [[-1,0,2,0,3,0,-15,0,13,0,-3],6],
    [[4,0,-7,0,9,0,-10,0,5,0,-2],0],
    [[17,0,-56,0,97,0,-102,0,67,0,-22,0,2],0],
    [[-1,0,0,0,6,0,-4,0,2],4],[[-2,0,1],20],
    [[1,0,-6,0,8,0,-7,0,3],0],[[-1,0,2,0,-1],2],
    [[],0],[[1,0,-2,0,1,0,-1,0,1],0],
    [[-2,0,5,0,-2,0,-1],4],[[],0],
    [[-1,0,2,0,-1],4],[[],0],[[],0],[[],0],
    [[5,0,-18,0,27,0,-27,0,15,0,-3],0],[[-1],4],
    [[],0],[[4,0,-3,0,-15,0,41,0,-34,0,14,0,-3],0],
    [[4],42],[[1,0,0,0,0,0,-3],18],[[1,0,-3],18],
    [[1],6],[[1,0,-1,0,2,0,-1],18],
    [[9,0,-30,0,48,0,-48,0,29,0,-9,0,1],0],
    [[1,0,0,0,-8,0,17,0,-15,0,5],0],[[],0],
    [[4,0,-12,0,19,0,-16,0,9,0,-3],0],[[1],24],
    [[],0],[[],0],[[-462,0,378],0],
    [[-168,0,0,0,0,0,0,0,0,0,378,0,-294],48],
    [[-148,0,330,0,-282,0,80],0],
    [[-7,0,3,0,0,0,44,0,-144,0,72,0,80,0,-60,0,-27,0,
    31,0,-12],0],[[-50,0,124,0,-80,0,10],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,-20,0,5,0,-10,0,40,0,
    -20,0,25,0,-15],12],
    [[-1,0,0,0,0,0,15,0,-39,0,0,0,70,0,-45,0,0,0,4],0
    ],[[-7,0,3,0,36,0,-72,0,45,0,-9],0],
    [[2,0,-6],30],[[-2,0,0,0,3,0,-3,0,0,0,3,0,3],12
    ],[[-19,0,62,0,-87,0,69,0,-24,0,3],0],
    [[-99,0,234,0,-174,0,45],0],
    [[-1,0,0,0,5,0,0,0,-10,0,-9,0,10,0,16,0,-5],16],
    [[-2,0,0,0,0,0,8,0,-32,0,12,0,15,0,-4],12],
    [[-6,0,0,0,3],16],
    [[-37,0,117,0,-177,0,149,0,-63,0,9],0],
    [[-7,0,14,0,-19,0,13,0,-3],0],
    [[-25,0,82,0,-119,0,92,0,-39,0,6],0],
    [[-2,0,6,0,-2,0,-6,0,1],16],
    [[2,0,-5,0,0,0,6,0,-2],18],
    [[2,0,0,0,-8,0,11,0,-4],6],
    [[-1,0,9,0,-11,0,4],0],
    [[1,0,-2,0,-2,0,11,0,-13,0,7,0,-1],6],
    [[-1,0,3,0,-2],0],[[5,0,-8,0,0,0,3],12],
    [[],0],[[],0],[[-7,0,26,0,-34,0,22,0,-6],0],
    [[3,0,-2],12],
    [[-1,0,0,0,0,0,5,0,-17,0,13,0,17,0,-36,0,18,0,-1,
    0,-1,0,1],0],[[-1,0,0,0,12,0,-23,0,10],0],
    [[-13,0,43,0,-60,0,40,0,-15,0,3],0],
    [[-2,0,3,0,2,0,-4,0,1,0,-2],10],
    [[-1,0,0,0,4,0,-9,0,10,0,-5,0,2],0],[[1],4],
    [[-1],6],[[-1],10],[[1,0,-1,0,1,0,-1],2],
    [[],0],[[1,0,-1,0,1,0,-1],4],[[],0],
    [[-2,0,5,0,-7,0,7,0,-6,0,3,0,-1],0],[[-1],6],
    [[-1,0,1,0,0,0,0,0,-1,0,1],0],[[-1,0,1],8],
    [[-3,0,9,0,-14,0,16,0,-13,0,7,0,-1],0],
    [[-1,0,2],10]],
    [[[1680],0],[[1680],120],[[10,0,0,0,0,0,-192,0,198,
    0,0,0,-16,0,0,0,198,0,-192,0,0,0,0,0,10],0],
    [[400,0,-880,0,400],0],
    [[15,0,0,0,12,0,0,0,-60,0,0,0,225,0,-464,0,225,0,0,
    0,-60,0,0,0,12,0,0,0,15],16],[[-16],60],
    [[76,0,-416,0,696,0,-416,0,76],0],
    [[300,0,-540,0,300],0],
    [[30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30],56],
    [[6],80],[[6],40],
    [[21,0,-24,0,0,0,0,0,12,0,0,0,0,0,-24,0,21],16],
    [[3,0,0,0,3],40],
    [[34,0,-192,0,322,0,-192,0,34],0],
    [[1,0,0,0,4,0,0,0,1],40],
    [[10,0,0,0,-66,0,144,0,-66,0,0,0,10],0],
    [[-2,0,0,0,18,0,0,0,18,0,0,0,-2],60],
    [[-1,0,8,0,0,0,-4,0,-6,0,-4,0,0,0,8,0,-1],8],
    [[30,0,-150,0,240,0,-150,0,30],0],
    [[-8,0,37,0,-34,0,1,0,8,0,1,0,-34,0,37,0,-8],6],
    [[],0],[[-10,0,54,0,-88,0,54,0,-10],2],
    [[14,0,-66,0,104,0,-66,0,14],0],
    [[-1,0,0,0,4,0,0,0,-6,0,0,0,4,0,0,0,-1],24],
    [[-5],48],[[-5],24],
    [[-3,0,4,0,-12,0,78,0,-123,0,46,0,0,0,46,0,-123,0,
    78,0,-12,0,4,0,-3],2],
    [[10,0,-48,0,56,0,-48,0,10],0],
    [[1,0,0,0,-4,0,0,0,1],40],
    [[52,0,-284,0,468,0,-284,0,52],0],
    [[7,0,-8,0,-1,0,8,0,-1,0,-8,0,7],8],[[2],20],
    [[5,0,0,0,-12,0,0,0,5],8],[[-1,0,0,0,-1],44],
    [[3,0,0,0,-4,0,0,0,-4,0,0,0,3],8],
    [[-6,0,29,0,-48,0,29,0,-6],2],
    [[3,0,-48,0,190,0,-292,0,190,0,-48,0,3],0],
    [[9,0,-20,0,9],8],[[1,0,0,0,1],20],
    [[-5,0,25,0,-42,0,25,0,-5],2],
    [[-1,0,9,0,-16,0,9,0,-1],2],[[],0],
    [[-2,0,10,0,-16,0,10,0,-2],2],
    [[-1,0,6,0,-10,0,6,0,-1],4],[[],0],
    [[3,0,-6,0,3],6],[[],0],[[],0],[[],0],
    [[1,0,-15,0,65,0,-102,0,65,0,-15,0,1],0],
    [[2,0,-4,0,2],4],[[-1],12],
    [[-3,0,-2,0,45,0,-84,0,45,0,-2,0,-3],2],
    [[-2,0,0,0,-2],44],
    [[1,0,0,0,0,0,0,0,0,0,0,0,1],20],
    [[1,0,0,0,1],20],[[1,0,0,0,1],4],
    [[1,0,0,0,0,0,0,0,1],20],
    [[1,0,-23,0,101,0,-158,0,101,0,-23,0,1],0],
    [[-3,0,23,0,-40,0,23,0,-3],4],[[],0],
    [[-9,0,45,0,-72,0,45,0,-9],2],[[-1,0,2,0,-1],24],
    [[1],16],[[1],8],[[-840,0,840],0],
    [[315,0,-189,0,0,0,336,0,0,0,0,0,-336,0,0,0,189,0,
    -315],54],[[-180,0,660,0,-660,0,180],0],
    [[-3,0,7,0,0,0,72,0,-201,0,117,0,8,0,-8,0,-117,0,
    201,0,-72,0,0,0,-7,0,3],0],
    [[-80,0,220,0,-220,0,80],0],
    [[1,0,20,0,-10,0,-20,0,101,0,-101,0,20,0,10,0,-20,0,
    -1],22],
    [[28,0,-48,0,6,0,6,0,-6,0,-6,0,48,0,-28],6],
    [[-3,0,7,0,27,0,-111,0,111,0,-27,0,-7,0,3],0],
    [[3,0,-5,0,0,0,0,0,5,0,-3],28],
    [[4,0,0,0,0,0,-4],18],
    [[-10,0,82,0,-208,0,208,0,-82,0,10],0],
    [[-130,0,440,0,-440,0,130],0],
    [[1,0,0,0,0,0,0,0,0,0,-21,0,60,0,-60,0,21,0,0,0,
    0,0,0,0,0,0,-1],18],
    [[-6,0,23,0,-16,0,0,0,-6,0,6,0,0,0,16,0,-23,0,6],
    16],[[9,0,-6,0,6,0,-9],18],
    [[-19,0,156,0,-395,0,395,0,-156,0,19],0],
    [[-3,0,25,0,-58,0,58,0,-25,0,3],0],
    [[-11,0,105,0,-271,0,271,0,-105,0,11],0],
    [[5,0,-7,0,7,0,-7,0,7,0,-5],18],
    [[2,0,-3,0,3,0,-3,0,3,0,-3,0,3,0,-2],18],
    [[-2,0,3,0,6,0,-6,0,-3,0,2],8],
    [[-1,0,13,0,-37,0,37,0,-13,0,1],0],
    [[-1,0,2,0,2,0,-2,0,2,0,-2,0,-2,0,1],8],
    [[7,0,-13,0,13,0,-7],2],
    [[2,0,0,0,-2,0,2,0,0,0,-2],10],
    [[1,0,1,0,-1,0,-1],14],[[-1,0,5,0,-5,0,1],4],
    [[-4,0,36,0,-92,0,92,0,-36,0,4],0],
    [[1,0,-1,0,1,0,-1],12],
    [[-10,0,28,0,-17,0,-3,0,3,0,17,0,-28,0,10],8],
    [[10,0,-36,0,36,0,-10],4],
    [[-5,0,54,0,-145,0,145,0,-54,0,5],0],
    [[-1,0,2,0,0,0,-1,0,1,0,0,0,-2,0,1],10],
    [[-7,0,24,0,-24,0,7],6],[[1,0,-1],6],
    [[1,0,-1],6],[[1,0,-1],10],
    [[-4,0,14,0,-14,0,4],4],[[],0],
    [[-1,0,5,0,-5,0,1],6],[[],0],
    [[-12,0,36,0,-36,0,12],4],[[2,0,-2],8],
    [[-3,0,11,0,-11,0,3],4],[[-1,0,5,0,-5,0,1],8],
    [[2,0,-24,0,64,0,-64,0,24,0,-2],2],[[2,0,-2],12]
    ],
    [[[972],0],[[972],140],[[54,0,0,0,-90,0,0,0,270,0,
    -144,0,0,0,0,0,18],8],[[171,0,-468,0,333],0],
    [[5,0,0,0,30,0,-128,0,135,0,-60,0,35,0,0,0,3,0,-40,
    0,45,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,1],24],
    [[36],70],[[30,0,-168,0,342,0,-312,0,120],0],
    [[81,0,-324,0,243],0],[[],0],[[],0],[[],0],
    [[-9,0,0,0,36,0,-24,0,-9,0,0,0,6],24],[[],0],
    [[9,0,-54,0,144,0,-162,0,63],0],[[],0],
    [[-18,0,90,0,-90,0,0,0,18],4],
    [[-18,0,30,0,-18,0,0,0,6],74],
    [[-1,0,2,0,9,0,-10,0,-10,0,18,0,-1,0,0,0,0,0,0,0,
    1],12],[[3,0,-36,0,108,0,-126,0,51],0],
    [[1,0,-4,0,-11,0,39,0,-34,0,-31,0,60,0,-21,0,0,0,
    -1,0,2],8],[[],0],
    [[-2,0,9,0,-24,0,36,0,-28,0,9],2],
    [[-6,0,39,0,-60,0,24],2],
    [[4,0,0,0,-6,0,0,0,0,0,0,0,-1],32],[[-3],56],
    [[-3],28],
    [[9,0,-18,0,3,0,30,0,-6,0,-102,0,120,0,-36,0,0,0,
    -6,0,6],8],[[18,0,-36,0,18],4],[[],0],
    [[15,0,-99,0,222,0,-225,0,87],0],
    [[1,0,-2,0,-4,0,14,0,-22,0,-2,0,18,0,-4,0,0,0,0,0,
    1],8],[[],0],[[-9,0,12,0,3,0,-6],12],
    [[],0],[[-3,0,9,0,-15,0,3,0,9,0,-3],12],
    [[3,0,-9,0,15,0,-15,0,6],4],
    [[1,0,-14,0,59,0,-116,0,131,0,-86,0,25],0],
    [[2,0,-8,0,11,0,-4,0,-2,0,0,0,1],8],[[],0],
    [[2,0,-8,0,15,0,-13,0,4],4],
    [[-1,0,4,0,-5,0,1],6],[[-1],20],
    [[-1,0,1,0,1,0,-5,0,2],4],
    [[-1,0,-1,0,8,0,-5,0,0,0,1],6],[[1,0,1],38],
    [[3,0,-3],10],[[],0],[[],0],[[],0],
    [[-1,0,12,0,-31,0,43,0,-32,0,10],2],
    [[2,0,-2,0,0,0,1],6],[[1],14],
    [[-3,0,12,0,-39,0,54,0,-24,0,-6,0,6],4],[[],0],
    [[],0],[[],0],[[3,0,-3],6],[[],0],
    [[-5,0,24,0,-54,0,69,0,-49,0,15],2],
    [[4,0,-17,0,27,0,-15,0,-1,0,2],6],[[],0],
    [[-1,0,7,0,-18,0,29,0,-24,0,7],2],[[1,0,-1],30],
    [[],0],[[],0],[[-405,0,567],0],
    [[84,0,0,0,-216,0,280,0,0,0,-189,0,168,0,0,0,0,0,0,
    0,0,0,0,0,35],66],
    [[-72,0,297,0,-405,0,198],0],
    [[-27,0,27,0,36,0,-54,0,-108,0,222,0,-84,0,0,0,-6,0,
    12],8],[[-6,0,75,0,-159,0,84],0],
    [[14,0,-30,0,10,0,-5,0,5,0,0,0,0,0,-10,0,5,0,0,0,
    5],30],
    [[-3,0,3,0,30,0,-57,0,-3,0,78,0,-33,0,0,0,0,0,3],
    8],[[9,0,-45,0,90,0,-54,0,-6,0,12],4],
    [[4,0,0,0,3,0,0,0,0,0,-3,0,2],36],
    [[3,0,0,0,4,0,-6,0,0,0,5],20],
    [[-1,0,18,0,-67,0,113,0,-93,0,32],0],
    [[-36,0,180,0,-288,0,144],0],
    [[19,0,-40,0,21,0,-5,0,5,0,0,0,-5,0,-1,0,6],30],
    [[3,0,-6,0,-12,0,32,0,-13,0,-6,0,-2,0,4],24],
    [[3,0,-8,0,6,0,0,0,-1],22],
    [[-6,0,51,0,-153,0,219,0,-165,0,54],0],
    [[-9,0,24,0,-27,0,12],4],
    [[-3,0,30,0,-93,0,147,0,-120,0,39],0],
    [[1,0,-2,0,7,0,-10,0,2,0,2],22],
    [[-2,0,-1,0,7,0,-3,0,-1],26],
    [[3,0,-10,0,7,0,4,0,-4],12],
    [[-3,0,15,0,-18,0,6],4],
    [[1,0,-5,0,11,0,-11,0,-1,0,7,0,-2],12],
    [[3,0,0,0,-6,0,3],4],
    [[1,0,-1,0,0,0,5,0,-7,0,0,0,3,0,-1],10],
    [[-1,0,0,0,1],20],[[1,0,-1],10],
    [[3,0,-21,0,45,0,-45,0,15],2],
    [[-1,0,0,0,-3,0,1],14],
    [[2,0,0,0,-12,0,26,0,-12,0,-27,0,33,0,-10,0,0,0,-1,
    0,1],10],[[-9,0,30,0,-24,0,0,0,3],6],
    [[-1,0,10,0,-39,0,75,0,-68,0,23],0],
    [[-2,0,4,0,-3,0,-4,0,5],16],
    [[-1,0,5,0,-13,0,16,0,-7,0,-1,0,1],6],
    [[1,0,-1],8],[[-1,0,3,0,-2],6],
    [[1,0,0,0,-1],12],[[1,0,-2,0,4,0,-3,0,1],6],
    [[1],10],[[-1,0,3,0,-2],10],[[1,0,-1],8],
    [[-2,0,5,0,-10,0,13,0,-10,0,3],4],
    [[-1,0,0,0,1,0,-1],8],[[1,0,1,0,-3,0,1],8],
    [[1,0,-2,0,3,0,-1,0,-1],10],
    [[-4,0,13,0,-22,0,25,0,-17,0,5],4],[[-2,0,2],14]
    ],
    [[[972],0],[[972],100],[[18,0,0,0,0,0,-144,0,270,0,
    0,0,-90,0,0,0,54],0],[[333,0,-468,0,171],0],
    [[1,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,45,0,-40,0,3,
    0,0,0,35,0,-60,0,135,0,-128,0,30,0,0,0,5],0],
    [[36],50],[[120,0,-312,0,342,0,-168,0,30],0],
    [[243,0,-324,0,81],0],[[],0],[[],0],[[],0],
    [[6,0,0,0,-9,0,-24,0,36,0,0,0,-9],12],[[],0],
    [[63,0,-162,0,144,0,-54,0,9],0],[[],0],
    [[18,0,0,0,-90,0,90,0,-18],0],
    [[6,0,0,0,-18,0,30,0,-18],50],
    [[1,0,0,0,0,0,0,0,-1,0,18,0,-10,0,-10,0,9,0,2,0,
    -1],0],[[51,0,-126,0,108,0,-36,0,3],0],
    [[2,0,-1,0,0,0,-21,0,60,0,-31,0,-34,0,39,0,-11,0,
    -4,0,1],0],[[],0],
    [[9,0,-28,0,36,0,-24,0,9,0,-2],0],
    [[24,0,-60,0,39,0,-6],0],
    [[-1,0,0,0,0,0,0,0,-6,0,0,0,4],20],[[-3],40],
    [[-3],20],
    [[6,0,-6,0,0,0,-36,0,120,0,-102,0,-6,0,30,0,3,0,
    -18,0,9],0],[[18,0,-36,0,18],0],[[],0],
    [[87,0,-225,0,222,0,-99,0,15],0],
    [[1,0,0,0,0,0,-4,0,18,0,-2,0,-22,0,14,0,-4,0,-2,0,
    1],0],[[],0],[[-6,0,3,0,12,0,-9],6],
    [[],0],[[-3,0,9,0,3,0,-15,0,9,0,-3],6],
    [[6,0,-15,0,15,0,-9,0,3],0],
    [[25,0,-86,0,131,0,-116,0,59,0,-14,0,1],0],
    [[1,0,0,0,-2,0,-4,0,11,0,-8,0,2],0],[[],0],
    [[4,0,-13,0,15,0,-8,0,2],0],
    [[1,0,-5,0,4,0,-1],0],[[-1],16],
    [[2,0,-5,0,1,0,1,0,-1],0],
    [[1,0,0,0,-5,0,8,0,-1,0,-1],0],[[1,0,1],28],
    [[-3,0,3],4],[[],0],[[],0],[[],0],
    [[10,0,-32,0,43,0,-31,0,12,0,-1],0],
    [[1,0,0,0,-2,0,2],0],[[1],10],
    [[6,0,-6,0,-24,0,54,0,-39,0,12,0,-3],0],[[],0],
    [[],0],[[],0],[[-3,0,3],4],[[],0],
    [[15,0,-49,0,69,0,-54,0,24,0,-5],0],
    [[2,0,-1,0,-15,0,27,0,-17,0,4],0],[[],0],
    [[7,0,-24,0,29,0,-18,0,7,0,-1],0],[[-1,0,1],20],
    [[],0],[[],0],[[-567,0,405],0],
    [[-35,0,0,0,0,0,0,0,0,0,0,0,-168,0,189,0,0,0,-280,
    0,216,0,0,0,-84],36],
    [[-198,0,405,0,-297,0,72],0],
    [[-12,0,6,0,0,0,84,0,-222,0,108,0,54,0,-36,0,-27,0,
    27],0],[[-84,0,159,0,-75,0,6],0],
    [[-5,0,0,0,-5,0,10,0,0,0,0,0,-5,0,5,0,-10,0,30,0,
    -14],12],
    [[-3,0,0,0,0,0,33,0,-78,0,3,0,57,0,-30,0,-3,0,3],
    0],[[-12,0,6,0,54,0,-90,0,45,0,-9],0],
    [[-2,0,3,0,0,0,0,0,-3,0,0,0,-4],18],
    [[-5,0,0,0,6,0,-4,0,0,0,-3],12],
    [[-32,0,93,0,-113,0,67,0,-18,0,1],0],
    [[-144,0,288,0,-180,0,36],0],
    [[-6,0,1,0,5,0,0,0,-5,0,5,0,-21,0,40,0,-19],16],
    [[-4,0,2,0,6,0,13,0,-32,0,12,0,6,0,-3],12],
    [[1,0,0,0,-6,0,8,0,-3],12],
    [[-54,0,165,0,-219,0,153,0,-51,0,6],0],
    [[-12,0,27,0,-24,0,9],0],
    [[-39,0,120,0,-147,0,93,0,-30,0,3],0],
    [[-2,0,-2,0,10,0,-7,0,2,0,-1],14],
    [[1,0,3,0,-7,0,1,0,2],16],
    [[4,0,-4,0,-7,0,10,0,-3],6],
    [[-6,0,18,0,-15,0,3],0],
    [[2,0,-7,0,1,0,11,0,-11,0,5,0,-1],6],
    [[-3,0,6,0,0,0,-3],0],
    [[1,0,-3,0,0,0,7,0,-5,0,0,0,1,0,-1],6],
    [[-1,0,0,0,1],10],[[1,0,-1],2],
    [[-15,0,45,0,-45,0,21,0,-3],0],
    [[-1,0,3,0,0,0,1],10],
    [[-1,0,1,0,0,0,10,0,-33,0,27,0,12,0,-26,0,12,0,0,
    0,-2],0],[[-3,0,0,0,24,0,-30,0,9],0],
    [[-23,0,68,0,-75,0,39,0,-10,0,1],0],
    [[-5,0,4,0,3,0,-4,0,2],10],
    [[-1,0,1,0,7,0,-16,0,13,0,-5,0,1],0],
    [[1,0,-1],4],[[2,0,-3,0,1],4],
    [[1,0,0,0,-1],6],[[-1,0,3,0,-4,0,2,0,-1],0],
    [[-1],8],[[2,0,-3,0,1],4],[[1,0,-1],4],
    [[-3,0,10,0,-13,0,10,0,-5,0,2],0],
    [[1,0,-1,0,0,0,1],4],[[-1,0,3,0,-1,0,-1],0],
    [[1,0,1,0,-3,0,2,0,-1],4],
    [[-5,0,17,0,-25,0,22,0,-13,0,4],0],[[-2,0,2],10]
    ],
    [[[1050],0],[[1050],144],[[45,0,0,0,-104,0,0,0,306,
    0,-208,0,0,0,0,0,19],8],
    [[170,0,-500,0,380],0],
    [[30,0,-48,0,120,0,-120,0,90,0,0,0,-6,0,-80,0,75,0,
    0,0,0,0,-12,0,0,0,0,0,0,0,0,0,1],28],
    [[-30],72],[[31,0,-160,0,354,0,-368,0,137],0],
    [[75,0,-345,0,285],0],
    [[-60,0,0,0,60,0,0,0,15],72],[[15],96],
    [[15],48],[[-6,0,0,0,24,0,-24,0,-3,0,0,0,6],24],
    [[3,0,-12,0,6],48],
    [[4,0,-52,0,152,0,-182,0,84],0],
    [[1,0,-4,0,14,0,-8,0,3],48],
    [[-15,0,88,0,-102,0,0,0,19],4],
    [[9,0,-32,0,18,0,0,0,-5],76],
    [[6,0,-12,0,-12,0,24,0,-5,0,-4,0,0,0,0,0,1],16],
    [[2,0,-31,0,113,0,-148,0,66],0],
    [[1,0,-2,0,-11,0,43,0,-31,0,-41,0,76,0,-34,0,0,0,
    -1,0,2],8],[[-2],36],
    [[6,0,-24,0,43,0,-40,0,13],4],
    [[-5,0,40,0,-70,0,35],2],[[],0],[[],0],
    [[],0],
    [[-18,0,-3,0,34,0,3,0,-111,0,145,0,-68,0,0,0,-6,0,7
    ],10],[[16,0,-52,0,19],4],
    [[10,0,-4,0,1],52],
    [[13,0,-92,0,233,0,-261,0,106],0],
    [[-2,0,-2,0,16,0,-20,0,-2,0,22,0,-14,0,0,0,0,0,1],
    10],[[3],24],[[-6,0,8,0,5,0,-6],12],
    [[3,0,-8,0,7,0,-2,0,1],52],
    [[-2,0,8,0,-12,0,0,0,13,0,-3],12],
    [[-8,0,22,0,-23,0,7],6],
    [[1,0,-12,0,49,0,-114,0,159,0,-110,0,29],0],
    [[-6,0,15,0,-8,0,0,0,0,0,1],10],
    [[1,0,-2,0,1],24],[[1,0,-7,0,19,0,-20,0,7],4],
    [[-1,0,5,0,-8,0,4],6],[[],0],
    [[-1,0,2,0,5,0,-8,0,2],4],
    [[-2,0,6,0,-5,0,0,0,1],8],[[1,0,0,0,-1],40],
    [[3,0,-3],10],[[],0],[[],0],[[],0],
    [[-1,0,8,0,-29,0,54,0,-45,0,13],2],
    [[2,0,-1,0,-2,0,1],6],[[],0],
    [[14,0,-42,0,53,0,-27,0,-6,0,7],6],[[-4,0,3],54],
    [[-2,0,0,0,0,0,1],30],[[-2,0,1],26],
    [[2,0,-3],6],[[-1,0,0,0,-1,0,1],26],
    [[-3,0,18,0,-53,0,84,0,-66,0,19],2],
    [[3,0,-17,0,29,0,-17,0,-1,0,2],6],[[1],12],
    [[4,0,-18,0,36,0,-33,0,11],4],[[],0],[[],0],
    [[],0],[[-420,0,630],0],
    [[-216,0,280,0,0,0,0,0,315,0,-189,0,0,0,-15,0,0,0,
    0,0,35],70],[[-71,0,297,0,-453,0,229],0],
    [[-18,0,27,0,46,0,-58,0,-126,0,256,0,-132,0,0,0,-6,
    0,13],8],[[-5,0,70,0,-180,0,105],0],
    [[-5,0,-9,0,25,0,-30,0,20,0,0,0,-5,0,-20,0,20,0,0,
    0,0,0,-6],30],
    [[-2,0,3,0,28,0,-60,0,-3,0,97,0,-52,0,0,0,0,0,3],
    8],[[6,0,-47,0,92,0,-60,0,-6,0,13],4],
    [[3,0,-7,0,3,0,-3,0,2],40],
    [[1,0,-9,0,0,0,6,0,-3,0,0,0,-1],24],
    [[-1,0,14,0,-62,0,125,0,-118,0,40],0],
    [[-30,0,185,0,-315,0,175],0],
    [[9,0,-15,0,26,0,-21,0,20,0,-4,0,0,0,-6,0,6],30],
    [[3,0,-3,0,-12,0,20,0,-10,0,3,0,-2,0,4],24],
    [[-8,0,9,0,3,0,-1],24],
    [[-6,0,46,0,-144,0,243,0,-203,0,63],0],
    [[-5,0,30,0,-39,0,13],4],
    [[-2,0,24,0,-89,0,163,0,-146,0,50],0],
    [[-2,0,6,0,-8,0,1,0,3],24],
    [[-1,0,3,0,-2,0,-1],28],
    [[3,0,-7,0,2,0,5,0,-4],12],
    [[-3,0,16,0,-23,0,12],4],
    [[1,0,-5,0,10,0,-6,0,-5,0,9,0,-2],12],
    [[2,0,1,0,-10,0,3],4],
    [[-1,0,-3,0,5,0,-4,0,-1,0,5,0,-5],12],
    [[-1,0,0,0,1],20],[[2,0,-3,0,1],10],
    [[2,0,-18,0,51,0,-57,0,22],2],[[-1,0,1],14],
    [[1,0,2,0,-17,0,25,0,-3,0,-34,0,43,0,-18,0,0,0,-1,
    0,1],10],[[-7,0,31,0,-28,0,0,0,3],6],
    [[6,0,-38,0,82,0,-84,0,33],2],
    [[3,0,-3,0,-3,0,6,0,-2,0,-2],18],
    [[6,0,-13,0,17,0,-8,0,-1,0,1],8],
    [[1,0,0,0,-1],8],[[-1,0,3,0,-1],6],
    [[2,0,-1],14],[[-2,0,7,0,-7,0,2],8],
    [[1,0,-1],10],[[-1,0,3,0,-2],10],[[1,0,-1],8],
    [[3,0,-11,0,20,0,-16,0,4],6],[[1,0,0,0,-1],10],
    [[-2,0,0,0,5,0,-5,0,1],6],[[-3,0,4,0,-2],12],
    [[-2,0,8,0,-24,0,37,0,-25,0,6],4],[[-1,0,1],14]]
    ,
    [[[1050],0],[[1050],96],[[19,0,0,0,0,0,-208,0,306,
    0,0,0,-104,0,0,0,45],0],
    [[380,0,-500,0,170],0],
    [[1,0,0,0,0,0,0,0,0,0,-12,0,0,0,0,0,75,0,-80,0,
    -6,0,0,0,90,0,-120,0,120,0,-48,0,30],0],
    [[-30],48],[[137,0,-368,0,354,0,-160,0,31],0],
    [[285,0,-345,0,75],0],
    [[15,0,0,0,60,0,0,0,-60],48],[[15],64],
    [[15],32],[[6,0,0,0,-3,0,-24,0,24,0,0,0,-6],12],
    [[6,0,-12,0,3],32],
    [[84,0,-182,0,152,0,-52,0,4],0],
    [[3,0,-8,0,14,0,-4,0,1],32],
    [[19,0,0,0,-102,0,88,0,-15],0],
    [[-5,0,0,0,18,0,-32,0,9],48],
    [[1,0,0,0,0,0,-4,0,-5,0,24,0,-12,0,-12,0,6],0],
    [[66,0,-148,0,113,0,-31,0,2],0],
    [[2,0,-1,0,0,0,-34,0,76,0,-41,0,-31,0,43,0,-11,0,
    -2,0,1],0],[[-2],24],
    [[13,0,-40,0,43,0,-24,0,6],0],
    [[35,0,-70,0,40,0,-5],0],[[],0],[[],0],
    [[],0],
    [[7,0,-6,0,0,0,-68,0,145,0,-111,0,3,0,34,0,-3,0,-18
    ],0],[[19,0,-52,0,16],0],
    [[1,0,-4,0,10],32],
    [[106,0,-261,0,233,0,-92,0,13],0],
    [[1,0,0,0,0,0,-14,0,22,0,-2,0,-20,0,16,0,-2,0,-2],
    0],[[3],16],[[-6,0,5,0,8,0,-6],6],
    [[1,0,-2,0,7,0,-8,0,3],32],
    [[-3,0,13,0,0,0,-12,0,8,0,-2],6],
    [[7,0,-23,0,22,0,-8],0],
    [[29,0,-110,0,159,0,-114,0,49,0,-12,0,1],0],
    [[1,0,0,0,0,0,-8,0,15,0,-6],0],
    [[1,0,-2,0,1],16],[[7,0,-20,0,19,0,-7,0,1],0],
    [[4,0,-8,0,5,0,-1],0],[[],0],
    [[2,0,-8,0,5,0,2,0,-1],0],
    [[1,0,0,0,-5,0,6,0,-2],0],[[-1,0,0,0,1],24],
    [[-3,0,3],4],[[],0],[[],0],[[],0],
    [[13,0,-45,0,54,0,-29,0,8,0,-1],0],
    [[1,0,-2,0,-1,0,2],0],[[],0],
    [[7,0,-6,0,-27,0,53,0,-42,0,14],0],[[3,0,-4],36],
    [[1,0,0,0,0,0,-2],16],[[1,0,-2],16],
    [[-3,0,2],4],[[1,0,-1,0,0,0,-1],16],
    [[19,0,-66,0,84,0,-53,0,18,0,-3],0],
    [[2,0,-1,0,-17,0,29,0,-17,0,3],0],[[1],8],
    [[11,0,-33,0,36,0,-18,0,4],0],[[],0],[[],0],
    [[],0],[[-630,0,420],0],
    [[-35,0,0,0,0,0,15,0,0,0,189,0,-315,0,0,0,0,0,-280,
    0,216],36],[[-229,0,453,0,-297,0,71],0],
    [[-13,0,6,0,0,0,132,0,-256,0,126,0,58,0,-46,0,-27,0,
    18],0],[[-105,0,180,0,-70,0,5],0],
    [[6,0,0,0,0,0,-20,0,20,0,5,0,0,0,-20,0,30,0,-25,0,
    9,0,5],10],
    [[-3,0,0,0,0,0,52,0,-97,0,3,0,60,0,-28,0,-3,0,2],
    0],[[-13,0,6,0,60,0,-92,0,47,0,-6],0],
    [[-2,0,3,0,-3,0,7,0,-3],18],
    [[1,0,0,0,3,0,-6,0,0,0,9,0,-1],6],
    [[-40,0,118,0,-125,0,62,0,-14,0,1],0],
    [[-175,0,315,0,-185,0,30],0],
    [[-6,0,6,0,0,0,4,0,-20,0,21,0,-26,0,15,0,-9],16],
    [[-4,0,2,0,-3,0,10,0,-20,0,12,0,3,0,-3],12],
    [[1,0,-3,0,-9,0,8],12],
    [[-63,0,203,0,-243,0,144,0,-46,0,6],0],
    [[-13,0,39,0,-30,0,5],0],
    [[-50,0,146,0,-163,0,89,0,-24,0,2],0],
    [[-3,0,-1,0,8,0,-6,0,2],14],
    [[1,0,2,0,-3,0,1],16],
    [[4,0,-5,0,-2,0,7,0,-3],6],
    [[-12,0,23,0,-16,0,3],0],
    [[2,0,-9,0,5,0,6,0,-10,0,5,0,-1],6],
    [[-3,0,10,0,-1,0,-2],0],
    [[5,0,-5,0,1,0,4,0,-5,0,3,0,1],6],
    [[-1,0,0,0,1],10],[[-1,0,3,0,-2],0],
    [[-22,0,57,0,-51,0,18,0,-2],0],[[-1,0,1],14],
    [[-1,0,1,0,0,0,18,0,-43,0,34,0,3,0,-25,0,17,0,-2,
    0,-1],0],[[-3,0,0,0,28,0,-31,0,7],0],
    [[-33,0,84,0,-82,0,38,0,-6],0],
    [[2,0,2,0,-6,0,3,0,3,0,-3],6],
    [[-1,0,1,0,8,0,-17,0,13,0,-6],0],
    [[1,0,0,0,-1],2],[[1,0,-3,0,1],4],
    [[1,0,-2],6],[[-2,0,7,0,-7,0,2],0],
    [[1,0,-1],6],[[2,0,-3,0,1],4],[[1,0,-1],4],
    [[-4,0,16,0,-20,0,11,0,-3],0],[[1,0,0,0,-1],4],
    [[-1,0,5,0,-5,0,0,0,2],0],[[2,0,-4,0,3],6],
    [[-6,0,25,0,-37,0,24,0,-8,0,2],0],[[-1,0,1],10]]
    ,
    [[[2100],0],[[2100],120],[[12,0,0,0,0,0,-176,0,306,
    0,0,0,-168,0,0,0,306,0,-176,0,0,0,0,0,12],0],
    [[510,0,-1080,0,510],0],
    [[5,0,0,0,0,0,-20,0,-18,0,0,0,60,0,0,0,255,0,-624,
    0,255,0,0,0,60,0,0,0,-18,0,-20,0,0,0,0,0,5],
    12],[[20],60],
    [[108,0,-528,0,828,0,-528,0,108],0],
    [[360,0,-690,0,360],0],
    [[20,0,0,0,0,0,0,0,0,0,0,0,-10,0,0,0,0,0,0,0,0,
    0,0,0,20],52],[[30],80],[[30],40],
    [[2,0,0,0,0,0,-24,0,18,0,0,0,2,0,0,0,18,0,-24,0,
    0,0,0,0,2],12],[[9,0,-24,0,9],40],
    [[48,0,-234,0,384,0,-234,0,48],0],
    [[3,0,-12,0,30,0,-12,0,3],40],
    [[12,0,0,0,-102,0,160,0,-102,0,0,0,12],0],
    [[-18,0,16,0,-18],64],
    [[1,0,8,0,-10,0,-8,0,14,0,-8,0,-10,0,8,0,1],8],
    [[37,0,-181,0,284,0,-181,0,37],0],
    [[-1,0,0,0,-7,0,38,0,-42,0,-19,0,58,0,-19,0,-42,0,
    38,0,-7,0,0,0,-1],2],[[],0],
    [[1,0,-16,0,61,0,-96,0,61,0,-16,0,1],0],
    [[15,0,-75,0,120,0,-75,0,15],0],[[],0],[[],0],
    [[],0],
    [[-3,0,6,0,-20,0,92,0,-143,0,46,0,58,0,46,0,-143,0,
    92,0,-20,0,6,0,-3],2],
    [[12,0,-44,0,78,0,-44,0,12],0],
    [[-8,0,6,0,-8],42],
    [[73,0,-351,0,562,0,-351,0,73],0],
    [[-2,0,6,0,-4,0,-7,0,20,0,-7,0,-4,0,6,0,-2],6],
    [[2],20],[[-2,0,0,0,6,0,-6,0,6,0,0,0,-2],6],
    [[-2,0,9,0,-12,0,9,0,-2],42],
    [[-1,0,2,0,3,0,-8,0,4,0,-8,0,3,0,2,0,-1],6],
    [[-8,0,33,0,-48,0,33,0,-8],2],
    [[7,0,-72,0,230,0,-330,0,230,0,-72,0,7],0],
    [[-1,0,-2,0,12,0,-18,0,12,0,-2,0,-1],4],
    [[1,0,0,0,1],20],[[-6,0,27,0,-42,0,27,0,-6],2],
    [[-1,0,9,0,-16,0,9,0,-1],2],[[],0],
    [[-2,0,10,0,-16,0,10,0,-2],2],
    [[-1,0,6,0,-10,0,6,0,-1],4],[[],0],
    [[-1,0,3,0,-4,0,3,0,-1],4],[[],0],[[],0],
    [[],0],[[1,0,-21,0,74,0,-108,0,74,0,-21,0,1],0],
    [[2,0,-4,0,2],4],[[],0],
    [[-3,0,-6,0,59,0,-102,0,59,0,-6,0,-3],2],
    [[-2],46],[[-2],26],[[-2],22],[[-2],6],
    [[-1,0,0,0,-1],22],
    [[3,0,-34,0,119,0,-174,0,119,0,-34,0,3],0],
    [[-1,0,-6,0,29,0,-42,0,29,0,-6,0,-1],2],[[],0],
    [[1,0,-12,0,50,0,-78,0,50,0,-12,0,1],0],[[],0],
    [[],0],[[],0],[[-1050,0,1050],0],
    [[189,0,0,0,0,0,0,0,0,0,-189,0,0,0,0,0,189,0,0,0,
    0,0,0,0,0,0,-189],50],
    [[-240,0,810,0,-810,0,240],0],
    [[-3,0,9,0,0,0,76,0,-235,0,171,0,84,0,-84,0,-171,0,
    235,0,-76,0,0,0,-9,0,3],0],
    [[-90,0,270,0,-270,0,90],0],
    [[1,0,0,0,0,0,0,0,-4,0,-11,0,8,0,-20,0,116,0,-116,
    0,20,0,-8,0,11,0,4,0,0,0,0,0,0,0,-1],14],
    [[-1,0,0,0,0,0,22,0,-59,0,12,0,54,0,-54,0,-12,0,59,
    0,-22,0,0,0,0,0,1],0],
    [[-3,0,9,0,45,0,-137,0,137,0,-45,0,-9,0,3],0],
    [[-3,0,0,0,4,0,3,0,-3,0,-4,0,0,0,3],26],
    [[3,0,3,0,1,0,-3,0,3,0,-1,0,-3,0,-3],14],
    [[-14,0,105,0,-241,0,241,0,-105,0,14],0],
    [[-165,0,540,0,-540,0,165],0],
    [[-1,0,0,0,0,0,0,0,-10,0,56,0,-56,0,10,0,0,0,0,0,
    0,0,1],20],
    [[2,0,0,0,8,0,-22,0,12,0,-1,0,1,0,-12,0,22,0,-8,0,
    0,0,-2],14],[[-9,0,9],20],
    [[-30,0,207,0,-468,0,468,0,-207,0,30],0],
    [[-3,0,28,0,-64,0,64,0,-28,0,3],0],
    [[-20,0,134,0,-320,0,320,0,-134,0,20],0],
    [[-4,0,6,0,-6,0,4],20],
    [[-1,0,1,0,-3,0,3,0,-1,0,1],20],
    [[-2,0,-2,0,7,0,-7,0,2,0,2],8],
    [[-1,0,14,0,-39,0,39,0,-14,0,1],0],
    [[-1,0,1,0,5,0,-7,0,7,0,-5,0,-1,0,1],8],
    [[-1,0,4,0,-15,0,15,0,-4,0,1],0],
    [[-1,0,1,0,-1,0,-3,0,3,0,1,0,-1,0,1],8],
    [[1,0,1,0,-1,0,-1],14],[[-1,0,5,0,-5,0,1],4],
    [[-5,0,42,0,-103,0,103,0,-42,0,5],0],
    [[-1,0,1,0,0,0,0,0,-1,0,1],10],
    [[-1,0,1,0,-11,0,29,0,-16,0,-27,0,27,0,16,0,-29,0,
    11,0,-1,0,1],4],
    [[-1,0,0,0,17,0,-39,0,39,0,-17,0,0,0,1],0],
    [[-9,0,67,0,-167,0,167,0,-67,0,9],0],
    [[2,0,-1,0,-4,0,4,0,1,0,-2],12],
    [[-10,0,27,0,-27,0,10],6],[[1,0,-1],6],
    [[1,0,-1],6],[[1,0,-1],10],
    [[-5,0,13,0,-13,0,5],4],[[],0],
    [[-2,0,4,0,-4,0,2],6],[[],0],
    [[2,0,-15,0,37,0,-37,0,15,0,-2],2],[[2,0,-2],8],
    [[-4,0,10,0,-10,0,4],4],[[-2,0,4,0,-4,0,2],8],
    [[5,0,-31,0,66,0,-66,0,31,0,-5],2],
    [[-1,0,1,0,-1,0,1],10]],
    [[[1344],0],[[1344],150],
    [[36,0,0,0,-104,0,0,0,396,0,-320,0,0,0,0,0,56],8],
    [[184,0,-640,0,520],0],
    [[-64,0,150,0,-60,0,50,0,0,0,-48,0,-80,0,120,0,0,0,
    30,0,-36,0,0,0,0,0,0,0,0,0,2],30],[[],0],
    [[20,0,-176,0,456,0,-496,0,196],0],
    [[84,0,-420,0,420],0],
    [[60,0,0,0,-24,0,64,0,-15,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,-1],74],[[-24],100],[[-24],50],
    [[-3,0,0,0,30,0,-56,0,12,0,0,0,18,0,0,0,-9,0,0,0,
    0,0,0,0,2],24],[[-6,0,12,0,-12],50],
    [[4,0,-50,0,190,0,-270,0,120],0],
    [[-2,0,4,0,-14,0,12,0,-6],50],
    [[-12,0,88,0,-132,0,0,0,56],4],[[],0],
    [[6,0,-16,0,-10,0,32,0,-2,0,-12,0,0,0,0,0,2],16],
    [[1,0,-31,0,144,0,-221,0,107],0],
    [[-2,0,-3,0,33,0,-37,0,-58,0,124,0,-59,0,0,0,-6,0,8
    ],10],[[],0],[[6,0,-32,0,68,0,-60,0,18],4],
    [[-4,0,51,0,-114,0,66],2],
    [[-4,0,0,0,6,0,0,0,-4,0,0,0,1],34],[[4],60],
    [[4],30],
    [[-9,0,14,0,30,0,-13,0,-150,0,221,0,-88,0,5,0,-19,0,
    13],10],[[28,0,-80,0,56],4],
    [[-8,0,4,0,-4],54],
    [[9,0,-95,0,300,0,-365,0,155],0],
    [[-1,0,2,0,10,0,-24,0,-1,0,42,0,-26,0,0,0,0,0,2],
    10],[[],0],
    [[-3,0,10,0,4,0,-18,0,3,0,0,0,2],12],
    [[-1,0,6,0,-9,0,4,0,-2],54],
    [[-1,0,5,0,-12,0,2,0,23,0,-15,0,0,0,0,0,2],12],
    [[2,0,-15,0,39,0,-41,0,13],4],
    [[-6,0,52,0,-154,0,220,0,-158,0,44],2],
    [[-4,0,14,0,-8,0,-6,0,0,0,2],10],[[],0],
    [[1,0,-13,0,35,0,-35,0,12],4],
    [[-2,0,12,0,-15,0,5],6],[[],0],
    [[-3,0,15,0,-20,0,8],6],
    [[-2,0,14,0,-14,0,0,0,2],8],[[],0],
    [[7,0,-9,0,0,0,2],10],[[],0],[[],0],
    [[],0],[[9,0,-45,0,85,0,-73,0,23],4],
    [[1,0,2,0,-6,0,2],6],[[],0],
    [[7,0,-41,0,74,0,-34,0,-19,0,13],6],
    [[4,0,-3,0,0,0,-1],56],[[],0],[[],0],
    [[1,0,0,0,-3,0,2],6],[[],0],
    [[-1,0,19,0,-73,0,124,0,-98,0,29],2],
    [[1,0,-17,0,41,0,-27,0,-6,0,8],6],[[],0],
    [[4,0,-27,0,58,0,-53,0,17],4],[[-2,0,1],32],
    [[1],20],[[1],10],[[-504,0,840],0],
    [[280,0,0,0,-189,0,378,0,-189,0,0,0,15,0,0,0,0,0,
    35,0,0,0,0,0,-21,0,27],72],
    [[-64,0,360,0,-600,0,320],0],
    [[-9,0,27,0,34,0,-70,0,-153,0,371,0,-192,0,0,0,-24,
    0,32],8],[[-4,0,80,0,-240,0,180],0],
    [[-15,0,30,0,-5,0,16,0,4,0,-23,0,-20,0,30,0,-1,0,7,
    0,-7],32],
    [[-1,0,3,0,20,0,-56,0,-3,0,139,0,-100,0,0,0,0,0,14]
    ,8],[[3,0,-39,0,109,0,-81,0,-24,0,32],4],
    [[6,0,-4,0,-3,0,-3,0,1,0,3],40],
    [[4,0,-9,0,-3,0,15,0,-6,0,0,0,-1],24],
    [[11,0,-75,0,177,0,-177,0,64],2],
    [[-29,0,210,0,-430,0,255],0],
    [[-24,0,31,0,-5,0,10,0,-14,0,-5,0,-1,0,15,0,0,0,0,
    0,-1],32],
    [[-3,0,-12,0,42,0,-38,0,6,0,-8,0,10,0,3,0,-6,0,0,
    0,0,0,-1,0,1],26],
    [[-8,0,9,0,-3,0,-1,0,-3],24],
    [[-2,0,39,0,-176,0,328,0,-285,0,94],0],
    [[-11,0,49,0,-72,0,32],4],
    [[-1,0,19,0,-105,0,225,0,-211,0,73],0],
    [[-2,0,5,0,-12,0,8,0,1,0,2,0,-2],24],
    [[-1,0,6,0,-10,0,2,0,0,0,2,0,-1],28],
    [[-7,0,4,0,10,0,-11,0,2,0,-1,0,1],14],
    [[-3,0,27,0,-46,0,20],4],
    [[-2,0,8,0,-9,0,-9,0,19,0,-9,0,0,0,-1,0,1],14],
    [[1,0,9,0,-24,0,14],4],
    [[-1,0,1,0,5,0,-10,0,0,0,10,0,-5],12],
    [[-2,0,1,0,2,0,-1],20],[[-1,0,4,0,-4,0,1],8],
    [[1,0,-22,0,78,0,-95,0,39],2],
    [[1,0,-2,0,1,0,2,0,-1],16],
    [[-2,0,-6,0,26,0,-10,0,-54,0,71,0,-26,0,1,0,-5,0,3]
    ,12],[[-5,0,35,0,-46,0,0,0,14],6],
    [[5,0,-42,0,118,0,-131,0,48],2],
    [[3,0,-6,0,-5,0,9,0,-1,0,-2],18],
    [[3,0,-18,0,26,0,-11,0,-5,0,3],8],
    [[1,0,0,0,-1],8],[[1,0,1,0,-3,0,1],8],
    [[2,0,-2],14],[[1,0,-6,0,13,0,-11,0,3],6],
    [[1,0,-1],12],[[-3,0,8,0,-5,0,-1,0,1],10],
    [[1,0,-1],8],[[5,0,-18,0,31,0,-23,0,6],6],
    [[-1,0,5,0,-3],10],[[1,0,-4,0,11,0,-11,0,3],6],
    [[-2,0,5,0,-2,0,-1],12],
    [[-1,0,14,0,-39,0,56,0,-39,0,10],4],
    [[3,0,0,0,-2],16]],
    [[[1344],0],[[1344],90],[[56,0,0,0,0,0,-320,0,396,
    0,0,0,-104,0,0,0,36],0],
    [[520,0,-640,0,184],0],
    [[2,0,0,0,0,0,0,0,0,0,-36,0,30,0,0,0,120,0,-80,0,
    -48,0,0,0,50,0,-60,0,150,0,-64],0],[[],0],
    [[196,0,-496,0,456,0,-176,0,20],0],
    [[420,0,-420,0,84],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-15,0,64,0,
    -24,0,0,0,60],30],[[-24],60],[[-24],30],
    [[2,0,0,0,0,0,0,0,-9,0,0,0,18,0,0,0,12,0,-56,0,
    30,0,0,0,-3],0],[[-12,0,12,0,-6],30],
    [[120,0,-270,0,190,0,-50,0,4],0],
    [[-6,0,12,0,-14,0,4,0,-2],30],
    [[56,0,0,0,-132,0,88,0,-12],0],[[],0],
    [[2,0,0,0,0,0,-12,0,-2,0,32,0,-10,0,-16,0,6],0],
    [[107,0,-221,0,144,0,-31,0,1],0],
    [[8,0,-6,0,0,0,-59,0,124,0,-58,0,-37,0,33,0,-3,0,-2
    ],0],[[],0],[[18,0,-60,0,68,0,-32,0,6],0],
    [[66,0,-114,0,51,0,-4],0],
    [[1,0,0,0,-4,0,0,0,6,0,0,0,-4],18],[[4],36],
    [[4],18],
    [[13,0,-19,0,5,0,-88,0,221,0,-150,0,-13,0,30,0,14,0,
    -9],0],[[56,0,-80,0,28],0],
    [[-4,0,4,0,-8],30],
    [[155,0,-365,0,300,0,-95,0,9],0],
    [[2,0,0,0,0,0,-26,0,42,0,-1,0,-24,0,10,0,2,0,-1],
    0],[[],0],
    [[2,0,0,0,3,0,-18,0,4,0,10,0,-3],0],
    [[-2,0,4,0,-9,0,6,0,-1],30],
    [[2,0,0,0,0,0,-15,0,23,0,2,0,-12,0,5,0,-1],0],
    [[13,0,-41,0,39,0,-15,0,2],0],
    [[44,0,-158,0,220,0,-154,0,52,0,-6],0],
    [[2,0,0,0,-6,0,-8,0,14,0,-4],0],[[],0],
    [[12,0,-35,0,35,0,-13,0,1],0],
    [[5,0,-15,0,12,0,-2],0],[[],0],
    [[8,0,-20,0,15,0,-3],0],
    [[2,0,0,0,-14,0,14,0,-2],0],[[],0],
    [[2,0,0,0,-9,0,7],0],[[],0],[[],0],[[],0],
    [[23,0,-73,0,85,0,-45,0,9],0],
    [[2,0,-6,0,2,0,1],0],[[],0],
    [[13,0,-19,0,-34,0,74,0,-41,0,7],0],
    [[-1,0,0,0,-3,0,4],30],[[],0],[[],0],
    [[2,0,-3,0,0,0,1],0],[[],0],
    [[29,0,-98,0,124,0,-73,0,19,0,-1],0],
    [[8,0,-6,0,-27,0,41,0,-17,0,1],0],[[],0],
    [[17,0,-53,0,58,0,-27,0,4],0],[[1,0,-2],18],
    [[1],12],[[1],6],[[-840,0,504],0],
    [[-27,0,21,0,0,0,0,0,-35,0,0,0,0,0,-15,0,0,0,189,
    0,-378,0,189,0,0,0,-280],28],
    [[-320,0,600,0,-360,0,64],0],
    [[-32,0,24,0,0,0,192,0,-371,0,153,0,70,0,-34,0,-27,
    0,9],0],[[-180,0,240,0,-80,0,4],0],
    [[7,0,-7,0,1,0,-30,0,20,0,23,0,-4,0,-16,0,5,0,-30,
    0,15],10],
    [[-14,0,0,0,0,0,100,0,-139,0,3,0,56,0,-20,0,-3,0,1]
    ,0],[[-32,0,24,0,81,0,-109,0,39,0,-3],0],
    [[-3,0,-1,0,3,0,3,0,4,0,-6],16],
    [[1,0,0,0,6,0,-15,0,3,0,9,0,-4],6],
    [[-64,0,177,0,-177,0,75,0,-11],0],
    [[-255,0,430,0,-210,0,29],0],
    [[1,0,0,0,0,0,-15,0,1,0,5,0,14,0,-10,0,5,0,-31,0,
    24],10],
    [[-1,0,1,0,0,0,0,0,6,0,-3,0,-10,0,8,0,-6,0,38,0,
    -42,0,12,0,3],0],[[3,0,1,0,3,0,-9,0,8],10],
    [[-94,0,285,0,-328,0,176,0,-39,0,2],0],
    [[-32,0,72,0,-49,0,11],0],
    [[-73,0,211,0,-225,0,105,0,-19,0,1],0],
    [[2,0,-2,0,-1,0,-8,0,12,0,-5,0,2],10],
    [[1,0,-2,0,0,0,-2,0,10,0,-6,0,1],10],
    [[-1,0,1,0,-2,0,11,0,-10,0,-4,0,7],0],
    [[-20,0,46,0,-27,0,3],0],
    [[-1,0,1,0,0,0,9,0,-19,0,9,0,9,0,-8,0,2],0],
    [[-14,0,24,0,-9,0,-1],0],
    [[5,0,-10,0,0,0,10,0,-5,0,-1,0,1],6],
    [[1,0,-2,0,-1,0,2],8],[[-1,0,4,0,-4,0,1],0],
    [[-39,0,95,0,-78,0,22,0,-1],0],
    [[1,0,-2,0,-1,0,2,0,-1],6],
    [[-3,0,5,0,-1,0,26,0,-71,0,54,0,10,0,-26,0,6,0,2],
    0],[[-14,0,0,0,46,0,-35,0,5],0],
    [[-48,0,131,0,-118,0,42,0,-5],0],
    [[2,0,1,0,-9,0,5,0,6,0,-3],6],
    [[-3,0,5,0,11,0,-26,0,18,0,-3],0],
    [[1,0,0,0,-1],2],[[-1,0,3,0,-1,0,-1],0],
    [[2,0,-2],6],[[-3,0,11,0,-13,0,6,0,-1],0],
    [[1,0,-1],4],[[-1,0,1,0,5,0,-8,0,3],0],
    [[1,0,-1],4],[[-6,0,23,0,-31,0,18,0,-5],0],
    [[3,0,-5,0,1],4],[[-3,0,11,0,-11,0,4,0,-1],0],
    [[1,0,2,0,-5,0,2],4],
    [[-10,0,39,0,-56,0,39,0,-14,0,1],0],
    [[2,0,0,0,-3],6]],
    [[[2688],0],[[2688],120],[[4,0,0,0,0,0,-192,0,396,
    0,0,0,-288,0,0,0,396,0,-192,0,0,0,0,0,4],0],
    [[672,0,-1344,0,672],0],
    [[15,0,-20,0,24,0,0,0,0,0,-120,0,345,0,-488,0,345,0,
    -120,0,0,0,0,0,24,0,-20,0,15],16],[[64],60],
    [[168,0,-672,0,1008,0,-672,0,168],0],
    [[432,0,-912,0,432],0],
    [[-15,0,-64,0,60,0,0,0,-10,0,0,0,60,0,-64,0,-15],56
    ],[[60],80],[[60],40],
    [[-6,0,-16,0,24,0,0,0,-16,0,0,0,24,0,-16,0,-6],16],
    [[18,0,-48,0,18],40],
    [[68,0,-296,0,444,0,-296,0,68],0],
    [[5,0,-32,0,42,0,-32,0,5],40],
    [[4,0,0,0,-132,0,256,0,-132,0,0,0,4],0],
    [[4,0,0,0,-36,0,64,0,-36,0,0,0,4],60],
    [[-1,0,8,0,-8,0,-16,0,34,0,-16,0,-8,0,8,0,-1],8],
    [[48,0,-216,0,336,0,-216,0,48],0],
    [[-10,0,46,0,-42,0,-54,0,120,0,-54,0,-42,0,46,0,-10],
    6],[[],0],
    [[2,0,-24,0,66,0,-88,0,66,0,-24,0,2],0],
    [[16,0,-80,0,136,0,-80,0,16],0],
    [[1,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,1],24],
    [[3],48],[[3],24],
    [[-2,0,0,0,-28,0,131,0,-163,0,9,0,90,0,9,0,-163,0,
    131,0,-28,0,0,0,-2],2],
    [[4,0,-48,0,72,0,-48,0,4],0],
    [[1,0,-12,0,18,0,-12,0,1],40],
    [[108,0,-444,0,672,0,-444,0,108],0],
    [[-2,0,10,0,-8,0,-22,0,44,0,-22,0,-8,0,10,0,-2],6],
    [[4],20],[[2,0,8,0,-24,0,8,0,2],8],
    [[-6,0,14,0,-20,0,14,0,-6],42],
    [[2,0,0,0,-16,0,24,0,-16,0,0,0,2],8],
    [[-9,0,29,0,-38,0,29,0,-9],2],
    [[17,0,-108,0,276,0,-370,0,276,0,-108,0,17],0],
    [[-2,0,15,0,-26,0,15,0,-2],6],[[1,0,-4,0,1],20],
    [[1,0,-8,0,24,0,-34,0,24,0,-8,0,1],0],
    [[-2,0,6,0,-8,0,6,0,-2],2],[[],0],
    [[-1,0,4,0,-6,0,4,0,-1],2],
    [[-1,0,6,0,-10,0,6,0,-1],4],[[],0],
    [[2,0,-4,0,2],6],[[],0],[[],0],[[],0],
    [[4,0,-28,0,78,0,-108,0,78,0,-28,0,4],0],
    [[-1,0,2,0,-1],4],[[-1],12],
    [[-2,0,-21,0,87,0,-128,0,87,0,-21,0,-2],2],
    [[1,0,-2,0,1],44],
    [[1,0,0,0,0,0,-2,0,0,0,0,0,1],20],
    [[1,0,-2,0,1],20],[[-2,0,4,0,-2],4],
    [[1,0,-1,0,0,0,-1,0,1],20],
    [[7,0,-51,0,135,0,-182,0,135,0,-51,0,7],0],
    [[-8,0,36,0,-56,0,36,0,-8],4],[[],0],
    [[2,0,-18,0,52,0,-70,0,52,0,-18,0,2],0],
    [[1,0,0,0,1],24],[[],0],[[],0],
    [[-1344,0,1344],0],
    [[-280,0,216,0,0,0,336,0,0,0,0,0,-336,0,0,0,-216,0,
    280],54],[[-336,0,1008,0,-1008,0,336],0],
    [[-2,0,2,0,0,0,96,0,-294,0,198,0,144,0,-144,0,-198,
    0,294,0,-96,0,0,0,-2,0,2],0],
    [[-96,0,336,0,-336,0,96],0],
    [[15,0,-5,0,-25,0,75,0,-75,0,25,0,5,0,-15],24],
    [[20,0,-72,0,12,0,120,0,-120,0,-12,0,72,0,-20],6],
    [[-2,0,2,0,66,0,-194,0,194,0,-66,0,-2,0,2],0],
    [[],0],[[3,0,-4,0,-3,0,3,0,4,0,-3],16],
    [[-24,0,132,0,-276,0,276,0,-132,0,24],0],
    [[-216,0,672,0,-672,0,216],0],
    [[1,0,0,0,0,0,0,0,0,0,-21,0,50,0,-50,0,21,0,0,0,
    0,0,0,0,0,0,-1],18],
    [[3,0,5,0,-20,0,12,0,8,0,-8,0,-12,0,20,0,-5,0,-3],
    16],[[8,0,-6,0,6,0,-8],18],
    [[-54,0,276,0,-558,0,558,0,-276,0,54],0],
    [[-2,0,26,0,-60,0,60,0,-26,0,2],0],
    [[-34,0,182,0,-370,0,370,0,-182,0,34],0],
    [[4,0,-7,0,7,0,-7,0,7,0,-4],18],
    [[1,0,-3,0,3,0,-3,0,3,0,-3,0,3,0,-1],18],
    [[-1,0,-3,0,16,0,-16,0,3,0,1],8],
    [[-2,0,14,0,-34,0,34,0,-14,0,2],0],
    [[-1,0,1,0,8,0,-20,0,20,0,-8,0,-1,0,1],8],
    [[2,0,-6,0,6,0,-2],2],
    [[-1,0,2,0,4,0,-7,0,7,0,-4,0,-2,0,1],8],
    [[],0],[[-1,0,1,0,-1,0,1],4],
    [[-8,0,48,0,-108,0,108,0,-48,0,8],0],
    [[1,0,-1,0,1,0,-1],12],
    [[2,0,-18,0,30,0,8,0,-58,0,58,0,-8,0,-30,0,18,0,-2]
    ,6],[[16,0,-56,0,56,0,-16],4],
    [[-14,0,88,0,-182,0,182,0,-88,0,14],0],
    [[-1,0,1,0,3,0,-11,0,11,0,-3,0,-1,0,1],10],
    [[2,0,-15,0,30,0,-30,0,15,0,-2],4],[[-1,0,1],6],
    [[1,0,-3,0,3,0,-1],4],[[],0],
    [[1,0,-4,0,7,0,-7,0,4,0,-1],2],[[-1,0,1],8],
    [[-1,0,3,0,-3,0,1],6],[[-1,0,1],6],
    [[4,0,-17,0,29,0,-29,0,17,0,-4],2],[[],0],
    [[-2,0,3,0,-3,0,2],4],[[-2,0,5,0,-5,0,2],8],
    [[-1,0,10,0,-35,0,61,0,-61,0,35,0,-10,0,1],0],
    [[2,0,-2],12]],
    [[[1400],0],[[1400],144],[[-16,0,54,0,0,0,-200,0,0,
    0,360,0,-304,0,0,0,0,0,34],6],
    [[220,0,-680,0,500],0],
    [[75,0,-152,0,165,0,-120,0,170,0,0,0,-90,0,-80,0,90,
    0,0,0,5,0,-24,0,0,0,0,0,0,0,0,0,1],28],
    [[40],72],[[34,0,-208,0,492,0,-496,0,170],0],
    [[110,0,-450,0,390],0],
    [[10,0,0,0,60,0,-64,0,30,0,0,0,20,0,0,0,-6],72],
    [[50],96],[[50],48],
    [[-11,0,0,0,24,0,-40,0,21,0,0,0,8,0,0,0,-6],24],
    [[11,0,-36,0,21],48],
    [[5,0,-70,0,215,0,-250,0,105],0],
    [[2,0,-16,0,38,0,-28,0,9],48],
    [[-18,0,88,0,-120,0,0,0,34],4],
    [[-18,0,32,0,-36,0,0,0,6],76],
    [[16,0,-20,0,-8,0,24,0,-5,0,-8,0,0,0,0,0,1],16],
    [[3,0,-44,0,160,0,-206,0,87],0],
    [[-2,0,-14,0,59,0,-44,0,-49,0,97,0,-47,0,0,0,-3,0,3
    ],10],[[],0],[[9,0,-40,0,67,0,-50,0,14],4],
    [[-10,0,60,0,-100,0,50],2],[[],0],[[],0],
    [[],0],
    [[4,0,-26,0,-4,0,68,0,-6,0,-145,0,186,0,-84,0,4,0,
    -11,0,8],8],[[-4,0,40,0,-76,0,34],2],
    [[-4,0,10,0,-16,0,4],50],
    [[15,0,-121,0,326,0,-355,0,133],0],
    [[-2,0,16,0,-22,0,0,0,25,0,-20,0,0,0,0,0,1],12],
    [[-2],24],[[1,0,8,0,-3,0,-8,0,2],12],
    [[6,0,-16,0,16,0,-8,0,2],52],
    [[1,0,6,0,-13,0,0,0,11,0,-8],12],
    [[3,0,-22,0,40,0,-32,0,8],4],
    [[1,0,-12,0,65,0,-170,0,225,0,-140,0,32],0],
    [[-2,0,11,0,-8,0,-1,0,0,0,1],10],[[2,0,-1],26],
    [[2,0,-15,0,33,0,-27,0,8],4],
    [[-4,0,11,0,-11,0,4],6],[[],0],
    [[1,0,-8,0,18,0,-14,0,3],4],
    [[-4,0,10,0,-7,0,0,0,1],8],[[],0],
    [[-2,0,5,0,-4],8],[[-1],16],[[-1],32],
    [[-1],16],[[-1,0,12,0,-49,0,83,0,-60,0,15],2],
    [[-2,0,5,0,-4,0,1],6],[[],0],
    [[12,0,-46,0,65,0,-26,0,-11,0,8],6],
    [[2,0,2,0,-2],54],[[2],30],[[2],26],
    [[-1,0,5,0,-2],6],[[1,0,0,0,1],26],
    [[-3,0,25,0,-83,0,124,0,-84,0,21],2],
    [[2,0,-17,0,34,0,-19,0,-3,0,3],6],[[],0],
    [[6,0,-32,0,57,0,-43,0,12],4],[[],0],[[],0],
    [[],0],[[-560,0,840],0],
    [[405,0,-315,0,0,0,0,0,315,0,-189,0,0,0,120,0,0,0,
    0,0,-56],70],[[-86,0,402,0,-618,0,294],0],
    [[4,0,-30,0,36,0,90,0,-110,0,-153,0,331,0,-180,0,0,
    0,-15,0,19],6],[[-10,0,100,0,-240,0,150],0],
    [[10,0,-41,0,45,0,-40,0,40,0,9,0,-18,0,-20,0,20,0,
    0,0,1,0,-6],30],
    [[-1,0,3,0,36,0,-84,0,-3,0,109,0,-82,0,0,0,0,0,6],
    8],[[6,0,-46,0,105,0,-69,0,-15,0,19],4],
    [[-7,0,9,0,3,0,-5],36],
    [[9,0,2,0,-9,0,0,0,10,0,-3,0,0,0,-1],22],
    [[-1,0,18,0,-89,0,183,0,-160,0,49],0],
    [[-40,0,250,0,-430,0,230],0],
    [[5,0,-6,0,-1,0,36,0,-19,0,-10,0,6,0,1,0,-1,0,-1],
    32],
    [[10,0,-1,0,-12,0,28,0,-30,0,15,0,-4,0,4,0,3,0,-3],
    24],[[9,0,9,0,-6,0,-2],24],
    [[-6,0,55,0,-201,0,344,0,-269,0,75],0],
    [[1,0,-18,0,56,0,-60,0,19],2],
    [[-2,0,29,0,-126,0,235,0,-194,0,59],0],
    [[3,0,-4,0,-2,0,8,0,-3,0,-1],24],
    [[-2,0,1,0,-1,0,-5,0,6,0,-1],26],
    [[-2,0,-5,0,6,0,3,0,-5,0,1],12],
    [[-7,0,28,0,-35,0,15],4],
    [[-1,0,-2,0,10,0,-7,0,-5,0,10,0,-4],12],
    [[-3,0,16,0,-19,0,6],4],
    [[-3,0,5,0,-2,0,0,0,5,0,-5],14],
    [[1,0,0,0,-1],18],[[-2,0,4,0,-3,0,1],8],
    [[3,0,-29,0,79,0,-81,0,28],2],[[1,0,-1],16],
    [[1,0,-23,0,35,0,-4,0,-45,0,53,0,-21,0,1,0,-2,0,1],
    12],[[-7,0,31,0,-34,0,0,0,6],6],
    [[8,0,-56,0,123,0,-114,0,39],2],
    [[4,0,-5,0,-1,0,6,0,-2,0,-2],18],
    [[4,0,-17,0,20,0,-7,0,-2,0,1],8],
    [[-1,0,1,0,-1],8],[[-3,0,4,0,-1],8],
    [[-1,0,1],12],[[1,0,-7,0,12,0,-8,0,2],6],
    [[-1,0,1],10],[[1,0,-3,0,5,0,-2],8],[[1],10],
    [[6,0,-22,0,30,0,-18,0,4],6],[[-2,0,3,0,-1],10],
    [[2,0,-8,0,12,0,-7,0,1],6],[[-1,0,3,0,-2],12],
    [[-2,0,15,0,-43,0,54,0,-30,0,6],4],[[1,0,-1],16]
    ],
    [[[1400],0],[[1400],96],[[34,0,0,0,0,0,-304,0,360,
    0,0,0,-200,0,0,0,54,0,-16],0],
    [[500,0,-680,0,220],0],
    [[1,0,0,0,0,0,0,0,0,0,-24,0,5,0,0,0,90,0,-80,0,
    -90,0,0,0,170,0,-120,0,165,0,-152,0,75],0],
    [[40],48],[[170,0,-496,0,492,0,-208,0,34],0],
    [[390,0,-450,0,110],0],
    [[-6,0,0,0,20,0,0,0,30,0,-64,0,60,0,0,0,10],40],
    [[50],64],[[50],32],
    [[-6,0,0,0,8,0,0,0,21,0,-40,0,24,0,0,0,-11],8],
    [[21,0,-36,0,11],32],
    [[105,0,-250,0,215,0,-70,0,5],0],
    [[9,0,-28,0,38,0,-16,0,2],32],
    [[34,0,0,0,-120,0,88,0,-18],0],
    [[6,0,0,0,-36,0,32,0,-18],48],
    [[1,0,0,0,0,0,-8,0,-5,0,24,0,-8,0,-20,0,16],0],
    [[87,0,-206,0,160,0,-44,0,3],0],
    [[3,0,-3,0,0,0,-47,0,97,0,-49,0,-44,0,59,0,-14,0,-2
    ],0],[[],0],[[14,0,-50,0,67,0,-40,0,9],0],
    [[50,0,-100,0,60,0,-10],0],[[],0],[[],0],
    [[],0],
    [[8,0,-11,0,4,0,-84,0,186,0,-145,0,-6,0,68,0,-4,0,
    -26,0,4],0],[[34,0,-76,0,40,0,-4],0],
    [[4,0,-16,0,10,0,-4],32],
    [[133,0,-355,0,326,0,-121,0,15],0],
    [[1,0,0,0,0,0,-20,0,25,0,0,0,-22,0,16,0,-2],0],
    [[-2],16],[[2,0,-8,0,-3,0,8,0,1],4],
    [[2,0,-8,0,16,0,-16,0,6],32],
    [[-8,0,11,0,0,0,-13,0,6,0,1],6],
    [[8,0,-32,0,40,0,-22,0,3],0],
    [[32,0,-140,0,225,0,-170,0,65,0,-12,0,1],0],
    [[1,0,0,0,-1,0,-8,0,11,0,-2],0],[[-1,0,2],16],
    [[8,0,-27,0,33,0,-15,0,2],0],
    [[4,0,-11,0,11,0,-4],0],[[],0],
    [[3,0,-14,0,18,0,-8,0,1],0],
    [[1,0,0,0,-7,0,10,0,-4],0],[[],0],
    [[-4,0,5,0,-2],4],[[-1],16],[[-1],24],
    [[-1],12],[[15,0,-60,0,83,0,-49,0,12,0,-1],0],
    [[1,0,-4,0,5,0,-2],0],[[],0],
    [[8,0,-11,0,-26,0,65,0,-46,0,12],0],
    [[-2,0,2,0,2],34],[[2],22],[[2],18],
    [[-2,0,5,0,-1],2],[[1,0,0,0,1],18],
    [[21,0,-84,0,124,0,-83,0,25,0,-3],0],
    [[3,0,-3,0,-19,0,34,0,-17,0,2],0],[[],0],
    [[12,0,-43,0,57,0,-32,0,6],0],[[],0],[[],0],
    [[],0],[[-840,0,560],0],
    [[56,0,0,0,0,0,-120,0,0,0,189,0,-315,0,0,0,0,0,315,
    0,-405],36],[[-294,0,618,0,-402,0,86],0],
    [[-19,0,15,0,0,0,180,0,-331,0,153,0,110,0,-90,0,-36,
    0,30,0,-4],0],[[-150,0,240,0,-100,0,10],0],
    [[6,0,-1,0,0,0,-20,0,20,0,18,0,-9,0,-40,0,40,0,-45,
    0,41,0,-10],10],
    [[-6,0,0,0,0,0,82,0,-109,0,3,0,84,0,-36,0,-3,0,1],
    0],[[-19,0,15,0,69,0,-105,0,46,0,-6],0],
    [[5,0,-3,0,-9,0,7],24],
    [[1,0,0,0,3,0,-10,0,0,0,9,0,-2,0,-9],6],
    [[-49,0,160,0,-183,0,89,0,-18,0,1],0],
    [[-230,0,430,0,-250,0,40],0],
    [[1,0,1,0,-1,0,-6,0,10,0,19,0,-36,0,1,0,6,0,-5],
    12],
    [[3,0,-3,0,-4,0,4,0,-15,0,30,0,-28,0,12,0,1,0,-10],
    8],[[2,0,6,0,-9,0,-9],12],
    [[-75,0,269,0,-344,0,201,0,-55,0,6],0],
    [[-19,0,60,0,-56,0,18,0,-1],0],
    [[-59,0,194,0,-235,0,126,0,-29,0,2],0],
    [[1,0,3,0,-8,0,2,0,4,0,-3],12],
    [[1,0,-6,0,5,0,1,0,-1,0,2],14],
    [[-1,0,5,0,-3,0,-6,0,5,0,2],4],
    [[-15,0,35,0,-28,0,7],0],
    [[4,0,-10,0,5,0,7,0,-10,0,2,0,1],6],
    [[-6,0,19,0,-16,0,3],0],
    [[5,0,-5,0,0,0,2,0,-5,0,3],6],
    [[1,0,0,0,-1],12],[[-1,0,3,0,-4,0,2],0],
    [[-28,0,81,0,-79,0,29,0,-3],0],[[1,0,-1],12],
    [[-1,0,2,0,-1,0,21,0,-53,0,45,0,4,0,-35,0,23,0,-1],
    0],[[-6,0,0,0,34,0,-31,0,7],0],
    [[-39,0,114,0,-123,0,56,0,-8],0],
    [[2,0,2,0,-6,0,1,0,5,0,-4],6],
    [[-1,0,2,0,7,0,-20,0,17,0,-4],0],
    [[1,0,-1,0,1],2],[[1,0,-4,0,3],2],
    [[-1,0,1],8],[[-2,0,8,0,-12,0,7,0,-1],0],
    [[-1,0,1],6],[[2,0,-5,0,3,0,-1],4],[[-1],4],
    [[-4,0,18,0,-30,0,22,0,-6],0],[[1,0,-3,0,2],4],
    [[-1,0,7,0,-12,0,8,0,-2],0],[[2,0,-3,0,1],6],
    [[-6,0,30,0,-54,0,43,0,-15,0,2],0],[[1,0,-1],8]]
    ,
    [[[1575],0],[[1575],144],[[-32,0,63,0,0,0,-128,0,0,
    0,360,0,-368,0,0,0,0,0,48],6],
    [[240,0,-780,0,555],0],
    [[120,0,-192,0,180,0,-60,0,40,0,0,0,-78,0,-60,0,90,
    0,0,0,10,0,-36,0,0,0,0,0,0,0,0,0,1],28],
    [[15],72],[[30,0,-228,0,576,0,-564,0,177],0],
    [[135,0,-495,0,450],0],
    [[100,0,0,0,-60,0,64,0,0,0,0,0,-20,0,0,0,6],72],
    [[-45],96],[[-45],48],
    [[10,0,0,0,12,0,-56,0,45,0,0,0,10,0,0,0,-12],24],
    [[-9,0,36,0,-18],48],
    [[5,0,-80,0,255,0,-290,0,110],0],
    [[-1,0,16,0,-36,0,28,0,-7],48],
    [[-21,0,104,0,-120,0,0,0,48],4],
    [[-9,0,16,0,0,0,0,0,4],76],
    [[8,0,-16,0,-2,0,28,0,-4,0,-12,0,0,0,0,0,1],16],
    [[4,0,-52,0,191,0,-241,0,97],0],
    [[1,0,-4,0,-5,0,37,0,-28,0,-59,0,112,0,-54,0,0,0,
    -5,0,4],8],[[-1],36],
    [[11,0,-54,0,85,0,-54,0,11],4],
    [[-15,0,75,0,-120,0,60],2],[[],0],[[],0],
    [[],0],
    [[8,0,-34,0,17,0,40,0,7,0,-161,0,201,0,-84,0,8,0,
    -16,0,8],8],[[-8,0,46,0,-92,0,48],2],
    [[4,0,-14,0,16,0,-3],50],
    [[14,0,-135,0,383,0,-408,0,140],0],
    [[-2,0,-2,0,10,0,-15,0,-2,0,28,0,-24,0,0,0,0,0,1],
    10],[[3],24],[[-6,0,4,0,5,0,-10,0,4],12],
    [[-8,0,16,0,-18,0,8,0,-1],52],
    [[-2,0,6,0,-7,0,0,0,16,0,-13],12],
    [[4,0,-29,0,54,0,-37,0,8],4],
    [[-10,0,73,0,-210,0,269,0,-150,0,28],2],
    [[-6,0,13,0,-6,0,-2,0,0,0,1],10],
    [[1,0,-2,0,1],24],[[3,0,-23,0,45,0,-32,0,7],4],
    [[-7,0,17,0,-13,0,3],6],[[],0],
    [[1,0,-10,0,25,0,-19,0,4],4],
    [[-6,0,14,0,-8,0,0,0,1],8],[[1],40],
    [[-2,0,7,0,-5],8],[[],0],[[],0],[[],0],
    [[-1,0,15,0,-66,0,106,0,-68,0,14],2],
    [[-2,0,7,0,-6,0,1],6],[[],0],
    [[12,0,-56,0,73,0,-19,0,-16,0,8],6],
    [[4,0,-4,0,2],54],[[-2,0,0,0,0,0,1],30],
    [[-2,0,1],26],[[-2,0,5,0,-4],6],
    [[-1,0,0,0,-1,0,1],26],
    [[-2,0,30,0,-106,0,153,0,-91,0,18],2],
    [[3,0,-23,0,41,0,-18,0,-5,0,4],6],[[-1],12],
    [[8,0,-44,0,74,0,-48,0,10],4],[[],0],[[],0],
    [[],0],[[-630,0,945],0],
    [[594,0,-280,0,0,0,0,0,210,0,-189,0,0,0,15,0,0,0,0,
    0,-35],70],[[-87,0,459,0,-711,0,318],0],
    [[8,0,-42,0,45,0,50,0,-78,0,-162,0,362,0,-204,0,0,0,
    -24,0,24],6],[[-15,0,120,0,-270,0,180],0],
    [[25,0,-51,0,55,0,-10,0,10,0,8,0,-23,0,-10,0,15,0,
    0,0,2,0,-6],30],
    [[-4,0,3,0,23,0,-50,0,-3,0,118,0,-105,0,0,0,0,0,9],
    8],[[6,0,-53,0,120,0,-66,0,-24,0,24],4],
    [[6,0,3,0,-4,0,-3,0,3,0,2],38],
    [[6,0,-1,0,-9,0,0,0,11,0,-3,0,0,0,-1],22],
    [[-1,0,19,0,-108,0,223,0,-184,0,50],0],
    [[-45,0,285,0,-495,0,255],0],
    [[9,0,-15,0,26,0,-15,0,5,0,-9,0,0,0,4,0,-5],30],
    [[-9,0,1,0,-6,0,30,0,-50,0,27,0,-6,0,4,0,6,0,-6],
    24],[[-10,0,3,0,-3,0,1],24],
    [[-4,0,56,0,-235,0,410,0,-301,0,74],0],
    [[2,0,-22,0,71,0,-75,0,24],2],
    [[-1,0,30,0,-150,0,283,0,-219,0,57],0],
    [[-3,0,6,0,-6,0,6,0,-3],24],
    [[2,0,-1,0,2,0,-8,0,8],26],
    [[3,0,-5,0,0,0,9,0,-6,0,2],12],
    [[-11,0,39,0,-44,0,16],4],
    [[1,0,-4,0,7,0,-3,0,-9,0,14,0,-6],12],
    [[-4,0,19,0,-27,0,9],4],
    [[-1,0,-3,0,5,0,-4,0,-1,0,5,0,-4],12],
    [[-1,0,1,0,1],20],[[-4,0,6,0,-3],8],
    [[4,0,-38,0,101,0,-97,0,30],2],[[-1,0,1],14],
    [[1,0,-3,0,-11,0,25,0,6,0,-56,0,57,0,-19,0,2,0,-3,
    0,1],10],[[-11,0,38,0,-36,0,0,0,9],6],
    [[9,0,-69,0,153,0,-131,0,38],2],
    [[2,0,-4,0,-1,0,6,0,-1,0,-2],18],
    [[6,0,-23,0,23,0,-4,0,-3,0,1],8],
    [[-1,0,2,0,-1],8],[[1,0,-3,0,5,0,-2],6],
    [[2,0,-1],14],[[2,0,-12,0,17,0,-8,0,1],6],
    [[-1,0,1],10],[[-5,0,7,0,-2],10],[[-1,0,1],8],
    [[9,0,-32,0,38,0,-17,0,2],6],[[-3,0,4,0,-1],10],
    [[2,0,-12,0,17,0,-8,0,1],6],[[-3,0,4,0,-1],12],
    [[-2,0,21,0,-60,0,67,0,-30,0,4],4],[[-1,0,1],14]
    ],
    [[[1575],0],[[1575],96],[[48,0,0,0,0,0,-368,0,360,
    0,0,0,-128,0,0,0,63,0,-32],0],
    [[555,0,-780,0,240],0],
    [[1,0,0,0,0,0,0,0,0,0,-36,0,10,0,0,0,90,0,-60,0,
    -78,0,0,0,40,0,-60,0,180,0,-192,0,120],0],
    [[15],48],[[177,0,-564,0,576,0,-228,0,30],0],
    [[450,0,-495,0,135],0],
    [[6,0,0,0,-20,0,0,0,0,0,64,0,-60,0,0,0,100],40],
    [[-45],64],[[-45],32],
    [[-12,0,0,0,10,0,0,0,45,0,-56,0,12,0,0,0,10],8],
    [[-18,0,36,0,-9],32],
    [[110,0,-290,0,255,0,-80,0,5],0],
    [[-7,0,28,0,-36,0,16,0,-1],32],
    [[48,0,0,0,-120,0,104,0,-21],0],
    [[4,0,0,0,0,0,16,0,-9],48],
    [[1,0,0,0,0,0,-12,0,-4,0,28,0,-2,0,-16,0,8],0],
    [[97,0,-241,0,191,0,-52,0,4],0],
    [[4,0,-5,0,0,0,-54,0,112,0,-59,0,-28,0,37,0,-5,0,
    -4,0,1],0],[[-1],24],
    [[11,0,-54,0,85,0,-54,0,11],0],
    [[60,0,-120,0,75,0,-15],0],[[],0],[[],0],
    [[],0],
    [[8,0,-16,0,8,0,-84,0,201,0,-161,0,7,0,40,0,17,0,
    -34,0,8],0],[[48,0,-92,0,46,0,-8],0],
    [[-3,0,16,0,-14,0,4],32],
    [[140,0,-408,0,383,0,-135,0,14],0],
    [[1,0,0,0,0,0,-24,0,28,0,-2,0,-15,0,10,0,-2,0,-2],
    0],[[3],16],[[4,0,-10,0,5,0,4,0,-6],4],
    [[-1,0,8,0,-18,0,16,0,-8],32],
    [[-13,0,16,0,0,0,-7,0,6,0,-2],6],
    [[8,0,-37,0,54,0,-29,0,4],0],
    [[28,0,-150,0,269,0,-210,0,73,0,-10],0],
    [[1,0,0,0,-2,0,-6,0,13,0,-6],0],
    [[1,0,-2,0,1],16],[[7,0,-32,0,45,0,-23,0,3],0],
    [[3,0,-13,0,17,0,-7],0],[[],0],
    [[4,0,-19,0,25,0,-10,0,1],0],
    [[1,0,0,0,-8,0,14,0,-6],0],[[1],28],
    [[-5,0,7,0,-2],4],[[],0],[[],0],[[],0],
    [[14,0,-68,0,106,0,-66,0,15,0,-1],0],
    [[1,0,-6,0,7,0,-2],0],[[],0],
    [[8,0,-16,0,-19,0,73,0,-56,0,12],0],
    [[2,0,-4,0,4],34],[[1,0,0,0,0,0,-2],16],
    [[1,0,-2],16],[[-4,0,5,0,-2],2],
    [[1,0,-1,0,0,0,-1],16],
    [[18,0,-91,0,153,0,-106,0,30,0,-2],0],
    [[4,0,-5,0,-18,0,41,0,-23,0,3],0],[[-1],8],
    [[10,0,-48,0,74,0,-44,0,8],0],[[],0],[[],0],
    [[],0],[[-945,0,630],0],
    [[35,0,0,0,0,0,-15,0,0,0,189,0,-210,0,0,0,0,0,280,
    0,-594],36],[[-318,0,711,0,-459,0,87],0],
    [[-24,0,24,0,0,0,204,0,-362,0,162,0,78,0,-50,0,-45,
    0,42,0,-8],0],[[-180,0,270,0,-120,0,15],0],
    [[6,0,-2,0,0,0,-15,0,10,0,23,0,-8,0,-10,0,10,0,-55,
    0,51,0,-25],10],
    [[-9,0,0,0,0,0,105,0,-118,0,3,0,50,0,-23,0,-3,0,4],
    0],[[-24,0,24,0,66,0,-120,0,53,0,-6],0],
    [[-2,0,-3,0,3,0,4,0,-3,0,-6],18],
    [[1,0,0,0,3,0,-11,0,0,0,9,0,1,0,-6],6],
    [[-50,0,184,0,-223,0,108,0,-19,0,1],0],
    [[-255,0,495,0,-285,0,45],0],
    [[5,0,-4,0,0,0,9,0,-5,0,15,0,-26,0,15,0,-9],16],
    [[6,0,-6,0,-4,0,6,0,-27,0,50,0,-30,0,6,0,-1,0,9],
    8],[[-1,0,3,0,-3,0,10],12],
    [[-74,0,301,0,-410,0,235,0,-56,0,4],0],
    [[-24,0,75,0,-71,0,22,0,-2],0],
    [[-57,0,219,0,-283,0,150,0,-30,0,1],0],
    [[3,0,-6,0,6,0,-6,0,3],14],
    [[-8,0,8,0,-2,0,1,0,-2],16],
    [[-2,0,6,0,-9,0,0,0,5,0,-3],4],
    [[-16,0,44,0,-39,0,11],0],
    [[6,0,-14,0,9,0,3,0,-7,0,4,0,-1],6],
    [[-9,0,27,0,-19,0,4],0],
    [[4,0,-5,0,1,0,4,0,-5,0,3,0,1],6],
    [[-1,0,-1,0,1],10],[[3,0,-6,0,4],2],
    [[-30,0,97,0,-101,0,38,0,-4],0],[[-1,0,1],14],
    [[-1,0,3,0,-2,0,19,0,-57,0,56,0,-6,0,-25,0,11,0,3,
    0,-1],0],[[-9,0,0,0,36,0,-38,0,11],0],
    [[-38,0,131,0,-153,0,69,0,-9],0],
    [[2,0,1,0,-6,0,1,0,4,0,-2],6],
    [[-1,0,3,0,4,0,-23,0,23,0,-6],0],
    [[1,0,-2,0,1],2],[[2,0,-5,0,3,0,-1],2],
    [[1,0,-2],6],[[-1,0,8,0,-17,0,12,0,-2],0],
    [[-1,0,1],6],[[2,0,-7,0,5],4],[[-1,0,1],4],
    [[-2,0,17,0,-38,0,32,0,-9],0],[[1,0,-4,0,3],4],
    [[-1,0,8,0,-17,0,12,0,-2],0],[[1,0,-4,0,3],6],
    [[-4,0,30,0,-67,0,60,0,-21,0,2],0],[[-1,0,1],10]
    ],
    [[[3150],0],[[3150],120],[[6,0,0,0,0,0,-208,0,423,
    0,0,0,-556,0,0,0,423,0,-208,0,0,0,0,0,6],0],
    [[795,0,-1560,0,795],0],
    [[-20,0,-24,0,0,0,115,0,-240,0,480,0,-592,0,480,0,
    -240,0,115,0,0,0,-24,0,-20],18],[[30],60],
    [[207,0,-792,0,1152,0,-792,0,207],0],
    [[495,0,-1080,0,495],0],
    [[30,0,-64,0,24,0,0,0,-70,0,0,0,24,0,-64,0,30],56],
    [[45],80],[[45],40],
    [[3,0,-16,0,42,0,0,0,-40,0,0,0,42,0,-16,0,3],16],
    [[18,0,-18,0,18],40],
    [[85,0,-340,0,510,0,-340,0,85],0],
    [[7,0,-16,0,18,0,-16,0,7],40],
    [[6,0,0,0,-141,0,292,0,-141,0,0,0,6],0],
    [[2,0,0,0,-9,0,36,0,-9,0,0,0,2],60],
    [[8,0,-7,0,-26,0,56,0,-26,0,-7,0,8],10],
    [[56,0,-248,0,382,0,-248,0,56],0],
    [[-13,0,43,0,-33,0,-100,0,204,0,-100,0,-33,0,43,0,-13
    ],6],[[-2],30],
    [[5,0,-30,0,72,0,-96,0,72,0,-30,0,5],0],
    [[15,0,-90,0,150,0,-90,0,15],0],[[],0],[[],0],
    [[],0],
    [[1,0,-2,0,1,0,-44,0,144,0,-164,0,-27,0,188,0,-27,0,
    -164,0,144,0,-44,0,1,0,-2,0,1],0],
    [[6,0,-52,0,98,0,-52,0,6],0],
    [[3,0,-4,0,-1,0,-4,0,3],40],
    [[133,0,-516,0,772,0,-516,0,133],0],
    [[-2,0,5,0,-2,0,-34,0,72,0,-34,0,-2,0,5,0,-2],6],
    [[-3],20],[[-1,0,14,0,-32,0,14,0,-1],8],
    [[1,0,-4,0,1,0,-2,0,1,0,-4,0,1],40],
    [[1,0,-23,0,44,0,-23,0,1],10],
    [[1,0,-13,0,34,0,-44,0,34,0,-13,0,1],0],
    [[24,0,-134,0,316,0,-412,0,316,0,-134,0,24],0],
    [[-2,0,10,0,-16,0,10,0,-2],6],[[-1,0,2,0,-1],20],
    [[1,0,-8,0,24,0,-34,0,24,0,-8,0,1],0],
    [[-1,0,5,0,-8,0,5,0,-1],2],[[],0],
    [[-2,0,9,0,-12,0,9,0,-2],2],[[7,0,-12,0,7],6],
    [[2],34],[[2,0,-4,0,2],6],[[],0],[[],0],
    [[],0],[[5,0,-33,0,85,0,-114,0,85,0,-33,0,5],0],
    [[1,0,-2,0,1],4],[[],0],
    [[1,0,-2,0,-23,0,94,0,-142,0,94,0,-23,0,-2,0,1],0],
    [[-2,0,2,0,-2],44],
    [[-1,0,0,0,0,0,3,0,0,0,0,0,-1],20],
    [[-1,0,3,0,-1],20],[[1,0,-4,0,1],4],
    [[-1,0,1,0,-2,0,1,0,-1],20],
    [[11,0,-63,0,151,0,-200,0,151,0,-63,0,11],0],
    [[-8,0,36,0,-58,0,36,0,-8],4],[[1],10],
    [[4,0,-21,0,55,0,-76,0,55,0,-21,0,4],0],[[],0],
    [[],0],[[],0],[[-1575,0,1575],0],
    [[70,0,-405,0,378,0,-210,0,0,0,0,0,210,0,-378,0,405,
    0,-70],54],[[-405,0,1170,0,-1170,0,405],0],
    [[-3,0,3,0,0,0,116,0,-308,0,207,0,278,0,-278,0,-207,
    0,308,0,-116,0,0,0,-3,0,3],0],
    [[-105,0,390,0,-390,0,105],0],
    [[5,0,-4,0,-15,0,35,0,-70,0,96,0,-96,0,70,0,-35,0,
    15,0,4,0,-5],20],
    [[21,0,-65,0,6,0,205,0,-205,0,-6,0,65,0,-21],6],
    [[-3,0,3,0,72,0,-215,0,215,0,-72,0,-3,0,3],0],
    [[-3,0,14,0,-6,0,6,0,-14,0,3],28],
    [[6,0,-3,0,-12,0,12,0,3,0,-6],16],
    [[-30,0,155,0,-310,0,310,0,-155,0,30],0],
    [[-255,0,780,0,-780,0,255],0],
    [[1,0,0,0,0,0,-5,0,-4,0,-1,0,0,0,0,0,1,0,4,0,5,
    0,0,0,0,0,-1],18],
    [[-3,0,8,0,-26,0,24,0,20,0,-20,0,-24,0,26,0,-8,0,3]
    ,16],[[7,0,6,0,-6,0,-7],18],
    [[-69,0,330,0,-636,0,636,0,-330,0,69],0],
    [[-3,0,32,0,-72,0,72,0,-32,0,3],0],
    [[-46,0,213,0,-421,0,421,0,-213,0,46],0],
    [[3,0,-3,0,-6,0,6,0,3,0,-3],18],
    [[-2,0,1,0,6,0,-6,0,-1,0,2],20],
    [[1,0,-6,0,24,0,-24,0,6,0,-1],8],
    [[-1,0,14,0,-35,0,35,0,-14,0,1],0],
    [[12,0,-34,0,34,0,-12],12],
    [[3,0,-14,0,14,0,-3],2],
    [[-1,0,0,0,3,0,-13,0,13,0,-3,0,0,0,1],8],
    [[-1,0,0,0,0,0,1],14],[[1,0,-1],6],
    [[-9,0,53,0,-118,0,118,0,-53,0,9],0],
    [[-2,0,2],14],
    [[6,0,-20,0,24,0,24,0,-101,0,101,0,-24,0,-24,0,20,0,
    -6],6],[[15,0,-58,0,58,0,-15],4],
    [[-20,0,101,0,-204,0,204,0,-101,0,20],0],
    [[4,0,-11,0,11,0,-4],14],
    [[3,0,-14,0,31,0,-31,0,14,0,-3],4],[[],0],
    [[-1,0,2,0,-2,0,1],4],[[-1,0,1],10],
    [[1,0,-3,0,6,0,-6,0,3,0,-1],2],[[1,0,-1],8],
    [[-1,0,3,0,-3,0,1],6],[[1,0,-1],6],
    [[-1,0,7,0,-18,0,30,0,-30,0,18,0,-7,0,1],0],
    [[2,0,-2],8],[[1,0,-4,0,6,0,-6,0,4,0,-1],2],
    [[-1,0,2,0,-2,0,1],8],
    [[-2,0,14,0,-39,0,63,0,-63,0,39,0,-14,0,2],0],
    [[1,0,-1],12]],
    [[[2100],0],[[2100],132],[[2,0,0,0,0,0,-112,0,180,
    0,0,0,-94,0,0,0,378,0,-336,0,0,0,0,0,34],0],
    [[405,0,-1080,0,615],0],
    [[15,0,0,0,20,0,0,0,180,0,-504,0,300,0,0,0,-55,0,0,
    0,-39,0,-20,0,45,0,0,0,10,0,-12],20],
    [[20],66],[[60,0,-412,0,834,0,-636,0,158],0],
    [[270,0,-675,0,480],0],
    [[64,0,0,0,0,0,10,0,0,0,-24,0,64,0,-45,0,0,0,0,0,
    0,0,6],62],[[-60],88],[[-60],44],
    [[-8,0,0,0,0,0,7,0,0,0,12,0,-56,0,36,0,0,0,6,0,0,
    0,-3],18],[[-18,0,36,0,-24],44],
    [[22,0,-166,0,381,0,-316,0,82],0],
    [[-5,0,20,0,-36,0,32,0,-8],44],
    [[2,0,0,0,-60,0,162,0,-126,0,0,0,34],0],
    [[2,0,0,0,0,0,26,0,-18,0,0,0,2],66],
    [[2,0,-3,0,-4,0,4,0,-10,0,-6,0,18,0,-1,0,-4],10],
    [[16,0,-123,0,284,0,-254,0,73],0],
    [[-1,0,14,0,-23,0,-1,0,30,0,-19,0,-63,0,90,0,-29,0,
    0,0,-3,0,1],6],[[],0],
    [[-4,0,38,0,-96,0,93,0,-34,0,3],2],
    [[5,0,-45,0,120,0,-120,0,40],0],[[],0],[[],0],
    [[],0],
    [[2,0,-4,0,41,0,-98,0,67,0,28,0,21,0,-194,0,175,0,
    -44,0,10,0,-11,0,2],4],
    [[2,0,-28,0,71,0,-84,0,34],0],
    [[-1,0,8,0,-10,0,12,0,-5],44],
    [[37,0,-262,0,561,0,-449,0,116],0],
    [[2,0,-6,0,3,0,12,0,-15,0,-6,0,21,0,-8],8],
    [[-4],22],[[-9,0,4,0,8,0,-6,0,1],12],
    [[2,0,-7,0,12,0,-16,0,8,0,-1],46],
    [[-4,0,2,0,-5,0,2,0,11,0,-5],12],
    [[-1,0,17,0,-51,0,56,0,-22,0,2],2],
    [[1,0,-30,0,166,0,-334,0,302,0,-118,0,16],0],
    [[5,0,-18,0,20,0,-2,0,-2],8],[[-1,0,2,0,-2],22],
    [[-1,0,15,0,-44,0,47,0,-18,0,2],2],
    [[4,0,-16,0,18,0,-6],4],[[],0],
    [[4,0,-17,0,22,0,-10,0,1],4],
    [[3,0,-10,0,12,0,-5],6],[[1,0,-1],36],
    [[1,0,-5,0,7,0,-3],6],[[],0],[[],0],
    [[],0],[[-6,0,47,0,-113,0,112,0,-46,0,6],2],
    [[-4,0,6,0,-2],6],[[],0],
    [[-1,0,38,0,-94,0,80,0,-11,0,-11,0,2],4],
    [[2,0,-1,0,2],50],
    [[-1,0,0,0,0,0,2,0,0,0,0,0,-1],22],
    [[-1,0,2,0,-1],22],[[-1,0,2,0,-1],6],
    [[-1,0,1,0,0,0,1,0,-1],22],
    [[-12,0,79,0,-178,0,167,0,-65,0,8],2],
    [[-1,0,15,0,-43,0,43,0,-13,0,-3,0,1],4],[[],0],
    [[-3,0,30,0,-79,0,79,0,-30,0,3],2],[[],0],
    [[],0],[[],0],[[-945,0,1155],0],
    [[336,0,0,0,0,0,84,0,0,0,189,0,-315,0,0,0,-189,0,
    210,0,0,0,0,0,-105],60],
    [[-163,0,726,0,-894,0,317],0],
    [[2,0,0,0,36,0,-139,0,117,0,24,0,-70,0,-189,0,369,0,
    -156,0,0,0,-21,0,13],2],
    [[-50,0,220,0,-320,0,160],0],
    [[5,0,0,0,4,0,0,0,76,0,-121,0,50,0,16,0,-19,0,8,0,
    -9,0,0,0,0,0,-1,0,1],22],
    [[7,0,-27,0,9,0,26,0,-33,0,-9,0,105,0,-72,0,0,0,0,
    0,4],6],
    [[2,0,21,0,-111,0,153,0,-63,0,-21,0,13],2],
    [[1,0,-3,0,3,0,-4,0,-3],36],
    [[3,0,-3,0,0,0,4,0,-3,0,-3,0,4],18],
    [[-4,0,57,0,-204,0,287,0,-166,0,32],0],
    [[-105,0,465,0,-615,0,240],0],
    [[-5,0,35,0,-60,0,26,0,0,0,-11,0,0,0,0,0,-1,0,0,0,
    1],28],
    [[-8,0,0,0,-4,0,3,0,-6,0,38,0,-45,0,15,0,-4,0,2,0,
    3],20],[[-6,0,3,0,-9,0,3,0,3],20],
    [[-11,0,127,0,-411,0,532,0,-290,0,54],0],
    [[11,0,-49,0,86,0,-60,0,13],2],
    [[-6,0,78,0,-273,0,370,0,-203,0,37],0],
    [[-3,0,5,0,-3,0,6,0,-6,0,2,0,2],20],
    [[-1,0,2,0,-3,0,2,0,-1,0,3,0,-6,0,1,0,1],20],
    [[4,0,-7,0,-3,0,7,0,-3],12],
    [[5,0,-29,0,53,0,-34,0,6],2],
    [[2,0,-2,0,4,0,-4,0,-6,0,8,0,-1],12],
    [[1,0,-10,0,21,0,-18,0,4],2],
    [[1,0,-2,0,-1,0,4,0,-3,0,-2,0,1],10],
    [[-1,0,-2,0,1],18],[[3,0,-7,0,4],6],
    [[-1,0,19,0,-83,0,130,0,-81,0,16],0],
    [[1,0,-1,0,0,0,-1,0,1],12],
    [[-2,0,13,0,-16,0,-5,0,22,0,13,0,-56,0,36,0,-5,0,2,
    0,-1],8],[[5,0,-29,0,51,0,-30,0,0,0,4],4],
    [[-2,0,34,0,-137,0,201,0,-115,0,20],0],
    [[1,0,-1,0,0,0,5,0,-4,0,-3,0,3],12],
    [[-3,0,20,0,-33,0,19,0,-1,0,-1],6],[[-2,0,1],8],
    [[-2,0,2],8],[[-2,0,2],12],
    [[-1,0,10,0,-19,0,12,0,-2],4],[[],0],
    [[3,0,-7,0,5,0,-1],8],[[],0],
    [[-5,0,29,0,-48,0,30,0,-6],4],[[1,0,-3,0,2],8],
    [[7,0,-16,0,12,0,-2],6],[[3,0,-6,0,4],10],
    [[-13,0,55,0,-85,0,56,0,-14,0,1],4],
    [[1,0,-2,0,1],12]],
    [[[2100],0],[[2100],108],[[34,0,0,0,0,0,-336,0,378,
    0,0,0,-94,0,0,0,180,0,-112,0,0,0,0,0,2],0],
    [[615,0,-1080,0,405],0],
    [[-12,0,10,0,0,0,45,0,-20,0,-39,0,0,0,-55,0,0,0,
    300,0,-504,0,180,0,0,0,20,0,0,0,15],10],
    [[20],54],[[158,0,-636,0,834,0,-412,0,60],0],
    [[480,0,-675,0,270],0],
    [[6,0,0,0,0,0,0,0,-45,0,64,0,-24,0,0,0,10,0,0,0,
    0,0,64],44],[[-60],72],[[-60],36],
    [[-3,0,0,0,6,0,0,0,36,0,-56,0,12,0,0,0,7,0,0,0,0,
    0,-8],8],[[-24,0,36,0,-18],36],
    [[82,0,-316,0,381,0,-166,0,22],0],
    [[-8,0,32,0,-36,0,20,0,-5],36],
    [[34,0,0,0,-126,0,162,0,-60,0,0,0,2],0],
    [[2,0,0,0,-18,0,26,0,0,0,0,0,2],54],
    [[-4,0,-1,0,18,0,-6,0,-10,0,4,0,-4,0,-3,0,2],6],
    [[73,0,-254,0,284,0,-123,0,16],0],
    [[1,0,-3,0,0,0,-29,0,90,0,-63,0,-19,0,30,0,-1,0,
    -23,0,14,0,-1],0],[[],0],
    [[3,0,-34,0,93,0,-96,0,38,0,-4],0],
    [[40,0,-120,0,120,0,-45,0,5],0],[[],0],[[],0],
    [[],0],
    [[2,0,-11,0,10,0,-44,0,175,0,-194,0,21,0,28,0,67,0,
    -98,0,41,0,-4,0,2],0],
    [[34,0,-84,0,71,0,-28,0,2],0],
    [[-5,0,12,0,-10,0,8,0,-1],36],
    [[116,0,-449,0,561,0,-262,0,37],0],
    [[-8,0,21,0,-6,0,-15,0,12,0,3,0,-6,0,2],6],
    [[-4],18],[[1,0,-6,0,8,0,4,0,-9],4],
    [[-1,0,8,0,-16,0,12,0,-7,0,2],36],
    [[-5,0,11,0,2,0,-5,0,2,0,-4],6],
    [[2,0,-22,0,56,0,-51,0,17,0,-1],0],
    [[16,0,-118,0,302,0,-334,0,166,0,-30,0,1],0],
    [[-2,0,-2,0,20,0,-18,0,5],4],[[-2,0,2,0,-1],18],
    [[2,0,-18,0,47,0,-44,0,15,0,-1],0],
    [[-6,0,18,0,-16,0,4],2],[[],0],
    [[1,0,-10,0,22,0,-17,0,4],0],
    [[-5,0,12,0,-10,0,3],4],[[-1,0,1],30],
    [[-3,0,7,0,-5,0,1],4],[[],0],[[],0],
    [[],0],[[6,0,-46,0,112,0,-113,0,47,0,-6],0],
    [[-2,0,6,0,-4],2],[[],0],
    [[2,0,-11,0,-11,0,80,0,-94,0,38,0,-1],0],
    [[2,0,-1,0,2],38],
    [[-1,0,0,0,0,0,2,0,0,0,0,0,-1],18],
    [[-1,0,2,0,-1],18],[[-1,0,2,0,-1],2],
    [[-1,0,1,0,0,0,1,0,-1],18],
    [[8,0,-65,0,167,0,-178,0,79,0,-12],0],
    [[1,0,-3,0,-13,0,43,0,-43,0,15,0,-1],0],[[],0],
    [[3,0,-30,0,79,0,-79,0,30,0,-3],0],[[],0],
    [[],0],[[],0],[[-1155,0,945],0],
    [[105,0,0,0,0,0,-210,0,189,0,0,0,315,0,-189,0,0,0,
    -84,0,0,0,0,0,-336],42],
    [[-317,0,894,0,-726,0,163],0],
    [[-13,0,21,0,0,0,156,0,-369,0,189,0,70,0,-24,0,-117,
    0,139,0,-36,0,0,0,-2],0],
    [[-160,0,320,0,-220,0,50],0],
    [[-1,0,1,0,0,0,0,0,9,0,-8,0,19,0,-16,0,-50,0,121,
    0,-76,0,0,0,-4,0,0,0,-5],12],
    [[-4,0,0,0,0,0,72,0,-105,0,9,0,33,0,-26,0,-9,0,27,
    0,-7],0],
    [[-13,0,21,0,63,0,-153,0,111,0,-21,0,-2],0],
    [[3,0,4,0,-3,0,3,0,-1],22],
    [[-4,0,3,0,3,0,-4,0,0,0,3,0,-3],12],
    [[-32,0,166,0,-287,0,204,0,-57,0,4],0],
    [[-240,0,615,0,-465,0,105],0],
    [[-1,0,0,0,1,0,0,0,0,0,11,0,0,0,-26,0,60,0,-35,0,
    5],14],
    [[-3,0,-2,0,4,0,-15,0,45,0,-38,0,6,0,-3,0,4,0,0,0,
    8],10],[[-3,0,-3,0,9,0,-3,0,6],14],
    [[-54,0,290,0,-532,0,411,0,-127,0,11],0],
    [[-13,0,60,0,-86,0,49,0,-11],0],
    [[-37,0,203,0,-370,0,273,0,-78,0,6],0],
    [[-2,0,-2,0,6,0,-6,0,3,0,-5,0,3],14],
    [[-1,0,-1,0,6,0,-3,0,1,0,-2,0,3,0,-2,0,1],14],
    [[3,0,-7,0,3,0,7,0,-4],6],
    [[-6,0,34,0,-53,0,29,0,-5],0],
    [[1,0,-8,0,6,0,4,0,-4,0,2,0,-2],6],
    [[-4,0,18,0,-21,0,10,0,-1],0],
    [[-1,0,2,0,3,0,-4,0,1,0,2,0,-1],8],
    [[-1,0,2,0,1],12],[[-4,0,7,0,-3],4],
    [[-16,0,81,0,-130,0,83,0,-19,0,1],0],
    [[-1,0,1,0,0,0,1,0,-1],10],
    [[1,0,-2,0,5,0,-36,0,56,0,-13,0,-22,0,5,0,16,0,-13,
    0,2],2],[[-4,0,0,0,30,0,-51,0,29,0,-5],0],
    [[-20,0,115,0,-201,0,137,0,-34,0,2],0],
    [[-3,0,3,0,4,0,-5,0,0,0,1,0,-1],10],
    [[1,0,1,0,-19,0,33,0,-20,0,3],2],[[-1,0,2],4],
    [[-2,0,2],4],[[-2,0,2],8],
    [[2,0,-12,0,19,0,-10,0,1],2],[[],0],
    [[1,0,-5,0,7,0,-3],4],[[],0],
    [[6,0,-30,0,48,0,-29,0,5],2],[[-2,0,3,0,-1],6],
    [[2,0,-12,0,16,0,-7],2],[[-4,0,6,0,-3],8],
    [[-1,0,14,0,-56,0,85,0,-55,0,13],0],
    [[-1,0,2,0,-1],10]],
    [[[4200],0],[[4200],120],[[9,0,0,0,0,0,-256,0,603,
    0,0,0,-608,0,0,0,603,0,-256,0,0,0,0,0,9],0],
    [[1060,0,-2080,0,1060],0],
    [[15,0,-20,0,-21,0,0,0,145,0,-240,0,585,0,-888,0,585,
    0,-240,0,145,0,0,0,-21,0,-20,0,15],16],
    [[-40],60],[[278,0,-1048,0,1548,0,-1048,0,278],0],
    [[660,0,-1440,0,660],0],
    [[-15,0,0,0,0,0,0,0,-90,0,0,0,0,0,0,0,-15],56],
    [[15],80],[[15],40],
    [[-6,0,-24,0,54,0,0,0,-60,0,0,0,54,0,-24,0,-6],16],
    [[3,0,-18,0,3],40],
    [[114,0,-452,0,682,0,-452,0,114],0],
    [[-8,0,22,0,-8],42],
    [[9,0,0,0,-201,0,408,0,-201,0,0,0,9],0],
    [[-3,0,0,0,27,0,-24,0,27,0,0,0,-3],60],
    [[-1,0,10,0,-16,0,-26,0,58,0,-26,0,-16,0,10,0,-1],8
    ],[[75,0,-330,0,510,0,-330,0,75],0],
    [[-15,0,64,0,-51,0,-118,0,240,0,-118,0,-51,0,64,0,-15
    ],6],[[-4],30],
    [[7,0,-40,0,97,0,-128,0,97,0,-40,0,7],0],
    [[20,0,-120,0,200,0,-120,0,20],0],[[],0],
    [[],0],[[],0],
    [[3,0,-3,0,0,0,-48,0,196,0,-239,0,-11,0,212,0,-11,0,
    -239,0,196,0,-48,0,0,0,-3,0,3],0],
    [[9,0,-64,0,118,0,-64,0,9],0],[[-4,0,7,0,-4],42],
    [[176,0,-692,0,1024,0,-692,0,176],0],
    [[-2,0,12,0,-8,0,-50,0,88,0,-50,0,-8,0,12,0,-2],6],
    [[-1],20],[[2,0,18,0,-44,0,18,0,2],8],
    [[5,0,-14,0,5],44],
    [[2,0,3,0,-30,0,52,0,-30,0,3,0,2],8],
    [[3,0,-15,0,41,0,-56,0,41,0,-15,0,3],0],
    [[31,0,-178,0,422,0,-552,0,422,0,-178,0,31],0],
    [[-2,0,19,0,-36,0,19,0,-2],6],[[2],22],
    [[1,0,-11,0,33,0,-44,0,33,0,-11,0,1],0],
    [[-2,0,7,0,-10,0,7,0,-2],2],[[],0],
    [[-2,0,6,0,-8,0,6,0,-2],2],
    [[-1,0,8,0,-14,0,8,0,-1],4],
    [[-1,0,0,0,2,0,0,0,-1],30],[[3,0,-6,0,3],6],
    [[],0],[[],0],[[],0],
    [[6,0,-44,0,114,0,-152,0,114,0,-44,0,6],0],
    [[-1,0,2,0,-1],4],[[],0],
    [[3,0,-3,0,-36,0,133,0,-194,0,133,0,-36,0,-3,0,3],0
    ],[[1,0,-2,0,1],44],[[3],26],[[3],22],
    [[-2,0,4,0,-2],4],[[1,0,-2,0,1],22],
    [[14,0,-84,0,203,0,-266,0,203,0,-84,0,14],0],
    [[-13,0,54,0,-82,0,54,0,-13],4],[[-1],10],
    [[4,0,-30,0,75,0,-98,0,75,0,-30,0,4],0],[[],0],
    [[],0],[[],0],[[-2100,0,2100],0],
    [[-280,0,216,0,378,0,-714,0,0,0,0,0,714,0,-378,0,
    -216,0,280],54],[[-540,0,1560,0,-1560,0,540],0]
    ,
    [[-6,0,3,0,0,0,136,0,-435,0,288,0,304,0,-304,0,-288,
    0,435,0,-136,0,0,0,-3,0,6],0],
    [[-140,0,520,0,-520,0,140],0],
    [[5,0,0,0,-35,0,25,0,-50,0,155,0,-155,0,50,0,-25,0,
    35,0,0,0,-5],20],
    [[26,0,-98,0,12,0,244,0,-244,0,-12,0,98,0,-26],6],
    [[-6,0,3,0,105,0,-300,0,300,0,-105,0,-3,0,6],0],
    [[6,0,-6,0,6,0,-6],30],
    [[6,0,-4,0,-6,0,6,0,4,0,-6],16],
    [[-40,0,206,0,-414,0,414,0,-206,0,40],0],
    [[-340,0,1040,0,-1040,0,340],0],
    [[1,0,0,0,0,0,-5,0,1,0,4,0,45,0,-45,0,-4,0,-1,0,
    5,0,0,0,0,0,-1],18],
    [[3,0,13,0,-38,0,24,0,30,0,-30,0,-24,0,38,0,-13,0,
    -3],16],[[8,0,6,0,-6,0,-8],18],
    [[-92,0,438,0,-850,0,850,0,-438,0,92],0],
    [[-6,0,37,0,-89,0,89,0,-37,0,6],0],
    [[-59,0,289,0,-559,0,559,0,-289,0,59],0],
    [[4,0,-4,0,-9,0,9,0,4,0,-4],18],
    [[1,0,-3,0,-1,0,9,0,-9,0,1,0,3,0,-1],18],
    [[-1,0,-9,0,30,0,-30,0,9,0,1],8],
    [[-2,0,18,0,-47,0,47,0,-18,0,2],0],
    [[-1,0,-1,0,17,0,-40,0,40,0,-17,0,1,0,1],8],
    [[3,0,-9,0,9,0,-3],2],
    [[-1,0,2,0,4,0,-15,0,15,0,-4,0,-2,0,1],8],
    [[],0],[[-1,0,1,0,-1,0,1],4],
    [[-11,0,73,0,-156,0,156,0,-73,0,11],0],
    [[1,0,-3,0,3,0,-1],12],
    [[6,0,-28,0,38,0,24,0,-118,0,118,0,-24,0,-38,0,28,0,
    -6],6],[[23,0,-85,0,85,0,-23],4],
    [[-27,0,135,0,-272,0,272,0,-135,0,27],0],
    [[-1,0,3,0,4,0,-16,0,16,0,-4,0,-3,0,1],10],
    [[5,0,-23,0,43,0,-43,0,23,0,-5],4],[[-1,0,1],6],
    [[1,0,-3,0,3,0,-1],4],[[],0],
    [[1,0,-5,0,8,0,-8,0,5,0,-1],2],[[-1,0,1],8],
    [[-2,0,4,0,-4,0,2],6],[[-1,0,1],6],
    [[-1,0,9,0,-26,0,40,0,-40,0,26,0,-9,0,1],0],
    [[],0],[[1,0,-3,0,4,0,-4,0,3,0,-1],2],
    [[-2,0,6,0,-6,0,2],8],
    [[-2,0,18,0,-53,0,85,0,-85,0,53,0,-18,0,2],0],
    [[3,0,-3],12]],
    [[[2240],0],[[2240],138],[[-32,0,108,0,0,0,-360,0,0,
    0,540,0,-352,0,0,0,0,0,32],6],
    [[408,0,-1088,0,744],0],
    [[-60,0,150,0,-296,0,360,0,-240,0,220,0,0,0,-78,0,
    -80,0,90,0,0,0,10,0,-12],26],[[],0],
    [[76,0,-400,0,792,0,-720,0,252],0],
    [[204,0,-748,0,540],0],
    [[-20,0,0,0,-24,0,64,0,-30,0,0,0,0,0,0,0,6],70],
    [[-40],92],[[-40],46],
    [[-29,0,0,0,66,0,-56,0,6,0,0,0,6,0,0,0,-3],24],
    [[-12,0,20,0,-18],46],
    [[20,0,-138,0,342,0,-358,0,136],0],
    [[-4,0,12,0,-18,0,20,0,-8],46],
    [[-36,0,184,0,-180,0,0,0,32],4],[[],0],
    [[-4,0,30,0,-32,0,-14,0,28,0,-4,0,-4],14],
    [[9,0,-91,0,256,0,-281,0,107],0],
    [[2,0,-4,0,-38,0,124,0,-93,0,-59,0,114,0,-48,0,0,0,
    -1,0,3],8],[[],0],
    [[-4,0,22,0,-60,0,84,0,-60,0,18],2],
    [[-20,0,95,0,-130,0,50],2],[[-5],34],[[],0],
    [[],0],
    [[-4,0,21,0,-40,0,-17,0,118,0,-35,0,-208,0,251,0,-92,
    0,2,0,-10,0,10],6],[[-8,0,60,0,-88,0,32],2],
    [[4,0,0,0,8,0,-4],48],
    [[39,0,-237,0,524,0,-507,0,185],0],
    [[-1,0,-6,0,42,0,-46,0,-1,0,30,0,-14],10],
    [[],0],[[-13,0,22,0,-2,0,-6,0,1],12],
    [[2,0,1,0,2,0,-7,0,6,0,-2],48],
    [[-3,0,23,0,-30,0,2,0,9,0,-5],12],
    [[-1,0,10,0,-28,0,44,0,-33,0,10],2],
    [[4,0,-36,0,138,0,-274,0,306,0,-188,0,48],0],
    [[-8,0,16,0,-8,0,-2],10],[[],0],
    [[5,0,-21,0,35,0,-27,0,8],4],
    [[-4,0,10,0,-9,0,3],6],[[],0],
    [[2,0,-8,0,14,0,-11,0,3],4],[[-6,0,14,0,-8],8],
    [[],0],[[-2,0,7,0,-3],8],[[2],18],[[-1],32],
    [[-1],16],[[-4,0,28,0,-75,0,100,0,-69,0,19],2],
    [[-1,0,2,0,-2],6],[[],0],
    [[-3,0,28,0,-86,0,104,0,-43,0,-10,0,10],4],
    [[-4,0,2,0,2],52],[[],0],[[],0],
    [[-1,0,2,0,-1],6],[[],0],
    [[1,0,-12,0,57,0,-130,0,161,0,-106,0,29],0],
    [[7,0,-34,0,50,0,-25,0,-1,0,3],6],[[],0],
    [[-2,0,16,0,-47,0,68,0,-49,0,15],2],[[1],30],
    [[],0],[[],0],[[-952,0,1288],0],
    [[210,0,-378,0,405,0,-105,0,0,0,0,0,273,0,-189,0,0,
    0,120],66],[[-176,0,696,0,-936,0,432],0],
    [[16,0,-61,0,63,0,162,0,-198,0,-225,0,459,0,-208,0,0,
    0,-12,0,20],6],[[-20,0,184,0,-360,0,180],0],
    [[-15,0,30,0,-66,0,55,0,-50,0,50,0,4,0,-24,0,-20,0,
    20,0,0,0,1,0,-1],28],
    [[-5,0,3,0,90,0,-168,0,-3,0,141,0,-78,0,0,0,0,0,4],
    8],[[15,0,-99,0,181,0,-105,0,-12,0,20],4],
    [[6,0,-15,0,9,0,3,0,-3],34],
    [[-3,0,9,0,0,0,-12,0,0,0,9,0,-3],20],
    [[-4,0,45,0,-161,0,263,0,-207,0,64],0],
    [[-89,0,434,0,-654,0,315],0],
    [[-5,0,-15,0,6,0,-2,0,41,0,-19,0,-5,0,4,0,2,0,-1],
    30],
    [[13,0,-16,0,-30,0,60,0,-35,0,3,0,-2,0,4,0,0,0,-3],
    24],[[-6,0,-6,0,12,0,-6],22],
    [[-17,0,125,0,-359,0,511,0,-371,0,109],0],
    [[4,0,-31,0,69,0,-64,0,20],2],
    [[-9,0,71,0,-225,0,345,0,-263,0,81],0],
    [[-2,0,5,0,4,0,-13,0,9,0,-3],22],
    [[2,0,-6,0,-1,0,7,0,-6,0,3,0,-1],24],
    [[5,0,-18,0,13,0,1,0,-4,0,1],12],
    [[-11,0,35,0,-38,0,12],4],
    [[1,0,-12,0,26,0,-18,0,-2,0,7,0,-4],12],
    [[-3,0,15,0,-16,0,4],4],
    [[-3,0,13,0,-13,0,0,0,5,0,-2],14],
    [[1,0,0,0,-1],18],[[-1,0,2,0,-2,0,1],8],
    [[9,0,-52,0,108,0,-95,0,31],2],[[3,0,-2],16],
    [[2,0,9,0,-46,0,77,0,-27,0,-53,0,62,0,-23,0,0,0,-1,
    0,2],10],[[-17,0,57,0,-42,0,0,0,4],6],
    [[-2,0,25,0,-98,0,176,0,-147,0,48],0],
    [[-3,0,9,0,-5,0,-4,0,7,0,-2],16],
    [[-1,0,11,0,-26,0,28,0,-11,0,-1,0,2],6],[[],0],
    [[1,0,-1,0,1,0,-1],6],[[],0],
    [[2,0,-6,0,9,0,-7,0,2],6],[[-1,0,1],10],
    [[1,0,-4,0,5,0,-2],8],[[],0],
    [[-3,0,12,0,-26,0,31,0,-21,0,6],4],
    [[-2,0,2,0,-1],10],
    [[-1,0,3,0,-6,0,8,0,-6,0,2],4],
    [[-2,0,4,0,-2],12],
    [[1,0,-8,0,30,0,-54,0,59,0,-36,0,9],2],
    [[-1,0,2],14]],
    [[[2240],0],[[2240],102],[[32,0,0,0,0,0,-352,0,540,
    0,0,0,-360,0,0,0,108,0,-32],0],
    [[744,0,-1088,0,408],0],
    [[-12,0,10,0,0,0,90,0,-80,0,-78,0,0,0,220,0,-240,0,
    360,0,-296,0,150,0,-60],10],[[],0],
    [[252,0,-720,0,792,0,-400,0,76],0],
    [[540,0,-748,0,204],0],
    [[6,0,0,0,0,0,0,0,-30,0,64,0,-24,0,0,0,-20],42],
    [[-40],68],[[-40],34],
    [[-3,0,0,0,6,0,0,0,6,0,-56,0,66,0,0,0,-29],8],
    [[-18,0,20,0,-12],34],
    [[136,0,-358,0,342,0,-138,0,20],0],
    [[-8,0,20,0,-18,0,12,0,-4],34],
    [[32,0,0,0,-180,0,184,0,-36],0],[[],0],
    [[-4,0,-4,0,28,0,-14,0,-32,0,30,0,-4],6],
    [[107,0,-281,0,256,0,-91,0,9],0],
    [[3,0,-1,0,0,0,-48,0,114,0,-59,0,-93,0,124,0,-38,0,
    -4,0,2],0],[[],0],
    [[18,0,-60,0,84,0,-60,0,22,0,-4],0],
    [[50,0,-130,0,95,0,-20],0],[[-5],30],[[],0],
    [[],0],
    [[10,0,-10,0,2,0,-92,0,251,0,-208,0,-35,0,118,0,-17,
    0,-40,0,21,0,-4],0],[[32,0,-88,0,60,0,-8],0]
    ,[[-4,0,8,0,0,0,4],34],
    [[185,0,-507,0,524,0,-237,0,39],0],
    [[-14,0,30,0,-1,0,-46,0,42,0,-6,0,-1],6],[[],0],
    [[1,0,-6,0,-2,0,22,0,-13],4],
    [[-2,0,6,0,-7,0,2,0,1,0,2],34],
    [[-5,0,9,0,2,0,-30,0,23,0,-3],6],
    [[10,0,-33,0,44,0,-28,0,10,0,-1],0],
    [[48,0,-188,0,306,0,-274,0,138,0,-36,0,4],0],
    [[-2,0,-8,0,16,0,-8],4],[[],0],
    [[8,0,-27,0,35,0,-21,0,5],0],
    [[3,0,-9,0,10,0,-4],0],[[],0],
    [[3,0,-11,0,14,0,-8,0,2],0],[[-8,0,14,0,-6],4],
    [[],0],[[-3,0,7,0,-2],4],[[2],14],[[-1],24],
    [[-1],12],[[19,0,-69,0,100,0,-75,0,28,0,-4],0],
    [[-2,0,2,0,-1],2],[[],0],
    [[10,0,-10,0,-43,0,104,0,-86,0,28,0,-3],0],
    [[2,0,2,0,-4],36],[[],0],[[],0],
    [[-1,0,2,0,-1],2],[[],0],
    [[29,0,-106,0,161,0,-130,0,57,0,-12,0,1],0],
    [[3,0,-1,0,-25,0,50,0,-34,0,7],0],[[],0],
    [[15,0,-49,0,68,0,-47,0,16,0,-2],0],[[1],22],
    [[],0],[[],0],[[-1288,0,952],0],
    [[-120,0,0,0,189,0,-273,0,0,0,0,0,105,0,-405,0,378,
    0,-210],42],[[-432,0,936,0,-696,0,176],0],
    [[-20,0,12,0,0,0,208,0,-459,0,225,0,198,0,-162,0,-63,
    0,61,0,-16],0],[[-180,0,360,0,-184,0,20],0],
    [[1,0,-1,0,0,0,-20,0,20,0,24,0,-4,0,-50,0,50,0,-55,
    0,66,0,-30,0,15],10],
    [[-4,0,0,0,0,0,78,0,-141,0,3,0,168,0,-90,0,-3,0,5],
    0],[[-20,0,12,0,105,0,-181,0,99,0,-15],0],
    [[3,0,-3,0,-9,0,15,0,-6],24],
    [[3,0,-9,0,0,0,12,0,0,0,-9,0,3],10],
    [[-64,0,207,0,-263,0,161,0,-45,0,4],0],
    [[-315,0,654,0,-434,0,89],0],
    [[1,0,-2,0,-4,0,5,0,19,0,-41,0,2,0,-6,0,15,0,5],
    14],
    [[3,0,0,0,-4,0,2,0,-3,0,35,0,-60,0,30,0,16,0,-13],
    8],[[6,0,-12,0,6,0,6],14],
    [[-109,0,371,0,-511,0,359,0,-125,0,17],0],
    [[-20,0,64,0,-69,0,31,0,-4],0],
    [[-81,0,263,0,-345,0,225,0,-71,0,9],0],
    [[3,0,-9,0,13,0,-4,0,-5,0,2],14],
    [[1,0,-3,0,6,0,-7,0,1,0,6,0,-2],14],
    [[-1,0,4,0,-1,0,-13,0,18,0,-5],4],
    [[-12,0,38,0,-35,0,11],0],
    [[4,0,-7,0,2,0,18,0,-26,0,12,0,-1],6],
    [[-4,0,16,0,-15,0,3],0],
    [[2,0,-5,0,0,0,13,0,-13,0,3],6],
    [[1,0,0,0,-1],12],[[-1,0,2,0,-2,0,1],0],
    [[-31,0,95,0,-108,0,52,0,-9],0],[[2,0,-3],12],
    [[-2,0,1,0,0,0,23,0,-62,0,53,0,27,0,-77,0,46,0,-9,
    0,-2],0],[[-4,0,0,0,42,0,-57,0,17],0],
    [[-48,0,147,0,-176,0,98,0,-25,0,2],0],
    [[2,0,-7,0,4,0,5,0,-9,0,3],8],
    [[-2,0,1,0,11,0,-28,0,26,0,-11,0,1],0],[[],0],
    [[1,0,-1,0,1,0,-1],2],[[],0],
    [[-2,0,7,0,-9,0,6,0,-2],0],[[-1,0,1],6],
    [[2,0,-5,0,4,0,-1],4],[[],0],
    [[-6,0,21,0,-31,0,26,0,-12,0,3],0],
    [[1,0,-2,0,2],4],[[-2,0,6,0,-8,0,6,0,-3,0,1],0]
    ,[[2,0,-4,0,2],6],
    [[-9,0,36,0,-59,0,54,0,-30,0,8,0,-1],0],
    [[-2,0,1],10]],
    [[[4480],0],[[4480],120],[[12,0,0,0,0,0,-320,0,612,
    0,0,0,-736,0,0,0,612,0,-320,0,0,0,0,0,12],0],
    [[1120,0,-2240,0,1120],0],
    [[15,0,-20,0,-72,0,0,0,180,0,-240,0,645,0,-1016,0,
    645,0,-240,0,180,0,0,0,-72,0,-20,0,15],16],
    [[64],60],[[280,0,-1120,0,1680,0,-1120,0,280],0],
    [[720,0,-1520,0,720],0],
    [[-30,0,64,0,-24,0,0,0,-100,0,0,0,-24,0,64,0,-30],
    56],[[-44],80],[[-44],40],
    [[6,0,-32,0,48,0,0,0,-64,0,0,0,48,0,-32,0,6],16],
    [[-18,0,16,0,-18],40],
    [[116,0,-488,0,748,0,-488,0,116],0],
    [[-7,0,16,0,-14,0,16,0,-7],40],
    [[12,0,0,0,-204,0,384,0,-204,0,0,0,12],0],
    [[4,0,0,0,-36,0,64,0,-36,0,0,0,4],60],
    [[-1,0,8,0,-12,0,-32,0,74,0,-32,0,-12,0,8,0,-1],8],
    [[80,0,-360,0,560,0,-360,0,80],0],
    [[-18,0,66,0,-54,0,-122,0,256,0,-122,0,-54,0,66,0,-18
    ],6],[[],0],
    [[6,0,-40,0,110,0,-152,0,110,0,-40,0,6],0],
    [[24,0,-136,0,224,0,-136,0,24],0],
    [[-1,0,0,0,4,0,0,0,-6,0,0,0,4,0,0,0,-1],24],
    [[-5],48],[[-5],24],
    [[2,0,-4,0,2,0,-52,0,207,0,-259,0,-15,0,254,0,-15,0,
    -259,0,207,0,-52,0,2,0,-4,0,2],0],
    [[12,0,-80,0,152,0,-80,0,12],0],
    [[-3,0,4,0,2,0,4,0,-3],40],
    [[180,0,-740,0,1120,0,-740,0,180],0],
    [[-2,0,10,0,-4,0,-46,0,84,0,-46,0,-4,0,10,0,-2],6],
    [[4],20],[[-2,0,16,0,-24,0,16,0,-2],8],
    [[-1,0,4,0,-1,0,0,0,-1,0,4,0,-1],40],
    [[2,0,-22,0,44,0,-22,0,2],10],
    [[2,0,-17,0,53,0,-78,0,53,0,-17,0,2],0],
    [[29,0,-180,0,460,0,-618,0,460,0,-180,0,29],0],
    [[-2,0,15,0,-26,0,15,0,-2],6],[[1,0,-4,0,1],20],
    [[1,0,-12,0,40,0,-58,0,40,0,-12,0,1],0],
    [[-2,0,10,0,-16,0,10,0,-2],2],[[],0],
    [[-3,0,16,0,-26,0,16,0,-3],2],
    [[-1,0,10,0,-18,0,10,0,-1],4],[[],0],
    [[4,0,-10,0,4],6],[[-2],16],[[1],28],
    [[1],14],
    [[6,0,-46,0,130,0,-180,0,130,0,-46,0,6],0],
    [[3,0,-6,0,3],4],[[-1],12],
    [[2,0,-4,0,-31,0,131,0,-196,0,131,0,-31,0,-4,0,2],0
    ],[[2,0,-4,0,2],44],
    [[1,0,0,0,0,0,-2,0,0,0,0,0,1],20],
    [[1,0,-2,0,1],20],[[2,0,-4,0,2],4],
    [[1,0,-1,0,0,0,-1,0,1],20],
    [[13,0,-85,0,225,0,-306,0,225,0,-85,0,13],0],
    [[-12,0,52,0,-80,0,52,0,-12],4],[[],0],
    [[4,0,-30,0,86,0,-120,0,86,0,-30,0,4],0],
    [[-1,0,2,0,-1],24],[[1],16],[[1],8],
    [[-2240,0,2240],0],
    [[315,0,-405,0,378,0,-630,0,0,0,0,0,630,0,-378,0,405,
    0,-315],54],[[-560,0,1680,0,-1680,0,560],0],
    [[-6,0,6,0,0,0,160,0,-466,0,306,0,368,0,-368,0,-306,
    0,466,0,-160,0,0,0,-6,0,6],0],
    [[-160,0,560,0,-560,0,160],0],
    [[9,0,-9,0,-35,0,35,0,-70,0,182,0,-182,0,70,0,-35,0,
    35,0,9,0,-9],20],
    [[36,0,-96,0,12,0,256,0,-256,0,-12,0,96,0,-36],6],
    [[-6,0,6,0,102,0,-294,0,294,0,-102,0,-6,0,6],0],
    [[-9,0,17,0,-6,0,6,0,-17,0,9],28],
    [[6,0,-5,0,-15,0,15,0,5,0,-6],16],
    [[-40,0,220,0,-460,0,460,0,-220,0,40],0],
    [[-360,0,1120,0,-1120,0,360],0],
    [[-1,0,0,0,5,0,-5,0,-19,0,36,0,-10,0,10,0,-36,0,19,
    0,5,0,-5,0,0,0,1],18],
    [[-3,0,19,0,-40,0,24,0,32,0,-32,0,-24,0,40,0,-19,0,
    3],16],[[-9,0,9,0,-9,0,9],18],
    [[-90,0,460,0,-930,0,930,0,-460,0,90],0],
    [[-6,0,46,0,-116,0,116,0,-46,0,6],0],
    [[-58,0,302,0,-618,0,618,0,-302,0,58],0],
    [[-3,0,8,0,-15,0,15,0,-8,0,3],18],
    [[2,0,-3,0,9,0,-9,0,3,0,-2],20],
    [[1,0,-9,0,20,0,-20,0,9,0,-1],8],
    [[-2,0,22,0,-58,0,58,0,-22,0,2],0],
    [[-1,0,12,0,-33,0,33,0,-12,0,1],10],
    [[6,0,-26,0,26,0,-6],2],
    [[-1,0,1,0,3,0,-15,0,15,0,-3,0,-1,0,1],8],
    [[-1,0,-1,0,1,0,1],14],[[-1,0,3,0,-3,0,1],4],
    [[-12,0,80,0,-180,0,180,0,-80,0,12],0],
    [[-2,0,2],14],
    [[6,0,-28,0,40,0,20,0,-126,0,126,0,-20,0,-40,0,28,0,
    -6],6],[[24,0,-80,0,80,0,-24],4],
    [[-26,0,144,0,-306,0,306,0,-144,0,26],0],
    [[1,0,5,0,-16,0,16,0,-5,0,-1],12],
    [[4,0,-21,0,44,0,-44,0,21,0,-4],4],[[1,0,-1],6],
    [[-1,0,3,0,-3,0,1],4],[[2,0,-2],10],
    [[1,0,-6,0,13,0,-13,0,6,0,-1],2],[[1,0,-1],8],
    [[-2,0,7,0,-7,0,2],6],[[],0],
    [[-1,0,8,0,-28,0,51,0,-51,0,28,0,-8,0,1],0],
    [[-1,0,3,0,-3,0,1],6],
    [[1,0,-6,0,14,0,-14,0,6,0,-1],2],
    [[-1,0,4,0,-4,0,1],8],
    [[-2,0,17,0,-58,0,103,0,-103,0,58,0,-17,0,2],0],
    [[1,0,-1],12]],
    [[[2268],0],[[2268],140],[[-48,0,126,0,0,0,-258,0,0,
    0,522,0,-432,0,0,0,0,0,54],6],
    [[381,0,-1128,0,759],0],
    [[45,0,0,0,120,0,-424,0,315,0,-60,0,115,0,0,0,-141,
    0,-60,0,105,0,0,0,20,0,-24,0,0,0,0,0,0,0,0,0,
    1],24],[[-36],70],
    [[54,0,-372,0,846,0,-756,0,240],0],
    [[216,0,-729,0,594],0],[[81],68],[[],0],
    [[],0],
    [[-3,0,0,0,36,0,-72,0,36,0,0,0,12,0,0,0,-9],24],
    [[],0],[[15,0,-132,0,372,0,-390,0,135],0],
    [[],0],[[-42,0,150,0,-174,0,0,0,54],4],
    [[18,0,-42,0,18,0,0,0,-6],74],
    [[-1,0,-2,0,23,0,-22,0,-10,0,26,0,-3,0,-8,0,0,0,0,
    0,1],12],[[8,0,-91,0,278,0,-316,0,117],0],
    [[2,0,-9,0,-15,0,71,0,-61,0,-73,0,137,0,-55,0,0,0,
    -5,0,4],8],[[],0],
    [[-2,0,23,0,-80,0,108,0,-62,0,13],2],
    [[1,0,-25,0,110,0,-154,0,66],0],
    [[1,0,0,0,0,0,0,0,0,0,0,0,-4,0,0,0,1],28],
    [[3],56],[[3],28],
    [[21,0,-60,0,33,0,84,0,-24,0,-231,0,270,0,-84,0,9,0,
    -18,0,9],8],[[-12,0,75,0,-108,0,54],2],
    [[],0],[[28,0,-225,0,559,0,-546,0,181],0],
    [[-2,0,0,0,18,0,-37,0,-2,0,37,0,-18,0,0,0,0,0,1],
    10],[[],0],[[-3,0,12,0,0,0,-12,0,3],12],
    [[],0],[[9,0,-15,0,3,0,15,0,-12],14],
    [[9,0,-45,0,66,0,-39,0,9],4],
    [[1,0,-22,0,131,0,-314,0,351,0,-186,0,39],0],
    [[-10,0,19,0,-6,0,-4,0,0,0,1],10],[[],0],
    [[7,0,-34,0,54,0,-34,0,7],4],
    [[1,0,-10,0,20,0,-13,0,2],4],[[],0],
    [[2,0,-17,0,29,0,-18,0,4],4],
    [[1,0,-7,0,16,0,-11,0,0,0,1],6],[[-1,0,1],38],
    [[-3,0,9,0,-6],8],[[],0],[[],0],[[],0],
    [[-2,0,30,0,-98,0,132,0,-77,0,17],2],
    [[-4,0,9,0,-4,0,1],6],[[-1],14],
    [[-3,0,24,0,-81,0,99,0,-33,0,-18,0,9],4],
    [[-3],52],[[],0],[[],0],[[-3,0,6,0,-3],6],
    [[],0],[[-7,0,56,0,-159,0,195,0,-109,0,23],2],
    [[7,0,-33,0,52,0,-26,0,-5,0,4],6],[[],0],
    [[-1,0,18,0,-64,0,92,0,-55,0,11],2],
    [[1,0,-1,0,1],28],[[],0],[[],0],
    [[-945,0,1323],0],
    [[420,0,0,0,405,0,-595,0,0,0,-189,0,378,0,0,0,0,0,
    15,0,0,0,0,0,-56],66],
    [[-147,0,702,0,-990,0,429],0],
    [[12,0,-81,0,81,0,96,0,-162,0,-225,0,501,0,-228,0,0,
    0,-27,0,27],6],[[-26,0,190,0,-374,0,220],0],
    [[10,0,0,0,51,0,-116,0,50,0,-5,0,36,0,13,0,-37,0,
    -10,0,15,0,-1,0,5,0,-1],26],
    [[1,0,-7,0,7,0,53,0,-101,0,-7,0,150,0,-111,0,0,0,0,
    0,9],6],[[15,0,-87,0,165,0,-99,0,-27,0,27],4
    ],[[-11,0,9,0,3,0,-4,0,-3],36],
    [[-6,0,3,0,4,0,-9,0,-3,0,8,0,-3],20],
    [[-2,0,38,0,-173,0,306,0,-229,0,62],0],
    [[-81,0,435,0,-693,0,330],0],
    [[5,0,0,0,0,0,-19,0,10,0,0,0,10,0,-5,0,-15,0,5,0,
    1,0,0,0,-1],26],
    [[1,0,-2,0,-12,0,56,0,-61,0,15,0,-6,0,6,0,6,0,-3],
    24],[[-3,0,-1,0,9,0,-3,0,-2],22],
    [[-9,0,102,0,-372,0,570,0,-387,0,99],0],
    [[3,0,-39,0,96,0,-84,0,27],2],
    [[-4,0,59,0,-237,0,391,0,-281,0,72],0],
    [[4,0,0,0,-9,0,7,0,-1,0,-1],24],
    [[-1,0,2,0,4,0,-10,0,5],26],
    [[1,0,-6,0,7,0,5,0,-8,0,1],12],
    [[1,0,-17,0,52,0,-51,0,15],2],
    [[-3,0,11,0,-11,0,-6,0,14,0,-5],14],
    [[-7,0,27,0,-27,0,9],4],
    [[-1,0,1,0,7,0,-10,0,-1,0,7,0,-1],12],
    [[1,0,0,0,1],18],[[1,0,-5,0,6,0,-2],6],
    [[9,0,-62,0,135,0,-117,0,33],2],[[-3,0,1],18],
    [[3,0,-5,0,-19,0,49,0,-10,0,-71,0,68,0,-18,0,2,0,
    -3,0,1],10],
    [[1,0,-17,0,52,0,-48,0,0,0,9],4],
    [[-1,0,21,0,-109,0,210,0,-164,0,44],0],
    [[-1,0,8,0,-7,0,-4,0,5],16],
    [[-1,0,11,0,-29,0,29,0,-8,0,-3,0,1],6],
    [[-2,0,2],8],[[1,0,-5,0,5,0,-1],6],
    [[-2,0,2],12],[[5,0,-16,0,17,0,-7,0,1],6],
    [[-1,0,1],10],[[1,0,-6,0,8,0,-3],8],
    [[-1,0,1],8],[[-2,0,18,0,-43,0,42,0,-18,0,3],4],
    [[1,0,-3,0,4,0,-2],8],
    [[5,0,-17,0,17,0,-7,0,1],6],
    [[-4,0,5,0,-1,0,-1],12],
    [[-6,0,39,0,-81,0,76,0,-33,0,6],4],[[2,0,-1],16]
    ],
    [[[2268],0],[[2268],100],[[54,0,0,0,0,0,-432,0,522,
    0,0,0,-258,0,0,0,126,0,-48],0],
    [[759,0,-1128,0,381],0],
    [[1,0,0,0,0,0,0,0,0,0,-24,0,20,0,0,0,105,0,-60,0,
    -141,0,0,0,115,0,-60,0,315,0,-424,0,120,0,0,0,
    45],0],[[-36],50],
    [[240,0,-756,0,846,0,-372,0,54],0],
    [[594,0,-729,0,216],0],[[81],60],[[],0],
    [[],0],
    [[-9,0,0,0,12,0,0,0,36,0,-72,0,36,0,0,0,-3],8],
    [[],0],[[135,0,-390,0,372,0,-132,0,15],0],
    [[],0],[[54,0,0,0,-174,0,150,0,-42],0],
    [[-6,0,0,0,18,0,-42,0,18],50],
    [[1,0,0,0,0,0,-8,0,-3,0,26,0,-10,0,-22,0,23,0,-2,
    0,-1],0],[[117,0,-316,0,278,0,-91,0,8],0],
    [[4,0,-5,0,0,0,-55,0,137,0,-73,0,-61,0,71,0,-15,0,
    -9,0,2],0],[[],0],
    [[13,0,-62,0,108,0,-80,0,23,0,-2],0],
    [[66,0,-154,0,110,0,-25,0,1],0],
    [[1,0,0,0,-4,0,0,0,0,0,0,0,0,0,0,0,1],20],
    [[3],40],[[3],20],
    [[9,0,-18,0,9,0,-84,0,270,0,-231,0,-24,0,84,0,33,0,
    -60,0,21],0],[[54,0,-108,0,75,0,-12],0],
    [[],0],[[181,0,-546,0,559,0,-225,0,28],0],
    [[1,0,0,0,0,0,-18,0,37,0,-2,0,-37,0,18,0,0,0,-2],
    0],[[],0],[[3,0,-12,0,0,0,12,0,-3],4],
    [[],0],[[-12,0,15,0,3,0,-15,0,9],6],
    [[9,0,-39,0,66,0,-45,0,9],0],
    [[39,0,-186,0,351,0,-314,0,131,0,-22,0,1],0],
    [[1,0,0,0,-4,0,-6,0,19,0,-10],0],[[],0],
    [[7,0,-34,0,54,0,-34,0,7],0],
    [[2,0,-13,0,20,0,-10,0,1],0],[[],0],
    [[4,0,-18,0,29,0,-17,0,2],0],
    [[1,0,0,0,-11,0,16,0,-7,0,1],0],[[1,0,-1],28],
    [[-6,0,9,0,-3],4],[[],0],[[],0],[[],0],
    [[17,0,-77,0,132,0,-98,0,30,0,-2],0],
    [[1,0,-4,0,9,0,-4],0],[[-1],10],
    [[9,0,-18,0,-33,0,99,0,-81,0,24,0,-3],0],
    [[-3],40],[[],0],[[],0],[[-3,0,6,0,-3],2],
    [[],0],[[23,0,-109,0,195,0,-159,0,56,0,-7],0],
    [[4,0,-5,0,-26,0,52,0,-33,0,7],0],[[],0],
    [[11,0,-55,0,92,0,-64,0,18,0,-1],0],
    [[1,0,-1,0,1],20],[[],0],[[],0],
    [[-1323,0,945],0],
    [[56,0,0,0,0,0,-15,0,0,0,0,0,-378,0,189,0,0,0,595,
    0,-405,0,0,0,-420],36],
    [[-429,0,990,0,-702,0,147],0],
    [[-27,0,27,0,0,0,228,0,-501,0,225,0,162,0,-96,0,-81,
    0,81,0,-12],0],[[-220,0,374,0,-190,0,26],0],
    [[1,0,-5,0,1,0,-15,0,10,0,37,0,-13,0,-36,0,5,0,-50,
    0,116,0,-51,0,0,0,-10],10],
    [[-9,0,0,0,0,0,111,0,-150,0,7,0,101,0,-53,0,-7,0,7,
    0,-1],0],
    [[-27,0,27,0,99,0,-165,0,87,0,-15],0],
    [[3,0,4,0,-3,0,-9,0,11],22],
    [[3,0,-8,0,3,0,9,0,-4,0,-3,0,6],10],
    [[-62,0,229,0,-306,0,173,0,-38,0,2],0],
    [[-330,0,693,0,-435,0,81],0],
    [[1,0,0,0,-1,0,-5,0,15,0,5,0,-10,0,0,0,-10,0,19,0,
    0,0,0,0,-5],12],
    [[3,0,-6,0,-6,0,6,0,-15,0,61,0,-56,0,12,0,2,0,-1],
    8],[[2,0,3,0,-9,0,1,0,3],12],
    [[-99,0,387,0,-570,0,372,0,-102,0,9],0],
    [[-27,0,84,0,-96,0,39,0,-3],0],
    [[-72,0,281,0,-391,0,237,0,-59,0,4],0],
    [[1,0,1,0,-7,0,9,0,0,0,-4],12],
    [[-5,0,10,0,-4,0,-2,0,1],16],
    [[-1,0,8,0,-5,0,-7,0,6,0,-1],4],
    [[-15,0,51,0,-52,0,17,0,-1],0],
    [[5,0,-14,0,6,0,11,0,-11,0,3],6],
    [[-9,0,27,0,-27,0,7],0],
    [[1,0,-7,0,1,0,10,0,-7,0,-1,0,1],6],
    [[-1,0,0,0,-1],12],[[2,0,-6,0,5,0,-1],2],
    [[-33,0,117,0,-135,0,62,0,-9],0],[[-1,0,3],10],
    [[-1,0,3,0,-2,0,18,0,-68,0,71,0,10,0,-49,0,19,0,5,
    0,-3],0],[[-9,0,0,0,48,0,-52,0,17,0,-1],0],
    [[-44,0,164,0,-210,0,109,0,-21,0,1],0],
    [[-5,0,4,0,7,0,-8,0,1],10],
    [[-1,0,3,0,8,0,-29,0,29,0,-11,0,1],0],
    [[-2,0,2],4],[[1,0,-5,0,5,0,-1],2],
    [[-2,0,2],8],[[-1,0,7,0,-17,0,16,0,-5],0],
    [[-1,0,1],6],[[3,0,-8,0,6,0,-1],4],
    [[-1,0,1],4],[[-3,0,18,0,-42,0,43,0,-18,0,2],0],
    [[2,0,-4,0,3,0,-1],4],
    [[-1,0,7,0,-17,0,17,0,-5],0],
    [[1,0,1,0,-5,0,4],4],
    [[-6,0,33,0,-76,0,81,0,-39,0,6],0],[[1,0,-2],8]]
    ,
    [[[4536],0],[[4536],120],[[15,0,0,0,0,0,-384,0,621,
    0,0,0,-576,0,0,0,621,0,-384,0,0,0,0,0,15],0],
    [[1116,0,-2304,0,1116],0],
    [[30,0,-20,0,-51,0,0,0,105,0,-120,0,600,0,-1160,0,
    600,0,-120,0,105,0,0,0,-51,0,-20,0,30],16],
    [[-24],60],[[258,0,-1128,0,1764,0,-1128,0,258],0],
    [[756,0,-1512,0,756],0],
    [[15,0,-64,0,84,0,0,0,-70,0,0,0,84,0,-64,0,15],56],
    [[81],80],[[81],40],
    [[15,0,-40,0,30,0,0,0,-10,0,0,0,30,0,-40,0,15],16],
    [[27,0,-54,0,27],40],
    [[108,0,-504,0,792,0,-504,0,108],0],
    [[9,0,-36,0,54,0,-36,0,9],40],
    [[15,0,0,0,-207,0,360,0,-207,0,0,0,15],0],
    [[-1,0,0,0,9,0,-40,0,9,0,0,0,-1],60],
    [[-2,0,10,0,-10,0,-26,0,64,0,-26,0,-10,0,10,0,-2],8
    ],[[81,0,-378,0,594,0,-378,0,81],0],
    [[-18,0,78,0,-69,0,-84,0,186,0,-84,0,-69,0,78,0,-18],
    6],[[-4],30],
    [[3,0,-36,0,123,0,-180,0,123,0,-36,0,3],0],
    [[30,0,-150,0,246,0,-150,0,30],0],[[6],32],
    [[1],48],[[1],24],
    [[1,0,-5,0,4,0,-40,0,218,0,-295,0,21,0,192,0,21,0,
    -295,0,218,0,-40,0,4,0,-5,0,1],0],
    [[15,0,-96,0,162,0,-96,0,15],0],
    [[3,0,-12,0,27,0,-12,0,3],40],
    [[168,0,-756,0,1176,0,-756,0,168],0],
    [[-2,0,14,0,-8,0,-32,0,56,0,-32,0,-8,0,14,0,-2],6],
    [[-3],20],[[-1,0,10,0,-18,0,10,0,-1],8],
    [[1,0,-6,0,18,0,-26,0,18,0,-6,0,1],40],
    [[1,0,1,0,-16,0,28,0,-16,0,1,0,1],8],
    [[1,0,-15,0,63,0,-98,0,63,0,-15,0,1],0],
    [[22,0,-164,0,482,0,-680,0,482,0,-164,0,22],0],
    [[-2,0,18,0,-32,0,18,0,-2],6],[[-1,0,2,0,-1],20],
    [[1,0,-13,0,50,0,-76,0,50,0,-13,0,1],0],
    [[-3,0,15,0,-24,0,15,0,-3],2],[[],0],
    [[-3,0,21,0,-36,0,21,0,-3],2],
    [[-2,0,12,0,-20,0,12,0,-2],4],
    [[-1,0,0,0,2,0,0,0,-1],30],[[5,0,-10,0,5],6],
    [[],0],[[],0],[[],0],
    [[5,0,-45,0,146,0,-214,0,146,0,-45,0,5],0],
    [[4,0,-10,0,4],4],[[1],12],
    [[1,0,-5,0,-26,0,129,0,-198,0,129,0,-26,0,-5,0,1],0
    ],[[3,0,-6,0,3],44],
    [[-1,0,0,0,0,0,-1,0,0,0,0,0,-1],20],
    [[-1,0,-1,0,-1],20],[[3,0,-6,0,3],4],
    [[-1,0,0,0,2,0,0,0,-1],20],
    [[9,0,-78,0,243,0,-348,0,243,0,-78,0,9],0],
    [[-12,0,54,0,-84,0,54,0,-12],4],[[-1],10],
    [[2,0,-29,0,99,0,-144,0,99,0,-29,0,2],0],[[],0],
    [[1],16],[[1],8],[[-2268,0,2268],0],
    [[595,0,-405,0,0,0,-84,0,0,0,0,0,84,0,0,0,405,0,
    -595],54],[[-540,0,1728,0,-1728,0,540],0],
    [[-6,0,9,0,0,0,168,0,-513,0,324,0,288,0,-288,0,-324,
    0,513,0,-168,0,0,0,-9,0,6],0],
    [[-180,0,576,0,-576,0,180],0],
    [[4,0,-9,0,-5,0,5,0,-45,0,218,0,-218,0,45,0,-5,0,5,
    0,9,0,-4],20],
    [[48,0,-108,0,18,0,186,0,-186,0,-18,0,108,0,-48],6],
    [[-6,0,9,0,99,0,-288,0,288,0,-99,0,-9,0,6],0],
    [[-9,0,11,0,0,0,0,0,-11,0,9],28],
    [[3,0,-4,0,-15,0,15,0,4,0,-3],16],
    [[-36,0,222,0,-498,0,498,0,-222,0,36],0],
    [[-360,0,1152,0,-1152,0,360],0],[[36,0,-36],30],
    [[-3,0,28,0,-42,0,12,0,5,0,-5,0,-12,0,42,0,-28,0,3]
    ,16],[[1,0,-3,0,3,0,-1],18],
    [[-78,0,450,0,-984,0,984,0,-450,0,78],0],
    [[-6,0,51,0,-135,0,135,0,-51,0,6],0],
    [[-48,0,300,0,-660,0,660,0,-300,0,48],0],
    [[1,0,-2,0,1,0,-1,0,2,0,-1],18],
    [[1,0,-1,0,0,0,-2,0,2,0,0,0,1,0,-1],18],
    [[1,0,-6,0,13,0,-13,0,6,0,-1],8],
    [[-3,0,27,0,-72,0,72,0,-27,0,3],0],
    [[9,0,-21,0,21,0,-9],12],[[9,0,-33,0,33,0,-9],2],
    [[-1,0,2,0,4,0,-9,0,9,0,-4,0,-2,0,1],8],
    [[-1,0,-1,0,1,0,1],14],[[-2,0,6,0,-6,0,2],4],
    [[-12,0,87,0,-204,0,204,0,-87,0,12],0],
    [[1,0,0,0,0,0,-1],12],
    [[2,0,-28,0,53,0,1,0,-90,0,90,0,-1,0,-53,0,28,0,-2]
    ,6],[[27,0,-81,0,81,0,-27],4],
    [[-21,0,147,0,-336,0,336,0,-147,0,21],0],
    [[-1,0,2,0,4,0,-15,0,15,0,-4,0,-2,0,1],10],
    [[3,0,-21,0,48,0,-48,0,21,0,-3],4],[[2,0,-2],6],
    [[-1,0,5,0,-5,0,1],4],[[2,0,-2],10],
    [[1,0,-8,0,21,0,-21,0,8,0,-1],2],[[1,0,-1],8],
    [[-2,0,8,0,-8,0,2],6],[[1,0,-1],6],
    [[5,0,-30,0,66,0,-66,0,30,0,-5],2],
    [[-1,0,4,0,-4,0,1],6],[[-7,0,21,0,-21,0,7],4],
    [[-2,0,6,0,-6,0,2],8],
    [[-1,0,13,0,-61,0,127,0,-127,0,61,0,-13,0,1],0],
    [[1,0,-1],12]],
    [[[2835],0],[[2835],128],[[-96,0,279,0,0,0,-480,0,0,
    0,531,0,-288,0,0,0,0,0,9],6],
    [[627,0,-1392,0,816],0],
    [[60,0,-120,0,315,0,-480,0,435,0,-300,0,180,0,0,0,
    -24,0,-60,0,45],24],[[-45],64],
    [[150,0,-612,0,1026,0,-804,0,243],0],
    [[351,0,-972,0,540],0],[[-81],64],[[],0],
    [[],0],[[18,0,0,0,-48,0,0,0,54,0,-24],20],
    [[],0],[[48,0,-246,0,447,0,-366,0,117],0],
    [[],0],[[-93,0,264,0,-177,0,0,0,9],4],
    [[27,0,-48,0,27,0,0,0,-3],68],
    [[-4,0,-12,0,50,0,-32,0,-12,0,16,0,-3],12],
    [[28,0,-170,0,334,0,-278,0,81],0],
    [[-3,0,18,0,-17,0,-79,0,175,0,-103,0,-49,0,79,0,-26],
    6],[[3],32],
    [[1,0,-14,0,45,0,-80,0,82,0,-46,0,11],0],
    [[5,0,-50,0,130,0,-110,0,30],0],[[5],32],
    [[],0],[[],0],
    [[-12,0,81,0,-111,0,-36,0,162,0,-30,0,-204,0,213,0,
    -72,0,0,0,-3,0,3],6],
    [[-24,0,78,0,-72,0,9],2],[[],0],
    [[86,0,-387,0,680,0,-543,0,167],0],
    [[3,0,-4,0,-24,0,62,0,-42,0,-4,0,18,0,-6],8],
    [[],0],[[6,0,-24,0,18],10],[[],0],
    [[-12,0,36,0,-27,0,0,0,3],12],
    [[-3,0,18,0,-36,0,39,0,-21,0,3],2],
    [[15,0,-82,0,228,0,-360,0,332,0,-170,0,37],0],
    [[6,0,-18,0,18,0,-6],8],[[],0],
    [[-3,0,12,0,-27,0,30,0,-16,0,4],2],
    [[2,0,-5,0,7,0,-5,0,1],4],[[],0],
    [[2,0,-8,0,9,0,-4],4],[[2,0,-8,0,8,0,-3],6],
    [[-2,0,0,0,1],36],[[-3,0,3],8],[[],0],
    [[],0],[[],0],
    [[2,0,-15,0,53,0,-97,0,97,0,-50,0,11],0],
    [[1],8],[[],0],
    [[-15,0,69,0,-120,0,108,0,-39,0,-3,0,3],4],
    [[3],48],[[],0],[[],0],[[],0],[[],0],
    [[5,0,-34,0,102,0,-171,0,166,0,-87,0,20],0],
    [[-3,0,22,0,-49,0,47,0,-16],4],[[],0],
    [[1,0,-9,0,33,0,-62,0,64,0,-36,0,8],0],
    [[-1],28],[[],0],[[],0],[[-1323,0,1512],0],
    [[-210,0,0,0,0,0,210,0,0,0,189,0,-105,0,0,0,0,0,105
    ],60],[[-303,0,972,0,-1116,0,444],0],
    [[48,0,-192,0,135,0,234,0,-246,0,-234,0,417,0,-168,0,
    0,0,-3,0,6],6],[[-55,0,296,0,-400,0,140],0],
    [[5,0,-25,0,65,0,-85,0,60,0,-55,0,30,0,0,0,-9,0,
    -10,0,5],26],
    [[5,0,-29,0,8,0,160,0,-205,0,-8,0,108,0,-42],6],
    [[48,0,-171,0,216,0,-99,0,-3,0,6],4],
    [[-6,0,6,0,-9,0,9,0,0,0,-3],32],
    [[-3,0,-6,0,9,0,3,0,-9,0,0,0,3],18],
    [[-15,0,97,0,-240,0,304,0,-188,0,47],0],
    [[-171,0,636,0,-756,0,300],0],
    [[-5,0,0,0,15,0,4,0,-10,0,1,0,-11,0,20,0,-5,0,0,0,
    -1,0,1],24],
    [[-12,0,6,0,28,0,-20,0,-24,0,38,0,-16],20],
    [[6,0,-6,0,-6,0,6],20],
    [[-45,0,228,0,-516,0,609,0,-372,0,93],0],
    [[12,0,-48,0,72,0,-45,0,6],2],
    [[-26,0,142,0,-333,0,404,0,-253,0,66],0],
    [[1,0,-8,0,7,0,3,0,-6,0,3],20],
    [[6,0,-8,0,-1,0,3,0,-1,0,1],24],
    [[-4,0,14,0,-20,0,10],10],
    [[5,0,-22,0,35,0,-24,0,6],2],
    [[7,0,-23,0,30,0,-15,0,-1,0,2],12],
    [[-5,0,12,0,-6],4],
    [[1,0,3,0,-8,0,10,0,-5,0,-1,0,2,0,-1],10],
    [[1,0,1,0,-1],18],[[-1,0,1,0,-1],8],
    [[-3,0,27,0,-85,0,117,0,-75,0,18],0],[[-1],14],
    [[1,0,-7,0,12,0,24,0,-82,0,91,0,-26,0,-39,0,41,0,
    -12],6],[[5,0,-40,0,65,0,-27],4],
    [[-8,0,60,0,-155,0,198,0,-130,0,34],0],
    [[2,0,-10,0,13,0,-7,0,-1,0,3,0,-1],14],
    [[1,0,-8,0,21,0,-30,0,23,0,-7],4],[[],0],
    [[],0],[[],0],[[-1,0,3,0,-6,0,6,0,-3,0,1],4],
    [[],0],[[1,0,-3,0,2],8],[[],0],
    [[2,0,-8,0,20,0,-29,0,26,0,-13,0,3],2],[[1],12],
    [[3,0,-5,0,5,0,-2],6],[[2,0,-3,0,3,0,-1],10],
    [[-1,0,5,0,-20,0,45,0,-62,0,51,0,-24,0,5],0],
    [[-1],14]],
    [[[2835],0],[[2835],112],[[9,0,0,0,0,0,-288,0,531,
    0,0,0,-480,0,0,0,279,0,-96],0],
    [[816,0,-1392,0,627],0],
    [[45,0,-60,0,-24,0,0,0,180,0,-300,0,435,0,-480,0,315,
    0,-120,0,60],16],[[-45],56],
    [[243,0,-804,0,1026,0,-612,0,150],0],
    [[540,0,-972,0,351],0],[[-81],64],[[],0],
    [[],0],[[-24,0,54,0,0,0,-48,0,0,0,18],18],
    [[],0],[[117,0,-366,0,447,0,-246,0,48],0],
    [[],0],[[9,0,0,0,-177,0,264,0,-93],0],
    [[-3,0,0,0,27,0,-48,0,27],56],
    [[-3,0,16,0,-12,0,-32,0,50,0,-12,0,-4],8],
    [[81,0,-278,0,334,0,-170,0,28],0],
    [[-26,0,79,0,-49,0,-103,0,175,0,-79,0,-17,0,18,0,-3],
    6],[[3],28],
    [[11,0,-46,0,82,0,-80,0,45,0,-14,0,1],0],
    [[30,0,-110,0,130,0,-50,0,5],0],[[5],32],
    [[],0],[[],0],
    [[3,0,-3,0,0,0,-72,0,213,0,-204,0,-30,0,162,0,-36,0,
    -111,0,81,0,-12],0],[[9,0,-72,0,78,0,-24],0],
    [[],0],[[167,0,-543,0,680,0,-387,0,86],0],
    [[-6,0,18,0,-4,0,-42,0,62,0,-24,0,-4,0,3],6],
    [[],0],[[18,0,-24,0,6],10],[[],0],
    [[3,0,0,0,-27,0,36,0,-12],8],
    [[3,0,-21,0,39,0,-36,0,18,0,-3],0],
    [[37,0,-170,0,332,0,-360,0,228,0,-82,0,15],0],
    [[-6,0,18,0,-18,0,6],6],[[],0],
    [[4,0,-16,0,30,0,-27,0,12,0,-3],0],
    [[1,0,-5,0,7,0,-5,0,2],0],[[],0],
    [[-4,0,9,0,-8,0,2],2],[[-3,0,8,0,-8,0,2],4],
    [[1,0,0,0,-2],28],[[3,0,-3],6],[[],0],
    [[],0],[[],0],
    [[11,0,-50,0,97,0,-97,0,53,0,-15,0,2],0],
    [[1],4],[[],0],
    [[3,0,-3,0,-39,0,108,0,-120,0,69,0,-15],0],
    [[3],44],[[],0],[[],0],[[],0],[[],0],
    [[20,0,-87,0,166,0,-171,0,102,0,-34,0,5],0],
    [[-16,0,47,0,-49,0,22,0,-3],4],[[],0],
    [[8,0,-36,0,64,0,-62,0,33,0,-9,0,1],0],
    [[-1],24],[[],0],[[],0],[[-1512,0,1323],0],
    [[-105,0,0,0,0,0,105,0,-189,0,0,0,-210,0,0,0,0,0,
    210],48],[[-444,0,1116,0,-972,0,303],0],
    [[-6,0,3,0,0,0,168,0,-417,0,234,0,246,0,-234,0,-135,
    0,192,0,-48],0],[[-140,0,400,0,-296,0,55],0],
    [[-5,0,10,0,9,0,0,0,-30,0,55,0,-60,0,85,0,-65,0,25,
    0,-5],16],
    [[42,0,-108,0,8,0,205,0,-160,0,-8,0,29,0,-5],6],
    [[-6,0,3,0,99,0,-216,0,171,0,-48],0],
    [[3,0,0,0,-9,0,9,0,-6,0,6],24],
    [[-3,0,0,0,9,0,-3,0,-9,0,6,0,3],12],
    [[-47,0,188,0,-304,0,240,0,-97,0,15],0],
    [[-300,0,756,0,-636,0,171],0],
    [[-1,0,1,0,0,0,5,0,-20,0,11,0,-1,0,10,0,-4,0,-15,
    0,0,0,5],16],
    [[16,0,-38,0,24,0,20,0,-28,0,-6,0,12],18],
    [[-6,0,6,0,6,0,-6],16],
    [[-93,0,372,0,-609,0,516,0,-228,0,45],0],
    [[-6,0,45,0,-72,0,48,0,-12],0],
    [[-66,0,253,0,-404,0,333,0,-142,0,26],0],
    [[-3,0,6,0,-3,0,-7,0,8,0,-1],16],
    [[-1,0,1,0,-3,0,1,0,8,0,-6],16],
    [[-10,0,20,0,-14,0,4],10],
    [[-6,0,24,0,-35,0,22,0,-5],0],
    [[-2,0,1,0,15,0,-30,0,23,0,-7],8],
    [[6,0,-12,0,5],2],
    [[1,0,-2,0,1,0,5,0,-10,0,8,0,-3,0,-1],6],
    [[1,0,-1,0,-1],12],[[1,0,-1,0,1],2],
    [[-18,0,75,0,-117,0,85,0,-27,0,3],0],[[1],16],
    [[12,0,-41,0,39,0,26,0,-91,0,82,0,-24,0,-12,0,7,0,
    -1],6],[[27,0,-65,0,40,0,-5],4],
    [[-34,0,130,0,-198,0,155,0,-60,0,8],0],
    [[1,0,-3,0,1,0,7,0,-13,0,10,0,-2],8],
    [[7,0,-23,0,30,0,-21,0,8,0,-1],4],[[],0],
    [[],0],[[],0],[[-1,0,3,0,-6,0,6,0,-3,0,1],0],
    [[],0],[[-2,0,3,0,-1],6],[[],0],
    [[-3,0,13,0,-26,0,29,0,-20,0,8,0,-2],0],
    [[-1],6],[[2,0,-5,0,5,0,-3],2],
    [[1,0,-3,0,3,0,-2],6],
    [[-5,0,24,0,-51,0,62,0,-45,0,20,0,-5,0,1],0],
    [[1],12]],
    [[[5670],0],[[5670],120],[[21,0,0,0,0,0,-480,0,756,
    0,0,0,-684,0,0,0,756,0,-480,0,0,0,0,0,21],0],
    [[1395,0,-2880,0,1395],0],
    [[30,0,-20,0,-75,0,0,0,70,0,-180,0,810,0,-1360,0,810,
    0,-180,0,70,0,0,0,-75,0,-20,0,30],16],
    [[6],60],[[321,0,-1416,0,2196,0,-1416,0,321],0],
    [[945,0,-1890,0,945],0],
    [[-15,0,64,0,-84,0,0,0,70,0,0,0,-84,0,64,0,-15],56]
    ,[[-81],80],[[-81],40],
    [[21,0,-56,0,42,0,0,0,-14,0,0,0,42,0,-56,0,21],16],
    [[-27,0,54,0,-27],40],
    [[135,0,-630,0,990,0,-630,0,135],0],
    [[-9,0,36,0,-54,0,36,0,-9],40],
    [[21,0,0,0,-252,0,468,0,-252,0,0,0,21],0],
    [[1,0,0,0,0,0,4,0,0,0,0,0,1],60],
    [[-2,0,14,0,-11,0,-32,0,68,0,-32,0,-11,0,14,0,-2],8
    ],[[102,0,-471,0,744,0,-471,0,102],0],
    [[-25,0,94,0,-85,0,-100,0,238,0,-100,0,-85,0,94,0,-25
    ],6],[[-2],30],
    [[4,0,-46,0,153,0,-224,0,153,0,-46,0,4],0],
    [[36,0,-189,0,306,0,-189,0,36],0],
    [[1,0,0,0,-4,0,0,0,6,0,0,0,-4,0,0,0,1],24],
    [[5],48],[[5],24],
    [[2,0,-7,0,5,0,-56,0,259,0,-356,0,39,0,228,0,39,0,
    -356,0,259,0,-56,0,5,0,-7,0,2],0],
    [[21,0,-120,0,198,0,-120,0,21],0],
    [[-3,0,12,0,-27,0,12,0,-3],40],
    [[210,0,-945,0,1470,0,-945,0,210],0],
    [[-2,0,16,0,-10,0,-42,0,76,0,-42,0,-10,0,16,0,-2],6
    ],[[3],20],[[1,0,14,0,-30,0,14,0,1],8],
    [[-1,0,6,0,-18,0,26,0,-18,0,6,0,-1],40],
    [[2,0,2,0,-23,0,38,0,-23,0,2,0,2],8],
    [[2,0,-21,0,78,0,-118,0,78,0,-21,0,2],0],
    [[26,0,-208,0,604,0,-844,0,604,0,-208,0,26],0],
    [[-2,0,22,0,-40,0,22,0,-2],6],[[1,0,-2,0,1],20],
    [[1,0,-16,0,62,0,-94,0,62,0,-16,0,1],0],
    [[-3,0,18,0,-30,0,18,0,-3],2],[[],0],
    [[-5,0,25,0,-42,0,25,0,-5],2],
    [[-2,0,15,0,-28,0,15,0,-2],4],
    [[-1,0,0,0,0,0,0,0,-1],30],[[7,0,-14,0,7],6],
    [[],0],[[],0],[[],0],
    [[6,0,-57,0,183,0,-264,0,183,0,-57,0,6],0],
    [[5,0,-10,0,5],4],[[1],12],
    [[2,0,-7,0,-28,0,162,0,-258,0,162,0,-28,0,-7,0,2],0
    ],[[-3,0,6,0,-3],44],
    [[1,0,0,0,0,0,1,0,0,0,0,0,1],20],
    [[1,0,1,0,1],20],[[3,0,-6,0,3],4],
    [[1,0,0,0,-2,0,0,0,1],20],
    [[11,0,-99,0,304,0,-432,0,304,0,-99,0,11],0],
    [[-14,0,69,0,-110,0,69,0,-14],4],[[1],10],
    [[3,0,-36,0,123,0,-180,0,123,0,-36,0,3],0],
    [[1,0,-2,0,1],24],[[-1],16],[[-1],8],
    [[-2835,0,2835],0],
    [[595,0,-594,0,378,0,-84,0,0,0,0,0,84,0,-378,0,594,
    0,-595],54],[[-675,0,2160,0,-2160,0,675],0],
    [[-9,0,12,0,0,0,216,0,-615,0,405,0,342,0,-342,0,-405,
    0,615,0,-216,0,0,0,-12,0,9],0],
    [[-225,0,720,0,-720,0,225],0],
    [[9,0,-13,0,-5,0,5,0,-80,0,253,0,-253,0,80,0,-5,0,
    5,0,13,0,-9],20],
    [[60,0,-135,0,18,0,228,0,-228,0,-18,0,135,0,-60],6],
    [[-9,0,12,0,117,0,-369,0,369,0,-117,0,-12,0,9],0],
    [[-12,0,11,0,0,0,0,0,-11,0,12],28],
    [[6,0,-4,0,-15,0,15,0,4,0,-6],16],
    [[-45,0,279,0,-621,0,621,0,-279,0,45],0],
    [[-450,0,1440,0,-1440,0,450],0],
    [[-9,0,0,0,45,0,-45,0,0,0,9],26],
    [[-9,0,36,0,-50,0,24,0,7,0,-7,0,-24,0,50,0,-36,0,9]
    ,16],[[1,0,-3,0,3,0,-1],18],
    [[-96,0,567,0,-1227,0,1227,0,-567,0,96],0],
    [[-9,0,66,0,-165,0,165,0,-66,0,9],0],
    [[-60,0,375,0,-825,0,825,0,-375,0,60],0],
    [[1,0,-2,0,1,0,-1,0,2,0,-1],18],
    [[1,0,-1,0,0,0,-2,0,2,0,0,0,1,0,-1],18],
    [[-1,0,-6,0,23,0,-23,0,6,0,1],8],
    [[-3,0,33,0,-90,0,90,0,-33,0,3],0],
    [[-1,0,0,0,11,0,-32,0,32,0,-11,0,0,0,1],8],
    [[12,0,-39,0,39,0,-12],2],
    [[-1,0,3,0,4,0,-17,0,17,0,-4,0,-3,0,1],8],
    [[-1,0,1],16],[[-2,0,7,0,-7,0,2],4],
    [[-15,0,108,0,-255,0,255,0,-108,0,15],0],
    [[1,0,-3,0,3,0,-1],12],
    [[5,0,-34,0,63,0,-4,0,-116,0,116,0,4,0,-63,0,34,0,
    -5],6],[[33,0,-105,0,105,0,-33],4],
    [[-27,0,183,0,-420,0,420,0,-183,0,27],0],
    [[-1,0,2,0,4,0,-17,0,17,0,-4,0,-2,0,1],10],
    [[3,0,-26,0,63,0,-63,0,26,0,-3],4],[[2,0,-2],6],
    [[-1,0,5,0,-5,0,1],4],[[2,0,-2],10],
    [[1,0,-10,0,25,0,-25,0,10,0,-1],2],[[1,0,-1],8],
    [[-3,0,11,0,-11,0,3],6],[[1,0,-1],6],
    [[7,0,-38,0,81,0,-81,0,38,0,-7],2],
    [[-1,0,5,0,-5,0,1],6],
    [[1,0,-9,0,24,0,-24,0,9,0,-1],2],
    [[-2,0,8,0,-8,0,2],8],
    [[-1,0,17,0,-78,0,156,0,-156,0,78,0,-17,0,1],0],
    [[3,0,-3],12]],
    [[[3200],0],[[3200],126],[[-160,0,360,0,0,0,-384,0,
    0,0,576,0,-288,0,0,0,0,0,24],6],
    [[720,0,-1600,0,880],0],
    [[-20,0,0,0,0,0,30,0,-120,0,330,0,-680,0,510,0,-120,
    0,80,0,0,0,-30,0,-20,0,30,0,0,0,10],18],
    [[],0],[[152,0,-736,0,1200,0,-864,0,248],0],
    [[440,0,-1080,0,600],0],
    [[15,0,0,0,0,0,0,0,10,0,0,0,-60,0,0,0,15,0,0,0,
    -20],58],[[-40],84],[[-40],42],
    [[-3,0,0,0,18,0,0,0,-20,0,0,0,66,0,-48,0,-3,0,0,0,
    4],16],[[-10,0,36,0,-12],42],
    [[64,0,-292,0,532,0,-412,0,104],0],
    [[-2,0,20,0,-38,0,20,0,-4],42],
    [[-120,0,288,0,-192,0,0,0,24],4],[[],0],
    [[4,0,-6,0,-12,0,40,0,-24,0,-18,0,16],10],
    [[38,0,-214,0,400,0,-306,0,82],0],
    [[-4,0,28,0,-36,0,-49,0,149,0,-88,0,-61,0,84,0,-23,
    0,0,0,-1,0,1],6],[[],0],
    [[2,0,-20,0,66,0,-108,0,94,0,-40,0,6],0],
    [[10,0,-70,0,160,0,-130,0,30],0],[[],0],
    [[],0],[[],0],
    [[-28,0,97,0,-145,0,41,0,132,0,-8,0,-242,0,208,0,-44,
    0,3,0,-9,0,3],6],[[-40,0,96,0,-72,0,24],2],
    [[8,0,-12,0,12],44],
    [[96,0,-468,0,800,0,-592,0,164],0],
    [[-2,0,6,0,-6,0,-14,0,52,0,-46,0,-6,0,18,0,-2],6],
    [[],0],[[1,0,6,0,-24,0,22,0,1,0,-4],8],
    [[2,0,-12,0,18,0,-10,0,4],44],
    [[1,0,0,0,-13,0,28,0,-29,0,6,0,5,0,-2],8],
    [[-7,0,30,0,-51,0,41,0,-20,0,3],2],
    [[10,0,-96,0,300,0,-442,0,360,0,-164,0,32],0],
    [[-2,0,12,0,-26,0,20,0,-2,0,-2],6],[[],0],
    [[-5,0,23,0,-42,0,37,0,-15,0,2],2],
    [[-1,0,5,0,-11,0,11,0,-3],2],[[1],18],
    [[6,0,-11,0,9,0,-5,0,1],4],
    [[2,0,-12,0,14,0,-4],6],[[],0],
    [[-5,0,6,0,-2],8],[[-1],14],[[-1],28],
    [[-1],14],
    [[1,0,-21,0,81,0,-130,0,109,0,-49,0,9],0],
    [[],0],[[],0],
    [[-15,0,75,0,-147,0,126,0,-33,0,-9,0,3],4],
    [[-1,0,2,0,-1],46],[[],0],[[],0],
    [[-1,0,2,0,-1],4],[[],0],
    [[4,0,-43,0,142,0,-219,0,183,0,-82,0,15],0],
    [[-4,0,30,0,-63,0,55,0,-18,0,-1,0,1],4],[[],0],
    [[1,0,-14,0,52,0,-86,0,74,0,-32,0,5],0],[[],0],
    [[],0],[[],0],[[-1520,0,1680],0],
    [[216,0,0,0,-105,0,0,0,0,0,168,0,-378,0,0,0,280,0,
    0,0,-189,0,168],56],
    [[-336,0,1152,0,-1248,0,464],0],
    [[80,0,-242,0,198,0,172,0,-212,0,-270,0,450,0,-144,0,
    0,0,-12,0,12],6],[[-80,0,360,0,-440,0,160],0]
    ,
    [[-5,0,15,0,-40,0,105,0,-131,0,40,0,0,0,11,0,9,0,
    -4,0,0,0,0,0,-1,0,1],24],
    [[10,0,-52,0,12,0,132,0,-166,0,-12,0,118,0,-44,0,0,
    0,0,0,2],6],
    [[54,0,-198,0,246,0,-102,0,-12,0,12],4],
    [[3,0,0,0,-6,0,0,0,3],32],
    [[3,0,-3,0,-6,0,3,0,10,0,-6,0,-3,0,2],16],
    [[-16,0,124,0,-308,0,352,0,-196,0,44],0],
    [[-210,0,740,0,-860,0,310],0],
    [[-1,0,0,0,0,0,0,0,-10,0,36,0,-70,0,21,0,4,0,5,0,
    0,0,-5,0,-1,0,1],20],
    [[-3,0,-6,0,12,0,6,0,-14,0,-30,0,60,0,-24,0,-3,0,
    -2,0,2],18],[[-6,0,6,0,-8,0,6],20],
    [[-41,0,276,0,-637,0,693,0,-384,0,89],0],
    [[20,0,-70,0,82,0,-48,0,12],2],
    [[-27,0,175,0,-415,0,469,0,-261,0,57],0],
    [[-2,0,4,0,-5,0,9,0,-10,0,2],20],
    [[-1,0,0,0,-2,0,8,0,-3],24],
    [[-1,0,14,0,-24,0,12,0,3,0,-2],10],
    [[-1,0,9,0,-33,0,51,0,-27,0,3],0],
    [[1,0,5,0,-19,0,30,0,-19,0,1,0,4,0,-1],10],
    [[-8,0,14,0,-8,0,2],4],
    [[-1,0,2,0,-5,0,-3,0,15,0,-8,0,-1,0,1],8],
    [[1,0,0,0,-1],16],[[-1,0,2,0,-2,0,1],4],
    [[-4,0,40,0,-116,0,144,0,-80,0,16],0],
    [[3,0,-4,0,1],16],
    [[1,0,-9,0,21,0,-7,0,-57,0,88,0,-19,0,-48,0,38,0,
    -7,0,0,0,-1],6],
    [[10,0,-52,0,74,0,-34,0,0,0,2],4],
    [[-12,0,78,0,-198,0,240,0,-134,0,26],0],
    [[3,0,-8,0,14,0,-6,0,-5,0,2],14],
    [[1,0,-10,0,30,0,-40,0,26,0,-6,0,-1],4],
    [[1,0,-1],8],[[-1,0,2,0,-1],6],[[],0],
    [[-4,0,9,0,-10,0,6,0,-2],4],[[-1],8],
    [[3,0,-5,0,4,0,-1],8],[[1],8],
    [[3,0,-17,0,35,0,-38,0,25,0,-9,0,1],2],
    [[-2,0,2],10],[[-3,0,7,0,-5,0,3,0,-2],4],
    [[-1,0,4,0,-6,0,3],8],
    [[6,0,-35,0,72,0,-77,0,51,0,-20,0,3],2],
    [[1,0,-3,0,2],12]],
    [[[3200],0],[[3200],114],[[24,0,0,0,0,0,-288,0,576,
    0,0,0,-384,0,0,0,360,0,-160],0],
    [[880,0,-1600,0,720],0],
    [[10,0,0,0,30,0,-20,0,-30,0,0,0,80,0,-120,0,510,0,
    -680,0,330,0,-120,0,30,0,0,0,0,0,-20],12],
    [[],0],[[248,0,-864,0,1200,0,-736,0,152],0],
    [[600,0,-1080,0,440],0],
    [[-20,0,0,0,15,0,0,0,-60,0,0,0,10,0,0,0,0,0,0,0,
    15],50],[[-40],76],[[-40],38],
    [[4,0,0,0,-3,0,-48,0,66,0,0,0,-20,0,0,0,18,0,0,0,
    -3],12],[[-12,0,36,0,-10],38],
    [[104,0,-412,0,532,0,-292,0,64],0],
    [[-4,0,20,0,-38,0,20,0,-2],38],
    [[24,0,0,0,-192,0,288,0,-120],0],[[],0],
    [[16,0,-18,0,-24,0,40,0,-12,0,-6,0,4],10],
    [[82,0,-306,0,400,0,-214,0,38],0],
    [[1,0,-1,0,0,0,-23,0,84,0,-61,0,-88,0,149,0,-49,0,
    -36,0,28,0,-4],0],[[],0],
    [[6,0,-40,0,94,0,-108,0,66,0,-20,0,2],0],
    [[30,0,-130,0,160,0,-70,0,10],0],[[],0],
    [[],0],[[],0],
    [[3,0,-9,0,3,0,-44,0,208,0,-242,0,-8,0,132,0,41,0,
    -145,0,97,0,-28],0],[[24,0,-72,0,96,0,-40],0]
    ,[[12,0,-12,0,8],40],
    [[164,0,-592,0,800,0,-468,0,96],0],
    [[-2,0,18,0,-6,0,-46,0,52,0,-14,0,-6,0,6,0,-2],6],
    [[],0],[[-4,0,1,0,22,0,-24,0,6,0,1],6],
    [[4,0,-10,0,18,0,-12,0,2],40],
    [[-2,0,5,0,6,0,-29,0,28,0,-13,0,0,0,1],6],
    [[3,0,-20,0,41,0,-51,0,30,0,-7],0],
    [[32,0,-164,0,360,0,-442,0,300,0,-96,0,10],0],
    [[-2,0,-2,0,20,0,-26,0,12,0,-2],4],[[],0],
    [[2,0,-15,0,37,0,-42,0,23,0,-5],0],
    [[-3,0,11,0,-11,0,5,0,-1],2],[[1],18],
    [[1,0,-5,0,9,0,-11,0,6],0],
    [[-4,0,14,0,-12,0,2],4],[[],0],
    [[-2,0,6,0,-5],4],[[-1],18],[[-1],28],
    [[-1],14],
    [[9,0,-49,0,109,0,-130,0,81,0,-21,0,1],0],
    [[],0],[[],0],
    [[3,0,-9,0,-33,0,126,0,-147,0,75,0,-15],0],
    [[-1,0,2,0,-1],42],[[],0],[[],0],
    [[-1,0,2,0,-1],4],[[],0],
    [[15,0,-82,0,183,0,-219,0,142,0,-43,0,4],0],
    [[1,0,-1,0,-18,0,55,0,-63,0,30,0,-4],0],[[],0],
    [[5,0,-32,0,74,0,-86,0,52,0,-14,0,1],0],[[],0],
    [[],0],[[],0],[[-1680,0,1520],0],
    [[-168,0,189,0,0,0,-280,0,0,0,378,0,-168,0,0,0,0,0,
    105,0,0,0,-216],48],
    [[-464,0,1248,0,-1152,0,336],0],
    [[-12,0,12,0,0,0,144,0,-450,0,270,0,212,0,-172,0,
    -198,0,242,0,-80],0],
    [[-160,0,440,0,-360,0,80],0],
    [[-1,0,1,0,0,0,0,0,4,0,-9,0,-11,0,0,0,-40,0,131,0,
    -105,0,40,0,-15,0,5],12],
    [[-2,0,0,0,0,0,44,0,-118,0,12,0,166,0,-132,0,-12,0,
    52,0,-10],0],
    [[-12,0,12,0,102,0,-246,0,198,0,-54],0],
    [[-3,0,0,0,6,0,0,0,-3],26],
    [[-2,0,3,0,6,0,-10,0,-3,0,6,0,3,0,-3],12],
    [[-44,0,196,0,-352,0,308,0,-124,0,16],0],
    [[-310,0,860,0,-740,0,210],0],
    [[-1,0,1,0,5,0,0,0,-5,0,-4,0,-21,0,70,0,-36,0,10,
    0,0,0,0,0,0,0,1],16],
    [[-2,0,2,0,3,0,24,0,-60,0,30,0,14,0,-6,0,-12,0,6,
    0,3],12],[[-6,0,8,0,-6,0,6],16],
    [[-89,0,384,0,-693,0,637,0,-276,0,41],0],
    [[-12,0,48,0,-82,0,70,0,-20],0],
    [[-57,0,261,0,-469,0,415,0,-175,0,27],0],
    [[-2,0,10,0,-9,0,5,0,-4,0,2],16],
    [[3,0,-8,0,2,0,0,0,1],18],
    [[2,0,-3,0,-12,0,24,0,-14,0,1],6],
    [[-3,0,27,0,-51,0,33,0,-9,0,1],0],
    [[1,0,-4,0,-1,0,19,0,-30,0,19,0,-5,0,-1],6],
    [[-2,0,8,0,-14,0,8],0],
    [[-1,0,1,0,8,0,-15,0,3,0,5,0,-2,0,1],8],
    [[1,0,0,0,-1],14],[[-1,0,2,0,-2,0,1],4],
    [[-16,0,80,0,-144,0,116,0,-40,0,4],0],
    [[-1,0,4,0,-3],10],
    [[1,0,0,0,7,0,-38,0,48,0,19,0,-88,0,57,0,7,0,-21,
    0,9,0,-1],2],
    [[-2,0,0,0,34,0,-74,0,52,0,-10],0],
    [[-26,0,134,0,-240,0,198,0,-78,0,12],0],
    [[-2,0,5,0,6,0,-14,0,8,0,-3],10],
    [[1,0,6,0,-26,0,40,0,-30,0,10,0,-1],2],
    [[1,0,-1],4],[[1,0,-2,0,1],4],[[],0],
    [[2,0,-6,0,10,0,-9,0,4],2],[[1],10],
    [[1,0,-4,0,5,0,-3],4],[[-1],6],
    [[-1,0,9,0,-25,0,38,0,-35,0,17,0,-3],0],
    [[-2,0,2],6],[[2,0,-3,0,5,0,-7,0,3],2],
    [[-3,0,6,0,-4,0,1],8],
    [[-3,0,20,0,-51,0,77,0,-72,0,35,0,-6],0],
    [[-2,0,3,0,-1],10]],
    [[[4096],0],[[4096],135],[[-128,0,288,0,0,0,-448,0,
    0,0,864,0,-640,0,0,0,0,0,64],6],
    [[768,0,-2048,0,1280],0],
    [[10,0,-60,0,330,0,-744,0,630,0,-180,0,110,0,0,0,
    -132,0,-80,0,120,0,0,0,20,0,-24],24],[[],0],
    [[128,0,-768,0,1536,0,-1280,0,384],0],
    [[448,0,-1344,0,960],0],
    [[60,0,0,0,-10,0,0,0,84,0,-64,0,0,0,0,0,0,0,0,0,
    -6],65],[[64],90],[[64],45],
    [[6,0,0,0,-10,0,0,0,66,0,-112,0,36,0,0,0,12,0,0,0,
    -6],20],[[16,0,-48,0,24],45],
    [[40,0,-288,0,680,0,-640,0,200],0],
    [[4,0,-24,0,44,0,-40,0,8],45],
    [[-96,0,320,0,-288,0,0,0,64],4],[[],0],
    [[-2,0,-8,0,40,0,-40,0,-18,0,40,0,-4,0,-8],12],
    [[24,0,-200,0,512,0,-504,0,168],0],
    [[-1,0,12,0,-24,0,-36,0,152,0,-104,0,-116,0,188,0,
    -71,0,0,0,-4,0,4],6],[[],0],
    [[-8,0,56,0,-144,0,168,0,-88,0,16],2],
    [[4,0,-60,0,204,0,-236,0,84],0],
    [[-1,0,0,0,0,0,0,0,-6,0,0,0,4,0,0,0,-1],27],
    [[-4],54],[[-4],27],
    [[-8,0,58,0,-130,0,50,0,144,0,-12,0,-376,0,396,0,
    -120,0,10,0,-22,0,10],6],
    [[-32,0,128,0,-160,0,64],2],
    [[-8,0,20,0,-16,0,4],47],
    [[72,0,-472,0,1024,0,-904,0,280],0],
    [[2,0,-6,0,-6,0,48,0,-58,0,-6,0,46,0,-20],8],
    [[],0],[[2,0,-18,0,22,0,4,0,-12,0,2],10],
    [[-2,0,9,0,-20,0,22,0,-10,0,1],47],
    [[-7,0,24,0,-29,0,4,0,18,0,-10],12],
    [[-2,0,24,0,-74,0,94,0,-52,0,10],2],
    [[4,0,-64,0,288,0,-572,0,576,0,-288,0,56],0],
    [[4,0,-24,0,32,0,-8,0,-4],8],[[],0],
    [[-1,0,18,0,-60,0,78,0,-43,0,8],2],
    [[3,0,-17,0,27,0,-14,0,2],4],[[1],21],
    [[5,0,-24,0,35,0,-20,0,4],4],
    [[2,0,-16,0,26,0,-12],6],[[],0],
    [[-7,0,14,0,-6],8],[[1],15],[[1],30],
    [[1],15],[[-10,0,70,0,-176,0,202,0,-108,0,22],2],
    [[-4,0,8,0,-4],6],[[],0],
    [[-6,0,62,0,-170,0,176,0,-50,0,-22,0,10],4],
    [[-2,0,4,0,-2],51],[[],0],[[],0],
    [[-2,0,4,0,-2],6],[[],0],
    [[1,0,-23,0,129,0,-288,0,311,0,-161,0,31],0],
    [[-1,0,20,0,-72,0,88,0,-35,0,-4,0,4],4],[[],0],
    [[-5,0,43,0,-117,0,139,0,-75,0,14],2],
    [[-1,0,1,0,-1],27],[[-1],18],[[-1],9],
    [[-1792,0,2304],0],
    [[512,0,0,84,0,-378,0,594,0,-315,0,0,0,-189,0,378,0,
    -189,0,0,0,15],63],
    [[-320,0,1344,0,-1728,0,704],0],
    [[48,0,-188,0,180,0,184,0,-264,0,-396,0,772,0,-336,0,
    0,0,-32,0,32],6],[[-64,0,384,0,-640,0,320],0]
    ,
    [[-15,0,96,0,-172,0,95,0,-10,0,21,0,17,0,-37,0,-10,
    0,15,0,-1,0,2,0,-1],28],
    [[4,0,-28,0,12,0,116,0,-188,0,-12,0,228,0,-140,0,0,
    0,0,0,8],6],
    [[36,0,-196,0,316,0,-156,0,-32,0,32],4],
    [[-11,0,12,0,6,0,-4,0,-3],36],
    [[-6,0,9,0,8,0,-15,0,-3,0,10,0,-3],20],
    [[-8,0,96,0,-344,0,520,0,-352,0,88],0],
    [[-184,0,848,0,-1200,0,520],0],
    [[-5,0,0,0,5,19,-16,-50,5,31,0,4,-5,10,0,-14,0,-5,
    0,4,0,1],25],
    [[6,0,3,0,-7,0,-30,0,92,0,-74,0,18,0,-6,0,6,0,3,0,
    -3],22],[[8,3,0,-9,0,9,0,-3],21],
    [[-26,0,240,0,-726,0,986,0,-624,0,150],0],
    [[12,0,-76,0,148,0,-116,0,32],2],
    [[-14,0,142,0,-470,0,674,0,-442,0,106],0],
    [[2,1,-8,-2,2,7,0,-13,0,8,0,-1],21],
    [[-2,0,4,2,-2,-1,0,7,0,-11,0,3],23],
    [[9,0,-21,0,10,0,8,0,-7,0,1],12],
    [[4,0,-36,0,84,0,-68,0,16],2],
    [[2,0,-14,0,28,0,-18,0,-7,0,14,0,-5],12],
    [[-12,0,36,0,-32,0,8],4],
    [[1,0,-2,0,-4,0,17,0,-15,0,-2,0,6,0,-1],10],
    [[1,0,-2,0,1],18],[[2,0,-6,0,6,0,-2],6],
    [[-1,0,26,0,-126,0,226,0,-166,0,43],0],
    [[-1,2,3,0,-3,0,1],14],
    [[-2,0,11,0,-8,0,-51,0,97,0,-12,0,-101,0,90,0,-23,0,
    1,0,-3,0,1],8],
    [[4,0,-44,0,100,0,-68,0,0,0,8],4],
    [[-4,0,56,0,-220,0,356,0,-248,0,60],0],
    [[-5,0,15,0,-10,0,-6,0,7,0,-1],16],
    [[-4,0,28,0,-56,0,45,0,-11,0,-3,0,1],6],
    [[-1,0,1],8],[[1,0,-3,0,3,0,-1],6],
    [[-2,0,2],12],[[-1,0,10,0,-22,0,21,0,-8,0,1],4],
    [[1,-1,0,1],9],[[3,0,-11,0,10,0,-3],8],
    [[-1],7],[[-8,0,37,0,-67,0,59,0,-24,0,3],4],
    [[1,0,-5,0,5,0,-1],8],
    [[-1,0,9,0,-20,0,19,0,-8,0,1],4],
    [[2,0,-8,0,7,0,-1],10],
    [[1,0,-21,0,78,0,-130,0,110,0,-46,0,7],2],
    [[-1,-3,0,3],13]],
    [[[4096],0],[[4096],105],[[64,0,0,0,0,0,-640,0,864,
    0,0,0,-448,0,0,0,288,0,-128],0],
    [[1280,0,-2048,0,768],0],
    [[-24,0,20,0,0,0,120,0,-80,0,-132,0,0,0,110,0,-180,
    0,630,0,-744,0,330,0,-60,0,10],10],[[],0],
    [[384,0,-1280,0,1536,0,-768,0,128],0],
    [[960,0,-1344,0,448],0],
    [[-6,0,0,0,0,0,0,0,0,0,-64,0,84,0,0,0,-10,0,0,0,
    60],43],[[64],70],[[64],35],
    [[-6,0,0,0,12,0,0,0,36,0,-112,0,66,0,0,0,-10,0,0,
    0,6],8],[[24,0,-48,0,16],35],
    [[200,0,-640,0,680,0,-288,0,40],0],
    [[8,0,-40,0,44,0,-24,0,4],35],
    [[64,0,0,0,-288,0,320,0,-96],0],[[],0],
    [[-8,0,-4,0,40,0,-18,0,-40,0,40,0,-8,0,-2],6],
    [[168,0,-504,0,512,0,-200,0,24],0],
    [[4,0,-4,0,0,0,-71,0,188,0,-116,0,-104,0,152,0,-36,
    0,-24,0,12,0,-1],0],[[],0],
    [[16,0,-88,0,168,0,-144,0,56,0,-8],0],
    [[84,0,-236,0,204,0,-60,0,4],0],
    [[-1,0,0,0,4,0,0,0,-6,0,0,0,0,0,0,0,-1],21],
    [[-4],42],[[-4],21],
    [[10,0,-22,0,10,0,-120,0,396,0,-376,0,-12,0,144,0,50,
    0,-130,0,58,0,-8],0],
    [[64,0,-160,0,128,0,-32],0],
    [[4,0,-16,0,20,0,-8],35],
    [[280,0,-904,0,1024,0,-472,0,72],0],
    [[-20,0,46,0,-6,0,-58,0,48,0,-6,0,-6,0,2],6],
    [[],0],[[2,0,-12,0,4,0,22,0,-18,0,2],4],
    [[1,0,-10,0,22,0,-20,0,9,0,-2],35],
    [[-10,0,18,0,4,0,-29,0,24,0,-7],6],
    [[10,0,-52,0,94,0,-74,0,24,0,-2],0],
    [[56,0,-288,0,576,0,-572,0,288,0,-64,0,4],0],
    [[-4,0,-8,0,32,0,-24,0,4],4],[[],0],
    [[8,0,-43,0,78,0,-60,0,18,0,-1],0],
    [[2,0,-14,0,27,0,-17,0,3],0],[[1],15],
    [[4,0,-20,0,35,0,-24,0,5],0],
    [[-12,0,26,0,-16,0,2],4],[[],0],
    [[-6,0,14,0,-7],4],[[1],17],[[1],26],
    [[1],13],[[22,0,-108,0,202,0,-176,0,70,0,-10],0],
    [[-4,0,8,0,-4],2],[[],0],
    [[10,0,-22,0,-50,0,176,0,-170,0,62,0,-6],0],
    [[-2,0,4,0,-2],37],[[],0],[[],0],
    [[-2,0,4,0,-2],2],[[],0],
    [[31,0,-161,0,311,0,-288,0,129,0,-23,0,1],0],
    [[4,0,-4,0,-35,0,88,0,-72,0,20,0,-1],0],[[],0],
    [[14,0,-75,0,139,0,-117,0,43,0,-5],0],
    [[-1,0,1,0,-1],21],[[-1],14],[[-1],7],
    [[-2304,0,1792],0],
    [[-15,0,0,0,189,0,-378,0,189,0,0,0,315,0,-594,0,378,
    0,-84,0,0,-512],42],
    [[-704,0,1728,0,-1344,0,320],0],
    [[-32,0,32,0,0,0,336,0,-772,0,396,0,264,0,-184,0,
    -180,0,188,0,-48],0],
    [[-320,0,640,0,-384,0,64],0],
    [[1,0,-2,0,1,0,-15,0,10,0,37,0,-17,0,-21,0,10,0,
    -95,0,172,0,-96,0,15],10],
    [[-8,0,0,0,0,0,140,0,-228,0,12,0,188,0,-116,0,-12,0,
    28,0,-4],0],
    [[-32,0,32,0,156,0,-316,0,196,0,-36],0],
    [[3,0,4,0,-6,0,-12,0,11],22],
    [[3,0,-10,0,3,0,15,0,-8,0,-9,0,6],10],
    [[-88,0,352,0,-520,0,344,0,-96,0,8],0],
    [[-520,0,1200,0,-848,0,184],0],
    [[-1,0,-4,0,5,0,14,0,-10,5,-4,0,-31,-5,50,16,-19,-5,
    0,0,0,5],16],
    [[3,0,-3,0,-6,0,6,0,-18,0,74,0,-92,0,30,0,7,0,-3,
    0,-6],8],[[3,0,-9,0,9,0,-3,-8],14],
    [[-150,0,624,0,-986,0,726,0,-240,0,26],0],
    [[-32,0,116,0,-148,0,76,0,-12],0],
    [[-106,0,442,0,-674,0,470,0,-142,0,14],0],
    [[1,0,-8,0,13,0,-7,-2,2,8,-1,-2],14],
    [[-3,0,11,0,-7,0,1,2,-2,-4,0,2],16],
    [[-1,0,7,0,-8,0,-10,0,21,0,-9],4],
    [[-16,0,68,0,-84,0,36,0,-4],0],
    [[5,0,-14,0,7,0,18,0,-28,0,14,0,-2],6],
    [[-8,0,32,0,-36,0,12],0],
    [[1,0,-6,0,2,0,15,0,-17,0,4,0,2,0,-1],6],
    [[-1,0,2,0,-1],12],[[2,0,-6,0,6,0,-2],2],
    [[-43,0,166,0,-226,0,126,0,-26,0,1],0],
    [[-1,0,3,0,-3,-2,1],10],
    [[-1,0,3,0,-1,0,23,0,-90,0,101,0,12,0,-97,0,51,0,8,
    0,-11,0,2],0],
    [[-8,0,0,0,68,0,-100,0,44,0,-4],0],
    [[-60,0,248,0,-356,0,220,0,-56,0,4],0],
    [[1,0,-7,0,6,0,10,0,-15,0,5],8],
    [[-1,0,3,0,11,0,-45,0,56,0,-28,0,4],0],
    [[-1,0,1],4],[[1,0,-3,0,3,0,-1],2],
    [[-2,0,2],8],[[-1,0,8,0,-21,0,22,0,-10,0,1],0],
    [[-1,0,1,-1],6],[[3,0,-10,0,11,0,-3],4],
    [[1],7],[[-3,0,24,0,-59,0,67,0,-37,0,8],0],
    [[1,0,-5,0,5,0,-1],4],
    [[-1,0,8,0,-19,0,20,0,-9,0,1],0],
    [[1,0,-7,0,8,0,-2],6],
    [[-7,0,46,0,-110,0,130,0,-78,0,21,0,-1],0],
    [[-3,0,3,1],10]],
    [[[4200],0],[[4200],132],[[-128,0,342,0,0,0,-596,0,
    0,0,864,0,-544,0,0,0,0,0,38],6],
    [[850,0,-2080,0,1270],0],
    [[55,0,-120,0,375,0,-752,0,645,0,-300,0,230,0,0,0,
    -111,0,-80,0,105,0,0,0,5,0,-12],24],
    [[40],66],[[172,0,-840,0,1548,0,-1256,0,384],0],
    [[480,0,-1410,0,900],0],
    [[-60,0,0,0,90,0,0,0,-60],64],[[-30],88],
    [[-30],44],
    [[12,0,0,0,-33,0,0,0,84,0,-72,0,18,0,0,0,6],20],
    [[-6,0,30,0,-9],44],
    [[53,0,-324,0,679,0,-604,0,193],0],
    [[-1,0,12,0,-32,0,20,0,-2],44],
    [[-114,0,356,0,-288,0,0,0,38],4],
    [[-18,0,44,0,-36,0,0,0,2],70],
    [[-3,0,-14,0,56,0,-44,0,-23,0,30,0,-6,0,-4],12],
    [[31,0,-223,0,510,0,-467,0,149],0],
    [[-2,0,17,0,-23,0,-71,0,210,0,-136,0,-98,0,158,0,-56,
    0,0,0,-1,0,2],6],[[],0],
    [[1,0,-12,0,62,0,-132,0,146,0,-82,0,17],0],
    [[5,0,-65,0,200,0,-205,0,65],0],[[],0],[[],0],
    [[],0],
    [[-12,0,80,0,-145,0,2,0,196,0,-35,0,-352,0,373,0,
    -112,0,3,0,-13,0,9],6],
    [[-32,0,124,0,-136,0,38],2],
    [[4,0,-17,0,8,0,-1],46],
    [[96,0,-524,0,1026,0,-872,0,272],0],
    [[2,0,-6,0,-17,0,70,0,-69,0,-6,0,38,0,-14],8],
    [[-2],22],[[4,0,-25,0,28,0,2,0,-6],10],
    [[-8,0,20,0,-13,0,4],48],
    [[-10,0,39,0,-38,0,3,0,12,0,-3],12],
    [[-3,0,25,0,-64,0,77,0,-41,0,9],2],
    [[10,0,-92,0,313,0,-558,0,545,0,-276,0,59],0],
    [[4,0,-26,0,32,0,-8,0,-1],8],[[-1,0,2],22],
    [[-2,0,18,0,-50,0,61,0,-35,0,7],2],
    [[3,0,-12,0,18,0,-11,0,2],4],[[],0],
    [[4,0,-18,0,24,0,-12,0,2],4],
    [[3,0,-14,0,19,0,-8],6],[[],0],
    [[-6,0,9,0,-3],8],[[],0],[[],0],[[],0],
    [[1,0,-15,0,74,0,-161,0,175,0,-94,0,20],0],
    [[-2,0,4,0,-2],6],[[],0],
    [[-12,0,81,0,-177,0,170,0,-60,0,-13,0,9],4],
    [[2,0,-4],50],[[-1,0,0,0,0,0,-1],28],
    [[-1,0,-1],24],[[-1,0,2],6],[[2,0,0,0,-1],26],
    [[3,0,-35,0,140,0,-273,0,283,0,-150,0,32],0],
    [[-2,0,26,0,-73,0,80,0,-32,0,-1,0,2],4],[[],0],
    [[-9,0,46,0,-104,0,119,0,-66,0,14],2],[[],0],
    [[],0],[[],0],[[-1890,0,2310],0],
    [[630,0,-378,0,189,0,-315,0,0,0,0,0,483,0,-189],66],
    [[-382,0,1404,0,-1716,0,698],0],
    [[56,0,-225,0,189,0,266,0,-330,0,-387,0,725,0,-296,0,
    0,0,-16,0,22],6],[[-70,0,410,0,-630,0,270],0]
    ,
    [[-10,0,5,0,-15,0,96,0,-161,0,80,0,-40,0,45,0,9,0,
    -33,0,-10,0,15,0,0,0,0,0,-1],24],
    [[5,0,-32,0,12,0,174,0,-255,0,-12,0,203,0,-102,0,0,
    0,0,0,3],6],
    [[51,0,-225,0,323,0,-159,0,-16,0,22],4],
    [[6,0,-17,0,9,0,3,0,-5],34],
    [[3,0,-6,0,12,0,9,0,-15,0,0,0,4,0,-3],18],
    [[-14,0,116,0,-354,0,490,0,-324,0,82],0],
    [[-215,0,900,0,-1180,0,495],0],
    [[5,0,0,0,4,0,-25,0,11,0,-12,0,30,0,-9,0,-5,0,-1,
    0,2],26],
    [[-6,0,6,0,12,0,-21,0,-36,0,80,0,-49,0,9,0,-2,0,4],
    20],[[-9,0,-9,0,15],22],
    [[-43,0,288,0,-750,0,959,0,-600,0,150],0],
    [[14,0,-73,0,131,0,-90,0,22],2],
    [[-23,0,176,0,-483,0,646,0,-419,0,106],0],
    [[-2,0,8,0,5,0,-15,0,7],22],
    [[2,0,-5,0,1,0,7,0,-6,0,2],24],
    [[-2,0,14,0,-25,0,15,0,3,0,-4],10],
    [[5,0,-34,0,69,0,-52,0,13],2],
    [[5,0,-23,0,38,0,-22,0,-3,0,8,0,-2],12],
    [[-10,0,27,0,-20,0,3],4],
    [[1,0,2,0,-8,0,17,0,-15,0,-2,0,6,0,-1],10],
    [[1,0,0,0,-1],18],[[1,0,-3,0,4,0,-2],6],
    [[-2,0,32,0,-126,0,202,0,-142,0,36],0],
    [[-1,0,3,0,-2],14],
    [[-4,0,14,0,10,0,-85,0,121,0,-30,0,-82,0,79,0,-21,0,
    0,0,-1,0,1],8],
    [[5,0,-50,0,101,0,-57,0,0,0,3],4],
    [[-7,0,70,0,-226,0,329,0,-226,0,58],0],
    [[-1,0,-9,0,19,0,-10,0,-5,0,5,0,-1],14],
    [[-8,0,30,0,-50,0,40,0,-13,0,-1,0,1],6],
    [[1],10],[[-2,0,1],8],[[-2,0,1],12],
    [[-1,0,7,0,-15,0,15,0,-7,0,1],4],[[],0],
    [[3,0,-7,0,6,0,-2],8],[[],0],
    [[1,0,-10,0,33,0,-55,0,50,0,-23,0,4],2],
    [[1,0,-2,0,2,0,-1],8],
    [[-1,0,6,0,-14,0,13,0,-5,0,1],4],
    [[2,0,-7,0,6,0,-1],10],
    [[4,0,-25,0,72,0,-112,0,95,0,-42,0,8],2],
    [[-2,0,2],14]],
    [[[4200],0],[[4200],108],[[38,0,0,0,0,0,-544,0,864,
    0,0,0,-596,0,0,0,342,0,-128],0],
    [[1270,0,-2080,0,850],0],
    [[-12,0,5,0,0,0,105,0,-80,0,-111,0,0,0,230,0,-300,0,
    645,0,-752,0,375,0,-120,0,55],10],[[40],54],
    [[384,0,-1256,0,1548,0,-840,0,172],0],
    [[900,0,-1410,0,480],0],
    [[-60,0,0,0,90,0,0,0,-60],56],[[-30],72],
    [[-30],36],
    [[6,0,0,0,18,0,-72,0,84,0,0,0,-33,0,0,0,12],12],
    [[-9,0,30,0,-6],36],
    [[193,0,-604,0,679,0,-324,0,53],0],
    [[-2,0,20,0,-32,0,12,0,-1],36],
    [[38,0,0,0,-288,0,356,0,-114],0],
    [[2,0,0,0,-36,0,44,0,-18],54],
    [[-4,0,-6,0,30,0,-23,0,-44,0,56,0,-14,0,-3],6],
    [[149,0,-467,0,510,0,-223,0,31],0],
    [[2,0,-1,0,0,0,-56,0,158,0,-98,0,-136,0,210,0,-71,0,
    -23,0,17,0,-2],0],[[],0],
    [[17,0,-82,0,146,0,-132,0,62,0,-12,0,1],0],
    [[65,0,-205,0,200,0,-65,0,5],0],[[],0],[[],0],
    [[],0],
    [[9,0,-13,0,3,0,-112,0,373,0,-352,0,-35,0,196,0,2,0,
    -145,0,80,0,-12],0],
    [[38,0,-136,0,124,0,-32],0],
    [[-1,0,8,0,-17,0,4],36],
    [[272,0,-872,0,1026,0,-524,0,96],0],
    [[-14,0,38,0,-6,0,-69,0,70,0,-17,0,-6,0,2],6],
    [[-2],18],[[-6,0,2,0,28,0,-25,0,4],6],
    [[4,0,-13,0,20,0,-8],38],
    [[-3,0,12,0,3,0,-38,0,39,0,-10],6],
    [[9,0,-41,0,77,0,-64,0,25,0,-3],0],
    [[59,0,-276,0,545,0,-558,0,313,0,-92,0,10],0],
    [[-1,0,-8,0,32,0,-26,0,4],4],[[2,0,-1],20],
    [[7,0,-35,0,61,0,-50,0,18,0,-2],0],
    [[2,0,-11,0,18,0,-12,0,3],0],[[],0],
    [[2,0,-12,0,24,0,-18,0,4],0],
    [[-8,0,19,0,-14,0,3],4],[[],0],
    [[-3,0,9,0,-6],4],[[],0],[[],0],[[],0],
    [[20,0,-94,0,175,0,-161,0,74,0,-15,0,1],0],
    [[-2,0,4,0,-2],2],[[],0],
    [[9,0,-13,0,-60,0,170,0,-177,0,81,0,-12],0],
    [[-4,0,2],40],[[-1,0,0,0,0,0,-1],18],
    [[-1,0,-1],18],[[2,0,-1],4],[[-1,0,0,0,2],18],
    [[32,0,-150,0,283,0,-273,0,140,0,-35,0,3],0],
    [[2,0,-1,0,-32,0,80,0,-73,0,26,0,-2],0],[[],0],
    [[14,0,-66,0,119,0,-104,0,46,0,-9],0],[[],0],
    [[],0],[[],0],[[-2310,0,1890],0],
    [[189,0,-483,0,0,0,0,0,315,0,-189,0,378,0,-630],46],
    [[-698,0,1716,0,-1404,0,382],0],
    [[-22,0,16,0,0,0,296,0,-725,0,387,0,330,0,-266,0,
    -189,0,225,0,-56],0],
    [[-270,0,630,0,-410,0,70],0],
    [[1,0,0,0,0,0,-15,0,10,0,33,0,-9,0,-45,0,40,0,-80,
    0,161,0,-96,0,15,0,-5,0,10],10],
    [[-3,0,0,0,0,0,102,0,-203,0,12,0,255,0,-174,0,-12,0,
    32,0,-5],0],
    [[-22,0,16,0,159,0,-323,0,225,0,-51],0],
    [[5,0,-3,0,-9,0,17,0,-6],24],
    [[3,0,-4,0,0,0,15,0,-9,0,-12,0,6,0,-3],10],
    [[-82,0,324,0,-490,0,354,0,-116,0,14],0],
    [[-495,0,1180,0,-900,0,215],0],
    [[-2,0,1,0,5,0,9,0,-30,0,12,0,-11,0,25,0,-4,0,0,0,
    -5],16],
    [[-4,0,2,0,-9,0,49,0,-80,0,36,0,21,0,-12,0,-6,0,6],
    12],[[-15,0,9,0,9],16],
    [[-150,0,600,0,-959,0,750,0,-288,0,43],0],
    [[-22,0,90,0,-131,0,73,0,-14],0],
    [[-106,0,419,0,-646,0,483,0,-176,0,23],0],
    [[-7,0,15,0,-5,0,-8,0,2],16],
    [[-2,0,6,0,-7,0,-1,0,5,0,-2],16],
    [[4,0,-3,0,-15,0,25,0,-14,0,2],6],
    [[-13,0,52,0,-69,0,34,0,-5],0],
    [[2,0,-8,0,3,0,22,0,-38,0,23,0,-5],6],
    [[-3,0,20,0,-27,0,10],0],
    [[1,0,-6,0,2,0,15,0,-17,0,8,0,-2,0,-1],6],
    [[1,0,0,0,-1],12],[[2,0,-4,0,3,0,-1],2],
    [[-36,0,142,0,-202,0,126,0,-32,0,2],0],
    [[2,0,-3,0,1],12],
    [[-1,0,1,0,0,0,21,0,-79,0,82,0,30,0,-121,0,85,0,
    -10,0,-14,0,4],0],
    [[-3,0,0,0,57,0,-101,0,50,0,-5],0],
    [[-58,0,226,0,-329,0,226,0,-70,0,7],0],
    [[1,0,-5,0,5,0,10,0,-19,0,9,0,1],8],
    [[-1,0,1,0,13,0,-40,0,50,0,-30,0,8],0],[[-1],4],
    [[-1,0,2],4],[[-1,0,2],8],
    [[-1,0,7,0,-15,0,15,0,-7,0,1],0],[[],0],
    [[2,0,-6,0,7,0,-3],4],[[],0],
    [[-4,0,23,0,-50,0,55,0,-33,0,10,0,-1],0],
    [[1,0,-2,0,2,0,-1],4],
    [[-1,0,5,0,-13,0,14,0,-6,0,1],0],
    [[1,0,-6,0,7,0,-2],6],
    [[-8,0,42,0,-95,0,112,0,-72,0,25,0,-4],0],
    [[-2,0,2],10]],
    [[[6075],0],[[6075],128],[[9,0,0,0,0,0,-288,0,621,
    0,0,0,-720,0,0,0,1080,0,-720,0,0,0,0,0,45],0],
    [[1305,0,-3060,0,1710],0],
    [[-24,0,0,0,60,0,-120,0,705,0,-1296,0,900,0,-300,0,
    170,0,0,0,-108,0,-100,0,75,0,0,0,5,0,-12],20],
    [[-45],64],[[267,0,-1308,0,2304,0,-1740,0,456],0],
    [[810,0,-2025,0,1215],0],[[],0],[[],0],
    [[],0],
    [[-24,0,36,0,0,0,-21,0,0,0,72,0,-96,0,27,0,0,0,6],
    18],[[],0],[[90,0,-540,0,1035,0,-810,0,225],0],
    [[],0],[[9,0,0,0,-207,0,504,0,-360,0,0,0,45],0],
    [[-3,0,0,0,9,0,-48,0,36,0,0,0,-3],64],
    [[4,0,-12,0,-20,0,69,0,-52,0,-22,0,40,0,-4,0,-4],10
    ],[[63,0,-384,0,777,0,-627,0,174],0],
    [[-8,0,46,0,-58,0,-90,0,260,0,-130,0,-136,0,179,0,
    -59,0,0,0,-2,0,1],6],[[3],32],
    [[1,0,-24,0,115,0,-222,0,209,0,-90,0,14],0],
    [[15,0,-135,0,315,0,-270,0,75],0],[[],0],
    [[],0],[[],0],
    [[-3,0,3,0,-24,0,159,0,-279,0,42,0,240,0,42,0,-468,
    0,420,0,-132,0,9,0,-15,0,6],2],
    [[9,0,-72,0,198,0,-180,0,45],0],[[],0],
    [[159,0,-837,0,1545,0,-1188,0,321],0],
    [[6,0,-10,0,-32,0,86,0,-58,0,-10,0,34,0,-16],8],
    [[],0],[[12,0,-33,0,24,0,3,0,-6],10],[[],0],
    [[3,0,-21,0,42,0,-36,0,3,0,12,0,-3],10],
    [[-9,0,51,0,-111,0,111,0,-48,0,6],2],
    [[16,0,-152,0,515,0,-866,0,767,0,-332,0,52],0],
    [[15,0,-42,0,38,0,-10,0,-1],8],[[],0],
    [[-6,0,40,0,-91,0,90,0,-38,0,5],2],
    [[9,0,-28,0,28,0,-11,0,1],4],[[-1],20],
    [[-1,0,12,0,-34,0,37,0,-14,0,1],2],
    [[8,0,-27,0,26,0,-6],6],
    [[1,0,0,0,-1,0,0,0,1],32],
    [[3,0,-12,0,12,0,-3],6],[[],0],[[],0],
    [[],0],
    [[2,0,-32,0,137,0,-264,0,250,0,-109,0,16],0],
    [[1,0,-6,0,7,0,-2],4],[[],0],
    [[-3,0,-18,0,135,0,-276,0,222,0,-51,0,-15,0,6],2],
    [[],0],[[],0],[[],0],[[-3,0,3],6],
    [[],0],
    [[5,0,-63,0,243,0,-438,0,400,0,-174,0,27],0],
    [[-7,0,50,0,-116,0,105,0,-31,0,-2,0,1],4],
    [[],0],[[1,0,-17,0,88,0,-180,0,170,0,-73,0,11],0]
    ,[[],0],[[],0],[[],0],[[-2835,0,3240],0],
    [[378,0,-84,0,0,0,0,0,189,0,-378,0,783,0,-315,0,0,0,
    -189,0,210,0,-189],58],
    [[-594,0,2133,0,-2457,0,891],0],
    [[-3,0,6,0,0,0,120,0,-438,0,351,0,342,0,-378,0,-540,
    0,888,0,-372,0,0,0,-24,0,21],0],
    [[-150,0,660,0,-870,0,345],0],
    [[-9,0,0,0,-1,0,-45,0,197,0,-263,0,125,0,-39,0,30,0,
    17,0,-23,0,-10,0,5,0,0,0,1],22],
    [[21,0,-81,0,21,0,222,0,-279,0,-21,0,243,0,-120,0,0,
    0,0,0,3],6],
    [[-3,0,6,0,90,0,-351,0,450,0,-180,0,-24,0,21],0],
    [[10,0,0,0,-3,0,-17,0,15,0,6,0,-2],30],
    [[-6,0,-9,0,18,0,5,0,-18,0,0,0,7],18],
    [[-26,0,207,0,-572,0,721,0,-414,0,85],0],
    [[-360,0,1395,0,-1665,0,630],0],
    [[-9,0,0,0,49,0,-76,0,36,0,4,0,5,0,-9,0,1,0,-1],
    26],
    [[8,0,-28,0,24,0,11,0,-10,0,-42,0,78,0,-57,0,18,0,
    -4,0,2],18],[[-3,0,9,0,-9,0,3],20],
    [[-69,0,468,0,-1173,0,1398,0,-783,0,159],0],
    [[-3,0,36,0,-132,0,195,0,-117,0,21],0],
    [[-39,0,291,0,-777,0,948,0,-534,0,111],0],
    [[-2,0,4,0,-5,0,8,0,-7,0,2],20],
    [[-1,0,1,0,-2,0,3,0,-1,0,3,0,-4,0,1],20],
    [[-4,0,23,0,-32,0,9,0,6,0,-2],10],
    [[15,0,-72,0,108,0,-63,0,12],2],
    [[-1,0,10,0,-33,0,42,0,-18,0,-6,0,7,0,-1],10],
    [[3,0,-24,0,45,0,-24,0,3],2],
    [[2,0,1,0,-15,0,21,0,-6,0,-3,0,4,0,-1],10],
    [[-1],20],[[4,0,-8,0,6,0,-1],6],
    [[-6,0,66,0,-222,0,303,0,-177,0,36],0],
    [[1,0,-4,0,3,0,-1,0,1],12],
    [[1,0,-13,0,36,0,-1,0,-116,0,137,0,4,0,-106,0,77,0,
    -19,0,1,0,-1],6],
    [[18,0,-90,0,135,0,-66,0,0,0,3],4],
    [[-13,0,127,0,-381,0,489,0,-281,0,59],0],
    [[1,0,1,0,-15,0,20,0,-8,0,-3,0,5,0,-1],12],
    [[1,0,-15,0,55,0,-79,0,47,0,-8,0,-1],4],
    [[-1,0,1],8],[[1,0,-3,0,2],6],
    [[1,0,-2,0,1],10],[[-4,0,17,0,-29,0,21,0,-6],4],
    [[-1],10],[[-1,0,7,0,-13,0,8,0,-1],6],[[],0],
    [[2,0,-21,0,64,0,-93,0,67,0,-21,0,2],2],
    [[3,0,-6,0,3],8],[[-3,0,14,0,-25,0,19,0,-5],4],
    [[6,0,-11,0,6,0,-1],10],
    [[8,0,-49,0,130,0,-179,0,128,0,-42,0,4],2],
    [[2,0,-4,0,2],12]],
    [[[6075],0],[[6075],112],[[45,0,0,0,0,0,-720,0,1080,
    0,0,0,-720,0,0,0,621,0,-288,0,0,0,0,0,9],0],
    [[1710,0,-3060,0,1305],0],
    [[-12,0,5,0,0,0,75,0,-100,0,-108,0,0,0,170,0,-300,0,
    900,0,-1296,0,705,0,-120,0,60,0,0,0,-24],10],
    [[-45],56],[[456,0,-1740,0,2304,0,-1308,0,267],0],
    [[1215,0,-2025,0,810],0],[[],0],[[],0],
    [[],0],
    [[6,0,0,0,27,0,-96,0,72,0,0,0,-21,0,0,0,36,0,-24],
    12],[[],0],[[225,0,-810,0,1035,0,-540,0,90],0],
    [[],0],[[45,0,0,0,-360,0,504,0,-207,0,0,0,9],0],
    [[-3,0,0,0,36,0,-48,0,9,0,0,0,-3],56],
    [[-4,0,-4,0,40,0,-22,0,-52,0,69,0,-20,0,-12,0,4],6]
    ,[[174,0,-627,0,777,0,-384,0,63],0],
    [[1,0,-2,0,0,0,-59,0,179,0,-136,0,-130,0,260,0,-90,
    0,-58,0,46,0,-8],0],[[3],28],
    [[14,0,-90,0,209,0,-222,0,115,0,-24,0,1],0],
    [[75,0,-270,0,315,0,-135,0,15],0],[[],0],
    [[],0],[[],0],
    [[6,0,-15,0,9,0,-132,0,420,0,-468,0,42,0,240,0,42,0,
    -279,0,159,0,-24,0,3,0,-3],0],
    [[45,0,-180,0,198,0,-72,0,9],0],[[],0],
    [[321,0,-1188,0,1545,0,-837,0,159],0],
    [[-16,0,34,0,-10,0,-58,0,86,0,-32,0,-10,0,6],6],
    [[],0],[[-6,0,3,0,24,0,-33,0,12],6],[[],0],
    [[-3,0,12,0,3,0,-36,0,42,0,-21,0,3],6],
    [[6,0,-48,0,111,0,-111,0,51,0,-9],0],
    [[52,0,-332,0,767,0,-866,0,515,0,-152,0,16],0],
    [[-1,0,-10,0,38,0,-42,0,15],4],[[],0],
    [[5,0,-38,0,90,0,-91,0,40,0,-6],0],
    [[1,0,-11,0,28,0,-28,0,9],0],[[-1],16],
    [[1,0,-14,0,37,0,-34,0,12,0,-1],0],
    [[-6,0,26,0,-27,0,8],4],
    [[1,0,0,0,-1,0,0,0,1],28],
    [[-3,0,12,0,-12,0,3],4],[[],0],[[],0],
    [[],0],
    [[16,0,-109,0,250,0,-264,0,137,0,-32,0,2],0],
    [[-2,0,7,0,-6,0,1],2],[[],0],
    [[6,0,-15,0,-51,0,222,0,-276,0,135,0,-18,0,-3],0],
    [[],0],[[],0],[[],0],[[3,0,-3],4],
    [[],0],
    [[27,0,-174,0,400,0,-438,0,243,0,-63,0,5],0],
    [[1,0,-2,0,-31,0,105,0,-116,0,50,0,-7],0],
    [[],0],[[11,0,-73,0,170,0,-180,0,88,0,-17,0,1],0]
    ,[[],0],[[],0],[[],0],[[-3240,0,2835],0],
    [[189,0,-210,0,189,0,0,0,315,0,-783,0,378,0,-189,0,0,
    0,0,0,84,0,-378],46],
    [[-891,0,2457,0,-2133,0,594],0],
    [[-21,0,24,0,0,0,372,0,-888,0,540,0,378,0,-342,0,
    -351,0,438,0,-120,0,0,0,-6,0,3],0],
    [[-345,0,870,0,-660,0,150],0],
    [[-1,0,0,0,-5,0,10,0,23,0,-17,0,-30,0,39,0,-125,0,
    263,0,-197,0,45,0,1,0,0,0,9],12],
    [[-3,0,0,0,0,0,120,0,-243,0,21,0,279,0,-222,0,-21,0,
    81,0,-21],0],
    [[-21,0,24,0,180,0,-450,0,351,0,-90,0,-6,0,3],0],
    [[2,0,-6,0,-15,0,17,0,3,0,0,0,-10],24],
    [[-7,0,0,0,18,0,-5,0,-18,0,9,0,6],12],
    [[-85,0,414,0,-721,0,572,0,-207,0,26],0],
    [[-630,0,1665,0,-1395,0,360],0],
    [[1,0,-1,0,9,0,-5,0,-4,0,-36,0,76,0,-49,0,0,0,9],
    18],
    [[-2,0,4,0,-18,0,57,0,-78,0,42,0,10,0,-11,0,-24,0,
    28,0,-8],12],[[-3,0,9,0,-9,0,3],16],
    [[-159,0,783,0,-1398,0,1173,0,-468,0,69],0],
    [[-21,0,117,0,-195,0,132,0,-36,0,3],0],
    [[-111,0,534,0,-948,0,777,0,-291,0,39],0],
    [[-2,0,7,0,-8,0,5,0,-4,0,2],16],
    [[-1,0,4,0,-3,0,1,0,-3,0,2,0,-1,0,1],16],
    [[2,0,-6,0,-9,0,32,0,-23,0,4],6],
    [[-12,0,63,0,-108,0,72,0,-15],0],
    [[1,0,-7,0,6,0,18,0,-42,0,33,0,-10,0,1],6],
    [[-3,0,24,0,-45,0,24,0,-3],0],
    [[1,0,-4,0,3,0,6,0,-21,0,15,0,-1,0,-2],6],
    [[1],14],[[1,0,-6,0,8,0,-4],2],
    [[-36,0,177,0,-303,0,222,0,-66,0,6],0],
    [[-1,0,1,0,-3,0,4,0,-1],10],
    [[1,0,-1,0,19,0,-77,0,106,0,-4,0,-137,0,116,0,1,0,
    -36,0,13,0,-1],2],
    [[-3,0,0,0,66,0,-135,0,90,0,-18],0],
    [[-59,0,281,0,-489,0,381,0,-127,0,13],0],
    [[1,0,-5,0,3,0,8,0,-20,0,15,0,-1,0,-1],8],
    [[1,0,8,0,-47,0,79,0,-55,0,15,0,-1],2],
    [[-1,0,1],4],[[-2,0,3,0,-1],4],
    [[-1,0,2,0,-1],8],[[6,0,-21,0,29,0,-17,0,4],2],
    [[1],8],[[1,0,-8,0,13,0,-7,0,1],4],[[],0],
    [[-2,0,21,0,-67,0,93,0,-64,0,21,0,-2],0],
    [[-3,0,6,0,-3],6],[[5,0,-19,0,25,0,-14,0,3],2],
    [[1,0,-6,0,11,0,-6],6],
    [[-4,0,42,0,-128,0,179,0,-130,0,49,0,-8],0],
    [[-2,0,4,0,-2],10]],
    [[[8],0],[[-8],210],[[-4,0,0,0,0,0,4],18],
    [[-2,0,6],2],[[-6,0,0,0,0,0,0,0,0,0,2],50],
    [[],0],[[-4,0,4],6],[[-1,0,6],2],
    [[-6,0,0,0,0,0,0,0,1],110],[[-4],140],
    [[4],70],[[-3,0,0,0,0,0,0,0,2],40],
    [[-2,0,3],72],[[-2,0,4],6],[[-4,0,2],76],
    [[4],12],[[-4],114],[[-2,0,0,0,0,0,2],26],
    [[-2,0,4],6],[[-3,0,0,0,-1,0,2],22],[[],0],
    [[-2,0,2],10],[[-1,0,4],6],[[-4,0,0,0,1],54],
    [[-2],84],[[2],42],[[-4,0,0,0,-1,0,2],22],
    [[-1,0,4],6],[[-2,0,2],76],[[-3,0,4],6],
    [[-3,0,0,0,0,0,2],22],[[],0],
    [[1,0,0,0,2],20],[[-4,0,1],80],
    [[-2,0,0,0,0,0,2],22],[[-2,0,2],10],
    [[-4,0,2],10],[[2],20],[[],0],[[-2,0,2],10],
    [[-1,0,2],10],[[-1],30],[[-2,0,2],10],
    [[2],16],[[-2],58],[[2],16],[[-2],26],
    [[-1],48],[[1],24],[[-3,0,2],10],
    [[-1,0,2],10],[[],0],[[-1,0,2],14],
    [[-2,0,1],80],[[-2],44],[[2],38],
    [[-1,0,2],10],[[-2,0,1],40],[[-3,0,2],10],
    [[-1,0,2],14],[[],0],[[-2,0,2],10],
    [[-1,0,1],44],[[1],28],[[-1],14],
    [[-1,0,7],0],
    [[-7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],108],
    [[-3,0,5],4],[[-4,0,0,0,-1,0,3],20],
    [[-1,0,5],4],[[-5,0,0,0,0,0,0,0,0,0,1],52],
    [[-3,0,0,0,0,0,3],20],[[-1,0,3],12],
    [[-3,0,0,0,0,0,0,0,0,0,1],56],
    [[-1,0,0,0,0,0,1],36],[[-3,0,3],8],
    [[-2,0,5],4],[[-5,0,0,0,1,0,0,0,0,0,1],52],
    [[-3,0,0,0,0,0,-1,0,1],42],
    [[2,0,0,0,0,0,1],36],[[-4,0,3],8],
    [[-2,0,3],8],[[-3,0,3],8],
    [[-2,0,1,0,0,0,0,0,1],38],
    [[-2,0,0,0,0,0,0,0,1],42],[[1,0,-1,0,1],22],
    [[-1,0,3],8],[[-2,0,0,0,-1,0,1],24],
    [[-1,0,3],8],[[-3,0,0,0,0,0,1],24],
    [[-1,0,0,0,0,0,1],28],[[-1,0,1],12],
    [[-2,0,3],8],[[-2,0,0,0,0,0,1],24],
    [[-3,0,0,0,-1,0,1],24],[[3],14],[[-2,0,3],8],
    [[-2,0,0,0,0,0,1],28],[[-1,0,1],16],
    [[-1,0,1],12],[[-2,0,1],12],[[1],22],
    [[-2,0,1],12],[[1],18],[[-1,0,1],16],
    [[-1,0,1],12],[[-2,0,1],12],[[1],18],
    [[-2,0,1],12],[[1],22],[[-3,0,1],12],
    [[1,0,0,0,1],22]],
    [[[8],0],[[-8],30],[[4,0,0,0,0,0,-4],0],
    [[6,0,-2],0],[[2,0,0,0,0,0,0,0,0,0,-6],0],
    [[],0],[[4,0,-4],0],[[6,0,-1],0],
    [[1,0,0,0,0,0,0,0,-6],10],[[-4],20],[[4],10],
    [[2,0,0,0,0,0,0,0,-3],0],[[3,0,-2],10],
    [[4,0,-2],0],[[2,0,-4],10],[[4],0],
    [[-4],18],[[2,0,0,0,0,0,-2],0],[[4,0,-2],0],
    [[2,0,-1,0,0,0,-3],0],[[],0],[[2,0,-2],0],
    [[4,0,-1],0],[[1,0,0,0,-4],6],[[-2],12],
    [[2],6],[[2,0,-1,0,0,0,-4],0],[[4,0,-1],0],
    [[2,0,-2],10],[[4,0,-3],0],
    [[2,0,0,0,0,0,-3],0],[[],0],[[2,0,0,0,1],0],
    [[1,0,-4],10],[[2,0,0,0,0,0,-2],0],
    [[2,0,-2],0],[[2,0,-4],0],[[2],0],[[],0],
    [[2,0,-2],0],[[2,0,-1],0],[[-1],6],
    [[2,0,-2],0],[[2],0],[[-2],10],[[2],0],
    [[-2],6],[[-1],8],[[1],4],[[2,0,-3],0],
    [[2,0,-1],0],[[],0],[[2,0,-1],0],
    [[1,0,-2],10],[[-2],8],[[2],6],[[2,0,-1],0],
    [[1,0,-2],6],[[2,0,-3],0],[[2,0,-1],0],
    [[],0],[[2,0,-2],0],[[1,0,-1],6],[[1],4],
    [[-1],2],[[-7,0,1],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7],0],
    [[-5,0,3],0],[[-3,0,1,0,0,0,4],0],
    [[-5,0,1],0],[[-1,0,0,0,0,0,0,0,0,0,5],0],
    [[-3,0,0,0,0,0,3],0],[[-3,0,1],0],
    [[-1,0,0,0,0,0,0,0,0,0,3],0],
    [[-1,0,0,0,0,0,1],0],[[-3,0,3],0],
    [[-5,0,2],0],[[-1,0,0,0,0,0,-1,0,0,0,5],0],
    [[-1,0,1,0,0,0,0,0,3],0],[[-1,0,0,0,0,0,-2],0],
    [[-3,0,4],0],[[-3,0,2],0],[[-3,0,3],0],
    [[-1,0,0,0,0,0,-1,0,2],0],
    [[-1,0,0,0,0,0,0,0,2],0],[[-1,0,1,0,-1],0],
    [[-3,0,1],0],[[-1,0,1,0,0,0,2],0],
    [[-3,0,1],0],[[-1,0,0,0,0,0,3],0],
    [[-1,0,0,0,0,0,1],0],[[-1,0,1],0],
    [[-3,0,2],0],[[-1,0,0,0,0,0,2],0],
    [[-1,0,1,0,0,0,3],0],[[-3],0],[[-3,0,2],0],
    [[-1,0,0,0,0,0,2],0],[[-1,0,1],0],
    [[-1,0,1],0],[[-1,0,2],0],[[-1],0],
    [[-1,0,2],0],[[-1],0],[[-1,0,1],0],
    [[-1,0,1],0],[[-1,0,2],0],[[-1],0],
    [[-1,0,2],0],[[-1],0],[[-1,0,3],0],
    [[-1,0,0,0,-1],0]],
    [[[56],0],[[-56],150],[[-4,0,0,0,0,0,24,0,0,0,0,
    0,-24,0,0,0,0,0,4],6],[[6,0,-30,0,20],0],
    [[-20,0,0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,0,0,-6],
    30],[[],0],[[-4,0,24,0,-24,0,4],2],
    [[6,0,-15,0,20],0],
    [[-20,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,-6],74],
    [[-16],100],[[16],50],
    [[-7,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,-3],24],
    [[3,0,-12,0,7],50],[[-2,0,12,0,-12,0,4],2],
    [[-4,0,12,0,-12,0,2],52],[[8,0,0,0,0,0,4],6],
    [[-4,0,0,0,0,0,-8],78],
    [[-4,0,0,0,2,0,4,0,0,0,-2],16],
    [[-2,0,8,0,-12,0,4],2],
    [[-1,0,0,0,-6,0,6,0,-1,0,8,0,-3,0,0,0,-1],10],
    [[],0],[[-4,0,6,0,-2],6],
    [[-1,0,4,0,-6,0,4],2],
    [[-4,0,0,0,6,0,0,0,-4,0,0,0,1],34],[[-4],60],
    [[4],30],
    [[-4,0,0,0,-6,0,12,0,-4,0,8,0,-4,0,2,0,-1],10],
    [[-1,0,0,0,-6,0,4],2],[[-2,0,6,0,-6,0,2],52],
    [[-3,0,16,0,-18,0,4],2],
    [[-1,0,0,0,0,0,6,0,-1,0,0,0,-3],10],[[],0],
    [[1,0,0,0,4,0,0,0,1],12],[[-10,0,8,0,-4],56],
    [[-2,0,2,0,0,0,2,0,-2],14],[[-2,0,4,0,-2],6],
    [[-10,0,16,0,-4],6],[[-2],10],[[],0],
    [[-2,0,4,0,-2],6],[[-1,0,2,0,-1],6],[[],0],
    [[2,0,-2],8],[[2],10],[[-2],40],[[-1],8],
    [[1],22],[[-1],36],[[1],18],
    [[-4,0,8,0,-3],6],[[-1],10],[[],0],
    [[-2,0,4,0,2,0,-1],8],[[-4,0,3,0,-2],56],
    [[-2,0,0,0,0,0,2],28],[[2,0,-2],26],
    [[1,0,0,0,-1],6],[[1,0,-2,0,2,0,-1],26],
    [[-6,0,10,0,-3],6],[[-2,0,2,0,0,0,-1],8],
    [[],0],[[-3,0,6,0,-2],6],[[-2,0,1],32],
    [[-1],20],[[1],10],[[-21,0,35],0],
    [[-35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21],72],
    [[-1,0,15,0,-30,0,10],0],
    [[-4,0,0,0,-6,0,18,0,0,0,12,0,-12,0,0,0,-3,0,1],8
    ],[[-1,0,5,0,-10,0,10],0],
    [[-10,0,0,0,0,0,0,0,-5,0,10,0,0,0,0,0,0,0,1],32],
    [[-1,0,0,0,-3,0,9,0,0,0,3,0,-9,0,0,0,0,0,1],8],
    [[-2,0,6,0,0,0,-3,0,1],6],
    [[-1,0,-6,0,0,0,0,0,0,0,3,0,2],36],
    [[-3,0,0,0,0,0,3],24],[[-4,0,12,0,-9,0,1],4],
    [[-1,0,10,0,-20,0,10],0],
    [[-10,0,0,0,10,0,0,0,-5,0,10,0,0,0,-5,0,0,0,1],32
    ],[[-7,0,0,0,0,0,-6,0,6,0,0,0,0,0,3],26],
    [[1,0,0,0,0,0,3],24],[[-7,0,21,0,-12,0,1],4],
    [[-1,0,3,0,-6,0,1],4],[[-5,0,15,0,-9,0,1],4],
    [[1,0,-2,0,-1,0,1,0,-2,0,1],24],
    [[-2,0,0,0,0,0,-1,0,3],26],
    [[1,0,-2,0,2,0,-1],14],[[-1,0,3,0,-3,0,1],4],
    [[-3,0,1,0,-1,0,3],16],[[-3,0,1],8],
    [[-1,0,0,0,0,0,3],12],[[-1,0,0,0,0,0,1],18],
    [[-1,0,1],8],[[-2,0,6,0,-6,0,1],4],[[1],18],
    [[-1,0,0,0,-6,0,3,0,-4,0,4,0,0,0,1],12],
    [[-1,0,3,0,0,0,0,0,1],6],[[-3,0,9,0,-6,0,1],4],
    [[-2,0,0,0,0,0,1],18],[[-2,0,1,0,1],10],
    [[],0],[[1,0,1],8],[[-1,0,0,0,-1],12],
    [[-2,0,2],8],[[],0],[[-1],10],[[1],8],
    [[-4,0,3],8],[[1],12],[[-1,0,2],8],
    [[-1],12],[[-6,0,5],8],[[1],18]],
    [[[56],0],[[-56],90],
    [[4,0,0,0,0,0,-24,0,0,0,0,0,24,0,0,0,0,0,-4],0],
    [[20,0,-30,0,6],0],
    [[-6,0,0,0,0,0,0,0,0,0,30,0,0,0,0,0,0,0,0,0,-20],
    10],[[],0],[[4,0,-24,0,24,0,-4],0],
    [[20,0,-15,0,6],0],
    [[-6,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,-20],38],
    [[-16],60],[[16],30],
    [[-3,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,-7],8],
    [[7,0,-12,0,3],30],[[4,0,-12,0,12,0,-2],0],
    [[2,0,-12,0,12,0,-4],30],[[4,0,0,0,0,0,8],0],
    [[-8,0,0,0,0,0,-4],48],
    [[-2,0,0,0,4,0,2,0,0,0,-4],6],
    [[4,0,-12,0,8,0,-2],0],
    [[-1,0,0,0,-3,0,8,0,-1,0,6,0,-6,0,0,0,-1],2],
    [[],0],[[-2,0,6,0,-4],2],
    [[4,0,-6,0,4,0,-1],0],
    [[1,0,0,0,-4,0,0,0,6,0,0,0,-4],18],[[-4],36],
    [[4],18],
    [[-1,0,2,0,-4,0,8,0,-4,0,12,0,-6,0,0,0,-4],2],
    [[4,0,-6,0,0,0,-1],0],[[2,0,-6,0,6,0,-2],30],
    [[4,0,-18,0,16,0,-3],0],
    [[-3,0,0,0,-1,0,6,0,0,0,0,0,-1],6],[[],0],
    [[1,0,0,0,4,0,0,0,1],4],[[-4,0,8,0,-10],32],
    [[-2,0,2,0,0,0,2,0,-2],6],[[-2,0,4,0,-2],2],
    [[-4,0,16,0,-10],2],[[-2],10],[[],0],
    [[-2,0,4,0,-2],2],[[-1,0,2,0,-1],2],[[],0],
    [[-2,0,2],2],[[2],6],[[-2],28],[[-1],8],
    [[1],10],[[-1],20],[[1],10],
    [[-3,0,8,0,-4],2],[[-1],2],[[],0],
    [[-1,0,2,0,4,0,-2],2],[[-2,0,3,0,-4],32],
    [[2,0,0,0,0,0,-2],18],[[-2,0,2],16],
    [[-1,0,0,0,1],2],[[-1,0,2,0,-2,0,1],16],
    [[-3,0,10,0,-6],2],[[-1,0,0,0,2,0,-2],2],
    [[],0],[[-2,0,6,0,-3],2],[[1,0,-2],18],
    [[-1],12],[[1],6],[[-35,0,21],0],
    [[-21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35],36],
    [[-10,0,30,0,-15,0,1],0],
    [[-1,0,3,0,0,0,12,0,-12,0,0,0,-18,0,6,0,0,0,4],0]
    ,[[-10,0,10,0,-5,0,1],0],
    [[-1,0,0,0,0,0,0,0,-10,0,5,0,0,0,0,0,0,0,10],12],
    [[-1,0,0,0,0,0,9,0,-3,0,0,0,-9,0,3,0,0,0,1],0],
    [[-1,0,3,0,0,0,-6,0,2],0],
    [[-2,0,-3,0,0,0,0,0,0,0,6,0,1],18],
    [[-3,0,0,0,0,0,3],12],[[-1,0,9,0,-12,0,4],0],
    [[-10,0,20,0,-10,0,1],0],
    [[-1,0,0,0,5,0,0,0,-10,0,5,0,0,0,-10,0,0,0,10],12
    ],[[-3,0,0,0,0,0,-6,0,6,0,0,0,0,0,7],10],
    [[-3,0,0,0,0,0,-1],12],[[-1,0,12,0,-21,0,7],0],
    [[-1,0,6,0,-3,0,1],0],[[-1,0,9,0,-15,0,5],0],
    [[-1,0,2,0,-1,0,1,0,2,0,-1],12],
    [[-3,0,1,0,0,0,0,0,2],16],[[1,0,-2,0,2,0,-1],6]
    ,[[-1,0,3,0,-3,0,1],0],[[-3,0,1,0,-1,0,3],8],
    [[-1,0,3],0],[[-3,0,0,0,0,0,1],12],
    [[-1,0,0,0,0,0,1],10],[[-1,0,1],4],
    [[-1,0,6,0,-6,0,2],0],[[-1],12],
    [[-1,0,0,0,-4,0,4,0,-3,0,6,0,0,0,1],4],
    [[-1,0,0,0,0,0,-3,0,1],0],[[-1,0,6,0,-9,0,3],0]
    ,[[-1,0,0,0,0,0,2],10],[[-1,0,-1,0,2],4],
    [[],0],[[-1,0,-1],4],[[1,0,0,0,1],6],
    [[-2,0,2],4],[[],0],[[1],8],[[-1],6],
    [[-3,0,4],4],[[-1],6],[[-2,0,1],4],[[1],10],
    [[-5,0,6],4],[[-1],8]],
    [[[112],0],[[-112],180],
    [[-8,0,0,0,36,0,-48,0,0,0,0,0,20],12],
    [[6,0,-44,0,62],0],
    [[-24,0,-20,0,30,0,0,0,10,0,-24,0,0,0,0,0,0,0,0,0,
    4],40],[[],0],[[-4,0,24,0,-52,0,32],2],
    [[1,0,-27,0,57],0],
    [[-30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1],92],
    [[4],120],[[-4],60],
    [[3,0,0,0,6,0,0,0,-9,0,0,0,0,0,0,0,4],32],
    [[-1,0,0,0,-3],60],[[8,0,-30,0,26],4],
    [[-2,0,0,0,-2],64],[[-12,0,0,0,20],8],
    [[-8],96],[[4,0,0,0,-8,0,0,0,0,0,4],22],
    [[6,0,-27,0,25],4],
    [[-3,0,-5,0,20,0,-18,0,0,0,-4,0,6],16],[[],0],
    [[6,0,-14,0,8],8],[[1,0,-15,0,21],4],
    [[-6,0,0,0,0,0,0,0,-1],44],[[2],72],[[-2],36],
    [[-8,0,-9,0,30,0,-24,0,1,0,-6,0,7],16],
    [[1,0,-12,0,20],4],[[2,0,0,0,-2],64],
    [[-1,0,15,0,-40,0,29],2],
    [[-3,0,0,0,10,0,-14,0,0,0,0,0,4],16],[[],0],
    [[-1,0,-6,0,3,0,0,0,4],16],[[1,0,0,0,-1],68],
    [[-1,0,0,0,6,0,-9,0,0,0,0,0,4],16],
    [[5,0,-12,0,7],8],[[-4,0,20,0,-28,0,12],6],
    [[-2,0,-2,0,0,0,4],14],[[],0],
    [[4,0,-11,0,7],8],[[1,0,-6,0,5],8],[[],0],
    [[3,0,-9,0,6],8],[[-4,0,0,0,4],12],[[],0],
    [[-3,0,0,0,4],12],[[-1],20],[[1],40],
    [[-1],20],[[-1,0,9,0,-18,0,9],6],
    [[1,0,-4,0,4],8],[[],0],
    [[3,0,-5,0,-6,0,7],10],[[2,0,0,0,-1],68],
    [[2],36],[[-2],32],[[1,0,-3,0,4],8],
    [[-1,0,0,0,-1],32],[[-1,0,12,0,-20,0,10],6],
    [[2,0,-5,0,-4,0,6],10],[[],0],
    [[6,0,-13,0,8],8],[[-1],40],[[-1],24],
    [[1],12],[[-28,0,84],0],
    [[-56,0,0,0,0,0,-21,0,27,0,0,0,0,0,0,0,0,0,-7,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],90],
    [[-1,0,15,0,-51,0,45],0],
    [[-8,0,-9,0,39,0,-36,0,0,0,-7,0,13],14],
    [[1,0,-21,0,36],2],
    [[-15,0,-10,0,15,0,0,0,4,0,-11,0,0,0,0,0,0,0,0,0,
    1],42],[[-3,0,0,0,18,0,-25,0,0,0,0,0,10],14
    ],[[3,0,-9,0,-7,0,13],8],
    [[-1,0,3,0,0,0,0,0,-3,0,0,0,0,0,0,0,0,0,1],48],
    [[4,0,-3,0,0,0,-2,0,0,0,0,0,1],30],
    [[-1,0,12,0,-28,0,17],4],[[7,0,-37,0,41],2],
    [[-10,0,-5,0,9,0,0,0,-1,0,-6,0,0,0,1,0,0,0,0,0,1]
    ,42],
    [[3,0,-2,0,4,0,3,0,-6,0,0,0,0,0,-2,0,2],34],
    [[-2,0,-3,0,0,0,2,0,0,0,0,0,1],30],
    [[-4,0,22,0,-39,0,20],4],[[4,0,-16,0,13],6],
    [[-1,0,15,0,-30,0,18],4],
    [[-1,0,0,0,1,0,-2,0,-2,0,1,0,0,0,0,0,1],30],
    [[2,0,0,0,2,0,-1,0,-2,0,0,0,0,0,0,0,1],34],
    [[1,0,-5,0,2,0,-2,0,2],18],[[1,0,-10,0,11],6],
    [[-1,0,-2,0,7,0,-6,0,0,0,-2,0,2],18],
    [[1,0,-7,0,10],6],
    [[-3,0,0,0,5,0,-7,0,0,0,0,0,1],18],
    [[1,0,-1,0,-1,0,0,0,0,0,1],24],
    [[1,0,-3,0,2],10],[[5,0,-18,0,14],6],
    [[-1,0,0,0,2,0,-3,0,0,0,0,0,1],18],
    [[-3,0,-5,0,15,0,-11,0,1,0,-3,0,3],18],
    [[-7,0,0,0,10],10],[[7,0,-21,0,15],6],
    [[2,0,0,0,-4,0,0,0,0,0,1],24],
    [[2,0,-2,0,-3,0,3],12],[[1,0,-2,0,1],10],
    [[2,0,-4,0,2],10],[[-1,0,0,0,0,0,1],16],
    [[3,0,-6,0,3],10],[[-1,0,0,0,1],14],
    [[1,0,-2,0,-2,0,2],12],[[1,0,-1,0,1],10],
    [[5,0,-8,0,4],10],[[-2,0,0,0,1],14],
    [[4,0,-6,0,3],10],[[-1,0,-1,0,0,0,1],16],
    [[-1,0,9,0,-12,0,5],8],
    [[-1,0,-2,0,1,0,0,0,1],18]],
    [[[112],0],[[-112],60],
    [[20,0,0,0,0,0,-48,0,36,0,0,0,-8],0],
    [[62,0,-44,0,6],0],
    [[4,0,0,0,0,0,0,0,0,0,-24,0,10,0,0,0,30,0,-20,0,
    -24],0],[[],0],[[32,0,-52,0,24,0,-4],0],
    [[57,0,-27,0,1],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-30],20],
    [[4],40],[[-4],20],
    [[4,0,0,0,0,0,0,0,-9,0,0,0,6,0,0,0,3],0],
    [[-3,0,0,0,-1],20],[[26,0,-30,0,8],0],
    [[-2,0,0,0,-2],20],[[20,0,0,0,-12],0],
    [[-8],36],[[4,0,0,0,0,0,-8,0,0,0,4],0],
    [[25,0,-27,0,6],0],
    [[6,0,-4,0,0,0,-18,0,20,0,-5,0,-3],0],[[],0],
    [[8,0,-14,0,6],0],[[21,0,-15,0,1],0],
    [[-1,0,0,0,0,0,0,0,-6],12],[[2],24],[[-2],12],
    [[7,0,-6,0,1,0,-24,0,30,0,-9,0,-8],0],
    [[20,0,-12,0,1],0],[[-2,0,0,0,2],20],
    [[29,0,-40,0,15,0,-1],0],
    [[4,0,0,0,0,0,-14,0,10,0,0,0,-3],0],[[],0],
    [[4,0,0,0,3,0,-6,0,-1],0],[[-1,0,0,0,1],20],
    [[4,0,0,0,0,0,-9,0,6,0,0,0,-1],0],
    [[7,0,-12,0,5],0],[[12,0,-28,0,20,0,-4],0],
    [[4,0,0,0,-2,0,-2],0],[[],0],
    [[7,0,-11,0,4],0],[[5,0,-6,0,1],0],[[],0],
    [[6,0,-9,0,3],0],[[4,0,0,0,-4],0],[[],0],
    [[4,0,0,0,-3],0],[[-1],12],[[1],16],
    [[-1],8],[[9,0,-18,0,9,0,-1],0],
    [[4,0,-4,0,1],0],[[],0],[[7,0,-6,0,-5,0,3],0]
    ,[[-1,0,0,0,2],20],[[2],16],[[-2],12],
    [[4,0,-3,0,1],0],[[-1,0,0,0,-1],12],
    [[10,0,-20,0,12,0,-1],0],[[6,0,-4,0,-5,0,2],0],
    [[],0],[[8,0,-13,0,6],0],[[-1],12],[[-1],8],
    [[1],4],[[-84,0,28],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,
    0,0,0,0,0,0,-27,0,21,0,0,0,0,0,56],0],
    [[-45,0,51,0,-15,0,1],0],
    [[-13,0,7,0,0,0,36,0,-39,0,9,0,8],0],
    [[-36,0,21,0,-1],0],
    [[-1,0,0,0,0,0,0,0,0,0,11,0,-4,0,0,0,-15,0,10,0,
    15],0],[[-10,0,0,0,0,0,25,0,-18,0,0,0,3],0]
    ,[[-13,0,7,0,9,0,-3],0],
    [[-1,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,-3,0,1],0],
    [[-1,0,0,0,0,0,2,0,0,0,3,0,-4],0],
    [[-17,0,28,0,-12,0,1],0],[[-41,0,37,0,-7],0],
    [[-1,0,0,0,0,0,-1,0,0,0,6,0,1,0,0,0,-9,0,5,0,10],
    0],[[-2,0,2,0,0,0,0,0,6,0,-3,0,-4,0,2,0,-3],0
    ],[[-1,0,0,0,0,0,-2,0,0,0,3,0,2],0],
    [[-20,0,39,0,-22,0,4],0],[[-13,0,16,0,-4],0],
    [[-18,0,30,0,-15,0,1],0],
    [[-1,0,0,0,0,0,-1,0,2,0,2,0,-1,0,0,0,1],0],
    [[-1,0,0,0,0,0,0,0,2,0,1,0,-2,0,0,0,-2],0],
    [[-2,0,2,0,-2,0,5,0,-1],0],[[-11,0,10,0,-1],0],
    [[-2,0,2,0,0,0,6,0,-7,0,2,0,1],0],
    [[-10,0,7,0,-1],0],
    [[-1,0,0,0,0,0,7,0,-5,0,0,0,3],0],
    [[-1,0,0,0,0,0,1,0,1,0,-1],0],
    [[-2,0,3,0,-1],0],[[-14,0,18,0,-5],0],
    [[-1,0,0,0,0,0,3,0,-2,0,0,0,1],0],
    [[-3,0,3,0,-1,0,11,0,-15,0,5,0,3],0],
    [[-10,0,0,0,7],0],[[-15,0,21,0,-7],0],
    [[-1,0,0,0,0,0,4,0,0,0,-2],0],
    [[-3,0,3,0,2,0,-2],0],[[-1,0,2,0,-1],0],
    [[-2,0,4,0,-2],0],[[-1,0,0,0,0,0,1],0],
    [[-3,0,6,0,-3],0],[[-1,0,0,0,1],0],
    [[-2,0,2,0,2,0,-1],0],[[-1,0,1,0,-1],0],
    [[-4,0,8,0,-5],0],[[-1,0,0,0,2],0],
    [[-3,0,6,0,-4],0],[[-1,0,0,0,1,0,1],0],
    [[-5,0,12,0,-9,0,1],0],
    [[-1,0,0,0,-1,0,2,0,1],0]],
    [[[160],0],[[-160],168],
    [[8,0,0,0,36,0,-64,0,0,0,0,0,20],12],
    [[12,0,-72,0,76],0],
    [[-40,0,0,0,6,0,0,0,30,0,0,0,10,0,-24,0,0,0,0,0,
    0,0,0,0,2],36],[[],0],
    [[-8,0,48,0,-72,0,32],2],[[6,0,-42,0,70],0],
    [[-64,0,15,0,0,0,20,0,0,0,-6,0,0,0,0,0,0,0,1],86]
    ,[[-20],112],[[20],56],
    [[-8,0,12,0,0,0,4,0,0,0,-12,0,0,0,0,0,0,0,2],30],
    [[3,0,-12,0,11],56],[[-2,0,18,0,-42,0,24],2],
    [[-4,0,12,0,-12,0,6],58],[[8,0,-12,0,0,0,20],6],
    [[-16],90],[[2,0,4,0,0,0,-8,0,0,0,0,0,2],20],
    [[-1,0,14,0,-37,0,24],2],
    [[-3,0,1,0,-6,0,25,0,-17,0,0,0,-4,0,4],14],
    [[],0],[[-2,0,12,0,-14,0,4],6],
    [[5,0,-20,0,20],4],[[-5],40],[[],0],[[],0],
    [[-6,0,-4,0,-13,0,38,0,-20,0,2,0,-7,0,4],14],
    [[2,0,-16,0,20],4],[[4,0,-8,0,4],60],
    [[-4,0,30,0,-56,0,28],2],
    [[1,0,0,0,11,0,-12,0,0,0,0,0,2],16],[[],0],
    [[4,0,-4,0,4,0,0,0,2],16],
    [[-8,0,6,0,-6,0,2],62],
    [[2,0,0,0,6,0,-10,0,0,0,0,0,2],16],
    [[-1,0,9,0,-12,0,4],6],[[-14,0,34,0,-30,0,8],6],
    [[2,0,0,0,-2,0,0,0,2],12],[[],0],
    [[-1,0,8,0,-11,0,4],6],[[3,0,-6,0,2],8],
    [[1],24],[[5,0,-9,0,4],8],
    [[2,0,-4,0,0,0,2],10],[[],0],
    [[1,0,-2,0,0,0,2],10],[[-1],24],[[1],40],
    [[-1],20],[[-4,0,17,0,-18,0,6],6],
    [[1,0,-4,0,2],8],[[],0],
    [[-2,0,7,0,-4,0,-7,0,4],8],[[3,0,-2,0,1],64],
    [[-2],34],[[2],30],[[-4,0,2],10],
    [[1,0,0,0,1],30],[[-6,0,21,0,-21,0,6],6],
    [[-1,0,5,0,-4,0,-4,0,4],8],[[],0],
    [[-2,0,11,0,-14,0,4],6],[[1],36],[[],0],
    [[],0],[[-48,0,112],0],
    [[-105,0,0,0,0,0,21,0,0,0,0,0,0,0,27,0,0,0,0,0,0,
    0,0,0,-7],84],[[-2,0,30,0,-78,0,50],0],
    [[-6,0,2,0,-9,0,51,0,-40,0,0,0,-9,0,11],12],
    [[6,0,-30,0,40],2],
    [[-20,0,0,0,-5,0,0,0,10,0,0,0,5,0,-6],38],
    [[4,0,0,0,18,0,-30,0,0,0,0,0,8],14],
    [[-2,0,9,0,-9,0,-9,0,11],6],
    [[-2,0,-3,0,3,0,2,0,3,0,0,0,0,0,-3],42],
    [[4,0,-3,0,0,0,-1],30],[[-4,0,24,0,-34,0,14],4],
    [[-1,0,16,0,-56,0,45],0],
    [[-16,0,0,0,10,0,0,0,4,0,1,0,1,0,-5,0,0,0,1],38],
    [[-14,0,6,0,-2,0,2,0,6,0,-6,0,0,0,0,0,-1,0,1],32]
    ,[[3,0,3,0,0,0,0,0,2],28],
    [[-11,0,42,0,-48,0,17],4],[[8,0,-19,0,11],6],
    [[-6,0,28,0,-38,0,14],4],
    [[1,0,1,0,0,0,1,0,0,0,-2,0,1],28],
    [[-2,0,3,0,1,0,0,0,0,0,-2],32],
    [[-2,0,4,0,-4,0,2,0,-1,0,1],16],
    [[4,0,-12,0,8],6],
    [[-1,0,1,0,-3,0,8,0,-5,0,0,0,-1,0,1],16],
    [[1,0,-9,0,8],6],[[-2,0,0,0,5,0,-3],18],
    [[1,0,1,0,-1,0,-1],22],[[2,0,-2],10],
    [[-1,0,11,0,-22,0,11],4],[[1,0,0,0,2,0,-2],18],
    [[-3,0,-2,0,-9,0,16,0,-7,0,1,0,-3,0,1],16],
    [[4,0,-6,0,0,0,8],8],[[-2,0,15,0,-26,0,11],4],
    [[1,0,2,0,1,0,-2],22],
    [[-1,0,4,0,-1,0,-3,0,1],10],[[1,0,-1],10],
    [[2,0,-3,0,1],10],[[1,0,-1],14],
    [[-1,0,5,0,-4,0,1],8],[[-1],14],
    [[2,0,-1,0,-1,0,1],12],[[-1],12],
    [[-2,0,8,0,-6,0,1],8],[[1,0,-2],12],
    [[-1,0,5,0,-5,0,1],8],[[1,0,0,0,-1],14],
    [[-6,0,13,0,-10,0,2],8],[[1,0,-1,0,1],18]],
    [[[160],0],[[-160],72],
    [[20,0,0,0,0,0,-64,0,36,0,0,0,8],0],
    [[76,0,-72,0,12],0],
    [[2,0,0,0,0,0,0,0,0,0,-24,0,10,0,0,0,30,0,0,0,6,
    0,0,0,-40],0],[[],0],
    [[32,0,-72,0,48,0,-8],0],[[70,0,-42,0,6],0],
    [[1,0,0,0,0,0,0,0,-6,0,0,0,20,0,0,0,15,0,-64],24]
    ,[[-20],48],[[20],24],
    [[2,0,0,0,0,0,0,0,-12,0,0,0,4,0,0,0,12,0,-8],0],
    [[11,0,-12,0,3],24],[[24,0,-42,0,18,0,-2],0],
    [[6,0,-12,0,12,0,-4],24],[[20,0,0,0,-12,0,8],0],
    [[-16],42],[[2,0,0,0,0,0,-8,0,0,0,4,0,2],0],
    [[24,0,-37,0,14,0,-1],0],
    [[4,0,-4,0,0,0,-17,0,25,0,-6,0,1,0,-3],0],
    [[],0],[[4,0,-14,0,12,0,-2],0],
    [[20,0,-20,0,5],0],[[-5],24],[[],0],[[],0],
    [[4,0,-7,0,2,0,-20,0,38,0,-13,0,-4,0,-6],0],
    [[20,0,-16,0,2],0],[[4,0,-8,0,4],24],
    [[28,0,-56,0,30,0,-4],0],
    [[2,0,0,0,0,0,-12,0,11,0,0,0,1],0],[[],0],
    [[2,0,0,0,4,0,-4,0,4],0],[[2,0,-6,0,6,0,-8],24]
    ,[[2,0,0,0,0,0,-10,0,6,0,0,0,2],0],
    [[4,0,-12,0,9,0,-1],0],[[8,0,-30,0,34,0,-14],0],
    [[2,0,0,0,-2,0,0,0,2],0],[[],0],
    [[4,0,-11,0,8,0,-1],0],[[2,0,-6,0,3],0],
    [[1],12],[[4,0,-9,0,5],0],
    [[2,0,0,0,-4,0,2],0],[[],0],
    [[2,0,0,0,-2,0,1],0],[[-1],8],[[1],16],
    [[-1],8],[[6,0,-18,0,17,0,-4],0],
    [[2,0,-4,0,1],0],[[],0],
    [[4,0,-7,0,-4,0,7,0,-2],0],[[1,0,-2,0,3],24],
    [[-2],18],[[2],14],[[2,0,-4],0],
    [[1,0,0,0,1],14],[[6,0,-21,0,21,0,-6],0],
    [[4,0,-4,0,-4,0,5,0,-1],0],[[],0],
    [[4,0,-14,0,11,0,-2],0],[[1],16],[[],0],
    [[],0],[[-112,0,48],0],
    [[7,0,0,0,0,0,0,0,0,0,-27,0,0,0,0,0,0,0,-21,0,0,
    0,0,0,105],18],[[-50,0,78,0,-30,0,2],0],
    [[-11,0,9,0,0,0,40,0,-51,0,9,0,-2,0,6],0],
    [[-40,0,30,0,-6],0],
    [[6,0,-5,0,0,0,-10,0,0,0,5,0,0,0,20],10],
    [[-8,0,0,0,0,0,30,0,-18,0,0,0,-4],0],
    [[-11,0,9,0,9,0,-9,0,2],0],
    [[3,0,0,0,0,0,-3,0,-2,0,-3,0,3,0,2],10],
    [[1,0,0,0,3,0,-4],6],[[-14,0,34,0,-24,0,4],0],
    [[-45,0,56,0,-16,0,1],0],
    [[-1,0,0,0,5,0,-1,0,-1,0,-4,0,0,0,-10,0,0,0,16],6
    ],
    [[-1,0,1,0,0,0,0,0,6,0,-6,0,-2,0,2,0,-6,0,14],0],
    [[-2,0,0,0,0,0,-3,0,-3],6],
    [[-17,0,48,0,-42,0,11],0],[[-11,0,19,0,-8],0],
    [[-14,0,38,0,-28,0,6],0],
    [[-1,0,2,0,0,0,-1,0,0,0,-1,0,-1],6],
    [[2,0,0,0,0,0,-1,0,-3,0,2],8],
    [[-1,0,1,0,-2,0,4,0,-4,0,2],0],
    [[-8,0,12,0,-4],0],
    [[-1,0,1,0,0,0,5,0,-8,0,3,0,-1,0,1],0],
    [[-8,0,9,0,-1],0],[[3,0,-5,0,0,0,2],6],
    [[1,0,1,0,-1,0,-1],6],[[2,0,-2],2],
    [[-11,0,22,0,-11,0,1],0],[[2,0,-2,0,0,0,-1],6],
    [[-1,0,3,0,-1,0,7,0,-16,0,9,0,2,0,3],0],
    [[-8,0,0,0,6,0,-4],0],[[-11,0,26,0,-15,0,2],0],
    [[2,0,-1,0,-2,0,-1],6],
    [[-1,0,3,0,1,0,-4,0,1],0],[[1,0,-1],2],
    [[-1,0,3,0,-2],0],[[1,0,-1],6],
    [[-1,0,4,0,-5,0,1],0],[[1],4],
    [[-1,0,1,0,1,0,-2],0],[[1],2],
    [[-1,0,6,0,-8,0,2],0],[[2,0,-1],4],
    [[-1,0,5,0,-5,0,1],0],[[1,0,0,0,-1],4],
    [[-2,0,10,0,-13,0,6],0],[[-1,0,1,0,-1],4]],
    [[[448],0],[[-448],120],
    [[4,0,0,0,0,0,-64,0,36,0,0,0,48,0,0,0,36,0,-64,0,
    0,0,0,0,4],0],[[104,0,-240,0,104],0],
    [[6,0,0,0,-40,0,0,0,90,0,-80,0,90,0,0,0,-40,0,0,0,
    6],20],[[],0],
    [[16,0,-112,0,192,0,-112,0,16],0],
    [[84,0,-140,0,84],0],
    [[15,0,-64,0,0,0,0,0,70,0,0,0,0,0,-64,0,15],56],
    [[-44],80],[[44],40],
    [[12,0,-8,0,0,0,0,0,-10,0,0,0,0,0,-8,0,12],16],
    [[15,0,-28,0,15],40],[[8,0,-52,0,92,0,-52,0,8],0]
    ,[[4,0,-20,0,28,0,-20,0,4],40],
    [[4,0,0,0,-12,0,48,0,-12,0,0,0,4],0],[[-32],66],
    [[4,0,2,0,0,0,-12,0,0,0,2,0,4],10],
    [[8,0,-42,0,68,0,-42,0,8],0],
    [[-3,0,11,0,-10,0,7,0,-10,0,7,0,-10,0,11,0,-3],6],
    [[],0],[[-2,0,16,0,-28,0,16,0,-2],2],
    [[4,0,-20,0,30,0,-20,0,4],0],
    [[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],24],
    [[-2],48],[[2],24],
    [[-1,0,2,0,-4,0,20,0,-29,0,26,0,-16,0,26,0,-29,0,
    20,0,-4,0,2,0,-1],2],
    [[4,0,-16,0,12,0,-16,0,4],0],
    [[2,0,-8,0,12,0,-8,0,2],40],
    [[12,0,-76,0,132,0,-76,0,12],0],
    [[1,0,-4,0,1,0,0,0,1,0,-4,0,1],8],[[],0],
    [[4,0,0,0,-2,0,0,0,4],8],
    [[-4,0,9,0,-16,0,9,0,-4],42],
    [[2,0,0,0,0,0,-4,0,0,0,0,0,2],8],
    [[-2,0,9,0,-14,0,9,0,-2],2],
    [[-10,0,54,0,-84,0,54,0,-10],2],[[2,0,-8,0,2],8],
    [[],0],[[-1,0,8,0,-14,0,8,0,-1],2],
    [[3,0,-6,0,3],4],[[],0],
    [[-1,0,3,0,-4,0,3,0,-1],2],[[2,0,-4,0,2],6],
    [[],0],[[1,0,-4,0,1],6],[[2],16],[[1],28],
    [[-1],14],[[-4,0,19,0,-32,0,19,0,-4],2],
    [[1,0,0,0,1],4],[[],0],
    [[-1,0,2,0,11,0,-28,0,11,0,2,0,-1],2],
    [[3,0,-2,0,3],44],[[2],26],[[-2],22],
    [[2],6],[[-1,0,0,0,-1],22],
    [[-5,0,29,0,-48,0,29,0,-5],2],[[7,0,-14,0,7],6],
    [[],0],[[-2,0,13,0,-24,0,13,0,-2],2],
    [[1,0,0,0,1],24],[[1],16],[[-1],8],
    [[-224,0,224],0],
    [[35,0,-189,0,0,0,0,0,0,0,0,0,0,0,0,0,189,0,-35],
    54],[[-44,0,180,0,-180,0,44],0],
    [[-1,0,3,0,0,0,24,0,-49,0,27,0,-24,0,24,0,-27,0,49,
    0,-24,0,0,0,-3,0,1],0],
    [[-24,0,60,0,-60,0,24],0],
    [[1,0,0,0,-10,0,-20,0,25,0,-25,0,20,0,10,0,0,0,-1],
    22],[[10,0,-14,0,0,0,-12,0,12,0,0,0,14,0,-10],6
    ],[[-1,0,3,0,3,0,-33,0,33,0,-3,0,-3,0,1],0],
    [[3,0,-5,0,0,0,0,0,5,0,-3],28],
    [[3,0,3,0,-3,0,-3],18],
    [[-2,0,22,0,-60,0,60,0,-22,0,2],0],
    [[-34,0,120,0,-120,0,34],0],
    [[5,0,0,0,-10,0,0,0,19,0,-19,0,0,0,10,0,0,0,-5],
    22],
    [[-6,0,6,0,-8,0,0,0,5,0,-5,0,0,0,8,0,-6,0,6],16],
    [[-1,0,0,0,0,0,1],18],
    [[-3,0,40,0,-111,0,111,0,-40,0,3],0],
    [[-1,0,9,0,-16,0,16,0,-9,0,1],0],
    [[-2,0,26,0,-78,0,78,0,-26,0,2],0],
    [[1,0,2,0,-1,0,1,0,-2,0,-1],18],
    [[1,0,0,0,0,0,2,0,-2,0,0,0,0,0,-1],18],
    [[-2,0,2,0,1,0,-1,0,-2,0,2],8],
    [[4,0,-12,0,12,0,-4],2],
    [[-1,0,1,0,0,0,2,0,-2,0,0,0,-1,0,1],8],
    [[3,0,-3,0,3,0,-3],2],
    [[1,0,-1,0,0,0,0,0,1,0,-1],10],
    [[1,0,1,0,-1,0,-1],14],[[2,0,-2],6],
    [[-1,0,10,0,-28,0,28,0,-10,0,1],0],[[-1,0,1],14],
    [[-4,0,7,0,-10,0,5,0,-5,0,10,0,-7,0,4],8],
    [[2,0,-12,0,12,0,-2],4],
    [[-1,0,14,0,-43,0,43,0,-14,0,1],0],
    [[1,0,0,0,1,0,-1,0,0,0,-1],12],
    [[-1,0,9,0,-9,0,1],6],[[],0],[[-1,0,1],6],
    [[1,0,-1],10],[[-1,0,5,0,-5,0,1],4],[[],0],
    [[3,0,-3],8],[[-1,0,1],6],
    [[-3,0,12,0,-12,0,3],4],[[1,0,-1],8],
    [[-1,0,3,0,-3,0,1],4],[[2,0,-2],10],
    [[-7,0,20,0,-20,0,7],4],[[1,0,-1],12]],
    [[[400],0],[[-400],156],
    [[-48,0,0,0,144,0,-112,0,0,0,0,0,16],12],
    [[50,0,-180,0,170],0],
    [[-60,0,60,0,0,0,-30,0,-60,0,60,0,0,0,0,0,-12,0,0,
    0,0,0,0,0,0,0,2],34],[[],0],
    [[8,0,-44,0,120,0,-156,0,72],0],
    [[15,0,-125,0,135],0],
    [[60,0,-64,0,-15,0,0,0,0,0,0,0,-6],80],
    [[-20],104],[[20],52],
    [[12,0,-8,0,-3,0,0,0,6,0,0,0,-3],28],
    [[3,0,-16,0,9],52],[[-10,0,50,0,-80,0,50],2],
    [[-8,0,10,0,-16,0,4],54],[[24,0,-48,0,0,0,16],6],
    [[8],84],
    [[-4,0,-6,0,16,0,-4,0,-4,0,0,0,0,0,2],18],
    [[-5,0,36,0,-68,0,41],2],
    [[-3,0,14,0,-16,0,-20,0,45,0,-26,0,0,0,-1,0,3],12],
    [[],0],[[-6,0,18,0,-24,0,12],6],
    [[10,0,-35,0,25],4],[[],0],[[],0],[[],0],
    [[2,0,20,0,-1,0,-49,0,77,0,-44,0,0,0,-4,0,8],12],
    [[3,0,-28,0,16],4],[[6,0,-8,0,2],56],
    [[2,0,-23,0,77,0,-114,0,59],0],
    [[6,0,-12,0,0,0,15,0,-12,0,0,0,0,0,2],14],
    [[],0],[[4,0,1,0,-6,0,1],14],
    [[1,0,-4,0,8,0,-6,0,1],56],
    [[2,0,-7,0,0,0,10,0,-5],14],
    [[-1,0,-2,0,10,0,-15,0,8],4],
    [[-2,0,10,0,-34,0,64,0,-60,0,20],2],
    [[6,0,-6,0,0,0,0,0,2],12],[[],0],
    [[-1,0,8,0,-14,0,7],6],[[2,0,-6,0,5],8],
    [[-1],24],[[1,0,3,0,-7,0,3],6],
    [[2,0,-4,0,0,0,2],10],[[],0],[[1,0,-3],10],
    [[2],20],[[1],36],[[-1],18],
    [[1,0,-7,0,23,0,-28,0,11],4],[[-2,0,2],10],
    [[],0],[[2,0,-11,0,21,0,-15,0,-4,0,8],6],
    [[1,0,-2],60],[[-2],32],[[2],28],
    [[-1,0,-1],8],[[1,0,0,0,1],28],
    [[3,0,-14,0,35,0,-38,0,15],4],
    [[-4,0,12,0,-11,0,-1,0,3],8],[[],0],
    [[-4,0,15,0,-21,0,10],6],[[],0],[[],0],
    [[],0],[[-140,0,260],0],
    [[105,0,-189,0,0,0,-15,0,0,0,0,0,-21],78],
    [[-19,0,93,0,-177,0,111],0],
    [[18,0,-30,0,-54,0,126,0,-76,0,0,0,-4,0,12],12],
    [[15,0,-75,0,60],2],
    [[10,0,-25,0,25,0,0,0,-5,0,-20,0,20,0,0,0,0,0,-6,
    0,0,0,0,0,0,0,0,0,1],34],
    [[6,0,-27,0,0,0,54,0,-37,0,0,0,0,0,4],12],
    [[-10,0,32,0,-30,0,-4,0,12],6],
    [[3,0,-5,0,3,0,-3,0,2],40],
    [[3,0,-6,0,0,0,6,0,-3,0,0,0,-1,0,0,0,0,0,1],24],
    [[2,0,-15,0,46,0,-60,0,27],2],
    [[-5,0,55,0,-125,0,90],0],
    [[-16,0,15,0,-4,0,-10,0,-5,0,6,0,0,0,-1],36],
    [[-6,0,6,0,-5,0,0,0,-2,0,4,0,0,0,-3],28],
    [[6,0,3,0,-3],26],
    [[-1,0,10,0,-40,0,89,0,-97,0,38],0],
    [[12,0,-23,0,12],6],[[4,0,-23,0,59,0,-72,0,32],2]
    ,[[2,0,-2,0,-2,0,3,0,-1],26],[[1,0,1],30],
    [[-2,0,1,0,2,0,-4,0,1],14],[[5,0,-14,0,11],6],
    [[-1,0,4,0,-4,0,-4,0,7,0,-4],14],[[-8,0,4],8],
    [[3,0,1,0,0,0,4,0,-5,0,0,0,0,0,1],16],
    [[-1,0,0,0,1],20],[[1,0,-3,0,2],10],
    [[-3,0,18,0,-32,0,17],4],[[1,0,-1],16],
    [[-3,0,11,0,-1,0,-17,0,28,0,-16,0,0,0,-1,0,2],14],
    [[10,0,-17,0,0,0,4],8],[[-8,0,30,0,-43,0,24],4],
    [[-3,0,-2,0,5,0,-2,0,-2,0,0,0,0,0,1],20],
    [[1,0,-4,0,8,0,-6,0,-1,0,2],8],[[-1,0,1],12],
    [[1,0,0,0,-1],8],[[1,0,-1],14],
    [[4,0,-6,0,3],10],[[-1],12],[[2,0,-2],12],
    [[],0],[[-3,0,10,0,-12,0,5],8],
    [[-1,0,0,0,1],14],[[-1,0,0,0,3,0,-5,0,2],6],
    [[2,0,-2,0,0,0,0,0,1],14],
    [[1,0,-7,0,18,0,-18,0,6],6],[[1,0,-1],16]],
    [[[400],0],[[-400],84],
    [[16,0,0,0,0,0,-112,0,144,0,0,0,-48],0],
    [[170,0,-180,0,50],0],
    [[2,0,0,0,0,0,0,0,0,0,-12,0,0,0,0,0,60,0,-60,0,
    -30,0,0,0,60,0,-60],0],[[],0],
    [[72,0,-156,0,120,0,-44,0,8],0],
    [[135,0,-125,0,15],0],
    [[-6,0,0,0,0,0,0,0,-15,0,-64,0,60],36],
    [[-20],56],[[20],28],
    [[-3,0,0,0,6,0,0,0,-3,0,-8,0,12],8],
    [[9,0,-16,0,3],28],[[50,0,-80,0,50,0,-10],0],
    [[4,0,-16,0,10,0,-8],28],[[16,0,0,0,-48,0,24],0],
    [[8],48],
    [[2,0,0,0,0,0,-4,0,-4,0,16,0,-6,0,-4],0],
    [[41,0,-68,0,36,0,-5],0],
    [[3,0,-1,0,0,0,-26,0,45,0,-20,0,-16,0,14,0,-3],0],
    [[],0],[[12,0,-24,0,18,0,-6],0],
    [[25,0,-35,0,10],0],[[],0],[[],0],[[],0],
    [[8,0,-4,0,0,0,-44,0,77,0,-49,0,-1,0,20,0,2],0],
    [[16,0,-28,0,3],0],[[2,0,-8,0,6],28],
    [[59,0,-114,0,77,0,-23,0,2],0],
    [[2,0,0,0,0,0,-12,0,15,0,0,0,-12,0,6],0],
    [[],0],[[1,0,-6,0,1,0,4],4],
    [[1,0,-6,0,8,0,-4,0,1],28],
    [[-5,0,10,0,0,0,-7,0,2],6],
    [[8,0,-15,0,10,0,-2,0,-1],0],
    [[20,0,-60,0,64,0,-34,0,10,0,-2],0],
    [[2,0,0,0,0,0,-6,0,6],0],[[],0],
    [[7,0,-14,0,8,0,-1],0],[[5,0,-6,0,2],0],
    [[-1],12],[[3,0,-7,0,3,0,1],0],
    [[2,0,0,0,-4,0,2],0],[[],0],[[-3,0,1],4],
    [[2],12],[[1],20],[[-1],10],
    [[11,0,-28,0,23,0,-7,0,1],0],[[2,0,-2],0],
    [[],0],[[8,0,-4,0,-15,0,21,0,-11,0,2],0],
    [[-2,0,1],30],[[-2],20],[[2],16],
    [[-1,0,-1],2],[[1,0,0,0,1],16],
    [[15,0,-38,0,35,0,-14,0,3],0],
    [[3,0,-1,0,-11,0,12,0,-4],0],[[],0],
    [[10,0,-21,0,15,0,-4],0],[[],0],[[],0],
    [[],0],[[-260,0,140],0],
    [[21,0,0,0,0,0,15,0,0,0,189,0,-105],36],
    [[-111,0,177,0,-93,0,19],0],
    [[-12,0,4,0,0,0,76,0,-126,0,54,0,30,0,-18],0],
    [[-60,0,75,0,-15],0],
    [[-1,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,-20,0,20,0,5,
    0,0,0,-25,0,25,0,-10],0],
    [[-4,0,0,0,0,0,37,0,-54,0,0,0,27,0,-6],0],
    [[-12,0,4,0,30,0,-32,0,10],0],
    [[-2,0,3,0,-3,0,5,0,-3],18],
    [[-1,0,0,0,0,0,1,0,0,0,3,0,-6,0,0,0,6,0,-3],0],
    [[-27,0,60,0,-46,0,15,0,-2],0],
    [[-90,0,125,0,-55,0,5],0],
    [[1,0,0,0,-6,0,5,0,10,0,4,0,-15,0,16],12],
    [[3,0,0,0,-4,0,2,0,0,0,5,0,-6,0,6],8],
    [[3,0,-3,0,-6],12],
    [[-38,0,97,0,-89,0,40,0,-10,0,1],0],
    [[-12,0,23,0,-12],0],
    [[-32,0,72,0,-59,0,23,0,-4],0],
    [[1,0,-3,0,2,0,2,0,-2],12],[[-1,0,-1],18],
    [[-1,0,4,0,-2,0,-1,0,2],4],[[-11,0,14,0,-5],0],
    [[4,0,-7,0,4,0,4,0,-4,0,1],6],[[-4,0,8],0],
    [[-1,0,0,0,0,0,5,0,-4,0,0,0,-1,0,-3],0],
    [[-1,0,0,0,1],10],[[-2,0,3,0,-1],0],
    [[-17,0,32,0,-18,0,3],0],[[1,0,-1],12],
    [[-2,0,1,0,0,0,16,0,-28,0,17,0,1,0,-11,0,3],0],
    [[-4,0,0,0,17,0,-10],0],[[-24,0,43,0,-30,0,8],0],
    [[-1,0,0,0,0,0,2,0,2,0,-5,0,2,0,3],0],
    [[-2,0,1,0,6,0,-8,0,4,0,-1],0],[[-1,0,1],0],
    [[1,0,0,0,-1],2],[[1,0,-1],6],
    [[-3,0,6,0,-4],0],[[1],6],[[2,0,-2],4],
    [[],0],[[-5,0,12,0,-10,0,3],0],
    [[-1,0,0,0,1],0],[[-2,0,5,0,-3,0,0,0,1],0],
    [[-1,0,0,0,0,0,2,0,-2],0],
    [[-6,0,18,0,-18,0,7,0,-1],0],[[1,0,-1],8]],
    [[[448],0],[[-448],150],
    [[-64,0,0,0,144,0,-96,0,0,0,0,0,16],12],
    [[64,0,-208,0,176],0],
    [[60,0,-60,0,10,0,0,0,-30,0,-40,0,30,0,0,0,10,0,-12
    ],32],[[],0],
    [[8,0,-64,0,144,0,-160,0,72],0],
    [[24,0,-144,0,136],0],
    [[-10,0,0,0,-24,0,64,0,-45,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,-1],74],[[16],100],[[-16],50],
    [[1,0,0,0,24,0,-16,0,0,0,0,0,6,0,0,0,0,0,0,0,0,
    0,0,0,1],24],[[-6,0,0,0,-10],50],
    [[2,0,-16,0,58,0,-88,0,42],0],
    [[-2,0,4,0,2,0,4,0,-6],50],
    [[32,0,-48,0,0,0,16],6],[[],0],
    [[4,0,-8,0,-4,0,12,0,0,0,-4],16],
    [[-10,0,44,0,-70,0,36],2],
    [[-3,0,21,0,-24,0,-17,0,40,0,-19,0,0,0,-1,0,3],12],
    [[],0],[[2,0,-8,0,18,0,-20,0,8],4],
    [[14,0,-36,0,20],4],[[6,0,0,0,-4],38],
    [[-2],60],[[2],30],
    [[-2,0,18,0,-17,0,-45,0,77,0,-32,0,1,0,-5,0,5],12],
    [[8,0,-24,0,16],4],[[4,0,0,0,-4],54],
    [[4,0,-32,0,96,0,-116,0,56],0],
    [[6,0,-16,0,0,0,12,0,-10],14],[[],0],
    [[-3,0,8,0,0,0,-6,0,0,0,0,0,1],12],
    [[-1,0,-6,0,5,0,4,0,-2],54],
    [[-1,0,5,0,-10,0,1,0,7,0,-3,0,0,0,0,0,1],12],
    [[1,0,-3,0,10,0,-13,0,5],4],
    [[-4,0,18,0,-46,0,66,0,-52,0,20],2],
    [[4,0,-4,0,-2],12],[[],0],
    [[-3,0,8,0,-10,0,5],6],[[2,0,-4,0,2],8],
    [[],0],[[-1,0,3,0,-5,0,3],6],[[4,0,-4],10],
    [[],0],[[1,0,2,0,-3,0,0,0,1],8],[[-1],22],
    [[1],36],[[-1],18],
    [[3,0,-12,0,23,0,-22,0,10],4],[[-2],10],
    [[],0],[[2,0,-13,0,25,0,-14,0,-5,0,5],6],
    [[-2,0,3,0,0,0,-1],56],[[],0],[[],0],
    [[-1,0,0,0,0,0,1],6],[[],0],
    [[-1,0,6,0,-21,0,35,0,-32,0,13],2],
    [[-5,0,13,0,-10,0,-1,0,3],8],[[],0],
    [[1,0,-7,0,15,0,-16,0,8],4],[[-1],32],
    [[1],20],[[-1],10],[[-168,0,280],0],
    [[-70,0,0,0,0,0,168,0,-189,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,-21],72],[[-24,0,120,0,-192,0,112],0]
    ,[[20,0,-44,0,-54,0,122,0,-64,0,0,0,-6,0,10],12],
    [[24,0,-80,0,56],2],
    [[10,0,-5,0,5,0,0,0,-15,0,-10,0,15,0,0,0,1,0,-1],
    34],[[12,0,-36,0,0,0,48,0,-28,0,0,0,0,0,4],12],
    [[-12,0,38,0,-30,0,-6,0,10],6],
    [[-2,0,0,0,3,0,0,0,0,0,0,0,-1],36],
    [[3,0,-6,0,0,0,6,0,-3],24],
    [[4,0,-24,0,52,0,-56,0,24],2],
    [[-10,0,68,0,-140,0,86],0],
    [[-5,0,21,0,-5,0,5,0,-9,0,-5,0,-6,0,1,0,0,0,0,0,
    -1],32],
    [[1,0,-12,0,20,0,-8,0,0,0,-2,0,4,0,0,0,0,0,0,0,0,
    0,0,0,1],26],[[-7,0,6,0,0,0,0,0,-3],24],
    [[-1,0,16,0,-57,0,101,0,-92,0,37],0],
    [[-4,0,12,0,-22,0,10],4],
    [[-1,0,7,0,-33,0,69,0,-67,0,29],0],
    [[-2,0,5,0,-9,0,2,0,0,0,2,0,-2],24],
    [[-1,0,6,0,-2,0,0,0,0,0,2,0,-1],28],
    [[-7,0,4,0,2,0,-4,0,0,0,0,0,1],14],
    [[6,0,-14,0,6],6],
    [[-2,0,8,0,-7,0,-2,0,6,0,-2,0,0,0,0,0,1],14],
    [[2,0,-6,0,4],6],[[3,0,-6,0,0,0,4,0,-1],16],
    [[-1,0,0,0,1],20],[[-1,0,1],12],
    [[-6,0,22,0,-28,0,14],4],
    [[1,0,-2,0,0,0,0,0,-1],16],
    [[-5,0,16,0,-12,0,-15,0,25,0,-10,0,0,0,-1,0,2],14],
    [[12,0,-16,0,0,0,4],8],
    [[2,0,-12,0,34,0,-42,0,18],2],
    [[2,0,-3,0,-1,0,3,0,-1],18],
    [[1,0,-5,0,8,0,-5,0,-1,0,2],8],[[],0],
    [[-1,0,0,0,0,0,1],8],[[1,0,0,0,-1],12],
    [[-1,0,2,0,-3,0,2],8],[[],0],
    [[2,0,-2,0,0,0,1],12],[[-1],8],
    [[1,0,-4,0,7,0,-8,0,4],6],[[1,0,-1],12],
    [[-1,0,2,0,-3,0,2],8],[[1,0,-1],14],
    [[-1,0,3,0,-10,0,14,0,-13,0,6],4],
    [[2,0,0,0,-1],16]],
    [[[448],0],[[-448],90],[[16,0,0,0,0,0,-96,0,144,0,
    0,0,-64],0],[[176,0,-208,0,64],0],
    [[-12,0,10,0,0,0,30,0,-40,0,-30,0,0,0,10,0,-60,0,60
    ],10],[[],0],
    [[72,0,-160,0,144,0,-64,0,8],0],
    [[136,0,-144,0,24],0],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-45,0,64,0,
    -24,0,0,0,-10],30],[[16],60],[[-16],30],
    [[1,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,-16,0,24,
    0,0,0,1],0],[[-10,0,0,0,-6],30],
    [[42,0,-88,0,58,0,-16,0,2],0],
    [[-6,0,4,0,2,0,4,0,-2],30],
    [[16,0,0,0,-48,0,32],0],[[],0],
    [[-4,0,0,0,12,0,-4,0,-8,0,4],6],
    [[36,0,-70,0,44,0,-10],0],
    [[3,0,-1,0,0,0,-19,0,40,0,-17,0,-24,0,21,0,-3],0],
    [[],0],[[8,0,-20,0,18,0,-8,0,2],0],
    [[20,0,-36,0,14],0],[[-4,0,0,0,6],22],
    [[-2],36],[[2],18],
    [[5,0,-5,0,1,0,-32,0,77,0,-45,0,-17,0,18,0,-2],0],
    [[16,0,-24,0,8],0],[[-4,0,0,0,4],30],
    [[56,0,-116,0,96,0,-32,0,4],0],
    [[-10,0,12,0,0,0,-16,0,6],6],[[],0],
    [[1,0,0,0,0,0,-6,0,0,0,8,0,-3],0],
    [[-2,0,4,0,5,0,-6,0,-1],30],
    [[1,0,0,0,0,0,-3,0,7,0,1,0,-10,0,5,0,-1],0],
    [[5,0,-13,0,10,0,-3,0,1],0],
    [[20,0,-52,0,66,0,-46,0,18,0,-4],0],
    [[-2,0,-4,0,4],4],[[],0],
    [[5,0,-10,0,8,0,-3],0],[[2,0,-4,0,2],0],
    [[],0],[[3,0,-5,0,3,0,-1],0],[[-4,0,4],4],
    [[],0],[[1,0,0,0,-3,0,2,0,1],0],[[-1],10],
    [[1],20],[[-1],10],
    [[10,0,-22,0,23,0,-12,0,3],0],[[-2],2],[[],0],
    [[5,0,-5,0,-14,0,25,0,-13,0,2],0],
    [[-1,0,0,0,3,0,-2],30],[[],0],[[],0],
    [[1,0,0,0,0,0,-1],0],[[],0],
    [[13,0,-32,0,35,0,-21,0,6,0,-1],0],
    [[3,0,-1,0,-10,0,13,0,-5],0],[[],0],
    [[8,0,-16,0,15,0,-7,0,1],0],[[-1],20],
    [[1],12],[[-1],6],[[-280,0,168],0],
    [[21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,189,0,-168,0,
    0,0,0,0,70],30],[[-112,0,192,0,-120,0,24],0],
    [[-10,0,6,0,0,0,64,0,-122,0,54,0,44,0,-20],0],
    [[-56,0,80,0,-24],0],
    [[1,0,-1,0,0,0,-15,0,10,0,15,0,0,0,-5,0,5,0,-10],
    10],[[-4,0,0,0,0,0,28,0,-48,0,0,0,36,0,-12],0],
    [[-10,0,6,0,30,0,-38,0,12],0],
    [[1,0,0,0,0,0,0,0,-3,0,0,0,2],18],
    [[3,0,-6,0,0,0,6,0,-3],10],
    [[-24,0,56,0,-52,0,24,0,-4],0],
    [[-86,0,140,0,-68,0,10],0],
    [[1,0,0,0,0,0,-1,0,6,0,5,0,9,0,-5,0,5,0,-21,0,5],
    10],
    [[-1,0,0,0,0,0,0,0,0,0,0,0,-4,0,2,0,0,0,8,0,-20,
    0,12,0,-1],0],[[3,0,0,0,0,0,-6,0,7],10],
    [[-37,0,92,0,-101,0,57,0,-16,0,1],0],
    [[-10,0,22,0,-12,0,4],0],
    [[-29,0,67,0,-69,0,33,0,-7,0,1],0],
    [[2,0,-2,0,0,0,-2,0,9,0,-5,0,2],10],
    [[1,0,-2,0,0,0,0,0,2,0,-6,0,1],10],
    [[-1,0,0,0,0,0,4,0,-2,0,-4,0,7],0],
    [[-6,0,14,0,-6],0],
    [[-1,0,0,0,0,0,2,0,-6,0,2,0,7,0,-8,0,2],0],
    [[-4,0,6,0,-2],0],[[1,0,-4,0,0,0,6,0,-3],6],
    [[-1,0,0,0,1],10],[[-1,0,1],0],
    [[-14,0,28,0,-22,0,6],0],
    [[1,0,0,0,0,0,2,0,-1],6],
    [[-2,0,1,0,0,0,10,0,-25,0,15,0,12,0,-16,0,5],0],
    [[-4,0,0,0,16,0,-12],0],
    [[-18,0,42,0,-34,0,12,0,-2],0],
    [[1,0,-3,0,1,0,3,0,-2],8],
    [[-2,0,1,0,5,0,-8,0,5,0,-1],0],[[],0],
    [[-1,0,0,0,0,0,1],0],[[1,0,0,0,-1],6],
    [[-2,0,3,0,-2,0,1],0],[[],0],
    [[-1,0,0,0,2,0,-2],0],[[1],6],
    [[-4,0,8,0,-7,0,4,0,-1],0],[[1,0,-1],4],
    [[-2,0,3,0,-2,0,1],0],[[1,0,-1],6],
    [[-6,0,13,0,-14,0,10,0,-3,0,1],0],
    [[1,0,0,0,-2],6]],
    [[[560],0],[[-560],162],[[-40,0,0,0,180,0,-184,0,0,
    0,0,0,44],12],[[56,0,-252,0,252],0],
    [[-30,0,10,0,0,0,-48,0,-60,0,90,0,0,0,20,0,-42,0,0,
    0,0,0,0,0,0,0,4],34],[[],0],
    [[4,0,-48,0,168,0,-232,0,108],0],
    [[20,0,-162,0,216],0],
    [[-60,0,0,0,0,0,0,0,-20,0,0,0,6],82],[[20],108],
    [[-20],54],
    [[6,0,-24,0,9,0,0,0,14,0,0,0,-15,0,0,0,0,0,0,0,3]
    ,28],[[-2,0,18,0,-9],54],
    [[-10,0,66,0,-130,0,76],2],
    [[4,0,-18,0,16,0,-4],56],[[24,0,-60,0,0,0,44],6],
    [[-8],90],
    [[-6,0,-2,0,20,0,-2,0,-14,0,0,0,0,0,4],18],
    [[-5,0,50,0,-111,0,70],2],
    [[8,0,-15,0,-28,0,74,0,-46,0,0,0,-6,0,9],14],
    [[],0],[[-8,0,32,0,-40,0,16],6],
    [[15,0,-60,0,50],4],[[-5],42],[[],0],[[],0],
    [[10,0,-11,0,-62,0,119,0,-64,0,3,0,-14,0,13],14],
    [[8,0,-46,0,44],4],[[-8,0,10,0,-2],58],
    [[1,0,-23,0,108,0,-175,0,91],0],
    [[3,0,-10,0,0,0,28,0,-27,0,0,0,0,0,4],14],
    [[],0],[[2,0,1,0,-14,0,5,0,0,0,3],14],
    [[10,0,-12,0,6,0,-1],60],
    [[1,0,-4,0,0,0,17,0,-17,0,0,0,0,0,3],14],
    [[-4,0,21,0,-30,0,13],6],
    [[10,0,-48,0,102,0,-92,0,30],4],
    [[4,0,-6,0,-4,0,0,0,4],12],[[],0],
    [[-3,0,18,0,-27,0,12],6],[[6,0,-13,0,7],8],
    [[],0],[[-1,0,10,0,-18,0,9],6],
    [[6,0,-10,0,0,0,4],10],[[],0],
    [[3,0,-7,0,0,0,3],10],[[1],18],[[-1],36],
    [[1],18],[[1,0,-13,0,43,0,-49,0,19],4],
    [[2,0,-7,0,4],8],[[],0],
    [[-9,0,30,0,-18,0,-14,0,13],8],[[-4,0,2],62],
    [[2],36],[[-2],30],[[1,0,-5,0,3],8],
    [[2,0,-1],32],[[2,0,-22,0,58,0,-62,0,22],4],
    [[-3,0,18,0,-16,0,-6,0,9],8],[[],0],
    [[-7,0,28,0,-37,0,15],6],[[1],34],[[],0],
    [[],0],[[-182,0,378],0],
    [[-189,0,0,0,15,0,0,0,0,0,-21,0,0,0,0,0,-21,0,27,
    0,0,0,0,0,0,0,0,0,-7],80],
    [[-16,0,120,0,-258,0,166],0],
    [[10,0,-30,0,-63,0,181,0,-120,0,0,0,-17,0,27],12],
    [[20,0,-106,0,110],2],
    [[-10,0,5,0,0,0,-24,0,-20,0,30,0,0,0,6,0,-12,0,0,
    0,0,0,0,0,0,0,1],36],
    [[3,0,-20,0,0,0,75,0,-73,0,0,0,0,0,15],12],
    [[-6,0,39,0,-39,0,-17,0,27],6],
    [[3,0,-2,0,-3,0,-3,0,1,0,3,0,0,0,0,0,-3],40],
    [[-6,0,0,0,13,0,-6,0,0,0,-2,0,0,0,0,0,1],26],
    [[1,0,-19,0,73,0,-99,0,44],2],
    [[-5,0,66,0,-186,0,141],0],
    [[-14,0,-10,0,0,0,14,0,0,0,-1,0,-6,0,0,0,1],40],
    [[14,0,-16,0,9,0,-6,0,8,0,6,0,-9,0,0,0,0,0,-1,0,2
    ],30],[[-3,0,-3,0,-3,0,0,0,2],28],
    [[7,0,-50,0,134,0,-149,0,58],2],
    [[-2,0,22,0,-47,0,27],4],
    [[2,0,-28,0,90,0,-114,0,48],2],
    [[3,0,1,0,1,0,-2,0,-2,0,1],30],
    [[-5,0,3,0,0,0,2,0,-1,0,-2],32],
    [[2,0,7,0,-10,0,3,0,-1,0,2],16],
    [[10,0,-30,0,20],6],
    [[2,0,-3,0,-7,0,17,0,-10,0,0,0,-1,0,2],16],
    [[4,0,-19,0,15],6],
    [[3,0,-5,0,0,0,9,0,-8,0,0,0,0,0,1],16],
    [[-1,0,1,0,2,0,-1,0,-1],20],[[3,0,-5,0,2],10],
    [[-4,0,32,0,-58,0,31],4],
    [[1,0,-1,0,0,0,2,0,-3],16],
    [[8,0,-5,0,-27,0,47,0,-23,0,1,0,-5,0,4],16],
    [[11,0,-26,0,0,0,15],8],[[-9,0,47,0,-74,0,36],4],
    [[-2,0,-1,0,7,0,-1,0,-4,0,0,0,0,0,1],20],
    [[-5,0,13,0,-7,0,-5,0,4],10],[[1,0,-2,0,1],10],
    [[3,0,-4,0,2],10],[[1,0,-2],14],
    [[-2,0,9,0,-11,0,4],8],[[1,0,-1],12],
    [[-1,0,5,0,-4,0,-1,0,2],10],[[-1],12],
    [[-6,0,18,0,-19,0,6],8],[[3,0,-3,0,0,0,1],12],
    [[-2,0,9,0,-11,0,4],8],
    [[2,0,-2,0,-1,0,0,0,1],14],
    [[2,0,-14,0,33,0,-29,0,9],6],
    [[1,0,-1,0,-2,0,1],16]],
    [[[560],0],[[-560],78],
    [[44,0,0,0,0,0,-184,0,180,0,0,0,-40],0],
    [[252,0,-252,0,56],0],
    [[4,0,0,0,0,0,0,0,0,0,-42,0,20,0,0,0,90,0,-60,0,
    -48,0,0,0,10,0,-30],0],[[],0],
    [[108,0,-232,0,168,0,-48,0,4],0],
    [[216,0,-162,0,20],0],
    [[6,0,0,0,-20,0,0,0,0,0,0,0,-60],34],[[20],52],
    [[-20],26],
    [[3,0,0,0,0,0,0,0,-15,0,0,0,14,0,0,0,9,0,-24,0,6]
    ,0],[[-9,0,18,0,-2],26],
    [[76,0,-130,0,66,0,-10],0],
    [[-4,0,16,0,-18,0,4],26],[[44,0,0,0,-60,0,24],0],
    [[-8],42],
    [[4,0,0,0,0,0,-14,0,-2,0,20,0,-2,0,-6],0],
    [[70,0,-111,0,50,0,-5],0],
    [[9,0,-6,0,0,0,-46,0,74,0,-28,0,-15,0,8],0],
    [[],0],[[16,0,-40,0,32,0,-8],0],
    [[50,0,-60,0,15],0],[[-5],22],[[],0],[[],0],
    [[13,0,-14,0,3,0,-64,0,119,0,-62,0,-11,0,10],0],
    [[44,0,-46,0,8],0],[[-2,0,10,0,-8],26],
    [[91,0,-175,0,108,0,-23,0,1],0],
    [[4,0,0,0,0,0,-27,0,28,0,0,0,-10,0,3],0],
    [[],0],[[3,0,0,0,5,0,-14,0,1,0,2],0],
    [[-1,0,6,0,-12,0,10],26],
    [[3,0,0,0,0,0,-17,0,17,0,0,0,-4,0,1],0],
    [[13,0,-30,0,21,0,-4],0],
    [[30,0,-92,0,102,0,-48,0,10],0],
    [[4,0,0,0,-4,0,-6,0,4],0],[[],0],
    [[12,0,-27,0,18,0,-3],0],[[7,0,-13,0,6],0],
    [[],0],[[9,0,-18,0,10,0,-1],0],
    [[4,0,0,0,-10,0,6],0],[[],0],
    [[3,0,0,0,-7,0,3],0],[[1],14],[[-1],20],
    [[1],10],[[19,0,-49,0,43,0,-13,0,1],0],
    [[4,0,-7,0,2],0],[[],0],
    [[13,0,-14,0,-18,0,30,0,-9],0],[[2,0,-4],28],
    [[2],16],[[-2],14],[[3,0,-5,0,1],0],
    [[-1,0,2],14],[[22,0,-62,0,58,0,-22,0,2],0],
    [[9,0,-6,0,-16,0,18,0,-3],0],[[],0],
    [[15,0,-37,0,28,0,-7],0],[[1],18],[[],0],
    [[],0],[[-378,0,182],0],
    [[7,0,0,0,0,0,0,0,0,0,-27,0,21,0,0,0,0,0,21,0,0,
    0,0,0,-15,0,0,0,189],18],
    [[-166,0,258,0,-120,0,16],0],
    [[-27,0,17,0,0,0,120,0,-181,0,63,0,30,0,-10],0],
    [[-110,0,106,0,-20],0],
    [[-1,0,0,0,0,0,0,0,0,0,12,0,-6,0,0,0,-30,0,20,0,
    24,0,0,0,-5,0,10],0],
    [[-15,0,0,0,0,0,73,0,-75,0,0,0,20,0,-3],0],
    [[-27,0,17,0,39,0,-39,0,6],0],
    [[3,0,0,0,0,0,-3,0,-1,0,3,0,3,0,2,0,-3],10],
    [[-1,0,0,0,0,0,2,0,0,0,6,0,-13,0,0,0,6],0],
    [[-44,0,99,0,-73,0,19,0,-1],0],
    [[-141,0,186,0,-66,0,5],0],
    [[-1,0,0,0,6,0,1,0,0,0,-14,0,0,0,10,0,14],6],
    [[-2,0,1,0,0,0,0,0,9,0,-6,0,-8,0,6,0,-9,0,16,0,
    -14],0],[[-2,0,0,0,3,0,3,0,3],6],
    [[-58,0,149,0,-134,0,50,0,-7],0],
    [[-27,0,47,0,-22,0,2],0],
    [[-48,0,114,0,-90,0,28,0,-2],0],
    [[-1,0,2,0,2,0,-1,0,-1,0,-3],6],
    [[2,0,1,0,-2,0,0,0,-3,0,5],8],
    [[-2,0,1,0,-3,0,10,0,-7,0,-2],0],
    [[-20,0,30,0,-10],0],
    [[-2,0,1,0,0,0,10,0,-17,0,7,0,3,0,-2],0],
    [[-15,0,19,0,-4],0],
    [[-1,0,0,0,0,0,8,0,-9,0,0,0,5,0,-3],0],
    [[1,0,1,0,-2,0,-1,0,1],6],[[-2,0,5,0,-3],0],
    [[-31,0,58,0,-32,0,4],0],
    [[3,0,-2,0,0,0,1,0,-1],6],
    [[-4,0,5,0,-1,0,23,0,-47,0,27,0,5,0,-8],0],
    [[-15,0,0,0,26,0,-11],0],[[-36,0,74,0,-47,0,9],0]
    ,[[-1,0,0,0,0,0,4,0,1,0,-7,0,1,0,2],0],
    [[-4,0,5,0,7,0,-13,0,5],0],[[-1,0,2,0,-1],0],
    [[-2,0,4,0,-3],0],[[2,0,-1],6],
    [[-4,0,11,0,-9,0,2],0],[[1,0,-1],4],
    [[-2,0,1,0,4,0,-5,0,1],0],[[1],2],
    [[-6,0,19,0,-18,0,6],0],[[-1,0,0,0,3,0,-3],0],
    [[-4,0,11,0,-9,0,2],0],
    [[-1,0,0,0,1,0,2,0,-2],0],
    [[-9,0,29,0,-33,0,14,0,-2],0],
    [[-1,0,2,0,1,0,-1],4]],
    [[[1344],0],[[-1344],120],
    [[4,0,0,0,0,0,-64,0,180,0,0,0,-240,0,0,0,180,0,-64,
    0,0,0,0,0,4],0],[[344,0,-656,0,344],0],
    [[-6,0,0,0,60,0,-120,0,210,0,-320,0,210,0,-120,0,60,
    0,0,0,-6],20],[[],0],
    [[96,0,-336,0,480,0,-336,0,96],0],
    [[204,0,-468,0,204],0],
    [[-64,0,84,0,0,0,20,0,0,0,84,0,-64],58],
    [[-60],80],[[60],40],
    [[-8,0,24,0,0,0,-38,0,0,0,24,0,-8],18],
    [[21,0,-36,0,21],40],
    [[40,0,-140,0,212,0,-140,0,40],0],
    [[8,0,-28,0,28,0,-28,0,8],40],
    [[4,0,0,0,-60,0,144,0,-60,0,0,0,4],0],[[-32],66],
    [[4,0,-6,0,-8,0,20,0,-8,0,-6,0,4],10],
    [[24,0,-102,0,156,0,-102,0,24],0],
    [[-5,0,17,0,-10,0,-51,0,98,0,-51,0,-10,0,17,0,-5],6
    ],[[],0],
    [[4,0,-14,0,28,0,-36,0,28,0,-14,0,4],0],
    [[4,0,-36,0,58,0,-36,0,4],0],
    [[1,0,0,0,-4,0,0,0,12,0,0,0,-4,0,0,0,1],24],
    [[-6],48],[[6],24],
    [[2,0,-1,0,0,0,-20,0,56,0,-67,0,-18,0,84,0,-18,0,
    -67,0,56,0,-20,0,0,0,-1,0,2],0],
    [[4,0,-16,0,36,0,-16,0,4],0],
    [[2,0,-8,0,12,0,-8,0,2],40],
    [[60,0,-220,0,316,0,-220,0,60],0],
    [[3,0,0,0,-21,0,40,0,-21,0,0,0,3],8],[[],0],
    [[8,0,-22,0,8],10],
    [[1,0,-6,0,10,0,-4,0,10,0,-6,0,1],40],
    [[2,0,-14,0,24,0,-14,0,2],10],
    [[2,0,-6,0,11,0,-14,0,11,0,-6,0,2],0],
    [[12,0,-62,0,130,0,-164,0,130,0,-62,0,12],0],
    [[6,0,-8,0,6],8],[[],0],
    [[-3,0,8,0,-10,0,8,0,-3],2],[[1,0,-2,0,1],4],
    [[],0],[[-1,0,1,0,0,0,1,0,-1],2],
    [[2,0,-4,0,2],6],[[],0],[[1,0,-2,0,1],6],
    [[],0],[[],0],[[],0],
    [[2,0,-14,0,33,0,-40,0,33,0,-14,0,2],0],
    [[-1,0,0,0,-1],4],[[],0],
    [[2,0,-1,0,-12,0,41,0,-64,0,41,0,-12,0,-1,0,2],0],
    [[4],46],[[2],26],[[-2],22],[[2],6],
    [[-1,0,0,0,-1],22],
    [[6,0,-29,0,61,0,-76,0,61,0,-29,0,6],0],
    [[-4,0,17,0,-26,0,17,0,-4],4],[[],0],
    [[2,0,-10,0,21,0,-26,0,21,0,-10,0,2],0],
    [[1,0,-2,0,1],24],[[],0],[[],0],
    [[-672,0,672],0],
    [[378,0,-294,0,0,0,0,0,294,0,-378],58],
    [[-180,0,492,0,-492,0,180],0],
    [[-3,0,1,0,0,0,40,0,-123,0,81,0,120,0,-120,0,-81,0,
    123,0,-40,0,0,0,-1,0,3],0],
    [[-40,0,164,0,-164,0,40],0],
    [[1,0,0,0,-10,0,30,0,-25,0,60,0,-60,0,25,0,-30,0,
    10,0,0,0,-1],20],
    [[6,0,-26,0,0,0,100,0,-100,0,0,0,26,0,-6],6],
    [[-3,0,1,0,33,0,-99,0,99,0,-33,0,-1,0,3],0],
    [[2,0,-6,0,6,0,-2],30],
    [[3,0,0,0,-3,0,3,0,0,0,-3],16],
    [[-14,0,66,0,-124,0,124,0,-66,0,14],0],
    [[-110,0,328,0,-328,0,110],0],
    [[-5,0,-9,0,15,0,21,0,-21,0,-15,0,9,0,5],24],
    [[8,0,-12,0,12,0,19,0,-19,0,-12,0,12,0,-8],18],
    [[3,0,-3],20],
    [[-33,0,144,0,-261,0,261,0,-144,0,33],0],
    [[-3,0,11,0,-24,0,24,0,-11,0,3],0],
    [[-22,0,94,0,-170,0,170,0,-94,0,22],0],
    [[-1,0,-7,0,7,0,1],20],
    [[-1,0,0,0,8,0,-8,0,0,0,1],20],
    [[-4,0,15,0,-15,0,4],10],[[4,0,-12,0,12,0,-4],2],
    [[-1,0,8,0,-19,0,19,0,-8,0,1],10],
    [[1,0,-1,0,1,0,-1],2],[[2,0,-8,0,8,0,-2],12],
    [[],0],[[],0],
    [[-3,0,22,0,-44,0,44,0,-22,0,3],0],
    [[1,0,-2,0,2,0,-1],12],
    [[4,0,-8,0,9,0,14,0,-49,0,49,0,-14,0,-9,0,8,0,-4],
    6],[[6,0,-28,0,28,0,-6],4],
    [[-11,0,42,0,-81,0,81,0,-42,0,11],0],
    [[-1,0,1,0,0,0,-4,0,4,0,0,0,-1,0,1],10],
    [[2,0,-7,0,13,0,-13,0,7,0,-2],4],[[],0],
    [[-1,0,1],6],[[-1,0,1],10],
    [[-1,0,1,0,-1,0,1],4],[[],0],
    [[-1,0,1,0,-1,0,1],6],[[],0],
    [[-1,0,4,0,-8,0,10,0,-10,0,8,0,-4,0,1],0],
    [[1,0,0,0,0,0,-1],6],
    [[1,0,-1,0,0,0,0,0,1,0,-1],2],
    [[-1,0,1,0,-1,0,1],8],
    [[-1,0,7,0,-16,0,22,0,-22,0,16,0,-7,0,1],0],
    [[2,0,-2],12]],
    [[[840],0],[[-840],138],[[-24,0,36,0,0,0,-72,0,0,0,
    180,0,-140,0,0,0,0,0,20],6],
    [[148,0,-418,0,274],0],
    [[-30,0,90,0,-100,0,150,0,-30,0,-70,0,0,0,-48,0,0,0,
    30,0,0,0,10,0,-6],26],[[],0],
    [[20,0,-152,0,312,0,-268,0,88],0],
    [[84,0,-273,0,210],0],
    [[-70,0,0,0,84,0,-64,0,15,0,0,0,20,0,0,0,-6],70],
    [[-60],92],[[60],46],
    [[-2,0,0,0,24,0,-32,0,12,0,0,0,4,0,0,0,-3],24],
    [[15,0,-42,0,24],46],
    [[8,0,-52,0,136,0,-142,0,44],0],
    [[4,0,-20,0,44,0,-32,0,10],46],
    [[-12,0,72,0,-60,0,0,0,20],4],
    [[-8,0,0,0,0,0,-12],72],
    [[-2,0,4,0,-6,0,-2,0,8,0,0,0,-2],14],
    [[4,0,-36,0,104,0,-110,0,40],0],
    [[2,0,-2,0,-2,0,28,0,-26,0,-26,0,42,0,-19,0,0,0,-1,
    0,2],8],[[],0],
    [[-2,0,10,0,-28,0,36,0,-20,0,4],2],
    [[-10,0,40,0,-55,0,20],2],[[5],34],[[],0],
    [[],0],
    [[-4,0,8,0,-13,0,26,0,22,0,-18,0,-83,0,84,0,-24,0,
    2,0,-7,0,4],6],[[-6,0,24,0,-35,0,20],2],
    [[-6,0,18,0,-16,0,4],48],
    [[12,0,-90,0,208,0,-193,0,64],0],
    [[-1,0,0,0,10,0,-20,0,-1,0,14,0,-3],10],[[],0],
    [[-6,0,8,0,4,0,-4,0,1],12],
    [[-2,0,8,0,-22,0,19,0,-8,0,2],48],
    [[-2,0,6,0,-8,0,2,0,6,0,-4],12],
    [[-1,0,4,0,-14,0,20,0,-13,0,4],2],
    [[-10,0,58,0,-116,0,118,0,-66,0,14],2],
    [[-4,0,8,0,0,0,-2],10],[[],0],
    [[3,0,-12,0,17,0,-10,0,2],4],[[-3,0,6,0,-3],6],
    [[],0],[[1,0,-4,0,7,0,-6,0,2],4],
    [[-4,0,6,0,-4],8],[[2],40],[[-2,0,4,0,-2],8],
    [[],0],[[],0],[[],0],
    [[-1,0,14,0,-36,0,42,0,-26,0,6],2],[[2,0,-1],8],
    [[],0],[[11,0,-34,0,41,0,-10,0,-7,0,4],6],
    [[-6,0,3,0,-2],52],[[2],26],[[-2],24],
    [[-1],10],[[-1,0,2],24],
    [[-4,0,25,0,-58,0,65,0,-37,0,8],2],
    [[3,0,-16,0,21,0,-8,0,-1,0,2],6],[[],0],
    [[-1,0,8,0,-23,0,30,0,-17,0,4],2],[[-1],30],
    [[],0],[[],0],[[-357,0,483],0],
    [[-378,0,189,0,0,0,0,0,0,0,168,0,0,0,0,0,-105],68],
    [[-58,0,270,0,-357,0,155],0],
    [[12,0,-21,0,27,0,14,0,-58,0,-81,0,167,0,-72,0,0,0,
    -9,0,11],6],[[-10,0,74,0,-135,0,75],0],
    [[-15,0,15,0,-20,0,30,0,10,0,-10,0,4,0,-19,0,0,0,0,
    0,0,0,1],28],
    [[-4,0,0,0,20,0,-36,0,0,0,52,0,-35,0,0,0,0,0,3],8
    ],[[3,0,-39,0,69,0,-33,0,-9,0,11],4],
    [[3,0,0,0,-2,0,-3],38],
    [[-3,0,-3,0,6,0,-3,0,0,0,3],20],
    [[-1,0,17,0,-68,0,108,0,-78,0,22],0],
    [[-34,0,164,0,-254,0,115],0],
    [[9,0,0,0,5,0,9,0,-11,0,0,0,-5,0,0,0,1,0,1],30],
    [[-2,0,-4,0,-12,0,28,0,-22,0,6,0,-2,0,2,0,0,0,-3],
    24],[[6,0,3],26],
    [[-3,0,44,0,-147,0,201,0,-136,0,36],0],
    [[3,0,-13,0,31,0,-27,0,11],2],
    [[-2,0,26,0,-92,0,140,0,-97,0,25],0],
    [[1,0,-5,0,2,0,2],26],[[4,0,-4,0,0,0,1],30],
    [[2,0,-8,0,2,0,4,0,-2,0,1],12],
    [[-6,0,18,0,-17,0,3],4],
    [[1,0,-2,0,9,0,-5,0,-2,0,4,0,-3],12],
    [[-2,0,6,0,-9,0,3],4],[[8,0,-5,0,-1],16],
    [[-1,0,1],20],[[-1,0,1],8],
    [[4,0,-24,0,48,0,-38,0,11],2],[[-1,0,2,0,-2],14],
    [[-1,0,1,0,-4,0,-4,0,24,0,-8,0,-23,0,19,0,-7,0,0,
    0,-1,0,1],8],[[-8,0,24,0,-16,0,0,0,3],6],
    [[-1,0,10,0,-41,0,75,0,-56,0,14],0],
    [[3,0,-4,0,-2,0,2],18],
    [[-1,0,5,0,-13,0,11,0,-2,0,-1,0,1],6],[[],0],
    [[-1],12],[[1],14],[[2,0,-4,0,4,0,-2],6],
    [[],0],[[1,0,-3,0,3,0,-1],8],[[],0],
    [[-2,0,7,0,-13,0,12,0,-6,0,1],4],[[-1,0,2],10],
    [[2,0,-3,0,4,0,-3,0,1],6],[[-2,0,1],12],
    [[-4,0,17,0,-25,0,23,0,-12,0,2],4],[[-2,0,1],14]
    ],
    [[[840],0],[[-840],102],[[20,0,0,0,0,0,-140,0,180,
    0,0,0,-72,0,0,0,36,0,-24],0],
    [[274,0,-418,0,148],0],
    [[-6,0,10,0,0,0,30,0,0,0,-48,0,0,0,-70,0,-30,0,150,
    0,-100,0,90,0,-30],10],[[],0],
    [[88,0,-268,0,312,0,-152,0,20],0],
    [[210,0,-273,0,84],0],
    [[-6,0,0,0,20,0,0,0,15,0,-64,0,84,0,0,0,-70],42],
    [[-60],68],[[60],34],
    [[-3,0,0,0,4,0,0,0,12,0,-32,0,24,0,0,0,-2],8],
    [[24,0,-42,0,15],34],
    [[44,0,-142,0,136,0,-52,0,8],0],
    [[10,0,-32,0,44,0,-20,0,4],34],
    [[20,0,0,0,-60,0,72,0,-12],0],
    [[-12,0,0,0,0,0,-8],54],
    [[-2,0,0,0,8,0,-2,0,-6,0,4,0,-2],6],
    [[40,0,-110,0,104,0,-36,0,4],0],
    [[2,0,-1,0,0,0,-19,0,42,0,-26,0,-26,0,28,0,-2,0,-2,
    0,2],0],[[],0],
    [[4,0,-20,0,36,0,-28,0,10,0,-2],0],
    [[20,0,-55,0,40,0,-10],0],[[5],30],[[],0],
    [[],0],
    [[4,0,-7,0,2,0,-24,0,84,0,-83,0,-18,0,22,0,26,0,
    -13,0,8,0,-4],0],[[20,0,-35,0,24,0,-6],0],
    [[4,0,-16,0,18,0,-6],34],
    [[64,0,-193,0,208,0,-90,0,12],0],
    [[-3,0,14,0,-1,0,-20,0,10,0,0,0,-1],6],[[],0],
    [[1,0,-4,0,4,0,8,0,-6],4],
    [[2,0,-8,0,19,0,-22,0,8,0,-2],34],
    [[-4,0,6,0,2,0,-8,0,6,0,-2],6],
    [[4,0,-13,0,20,0,-14,0,4,0,-1],0],
    [[14,0,-66,0,118,0,-116,0,58,0,-10],0],
    [[-2,0,0,0,8,0,-4],4],[[],0],
    [[2,0,-10,0,17,0,-12,0,3],0],[[-3,0,6,0,-3],2],
    [[],0],[[2,0,-6,0,7,0,-4,0,1],0],
    [[-4,0,6,0,-4],4],[[2],28],[[-2,0,4,0,-2],4],
    [[],0],[[],0],[[],0],
    [[6,0,-26,0,42,0,-36,0,14,0,-1],0],[[-1,0,2],2],
    [[],0],[[4,0,-7,0,-10,0,41,0,-34,0,11],0],
    [[-2,0,3,0,-6],36],[[2],26],[[-2],20],
    [[-1],2],[[2,0,-1],22],
    [[8,0,-37,0,65,0,-58,0,25,0,-4],0],
    [[2,0,-1,0,-8,0,21,0,-16,0,3],0],[[],0],
    [[4,0,-17,0,30,0,-23,0,8,0,-1],0],[[-1],22],
    [[],0],[[],0],[[-483,0,357],0],
    [[105,0,0,0,0,0,-168,0,0,0,0,0,0,0,-189,0,378],42],
    [[-155,0,357,0,-270,0,58],0],
    [[-11,0,9,0,0,0,72,0,-167,0,81,0,58,0,-14,0,-27,0,
    21,0,-12],0],[[-75,0,135,0,-74,0,10],0],
    [[-1,0,0,0,0,0,0,0,19,0,-4,0,10,0,-10,0,-30,0,20,
    0,-15,0,15],12],
    [[-3,0,0,0,0,0,35,0,-52,0,0,0,36,0,-20,0,0,0,4],0
    ],[[-11,0,9,0,33,0,-69,0,39,0,-3],0],
    [[3,0,2,0,0,0,-3],22],
    [[-3,0,0,0,3,0,-6,0,3,0,3],12],
    [[-22,0,78,0,-108,0,68,0,-17,0,1],0],
    [[-115,0,254,0,-164,0,34],0],
    [[-1,0,-1,0,0,0,5,0,0,0,11,0,-9,0,-5,0,0,0,-9],14
    ],
    [[3,0,0,0,-2,0,2,0,-6,0,22,0,-28,0,12,0,4,0,2],8]
    ,[[-3,0,-6],14],
    [[-36,0,136,0,-201,0,147,0,-44,0,3],0],
    [[-11,0,27,0,-31,0,13,0,-3],0],
    [[-25,0,97,0,-140,0,92,0,-26,0,2],0],
    [[-2,0,-2,0,5,0,-1],14],[[-1,0,0,0,4,0,-4],14],
    [[-1,0,2,0,-4,0,-2,0,8,0,-2],4],
    [[-3,0,17,0,-18,0,6],0],
    [[3,0,-4,0,2,0,5,0,-9,0,2,0,-1],6],
    [[-3,0,9,0,-6,0,2],0],[[1,0,5,0,-8],10],
    [[-1,0,1],12],[[-1,0,1],4],
    [[-11,0,38,0,-48,0,24,0,-4],0],[[2,0,-2,0,1],12],
    [[-1,0,1,0,0,0,7,0,-19,0,23,0,8,0,-24,0,4,0,4,0,
    -1,0,1],0],[[-3,0,0,0,16,0,-24,0,8],0],
    [[-14,0,56,0,-75,0,41,0,-10,0,1],0],
    [[-2,0,2,0,4,0,-3],10],
    [[-1,0,1,0,2,0,-11,0,13,0,-5,0,1],0],[[],0],
    [[1],2],[[-1],8],[[2,0,-4,0,4,0,-2],2],
    [[],0],[[1,0,-3,0,3,0,-1],4],[[],0],
    [[-1,0,6,0,-12,0,13,0,-7,0,2],0],[[-2,0,1],6],
    [[-1,0,3,0,-4,0,3,0,-2],0],[[-1,0,2],8],
    [[-2,0,12,0,-23,0,25,0,-17,0,4],0],[[-1,0,2],10]
    ],
    [[[1008],0],[[-1008],150],[[-8,0,36,0,0,0,-56,0,0,
    0,252,0,-272,0,0,0,0,0,48],6],
    [[132,0,-492,0,384],0],
    [[-136,0,90,0,0,0,40,0,0,0,-54,0,-40,0,90,0,0,0,20,
    0,-36,0,0,0,0,0,0,0,0,0,2],30],[[],0],
    [[12,0,-120,0,360,0,-384,0,132],0],
    [[72,0,-306,0,324],0],
    [[-90,0,0,0,-24,0,64,0,-45,0,0,0,0,0,0,0,6,0,0,0,
    0,0,0,0,-1],74],[[36],100],[[-36],50],
    [[9,0,0,0,6,0,-40,0,36,0,0,0,12,0,0,0,-15,0,0,0,
    0,0,0,0,1],24],[[-9,0,18,0,-18],50],
    [[2,0,-38,0,156,0,-206,0,86],0],
    [[-2,0,8,0,-18,0,20,0,-8],50],
    [[-12,0,56,0,-84,0,0,0,48],4],[[-8],78],
    [[2,0,-8,0,-2,0,20,0,-2,0,-12,0,0,0,0,0,2],16],
    [[1,0,-25,0,116,0,-175,0,79],0],
    [[-2,0,0,0,12,0,-13,0,-41,0,96,0,-46,0,0,0,-7,0,5],
    10],[[],0],[[4,0,-32,0,62,0,-44,0,10],4],
    [[-6,0,45,0,-90,0,54],2],
    [[-4,0,0,0,0,0,0,0,0,0,0,0,1],34],[[-2],60],
    [[2],30],
    [[-17,0,16,0,16,0,-4,0,-113,0,160,0,-64,0,8,0,-16,0,
    8],10],[[-2,0,28,0,-68,0,48],2],
    [[2,0,-4,0,8,0,-6],52],
    [[5,0,-69,0,236,0,-285,0,107],0],
    [[-1,0,2,0,4,0,-8,0,-1,0,30,0,-22,0,0,0,0,0,2],10
    ],[[],0],[[-3,0,2,0,4,0,-12,0,5,0,0,0,1],12],
    [[-1,0,6,0,-8,0,8,0,-2],54],
    [[-1,0,2,0,-3,0,1,0,16,0,-16,0,0,0,0,0,1],12],
    [[1,0,-18,0,41,0,-32,0,8],4],
    [[-2,0,34,0,-128,0,186,0,-114,0,24],2],
    [[-4,0,10,0,-4,0,-4,0,0,0,2],10],[[],0],
    [[1,0,-14,0,35,0,-29,0,7],4],
    [[-4,0,14,0,-13,0,3],6],[[],0],
    [[-6,0,20,0,-19,0,5],6],
    [[-2,0,10,0,-10,0,0,0,2],8],[[],0],
    [[5,0,-6,0,0,0,1],10],[[],0],[[],0],
    [[],0],[[6,0,-41,0,78,0,-57,0,13],4],
    [[-1,0,6,0,-6,0,2],6],[[],0],
    [[5,0,-28,0,49,0,-16,0,-16,0,8],6],
    [[-2,0,-1,0,2,0,-1],56],[[2],28],[[-2],26],
    [[-1,0,4,0,-5,0,1],6],[[-1,0,2],26],
    [[13,0,-64,0,109,0,-72,0,16],4],
    [[1,0,-12,0,28,0,-17,0,-7,0,5],6],[[],0],
    [[3,0,-26,0,55,0,-41,0,9],4],[[-1,0,1],32],
    [[1],20],[[-1],10],[[-378,0,630],0],
    [[-280,0,0,0,-189,0,210,0,0,0,0,0,15,0,0,0,0,0,-35,
    0,0,0,0,0,0,0,27],72],
    [[-42,0,270,0,-468,0,228],0],
    [[-17,0,27,0,18,0,-38,0,-99,0,273,0,-152,0,0,0,-24,
    0,24],8],[[-6,0,66,0,-180,0,144],0],
    [[-45,0,20,0,0,0,11,0,4,0,-18,0,-10,0,15,0,-1,0,6,
    0,-6],32],
    [[-1,0,3,0,8,0,-20,0,-3,0,91,0,-90,0,0,0,0,0,12],
    8],[[3,0,-27,0,71,0,-51,0,-24,0,24],4],
    [[3,0,-4,0,-3,0,3,0,2,0,3],40],
    [[-1,0,-3,0,-3,0,11,0,-3,0,0,0,-1],24],
    [[7,0,-59,0,149,0,-139,0,42],2],
    [[-21,0,162,0,-330,0,189],0],
    [[-24,0,26,0,-15,0,5,0,0,0,0,0,4,0,4],32],
    [[9,0,0,0,22,0,-42,0,18,0,-6,0,6,0,9,0,-6,0,0,0,
    0,0,-1],26],[[-10,0,3,0,-3,0,1],24],
    [[-1,0,23,0,-133,0,269,0,-217,0,59],0],
    [[-11,0,49,0,-62,0,24],4],
    [[12,0,-82,0,186,0,-162,0,46],2],
    [[-3,0,6,0,-6,0,6,0,-3],24],
    [[2,0,-1,0,2,0,-8,0,8],26],
    [[-3,0,0,0,8,0,-9,0,2,0,-1],14],
    [[-5,0,27,0,-38,0,16],4],
    [[-1,0,2,0,-3,0,-7,0,17,0,-7,0,0,0,-1],14],
    [[-1,0,13,0,-24,0,12],4],
    [[-1,0,1,0,2,0,-4,0,0,0,6,0,-4],12],
    [[-1,0,1,0,1,0,-1],20],[[-3,0,6,0,-3],8],
    [[1,0,-20,0,68,0,-79,0,27],2],[[1,0,2],20],
    [[-2,0,-1,0,10,0,2,0,-45,0,52,0,-16,0,3,0,-4,0,1],
    12],[[-5,0,23,0,-30,0,0,0,12],6],
    [[3,0,-36,0,102,0,-101,0,32],2],
    [[1,0,-3,0,-2,0,6,0,0,0,-2],18],
    [[2,0,-13,0,18,0,-4,0,-4,0,1],8],
    [[-1,0,2,0,-1],8],[[-3,0,5,0,-3],8],
    [[2,0,-1],14],[[1,0,-9,0,15,0,-8,0,1],6],
    [[1,0,-1],12],[[-2,0,6,0,-3,0,-1],10],
    [[-1,0,1],8],[[4,0,-22,0,30,0,-15,0,2],6],
    [[-1,0,4,0,-2],10],[[1,0,-9,0,15,0,-8,0,1],6],
    [[-2,0,4,0,-1,0,-1],12],
    [[11,0,-41,0,52,0,-26,0,4],6],[[1,0,0,0,-1],16]]
    ,
    [[[1008],0],[[-1008],90],[[48,0,0,0,0,0,-272,0,252,
    0,0,0,-56,0,0,0,36,0,-8],0],
    [[384,0,-492,0,132],0],
    [[2,0,0,0,0,0,0,0,0,0,-36,0,20,0,0,0,90,0,-40,0,
    -54,0,0,0,40,0,0,0,90,0,-136],0],[[],0],
    [[132,0,-384,0,360,0,-120,0,12],0],
    [[324,0,-306,0,72],0],
    [[-1,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,-45,0,64,0,
    -24,0,0,0,-90],30],[[36],60],[[-36],30],
    [[1,0,0,0,0,0,0,0,-15,0,0,0,12,0,0,0,36,0,-40,0,
    6,0,0,0,9],0],[[-18,0,18,0,-9],30],
    [[86,0,-206,0,156,0,-38,0,2],0],
    [[-8,0,20,0,-18,0,8,0,-2],30],
    [[48,0,0,0,-84,0,56,0,-12],0],[[-8],54],
    [[2,0,0,0,0,0,-12,0,-2,0,20,0,-2,0,-8,0,2],0],
    [[79,0,-175,0,116,0,-25,0,1],0],
    [[5,0,-7,0,0,0,-46,0,96,0,-41,0,-13,0,12,0,0,0,-2],
    0],[[],0],[[10,0,-44,0,62,0,-32,0,4],0],
    [[54,0,-90,0,45,0,-6],0],
    [[1,0,0,0,0,0,0,0,0,0,0,0,-4],18],[[-2],36],
    [[2],18],
    [[8,0,-16,0,8,0,-64,0,160,0,-113,0,-4,0,16,0,16,0,
    -17],0],[[48,0,-68,0,28,0,-2],0],
    [[-6,0,8,0,-4,0,2],30],
    [[107,0,-285,0,236,0,-69,0,5],0],
    [[2,0,0,0,0,0,-22,0,30,0,-1,0,-8,0,4,0,2,0,-1],0]
    ,[[],0],[[1,0,0,0,5,0,-12,0,4,0,2,0,-3],0],
    [[-2,0,8,0,-8,0,6,0,-1],30],
    [[1,0,0,0,0,0,-16,0,16,0,1,0,-3,0,2,0,-1],0],
    [[8,0,-32,0,41,0,-18,0,1],0],
    [[24,0,-114,0,186,0,-128,0,34,0,-2],0],
    [[2,0,0,0,-4,0,-4,0,10,0,-4],0],[[],0],
    [[7,0,-29,0,35,0,-14,0,1],0],
    [[3,0,-13,0,14,0,-4],0],[[],0],
    [[5,0,-19,0,20,0,-6],0],
    [[2,0,0,0,-10,0,10,0,-2],0],[[],0],
    [[1,0,0,0,-6,0,5],0],[[],0],[[],0],[[],0],
    [[13,0,-57,0,78,0,-41,0,6],0],
    [[2,0,-6,0,6,0,-1],0],[[],0],
    [[8,0,-16,0,-16,0,49,0,-28,0,5],0],
    [[-1,0,2,0,-1,0,-2],30],[[2],24],[[-2],18],
    [[1,0,-5,0,4,0,-1],0],[[2,0,-1],20],
    [[16,0,-72,0,109,0,-64,0,13],0],
    [[5,0,-7,0,-17,0,28,0,-12,0,1],0],[[],0],
    [[9,0,-41,0,55,0,-26,0,3],0],[[1,0,-1],18],
    [[1],12],[[-1],6],[[-630,0,378],0],
    [[-27,0,0,0,0,0,0,0,35,0,0,0,0,0,-15,0,0,0,0,0,
    -210,0,189,0,0,0,280],28],
    [[-228,0,468,0,-270,0,42],0],
    [[-24,0,24,0,0,0,152,0,-273,0,99,0,38,0,-18,0,-27,0,
    17],0],[[-144,0,180,0,-66,0,6],0],
    [[6,0,-6,0,1,0,-15,0,10,0,18,0,-4,0,-11,0,0,0,-20,
    0,45],10],
    [[-12,0,0,0,0,0,90,0,-91,0,3,0,20,0,-8,0,-3,0,1],
    0],[[-24,0,24,0,51,0,-71,0,27,0,-3],0],
    [[-3,0,-2,0,-3,0,3,0,4,0,-3],16],
    [[1,0,0,0,3,0,-11,0,3,0,3,0,1],6],
    [[-42,0,139,0,-149,0,59,0,-7],0],
    [[-189,0,330,0,-162,0,21],0],
    [[-4,0,-4,0,0,0,0,0,-5,0,15,0,-26,0,24],16],
    [[1,0,0,0,0,0,6,0,-9,0,-6,0,6,0,-18,0,42,0,-22,0,
    0,0,-9],2],[[-1,0,3,0,-3,0,10],12],
    [[-59,0,217,0,-269,0,133,0,-23,0,1],0],
    [[-24,0,62,0,-49,0,11],0],
    [[-46,0,162,0,-186,0,82,0,-12],0],
    [[3,0,-6,0,6,0,-6,0,3],14],
    [[-8,0,8,0,-2,0,1,0,-2],16],
    [[1,0,-2,0,9,0,-8,0,0,0,3],2],
    [[-16,0,38,0,-27,0,5],0],
    [[1,0,0,0,7,0,-17,0,7,0,3,0,-2,0,1],2],
    [[-12,0,24,0,-13,0,1],0],
    [[4,0,-6,0,0,0,4,0,-2,0,-1,0,1],6],
    [[1,0,-1,0,-1,0,1],8],[[3,0,-6,0,3],2],
    [[-27,0,79,0,-68,0,20,0,-1],0],[[-2,0,-1],8],
    [[-1,0,4,0,-3,0,16,0,-52,0,45,0,-2,0,-10,0,1,0,2],
    0],[[-12,0,0,0,30,0,-23,0,5],0],
    [[-32,0,101,0,-102,0,36,0,-3],0],
    [[2,0,0,0,-6,0,2,0,3,0,-1],6],
    [[-1,0,4,0,4,0,-18,0,13,0,-2],0],
    [[1,0,-2,0,1],2],[[3,0,-5,0,3],2],
    [[1,0,-2],6],[[-1,0,8,0,-15,0,9,0,-1],0],
    [[1,0,-1],4],[[1,0,3,0,-6,0,2],2],
    [[-1,0,1],4],[[-2,0,15,0,-30,0,22,0,-4],0],
    [[2,0,-4,0,1],4],[[-1,0,8,0,-15,0,9,0,-1],0],
    [[1,0,1,0,-4,0,2],4],
    [[-4,0,26,0,-52,0,41,0,-11],0],[[1,0,0,0,-1],6]]
    ,
    [[[2016],0],[[-2016],120],[[-112,0,288,0,0,0,-352,0,
    0,0,288,0,-112],6],[[516,0,-984,0,516],0],
    [[-20,0,0,0,0,0,70,0,-180,0,270,0,-328,0,270,0,-180,
    0,70,0,0,0,0,0,-20],18],[[],0],
    [[144,0,-504,0,720,0,-504,0,144],0],
    [[306,0,-702,0,306],0],
    [[-15,0,0,0,60,0,0,0,0,0,0,0,60,0,0,0,-15],56],
    [[-36],80],[[36],40],
    [[-3,0,0,0,30,0,0,0,-36,0,0,0,30,0,0,0,-3],16],
    [[9,0,-36,0,9],40],
    [[58,0,-214,0,312,0,-214,0,58],0],
    [[2,0,-20,0,36,0,-20,0,2],40],
    [[-96,0,208,0,-96],4],[[-16],66],
    [[4,0,-6,0,-16,0,36,0,-16,0,-6,0,4],10],
    [[35,0,-155,0,232,0,-155,0,35],0],
    [[-6,0,31,0,-19,0,-72,0,140,0,-72,0,-19,0,31,0,-6],
    6],[[],0],
    [[4,0,-20,0,42,0,-52,0,42,0,-20,0,4],0],
    [[9,0,-51,0,90,0,-51,0,9],0],
    [[1,0,0,0,-4,0,0,0,0,0,0,0,-4,0,0,0,1],24],
    [[-4],48],[[4],24],
    [[-28,0,103,0,-103,0,-29,0,120,0,-29,0,-103,0,103,0,
    -28],6],[[-28,0,50,0,-28],2],
    [[-8,0,16,0,-8],42],
    [[91,0,-327,0,478,0,-327,0,91],0],
    [[-2,0,5,0,-4,0,-28,0,52,0,-28,0,-4,0,5,0,-2],6],
    [[],0],[[1,0,10,0,-28,0,10,0,1],8],
    [[-2,0,13,0,-16,0,13,0,-2],42],
    [[1,0,0,0,-18,0,34,0,-18,0,0,0,1],8],
    [[-7,0,17,0,-20,0,17,0,-7],2],
    [[20,0,-90,0,194,0,-248,0,194,0,-90,0,20],0],
    [[-2,0,10,0,-16,0,10,0,-2],6],[[],0],
    [[1,0,-5,0,12,0,-16,0,12,0,-5,0,1],0],
    [[-1,0,2,0,-2,0,2,0,-1],2],[[],0],
    [[1,0,-2,0,1],4],[[2,0,-4,0,2],6],[[],0],
    [[],0],[[],0],[[],0],[[],0],
    [[4,0,-21,0,48,0,-64,0,48,0,-21,0,4],0],[[2],6],
    [[],0],[[-21,0,65,0,-90,0,65,0,-21],4],
    [[1,0,0,0,1],44],[[-2],26],[[2],22],
    [[-1,0,0,0,-1],4],[[1,0,0,0,1],22],
    [[9,0,-42,0,90,0,-116,0,90,0,-42,0,9],0],
    [[-6,0,25,0,-36,0,25,0,-6],4],[[],0],
    [[3,0,-14,0,31,0,-40,0,31,0,-14,0,3],0],
    [[1,0,-2,0,1],24],[[-1],16],[[1],8],
    [[-1008,0,1008],0],
    [[70,0,216,0,0,0,-210,0,0,0,0,0,210,0,0,0,-216,0,
    -70],54],[[-270,0,738,0,-738,0,270],0],
    [[68,0,-206,0,126,0,176,0,-176,0,-126,0,206,0,-68],6]
    ,[[-60,0,246,0,-246,0,60],0],
    [[-15,0,15,0,-35,0,49,0,-49,0,35,0,-15,0,15],24],
    [[9,0,-44,0,6,0,145,0,-145,0,-6,0,44,0,-9],6],
    [[54,0,-146,0,146,0,-54],4],
    [[2,0,-6,0,6,0,-2],30],
    [[3,0,-3,0,0,0,0,0,3,0,-3],16],
    [[-21,0,98,0,-187,0,187,0,-98,0,21],0],
    [[-165,0,492,0,-492,0,165],0],
    [[1,0,0,0,0,0,-5,0,5,0,-1,0,9,0,-9,0,1,0,-5,0,5,
    0,0,0,0,0,-1],18],
    [[3,0,0,0,-18,0,12,0,18,0,-18,0,-12,0,18,0,0,0,-3],
    16],[[7,0,6,0,-6,0,-7],18],
    [[-51,0,213,0,-393,0,393,0,-213,0,51],0],
    [[17,0,-36,0,36,0,-17],2],
    [[-34,0,138,0,-256,0,256,0,-138,0,34],0],
    [[3,0,-3,0,-6,0,6,0,3,0,-3],18],
    [[-2,0,1,0,6,0,-6,0,-1,0,2],20],
    [[-1,0,-6,0,18,0,-18,0,6,0,1],8],
    [[-1,0,8,0,-17,0,17,0,-8,0,1],0],
    [[-1,0,0,0,10,0,-25,0,25,0,-10,0,0,0,1],8],
    [[-2,0,2],4],
    [[-1,0,1,0,3,0,-5,0,5,0,-3,0,-1,0,1],8],
    [[],0],[[],0],
    [[-6,0,32,0,-67,0,67,0,-32,0,6],0],[[-1,0,1],14],
    [[3,0,-16,0,16,0,23,0,-69,0,69,0,-23,0,-16,0,16,0,
    -3],6],[[9,0,-40,0,40,0,-9],4],
    [[-14,0,65,0,-120,0,120,0,-65,0,14],0],
    [[4,0,-11,0,11,0,-4],14],
    [[3,0,-11,0,18,0,-18,0,11,0,-3],4],[[],0],
    [[1,0,0,0,0,0,-1],4],[[-1,0,1],10],
    [[1,0,-1,0,2,0,-2,0,1,0,-1],2],[[-1,0,1],8],
    [[],0],[[1,0,-1],6],
    [[-1,0,5,0,-10,0,15,0,-15,0,10,0,-5,0,1],0],
    [[-1,0,1],8],[[1,0,-1],6],
    [[-1,0,2,0,-2,0,1],8],
    [[-2,0,10,0,-22,0,34,0,-34,0,22,0,-10,0,2],0],
    [[1,0,-1],12]],
    [[[1296],0],[[-1296],140],[[-48,0,72,0,0,0,-24,0,0,
    0,252,0,-288,0,0,0,0,0,36],6],
    [[210,0,-660,0,426],0],
    [[-40,0,0,0,90,0,-232,0,180,0,0,0,0,0,0,0,0,0,-20,
    0,60,0,0,0,10,0,-24],24],[[],0],
    [[24,0,-204,0,504,0,-444,0,120],0],
    [[135,0,-405,0,351],0],[[-81],68],[[],0],
    [[],0],
    [[6,0,0,0,0,0,-48,0,45,0,0,0,6,0,0,0,-9],24],
    [[],0],[[6,0,-78,0,228,0,-228,0,72],0],[[],0],
    [[-24,0,96,0,-84,0,0,0,36],4],[[-24],76],
    [[-2,0,-8,0,0,0,20,0,-2,0,-8],16],
    [[5,0,-55,0,170,0,-190,0,66],0],
    [[3,0,-9,0,2,0,8,0,-3,0,-46,0,85,0,-34,0,0,0,-4,0,
    2],8],[[],0],
    [[14,0,-56,0,72,0,-34,0,4],4],
    [[1,0,-19,0,71,0,-94,0,42],0],
    [[-1,0,0,0,4,0,0,0,-6,0,0,0,4,0,0,0,-2],28],
    [[6],56],[[-6],28],
    [[12,0,-42,0,30,0,6,0,30,0,-129,0,150,0,-48,0,9,0,
    -12,0,3],8],[[-12,0,39,0,-72,0,36],2],
    [[],0],[[13,0,-126,0,337,0,-321,0,94],0],
    [[1,0,-4,0,0,0,4,0,-1,0,-4,0,21,0,-14],8],
    [[],0],[[-6,0,0,0,9,0,-6,0,3],12],[[],0],
    [[-3,0,0,0,0,0,0,0,12,0,-9],12],
    [[6,0,-30,0,45,0,-24,0,3],4],
    [[-8,0,72,0,-198,0,220,0,-100,0,14],2],
    [[2,0,-10,0,12,0,-2,0,-2],8],[[],0],
    [[5,0,-26,0,39,0,-21,0,3],4],
    [[1,0,-9,0,16,0,-8,0,1],4],[[-1],20],
    [[1,0,-10,0,20,0,-13,0,2],4],[[-6,0,12,0,-6],8],
    [[],0],[[-3,0,6,0,-3],8],[[],0],[[],0],
    [[],0],[[-1,0,18,0,-67,0,89,0,-45,0,7],2],
    [[-2,0,5,0,-4],6],[[],0],
    [[12,0,-54,0,57,0,-9,0,-12,0,3],6],[[3],52],
    [[],0],[[],0],[[3,0,-3],8],[[],0],
    [[-2,0,32,0,-105,0,126,0,-60,0,8],2],
    [[5,0,-24,0,33,0,-11,0,-4,0,2],6],[[],0],
    [[11,0,-46,0,63,0,-31,0,4],4],[[-1,0,2,0,-2],28],
    [[],0],[[],0],[[-540,0,756],0],
    [[-336,0,0,0,189,0,-315,0,0,0,0,0,210,0,0,0,0,0,15,
    0,0,0,0,0,21],66],
    [[-75,0,405,0,-585,0,231],0],
    [[12,0,-54,0,54,0,12,0,-12,0,-117,0,279,0,-144,0,0,
    0,-21,0,15],6],[[-20,0,115,0,-215,0,136],0],
    [[-10,0,0,0,25,0,-76,0,40,0,0,0,-9,0,3,0,1,0,0,0,
    10,0,-1,0,2,0,-1],26],
    [[1,0,-10,0,4,0,5,0,-8,0,-4,0,84,0,-78,0,0,0,0,0,
    6],6],[[6,0,-54,0,99,0,-45,0,-21,0,15],4],
    [[5,0,-3,0,0,0,-4,0,-3,0,3,0,2],36],
    [[3,0,3,0,-4,0,-3,0,-3,0,7,0,-3],20],
    [[-1,0,20,0,-106,0,193,0,-136,0,30],0],
    [[-45,0,255,0,-405,0,186],0],
    [[-5,0,0,0,19,0,-41,0,31,0,-5,0,5,0,-5,0,10,0,4,0,
    -5,0,0,0,1],26],
    [[-2,0,4,0,0,0,24,0,-48,0,21,0,-4,0,2,0,6,0,-3],
    24],[[6,0,-9,0,3,0,-3,0,3],22],
    [[-3,0,51,0,-219,0,351,0,-222,0,45],0],
    [[3,0,-24,0,60,0,-57,0,15],2],
    [[-1,0,29,0,-144,0,244,0,-161,0,33],0],
    [[1,0,-6,0,7,0,-7,0,7,0,-3,0,1],22],
    [[3,0,-3,0,3,0,-9,0,6],26],
    [[2,0,-4,0,-4,0,9,0,-4,0,1],12],
    [[1,0,-14,0,37,0,-33,0,9],2],
    [[1,0,-2,0,0,0,0,0,-7,0,11,0,-3],12],
    [[-4,0,15,0,-21,0,6],4],
    [[1,0,-2,0,1,0,2,0,-1,0,-1,0,4],10],
    [[-1,0,-1,0,1,0,1],18],[[1,0,-5,0,5,0,-1],6],
    [[6,0,-41,0,90,0,-72,0,18],2],[[-1],14],
    [[3,0,-7,0,-1,0,5,0,14,0,-48,0,39,0,-8,0,2,0,-2],
    10],[[1,0,-14,0,34,0,-24,0,0,0,6],4],
    [[11,0,-70,0,135,0,-96,0,21],2],
    [[-1,0,0,0,-2,0,-2,0,4],16],
    [[8,0,-22,0,17,0,-1,0,-2],8],[[-1,0,1],8],
    [[-2,0,3,0,-1],8],[[-1,0,2,0,-1],12],
    [[4,0,-14,0,13,0,-4],6],[[1],12],
    [[1,0,-5,0,5,0,-1],8],[[],0],
    [[13,0,-33,0,29,0,-8],6],[[-3,0,3,0,-1],10],
    [[3,0,-12,0,12,0,-4],6],[[1,0,-4,0,4],10],
    [[-2,0,26,0,-59,0,51,0,-16,0,1],4],
    [[-2,0,0,0,1],14]],
    [[[1296],0],[[-1296],100],[[36,0,0,0,0,0,-288,0,252,
    0,0,0,-24,0,0,0,72,0,-48],0],
    [[426,0,-660,0,210],0],
    [[-24,0,10,0,0,0,60,0,-20,0,0,0,0,0,0,0,0,0,180,0,
    -232,0,90,0,0,0,-40],10],[[],0],
    [[120,0,-444,0,504,0,-204,0,24],0],
    [[351,0,-405,0,135],0],[[-81],60],[[],0],
    [[],0],
    [[-9,0,0,0,6,0,0,0,45,0,-48,0,0,0,0,0,6],8],
    [[],0],[[72,0,-228,0,228,0,-78,0,6],0],[[],0],
    [[36,0,0,0,-84,0,96,0,-24],0],[[-24],56],
    [[-8,0,-2,0,20,0,0,0,-8,0,-2],6],
    [[66,0,-190,0,170,0,-55,0,5],0],
    [[2,0,-4,0,0,0,-34,0,85,0,-46,0,-3,0,8,0,2,0,-9,0,
    3],0],[[],0],
    [[4,0,-34,0,72,0,-56,0,14],0],
    [[42,0,-94,0,71,0,-19,0,1],0],
    [[-2,0,0,0,4,0,0,0,-6,0,0,0,4,0,0,0,-1],20],
    [[6],40],[[-6],20],
    [[3,0,-12,0,9,0,-48,0,150,0,-129,0,30,0,6,0,30,0,
    -42,0,12],0],[[36,0,-72,0,39,0,-12],0],
    [[],0],[[94,0,-321,0,337,0,-126,0,13],0],
    [[-14,0,21,0,-4,0,-1,0,4,0,0,0,-4,0,1],6],
    [[],0],[[3,0,-6,0,9,0,0,0,-6],4],[[],0],
    [[-9,0,12,0,0,0,0,0,0,0,-3],6],
    [[3,0,-24,0,45,0,-30,0,6],0],
    [[14,0,-100,0,220,0,-198,0,72,0,-8],0],
    [[-2,0,-2,0,12,0,-10,0,2],4],[[],0],
    [[3,0,-21,0,39,0,-26,0,5],0],
    [[1,0,-8,0,16,0,-9,0,1],0],[[-1],16],
    [[2,0,-13,0,20,0,-10,0,1],0],[[-6,0,12,0,-6],4],
    [[],0],[[-3,0,6,0,-3],4],[[],0],[[],0],
    [[],0],[[7,0,-45,0,89,0,-67,0,18,0,-1],0],
    [[-4,0,5,0,-2],2],[[],0],
    [[3,0,-12,0,-9,0,57,0,-54,0,12],0],[[3],40],
    [[],0],[[],0],[[-3,0,3],2],[[],0],
    [[8,0,-60,0,126,0,-105,0,32,0,-2],0],
    [[2,0,-4,0,-11,0,33,0,-24,0,5],0],[[],0],
    [[4,0,-31,0,63,0,-46,0,11],0],[[-2,0,2,0,-1],20],
    [[],0],[[],0],[[-756,0,540],0],
    [[-21,0,0,0,0,0,-15,0,0,0,0,0,-210,0,0,0,0,0,315,
    0,-189,0,0,0,336],36],
    [[-231,0,585,0,-405,0,75],0],
    [[-15,0,21,0,0,0,144,0,-279,0,117,0,12,0,-12,0,-54,
    0,54,0,-12],0],[[-136,0,215,0,-115,0,20],0],
    [[1,0,-2,0,1,0,-10,0,0,0,-1,0,-3,0,9,0,0,0,-40,0,
    76,0,-25,0,0,0,10],10],
    [[-6,0,0,0,0,0,78,0,-84,0,4,0,8,0,-5,0,-4,0,10,0,
    -1],0],[[-15,0,21,0,45,0,-99,0,54,0,-6],0],
    [[-2,0,-3,0,3,0,4,0,0,0,3,0,-5],18],
    [[3,0,-7,0,3,0,3,0,4,0,-3,0,-3],10],
    [[-30,0,136,0,-193,0,106,0,-20,0,1],0],
    [[-186,0,405,0,-255,0,45],0],
    [[-1,0,0,0,5,0,-4,0,-10,0,5,0,-5,0,5,0,-31,0,41,0,
    -19,0,0,0,5],12],
    [[3,0,-6,0,-2,0,4,0,-21,0,48,0,-24,0,0,0,-4,0,2],
    8],[[-3,0,3,0,-3,0,9,0,-6],12],
    [[-45,0,222,0,-351,0,219,0,-51,0,3],0],
    [[-15,0,57,0,-60,0,24,0,-3],0],
    [[-33,0,161,0,-244,0,144,0,-29,0,1],0],
    [[-1,0,3,0,-7,0,7,0,-7,0,6,0,-1],12],
    [[-6,0,9,0,-3,0,3,0,-3],16],
    [[-1,0,4,0,-9,0,4,0,4,0,-2],4],
    [[-9,0,33,0,-37,0,14,0,-1],0],
    [[3,0,-11,0,7,0,0,0,0,0,2,0,-1],6],
    [[-6,0,21,0,-15,0,4],0],
    [[-4,0,1,0,1,0,-2,0,-1,0,2,0,-1],8],
    [[-1,0,-1,0,1,0,1],10],[[1,0,-5,0,5,0,-1],2],
    [[-18,0,72,0,-90,0,41,0,-6],0],[[1],16],
    [[2,0,-2,0,8,0,-39,0,48,0,-14,0,-5,0,1,0,7,0,-3],
    2],[[-6,0,0,0,24,0,-34,0,14,0,-1],0],
    [[-21,0,96,0,-135,0,70,0,-11],0],
    [[-4,0,2,0,2,0,0,0,1],10],
    [[2,0,1,0,-17,0,22,0,-8],2],[[-1,0,1],4],
    [[1,0,-3,0,2],2],[[1,0,-2,0,1],6],
    [[4,0,-13,0,14,0,-4],2],[[-1],6],
    [[1,0,-5,0,5,0,-1],4],[[],0],
    [[8,0,-29,0,33,0,-13],2],[[1,0,-3,0,3],4],
    [[4,0,-12,0,12,0,-3],2],[[-4,0,4,0,-1],8],
    [[-1,0,16,0,-51,0,59,0,-26,0,2],0],
    [[-1,0,0,0,2],8]],
    [[[1400],0],[[-1400],138],[[-8,0,72,0,0,0,-224,0,0,
    0,360,0,-212,0,0,0,0,0,12],6],
    [[260,0,-670,0,470],0],
    [[-30,0,60,0,-164,0,210,0,-210,0,130,0,0,0,-30,0,-80,
    0,60,0,0,0,0,0,-6],26],[[],0],
    [[56,0,-248,0,480,0,-452,0,164],0],
    [[120,0,-475,0,330],0],
    [[90,0,0,0,-60,0,0,0,15,0,0,0,-20],70],
    [[20],92],[[-20],46],
    [[-27,0,0,0,42,0,-24,0,-6,0,0,0,2],24],
    [[-3,0,22,0,-6],46],
    [[12,0,-86,0,206,0,-216,0,92],0],
    [[8,0,-26,0,12,0,-2],48],
    [[-24,0,128,0,-120,0,0,0,12],4],
    [[-8,0,0,0,0,0,12],72],
    [[-2,0,18,0,-18,0,-12,0,20,0,-4,0,-2],14],
    [[5,0,-55,0,152,0,-171,0,67],0],
    [[2,0,-2,0,-30,0,84,0,-61,0,-37,0,74,0,-29,0,0,0,0,
    0,1],8],[[],0],
    [[-2,0,12,0,-32,0,48,0,-40,0,14],2],
    [[-10,0,55,0,-75,0,30],2],[[],0],[[],0],
    [[],0],
    [[13,0,-27,0,-11,0,80,0,-17,0,-125,0,167,0,-68,0,0,
    0,-3,0,6],8],[[-2,0,28,0,-53,0,12],2],
    [[2,0,-10,0,8],48],
    [[27,0,-147,0,316,0,-314,0,121],0],
    [[-2,0,-6,0,32,0,-34,0,-2,0,20,0,-11],10],
    [[],0],[[-11,0,14,0,2,0,-2],12],
    [[-5,0,12,0,-12,0,2],50],
    [[-3,0,17,0,-20,0,0,0,7,0,-1],12],
    [[2,0,-12,0,24,0,-20,0,6],4],
    [[4,0,-26,0,80,0,-158,0,188,0,-122,0,34],0],
    [[-8,0,16,0,-8],10],[[],0],
    [[2,0,-9,0,18,0,-17,0,6],4],
    [[-1,0,4,0,-6,0,3],6],[[],0],
    [[-1,0,0,0,5,0,-5,0,1],4],[[-2,0,4,0,-4],8],
    [[2],40],[[3,0,-1],10],[[-2],18],[[-1],32],
    [[1],16],[[-3,0,14,0,-39,0,58,0,-43,0,13],2],
    [[1,0,0,0,-1],6],[[],0],
    [[-3,0,25,0,-56,0,63,0,-33,0,-3,0,6],4],
    [[2,0,-1],52],[[2],26],[[-2],24],
    [[1,0,-2],6],[[-1,0,2],24],
    [[1,0,-8,0,32,0,-72,0,96,0,-69,0,21],0],
    [[6,0,-22,0,31,0,-17,0,0,0,1],6],[[],0],
    [[-1,0,8,0,-24,0,38,0,-32,0,11],2],[[],0],
    [[],0],[[],0],[[-595,0,805],0],
    [[210,0,0,0,-216,0,-105,0,0,0,0,0,105,0,-189,0,0,0,
    -15],66],[[-118,0,426,0,-579,0,277],0],
    [[4,0,-40,0,36,0,100,0,-124,0,-144,0,292,0,-136,0,0,
    0,-3,0,9],6],[[-10,0,110,0,-225,0,105],0],
    [[15,0,-34,0,45,0,-40,0,40,0,0,0,-5,0,-20,0,20,0,0,
    0,0,0,-1],30],
    [[-3,0,3,0,64,0,-114,0,-3,0,95,0,-43,0,0,0,0,0,1],
    8],[[12,0,-72,0,116,0,-72,0,-3,0,9],4],
    [[6,0,-3,0,6,0,3,0,-5,0,3],34],
    [[6,0,-9,0,0,0,6,0,-3],24],
    [[-3,0,28,0,-93,0,155,0,-129,0,42],0],
    [[-55,0,270,0,-400,0,200],0],
    [[4,0,-15,0,1,0,-11,0,20,0,-9,0,0,0,-6,0,1],30],
    [[15,0,-12,0,-18,0,32,0,-13,0,-3,0,0,0,2],24],
    [[-6,0,-6,0,6,0,3],22],
    [[-14,0,81,0,-212,0,310,0,-235,0,73],0],
    [[1,0,-12,0,36,0,-37,0,9],2],
    [[-7,0,45,0,-133,0,205,0,-166,0,56],0],
    [[-2,0,5,0,3,0,-6,0,-1,0,1],22],
    [[2,0,-6,0,-1,0,3,0,0,0,-1],24],
    [[7,0,-10,0,7,0,1,0,-2],12],
    [[-5,0,17,0,-21,0,9],4],
    [[2,0,-10,0,17,0,-11,0,-2,0,5,0,-1],12],
    [[1,0,3,0,-7,0,1],4],
    [[-3,0,5,0,-2,0,-1,0,5,0,-2],14],[[1,0,-1],18],
    [[1,0,-2,0,1],10],[[5,0,-28,0,60,0,-57,0,20],2],
    [[-1,0,1],14],
    [[-1,0,1,0,7,0,-36,0,47,0,-17,0,-32,0,43,0,-16,0,0,
    0,0,0,1],8],[[-11,0,39,0,-26,0,0,0,1],6],
    [[-1,0,15,0,-57,0,101,0,-91,0,34],0],
    [[-3,0,8,0,-7,0,-2,0,5,0,-2],16],
    [[-2,0,8,0,-15,0,17,0,-9,0,0,0,1],6],[[],0],
    [[-1,0,1,0,-1],6],[[1],14],
    [[-2,0,5,0,-5,0,2],8],[[1,0,-1],10],
    [[-1,0,2,0,-1],10],[[],0],
    [[-1,0,5,0,-13,0,19,0,-15,0,5],4],
    [[1,0,0,0,-1],10],
    [[1,0,-1,0,-1,0,4,0,-3,0,1],4],
    [[-2,0,3,0,-2],12],
    [[1,0,-4,0,13,0,-29,0,36,0,-24,0,7],2],
    [[-1,0,1],14]],
    [[[1400],0],[[-1400],102],[[12,0,0,0,0,0,-212,0,360,
    0,0,0,-224,0,0,0,72,0,-8],0],
    [[470,0,-670,0,260],0],
    [[-6,0,0,0,0,0,60,0,-80,0,-30,0,0,0,130,0,-210,0,
    210,0,-164,0,60,0,-30],10],[[],0],
    [[164,0,-452,0,480,0,-248,0,56],0],
    [[330,0,-475,0,120],0],
    [[-20,0,0,0,15,0,0,0,-60,0,0,0,90],46],
    [[20],68],[[-20],34],
    [[2,0,0,0,-6,0,-24,0,42,0,0,0,-27],12],
    [[-6,0,22,0,-3],34],
    [[92,0,-216,0,206,0,-86,0,12],0],
    [[-2,0,12,0,-26,0,8],34],
    [[12,0,0,0,-120,0,128,0,-24],0],
    [[12,0,0,0,0,0,-8],54],
    [[-2,0,-4,0,20,0,-12,0,-18,0,18,0,-2],6],
    [[67,0,-171,0,152,0,-55,0,5],0],
    [[1,0,0,0,0,0,-29,0,74,0,-37,0,-61,0,84,0,-30,0,-2,
    0,2],0],[[],0],
    [[14,0,-40,0,48,0,-32,0,12,0,-2],0],
    [[30,0,-75,0,55,0,-10],0],[[],0],[[],0],
    [[],0],
    [[6,0,-3,0,0,0,-68,0,167,0,-125,0,-17,0,80,0,-11,0,
    -27,0,13],0],[[12,0,-53,0,28,0,-2],0],
    [[8,0,-10,0,2],36],
    [[121,0,-314,0,316,0,-147,0,27],0],
    [[-11,0,20,0,-2,0,-34,0,32,0,-6,0,-2],6],[[],0],
    [[-2,0,2,0,14,0,-11],6],[[2,0,-12,0,12,0,-5],36],
    [[-1,0,7,0,0,0,-20,0,17,0,-3],6],
    [[6,0,-20,0,24,0,-12,0,2],0],
    [[34,0,-122,0,188,0,-158,0,80,0,-26,0,4],0],
    [[-8,0,16,0,-8],6],[[],0],
    [[6,0,-17,0,18,0,-9,0,2],0],
    [[3,0,-6,0,4,0,-1],0],[[],0],
    [[1,0,-5,0,5,0,0,0,-1],0],[[-4,0,4,0,-2],4],
    [[2],28],[[-1,0,3],4],[[-2],14],[[-1],24],
    [[1],12],[[13,0,-43,0,58,0,-39,0,14,0,-3],0],
    [[-1,0,0,0,1],2],[[],0],
    [[6,0,-3,0,-33,0,63,0,-56,0,25,0,-3],0],
    [[-1,0,2],38],[[2],26],[[-2],20],
    [[-2,0,1],4],[[2,0,-1],22],
    [[21,0,-69,0,96,0,-72,0,32,0,-8,0,1],0],
    [[1,0,0,0,-17,0,31,0,-22,0,6],0],[[],0],
    [[11,0,-32,0,38,0,-24,0,8,0,-1],0],[[],0],
    [[],0],[[],0],[[-805,0,595],0],
    [[15,0,0,0,189,0,-105,0,0,0,0,0,105,0,216,0,0,0,
    -210],42],[[-277,0,579,0,-426,0,118],0],
    [[-9,0,3,0,0,0,136,0,-292,0,144,0,124,0,-100,0,-36,
    0,40,0,-4],0],[[-105,0,225,0,-110,0,10],0],
    [[1,0,0,0,0,0,-20,0,20,0,5,0,0,0,-40,0,40,0,-45,0,
    34,0,-15],10],
    [[-1,0,0,0,0,0,43,0,-95,0,3,0,114,0,-64,0,-3,0,3],
    0],[[-9,0,3,0,72,0,-116,0,72,0,-12],0],
    [[-3,0,5,0,-3,0,-6,0,3,0,-6],22],
    [[3,0,-6,0,0,0,9,0,-6],10],
    [[-42,0,129,0,-155,0,93,0,-28,0,3],0],
    [[-200,0,400,0,-270,0,55],0],
    [[-1,0,6,0,0,0,9,0,-20,0,11,0,-1,0,15,0,-4],16],
    [[-2,0,0,0,3,0,13,0,-32,0,18,0,12,0,-15],12],
    [[-3,0,-6,0,6,0,6],14],
    [[-73,0,235,0,-310,0,212,0,-81,0,14],0],
    [[-9,0,37,0,-36,0,12,0,-1],0],
    [[-56,0,166,0,-205,0,133,0,-45,0,7],0],
    [[-1,0,1,0,6,0,-3,0,-5,0,2],14],
    [[1,0,0,0,-3,0,1,0,6,0,-2],16],
    [[2,0,-1,0,-7,0,10,0,-7],6],
    [[-9,0,21,0,-17,0,5],0],
    [[1,0,-5,0,2,0,11,0,-17,0,10,0,-2],6],
    [[-1,0,7,0,-3,0,-1],0],
    [[2,0,-5,0,1,0,2,0,-5,0,3],6],[[1,0,-1],14],
    [[-1,0,2,0,-1],0],[[-20,0,57,0,-60,0,28,0,-5],0],
    [[-1,0,1],14],
    [[-1,0,0,0,0,0,16,0,-43,0,32,0,17,0,-47,0,36,0,-7,
    0,-1,0,1],0],[[-1,0,0,0,26,0,-39,0,11],0],
    [[-34,0,91,0,-101,0,57,0,-15,0,1],0],
    [[2,0,-5,0,2,0,7,0,-8,0,3],8],
    [[-1,0,0,0,9,0,-17,0,15,0,-8,0,2],0],[[],0],
    [[1,0,-1,0,1],4],[[-1],8],
    [[-2,0,5,0,-5,0,2],0],[[1,0,-1],6],
    [[1,0,-2,0,1],4],[[],0],
    [[-5,0,15,0,-19,0,13,0,-5,0,1],0],
    [[1,0,0,0,-1],4],[[-1,0,3,0,-4,0,1,0,1,0,-1],0]
    ,[[2,0,-3,0,2],6],
    [[-7,0,24,0,-36,0,29,0,-13,0,4,0,-1],0],
    [[-1,0,1],10]],
    [[[1400],0],[[-1400],150],[[-4,0,36,0,0,0,-144,0,0,
    0,396,0,-344,0,0,0,0,0,60],6],
    [[190,0,-670,0,540],0],
    [[-116,0,150,0,-60,0,50,0,0,0,-114,0,-80,0,120,0,0,
    0,30,0,-42,0,0,0,0,0,0,0,0,0,2],30],
    [[],0],[[20,0,-180,0,480,0,-520,0,200],0],
    [[90,0,-435,0,440],0],
    [[-80,0,0,0,24,0,-64,0,30,0,0,0,0,0,0,0,-6,0,0,0,
    0,0,0,0,1],74],[[-40],100],[[40],50],
    [[-10,0,0,0,30,0,-56,0,24,0,0,0,18,0,0,0,-12,0,0,
    0,0,0,0,0,2],24],[[9,0,-24,0,19],50],
    [[4,0,-52,0,202,0,-282,0,124],0],
    [[2,0,-8,0,26,0,-24,0,8],50],
    [[-12,0,80,0,-132,0,0,0,60],4],
    [[-4,0,0,0,0,0,8],78],
    [[10,0,-16,0,-8,0,28,0,-2,0,-14,0,0,0,0,0,2],16],
    [[1,0,-33,0,152,0,-233,0,111],0],
    [[-1,0,-3,0,39,0,-43,0,-57,0,128,0,-62,0,0,0,-7,0,8
    ],10],[[],0],[[6,0,-36,0,74,0,-62,0,18],4],
    [[-5,0,55,0,-120,0,70],2],[[],0],[[],0],
    [[],0],
    [[-13,0,14,0,40,0,-33,0,-154,0,229,0,-92,0,7,0,-20,
    0,13],10],[[-1,0,36,0,-86,0,60],2],
    [[-2,0,6,0,-10,0,6],52],
    [[9,0,-98,0,316,0,-383,0,159],0],
    [[2,0,10,0,-30,0,0,0,42,0,-29,0,0,0,0,0,2],12],
    [[],0],[[2,0,10,0,0,0,-18,0,4,0,0,0,2],12],
    [[1,0,-8,0,13,0,-8,0,2],54],
    [[1,0,3,0,-12,0,2,0,21,0,-17,0,0,0,0,0,2],12],
    [[2,0,-19,0,47,0,-43,0,13],4],
    [[-6,0,52,0,-164,0,236,0,-162,0,44],2],
    [[-2,0,14,0,-8,0,-6,0,0,0,2],10],[[],0],
    [[1,0,-15,0,39,0,-37,0,12],4],
    [[-3,0,14,0,-16,0,5],6],[[],0],
    [[-7,0,21,0,-22,0,8],6],
    [[-2,0,12,0,-14,0,0,0,2],8],[[2],40],
    [[-1,0,7,0,-9,0,0,0,2],8],[[1],22],[[-1],36],
    [[1],18],[[9,0,-49,0,93,0,-76,0,23],4],
    [[-1,0,6,0,-7,0,2],6],[[],0],
    [[7,0,-39,0,70,0,-32,0,-20,0,13],6],
    [[2,0,-2,0,1],58],[[-2,0,0,0,0,0,-2],28],
    [[2,0,2],26],[[4,0,-4,0,2],8],
    [[1,0,-2,0,-2,0,1],26],
    [[-1,0,19,0,-79,0,134,0,-101,0,29],2],
    [[1,0,-15,0,39,0,-27,0,-7,0,8],6],[[],0],
    [[4,0,-30,0,64,0,-55,0,17],4],[[],0],[[],0],
    [[],0],[[-525,0,875],0],
    [[-315,0,0,0,-189,0,378,0,-189,0,0,0,15,0,0,0,0,0,
    -56,0,0,0,0,0,-21,0,27],72],
    [[-65,0,375,0,-630,0,330],0],
    [[-13,0,27,0,44,0,-100,0,-153,0,383,0,-204,0,0,0,-27,
    0,33],8],[[-5,0,85,0,-250,0,190],0],
    [[-35,0,30,0,-5,0,16,0,9,0,-43,0,-20,0,30,0,-1,0,6,
    0,-7],32],
    [[3,0,23,0,-65,0,-3,0,136,0,-109,0,0,0,0,0,15],10],
    [[3,0,-37,0,103,0,-81,0,-27,0,33],4],
    [[-1,0,6,0,6,0,-4,0,-3,0,0,0,-1,0,3],36],
    [[5,0,-9,0,-3,0,14,0,-6,0,0,0,-1],24],
    [[11,0,-79,0,189,0,-186,0,65],2],
    [[-30,0,220,0,-450,0,265],0],
    [[-4,0,-1,0,15,0,10,0,-19,0,-15,0,1,0,10,0,0,0,-1,
    0,-1],32],
    [[-10,0,-12,0,42,0,-44,0,12,0,-8,0,10,0,6,0,-6,0,0,
    0,0,0,-1,0,1],26],
    [[9,0,9,0,-3,0,-2,0,-3],24],
    [[-2,0,39,0,-183,0,349,0,-297,0,95],0],
    [[-14,0,58,0,-78,0,33],4],
    [[-1,0,19,0,-110,0,240,0,-220,0,74],0],
    [[3,0,-5,0,-5,0,7,0,-1,0,1,0,-2],24],
    [[-2,0,1,0,2,0,-9,0,5,0,0,0,2,0,-1],26],
    [[-2,0,6,0,8,0,-12,0,2,0,-1,0,1],14],
    [[-4,0,30,0,-49,0,21],4],
    [[7,0,-8,0,-8,0,20,0,-9,0,0,0,-1,0,1],16],
    [[-1,0,15,0,-27,0,15],4],
    [[1,0,5,0,-13,0,0,0,10,0,-5],14],
    [[1,0,-2,0,1,0,1,0,-1],18],
    [[-2,0,5,0,-4,0,1],8],
    [[1,0,-24,0,84,0,-101,0,40],2],
    [[1,0,-3,0,1,0,2,0,-1],16],
    [[-1,0,-6,0,32,0,-13,0,-56,0,73,0,-26,0,2,0,-5,0,3]
    ,12],[[-4,0,32,0,-46,0,0,0,15],6],
    [[5,0,-45,0,127,0,-137,0,49],2],
    [[5,0,-6,0,-3,0,8,0,-1,0,-2],18],
    [[3,0,-16,0,25,0,-10,0,-5,0,3],8],
    [[-1,0,2,0,-1],8],[[-2,0,4,0,-3,0,1],8],
    [[-1,0,2,0,-1],12],[[1,0,-8,0,15,0,-11,0,3],6],
    [[1,0,-1],12],[[-4,0,8,0,-5,0,-1,0,1],10],
    [[1],10],[[5,0,-22,0,34,0,-23,0,6],6],
    [[-1,0,4,0,-3],10],[[1,0,-9,0,15,0,-11,0,3],6],
    [[-1,0,5,0,-2,0,-1],12],
    [[-1,0,14,0,-45,0,61,0,-39,0,10],4],
    [[3,0,-1,0,-2],16]],
    [[[1400],0],[[-1400],90],[[60,0,0,0,0,0,-344,0,396,
    0,0,0,-144,0,0,0,36,0,-4],0],
    [[540,0,-670,0,190],0],
    [[2,0,0,0,0,0,0,0,0,0,-42,0,30,0,0,0,120,0,-80,0,
    -114,0,0,0,50,0,-60,0,150,0,-116],0],[[],0],
    [[200,0,-520,0,480,0,-180,0,20],0],
    [[440,0,-435,0,90],0],
    [[1,0,0,0,0,0,0,0,-6,0,0,0,0,0,0,0,30,0,-64,0,24,
    0,0,0,-80],30],[[-40],60],[[40],30],
    [[2,0,0,0,0,0,0,0,-12,0,0,0,18,0,0,0,24,0,-56,0,
    30,0,0,0,-10],0],[[19,0,-24,0,9],30],
    [[124,0,-282,0,202,0,-52,0,4],0],
    [[8,0,-24,0,26,0,-8,0,2],30],
    [[60,0,0,0,-132,0,80,0,-12],0],
    [[8,0,0,0,0,0,-4],48],
    [[2,0,0,0,0,0,-14,0,-2,0,28,0,-8,0,-16,0,10],0],
    [[111,0,-233,0,152,0,-33,0,1],0],
    [[8,0,-7,0,0,0,-62,0,128,0,-57,0,-43,0,39,0,-3,0,-1
    ],0],[[],0],[[18,0,-62,0,74,0,-36,0,6],0],
    [[70,0,-120,0,55,0,-5],0],[[],0],[[],0],
    [[],0],
    [[13,0,-20,0,7,0,-92,0,229,0,-154,0,-33,0,40,0,14,0,
    -13],0],[[60,0,-86,0,36,0,-1],0],
    [[6,0,-10,0,6,0,-2],30],
    [[159,0,-383,0,316,0,-98,0,9],0],
    [[2,0,0,0,0,0,-29,0,42,0,0,0,-30,0,10,0,2],0],
    [[],0],[[2,0,0,0,4,0,-18,0,0,0,10,0,2],0],
    [[2,0,-8,0,13,0,-8,0,1],30],
    [[2,0,0,0,0,0,-17,0,21,0,2,0,-12,0,3,0,1],0],
    [[13,0,-43,0,47,0,-19,0,2],0],
    [[44,0,-162,0,236,0,-164,0,52,0,-6],0],
    [[2,0,0,0,-6,0,-8,0,14,0,-2],0],[[],0],
    [[12,0,-37,0,39,0,-15,0,1],0],
    [[5,0,-16,0,14,0,-3],0],[[],0],
    [[8,0,-22,0,21,0,-7],0],
    [[2,0,0,0,-14,0,12,0,-2],0],[[2],28],
    [[2,0,0,0,-9,0,7,0,-1],0],[[1],10],[[-1],20],
    [[1],10],[[23,0,-76,0,93,0,-49,0,9],0],
    [[2,0,-7,0,6,0,-1],0],[[],0],
    [[13,0,-20,0,-32,0,70,0,-39,0,7],0],
    [[1,0,-2,0,2],30],[[-2,0,0,0,0,0,-2],18],
    [[2,0,2],16],[[2,0,-4,0,4],0],
    [[1,0,-2,0,-2,0,1],16],
    [[29,0,-101,0,134,0,-79,0,19,0,-1],0],
    [[8,0,-7,0,-27,0,39,0,-15,0,1],0],[[],0],
    [[17,0,-55,0,64,0,-30,0,4],0],[[],0],[[],0],
    [[],0],[[-875,0,525],0],
    [[-27,0,21,0,0,0,0,0,56,0,0,0,0,0,-15,0,0,0,189,0,
    -378,0,189,0,0,0,315],28],
    [[-330,0,630,0,-375,0,65],0],
    [[-33,0,27,0,0,0,204,0,-383,0,153,0,100,0,-44,0,-27,
    0,13],0],[[-190,0,250,0,-85,0,5],0],
    [[7,0,-6,0,1,0,-30,0,20,0,43,0,-9,0,-16,0,5,0,-30,
    0,35],10],
    [[-15,0,0,0,0,0,109,0,-136,0,3,0,65,0,-23,0,-3],0],
    [[-33,0,27,0,81,0,-103,0,37,0,-3],0],
    [[-3,0,1,0,0,0,3,0,4,0,-6,0,-6,0,1],16],
    [[1,0,0,0,6,0,-14,0,3,0,9,0,-5],6],
    [[-65,0,186,0,-189,0,79,0,-11],0],
    [[-265,0,450,0,-220,0,30],0],
    [[1,0,1,0,0,0,-10,0,-1,0,15,0,19,0,-10,0,-15,0,1,
    0,4],10],
    [[-1,0,1,0,0,0,0,0,6,0,-6,0,-10,0,8,0,-12,0,44,0,
    -42,0,12,0,10],0],
    [[3,0,2,0,3,0,-9,0,-9],10],
    [[-95,0,297,0,-349,0,183,0,-39,0,2],0],
    [[-33,0,78,0,-58,0,14],0],
    [[-74,0,220,0,-240,0,110,0,-19,0,1],0],
    [[2,0,-1,0,1,0,-7,0,5,0,5,0,-3],10],
    [[1,0,-2,0,0,0,-5,0,9,0,-2,0,-1,0,2],10],
    [[-1,0,1,0,-2,0,12,0,-8,0,-6,0,2],0],
    [[-21,0,49,0,-30,0,4],0],
    [[-1,0,1,0,0,0,9,0,-20,0,8,0,8,0,-7],0],
    [[-15,0,27,0,-15,0,1],0],
    [[5,0,-10,0,0,0,13,0,-5,0,-1],6],
    [[1,0,-1,0,-1,0,2,0,-1],8],
    [[-1,0,4,0,-5,0,2],0],
    [[-40,0,101,0,-84,0,24,0,-1],0],
    [[1,0,-2,0,-1,0,3,0,-1],6],
    [[-3,0,5,0,-2,0,26,0,-73,0,56,0,13,0,-32,0,6,0,1],
    0],[[-15,0,0,0,46,0,-32,0,4],0],
    [[-49,0,137,0,-127,0,45,0,-5],0],
    [[2,0,1,0,-8,0,3,0,6,0,-5],6],
    [[-3,0,5,0,10,0,-25,0,16,0,-3],0],
    [[1,0,-2,0,1],2],[[-1,0,3,0,-4,0,2],0],
    [[1,0,-2,0,1],6],[[-3,0,11,0,-15,0,8,0,-1],0],
    [[1,0,-1],4],[[-1,0,1,0,5,0,-8,0,4],0],
    [[-1],4],[[-6,0,23,0,-34,0,22,0,-5],0],
    [[3,0,-4,0,1],4],[[-3,0,11,0,-15,0,9,0,-1],0],
    [[1,0,2,0,-5,0,1],4],
    [[-10,0,39,0,-61,0,45,0,-14,0,1],0],
    [[2,0,1,0,-3],6]],
    [[[2400],0],[[-2400],126],[[8,0,0,0,0,0,-176,0,252,
    0,0,0,-144,0,0,0,360,0,-320,0,0,0,0,0,20],0],
    [[520,0,-1240,0,640],0],
    [[-18,0,0,0,-50,0,0,0,330,0,-560,0,360,0,-30,0,50,0,
    0,0,-6,0,-20,0,30,0,0,0,0,0,-6],20],
    [[],0],[[96,0,-528,0,960,0,-672,0,144],0],
    [[360,0,-780,0,480],0],
    [[-15,0,0,0,-24,0,0,0,10,0,0,0,-60,0,64,0,-15,0,0,
    0,-20],58],[[60],84],[[-60],42],
    [[6,0,-24,0,6,0,0,0,8,0,0,0,6,0,-40,0,33,0,0,0,2]
    ,16],[[-18,0,42,0,-21],42],
    [[34,0,-232,0,442,0,-312,0,74],0],
    [[-4,0,28,0,-46,0,24,0,-8],42],
    [[8,0,0,0,-84,0,192,0,-120,0,0,0,20],0],
    [[-16],72],
    [[4,0,-4,0,-4,0,10,0,-14,0,-4,0,16,0,-2,0,-2],10],
    [[29,0,-172,0,330,0,-248,0,61],0],
    [[-5,0,28,0,-34,0,-16,0,50,0,-14,0,-57,0,70,0,-21,0,
    0,0,-1],6],[[],0],
    [[-8,0,56,0,-112,0,90,0,-28,0,2],2],
    [[10,0,-70,0,140,0,-110,0,30],0],[[],0],
    [[],0],[[],0],
    [[-2,0,4,0,-8,0,74,0,-137,0,38,0,50,0,71,0,-189,0,
    149,0,-40,0,7,0,-6,0,1],2],
    [[8,0,-44,0,84,0,-80,0,20],0],
    [[-2,0,8,0,-18,0,14,0,-2],42],
    [[60,0,-348,0,648,0,-460,0,104],0],
    [[4,0,-7,0,-12,0,15,0,-4,0,-7,0,12,0,-5],8],
    [[],0],[[2,0,2,0,-12,0,2,0,5,0,-2],8],
    [[4,0,-14,0,24,0,-14,0,4,0,-1],44],
    [[1,0,1,0,-6,0,5,0,-6,0,0,0,6,0,-1],8],
    [[-4,0,29,0,-60,0,50,0,-16,0,1],2],
    [[4,0,-54,0,220,0,-388,0,312,0,-106,0,10],0],
    [[10,0,-20,0,14,0,-2],8],[[],0],
    [[-3,0,23,0,-51,0,43,0,-13,0,1],2],
    [[7,0,-19,0,15,0,-4],4],[[1],18],
    [[-1,0,9,0,-21,0,19,0,-6],2],
    [[4,0,-14,0,12,0,-2],6],[[],0],
    [[3,0,-7,0,5,0,-1],6],[[],0],[[],0],
    [[],0],[[1,0,-13,0,67,0,-130,0,109,0,-37,0,3],0],
    [[2,0,-5,0,4,0,-1],4],[[],0],
    [[-2,0,-2,0,53,0,-113,0,81,0,-8,0,-6,0,1],2],
    [[-3,0,2,0,-3],46],[[-2],30],[[2],24],
    [[-2,0,3],6],[[-2,0,1],26],
    [[1,0,-23,0,110,0,-206,0,168,0,-55,0,5],0],
    [[-3,0,23,0,-51,0,40,0,-8,0,-1],4],[[],0],
    [[-7,0,44,0,-92,0,76,0,-23,0,2],2],[[],0],
    [[],0],[[],0],[[-1140,0,1260],0],
    [[-189,0,0,0,-84,0,0,0,0,0,-336,0,0,0,594,0,-315,0,
    0,0,0,0,210],56],
    [[-228,0,876,0,-984,0,312],0],
    [[-2,0,6,0,0,0,64,0,-211,0,153,0,84,0,-60,0,-198,0,
    338,0,-144,0,0,0,-13,0,7],0],
    [[-80,0,280,0,-340,0,140],0],
    [[-4,0,10,0,-16,0,-30,0,101,0,-127,0,55,0,-4,0,5,0,
    3,0,6,0,0,0,0,0,0,0,1],22],
    [[18,0,-45,0,9,0,41,0,-48,0,-9,0,88,0,-55,0,0,0,0,
    0,1],6],
    [[-2,0,6,0,33,0,-139,0,170,0,-54,0,-13,0,7],0],
    [[-3,0,-2,0,0,0,0,0,-1,0,0,0,0,0,-2],28],
    [[-5,0,0,0,9,0,-4,0,-3,0,0,0,3],18],
    [[-10,0,88,0,-256,0,308,0,-154,0,24],0],
    [[-150,0,580,0,-660,0,230],0],
    [[-5,0,0,0,35,0,-60,0,31,0,-5,0,5,0,0,0,0,0,-1],
    26],
    [[14,0,-16,0,6,0,-3,0,5,0,-6,0,24,0,-34,0,15,0,-2],
    18],[[-3,0,6,0,-9,0,3],20],
    [[-23,0,184,0,-503,0,583,0,-284,0,43],0],
    [[-2,0,22,0,-67,0,89,0,-49,0,7],0],
    [[-12,0,118,0,-340,0,402,0,-192,0,30],0],
    [[-2,0,1,0,-7,0,7,0,-7,0,2],20],
    [[-1,0,0,0,-2,0,3,0,-3,0,3,0,-4,0,1],20],
    [[2,0,7,0,-9,0,-2,0,5],10],
    [[10,0,-41,0,53,0,-26,0,4],2],
    [[1,0,3,0,-7,0,6,0,-2,0,-4,0,3],10],
    [[4,0,-15,0,23,0,-13,0,1],2],
    [[2,0,-2,0,-5,0,4,0,2,0,-2,0,1],10],
    [[1,0,0,0,-1],14],[[4,0,-7,0,3],6],
    [[-3,0,33,0,-108,0,136,0,-69,0,11],0],
    [[1,0,-1,0,1,0,-1],12],
    [[-6,0,23,0,-12,0,-26,0,21,0,25,0,-47,0,25,0,-4,0,1
    ],8],[[10,0,-41,0,52,0,-22,0,0,0,1],4],
    [[-4,0,55,0,-177,0,213,0,-103,0,16],0],
    [[1,0,2,0,-4,0,2,0,-1,0,-2,0,2],12],
    [[-6,0,26,0,-36,0,16],6],[[1,0,-1],6],
    [[1,0,-3,0,1],6],[[1,0,-1,0,1],10],
    [[-2,0,13,0,-19,0,10,0,-1],4],[[-1],10],
    [[-1,0,5,0,-7,0,3],6],[[],0],
    [[-9,0,37,0,-51,0,27,0,-4],4],[[2,0,-4,0,2],8],
    [[-2,0,11,0,-16,0,8,0,-1],4],[[4,0,-6,0,2],10],
    [[2,0,-21,0,69,0,-91,0,51,0,-10],2],
    [[2,0,-2],12]],
    [[[2400],0],[[-2400],114],[[20,0,0,0,0,0,-320,0,360,
    0,0,0,-144,0,0,0,252,0,-176,0,0,0,0,0,8],0],
    [[640,0,-1240,0,520],0],
    [[-6,0,0,0,0,0,30,0,-20,0,-6,0,0,0,50,0,-30,0,360,
    0,-560,0,330,0,0,0,-50,0,0,0,-18],10],
    [[],0],[[144,0,-672,0,960,0,-528,0,96],0],
    [[480,0,-780,0,360],0],
    [[-20,0,0,0,-15,0,64,0,-60,0,0,0,10,0,0,0,-24,0,0,
    0,-15],50],[[60],76],[[-60],38],
    [[2,0,0,0,33,0,-40,0,6,0,0,0,8,0,0,0,6,0,-24,0,6]
    ,12],[[-21,0,42,0,-18],38],
    [[74,0,-312,0,442,0,-232,0,34],0],
    [[-8,0,24,0,-46,0,28,0,-4],38],
    [[20,0,0,0,-120,0,192,0,-84,0,0,0,8],0],
    [[-16],60],
    [[-2,0,-2,0,16,0,-4,0,-14,0,10,0,-4,0,-4,0,4],6],
    [[61,0,-248,0,330,0,-172,0,29],0],
    [[-1,0,0,0,-21,0,70,0,-57,0,-14,0,50,0,-16,0,-34,0,
    28,0,-5],2],[[],0],
    [[2,0,-28,0,90,0,-112,0,56,0,-8],0],
    [[30,0,-110,0,140,0,-70,0,10],0],[[],0],
    [[],0],[[],0],
    [[1,0,-6,0,7,0,-40,0,149,0,-189,0,71,0,50,0,38,0,
    -137,0,74,0,-8,0,4,0,-2],0],
    [[20,0,-80,0,84,0,-44,0,8],0],
    [[-2,0,14,0,-18,0,8,0,-2],38],
    [[104,0,-460,0,648,0,-348,0,60],0],
    [[-5,0,12,0,-7,0,-4,0,15,0,-12,0,-7,0,4],6],
    [[],0],[[-2,0,5,0,2,0,-12,0,2,0,2],6],
    [[-1,0,4,0,-14,0,24,0,-14,0,4],38],
    [[-1,0,6,0,0,0,-6,0,5,0,-6,0,1,0,1],6],
    [[1,0,-16,0,50,0,-60,0,29,0,-4],0],
    [[10,0,-106,0,312,0,-388,0,220,0,-54,0,4],0],
    [[-2,0,14,0,-20,0,10],6],[[],0],
    [[1,0,-13,0,43,0,-51,0,23,0,-3],0],
    [[-4,0,15,0,-19,0,7],2],[[1],18],
    [[-6,0,19,0,-21,0,9,0,-1],2],
    [[-2,0,12,0,-14,0,4],4],[[],0],
    [[-1,0,5,0,-7,0,3],4],[[],0],[[],0],
    [[],0],[[3,0,-37,0,109,0,-130,0,67,0,-13,0,1],0],
    [[-1,0,4,0,-5,0,2],2],[[],0],
    [[1,0,-6,0,-8,0,81,0,-113,0,53,0,-2,0,-2],0],
    [[-3,0,2,0,-3],42],[[-2],22],[[2],20],
    [[3,0,-2],4],[[1,0,-2],20],
    [[5,0,-55,0,168,0,-206,0,110,0,-23,0,1],0],
    [[-1,0,-8,0,40,0,-51,0,23,0,-3],2],[[],0],
    [[2,0,-23,0,76,0,-92,0,44,0,-7],0],[[],0],
    [[],0],[[],0],[[-1260,0,1140],0],
    [[-210,0,0,0,0,0,315,0,-594,0,0,0,336,0,0,0,0,0,84,
    0,0,0,189],48],[[-312,0,984,0,-876,0,228],0],
    [[-7,0,13,0,0,0,144,0,-338,0,198,0,60,0,-84,0,-153,
    0,211,0,-64,0,0,0,-6,0,2],0],
    [[-140,0,340,0,-280,0,80],0],
    [[-1,0,0,0,0,0,0,0,-6,0,-3,0,-5,0,4,0,-55,0,127,0,
    -101,0,30,0,16,0,-10,0,4],12],
    [[-1,0,0,0,0,0,55,0,-88,0,9,0,48,0,-41,0,-9,0,45,
    0,-18],0],
    [[-7,0,13,0,54,0,-170,0,139,0,-33,0,-6,0,2],0],
    [[2,0,0,0,0,0,1,0,0,0,0,0,2,0,3],24],
    [[-3,0,0,0,3,0,4,0,-9,0,0,0,5],12],
    [[-24,0,154,0,-308,0,256,0,-88,0,10],0],
    [[-230,0,660,0,-580,0,150],0],
    [[1,0,0,0,0,0,-5,0,5,0,-31,0,60,0,-35,0,0,0,5],18
    ],
    [[2,0,-15,0,34,0,-24,0,6,0,-5,0,3,0,-6,0,16,0,-14],
    14],[[-3,0,9,0,-6,0,3],16],
    [[-43,0,284,0,-583,0,503,0,-184,0,23],0],
    [[-7,0,49,0,-89,0,67,0,-22,0,2],0],
    [[-30,0,192,0,-402,0,340,0,-118,0,12],0],
    [[-2,0,7,0,-7,0,7,0,-1,0,2],16],
    [[-1,0,4,0,-3,0,3,0,-3,0,2,0,0,0,1],16],
    [[-5,0,2,0,9,0,-7,0,-2],8],
    [[-4,0,26,0,-53,0,41,0,-10],0],
    [[-3,0,4,0,2,0,-6,0,7,0,-3,0,-1],8],
    [[-1,0,13,0,-23,0,15,0,-4],0],
    [[-1,0,2,0,-2,0,-4,0,5,0,2,0,-2],8],
    [[1,0,0,0,-1],16],[[-3,0,7,0,-4],4],
    [[-11,0,69,0,-136,0,108,0,-33,0,3],0],
    [[1,0,-1,0,1,0,-1],12],
    [[-1,0,4,0,-25,0,47,0,-25,0,-21,0,26,0,12,0,-23,0,6
    ],4],[[-1,0,0,0,22,0,-52,0,41,0,-10],0],
    [[-16,0,103,0,-213,0,177,0,-55,0,4],0],
    [[-2,0,2,0,1,0,-2,0,4,0,-2,0,-1],10],
    [[-16,0,36,0,-26,0,6],6],[[1,0,-1],6],
    [[-1,0,3,0,-1],4],[[-1,0,1,0,-1],8],
    [[1,0,-10,0,19,0,-13,0,2],2],[[1],8],
    [[-3,0,7,0,-5,0,1],6],[[],0],
    [[4,0,-27,0,51,0,-37,0,9],2],[[-2,0,4,0,-2],6],
    [[1,0,-8,0,16,0,-11,0,2],2],[[-2,0,6,0,-4],8],
    [[10,0,-51,0,91,0,-69,0,21,0,-2],2],
    [[2,0,-2],12]],
    [[[2800],0],[[-2800],132],[[4,0,0,0,0,0,-112,0,252,
    0,0,0,-304,0,0,0,540,0,-416,0,0,0,0,0,36],0],
    [[550,0,-1420,0,830],0],
    [[-24,0,0,0,30,0,0,0,240,0,-696,0,420,0,-60,0,210,0,
    0,0,-78,0,-60,0,60,0,0,0,10,0,-12],20],
    [[],0],[[96,0,-548,0,1080,0,-852,0,224],0],
    [[345,0,-915,0,625],0],
    [[-64,0,24,0,0,0,-10,0,0,0,84,0,-128,0,45,0,0,0,0,
    0,0,0,-6],62],[[-80],88],[[80],44],
    [[-8,0,12,0,0,0,-2,0,0,0,24,0,-64,0,27,0,0,0,6,0,
    0,0,-3],18],[[24,0,-48,0,32],44],
    [[30,0,-220,0,490,0,-410,0,120],0],
    [[6,0,-32,0,44,0,-40,0,12],44],
    [[4,0,0,0,-84,0,200,0,-180,0,0,0,36],0],
    [[24],72],
    [[-6,0,-4,0,28,0,-24,0,-12,0,24,0,-2,0,-4],12],
    [[21,0,-158,0,364,0,-329,0,98],0],
    [[-1,0,14,0,-25,0,-28,0,94,0,-49,0,-75,0,113,0,-37,
    0,0,0,-3,0,1],6],[[],0],
    [[-6,0,46,0,-114,0,116,0,-50,0,8],2],
    [[5,0,-55,0,150,0,-150,0,50],0],[[],0],[[],0],
    [[],0],
    [[-1,0,2,0,-4,0,50,0,-125,0,24,0,102,0,29,0,-252,0,
    235,0,-72,0,10,0,-11,0,4],2],
    [[4,0,-28,0,101,0,-104,0,36],0],
    [[2,0,-8,0,16,0,-16,0,6],44],
    [[55,0,-348,0,723,0,-595,0,164],0],
    [[2,0,-4,0,-9,0,26,0,-21,0,-4,0,23,0,-12],8],
    [[],0],[[4,0,-6,0,8,0,-1,0,-6,0,1],10],
    [[-4,0,11,0,-16,0,17,0,-10,0,2],46],
    [[2,0,-5,0,10,0,-12,0,2,0,8,0,-5],10],
    [[-2,0,22,0,-62,0,67,0,-29,0,4],2],
    [[4,0,-48,0,212,0,-416,0,394,0,-170,0,26],0],
    [[6,0,-18,0,18,0,-6,0,-2],8],[[],0],
    [[-1,0,17,0,-49,0,55,0,-25,0,3],2],
    [[4,0,-17,0,20,0,-8,0,1],4],[[],0],
    [[6,0,-23,0,27,0,-11,0,1],4],
    [[2,0,-12,0,16,0,-6],6],[[],0],
    [[1,0,-5,0,8,0,-3],6],[[-1],20],[[1],32],
    [[-1],16],[[-9,0,56,0,-133,0,140,0,-63,0,9],2],
    [[1,0,-6,0,7,0,-2],4],[[],0],
    [[-1,0,-4,0,47,0,-117,0,108,0,-23,0,-11,0,4],2],
    [[-2,0,1,0,-2],50],[[],0],[[],0],
    [[-4,0,5,0,-1],6],[[],0],
    [[1,0,-18,0,99,0,-216,0,213,0,-94,0,14],0],
    [[-2,0,18,0,-48,0,54,0,-19,0,-3,0,1],4],[[],0],
    [[-4,0,36,0,-92,0,97,0,-43,0,6],2],[[],0],
    [[],0],[[],0],[[-1260,0,1540],0],
    [[-420,0,0,0,0,0,189,0,0,0,405,0,-595,0,0,0,-189,0,
    210,0,0,0,0,0,120],60],
    [[-233,0,951,0,-1179,0,437],0],
    [[-1,0,3,0,0,0,36,0,-175,0,153,0,150,0,-154,0,-261,
    0,487,0,-208,0,0,0,-21,0,15],0],
    [[-60,0,285,0,-425,0,200],0],
    [[-5,0,0,0,4,0,0,0,96,0,-167,0,55,0,-19,0,46,0,8,
    0,-13,0,-10,0,5,0,-1,0,1],22],
    [[7,0,-28,0,12,0,75,0,-108,0,-12,0,134,0,-84,0,0,0,
    0,0,4],6],
    [[-1,0,3,0,33,0,-137,0,201,0,-93,0,-21,0,15],0],
    [[4,0,0,0,-3,0,-11,0,9,0,3,0,-2],30],
    [[-2,0,-3,0,12,0,-5,0,-6,0,-3,0,7],18],
    [[-7,0,76,0,-256,0,363,0,-222,0,46],0],
    [[-140,0,615,0,-805,0,325],0],
    [[5,0,15,0,-51,0,20,0,-5,0,21,0,-5,0,1,0,5,0,0,0,
    -1],28],
    [[-14,0,6,0,2,0,0,0,-12,0,44,0,-47,0,12,0,-4,0,2,
    0,3],20],[[3,0,9,0,-1,0,3,0,-6],20],
    [[-21,0,177,0,-524,0,687,0,-396,0,80],0],
    [[-1,0,12,0,-64,0,108,0,-73,0,15],0],
    [[-11,0,107,0,-348,0,470,0,-277,0,57],0],
    [[1,0,0,0,-2,0,4,0,-4,0,6,0,-3],20],
    [[-1,0,1,0,3,0,0,0,1,0,-6,0,3,0,-1],22],
    [[-2,0,4,0,-8,0,5,0,4,0,-3],10],
    [[5,0,-34,0,61,0,-41,0,9],2],
    [[-1,0,3,0,-8,0,11,0,-7,0,-4,0,7,0,-1],10],
    [[1,0,-13,0,31,0,-19,0,4],2],
    [[1,0,-2,0,-4,0,6,0,-5,0,-1,0,2,0,-1],10],
    [[],0],[[3,0,-7,0,5,0,-1],6],
    [[-1,0,24,0,-100,0,159,0,-104,0,22],0],
    [[-1,0,1],18],
    [[-1,0,14,0,-6,0,-39,0,51,0,11,0,-67,0,49,0,-10,0,
    2,0,-1],8],[[7,0,-34,0,60,0,-40,0,0,0,4],4]
    ,[[-3,0,45,0,-171,0,251,0,-152,0,33],0],
    [[-1,0,-5,0,6,0,-2,0,-4,0,4,0,-1],14],
    [[-4,0,21,0,-38,0,26,0,-4,0,-1],6],
    [[1,0,-2,0,1],6],[[2,0,-5,0,3],6],
    [[1,0,-2,0,1],10],[[-1,0,10,0,-20,0,15,0,-4],4],
    [[-1,0,1],10],[[3,0,-7,0,6,0,-1],8],[[-1],8],
    [[-6,0,32,0,-55,0,40,0,-12,0,1],4],
    [[1,0,-4,0,3],8],[[-1,0,10,0,-19,0,14,0,-3],4],
    [[2,0,-6,0,4,0,-1],10],
    [[1,0,-16,0,62,0,-100,0,74,0,-23,0,2],2],
    [[-1,0,1],14]],
    [[[2800],0],[[-2800],108],[[36,0,0,0,0,0,-416,0,540,
    0,0,0,-304,0,0,0,252,0,-112,0,0,0,0,0,4],0],
    [[830,0,-1420,0,550],0],
    [[-12,0,10,0,0,0,60,0,-60,0,-78,0,0,0,210,0,-60,0,
    420,0,-696,0,240,0,0,0,30,0,0,0,-24],10],
    [[],0],[[224,0,-852,0,1080,0,-548,0,96],0],
    [[625,0,-915,0,345],0],
    [[-6,0,0,0,0,0,0,0,45,0,-128,0,84,0,0,0,-10,0,0,0,
    24,0,-64],44],[[-80],72],[[80],36],
    [[-3,0,0,0,6,0,0,0,27,0,-64,0,24,0,0,0,-2,0,0,0,
    12,0,-8],8],[[32,0,-48,0,24],36],
    [[120,0,-410,0,490,0,-220,0,30],0],
    [[12,0,-40,0,44,0,-32,0,6],36],
    [[36,0,0,0,-180,0,200,0,-84,0,0,0,4],0],
    [[24],60],
    [[-4,0,-2,0,24,0,-12,0,-24,0,28,0,-4,0,-6],6],
    [[98,0,-329,0,364,0,-158,0,21],0],
    [[1,0,-3,0,0,0,-37,0,113,0,-75,0,-49,0,94,0,-28,0,
    -25,0,14,0,-1],0],[[],0],
    [[8,0,-50,0,116,0,-114,0,46,0,-6],0],
    [[50,0,-150,0,150,0,-55,0,5],0],[[],0],[[],0],
    [[],0],
    [[4,0,-11,0,10,0,-72,0,235,0,-252,0,29,0,102,0,24,0,
    -125,0,50,0,-4,0,2,0,-1],0],
    [[36,0,-104,0,101,0,-28,0,4],0],
    [[6,0,-16,0,16,0,-8,0,2],36],
    [[164,0,-595,0,723,0,-348,0,55],0],
    [[-12,0,23,0,-4,0,-21,0,26,0,-9,0,-4,0,2],6],
    [[],0],[[1,0,-6,0,-1,0,8,0,-6,0,4],4],
    [[2,0,-10,0,17,0,-16,0,11,0,-4],36],
    [[-5,0,8,0,2,0,-12,0,10,0,-5,0,2],6],
    [[4,0,-29,0,67,0,-62,0,22,0,-2],0],
    [[26,0,-170,0,394,0,-416,0,212,0,-48,0,4],0],
    [[-2,0,-6,0,18,0,-18,0,6],4],[[],0],
    [[3,0,-25,0,55,0,-49,0,17,0,-1],0],
    [[1,0,-8,0,20,0,-17,0,4],0],[[],0],
    [[1,0,-11,0,27,0,-23,0,6],0],
    [[-6,0,16,0,-12,0,2],4],[[],0],
    [[-3,0,8,0,-5,0,1],4],[[-1],12],[[1],24],
    [[-1],12],[[9,0,-63,0,140,0,-133,0,56,0,-9],0],
    [[-2,0,7,0,-6,0,1],2],[[],0],
    [[4,0,-11,0,-23,0,108,0,-117,0,47,0,-4,0,-1],0],
    [[-2,0,1,0,-2],38],[[],0],[[],0],
    [[-1,0,5,0,-4],2],[[],0],
    [[14,0,-94,0,213,0,-216,0,99,0,-18,0,1],0],
    [[1,0,-3,0,-19,0,54,0,-48,0,18,0,-2],0],[[],0],
    [[6,0,-43,0,97,0,-92,0,36,0,-4],0],[[],0],
    [[],0],[[],0],[[-1540,0,1260],0],
    [[-120,0,0,0,0,0,-210,0,189,0,0,0,595,0,-405,0,0,0,
    -189,0,0,0,0,0,420],42],
    [[-437,0,1179,0,-951,0,233],0],
    [[-15,0,21,0,0,0,208,0,-487,0,261,0,154,0,-150,0,
    -153,0,175,0,-36,0,0,0,-3,0,1],0],
    [[-200,0,425,0,-285,0,60],0],
    [[-1,0,1,0,-5,0,10,0,13,0,-8,0,-46,0,19,0,-55,0,
    167,0,-96,0,0,0,-4,0,0,0,5],12],
    [[-4,0,0,0,0,0,84,0,-134,0,12,0,108,0,-75,0,-12,0,
    28,0,-7],0],
    [[-15,0,21,0,93,0,-201,0,137,0,-33,0,-3,0,1],0],
    [[2,0,-3,0,-9,0,11,0,3,0,0,0,-4],24],
    [[-7,0,3,0,6,0,5,0,-12,0,3,0,2],12],
    [[-46,0,222,0,-363,0,256,0,-76,0,7],0],
    [[-325,0,805,0,-615,0,140],0],
    [[1,0,0,0,-5,0,-1,0,5,0,-21,0,5,0,-20,0,51,0,-15,
    0,-5],14],
    [[-3,0,-2,0,4,0,-12,0,47,0,-44,0,12,0,0,0,-2,0,-6,
    0,14],10],[[6,0,-3,0,1,0,-9,0,-3],14],
    [[-80,0,396,0,-687,0,524,0,-177,0,21],0],
    [[-15,0,73,0,-108,0,64,0,-12,0,1],0],
    [[-57,0,277,0,-470,0,348,0,-107,0,11],0],
    [[3,0,-6,0,4,0,-4,0,2,0,0,0,-1],14],
    [[1,0,-3,0,6,0,-1,0,0,0,-3,0,-1,0,1],14],
    [[3,0,-4,0,-5,0,8,0,-4,0,2],6],
    [[-9,0,41,0,-61,0,34,0,-5],0],
    [[1,0,-7,0,4,0,7,0,-11,0,8,0,-3,0,1],6],
    [[-4,0,19,0,-31,0,13,0,-1],0],
    [[1,0,-2,0,1,0,5,0,-6,0,4,0,2,0,-1],6],[[],0],
    [[1,0,-5,0,7,0,-3],2],
    [[-22,0,104,0,-159,0,100,0,-24,0,1],0],
    [[-1,0,1],10],
    [[1,0,-2,0,10,0,-49,0,67,0,-11,0,-51,0,39,0,6,0,
    -14,0,1],2],
    [[-4,0,0,0,40,0,-60,0,34,0,-7],0],
    [[-33,0,152,0,-251,0,171,0,-45,0,3],0],
    [[1,0,-4,0,4,0,2,0,-6,0,5,0,1],8],
    [[1,0,4,0,-26,0,38,0,-21,0,4],2],
    [[-1,0,2,0,-1],4],[[-3,0,5,0,-2],4],
    [[-1,0,2,0,-1],8],[[4,0,-15,0,20,0,-10,0,1],2],
    [[-1,0,1],6],[[1,0,-6,0,7,0,-3],4],[[1],6],
    [[-1,0,12,0,-40,0,55,0,-32,0,6],0],
    [[-3,0,4,0,-1],6],[[3,0,-14,0,19,0,-10,0,1],2],
    [[1,0,-4,0,6,0,-2],6],
    [[-2,0,23,0,-74,0,100,0,-62,0,16,0,-1],0],
    [[-1,0,1],10]],
    [[[5600],0],[[-5600],120],[[20,0,0,0,0,0,-464,0,756,
    0,0,0,-624,0,0,0,756,0,-464,0,0,0,0,0,20],0],
    [[1380,0,-2840,0,1380],0],
    [[30,0,-20,0,-42,0,0,0,70,0,-180,0,810,0,-1256,0,810,
    0,-180,0,70,0,0,0,-42,0,-20,0,30],16],
    [[],0],[[320,0,-1400,0,2160,0,-1400,0,320],0],
    [[930,0,-1870,0,930],0],
    [[30,0,-64,0,84,0,0,0,-90,0,0,0,84,0,-64,0,30],56],
    [[-100],80],[[100],40],
    [[15,0,-56,0,42,0,0,0,0,0,0,0,42,0,-56,0,15],16],
    [[33,0,-68,0,33],40],
    [[134,0,-622,0,972,0,-622,0,134],0],
    [[10,0,-44,0,72,0,-44,0,10],40],
    [[20,0,0,0,-252,0,480,0,-252,0,0,0,20],0],
    [[-16],66],
    [[-2,0,16,0,-12,0,-32,0,60,0,-32,0,-12,0,16,0,-2],8
    ],[[101,0,-463,0,732,0,-463,0,101],0],
    [[-25,0,92,0,-87,0,-97,0,226,0,-97,0,-87,0,92,0,-25],
    6],[[],0],
    [[4,0,-46,0,150,0,-216,0,150,0,-46,0,4],0],
    [[35,0,-185,0,300,0,-185,0,35],0],[[],0],
    [[],0],[[],0],
    [[2,0,-7,0,4,0,-56,0,255,0,-348,0,49,0,208,0,49,0,
    -348,0,255,0,-56,0,4,0,-7,0,2],0],
    [[20,0,-116,0,186,0,-116,0,20],0],
    [[4,0,-16,0,24,0,-16,0,4],40],
    [[209,0,-933,0,1446,0,-933,0,209],0],
    [[-2,0,16,0,-12,0,-39,0,76,0,-39,0,-12,0,16,0,-2],6
    ],[[],0],[[3,0,14,0,-40,0,14,0,3],8],
    [[1,0,-6,0,22,0,-28,0,22,0,-6,0,1],40],
    [[3,0,2,0,-26,0,42,0,-26,0,2,0,3],8],
    [[2,0,-21,0,74,0,-110,0,74,0,-21,0,2],0],
    [[26,0,-208,0,596,0,-824,0,596,0,-208,0,26],0],
    [[-2,0,22,0,-44,0,22,0,-2],6],[[],0],
    [[1,0,-16,0,60,0,-90,0,60,0,-16,0,1],0],
    [[-3,0,17,0,-28,0,17,0,-3],2],[[],0],
    [[-5,0,22,0,-34,0,22,0,-5],2],
    [[-2,0,16,0,-28,0,16,0,-2],4],[[],0],
    [[7,0,-12,0,7],6],[[-2],16],[[-1],28],
    [[1],14],
    [[6,0,-57,0,179,0,-256,0,179,0,-57,0,6],0],
    [[3,0,-6,0,3],4],[[],0],
    [[2,0,-7,0,-29,0,164,0,-262,0,164,0,-29,0,-7,0,2],0
    ],[[2,0,-2,0,2],44],[[-2],26],[[2],22],
    [[1,0,-4,0,1],4],[[1,0,0,0,1],22],
    [[11,0,-99,0,299,0,-420,0,299,0,-99,0,11],0],
    [[-14,0,70,0,-114,0,70,0,-14],4],[[],0],
    [[3,0,-36,0,120,0,-174,0,120,0,-36,0,3],0],
    [[],0],[[],0],[[],0],[[-2800,0,2800],0],
    [[-594,0,378,0,-84,0,0,0,0,0,84,0,-378,0,594],56],
    [[-670,0,2130,0,-2130,0,670],0],
    [[-9,0,11,0,0,0,212,0,-603,0,405,0,312,0,-312,0,-405,
    0,603,0,-212,0,0,0,-11,0,9],0],
    [[-220,0,710,0,-710,0,220],0],
    [[9,0,-8,0,-5,0,5,0,-80,0,233,0,-233,0,80,0,-5,0,5,
    0,8,0,-9],20],
    [[57,0,-138,0,18,0,219,0,-219,0,-18,0,138,0,-57],6],
    [[-9,0,11,0,117,0,-375,0,375,0,-117,0,-11,0,9],0],
    [[-6,0,10,0,0,0,0,0,-10,0,6],28],
    [[6,0,-3,0,-15,0,15,0,3,0,-6],16],
    [[-45,0,276,0,-609,0,609,0,-276,0,45],0],
    [[-445,0,1420,0,-1420,0,445],0],
    [[2,0,0,0,-5,0,0,0,11,0,-32,0,65,0,-65,0,32,0,-11,
    0,0,0,5,0,0,0,-2],18],
    [[-9,0,30,0,-50,0,24,0,0,0,0,0,-24,0,50,0,-30,0,9],
    16],[[18,0,-3,0,3,0,-18],18],
    [[-96,0,563,0,-1206,0,1206,0,-563,0,96],0],
    [[-9,0,64,0,-156,0,156,0,-64,0,9],0],
    [[-60,0,372,0,-810,0,810,0,-372,0,60],0],
    [[8,0,-12,0,6,0,-6,0,12,0,-8],18],
    [[2,0,-5,0,2,0,-4,0,4,0,-2,0,5,0,-2],18],
    [[-1,0,-4,0,28,0,-28,0,4,0,1],8],
    [[-3,0,32,0,-87,0,87,0,-32,0,3],0],
    [[-1,0,1,0,13,0,-35,0,35,0,-13,0,-1,0,1],8],
    [[11,0,-33,0,33,0,-11],2],
    [[-1,0,3,0,3,0,-17,0,17,0,-3,0,-3,0,1],8],
    [[],0],[[-2,0,6,0,-6,0,2],4],
    [[-15,0,106,0,-249,0,249,0,-106,0,15],0],
    [[1,0,-3,0,3,0,-1],12],
    [[5,0,-34,0,61,0,-5,0,-110,0,110,0,5,0,-61,0,34,0,
    -5],6],[[33,0,-108,0,108,0,-33],4],
    [[-27,0,181,0,-411,0,411,0,-181,0,27],0],
    [[-1,0,3,0,4,0,-15,0,15,0,-4,0,-3,0,1],10],
    [[3,0,-26,0,65,0,-65,0,26,0,-3],4],[[],0],
    [[-1,0,2,0,-2,0,1],4],[[1,0,-1],10],
    [[1,0,-10,0,23,0,-23,0,10,0,-1],2],[[1,0,-1],8],
    [[-3,0,10,0,-10,0,3],6],[[],0],
    [[7,0,-38,0,77,0,-77,0,38,0,-7],2],
    [[-1,0,5,0,-5,0,1],6],
    [[1,0,-9,0,19,0,-19,0,9,0,-1],2],
    [[-2,0,9,0,-9,0,2],8],
    [[-1,0,17,0,-78,0,150,0,-150,0,78,0,-17,0,1],0],
    [[3,0,-3],12]],
    [[[3240],0],[[-3240],142],[[-36,0,144,0,0,0,-384,0,
    0,0,828,0,-624,0,0,0,0,0,72],6],
    [[534,0,-1578,0,1128],0],
    [[-30,0,150,0,-416,0,390,0,-240,0,180,0,0,0,-144,0,
    -140,0,180,0,0,0,20,0,-36,0,0,0,0,0,0,0,0,0,2
    ],26],[[],0],
    [[84,0,-516,0,1152,0,-1104,0,384],0],
    [[270,0,-1053,0,864],0],[[-81],74],[[],0],
    [[],0],
    [[-12,0,0,0,72,0,-96,0,27,0,0,0,18,0,0,0,-9],24],
    [[],0],[[18,0,-174,0,498,0,-564,0,222],0],
    [[],0],[[-48,0,240,0,-276,0,0,0,72],4],
    [[12],74],
    [[-2,0,28,0,-40,0,-20,0,52,0,-8,0,-12,0,0,0,0,0,2],
    14],[[9,0,-112,0,374,0,-454,0,185],0],
    [[2,0,-7,0,-29,0,127,0,-102,0,-111,0,208,0,-92,0,0,
    0,-5,0,7],8],[[],0],
    [[-2,0,26,0,-92,0,144,0,-104,0,28],2],
    [[-25,0,140,0,-220,0,100],2],[[5],38],[[],0],
    [[],0],
    [[21,0,-57,0,15,0,126,0,-21,0,-330,0,411,0,-156,0,6,
    0,-24,0,18],8],[[-9,0,84,0,-156,0,72],2],
    [[],0],[[40,0,-303,0,760,0,-792,0,292],0],
    [[-3,0,-4,0,43,0,-58,0,-3,0,58,0,-32,0,0,0,0,0,2],
    10],[[],0],[[-12,0,24,0,3,0,-18,0,3],12],
    [[],0],[[-3,0,21,0,-33,0,3,0,27,0,-15],12],
    [[9,0,-45,0,81,0,-63,0,18],4],
    [[2,0,-34,0,172,0,-402,0,492,0,-302,0,72],0],
    [[-14,0,30,0,-14,0,-4,0,0,0,2],10],[[],0],
    [[6,0,-35,0,68,0,-54,0,15],4],
    [[-8,0,22,0,-21,0,6],6],[[1],22],
    [[1,0,-12,0,30,0,-26,0,7],4],
    [[-8,0,24,0,-16,0,0,0,2],8],[[-2],38],
    [[-3,0,12,0,-9],8],[[],0],[[],0],[[],0],
    [[-3,0,34,0,-116,0,176,0,-124,0,32],2],
    [[-1,0,6,0,-6,0,2],6],[[],0],
    [[-3,0,33,0,-120,0,156,0,-63,0,-24,0,18],4],
    [[3],54],[[],0],[[],0],[[3,0,-3],8],
    [[],0],[[-10,0,69,0,-195,0,268,0,-178,0,45],2],
    [[8,0,-48,0,82,0,-43,0,-5,0,7],6],[[],0],
    [[-1,0,19,0,-73,0,121,0,-89,0,24],2],[[-1],30],
    [[],0],[[],0],[[-1323,0,1917],0],
    [[-378,0,189,0,-315,0,0,0,-189,0,483,0,-378,0,0,0,15,
    0,0,0,0,0,-21],68],
    [[-213,0,963,0,-1404,0,660],0],
    [[12,0,-78,0,90,0,156,0,-228,0,-351,0,741,0,-360,0,0,
    0,-30,0,42],6],[[-25,0,245,0,-544,0,320],0],
    [[45,0,-96,0,75,0,-45,0,50,0,13,0,-42,0,-30,0,35,0,
    0,0,6,0,-7],30],
    [[-6,0,7,0,86,0,-179,0,-7,0,247,0,-160,0,0,0,0,0,12
    ],8],[[18,0,-126,0,261,0,-159,0,-30,0,42],4],
    [[-13,0,9,0,9,0,-7,0,-3,0,-3,0,2],36],
    [[6,0,6,0,-21,0,0,0,16,0,-6,0,0,0,-1],22],
    [[-3,0,49,0,-220,0,412,0,-344,0,106],0],
    [[-105,0,594,0,-984,0,504],0],
    [[9,0,-34,0,31,0,-12,0,25,0,-23,0,-15,0,4,0,7,0,0,
    0,-1],30],
    [[4,0,-8,0,-30,0,82,0,-65,0,18,0,-8,0,10,0,3,0,-6],
    24],[[-9,0,15,0,-3,0,-3],24],
    [[-15,0,144,0,-492,0,780,0,-588,0,168],0],
    [[3,0,-39,0,117,0,-120,0,42],2],
    [[-6,0,80,0,-307,0,531,0,-425,0,127],0],
    [[-2,0,7,0,-15,0,10,0,1,0,-1],24],
    [[-1,0,7,0,-11,0,5],28],
    [[4,0,-18,0,13,0,10,0,-11,0,2],12],
    [[-16,0,62,0,-73,0,27],4],
    [[1,0,-10,0,27,0,-20,0,-10,0,21,0,-9],12],
    [[-3,0,25,0,-36,0,12],4],
    [[-1,0,-3,0,15,0,-14,0,-1,0,12,0,-6],12],
    [[1,0,-2,0,0,0,1],18],[[-3,0,7,0,-5,0,1],8],
    [[9,0,-72,0,176,0,-171,0,57],2],
    [[-1,0,4,0,-3,0,1],14],
    [[3,0,1,0,-41,0,83,0,-18,0,-98,0,112,0,-39,0,1,0,
    -4,0,3],10],[[-22,0,83,0,-76,0,0,0,12],6],
    [[-1,0,25,0,-135,0,277,0,-247,0,80],0],
    [[-3,0,12,0,-10,0,-6,0,12,0,-2,0,-2],16],
    [[-1,0,14,0,-42,0,47,0,-17,0,-4,0,3],6],
    [[1,0,-1],10],[[-1,0,3,0,-2],8],
    [[-1,0,2,0,-1],12],[[3,0,-14,0,22,0,-15,0,3],6],
    [[1],12],[[1,0,-7,0,11,0,-5],8],[[],0],
    [[-2,0,17,0,-46,0,60,0,-36,0,8],4],
    [[-3,0,5,0,-3],10],[[3,0,-12,0,20,0,-13,0,3],6],
    [[-5,0,8,0,-3,0,-1],12],
    [[-8,0,41,0,-94,0,109,0,-62,0,13],4],
    [[-2,0,4,0,-1],14]],
    [[[3240],0],[[-3240],98],[[72,0,0,0,0,0,-624,0,828,
    0,0,0,-384,0,0,0,144,0,-36],0],
    [[1128,0,-1578,0,534],0],
    [[2,0,0,0,0,0,0,0,0,0,-36,0,20,0,0,0,180,0,-140,0,
    -144,0,0,0,180,0,-240,0,390,0,-416,0,150,0,-30],
    0],[[],0],[[384,0,-1104,0,1152,0,-516,0,84],0],
    [[864,0,-1053,0,270],0],[[-81],54],[[],0],
    [[],0],
    [[-9,0,0,0,18,0,0,0,27,0,-96,0,72,0,0,0,-12],8],
    [[],0],[[222,0,-564,0,498,0,-174,0,18],0],
    [[],0],[[72,0,0,0,-276,0,240,0,-48],0],
    [[12],58],
    [[2,0,0,0,0,0,-12,0,-8,0,52,0,-20,0,-40,0,28,0,-2],
    0],[[185,0,-454,0,374,0,-112,0,9],0],
    [[7,0,-5,0,0,0,-92,0,208,0,-111,0,-102,0,127,0,-29,
    0,-7,0,2],0],[[],0],
    [[28,0,-104,0,144,0,-92,0,26,0,-2],0],
    [[100,0,-220,0,140,0,-25],0],[[5],26],[[],0],
    [[],0],
    [[18,0,-24,0,6,0,-156,0,411,0,-330,0,-21,0,126,0,15,
    0,-57,0,21],0],[[72,0,-156,0,84,0,-9],0],
    [[],0],[[292,0,-792,0,760,0,-303,0,40],0],
    [[2,0,0,0,0,0,-32,0,58,0,-3,0,-58,0,43,0,-4,0,-3],
    0],[[],0],[[3,0,-18,0,3,0,24,0,-12],4],
    [[],0],[[-15,0,27,0,3,0,-33,0,21,0,-3],6],
    [[18,0,-63,0,81,0,-45,0,9],0],
    [[72,0,-302,0,492,0,-402,0,172,0,-34,0,2],0],
    [[2,0,0,0,-4,0,-14,0,30,0,-14],0],[[],0],
    [[15,0,-54,0,68,0,-35,0,6],0],
    [[6,0,-21,0,22,0,-8],0],[[1],14],
    [[7,0,-26,0,30,0,-12,0,1],0],
    [[2,0,0,0,-16,0,24,0,-8],0],[[-2],30],
    [[-9,0,12,0,-3],4],[[],0],[[],0],[[],0],
    [[32,0,-124,0,176,0,-116,0,34,0,-3],0],
    [[2,0,-6,0,6,0,-1],0],[[],0],
    [[18,0,-24,0,-63,0,156,0,-120,0,33,0,-3],0],
    [[3],38],[[],0],[[],0],[[-3,0,3],2],
    [[],0],[[45,0,-178,0,268,0,-195,0,69,0,-10],0],
    [[7,0,-5,0,-43,0,82,0,-48,0,8],0],[[],0],
    [[24,0,-89,0,121,0,-73,0,19,0,-1],0],[[-1],22],
    [[],0],[[],0],[[-1917,0,1323],0],
    [[21,0,0,0,0,0,-15,0,0,0,378,0,-483,0,189,0,0,0,
    315,0,-189,0,378],36],
    [[-660,0,1404,0,-963,0,213],0],
    [[-42,0,30,0,0,0,360,0,-741,0,351,0,228,0,-156,0,-90,
    0,78,0,-12],0],[[-320,0,544,0,-245,0,25],0],
    [[7,0,-6,0,0,0,-35,0,30,0,42,0,-13,0,-50,0,45,0,
    -75,0,96,0,-45],10],
    [[-12,0,0,0,0,0,160,0,-247,0,7,0,179,0,-86,0,-7,0,6
    ],0],[[-42,0,30,0,159,0,-261,0,126,0,-18],0],
    [[-2,0,3,0,3,0,7,0,-9,0,-9,0,13],18],
    [[1,0,0,0,6,0,-16,0,0,0,21,0,-6,0,-6],6],
    [[-106,0,344,0,-412,0,220,0,-49,0,3],0],
    [[-504,0,984,0,-594,0,105],0],
    [[1,0,0,0,-7,0,-4,0,15,0,23,0,-25,0,12,0,-31,0,34,
    0,-9],12],
    [[6,0,-3,0,-10,0,8,0,-18,0,65,0,-82,0,30,0,8,0,-4],
    8],[[3,0,3,0,-15,0,9],12],
    [[-168,0,588,0,-780,0,492,0,-144,0,15],0],
    [[-42,0,120,0,-117,0,39,0,-3],0],
    [[-127,0,425,0,-531,0,307,0,-80,0,6],0],
    [[1,0,-1,0,-10,0,15,0,-7,0,2],12],
    [[-5,0,11,0,-7,0,1],16],
    [[-2,0,11,0,-10,0,-13,0,18,0,-4],4],
    [[-27,0,73,0,-62,0,16],0],
    [[9,0,-21,0,10,0,20,0,-27,0,10,0,-1],6],
    [[-12,0,36,0,-25,0,3],0],
    [[6,0,-12,0,1,0,14,0,-15,0,3,0,1],6],
    [[-1,0,0,0,2,0,-1],10],[[-1,0,5,0,-7,0,3],0],
    [[-57,0,171,0,-176,0,72,0,-9],0],
    [[-1,0,3,0,-4,0,1],10],
    [[-3,0,4,0,-1,0,39,0,-112,0,98,0,18,0,-83,0,41,0,
    -1,0,-3],0],[[-12,0,0,0,76,0,-83,0,22],0],
    [[-80,0,247,0,-277,0,135,0,-25,0,1],0],
    [[2,0,2,0,-12,0,6,0,10,0,-12,0,3],6],
    [[-3,0,4,0,17,0,-47,0,42,0,-14,0,1],0],
    [[1,0,-1],2],[[2,0,-3,0,1],2],
    [[1,0,-2,0,1],6],[[-3,0,15,0,-22,0,14,0,-3],0],
    [[-1],6],[[5,0,-11,0,7,0,-1],4],[[],0],
    [[-8,0,36,0,-60,0,46,0,-17,0,2],0],
    [[3,0,-5,0,3],4],[[-3,0,13,0,-20,0,12,0,-3],0],
    [[1,0,3,0,-8,0,5],4],
    [[-13,0,62,0,-109,0,94,0,-41,0,8],0],
    [[1,0,-4,0,2],8]],
    [[[3360],0],[[-3360],132],[[-112,0,288,0,0,0,-424,0,
    0,0,684,0,-464,0,0,0,0,0,28],6],
    [[676,0,-1672,0,1012],0],
    [[-30,0,-60,0,300,0,-592,0,480,0,-240,0,170,0,0,0,
    -42,0,-80,0,90,0,0,0,0,0,-12],24],[[],0],
    [[136,0,-664,0,1248,0,-1016,0,296],0],
    [[390,0,-1122,0,726],0],
    [[60,0,0,0,-70,0,0,0,60,0,-64,0,0,0,0,0,20],64],
    [[-60],88],[[60],44],
    [[12,0,0,0,-14,0,0,0,48,0,-56,0,18,0,0,0,4],20],
    [[15,0,-48,0,21],44],
    [[38,0,-264,0,550,0,-484,0,154],0],
    [[4,0,-24,0,50,0,-32,0,8],44],
    [[-96,0,280,0,-228,0,0,0,28],4],[[16],72],
    [[-2,0,-8,0,44,0,-36,0,-16,0,28,0,-6,0,-4],12],
    [[25,0,-180,0,414,0,-378,0,119],0],
    [[-2,0,15,0,-23,0,-53,0,150,0,-87,0,-84,0,130,0,-46,
    0,0,0,-1,0,1],6],[[],0],
    [[-8,0,50,0,-110,0,122,0,-66,0,12],2],
    [[5,0,-55,0,165,0,-165,0,55],0],[[-5],36],
    [[],0],[[],0],
    [[-4,0,67,0,-127,0,1,0,144,0,16,0,-281,0,300,0,-96,
    0,3,0,-10,0,5],6],[[-28,0,98,0,-116,0,28],2]
    ,[[-8,0,22,0,-16,0,2],46],
    [[75,0,-417,0,830,0,-703,0,213],0],
    [[3,0,-6,0,-16,0,50,0,-39,0,-6,0,30,0,-14],8],
    [[],0],[[4,0,-18,0,16,0,2,0,-4],10],
    [[-2,0,13,0,-24,0,20,0,-8,0,1],46],
    [[-9,0,26,0,-25,0,0,0,10,0,-2],12],
    [[-1,0,20,0,-54,0,64,0,-34,0,5],2],
    [[8,0,-70,0,246,0,-456,0,448,0,-220,0,42],0],
    [[6,0,-22,0,26,0,-8],8],[[],0],
    [[-2,0,15,0,-43,0,53,0,-29,0,6],2],
    [[3,0,-11,0,16,0,-10,0,2],4],[[],0],
    [[3,0,-15,0,21,0,-10,0,1],4],
    [[2,0,-12,0,16,0,-6],6],[[],0],
    [[-5,0,7,0,-2],8],[[],0],[[],0],[[],0],
    [[1,0,-12,0,59,0,-134,0,148,0,-76,0,15],0],
    [[-2,0,3,0,-2],6],[[],0],
    [[-9,0,67,0,-143,0,137,0,-45,0,-10,0,5],4],
    [[-6,0,4],50],[[2],28],[[-2],24],[[2],8],
    [[-1,0,0,0,-1],24],
    [[2,0,-26,0,111,0,-225,0,235,0,-120,0,23],0],
    [[-2,0,21,0,-60,0,65,0,-24,0,-1,0,1],4],[[],0],
    [[-6,0,37,0,-88,0,100,0,-54,0,10],2],[[1],28],
    [[],0],[[],0],[[-1512,0,1848],0],
    [[-336,0,0,0,189,0,-315,0,0,0,0,0,315,0,-189],66],
    [[-302,0,1122,0,-1386,0,550],0],
    [[44,0,-194,0,162,0,206,0,-218,0,-315,0,581,0,-252,0,
    0,0,-13,0,15],6],[[-60,0,330,0,-506,0,220],0]
    ,
    [[10,0,-10,0,-10,0,76,0,-121,0,70,0,-35,0,25,0,9,0,
    -3,0,-10,0,15,0,0,0,1,0,-1],24],
    [[5,0,-30,0,12,0,123,0,-179,0,-12,0,166,0,-87,0,0,0,
    0,0,2],6],
    [[42,0,-180,0,259,0,-123,0,-13,0,15],4],
    [[-7,0,9,0,3,0,-5],36],
    [[-6,0,-3,0,12,0,6,0,-12,0,0,0,6,0,-3],18],
    [[-11,0,92,0,-285,0,403,0,-262,0,63],0],
    [[-170,0,726,0,-946,0,396],0],
    [[-5,0,0,0,19,0,-41,0,31,0,-21,0,20,0,-9,0,0,0,-1,
    0,1],26],
    [[-6,0,6,0,8,0,-6,0,-24,0,48,0,-41,0,9,0,-2,0,2],
    20],[[6,0,-9,0,9],22],
    [[-34,0,225,0,-601,0,782,0,-483,0,113],0],
    [[11,0,-60,0,108,0,-76,0,15],2],
    [[-17,0,137,0,-391,0,527,0,-337,0,81],0],
    [[1,0,-6,0,9,0,-9,0,5],22],
    [[3,0,-3,0,4,0,-4,0,2],26],
    [[-2,0,10,0,-18,0,7,0,3,0,-2],10],
    [[5,0,-30,0,58,0,-43,0,12],2],
    [[4,0,-18,0,25,0,-13,0,-5,0,6,0,-1],12],
    [[-8,0,23,0,-17,0,2],4],
    [[1,0,-1,0,-8,0,9,0,-4,0,-2,0,6,0,-1],10],
    [[1,0,0,0,-1],18],[[1,0,-3,0,4,0,-2],6],
    [[-2,0,26,0,-104,0,168,0,-116,0,29],0],
    [[-1,0,1,0,-1],14],
    [[-3,0,13,0,7,0,-67,0,79,0,-7,0,-69,0,64,0,-16,0,0,
    0,-1],8],[[5,0,-42,0,80,0,-45,0,0,0,2],4],
    [[-4,0,55,0,-186,0,269,0,-183,0,45],0],
    [[3,0,-8,0,15,0,-8,0,-2,0,5,0,-1],14],
    [[-6,0,25,0,-42,0,33,0,-9,0,-1],6],[[],0],
    [[-1,0,1],8],[[-1,0,1],12],
    [[-1,0,6,0,-14,0,14,0,-6,0,1],4],[[],0],
    [[2,0,-6,0,5,0,-1],8],[[],0],
    [[-7,0,27,0,-48,0,43,0,-18,0,2],4],
    [[1,0,-2,0,3,0,-1],8],[[5,0,-12,0,11,0,-4],6],
    [[2,0,-6,0,5,0,-1],10],
    [[3,0,-18,0,59,0,-96,0,81,0,-33,0,5],2],
    [[-2,0,1],14]],
    [[[3360],0],[[-3360],108],[[28,0,0,0,0,0,-464,0,684,
    0,0,0,-424,0,0,0,288,0,-112],0],
    [[1012,0,-1672,0,676],0],
    [[-12,0,0,0,0,0,90,0,-80,0,-42,0,0,0,170,0,-240,0,
    480,0,-592,0,300,0,-60,0,-30],10],[[],0],
    [[296,0,-1016,0,1248,0,-664,0,136],0],
    [[726,0,-1122,0,390],0],
    [[20,0,0,0,0,0,-64,0,60,0,0,0,-70,0,0,0,60],48],
    [[-60],72],[[60],36],
    [[4,0,0,0,18,0,-56,0,48,0,0,0,-14,0,0,0,12],12],
    [[21,0,-48,0,15],36],
    [[154,0,-484,0,550,0,-264,0,38],0],
    [[8,0,-32,0,50,0,-24,0,4],36],
    [[28,0,0,0,-228,0,280,0,-96],0],[[16],60],
    [[-4,0,-6,0,28,0,-16,0,-36,0,44,0,-8,0,-2],6],
    [[119,0,-378,0,414,0,-180,0,25],0],
    [[1,0,-1,0,0,0,-46,0,130,0,-84,0,-87,0,150,0,-53,0,
    -23,0,15,0,-2],0],[[],0],
    [[12,0,-66,0,122,0,-110,0,50,0,-8],0],
    [[55,0,-165,0,165,0,-55,0,5],0],[[-5],28],
    [[],0],[[],0],
    [[5,0,-10,0,3,0,-96,0,300,0,-281,0,16,0,144,0,1,0,
    -127,0,67,0,-4],0],[[28,0,-116,0,98,0,-28],0]
    ,[[2,0,-16,0,22,0,-8],36],
    [[213,0,-703,0,830,0,-417,0,75],0],
    [[-14,0,30,0,-6,0,-39,0,50,0,-16,0,-6,0,3],6],
    [[],0],[[-4,0,2,0,16,0,-18,0,4],6],
    [[1,0,-8,0,20,0,-24,0,13,0,-2],36],
    [[-2,0,10,0,0,0,-25,0,26,0,-9],6],
    [[5,0,-34,0,64,0,-54,0,20,0,-1],0],
    [[42,0,-220,0,448,0,-456,0,246,0,-70,0,8],0],
    [[-8,0,26,0,-22,0,6],6],[[],0],
    [[6,0,-29,0,53,0,-43,0,15,0,-2],0],
    [[2,0,-10,0,16,0,-11,0,3],0],[[],0],
    [[1,0,-10,0,21,0,-15,0,3],0],
    [[-6,0,16,0,-12,0,2],4],[[],0],
    [[-2,0,7,0,-5],4],[[],0],[[],0],[[],0],
    [[15,0,-76,0,148,0,-134,0,59,0,-12,0,1],0],
    [[-2,0,3,0,-2],2],[[],0],
    [[5,0,-10,0,-45,0,137,0,-143,0,67,0,-9],0],
    [[4,0,-6],40],[[2],24],[[-2],20],[[2],4],
    [[-1,0,0,0,-1],20],
    [[23,0,-120,0,235,0,-225,0,111,0,-26,0,2],0],
    [[1,0,-1,0,-24,0,65,0,-60,0,21,0,-2],0],[[],0],
    [[10,0,-54,0,100,0,-88,0,37,0,-6],0],[[1],24],
    [[],0],[[],0],[[-1848,0,1512],0],
    [[189,0,-315,0,0,0,0,0,315,0,-189,0,0,0,336],46],
    [[-550,0,1386,0,-1122,0,302],0],
    [[-15,0,13,0,0,0,252,0,-581,0,315,0,218,0,-206,0,
    -162,0,194,0,-44],0],
    [[-220,0,506,0,-330,0,60],0],
    [[1,0,-1,0,0,0,-15,0,10,0,3,0,-9,0,-25,0,35,0,-70,
    0,121,0,-76,0,10,0,10,0,-10],10],
    [[-2,0,0,0,0,0,87,0,-166,0,12,0,179,0,-123,0,-12,0,
    30,0,-5],0],
    [[-15,0,13,0,123,0,-259,0,180,0,-42],0],
    [[5,0,-3,0,-9,0,7],24],
    [[3,0,-6,0,0,0,12,0,-6,0,-12,0,3,0,6],10],
    [[-63,0,262,0,-403,0,285,0,-92,0,11],0],
    [[-396,0,946,0,-726,0,170],0],
    [[-1,0,1,0,0,0,9,0,-20,0,21,0,-31,0,41,0,-19,0,0,
    0,5],16],
    [[-2,0,2,0,-9,0,41,0,-48,0,24,0,6,0,-8,0,-6,0,6],
    12],[[-9,0,9,0,-6],16],
    [[-113,0,483,0,-782,0,601,0,-225,0,34],0],
    [[-15,0,76,0,-108,0,60,0,-11],0],
    [[-81,0,337,0,-527,0,391,0,-137,0,17],0],
    [[-5,0,9,0,-9,0,6,0,-1],16],
    [[-2,0,4,0,-4,0,3,0,-3],16],
    [[2,0,-3,0,-7,0,18,0,-10,0,2],6],
    [[-12,0,43,0,-58,0,30,0,-5],0],
    [[1,0,-6,0,5,0,13,0,-25,0,18,0,-4],6],
    [[-2,0,17,0,-23,0,8],0],
    [[1,0,-6,0,2,0,4,0,-9,0,8,0,1,0,-1],6],
    [[1,0,0,0,-1],12],[[2,0,-4,0,3,0,-1],2],
    [[-29,0,116,0,-168,0,104,0,-26,0,2],0],
    [[1,0,-1,0,1],12],
    [[1,0,0,0,16,0,-64,0,69,0,7,0,-79,0,67,0,-7,0,-13,
    0,3],2],[[-2,0,0,0,45,0,-80,0,42,0,-5],0],
    [[-45,0,183,0,-269,0,186,0,-55,0,4],0],
    [[1,0,-5,0,2,0,8,0,-15,0,8,0,-3],8],
    [[1,0,9,0,-33,0,42,0,-25,0,6],2],[[],0],
    [[-1,0,1],4],[[-1,0,1],8],
    [[-1,0,6,0,-14,0,14,0,-6,0,1],0],[[],0],
    [[1,0,-5,0,6,0,-2],4],[[],0],
    [[-2,0,18,0,-43,0,48,0,-27,0,7],0],
    [[1,0,-3,0,2,0,-1],4],[[4,0,-11,0,12,0,-5],2],
    [[1,0,-5,0,6,0,-2],6],
    [[-5,0,33,0,-81,0,96,0,-59,0,18,0,-3],0],
    [[-1,0,2],10]],
    [[[7168],0],[[-7168],120],[[16,0,0,0,0,0,-512,0,
    1008,0,0,0,-1024,0,0,0,1008,0,-512,0,0,0,0,0,16
    ],0],[[1792,0,-3584,0,1792],0],
    [[30,0,-40,0,-48,0,0,0,180,0,-360,0,990,0,-1504,0,
    990,0,-360,0,180,0,0,0,-48,0,-40,0,30],16],
    [[],0],[[448,0,-1792,0,2688,0,-1792,0,448],0],
    [[1152,0,-2432,0,1152],0],
    [[45,0,0,0,-36,0,0,0,110,0,0,0,-36,0,0,0,45],56],
    [[16],80],[[-16],40],
    [[-48,0,72,0,0,0,-80,0,0,0,72,0,-48],18],
    [[32],42],[[184,0,-784,0,1192,0,-784,0,184],0],
    [[2,0,16,0,-28,0,16,0,2],40],
    [[16,0,0,0,-336,0,640,0,-336,0,0,0,16],0],
    [[],0],
    [[-2,0,16,0,-20,0,-48,0,108,0,-48,0,-20,0,16,0,-2],
    8],[[128,0,-576,0,896,0,-576,0,128],0],
    [[-28,0,112,0,-96,0,-176,0,376,0,-176,0,-96,0,112,0,
    -28],6],[[],0],
    [[8,0,-64,0,176,0,-240,0,176,0,-64,0,8],0],
    [[40,0,-216,0,360,0,-216,0,40],0],
    [[-4,0,0,0,0,0,0,0,-4],28],[[-2],48],[[2],24],
    [[2,0,-6,0,2,0,-80,0,338,0,-422,0,-6,0,344,0,-6,0,
    -422,0,338,0,-80,0,2,0,-6,0,2],0],
    [[16,0,-128,0,224,0,-128,0,16],0],
    [[2,0,8,0,-20,0,8,0,2],40],
    [[288,0,-1184,0,1792,0,-1184,0,288],0],
    [[-4,0,20,0,-12,0,-68,0,128,0,-68,0,-12,0,20,0,-4],
    6],[[],0],[[24,0,-48,0,24],10],
    [[1,0,2,0,-13,0,20,0,-13,0,2,0,1],40],
    [[2,0,2,0,-38,0,68,0,-38,0,2,0,2],8],
    [[2,0,-26,0,82,0,-116,0,82,0,-26,0,2],0],
    [[46,0,-288,0,736,0,-988,0,736,0,-288,0,46],0],
    [[-4,0,30,0,-52,0,30,0,-4],6],[[],0],
    [[2,0,-20,0,64,0,-92,0,64,0,-20,0,2],0],
    [[-4,0,16,0,-24,0,16,0,-4],2],[[],0],
    [[-4,0,20,0,-32,0,20,0,-4],2],
    [[-2,0,16,0,-28,0,16,0,-2],4],[[],0],
    [[6,0,-14,0,6],6],[[2],16],[[1],28],
    [[-1],14],
    [[10,0,-74,0,208,0,-288,0,208,0,-74,0,10],0],
    [[2,0,-4,0,2],4],[[],0],
    [[2,0,-6,0,-52,0,218,0,-324,0,218,0,-52,0,-6,0,2],0
    ],[[-3,0,6,0,-3],44],[[],0],[[],0],
    [[],0],[[],0],
    [[20,0,-136,0,360,0,-488,0,360,0,-136,0,20],0],
    [[-20,0,88,0,-136,0,88,0,-20],4],[[],0],
    [[6,0,-48,0,138,0,-190,0,138,0,-48,0,6],0],
    [[-2],26],[[1],16],[[-1],8],[[-3584,0,3584],0],
    [[35,0,-189,0,378,0,-294,0,0,0,0,0,294,0,-378,0,189,
    0,-35],54],[[-896,0,2688,0,-2688,0,896],0],
    [[-8,0,8,0,0,0,256,0,-760,0,504,0,512,0,-512,0,-504,
    0,760,0,-256,0,0,0,-8,0,8],0],
    [[-256,0,896,0,-896,0,256],0],
    [[9,0,-9,0,-20,0,30,0,-95,0,257,0,-257,0,95,0,-30,0,
    20,0,9,0,-9],20],
    [[56,0,-168,0,24,0,376,0,-376,0,-24,0,168,0,-56],6],
    [[-8,0,8,0,168,0,-488,0,488,0,-168,0,-8,0,8],0],
    [[-9,0,17,0,-6,0,6,0,-17,0,9],28],
    [[9,0,-9,0,-18,0,18,0,9,0,-9],16],
    [[-64,0,352,0,-736,0,736,0,-352,0,64],0],
    [[-576,0,1792,0,-1792,0,576],0],
    [[5,0,-5,0,-19,0,15,0,40,0,-40,0,-15,0,19,0,5,0,-5]
    ,22],
    [[24,0,-60,0,36,0,40,0,-40,0,-36,0,60,0,-24],18],
    [[-1,0,3,0,-3,0,1],18],
    [[-144,0,736,0,-1488,0,1488,0,-736,0,144],0],
    [[-8,0,72,0,-176,0,176,0,-72,0,8],0],
    [[-92,0,484,0,-988,0,988,0,-484,0,92],0],
    [[1,0,1,0,-8,0,8,0,-1,0,-1],18],
    [[1,0,-1,0,0,0,6,0,-6,0,0,0,1,0,-1],18],
    [[-12,0,36,0,-36,0,12],10],
    [[-4,0,36,0,-92,0,92,0,-36,0,4],0],
    [[-1,0,0,0,20,0,-53,0,53,0,-20,0,0,0,1],8],
    [[8,0,-32,0,32,0,-8],2],
    [[-2,0,3,0,7,0,-22,0,22,0,-7,0,-3,0,2],8],
    [[-1,0,-1,0,1,0,1],14],[[-2,0,4,0,-4,0,2],4],
    [[-20,0,128,0,-288,0,288,0,-128,0,20],0],
    [[1,0,-3,0,3,0,-1],12],
    [[8,0,-46,0,70,0,28,0,-184,0,184,0,-28,0,-70,0,46,0,
    -8],6],[[40,0,-136,0,136,0,-40],4],
    [[-40,0,232,0,-488,0,488,0,-232,0,40],0],
    [[-1,0,2,0,8,0,-27,0,27,0,-8,0,-2,0,1],10],
    [[6,0,-36,0,74,0,-74,0,36,0,-6],4],[[],0],
    [[],0],[[2,0,-2],10],
    [[2,0,-10,0,20,0,-20,0,10,0,-2],2],[[],0],
    [[-3,0,10,0,-10,0,3],6],[[-1,0,1],6],
    [[-1,0,12,0,-45,0,80,0,-80,0,45,0,-12,0,1],0],
    [[-1,0,3,0,-3,0,1],6],
    [[1,0,-8,0,17,0,-17,0,8,0,-1],2],
    [[-3,0,9,0,-9,0,3],8],
    [[-3,0,27,0,-93,0,164,0,-164,0,93,0,-27,0,3],0],
    [[3,0,-3],12]],
    [[[4096],0],[[-4096],135],[[-128,0,288,0,0,0,-448,0,
    0,0,864,0,-640,0,0,0,0,0,64],6],
    [[768,0,-2048,0,1280],0],
    [[10,0,-60,0,330,0,-744,0,630,0,-180,0,110,0,0,0,
    -132,0,-80,0,120,0,0,0,20,0,-24],24],[[],0],
    [[128,0,-768,0,1536,0,-1280,0,384],0],
    [[448,0,-1344,0,960],0],
    [[-60,0,0,0,10,0,0,0,-84,0,64,0,0,0,0,0,0,0,0,0,6
    ],65],[[64],90],[[-64],45],
    [[6,0,0,0,-10,0,0,0,66,0,-112,0,36,0,0,0,12,0,0,0,
    -6],20],[[-16,0,48,0,-24],45],
    [[40,0,-288,0,680,0,-640,0,200],0],
    [[-4,0,24,0,-44,0,40,0,-8],45],
    [[-96,0,320,0,-288,0,0,0,64],4],[[],0],
    [[-2,0,-8,0,40,0,-40,0,-18,0,40,0,-4,0,-8],12],
    [[24,0,-200,0,512,0,-504,0,168],0],
    [[-1,0,12,0,-24,0,-36,0,152,0,-104,0,-116,0,188,0,
    -71,0,0,0,-4,0,4],6],[[],0],
    [[-8,0,56,0,-144,0,168,0,-88,0,16],2],
    [[4,0,-60,0,204,0,-236,0,84],0],
    [[1,0,0,0,0,0,0,0,6,0,0,0,-4,0,0,0,1],27],
    [[-4],54],[[4],27],
    [[-8,0,58,0,-130,0,50,0,144,0,-12,0,-376,0,396,0,
    -120,0,10,0,-22,0,10],6],
    [[-32,0,128,0,-160,0,64],2],
    [[8,0,-20,0,16,0,-4],47],
    [[72,0,-472,0,1024,0,-904,0,280],0],
    [[2,0,-6,0,-6,0,48,0,-58,0,-6,0,46,0,-20],8],
    [[],0],[[2,0,-18,0,22,0,4,0,-12,0,2],10],
    [[2,0,-9,0,20,0,-22,0,10,0,-1],47],
    [[-7,0,24,0,-29,0,4,0,18,0,-10],12],
    [[-2,0,24,0,-74,0,94,0,-52,0,10],2],
    [[4,0,-64,0,288,0,-572,0,576,0,-288,0,56],0],
    [[4,0,-24,0,32,0,-8,0,-4],8],[[],0],
    [[-1,0,18,0,-60,0,78,0,-43,0,8],2],
    [[3,0,-17,0,27,0,-14,0,2],4],[[-1],21],
    [[5,0,-24,0,35,0,-20,0,4],4],
    [[2,0,-16,0,26,0,-12],6],[[],0],
    [[-7,0,14,0,-6],8],[[-1],15],[[1],30],
    [[-1],15],[[-10,0,70,0,-176,0,202,0,-108,0,22],2],
    [[-4,0,8,0,-4],6],[[],0],
    [[-6,0,62,0,-170,0,176,0,-50,0,-22,0,10],4],
    [[2,0,-4,0,2],51],[[],0],[[],0],
    [[-2,0,4,0,-2],6],[[],0],
    [[1,0,-23,0,129,0,-288,0,311,0,-161,0,31],0],
    [[-1,0,20,0,-72,0,88,0,-35,0,-4,0,4],4],[[],0],
    [[-5,0,43,0,-117,0,139,0,-75,0,14],2],
    [[1,0,-1,0,1],27],[[-1],18],[[1],9],
    [[-1792,0,2304],0],
    [[-512,0,0,84,0,-378,0,594,0,-315,0,0,0,-189,0,378,0,
    -189,0,0,0,15],63],
    [[-320,0,1344,0,-1728,0,704],0],
    [[48,0,-188,0,180,0,184,0,-264,0,-396,0,772,0,-336,0,
    0,0,-32,0,32],6],[[-64,0,384,0,-640,0,320],0]
    ,
    [[-15,0,96,0,-172,0,95,0,-10,0,21,0,17,0,-37,0,-10,
    0,15,0,-1,0,2,0,-1],28],
    [[4,0,-28,0,12,0,116,0,-188,0,-12,0,228,0,-140,0,0,
    0,0,0,8],6],
    [[36,0,-196,0,316,0,-156,0,-32,0,32],4],
    [[-11,0,12,0,6,0,-4,0,-3],36],
    [[-6,0,9,0,8,0,-15,0,-3,0,10,0,-3],20],
    [[-8,0,96,0,-344,0,520,0,-352,0,88],0],
    [[-184,0,848,0,-1200,0,520],0],
    [[5,0,0,0,-5,19,16,-50,-5,31,0,4,5,10,0,-14,0,-5,0,
    4,0,1],25],
    [[6,0,3,0,-7,0,-30,0,92,0,-74,0,18,0,-6,0,6,0,3,0,
    -3],22],[[-8,3,0,-9,0,9,0,-3],21],
    [[-26,0,240,0,-726,0,986,0,-624,0,150],0],
    [[12,0,-76,0,148,0,-116,0,32],2],
    [[-14,0,142,0,-470,0,674,0,-442,0,106],0],
    [[-2,1,8,-2,-2,7,0,-13,0,8,0,-1],21],
    [[2,0,-4,2,2,-1,0,7,0,-11,0,3],23],
    [[9,0,-21,0,10,0,8,0,-7,0,1],12],
    [[4,0,-36,0,84,0,-68,0,16],2],
    [[2,0,-14,0,28,0,-18,0,-7,0,14,0,-5],12],
    [[-12,0,36,0,-32,0,8],4],
    [[1,0,-2,0,-4,0,17,0,-15,0,-2,0,6,0,-1],10],
    [[1,0,-2,0,1],18],[[2,0,-6,0,6,0,-2],6],
    [[-1,0,26,0,-126,0,226,0,-166,0,43],0],
    [[-1,-2,3,0,-3,0,1],14],
    [[-2,0,11,0,-8,0,-51,0,97,0,-12,0,-101,0,90,0,-23,0,
    1,0,-3,0,1],8],
    [[4,0,-44,0,100,0,-68,0,0,0,8],4],
    [[-4,0,56,0,-220,0,356,0,-248,0,60],0],
    [[-5,0,15,0,-10,0,-6,0,7,0,-1],16],
    [[-4,0,28,0,-56,0,45,0,-11,0,-3,0,1],6],
    [[-1,0,1],8],[[1,0,-3,0,3,0,-1],6],
    [[-2,0,2],12],[[-1,0,10,0,-22,0,21,0,-8,0,1],4],
    [[-1,-1,0,1],9],[[3,0,-11,0,10,0,-3],8],
    [[1],7],[[-8,0,37,0,-67,0,59,0,-24,0,3],4],
    [[1,0,-5,0,5,0,-1],8],
    [[-1,0,9,0,-20,0,19,0,-8,0,1],4],
    [[2,0,-8,0,7,0,-1],10],
    [[1,0,-21,0,78,0,-130,0,110,0,-46,0,7],2],
    [[1,-3,0,3],13]],
    [[[4096],0],[[-4096],105],[[64,0,0,0,0,0,-640,0,864,
    0,0,0,-448,0,0,0,288,0,-128],0],
    [[1280,0,-2048,0,768],0],
    [[-24,0,20,0,0,0,120,0,-80,0,-132,0,0,0,110,0,-180,
    0,630,0,-744,0,330,0,-60,0,10],10],[[],0],
    [[384,0,-1280,0,1536,0,-768,0,128],0],
    [[960,0,-1344,0,448],0],
    [[6,0,0,0,0,0,0,0,0,0,64,0,-84,0,0,0,10,0,0,0,-60
    ],43],[[64],70],[[-64],35],
    [[-6,0,0,0,12,0,0,0,36,0,-112,0,66,0,0,0,-10,0,0,
    0,6],8],[[-24,0,48,0,-16],35],
    [[200,0,-640,0,680,0,-288,0,40],0],
    [[-8,0,40,0,-44,0,24,0,-4],35],
    [[64,0,0,0,-288,0,320,0,-96],0],[[],0],
    [[-8,0,-4,0,40,0,-18,0,-40,0,40,0,-8,0,-2],6],
    [[168,0,-504,0,512,0,-200,0,24],0],
    [[4,0,-4,0,0,0,-71,0,188,0,-116,0,-104,0,152,0,-36,
    0,-24,0,12,0,-1],0],[[],0],
    [[16,0,-88,0,168,0,-144,0,56,0,-8],0],
    [[84,0,-236,0,204,0,-60,0,4],0],
    [[1,0,0,0,-4,0,0,0,6,0,0,0,0,0,0,0,1],21],
    [[-4],42],[[4],21],
    [[10,0,-22,0,10,0,-120,0,396,0,-376,0,-12,0,144,0,50,
    0,-130,0,58,0,-8],0],
    [[64,0,-160,0,128,0,-32],0],
    [[-4,0,16,0,-20,0,8],35],
    [[280,0,-904,0,1024,0,-472,0,72],0],
    [[-20,0,46,0,-6,0,-58,0,48,0,-6,0,-6,0,2],6],
    [[],0],[[2,0,-12,0,4,0,22,0,-18,0,2],4],
    [[-1,0,10,0,-22,0,20,0,-9,0,2],35],
    [[-10,0,18,0,4,0,-29,0,24,0,-7],6],
    [[10,0,-52,0,94,0,-74,0,24,0,-2],0],
    [[56,0,-288,0,576,0,-572,0,288,0,-64,0,4],0],
    [[-4,0,-8,0,32,0,-24,0,4],4],[[],0],
    [[8,0,-43,0,78,0,-60,0,18,0,-1],0],
    [[2,0,-14,0,27,0,-17,0,3],0],[[-1],15],
    [[4,0,-20,0,35,0,-24,0,5],0],
    [[-12,0,26,0,-16,0,2],4],[[],0],
    [[-6,0,14,0,-7],4],[[-1],17],[[1],26],
    [[-1],13],[[22,0,-108,0,202,0,-176,0,70,0,-10],0],
    [[-4,0,8,0,-4],2],[[],0],
    [[10,0,-22,0,-50,0,176,0,-170,0,62,0,-6],0],
    [[2,0,-4,0,2],37],[[],0],[[],0],
    [[-2,0,4,0,-2],2],[[],0],
    [[31,0,-161,0,311,0,-288,0,129,0,-23,0,1],0],
    [[4,0,-4,0,-35,0,88,0,-72,0,20,0,-1],0],[[],0],
    [[14,0,-75,0,139,0,-117,0,43,0,-5],0],
    [[1,0,-1,0,1],21],[[-1],14],[[1],7],
    [[-2304,0,1792],0],
    [[-15,0,0,0,189,0,-378,0,189,0,0,0,315,0,-594,0,378,
    0,-84,0,0,512],42],
    [[-704,0,1728,0,-1344,0,320],0],
    [[-32,0,32,0,0,0,336,0,-772,0,396,0,264,0,-184,0,
    -180,0,188,0,-48],0],
    [[-320,0,640,0,-384,0,64],0],
    [[1,0,-2,0,1,0,-15,0,10,0,37,0,-17,0,-21,0,10,0,
    -95,0,172,0,-96,0,15],10],
    [[-8,0,0,0,0,0,140,0,-228,0,12,0,188,0,-116,0,-12,0,
    28,0,-4],0],
    [[-32,0,32,0,156,0,-316,0,196,0,-36],0],
    [[3,0,4,0,-6,0,-12,0,11],22],
    [[3,0,-10,0,3,0,15,0,-8,0,-9,0,6],10],
    [[-88,0,352,0,-520,0,344,0,-96,0,8],0],
    [[-520,0,1200,0,-848,0,184],0],
    [[-1,0,-4,0,5,0,14,0,-10,-5,-4,0,-31,5,50,-16,-19,5,
    0,0,0,-5],16],
    [[3,0,-3,0,-6,0,6,0,-18,0,74,0,-92,0,30,0,7,0,-3,
    0,-6],8],[[3,0,-9,0,9,0,-3,8],14],
    [[-150,0,624,0,-986,0,726,0,-240,0,26],0],
    [[-32,0,116,0,-148,0,76,0,-12],0],
    [[-106,0,442,0,-674,0,470,0,-142,0,14],0],
    [[1,0,-8,0,13,0,-7,2,2,-8,-1,2],14],
    [[-3,0,11,0,-7,0,1,-2,-2,4,0,-2],16],
    [[-1,0,7,0,-8,0,-10,0,21,0,-9],4],
    [[-16,0,68,0,-84,0,36,0,-4],0],
    [[5,0,-14,0,7,0,18,0,-28,0,14,0,-2],6],
    [[-8,0,32,0,-36,0,12],0],
    [[1,0,-6,0,2,0,15,0,-17,0,4,0,2,0,-1],6],
    [[-1,0,2,0,-1],12],[[2,0,-6,0,6,0,-2],2],
    [[-43,0,166,0,-226,0,126,0,-26,0,1],0],
    [[-1,0,3,0,-3,2,1],10],
    [[-1,0,3,0,-1,0,23,0,-90,0,101,0,12,0,-97,0,51,0,8,
    0,-11,0,2],0],
    [[-8,0,0,0,68,0,-100,0,44,0,-4],0],
    [[-60,0,248,0,-356,0,220,0,-56,0,4],0],
    [[1,0,-7,0,6,0,10,0,-15,0,5],8],
    [[-1,0,3,0,11,0,-45,0,56,0,-28,0,4],0],
    [[-1,0,1],4],[[1,0,-3,0,3,0,-1],2],
    [[-2,0,2],8],[[-1,0,8,0,-21,0,22,0,-10,0,1],0],
    [[-1,0,1,1],6],[[3,0,-10,0,11,0,-3],4],
    [[-1],7],[[-3,0,24,0,-59,0,67,0,-37,0,8],0],
    [[1,0,-5,0,5,0,-1],4],
    [[-1,0,8,0,-19,0,20,0,-9,0,1],0],
    [[1,0,-7,0,8,0,-2],6],
    [[-7,0,46,0,-110,0,130,0,-78,0,21,0,-1],0],
    [[-3,0,3,-1],10]],
    [[[4200],0],[[-4200],126],[[8,0,0,0,0,0,-180,0,468,
    0,0,0,-616,0,0,0,720,0,-416,0,0,0,0,0,16],0],
    [[950,0,-2090,0,1160],0],
    [[-30,0,0,0,40,0,-150,0,510,0,-912,0,630,0,-300,0,
    240,0,0,0,-48,0,-60,0,60],20],[[],0],
    [[224,0,-932,0,1560,0,-1168,0,316],0],
    [[570,0,-1425,0,780],0],
    [[64,0,-24,0,0,0,40,0,0,0,-24,0,64,0,-45],60],
    [[60],84],[[-60],42],
    [[-16,0,42,0,0,0,-40,0,0,0,60,0,-40,0,9],18],
    [[-21,0,30,0,-24],42],
    [[74,0,-392,0,692,0,-522,0,154],0],
    [[-8,0,20,0,-32,0,24,0,-10],42],
    [[8,0,0,0,-156,0,376,0,-240,0,0,0,16],0],
    [[-4],66],
    [[4,0,-10,0,-18,0,60,0,-36,0,-16,0,20,0,-4],10],
    [[50,0,-275,0,518,0,-399,0,108],0],
    [[-7,0,36,0,-35,0,-101,0,227,0,-115,0,-76,0,102,0,-33
    ],6],[[],0],
    [[2,0,-22,0,78,0,-136,0,126,0,-60,0,12],0],
    [[10,0,-95,0,205,0,-160,0,40],0],[[],0],
    [[],0],[[],0],
    [[1,0,-3,0,1,0,-20,0,127,0,-194,0,-21,0,212,0,9,0,
    -299,0,271,0,-88,0,1,0,-5,0,5],0],
    [[8,0,-45,0,128,0,-104,0,16],0],
    [[-2,0,6,0,-8,0,8,0,-4],42],
    [[131,0,-604,0,1036,0,-787,0,217],0],
    [[4,0,-6,0,-38,0,81,0,-46,0,-6,0,24,0,-6],8],
    [[],0],[[14,0,-32,0,20,0,1],10],
    [[-1,0,2,0,-8,0,8,0,-8,0,6,0,-2],42],
    [[4,0,-22,0,44,0,-31,0,1,0,4],10],
    [[1,0,-8,0,32,0,-65,0,62,0,-27,0,5],0],
    [[20,0,-126,0,362,0,-564,0,498,0,-226,0,38],0],
    [[10,0,-30,0,24,0,-6],8],[[],0],
    [[-5,0,25,0,-50,0,49,0,-22,0,3],2],
    [[5,0,-13,0,13,0,-6,0,1],4],[[],0],
    [[-1,0,6,0,-16,0,17,0,-6],2],
    [[6,0,-16,0,12,0,-4],6],[[2],34],
    [[2,0,-7,0,5],6],[[],0],[[],0],[[],0],
    [[3,0,-26,0,92,0,-161,0,150,0,-68,0,10],0],
    [[-2,0,2],6],[[],0],
    [[1,0,-3,0,-20,0,108,0,-188,0,147,0,-44,0,-5,0,5],0
    ],[[-1],50],[[-2],24],[[2],22],[[1],8],
    [[1,0,-2],22],
    [[7,0,-54,0,168,0,-277,0,251,0,-116,0,20],0],
    [[-7,0,39,0,-78,0,66,0,-19],4],[[],0],
    [[1,0,-16,0,59,0,-106,0,101,0,-47,0,8],0],
    [[],0],[[],0],[[],0],[[-1995,0,2205],0],
    [[378,0,-504,0,0,0,0,0,315,0,-378,0,189,0,-315,0,0,
    0,0,0,105],58],[[-457,0,1479,0,-1656,0,608],0]
    ,
    [[-4,0,4,0,0,0,84,0,-321,0,243,0,314,0,-302,0,-342,
    0,570,0,-224,0,0,0,-6,0,10],0],
    [[-105,0,465,0,-580,0,200],0],
    [[5,0,-5,0,0,0,5,0,-25,0,146,0,-171,0,85,0,-60,0,
    50,0,4,0,-9,0,-10,0,5],20],
    [[14,0,-59,0,12,0,208,0,-247,0,-12,0,144,0,-60],6],
    [[-4,0,4,0,75,0,-263,0,308,0,-126,0,-6,0,10],0],
    [[6,0,0,0,3,0,-13,0,9,0,0,0,-3],30],
    [[3,0,-6,0,-6,0,15,0,0,0,-9,0,0,0,3],16],
    [[-25,0,156,0,-385,0,463,0,-265,0,56],0],
    [[-270,0,980,0,-1110,0,415],0],
    [[-9,0,5,0,25,0,-51,0,11,0,-17,0,20,0,0,0,1,0,-1,
    0,1],26],
    [[8,0,-32,0,18,0,24,0,-16,0,-30,0,46,0,-24,0,9],18]
    ,[[-9,0,6],24],
    [[-66,0,353,0,-801,0,921,0,-523,0,111],0],
    [[-4,0,25,0,-82,0,118,0,-62,0,10],0],
    [[-37,0,225,0,-526,0,614,0,-354,0,78],0],
    [[-1,0,-3,0,1,0,7,0,-7,0,3],20],
    [[-1,0,-1,0,5,0,-3,0,-1,0,3,0,-2,0,1],20],
    [[-8,0,22,0,-26,0,10,0,1],10],
    [[10,0,-45,0,59,0,-33,0,7],2],
    [[-2,0,14,0,-33,0,37,0,-15,0,-1,0,2],10],
    [[2,0,-12,0,22,0,-10],2],
    [[1,0,3,0,-16,0,14,0,-3,0,-2,0,2,0,-1],10],
    [[1,0,-1],20],[[1,0,-3,0,3,0,-1],6],
    [[-5,0,50,0,-144,0,184,0,-106,0,21],0],
    [[1,0,-3,0,2],12],
    [[1,0,-14,0,23,0,23,0,-111,0,112,0,-10,0,-59,0,46,0,
    -14],6],[[14,0,-67,0,92,0,-36],4],
    [[-13,0,98,0,-255,0,307,0,-178,0,42],0],
    [[1,0,2,0,-14,0,15,0,-5,0,-3,0,4,0,-1],12],
    [[2,0,-14,0,37,0,-48,0,30,0,-7],4],[[],0],
    [[1],10],[[-1],12],[[-2,0,8,0,-13,0,11,0,-4],4]
    ,[[],0],[[-1,0,4,0,-6,0,3],6],[[],0],
    [[3,0,-15,0,37,0,-52,0,41,0,-16,0,2],2],
    [[1,0,-2,0,1],8],[[-2,0,6,0,-11,0,9,0,-3],4],
    [[4,0,-6,0,4,0,-1],10],
    [[-1,0,8,0,-35,0,79,0,-104,0,79,0,-29,0,3],0],
    [[2,0,-2],12]],
    [[[4200],0],[[-4200],114],[[16,0,0,0,0,0,-416,0,720,
    0,0,0,-616,0,0,0,468,0,-180,0,0,0,0,0,8],0],
    [[1160,0,-2090,0,950],0],
    [[60,0,-60,0,-48,0,0,0,240,0,-300,0,630,0,-912,0,510,
    0,-150,0,40,0,0,0,-30],16],[[],0],
    [[316,0,-1168,0,1560,0,-932,0,224],0],
    [[780,0,-1425,0,570],0],
    [[-45,0,64,0,-24,0,0,0,40,0,0,0,-24,0,64],54],
    [[60],76],[[-60],38],
    [[9,0,-40,0,60,0,0,0,-40,0,0,0,42,0,-16],16],
    [[-24,0,30,0,-21],38],
    [[154,0,-522,0,692,0,-392,0,74],0],
    [[-10,0,24,0,-32,0,20,0,-8],38],
    [[16,0,0,0,-240,0,376,0,-156,0,0,0,8],0],
    [[-4],66],
    [[-4,0,20,0,-16,0,-36,0,60,0,-18,0,-10,0,4],8],
    [[108,0,-399,0,518,0,-275,0,50],0],
    [[-33,0,102,0,-76,0,-115,0,227,0,-101,0,-35,0,36,0,-7
    ],6],[[],0],
    [[12,0,-60,0,126,0,-136,0,78,0,-22,0,2],0],
    [[40,0,-160,0,205,0,-95,0,10],0],[[],0],
    [[],0],[[],0],
    [[5,0,-5,0,1,0,-88,0,271,0,-299,0,9,0,212,0,-21,0,
    -194,0,127,0,-20,0,1,0,-3,0,1],0],
    [[16,0,-104,0,128,0,-45,0,8],0],
    [[-4,0,8,0,-8,0,6,0,-2],38],
    [[217,0,-787,0,1036,0,-604,0,131],0],
    [[-6,0,24,0,-6,0,-46,0,81,0,-38,0,-6,0,4],6],
    [[],0],[[1,0,20,0,-32,0,14],8],
    [[-2,0,6,0,-8,0,8,0,-8,0,2,0,-1],38],
    [[4,0,1,0,-31,0,44,0,-22,0,4],8],
    [[5,0,-27,0,62,0,-65,0,32,0,-8,0,1],0],
    [[38,0,-226,0,498,0,-564,0,362,0,-126,0,20],0],
    [[-6,0,24,0,-30,0,10],6],[[],0],
    [[3,0,-22,0,49,0,-50,0,25,0,-5],0],
    [[1,0,-6,0,13,0,-13,0,5],0],[[],0],
    [[-6,0,17,0,-16,0,6,0,-1],2],
    [[-4,0,12,0,-16,0,6],4],[[2],34],
    [[5,0,-7,0,2],6],[[],0],[[],0],[[],0],
    [[10,0,-68,0,150,0,-161,0,92,0,-26,0,3],0],
    [[2,0,-2],4],[[],0],
    [[5,0,-5,0,-44,0,147,0,-188,0,108,0,-20,0,-3,0,1],0
    ],[[-1],42],[[-2],28],[[2],22],[[1],4],
    [[-2,0,1],24],
    [[20,0,-116,0,251,0,-277,0,168,0,-54,0,7],0],
    [[-19,0,66,0,-78,0,39,0,-7],4],[[],0],
    [[8,0,-47,0,101,0,-106,0,59,0,-16,0,1],0],
    [[],0],[[],0],[[],0],[[-2205,0,1995],0],
    [[-105,0,0,0,0,0,315,0,-189,0,378,0,-315,0,0,0,0,0,
    504,0,-378],48],[[-608,0,1656,0,-1479,0,457],0]
    ,
    [[-10,0,6,0,0,0,224,0,-570,0,342,0,302,0,-314,0,-243,
    0,321,0,-84,0,0,0,-4,0,4],0],
    [[-200,0,580,0,-465,0,105],0],
    [[-5,0,10,0,9,0,-4,0,-50,0,60,0,-85,0,171,0,-146,0,
    25,0,-5,0,0,0,5,0,-5],16],
    [[60,0,-144,0,12,0,247,0,-208,0,-12,0,59,0,-14],6],
    [[-10,0,6,0,126,0,-308,0,263,0,-75,0,-4,0,4],0],
    [[3,0,0,0,-9,0,13,0,-3,0,0,0,-6],24],
    [[-3,0,0,0,9,0,0,0,-15,0,6,0,6,0,-3],12],
    [[-56,0,265,0,-463,0,385,0,-156,0,25],0],
    [[-415,0,1110,0,-980,0,270],0],
    [[-1,0,1,0,-1,0,0,0,-20,0,17,0,-11,0,51,0,-25,0,-5,
    0,9],16],
    [[-9,0,24,0,-46,0,30,0,16,0,-24,0,-18,0,32,0,-8],16
    ],[[-6,0,9],16],
    [[-111,0,523,0,-921,0,801,0,-353,0,66],0],
    [[-10,0,62,0,-118,0,82,0,-25,0,4],0],
    [[-78,0,354,0,-614,0,526,0,-225,0,37],0],
    [[-3,0,7,0,-7,0,-1,0,3,0,1],16],
    [[-1,0,2,0,-3,0,1,0,3,0,-5,0,1,0,1],16],
    [[-1,0,-10,0,26,0,-22,0,8],8],
    [[-7,0,33,0,-59,0,45,0,-10],0],
    [[-2,0,1,0,15,0,-37,0,33,0,-14,0,2],8],
    [[10,0,-22,0,12,0,-2],2],
    [[1,0,-2,0,2,0,3,0,-14,0,16,0,-3,0,-1],6],
    [[1,0,-1],12],[[1,0,-3,0,3,0,-1],2],
    [[-21,0,106,0,-184,0,144,0,-50,0,5],0],
    [[-2,0,3,0,-1],14],
    [[14,0,-46,0,59,0,10,0,-112,0,111,0,-23,0,-23,0,14,
    0,-1],6],[[36,0,-92,0,67,0,-14],4],
    [[-42,0,178,0,-307,0,255,0,-98,0,13],0],
    [[1,0,-4,0,3,0,5,0,-15,0,14,0,-2,0,-1],8],
    [[7,0,-30,0,48,0,-37,0,14,0,-2],4],[[],0],
    [[-1],4],[[1],10],[[4,0,-11,0,13,0,-8,0,2],2],
    [[],0],[[-3,0,6,0,-4,0,1],6],[[],0],
    [[-2,0,16,0,-41,0,52,0,-37,0,15,0,-3],0],
    [[-1,0,2,0,-1],6],[[3,0,-9,0,11,0,-6,0,2],2],
    [[1,0,-4,0,6,0,-4],6],
    [[-3,0,29,0,-79,0,104,0,-79,0,35,0,-8,0,1],0],
    [[2,0,-2],12]],
    [[[4536],0],[[-4536],130],[[-144,0,396,0,0,0,-696,0,
    0,0,900,0,-492,0,0,0,0,0,36],6],
    [[960,0,-2238,0,1338],0],
    [[110,0,-180,0,450,0,-856,0,720,0,-360,0,180,0,0,0,
    -108,0,-80,0,60,0,0,0,10,0,-6],24],[[],0],
    [[204,0,-960,0,1656,0,-1308,0,408],0],
    [[540,0,-1539,0,918],0],[[81],70],[[],0],
    [[],0],
    [[18,0,0,0,-60,0,0,0,108,0,-72,0,0,0,0,0,6],20],
    [[],0],[[72,0,-366,0,726,0,-624,0,192],0],
    [[],0],[[-132,0,408,0,-300,0,0,0,36],4],
    [[-12],74],
    [[-6,0,-16,0,66,0,-48,0,-24,0,32,0,-2,0,-2],12],
    [[39,0,-257,0,544,0,-473,0,145],0],
    [[-3,0,22,0,-26,0,-91,0,257,0,-165,0,-90,0,146,0,-49,
    0,0,0,-1,0,2],6],[[],0],
    [[2,0,-20,0,72,0,-136,0,142,0,-78,0,18],0],
    [[6,0,-74,0,211,0,-203,0,56],0],
    [[-1,0,0,0,4,0,0,0,-6,0,0,0,8,0,0,0,-1],26],
    [[6],52],[[-6],26],
    [[-24,0,102,0,-159,0,0,0,234,0,-57,0,-354,0,357,0,
    -108,0,3,0,-12,0,9],6],
    [[-36,0,132,0,-123,0,36],2],[[],0],
    [[119,0,-597,0,1100,0,-900,0,281],0],
    [[4,0,-5,0,-24,0,90,0,-82,0,-5,0,30,0,-11],8],
    [[],0],[[6,0,-36,0,36,0,0,0,-6],10],[[],0],
    [[-15,0,51,0,-48,0,6,0,9,0,-3],12],
    [[-6,0,30,0,-63,0,69,0,-39,0,9],2],
    [[14,0,-118,0,364,0,-590,0,548,0,-282,0,64],0],
    [[8,0,-28,0,30,0,-8,0,-2],8],[[],0],
    [[-3,0,21,0,-49,0,55,0,-30,0,6],2],
    [[3,0,-11,0,15,0,-8,0,1],4],[[],0],
    [[5,0,-15,0,18,0,-10,0,2],4],
    [[2,0,-14,0,20,0,-6],6],[[-2],38],
    [[-6,0,9,0,-3],8],[[],0],[[],0],[[],0],
    [[1,0,-21,0,87,0,-165,0,167,0,-89,0,20],0],
    [[-1,0,2,0,-1],6],[[],0],
    [[-18,0,93,0,-195,0,186,0,-60,0,-12,0,9],4],
    [[-3],50],[[],0],[[],0],[[],0],[[],0],
    [[5,0,-48,0,164,0,-285,0,279,0,-148,0,34],0],
    [[-3,0,31,0,-81,0,83,0,-32,0,-1,0,2],4],[[],0],
    [[1,0,-13,0,54,0,-107,0,112,0,-62,0,14],0],
    [[-1,0,3,0,-1],26],[[],0],[[],0],
    [[-2079,0,2457],0],
    [[-210,0,0,0,0,0,714,0,-756,0,189,0,-105,0,0,0,-189,
    0,168,0,-189],60],
    [[-444,0,1548,0,-1809,0,735],0],
    [[72,0,-261,0,207,0,306,0,-390,0,-405,0,711,0,-276,0,
    0,0,-15,0,21],6],[[-80,0,460,0,-659,0,259],0]
    ,
    [[-10,0,30,0,-40,0,125,0,-161,0,90,0,-35,0,45,0,9,0,
    -29,0,-10,0,5,0,0,0,1],24],
    [[6,0,-39,0,11,0,220,0,-304,0,-11,0,197,0,-83,0,0,0,
    0,0,3],6],
    [[63,0,-255,0,357,0,-165,0,-15,0,21],4],
    [[-6,0,6,0,-21,0,9,0,6],32],
    [[-9,0,9,0,12,0,-18,0,0,0,6],20],
    [[-18,0,143,0,-389,0,503,0,-322,0,83],0],
    [[-255,0,990,0,-1248,0,504],0],
    [[-5,0,5,0,15,0,14,0,-35,0,1,0,23,0,10,0,-14,0,-5,
    0,-1,0,1],24],
    [[-6,0,12,0,24,0,-36,0,-48,0,92,0,-40,0,0,0,-2,0,4]
    ,20],[[6,0,-6,0,-6,0,6],20],
    [[-54,0,345,0,-828,0,996,0,-615,0,159],0],
    [[18,0,-81,0,123,0,-84,0,21],2],
    [[-33,0,211,0,-533,0,669,0,-424,0,110],0],
    [[1,0,-7,0,11,0,3,0,-10,0,2],20],
    [[6,0,-11,0,1,0,7,0,-3],24],
    [[-2,0,20,0,-36,0,20,0,2,0,-4],10],
    [[6,0,-35,0,67,0,-47,0,9],2],
    [[6,0,-31,0,50,0,-30,0,0,0,7,0,-2],12],
    [[-9,0,23,0,-15,0,3],4],
    [[1,0,-1,0,-10,0,23,0,-16,0,-1,0,3,0,-1],10],
    [[1,0,-1],18],[[1,0,-2,0,2,0,-1],6],
    [[-3,0,39,0,-138,0,202,0,-135,0,33],0],
    [[-1,0,5,0,-3,0,1],14],
    [[1,0,-8,0,16,0,11,0,-104,0,150,0,-47,0,-74,0,73,0,
    -21,0,0,0,-1,0,1],6],
    [[6,0,-59,0,109,0,-56,0,0,0,3],4],
    [[-12,0,87,0,-246,0,338,0,-223,0,57],0],
    [[1,0,-11,0,21,0,-11,0,-5,0,5,0,-1],14],
    [[1,0,-10,0,34,0,-53,0,41,0,-13,0,-1,0,1],4],
    [[],0],[[],0],[[],0],
    [[-2,0,7,0,-12,0,11,0,-5,0,1],4],[[],0],
    [[3,0,-7,0,6,0,-2],8],[[],0],
    [[3,0,-15,0,36,0,-51,0,44,0,-22,0,5],2],
    [[-2,0,2],10],[[-2,0,6,0,-10,0,9,0,-5,0,1],4],
    [[3,0,-6,0,5,0,-1],10],
    [[7,0,-34,0,79,0,-106,0,87,0,-41,0,9],2],
    [[-4,0,3],14]],
    [[[4536],0],[[-4536],110],[[36,0,0,0,0,0,-492,0,900,
    0,0,0,-696,0,0,0,396,0,-144],0],
    [[1338,0,-2238,0,960],0],
    [[-6,0,10,0,0,0,60,0,-80,0,-108,0,0,0,180,0,-360,0,
    720,0,-856,0,450,0,-180,0,110],10],[[],0],
    [[408,0,-1308,0,1656,0,-960,0,204],0],
    [[918,0,-1539,0,540],0],[[81],58],[[],0],
    [[],0],
    [[6,0,0,0,0,0,-72,0,108,0,0,0,-60,0,0,0,18],12],
    [[],0],[[192,0,-624,0,726,0,-366,0,72],0],
    [[],0],[[36,0,0,0,-300,0,408,0,-132],0],
    [[-12],58],
    [[-2,0,-2,0,32,0,-24,0,-48,0,66,0,-16,0,-6],6],
    [[145,0,-473,0,544,0,-257,0,39],0],
    [[2,0,-1,0,0,0,-49,0,146,0,-90,0,-165,0,257,0,-91,0,
    -26,0,22,0,-3],0],[[],0],
    [[18,0,-78,0,142,0,-136,0,72,0,-20,0,2],0],
    [[56,0,-203,0,211,0,-74,0,6],0],
    [[-1,0,0,0,8,0,0,0,-6,0,0,0,4,0,0,0,-1],22],
    [[6],44],[[-6],22],
    [[9,0,-12,0,3,0,-108,0,357,0,-354,0,-57,0,234,0,0,0,
    -159,0,102,0,-24],0],
    [[36,0,-123,0,132,0,-36],0],[[],0],
    [[281,0,-900,0,1100,0,-597,0,119],0],
    [[-11,0,30,0,-5,0,-82,0,90,0,-24,0,-5,0,4],6],
    [[],0],[[-6,0,0,0,36,0,-36,0,6],6],[[],0],
    [[-3,0,9,0,6,0,-48,0,51,0,-15],6],
    [[9,0,-39,0,69,0,-63,0,30,0,-6],0],
    [[64,0,-282,0,548,0,-590,0,364,0,-118,0,14],0],
    [[-2,0,-8,0,30,0,-28,0,8],4],[[],0],
    [[6,0,-30,0,55,0,-49,0,21,0,-3],0],
    [[1,0,-8,0,15,0,-11,0,3],0],[[],0],
    [[2,0,-10,0,18,0,-15,0,5],0],
    [[-6,0,20,0,-14,0,2],4],[[-2],30],
    [[-3,0,9,0,-6],4],[[],0],[[],0],[[],0],
    [[20,0,-89,0,167,0,-165,0,87,0,-21,0,1],0],
    [[-1,0,2,0,-1],2],[[],0],
    [[9,0,-12,0,-60,0,186,0,-195,0,93,0,-18],0],
    [[-3],42],[[],0],[[],0],[[],0],[[],0],
    [[34,0,-148,0,279,0,-285,0,164,0,-48,0,5],0],
    [[2,0,-1,0,-32,0,83,0,-81,0,31,0,-3],0],[[],0],
    [[14,0,-62,0,112,0,-107,0,54,0,-13,0,1],0],
    [[-1,0,3,0,-1],22],[[],0],[[],0],
    [[-2457,0,2079],0],
    [[189,0,-168,0,189,0,0,0,105,0,-189,0,756,0,-714,0,0,
    0,0,0,210],46],[[-735,0,1809,0,-1548,0,444],0]
    ,
    [[-21,0,15,0,0,0,276,0,-711,0,405,0,390,0,-306,0,-207,
    0,261,0,-72],0],[[-259,0,659,0,-460,0,80],0],
    [[-1,0,0,0,-5,0,10,0,29,0,-9,0,-45,0,35,0,-90,0,
    161,0,-125,0,40,0,-30,0,10],12],
    [[-3,0,0,0,0,0,83,0,-197,0,11,0,304,0,-220,0,-11,0,
    39,0,-6],0],
    [[-21,0,15,0,165,0,-357,0,255,0,-63],0],
    [[-6,0,-9,0,21,0,-6,0,6],26],
    [[-6,0,0,0,18,0,-12,0,-9,0,9],12],
    [[-83,0,322,0,-503,0,389,0,-143,0,18],0],
    [[-504,0,1248,0,-990,0,255],0],
    [[-1,0,1,0,5,0,14,0,-10,0,-23,0,-1,0,35,0,-14,0,
    -15,0,-5,0,5],16],
    [[-4,0,2,0,0,0,40,0,-92,0,48,0,36,0,-24,0,-12,0,6],
    12],[[-6,0,6,0,6,0,-6],16],
    [[-159,0,615,0,-996,0,828,0,-345,0,54],0],
    [[-21,0,84,0,-123,0,81,0,-18],0],
    [[-110,0,424,0,-669,0,533,0,-211,0,33],0],
    [[-2,0,10,0,-3,0,-11,0,7,0,-1],16],
    [[3,0,-7,0,-1,0,11,0,-6],18],
    [[4,0,-2,0,-20,0,36,0,-20,0,2],6],
    [[-9,0,47,0,-67,0,35,0,-6],0],
    [[2,0,-7,0,0,0,30,0,-50,0,31,0,-6],6],
    [[-3,0,15,0,-23,0,9],0],
    [[1,0,-3,0,1,0,16,0,-23,0,10,0,1,0,-1],6],
    [[1,0,-1],14],[[1,0,-2,0,2,0,-1],2],
    [[-33,0,135,0,-202,0,138,0,-39,0,3],0],
    [[-1,0,3,0,-5,0,1],10],
    [[-1,0,1,0,0,0,21,0,-73,0,74,0,47,0,-150,0,104,0,
    -11,0,-16,0,8,0,-1],0],
    [[-3,0,0,0,56,0,-109,0,59,0,-6],0],
    [[-57,0,223,0,-338,0,246,0,-87,0,12],0],
    [[1,0,-5,0,5,0,11,0,-21,0,11,0,-1],8],
    [[-1,0,1,0,13,0,-41,0,53,0,-34,0,10,0,-1],0],
    [[],0],[[],0],[[],0],
    [[-1,0,5,0,-11,0,12,0,-7,0,2],0],[[],0],
    [[2,0,-6,0,7,0,-3],4],[[],0],
    [[-5,0,22,0,-44,0,51,0,-36,0,15,0,-3],0],
    [[-2,0,2],6],[[-1,0,5,0,-9,0,10,0,-6,0,2],0],
    [[1,0,-5,0,6,0,-3],6],
    [[-9,0,41,0,-87,0,106,0,-79,0,34,0,-7],0],
    [[-3,0,4],10]],
    [[[5600],0],[[-5600],126],[[8,0,0,0,0,0,-336,0,612,
    0,0,0,-656,0,0,0,936,0,-608,0,0,0,0,0,44],0],
    [[1240,0,-2840,0,1520],0],
    [[-20,0,-18,0,0,0,140,0,-120,0,660,0,-1304,0,870,0,
    -150,0,130,0,0,0,-132,0,-40,0,60,0,0,0,10,0,-6]
    ,18],[[],0],
    [[248,0,-1264,0,2160,0,-1536,0,392],0],
    [[800,0,-1860,0,1080],0],
    [[-30,0,0,0,-24,0,0,0,0,0,0,0,0,0,64,0,-30],58],
    [[20],84],[[-20],42],
    [[3,0,-24,0,24,0,0,0,-12,0,0,0,72,0,-88,0,30,0,0,
    0,6],16],[[-8,0,6,0,-9],42],
    [[98,0,-524,0,974,0,-724,0,178],0],
    [[-2,0,8,0,-8,0,4,0,-4],42],
    [[8,0,0,0,-204,0,448,0,-312,0,0,0,44],0],
    [[16],72],
    [[8,0,-10,0,-24,0,66,0,-38,0,-22,0,24,0,-2,0,-2],10
    ],[[67,0,-386,0,730,0,-554,0,143],0],
    [[-9,0,54,0,-64,0,-71,0,223,0,-120,0,-116,0,148,0,
    -44,0,0,0,-2,0,1],6],[[],0],
    [[2,0,-28,0,122,0,-220,0,184,0,-68,0,8],0],
    [[20,0,-140,0,300,0,-240,0,60],0],[[],0],
    [[],0],[[],0],
    [[-2,0,4,0,-36,0,171,0,-282,0,79,0,214,0,-1,0,-431,
    0,357,0,-84,0,10,0,-15,0,4],2],
    [[8,0,-84,0,196,0,-152,0,44],0],
    [[-2,0,0,0,2,0,2,0,-2],42],
    [[156,0,-816,0,1448,0,-1052,0,268],0],
    [[-2,0,6,0,-9,0,-18,0,67,0,-62,0,-9,0,30,0,-7],6],
    [[],0],[[-1,0,8,0,-24,0,24,0,2,0,-6],8],
    [[2,0,-2,0,-2,0,0,0,0,0,-1],44],
    [[1,0,-15,0,33,0,-31,0,6,0,9,0,-3],10],
    [[-11,0,59,0,-115,0,99,0,-36,0,4],2],
    [[14,0,-150,0,520,0,-830,0,672,0,-270,0,42],0],
    [[-2,0,14,0,-38,0,34,0,-4,0,-2],6],[[],0],
    [[-8,0,46,0,-93,0,80,0,-28,0,3],2],
    [[-1,0,12,0,-30,0,26,0,-7],2],[[],0],
    [[-1,0,17,0,-40,0,34,0,-11,0,1],2],
    [[10,0,-26,0,22,0,-6],6],[[],0],
    [[3,0,-12,0,11,0,-3],6],[[1],14],[[-1],28],
    [[1],14],
    [[2,0,-34,0,148,0,-260,0,218,0,-86,0,12],0],
    [[2,0,-9,0,8,0,-1],4],[[],0],
    [[-2,0,-17,0,128,0,-252,0,191,0,-41,0,-15,0,4],2],
    [[2,0,0,0,2],46],[[2],30],[[-2],24],
    [[1,0,-6,0,4],4],[[2,0,-1],26],
    [[5,0,-66,0,252,0,-425,0,351,0,-137,0,20],0],
    [[-7,0,51,0,-106,0,89,0,-26,0,-2,0,1],4],[[],0],
    [[1,0,-21,0,96,0,-178,0,150,0,-55,0,7],0],
    [[],0],[[],0],[[],0],[[-2660,0,2940],0],
    [[-405,0,0,0,-189,0,0,0,0,0,504,0,-378,0,594,0,-595,
    0,0,0,-189,0,378],56],
    [[-564,0,2028,0,-2232,0,776],0],
    [[-2,0,6,0,0,0,144,0,-453,0,351,0,288,0,-368,0,-468,
    0,788,0,-288,0,0,0,-25,0,19],0],
    [[-160,0,640,0,-780,0,300],0],
    [[-4,0,-15,0,19,0,-50,0,218,0,-268,0,95,0,-4,0,16,0,
    22,0,-28,0,0,0,0,0,-1],22],
    [[28,0,-89,0,21,0,197,0,-238,0,-21,0,198,0,-99,0,0,
    0,0,0,3],6],
    [[-2,0,6,0,87,0,-329,0,392,0,-156,0,-25,0,19],0],
    [[-3,0,10,0,3,0,0,0,-15,0,12,0,3,0,-2],28],
    [[3,0,4,0,-18,0,12,0,10,0,-9,0,-3,0,1],16],
    [[-26,0,212,0,-564,0,660,0,-350,0,68],0],
    [[-360,0,1320,0,-1520,0,540],0],
    [[-1,0,0,0,0,0,5,0,-10,0,51,0,-50,0,10,0,9,0,10,0,
    0,0,-5,0,0,0,1],20],
    [[11,0,-22,0,18,0,3,0,-9,0,-36,0,84,0,-58,0,12,0,
    -4,0,2],18],[[-9,0,0,0,-1,0,9],20],
    [[-64,0,460,0,-1140,0,1276,0,-668,0,132],0],
    [[-2,0,42,0,-141,0,183,0,-97,0,19],0],
    [[-39,0,293,0,-755,0,871,0,-453,0,87],0],
    [[-4,0,3,0,0,0,2,0,-9,0,4],20],
    [[-1,0,0,0,-3,0,1,0,1,0,5,0,-5,0,1],20],
    [[-3,0,17,0,-25,0,10,0,4,0,-2],10],
    [[-1,0,19,0,-74,0,104,0,-53,0,7],0],
    [[6,0,-24,0,34,0,-19,0,-3,0,5,0,-1],12],
    [[4,0,-31,0,45,0,-21,0,3],2],
    [[-1,0,2,0,1,0,-8,0,19,0,-12,0,-3,0,2],8],
    [[-1,0,1,0,1,0,-1],14],[[-1,0,6,0,-9,0,4],4],
    [[-7,0,73,0,-224,0,280,0,-149,0,27],0],
    [[1,0,-1,0,2,0,-3,0,1],12],
    [[1,0,-15,0,42,0,-15,0,-89,0,127,0,-6,0,-93,0,59,0,
    -11,0,1,0,-1],6],
    [[20,0,-85,0,118,0,-56,0,0,0,3],4],
    [[-16,0,133,0,-375,0,453,0,-237,0,42],0],
    [[1,0,-1,0,-10,0,20,0,-7,0,-5,0,2],12],
    [[1,0,-16,0,54,0,-70,0,38,0,-6,0,-1],4],
    [[1,0,-2,0,1],6],[[4,0,-5,0,2],6],
    [[1,0,-3,0,1],10],[[-6,0,22,0,-29,0,16,0,-3],4],
    [[1,0,-1],8],[[-1,0,8,0,-12,0,7,0,-1],6],
    [[-1],8],[[3,0,-26,0,72,0,-89,0,52,0,-13,0,1],2],
    [[4,0,-6,0,2],8],[[-5,0,20,0,-27,0,15,0,-3],4],
    [[-1,0,6,0,-10,0,5],8],
    [[8,0,-56,0,141,0,-168,0,102,0,-30,0,3],2],
    [[1,0,-3,0,2],12]],
    [[[5600],0],[[-5600],114],[[44,0,0,0,0,0,-608,0,936,
    0,0,0,-656,0,0,0,612,0,-336,0,0,0,0,0,8],0],
    [[1520,0,-2840,0,1240],0],
    [[-6,0,10,0,0,0,60,0,-40,0,-132,0,0,0,130,0,-150,0,
    870,0,-1304,0,660,0,-120,0,140,0,0,0,-18,0,-20],
    10],[[],0],
    [[392,0,-1536,0,2160,0,-1264,0,248],0],
    [[1080,0,-1860,0,800],0],
    [[-30,0,64,0,0,0,0,0,0,0,0,0,-24,0,0,0,-30],54],
    [[20],76],[[-20],38],
    [[6,0,0,0,30,0,-88,0,72,0,0,0,-12,0,0,0,24,0,-24,
    0,3],12],[[-9,0,6,0,-8],38],
    [[178,0,-724,0,974,0,-524,0,98],0],
    [[-4,0,4,0,-8,0,8,0,-2],38],
    [[44,0,0,0,-312,0,448,0,-204,0,0,0,8],0],
    [[16],60],
    [[-2,0,-2,0,24,0,-22,0,-38,0,66,0,-24,0,-10,0,8],6]
    ,[[143,0,-554,0,730,0,-386,0,67],0],
    [[1,0,-2,0,0,0,-44,0,148,0,-116,0,-120,0,223,0,-71,
    0,-64,0,54,0,-9],0],[[],0],
    [[8,0,-68,0,184,0,-220,0,122,0,-28,0,2],0],
    [[60,0,-240,0,300,0,-140,0,20],0],[[],0],
    [[],0],[[],0],
    [[4,0,-15,0,10,0,-84,0,357,0,-431,0,-1,0,214,0,79,0,
    -282,0,171,0,-36,0,4,0,-2],0],
    [[44,0,-152,0,196,0,-84,0,8],0],
    [[-2,0,2,0,2,0,0,0,-2],38],
    [[268,0,-1052,0,1448,0,-816,0,156],0],
    [[-7,0,30,0,-9,0,-62,0,67,0,-18,0,-9,0,6,0,-2],6],
    [[],0],[[-6,0,2,0,24,0,-24,0,8,0,-1],6],
    [[-1,0,0,0,0,0,-2,0,-2,0,2],38],
    [[-3,0,9,0,6,0,-31,0,33,0,-15,0,1],6],
    [[4,0,-36,0,99,0,-115,0,59,0,-11],0],
    [[42,0,-270,0,672,0,-830,0,520,0,-150,0,14],0],
    [[-2,0,-4,0,34,0,-38,0,14,0,-2],4],[[],0],
    [[3,0,-28,0,80,0,-93,0,46,0,-8],0],
    [[-7,0,26,0,-30,0,12,0,-1],2],[[],0],
    [[1,0,-11,0,34,0,-40,0,17,0,-1],0],
    [[-6,0,22,0,-26,0,10],4],[[],0],
    [[-3,0,11,0,-12,0,3],4],[[1],18],[[-1],28],
    [[1],14],
    [[12,0,-86,0,218,0,-260,0,148,0,-34,0,2],0],
    [[-1,0,8,0,-9,0,2],2],[[],0],
    [[4,0,-15,0,-41,0,191,0,-252,0,128,0,-17,0,-2],0],
    [[2,0,0,0,2],42],[[2],22],[[-2],20],
    [[4,0,-6,0,1],4],[[-1,0,2],20],
    [[20,0,-137,0,351,0,-425,0,252,0,-66,0,5],0],
    [[1,0,-2,0,-26,0,89,0,-106,0,51,0,-7],0],[[],0],
    [[7,0,-55,0,150,0,-178,0,96,0,-21,0,1],0],
    [[],0],[[],0],[[],0],[[-2940,0,2660],0],
    [[-378,0,189,0,0,0,595,0,-594,0,378,0,-504,0,0,0,0,
    0,189,0,0,0,405],48],
    [[-776,0,2232,0,-2028,0,564],0],
    [[-19,0,25,0,0,0,288,0,-788,0,468,0,368,0,-288,0,
    -351,0,453,0,-144,0,0,0,-6,0,2],0],
    [[-300,0,780,0,-640,0,160],0],
    [[1,0,0,0,0,0,28,0,-22,0,-16,0,4,0,-95,0,268,0,
    -218,0,50,0,-19,0,15,0,4],14],
    [[-3,0,0,0,0,0,99,0,-198,0,21,0,238,0,-197,0,-21,0,
    89,0,-28],0],
    [[-19,0,25,0,156,0,-392,0,329,0,-87,0,-6,0,2],0],
    [[2,0,-3,0,-12,0,15,0,0,0,-3,0,-10,0,3],24],
    [[-1,0,3,0,9,0,-10,0,-12,0,18,0,-4,0,-3],12],
    [[-68,0,350,0,-660,0,564,0,-212,0,26],0],
    [[-540,0,1520,0,-1320,0,360],0],
    [[-1,0,0,0,5,0,0,0,-10,0,-9,0,-10,0,50,0,-51,0,10,
    0,-5,0,0,0,0,0,1],16],
    [[-2,0,4,0,-12,0,58,0,-84,0,36,0,9,0,-3,0,-18,0,22,
    0,-11],12],[[-9,0,1,0,0,0,9],16],
    [[-132,0,668,0,-1276,0,1140,0,-460,0,64],0],
    [[-19,0,97,0,-183,0,141,0,-42,0,2],0],
    [[-87,0,453,0,-871,0,755,0,-293,0,39],0],
    [[-4,0,9,0,-2,0,0,0,-3,0,4],16],
    [[-1,0,5,0,-5,0,-1,0,-1,0,3,0,0,0,1],16],
    [[2,0,-4,0,-10,0,25,0,-17,0,3],6],
    [[-7,0,53,0,-104,0,74,0,-19,0,1],0],
    [[1,0,-5,0,3,0,19,0,-34,0,24,0,-6],6],
    [[-3,0,21,0,-45,0,31,0,-4],0],
    [[-2,0,3,0,12,0,-19,0,8,0,-1,0,-2,0,1],8],
    [[1,0,-1,0,-1,0,1],14],[[-4,0,9,0,-6,0,1],4],
    [[-27,0,149,0,-280,0,224,0,-73,0,7],0],
    [[-1,0,3,0,-2,0,1,0,-1],10],
    [[1,0,-1,0,11,0,-59,0,93,0,6,0,-127,0,89,0,15,0,
    -42,0,15,0,-1],2],
    [[-3,0,0,0,56,0,-118,0,85,0,-20],0],
    [[-42,0,237,0,-453,0,375,0,-133,0,16],0],
    [[-2,0,5,0,7,0,-20,0,10,0,1,0,-1],10],
    [[1,0,6,0,-38,0,70,0,-54,0,16,0,-1],2],
    [[-1,0,2,0,-1],4],[[-2,0,5,0,-4],4],
    [[-1,0,3,0,-1],8],[[3,0,-16,0,29,0,-22,0,6],2],
    [[1,0,-1],8],[[1,0,-7,0,12,0,-8,0,1],4],
    [[1],6],[[-1,0,13,0,-52,0,89,0,-72,0,26,0,-3],0],
    [[-2,0,6,0,-4],6],[[3,0,-15,0,27,0,-20,0,5],2],
    [[-5,0,10,0,-6,0,1],8],
    [[-3,0,30,0,-102,0,168,0,-141,0,56,0,-8],0],
    [[-2,0,3,0,-1],10]]];

CHEVIE.E8.vcycpolschurelms:=
[ [ [ 0, 0, 8, 4, 4, 2, 4, 1, 2, 1, 2, 0, 2, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 
          1, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -120, 0, 8, 4, 4, 2, 4, 1, 2, 1, 2, 0, 2, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 
          0, 1, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -3, 0, 8, 4, 2, 2, 4, 0, 1, 1, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -63, 0, 8, 4, 2, 2, 4, 0, 1, 1, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -2, 0, 8, 4, 4, 1, 4, 0, 2, 1, 1, 0, 2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
          0, 1 ], 1 ], 
  [ [ -74, 0, 8, 4, 4, 1, 4, 0, 2, 1, 1, 0, 2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
          0, 1 ], 1 ], 
  [ [ -16, 0, 8, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 0, 0, 0, 1 ], 30 ], 
  [ [ -4, 0, 8, 4, 4, 0, 4, 1, 0, 1, 1, 0, 2 ], 2 ], 
  [ [ -52, 0, 8, 4, 4, 0, 4, 1, 0, 1, 1, 0, 2 ], 2 ], 
  [ [ -3, 0, 8, 4, 2, 2, 4, 0, 1, 0, 2, 0, 1, 0, 0, 1, 0, 0, 1 ], 2 ], 
  [ [ -63, 0, 8, 4, 2, 2, 4, 0, 1, 0, 2, 0, 1, 0, 0, 1, 0, 0, 1 ], 2 ], 
  [ [ -16, 0, 8, 4, 0, 2, 4 ], 8 ], [ [ -8, 0, 8, 4, 4, 0, 4, 0, 2 ], 3 ], 
  [ [ -32, 0, 8, 4, 4, 0, 4, 0, 2 ], 3 ], 
  [ [ -4, 0, 8, 4, 4, 1, 4, 0, 0, 0, 0, 0, 2, 0, 1, 0, 0, 0, 1 ], 2 ], 
  [ [ -52, 0, 8, 4, 4, 1, 4, 0, 0, 0, 0, 0, 2, 0, 1, 0, 0, 0, 1 ], 2 ], 
  [ [ -16, 0, 8, 4, 4, 0, 4 ], 5 ], 
  [ [ -6, 0, 8, 4, 2, 0, 4, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -42, 0, 8, 4, 2, 0, 4, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -8, 0, 8, 4, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 1 ], 6 ], 
  [ [ -32, 0, 8, 4, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 1 ], 6 ], [ [ -12, 0, 8, 4, 4, 0, 4, 0, 2, 0, 0, 0, 2 ], 1 ], 
  [ [ -36, 0, 8, 4, 4, 0, 4, 0, 2, 0, 0, 0, 2 ], 1 ], 
  [ [ -6, 0, 8, 1, 4, 2, 1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -46, 0, 8, 1, 4, 2, 1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -16, 0, 8, 0, 4, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ -13, 0, 8, 4, 2, 0, 4, 0, 1, 1 ], 2 ], 
  [ [ -25, 0, 8, 4, 2, 0, 4, 0, 1, 1 ], 2 ], 
  [ [ -6, 0, 8, 4, 2, 0, 4, 0, 1, 1, 0, 0, 1, 0, 1 ], 2 ], 
  [ [ -42, 0, 8, 4, 2, 0, 4, 0, 1, 1, 0, 0, 1, 0, 1 ], 2 ], 
  [ [ -16, 0, 8, 4, 0, 0, 0, 0, 0, 0, 2, 0, 2 ], 24 ], 
  [ [ -12, 0, 8, 4, 2, 1, 4, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -24, 0, 8, 4, 2, 1, 4, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -16, 0, 8, 4, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 20 ],
  [ [ -10, 0, 8, 0, 2, 2, 1, 1, 1, 0, 2 ], 2 ], 
  [ [ -30, 0, 8, 0, 2, 2, 1, 1, 1, 0, 2 ], 2 ], 
  [ [ -8, 0, 8, 4, 4, 0, 4, 0, 0, 0, 0, 0, 2 ], 2 ], 
  [ [ -32, 0, 8, 4, 4, 0, 4, 0, 0, 0, 0, 0, 2 ], 2 ], 
  [ [ -20, 0, 8, 4, 4, 0, 4, 0, 0, 0, 0, 0, 2 ], 1 ], 
  [ [ -7, 0, 4, 4, 2, 2, 2, 0, 1, 0, 0, 0, 1, 0, 0, 1 ], 2 ], 
  [ [ -37, 0, 4, 4, 2, 2, 2, 0, 1, 0, 0, 0, 1, 0, 0, 1 ], 2 ], 
  [ [ -16, 0, 0, 4, 4, 2, 0, 0, 0, 0, 0, 0, 2 ], 8 ], 
  [ [ -8, 0, 8, 4, 0, 0, 4, 0, 2, 0, 0, 0, 2 ], 6 ], 
  [ [ -32, 0, 8, 4, 0, 0, 4, 0, 2, 0, 0, 0, 2 ], 6 ], 
  [ [ -8, 0, 8, 1, 4, 0, 1, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 3 ], 
  [ [ -32, 0, 8, 1, 4, 0, 1, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 3 ], 
  [ [ -16, 0, 8, 1, 4, 0, 0, 0, 0, 1, 2 ], 6 ], 
  [ [ -13, 0, 8, 4, 2, 0, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -25, 0, 8, 4, 2, 0, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -16, 0, 8, 4, 0, 0, 4, 0, 0, 0, 2 ], 8 ], 
  [ [ -10, 0, 4, 4, 2, 1, 2, 0, 1, 1, 0, 0, 1 ], 2 ], 
  [ [ -28, 0, 4, 4, 2, 1, 2, 0, 1, 1, 0, 0, 1 ], 2 ], 
  [ [ -16, 0, 0, 4, 4, 0, 4, 0, 0, 0, 2 ], 120 ], 
  [ [ -10, 0, 8, 1, 2, 2, 0, 0, 1, 0, 2, 0, 0, 0, 1 ], 2 ], 
  [ [ -30, 0, 8, 1, 2, 2, 0, 0, 1, 0, 2, 0, 0, 0, 1 ], 2 ], 
  [ [ -16, 0, 8, 0, 0, 2, 4, 0, 0, 0, 0, 0, 2 ], 24 ], 
  [ [ -14, 0, 8, 1, 4, 1, 1, 0, 2, 0, 1 ], 1 ], 
  [ [ -22, 0, 8, 1, 4, 1, 1, 0, 2, 0, 1 ], 1 ], 
  [ [ -16, 0, 8, 0, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 30 ], 
  [ [ -15, 0, 4, 4, 2, 0, 2, 1, 0, 1, 0, 0, 1 ], 2 ], 
  [ [ -21, 0, 4, 4, 2, 0, 2, 1, 0, 1, 0, 0, 1 ], 2 ], 
  [ [ -11, 0, 1, 4, 0, 2, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -26, 0, 1, 4, 0, 2, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -12, 0, 8, 4, 2, 0, 4, 0, 0, 0, 1, 0, 1 ], 2 ], 
  [ [ -24, 0, 8, 4, 2, 0, 4, 0, 0, 0, 1, 0, 1 ], 2 ], 
  [ [ -14, 0, 8, 0, 4, 0, 0, 1, 2, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -22, 0, 8, 0, 4, 0, 0, 1, 2, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -1, 0, 8, 4, 2, 2, 4, 1, 1, 1, 2, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 
          0, 0, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -91, 0, 8, 4, 2, 2, 4, 1, 1, 1, 2, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 
          0, 0, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -7, 0, 8, 4, 2, 2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ -37, 0, 8, 4, 2, 2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ -3, 0, 4, 4, 4, 2, 2, 0, 1, 1, 0, 0, 2, 0, 0, 1, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -63, 0, 4, 4, 4, 2, 2, 0, 1, 1, 0, 0, 2, 0, 0, 1, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -4, 0, 4, 4, 2, 1, 2, 1, 2, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 1 ], 2 ], 
  [ [ -52, 0, 4, 4, 2, 1, 2, 1, 2, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 1 ], 2 ], 
  [ [ -16, 0, 4, 4, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 1 ], 12 ], [ [ -6, 0, 4, 4, 4, 0, 2, 1, 1, 1, 0, 0, 2 ], 2 ], 
  [ [ -42, 0, 4, 4, 4, 0, 2, 1, 1, 1, 0, 0, 2 ], 2 ], 
  [ [ -7, 0, 8, 4, 0, 2, 4, 0, 0, 0, 2, 0, 1 ], 3 ], 
  [ [ -37, 0, 8, 4, 0, 2, 4, 0, 0, 0, 2, 0, 1 ], 3 ], 
  [ [ -5, 0, 8, 4, 2, 1, 4, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -47, 0, 8, 4, 2, 1, 4, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -16, 0, 4, 4, 2, 2, 2, 0, 0, 0, 0, 0, 1 ], 4 ], 
  [ [ -10, 0, 8, 4, 2, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -28, 0, 8, 4, 2, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -7, 0, 8, 1, 2, 2, 1, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 1 ], 3 ], 
  [ [ -37, 0, 8, 1, 2, 2, 1, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 1 ], 3 ], 
  [ [ -16, 0, 4, 1, 2, 2, 0, 0, 2, 1 ], 6 ], 
  [ [ -10, 0, 4, 1, 4, 2, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -30, 0, 4, 1, 4, 2, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -10, 0, 8, 4, 2, 0, 4, 0, 0, 1, 1 ], 2 ], 
  [ [ -28, 0, 8, 4, 2, 0, 4, 0, 0, 1, 1 ], 2 ], 
  [ [ -7, 0, 8, 4, 2, 0, 4, 0, 0, 0, 2, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ -37, 0, 8, 4, 2, 0, 4, 0, 0, 0, 2, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ -15, 0, 8, 4, 0, 0, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -21, 0, 8, 4, 0, 0, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -13, 0, 4, 4, 4, 0, 0, 0, 1, 1, 0, 0, 2 ], 2 ], 
  [ [ -25, 0, 4, 4, 4, 0, 0, 0, 1, 1, 0, 0, 2 ], 2 ], 
  [ [ -16, 0, 4, 4, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ -9, 0, 8, 1, 2, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -31, 0, 8, 1, 2, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -12, 0, 4, 4, 4, 1, 2, 0, 0, 0, 0, 0, 2 ], 2 ], 
  [ [ -24, 0, 4, 4, 4, 1, 2, 0, 0, 0, 0, 0, 2 ], 2 ], 
  [ [ -16, 0, 0, 4, 0, 2, 2, 0, 2, 0, 0, 0, 1 ], 12 ], 
  [ [ -11, 0, 1, 4, 0, 2, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -26, 0, 1, 4, 0, 2, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -15, 0, 8, 4, 2, 0, 4, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -21, 0, 8, 4, 2, 0, 4, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -13, 0, 8, 1, 2, 2, 1, 0, 1, 0, 2 ], 1 ], 
  [ [ -23, 0, 8, 1, 2, 2, 1, 0, 1, 0, 2 ], 1 ], 
  [ [ -15, 0, 8, 4, 0, 0, 4, 0, 0, 1, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -21, 0, 8, 4, 0, 0, 4, 0, 0, 1, 0, 0, 0, 0, 1 ], 2 ] ];

CHEVIE.E8.vpolfakedegrees:=
[ [ [ 1 ], 0 ], [ [ 1 ], 120 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 2, 0, 2, 0, 0, 0, 3, 0, 1, 0, 1, 0, 4, 0, 
          1, 0, 1, 0, 3, 0, 0, 0, 2, 0, 2, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1 ], 8 ]
    , 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 2, 0, 2, 0, 0, 0, 3, 0, 1, 0, 1, 0, 4, 0, 
          1, 0, 1, 0, 3, 0, 0, 0, 2, 0, 2, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1 ], 68 
     ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 1, 0, 3, 0, 2, 0, 2, 0, 3, 0, 
          2, 0, 2, 0, 3, 0, 1, 0, 2, 0, 2, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 2 ]
    , 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 1, 0, 3, 0, 2, 0, 2, 0, 3, 0, 
          2, 0, 2, 0, 3, 0, 1, 0, 2, 0, 2, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 74 
     ], 
  [ [ 1, 0, 0, 0, 1, 0, 2, 0, 1, 0, 2, 0, 3, 0, 0, 0, 5, 0, 4, 0, 1, 0, 6, 0, 
          3, 0, 2, 0, 8, 0, 2, 0, 3, 0, 6, 0, 1, 0, 4, 0, 5, 0, 0, 0, 3, 0, 
          2, 0, 1, 0, 2, 0, 1, 0, 0, 0, 1 ], 32 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 2, 0, 2, 0, 3, 0, 
          3, 0, 2, 0, 4, 0, 2, 0, 3, 0, 3, 0, 2, 0, 2, 0, 3, 0, 1, 0, 2, 0, 
          1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 8 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 2, 0, 2, 0, 3, 0, 
          3, 0, 2, 0, 4, 0, 2, 0, 3, 0, 3, 0, 2, 0, 2, 0, 3, 0, 1, 0, 2, 0, 
          1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 56 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 2, 0, 4, 0, 3, 0, 4, 0, 5, 0, 4, 0, 5, 0, 
          6, 0, 4, 0, 6, 0, 5, 0, 4, 0, 5, 0, 4, 0, 3, 0, 4, 0, 2, 0, 2, 0, 
          2, 0, 1, 0, 1, 0, 1 ], 4 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 2, 0, 4, 0, 3, 0, 4, 0, 5, 0, 4, 0, 5, 0, 
          6, 0, 4, 0, 6, 0, 5, 0, 4, 0, 5, 0, 4, 0, 3, 0, 4, 0, 2, 0, 2, 0, 
          2, 0, 1, 0, 1, 0, 1 ], 64 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 3, 0, 4, 0, 4, 0, 6, 0, 4, 0, 
          9, 0, 7, 0, 7, 0, 9, 0, 9, 0, 7, 0, 12, 0, 7, 0, 9, 0, 9, 0, 7, 0, 
          7, 0, 9, 0, 4, 0, 6, 0, 4, 0, 4, 0, 3, 0, 3, 0, 1, 0, 2, 0, 1, 0, 
          1, 0, 0, 0, 1 ], 24 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 2, 0, 3, 0, 2, 0, 5, 0, 4, 0, 5, 0, 7, 0, 
          7, 0, 7, 0, 10, 0, 7, 0, 10, 0, 10, 0, 9, 0, 10, 0, 10, 0, 7, 0, 
          10, 0, 7, 0, 7, 0, 7, 0, 5, 0, 4, 0, 5, 0, 2, 0, 3, 0, 2, 0, 1, 0, 
          1, 0, 1, 0, 0, 0, 1 ], 12 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 2, 0, 3, 0, 2, 0, 5, 0, 4, 0, 5, 0, 7, 0, 
          7, 0, 7, 0, 10, 0, 7, 0, 10, 0, 10, 0, 9, 0, 10, 0, 10, 0, 7, 0, 
          10, 0, 7, 0, 7, 0, 7, 0, 5, 0, 4, 0, 5, 0, 2, 0, 3, 0, 2, 0, 1, 0, 
          1, 0, 1, 0, 0, 0, 1 ], 36 ], 
  [ [ 1, 0, 0, 0, 1, 0, 2, 0, 2, 0, 3, 0, 5, 0, 4, 0, 7, 0, 8, 0, 8, 0, 10, 
          0, 12, 0, 10, 0, 13, 0, 13, 0, 12, 0, 13, 0, 13, 0, 10, 0, 12, 0, 
          10, 0, 8, 0, 8, 0, 7, 0, 4, 0, 5, 0, 3, 0, 2, 0, 2, 0, 1, 0, 0, 0, 
          1 ], 4 ], 
  [ [ 1, 0, 0, 0, 1, 0, 2, 0, 2, 0, 3, 0, 5, 0, 4, 0, 7, 0, 8, 0, 8, 0, 10, 
          0, 12, 0, 10, 0, 13, 0, 13, 0, 12, 0, 13, 0, 13, 0, 10, 0, 12, 0, 
          10, 0, 8, 0, 8, 0, 7, 0, 4, 0, 5, 0, 3, 0, 2, 0, 2, 0, 1, 0, 0, 0, 
          1 ], 52 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 2, 0, 2, 0, 5, 0, 3, 0, 7, 0, 8, 0, 9, 0, 11, 
          0, 15, 0, 11, 0, 20, 0, 18, 0, 18, 0, 23, 0, 22, 0, 19, 0, 28, 0, 
          19, 0, 22, 0, 23, 0, 18, 0, 18, 0, 20, 0, 11, 0, 15, 0, 11, 0, 9, 
          0, 8, 0, 7, 0, 3, 0, 5, 0, 2, 0, 2, 0, 1, 0, 1, 0, 0, 0, 1 ], 20 ], 
  [ [ 1, 0, 0, 0, 2, 0, 2, 0, 2, 0, 4, 0, 6, 0, 4, 0, 10, 0, 9, 0, 9, 0, 14, 
          0, 14, 0, 12, 0, 20, 0, 15, 0, 16, 0, 20, 0, 16, 0, 15, 0, 20, 0, 
          12, 0, 14, 0, 14, 0, 9, 0, 9, 0, 10, 0, 4, 0, 6, 0, 4, 0, 2, 0, 2, 
          0, 2, 0, 0, 0, 1 ], 8 ], 
  [ [ 1, 0, 0, 0, 2, 0, 2, 0, 2, 0, 4, 0, 6, 0, 4, 0, 10, 0, 9, 0, 9, 0, 14, 
          0, 14, 0, 12, 0, 20, 0, 15, 0, 16, 0, 20, 0, 16, 0, 15, 0, 20, 0, 
          12, 0, 14, 0, 14, 0, 9, 0, 9, 0, 10, 0, 4, 0, 6, 0, 4, 0, 2, 0, 2, 
          0, 2, 0, 0, 0, 1 ], 44 ], 
  [ [ 1, 0, 0, 0, 2, 0, 3, 0, 2, 0, 5, 0, 7, 0, 5, 0, 11, 0, 11, 0, 10, 0, 
          17, 0, 16, 0, 14, 0, 23, 0, 18, 0, 18, 0, 24, 0, 18, 0, 18, 0, 23, 
          0, 14, 0, 16, 0, 17, 0, 10, 0, 11, 0, 11, 0, 5, 0, 7, 0, 5, 0, 2, 
          0, 3, 0, 2, 0, 0, 0, 1 ], 14 ], 
  [ [ 1, 0, 0, 0, 2, 0, 3, 0, 2, 0, 5, 0, 7, 0, 5, 0, 11, 0, 11, 0, 10, 0, 
          17, 0, 16, 0, 14, 0, 23, 0, 18, 0, 18, 0, 24, 0, 18, 0, 18, 0, 23, 
          0, 14, 0, 16, 0, 17, 0, 10, 0, 11, 0, 11, 0, 5, 0, 7, 0, 5, 0, 2, 
          0, 3, 0, 2, 0, 0, 0, 1 ], 38 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 4, 0, 4, 0, 8, 0, 9, 0, 10, 0, 15, 0, 16, 0, 
          17, 0, 24, 0, 23, 0, 24, 0, 30, 0, 28, 0, 28, 0, 33, 0, 28, 0, 28, 
          0, 30, 0, 24, 0, 23, 0, 24, 0, 17, 0, 16, 0, 15, 0, 10, 0, 9, 0, 8, 
          0, 4, 0, 4, 0, 3, 0, 1, 0, 1, 0, 1 ], 12 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 4, 0, 4, 0, 8, 0, 9, 0, 10, 0, 15, 0, 16, 0, 
          17, 0, 24, 0, 23, 0, 24, 0, 30, 0, 28, 0, 28, 0, 33, 0, 28, 0, 28, 
          0, 30, 0, 24, 0, 23, 0, 24, 0, 17, 0, 16, 0, 15, 0, 10, 0, 9, 0, 8, 
          0, 4, 0, 4, 0, 3, 0, 1, 0, 1, 0, 1 ], 36 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 5, 0, 7, 0, 9, 0, 11, 0, 15, 0, 17, 0, 21, 0, 
          23, 0, 26, 0, 29, 0, 31, 0, 32, 0, 34, 0, 33, 0, 34, 0, 32, 0, 31, 
          0, 29, 0, 26, 0, 23, 0, 21, 0, 17, 0, 15, 0, 11, 0, 9, 0, 7, 0, 5, 
          0, 3, 0, 2, 0, 1, 0, 1 ], 6 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 5, 0, 7, 0, 9, 0, 11, 0, 15, 0, 17, 0, 21, 0, 
          23, 0, 26, 0, 29, 0, 31, 0, 32, 0, 34, 0, 33, 0, 34, 0, 32, 0, 31, 
          0, 29, 0, 26, 0, 23, 0, 21, 0, 17, 0, 15, 0, 11, 0, 9, 0, 7, 0, 5, 
          0, 3, 0, 2, 0, 1, 0, 1 ], 46 ], 
  [ [ 1, 0, 0, 0, 2, 0, 3, 0, 3, 0, 7, 0, 11, 0, 8, 0, 18, 0, 21, 0, 21, 0, 
          33, 0, 37, 0, 33, 0, 53, 0, 49, 0, 49, 0, 66, 0, 59, 0, 56, 0, 74, 
          0, 56, 0, 59, 0, 66, 0, 49, 0, 49, 0, 53, 0, 33, 0, 37, 0, 33, 0, 
          21, 0, 21, 0, 18, 0, 8, 0, 11, 0, 7, 0, 3, 0, 3, 0, 2, 0, 0, 0, 1 ],
      20 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 9, 0, 9, 0, 13, 0, 16, 0, 18, 0, 
          21, 0, 27, 0, 26, 0, 32, 0, 34, 0, 34, 0, 37, 0, 40, 0, 36, 0, 40, 
          0, 37, 0, 34, 0, 34, 0, 32, 0, 26, 0, 27, 0, 21, 0, 18, 0, 16, 0, 
          13, 0, 9, 0, 9, 0, 5, 0, 4, 0, 3, 0, 2, 0, 1, 0, 1 ], 16 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 9, 0, 9, 0, 13, 0, 16, 0, 18, 0, 
          21, 0, 27, 0, 26, 0, 32, 0, 34, 0, 34, 0, 37, 0, 40, 0, 36, 0, 40, 
          0, 37, 0, 34, 0, 34, 0, 32, 0, 26, 0, 27, 0, 21, 0, 18, 0, 16, 0, 
          13, 0, 9, 0, 9, 0, 5, 0, 4, 0, 3, 0, 2, 0, 1, 0, 1 ], 28 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 5, 0, 6, 0, 10, 0, 11, 0, 15, 0, 18, 0, 22, 0, 
          24, 0, 30, 0, 31, 0, 35, 0, 37, 0, 39, 0, 39, 0, 42, 0, 39, 0, 39, 
          0, 37, 0, 35, 0, 31, 0, 30, 0, 24, 0, 22, 0, 18, 0, 15, 0, 11, 0, 
          10, 0, 6, 0, 5, 0, 3, 0, 2, 0, 1, 0, 1 ], 6 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 5, 0, 6, 0, 10, 0, 11, 0, 15, 0, 18, 0, 22, 0, 
          24, 0, 30, 0, 31, 0, 35, 0, 37, 0, 39, 0, 39, 0, 42, 0, 39, 0, 39, 
          0, 37, 0, 35, 0, 31, 0, 30, 0, 24, 0, 22, 0, 18, 0, 15, 0, 11, 0, 
          10, 0, 6, 0, 5, 0, 3, 0, 2, 0, 1, 0, 1 ], 42 ], 
  [ [ 1, 0, 0, 0, 3, 0, 3, 0, 4, 0, 8, 0, 12, 0, 11, 0, 22, 0, 24, 0, 28, 0, 
          39, 0, 44, 0, 45, 0, 63, 0, 60, 0, 65, 0, 77, 0, 75, 0, 73, 0, 86, 
          0, 73, 0, 75, 0, 77, 0, 65, 0, 60, 0, 63, 0, 45, 0, 44, 0, 39, 0, 
          28, 0, 24, 0, 22, 0, 11, 0, 12, 0, 8, 0, 4, 0, 3, 0, 3, 0, 0, 0, 1 ]
        , 20 ], 
  [ [ 1, 0, 0, 0, 2, 0, 2, 0, 3, 0, 5, 0, 8, 0, 7, 0, 14, 0, 14, 0, 18, 0, 
          23, 0, 27, 0, 27, 0, 37, 0, 35, 0, 40, 0, 44, 0, 45, 0, 43, 0, 50, 
          0, 43, 0, 45, 0, 44, 0, 40, 0, 35, 0, 37, 0, 27, 0, 27, 0, 23, 0, 
          18, 0, 14, 0, 14, 0, 7, 0, 8, 0, 5, 0, 3, 0, 2, 0, 2, 0, 0, 0, 1 ], 
      14 ], 
  [ [ 1, 0, 0, 0, 2, 0, 2, 0, 3, 0, 5, 0, 8, 0, 7, 0, 14, 0, 14, 0, 18, 0, 
          23, 0, 27, 0, 27, 0, 37, 0, 35, 0, 40, 0, 44, 0, 45, 0, 43, 0, 50, 
          0, 43, 0, 45, 0, 44, 0, 40, 0, 35, 0, 37, 0, 27, 0, 27, 0, 23, 0, 
          18, 0, 14, 0, 14, 0, 7, 0, 8, 0, 5, 0, 3, 0, 2, 0, 2, 0, 0, 0, 1 ], 
      26 ], 
  [ [ 1, 0, 2, 0, 4, 0, 5, 0, 9, 0, 12, 0, 17, 0, 23, 0, 29, 0, 35, 0, 45, 0, 
          51, 0, 61, 0, 68, 0, 75, 0, 82, 0, 88, 0, 91, 0, 95, 0, 94, 0, 95, 
          0, 91, 0, 88, 0, 82, 0, 75, 0, 68, 0, 61, 0, 51, 0, 45, 0, 35, 0, 
          29, 0, 23, 0, 17, 0, 12, 0, 9, 0, 5, 0, 4, 0, 2, 0, 1 ], 22 ], 
  [ [ 1, 0, 1, 0, 3, 0, 3, 0, 6, 0, 7, 0, 11, 0, 13, 0, 18, 0, 20, 0, 27, 0, 
          29, 0, 36, 0, 38, 0, 44, 0, 46, 0, 51, 0, 51, 0, 55, 0, 52, 0, 55, 
          0, 51, 0, 51, 0, 46, 0, 44, 0, 38, 0, 36, 0, 29, 0, 27, 0, 20, 0, 
          18, 0, 13, 0, 11, 0, 7, 0, 6, 0, 3, 0, 3, 0, 1, 0, 1 ], 12 ], 
  [ [ 1, 0, 1, 0, 3, 0, 3, 0, 6, 0, 7, 0, 11, 0, 13, 0, 18, 0, 20, 0, 27, 0, 
          29, 0, 36, 0, 38, 0, 44, 0, 46, 0, 51, 0, 51, 0, 55, 0, 52, 0, 55, 
          0, 51, 0, 51, 0, 46, 0, 44, 0, 38, 0, 36, 0, 29, 0, 27, 0, 20, 0, 
          18, 0, 13, 0, 11, 0, 7, 0, 6, 0, 3, 0, 3, 0, 1, 0, 1 ], 32 ], 
  [ [ 1, 0, 1, 0, 3, 0, 3, 0, 6, 0, 8, 0, 11, 0, 14, 0, 20, 0, 21, 0, 29, 0, 
          32, 0, 37, 0, 43, 0, 48, 0, 48, 0, 57, 0, 55, 0, 58, 0, 60, 0, 58, 
          0, 55, 0, 57, 0, 48, 0, 48, 0, 43, 0, 37, 0, 32, 0, 29, 0, 21, 0, 
          20, 0, 14, 0, 11, 0, 8, 0, 6, 0, 3, 0, 3, 0, 1, 0, 1 ], 10 ], 
  [ [ 1, 0, 1, 0, 3, 0, 3, 0, 6, 0, 8, 0, 11, 0, 14, 0, 20, 0, 21, 0, 29, 0, 
          32, 0, 37, 0, 43, 0, 48, 0, 48, 0, 57, 0, 55, 0, 58, 0, 60, 0, 58, 
          0, 55, 0, 57, 0, 48, 0, 48, 0, 43, 0, 37, 0, 32, 0, 29, 0, 21, 0, 
          20, 0, 14, 0, 11, 0, 8, 0, 6, 0, 3, 0, 3, 0, 1, 0, 1 ], 34 ], 
  [ [ 1, 0, 1, 0, 3, 0, 5, 0, 7, 0, 11, 0, 17, 0, 20, 0, 30, 0, 37, 0, 44, 0, 
          56, 0, 66, 0, 72, 0, 88, 0, 93, 0, 100, 0, 111, 0, 113, 0, 114, 0, 
          122, 0, 114, 0, 113, 0, 111, 0, 100, 0, 93, 0, 88, 0, 72, 0, 66, 0, 
          56, 0, 44, 0, 37, 0, 30, 0, 20, 0, 17, 0, 11, 0, 7, 0, 5, 0, 3, 0, 
          1, 0, 1 ], 20 ], 
  [ [ 1, 0, 2, 0, 3, 0, 5, 0, 8, 0, 11, 0, 15, 0, 21, 0, 25, 0, 31, 0, 40, 0, 
          44, 0, 51, 0, 60, 0, 61, 0, 69, 0, 75, 0, 72, 0, 78, 0, 78, 0, 72, 
          0, 75, 0, 69, 0, 61, 0, 60, 0, 51, 0, 44, 0, 40, 0, 31, 0, 25, 0, 
          21, 0, 15, 0, 11, 0, 8, 0, 5, 0, 3, 0, 2, 0, 1 ], 8 ], 
  [ [ 1, 0, 2, 0, 3, 0, 5, 0, 8, 0, 11, 0, 15, 0, 21, 0, 25, 0, 31, 0, 40, 0, 
          44, 0, 51, 0, 60, 0, 61, 0, 69, 0, 75, 0, 72, 0, 78, 0, 78, 0, 72, 
          0, 75, 0, 69, 0, 61, 0, 60, 0, 51, 0, 44, 0, 40, 0, 31, 0, 25, 0, 
          21, 0, 15, 0, 11, 0, 8, 0, 5, 0, 3, 0, 2, 0, 1 ], 38 ], 
  [ [ 2, 0, 1, 0, 5, 0, 7, 0, 10, 0, 15, 0, 24, 0, 25, 0, 41, 0, 48, 0, 57, 
          0, 72, 0, 86, 0, 89, 0, 115, 0, 117, 0, 126, 0, 141, 0, 143, 0, 
          141, 0, 158, 0, 141, 0, 143, 0, 141, 0, 126, 0, 117, 0, 115, 0, 89, 
          0, 86, 0, 72, 0, 57, 0, 48, 0, 41, 0, 25, 0, 24, 0, 15, 0, 10, 0, 
          7, 0, 5, 0, 1, 0, 2 ], 20 ], 
  [ [ 1, 0, 0, 0, 2, 0, 3, 0, 4, 0, 7, 0, 12, 0, 11, 0, 21, 0, 24, 0, 28, 0, 
          38, 0, 45, 0, 45, 0, 62, 0, 61, 0, 66, 0, 77, 0, 76, 0, 74, 0, 86, 
          0, 74, 0, 76, 0, 77, 0, 66, 0, 61, 0, 62, 0, 45, 0, 45, 0, 38, 0, 
          28, 0, 24, 0, 21, 0, 11, 0, 12, 0, 7, 0, 4, 0, 3, 0, 2, 0, 0, 0, 1 ]
        , 8 ], 
  [ [ 1, 0, 0, 0, 2, 0, 3, 0, 4, 0, 7, 0, 12, 0, 11, 0, 21, 0, 24, 0, 28, 0, 
          38, 0, 45, 0, 45, 0, 62, 0, 61, 0, 66, 0, 77, 0, 76, 0, 74, 0, 86, 
          0, 74, 0, 76, 0, 77, 0, 66, 0, 61, 0, 62, 0, 45, 0, 45, 0, 38, 0, 
          28, 0, 24, 0, 21, 0, 11, 0, 12, 0, 7, 0, 4, 0, 3, 0, 2, 0, 0, 0, 1 ]
        , 32 ], 
  [ [ 1, 0, 2, 0, 2, 0, 6, 0, 7, 0, 10, 0, 17, 0, 20, 0, 25, 0, 37, 0, 38, 0, 
          48, 0, 60, 0, 61, 0, 71, 0, 82, 0, 77, 0, 89, 0, 92, 0, 85, 0, 92, 
          0, 89, 0, 77, 0, 82, 0, 71, 0, 61, 0, 60, 0, 48, 0, 38, 0, 37, 0, 
          25, 0, 20, 0, 17, 0, 10, 0, 7, 0, 6, 0, 2, 0, 2, 0, 1 ], 10 ], 
  [ [ 1, 0, 2, 0, 2, 0, 6, 0, 7, 0, 10, 0, 17, 0, 20, 0, 25, 0, 37, 0, 38, 0, 
          48, 0, 60, 0, 61, 0, 71, 0, 82, 0, 77, 0, 89, 0, 92, 0, 85, 0, 92, 
          0, 89, 0, 77, 0, 82, 0, 71, 0, 61, 0, 60, 0, 48, 0, 38, 0, 37, 0, 
          25, 0, 20, 0, 17, 0, 10, 0, 7, 0, 6, 0, 2, 0, 2, 0, 1 ], 34 ], 
  [ [ 1, 0, 2, 0, 2, 0, 6, 0, 8, 0, 12, 0, 19, 0, 26, 0, 32, 0, 47, 0, 55, 0, 
          68, 0, 85, 0, 98, 0, 109, 0, 130, 0, 137, 0, 150, 0, 163, 0, 167, 
          0, 169, 0, 178, 0, 169, 0, 167, 0, 163, 0, 150, 0, 137, 0, 130, 0, 
          109, 0, 98, 0, 85, 0, 68, 0, 55, 0, 47, 0, 32, 0, 26, 0, 19, 0, 12, 
          0, 8, 0, 6, 0, 2, 0, 2, 0, 1 ], 18 ], 
  [ [ 2, 0, 2, 0, 4, 0, 8, 0, 10, 0, 14, 0, 24, 0, 26, 0, 36, 0, 48, 0, 52, 
          0, 64, 0, 80, 0, 80, 0, 96, 0, 106, 0, 104, 0, 116, 0, 122, 0, 112, 
          0, 122, 0, 116, 0, 104, 0, 106, 0, 96, 0, 80, 0, 80, 0, 64, 0, 52, 
          0, 48, 0, 36, 0, 26, 0, 24, 0, 14, 0, 10, 0, 8, 0, 4, 0, 2, 0, 2 ], 
      16 ], 
  [ [ 2, 0, 2, 0, 4, 0, 8, 0, 10, 0, 14, 0, 24, 0, 26, 0, 36, 0, 48, 0, 52, 
          0, 64, 0, 80, 0, 80, 0, 96, 0, 106, 0, 104, 0, 116, 0, 122, 0, 112, 
          0, 122, 0, 116, 0, 104, 0, 106, 0, 96, 0, 80, 0, 80, 0, 64, 0, 52, 
          0, 48, 0, 36, 0, 26, 0, 24, 0, 14, 0, 10, 0, 8, 0, 4, 0, 2, 0, 2 ], 
      28 ], 
  [ [ 1, 0, 2, 0, 4, 0, 6, 0, 12, 0, 16, 0, 25, 0, 34, 0, 46, 0, 59, 0, 77, 
          0, 90, 0, 113, 0, 130, 0, 149, 0, 168, 0, 187, 0, 198, 0, 217, 0, 
          221, 0, 229, 0, 232, 0, 229, 0, 221, 0, 217, 0, 198, 0, 187, 0, 
          168, 0, 149, 0, 130, 0, 113, 0, 90, 0, 77, 0, 59, 0, 46, 0, 34, 0, 
          25, 0, 16, 0, 12, 0, 6, 0, 4, 0, 2, 0, 1 ], 18 ], 
  [ [ 1, 0, 1, 0, 2, 0, 5, 0, 6, 0, 10, 0, 16, 0, 19, 0, 27, 0, 37, 0, 42, 0, 
          54, 0, 66, 0, 72, 0, 86, 0, 97, 0, 101, 0, 113, 0, 120, 0, 119, 0, 
          126, 0, 126, 0, 119, 0, 120, 0, 113, 0, 101, 0, 97, 0, 86, 0, 72, 
          0, 66, 0, 54, 0, 42, 0, 37, 0, 27, 0, 19, 0, 16, 0, 10, 0, 6, 0, 5, 
          0, 2, 0, 1, 0, 1 ], 10 ], 
  [ [ 1, 0, 1, 0, 2, 0, 5, 0, 6, 0, 10, 0, 16, 0, 19, 0, 27, 0, 37, 0, 42, 0, 
          54, 0, 66, 0, 72, 0, 86, 0, 97, 0, 101, 0, 113, 0, 120, 0, 119, 0, 
          126, 0, 126, 0, 119, 0, 120, 0, 113, 0, 101, 0, 97, 0, 86, 0, 72, 
          0, 66, 0, 54, 0, 42, 0, 37, 0, 27, 0, 19, 0, 16, 0, 10, 0, 6, 0, 5, 
          0, 2, 0, 1, 0, 1 ], 28 ], 
  [ [ 1, 0, 0, 0, 2, 0, 4, 0, 7, 0, 11, 0, 19, 0, 23, 0, 37, 0, 48, 0, 63, 0, 
          78, 0, 101, 0, 114, 0, 141, 0, 160, 0, 179, 0, 197, 0, 220, 0, 223, 
          0, 243, 0, 246, 0, 246, 0, 246, 0, 243, 0, 223, 0, 220, 0, 197, 0, 
          179, 0, 160, 0, 141, 0, 114, 0, 101, 0, 78, 0, 63, 0, 48, 0, 37, 0, 
          23, 0, 19, 0, 11, 0, 7, 0, 4, 0, 2, 0, 0, 0, 1 ], 16 ], 
  [ [ 1, 0, 1, 0, 3, 0, 4, 0, 8, 0, 11, 0, 17, 0, 22, 0, 31, 0, 38, 0, 50, 0, 
          58, 0, 71, 0, 80, 0, 93, 0, 101, 0, 112, 0, 117, 0, 125, 0, 126, 0, 
          130, 0, 126, 0, 125, 0, 117, 0, 112, 0, 101, 0, 93, 0, 80, 0, 71, 
          0, 58, 0, 50, 0, 38, 0, 31, 0, 22, 0, 17, 0, 11, 0, 8, 0, 4, 0, 3, 
          0, 1, 0, 1 ], 10 ], 
  [ [ 1, 0, 1, 0, 3, 0, 4, 0, 8, 0, 11, 0, 17, 0, 22, 0, 31, 0, 38, 0, 50, 0, 
          58, 0, 71, 0, 80, 0, 93, 0, 101, 0, 112, 0, 117, 0, 125, 0, 126, 0, 
          130, 0, 126, 0, 125, 0, 117, 0, 112, 0, 101, 0, 93, 0, 80, 0, 71, 
          0, 58, 0, 50, 0, 38, 0, 31, 0, 22, 0, 17, 0, 11, 0, 8, 0, 4, 0, 3, 
          0, 1, 0, 1 ], 30 ], 
  [ [ 1, 0, 2, 0, 3, 0, 6, 0, 12, 0, 15, 0, 26, 0, 36, 0, 45, 0, 64, 0, 82, 
          0, 93, 0, 124, 0, 141, 0, 156, 0, 188, 0, 202, 0, 212, 0, 243, 0, 
          240, 0, 246, 0, 262, 0, 246, 0, 240, 0, 243, 0, 212, 0, 202, 0, 
          188, 0, 156, 0, 141, 0, 124, 0, 93, 0, 82, 0, 64, 0, 45, 0, 36, 0, 
          26, 0, 15, 0, 12, 0, 6, 0, 3, 0, 2, 0, 1 ], 18 ], 
  [ [ 1, 0, 1, 0, 3, 0, 4, 0, 8, 0, 11, 0, 17, 0, 22, 0, 32, 0, 39, 0, 52, 0, 
          61, 0, 76, 0, 87, 0, 102, 0, 112, 0, 127, 0, 134, 0, 146, 0, 149, 
          0, 156, 0, 155, 0, 156, 0, 149, 0, 146, 0, 134, 0, 127, 0, 112, 0, 
          102, 0, 87, 0, 76, 0, 61, 0, 52, 0, 39, 0, 32, 0, 22, 0, 17, 0, 11, 
          0, 8, 0, 4, 0, 3, 0, 1, 0, 1 ], 14 ], 
  [ [ 1, 0, 1, 0, 3, 0, 4, 0, 8, 0, 11, 0, 17, 0, 22, 0, 32, 0, 39, 0, 52, 0, 
          61, 0, 76, 0, 87, 0, 102, 0, 112, 0, 127, 0, 134, 0, 146, 0, 149, 
          0, 156, 0, 155, 0, 156, 0, 149, 0, 146, 0, 134, 0, 127, 0, 112, 0, 
          102, 0, 87, 0, 76, 0, 61, 0, 52, 0, 39, 0, 32, 0, 22, 0, 17, 0, 11, 
          0, 8, 0, 4, 0, 3, 0, 1, 0, 1 ], 22 ], 
  [ [ 1, 0, 2, 0, 5, 0, 8, 0, 12, 0, 23, 0, 30, 0, 42, 0, 63, 0, 76, 0, 98, 
          0, 129, 0, 144, 0, 175, 0, 208, 0, 222, 0, 254, 0, 280, 0, 283, 0, 
          308, 0, 318, 0, 308, 0, 318, 0, 308, 0, 283, 0, 280, 0, 254, 0, 
          222, 0, 208, 0, 175, 0, 144, 0, 129, 0, 98, 0, 76, 0, 63, 0, 42, 0, 
          30, 0, 23, 0, 12, 0, 8, 0, 5, 0, 2, 0, 1 ], 18 ], 
  [ [ 1, 0, 2, 0, 3, 0, 7, 0, 10, 0, 14, 0, 23, 0, 29, 0, 38, 0, 53, 0, 62, 
          0, 76, 0, 95, 0, 104, 0, 121, 0, 139, 0, 144, 0, 160, 0, 171, 0, 
          169, 0, 179, 0, 179, 0, 169, 0, 171, 0, 160, 0, 144, 0, 139, 0, 
          121, 0, 104, 0, 95, 0, 76, 0, 62, 0, 53, 0, 38, 0, 29, 0, 23, 0, 
          14, 0, 10, 0, 7, 0, 3, 0, 2, 0, 1 ], 16 ], 
  [ [ 1, 0, 2, 0, 3, 0, 7, 0, 10, 0, 14, 0, 23, 0, 29, 0, 38, 0, 53, 0, 62, 
          0, 76, 0, 95, 0, 104, 0, 121, 0, 139, 0, 144, 0, 160, 0, 171, 0, 
          169, 0, 179, 0, 179, 0, 169, 0, 171, 0, 160, 0, 144, 0, 139, 0, 
          121, 0, 104, 0, 95, 0, 76, 0, 62, 0, 53, 0, 38, 0, 29, 0, 23, 0, 
          14, 0, 10, 0, 7, 0, 3, 0, 2, 0, 1 ], 22 ], 
  [ [ 1, 0, 3, 0, 4, 0, 8, 0, 14, 0, 18, 0, 29, 0, 41, 0, 49, 0, 69, 0, 86, 
          0, 98, 0, 126, 0, 142, 0, 155, 0, 185, 0, 194, 0, 204, 0, 227, 0, 
          223, 0, 226, 0, 236, 0, 219, 0, 213, 0, 208, 0, 182, 0, 170, 0, 
          156, 0, 127, 0, 113, 0, 96, 0, 72, 0, 61, 0, 47, 0, 31, 0, 25, 0, 
          17, 0, 9, 0, 7, 0, 3, 0, 1, 0, 1 ], 12 ], 
  [ [ 1, 0, 1, 0, 3, 0, 7, 0, 9, 0, 17, 0, 25, 0, 31, 0, 47, 0, 61, 0, 72, 0, 
          96, 0, 113, 0, 127, 0, 156, 0, 170, 0, 182, 0, 208, 0, 213, 0, 219, 
          0, 236, 0, 226, 0, 223, 0, 227, 0, 204, 0, 194, 0, 185, 0, 155, 0, 
          142, 0, 126, 0, 98, 0, 86, 0, 69, 0, 49, 0, 41, 0, 29, 0, 18, 0, 
          14, 0, 8, 0, 4, 0, 3, 0, 1 ], 26 ], 
  [ [ 1, 0, 1, 0, 4, 0, 6, 0, 10, 0, 16, 0, 24, 0, 31, 0, 47, 0, 57, 0, 74, 
          0, 93, 0, 110, 0, 128, 0, 154, 0, 165, 0, 188, 0, 204, 0, 213, 0, 
          225, 0, 235, 0, 228, 0, 235, 0, 225, 0, 213, 0, 204, 0, 188, 0, 
          165, 0, 154, 0, 128, 0, 110, 0, 93, 0, 74, 0, 57, 0, 47, 0, 31, 0, 
          24, 0, 16, 0, 10, 0, 6, 0, 4, 0, 1, 0, 1 ], 12 ], 
  [ [ 1, 0, 1, 0, 4, 0, 6, 0, 10, 0, 16, 0, 24, 0, 31, 0, 47, 0, 57, 0, 74, 
          0, 93, 0, 110, 0, 128, 0, 154, 0, 165, 0, 188, 0, 204, 0, 213, 0, 
          225, 0, 235, 0, 228, 0, 235, 0, 225, 0, 213, 0, 204, 0, 188, 0, 
          165, 0, 154, 0, 128, 0, 110, 0, 93, 0, 74, 0, 57, 0, 47, 0, 31, 0, 
          24, 0, 16, 0, 10, 0, 6, 0, 4, 0, 1, 0, 1 ], 24 ], 
  [ [ 1, 0, 2, 0, 5, 0, 8, 0, 15, 0, 22, 0, 34, 0, 46, 0, 65, 0, 83, 0, 108, 
          0, 131, 0, 161, 0, 187, 0, 218, 0, 243, 0, 272, 0, 292, 0, 314, 0, 
          325, 0, 337, 0, 337, 0, 337, 0, 325, 0, 314, 0, 292, 0, 272, 0, 
          243, 0, 218, 0, 187, 0, 161, 0, 131, 0, 108, 0, 83, 0, 65, 0, 46, 
          0, 34, 0, 22, 0, 15, 0, 8, 0, 5, 0, 2, 0, 1 ], 14 ], 
  [ [ 1, 0, 2, 0, 5, 0, 8, 0, 15, 0, 22, 0, 34, 0, 46, 0, 65, 0, 83, 0, 108, 
          0, 131, 0, 161, 0, 187, 0, 218, 0, 243, 0, 272, 0, 292, 0, 314, 0, 
          325, 0, 337, 0, 337, 0, 337, 0, 325, 0, 314, 0, 292, 0, 272, 0, 
          243, 0, 218, 0, 187, 0, 161, 0, 131, 0, 108, 0, 83, 0, 65, 0, 46, 
          0, 34, 0, 22, 0, 15, 0, 8, 0, 5, 0, 2, 0, 1 ], 22 ], 
  [ [ 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 
          0, 0, 0, 0, 1 ], 1 ], 
  [ [ 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 
          0, 0, 0, 0, 1 ], 91 ], 
  [ [ 1, 0, 1, 0, 0, 0, 2, 0, 1, 0, 1, 0, 4, 0, 1, 0, 2, 0, 5, 0, 1, 0, 4, 0, 
          5, 0, 0, 0, 5, 0, 4, 0, 1, 0, 5, 0, 2, 0, 1, 0, 4, 0, 1, 0, 1, 0, 
          2, 0, 0, 0, 1, 0, 1 ], 19 ], 
  [ [ 1, 0, 1, 0, 0, 0, 2, 0, 1, 0, 1, 0, 4, 0, 1, 0, 2, 0, 5, 0, 1, 0, 4, 0, 
          5, 0, 0, 0, 5, 0, 4, 0, 1, 0, 5, 0, 2, 0, 1, 0, 4, 0, 1, 0, 1, 0, 
          2, 0, 0, 0, 1, 0, 1 ], 49 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 3, 0, 4, 0, 4, 0, 5, 0, 6, 0, 6, 0, 7, 0, 
          7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 6, 0, 6, 0, 5, 0, 4, 0, 4, 0, 3, 0, 
          2, 0, 2, 0, 1, 0, 1, 0, 1 ], 3 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 3, 0, 4, 0, 4, 0, 5, 0, 6, 0, 6, 0, 7, 0, 
          7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 6, 0, 6, 0, 5, 0, 4, 0, 4, 0, 3, 0, 
          2, 0, 2, 0, 1, 0, 1, 0, 1 ], 63 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 2, 0, 3, 0, 6, 0, 4, 0, 6, 0, 9, 0, 6, 0, 9, 0, 
          11, 0, 7, 0, 11, 0, 11, 0, 7, 0, 11, 0, 9, 0, 6, 0, 9, 0, 6, 0, 4, 
          0, 6, 0, 3, 0, 2, 0, 3, 0, 1, 0, 1, 0, 1 ], 7 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 2, 0, 3, 0, 6, 0, 4, 0, 6, 0, 9, 0, 6, 0, 9, 0, 
          11, 0, 7, 0, 11, 0, 11, 0, 7, 0, 11, 0, 9, 0, 6, 0, 9, 0, 6, 0, 4, 
          0, 6, 0, 3, 0, 2, 0, 3, 0, 1, 0, 1, 0, 1 ], 55 ], 
  [ [ 1, 0, 1, 0, 1, 0, 4, 0, 3, 0, 4, 0, 9, 0, 7, 0, 10, 0, 16, 0, 12, 0, 
          17, 0, 23, 0, 17, 0, 24, 0, 27, 0, 20, 0, 28, 0, 28, 0, 20, 0, 27, 
          0, 24, 0, 17, 0, 23, 0, 17, 0, 12, 0, 16, 0, 10, 0, 7, 0, 9, 0, 4, 
          0, 3, 0, 4, 0, 1, 0, 1, 0, 1 ], 25 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 3, 0, 4, 0, 7, 0, 7, 0, 9, 0, 13, 0, 12, 0, 15, 
          0, 19, 0, 17, 0, 21, 0, 23, 0, 20, 0, 24, 0, 24, 0, 20, 0, 23, 0, 
          21, 0, 17, 0, 19, 0, 15, 0, 12, 0, 13, 0, 9, 0, 7, 0, 7, 0, 4, 0, 
          3, 0, 3, 0, 1, 0, 1, 0, 1 ], 7 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 3, 0, 4, 0, 7, 0, 7, 0, 9, 0, 13, 0, 12, 0, 15, 
          0, 19, 0, 17, 0, 21, 0, 23, 0, 20, 0, 24, 0, 24, 0, 20, 0, 23, 0, 
          21, 0, 17, 0, 19, 0, 15, 0, 12, 0, 13, 0, 9, 0, 7, 0, 7, 0, 4, 0, 
          3, 0, 3, 0, 1, 0, 1, 0, 1 ], 43 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 3, 0, 4, 0, 7, 0, 7, 0, 9, 0, 13, 0, 13, 0, 16, 
          0, 19, 0, 19, 0, 22, 0, 24, 0, 24, 0, 25, 0, 26, 0, 25, 0, 24, 0, 
          24, 0, 22, 0, 19, 0, 19, 0, 16, 0, 13, 0, 13, 0, 9, 0, 7, 0, 7, 0, 
          4, 0, 3, 0, 3, 0, 1, 0, 1, 0, 1 ], 9 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 3, 0, 4, 0, 7, 0, 7, 0, 9, 0, 13, 0, 13, 0, 16, 
          0, 19, 0, 19, 0, 22, 0, 24, 0, 24, 0, 25, 0, 26, 0, 25, 0, 24, 0, 
          24, 0, 22, 0, 19, 0, 19, 0, 16, 0, 13, 0, 13, 0, 9, 0, 7, 0, 7, 0, 
          4, 0, 3, 0, 3, 0, 1, 0, 1, 0, 1 ], 39 ], 
  [ [ 1, 0, 1, 0, 2, 0, 4, 0, 4, 0, 7, 0, 10, 0, 10, 0, 15, 0, 18, 0, 18, 0, 
          25, 0, 26, 0, 26, 0, 33, 0, 31, 0, 31, 0, 36, 0, 31, 0, 31, 0, 33, 
          0, 26, 0, 26, 0, 25, 0, 18, 0, 18, 0, 15, 0, 10, 0, 10, 0, 7, 0, 4, 
          0, 4, 0, 2, 0, 1, 0, 1 ], 5 ], 
  [ [ 1, 0, 1, 0, 2, 0, 4, 0, 4, 0, 7, 0, 10, 0, 10, 0, 15, 0, 18, 0, 18, 0, 
          25, 0, 26, 0, 26, 0, 33, 0, 31, 0, 31, 0, 36, 0, 31, 0, 31, 0, 33, 
          0, 26, 0, 26, 0, 25, 0, 18, 0, 18, 0, 15, 0, 10, 0, 10, 0, 7, 0, 4, 
          0, 4, 0, 2, 0, 1, 0, 1 ], 47 ], 
  [ [ 1, 0, 1, 0, 1, 0, 4, 0, 4, 0, 6, 0, 12, 0, 11, 0, 16, 0, 25, 0, 24, 0, 
          33, 0, 42, 0, 40, 0, 52, 0, 60, 0, 57, 0, 68, 0, 72, 0, 67, 0, 76, 
          0, 76, 0, 67, 0, 72, 0, 68, 0, 57, 0, 60, 0, 52, 0, 40, 0, 42, 0, 
          33, 0, 24, 0, 25, 0, 16, 0, 11, 0, 12, 0, 6, 0, 4, 0, 4, 0, 1, 0, 
          1, 0, 1 ], 19 ], 
  [ [ 1, 0, 1, 0, 1, 0, 4, 0, 4, 0, 5, 0, 11, 0, 10, 0, 13, 0, 22, 0, 19, 0, 
          25, 0, 35, 0, 29, 0, 38, 0, 46, 0, 37, 0, 48, 0, 51, 0, 40, 0, 51, 
          0, 48, 0, 37, 0, 46, 0, 38, 0, 29, 0, 35, 0, 25, 0, 19, 0, 22, 0, 
          13, 0, 10, 0, 11, 0, 5, 0, 4, 0, 4, 0, 1, 0, 1, 0, 1 ], 13 ], 
  [ [ 1, 0, 1, 0, 1, 0, 4, 0, 4, 0, 5, 0, 11, 0, 10, 0, 13, 0, 22, 0, 19, 0, 
          25, 0, 35, 0, 29, 0, 38, 0, 46, 0, 37, 0, 48, 0, 51, 0, 40, 0, 51, 
          0, 48, 0, 37, 0, 46, 0, 38, 0, 29, 0, 35, 0, 25, 0, 19, 0, 22, 0, 
          13, 0, 10, 0, 11, 0, 5, 0, 4, 0, 4, 0, 1, 0, 1, 0, 1 ], 31 ], 
  [ [ 1, 0, 2, 0, 2, 0, 5, 0, 7, 0, 8, 0, 14, 0, 17, 0, 19, 0, 28, 0, 31, 0, 
          34, 0, 44, 0, 45, 0, 48, 0, 57, 0, 55, 0, 56, 0, 62, 0, 56, 0, 55, 
          0, 57, 0, 48, 0, 45, 0, 44, 0, 34, 0, 31, 0, 28, 0, 19, 0, 17, 0, 
          14, 0, 8, 0, 7, 0, 5, 0, 2, 0, 2, 0, 1 ], 9 ], 
  [ [ 1, 0, 2, 0, 2, 0, 5, 0, 7, 0, 8, 0, 14, 0, 17, 0, 19, 0, 28, 0, 31, 0, 
          34, 0, 44, 0, 45, 0, 48, 0, 57, 0, 55, 0, 56, 0, 62, 0, 56, 0, 55, 
          0, 57, 0, 48, 0, 45, 0, 44, 0, 34, 0, 31, 0, 28, 0, 19, 0, 17, 0, 
          14, 0, 8, 0, 7, 0, 5, 0, 2, 0, 2, 0, 1 ], 39 ], 
  [ [ 1, 0, 2, 0, 2, 0, 5, 0, 7, 0, 9, 0, 16, 0, 19, 0, 24, 0, 35, 0, 39, 0, 
          48, 0, 61, 0, 64, 0, 76, 0, 88, 0, 89, 0, 100, 0, 107, 0, 104, 0, 
          112, 0, 112, 0, 104, 0, 107, 0, 100, 0, 89, 0, 88, 0, 76, 0, 64, 0, 
          61, 0, 48, 0, 39, 0, 35, 0, 24, 0, 19, 0, 16, 0, 9, 0, 7, 0, 5, 0, 
          2, 0, 2, 0, 1 ], 19 ], 
  [ [ 1, 0, 2, 0, 3, 0, 5, 0, 7, 0, 11, 0, 15, 0, 19, 0, 25, 0, 30, 0, 37, 0, 
          44, 0, 49, 0, 56, 0, 61, 0, 66, 0, 71, 0, 72, 0, 74, 0, 74, 0, 72, 
          0, 71, 0, 66, 0, 61, 0, 56, 0, 49, 0, 44, 0, 37, 0, 30, 0, 25, 0, 
          19, 0, 15, 0, 11, 0, 7, 0, 5, 0, 3, 0, 2, 0, 1 ], 13 ], 
  [ [ 1, 0, 2, 0, 3, 0, 5, 0, 7, 0, 11, 0, 15, 0, 19, 0, 25, 0, 30, 0, 37, 0, 
          44, 0, 49, 0, 56, 0, 61, 0, 66, 0, 71, 0, 72, 0, 74, 0, 74, 0, 72, 
          0, 71, 0, 66, 0, 61, 0, 56, 0, 49, 0, 44, 0, 37, 0, 30, 0, 25, 0, 
          19, 0, 15, 0, 11, 0, 7, 0, 5, 0, 3, 0, 2, 0, 1 ], 33 ], 
  [ [ 1, 0, 1, 0, 2, 0, 4, 0, 5, 0, 8, 0, 12, 0, 14, 0, 20, 0, 26, 0, 29, 0, 
          38, 0, 44, 0, 48, 0, 58, 0, 62, 0, 65, 0, 74, 0, 74, 0, 75, 0, 80, 
          0, 75, 0, 74, 0, 74, 0, 65, 0, 62, 0, 58, 0, 48, 0, 44, 0, 38, 0, 
          29, 0, 26, 0, 20, 0, 14, 0, 12, 0, 8, 0, 5, 0, 4, 0, 2, 0, 1, 0, 1 ]
        , 11 ], 
  [ [ 1, 0, 1, 0, 2, 0, 4, 0, 5, 0, 8, 0, 12, 0, 14, 0, 20, 0, 26, 0, 29, 0, 
          38, 0, 44, 0, 48, 0, 58, 0, 62, 0, 65, 0, 74, 0, 74, 0, 75, 0, 80, 
          0, 75, 0, 74, 0, 74, 0, 65, 0, 62, 0, 58, 0, 48, 0, 44, 0, 38, 0, 
          29, 0, 26, 0, 20, 0, 14, 0, 12, 0, 8, 0, 5, 0, 4, 0, 2, 0, 1, 0, 1 ]
        , 29 ], 
  [ [ 1, 0, 1, 0, 2, 0, 5, 0, 6, 0, 9, 0, 15, 0, 17, 0, 23, 0, 32, 0, 34, 0, 
          43, 0, 53, 0, 54, 0, 64, 0, 72, 0, 70, 0, 79, 0, 82, 0, 76, 0, 82, 
          0, 79, 0, 70, 0, 72, 0, 64, 0, 54, 0, 53, 0, 43, 0, 34, 0, 32, 0, 
          23, 0, 17, 0, 15, 0, 9, 0, 6, 0, 5, 0, 2, 0, 1, 0, 1 ], 7 ], 
  [ [ 1, 0, 1, 0, 2, 0, 5, 0, 6, 0, 9, 0, 15, 0, 17, 0, 23, 0, 32, 0, 34, 0, 
          43, 0, 53, 0, 54, 0, 64, 0, 72, 0, 70, 0, 79, 0, 82, 0, 76, 0, 82, 
          0, 79, 0, 70, 0, 72, 0, 64, 0, 54, 0, 53, 0, 43, 0, 34, 0, 32, 0, 
          23, 0, 17, 0, 15, 0, 9, 0, 6, 0, 5, 0, 2, 0, 1, 0, 1 ], 37 ], 
  [ [ 1, 0, 1, 0, 3, 0, 6, 0, 7, 0, 13, 0, 19, 0, 22, 0, 34, 0, 43, 0, 48, 0, 
          66, 0, 75, 0, 81, 0, 102, 0, 107, 0, 112, 0, 131, 0, 128, 0, 130, 
          0, 142, 0, 130, 0, 128, 0, 131, 0, 112, 0, 107, 0, 102, 0, 81, 0, 
          75, 0, 66, 0, 48, 0, 43, 0, 34, 0, 22, 0, 19, 0, 13, 0, 7, 0, 6, 0, 
          3, 0, 1, 0, 1 ], 17 ], 
  [ [ 1, 0, 1, 0, 3, 0, 6, 0, 7, 0, 13, 0, 19, 0, 22, 0, 34, 0, 43, 0, 48, 0, 
          66, 0, 75, 0, 81, 0, 102, 0, 107, 0, 112, 0, 131, 0, 128, 0, 130, 
          0, 142, 0, 130, 0, 128, 0, 131, 0, 112, 0, 107, 0, 102, 0, 81, 0, 
          75, 0, 66, 0, 48, 0, 43, 0, 34, 0, 22, 0, 19, 0, 13, 0, 7, 0, 6, 0, 
          3, 0, 1, 0, 1 ], 23 ], 
  [ [ 1, 0, 1, 0, 2, 0, 6, 0, 7, 0, 11, 0, 20, 0, 23, 0, 32, 0, 47, 0, 51, 0, 
          66, 0, 85, 0, 88, 0, 107, 0, 125, 0, 124, 0, 143, 0, 154, 0, 146, 
          0, 161, 0, 161, 0, 146, 0, 154, 0, 143, 0, 124, 0, 125, 0, 107, 0, 
          88, 0, 85, 0, 66, 0, 51, 0, 47, 0, 32, 0, 23, 0, 20, 0, 11, 0, 7, 
          0, 6, 0, 2, 0, 1, 0, 1 ], 13 ], 
  [ [ 1, 0, 1, 0, 2, 0, 6, 0, 7, 0, 11, 0, 20, 0, 23, 0, 32, 0, 47, 0, 51, 0, 
          66, 0, 85, 0, 88, 0, 107, 0, 125, 0, 124, 0, 143, 0, 154, 0, 146, 
          0, 161, 0, 161, 0, 146, 0, 154, 0, 143, 0, 124, 0, 125, 0, 107, 0, 
          88, 0, 85, 0, 66, 0, 51, 0, 47, 0, 32, 0, 23, 0, 20, 0, 11, 0, 7, 
          0, 6, 0, 2, 0, 1, 0, 1 ], 25 ], 
  [ [ 2, 0, 3, 0, 5, 0, 12, 0, 16, 0, 24, 0, 40, 0, 49, 0, 66, 0, 93, 0, 106, 
          0, 133, 0, 167, 0, 180, 0, 213, 0, 245, 0, 251, 0, 282, 0, 302, 0, 
          295, 0, 316, 0, 316, 0, 295, 0, 302, 0, 282, 0, 251, 0, 245, 0, 
          213, 0, 180, 0, 167, 0, 133, 0, 106, 0, 93, 0, 66, 0, 49, 0, 40, 0, 
          24, 0, 16, 0, 12, 0, 5, 0, 3, 0, 2 ], 19 ], 
  [ [ 1, 0, 2, 0, 4, 0, 7, 0, 11, 0, 17, 0, 24, 0, 33, 0, 44, 0, 56, 0, 70, 
          0, 85, 0, 100, 0, 116, 0, 131, 0, 145, 0, 158, 0, 168, 0, 176, 0, 
          181, 0, 182, 0, 181, 0, 176, 0, 168, 0, 158, 0, 145, 0, 131, 0, 
          116, 0, 100, 0, 85, 0, 70, 0, 56, 0, 44, 0, 33, 0, 24, 0, 17, 0, 
          11, 0, 7, 0, 4, 0, 2, 0, 1 ], 9 ], 
  [ [ 1, 0, 2, 0, 4, 0, 7, 0, 11, 0, 17, 0, 24, 0, 33, 0, 44, 0, 56, 0, 70, 
          0, 85, 0, 100, 0, 116, 0, 131, 0, 145, 0, 158, 0, 168, 0, 176, 0, 
          181, 0, 182, 0, 181, 0, 176, 0, 168, 0, 158, 0, 145, 0, 131, 0, 
          116, 0, 100, 0, 85, 0, 70, 0, 56, 0, 44, 0, 33, 0, 24, 0, 17, 0, 
          11, 0, 7, 0, 4, 0, 2, 0, 1 ], 31 ], 
  [ [ 1, 0, 2, 0, 3, 0, 7, 0, 10, 0, 14, 0, 24, 0, 30, 0, 39, 0, 56, 0, 64, 
          0, 79, 0, 101, 0, 108, 0, 127, 0, 148, 0, 150, 0, 169, 0, 182, 0, 
          176, 0, 190, 0, 190, 0, 176, 0, 182, 0, 169, 0, 150, 0, 148, 0, 
          127, 0, 108, 0, 101, 0, 79, 0, 64, 0, 56, 0, 39, 0, 30, 0, 24, 0, 
          14, 0, 10, 0, 7, 0, 3, 0, 2, 0, 1 ], 13 ], 
  [ [ 1, 0, 2, 0, 3, 0, 7, 0, 10, 0, 14, 0, 24, 0, 30, 0, 39, 0, 56, 0, 64, 
          0, 79, 0, 101, 0, 108, 0, 127, 0, 148, 0, 150, 0, 169, 0, 182, 0, 
          176, 0, 190, 0, 190, 0, 176, 0, 182, 0, 169, 0, 150, 0, 148, 0, 
          127, 0, 108, 0, 101, 0, 79, 0, 64, 0, 56, 0, 39, 0, 30, 0, 24, 0, 
          14, 0, 10, 0, 7, 0, 3, 0, 2, 0, 1 ], 25 ], 
  [ [ 1, 0, 2, 0, 4, 0, 9, 0, 14, 0, 22, 0, 35, 0, 48, 0, 66, 0, 90, 0, 112, 
          0, 142, 0, 175, 0, 203, 0, 240, 0, 273, 0, 300, 0, 334, 0, 356, 0, 
          372, 0, 392, 0, 394, 0, 394, 0, 392, 0, 372, 0, 356, 0, 334, 0, 
          300, 0, 273, 0, 240, 0, 203, 0, 175, 0, 142, 0, 112, 0, 90, 0, 66, 
          0, 48, 0, 35, 0, 22, 0, 14, 0, 9, 0, 4, 0, 2, 0, 1 ], 17 ], 
  [ [ 1, 0, 1, 0, 3, 0, 7, 0, 9, 0, 17, 0, 25, 0, 31, 0, 47, 0, 61, 0, 72, 0, 
          96, 0, 113, 0, 127, 0, 156, 0, 170, 0, 182, 0, 208, 0, 213, 0, 219, 
          0, 236, 0, 226, 0, 223, 0, 227, 0, 204, 0, 194, 0, 185, 0, 155, 0, 
          142, 0, 126, 0, 98, 0, 86, 0, 69, 0, 49, 0, 41, 0, 29, 0, 18, 0, 
          14, 0, 8, 0, 4, 0, 3, 0, 1 ], 11 ], 
  [ [ 1, 0, 3, 0, 4, 0, 8, 0, 14, 0, 18, 0, 29, 0, 41, 0, 49, 0, 69, 0, 86, 
          0, 98, 0, 126, 0, 142, 0, 155, 0, 185, 0, 194, 0, 204, 0, 227, 0, 
          223, 0, 226, 0, 236, 0, 219, 0, 213, 0, 208, 0, 182, 0, 170, 0, 
          156, 0, 127, 0, 113, 0, 96, 0, 72, 0, 61, 0, 47, 0, 31, 0, 25, 0, 
          17, 0, 9, 0, 7, 0, 3, 0, 1, 0, 1 ], 27 ], 
  [ [ 1, 0, 2, 0, 3, 0, 7, 0, 11, 0, 15, 0, 25, 0, 34, 0, 43, 0, 61, 0, 75, 
          0, 89, 0, 114, 0, 130, 0, 146, 0, 173, 0, 185, 0, 198, 0, 220, 0, 
          222, 0, 227, 0, 238, 0, 227, 0, 222, 0, 220, 0, 198, 0, 185, 0, 
          173, 0, 146, 0, 130, 0, 114, 0, 89, 0, 75, 0, 61, 0, 43, 0, 34, 0, 
          25, 0, 15, 0, 11, 0, 7, 0, 3, 0, 2, 0, 1 ], 15 ], 
  [ [ 1, 0, 2, 0, 3, 0, 7, 0, 11, 0, 15, 0, 25, 0, 34, 0, 43, 0, 61, 0, 75, 
          0, 89, 0, 114, 0, 130, 0, 146, 0, 173, 0, 185, 0, 198, 0, 220, 0, 
          222, 0, 227, 0, 238, 0, 227, 0, 222, 0, 220, 0, 198, 0, 185, 0, 
          173, 0, 146, 0, 130, 0, 114, 0, 89, 0, 75, 0, 61, 0, 43, 0, 34, 0, 
          25, 0, 15, 0, 11, 0, 7, 0, 3, 0, 2, 0, 1 ], 21 ], 
  [ [ 1, 0, 2, 0, 4, 0, 7, 0, 11, 0, 18, 0, 26, 0, 36, 0, 49, 0, 63, 0, 81, 
          0, 100, 0, 119, 0, 141, 0, 161, 0, 182, 0, 202, 0, 217, 0, 232, 0, 
          242, 0, 248, 0, 252, 0, 248, 0, 242, 0, 232, 0, 217, 0, 202, 0, 
          182, 0, 161, 0, 141, 0, 119, 0, 100, 0, 81, 0, 63, 0, 49, 0, 36, 0, 
          26, 0, 18, 0, 11, 0, 7, 0, 4, 0, 2, 0, 1 ], 13 ], 
  [ [ 1, 0, 2, 0, 4, 0, 7, 0, 11, 0, 18, 0, 26, 0, 36, 0, 49, 0, 63, 0, 81, 
          0, 100, 0, 119, 0, 141, 0, 161, 0, 182, 0, 202, 0, 217, 0, 232, 0, 
          242, 0, 248, 0, 252, 0, 248, 0, 242, 0, 232, 0, 217, 0, 202, 0, 
          182, 0, 161, 0, 141, 0, 119, 0, 100, 0, 81, 0, 63, 0, 49, 0, 36, 0, 
          26, 0, 18, 0, 11, 0, 7, 0, 4, 0, 2, 0, 1 ], 23 ], 
  [ [ 1, 0, 2, 0, 4, 0, 8, 0, 13, 0, 20, 0, 31, 0, 43, 0, 58, 0, 78, 0, 98, 
          0, 121, 0, 148, 0, 173, 0, 199, 0, 227, 0, 249, 0, 270, 0, 290, 0, 
          301, 0, 309, 0, 314, 0, 309, 0, 301, 0, 290, 0, 270, 0, 249, 0, 
          227, 0, 199, 0, 173, 0, 148, 0, 121, 0, 98, 0, 78, 0, 58, 0, 43, 0, 
          31, 0, 20, 0, 13, 0, 8, 0, 4, 0, 2, 0, 1 ], 15 ], 
  [ [ 1, 0, 2, 0, 4, 0, 8, 0, 13, 0, 20, 0, 31, 0, 43, 0, 58, 0, 78, 0, 98, 
          0, 121, 0, 148, 0, 173, 0, 199, 0, 227, 0, 249, 0, 270, 0, 290, 0, 
          301, 0, 309, 0, 314, 0, 309, 0, 301, 0, 290, 0, 270, 0, 249, 0, 
          227, 0, 199, 0, 173, 0, 148, 0, 121, 0, 98, 0, 78, 0, 58, 0, 43, 0, 
          31, 0, 20, 0, 13, 0, 8, 0, 4, 0, 2, 0, 1 ], 21 ] ];

#############################################################################
##
#F  CHEVIE.E8.classparams( <w> )  . . . . . . . . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type E_8  as word in  standard
##  generators, 'CHEVIE.E8.ClassParam' returns the classparam of its conjugacy
##  class.
##
CHEVIE.E8.classparams:=function(w)
  if w=[] then return " ";fi;
  return CHEVIE.E8.classparams[Position(CHEVIE.E8.cyclestructure,
    CycleStructurePerm(Product(CHEVIE.E8.generators{w})))];
end;

###########################################################################
##
#F CHEVIE.E8.HeckeCharTable( <v> ) character table of the Hecke algebra of type E8
##
## Note: the parameter for the Hecke algebra is <v>^2.
##       the labelling is consistent with v -> 1.
##
CHEVIE.E8.HeckeCharTable:=v->rec( 
  identifier:= "H(E8)", 
  text := "origin: Jean Michel, March 1995",
  cartan:=CHEVIE.E8.cartan, 
  parameter := [ v^2, v^2, v^2, v^2, v^2, v^2, v^2, v^2 ], 
  size := 696729600, 
  powermap:=CHEVIE.E8.powermap, 
  classtext := CHEVIE.E8.classtext,
  classnames := CHEVIE.E8.classnames,
  classparam := CHEVIE.E8.classnames,
  orders := CHEVIE.E8.orders, 
  centralizers := CHEVIE.E8.centralizers, 
  classes := CHEVIE.E8.classes,
  irreducibles:=List(CHEVIE.E8.vpolheckeirreducibles,
                     i->List(i,j->FastValue(j,v))),
  irredinfo:=List(CHEVIE.E8.CharParams(),x->
                       rec(charparam:=x,charname:=CHEVIE.E8.CharName(x))),
  operations := CharTableOps );
