#############################################################################
##
#A  weylg. g                  CHEVIE library                     Meinolf Geck
##
#A  $Id: weylg.g,v 1.1 1997/01/21 13:46:59 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains the character table of the Hecke algebra of type G2.
##

CHEVIE.G2:=rec();

CHEVIE.G2.classtext:=[[], [2], [1], [1, 2], [1, 2, 1, 2], [1, 2, 1, 2, 1, 2]];

CHEVIE.G2.classnames:=[" ","~A_1","A_1","G_2","A_2", "A_1 + ~A_1"];

#how to make a .charname from a .charparam
CHEVIE.G2.CharName:= function(x)local s;
  s:=Concatenation("phi_{",String(x[1]),",",String(x[2]),"}");
  if Length(x)=3 then Append(s,x[3]);fi;
  return String(s);
end;

CHEVIE.G2.CharParams:=function()
  return [[1,0],[1,6],[1,3,"'"],[1,3,"''"],[2,1],[2,2]];
end;

CHEVIE.G2.generators:=[ (2,3)(4,5), (1,2)(3,4)(5,6) ];

CHEVIE.G2.cartan:=[[2,-1],[-3,2]];

CHEVIE.G2.powermap:=[,[1,1,1,5,5,1], [1,2,3,6,1,6]];

CHEVIE.G2.orders:=[1,2,2,6,3,2];

CHEVIE.G2.centralizers:=[12,4,4,6,6,12];

CHEVIE.G2.classes:=[1,3,3,2,2,1];

CHEVIE.G2.PositionId:=function() return 1; end;

CHEVIE.G2.PositionSgn:=function() return 2; end;

CHEVIE.G2.PositionRefl:=function() return 5; end;

CHEVIE.G2.vpolfakedegrees:=
[ [ [ 1 ], 0 ], [ [ 1 ], 6 ], [ [ 1 ], 3 ], [ [ 1 ], 3 ], 
  [ [ 1, 0, 0, 0, 1 ], 1 ], [ [ 1, 0, 1 ], 2 ] ];

CHEVIE.G2.chara:=[ 0, 6, 1, 1, 1, 1 ];

CHEVIE.G2.charA:=[ 0, 6, 5, 5, 5, 5 ];

#############################################################################
##
#F  CHEVIE.G2.ClassParam( <w> )  . . . . . . . . . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type G_2  as word in  standard
##  generators, 'CHEVIE.G2.ClassParam' returns the classparam of its conjugacy
##  class.
##
CHEVIE.G2.ClassParam:=function(w)local ind, els;
  if w=[] then return " "; fi;
  els:=Set([ (), (2,3)(4,5), (1,2)(3,4)(5,6), (1,2,4,6,5,3), (1,3,5,6,4,2), 
         (1,3)(2,5)(4,6), (1,4)(3,6), (1,4,5)(2,6,3), 
         (1,5,4)(2,3,6), (1,5)(2,6), 
         (1,6)(2,4)(3,5), (1,6)(2,5)(3,4) ]);
  ind:=[ 1, 3, 2, 4, 4, 2, 3, 5, 5, 3, 2, 6 ];
  return CHEVIE.G2.classparams[ind[Position(els,
                                        Product(CHEVIE.G2.generators{w}))]];
end;

###########################################################################
##
#F  CHEVIE.G2.HeckeCharTable( <arg> ) . . . . . . . . . . . . . . . . . . . .
##  . . . . . . . . . . .   character table of the Hecke algebra of type G2
##
##  'CHEVIE.G2.HeckeCharTable' returns the character table of the Hecke algebra
##  of type  G2  with  parameters  given  by  <arg>. 
##
##  The  parameters  given should be u, v, sqrt(u*v) where u and v are
##  the parameters for the Hecke algebra. If only one is given, the
##  values u, u, u are used. If two are given, the function knows how to
##  compute sqrt(u*v) only if u and v are equal or one is the cube of
##  the other one.
##
CHEVIE.G2.HeckeCharTable:=function(arg) local u,v,squv;
  u:=arg[1];
  if Length(arg)=1 then
    v:=u; squv:=u;
  elif Length(arg)=3 then
    v:=arg[2]; squv:=arg[3];
  else 
    v:=arg[2];
    if u=v then squv:=u;
    elif u=v^3 then squv:=v^2;
    elif v=u^3 then squv:=u^2;
    else 
     Error("need sqrtParameters or u=v or u=v^3 or u^3=v for CharTable(H(G2))");
    fi;
  fi;
  return rec(
  identifier:="H(G2)",
  parameter:=[u,v], 
  sqrtParameter:=[squv, squv],
  cartan:=CHEVIE.G2.cartan, 
  size:=12, 
  powermap:=CHEVIE.G2.powermap, 
  classtext := CHEVIE.G2.classtext,
  classnames := CHEVIE.G2.classnames,
  classparam := CHEVIE.G2.classnames,
  orders := CHEVIE.G2.orders, 
  centralizers := CHEVIE.G2.centralizers, 
  classes := CHEVIE.G2.classes,
  irreducibles:= 
    [[1, v, u, v*u, v^2*u^2, v^3*u^3], [1, -1, -1, 1, 1, 1], 
     [1, v, -1, -v, v^2, -v^3], [1, -1, u, -u, u^2, -u^3], 
     [2, -1+v, u-1, squv, -v*u, -2*squv^3], 
     [2, -1+v, u-1, -squv, -v*u, 2*squv^3]]*v^0, 
  irredinfo:=List(CHEVIE.G2.CharParams(),x->
                       rec(charparam:=x,charname:=CHEVIE.G2.CharName(x))),
  operations:=CharTableOps); 
end;

#############################################################################
##
#F  CHEVIE.G2.PoincarePolynomial(u,v) . . . . Poincare Polynomial for G2
##
##  Same as Schur element for the identity character, but does not
##  require squv to be given.
##
CHEVIE.G2.PoincarePolynomial:=function(u,v)
  return (1+u)*(v+1)*((1+u*v)^2-u*v);
end;

CHEVIE.G2.SchurElements:=
[ function(u,v,squv)return(1+u)*(v+1)*(u*v-squv+1)*(u*v+squv+1);end,
  function(u,v,squv)return(1+u)*(v+1)*(u*v-squv+1)*(u*v+squv+1)/u^3/v^3;end, 
  function(u,v,squv)return(u-squv+v)*(u+squv+v)*(1+u)*(v+1)/u^3;end, 
  function(u,v,squv)return(u-squv+v)*(u+squv+v)*(1+u)*(v+1)/v^3;end, 
  function(u,v,squv)return 2*(u+squv+v)*(u*v-squv+1)/u/v;end,
  function(u,v,squv)return 2*(u-squv+v)*(u*v+squv+1)/u/v;end];

#############################################################################
##
#F  CHEVIE.G2.SchurElement( <phi>, <para> ) . . . .  Schur elements for type G2
##
##  'CHEVIE.G2.SchurElement' returns the constant arising  from  the
##  Schur relations for  the  irreducible  character  <phi> of  the 
##  Hecke of type G2 with parameters given by a list <para>. 
##
##  The  parameters  given should be u, v, sqrt(u*v) where u and v are
##  the parameters for the Hecke algebra. If only one is given, the
##  values u, u, u are used. If two are given, the function knows how to
##  compute sqrt(u*v) only if u and v are equal or one is the cube of
##  the other one.
##
##  The  constant  corresponding  to  an  phi  is  defined  to be P/D where
##  P is the Poincare  polynomial and D  is the generic degree of  phi. 
##
CHEVIE.G2.SchurElement:=function(arg) local u,v,squv,p;
  p:=Position(CHEVIE.G2.CharParams(),arg[1]);arg:=arg{[2..Length(arg)]};
  u:=arg[1];
  if Length(arg)=1 then
    v:=u; squv:=u;
  elif Length(arg)=3 then
    v:=arg[2]; squv:=arg[3];
  else 
    v:=arg[2];
    if u=v then squv:=u;
    elif u=v^3 then squv:=v^2;
    elif v=u^3 then squv:=u^2;
    else 
    Error("need sqrtParameters or u=v or u=v^3 or u^3=v for SchurElements(G2)");
    fi;
  fi;
  return CHEVIE.G2.SchurElements[p](u,v,squv);
end;
