#############################################################################
##
#W  fixes_dispatch.g	   	Matrix Packages                  Frank Celler
##
#H  @(#)$Id: dispatch.g,v 1.1 1997/03/10 13:51:40 gap Exp $
##
#Y  Copyright (C)  1996,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file  fixes functions from  the  file "dispatch.g".
##
RevisionMatrix.fixes_dispatch_g :=
    "@(#)$Id: dispatch.g,v 1.1 1997/03/10 13:51:40 gap Exp $";

# read in the files to patch
ReadLib("dispatch");
ReadLib("operatio");


#############################################################################
##

#F  BlowupVec( <V>, <v> )
##
BlowupVec := function( V, v )
    BlowupVec := CRecSL.BlowupVec;
    return BlowupVec( V, v );
end;


#############################################################################
##
#F  Rewrite( <struct>, <obj> )
##
Rewrite := function( struct, obj )
    return struct.operations.Rewrite( struct, obj );
end;


#############################################################################
##
#F  AddGenerator( <struct>, <obj> )
##
AddGenerator := function( struct, obj )
    return struct.operations.AddGenerator( struct, obj );
end;


#############################################################################
##
#F  AddGenerators( <struct>, <obj> )
##
AddGenerators := function( struct, obj )
    return struct.operations.AddGenerators( struct, obj );
end;


#############################################################################
##

#F  IsIrreducible( [<R>,] <obj> ) . . . . . . . check if <obj> is irreducible
##
IsIrreducible := function( arg )
    local R, r;

    # get and check the arguments
    if   Length( arg ) = 1 then

        # group module from smash
        if IsGModule(arg[1])  then
            if not IsBound(arg[1].isIrreducible)  then
                arg[1].isIrreducible := MatrixMTX.isIrreducible(arg[1]);
            fi;
            return arg[1].isIrreducible;

        # gap records
        elif IsRec( arg[1] ) then
            if not IsBound( arg[1].isIrreducible ) then
                if not IsBound( arg[1].operations ) then
                    Error( "<struct> must have 'operations' entry" );
                fi;
                arg[1].isIrreducible:=
                  arg[1].operations.IsIrreducible( arg[1] );
            fi;
            return arg[1].isIrreducible;

        # anything else
        else
            R := DefaultRing( arg[1] );
            r := arg[1];
        fi;

    elif Length(arg) = 2 then
        R := arg[1];
        if not IsRing(R)  then
            Error( "<R> must be a ring" );
        fi;
        r := arg[2];
        if not r in R  then
            Error( "<r> must be an element of <R>" );
        fi;
    else
        Error( "usage: IsIrreducible( <struct> )",
               " resp. IsIrreducible( [<R>,] <r> )" );
    fi;

    # permform the test
    return R.operations.IsIrreducible( R, r );

end;


#############################################################################
##
#F  IsPrimitive( <obj> )  . . . . . . . . . . . . check if <obj> is primitive
##
IsPrimitive := function ( arg )
    local  isPrim,  tmp;

    # g-modules
    if IsGModule(arg[1])  then
        tmp := ApplyFunc(MatrixMTX.IsPrimitive,arg);
        if IsBool(tmp[1])  then
            arg[1].isPrimitive := tmp;
        fi;
        return tmp;
    elif IsMatGroup(arg[1])  then
        tmp := ApplyFunc(MatrixMTX.IsPrimitive,arg);
        if IsBool(tmp[1])  then
            arg[1].isPrimitive := tmp;
        fi;
        return tmp;

    # other objects
    elif Length(arg) = 1  then
        if not IsBound(arg[1].isPrimitive)  then
            arg[1].isPrimitive := arg[1].operations.IsPrimitive(arg[1]);
        fi;
        isPrim := arg[1].isPrimitive;
    elif Length(arg) = 2  then
        isPrim := arg[1].operations.IsPrimitive( arg[1], arg[2], OnPoints );
    elif Length(arg) = 3  then
        isPrim := arg[1].operations.IsPrimitive( arg[1], arg[2], arg[3] );
    else
        Error( "usage: IsPrimitive( <G>, <D> [, <operation>]" );
    fi;
    return isPrim;
end;


#############################################################################
##
#F  CompositionFactors( <obj> ) . . . . . . . .  composition factors of <obj>
##
CompositionFactors := function ( struct )
    if not IsRec( struct )  then
        Error( "<struct> must be a record" );
    fi;
    if not IsBound( struct.compositionFactors )  then
        if IsGModule(struct)  then
            struct.compositionFactors :=
                MatrixMTX.CompositionFactors( struct );
        elif not IsBound( struct.operations )  then
            Error( "<struct> must have 'operations' entry" );
        else
            struct.compositionFactors :=
                struct.operations.CompositionFactors( struct );
        fi;
    fi;
    return struct.compositionFactors;
end;


#############################################################################
##

#E  fixes_disptach.g  . . . . . . . . . . . . . . . . . . . . . . . ends here
##
