#############################################################################
##
#A  init.g                 CHEVIE library         Meinolf Geck, Frank Luebeck, 
##                                            Jean Michel and G\"otz Pfeiffer.
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen,
#Y  IWR der Universit\"at Heidelberg, Germany and University Paris VII, France.
##
##  This is the init file of the CHEVIE package.
## 
if not IsBound(CHEVIEPATH) then 
  CHEVIEPATH:=LOADED_PACKAGES.chevie;
fi;

ReadChv:= function(name)
  if not ReadPath(CHEVIEPATH, name, ".g", "ReadChv") then
     Error("CHEVIE library file '", name, "' must exist and be readable");
  fi;
end;

AUTO( ReadChv( "prg/util" ),
  CharRepresentationWords,
  DecomposedMat,
  DirectSumMat ,
  IsDiagonalMat,
  IsLowerTriangularMat,
  EigenvaluesMat,
  IsNormalizing,
  InductionTable,
  PrintInductionTable,
  DisplayInductionTable,
  FastValue,
  IntListToString,
  PointsAndRepresentativesOrbits,
  SublistUnbnd);

AUTO( ReadChv( "prg/dispatch" ),
  Coefficient,
  ReflectionDegrees,
  FakeDegrees,
  SchurElements,
  CharName,
  CharParams,
  AltInvolution, 
  AlphaInvolution, 
  BetaInvolution,
  ChevieClassInfo,
  ChevieCharInfo,
  GetChevieInfo,
  PositionId,
  PositionSgn,
  Hecke,
  ReflectionCharValue);

AUTO( ReadChv( "prg/classinv" ),
  ClassInvariants,
  PositionClass,
  CycleStructurePermOrbits,
  ShortClassListFunction,
  CentreMultFunction,
  PointsRepOrb,
  FingerPrintFunction,
  ConjugacyTestFunction);

AUTO( ReadChv( "prg/wclsinv" ),
  CoxeterGroupOpsClassInvariants,
  CoxeterCosetOpsClassInvariants,
  ComponentWordsPerm,
  ComponentWordsPermCoset,
  CoxeterClassParamCheckFunction,
  CoxeterCosetClassParamCheckFunction,
  CoxeterClassParamIrred);

AUTO( ReadChv( "prg/symbol" ),
  DoublePartitionToString,
  ShiftBeta,
  SymbolDpart,
  DefectSymbol,
  RankSymbol,
  PartBeta,
  DpartSymbol,
  vcycFakeDegreeSymbol,
  vcycGenericDegreeSymbol,
  DoublePartitions,
  DifferencePartitions);

AUTO( ReadChv( "prg/vcyc" ),
  vcyc);

AUTO( ReadChv( "prg/coxeter" ),
  AddComponentsCoxeterGroup ,
  Bruhat,
  CartanMat ,
  HighestShortRoot,
  jInductionTable,
  LeftDescentSet,
  LongestCoxeterElement,
  LongestCoxeterWord,
  MatXPerm,
  MatYPerm,
  OmegaSubgroup,
  PermMatX,
  PermMatXCoxeterElement,
  PermMatY,
  PermCoxeterWord  ,
  PrintDynkinDiagram,
  ReducedInCoxeterCoset,
  ReducedCoxeterWord ,
  RightDescentSet,
  RootsAndMatgens ,
  RootsIntCartan,
  SimpleRootsSubsystem,
  CoxeterGroup,
  FakeDegree,
  LowestPowerFakeDegrees,
  HighestPowerFakeDegrees,
  CoxeterCharTableIrred,
  CoxeterClassInfoIrred,
  CoxeterConjugacyClasses,
  PermCosetsSubgroup ,
  CoxeterWords,
  CoxeterElementsLength,
  CoxeterGroupOps,
  CoxeterLength,
  CartanName,
  Reflections,
  ReducedRightCosetRepresentatives,
  ReflectionSubgroup,
  CartanType,
  CoxeterWord);

AUTO( ReadChv( "prg/coset" ),
  # almost all functions are components of 'CoxeterCosetOps':
  CoxeterCosetOps,
  CoxeterCoset,
  CoxeterSubCoset,
  PhiFactors,
  Frobenius);

AUTO( ReadChv( "prg/hecke" ),
  CheckHeckeDefiningRelations,
  CreateHeckeBasis, 
  HeckeCentralMonomials, 
  HeckeCharTableIrred,
  HeckeCharValues,
  HeckeCharValuesGood, 
  HeckeScalarProduct,
  HeckeClassPolynomials,
  HeckeReflectionRepresentation, 
  HeckeSubAlgebra,
  JInductionTable,
  LowestPowerGenericDegrees,
  HighestPowerGenericDegrees,
  SchurElement,
  PoincarePolynomial);

AUTO( ReadChv( "prg/ctcychck" ),
  CycHeckeOps,
  HeckeCharTableCyclic,
  HeckeCharTableG4,
  HeckeCharTableG5,
  HeckeCharTableG6,
  HeckeCharTableG8,
  HeckeCharTableG9,
  HeckeCharTableG12,
  HeckeCharTableG25);

AUTO( ReadChv( "prg/complexr" ),
  ComplexReflectionGroup);

AUTO( ReadChv( "prg/kl" ),
  CriticalPair,
  KazhdanLusztigPolynomial, 
  KazhdanLusztigMue, 
  KazhdanLusztigCoefficient, 
  KLMueMat, 
  LeftCells, 
  LeftCellRepresentation);

AUTO( ReadChv( "prg/braid" ), 
  Braid, 
  PermBraid, 
  WordBraid, 
  GoodCoxeterWord);

# print welcome message.
Print("\n   WELCOME  to  the  CHEVIE  package,  Version 3  (Dec  1996)\n\n",
      "      Meinolf Geck,  Frank Luebeck,   Gerhard Hiss, \n",
      "      Gunter Malle,  Jean Michel, and Goetz Pfeiffer,\n",
      "          Lehrstuhl D fuer Mathematik, RWTH Aachen,\n",
      "          IWR der Universitaet Heidelberg,\n",
      "          University of St. Andrews and\n",
      "          Universite Paris VII\n\n",
      "   This replaces the former weyl package.",
      " For first help type\n\n",
      "          ?CHEVIE Version 3 -- a short introduction\n\n");

# initialize global control variables.
CHEVIE:=rec(version:="3",
  PrintBraid:= "Deligne",
  PrintHecke:= "",
  BrieskornNormalForm:=false
);

ReadChvTbl:= function(f)local files,fields;
  fields:=["A","B","D","E6","E7","E8","H3","H4","G2","F4","I",
           "2I","3D4","2E6","2D","2A"];
  files:=["weyla","weylb","weyld","weyle6","weyle7","weyle8","coxh3",
                "coxh4", "weylg","weylf","coxi","cox2i","weyl3d4",
               "weyl2e6","weyl2d","weyl2a"];
  if not IsBound(CHEVIE.(f)) then 
    ReadChv(ConcatenationString("tbl/",files[Position(fields,f)]));
  fi;
  return CHEVIE.(f);
end;

if not IsBound(InfoChevie) then InfoChevie:=Ignore;fi;

ReadChv("prg/libpatch");
