#############################################################################
##
#A  dispatch.g               CHEVIE library                       Jean Michel
##
#A  $Id: dispatch.g,v 1.1 1997/01/21 13:46:28 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##   This file contains generic functions defined in the package 'chevie'
##   Jean Michel 7-9-96
##

##  The following is a generic "helper" function which allows one to write,
##  AlphaInvolution(h) instead of h.operations.AlphaInvolution(h).

AlphaInvolution:=function(h)
  if IsRec(h) and IsBound(h.operations) 
	      and IsBound(h.operations.AlphaInvolution)
  then return h.operations.AlphaInvolution(h);
  else Error("object has no method for Alpha Involution");
  fi;
end;

##  The following is a generic "helper" function which allows one to write,
##  AltInvolution(h) instead of h.operations.AltInvolution(h).

AltInvolution := function(h)
  if IsRec(h) and IsBound(h.operations) 
	      and IsBound(h.operations.AltInvolution)
  then return h.operations.AltInvolution(h);
  else Error("object has no method for Alt Involution");
  fi;
end;

##  The following is a generic "helper" function which allows one to write,
##  BetaInvolution(h) instead of h.operations.BetaInvolution(h).

BetaInvolution := function(h)
  if IsRec(h) and IsBound(h.operations) 
	      and IsBound(h.operations.BetaInvolution)
  then return h.operations.BetaInvolution(h);
  else Error("object has no method for Beta Involution");
  fi;
end;

#############################################################################
##
#F  Coefficient( <a>, <b> ) . . . . . . . . . 'generic' routine which
#F  looks if a has .operations.Coefficient and returns
##  a.operations.Coefficient(a,b).
##
##  (I would expect that something like Coefficient(q^2+q+1,q) would exist,
##   but it does not...)
##
Coefficient:=function(arg)
  if IsRec(arg[1]) and IsBound(arg[1].operations) 
  and IsBound(arg[1].operations.Coefficient) then
    return ApplyFunc(arg[1].operations.Coefficient,arg);
  else
    Error("no method for Coefficient(",arg[1],",...)");
  fi;
end;

##############################################################################
#
# The following functions are generic since they have (or will have)
# different versions for Coxeter groups, Coxeter cosets, 
# Complex refl. groups
#
FakeDegrees:=function(W,q)return W.operations.FakeDegrees(W,q);end;

SchurElements:=H->H.operations.SchurElements(H);

ReflectionDegrees:=function(W)
  if not IsBound(W.degrees) then 
    W.degrees:=W.operations.ReflectionDegrees(W);
  fi;
  return W.degrees;
end;

CharName:=function(W,p)return W.operations.CharName(W,p);end;

CharParams:=function(W)
  local ct;
  if IsRec(W) and IsBound(W.operations) and 
                      IsBound(W.operations.CharParams) then
    return W.operations.CharParams(W);
  else
    ct:=CharTable(W);
    if IsBound(ct.irredinfo) and IsBound(ct.irredinfo[1].charparam) then
      return List(ct.irredinfo,x->x.charparam);
    else
      return [1..Length(ct.irreducibles)];
    fi;
  fi;
end;

PositionId:=function(W)
  local ti;
  if IsBound(W.operations.PositionId) then
    return W.operations.PositionId(W);
  elif IsGroup(W) then 
    ti:=CharTable(W);
    return Position(ti.irreducibles,ti.irreducibles[1]*0+1);
  elif IsCharTable(W) then
    return Position(W.irreducibles,W.irreducibles[1]*0+1);
  else
    Error("PositionId not defined \n");
  fi;
end;

PositionSgn:=function(W)
  if IsBound(W.operations.PositionSgn) then
    return W.operations.PositionSgn(W);
  fi;
end;

ChevieClassInfo:=function(W)
  return W.operations.ChevieClassInfo(W);
end;

ChevieCharInfo:=function(W)
  return W.operations.ChevieCharInfo(W);
end;

GetChevieInfo:=function(W,fname)
  return W.operations.GetChevieInfo(W,fname);
end;

Hecke:=function(arg)local W,H,i;
  W:=arg[1]; 
  if not IsRec(W) or not (IsBound(W.hecke) or (IsBound(W.operations)
     and IsBound(W.operations.Hecke)))
  then Error("first argument should be a record with .hecke or have a method Hecke");
  fi;
  # get back the .hecke entry of a record:
  if IsBound(W.hecke) then return W.hecke;
  else return ApplyFunc(W.operations.Hecke,arg);
  fi;
end;

ReflectionCharValue:=function(arg)local W;
  W:=arg[1]; 
  if not (IsRec(W) and IsBound(W.operations) and IsBound(W.operations.ReflectionCharValue))
  then Error("first argument should have a method ReflectionCharValue");
  fi;
  return ApplyFunc(W.operations.ReflectionCharValue,arg);
end;
