#************** TEMPORARY *********************
# We hope that the following functions become part of the GAP-library
# (some are improvements of existing functions).
# Until then we overwrite them here.
#
#   Frank Luebeck, Jean Michel
#
# We also hope that the manual for GAP3.4 patch 4 will be patched to
# document the 3rd argument of Position and ApplyFunc, that we (and the
# user of our package) use.
#

# PositionSet is now in the library

#############################################################################
##
#F  SortByLess( <list> ) . . . . . . . . . same as 'Sort( <list> )', but
#F  no second argument possible
##  
##  It is faster than 'Sort' because it uses the internal function 'Set'.
##  
SortByLess:=function(list)
  local  both, perm, i, l;
  l:=Length(list);
  both := [  ];
  for i  in [ 1 .. l ]  do
    both[i] := [ list[i], i ];
  od;
  both:=Set( both );
  for i  in [ 1 .. l ]  do
    list[i] := both[i][1];
  od;
end;

#############################################################################
##
#F  SortByLessParallel( <list>, <list2> ) . . . . . . like 'SortParallel'
#F  but comparisons only by '<'
##  
##  It is faster than 'SortParallel' because it uses the internal function 
##  'Set'.
##  
SortByLessParallel:=function(l1,l2)
  local  both, perm, i, l;
  if not IsList(l1) and IsList(l2) and Length(l1)=Length(l2) then
    Error("arguments must be lists of equal length\n"); 
  fi;
  l:=Length(l1);
  both := [  ];
  for i  in [ 1 .. l ]  do
    both[i] := [ l1[i], i , l2[i]];
  od;
  both:=Set( both );
  for i  in [ 1 .. l ]  do
    l1[i] := both[i][1];
    l2[i] := both[i][3];
  od;
end;

# Sortex is now in the library
# SortingPerm is now in the library
# PermListList is now in the library
# Permuted is now in the library
# Reversed is now in the library

# There was a minor bug in this function:

PolynomialOps.String:= function ( f )
    local  x, i, d, v, s, l, one, sone;
    x := Indeterminate( f.baseRing );
    if IsBound( x.name )  then
        x := x.name;
    else
        x := "x";
    fi;
    one := f.baseRing.one;
    sone := String( one );
    v := f.valuation - 1;
    l := Length( f.coefficients );
    for i  in [ l, l - 1 .. 1 ]  do
        d := f.coefficients[i];
# old line:  if 0 <> d then 
        if 0 * d <> d  then
            if i = l and d = one and i + v <> 0  then
                s := "";
            elif i = l and d = one  then
                s := String( one );
            elif i = l and d = -1 * one and i + v <> 0  then
                s := "-";
            elif i = l and d = -1 * one  then
                s := ConcatenationString( "-", sone );
            elif i = l  then
                s := ConcatenationString( "(", String( d ), ")" );
            elif d = 1 and i + v <> 0  then
                s := ConcatenationString( s, "+" );
            elif d = 1  then
                s := ConcatenationString( s, "+", sone );
            elif d = -1 and i + v <> 0  then
                s := ConcatenationString( s, "-" );
            elif d = -1  then
                s := ConcatenationString( s, "-", sone );
            elif 0 * d <> d  then
                s := ConcatenationString( s, "+(", String( d ), ")" );
            else
                Error( "internal error in 'RationalsPolynomialOps.String'" );
            fi;
            if i + v < 0 or 1 < i + v  then
                s := ConcatenationString( s, x, "^", String( i + v ) );
            elif i + v = 1  then
                s := ConcatenationString( s, x );
            fi;
        fi;
    od;
    if l = 0  then
        s := "0";
    fi;
    return s;
end;
