#############################################################################
##
#A  symbol.g                CHEVIE library       Meinolf Geck, Frank L\"ubeck, 
#A                                                Jean Michel, G\"otz Pfeiffer
##
#A  $Id: symbol.g,v 1.1 1997/01/21 13:46:34 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains a few functions dealing with double partitions and
##  symbols for unipotent characters of classical groups which are used in
##  weylb.g and weyld.g, in order to factor out some common code in these 
##  files.
##  Of course these functions might be re-used/modified by Frank to serve
##  in other parts of the Chevie Package.
##       Jean 13-9-96
##  
#############################################################################
##
#F  DoublePartitionToString( <dblpart> ) . . . . . . . . . . as the name says
##  
##  'IntListToString' is applied to the  two partitions in <dblpart> and
##  the results are concatenated by a separating '.':
##  
##     [[],[2,1,1]]      --->    ".211"
##     [[4,3],[2,1,1]]   --->    "43.211"
##     [[14,3],[2,1,1]]  --->    "(14,3).211"
##  
DoublePartitionToString:=function(p)
  return Concatenation(IntListToString(p[1]),".",IntListToString(p[2]));
end;

# shift a list of beta-numbers
ShiftBeta:=function(beta,n)return Concatenation([0..n-1],beta+n);end;

# gives the reduced symbol of defect k corresponding to double partition d
SymbolDpart := function(d,k)local S,s;
    s:=k+Length(d[2])-Length(d[1]);
    S:=List(d,BetaSet);
    if s>0 then S[1]:=ShiftBeta(S[1],s);
    else        S[2]:=ShiftBeta(S[2],-s);
    fi;
    return S;
end;

# defect of a symbol
DefectSymbol:=d->Length(d[1])-Length(d[2]); 

# rank of a symbol
RankSymbol:=s->Sum(s,Sum)-QuoInt((Sum(s,Length)-1)^2,4);

# gives the partition corresponding to a list b of beta-numbers
PartBeta:=function(b)
  if Length(b)=0 then return []; # needed since []+[] is an error!!!
  else return Reversed(Filtered(b+[0,-1..1-Length(b)],x->x<>0));
  fi;
end;
	  
# gives the double partition corresponding to a symbol x
DpartSymbol:=x->List(x,PartBeta);

# Returns the fake degree of the unipotent character corresponding to
# symbol s as a 'vcyc' (see vcyc.g)
#
vcycFakeDegreeSymbol:=function(s)local res,S,T,delta,theta,a,b,r,t,d;

  delta:=S->Product(Filtered(Cartesian(S,S),x->x[1]>x[2]),
                                      x->vcyc(2*x[1],2*x[2],-1));

  theta:=S->Product(Filtered(S,x->x>0),l->Product([1..l],h->vcyc(2*h,0,-1)));

  d:=DefectSymbol(s);
  r:=RankSymbol(s);

  if d>2 then return vcyc(0,0,-1);
  elif d=2 then  s:=SymbolDpart(DpartSymbol(s),0); S:=t[1]; T:=t[2];
  else S:=s[1]; T:=s[2];
  fi;

  if d mod 2<>0 then res:=theta([r]);
  elif d mod 4=0 then res:=theta([r-1])*vcyc(r,0,-1);
  else res:=theta([r-1])*vcyc(r,0,1);
  fi;

  if d mod 2<>0 then res:=res*vcyc(Sum(T),Sum(T),1);res.coeff:=res.coeff/2;
  elif d mod 4=0 then res:=res*vcyc(Sum(S),Sum(T),1);
    if S=T then res.coeff:=res.coeff/2;fi;
  else res:=res*vcyc(Sum(S),Sum(T),-1);
  fi;
  
  res:=res*delta(S)*delta(T);

  a:=Length(S)+Length(T);
  res.vcyc[1]:=res.vcyc[1]-Sum([a-2,a-4..a mod 2],x->x*(x-1)/2);
  return res/theta(S)/theta(T);
end;

# generic degree of the unipotent character corresponding to symbol s
vcycGenericDegreeSymbol:=function(s)local res,S,T,delta,theta,a,b,r,d;

  delta:=S->Product(Filtered(Cartesian(S,S),x->x[1]>x[2]),
                                                     x->vcyc(x[1],x[2],-1));

  theta:=S->Product(Filtered(S,x->x>0),l->Product([1..l],h->vcyc(2*h,0,-1)));

  S:=s[1]; T:=s[2];a:=Length(S);b:=Length(T);

  d:=DefectSymbol(s);
  r:=RankSymbol(s);

  if d mod 2 <>0 then res:=theta([r]);
  elif d mod 4 =0 then res:=theta([r-1])*vcyc(r,0,-1);
  else res:=theta([r-1])*vcyc(r,0,1);
  fi;

  res:=res*delta(S)*delta(T)*Product(Cartesian(S,T),x->vcyc(x[1],x[2],1));

  a:=Length(S)+Length(T);
  res.vcyc[1]:=res.vcyc[1]-Sum([a-2,a-4..a mod 2],x->x*(x-1)/2);
  res:=res/theta(S)/theta(T);
  if S=T then res.coeff:=res.coeff/2^Length(S); 
  else res.coeff:=res.coeff/2^QuoInt(a-1,2);
  fi;
  return res;
end;

#############################################################################
##
#F  DoublePartitions( <n> ) . . . . . . . . . . . . . .  pairs of partitions.
##
##  JM: why is not PartitionTuples(n,2) usable?
##      if there is a reason it should be put in comments
##
DoublePartitions:= function(n)

   local m, k, pm, t, s, res;

   if n = 0 then
      return [[[], []]];
   fi;

   pm:= List([1..n], x->[]);

   #  second position.
   for m in [1..n] do 

      #  add the m-cycle.
      Add(pm[m], [[], [m]]);
      for k in [m+1..n] do
         for t in pm[k-m] do
            s:= [[], [m]];
            Append(s[2], t[2]);
            Add(pm[k], s);
         od;
      od;
   od;

   #  first position.
   for m in [1..QuoInt(n,2)] do 

      #  add the m-cycle.
      Add(pm[m], [[m], []]);
      for k in [m+1..n-m] do
         for t in pm[k-m] do
            s:= [[m], t[2]];
            Append(s[1], t[1]);
            Add(pm[k], s);
         od;
      od;
   od;

   #  collect.
   res:= [];
   for k in [1..n-1] do
      for t in pm[n-k] do
         s:= [[k], t[2]];
         Append(s[1], t[1]);
         Add(res, s);
      od;
   od;
   Add(res, [[n], []]);
   Append(res, pm[n]);

   return res;

end;

#############################################################################
##
#F  DifferencePartitions( <gamma>, <alpha> ) . . .  difference of partitions.
##
##  This function computes the  difference of two  partitions, if it  exists, 
##  and returns the number of hooks ('cc'), their combined  leg length ('ll')
##  and the contents of a box  underneath the last hook ('d').  If  <gamma> -
##  <alpha> doesn't  exist or contains a  2x2 box then  'false' is  returned.
##  This function is  needed for the  computation of single  character values
##  for Hecke algebras of types A, B or D.
##  
DifferencePartitions:= function(gamma, alpha)

   local i, dp, old, new, int, inhook;

   # initialize.
   dp:= rec(cc:= 0, ll:= 0);

   if Length(alpha) > Length(gamma) then
      return false;
   fi;

   old:= []; inhook:= false;  alpha:= Copy(alpha);
   for i in [Length(alpha)+1..Length(gamma)] do
      alpha[i]:= 0;
   od;
   for i in [1..Length(gamma)] do
      if alpha[i] > gamma[i] then
         return false;
      fi;
      new:= [alpha[i]+1..gamma[i]];
      int:= Intersection(old, new);
      if Length(int) > 1 then
         return false;
      elif Length(int) = 1 then
         dp.ll:= dp.ll + 1;
      else # int = [];
         if inhook then
            dp.cc:= dp.cc + 1;
            dp.d:= old[1] - i;
            inhook:= false;
         fi;
      fi;
      if new <> [] then
         inhook:= true;
      fi;
      old:= new;
   od;

   if inhook then
      dp.cc:= dp.cc + 1;
      dp.d:= old[1] - Length(gamma) - 1;
   fi;

   return dp;

end;
