## the test requires 3.4.3 or 3.5 ###########################################
if not IsBound(DefinePkgBinPath)  then
  Error( "sorry, this test doesn't work with version ", VERLIB );
fi;

## we need the meataxe ######################################################
if not IsBound(MeatAxe)  then
  RequirePackage("meataxe");
  Print("#I  this test requires the meataxe, if you get an error message\n");
  Print("#I  first check that the meataxe is installed correctly\n");
fi;

## create table for GF(2) ###################################################
f := GF(2) ;
MeatAxe.Maketab(Size(f));

## and register the meataxe matrices ########################################
m1 := MeatAxeMat(Concatenation(XGAPLIBNAME,"../tst/meatmat.1"),f,[164,164]);
m2 := MeatAxeMat(Concatenation(XGAPLIBNAME,"../tst/meatmat.2"),f,[164,164]);

## create the algebra <a> generated by <m1> and <m2> ########################
a := Algebra( f, [m1,m2] );

## and the natural module <m> of <a> ########################################
m := NaturalModule(a);


l := PartialModuleLattice(m);
