##############################################################################
##
##  cat1list.g               for GAP 3.4                      version  9/12/96
##
##############################################################################
##
#A  cat1list.g               GAP library                         Chris Wensley
#A                                                                   Murat Alp
#Y  Copyright
##
##  This file contains data on cat1-groups and crossed modules up to size 47
##
#H  $Log: cat1list.g,v $
#H  Revision 1.1  1997/03/27 13:35:44  gap
#H      Added xmod 1.31
#H
#H  	    SL
#H

##  Global constant specifying the maximum size for Cat1List :-

Cat1ListMaxSize := 47;

##############################################################################
##
##  NumbersOfIsomorphismClasses          for groups of size <= Cat1ListMaxSize
##

NumbersOfIsomorphismClasses := 
   [   1,  1,  1,  2,  1,  2,  1,  5,  2,  2,
       1,  5,  1,  2,  1, 14,  1,  5,  1,  5,
       2,  2,  1, 15,  2,  2,  5,  4,  1,  4,
       1, 51,  1,  2,  1, 14,  1,  2,  2, 14,
       1,  6,  1,  4,  2,  2,  1               ];

##############################################################################
##
##  Cat1List cat1-structures for iso-classes of gps of size <= Cat1ListMaxSize
##

Cat1List := [
[1,1,[ ],"triv",[ ] ],
[2,1,[(1,2)],"c2",
        [ [ [ ],"c2","triv",[()],[()] ] ] ],
[3,1,[(1,2,3)],"c3",
        [ [ [ ],"c3","triv",[()],[()] ] ] ],
[4,1,[(1,2),(3,4)],"k4",
        [ [ [ ],"k4","triv",[(),()],[(),()] ],
          [ [(3,4)],"c2","c2",[(),(3,4)],[(),(3,4)] ],
          [ [(3,4)],"c2","c2",[(3,4),(3,4)],[(),(3,4)] ] ] ],
[4,2,[(1,2,3,4)],"c4",
        [ [ [ ],"c4","triv",[()],[()] ] ] ],
[5,1,[(1,2,3,4,5)],"c5",
        [ [ [ ],"c5","triv",[()],[()] ] ] ],
[6,1,[(1,2,3)(4,5)],"c6",
        [ [ [ ],"c6","triv",[()],[()] ] ,
          [ [(4,5)],"c3","c2",[(4,5)],[(4,5)] ],
          [ [(1,2,3)],"c2","c3",[(1,2,3)],[(1,2,3)] ] ] ],
[6,2,[(1,2),(2,3)],"s3",
        [ [ [(2,3),(2,3)],"c3","c2",[(2,3),(2,3)],[(2,3),(2,3)] ] ] ],
[7,1,[(1,2,3,4,5,6,7)],"c7",
        [ [ [ ],"c7","triv",[()],[()] ] ] ],
[8,1,[(1,2),(3,4),(5,6)],"c2^3",
        [ [ [ ],"c2^3","triv",[(),(),()],[(),(),()] ],
          [ [(5,6)],"k4","c2",[(),(),(5,6)],[(),(),(5,6)] ],
          [ [(5,6)],"k4","c2",[(),(5,6),(5,6)],[(),(),(5,6)] ],
          [ [(3,4),(5,6)],"c2","k4",[(),(3,4),(5,6)],[(),(3,4),(5,6)] ],
          [ [(3,4),(5,6)],"c2","k4",
              [(5,6),(3,4),(5,6)],[(),(3,4),(5,6)] ] ] ],
[8,2,[(1,2,3,4),(5,6)],"c4c2",
        [ [ [ ],"c4c2","triv",[(),()],[(),()] ],
          [ [(5,6)],"c4","c2",[(),(5,6)],[(),(5,6)] ],
          [ [(5,6)],"c4","c2",[(5,6),(5,6)],[(),(5,6)] ],
          [ [(1,2,3,4)],"c2","c4",[(1,2,3,4),()],[(1,2,3,4),()] ],
          [ [(1,2,3,4)],"c2","c4",
              [(1,2,3,4),(1,3)(2,4)],[(1,2,3,4),()] ] ] ],
[8,3,[(1,2,3,4,5,6,7,8)],"c8",
        [ [ [ ],"c8","triv",[()],[()] ] ] ],
[8,4,[(1,2,3,4),(1,3)],"d8",
        [ [ [(2,4)],"c4","c2",[(),(2,4)],[(),(2,4)] ],
        [ [(2,4),(2,4)],"k4","c2",[(2,4),(2,4)],[(2,4),(2,4)] ] ] ],
[8,5,[(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5)],"q8",[ ] ],
[9,1,[(1,2,3),(4,5,6)],"c3^2",
        [ [ [ ],"c3^2","triv",[(),()],[(),()] ],
          [ [(4,5,6)],"c3","c3",[(),(4,5,6)],[(),(4,5,6)] ],
          [ [(4,5,6)],"c3","c3",[(4,5,6),(4,5,6)],[(),(4,5,6)] ] ] ],
[9,2,[(1,2,3,4,5,6,7,8,9)],"c9",
        [ [ [ ],"c9","triv",[()],[()] ] ] ],
[10,1,[(1,2,3,4,5)(6,7)],"c10",
        [ [ [ ],"c10","triv",[()],[()] ],
          [ [(6,7)],"c5","c2",[(6,7)],[(6,7)] ],
          [ [(1,2,3,4,5)],"c2","c5",[(1,2,3,4,5)],[(1,2,3,4,5)] ] ] ],
[10,2,[(1,2,3,4,5),(2,5)(3,4)],"d10",
        [ [ [(2,5)(3,4)],"c5","c2",[(),(2,5)(3,4)],[(),(2,5)(3,4)] ] ] ],
[11,1,[(1,2,3,4,5,6,7,8,9,10,11)],"c11",
        [ [ [ ],"c11","triv",[()],[()] ] ] ],
[12,1,[(1,2,3),(4,5),(6,7)],"c6c2",
        [ [ [ ],"c6c2","triv",[(),(),()],[(),(),()] ],
          [ [(6,7)],"c6","c2",[(),(),(6,7)],[(),(),(6,7)] ],
          [ [(6,7)],"c6","c2",[(),(6,7),(6,7)],[(),(),(6,7)] ],
          [ [(1,2,3)],"k4","c3",[(1,2,3),(),()],[(1,2,3),(),()] ],
          [ [(4,5),(6,7)],"c3","k4",[(),(4,5),(6,7)],[(),(4,5),(6,7)] ],
          [ [(1,2,3),(6,7)],"c2","c6",
              [(1,2,3),(),(6,7)],[(1,2,3),(),(6,7)] ],
          [ [(1,2,3),(6,7)],"c2","c6",
              [(1,2,3),(6,7),(6,7)],[(1,2,3),(),(6,7)] ] ] ],
[12,2,[(1,2,3,4),(5,6,7)],"c12",
        [ [ [ ],"c12","triv",[(),()],[(),()] ],
          [ [(5,6,7)],"c4","c3",[(),(5,6,7)],[(),(5,6,7)] ],
          [ [(1,2,3,4)],"c3","c4",[(1,2,3,4),()],[(1,2,3,4),()] ] ] ],
[12,3,[(1,2),(2,3),(4,5)],"d12",
        [ [ [(2,3)(4,5),(2,3)(4,5)],"c6","c2",
              [(2,3)(4,5),(2,3)(4,5),()],[(2,3)(4,5),(2,3)(4,5),()] ],
          [ [(2,3),(2,3),(4,5)],"c3","k4",
              [(2,3),(2,3),(4,5)],[(2,3),(2,3),(4,5)] ],
          [ [(1,2),(2,3)],"c2","s3",
              [(1,2),(2,3),()],[(1,2),(2,3),()] ] ] ],
[12,4,[(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7)],"q12",
        [ [ [(1,2)(3,4),(1,3,2,4)(6,7)],"c3","c4",
              [(1,2)(3,4),(1,3,2,4)(6,7)],[(1,2)(3,4),(1,3,2,4)(6,7)] ] ] ],
[12,5,[(1,2,3),(2,3,4)],"a4",
        [ [ [(2,4,3),(2,3,4)],"k4","c3",
              [(2,4,3),(2,3,4)],[(2,4,3),(2,3,4)] ] ] ],
[13,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13)],"c13",
        [ [ [ ],"c13","triv",[()],[()] ] ] ],
[14,1,[(1,2,3,4,5,6,7),(8,9)],"c14",
        [ [ [ ],"c14","triv",[(),()],[(),()] ],
          [ [(8,9)],"c7","c2",[(),(8,9)],[(),(8,9)] ],
          [ [(1,2,3,4,5,6,7)],"c2","c7",
             [(1,2,3,4,5,6,7),()],[(1,2,3,4,5,6,7),()] ] ] ],
[14,2,[(1,2,3,4,5,6,7),(2,7)(3,6)(4,5)],"d14",
        [ [ [(2,7)(3,6)(4,5)],"c7","c2",
              [(),(2,7)(3,6)(4,5)],[(),(2,7)(3,6)(4,5)] ] ] ],
[15,1,[(1,2,3,4,5),(6,7,8)],"c15",
        [ [ [ ],"c15","triv",[(),()],[(),()] ],
          [ [(6,7,8)],"c5","c3",[(),(6,7,8)],[(),(6,7,8)] ],
          [ [(1,2,3,4,5)],"c3","c5",
              [(1,2,3,4,5),()],[(1,2,3,4,5),()] ] ] ],
[16,1,[(1,2),(3,4),(5,6),(7,8)],"c2^4",
        [ [ [ ],"c2^4","triv",[(),(),(),()],[(),(),(),()] ],
          [ [(7,8)],"c2^3","c2",[(),(),(),(7,8)],[(),(),(),(7,8)] ],
          [ [(7,8)],"c2^3","c2",[(),(),(),(7,8)],[(),(),(7,8),(7,8)] ],
          [ [(5,6),(7,8)],"k4","k4",
                  [(),(),(5,6),(7,8)],[(),(),(5,6),(7,8)] ],
          [ [(5,6),(7,8)],"k4","k4",
                  [(),(),(5,6),(7,8)],[(),(7,8),(5,6),(7,8)] ],
          [ [(5,6),(7,8)],"k4","k4",
                  [(),(),(5,6),(7,8)],[(5,6),(7,8),(5,6),(7,8)] ],
          [ [(3,4),(5,6),(7,8)],"c2","c2^3",
                  [(),(3,4),(5,6),(7,8)],[(),(3,4),(5,6),(7,8)] ],
          [ [(3,4),(5,6),(7,8)],"c2","c2^3",
                  [(),(3,4),(5,6),(7,8)],[(3,4),(3,4),(5,6),(7,8)] ] ] ],
[16,2,[(1,2),(3,4),(5,6,7,8)],"c4k4",
        [ [ [ ],"c4k4","triv",[(),(),()],[(),(),()] ],
          [ [(3,4)],"c4c2","c2",[(),(3,4),()],[(),(3,4),()] ],
          [ [(3,4)],"c4c2","c2",[(),(3,4),()],[(3,4),(3,4),()] ],
          [ [(3,4)],"c4c2","c2",[(),(3,4),()],[(),(3,4),(3,4)] ],
          [ [(1,2),(3,4)],"c4","k4",[(1,2),(3,4),()],[(1,2),(3,4),()] ],
          [ [(1,2),(3,4)],"c4","k4",
              [(1,2),(3,4),(3,4)],[(1,2),(3,4),()] ],
          [ [(5,6,7,8)],"k4","c4",[(),(),(5,6,7,8)],[(),(),(5,6,7,8)] ],
          [ [(5,6,7,8)],"k4","c4",
              [(),(),(5,6,7,8)],[(),(5,7)(6,8),(5,6,7,8)] ],
          [ [(3,4),(5,6,7,8)],"c2","c4c2",
              [(),(3,4),(5,6,7,8)],[(),(3,4),(5,6,7,8)] ],
          [ [(3,4),(5,6,7,8)],"c2","c4c2",
              [(5,7)(6,8),(3,4),(5,6,7,8)],[(),(3,4),(5,6,7,8)] ],
          [ [(3,4),(5,6,7,8)],"c2","c4c2",
              [(3,4),(3,4),(5,6,7,8)],[(),(3,4),(5,6,7,8)] ] ] ],
[16,3,[(1,2),(3,4,5,6,7,8,9,10)],"c8c2",
        [ [ [ ],"c8c2","triv",[(),()],[(),()] ],
          [ [(1,2)],"c8","c2",[(1,2),()],[(1,2),()] ],
          [ [(1,2)],"c8","c2",[(1,2),(1,2)],[(1,2),()] ],
          [ [(3,4,5,6,7,8,9,10)],"c2","c8",
              [(),(3,4,5,6,7,8,9,10)],[(),(3,4,5,6,7,8,9,10)] ],
          [ [(3,4,5,6,7,8,9,10)],"c2","c8",
              [(3,7)(4,8)(5,9)(6,10),(3,4,5,6,7,8,9,10)],
                 [(),(3,4,5,6,7,8,9,10)] ] ] ],
[16,4,[(1,2,3,4),(5,6,7,8)],"c4^2",
        [ [ [ ],"c4^2","triv",[(),()],[(),()] ],
          [ [(5,6,7,8)],"c4","c4",[(),(5,6,7,8)],[(),(5,6,7,8)] ],
          [ [(5,6,7,8)],"c4","c4",
              [(5,7)(6,8),(5,6,7,8)],[(),(5,6,7,8)] ],
          [ [(5,6,7,8)],"c4","c4",
              [(5,6,7,8),(5,6,7,8)],[(),(5,6,7,8)] ] ] ],
[16,5,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)],"c16",
        [ [ [ ],"c16","triv",[()],[()] ] ] ],
[16,6,[(1,2,3,4),(2,4),(5,6)],"d8c2",
        [ [ [(1,2)(3,4)],"c4c2","c2",
              [(),(1,2)(3,4),()],[(),(1,2)(3,4),()] ],
          [ [(1,2)(3,4)],"c2^3","c2",
              [(1,2)(3,4),(),()],[(1,2)(3,4),(),()] ],
          [ [(2,4),(5,6)],"c4","k4",
              [(5,6),(2,4),(5,6)],[(5,6),(2,4),(5,6)] ],
          [ [(2,4),(5,6)],"c4","k4",
              [(),(2,4),(5,6)],[(5,6),(2,4),(5,6)] ],
          [ [(2,4),(5,6)],"k4","k4",
              [(2,4)(5,6),(2,4),(5,6)],[(2,4)(5,6),(2,4),(5,6)] ],
          [ [(2,4),(5,6)],"k4","k4",
              [(2,4),(2,4),(5,6)],[(2,4)(5,6),(2,4),(5,6)] ],
          [ [(1,2,3,4),(2,4)],"c2","d8",
              [(1,2,3,4),(2,4),(1,3)(2,4)],[(1,2,3,4),(2,4),(1,3)(2,4)] ],
          [ [(1,2,3,4),(2,4)],"c2","d8",
              [(1,2,3,4),(2,4),()],[(1,2,3,4),(2,4),(1,3)(2,4)] ] ] ],
[16,7,[(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),(9,10)],"q8c2",
        [ [ [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5)],"c2","q8",
            [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()],
            [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()] ],
          [ [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5)],"c2","q8",
            [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),(1,2)(3,4)(5,6)(7,8)],
            [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()] ] ] ],
[16,8,[(1,2,3,4)(5,6,7,8),(5,7)(6,8),(1,5)(2,6)(3,7)(4,8)],"d8y4",
        [ [ [(1,5)(2,6)(3,7)(4,8)],"c4c2","c2",
            [(),(),(1,5)(2,6)(3,7)(4,8)],[(),(),(1,5)(2,6)(3,7)(4,8)] ] ] ],
[16,9,[(1,2,3,4)(5,6,7,8),(1,4,5,8)(3,2,7,6)],"c4c2|Xc2",
        [ [ [(2,8)(4,6)],"c4c2","c2",[(),(2,8)(4,6)],[(),(2,8)(4,6)] ],
          [ [(1,2,3,4)(5,6,7,8)],"k4","c4",
            [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8)],
            [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8)] ],
          [ [(1,2,3,4)(5,6,7,8)],"k4","c4",
            [(1,2,3,4)(5,6,7,8),(1,4,3,2)(5,8,7,6)],
            [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8)] ] ] ],
[16,10,[(1,2,3,4),(1,3)(5,6,7,8)],"c4|Xc4",
        [ [ [(2,4)(5,6,7,8)],"c4","c4",
            [(),(2,4)(5,6,7,8)],[(),(2,4)(5,6,7,8)] ],
          [ [(2,4)(5,6,7,8)],"c4","c4",
            [(5,7)(6,8),(2,4)(5,6,7,8)],[(),(2,4)(5,6,7,8)] ] ] ],
[16,11,[(1,2,3,4,5,6,7,8),(2,6)(4,8)],"c2|Xc8",
        [ [ [(2,6)(4,8)],"c8","c2",[(),(2,6)(4,8)],[(),(2,6)(4,8)] ] ] ],
[16,12,[(1,2,3,4,5,6,7,8),(2,8)(3,7)(4,6)],"d16",
        [ [ [(2,8)(3,7)(4,6)],"c8","c2",
            [(),(2,8)(3,7)(4,6)],[(),(2,8)(3,7)(4,6)] ] ] ],
[16,13,[(1,2,3,4,5,6,7,8),(2,4)(3,7)(6,8)],"qd16",
        [ [ [(2,4)(3,7)(6,8)],"c8","c2",
            [(),(2,4)(3,7)(6,8)],[(),(2,4)(3,7)(6,8)] ] ] ],
[16,14,[(1,2,3,4,5,6,7,8)(9,16,15,14,13,12,11,10),
         (1,9,5,13)(2,10,6,14)(3,11,7,15)(4,12,8,16)],"q16",[ ] ],
[17,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17)],"c17",
        [ [ [ ],"c17","triv",[()],[()] ] ] ],
[18,1,[(1,2,3)(4,5),(6,7,8)],"c6c3",
        [ [ [ ],"c6c3","triv",[(),()],[(),()] ],
          [ [(4,5)],"c3^2","c2",[(4,5),()],[(4,5),()] ],
          [ [(6,7,8)],"c6","c3",[(),(6,7,8)],[(),(6,7,8)] ],
          [ [(6,7,8)],"c6","c3",[(6,7,8),(6,7,8)],[(),(6,7,8)] ],
          [ [(4,5),(6,7,8)],"c3","c6",[(4,5),(6,7,8)],[(4,5),(6,7,8)] ],
          [ [(4,5),(6,7,8)],"c3","c6",
              [(4,5)(6,7,8),(6,7,8)],[(4,5),(6,7,8)] ],
          [ [(1,2,3),(6,7,8)],"c2","c3^2",
              [(1,2,3),(6,7,8)],[(1,2,3),(6,7,8)] ] ] ],
[18,2,[(1,2,3,4,5,6,7,8,9)(10,11)],"c18",
        [ [ [ ],"c18","triv",[()],[()] ],
          [ [(10,11)],"c9","c2",[(10,11)],[(10,11)] ],
          [ [(1,2,3,4,5,6,7,8,9)],"c2","c9",
              [(1,2,3,4,5,6,7,8,9)],[(1,2,3,4,5,6,7,8,9)] ] ] ],
[18,3,[(1,2,3,4,5,6,7,8,9),(1,9)(2,8)(3,7)(4,6)],"d18",
        [ [ [(2,9)(3,8)(4,7)(5,6)],"c9","c2",
              [(),(2,9)(3,8)(4,7)(5,6)],[(),(2,9)(3,8)(4,7)(5,6)] ] ] ],
[18,4,[(1,2,3),(2,3),(4,5,6)],"s3c3",
        [ [ [(2,3)],"c3^2","c2",[(),(2,3),()],[(),(2,3),()] ],
          [ [(2,3),(4,5,6)],"c3","c6",
              [(),(2,3),(4,5,6)],[(),(2,3),(4,5,6)] ],
          [ [(1,2,3),(2,3)],"c3","s3",
              [(1,2,3),(2,3),()],[(1,2,3),(2,3),()] ] ] ],
[18,5,[(1,2,3),(4,5,6),(2,3)(5,6)],"c3^2|Xc2",
        [ [ [(2,3)(5,6)],"c3^2","c2",
              [(),(),(2,3)(5,6)],[(),(),(2,3)(5,6)] ],
          [ [(4,5,6),(2,3)(5,6)],"c3","s3",
              [(),(4,5,6),(2,3)(5,6)],[(),(4,5,6),(2,3)(5,6)] ],
          [ [(4,5,6),(2,3)(5,6)],"c3","s3",
              [(4,5,6),(4,5,6),(2,3)(5,6)],[(),(4,5,6),(2,3)(5,6)] ] ] ],
[19,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19)],"c19",
        [ [ [ ],"c19","triv",[()],[()] ] ] ],
[20,1,[(1,2,3,4,5)(6,7),(8,9)],"c10c2",
        [ [ [ ],"c10c2","triv",[(),()],[(),()]],
          [ [(8,9)],"c10","c2",[(),(8,9)],[(),(8,9)] ],
          [ [(8,9)],"c10","c2",[(),(8,9)],[(8,9),(8,9)] ],
          [ [(6,7),(8,9)],"c5","k4",[(6,7),(8,9)],[(6,7),(8,9)] ],
          [ [(1,2,3,4,5)],"k4","c5",[(1,2,3,4,5),()],[(1,2,3,4,5),()] ],
          [ [(1,2,3,4,5),(8,9)],"c2","c10",
              [(1,2,3,4,5),(8,9)],[(1,2,3,4,5),(8,9)] ],
          [ [(1,2,3,4,5),(8,9)],"c2","c10",
              [(1,2,3,4,5)(8,9),(8,9)],[(1,2,3,4,5),(8,9)] ] ] ],
[20,2,[(1,2,3,4,5)(6,7,8,9)],"c20",
        [ [ [ ],"c20","triv",[()],[()] ],
          [ [(6,7,8,9)],"c5","c4",[(6,7,8,9)],[(6,7,8,9)] ],
          [ [(1,2,3,4,5)],"c4","c5",[(1,2,3,4,5)],[(1,2,3,4,5)] ] ] ],
[20,3,[(1,2,3,4,5)(6,7),(2,5)(3,4)],"d20",
        [ [ [(2,5)(3,4)],"c10","c2",[(),(2,5)(3,4)],[(),(2,5)(3,4)] ],
          [ [(6,7),(2,5)(3,4)],"c5","k4",
              [(6,7),(2,5)(3,4)],[(6,7),(2,5)(3,4)] ],
          [ [(1,2,3,4,5),(2,5)(3,4)],"c2","d10",
              [(1,2,3,4,5),(2,5)(3,4)],[(1,2,3,4,5),(2,5)(3,4)] ] ] ],
[20,4,[(1,2,3,4,5,6,7,8,9,10)(11,20,19,18,17,16,15,14,13,12),
          (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20)],"q20",
        [ [ [(1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20)],
            "c5","c4",
            [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
             (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20)],
            [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
             (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20)] ] ] ],
[20,5,[(1,2,3,4,5),(2,4,5,3)],"Hol(c5)",
        [ [ [(2,4,5,3)],"c5","c4",[(),(2,4,5,3)],[(),(2,4,5,3)] ] ] ],
[21,1,[(1,2,3,4,5,6,7)(8,9,10)],"c21",
        [ [ [ ],"c21","triv",[()],[()] ],
          [ [(8,9,10)],"c7","c3",[(8,9,10)],[(8,9,10)] ],
          [ [(1,2,3,4,5,6,7)],"c3","c7",
              [(1,2,3,4,5,6,7)],[(1,2,3,4,5,6,7)] ] ] ],
[21,2,[(1,2,3,4,5,6,7),(2,5,3)(4,6,7)],"c7|xc3",
        [ [ [(2,5,3)(4,6,7)],"c7","c3",
              [(),(2,5,3)(4,6,7)],[(),(2,5,3)(4,6,7)] ] ] ],
[22,1,[(1,2,3,4,5,6,7,8,9,10,11)(12,13)],"c22",
        [ [ [ ],"c22","triv",[()],[()] ],
          [ [(12,13)],"c11","c2",[(12,13)],[(12,13)] ],
          [ [(1,2,3,4,5,6,7,8,9,10,11)],"c2","c11",
              [(1,2,3,4,5,6,7,8,9,10,11)],[(1,2,3,4,5,6,7,8,9,10,11)] ] ] ],
[22,2,[(1,2,3,4,5,6,7,8,9,10,11),(2,11)(3,10)(4,9)(5,8)(6,7)],"d22",
        [ [ [(2,11)(3,10)(4,9)(5,8)(6,7)],"c11","c2",
              [(),(2,11)(3,10)(4,9)(5,8)(6,7)],
                [(),(2,11)(3,10)(4,9)(5,8)(6,7)] ] ] ],
[23,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23)],
           "c23",
        [ [ [ ],"c23","triv",[()],[()] ] ] ],
[24,1,[(1,2,3)(4,5),(6,7),(8,9)],"c6k4",
        [ [ [ ],"c6k4","triv",[(),(),()],[(),(),()] ],
          [ [(8,9)],"c6c2","c2",[(),(),(8,9)],[(),(),(8,9)] ],
          [ [(8,9)],"c6c2","c2",[(),(8,9),(8,9)],[(),(),(8,9)] ],
          [ [(1,2,3)],"c2^3","c3",[(1,2,3),(),()],[(1,2,3),(),()] ],
          [ [(6,7),(8,9)],"c6","k4",[(),(6,7),(8,9)],[(),(6,7),(8,9)] ],
          [ [(6,7),(8,9)],"c6","k4",
              [(8,9),(6,7),(8,9)],[(),(6,7),(8,9)] ],
          [ [(1,2,3),(8,9)],"k4","c6",
              [(1,2,3),(),(8,9)],[(1,2,3),(),(8,9)] ],
          [ [(1,2,3),(8,9)],"k4","c6",
              [(1,2,3),(8,9),(8,9)],[(1,2,3),(),(8,9)] ],
          [ [(4,5),(6,7),(8,9)],"c3","c2^3",
              [(4,5),(6,7),(8,9)],[(4,5),(6,7),(8,9)] ],
          [ [(1,2,3),(6,7),(8,9)],"c2","c6c2",
              [(1,2,3),(6,7),(8,9)],[(1,2,3),(6,7),(8,9)] ],
          [ [(1,2,3),(6,7),(8,9)],"c2","c6c2",
              [(1,2,3)(8,9),(6,7),(8,9)],[(1,2,3),(6,7),(8,9)] ] ] ],
[24,2,[(1,2),(3,4,5,6)(7,8,9)],"c12c2",
        [ [ [ ],"c12c2","triv",[(),()],[(),()] ],
          [ [(1,2)],"c12","c2",[(1,2),()],[(1,2),()] ],
          [ [(1,2)],"c12","c2",[(1,2),(1,2)],[(1,2),()] ],
          [ [(7,8,9)],"c4c2","c3",[(),(7,8,9)],[(),(7,8,9)] ],
          [ [(3,4,5,6)],"c6","c4",[(),(3,4,5,6)],[(),(3,4,5,6)] ],
          [ [(3,4,5,6)],"c6","c4",[(3,5)(4,6),(3,4,5,6)],[(),(3,4,5,6)] ],
          [ [(1,2),(7,8,9)],"c4","c6",[(1,2),(7,8,9)],[(1,2),(7,8,9)] ],
          [ [(1,2),(7,8,9)],"c4","c6",
              [(1,2),(1,2)(7,8,9)],[(1,2),(7,8,9)] ],
          [ [(1,2),(3,4,5,6)],"c3","c4c2",
              [(1,2),(3,4,5,6)],[(1,2),(3,4,5,6)] ],
          [ [(3,4,5,6)(7,8,9)],"c2","c12",
              [(),(3,4,5,6)(7,8,9)],[(),(3,4,5,6)(7,8,9)] ],
          [ [(3,4,5,6)(7,8,9)],"c2","c12",
              [(3,5)(4,6),(3,4,5,6)(7,8,9)],[(),(3,4,5,6)(7,8,9)] ] ] ],
[24,3,[(1,2,3,4,5,6,7,8)(9,10,11)],"c24",
        [ [ [ ],"c24","triv",[()],[()] ],
          [ [(9,10,11)],"c8","c3",[(9,10,11)],[(9,10,11)] ],
          [ [(1,2,3,4,5,6,7,8)],"c3","c8",
              [(1,2,3,4,5,6,7,8)],[(1,2,3,4,5,6,7,8)] ] ] ],
[24,4,[(1,2,3,4)(5,6,7),(2,4)],"d8c3",
        [ [ [(2,4)],"c12","c2",[(),(2,4)],[(),(2,4)] ],
          [ [(2,4),(2,4)],"c6c2","c2",[(2,4),(2,4)],[(2,4),(2,4)] ],
          [ [(2,4)(5,6,7)],"c4","c6",[(5,6,7),(2,4)],[(5,6,7),(2,4)] ],
          [ [(2,4)(5,6,7)],"k4","c6",
              [(2,4)(5,6,7),(2,4)],[(2,4)(5,6,7),(2,4)] ],
          [ [(1,2,3,4),(2,4)],"c3","d8",
              [(1,2,3,4),(2,4)],[(1,2,3,4),(2,4)] ] ] ],
[24,5,[(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),(9,10,11)],"q8c3",
        [ [ [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5)],"c3","q8",
            [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()],
            [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()] ] ] ],
[24,6,[(1,2,3)(4,5),(2,3),(6,7)],"d12c2",
        [ [ [(2,3)(6,7)],"c6c2","c2",
              [(),(2,3)(6,7),()],[(),(2,3)(6,7),()] ],
          [ [(2,3),(6,7)],"c6","k4",[(),(2,3),(6,7)],[(),(2,3),(6,7)] ],
          [ [(2,3),(6,7)],"c6","k4",
              [(6,7),(2,3),(6,7)],[(),(2,3),(6,7)] ],
          [ [(1,2,3),(2,3)],"k4","s3",
              [(1,2,3),(2,3),()],[(1,2,3),(2,3),()] ],
          [ [(4,5),(2,3),(6,7)],"c3","c2^3",
              [(4,5),(2,3),(6,7)],[(4,5),(2,3),(6,7)] ],
          [ [(1,2,3),(2,3),(6,7)],"c2","d12",
              [(1,2,3),(2,3),(6,7)],[(1,2,3),(2,3),(6,7)] ],
          [ [(1,2,3),(2,3),(6,7)],"c2","d12",
              [(1,2,3)(6,7),(2,3),(6,7)],[(1,2,3),(2,3),(6,7)] ] ] ],
[24,7,[(1,2),(2,3),(4,5,6,7)],"s3c4",
        [ [ [(2,3),(2,3)],"c12","c2",[(2,3),(2,3),()],[(2,3),(2,3),()] ],
          [ [(1,2),(2,3)],"c4","s3",
              [(1,2),(2,3),()],[(1,2),(2,3),()] ],
          [ [(2,3),(4,5,6,7)],"c3","c4c2",
              [(2,3),(2,3),(4,5,6,7)],[(2,3),(2,3),(4,5,6,7)] ] ] ],
[24,8,[(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7),(8,9)],"q12c2",
        [ [ [(1,3,2,4)(6,7)],"c6","c4",
             [(1,2)(3,4),(1,3,2,4)(6,7),()],[(1,2)(3,4),(1,3,2,4)(6,7),()] ],
          [ [(1,3,2,4)(6,7)],"c6","c4",
              [(1,2)(3,4),(1,3,2,4)(6,7),(1,2)(3,4)],
                [(1,2)(3,4),(1,3,2,4)(6,7),()] ],
          [ [(1,3,2,4)(6,7),(8,9)],"c3","c4c2",
              [(1,2)(3,4),(1,3,2,4)(6,7),(8,9)],
                [(1,2)(3,4),(1,3,2,4)(6,7),(8,9)] ],
          [ [(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7)],"c2","q12",
              [(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7),()],
                [(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7),()] ],
          [ [(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7)],"c2","q12",
              [(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7),(1,2)(3,4)],
                [(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7),()] ] ] ],
[24,9,[(1,2,3),(2,3)(4,5,6,7,8,9,10,11)],"c3|Xc8",
        [ [ [(2,3)(4,5,6,7,8,9,10,11)],"c3","c8",
              [(),(2,3)(4,5,6,7,8,9,10,11)],
                [(),(2,3)(4,5,6,7,8,9,10,11)] ] ] ],
[24,10,[(1,2,3),(2,3,4),(5,6)],"a4c2",
        [ [ [(2,3,4)],"c2^3","c3",
              [(2,4,3),(2,3,4),()],[(2,4,3),(2,3,4),()] ],
          [ [(2,3,4)(5,6)],"k4","c6",
              [(2,4,3),(2,3,4),(5,6)],[(2,4,3),(2,3,4),(5,6)] ],
          [ [(1,2,3),(2,3,4)],"c2","a4",
              [(1,2,3),(2,3,4),()],[(1,2,3),(2,3,4),()] ] ] ],
[24,11,[(5,6,7),(1,2,3,4)(6,7),(2,4)],"d8|Xc3",
        [ [ [(1,2)(3,4)(6,7)],"c6c2","c2",
              [(),(1,2)(3,4)(6,7),()],[(),(1,2)(3,4)(6,7),()] ],
          [ [(5,6,7),(1,2)(3,4)(6,7)],"k4","s3",
             [(5,6,7),(1,2)(3,4)(6,7),()],[(5,6,7),(1,2)(3,4)(6,7),()] ],
          [ [(1,2,3,4)(6,7),(2,4)],"c3","d8",
             [(),(1,2,3,4)(6,7),(2,4)],[(),(1,2,3,4)(6,7),(2,4)] ] ] ],
[24,12,[(1,2,3)(4,5,6,7),(2,3)(4,7)(5,6)],"d24",
        [ [ [(2,3)(5,7)],"c12","c2",[(),(2,3)(5,7)],[(),(2,3)(5,7)] ],
          [ [(1,2,3),(2,3)(5,7)],"c4","s3",
              [(1,2,3),(2,3)(5,7)],[(1,2,3),(2,3)(5,7)] ],
          [ [(4,5,6,7),(2,3)(4,7)(5,6)],"c3","d8",
              [(4,5,6,7),(2,3)(4,7)(5,6)],[(4,5,6,7),(2,3)(4,7)(5,6)] ] ] ],
[24,13,[(1,2,3,4)(5,6,7,8)(9,10,11),(1,5,3,7)(2,8,4,6)(10,11)],"q24",
        [ [ [(1,2,3,4)(5,6,7,8),(1,5,3,7)(2,8,4,6)(10,11)],"c3","q8",
              [(1,2,3,4)(5,6,7,8),(1,5,3,7)(2,8,4,6)(10,11)],
                [(1,2,3,4)(5,6,7,8),(1,5,3,7)(2,8,4,6)(10,11)] ] ] ],
[24,14,[(1,2,3,4)(5,8,7,6),(1,5,3,7)(2,6,4,8),(2,5,6)(4,7,8)(9,10,11)],
               "sl(2,3)",[ ] ],
[24,15,[(1,2,3,4),(1,2)],"s4",
        [ [ [(2,4),(3,4)],"k4","s3",[(2,4),(3,4)],[(2,4),(3,4)] ] ] ],
[25,1,[(1,2,3,4,5),(6,7,8,9,10)],"c5^2",
        [ [ [ ],"c5^2","triv",[(),()],[(),()] ],
          [ [(6,7,8,9,10)],"c5","c5",
              [(),(6,7,8,9,10)],[(),(6,7,8,9,10)] ],
          [ [(6,7,8,9,10)],"c5","c5",
              [(6,7,8,9,10),(6,7,8,9,10)],[(),(6,7,8,9,10)] ] ] ],
[25,2,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,
          18,19,20,21,22,23,24,25)],"c25",
        [ [ [ ],"c25","triv",[()],[()] ] ] ],
[26,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13)(14,15)],"c26",
        [ [ [ ],"c26","triv",[()],[()] ],
          [ [(14,15)],"c13","c2",[(14,15)],[(14,15)] ],
          [ [(1,2,3,4,5,6,7,8,9,10,11,12,13)],"c2","c13",
              [(1,2,3,4,5,6,7,8,9,10,11,12,13)],
                [(1,2,3,4,5,6,7,8,9,10,11,12,13)] ] ] ],
[26,2,[(1,2,3,4,5,6,7,8,9,10,11,12,13),
           (2,13)(3,12)(4,11)(5,10)(6,9)(7,8)],"d26",
        [ [ [(2,13)(3,12)(4,11)(5,10)(6,9)(7,8)],"c13","c2",
            [(),(2,13)(3,12)(4,11)(5,10)(6,9)(7,8)],
              [(),(2,13)(3,12)(4,11)(5,10)(6,9)(7,8)] ] ] ],
[27,1,[(1,2,3),(4,5,6),(7,8,9)],"c3^3",
        [ [ [ ],"c3^3","triv",[(),(),()],[(),(),()] ],
          [ [(7,8,9)],"c3^2","c3",[(),(),(7,8,9)],[(),(),(7,8,9)] ],
          [ [(7,8,9)],"c3^2","c3",[(),(7,8,9),(7,8,9)],[(),(),(7,8,9)] ],
          [ [(4,5,6),(7,8,9)],"c3","c3^2",
              [(),(4,5,6),(7,8,9)],[(),(4,5,6),(7,8,9)] ],
          [ [(4,5,6),(7,8,9)],"c3","c3^2",
              [(7,8,9),(4,5,6),(7,8,9)],[(),(4,5,6),(7,8,9)] ] ] ],
[27,2,[(1,2,3),(4,5,6,7,8,9,10,11,12)],"c9c3",
        [ [ [ ],"c9c3","triv",[(),()],[(),()] ],
          [ [(1,2,3)],"c9","c3",[(1,2,3),()],[(1,2,3),()] ],
          [ [(1,2,3)],"c9","c3",[(1,2,3),(1,2,3)],[(1,2,3),()] ],
          [ [(4,5,6,7,8,9,10,11,12)],"c3","c9",
              [(),(4,5,6,7,8,9,10,11,12)],[(),(4,5,6,7,8,9,10,11,12)] ],
          [ [(4,5,6,7,8,9,10,11,12)],"c3","c9",
              [(4,7,10)(5,8,11)(6,9,12),(4,5,6,7,8,9,10,11,12)],
                [(),(4,5,6,7,8,9,10,11,12)] ] ] ],
[27,3,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
           16,17,18,19,20,21,22,23,24,25,26,27)],"c27",
        [ [ [  ],"c27","triv",[()],[()] ] ] ],
[27,4,[(4,5,6)(7,9,8),(1,4,7)(2,5,8)(3,6,9)],"c3^2|xc3",
        [ [ [(1,4,7)(2,5,8)(3,6,9)],"c3^2","c3",
              [(),(1,4,7)(2,5,8)(3,6,9)],[(),(1,4,7)(2,5,8)(3,6,9)] ] ] ],
[27,5,[(1,2,3,4,5,6,7,8,9),(2,5,8)(3,9,6)],"c9|xc3",
        [ [ [(2,5,8)(3,9,6)],"c9","c3",
              [(),(2,5,8)(3,9,6)],[(),(2,5,8)(3,9,6)] ] ] ],
[28,1,[(1,2)(3,4,5,6,7,8,9),(10,11)],"c14c2",
        [ [ [ ],"c14c2","triv",[(),()],[(),()] ],
          [ [(10,11)],"c14","c2",[(),(10,11)],[(),(10,11)] ],
          [ [(10,11)],"c14","c2",[(10,11),(10,11)],[(),(10,11)] ],
          [ [(1,2),(10,11)],"c7","k4",
              [(1,2),(10,11)],[(1,2),(10,11)] ],
          [ [(3,4,5,6,7,8,9)],"k4","c7",
              [(3,4,5,6,7,8,9),()],[(3,4,5,6,7,8,9),()] ],
          [ [(3,4,5,6,7,8,9)(10,11)],"c2","c14",
              [(3,4,5,6,7,8,9),(10,11)],[(3,4,5,6,7,8,9),(10,11)] ],
          [ [(3,4,5,6,7,8,9)(10,11)],"c2","c14",
             [(3,4,5,6,7,8,9)(10,11),(10,11)],[(3,4,5,6,7,8,9),(10,11)] ] ] ],
[28,2,[(1,2,3,4,5,6,7)(8,9,10,11)],"c28",
        [ [ [ ],"c28","triv",[()],[()] ],
          [ [(8,9,10,11)],"c7","c4",[(8,9,10,11)],[(8,9,10,11)] ],
          [ [(1,2,3,4,5,6,7)],"c4","c7",
              [(1,2,3,4,5,6,7)],[(1,2,3,4,5,6,7)] ] ] ],
[28,3,[(1,2)(3,4,5,6,7,8,9),(3,9)(4,8)(5,7)],"d28",
        [ [ [(4,9)(5,8)(6,7)],"c14","c2",
              [(),(4,9)(5,8)(6,7)],[(),(4,9)(5,8)(6,7)] ],
          [ [(1,2),(4,9)(5,8)(6,7)],"c7","k4",
                [(1,2),(4,9)(5,8)(6,7)],[(1,2),(4,9)(5,8)(6,7)] ],
          [ [(3,4,5,6,7,8,9),(3,9)(4,8)(5,7)],"c2","d14",
              [(3,4,5,6,7,8,9),(3,9)(4,8)(5,7)],
                [(3,4,5,6,7,8,9),(3,9)(4,8)(5,7)] ] ] ],
[28,4,[(1,2)(3,4)(5,6,7,8,9,10,11),(1,3,2,4)(6,11)(7,10)(8,9)],"q28",
        [ [ [(1,3,2,4)(6,11)(7,10)(8,9)],"c7","c4",
              [(1,2)(3,4),(1,3,2,4)(6,11)(7,10)(8,9)],
                [(1,2)(3,4),(1,3,2,4)(6,11)(7,10)(8,9)] ] ] ],
[29,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,27,28,29)],"c29",
        [ [ [  ],"c29","triv",[()],[()] ] ] ],
[30,1,[(1,2,3,4,5)(6,7,8)(9,10)],"c30",
        [ [ [ ],"c30","triv",[()],[()] ],
          [ [(9,10)],"c15","c2",[(9,10)],[(9,10)] ],
          [ [(6,7,8)],"c10","c3",[(6,7,8)],[(6,7,8)] ],
          [ [(1,2,3,4,5)],"c6","c5",[(1,2,3,4,5)],[(1,2,3,4,5)] ],
          [ [(6,7,8)(9,10)],"c5","c6",[(6,7,8)(9,10)],[(6,7,8)(9,10)] ],
          [ [(1,2,3,4,5)(9,10)],"c3","c10",
              [(1,2,3,4,5)(9,10)],[(1,2,3,4,5)(9,10)] ],
          [ [(1,2,3,4,5)(6,7,8)],"c2","c15",
              [(1,2,3,4,5)(6,7,8)],[(1,2,3,4,5)(6,7,8)] ] ] ],
[30,2,[(1,2,3,4,5),(1,5)(2,4),(6,7,8)],"d10c3",
        [ [ [(2,5)(3,4)],"c15","c2",[(),(2,5)(3,4),()],[(),(2,5)(3,4),()] ],
          [ [(2,5)(3,4)(6,7,8)],"c5","c6",
            [(),(2,5)(3,4),(6,7,8)],[(),(2,5)(3,4),(6,7,8)] ],
          [ [(1,2,3,4,5),(1,5)(2,4)],"c3","d10",
            [(1,2,3,4,5),(1,5)(2,4),()],[(1,2,3,4,5),(1,5)(2,4),()],1 ] ] ],
[30,3,[(1,2,3),(2,3),(4,5,6,7,8)],"d6c5",
        [ [ [(2,3)],"c15","c2",[(),(2,3),()],[(),(2,3),()] ],
          [ [(1,2,3),(2,3)],"c5","s3",
              [(1,2,3),(2,3),()],[(1,2,3),(2,3),()] ],
          [ [(2,3),(4,5,6,7,8)],"c3","c10",
              [(),(2,3),(4,5,6,7,8)],[(),(2,3),(4,5,6,7,8)] ] ] ],
[30,4,[(1,2,3)(4,5,6,7,8),(2,3)(4,8)(5,7)],"d30",
        [ [ [(2,3)(5,8)(6,7)],"c15","c2",
              [(),(2,3)(5,8)(6,7)],[(),(2,3)(5,8)(6,7)] ],
         [ [(1,2,3),(2,3)(5,8)(6,7)],"c5","s3",
          [(1,2,3),(2,3)(5,8)(6,7)],[(1,2,3),(2,3)(5,8)(6,7)] ],
         [ [(4,5,6,7,8),(2,3)(4,8)(5,7)],"c3","d10",
          [(4,5,6,7,8),(2,3)(4,8)(5,7)],[(4,5,6,7,8),(2,3)(4,8)(5,7)] ] ] ],
[31,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,
	 18,19,20,21,22,23,24,25,26,27,28,29,30,31)],"c31" ,
      [ [ [  ],"c31","triv",[()],[()] ] ] ],	 
[32,1,[(1,2),(3,4),(5,6),(7,8),(9,10)],"c2^5",
        [ [ [ ],"c2^5","triv",[(),(),(),(),()],[(),(),(),(),()] ],
          [ [(9,10)],"c2^4","c2",[(),(),(),(),(9,10)],[(),(),(),(),(9,10)] ],
          [ [(9,10)],"c2^4","c2",[(),(),(),(),(9,10)],[(),(),(),(9,10),(9,10)]],
          [ [(7,8),(9,10)],"c2^3","k4",
                [(),(),(),(7,8),(9,10)],[(),(),(),(7,8),(9,10)] ],
          [ [(7,8),(9,10)],"c2^3","k4",
                [(),(),(),(7,8),(9,10)],[(),(),(9,10),(7,8),(9,10)] ],
          [ [(7,8),(9,10)],"c2^3","k4",
                [(),(),(),(7,8),(9,10)],[(),(7,8),(9,10),(7,8),(9,10)] ],
          [ [(5,6),(7,8),(9,10)],"k4","c2^3",
                [(),(),(5,6),(7,8),(9,10)],[(),(),(5,6),(7,8),(9,10)] ],
          [ [(5,6),(7,8),(9,10)],"k4","c2^3",
                [(),(),(5,6),(7,8),(9,10)],[(),(9,10),(5,6),(7,8),(9,10)] ],
          [ [(5,6),(7,8),(9,10)],"k4","c2^3",
                [(),(),(5,6),(7,8),(9,10)],[(7,8),(9,10),(5,6),(7,8),(9,10)] ],
          [ [(3,4),(5,6),(7,8),(9,10)],"c2","c2^4",
                [(),(3,4),(5,6),(7,8),(9,10)],[(),(3,4),(5,6),(7,8),(9,10)] ],
          [ [(3,4),(5,6),(7,8),(9,10)],"c2","c2^4",
             [(),(3,4),(5,6),(7,8),(9,10)],[(3,4),(3,4),(5,6),(7,8),(9,10)] ]
            ] ],
[32,2,[(1,2,3,4),(5,6),(7,8),(9,10)],"c4c2^3",
        [ [ [ ],"c4c2^3","triv",[(),(),(),()],[(),(),(),()] ],
          [ [(9,10)],"c4k4","c2",[(),(),(),(9,10)],[(),(),(),(9,10)] ],
          [ [(9,10)],"c4k4","c2",[(),(),(),(9,10)],[(9,10),(),(),(9,10)] ],
          [ [(9,10)],"c4k4","c2",[(),(),(),(9,10)],[(),(),(9,10),(9,10)] ],
          [ [(7,8),(9,10)],"c4c2","k4",
              [(),(),(7,8),(9,10)],[(),(),(7,8),(9,10)] ],
          [ [(7,8),(9,10)],"c4c2","k4",
              [(),(),(7,8),(9,10)],[(),(9,10),(7,8),(9,10)] ],
          [ [(7,8),(9,10)],"c4c2","k4",
              [(),(),(7,8),(9,10)],[(9,10),(),(7,8),(9,10)] ],
          [ [(7,8),(9,10)],"c4c2","k4",
              [(),(),(7,8),(9,10)],[(9,10),(9,10),(7,8),(9,10)] ],
          [ [(1,2,3,4)],"c2^3","c4",
              [(1,2,3,4),(),(),()],[(1,2,3,4),(),(),()] ],
          [ [(1,2,3,4)],"c2^3","c4",
              [(1,2,3,4),(),(),()],[(1,2,3,4),(),(),(1,3)(2,4)] ],
          [ [(5,6),(7,8),(9,10)],"c4","c2^3",
              [(),(5,6),(7,8),(9,10)],[(),(5,6),(7,8),(9,10)] ],
          [ [(5,6),(7,8),(9,10)],"c4","c2^3",
              [(),(5,6),(7,8),(9,10)],[(9,10),(5,6),(7,8),(9,10)] ],
          [ [(1,2,3,4),(9,10)],"k4","c4c2",
              [(1,2,3,4),(),(),(9,10)],[(1,2,3,4),(),(),(9,10)] ],
          [ [(1,2,3,4),(9,10)],"k4","c4c2",
              [(1,2,3,4),(),(),(9,10)],[(1,2,3,4),(),(9,10),(9,10)] ],
          [ [(1,2,3,4),(9,10)],"k4","c4c2",
              [(1,2,3,4),(),(),(9,10)],[(1,2,3,4),(),(1,3)(2,4),(9,10)] ],
          [ [(1,2,3,4),(9,10)],"k4","c4c2",
              [(1,2,3,4),(),(),(9,10)],[(1,2,3,4),(1,3)(2,4),(9,10),(9,10)] ],
          [ [(1,2,3,4),(7,8),(9,10)],"c2","c4k4",
              [(1,2,3,4),(),(7,8),(9,10)],[(1,2,3,4),(),(7,8),(9,10)] ],
          [ [(1,2,3,4),(7,8),(9,10)],"c2","c4k4",
              [(1,2,3,4),(),(7,8),(9,10)],[(1,2,3,4),(9,10),(7,8),(9,10)] ],
          [ [(1,2,3,4),(7,8),(9,10)],"c2","c4k4",
              [(1,2,3,4),(),(7,8),(9,10)],[(1,2,3,4),(1,3)(2,4),(7,8),(9,10)] ]
            ] ],
[32,3,[(1,2),(3,4),(5,6,7,8,9,10,11,12)],"c2^3c8",
       [ [ [ ],"k4c8","triv",
	   [(),(),()],
	   [(),(),()] ],
	 [ [(5,6,7,8,9,10,11,12)],"k4","c8",
	   [(),(),(5,6,7,8,9,10,11,12)],
	   [(),(),(5,6,7,8,9,10,11,12)] ],
	 [ [(5,9)(6,10)(7,11)(8,12),(5,6,7,8,9,10,11,12)],"k4","c8",
	   [(),(5,9)(6,10)(7,11)(8,12),(5,6,7,8,9,10,11,12)],
	   [(),(),(5,6,7,8,9,10,11,12)] ],
	 [ [(3,4)],"c8c2","c2",
	   [(),(3,4),()],
	   [(),(3,4),()] ],
	 [ [(3,4),(3,4)],"c8c2","c2",
	   [(),(3,4),(3,4)],
	   [(),(3,4),()] ],
	 [ [(3,4)],"c8c2","c2",
	   [(3,4),(3,4),()],
	   [(),(3,4),()] ],
	 [ [(3,4),(5,6,7,8,9,10,11,12)],"c2","c8c2",
	   [(),(3,4),(5,6,7,8,9,10,11,12)],
	   [(),(3,4),(5,6,7,8,9,10,11,12)] ],
	 [ [(5,9)(6,10)(7,11)(8,12),(3,4),(5,6,7,8,9,10,11,12)],"c2","c8c2",
	   [(5,9)(6,10)(7,11)(8,12),(3,4),(5,6,7,8,9,10,11,12)],
	   [(),(3,4),(5,6,7,8,9,10,11,12)] ],
	 [ [(3,4),(3,4),(5,6,7,8,9,10,11,12)],"c2","c8c2",
	   [(3,4),(3,4),(5,6,7,8,9,10,11,12)],
	   [(),(3,4),(5,6,7,8,9,10,11,12)] ],
	 [ [(1,2),(3,4)],"c8","k4",
	   [(1,2),(3,4),()],
	   [(1,2),(3,4),()] ],
	 [ [(1,2),(3,4),(3,4)],"c8","k4",
	   [(1,2),(3,4),(3,4)],
	   [(1,2),(3,4),()] ] ] ],
[32,4,[(1,2),(3,4,5,6),(7,8,9,10)],"c4^2c2",
       [ [ [ ],"c4^2c2","triv",
	   [(),(),()],
	   [(),(),()] ],
	 [ [(7,8,9,10)],"c2c4","c4",
	   [(),(),(7,8,9,10)],
	   [(),(),(7,8,9,10)] ],
	 [ [(7,8,9,10),(7,8,9,10)],"c2c4","c4",
	   [(),(7,8,9,10),(7,8,9,10)],
	   [(),(7,8,9,10),(7,8,9,10)] ],
	 [ [(7,9)(8,10),(7,8,9,10)],"c2c4","c4",
	   [(),(7,9)(8,10),(7,8,9,10)],
	   [(),(),(7,8,9,10)] ],
	 [ [(7,9)(8,10),(7,8,9,10)],"c2c4","c4",
	   [(7,9)(8,10),(),(7,8,9,10)],
	   [(),(),(7,8,9,10)] ],
	 [ [(3,4,5,6),(7,8,9,10)],"c2","c4^2",
	   [(),(3,4,5,6),(7,8,9,10)],
	   [(),(3,4,5,6),(7,8,9,10)] ],
	 [ [(7,9)(8,10),(3,4,5,6),(7,8,9,10)],"c2","c4^2",
	   [(7,9)(8,10),(3,4,5,6),(7,8,9,10)],
	   [(),(3,4,5,6),(7,8,9,10)] ],
	 [ [(1,2)],"c4^2","c2",
	   [(1,2),(),()],
	   [(1,2),(),()] ],
	 [ [(1,2),(1,2)],"c4^2","c2",
	   [(1,2),(),(1,2)],
	   [(1,2),(),()] ],
	 [ [(1,2),(7,8,9,10)],"c4","c2c4",
	   [(1,2),(),(7,8,9,10)],
	   [(1,2),(),(7,8,9,10)] ],
	 [ [(1,2),(7,8,9,10),(7,8,9,10)],"c4","c2c4",
	   [(1,2),(7,8,9,10),(7,8,9,10)],
	   [(1,2),(),(7,8,9,10)] ],
	 [ [(1,2),(7,9)(8,10),(7,8,9,10)],"c4","c2c4",
	   [(1,2),(7,9)(8,10),(7,8,9,10)],
	   [(1,2),(),(7,8,9,10)] ],
	 [ [(1,2),(1,2),(7,8,9,10)],"c4","c2c4",
	   [(1,2),(1,2),(7,8,9,10)],
	   [(1,2),(),(7,8,9,10)] ] ] ],
[32,5,[(1,2),(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)],"c16c2",
       [ [ [ ],"c16c2","triv",
	   [(),()],
	   [(),()] ],
	 [ [(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)],"c2","c16",
	   [(),(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)],
	   [(),(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)] ],
	 [ [(3,11)(4,12)(5,13)(6,14)(7,15)(8,16)(9,17)(10,18),
	    (3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)],"c2","c16",
	   [(3,11)(4,12)(5,13)(6,14)(7,15)(8,16)(9,17)(10,18),
	    (3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)],
	   [(),(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)] ],
	 [ [(1,2)],"c16","c2",
	   [(1,2),()],
	   [(1,2),()] ],
	 [ [(1,2),(1,2)],"c16","c2",
	   [(1,2),(1,2)],
	   [(1,2),()] ] ] ],
[32,6,[(1,2,3,4),(5,6,7,8,9,10,11,12)],"c8c4",
       [ [ [ ],"c8c4","triv",
	   [(),()],
	   [(),()] ],
	 [ [(5,6,7,8,9,10,11,12)],"c4","c8",
	   [(),(5,6,7,8,9,10,11,12)],
	   [(),(5,6,7,8,9,10,11,12)] ],
	 [ [(5,7,9,11)(6,8,10,12),(5,6,7,8,9,10,11,12)],"c4","c8",
	   [(5,7,9,11)(6,8,10,12),(5,6,7,8,9,10,11,12)],
	   [(),(5,6,7,8,9,10,11,12)] ],
	 [ [(5,9)(6,10)(7,11)(8,12),(5,6,7,8,9,10,11,12)],"c4","c8",
	   [(5,9)(6,10)(7,11)(8,12),(5,6,7,8,9,10,11,12)],
	   [(),(5,6,7,8,9,10,11,12)] ],
	 [ [(1,2,3,4)],"c8","c4",
	   [(1,2,3,4),()],
	   [(1,2,3,4),()] ],
	 [ [(1,2,3,4),(1,2,3,4)],"c8","c4",
	   [(1,2,3,4),(1,2,3,4)],
	   [(1,2,3,4),()] ],
	 [ [(1,2,3,4),(1,3)(2,4)],"c8","c4",
	   [(1,2,3,4),(1,3)(2,4)],
	   [(1,2,3,4),()] ] ] ],
[32,7,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
	 21,22,23,24,25,26,27,28,29,30,31,32)],"c32",
      [ [ [ ],"c32","triv",[()],[()] ] ] ],
[32,8,[(1,2,3,4),(2,4),(5,6),(7,8)],"d8k4",
      [ [ [(2,4)(7,8)],"c4k4","c2",
	  [(),(2,4)(7,8),(),()],[(),(2,4)(7,8),(),()] ],
	[ [(2,4)(7,8),(2,4)(7,8)],"c2^4","c2",
	  [(2,4)(7,8),(2,4)(7,8),(),()],[(2,4)(7,8),(2,4)(7,8),(),()] ],
	[ [(2,4)(7,8),(5,6)],"c2c4","k4",
	  [(),(2,4)(7,8),(5,6),()],[(),(2,4)(7,8),(5,6),()] ],
	[ [(2,4)(5,6)(7,8),(5,6),(5,6)],"c2c4","k4",
	  [(),(2,4)(5,6)(7,8),(5,6),(5,6)],[(),(2,4)(7,8),(5,6),()] ],
	[ [(5,6),(2,4)(7,8),(5,6)],"c2c4","k4",
	  [(5,6),(2,4)(7,8),(5,6),()],[(),(2,4)(7,8),(5,6),()] ],
	[ [(2,4)(7,8),(2,4)(7,8),(5,6)],"c2^3","k4",
	  [(2,4)(7,8),(2,4)(7,8),(5,6),()],[(2,4)(7,8),(2,4)(7,8),(5,6),()] ],
	[ [(2,4)(7,8),(2,4)(5,6)(7,8),(5,6),(5,6)],"c2^3","k4",
	  [(2,4)(7,8),(2,4)(5,6)(7,8),(5,6),(5,6)],
	  [(2,4)(7,8),(2,4)(7,8),(5,6),()] ],
	[ [(2,4)(5,6)(7,8),(2,4)(7,8),(5,6)],"c2^3","k4",
	  [(2,4)(5,6)(7,8),(2,4)(7,8),(5,6),()],
	  [(2,4)(7,8),(2,4)(7,8),(5,6),()] ],
	[ [(2,4),(5,6),(7,8)],"c4","c2^3",
	  [(),(2,4),(5,6),(7,8)],[(),(2,4),(5,6),(7,8)] ],
	[ [(7,8),(2,4),(5,6),(7,8)],"c4","c2^3",
	  [(7,8),(2,4),(5,6),(7,8)],[(),(2,4),(5,6),(7,8)] ],
	[ [(2,4),(2,4),(5,6),(7,8)],"k4","c2^3",
	  [(2,4),(2,4),(5,6),(7,8)],[(2,4),(2,4),(5,6),(7,8)] ],
	[ [(2,4)(7,8),(2,4),(5,6),(7,8)],"k4","c2^3",
	  [(2,4)(7,8),(2,4),(5,6),(7,8)],[(2,4),(2,4),(5,6),(7,8)] ],
	[ [(1,2,3,4),(2,4)],"k4","d8",
	  [(1,2,3,4),(2,4),(),()],[(1,2,3,4),(2,4),(),()] ],
	[ [(1,2,3,4),(2,4),(1,3)(2,4)],"k4","d8",
	  [(1,2,3,4),(2,4),(),(1,3)(2,4)],[(1,2,3,4),(2,4),(),()] ],
	[ [(1,2,3,4),(2,4),(7,8)],"c2","d8c2",
	  [(1,2,3,4),(2,4),(),(7,8)],[(1,2,3,4),(2,4),(),(7,8)] ],
	[ [(1,2,3,4),(2,4),(7,8),(7,8)],"c2","d8c2",
	  [(1,2,3,4),(2,4),(7,8),(7,8)],[(1,2,3,4),(2,4),(),(7,8)] ],
	[ [(1,2,3,4),(2,4),(1,3)(2,4),(7,8)],"c2","d8c2",
	  [(1,2,3,4),(2,4),(1,3)(2,4),(7,8)],[(1,2,3,4),(2,4),(),(7,8)] ] ] ],
[32,9,[(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
       (13,24,27,19)(15,20,28,30)(25,31,32,29),
       (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
       (9,19,22,24)(15,25,28,32)(20,29,30,31),
       (1,4)(2,8)(3,12)(5,15)(6,16)(7,18)(9,20)(10,21)(11,23)(13,25)
       (14,26)(17,28)(19,29)(22,30)(24,31)(27,32),
       (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
       (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
       (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
       (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],"q8k4" ,
      [ [ [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],"k4","q8",
          [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),(),(),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],
          [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),(),(),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)] ],
        [ [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],"k4","q8",
          [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),(),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],
   	  [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),(),(),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)] ],
        [ [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),
           (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],"c2","q8c2",
	  [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
   	   (13,24,27,19)(15,20,28,30)(25,31,32,29),
 	   (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),(),
	   (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
 	   (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
   	   (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],
	  [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
	   (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),(),
           (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)] ],
        [ [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
  	   (13,24,27,19)(15,20,28,30)(25,31,32,29),
	   (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),
  	   (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
 	   (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],"c2","q8c2",
	  [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),
           (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
           (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],
	  [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),(),
           (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)] ],
        [ [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31),
           (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],"c2","q8c2",
	  [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
           (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
           (9,19,22,24)(15,25,28,32)(20,29,30,31),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31),
           (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
           (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)],
	  [(1,2,6,10)(3,11,14,7)(4,8,16,21)(5,9,17,22)(12,23,26,18)
           (13,24,27,19)(15,20,28,30)(25,31,32,29),
 	   (1,3,6,14)(2,7,10,11)(4,12,16,26)(5,13,17,27)(8,18,21,23)
  	   (9,19,22,24)(15,25,28,32)(20,29,30,31),(),
 	   (1,5)(2,9)(3,13)(4,15)(6,17)(7,19)(8,20)(10,22)(11,24)(12,25)
           (14,27)(16,28)(18,29)(21,30)(23,31)(26,32),
 	   (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,21)(9,22)(12,26)(13,27)
           (15,28)(18,23)(19,24)(20,30)(25,32)(29,31)] ] ] ],
[32,10,[(1,2,3,4)(5,6,7,8),(5,7)(6,8),
	 (1,5)(2,6)(3,7)(4,8),(9,10)],"d8y4c2",
       [ [ [(5,7)(6,8)(9,10)],"c4k4","c2",
	   [(),(5,7)(6,8)(9,10),(),()],
	   [(),(5,7)(6,8)(9,10),(),()] ],
	 [ [(1,5)(2,6)(3,7)(4,8),(9,10)],"c2c4","k4",
	   [(),(),(1,5)(2,6)(3,7)(4,8),(9,10)],
	   [(),(),(1,5)(2,6)(3,7)(4,8),(9,10)] ],
	 [ [(9,10),(1,5)(2,6)(3,7)(4,8),(9,10)],"c2c4","k4",
	   [(),(9,10),(1,5)(2,6)(3,7)(4,8),(9,10)],
	   [(),(),(1,5)(2,6)(3,7)(4,8),(9,10)] ],
	 [ [(9,10),(1,5)(2,6)(3,7)(4,8),(9,10)],"c2c4","k4",
	   [(9,10),(),(1,5)(2,6)(3,7)(4,8),(9,10)],
	   [(),(),(1,5)(2,6)(3,7)(4,8),(9,10)] ],
	 [ [(9,10),(9,10),(1,5)(2,6)(3,7)(4,8),(9,10)],"c2c4","k4",
	   [(9,10),(9,10),(1,5)(2,6)(3,7)(4,8),(9,10)],
	   [(),(),(1,5)(2,6)(3,7)(4,8),(9,10)] ],
	 [ [(1,2,3,4)(5,6,7,8),(5,7)(6,8),(1,5)(2,6)(3,7)(4,8)],"c2","d8y4",
	   [(1,2,3,4)(5,6,7,8),(5,7)(6,8),(1,5)(2,6)(3,7)(4,8),()],
	   [(1,2,3,4)(5,6,7,8),(5,7)(6,8),(1,5)(2,6)(3,7)(4,8),()] ],
	 [ [(1,2,3,4)(5,6,7,8),(5,7)(6,8),(1,5)(2,6)(3,7)(4,8),
	    (1,3)(2,4)(5,7)(6,8)],"c2","d8y4",
	   [(1,2,3,4)(5,6,7,8),(5,7)(6,8),(1,5)(2,6)(3,7)(4,8),
	    (1,3)(2,4)(5,7)(6,8)],
	   [(1,2,3,4)(5,6,7,8),(5,7)(6,8),(1,5)(2,6)(3,7)(4,8),()] ] ] ],
[32,11,[(1,2,3,4)(5,6,7,8),(1,4,5,8)(3,2,7,6),(9,10)],"[ ]",
       [ [ [(2,8)(4,6)(9,10)],"c4k4","c2",
	   [(),(2,8)(4,6)(9,10),()],
	   [(),(2,8)(4,6)(9,10),()] ],
	 [ [(2,8)(4,6),(9,10)],"c2c4","k4",
	   [(),(2,8)(4,6),(9,10)],
	   [(),(2,8)(4,6),(9,10)] ],
	 [ [(9,10),(2,8)(4,6)(9,10),(9,10)],"c2c4","k4",
	   [(9,10),(2,8)(4,6)(9,10),(9,10)],
	   [(),(2,8)(4,6),(9,10)] ],
	 [ [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8)],"c2^3","c4",
	   [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8),()],
	   [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8),()] ],
	 [ [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8),(1,3)(2,4)(5,7)(6,8)],
	     "c2^3","c4",
	   [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8),(1,3)(2,4)(5,7)(6,8)],
	   [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8),()] ],
	 [ [(1,2,3,4)(5,6,7,8),(1,4,3,2)(5,8,7,6)],"c2^3","c4",
	   [(1,2,3,4)(5,6,7,8),(1,4,3,2)(5,8,7,6),()],
	   [(1,2,3,4)(5,6,7,8),(1,4,3,2)(5,8,7,6),()] ],
	 [ [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8),(9,10)],"k4","c2c4",
	   [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8),(9,10)],
	   [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8),(9,10)] ],
	 [ [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8)(9,10),(9,10)],"k4","c2c4",
	   [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8)(9,10),(9,10)],
	   [(1,2,3,4)(5,6,7,8),(1,2,3,4)(5,6,7,8),(9,10)] ],
	 [ [(1,2,3,4)(5,6,7,8),(1,4,3,2)(5,8,7,6),(9,10)],"k4","c2c4",
	   [(1,2,3,4)(5,6,7,8),(1,4,3,2)(5,8,7,6),(9,10)],
	   [(1,2,3,4)(5,6,7,8),(1,4,3,2)(5,8,7,6),(9,10)] ],
	 [ [(1,2,3,4)(5,6,7,8),(1,2,5,6)(3,4,7,8)(9,10),(1,3)(2,4)(5,7)(6,8)],
	     "c2","[ ]",
	   [(1,2,3,4)(5,6,7,8),(1,2,5,6)(3,4,7,8)(9,10),(1,3)(2,4)(5,7)(6,8)],
	   [(1,2,3,4)(5,6,7,8),(1,2,5,6)(3,4,7,8)(9,10),(1,3)(2,4)(5,7)(6,8)] ],
	 [ [(1,2,3,4)(5,6,7,8),(1,4,5,8)(2,7,6,3)(9,10)],"c2","[ ]",
	   [(1,2,3,4)(5,6,7,8),(1,4,5,8)(2,7,6,3)(9,10),()],
	   [(1,2,3,4)(5,6,7,8),(1,2,5,6)(3,4,7,8)(9,10),(1,3)(2,4)(5,7)(6,8)] ],
	 [ [(1,2,3,4)(5,6,7,8),(1,8,5,4)(2,3,6,7)(9,10),(1,5)(2,6)(3,7)(4,8)],
	      "c2","[ ]",
	   [(1,2,3,4)(5,6,7,8),(1,8,5,4)(2,3,6,7)(9,10),
	    (1,5)(2,6)(3,7)(4,8)],[(1,2,3,4)(5,6,7,8),(1,2,5,6)
	    (3,4,7,8)(9,10),(1,3)(2,4)(5,7)(6,8)] ] ] ],
[32,12,[(1,2,3,4),(1,3)(5,6,7,8),(9,10)],"c2(c2c4).c2",
       [ [ [(2,4)(5,6,7,8)],"c2c4","c4",
	   [(),(2,4)(5,6,7,8),()],
	   [(),(2,4)(5,6,7,8),()] ],
	 [ [(2,4)(5,6,7,8),(5,7)(6,8)],"c2c4","c4",
	   [(),(2,4)(5,6,7,8),(5,7)(6,8)],
	   [(),(2,4)(5,6,7,8),()] ],
	 [ [(5,7)(6,8),(2,4)(5,6,7,8)],"c2c4","c4",
	   [(5,7)(6,8),(2,4)(5,6,7,8),()],
	   [(),(2,4)(5,6,7,8),()] ],
	 [ [(2,4)(5,6,7,8),(9,10)],"c4","c2c4",
	   [(),(2,4)(5,6,7,8),(9,10)],
	   [(),(2,4)(5,6,7,8),(9,10)] ],
	 [ [(9,10),(2,4)(5,6,7,8),(9,10)],"c4","c2c4",
	   [(9,10),(2,4)(5,6,7,8),(9,10)],
	   [(),(2,4)(5,6,7,8),(9,10)] ],
	 [ [(5,7)(6,8),(2,4)(5,6,7,8),(9,10)],"c4","c2c4",
	   [(5,7)(6,8),(2,4)(5,6,7,8),(9,10)],
	   [(),(2,4)(5,6,7,8),(9,10)] ],
	 [ [(1,2,3,4),(2,4)(5,6,7,8)(9,10),(1,3)(2,4)],"c2","(c2c4).c2",
	   [(1,2,3,4),(2,4)(5,6,7,8)(9,10),(1,3)(2,4)],
	   [(1,2,3,4),(2,4)(5,6,7,8)(9,10),(1,3)(2,4)] ],
	 [ [(1,2,3,4),(2,4)(5,8,7,6)(9,10),(1,3)(2,4)(5,7)(6,8)],
	    "c2","(c2c4).c2",
	   [(1,2,3,4),(2,4)(5,8,7,6)(9,10),(1,3)(2,4)(5,7)(6,8)],
	   [(1,2,3,4),(2,4)(5,6,7,8)(9,10),(1,3)(2,4)] ],
	 [ [(1,2,3,4),(1,3)(5,6,7,8)(9,10)],"c2","(c2c4).c2",
	   [(1,2,3,4),(1,3)(5,6,7,8)(9,10),()],
	   [(1,2,3,4),(2,4)(5,6,7,8)(9,10),(1,3)(2,4)] ],
	 [ [(1,2,3,4),(1,3)(5,8,7,6)(9,10),(5,7)(6,8)],"c2","(c2c4).c2",
	   [(1,2,3,4),(1,3)(5,8,7,6)(9,10),(5,7)(6,8)],
	   [(1,2,3,4),(2,4)(5,6,7,8)(9,10),(1,3)(2,4)] ] ] ],
[32,13,[(1,2,3,4,5,6,7,8),(2,6)(4,8),(9,10)],"[ ]",
       [ [ [(2,6)(4,8)(9,10)],"c8c2","c2",
	   [(),(2,6)(4,8)(9,10),()],
	   [(),(2,6)(4,8)(9,10),()] ],
	 [ [(2,6)(4,8),(9,10)],"c8","k4",
	   [(),(2,6)(4,8),(9,10)],
	   [(),(2,6)(4,8),(9,10)] ],
	 [ [(9,10),(2,6)(4,8),(9,10)],"c8","k4",
	   [(9,10),(2,6)(4,8),(9,10)],
	   [(),(2,6)(4,8),(9,10)] ],
	 [ [(1,2,3,4,5,6,7,8),(2,6)(4,8)],"c2","[ ]",
	   [(1,2,3,4,5,6,7,8),(2,6)(4,8),()],
	   [(1,2,3,4,5,6,7,8),(2,6)(4,8),()] ],
	 [ [(1,2,3,4,5,6,7,8),(2,6)(4,8),(1,5)(2,6)(3,7)(4,8)],"c2","[ ]",
	   [(1,2,3,4,5,6,7,8),(2,6)(4,8),(1,5)(2,6)(3,7)(4,8)],
	   [(1,2,3,4,5,6,7,8),(2,6)(4,8),()] ] ] ],
[32,14,[(1,2,3,4),(1,3),(7,8,9,10)],"d8c4",
       [ [ [(2,4)],"c4^2","c2",
	   [(),(2,4),()],
	   [(),(2,4),()] ],
	 [ [(2,4),(2,4)],"c4k4","c2",
	   [(2,4),(2,4),()],
	   [(2,4),(2,4),()] ],
	 [ [(2,4),(7,8,9,10)],"c4","c2c4",
	   [(),(2,4),(7,8,9,10)],
	   [(),(2,4),(7,8,9,10)] ],
	 [ [(7,9)(8,10),(2,4),(7,8,9,10)],"c4","c2c4",
	   [(7,9)(8,10),(2,4),(7,8,9,10)],
	   [(),(2,4),(7,8,9,10)] ],
	 [ [(2,4),(2,4),(7,8,9,10)],"k4","c2c4",
	   [(2,4),(2,4),(7,8,9,10)],
	   [(2,4),(2,4),(7,8,9,10)] ],
	 [ [(2,4)(7,9)(8,10),(2,4),(7,8,9,10)],"k4","c2c4",
	   [(2,4)(7,9)(8,10),(2,4),(7,8,9,10)],
	   [(2,4),(2,4),(7,8,9,10)] ],
	 [ [(1,2,3,4),(1,3)],"c4","d8",
	   [(1,2,3,4),(1,3),()],
	   [(1,2,3,4),(1,3),()] ],
	 [ [(1,2,3,4),(1,3),(1,3)(2,4)],"c4","d8",
	   [(1,2,3,4),(1,3),(1,3)(2,4)],
	   [(1,2,3,4),(1,3),()] ] ] ],
[32,15,[(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),(9,10,11,12)],"q8c4",
       [ [ [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5)],"c4","q8",
	   [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()],
	   [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()] ],
	 [ [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),(1,2)(3,4)(5,6)(7,8)],
	     "c4","q8",
	   [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),(1,2)(3,4)(5,6)(7,8)],
	   [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()] ] ] ],
[32,16,[(1,7,3,2)(4,14,9,8)(5,12,10,6)(11,16,15,13),
	 (2,6)(7,12)(8,13)(14,16),(1,3)(2,7)(4,9)(5,10)
	 (6,12)(8,14)(11,15)(13,16),(1,11,5,4)(2,13,6,8)
	 (3,15,10,9)(7,16,12,14),
	 (1,5)(2,6)(3,10)(4,11)(7,12)(8,13)(9,15)(14,16)],"[ ]",
       [ [ [(2,6)(7,12)(8,13)(14,16)],"c4^2","c2",
	   [(),(2,6)(7,12)(8,13)(14,16),(),(),()],
	   [(),(2,6)(7,12)(8,13)(14,16),(),(),()] ],
	 [ [(1,2,10,12)(3,7,5,6)(4,8,15,16)(9,14,11,13),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14)],"c2c4","c4",
	   [(1,2,10,12)(3,7,5,6)(4,8,15,16)(9,14,11,13),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),(),()],
	   [(1,2,10,12)(3,7,5,6)(4,8,15,16)(9,14,11,13),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),(),()] ],
	 [ [(1,2,10,12)(3,7,5,6)(4,8,15,16)(9,14,11,13),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14)],"c2c4","c4",
	   [(1,2,10,12)(3,7,5,6)(4,8,15,16)(9,14,11,13),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),()],
	   [(1,2,10,12)(3,7,5,6)(4,8,15,16)(9,14,11,13),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),(),()] ],
	 [ [(1,12,10,2)(3,6,5,7)(4,16,15,8)(9,13,11,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14)],"c2c4","c4",
	   [(1,12,10,2)(3,6,5,7)(4,16,15,8)(9,13,11,14),(),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),(),()],
	   [(1,2,10,12)(3,7,5,6)(4,8,15,16)(9,14,11,13),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),(),()] ],
	 [ [(1,12,10,2)(3,6,5,7)(4,16,15,8)(9,13,11,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14)],"c2c4","c4",
	   [(1,12,10,2)(3,6,5,7)(4,16,15,8)(9,13,11,14),(),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),()],
	   [(1,2,10,12)(3,7,5,6)(4,8,15,16)(9,14,11,13),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),
	    (1,10)(2,12)(3,5)(4,15)(6,7)(8,16)(9,11)(13,14),(),()] ] ] ],
[32,17,[(1,2)(3,10)(4,7)(5,8)(6,9)(11,16)(12,14)(13,15),
	 (1,3)(2,5)(4,11)(6,8)(7,12)(9,10)(13,14)(15,16),
	 (1,16,10,13,6,12,5,4)(2,11,3,15,9,14,8,7),
	 (1,10,6,5)(2,3,9,8)(4,16,13,12)(7,11,15,14),
	 (1,6)(2,9)(3,8)(4,13)(5,10)(7,15)(11,14)(12,16)],"d8y8",
       [ [ [(2,9)(3,8)(7,15)(11,14)],"c8c2","c2",
	   [(),(2,9)(3,8)(7,15)(11,14),(),(),()],
	   [(),(2,9)(3,8)(7,15)(11,14),(),(),()] ] ] ],
[32,18,[(1,2,4,8)(3,11,12,24)(5,9,15,21)(6,10,16,22)
	 (7,18,19,14)(13,25,26,32)(17,23,28,31)(20,29,30,27),
	 (1,3,5,13)(2,7,9,20)(4,12,15,26)(6,14,17,27)(8,19,21,30)
	 (10,11,23,25)(16,18,28,29)(22,24,31,32),
	 (1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)
	 (11,24)(13,26)(14,18)(17,28)(20,30)(23,31)(25,32)(27,29),
	 (1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)(11,25)
	 (12,26)(14,27)(16,28)(18,29)(19,30)(22,31)(24,32),
	 (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,22)(9,23)(12,18)
	 (13,27)(15,28)(19,24)(20,25)(21,31)(26,29)(30,32)],"[ ]",
       [ [ [(1,3,5,13)(2,7,9,20)(4,12,15,26)(6,14,17,27)(8,19,21,30)
	    (10,11,23,25)(16,18,28,29)(22,24,31,32),(1,5)(2,9)(3,13)(4,15)
	    (6,17)(7,20)(8,21)(10,23)(11,25)(12,26)(14,27)(16,28)(18,29)
	    (19,30)(22,31)(24,32)],"c2c4","c4",
	   [(),(1,3,5,13)(2,7,9,20)(4,12,15,26)(6,14,17,27)(8,19,21,30)
	    (10,11,23,25)(16,18,28,29)(22,24,31,32),(),(1,5)(2,9)(3,13)
	    (4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)(14,27)(16,28)
	    (18,29)(19,30)(22,31)(24,32),()],
	   [(),(1,3,5,13)(2,7,9,20)(4,12,15,26)(6,14,17,27)(8,19,21,30)
	    (10,11,23,25)(16,18,28,29)(22,24,31,32),(),(1,5)(2,9)(3,13)
	    (4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)(14,27)(16,28)
	    (18,29)(19,30)(22,31)(24,32),()] ],
	 [ [(1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)
	    (14,27)(16,28)(18,29)(19,30)(22,31)(24,32),(1,3,5,13)(2,7,9,20)
	    (4,12,15,26)(6,14,17,27)(8,19,21,30)(10,11,23,25)(16,18,28,29)
	    (22,24,31,32),(1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)
	    (11,25)(12,26)(14,27)(16,28)(18,29)(19,30)(22,31)(24,32)],
	    "c2c4","c4",
	   [(1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)
	    (14,27)(16,28)(18,29)(19,30)(22,31)(24,32),(1,3,5,13)(2,7,9,20)
	    (4,12,15,26)(6,14,17,27)(8,19,21,30)(10,11,23,25)(16,18,28,29)
	    (22,24,31,32),(),(1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)
	    (11,25)(12,26)(14,27)(16,28)(18,29)(19,30)(22,31)(24,32),()],
	   [(),(1,3,5,13)(2,7,9,20)(4,12,15,26)(6,14,17,27)(8,19,21,30)
	    (10,11,23,25)(16,18,28,29)(22,24,31,32),(),(1,5)(2,9)(3,13)
	    (4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)(14,27)(16,28)
	    (18,29)(19,30)(22,31)(24,32),()] ] ] ],
[32,19,[(1,2,5,9,6,10,17,23)(3,11,13,25,14,7,18,20)
	 (4,8,15,21,16,22,28,31)(12,24,26,32,27,19,29,30),
	 (1,3,4,12)(2,7,8,19)(5,13,15,26)
	 (6,14,16,27)(9,20,21,30)(10,11,22,24)
	 (17,18,28,29)(23,25,31,32),
	 (1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)
	 (11,24)(13,26)(14,27)(17,28)(18,29)(20,30)(23,31)(25,32),
	 (1,5,6,17)(2,9,10,23)(3,13,14,18)(4,15,16,28)(7,20,11,25)
	 (8,21,22,31)(12,26,27,29)(19,30,24,32),
	 (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,22)(9,23)(12,27)
	 (13,18)(15,28)(19,24)(20,25)(21,31)(26,29)(30,32)],"[ ]",
       [ [ [(1,3,4,12)(2,7,8,19)(5,13,15,26)(6,14,16,27)(9,20,21,30)
	    (10,11,22,24)(17,18,28,29)(23,25,31,32),
	    (1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)(11,24)(13,26)
	    (14,27)(17,28)(18,29)(20,30)(23,31)(25,32)],"c8","c4",
	   [(),(1,3,4,12)(2,7,8,19)(5,13,15,26)(6,14,16,27)(9,20,21,30)
	     (10,11,22,24)(17,18,28,29)(23,25,31,32),
	     (1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)(11,24)(13,26)
	     (14,27)(17,28)(18,29)(20,30)(23,31)(25,32),(),()],
	   [(),(1,3,4,12)(2,7,8,19)(5,13,15,26)(6,14,16,27)(9,20,21,30)
	     (10,11,22,24)(17,18,28,29)(23,25,31,32),
	     (1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)(11,24)(13,26)
	     (14,27)(17,28)(18,29)(20,30)(23,31)(25,32),(),()] ],
	 [ [(1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)(11,24)(13,26)
	     (14,27)(17,28)(18,29)(20,30)(23,31)(25,32),
	     (1,3,4,12)(2,7,8,19)(5,13,15,26)(6,14,16,27)(9,20,21,30)
	     (10,11,22,24)(17,18,28,29)(23,25,31,32),
	     (1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)(11,24)(13,26)
	     (14,27)(17,28)(18,29)(20,30)(23,31)(25,32)],"c8","c4",
	   [(1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)(11,24)(13,26)
	     (14,27)(17,28)(18,29)(20,30)(23,31)(25,32),
	     (1,3,4,12)(2,7,8,19)(5,13,15,26)(6,14,16,27)(9,20,21,30)
	     (10,11,22,24)(17,18,28,29)(23,25,31,32),
	     (1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)(11,24)(13,26)
	     (14,27)(17,28)(18,29)(20,30)(23,31)(25,32),(),()],
	   [(),(1,3,4,12)(2,7,8,19)(5,13,15,26)(6,14,16,27)(9,20,21,30)
	     (10,11,22,24)(17,18,28,29)(23,25,31,32),
	     (1,4)(2,8)(3,12)(5,15)(6,16)(7,19)(9,21)(10,22)(11,24)(13,26)
	     (14,27)(17,28)(18,29)(20,30)(23,31)(25,32),(),()] ] ] ],
[32,20,[(1,14,9,8,4,7,3,2)(5,16,15,13,11,12,10,6),
	 (2,6)(7,12)(8,13)(14,16),(1,9,4,3)(2,14,8,7)
	 (5,15,11,10)(6,16,13,12),(1,4)(2,8)(3,9)(5,11)(6,13)
	 (7,14)(10,15)(12,16),(1,5)(2,6)(3,10)(4,11)(7,12)
	 (8,13)(9,15)(14,16)],"[ ]",
       [ [ [(2,6)(7,12)(8,13)(14,16)],"c8c2","c2",
	   [(),(2,6)(7,12)(8,13)(14,16),(),(),()],
	   [(),(2,6)(7,12)(8,13)(14,16),(),(),()] ],
	 [ [(1,7,15,6,4,14,10,13)(2,11,16,3,8,5,12,9),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16),
	     (1,15,4,10)(2,16,8,12)(3,5,9,11)(6,14,13,7),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16)],
		"k4","c8",
	   [(1,7,15,6,4,14,10,13)(2,11,16,3,8,5,12,9),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16),
	     (1,15,4,10)(2,16,8,12)(3,5,9,11)(6,14,13,7),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16),()],
	   [(1,7,15,6,4,14,10,13)(2,11,16,3,8,5,12,9),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16),
	     (1,15,4,10)(2,16,8,12)(3,5,9,11)(6,14,13,7),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16),()] ],
	[  [(1,14,15,13,4,7,10,6)(2,5,16,9,8,11,12,3),
	     (1,15,4,10)(2,16,8,12)(3,5,9,11)(6,14,13,7),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16)],
	       "k4","c8",
	   [(1,14,15,13,4,7,10,6)(2,5,16,9,8,11,12,3),(),
	     (1,15,4,10)(2,16,8,12)(3,5,9,11)(6,14,13,7),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16),()],
	   [(1,7,15,6,4,14,10,13)(2,11,16,3,8,5,12,9),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16),
	     (1,15,4,10)(2,16,8,12)(3,5,9,11)(6,14,13,7),
	     (1,4)(2,8)(3,9)(5,11)(6,13)(7,14)(10,15)(12,16),()] ] ] ],
[32,21,[(1,2,4,8,5,9,15,21)(3,11,12,24,13,25,26,32)
	 (6,10,16,22,17,23,28,31)(7,18,19,27,20,29,30,14),
	 (1,3,6,14)(2,7,10,11)(4,12,16,18)(5,13,17,27)
	 (8,19,22,24)(9,20,23,25)(15,26,28,29)(21,30,31,32),
	 (1,4,5,15)(2,8,9,21)(3,12,13,26)(6,16,17,28)
	 (7,19,20,30)(10,22,23,31)(11,24,25,32)(14,18,27,29),
	 (1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)
	 (11,25)(12,26)(14,27)(16,28)(18,29)(19,30)(22,31)(24,32),
	 (1,6)(2,10)(3,14)(4,16)(5,17)(7,11)(8,22)(9,23)(12,18)
	 (13,27)(15,28)(19,24)(20,25)(21,31)(26,29)(30,32)],"c8+q8",
       [ [ [(1,2,4,8,5,9,15,21)(3,11,12,24,13,25,26,32)(6,10,16,22,17,23,28,31)
	     (7,18,19,27,20,29,30,14),(1,4,5,15)(2,8,9,21)(3,12,13,26)
	     (6,16,17,28)(7,19,20,30)(10,22,23,31)(11,24,25,32)(14,18,27,29),
	     (1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)
	     (14,27)(16,28)(18,29)(19,30)(22,31)(24,32)],"c4","c8",
	   [(1,2,4,8,5,9,15,21)(3,11,12,24,13,25,26,32)(6,10,16,22,17,23,28,31)
	     (7,18,19,27,20,29,30,14),(),(1,4,5,15)(2,8,9,21)(3,12,13,26)
	     (6,16,17,28)(7,19,20,30)(10,22,23,31)(11,24,25,32)(14,18,27,29),
	     (1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)
	     (14,27)(16,28)(18,29)(19,30)(22,31)(24,32),()],
	   [(1,2,4,8,5,9,15,21)(3,11,12,24,13,25,26,32)(6,10,16,22,17,23,28,31)
	     (7,18,19,27,20,29,30,14),(),(1,4,5,15)(2,8,9,21)(3,12,13,26)
	     (6,16,17,28)(7,19,20,30)(10,22,23,31)(11,24,25,32)(14,18,27,29),
	     (1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)
	     (14,27)(16,28)(18,29)(19,30)(22,31)(24,32),()] ],
	 [ [(1,2,4,8,5,9,15,21)(3,11,12,24,13,25,26,32)(6,10,16,22,17,23,28,31)
	     (7,18,19,27,20,29,30,14),(1,5)(2,9)(3,13)(4,15)(6,17)(7,20)
	     (8,21)(10,23)(11,25)(12,26)(14,27)(16,28)(18,29)(19,30)
	     (22,31)(24,32),(1,4,5,15)(2,8,9,21)(3,12,13,26)(6,16,17,28)
	     (7,19,20,30)(10,22,23,31)(11,24,25,32)(14,18,27,29),
	     (1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)
	     (14,27)(16,28)(18,29)(19,30)(22,31)(24,32)],"c4","c8",
	   [(1,2,4,8,5,9,15,21)(3,11,12,24,13,25,26,32)(6,10,16,22,17,23,28,31)
	     (7,18,19,27,20,29,30,14),(1,5)(2,9)(3,13)(4,15)(6,17)(7,20)
	     (8,21)(10,23)(11,25)(12,26)(14,27)(16,28)(18,29)(19,30)
	     (22,31)(24,32),(1,4,5,15)(2,8,9,21)(3,12,13,26)(6,16,17,28)
	     (7,19,20,30)(10,22,23,31)(11,24,25,32)(14,18,27,29),
	     (1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)
	     (14,27)(16,28)(18,29)(19,30)(22,31)(24,32),()],
	   [(1,2,4,8,5,9,15,21)(3,11,12,24,13,25,26,32)(6,10,16,22,17,23,28,31)
	     (7,18,19,27,20,29,30,14),(),(1,4,5,15)(2,8,9,21)(3,12,13,26)
	     (6,16,17,28)(7,19,20,30)(10,22,23,31)(11,24,25,32)(14,18,27,29),
	     (1,5)(2,9)(3,13)(4,15)(6,17)(7,20)(8,21)(10,23)(11,25)(12,26)
	     (14,27)(16,28)(18,29)(19,30)(22,31)(24,32),()] ] ] ],
[32,22,[(1,16,15,13,11,12,10,6,5,14,9,8,4,7,3,2),
	 (2,6)(7,12)(8,13)(14,16),
	 (1,15,11,10,5,9,4,3)(2,16,13,12,6,14,8,7),
	 (1,11,5,4)(2,13,6,8)(3,15,10,9)(7,16,12,14),
	 (1,5)(2,6)(3,10)(4,11)(7,12)(8,13)(9,15)(14,16)],"[ ]",
       [ [ [(2,6)(7,12)(8,13)(14,16)],"c16","c2",
	   [(),(2,6)(7,12)(8,13)(14,16),(),(),()],
	   [(),(2,6)(7,12)(8,13)(14,16),(),(),()] ] ] ],
[32,23,[(1,2,3,4,5,6,7,8),(1,8)(2,7)(3,6)(4,5),(9,10)],"d16c2",
       [ [ [(2,8)(3,7)(4,6)(9,10)],"c8c2","c2",
	   [(),(2,8)(3,7)(4,6)(9,10),()],
	   [(),(2,8)(3,7)(4,6)(9,10),()] ],
	 [ [(2,8)(3,7)(4,6),(9,10)],"c8","k4",
	   [(),(2,8)(3,7)(4,6),(9,10)],
	   [(),(2,8)(3,7)(4,6),(9,10)] ],
	 [ [(9,10),(2,8)(3,7)(4,6)(9,10),(9,10)],"c8","k4",
	   [(9,10),(2,8)(3,7)(4,6)(9,10),(9,10)],
	   [(),(2,8)(3,7)(4,6),(9,10)] ],
	 [ [(1,2,3,4,5,6,7,8),(1,4)(2,3)(5,8)(6,7)(9,10),
	     (1,5)(2,6)(3,7)(4,8)],"c2","d16",
	   [(1,2,3,4,5,6,7,8),(1,4)(2,3)(5,8)(6,7)(9,10),
	     (1,5)(2,6)(3,7)(4,8)],
	   [(1,2,3,4,5,6,7,8),(1,4)(2,3)(5,8)(6,7)(9,10),
	     (1,5)(2,6)(3,7)(4,8)] ],
	 [ [(1,2,3,4,5,6,7,8),(1,8)(2,7)(3,6)(4,5)(9,10)],"c2","d16",
	   [(1,2,3,4,5,6,7,8),(1,8)(2,7)(3,6)(4,5)(9,10),()],
	   [(1,2,3,4,5,6,7,8),(1,4)(2,3)(5,8)(6,7)(9,10),
	     (1,5)(2,6)(3,7)(4,8)] ] ] ],
[32,24,[(1,2,3,4,5,6,7,8),(2,4)(3,7)(6,8),(9,10)],"qd16c2",
       [ [ [(2,4)(3,7)(6,8)(9,10)],"c8c2","c2",
	   [(),(2,4)(3,7)(6,8)(9,10),()],
	   [(),(2,4)(3,7)(6,8)(9,10),()] ],
	 [ [(2,4)(3,7)(6,8),(9,10)],"c8","k4",
	   [(),(2,4)(3,7)(6,8),(9,10)],
	   [(),(2,4)(3,7)(6,8),(9,10)] ],
	 [ [(9,10),(2,4)(3,7)(6,8),(9,10)],"c8","k4",
	   [(9,10),(2,4)(3,7)(6,8),(9,10)],
	   [(),(2,4)(3,7)(6,8),(9,10)] ],
	 [ [(1,2,3,4,5,6,7,8),(2,4)(3,7)(6,8)],"c2","qd16",
	   [(1,2,3,4,5,6,7,8),(2,4)(3,7)(6,8),()],
	   [(1,2,3,4,5,6,7,8),(2,4)(3,7)(6,8),()] ],
	 [ [(1,2,3,4,5,6,7,8),(2,4)(3,7)(6,8),
	     (1,5)(2,6)(3,7)(4,8)],"c2","qd16",
	   [(1,2,3,4,5,6,7,8),(2,4)(3,7)(6,8),(1,5)(2,6)(3,7)(4,8)],
	   [(1,2,3,4,5,6,7,8),(2,4)(3,7)(6,8),()] ] ] ],
[32,25,[(1,2,3,4,5,6,7,8)(9,16,15,14,13,12,11,10),
	 (1,9,5,13)(2,10,6,14)(3,11,7,15)(4,12,8,16),(17,18)],"q16c2",
       [ [ [(1,2,3,4,5,6,7,8)(9,16,15,14,13,12,11,10),
	     (1,9,5,13)(2,10,6,14)(3,11,7,15)(4,12,8,16)],"c2","q16",
	   [(1,2,3,4,5,6,7,8)(9,16,15,14,13,12,11,10),
	     (1,9,5,13)(2,10,6,14)(3,11,7,15)(4,12,8,16),()],
	   [(1,2,3,4,5,6,7,8)(9,16,15,14,13,12,11,10),
	     (1,9,5,13)(2,10,6,14)(3,11,7,15)(4,12,8,16),()] ],
	 [ [(1,2,3,4,5,6,7,8)(9,16,15,14,13,12,11,10),
	     (1,9,5,13)(2,10,6,14)(3,11,7,15)(4,12,8,16),
	     (1,5)(2,6)(3,7)(4,8)(9,13)(10,14)(11,15)(12,16)],
	       "c2","q16",
	   [(1,2,3,4,5,6,7,8)(9,16,15,14,13,12,11,10),
	     (1,9,5,13)(2,10,6,14)(3,11,7,15)(4,12,8,16),
	     (1,5)(2,6)(3,7)(4,8)(9,13)(10,14)(11,15)(12,16)],
	   [(1,2,3,4,5,6,7,8)(9,16,15,14,13,12,11,10),
	     (1,9,5,13)(2,10,6,14)(3,11,7,15)(4,12,8,16),()] ] ] ],
[32,26,[(1,2)(3,10)(4,8)(5,9)(6,7)(11,16)(12,15)(13,14),
	 (1,7,3,9,5,10,6,2)(4,14,11,15,12,16,13,8),
	 (1,6,5,3)(2,10,9,7)(4,13,12,11)(8,16,15,14),
	 (1,12,5,4)(2,15,9,8)(3,13,6,11)(7,16,10,14),
	 (1,5)(2,9)(3,6)(4,12)(7,10)(8,15)(11,13)(14,16)],"d16y4",
       [ [ [(2,7)(3,6)(8,14)(9,10)(11,13)(15,16)],"c8c2","c2",
	   [(2,7)(3,6)(8,14)(9,10)(11,13)(15,16),(),(),(),()],
	   [(2,7)(3,6)(8,14)(9,10)(11,13)(15,16),(),(),(),()] ] ] ],
[32,27,[(2,6)(3,10)(7,11)(8,13)(9,14)(15,16),
	 (1,13,11,9,5,15,7,2)(3,16,12,14,10,8,4,6),
	 (1,10,5,3)(2,14,9,6)(4,7,12,11)(8,15,16,13),
	 (1,4)(2,8)(3,11)(5,12)(6,13)(7,10)(9,16)(14,15),
	 (1,5)(2,9)(3,10)(4,12)(6,14)(7,11)(8,16)(13,15)],"[ ]",
       [ [ [(2,6)(3,10)(7,11)(8,13)(9,14)(15,16)],"c8c2","c2",
	   [(2,6)(3,10)(7,11)(8,13)(9,14)(15,16),(),(),(),()],
	   [(2,6)(3,10)(7,11)(8,13)(9,14)(15,16),(),(),(),()] ] ] ],
[32,28,[(1,2,6,10)(3,11,15,27)(4,16,18,8)(5,9,19,25)
	 (7,20,23,13)(12,24,17,21)(14,26,30,31)(22,28,32,29),
	 (1,3,12,28,6,15,17,29)(2,7,21,31,10,23,24,26)
	 (4,13,5,14,18,20,19,30)(8,11,9,22,16,27,25,32),
	 (1,4,6,18)(2,8,10,16)(3,13,15,20)(5,17,19,12)
	 (7,11,23,27)(9,24,25,21)(14,29,30,28)(22,26,32,31),
	 (1,5)(2,9)(3,14)(4,17)(6,19)(7,22)(8,24)(10,25)
	 (11,26)(12,18)(13,29)(15,30)(16,21)(20,28)(23,32)(27,31),
	 (1,6)(2,10)(3,15)(4,18)(5,19)(7,23)(8,16)
	 (9,25)(11,27)(12,17)(13,20)(14,30)
	 (21,24)(22,32)(26,31)(28,29)],"[ ]",[ ] ],
[32,29,[(1,2)(3,4)(5,6,7,8,9,10,11,12),
			      (1,3,2,4)(6,12)(7,11)(8,10)],"[ ]",
       [ [ [(1,3,2,4)(6,12)(7,11)(8,10)],"c8","c4",
	   [(),(1,3,2,4)(6,12)(7,11)(8,10)],
	   [(),(1,3,2,4)(6,12)(7,11)(8,10)] ],
	 [ [(1,2)(3,4),(1,3,2,4)(6,12)(7,11)(8,10)],"c8","c4",
	   [(1,2)(3,4),(1,3,2,4)(6,12)(7,11)(8,10)],
	   [(),(1,3,2,4)(6,12)(7,11)(8,10)] ] ] ],
[32,30,[(1,2,5,9)(3,11,13,25)(4,15,16,29)(6,10,18,24)
	 (7,19,20,12)(8,22,23,17)(14,26,28,32)(21,30,31,27),
	 (1,3,4,12,6,14,17,27)(2,7,8,11,10,21,15,26)
	 (5,13,16,19,18,28,22,30)(9,20,23,25,24,31,29,32),
	 (1,4,6,17)(2,8,10,15)(3,12,14,27)(5,16,18,22)
	 (7,11,21,26)(9,23,24,29)(13,19,28,30)(20,25,31,32),
	 (1,5)(2,9)(3,13)(4,16)(6,18)(7,20)(8,23)(10,24)
	 (11,25)(12,19)(14,28)(15,29)(17,22)(21,31)
	 (26,32)(27,30),(1,6)(2,10)(3,14)(4,17)(5,18)(7,21)
	 (8,15)(9,24)(11,26)(12,27)(13,28)(16,22)(19,30)
	 (20,31)(23,29)(25,32)],"[ ]",
       [ [ [(1,2,5,9)(3,11,13,25)(4,15,16,29)(6,10,18,24)(7,19,20,12)
	     (8,22,23,17)(14,26,28,32)(21,30,31,27),
	     (1,5)(2,9)(3,13)(4,16)(6,18)(7,20)(8,23)(10,24)(11,25)(12,19)
	     (14,28)(15,29)(17,22)(21,31)(26,32)(27,30)],"c8","c4",
	   [(1,2,5,9)(3,11,13,25)(4,15,16,29)(6,10,18,24)(7,19,20,12)
	     (8,22,23,17)(14,26,28,32)(21,30,31,27),(),(),
	     (1,5)(2,9)(3,13)(4,16)(6,18)(7,20)(8,23)(10,24)(11,25)(12,19)
	     (14,28)(15,29)(17,22)(21,31)(26,32)(27,30),()],
	   [(1,2,5,9)(3,11,13,25)(4,15,16,29)(6,10,18,24)(7,19,20,12)
	     (8,22,23,17)(14,26,28,32)(21,30,31,27),(),(),
	     (1,5)(2,9)(3,13)(4,16)(6,18)(7,20)(8,23)(10,24)(11,25)(12,19)
	     (14,28)(15,29)(17,22)(21,31)(26,32)(27,30),()] ],
	  [ [(1,2,5,9)(3,11,13,25)(4,15,16,29)(6,10,18,24)(7,19,20,12)
	      (8,22,23,17)(14,26,28,32)(21,30,31,27),
	      (1,5)(2,9)(3,13)(4,16)(6,18)(7,20)(8,23)(10,24)(11,25)(12,19)
	      (14,28)(15,29)(17,22)(21,31)(26,32)(27,30),
	      (1,5)(2,9)(3,13)(4,16)(6,18)(7,20)(8,23)(10,24)(11,25)(12,19)
	      (14,28)(15,29)(17,22)(21,31)(26,32)(27,30)],"c8","c4",
	    [(1,2,5,9)(3,11,13,25)(4,15,16,29)(6,10,18,24)(7,19,20,12)
	      (8,22,23,17)(14,26,28,32)(21,30,31,27),
	      (1,5)(2,9)(3,13)(4,16)(6,18)(7,20)(8,23)(10,24)(11,25)(12,19)
	      (14,28)(15,29)(17,22)(21,31)(26,32)(27,30),(),
	      (1,5)(2,9)(3,13)(4,16)(6,18)(7,20)(8,23)(10,24)(11,25)(12,19)
	      (14,28)(15,29)(17,22)(21,31)(26,32)(27,30),()],
	    [(1,2,5,9)(3,11,13,25)(4,15,16,29)(6,10,18,24)(7,19,20,12)
	      (8,22,23,17)(14,26,28,32)(21,30,31,27),(),(),
	      (1,5)(2,9)(3,13)(4,16)(6,18)(7,20)(8,23)(10,24)(11,25)(12,19)
	      (14,28)(15,29)(17,22)(21,31)(26,32)(27,30),()] ] ] ],
[32,31,[(1,2,3,4,5,6,7,8),(1,3,5,7)],"[ ]",
       [ [ [(1,2)(3,4)(5,6)(7,8)],"c4^2","c2",
	   [(1,2)(3,4)(5,6)(7,8),()],
	   [(1,2)(3,4)(5,6)(7,8),()] ] ] ],
[32,32,[(1,14,4,9,6,8,5,2)(3,7,11,16,13,15,12,10),
	 (1,11,4,13,6,12,5,3)(2,10,8,15,9,16,14,7),
	 (1,5,6,4)(2,14,9,8)(3,12,13,11)(7,16,15,10),
	 (1,4,6,5)(2,14,9,8)(3,11,13,12)(7,16,15,10),
	 (1,6)(2,9)(3,13)(4,5)(7,15)(8,14)(10,16)(11,12)],"[ ]",[ ] ],
[32,33,[(1,2)(3,8)(4,6)(5,7),(1,3)(2,6)(4,5)(7,8),(1,4)  
	 (2,7)(3,5)(6,8),(1,5)(2,7)(3,4)(6,8),
	 (1,3)(2,8)(4,5)(6,7)],"[ ]",
       [ [ [(2,7)(6,8),(2,8)(6,7)],"c2^3","k4",
	   [(),(2,7)(6,8),(2,8)(6,7),(),()],
	   [(),(2,7)(6,8),(2,8)(6,7),(),()] ],
	 [ [(2,6)(7,8),(2,7)(6,8),(2,8)(6,7)],"c2c4","k4",
	   [(2,6)(7,8),(2,7)(6,8),(2,8)(6,7),(),()],
	   [(2,6)(7,8),(2,7)(6,8),(2,8)(6,7),(),()] ],
	 [ [(1,2)(3,8)(4,6)(5,7)],"c2^4","c2",
	   [(1,2)(3,8)(4,6)(5,7),(),(),(),()],
	   [(1,2)(3,8)(4,6)(5,7),(),(),(),()] ],
	 [ [(1,2)(3,8)(4,6)(5,7),(2,6)(7,8),(1,4)(2,6)(3,5)(7,8)],"k4","d8",
	   [(1,2)(3,8)(4,6)(5,7),(),(2,6)(7,8),(),(1,4)(2,6)(3,5)(7,8)],
	   [(1,2)(3,8)(4,6)(5,7),(),(2,6)(7,8),(),(1,4)(2,6)(3,5)(7,8)] ],
	 [ [(1,2)(3,8)(4,6)(5,7),(2,6)(7,8),(1,4)(2,6)(3,5)(7,8),
	     (1,4)(2,6)(3,5)(7,8)],"k4","d8",
	   [(1,2)(3,8)(4,6)(5,7),(2,6)(7,8),(1,4)(2,6)(3,5)(7,8),
	     (1,4)(2,6)(3,5)(7,8),()],
	   [(1,2)(3,8)(4,6)(5,7),(),(2,6)(7,8),(),(1,4)(2,6)(3,5)(7,8)] ],
	 [ [(1,2)(3,8)(4,6)(5,7),(1,4)(2,6)(3,5)(7,8),(1,4)(3,5),
	     (1,4)(2,6)(3,5)(7,8)],"k4","d8",
	   [(1,2)(3,8)(4,6)(5,7),(1,4)(2,6)(3,5)(7,8),(1,4)(3,5),(),
	     (1,4)(2,6)(3,5)(7,8)],
	   [(1,2)(3,8)(4,6)(5,7),(),(2,6)(7,8),(),(1,4)(2,6)(3,5)(7,8)] ] ] ],
[32,34,[(1,2)(3,4)(5,9)(6,10)(7,11)(8,12)(13,16)(14,15),
	 (1,11,5,3)(2,4,9,7)(6,15,13,8)(10,12,16,14),
	 (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
	 (1,5)(2,9)(3,11)(4,7)(6,13)(8,15)(10,16)(12,14),
	 (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)],"[ ]",
       [ [ [(2,16)(3,11)(4,12)(7,14)(8,15)(9,10)],"c4^2","c2",
	   [(2,16)(3,11)(4,12)(7,14)(8,15)(9,10),(),(),(),()],
	   [(2,16)(3,11)(4,12)(7,14)(8,15)(9,10),(),(),(),()] ],
	 [ [(2,16)(3,11)(4,12)(7,14)(8,15)(9,10),
             (1,4,6,12)(2,8,10,3)(5,7,13,14)(9,15,16,11),
	     (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
 	     (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15),
	     (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)],"c4","d8",
	    [(2,16)(3,11)(4,12)(7,14)(8,15)(9,10),
 	     (1,4,6,12)(2,8,10,3)(5,7,13,14)(9,15,16,11),
	     (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
	     (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15),
 	     (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)],
	    [(2,16)(3,11)(4,12)(7,14)(8,15)(9,10),
 	     (1,4,6,12)(2,8,10,3)(5,7,13,14)(9,15,16,11),
	     (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
	     (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15),
 	     (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)] ],
	  [ [(1,4)(2,11)(3,9)(5,7)(6,12)(8,16)(10,15)(13,14),
	     (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
	     (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)],"c4","d8",
	    [(1,4)(2,11)(3,9)(5,7)(6,12)(8,16)(10,15)(13,14),(),
             (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),(),
             (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)],
            [(2,16)(3,11)(4,12)(7,14)(8,15)(9,10),
             (1,4,6,12)(2,8,10,3)(5,7,13,14)(9,15,16,11),
             (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
             (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15),
             (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)] ],
	  [ [(1,6)(2,9)(3,15)(5,13)(8,11)(10,16),
 	     (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
             (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
             (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15),
             (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)],"c4","d8",
            [(1,6)(2,9)(3,15)(5,13)(8,11)(10,16),
             (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
             (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
             (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15),
             (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)],
            [(2,16)(3,11)(4,12)(7,14)(8,15)(9,10),
             (1,4,6,12)(2,8,10,3)(5,7,13,14)(9,15,16,11),
             (1,12,6,4)(2,3,10,8)(5,14,13,7)(9,11,16,15),
             (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15),
             (1,6)(2,10)(3,8)(4,12)(5,13)(7,14)(9,16)(11,15)] ] ] ],
[32,35,[(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23) 
	 (7,19,21,13)(12,26,28,24)(16,30,31,22)(20,27,29,32),
	 (1,3,5,13)(2,7,9,11)(4,12,16,27)(6,14,18,19)
	 (8,20,22,24)(10,21,23,25)(15,29,30,26)(17,28,31,32),
	 (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)
	 (7,20,21,29)(9,22,23,30)(11,24,25,26)(13,27,19,32),
	 (1,5)(2,9)(3,13)(4,16)(6,18)(7,11)(8,22)(10,23)
	 (12,27)(14,19)(15,30)(17,31)(20,24)(21,25)(26,29)
	 (28,32),(1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)
	 (9,23)(11,25)(12,28)(13,19)(16,31)(20,29)
	 (22,30)(24,26)(27,32)],"q8+q8",
        [ [ [(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23)(7,19,21,13)
	     (12,26,28,24)(16,30,31,22)(20,27,29,32),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32)],"c4","q8",
	    [(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23)(7,19,21,13)
	     (12,26,28,24)(16,30,31,22)(20,27,29,32),(),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),(),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32)],
	    [(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23)(7,19,21,13)
	     (12,26,28,24)(16,30,31,22)(20,27,29,32),(),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),(),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32)] ],
	  [ [(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23)(7,19,21,13)
	     (12,26,28,24)(16,30,31,22)(20,27,29,32),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32)],"c4","q8",
	    [(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23)(7,19,21,13)
	     (12,26,28,24)(16,30,31,22)(20,27,29,32),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32)],
	   [(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23)(7,19,21,13)
	     (12,26,28,24)(16,30,31,22)(20,27,29,32),(),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),(),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32)] ],
	 [ [(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23)(7,19,21,13)
	     (12,26,28,24)(16,30,31,22)(20,27,29,32),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32)],"c4","q8",
	   [(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23)(7,19,21,13)
	     (12,26,28,24)(16,30,31,22)(20,27,29,32),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),(),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32)],
	   [(1,2,6,10)(3,11,14,25)(4,15,17,8)(5,9,18,23)(7,19,21,13)
	     (12,26,28,24)(16,30,31,22)(20,27,29,32),(),
	     (1,4,6,17)(2,8,10,15)(3,12,14,28)(5,16,18,31)(7,20,21,29)
	     (9,22,23,30)(11,24,25,26)(13,27,19,32),(),
	     (1,6)(2,10)(3,14)(4,17)(5,18)(7,21)(8,15)(9,23)(11,25)(12,28)
	     (13,19)(16,31)(20,29)(22,30)(24,26)(27,32)] ] ] ],
[32,36,[(1,2)(3,9)(4,7)(5,8)(6,10)(11,16)(12,14)(13,15),
	 (1,3)(2,6)(4,10)(5,11)(7,9)(8,13)(12,15)(14,16),
	 (1,8,5,2)(3,13,11,6)(4,14,12,7)(9,10,16,15),
	 (1,4)(2,7)(3,10)(5,12)(6,9)(8,14)(11,15)(13,16),
	 (1,5)(2,8)(3,11)(4,12)(6,13)(7,14)(9,16)(10,15)],"[ ]",
       [ [ [(2,8)(3,10)(6,16)(7,14)(9,13)(11,15)],"c4k4","c2",
	   [(2,8)(3,10)(6,16)(7,14)(9,13)(11,15),(),(),(),()],
	   [(2,8)(3,10)(6,16)(7,14)(9,13)(11,15),(),(),(),()] ],
	 [ [(2,8)(3,10)(6,16)(7,14)(9,13)(11,15),
	     (1,3)(2,6)(4,10)(5,11)(7,9)(8,13)(12,15)(14,16),
	     (1,4)(2,7)(3,10)(5,12)(6,9)(8,14)(11,15)(13,16)],"c4","d8",
	   [(2,8)(3,10)(6,16)(7,14)(9,13)(11,15),
	     (1,3)(2,6)(4,10)(5,11)(7,9)(8,13)(12,15)(14,16),(),
	     (1,4)(2,7)(3,10)(5,12)(6,9)(8,14)(11,15)(13,16),()],
	   [(2,8)(3,10)(6,16)(7,14)(9,13)(11,15),
	     (1,3)(2,6)(4,10)(5,11)(7,9)(8,13)(12,15)(14,16),(),
	     (1,4)(2,7)(3,10)(5,12)(6,9)(8,14)(11,15)(13,16),()] ],
	 [ [(1,4)(2,14)(5,12)(6,13)(7,8)(9,16),
	     (1,3)(2,6)(4,10)(5,11)(7,9)(8,13)(12,15)(14,16),
	     (1,4)(2,7)(3,10)(5,12)(6,9)(8,14)(11,15)(13,16),
	     (1,4)(2,7)(3,10)(5,12)(6,9)(8,14)(11,15)(13,16)],"c4","d8",
	   [(1,4)(2,14)(5,12)(6,13)(7,8)(9,16),
	     (1,3)(2,6)(4,10)(5,11)(7,9)(8,13)(12,15)(14,16),
	     (1,4)(2,7)(3,10)(5,12)(6,9)(8,14)(11,15)(13,16),
	     (1,4)(2,7)(3,10)(5,12)(6,9)(8,14)(11,15)(13,16),()],
	   [(2,8)(3,10)(6,16)(7,14)(9,13)(11,15),
	     (1,3)(2,6)(4,10)(5,11)(7,9)(8,13)(12,15)(14,16),(),
	     (1,4)(2,7)(3,10)(5,12)(6,9)(8,14)(11,15)(13,16),()] ],
	 [ [(1,2)(3,9)(4,7)(5,8)(6,10)(11,16)(12,14)(13,15),
	     (1,8,5,2)(3,13,11,6)(4,14,12,7)(9,10,16,15),
	     (1,5)(2,8)(3,11)(4,12)(6,13)(7,14)(9,16)(10,15)],"k4","d8",
	   [(1,2)(3,9)(4,7)(5,8)(6,10)(11,16)(12,14)(13,15),(),
	     (1,8,5,2)(3,13,11,6)(4,14,12,7)(9,10,16,15),(),
	     (1,5)(2,8)(3,11)(4,12)(6,13)(7,14)(9,16)(10,15)],
	   [(1,2)(3,9)(4,7)(5,8)(6,10)(11,16)(12,14)(13,15),(),
	     (1,8,5,2)(3,13,11,6)(4,14,12,7)(9,10,16,15),(),
	     (1,5)(2,8)(3,11)(4,12)(6,13)(7,14)(9,16)(10,15)] ],
	 [ [(1,2)(3,9)(4,7)(5,8)(6,10)(11,16)(12,14)(13,15),
	     (1,5)(2,8)(3,11)(4,12)(6,13)(7,14)(9,16)(10,15),
	     (1,8,5,2)(3,13,11,6)(4,14,12,7)(9,10,16,15),
	     (1,5)(2,8)(3,11)(4,12)(6,13)(7,14)(9,16)(10,15)],"k4","d8",
	  [(1,2)(3,9)(4,7)(5,8)(6,10)(11,16)(12,14)(13,15),
	    (1,5)(2,8)(3,11)(4,12)(6,13)(7,14)(9,16)(10,15),
	    (1,8,5,2)(3,13,11,6)(4,14,12,7)(9,10,16,15),(),
	    (1,5)(2,8)(3,11)(4,12)(6,13)(7,14)(9,16)(10,15)],
	  [(1,2)(3,9)(4,7)(5,8)(6,10)(11,16)(12,14)(13,15),(),
	    (1,8,5,2)(3,13,11,6)(4,14,12,7)(9,10,16,15),(),
	    (1,5)(2,8)(3,11)(4,12)(6,13)(7,14)(9,16)(10,15)] ] ] ],
[32,37,[(1,8,5,2)(3,7,11,9)(4,14,12,6)(10,13,16,15),
	 (2,6)(7,13)(8,14)(9,15),(1,11,5,3)(2,9,8,7)
	 (4,16,12,10)(6,15,14,13),(1,4)(2,6)(3,10)(5,12)
	 (7,13)(8,14)(9,15)(11,16),(1,5)(2,8)(3,11)(4,12)
	 (6,14)(7,9)(10,16)(13,15)],"[ ]",
       [ [ [(1,8,5,2)(3,7,11,9)(4,14,12,6)(10,13,16,15),
	     (1,11,5,3)(2,9,8,7)(4,16,12,10)(6,15,14,13),
	     (1,5)(2,8)(3,11)(4,12)(6,14)(7,9)(10,16)(13,15)],"k4","q8",
	   [(1,8,5,2)(3,7,11,9)(4,14,12,6)(10,13,16,15),(),
	     (1,11,5,3)(2,9,8,7)(4,16,12,10)(6,15,14,13),(),
	     (1,5)(2,8)(3,11)(4,12)(6,14)(7,9)(10,16)(13,15)],
	   [(1,8,5,2)(3,7,11,9)(4,14,12,6)(10,13,16,15),(),
	     (1,11,5,3)(2,9,8,7)(4,16,12,10)(6,15,14,13),(),
	     (1,5)(2,8)(3,11)(4,12)(6,14)(7,9)(10,16)(13,15)] ],
	 [ [(1,8,5,2)(3,7,11,9)(4,14,12,6)(10,13,16,15),
	     (1,5)(2,8)(3,11)(4,12)(6,14)(7,9)(10,16)(13,15),
	     (1,11,5,3)(2,9,8,7)(4,16,12,10)(6,15,14,13),
	     (1,5)(2,8)(3,11)(4,12)(6,14)(7,9)(10,16)(13,15)],"k4","q8",
	   [(1,8,5,2)(3,7,11,9)(4,14,12,6)(10,13,16,15),
	     (1,5)(2,8)(3,11)(4,12)(6,14)(7,9)(10,16)(13,15),
	     (1,11,5,3)(2,9,8,7)(4,16,12,10)(6,15,14,13),(),
	     (1,5)(2,8)(3,11)(4,12)(6,14)(7,9)(10,16)(13,15)],
	   [(1,8,5,2)(3,7,11,9)(4,14,12,6)(10,13,16,15),(),
	     (1,11,5,3)(2,9,8,7)(4,16,12,10)(6,15,14,13),(),
	     (1,5)(2,8)(3,11)(4,12)(6,14)(7,9)(10,16)(13,15)] ] ] ],
[32,38,[(2,6)(3,9)(7,14)(8,13)(10,16)(12,15),
	 (1,8,5,2)(3,15,9,7)(4,13,11,6)(10,14,16,12),
	 (1,3)(2,7)(4,10)(5,9)(6,12)(8,15)(11,16)(13,14),
	 (1,4)(2,6)(3,10)(5,11)(7,12)(8,13)(9,16)(14,15),
	 (1,5)(2,8)(3,9)(4,11)(6,13)(7,15)(10,16)(12,14)],"[ ]",
       [ [ [(2,6)(3,9)(7,14)(8,13)(10,16)(12,15)],"c4k4","c2",
	   [(2,6)(3,9)(7,14)(8,13)(10,16)(12,15),(),(),(),()],
	   [(2,6)(3,9)(7,14)(8,13)(10,16)(12,15),(),(),(),()] ] ] ],
[32,39,[(2,6)(3,10)(8,15)(9,13)(11,14)(12,16),
	 (1,13,7,2)(3,15,14,8)(4,9,5,6)(10,12,11,16),
	 (1,10,5,3)(2,16,9,8)(4,14,7,11)(6,15,13,12),
	 (1,4)(2,6)(3,11)(5,7)(8,12)(9,13)(10,14)(15,16),
	 (1,5)(2,9)(3,10)(4,7)(6,13)(8,16)(11,14)(12,15)],"[ ]",
       [ [ [(1,3)(2,12)(4,11)(5,10)(6,8)(7,14)(9,15)(13,16)],"c4^2","c2",
	   [(1,3)(2,12)(4,11)(5,10)(6,8)(7,14)(9,15)(13,16),(),(),(),()],
	   [(1,3)(2,12)(4,11)(5,10)(6,8)(7,14)(9,15)(13,16),(),(),(),()] ] ] ],
[32,40,[(1,2,5,9)(3,11,14,7)(4,16,17,31)(6,10,12,19)
	 (8,22,23,18)(13,27,28,30)(15,25,26,21)(20,29,24,32),
	 (1,3,12,26)(2,7,19,25)(4,13,22,32)(5,14,6,15)
	 (8,20,31,27)(9,11,10,21)(16,30,23,24)(17,28,18,29),
	 (1,4,6,18)(2,8,10,16)(3,13,15,29)(5,17,12,22)
	 (7,20,21,30)(9,23,19,31)(11,24,25,27)(14,28,26,32),
	 (1,5)(2,9)(3,14)(4,17)(6,12)(7,11)(8,23)(10,19)
	 (13,28)(15,26)(16,31)(18,22)(20,24)(21,25)(27,30)
	 (29,32),(1,6)(2,10)(3,15)(4,18)(5,12)(7,21)(8,16)
	 (9,19)(11,25)(13,29)(14,26)(17,22)(20,30)(23,31)
	 (24,27)(28,32)],"[ ]",[ ] ],
[32,41,[(2,6)(3,10)(8,15)(9,13)(11,14)(12,16),
	 (1,13,7,2)(3,15,14,8)(4,9,5,6)(10,12,11,16),
	 (1,11,4,3)(2,12,6,8)(5,14,7,10)(9,15,13,16),
	 (1,4)(2,6)(3,11)(5,7)(8,12)(9,13)(10,14)(15,16),
	 (1,5)(2,9)(3,10)(4,7)(6,13)(8,16)(11,14)(12,15)],"[ ]",
       [ [ [(2,6)(3,10)(8,15)(9,13)(11,14)(12,16)],"c4^2","c2",
	   [(2,6)(3,10)(8,15)(9,13)(11,14)(12,16),(),(),(),()],
	   [(2,6)(3,10)(8,15)(9,13)(11,14)(12,16),(),(),(),()] ] ] ],
[32,42,[(1,8,6,2)(3,5,7,4),(1,7,6,3)(2,5,8,4),
	 (1,5,6,4)(2,3,8,7),(1,4,6,5)(2,3,8,7),
	 (1,6)(2,8)(3,7)(4,5)],"d8yd8" ,
       [ [ [( 3,7)( 4,5),( 2,8)( 4,5)],"c2c4","k4",
	   [(),(),(3,7)(4,5),(2,8)(4,5),()],
	   [(),(),(3,7)(4,5),(2,8)(4,5),()] ],
 	 [ [( 3,7)( 4,5),( 2,8)( 3,7)], "q8","k4",
	   [(3,7)(4,5),(),(),(2,8)(3,7),()],
	   [(),(2,8)(4,5),(2,8)(3,7),(),()] ],
	 [ [( 3,7)( 4,5),( 3,7)( 4,5),( 3,7)( 4,5),( 2,8)( 4,5)],"d8","k4", 
	   [(3,7)(4,5),(3,7)(4,5),(3,7)(4,5),(2,8)(4,5),()],
	   [(),(2,8)(3,7),(2,8)(4,5),(3,7)(4,5),()] ],
	 [ [( 2,8)( 4,5),( 3,7)( 4,5),( 2,8)( 4,5),( 3,7)( 4,5)], "c2^3","k4",
	   [(2,8)(4,5),(3,7)(4,5),(2,8)(4,5),(3,7)(4,5),()],
	   [(2,8)(4,5),(3,7)(4,5),(2,8)(4,5),(3,7)(4,5),()] ] ] ],
[32,43,[(1,2)(3,7)(4,8)(5,14)(6,10)(9,12)(11,16)(13,15),
	 (1,11,6,3)(2,16,10,7)(4,5,13,12)(8,14,15,9),
	 (1,13,6,4)(2,15,10,8)(3,12,11,5)(7,9,16,14),
	 (1,12,6,5)(2,14,10,9)(3,13,11,4)(7,8,16,15),
	 (1,6)(2,10)(3,11)(4,13)(5,12)(7,16)(8,15)(9,14)],"d8yq8",[ ] ],
[32,44,[(2,5)(3,6)(7,8),(1,5,3,7,4,8,6,2),(2,7)(5,8),
	 (1,6,4,3)(2,8,7,5),(1,4)(2,7)(3,6)(5,8)],"[ ]",
       [ [ [(2,5)(3,6)(7,8),(2,7)(5,8)],"c8","k4",
	   [(2,5)(3,6)(7,8),(),(2,7)(5,8),(),()],
	   [(2,5)(3,6)(7,8),(),(2,7)(5,8),(),()] ] ] ],
[32,45,[(1,9,6,2)(3,4,13,10)(5,8,11,14)(7,12,16,15),
	 (1,12,5,13,6,15,11,3)(2,10,8,16,9,4,14,7),
	 (1,4)(2,3)(5,7)(6,10)(8,12)(9,13)(11,16)(14,15),
	 (1,11,6,5)(2,14,9,8)(3,15,13,12)(4,16,10,7),
	 (1,6)(2,9)(3,13)(4,10)(5,11)(7,16)(8,14)(12,15)],"[ ]",[ ] ],
[32,46,[(1,3,4,2)(5,7,6,8),(1,3)(2,6)(4,8)(5,7),
	 (1,4)(2,3)(5,6)(7,8),(1,4)(2,7)(3,8)(5,6),
	 (1,5)(2,8)(3,7)(4,6)],"[ ]",
       [ [ [(2,3,8,7)(4,6),(2,8)(3,7)],"c2^3","c4",
	   [(2,3,8,7)(4,6),(),(2,8)(3,7),(),()],
	   [(2,3,8,7)(4,6),(),(2,8)(3,7),(),()] ],
	 [ [(2,7,8,3)(4,6),(2,8)(3,7),(2,8)(3,7)],"c2c4","c4",
	   [(2,7,8,3)(4,6),(2,8)(3,7),(2,8)(3,7),(),()],
	   [(2,7,8,3)(4,6),(2,8)(3,7),(2,8)(3,7),(),()] ] ] ],
[32,47,[(1,8,7,6,4,5,3,2),(3,7)(5,8),(1,7,4,3)(2,8,6,5),
	 (2,6)(5,8),(1,4)(2,6)(3,7)(5,8)],"[ ]",[ ] ],
[32,48,[(1,16,12,8,5,7,4,2)(3,15,11,14,10,13,9,6),
	 (1,10,5,3)(2,14,8,6)(4,9,12,11)(7,13,16,15),
	 (1,12,5,4)(2,16,8,7)(3,11,10,9)(6,15,14,13),
	 (2,8)(6,14)(7,16)(13,15),(1,5)(2,8)(3,10)(4,12)
	 (6,14)(7,16)(9,11)(13,15)],"[ ]",[ ] ],
[32,49,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16),
	 (1,16)(2,15)(3,14)(4,13)(5,12)(6,11)(7,10)(8,9)],"d32",
       [ [ [(2,16)(3,15)(4,14)(5,13)(6,12)(7,11)(8,10)],"c16","c2",
	   [(),(2,16)(3,15)(4,14)(5,13)(6,12)(7,11)(8,10)],
	   [(),(2,16)(3,15)(4,14)(5,13)(6,12)(7,11)(8,10)] ] ] ],
[32,50,[(2,6)(3,10)(4,11)(7,12)(8,16)(9,15)(13,14),
	 (1,15,12,13,11,14,10,9,5,6,3,8,4,16,7,2),
	 (1,10,4,12,5,7,11,3)(2,14,8,15,9,16,13,6),
	 (1,11,5,4)(2,13,9,8)(3,7,12,10)(6,16,15,14),
	 (1,5)(2,9)(3,12)(4,11)(6,15)(7,10)(8,13)(14,16)],"qd32",
       [ [ [(2,6)(3,10)(4,11)(7,12)(8,16)(9,15)(13,14)],"c16","c2",
	   [(2,6)(3,10)(4,11)(7,12)(8,16)(9,15)(13,14),(),(),(),()],
	   [(2,6)(3,10)(4,11)(7,12)(8,16)(9,15)(13,14),(),(),(),()] ] ] ],
[32,51,[(1,2,6,10)(3,11,15,27)(4,16,18,31)(5,19,17,9)
	 (7,20,22,13)(8,23,24,12)(14,30,29,26)(21,28,25,32),
	 (1,3,12,28,5,14,18,20,6,15,23,32,17,29,4,13)
	 (2,7,16,26,9,21,24,27,10,22,31,30,19,25,8,11),
	 (1,4,17,23,6,18,5,12)(2,8,19,31,10,24,9,16)
	 (3,13,29,32,15,20,14,28)(7,11,25,30,22,27,21,26),
	 (1,5,6,17)(2,9,10,19)(3,14,15,29)(4,12,18,23)
	 (7,21,22,25)(8,16,24,31)(11,26,27,30)(13,28,20,32),
	 (1,6)(2,10)(3,15)(4,18)(5,17)(7,22)(8,24)(9,19)(11,27)
	 (12,23)(13,20)(14,29)(16,31)(21,25)(26,30)(28,32)],"q32",[ ] ],
[33,1,[(1,2,4)(3,5,7)(6,8,10)(9,11,13)(12,14,16)
	 (15,17,19)(18,20,22)(21,23,25)(24,26,28)(27,29,31)
	 (30,32,33),(1,3,6,9,12,15,18,21,24,27,30)
	 (2,5,8,11,14,17,20,23,26,29,32)
	 (4,7,10,13,16,19,22,25,28,31,33)],"c33",
       [ [ [  ],"c33","triv",
	   [(),()],
	   [(),()] ],
	 [ [(1,3,6,9,12,15,18,21,24,27,30)(2,5,8,11,14,17,20,23,26,29,32)
	     (4,7,10,13,16,19,22,25,28,31,33)],"c3","c11",
	   [(),(1,3,6,9,12,15,18,21,24,27,30)(2,5,8,11,14,17,20,23,26,29,32)
	     (4,7,10,13,16,19,22,25,28,31,33)],
	   [(),(1,3,6,9,12,15,18,21,24,27,30)(2,5,8,11,14,17,20,23,26,29,32)
	     (4,7,10,13,16,19,22,25,28,31,33)] ],
	 [ [(1,2,4)(3,5,7)(6,8,10)(9,11,13)(12,14,16)(15,17,19)(18,20,22)
	     (21,23,25)(24,26,28)(27,29,31)(30,32,33)],"c11","c3",
	   [(1,2,4)(3,5,7)(6,8,10)(9,11,13)(12,14,16)(15,17,19)(18,20,22)
	     (21,23,25)(24,26,28)(27,29,31)(30,32,33),()],
	   [(1,2,4)(3,5,7)(6,8,10)(9,11,13)(12,14,16)(15,17,19)(18,20,22)
	     (21,23,25)(24,26,28)(27,29,31)(30,32,33),()] ] ] ],
[34,1,[(1,2)(3,4)(5,6)(7,8)(9,10)(11,12)(13,14)
	 (15,16)(17,18)(19,20)(21,22)(23,24)(25,26)(27,28)
	 (29,30)(31,32)(33,34),
	 (1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33)
	 (2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34)],"c34",
       [ [ [  ],"c34","triv",
	   [(),()],
	   [(),()] ],
	 [ [(1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33)(2,4,6,8,10,12,14,
	     16,18,20,22,24,26,28,30,32,34)],"c2","c17",
	   [(),(1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33)(2,4,6,8,10,12,
	     14,16,18,20,22,24,26,28,30,32,34)],
	   [(),(1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33)(2,4,6,8,10,12,
	     14,16,18,20,22,24,26,28,30,32,34)] ],
	 [ [(1,2)(3,4)(5,6)(7,8)(9,10)(11,12)(13,14)(15,16)(17,18)(19,20)
	     (21,22)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34)],"c17","c2",
	   [(1,2)(3,4)(5,6)(7,8)(9,10)(11,12)(13,14)(15,16)(17,18)(19,20)
	     (21,22)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34),()],
	   [(1,2)(3,4)(5,6)(7,8)(9,10)(11,12)(13,14)(15,16)(17,18)(19,20)
	     (21,22)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34),()] ] ] ],
[34,2,[(2,3)(4,5)(6,7)(8,9)(10,11)(12,13)(14,15)(16,17),
	 (1,3,5,7,9,11,13,15,17,16,14,12,10,8,6,4,2)],"d34",
       [ [ [(2,3)(4,5)(6,7)(8,9)(10,11)(12,13)(14,15)(16,17)],"c17","c2",
	   [(2,3)(4,5)(6,7)(8,9)(10,11)(12,13)(14,15)(16,17),()],
	   [(2,3)(4,5)(6,7)(8,9)(10,11)(12,13)(14,15)(16,17),()] ] ] ],
[35,1,[(1,2,4,7,11)(3,5,8,12,16)(6,9,13,17,21)
	 (10,14,18,22,26)(15,19,23,27,30)(20,24,28,31,33)
	 (25,29,32,34,35),(1,3,6,10,15,20,25)
	 (2,5,9,14,19,24,29)(4,8,13,18,23,28,32)
	 (7,12,17,22,27,31,34)(11,16,21,26,30,33,35)],"c35",
       [ [ [  ],"c35","triv",
	   [(),()],
	   [(),()] ],
	 [ [(1,3,6,10,15,20,25)(2,5,9,14,19,24,29)(4,8,13,18,23,28,32)
	     (7,12,17,22,27,31,34)(11,16,21,26,30,33,35)],"c5","c7",
	   [(),(1,3,6,10,15,20,25)(2,5,9,14,19,24,29)(4,8,13,18,23,28,32)
	     (7,12,17,22,27,31,34)(11,16,21,26,30,33,35)],
	   [(),(1,3,6,10,15,20,25)(2,5,9,14,19,24,29)(4,8,13,18,23,28,32)
	     (7,12,17,22,27,31,34)(11,16,21,26,30,33,35)] ],
	 [ [(1,2,4,7,11)(3,5,8,12,16)(6,9,13,17,21)(10,14,18,22,26)
	     (15,19,23,27,30)(20,24,28,31,33)(25,29,32,34,35)],"c7","c5",
	   [(1,2,4,7,11)(3,5,8,12,16)(6,9,13,17,21)(10,14,18,22,26)
	     (15,19,23,27,30)(20,24,28,31,33)(25,29,32,34,35),()],
	   [(1,2,4,7,11)(3,5,8,12,16)(6,9,13,17,21)(10,14,18,22,26)
	     (15,19,23,27,30)(20,24,28,31,33)(25,29,32,34,35),()] ] ] ],
[36,1,[(1,2,3,4,5,6),(7,8,9,10,11,12)],"c6^2",
       [ [ [  ],"c6^2","triv",
	   [(),()],
	   [(),()] ],
	 [ [(7,8,9,10,11,12)],"c6","c6",
	   [(),(7,8,9,10,11,12)],
	   [(),(7,8,9,10,11,12)] ],
	 [ [(7,8,9,10,11,12),(7,8,9,10,11,12)],"c6","c6",
	   [(7,8,9,10,11,12),(7,8,9,10,11,12)],
	   [(),(7,8,9,10,11,12)] ],
	 [ [(7,9,11)(8,10,12),(7,8,9,10,11,12)],"c6","c6",
	   [(7,9,11)(8,10,12),(7,8,9,10,11,12)],
	   [(),(7,8,9,10,11,12)] ],
	 [ [(7,10)(8,11)(9,12),(7,8,9,10,11,12)],"c6","c6",
	   [(7,10)(8,11)(9,12),(7,8,9,10,11,12)],
	   [(),(7,8,9,10,11,12)] ],
	 [ [(7,10)(8,11)(9,12)],"c6c3","c2",
	   [(),(7,10)(8,11)(9,12)],
	   [(),(7,10)(8,11)(9,12)] ],
	 [ [(7,10)(8,11)(9,12),(7,10)(8,11)(9,12)],"c6c3","c2",
	   [(7,10)(8,11)(9,12),(7,10)(8,11)(9,12)],
	   [(),(7,10)(8,11)(9,12)] ],
	 [ [(7,11,9)(8,12,10)],"c2c2c3","c3",
	   [(),(7,11,9)(8,12,10)],
	   [(),(7,11,9)(8,12,10)] ],
	 [ [(7,9,11)(8,10,12),(7,11,9)(8,12,10)],"c2c2c3","c3",
	   [(7,9,11)(8,10,12),(7,11,9)(8,12,10)],
	   [(),(7,11,9)(8,12,10)] ],
	 [ [(1,2,3,4,5,6),(7,10)(8,11)(9,12)],"c3","c2c2c3",
	   [(1,2,3,4,5,6),(7,10)(8,11)(9,12)],
	   [(1,2,3,4,5,6),(7,10)(8,11)(9,12)] ],
	 [ [(1,2,3,4,5,6),(1,3,5)(2,4,6)(7,10)(8,11)(9,12)],"c3","c2c2c3",
	   [(1,2,3,4,5,6),(1,3,5)(2,4,6)(7,10)(8,11)(9,12)],
	   [(1,2,3,4,5,6),(7,10)(8,11)(9,12)] ],
	 [ [(1,2,3,4,5,6),(7,11,9)(8,12,10)],"c2","c6c3",
	   [(1,2,3,4,5,6),(7,11,9)(8,12,10)],
	   [(1,2,3,4,5,6),(7,11,9)(8,12,10)] ],
	 [ [(1,2,3,4,5,6),(1,4)(2,5)(3,6)(7,11,9)(8,12,10)],"c2","c6c3",
	   [(1,2,3,4,5,6),(1,4)(2,5)(3,6)(7,11,9)(8,12,10)],
	   [(1,2,3,4,5,6),(7,11,9)(8,12,10)] ],
	 [ [(1,4)(2,5)(3,6),(7,10)(8,11)(9,12)],"c3^2","k4",
	   [(1,4)(2,5)(3,6),(7,10)(8,11)(9,12)],
	   [(1,4)(2,5)(3,6),(7,10)(8,11)(9,12)] ],
	 [ [(1,5,3)(2,6,4),(7,11,9)(8,12,10)],"k4","c3^2",
	   [(1,5,3)(2,6,4),(7,11,9)(8,12,10)],
	   [(1,5,3)(2,6,4),(7,11,9)(8,12,10)] ] ] ],
[36,2,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18),(19,20)],"c18c2",
       [ [ [  ],"c18c2","triv",
	   [(),()],
	   [(),()] ],
	 [ [(19,20)],"c9c2","c2",
	   [(),(19,20)],
	   [(),(19,20)] ],
	 [ [(19,20),(19,20)],"c9c2","c2",
	   [(19,20),(19,20)],
	   [(),(19,20)] ],
	 [ [(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18)],"c2","c9c2",
	   [(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18),()],
	   [(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18),()] ],
	 [ [(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18),
	    (1,10)(2,11)(3,12)(4,13)(5,14)(6,15)(7,16)(8,17)(9,18)],"c2","c9c2",
	   [(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18),
	     (1,10)(2,11)(3,12)(4,13)(5,14)(6,15)(7,16)(8,17)(9,18)],
	   [(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18),()] ],
	 [ [(1,10)(2,11)(3,12)(4,13)(5,14)(6,15)(7,16)(8,17)(9,18),(19,20)],
	    "c9","k4",
	   [(1,10)(2,11)(3,12)(4,13)(5,14)(6,15)(7,16)(8,17)(9,18),(19,20)],
	   [(1,10)(2,11)(3,12)(4,13)(5,14)(6,15)(7,16)(8,17)(9,18),(19,20)] ],
	 [ [(1,11,3,13,5,15,7,17,9)(2,12,4,14,6,16,8,18,10)],"k4","c9",
	   [(1,11,3,13,5,15,7,17,9)(2,12,4,14,6,16,8,18,10),()],
	   [(1,11,3,13,5,15,7,17,9)(2,12,4,14,6,16,8,18,10),()] ] ] ],
[36,3,[(1,2,3,4),(5,6,7),(8,9,10)],"c12c3",
       [ [ [  ],"c12c3","triv",
	   [(),(),()],
	   [(),(),()] ],
	 [ [(8,9,10)],"c4c3","c3",
	   [(),(),(8,9,10)],
	   [(),(),(8,9,10)] ],
	 [ [(8,9,10),(8,9,10)],"c4c3","c3",
	   [(),(8,9,10),(8,9,10)],
	   [(),(),(8,9,10)] ],
	 [ [(5,6,7),(8,9,10)],"c4","c3^2",
	   [(),(5,6,7),(8,9,10)],
	   [(),(5,6,7),(8,9,10)] ],
	 [ [(1,2,3,4)],"c3^2","c4",
	   [(1,2,3,4),(),()],
	   [(1,2,3,4),(),()] ],
	 [ [(1,2,3,4),(8,9,10)],"c3","c4c3",
	   [(1,2,3,4),(),(8,9,10)],
	   [(1,2,3,4),(),(8,9,10)] ],
	 [ [(1,2,3,4),(8,9,10),(8,9,10)],"c3","c4c3",
	   [(1,2,3,4),(8,9,10),(8,9,10)],
	   [(1,2,3,4),(),(8,9,10)] ] ] ],
[36,4,[(1,2,3,4),(5,6,7,8,9,10,11,12,13)],"c36",
       [ [ [  ],"c36","triv",
	   [(),()],
	   [(),()] ],
	 [ [(5,6,7,8,9,10,11,12,13)],"c4","c9",
	   [(),(5,6,7,8,9,10,11,12,13)],
	   [(),(5,6,7,8,9,10,11,12,13)] ],
	 [ [(1,2,3,4)],"c9","c4",
	   [(1,2,3,4),()],
	   [(1,2,3,4),()] ] ] ],
[36,5,[(1,2),(2,3),(6,7,8,9,10,11)],"c6s3",
       [ [ [(2,3)(6,9)(7,10)(8,11),(2,3)(6,9)(7,10)(8,11),
	     (6,10,8)(7,11,9)],"c6","c6",
	   [(2,3)(6,9)(7,10)(8,11),(2,3)(6,9)(7,10)(8,11),
	     (6,10,8)(7,11,9)],
	   [(2,3)(6,9)(7,10)(8,11),(2,3)(6,9)(7,10)(8,11),
	     (6,10,8)(7,11,9)] ],
	 [ [(2,3)(6,9)(7,10)(8,11),(2,3)(6,9)(7,10)(8,11)],"c6c3","c2",
	   [(2,3)(6,9)(7,10)(8,11),(2,3)(6,9)(7,10)(8,11),()],
	   [(2,3)(6,9)(7,10)(8,11),(2,3)(6,9)(7,10)(8,11),()] ],
	 [ [(2,3),(2,3),(6,7,8,9,10,11)],"c3","c2c2c3",
	   [(2,3),(2,3),(6,7,8,9,10,11)],
	   [(2,3),(2,3),(6,7,8,9,10,11)] ],
	 [ [(2,3),(2,3),(6,9)(7,10)(8,11)],"c3^2","k4",
	   [(2,3),(2,3),(6,9)(7,10)(8,11)],
	   [(2,3),(2,3),(6,9)(7,10)(8,11)] ],
	 [ [(1,2),(2,3)],"c6","d6",
	   [(1,2),(2,3),()],
	   [(1,2),(2,3),()] ],
	 [ [(1,2),(2,3),(6,9)(7,10)(8,11)],"c3","d12",
	   [(1,2),(2,3),(6,9)(7,10)(8,11)],
	   [(1,2),(2,3),(6,9)(7,10)(8,11)] ],
	 [ [(1,2),(2,3),(6,10,8)(7,11,9)],"c2","s3c3",
	   [(1,2),(2,3),(6,10,8)(7,11,9)],
	   [(1,2),(2,3),(6,10,8)(7,11,9)] ] ] ],
[36,6,[(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7),(8,9,10)],"c3c6.c3",
       [ [ [(1,2)(3,4),(1,3,2,4)(6,7)],"c3^2","c4",
	   [(1,2)(3,4),(1,3,2,4)(6,7),()],
	   [(1,2)(3,4),(1,3,2,4)(6,7),()] ],
	 [ [(1,2)(3,4),(1,3,2,4)(6,7),(8,9,10)],"c3","c4c3",
	   [(1,2)(3,4),(1,3,2,4)(6,7),(8,9,10)],
	   [(1,2)(3,4),(1,3,2,4)(6,7),(8,9,10)] ],
	 [ [(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7)],"c3","6.2",
	   [(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7),()],
	   [(1,2)(3,4)(5,6,7),(1,3,2,4)(6,7),()] ] ] ],
[36,7,[(1,2,3),(2,3,4),(5,6,7)],"a4c3",
       [ [ [(2,4,3)(5,7,6),(2,3,4)(5,6,7)],"c2c2c3","c3",
	   [(2,4,3)(5,7,6),(2,3,4)(5,6,7),()],
	   [(2,4,3)(5,7,6),(2,3,4)(5,6,7),()] ],
	 [ [(2,4,3),(2,3,4),(5,6,7)],"k4","c3^2",
	   [(2,4,3),(2,3,4),(5,6,7)],
	   [(2,4,3),(2,3,4),(5,6,7)] ],
	 [ [(1,2,3),(2,3,4)],"c3","a4",
	   [(1,2,3),(2,3,4),()],
	   [(1,2,3),(2,3,4),()] ] ] ],
[36,8,[(1,16,13,9,11,7,4,5,2)(3,18,17,14,15,12,8,10,6),
	(2,6)(5,10)(7,12)(11,15)(13,17)(16,18),
	(1,3)(4,8)(5,10)(9,14)(11,15)(16,18),
	(1,9,4)(2,13,7)(3,14,8)(5,16,11)(6,17,12)(10,18,15)],"(2^2x3).3",
       [ [ [(1,16,13,9,11,7,4,5,2)(3,18,17,14,15,12,8,10,6),
	     (1,9,4)(2,13,7)(3,14,8)(5,16,11)(6,17,12)(10,18,15)],"k4","c9",
	   [(1,16,13,9,11,7,4,5,2)(3,18,17,14,15,12,8,10,6),(),(),
	    (1,9,4)(2,13,7)(3,14,8)(5,16,11)(6,17,12)(10,18,15)],
	   [(1,16,13,9,11,7,4,5,2)(3,18,17,14,15,12,8,10,6),(),(),
	     (1,9,4)(2,13,7)(3,14,8)(5,16,11)(6,17,12)(10,18,15)] ] ] ],
[36,9,[(1,2,3),(4,5,6),(2,3)(5,6),(7,8)],"c2c3^2|Xc2",
       [ [ [(2,3)(5,6)(7,8)],"c6c3","c2",
	   [(),(),(2,3)(5,6)(7,8),()],
	   [(),(),(2,3)(5,6)(7,8),()] ],
	 [ [(2,3)(5,6),(7,8)],"c3^2","k4",
	   [(),(),(2,3)(5,6),(7,8)],
	   [(),(),(2,3)(5,6),(7,8)] ],
	 [ [(4,5,6),(2,3)(5,6)],"c6","d6",
	   [(),(4,5,6),(2,3)(5,6),()],
	   [(),(4,5,6),(2,3)(5,6),()] ],
	 [ [(4,5,6),(4,5,6),(2,3)(5,6)],"c6","d6",
	   [(4,5,6),(4,5,6),(2,3)(5,6),()],
	   [(),(4,5,6),(2,3)(5,6),()] ],
	 [ [(4,5,6),(2,3)(5,6),(7,8)],"c3","d12",
	   [(),(4,5,6),(2,3)(5,6),(7,8)],
	   [(),(4,5,6),(2,3)(5,6),(7,8)] ],
	 [ [(4,5,6),(4,5,6),(2,3)(5,6),(7,8)],"c3","d12",
	   [(4,5,6),(4,5,6),(2,3)(5,6),(7,8)],
	   [(),(4,5,6),(2,3)(5,6),(7,8)] ],
	 [ [(1,2,3),(4,5,6),(2,3)(5,6)],"c2","c3^2:c2",
	   [(1,2,3),(4,5,6),(2,3)(5,6),()],
	   [(1,2,3),(4,5,6),(2,3)(5,6),()] ] ] ],
[36,10,[(1,2,5,8)(3,9,12,22)(4,13,15,28)
	(6,16,18,10)(7,19,20,14)(11,24,26,35)
	(17,30,31,34)(21,32,33,25)(23,27,29,36),
	(1,3,10)(2,6,9)(4,11,23)(5,12,16)(7,17,21)
	(8,18,22)(13,27,24)(14,25,34)(15,26,29)(19,32,30)
	(20,31,33)(28,36,35),(1,4,14)(2,7,13)(3,11,25)
	(5,15,19)(6,17,27)(8,20,28)(9,21,24)
	(10,23,34)(12,26,32)(16,29,30)(18,31,36)(22,33,35),
	(1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)
	(10,16)(11,26)(13,28)(14,19)(17,31)(21,33)(23,29)
	(24,35)(25,32)(27,36)(30,34)],"(3^2x2).2",
       [ [ [(1,2,5,8)(3,9,12,22)(4,13,15,28)(6,16,18,10)(7,19,20,14)
	     (11,24,26,35)(17,30,31,34)(21,32,33,25)(23,27,29,36),
	     (1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)(10,16)(11,26)(13,28)
	     (14,19)(17,31)(21,33)(23,29)(24,35)(25,32)(27,36)(30,34)],
	       "c3^2","c4",
	   [(1,2,5,8)(3,9,12,22)(4,13,15,28)(6,16,18,10)(7,19,20,14)
	     (11,24,26,35)(17,30,31,34)(21,32,33,25)(23,27,29,36),(),(),
	     (1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)(10,16)(11,26)(13,28)
	     (14,19)(17,31)(21,33)(23,29)(24,35)(25,32)(27,36)(30,34)],
	   [(1,2,5,8)(3,9,12,22)(4,13,15,28)(6,16,18,10)(7,19,20,14)
	     (11,24,26,35)(17,30,31,34)(21,32,33,25)(23,27,29,36),(),(),
	     (1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)(10,16)(11,26)(13,28)
	     (14,19)(17,31)(21,33)(23,29)(24,35)(25,32)(27,36)(30,34)] ],
	 [ [(1,2,5,8)(3,9,12,22)(4,13,15,28)(6,16,18,10)(7,19,20,14)
	     (11,24,26,35)(17,30,31,34)(21,32,33,25)(23,27,29,36),
	     (1,4,14)(2,7,13)(3,11,25)(5,15,19)(6,17,27)(8,20,28)(9,21,24)
	     (10,23,34)(12,26,32)(16,29,30)(18,31,36)(22,33,35),
	     (1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)(10,16)(11,26)(13,28)
	     (14,19)(17,31)(21,33)(23,29)(24,35)(25,32)(27,36)(30,34)],
	        "c3","c6.c2",
	   [(1,2,5,8)(3,9,12,22)(4,13,15,28)(6,16,18,10)(7,19,20,14)
	     (11,24,26,35)(17,30,31,34)(21,32,33,25)(23,27,29,36),(),
	     (1,4,14)(2,7,13)(3,11,25)(5,15,19)(6,17,27)(8,20,28)(9,21,24)
	     (10,23,34)(12,26,32)(16,29,30)(18,31,36)(22,33,35),
	     (1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)(10,16)(11,26)(13,28)     
	     (14,19)(17,31)(21,33)(23,29)(24,35)(25,32)(27,36)(30,34)],
	   [(1,2,5,8)(3,9,12,22)(4,13,15,28)(6,16,18,10)(7,19,20,14)
	     (11,24,26,35)(17,30,31,34)(21,32,33,25)(23,27,29,36),(),
	     (1,4,14)(2,7,13)(3,11,25)(5,15,19)(6,17,27)(8,20,28)(9,21,24)
	     (10,23,34)(12,26,32)(16,29,30)(18,31,36)(22,33,35),
	     (1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)(10,16)(11,26)(13,28)
	     (14,19)(17,31)(21,33)(23,29)(24,35)(25,32)(27,36)(30,34)] ],
	 [ [(1,2,5,8)(3,9,12,22)(4,13,15,28)(6,16,18,10)(7,19,20,14)
	     (11,24,26,35)(17,30,31,34)(21,32,33,25)(23,27,29,36),
	     (1,4,14)(2,7,13)(3,11,25)(5,15,19)(6,17,27)(8,20,28)(9,21,24)
	     (10,23,34)(12,26,32)(16,29,30)(18,31,36)(22,33,35),
	     (1,4,14)(2,7,13)(3,11,25)(5,15,19)(6,17,27)(8,20,28)(9,21,24)
	     (10,23,34)(12,26,32)(16,29,30)(18,31,36)(22,33,35),
	     (1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)(10,16)(11,26)(13,28)
	     (14,19)(17,31)(21,33)(23,29)(24,35)(25,32)(27,36)(30,34)],
	       "c3","c6.c2",
	   [(1,2,5,8)(3,9,12,22)(4,13,15,28)(6,16,18,10)(7,19,20,14)
	     (11,24,26,35)(17,30,31,34)(21,32,33,25)(23,27,29,36),
	     (1,4,14)(2,7,13)(3,11,25)(5,15,19)(6,17,27)(8,20,28)(9,21,24)
	     (10,23,34)(12,26,32)(16,29,30)(18,31,36)(22,33,35),
	     (1,4,14)(2,7,13)(3,11,25)(5,15,19)(6,17,27)(8,20,28)(9,21,24)
	     (10,23,34)(12,26,32)(16,29,30)(18,31,36)(22,33,35),
	     (1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)(10,16)(11,26)(13,28)
	     (14,19)(17,31)(21,33)(23,29)(24,35)(25,32)(27,36)(30,34)],
	   [(1,2,5,8)(3,9,12,22)(4,13,15,28)(6,16,18,10)(7,19,20,14)
	     (11,24,26,35)(17,30,31,34)(21,32,33,25)(23,27,29,36),(),
	     (1,4,14)(2,7,13)(3,11,25)(5,15,19)(6,17,27)(8,20,28)(9,21,24)
	     (10,23,34)(12,26,32)(16,29,30)(18,31,36)(22,33,35),
	     (1,5)(2,8)(3,12)(4,15)(6,18)(7,20)(9,22)(10,16)(11,26)(13,28)
	     (14,19)(17,31)(21,33)(23,29)(24,35)(25,32)(27,36)(30,34)] ] ] ],
[36,11,[(1,2,3,4,5,6,7,8,9),(1,9)(2,8)(3,7)(4,6),(10,11)],"d36",
       [ [ [(2,9)(3,8)(4,7)(5,6)(10,11)],"c9c2","c2",
	   [(),(2,9)(3,8)(4,7)(5,6)(10,11),()],
	   [(),(2,9)(3,8)(4,7)(5,6)(10,11),()] ],
	 [ [(2,9)(3,8)(4,7)(5,6),(10,11)],"c9","k4",
	   [(),(2,9)(3,8)(4,7)(5,6),(10,11)],
	   [(),(2,9)(3,8)(4,7)(5,6),(10,11)] ],
	 [ [(1,2,3,4,5,6,7,8,9),(1,9)(2,8)(3,7)(4,6)],"c2","d18",
	   [(1,2,3,4,5,6,7,8,9),(1,9)(2,8)(3,7)(4,6),()],
	   [(1,2,3,4,5,6,7,8,9),(1,9)(2,8)(3,7)(4,6),()] ] ] ],
[36,12,[(1,2)(3,4)(5,6,7,8,9,10,11,12,13),(1,3,2,4)(6,13)
	(7,12)(8,11)(9,10)],"18.2",
       [ [ [(1,2)(3,4),(1,3,2,4)(6,13)(7,12)(8,11)(9,10)],"c9","c4",
	   [(1,2)(3,4),(1,3,2,4)(6,13)(7,12)(8,11)(9,10)],
	   [(1,2)(3,4),(1,3,2,4)(6,13)(7,12)(8,11)(9,10)] ] ] ],
[36,13,[(1,2,3),(2,3),(4,5,6),(5,6)],"s3^2",
       [ [ [(1,2,3)(4,5,6),(2,3)(5,6)],"s3","s3",
	   [(1,2,3)(4,5,6),(2,3)(5,6),(),()],
	   [(),(),(1,2,3)(4,5,6),(2,3)(5,6)] ],
	 [ [(2,3),(5,6)],"c3^2","k4",
	   [(),(2,3),(),(5,6)],
	   [(),(2,3),(),(5,6)] ],
	 [ [(2,3),(4,5,6),(5,6)],"c3","d12",
	   [(),(2,3),(4,5,6),(5,6)],
	   [(),(2,3),(4,5,6),(5,6)] ] ] ],
[36,14,[(1,2)(3,6,4,5),(3,4)(5,6),(1,4,3)(2,6,5),(1,3,4)(2,6,5)],"3^2:4",
       [ [ [(1,2)(3,6,4,5),(3,4)(5,6)],"c3^2","c4",
	   [(1,2)(3,6,4,5),(3,4)(5,6),(),()],
	   [(1,2)(3,6,4,5),(3,4)(5,6),(),()] ] ] ],
[37,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
	 22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37)],"c37",
       [ [ [  ],"c37","triv",[()],[()] ] ] ],
[38,1,[(1,2)(3,4)(5,6)(7,8)(9,10)(11,12)(13,14)
	 (15,16)(17,18)(19,20)(21,22)(23,24)(25,26)(27,28)
	 (29,30)(31,32)(33,34)(35,36)(37,38),
	 (1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37)
	 (2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38)],"c38",
       [ [ [  ],"c38","triv",[(),()],[(),()] ],
	 [ [(1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37)(2,4,6,8,10,
	       12,14,16,18,20,22,24,26,28,30,32,34,36,38)],"c2","c19",
	   [(),(1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37)
	     (2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38)],
	   [(),(1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37)
	     (2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38)] ],
	 [ [(1,2)(3,4)(5,6)(7,8)(9,10)(11,12)(13,14)(15,16)(17,18)(19,20)
	     (21,22)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34)(35,36)(37,38)],
	       "c19","c2",
	   [(1,2)(3,4)(5,6)(7,8)(9,10)(11,12)(13,14)(15,16)(17,18)(19,20)
	    (21,22)(23,24)(25,26)(27,28)(29,30)(31,32)(33,34)(35,36)(37,38),()],
	   [(1,2)(3,4)(5,6)(7,8)(9,10)(11,12)(13,14)(15,16)(17,18)
	    (19,20)(21,22)(23,24)(25,26)(27,28)(29,30)(31,32)
	    (33,34)(35,36)(37,38),()] ] ] ],
[38,2,[(2,3)(4,5)(6,7)(8,9)(10,11)(12,13)(14,15)(16,17)(18,19),
	 (1,3,5,7,9,11,13,15,17,19,18,16,14,12,10,8,6,4,2)],"d38",
       [ [ [(2,3)(4,5)(6,7)(8,9)(10,11)(12,13)(14,15)(16,17)(18,19)],"c19","c2",
	   [(2,3)(4,5)(6,7)(8,9)(10,11)(12,13)(14,15)(16,17)(18,19),()],
	   [(2,3)(4,5)(6,7)(8,9)(10,11)(12,13)(14,15)(16,17)(18,19),()] ] ] ],
[39,1,[(1,2,4)(3,5,7)(6,8,10)(9,11,13)(12,14,16)
	 (15,17,19)(18,20,22)(21,23,25)(24,26,28)
	 (27,29,31)(30,32,34)(33,35,37)(36,38,39),
	 (1,3,6,9,12,15,18,21,24,27,30,33,36)
	 (2,5,8,11,14,17,20,23,26,29,32,35,38)
	 (4,7,10,13,16,19,22,25,28,31,34,37,39)],"c39",
       [ [ [  ],"c39","triv",[(),()],[(),()] ],
	 [ [(1,3,6,9,12,15,18,21,24,27,30,33,36)(2,5,8,11,14,17,20,23,26,29,32,
	     35,38)(4,7,10,13,16,19,22,25,28,31,34,37,39)],"c3","c13",
	   [(),(1,3,6,9,12,15,18,21,24,27,30,33,36)(2,5,8,11,14,17,20,23,26,29,
	     32,35,38)(4,7,10,13,16,19,22,25,28,31,34,37,39)],
	   [(),(1,3,6,9,12,15,18,21,24,27,30,33,36)(2,5,8,11,14,17,20,23,26,29,
	     32,35,38)(4,7,10,13,16,19,22,25,28,31,34,37,39)] ],
	 [ [(1,2,4)(3,5,7)(6,8,10)(9,11,13)(12,14,16)(15,17,19)(18,20,22)
	     (21,23,25)(24,26,28)(27,29,31)(30,32,34)(33,35,37)(36,38,39)],
	      "c13","c3",
	   [(1,2,4)(3,5,7)(6,8,10)(9,11,13)(12,14,16)(15,17,19)(18,20,22)
	     (21,23,25)(24,26,28)(27,29,31)(30,32,34)(33,35,37)(36,38,39),()],
	   [(1,2,4)(3,5,7)(6,8,10)(9,11,13)(12,14,16)(15,17,19)
	    (18,20,22)(21,23,25)(24,26,28)(27,29,31)(30,32,34)
	    (33,35,37)(36,38,39),()] ] ] ],
[39,2,[(2,5,3)(4,11,7)(6,8,9)(10,13,12),
	 (1,9,10,6,3,12,13,11,7,8,5,4,2)],"d39",
       [ [ [(2,5,3)(4,11,7)(6,8,9)(10,13,12)],"c13","c3",
	   [(2,5,3)(4,11,7)(6,8,9)(10,13,12),()],
	   [(2,5,3)(4,11,7)(6,8,9)(10,13,12),()] ] ] ],
[40,1,[(1,2,3,4,5)(6,7),(8,9),(10,11)],"c2^3c5",
       [ [ [  ],"c2^3c5","triv",[(),(),()],[(),(),()] ],
	 [ [(10,11)],"c2c2c5","c2",[(),(),(10,11)],[(),(),(10,11)] ],
	 [ [(10,11)],"c2c2c5","c2",
	   [(),(10,11),(10,11)],
	   [(),(),(10,11)] ],
	 [ [(8,9),(10,11)],"c10","k4",
	   [(),(8,9),(10,11)],
	   [(),(8,9),(10,11)] ],
	 [ [(8,9),(10,11)],"c10","k4",
	   [(10,11),(8,9),(10,11)],
	   [(),(8,9),(10,11)] ],
	 [ [(6,7),(8,9),(10,11)],"c5","c2^3",
	   [(6,7),(8,9),(10,11)],
	   [(6,7),(8,9),(10,11)] ],
	 [ [(1,2,3,4,5)],"c2^3","c5",
	   [(1,2,3,4,5),(),()],
	   [(1,2,3,4,5),(),()] ],
	 [ [(1,2,3,4,5),(10,11)],"k4","c10",
	   [(1,2,3,4,5),(),(10,11)],
	   [(1,2,3,4,5),(),(10,11)] ],
	 [ [(1,2,3,4,5),(10,11)],"k4","c10",
	   [(1,2,3,4,5),(10,11),(10,11)],
	   [(1,2,3,4,5),(),(10,11)] ],
	 [ [(1,2,3,4,5),(8,9),(10,11)],"c2","c2c2c5",
	   [(1,2,3,4,5),(8,9),(10,11)],
	   [(1,2,3,4,5),(8,9),(10,11)] ],
	 [ [(1,2,3,4,5),(8,9),(10,11)],"c2","c2c2c5",
	   [(1,2,3,4,5)(10,11),(8,9),(10,11)],
	   [(1,2,3,4,5),(8,9),(10,11)] ] ] ],
[40,2,[(1,2),(3,4,5,6),(7,8,9,10,11)],"c2c20",
       [ [ [  ],"c2c20","triv",[(),(),()],[(),(),()] ],
	 [ [(7,8,9,10,11)],"c2c4","c5",
	   [(),(),(7,8,9,10,11)],[(),(),(7,8,9,10,11)] ],
	 [ [(3,4,5,6)],"c10","c4",
	   [(),(3,4,5,6),()],[(),(3,4,5,6),()] ],
	 [ [(3,4,5,6)],"c10","c4",
	   [(3,5)(4,6),(3,4,5,6),()],[(),(3,4,5,6),()] ],
	 [ [(3,4,5,6),(7,8,9,10,11)],"c2","c20",
	   [(),(3,4,5,6),(7,8,9,10,11)],[(),(3,4,5,6),(7,8,9,10,11)] ],
	 [ [(3,4,5,6),(7,8,9,10,11)],"c2","c20",
	   [(3,5)(4,6),(3,4,5,6),(7,8,9,10,11)],
	   [(),(3,4,5,6),(7,8,9,10,11)] ],
	 [ [(1,2)],"C20","c2",
	   [(1,2),(),()],[(1,2),(),()] ],
	 [ [(1,2)],"c20","c2",
	   [(1,2),(1,2),()],[(1,2),(),()] ],
	 [ [(1,2),(7,8,9,10,11)],"c4","c10",
	   [(1,2),(),(7,8,9,10,11)],[(1,2),(),(7,8,9,10,11)] ],
	 [ [(1,2),(7,8,9,10,11)],"c4","c10",
	   [(1,2),(1,2),(7,8,9,10,11)],[(1,2),(),(7,8,9,10,11)] ],
	 [ [(1,2),(3,4,5,6)],"c5","c2c4",
	   [(1,2),(3,4,5,6),()],[(1,2),(3,4,5,6),()] ] ] ],
[40,3,[(1,2,3,4,5),(6,7,8,9,10,11,12,13)],"c40",
       [ [ [  ],"c40","triv",[(),()],[(),()] ],
	 [ [(6,7,8,9,10,11,12,13)],"c5","c8",
	   [(),(6,7,8,9,10,11,12,13)],[(),(6,7,8,9,10,11,12,13)] ],
	 [ [(1,2,3,4,5)],"c8","c5",
	   [(1,2,3,4,5),()],[(1,2,3,4,5),()] ] ] ],
[40,4,[(1,2,3,4),(1,3),(5,6,7,8,9)],"d8c5",
       [ [ [(2,4)],"c20","c2",[(),(2,4),()],[(),(2,4),()] ],
	 [ [(2,4),(2,4)],"c2c10","c2",
	   [(2,4),(2,4),()],[(2,4),(2,4),()] ],
	 [ [(2,4),(5,6,7,8,9)],"c4","c10",
	   [(),(2,4),(5,6,7,8,9)],[(),(2,4),(5,6,7,8,9)] ],
	 [ [(2,4),(2,4),(5,6,7,8,9)],"k4","c10",
	   [(2,4),(2,4),(5,6,7,8,9)],[(2,4),(2,4),(5,6,7,8,9)] ],
	 [ [(1,2,3,4),(1,3)],"c5","d8",
	   [(1,2,3,4),(1,3),()],[(1,2,3,4),(1,3),()] ] ] ],
[40,5,[(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),(9,10,11,12,13)],"q8c5",
       [ [ [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5)],"c5","q8",
	 [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()],
	 [(1,5,2,6)(3,7,4,8),(1,7,2,8)(3,6,4,5),()] ] ] ],
[40,6,[(1,2,3,4,5)(6,7),(2,5)(3,4),(8,9)],"c2d20",
       [ [ [(2,5)(3,4)(8,9)],"c2c2c5","c2",
	   [(),(2,5)(3,4)(8,9),()],[(),(2,5)(3,4)(8,9),()] ],
	 [ [(2,5)(3,4),(8,9)],"c10","k4",
	   [(),(2,5)(3,4),(8,9)],[(),(2,5)(3,4),(8,9)] ],
	 [ [(2,5)(3,4),(8,9)],"c10","k4",
	   [(8,9),(2,5)(3,4),(8,9)],[(),(2,5)(3,4),(8,9)] ],
	 [ [(6,7),(2,5)(3,4),(8,9)],"c5","c2^3",
	   [(6,7),(2,5)(3,4),(8,9)],[(6,7),(2,5)(3,4),(8,9)] ],
	 [ [(1,2,3,4,5),(2,5)(3,4)],"k4","d10",
	   [(1,2,3,4,5),(2,5)(3,4),()],[(1,2,3,4,5),(2,5)(3,4),()] ],
	 [ [(1,2,3,4,5),(2,5)(3,4),(8,9)],"c2","d20",
	   [(1,2,3,4,5),(2,5)(3,4),(8,9)],[(1,2,3,4,5),(2,5)(3,4),(8,9)] ],
	 [ [(1,2,3,4,5),(2,5)(3,4),(8,9)],"c2","d20",
	   [(1,2,3,4,5)(8,9),(2,5)(3,4),(8,9)],
	   [(1,2,3,4,5),(2,5)(3,4),(8,9)] ] ] ],
[40,7,[(1,2,3,4,5),(2,5)(3,4),(6,7,8,9)],"c4d10",
       [ [ [(2,5)(3,4)],"c20","c2",
	   [(),(2,5)(3,4),()],[(),(2,5)(3,4),()] ],
	 [ [(2,5)(3,4),(6,7,8,9)],"c5","c2c4",
	   [(),(2,5)(3,4),(6,7,8,9)],[(),(2,5)(3,4),(6,7,8,9)] ],
	 [ [(1,2,3,4,5),(2,5)(3,4)],"c4","d10",
	   [(1,2,3,4,5),(2,5)(3,4),()],[(1,2,3,4,5),(2,5)(3,4),()] ] ] ],
[40,8,[(1,2,3,4,5,6,7,8,9,10)(11,20,19,18,17,16,15,14,13,12),
	(1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)
	(5,15,10,20),(21,22)],"c2q20",
       [ [ [(1,2,3,4,5,6,7,8,9,10)(11,20,19,18,17,16,15,14,13,12),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20)],
	     "c2","10.2",
	   [(1,2,3,4,5,6,7,8,9,10)(11,20,19,18,17,16,15,14,13,12),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),()],
	   [(1,2,3,4,5,6,7,8,9,10)(11,20,19,18,17,16,15,14,13,12),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),()] ],
	 [ [(1,2,3,4,5,6,7,8,9,10)(11,20,19,18,17,16,15,14,13,12),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20)],
	      "c2","10.2",
	   [(1,2,3,4,5,6,7,8,9,10)(11,20,19,18,17,16,15,14,13,12),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),
	     (1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20)],
	   [(1,2,3,4,5,6,7,8,9,10)(11,20,19,18,17,16,15,14,13,12),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),()] ],
	 [ [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20)],
	      "c10","c4",
	   [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),()],
	   [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),()] ],
	 [ [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20)],
	      "c10","c4",
	   [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),
	     (1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20)],
	   [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),()] ],
	 [ [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),(21,22)],
	       "c5","c2c4",
	   [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)(15,20),
	     (1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)(5,15,10,20),(21,22)],
	   [(1,6)(2,7)(3,8)(4,9)(5,10)(11,16)(12,17)(13,18)(14,19)
	    (15,20),(1,11,6,16)(2,12,7,17)(3,13,8,18)(4,14,9,19)
	    (5,15,10,20),(21,22)] ] ] ],
[40,9,[(1,2,4,7,5,8,13,18)(3,9,11,19,12,20,25,32)(6,14,16,26,17,27,31,35)
	(10,21,23,33,24,34,37,40)(15,28,29,36,30,38,39,22),
	(1,3,10,22,35)(2,6,15,21,9)(4,11,23,28,14)(5,12,24,36,26)
	(7,16,29,33,19)(8,17,30,34,20)(13,25,37,38,27)(18,31,39,40,32),
	(1,4,5,13)(2,7,8,18)(3,11,12,25)(6,16,17,31)(9,19,20,32)
	(10,23,24,37)(14,26,27,35)(15,29,30,39)(21,33,34,40)(22,28,36,38),
	(1,5)(2,8)(3,12)(4,13)(6,17)(7,18)(9,20)(10,24)(11,25)(14,27)
	(15,30)(16,31)(19,32)(21,34)(22,36)(23,37)(26,35)(28,38)(29,39)
	(33,40)],"20.2",
       [ [ [(1,2,4,7,5,8,13,18)(3,9,11,19,12,20,25,32)(6,14,16,26,17,27,31,35)
	     (10,21,23,33,24,34,37,40)(15,28,29,36,30,38,39,22),
	     (1,4,5,13)(2,7,8,18)(3,11,12,25)(6,16,17,31)(9,19,20,32)
	     (10,23,24,37)(14,26,27,35)(15,29,30,39)(21,33,34,40)(22,28,36,38),
	     (1,5)(2,8)(3,12)(4,13)(6,17)(7,18)(9,20)(10,24)(11,25)(14,27)
	     (15,30)(16,31)(19,32)(21,34)(22,36)(23,37)(26,35)(28,38)
	     (29,39)(33,40)],"c5","c8",
	   [(1,2,4,7,5,8,13,18)(3,9,11,19,12,20,25,32)(6,14,16,26,17,27,31,35)
	     (10,21,23,33,24,34,37,40)(15,28,29,36,30,38,39,22),(),
	     (1,4,5,13)(2,7,8,18)(3,11,12,25)(6,16,17,31)(9,19,20,32)
	     (10,23,24,37)(14,26,27,35)(15,29,30,39)(21,33,34,40)(22,28,36,38),
	     (1,5)(2,8)(3,12)(4,13)(6,17)(7,18)(9,20)(10,24)(11,25)(14,27)
	     (15,30)(16,31)(19,32)(21,34)(22,36)(23,37)(26,35)(28,38)
	     (29,39)(33,40)],
	   [(1,2,4,7,5,8,13,18)(3,9,11,19,12,20,25,32)(6,14,16,26,17,27,31,35)
	     (10,21,23,33,24,34,37,40)(15,28,29,36,30,38,39,22),(),
	     (1,4,5,13)(2,7,8,18)(3,11,12,25)(6,16,17,31)(9,19,20,32)
	     (10,23,24,37)(14,26,27,35)(15,29,30,39)(21,33,34,40)(22,28,36,38),
	     (1,5)(2,8)(3,12)(4,13)(6,17)(7,18)(9,20)(10,24)(11,25)
	     (14,27)(15,30)(16,31)(19,32)(21,34)(22,36)(23,37)
	     (26,35)(28,38)(29,39)(33,40)] ] ] ],
[40,10,[(1,2,3,4,5),(2,4,5,3),(6,7)],"c2c5:c4",
       [ [ [(2,4,5,3)(6,7)],"c10","c4",
	   [(),(2,4,5,3)(6,7),()],[(),(2,4,5,3)(6,7),()] ],
	 [ [(2,4,5,3),(6,7)],"c5","c2c4",
	   [(),(2,4,5,3),(6,7)],[(),(2,4,5,3),(6,7)] ],
	 [ [(1,2,3,4,5),(2,4,5,3)],"c2","c5:c4",
	   [(1,2,3,4,5),(2,4,5,3),()],[(1,2,3,4,5),(2,4,5,3),()] ] ] ],
[40,11,[(1,2,3,6,5,8,10,16)(4,11,12,23,14,25,26,39)
	(7,17,18,33,19,34,35,29)(9,20,21,36,22,37,38,24)
	(13,27,28,15,30,31,40,32),(1,3,5,10)(2,6,8,16)
	(4,12,14,26)(7,18,19,35)(9,21,22,38)(11,23,25,39)
	(13,28,30,40)(15,31,32,27)(17,33,34,29)(20,36,37,24),
	(1,4,13,29,38)(2,7,11,24,27)(3,9,17,28,12)
	(5,14,30,33,21)(6,15,20,23,18)(8,19,25,36,31)
	(10,22,34,40,26)(16,32,37,39,35),(1,5)(2,8)(3,10)
	(4,14)(6,16)(7,19)(9,22)(11,25)(12,26)(13,30)
	(15,32)(17,34)(18,35)(20,37)(21,38)(23,39)(24,36)
	(27,31)(28,40)(29,33)],"10.4",
       [ [ [(1,2,3,6,5,8,10,16)(4,11,12,23,14,25,26,39)(7,17,18,33,19,34,35,29)
	     (9,20,21,36,22,37,38,24)(13,27,28,15,30,31,40,32),
	     (1,3,5,10)(2,6,8,16)(4,12,14,26)(7,18,19,35)(9,21,22,38)
	     (11,23,25,39)(13,28,30,40)(15,31,32,27)(17,33,34,29)(20,36,37,24),
	     (1,5)(2,8)(3,10)(4,14)(6,16)(7,19)(9,22)(11,25)(12,26)(13,30)
	     (15,32)(17,34)(18,35)(20,37)(21,38)(23,39)(24,36)(27,31)
	     (28,40)(29,33)],"c5","c8",
	   [(1,2,3,6,5,8,10,16)(4,11,12,23,14,25,26,39)(7,17,18,33,19,34,35,29)
	     (9,20,21,36,22,37,38,24)(13,27,28,15,30,31,40,32),
	     (1,3,5,10)(2,6,8,16)(4,12,14,26)(7,18,19,35)(9,21,22,38)
	     (11,23,25,39)(13,28,30,40)(15,31,32,27)(17,33,34,29)
	     (20,36,37,24),(),(1,5)(2,8)(3,10)(4,14)(6,16)(7,19)(9,22)
	     (11,25)(12,26)(13,30)(15,32)(17,34)(18,35)(20,37)
	     (21,38)(23,39)(24,36)(27,31)(28,40)(29,33)],
	   [(1,2,3,6,5,8,10,16)(4,11,12,23,14,25,26,39)(7,17,18,33,19,34,35,29)
	     (9,20,21,36,22,37,38,24)(13,27,28,15,30,31,40,32),
	     (1,3,5,10)(2,6,8,16)(4,12,14,26)(7,18,19,35)(9,21,22,38)
	     (11,23,25,39)(13,28,30,40)(15,31,32,27)(17,33,34,29)
	     (20,36,37,24),(),(1,5)(2,8)(3,10)(4,14)(6,16)(7,19)(9,22)
	     (11,25)(12,26)(13,30)(15,32)(17,34)(18,35)(20,37)
	     (21,38)(23,39)(24,36)(27,31)(28,40)(29,33)] ] ] ],
[40,12,[(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)(16,20)
	(17,19),(1,2)(3,6)(4,5)(7,13)(8,12)(9,10)(11,14)
	(15,19)(16,17)(18,20),(1,7,15,8,3)(2,13,19,12,6)
	(4,14,20,16,9)(5,11,18,17,10),(1,4)(2,5)(3,9)
	(6,10)(7,14)(8,16)(11,13)(12,17)(15,20)(18,19)],"[ ]",
       [ [ [(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)(16,20)(17,19)],
           "c2c2c5","c2",
	   [(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)(16,20)(17,19),(),(),()],
	   [(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)
	   (16,20)(17,19),(),(),()] ],
	 [ [(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)(16,20)(17,19),
	     (1,7,15,8,3)(2,13,19,12,6)(4,14,20,16,9)(5,11,18,17,10)],
	     "k4","d10",
	   [(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)(16,20)(17,19),(),
	     (1,7,15,8,3)(2,13,19,12,6)(4,14,20,16,9)(5,11,18,17,10),()],
	   [(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)(16,20)(17,19),(),
	     (1,7,15,8,3)(2,13,19,12,6)(4,14,20,16,9)(5,11,18,17,10),()] ],
	 [ [(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)(16,20)(17,19),
	     (1,2)(3,6)(4,5)(7,13)(8,12)(9,10)(11,14)(15,19)(16,17)(18,20),
	     (1,4)(2,5)(3,9)(6,10)(7,14)(8,16)(11,13)(12,17)(15,20)(18,19)],
	     "c5","d8",
	   [(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)(16,20)(17,19),
	     (1,2)(3,6)(4,5)(7,13)(8,12)(9,10)(11,14)(15,19)(16,17)(18,20),(),
	     (1,4)(2,5)(3,9)(6,10)(7,14)(8,16)(11,13)(12,17)(15,20)(18,19)],
	   [(2,5)(3,7)(6,11)(8,15)(9,14)(10,13)(12,18)(16,20)(17,19),
	     (1,2)(3,6)(4,5)(7,13)(8,12)(9,10)(11,14)(15,19)(16,17)
	     (18,20),(),(1,4)(2,5)(3,9)(6,10)(7,14)(8,16)(11,13)
	     (12,17)(15,20)(18,19)] ] ] ],
[40,13,[(1,2,3,4)(5,6,7,8,9),(2,4)(5,9)(6,8)],"d40",
       [ [ [(2,4)(6,9)(7,8)],"c4c5","c2",
	   [(),(2,4)(6,9)(7,8)],[(),(2,4)(6,9)(7,8)] ],
	 [ [(5,6,7,8,9),(2,4)(5,9)(6,8)],"c4","d10",
	   [(5,6,7,8,9),(2,4)(5,9)(6,8)],[(5,6,7,8,9),(2,4)(5,9)(6,8)] ],
	 [ [(1,2,3,4),(2,4)(6,9)(7,8)],"c5","d8",
	   [(1,2,3,4),(2,4)(6,9)(7,8)],[(1,2,3,4),(2,4)(6,9)(7,8)] ] ] ],
[40,14,[(1,2,5,8)(3,9,11,6)(4,12,14,24)(7,16,18,31)
	(10,20,22,23)(13,25,27,39)(15,28,19,30)
	(17,32,33,26)(21,35,37,38)(29,36,34,40),
	(1,3,5,11)(2,6,8,9)(4,10,14,22)(7,15,18,19)
	(12,23,24,20)(13,21,27,37)(16,30,31,28)(17,29,33,34)
	(25,38,39,35)(26,36,32,40),(1,4,13,26,31)(2,7,17,25,12)
	(3,10,21,36,28)(5,14,27,32,16)(6,15,29,38,23)
	(8,18,33,39,24)(9,19,34,35,20)(11,22,37,40,30),
	(1,5)(2,8)(3,11)(4,14)(6,9)(7,18)(10,22)(12,24)(13,27)
	(15,19)(16,31)(17,33)(20,23)(21,37)(25,39)(26,32)
	(28,30)(29,34)(35,38)(36,40)],"q8+d10",
       [ [ [(1,2,5,8)(3,9,11,6)(4,12,14,24)(7,16,18,31)(10,20,22,23)
	     (13,25,27,39)(15,28,19,30)(17,32,33,26)(21,35,37,38)(29,36,34,40),
	     (1,3,5,11)(2,6,8,9)(4,10,14,22)(7,15,18,19)(12,23,24,20)
	     (13,21,27,37)(16,30,31,28)(17,29,33,34)(25,38,39,35)(26,36,32,40),
	     (1,5)(2,8)(3,11)(4,14)(6,9)(7,18)(10,22)(12,24)(13,27)(15,19)
	     (16,31)(17,33)(20,23)(21,37)(25,39)(26,32)(28,30)(29,34)
	     (35,38)(36,40)],"c5","q8",
	   [(1,2,5,8)(3,9,11,6)(4,12,14,24)(7,16,18,31)(10,20,22,23)
	     (13,25,27,39)(15,28,19,30)(17,32,33,26)(21,35,37,38)(29,36,34,40),
	     (1,3,5,11)(2,6,8,9)(4,10,14,22)(7,15,18,19)(12,23,24,20)
	     (13,21,27,37)(16,30,31,28)(17,29,33,34)(25,38,39,35)
	     (26,36,32,40),(),(1,5)(2,8)(3,11)(4,14)(6,9)(7,18)(10,22)
	     (12,24)(13,27)(15,19)(16,31)(17,33)(20,23)(21,37)(25,39)
	     (26,32)(28,30)(29,34)(35,38)(36,40)],
	   [(1,2,5,8)(3,9,11,6)(4,12,14,24)(7,16,18,31)(10,20,22,23)
	     (13,25,27,39)(15,28,19,30)(17,32,33,26)(21,35,37,38)(29,36,34,40),
	     (1,3,5,11)(2,6,8,9)(4,10,14,22)(7,15,18,19)(12,23,24,20)
	     (13,21,27,37)(16,30,31,28)(17,29,33,34)(25,38,39,35)
	     (26,36,32,40),(),(1,5)(2,8)(3,11)(4,14)(6,9)(7,18)(10,22)
	     (12,24)(13,27)(15,19)(16,31)(17,33)(20,23)(21,37)(25,39)
	     (26,32)(28,30)(29,34)(35,38)(36,40)] ] ] ],
[41,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
	 19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
	 34,35,36,37,38,39,40,41)],"c41",
       [ [ [  ],"c41","triv",[()],[()] ] ] ],
[42,1,[(1,2),(3,4,5),(6,7,8,9,10,11,12)]," c42",
       [ [ [  ],"c42","triv",[(),(),()],[(),(),()] ],
	 [ [(6,7,8,9,10,11,12)],"c6","c7",
	   [(),(),(6,7,8,9,10,11,12)],[(),(),(6,7,8,9,10,11,12)] ],
	 [ [(3,4,5)],"c14","c3",[(),(3,4,5),()],[(),(3,4,5),()] ],
	 [ [(3,4,5),(6,7,8,9,10,11,12)],"c2","c21",
	   [(),(3,4,5),(6,7,8,9,10,11,12)],
	   [(),(3,4,5),(6,7,8,9,10,11,12)] ],
	 [ [(1,2)],"c21","c2",[(1,2),(),()],[(1,2),(),()] ],
	 [ [(1,2),(6,7,8,9,10,11,12)],"c3","c14",
	   [(1,2),(),(6,7,8,9,10,11,12)],
	   [(1,2),(),(6,7,8,9,10,11,12)] ],
	 [ [(1,2),(3,4,5)],"c7","c6",
	   [(1,2),(3,4,5),()],[(1,2),(3,4,5),()] ] ] ],
[42,2,[(1,2,3,4,5,6,7),(2,7)(3,6)(4,5),(8,9,10)],"d14c3",
       [ [ [(2,7)(3,6)(4,5)],"c21","c2",
	   [(),(2,7)(3,6)(4,5),()],[(),(2,7)(3,6)(4,5),()] ],
	 [ [(2,7)(3,6)(4,5),(8,9,10)],"c7","c6",
	   [(),(2,7)(3,6)(4,5),(8,9,10)],[(),(2,7)(3,6)(4,5),(8,9,10)] ],
	 [ [(1,2,3,4,5,6,7),(2,7)(3,6)(4,5)],"c3","d14",
	   [(1,2,3,4,5,6,7),(2,7)(3,6)(4,5),()],
	   [(1,2,3,4,5,6,7),(2,7)(3,6)(4,5),()] ] ] ],
[42,3,[(1,2)(3,4)(5,7)(6,8)(9,11)(10,12)(13,14),
	(3,6,5)(4,8,7)(9,10,13)(11,12,14),
	(1,13,9,5,10,6,3)(2,14,11,7,12,8,4)],"c7:c3c2",
       [ [ [(3,6,5)(4,8,7)(9,10,13)(11,12,14)],"c14","c3",
	   [(),(3,6,5)(4,8,7)(9,10,13)(11,12,14),()],
	   [(),(3,6,5)(4,8,7)(9,10,13)(11,12,14),()] ],
	 [ [(3,6,5)(4,8,7)(9,10,13)(11,12,14),
	     (1,13,9,5,10,6,3)(2,14,11,7,12,8,4)],"c2","c7:c3",
	   [(),(3,6,5)(4,8,7)(9,10,13)(11,12,14),
	     (1,13,9,5,10,6,3)(2,14,11,7,12,8,4)],
	   [(),(3,6,5)(4,8,7)(9,10,13)(11,12,14),
	     (1,13,9,5,10,6,3)(2,14,11,7,12,8,4)] ],
	 [ [(1,2)(3,4)(5,7)(6,8)(9,11)(10,12)(13,14),
	     (3,6,5)(4,8,7)(9,10,13)(11,12,14)],"c7","c6",
	   [(1,2)(3,4)(5,7)(6,8)(9,11)(10,12)(13,14),
	     (3,6,5)(4,8,7)(9,10,13)(11,12,14),()],
	   [(1,2)(3,4)(5,7)(6,8)(9,11)(10,12)(13,14),
	     (3,6,5)(4,8,7)(9,10,13)(11,12,14),()] ] ] ],
[42,4,[(1,2),(2,3),(4,5,6,7,8,9,10)],"s3c7",
       [ [ [(2,3),(2,3)],"c21","c2",
	   [(2,3),(2,3),()],[(2,3),(2,3),()] ],
	 [ [(2,3),(2,3),(4,5,6,7,8,9,10)],"c3","c14",
	   [(2,3),(2,3),(4,5,6,7,8,9,10)],
	   [(2,3),(2,3),(4,5,6,7,8,9,10)] ],
	 [ [(1,2),(2,3)],"c7","d6",
	   [(1,2),(2,3),()],[(1,2),(2,3),()] ] ] ],
[42,5,[(2,3)(4,6)(5,7),(2,5,4)(3,7,6),(1,3,7,4,6,5,2)],"c7:c6",
       [ [ [(2,3)(4,6)(5,7),(2,5,4)(3,7,6)],"c7","c6",
	   [(2,3)(4,6)(5,7),(2,5,4)(3,7,6),()],
	   [(2,3)(4,6)(5,7),(2,5,4)(3,7,6),()] ] ] ],
[42,6,[(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)(13,18)(14,17)
	(16,20)(19,21),(1,4,2)(3,8,5)(6,9,11)(7,14,10)
	(12,15,17)(13,19,16)(18,20,21),(1,6,12,18,13,7,3)
	(2,11,17,21,16,10,5)(4,9,15,20,19,14,8)],"d42",
       [ [ [(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)(13,18)(14,17)(16,20)(19,21)],
            "c21","c2",
	   [(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)(13,18)(14,17)(16,20)
	   (19,21),(),()],[(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)
	   (13,18)(14,17)(16,20)(19,21),(),()] ],
	 [ [(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)(13,18)(14,17)(16,20)(19,21),
	     (1,6,12,18,13,7,3)(2,11,17,21,16,10,5)(4,9,15,20,19,14,8)],
	     "c3","d14",
	   [(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)(13,18)(14,17)(16,20)(19,21),(),
	     (1,6,12,18,13,7,3)(2,11,17,21,16,10,5)(4,9,15,20,19,14,8)],
	   [(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)(13,18)(14,17)(16,20)(19,21),(),
	     (1,6,12,18,13,7,3)(2,11,17,21,16,10,5)(4,9,15,20,19,14,8)] ],
	 [ [(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)(13,18)(14,17)(16,20)(19,21),
	     (1,4,2)(3,8,5)(6,9,11)(7,14,10)(12,15,17)(13,19,16)(18,20,21)],
	      "c7","d6",
	   [(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)(13,18)(14,17)(16,20)(19,21),
	     (1,4,2)(3,8,5)(6,9,11)(7,14,10)(12,15,17)(13,19,16)(18,20,21),()],
	   [(2,4)(3,6)(5,9)(7,12)(8,11)(10,15)(13,18)(14,17)(16,20)
	    (19,21),(1,4,2)(3,8,5)(6,9,11)(7,14,10)(12,15,17)
	    (13,19,16)(18,20,21),()] ] ] ],
[43,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
	 20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
	 36,37,38,39,40,41,42,43)],"c43",
       [ [ [ ],"c43","triv",[()],[()] ] ] ],
[44,1,[(1,2),(3,4),(5,6,7,8,9,10,11,12,13,14,15)],"c22c2",
       [ [ [  ],"c22c2","triv",[(),(),()],[(),(),()] ],
	 [ [(5,6,7,8,9,10,11,12,13,14,15)],"k4","c11",
	   [(),(),(5,6,7,8,9,10,11,12,13,14,15)],
	   [(),(),(5,6,7,8,9,10,11,12,13,14,15)] ],
	 [ [(3,4)],"c22","c2",[(),(3,4),()],[(),(3,4),()] ],
	 [ [(3,4),(3,4)],"c22","c2",
	   [(3,4),(3,4),()],[(),(3,4),()] ],
	 [ [(3,4),(5,6,7,8,9,10,11,12,13,14,15)],"c2","c22",
	   [(),(3,4),(5,6,7,8,9,10,11,12,13,14,15)],
	   [(),(3,4),(5,6,7,8,9,10,11,12,13,14,15)] ],
	 [ [(3,4),(3,4),(5,6,7,8,9,10,11,12,13,14,15)],"c2","c22",
	   [(3,4),(3,4),(5,6,7,8,9,10,11,12,13,14,15)],
	   [(),(3,4),(5,6,7,8,9,10,11,12,13,14,15)] ],
	 [ [(1,2),(3,4)],"c11","c4",
	   [(1,2),(3,4),()],[(1,2),(3,4),()] ] ] ],
[44,2,[(1,2,3,4),(5,6,7,8,9,10,11,12,13,14,15)],"c44",
       [ [ [  ],"c44","triv",[(),()],[(),()] ],
	 [ [(5,6,7,8,9,10,11,12,13,14,15)],"c4","c11",
	   [(),(5,6,7,8,9,10,11,12,13,14,15)],
	   [(),(5,6,7,8,9,10,11,12,13,14,15)] ],
	 [ [(1,2,3,4)],"c11","c4",
	   [(1,2,3,4),()],[(1,2,3,4),()] ] ] ],
[44,3,[(1,2,3,4,5,6,7,8,9,10,11),(1,11)(2,10)(3,9)
	(4,8)(5,7),(12,13)],"d44",
       [ [ [(2,11)(3,10)(4,9)(5,8)(6,7)(12,13)],"c22","c2",
	   [(),(2,11)(3,10)(4,9)(5,8)(6,7)(12,13),()],
	   [(),(2,11)(3,10)(4,9)(5,8)(6,7)(12,13),()] ],
	 [ [(2,11)(3,10)(4,9)(5,8)(6,7),(12,13)],"c11","k4",
	   [(),(2,11)(3,10)(4,9)(5,8)(6,7),(12,13)],
	   [(),(2,11)(3,10)(4,9)(5,8)(6,7),(12,13)] ],
	 [ [(1,2,3,4,5,6,7,8,9,10,11),(1,11)(2,10)(3,9)(4,8)(5,7)],"c2","d22",
	   [(1,2,3,4,5,6,7,8,9,10,11),(1,11)(2,10)(3,9)(4,8)(5,7),()],
	   [(1,2,3,4,5,6,7,8,9,10,11),(1,11)(2,10)(3,9)(4,8)(5,7),()] ] ] ],
[44,4,[(1,2)(3,4)(5,6,7,8,9,10,11,12,13,14,15),(1,3,2,4)
	(6,15)(7,14)(8,13)(9,12)(10,11)],"q44",
       [ [ [(1,2)(3,4),(1,3,2,4)(6,15)(7,14)(8,13)(9,12)(10,11)],"c11","c4",
	   [(1,2)(3,4),(1,3,2,4)(6,15)(7,14)(8,13)(9,12)(10,11)],
	   [(1,2)(3,4),(1,3,2,4)(6,15)(7,14)(8,13)(9,12)(10,11)] ] ] ],
[45,1,[(1,2,3),(4,5,6),(7,8,9,10,11)],"c15c3",
       [ [ [  ],"c3c15","triv",[(),(),()],[(),(),()] ],
	 [ [(7,8,9,10,11)],"c3^2","c5",
	   [(),(),(7,8,9,10,11)],[(),(),(7,8,9,10,11)] ],
	 [ [(4,5,6)],"c15","c3",
	   [(),(4,5,6),()],[(),(4,5,6),()] ],
	 [ [(4,5,6),(4,5,6)],"c15","c3",
	   [(4,5,6),(4,5,6),()],[(),(4,5,6),()] ],
	 [ [(4,5,6),(7,8,9,10,11)],"c3","c15",
	   [(),(4,5,6),(7,8,9,10,11)],[(),(4,5,6),(7,8,9,10,11)] ],
	 [ [(4,5,6),(4,5,6),(7,8,9,10,11)],"c3","c15",
	   [(4,5,6),(4,5,6),(7,8,9,10,11)],
	   [(),(4,5,6),(7,8,9,10,11)] ],
	 [ [(1,2,3),(4,5,6)],"c5","c3^2",
	   [(1,2,3),(4,5,6),()],[(1,2,3),(4,5,6),()] ] ] ],
[45,2,[(1,2,3,4,5,6,7,8,9),(10,11,12,13,14)],"c45",
       [ [ [  ],"c45","triv",[(),()],[(),()] ],
	 [ [(10,11,12,13,14)],"c9","c5",
	   [(),(10,11,12,13,14)],[(),(10,11,12,13,14)] ],
	 [ [(1,2,3,4,5,6,7,8,9)],"c5","c9",
	   [(1,2,3,4,5,6,7,8,9),()],[(1,2,3,4,5,6,7,8,9),()] ] ] ],
[46,1,[(1,2),(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
	20,21,22,23,24,25)],"c46",
       [ [ [  ],"c46","triv",[(),()],[(),()] ],
	 [ [(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25)],
	   "c2","c23",
	   [(),(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25)],
	   [(),(3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
	       21,22,23,24,25)] ],
	 [ [(1,2)],"c23","c2",[(1,2),()],[(1,2),()] ] ] ],
[46,2,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
	 20,21,22,23),(1,23)(2,22)(3,21)(4,20)(5,19)(6,18)
	 (7,17)(8,16)(9,15)(10,14)(11,13)],"d46",
       [ [ [(2,23)(3,22)(4,21)(5,20)(6,19)(7,18)(8,17)(9,16)(10,15)
            (11,14)(12,13)],"c23","c2",
	   [(),(2,23)(3,22)(4,21)(5,20)(6,19)(7,18)(8,17)(9,16)(10,15)
	    (11,14)(12,13)],[(),(2,23)(3,22)(4,21)(5,20)(6,19)(7,18)
	    (8,17)(9,16)(10,15)(11,14)(12,13)] ] ] ],
[47,1,[(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
	 20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
	 36,37,38,39,40,41,42,43,44,45,46,47)],"c47",
       [ [ [ ],"c47","triv",[()],[()] ] ] ] ];

#  end of file  cat1list.g
