IDA := rec();
#first global variables
#then a patch to get around X()
#then read routines
#then print routines
#then further global routines
#then tableaux wise routines

#global variables

X := Indeterminate(Rationals); #overwrites function X used in Factors
X.name := "X";

IDA.grpelt := ();
IDA.catbatch := [];
IDA.catlength := 2;
IDA.catno := 2;
IDA.i := 1;
IDA.num := 1;
IDA.fld := Rationals;
IDA.mes := "HAVINGFUNYET";
IDA.binword := "000";
IDA.v := [X,X,X,X,X,X];
IDA.lsts := [1,1];
IDA.lstg := [1,1];
IDA.m := 100;

I := E(4);
x  := Indeterminate(Integers);; x.name := "x";;
Rx := PolynomialRing(Integers);;
y  := Indeterminate(Rx);; y.name := "y";;
x  := y^0 * x;;
Rxy := PolynomialRing(Rx);;        
z  := Indeterminate(Rxy);; z.name := "z";;
x  := (z)^0 * x;                           ;
# returns x*y^0*z^0
y  := (z)^0 * y;
# returns y*z^0

IDA.xypol := [[0],[1]];
IDA.xyzpol := [[[0],[0,1]],[[1]]];
IDA.Xpol := X;

IDA.albe := ["a","b","c","d","e",
"f","g","h","i","j",
"k","l","m","n","o",
"p","q","r","s","t",
"u","v","w","x","y","z"];;


IDA.albec := ['1','2','3','4','5','6','7','8','9',
'a','b','c','d','e',
'f','g','h','i','j',
'k','l','m','n','o',
'p','q','r','s','t',
'u','v','w','x','y','z'];;

IDA.albecap := ['1','2','3','4','5','6','7','8','9',
'A','B','C','D','E',
'F','G','H','I','J',
'K','L','M','N','O',
'P','Q','R','S','T',
'U','V','W','X','Y','Z'];;

IDA.codeg := Z(2)*(Indeterminate(GF(2))^3 + Indeterminate(GF(2))^2 + 1);
# Factors(Indeterminate(GF(2))^7-Z(2))[2];
IDA.codeh := Z(2)*(Indeterminate(GF(2))^4 + Indeterminate(GF(2))^3 + 
                              Indeterminate(GF(2))^2 + 1);
IDA.grp := SymmetricGroup(4);
IDA.grpgens := [];
IDA.orbit := [];
IDA.lastfound := [];
IDA.new := [];
IDA.bool := true;
IDA.dim := 1;

IDA.2x2x2cubegens := [(1,2,3,4),(5,8,7,6),(5,1,4,8),(2,6,7,3),(5,6,2,1),(4,3,7,8)];
IDA.2x2x2cubegrp := Group(Subgroup(SymmetricGroup(8),IDA.2x2x2cubegens));


#read routines
IDA.readintmax :=    function(nn, maxn)     #read an integer nn of size at most maxn
  local ans;
  if IsInt(nn) then
    if nn < maxn then return(true);
    else Print(" Sorry, ",nn," too big, try a number less than ",maxn,"\n");
    fi;
  else Print(" Sorry, ",nn," is not an integer.\n");
  fi;
  return(false);
end;

IDA.readint :=    function(nn)     #read an integer nn of size at most maxn
  return(IDA.readintmax(nn,10^10));
end;


IDA.readintmin :=      function(nn,maxn,minn)      #read an integer of size >minn and <maxn
  if IDA.readintmax(nn,maxn) then
    if nn>minn then return(true);
    else Print(" Sorry, ",nn," is not an integer >", minn,".\n");
    fi;
  fi;
  return(false);
end;

IDA.readprime :=      function(nn)      #read a prime
  if IDA.readintmin(nn,10^10,1) then
    if IsPrime(nn) then return(true);
    else Print(" ",nn," is not a prime number.\n");
    fi;
  fi;
  return(false);
end;

IDA.readprimepow :=   function(nn)         #read a primepower
  local h;
  if IDA.readintmin(nn,10^10,1) then
     if IsPrimePowerInt(nn) then return(true);
     else Print(" Sorry, ",nn," is not a prime power.\n");
          h := Factors(nn);
          Print(" ",h[1]," and ",h[Length(h)]," are distinct prime divisors.\n");
     fi;
  fi;
  return(false);
end;


IDA.readlst :=   function(lst,nmax,nmin)       #read a list of numbers strictly between 
                                               #nmax and nmin
  local i, l, ok;
  if IsList(lst) then
     i := 0;
     l := Length(lst);
     ok := true;
     while i<l and ok do 
       i := i+1; ok := IDA.readintmin(lst[i],nmax,nmin);
     od;
     if ok then return(true); fi;
  else Print(" Input is not a list\n");
  fi;
  return(false);
end;

IDA.pol2coeffs := function(f) #give list of coefficients up to degree
  local ans, ff, n, xx;
  IDA.fld := f.baseRing;
  ff := Copy(f);
  n := Degree(ff);
  if n<0 then return([IDA.fld.zero]); fi;
  ans := List([1..n+1], xx -> IDA.fld.zero);
  while n>=0 do
    ans[n+1] := LeadingCoefficient(ff);
    ff := ff -ans[n+1]*Indeterminate(IDA.fld)^n;
    n := Degree(ff);
  od;
  return(ans);
end;

IDA.readxypol := function(f) #read in polynomial f in x,y in Rxy, create coeffs
  local fji, fxi, fxy, j, ff;
  #make coeffs pl
  if IsRat(f) then ff := f*z^0; else ff := Copy(f); fi;
  if IsPolynomial(ff) then
       fxy := IDA.pol2coeffs(ff); 
       if Length(fxy)>1 then Print(" No z allowed in input\n"); Print(fxy,"\n");
          return(false);
       fi;
       fxy := fxy[1]; #in Rxy
       if not(IsPolynomial(fxy)) # not implemented: check fxy.baseRing =?= Rxy
       then Print(" ",fxy," is not a polynomial in x, y,\n");
          return(false);
       fi;
       fxi := IDA.pol2coeffs(fxy);
       fji :=[];
       for j in [1..Length(fxi)] do
         if not(IsPolynomial(fxi[j])) 
         then Print(" ",fxy," is not a polynomial in x, y,\n");
            return(false);
         fi;
         fji[j] := IDA.pol2coeffs(fxi[j]); #in R
       od;
       IDA.xypol := fji;
  else Print(" input ",ff," is not a polynomial in x, y,\n");
       return(false);
  fi;
  return(true);
end;


IDA.readxyzpol := function(f) #read in polynomial f in x,y,z in Rxyz, create coeffs
  local fkxy, fkjx, j, k, ff, ans;
  #make coeffs pl
  if IsRat(f) then ff := f*z^0; else ff := Copy(f); fi;
  if IsPolynomial(ff) then
       ans := [];
       fkxy := IDA.pol2coeffs(ff); 
       for k in [1..Length(fkxy)] do
          if not(IsPolynomial(fkxy[k])) # not implemented: check fkxy.baseRing =?= Rxy
          then Print(" ",fkxy[k]," is not a polynomial in x, y,\n");
             return(false);
          fi;
          fkjx := IDA.pol2coeffs(fkxy[k]);
          ans[k] := [];
          for j in [1..Length(fkjx)] do
            if not(IsPolynomial(fkjx[j])) 
            then Print(" ",fkjx[j]," is not a polynomial in x,\n");
                 return(false);
            fi;
            ans[k][j] := IDA.pol2coeffs(fkjx[j]); #in R
          od;
       od;
       IDA.xyzpol := Copy(ans);
  else Print(" input ",ff," is not a polynomial in x, y, z.\n");
       return(false);
  fi;
  return(true);
end;


IDA.readXpol := function(f) #read in polynomial f in X over Rationals, put in IDA.Xpol
  local fji, fxi, fxy, j, ff;
  #make coeffs pl
  if IsRat(f) then ff := f*X^0; else ff := Copy(f); fi;
  if IsPolynomial(ff) and ff.baseRing = Rationals then
       IDA.Xpol := ff;
  else Print(" input ",ff," is not a polynomial in X\n");
       return(false);
  fi;
  return(true);
end;


IDA.readbinword :=  function(bstr) #read a binary string and change to binary vector
  local ans, i, l;
  l := Length(bstr);   
  ans := IDA.NullVec(l);
  for i in [1..l] do
    if bstr[i] = '1' then ans[i] := 1;
    elif bstr[i] <> '0' then 
         Print("\n Sorry, input is not a binary string.\n");
         return(false);
    fi;
  od;
  IDA.binword := ans;
  return(true);
end;

IDA.readprmlst := function(prmlst)   #read a list and check if represents permutation
                                     #if so store in IDA.grpelt in disjoint cycles form
 if not(IsList(prmlst)) then
    Print(" The input ", prmlst, " is neither a list nor a cycle decomposition\n");    
    return(false);
 elif Length(Set(prmlst)) <> Length(prmlst) then
    Print(" The mapping ",prmlst," is not injective\n");
    return(false);
 elif Maximum(prmlst) <> Length(prmlst) then
    Print(" The permutation ",prmlst," is not\n");
    Print(" everywhere defined on {1,...,",Maximum([Maximum(prmlst),Length(prmlst)]),"}\n");
    return(false);
 fi;
 IDA.grpelt := PermList(prmlst);
 return(true);
end;

IDA.readprmcyc := function(cyc)   #read a permutation in disjoint cycle form
 if IsPerm(cyc) then
    return(true);
 else Print(" Sorry, ",cyc," is not a permutation in disjoint cycles form\n");
 fi;
 return(false);
end;

IDA.readprm := function(perm)   #read a permutation in disjoint cycle form or list form
                                #check it and
                                #store element in disjoint cycle form in IDA.grpelt
 if IsPerm(perm) then
    IDA.grpelt := Copy(perm);
    return(true);
 elif IDA.readprmlst(perm) then
    return(true);
 fi;
 return(false);
end;

IDA.readgrp := function(glst)   #read in a group by means of list of generators
                                #and put the cycle perms in list IDA.grpelts
                                #and put the degree in IDA.m
  local h, ans, m, g;
  ans := [];
  m := 1;
  if IsList(glst) then
    for h in glst do 
      if IDA.readprm(h) then
        Add(ans,IDA.grpelt); m := Maximum([m,Maximum(ListPerm(IDA.grpelt))]);
      else return(false);
      fi;
    od;
    IDA.grpelts := Copy(ans);
    IDA.grp := Group(Subgroup(SymmetricGroup(m),IDA.grpelts));
    IDA.m := m;
    return(true);
  else Print(" Sorry, ",glst," is not a list of permutations,\n");
    return(false);
  fi;
end;

IDA.readmat :=    function(nn)   #read a matrix
  if IsMat(nn) then  return(true);
  else Print(" Sorry, ",nn," is not a matrix,\n");
  return(false);
  fi;
end;


IDA.readsqmat :=    function(nn)   #read a square matrix and put dimension in IDA.dim
  local d;
  if IsMat(nn) then
     d := DimensionsMat(nn);
     if d[1] = d[2] then IDA.dim := d[1];  return(true);
     else Print(" Sorry, ",nn," is not a square matrix,\n");
     fi;
  else Print(" Sorry, ",nn," is not a matrix,\n");
  return(false);
  fi;
end;

IDA.readstring :=    function(str)   #read a string
  if IsString(str) then  return(true);
  else Print(" Sorry, ",str," is not a string of characters,\n,");
  return(false);
  fi;
end;

IDA.readgauss := function(g) # read a Gaussian number
  local gg;
  if g in GaussianIntegers then
    return(true);
  else Print(" ",g," is not a Gaussian integer\n");
  fi;
  return(false);
end;

IDA.readalbecap := function(g) # read string with letters in IDA.albecap
  local gg, xx;
  if IDA.readstring(g) then
    for xx in g do 
        if not(xx in IDA.albecap) and xx <> '0' then
           Print(" ",xx," is not a capital or a number\n");
           return(false);
        fi;
    od;
  fi;
  return(true);
end;

#print routines
IDA.printset := function(st,num,op) #print a set/list/sequence st with num per line
                                    #     op = 0/ 1 / 2
 local i, l;
 l := Length(st);
 Print(" ");
 if op = 0 then Print("{"); elif op = 1 then Print("["); fi; 
 for i in [1..l-1] do
     Print(st[i],", ");
     if (i mod num) = 0 then Print("\n  "); fi;
 od; 
 Print(st[l]);
 if op = 0 then Print("}"); elif op = 1 then Print("]"); fi; 
 Print("\n");
end;

IDA.printmat := function(m,spacing) local mi,mij;
    for mi in m do 
        Print(" ( ");
        for mij in mi do
            Print(String(mij,spacing)," ");
        od;
        Print(")\n");
    od; Print("\n");
end;

IDA.printHadmat := function(m,parm) local mi, mij;
  if Length(m)<32 then
    for mi in m do 
        if parm then Print("("); fi; Print(" ");
        for mij in mi do
            if mij=1 then if parm then Print("+"); else Print("*");fi; Print(" ");
            else if parm then Print("-"); else Print(".");fi; Print(" "); 
            fi;
        od;
        if parm then Print(")"); fi; Print("\n");
    od; 
  else
    for mi in m do 
        if parm then Print("(");fi;
        for mij in mi do
            if mij=1 then if parm then Print("+"); else Print("*");fi; 
            else if parm then Print("-"); else Print(".");fi;
            fi;
        od;
        if parm then Print(")"); fi; Print("\n");
    od; 
  fi;
  Print("\n");
end;

IDA.printgrpelt := function(hlst) #print grp element
  local i, j, eq, l, h, c;
  i := 0; l := Length(hlst);
  while i < l do
    i := i+1; j := i; h := hlst[i]; eq := true;
    while j <= l and eq do
      if hlst[j] = h then j := j+1; else eq := false; fi;
    od;
    c := hlst[i];
    Print("g",AbsInt(c));
    if SignInt(c) <0 then Print("^",(i-j)); 
    elif j-i <> 1 then    Print("^",j-i);
    fi;
    i := j-1; Print(" ");
  od;
end;

IDA.printxypol := function(ff,xx,yy)  #read in polynomial f in x and y,
                                      #then display expanded with xx and yy as letters
                                      #representing x and y respectively
  local i, j, ans, addon, hlp, sgn;
      ans := ""; 
      addon := false;
      for j in [1..Length(ff)] do
        for i in [1..Length(ff[j])] do
          hlp := ff[j][i]; 
          if hlp <> 0 then 
             if SignInt(hlp) = 1 then sgn := "+ "; else sgn := "- "; fi;
             if addon or sgn = "- " then Append(ans,sgn); fi; 
             addon := true; hlp := AbsInt(hlp);
             if hlp<>1 then
                       Append(ans,String(hlp)); 
             elif i=1 and j=1 then Append(ans,String(1)); 
             fi;
             if i>1 then Append(ans,xx);
                if i>2 then Append(ans,"^"); Append(ans,String(i-1));
                fi;
             fi;
             if j>1 then Append(ans,yy);
                if j>2 then Append(ans,"^"); Append(ans,String(j-1));
                fi;
             fi;       
             Append(ans," ");
         fi;
       od;
     od;
     Print(" ",ans,"\n");
end;


IDA.printxyzpol := function(ff,xx,yy,zz)  #read in polynomial f in x,y,z,  then display expanded
  local i, j, k, ans, addon, hlp, sgn;
      ans := ""; 
      addon := false;
      for k in [1..Length(ff)] do
        for j in [1..Length(ff[k])] do
          for i in [1..Length(ff[k][j])] do
            hlp := ff[k][j][i]; 
            if hlp <> 0 then 
             if SignInt(hlp) = 1 then sgn := "+ "; else sgn := "- "; fi;
             if addon then Append(ans,sgn); fi; 
             addon := true; 
             if AbsInt(hlp)<>1 then
                       Append(ans,String(AbsInt(hlp))); 
             elif i=1 and j=1 and k=1 then Append(ans,String(1)); 
             fi;
             if i>1 then Append(ans,xx);
                if i>2 then Append(ans,"^"); Append(ans,String(i-1));
                fi;
             fi;
             if j>1 then Append(ans,yy);
                if j>2 then Append(ans,"^"); Append(ans,String(j-1));
                fi;
             fi;       
             if k>1 then Append(ans,zz);
                if k>2 then Append(ans,"^"); Append(ans,String(k-1));
                fi;
             fi;       
             Append(ans," ");
            fi;
         od;
       od;
     od;
     Print(" ",ans,"\n");
end;

IDA.printgauss := function(g) #print a Gaussian integer
  local a, b, gg, sgn;
  if g in Integers then Print(g);
  else
     gg := Conjugates(g);
     a := (gg[1]+gg[2])/2;
     b := -(gg[1]-gg[2])*I/2;
     if SignInt(b) > 0 then sgn := "+"; else sgn := "-"; fi;
     if a<>0 then Print(a); fi;
     if a <>0 or sgn=-1 then Print(sgn); fi;
     if AbsInt(b)<>1 then Print(AbsInt(b)); fi;
     Print("I");
  fi;
end;


#further global routines

IDA.NullVec := function(n)
   local v;
   return List([1..n], v -> 0);
end;

IDA.convert := function(n,a) local ans, nl;
  nl := n mod 36;
  if nl = 0 then ans := '0';
  else  ans := IDA.albecap[nl];
  fi;
  return(ans);
end;

IDA.revert := function(n,a)
 if n='0' or n = "0" then return(0);
 elif not (n in IDA.albecap)
      then Print(" Error in revert, first argument ",n," too big.\n");
 else return( Position(IDA.albecap,n) mod a);
 fi;
 return(0);
end;

IDA.mat2vec := function(m) # rewrite matrix to a vector
 local ans, i, j, rd, cd;
 rd := DimensionsMat(m);
 cd := rd[2]; rd := rd[1];
 ans := [];
 for i in [1..cd] do for j in [1..rd] do
   ans[i+(j-1)*cd] := m[j][i];
 od; od;
 return(ans);
end;

IDA.vec2mat := function(v,r,c) # rewrite vector to a matrix
 local ans, i, j, ind;
 ans := NullMat(r,c); #must have Length(v) = r*c
 for i in [1..c] do for j in [1..r] do
            ans[j][i] :=  v[i+(j-1)*c];
 od; od;
 return(ans);
end;


IDA.minpoly := function(a) #minimum poly of a square matrix
  local cont, va, vas, ko, i, k, n, v, b, hlp, nullv, xx, rel;
  n := DimensionsMat(a)[1];
  vas := [IDA.mat2vec(IdentityMat(n))];
  cont := true; i := 0; ko := 1;
  while cont and  i<n do
    i := i+1;
    Add(vas,IDA.mat2vec(a^i));
    v := RowSpace(Rationals, vas);
    b := Base(v);
    k := Length(b);
    if k = ko then 
       rel := NullspaceMat(vas)[1];
       return(Polynomial(Rationals,rel));
    fi;
    ko := k;    
  od;
end;

IDA.cos := function(n) local ans, hlp,i;
ans := 1*X^0; i := 0; hlp := 1;
while i<=n do i := i+2; hlp := hlp * (-1) /(i*(i-1));
   ans := ans + hlp*X^i;
od;
return(ans);
end;

IDA.sin := function(n) local ans, hlp,i;
ans := X^1; i := 1; hlp := 1;
while i<=n do i := i+2; hlp := hlp * (-1) /(i*(i-1));
   ans := ans + hlp*X^i;
od;
return(ans);
end;

IDA.invoneplus := function(n) local ans, hlp,i;
ans := X^0; i := 1; hlp := 1;
while i<=n do i := i+1; hlp := hlp * (-1);
   ans := ans + hlp*X^i;
od;
return(ans);
end;

IDA.exp := function(n) #exp(X) up to n-th order
  local ans, hlp,i;
  ans := X^0; i := 1; hlp := 1;
  while i<=n do i := i+1; hlp := hlp /i;
    ans := ans + hlp*X^i;
  od;
  return(ans);
end;

IDA.logonemin := function(n) # log(1-X) base e to n-th order
  local ans, i;
  ans := - X^0; i := 1; 
  while i<=n do i := i+1;
    ans := ans - (1/i)*X^i;
  od;
  return(ans);
end;

IDA.polinvXn := function(f,n)  # Taylor to n of f = f0(1-f1) 
                               # where f1 = (f0-f)/f0;
  local ans, f0, f1, hlp, i;
  f0 := Value(f,0);
  ans := 0;
  if f0 = 0 then return(0);
  else  hlp := 1/f0; ans := hlp*X^0; i := 1; f1 := (X^0-hlp*f) mod X^n; 
    while i<=n do i := i+1; hlp := (hlp * f1) mod X^n;
      ans := ans + hlp;
    od;
  return(ans);
  fi;
end;

IDA.Euler := function(n)  #compute Euler phi the hard way
 local ans, hlp,lst,i;
 if n=1 then return(1);
 else lst := DivisorsInt(n);
   ans := n; 
   for i in [1..Length(lst)-1] do
     ans := ans - IDA.Euler(lst[i]);
   od;
   return(ans);
 fi;
end;

IDA.Eulerelts := function(n)  #list the elts of (Z/n)^*
 local i;
 if n=1 then return(Set([1]));
 else        return(Filtered([1..n-1], i ->  Gcd(i,n)=1 ));
 fi;
end;


IDA.Weight := function(v,p,n) # coding theoretic weight of vector v in GF(p)^n
local i;
 return(Length(Filtered([1..n], i -> v[i] <> 0*Z(p)^0)));
end;


IDA.MakeRatPol :=  function(f,q) #f is poly over ground field GF(p) of GF(q), 
                                 #turn out rational version
  local p,c,cc,d,ans;
  p := CharFFE(Z(q));
  ans := 0*Indeterminate(Rationals);
  while Degree(f) >-1 do 
    cc := LeadingCoefficient(f);
    c := PowerMod(PrimitiveRootMod(p),(LogFFE(cc)), p);
    d := Degree(f);
    f := f - cc*Indeterminate(GF(q))^d;
    ans  := ans + c * Indeterminate(Rationals)^d;
  od;
  return ans;
end;


IDA.MakeFFEPol :=  function(f,q) local p,c,cc,d,ans;
  #f is rational poly; make poly over ground field GF(p)
  p := CharFFE(Z(q));
  ans := 0*Indeterminate(GF(q));
  while Degree(f) >-1 do 
    cc := LeadingCoefficient(f);
    c := cc*Z(p)^0;
    d := Degree(f);
    f := f - cc*Indeterminate(Rationals)^d;
    ans  := ans + c * Indeterminate(GF(q))^d;
  od;
  return ans;
end;



IDA.ModPolOrder := function(g,f,p) # determine order of g in mod f over GF(p)
local  nfd, q, i, h, hs, df; 
  h := Indeterminate(GF(p))^0; 
  nfd := true; i := 0;
  q := p^Degree(f);
  while nfd and i<q do h := h*g mod f; i := i+1; 
    if h = Indeterminate(GF(p))^0 then nfd := false; fi;
  od;
  return(i);
end;



IDA.NextList := function(lst,p) local i;
   i := Length(lst);
   while i>0 do
     if lst[i]<p-1 then lst[i] := lst[i]+1; return(lst);
     else lst[i]:= 0; i := i-1;
     fi;
   od;
   return(lst); 
end;


IDA.testModPolOrder := function (g, d, p ) #for debugging
    local  nfd, q, i, h, hs, df, ford, lford, fords;
    nfd := true;
    q := p^Degree(d);
    ford := Set(Factors(q-1));
    lford := Length(ford);
    ford := List([1..lford],i -> (q-1)/ford[i]);
    i := 0; lford := Length(ford);
    while nfd and i < lford  do
        i := i+1;
        h := PowerMod(g,ford[i],d);
        if h <> Indeterminate( GF( p ) ) ^ 0  then
            nfd := false;
        fi;
    od;
    return(not(nfd));
end;

IDA.FindPriPol := function(d,p)
  local dg, q, ct, g, lst;
  dg := Degree(d); 
  if dg = 1 then return(Z(p)*Indeterminate(GF(p)^0)); fi;
  q := p^dg;
  lst := IDA.NullVec(dg); lst[2] := 1;
         g := Indeterminate(GF(p));
         ct := 0;
         while  not(IDA.testModPolOrder(g,d,p))  and ct<q do
             ct := ct+1;
               lst := IDA.NextList(lst,p);
               g := Polynomial(GF(p),lst*Z(p)^0);
        od;
   return(g);
end;


IDA.NextPerm := function(ww) 
  local i,j, h,k, w;
  w := Copy(ww);
  k := Length(w);
  if k<2 then return IDA.NullVec(k); fi;
  i := k-1;
  while  w[i] > w[i+1]-1 do i := i-1;  # find last ascent (i,i+1)
    if i = 0 then return(IDA.NullVec(k)); fi; # there is none 
  od;
  j := k;
  while  w[i] >= w[j] do j := j-1; od; # find maximal j>i with w[i]<w[j]
  h := w[i]; w[i] := w[j]; w[j]:= h;
#  swap(w[i],w[j]);
# now we have w[i]<=w[i+1]>= .... >>w[j]>= .... >=w[k-1] 
  i := i+1; j := k;
  while i<j do 
      h := w[i]; w[i] := w[j]; w[j]:= h;
      i := i+1; j := j-1; # reverse w[i+1:k-1] 
  od;
  return(w);
end;

IDA.NextVec := function(w,p,k) #run through the vectors in [0..p-1]^k
  local i, j, pp, ww;
  ww := Copy(w); pp := p-1;
#   k = Length(w);
  i := k;
  while  ww[i]=pp do i := i-1;  # find last nonmaximal component
    if i = 0 then return(IDA.NullVec(k)); fi; # there is none 
  od;
  for j in [i+1..k] do ww[j] := 0; od;
  ww[i] := ww[i]+1;
  return(ww);
end;


IDA.fldorder := function(a) local q, h, ord, wan;
 h := a; ord := 1; wan := a^0;
 q := CharFFE(a)^(DegreeFFE(a));
 while h <> wan and ord<q  do h := h*a; ord := ord+1; od;
 return(ord);
end;


IDA.extgcd := function(v) local m, q, qr, l; 
  m := [[1,0],[0,1]]; l := 2;
  while v[l] <> 0 do 
      qr := QuotientRemainder(v[l-1],v[l]);
      Add(v,qr[2]); l := l+1; q := qr[1]; 
      m :=  [[0,1],[1,-q]] * m;  
  od;
  return [m[1][1],m[1][2],v[l-1]];
end;

IDA.extgcdp := function(v) local m, q, qr, l; 
  m := [[1,0],[0,1]]*X^0; l := 2;
  while v[l] <> 0*X^0 do 
      qr := QuotientRemainder(v[l-1],v[l]);
      Add(v,qr[2]); l := l+1; q := qr[1]; 
      m :=  ([[0,1],[1,-q]]*X^0) * m;  
  od;
  q := LeadingCoefficient(v[l-1]);
  return [m[1][1],m[1][2],v[l-1]]/q;
end;

IDA.extgcdpmod := function(v,p) local m, q, qr, l; 
  m := [[1,0],[0,1]]*Indeterminate(GF(p))^0; l := 2;
  while v[l] <> 0*Indeterminate(GF(p))^0 do 
      qr := QuotientRemainder(v[l-1],v[l]);
      Add(v,qr[2]); l := l+1; q := qr[1]; 
      m :=  ([[0,1],[1,-q]]*Indeterminate(GF(p))^0) * m;  
  od;
  q := LeadingCoefficient(v[l-1]);
  return [m[1][1],m[1][2],v[l-1]]/q;
end;


IDA.paley_sym := function(q)  local a,i,j,p,k,q, G,h,n,hn, ans;
  n := 2*(q+1); #should have q= 1 mod 4
  ans := NullMat(n,n);
 # want I+C   -I+C
 #     -I+C   -I-C
  for i in [1 .. q+1] do ans[i][q+1] := 1; ans[q+1][i] := 1;
    ans[i][n] := 1; ans[q+1][i+q+1] := 1;
    ans[q+1+i][q+1] := 1; ans[n][i] := 1;
    ans[q+1+i][n] := -1; ans[n][i+q+1] := -1;
  od; ans[q+1][n] := -1; ans[n][q+1] := -1; ans[n][n] := -1; 
  G := GF(q);
  a := Z(q);
  for i in [1 .. q-1] do for j in [1 .. q-1] do
   h := a^i-a^j;
   if h=0*Z(q) then ans[i][j] := 1; ans[i+q+1][j] := -1;
              ans[i][j+q+1] := -1; ans[i+q+1][j+q+1] := -1; 
   else hn := (q-1)/(IDA.fldorder(h)) ; 
         if (hn mod 2) = 0 then
           ans[i][j] := 1;  ans[i+q+1][j+q+1] := -1;
           ans[i+q+1][j] := 1;  ans[i][j+q+1] := 1;
         else
           ans[i][j] := -1;  ans[i+q+1][j+q+1] := 1;
           ans[i+q+1][j] := -1;  ans[i][j+q+1] := -1;
         fi;
   fi;
  od; od;
  for i in [1 .. q-1] do
    h := a^i;
    if h=0 then 
      ans[i][q] := 1; ans[q][i] := 1;
      ans[i][2*q+1] := 1; ans[q][i+q+1] := 1;
      ans[i+q+1][q] := 1; ans[2*q+1][i] := 1;
      ans[i+q+1][2*q+1] := -1; ans[2*q+1][i+q+1] := -1;
    else hn := (q-1)/(IDA.fldorder(h)) ; 
         if hn mod 2 = 0 then
              ans[i][q] := 1; ans[q][i] := 1;
              ans[i][2*q+1] := 1; ans[q][i+q+1] := 1;
              ans[i+q+1][q] := 1; ans[2*q+1][i] := 1;
              ans[i+q+1][2*q+1] := -1; ans[2*q+1][i+q+1] := -1;
         else ans[i][q] := -1; ans[q][i] := -1;
              ans[i][2*q+1] := -1; ans[q][i+q+1] := -1;
              ans[i+q+1][q] := -1; ans[2*q+1][i] := -1;
              ans[i+q+1][2*q+1] := 1; ans[2*q+1][i+q+1] := 1;
         fi;
    fi;
  od; 
  ans[q][q] := 1; ans[2*q+1][q] := -1; 
  ans[q][2*q+1] := -1; ans[2*q+1][2*q+1] := -1;
  return (ans);
end;


IDA.paley_skew := function(q)  local a,i,j,p,k,q, G,h, n, hn, ans;
  n := q+1; #should have q= 3 mod 4
  ans := NullMat(n,n);
  for i in [1 .. n-1] do ans[i][n] := 1; ans[n][i] := -1; od; ans[n][n] := 1;
  G := GF(q);
  a := Z(q);
  for i in [1 .. q-1] do for j in [1 .. q-1] do
   h := a^i-a^j;
   if h=0 then ans[i][j] := 1;
   else hn := (q-1)/(IDA.fldorder(h)) ; 
         if hn mod 2 = 0 then
           ans[i][j] := 1; else ans[i][j] := -1 ;
         fi;
   fi;
  od; od;
  for i in [1 .. q-1] do
    h := a^i;
    hn := (q-1)/(IDA.fldorder(h)) ; 
    if hn mod 2 = 0 then
              ans[i][q] := 1; ans[q][i] := -1;
    else ans[i][q] := -1; ans[q][i] := 1;
    fi;
  od; 
  ans[q][q] := 1;
  return(ans);
end;

IDA.tensor := function(a,b) local i,j,k,l,m,ii,jj, ans;
  l := Length(a); m := Length(b);
  k := l*m;
  ans := NullMat(k,k);
  for i in [1 .. l] do for j in [1..l] do
     for ii in [1 .. m] do for jj in [1 .. m] do
       ans[i+l*(ii-1)][j+l*(jj-1)] := a[i][j]*b[ii][jj];
     od; od;
  od; od;
  return(ans);
end;


IDA.Had := function(n) local i,j,k,q, ifacs, pk, ans;
  ans := NullMat(n,n); 
  if n=1 then ans[1][1] := 1; return(ans); fi;
  if n=2 then ans[1][1] := 1; ans[1][2] := 1;  ans[2][1] := -1;  ans[2][2] := 1;
              return((ans)) ;
  fi;
  if (n mod 4) <> 0 then Print("There is no Hadamard matrix of this dimension\n"); return(" "); fi;
  if (n mod 8 ) = 0 or n=4 then return(IDA.tensor(IDA.Had(n/2),IDA.Had(2))); fi;
  q := n-1;
  if (q mod 4) = 3 and IsPrimePowerInt(q) then
     #Print("in q mod 4 =3 case");
     return(IDA.paley_skew(q));
  fi;
  q := n/2-1;
  if (q mod 4) = 1  and IsPrimePowerInt(q) then
     #Print("in q mod 4 =1 case");
     return(IDA.paley_sym(q));
  fi;
  Print("not in present construction list"); return(" ");
end;

IDA.checkHad := function(f)  local d, i,j,a;
  d := Length(f); 
  a := f * TransposedMat(f);
  for i in [1 .. d] do for j in [1 .. d] do
   if (i=j and a[i][j]<> d) or (i<>j and a[i][j] <> 0)
   then return(false);
   fi;
  od; od;
  return(true);
end;

IDA.Had_exists := function(n)  local i,j,k,q, ifacs, pk, ans;
  if n=1 or n =2 or n = 4 then return(true); fi;
  if (n mod 4) <> 0 then Print("known not to exist as dimension is not equal to 0 mod 4");
          return(false);
  fi;
  if (n mod 8 ) = 0 or n=4 then return(IDA.Had_exists(n/2)); fi;
  q := n-1;
  if (q mod 4) = 3 and IsPrimePowerInt(q)
  then return(true) ;
  fi;
  q := n/2-1;
  if (q mod 4) = 1 and IsPrimePowerInt(q)
    then return(true);
  fi;
  return(false);
end;

IDA.HadOpenCases := function(k)  local i,j,lst;
  lst := []; i := 4;
  while i <= k do
    if not(IDA.Had_exists(i)) then Add(lst,i); fi; i := i+4;
  od;
  return(lst);
end;

IDA.onedgeset := function(edgeset,g) #action of g on a set of edges
  local ans, i, h;
  ans := [];
  for h in edgeset do
       Add(ans,Set([h[1]^g,h[2]^g]));
  od;
  return ans;
end;

IDA.companion := function(f) #given poly make companion matrix
  local ans, cf, lc, i, fld, n;
  fld := f.baseRing;
  n := Degree(f);
  ans := NullMat(n,n,fld);
  cf := IDA.pol2coeffs(f);
  lc := cf[n+1];
  for i in [1..n-1] do ans[i+1][i] := 1; ans[i][n] := -cf[i]/lc; od;
  ans[n][n] := -cf[n]/lc;
  return(ans);
end;


#here we begin with the tableau commands


IDA.c1s1p1df1 := function(v)  #divisibility test for integers
  if IDA.readint(v[1]) and IDA.readint(v[2]) then
    if QuotientRemainder(v[2],v[1])[2]=0 then 
       Print(" ",v[1]," divides ",v[2], " with quotient ",
            QuotientRemainder(v[2],v[1])[1],"\n");
    else  Print(" ",v[1]," does not divide ",v[2],"\n");
    fi;
  fi;
end;

IDA.c1s1p2th1 := function(v) #quotient and remainder for integers
  local qr;
  if IDA.readint(v[1]) and IDA.readint(v[2])
  then
    if v[2]=0 then Print(" Division by 0; impossible");
    else 
    qr :=  QuotientRemainder(v[1],v[2]);
    Print(" ",v[1]," divided by ",v[2]);
    Print(" gives quotient ", qr[1]," and\n remainder ", qr[2],"\n");
    fi;
  fi;
end;

IDA.c1s1p3df1 := function(v) #common divisors of two integers
  local da, db;
  if IDA.readint(v[1]) and IDA.readint(v[2]) then
     da := DivisorsInt(v[1]);     db := DivisorsInt(v[2]);
     Print(" The divisors of ", v[1], " are\n ", da, ".\n\n");
     Print(" The divisors of ", v[2], " are\n ", db, ".\n\n");
     Print(" The common divisors are\n ", Intersection(da,db), ",\n\n");
     Print(" so the greatest common divisor is ", Gcd(v[1],v[2]),".\n");
  fi;
end;

IDA.c1s1p4df1 := function(a,b) #common multiples of two integers
  local ma, mb, mab, i;
  if IDA.readintmin(a,100,0) and IDA.readintmin(b,100,0) then
     mab := Lcm(a,b);
     ma := [a]; mb := [b];
     for i in [1..mab/a+1] do Add(ma,a*i); od;
     for i in [1..mab/b+1] do Add(mb,b*i); od;
     Print(" The first few multiples of ", a, " are\n ", ma, ",\n\n");
     Print(" The first few multiples of ", b, " are\n ", mb, ",\n\n");
     Print(" so the least common multiple is ", mab,".\n");
  fi;
end;



IDA.c1s2p1al1 := function(v) #gcd 
  local l; l := 2; 
  if IDA.readint(v[1]) and IDA.readint(v[2]) then
     while v[l] <> 0 do Add(v,QuotientRemainder(v[l-1],v[l])[2]); l := l+1; od;
     Print(" ",v,"\n\n gcd(a,b) = ", v[l-1],"\n");
  fi;
end;


IDA.c1s2p2al1 := function(v) #extended gcd
  local eg;
  if IDA.readint(v[1]) and IDA.readint(v[2]) then
     eg := IDA.extgcd(v);
     Print(" x a   +   y b = gcd(a,b):\n");
     Print(" ",eg[1],"*",v[1]," + ",eg[2],"*",v[2]," = ",eg[3],"\n");
  fi;
end;

IDA.c1s3p1th1 := function(v) #solving a Diophantine homogeneous equation
  local ant,g;
  if IDA.readint(v[1]) and IDA.readint(v[2]) then
     if v[1] = 0 and v[2] = 0 then Print(" Both a and b are zero, any pair is a solution.\n");
     else g := Gcd(v[1],v[2]);  ant := [-v[2]/g,v[1]/g];
     Print(" [",ant[1],"*n,",ant[2],"*n] for any integer n.\n");
     fi;
  fi;
end;

IDA.c1s3p2al1 := function(w) #solving a diophantine equation
  local d,xp,yp,eg; 
  if IDA.readint(w[1]) and IDA.readint(w[2]) then
     eg := IDA.extgcd([w[1],w[2]]);
     xp := eg[1]; yp := eg[2];
     d := eg[3];
     if d <> Gcd(w[1],w[2]) 
     then Print(" Internal error\n",[d,xp,yp,w[1],w[2]]); 
     fi;
     if Mod(w[3],d) = 0 then
         Print(" [",xp*w[3]/d,"-n*",w[2]/d,",",yp*w[3]/d,"+n*",w[1]/d,"] for any integer n.\n");
     else Print(" No solutions as gcd(a,b) = ",d," does not divide ", w[3],".\n"); 
     fi;
  fi;
end;


IDA.c1s4p1df1 := function(v) #test primality
    if IDA.readprime(v) then Print(" ",v," is a prime.\n"); fi;
end;

IDA.c1s4p1th1 := function(pl)  #find a prime not dividing a set of integers
  local pp, i, ok;
  ok := true;
  pp := 1;
  for i in pl do 
    if ok then ok := IDA.readint(i); fi;
    if ok then pp := pp * i;   fi;
  od;
  if ok then
    pp := pp+1;
    Print(" ",Factors(pp)[1],"\n");
  fi;
end;

IDA.c1s4p2al1i := function(n) #Eratosthenes' sieve initialize
  if IDA.readintmin(n,500,2) then
    IDA.num := n;
    IDA.lst := [2..n]; IDA.i := 1;
    Print(" Start with the list: ",IDA.lst,"\n");
  fi;
end;

IDA.c1s4p2al1r := function() #Eratosthenes' sieve run
  local j;
  if IDA.i^2 >= IDA.num then
    Print(" Done, the final list of primes <= ",IDA.num," is \n",IDA.lst,"\n");
  else
    IDA.i := IDA.i+1;
    while not(IDA.i in IDA.lst) do IDA.i := IDA.i+1; od;
    IDA.lst := Filtered(IDA.lst, j -> (j mod IDA.i) <> 0 or j<=IDA.i);
    Print(" Prime found: ",IDA.i,".\n");
    Print(" The updated list (of length ",Length(IDA.lst),") is\n");
    Print(IDA.lst,"\n");
  fi;
end;


IDA.c1s5p1th1 := function(n) # factor n
  if IDA.readint(n) then  Print(" ",Factors(n),"\n");  fi;
end;

IDA.c2s1p1df1 := function(v) #congruence mod n
  if IDA.readint(v[1]) and IDA.readint(v[2]) and IDA.readint(v[3]) then
    if v[3] = 0 then
       Print(" ",v[1] = v[2],"\n");
    else
       Print(" ", (v[1]-v[2]) mod v[3] = 0,"\n");
    fi;
  fi;
end;

IDA.c2s1p2df1 := function(v) # sum and product modulo m
  if IDA.readintmin(v[3],1000000,0) and IDA.readint(v[1]) and IDA.readint(v[2]) then 
      Print("\n  sum: ",v[1]," + ",v[2]," = ", (v[1]+v[2]) mod v[3] ," mod ", v[3],"\n\ ");
      Print(" product: ",v[1]," * ",v[2]," = ", (v[1]*v[2]) mod v[3] ," mod ", v[3],"\n");
  fi;
end;

IDA.c2s1p3df1 := function(v) #test invertibility mod m
  local eg; 
  if IDA.readint(v[1]) and IDA.readintmin(v[2],10^10,1) then
     eg := IDA.extgcd(v);
     if eg[3] = 1 then
        Print(" ",v[1]," is invertible mod ",v[2],"\n with inverse ", eg[1] mod v[2],"\n");
     else
        Print(" ",v[1]," is not invertible mod ",v[2],"\n");
     fi;
  fi;
end;

IDA.c2s1p3th1 := function(n)  #invertible elts mod n
   local a, b, lst, eg;
   if IDA.readintmin(n,500,0) then
     lst := [1..n-1];
     while Length(lst)>0 do
        a := lst[1]; RemoveSet(lst,a);
        eg := IDA.extgcd([a,n]);
        if eg[3] = 1 then b := eg[1] mod n; RemoveSet(lst,b);
            Print(" ",String(a,-8)," with inverse ",b ,"\n");
        fi;
     od;
  fi;
end;

IDA.c2s2p1th1 := function(v)  #solve ax=b mod n
  local nd, hlp, eg;
  if IDA.readint(v[1]) and IDA.readint(v[2]) and  IDA.readint(v[3]) then
        eg := IDA.extgcd([v[1],v[3]]);
        if v[2] mod eg[3] <> 0 then 
            Print(" No solutions, as gcd(",v[1],",",v[3],") does not divide ",v[2],"\n");
        else
            if v[1]=0 and v[2]=0 
               then Print(" Any number is a solution to the trivial equation\n");
           else
               Print(" A solution is\n "); hlp := (eg[1]*v[2]/eg[3]) mod v[3]; nd := v[3]/eg[3];
               Print(hlp  mod v[3],"\n"); 
               Print(" Any other solution differs from this one by a multiple of ",nd,"\n");
           fi;
        fi;
  fi;
end;

IDA.c2s2p2al1 := function(v) #solve ax=b mod n describe all solutions explicitly
  local nd, hlp, i, eg;
  if IDA.readint(v[1]) and IDA.readint(v[2]) and  IDA.readint(v[3]) then
        eg := IDA.extgcd([v[1],v[3]]);
        if v[2] mod eg[3] <> 0 then 
            Print(" No solutions, as gcd(",v[1],",",v[3],") does not divide ",v[2],"\n");
        else
            if v[1]=0 and v[2]=0 
               then Print(" Any number is a solution to the trivial equation\n");
           else
               Print(" The solutions are\n "); 
               hlp := (eg[1]*v[2]/eg[3]) mod v[3]; nd := v[3]/eg[3];
               for i in [0..eg[3]-1] 
                 do Print(" ",(hlp -i*nd) mod v[3]," "); if i mod 10 = 9 then Print("\n"); fi;
               od; Print("\n");
           fi;
        fi;
  fi;
end;

IDA.c2s2p3th1 := function(v) local eg; #CRT: solve x=a1 mod m1, x = a2 mod m2
  if IDA.readint(v[1]) and IDA.readint(v[2]) and IDA.readint(v[3]) and IDA.readint(v[4]) then
        eg := IDA.extgcd([v[2],v[4]]);
        if eg[3] <> 1 then 
            Print(" The moduli ",v[2],", ",v[4]," are not relatively prime.\n");
        else
           Print(" ",(v[1]+(v[3]-v[1])*eg[1]*v[2]) mod (v[2]*v[4]),"\n");
        fi;
  fi;
end;

IDA.intaaryl := function(n,a,i,h)  # input n output n a-ary.
  local hh, ii, nn, ans, q;
  ans := []; ii := i; hh := h; nn := n;
  while ii >= 0 do 
    q := QuotientRemainder(nn,hh)[1]  mod a;
    nn := nn-q*hh;
    Add(ans,IDA.convert(q,a));
    hh := hh/a; ii := ii-1;
  od;
  return(ans);
end;

IDA.intaary := function(n,a) # input n output n a-ary.
  local i, ans, h, q;
  if n = 0 
  then return(['0']) ;
  else   
  ans := []; i := 0; h := a;
  while n >= h do i := i+1;  h := h*a; od;
  h := h/a;
    return(IDA.intaaryl(n,a,i,h));
  fi;
end;



IDA.c2s3p1df1 := function(n,a)  # input n output n a-ary.
   if IDA.readintmin(n,10^10,0) and IDA.readintmin(a,37,0) then
     Print(" ",IDA.intaary(n,a),"\n");
   fi;
end;

IDA.na2int := function(na,a) 
   local ans, l,h, i;
      # input string na and a in {1...36} out
      # output usual integer equal to a-ary na.
   ans := 0; l := Length(na);  h := a^l; i := 0;
   while i<l do h := h/a;     i := i+1;
    ans := ans + IDA.revert(na[i],a)*h;
   od;
   return(ans);
end;


IDA.c2s3p1th1 := function(na,a,b)  # input  a-ary string na 
                                   # output b-ary string equal to a-ary na
   if IsString(na) and a<37 and b<37 then
        Print(" ",IDA.intaary(IDA.na2int(na,a),b),"\n");
   elif a>36 or b>36 then 
        Print("\n Input ",a," or ",b," too big, \n");
        Print(" we can only handle numbers < 37.\n\n");
   else Print("\n Input a string for n, please.\n");
   fi;
end;

IDA.c2s4p1th1 := function(a,p) # input an integer a and a prime p
                               # output row a^i (i=1,...,p)
   local i;
   if IDA.readintmin(p,1000,0) and IDA.readprime(p) then
        Print("\n   i      : ");
        for i in [1..p] do Print(String(i,3)); od;
        Print("\n a^i mod p: ");  
        for i in [1..p] do Print(String(PowerMod(a,i,p),3)); od;
        Print("\n ");
   fi;
end;

IDA.c2s4p2df1 := function(sz)   #input size sz of primes sought for
    #output two primes p, q and two numbers v, w such that v*w = 1 mod (p-1)(q-1).
    local p,q,k,v,w,f,n;
  if sz>8 then Print(" input size too big, keep it less than 9 please\n");
  else
    p := Random([1..10^sz]); 
    if p mod 2 = 0 then p := p+1; fi;
    q := Random([1..10^sz]);
    if q mod 2 = 0 then q := q+1; fi;
    while not(IsPrime(p)) do p := p+2; od;
    while not(IsPrime(q)) do q := q+2; od;
    n := (p-1)*(q-1);
    k := 2; f := Factors(1+k*n);
    while Length(f) = 1  do k := k+1; f := Factors(1+k*n);od;
    v := f[Length(f)-1]; w := (1+k*n)/v;
    Print("\n p = ",p,"   q = ",q,"\n");
    Print("\n v = ",v,"   v = ",w,"\n");
    Print("\n check v*w mod (p-1)(q-1) = ",v*w mod n,"\n");
  fi;
end;

IDA.c2s4p3df2 := function(pq,vw,xm, e)  #input [p,q], [v,w] message xm
                                        #output encoded message c = xm^v mod m, 
                                        #where m=(p-1)(q-1).
    local p, q, m, v, w, n;
    p := pq[1]; q := pq[2]; n := (p-1)*(q-1); m := p*q;
    v := vw[1]; w := vw[2]; 
    if not( IsPrime(p) and IsPrime(q)) 
    then Print("\n At least one of p, q is not prime.\n");
    elif ((v*w) mod n) <> 1 then
         Print("\n vw not equal to 1 mod (p-1)(q-1)\n");
    else if e = 1 then
           Print("\n ", PowerMod(xm,v,m),"\n");
         else 
           Print("\n ", PowerMod(xm,w,m),"\n");
         fi;
    fi;
end;

IDA.rsac2s4ja := function(str,e)
  local a,b,c,d, ans, mes, hlp, lstr, xm, l, j, i, lm, lh, m;
  #chop str into pieces of length 4 for e=1 and 5 else
  if e=1 then lm := 4; else lm := 5; fi;
  lstr := Copy(str); i := 1; l := Length(str);
  mes := [];
  while i <= l-lm+1 do
      hlp := [];
      for j in [i..i+lm-1] do 
          Add(hlp,str[j]);
      od; 
      Add(mes,hlp);
      i := i+lm;
  od;
  if i <= l then
     hlp := [];
     for j in [i..l] do
        Add(hlp,str[j]);
     od;
     for j in [2..lm-l+i] do
        Add(hlp,'0');
     od;
     Add(mes,hlp);
  fi;
  #encode each elt in mes
  ans := "";
  m := 1687397; 
  if e = 1 then
      for xm in mes do
         hlp := IDA.intaary(PowerMod(IDA.na2int(xm,36),11,m),36);
         #pad to right length
         lh := Length(hlp);
         a := "";
         for i in [1..5-lh] do Append(a,"0"); od;
         Append(a,hlp);
         Append(ans, a);
      od;
  else 
      for xm in mes do
         hlp := IDA.na2int(xm,36);
         hlp := PowerMod(hlp,199,m);
         hlp := PowerMod(hlp,2309,m);
         hlp := IDA.intaary(hlp,36);
         lh := Length(hlp);
         #pad or trim to right length
         if lh = 5 then a := Sublist(hlp,[2..5]);
         else a := "";
              for i in [1..4-lh] do Append(a,"0"); od;
              Append(a,hlp);
         fi;
         Append(ans,a);
      od;
  fi;
  return(ans);
end;


IDA.c2s4ja := function(str,e)
  if IDA.readalbecap(str) then
      IDA.mes := IDA.rsac2s4ja(str,e);
      Print(" ",IDA.mes,"\n");
  fi;
end;


IDA.c2s5p2df1 := function(p,g)  #check if g is primitive elt in Z/n
        local i,j,flg,hlp;
        if IDA.readprime(p) then flg := false; j := p-1;
           hlp := g; #Print("\n The subsequent powers of g are:\n");
           for i in [1..p-2] do
              Print(" g^",String(i,-3),"=",String(hlp,3),",");
              if hlp = 1 then flg := true; j := i; fi;
              hlp := (hlp*g) mod p;
              if (i mod 5) = 0 then Print("\n"); fi;
           od;
           Print("\n\n ");
           Print(" Since ",j," is the exponent of the ");
           Print(" first nonzero power of ",g," equal to 1,\n ",g," is ");
           if flg then Print("not"); fi;
           Print(" primitive.\n");
        else
           hlp := Factors(p);
           Print("\n Sorry, ",p," is composite,\n\n ",hlp[1]," is a prime factor.\n");
        fi;
end;

IDA.c2s5p2ft1 := function(n) local hlp; #find primitive elt
        if IDA.readprime(n) then 
            Print(" ",PrimitiveRootMod(n),"\n");
        fi;
end;


IDA.c2s5p3al1 := function(p)  #make detection pattern
        local g, ans, i,j;
        if IDA.readprime(p) then 
           ans := NullMat(p-1,p-1); 
           g := PrimitiveRootMod(p);
           for i in [1..p-1] do j := PowerMod(g,i-1,p);
             ans[i][j] := 1;
           od;
           IDA.printHadmat(ans,false);
        fi;
end;


IDA.c3s1p1df1 := function(f,op)  #list of terms/coeffs/monomials of polynomial f
 local  ans, hlp, clst, i, d, ff, l;
 if IDA.readXpol(f) then ff := IDA.Xpol;
      clst := IDA.pol2coeffs(ff);
      if op=1  then #coefficients case
           IDA.printset(Set(clst),10,0);
      elif op=0 then #terms case
           ans := Set([]);
           for i in [1..Length(clst)] do 
               if clst[i]<>0 then AddSet(ans,clst[i]*X^(i-1)); fi;
           od;
           IDA.printset(ans,10,0);
      else #op=2 monomials case
           ans := Set([]);
           for i in [1..Length(clst)] do 
               if clst[i]<>0 then AddSet(ans,X^(i-1)); fi;
           od;
           IDA.printset(ans,10,0);
      fi;
 fi;
end;



IDA.c3s1p2df1 := function(f,g,n,op)  #sum/product of f+g in Z/n
  local ff, gg;
  if IDA.readint(n) then
    if IDA.readXpol(f) then ff := IDA.Xpol;
      if IDA.readXpol(g) then gg := IDA.Xpol;
        if op = 1 then Print(" ",(ff+gg) mod n,"\n");
         else Print(" ",(ff*gg) mod n,"\n");
         fi;
      fi;
    fi;
  fi;
end;



IDA.c3s2p1df1 := function(f,op) #the degree/leading coefficient of the polynomial f
  local ff;
  if IDA.readXpol(f) then ff := IDA.Xpol;
     if op = 0 then  Print(" ",Degree(ff),"\n");
     else      Print(" ",IDA.pol2coeffs(ff)[Degree(ff)+1],"\n");
     fi;
  fi;
end;

IDA.c3s2p2df1 := function(f,g)  #divisibility of f by g
  local ff, gg, qr;
  if IDA.readXpol(f) then ff := IDA.Xpol;
      if IDA.readXpol(g) then gg := IDA.Xpol;
        if gg=0*X^0 then Print(" division by 0; impossible");
        else 
          qr :=  QuotientRemainder(ff,gg);
          if qr[2] = 0*X^0 then
              Print(" ",gg," divides ",ff, " with quotient ", qr[1],"\n");
          else
              Print(" ",gg," does not divide ",ff, "\n");
          fi;
        fi;
      fi;
  fi;
end;

IDA.c3s2p2th1 := function(f,g)  #division for polys
  local ff, gg, qr;
  if IDA.readXpol(f) then ff := IDA.Xpol;
      if IDA.readXpol(g) then gg := IDA.Xpol;
         if g=0*X^0 then Print(" division by 0; impossible");
         else 
           qr :=  QuotientRemainder(f,g);
           Print(" quotient ", qr[1],"\n");
           Print(" remainder ",qr[2],"\n");
         fi;
      fi;
  fi;
end;


IDA.c3s2p3df1 := function(f,g,op) #gcd and lcm for polynomials
  local ff, gg, qr; 
  if IDA.readXpol(f) then ff := IDA.Xpol;
      if IDA.readXpol(g) then gg := IDA.Xpol;
          if op=0 then Print(" ",Gcd(f,g),"\n");
          else         Print(" ",Lcm(f,g),"\n");
          fi;
      fi;
  fi;
end;

IDA.c3s2p4al1 := function(f,g) #gcd for pols
  IDA.c3s2p3df1(f,g,0);
end;



IDA.c3s2p4al2i := function(f,g) #extended euclidean algorithm for polynomials
  local ff, gg, v; 
  if IDA.readXpol(f) then ff := IDA.Xpol;
      if IDA.readXpol(g) then gg := IDA.Xpol;
         v := [1*X^0,0*X^0,0*X^0,1*X^0,ff,gg];
         Print(" initial pair a,b = \n ", v[5],"\n ",v[6],"\n\n");
         Print(" initial quadruple x,y,u,v =\n ");
         Print(v[1],"\n ",v[2],"\n ", v[3],"\n ",v[4],"\n");
         IDA.v := Copy(v);
      fi;
  fi;
end;


IDA.c3s2p4al2l := function() #stepwise gcd computation
    local q, qr, m, v;
    v := Copy(IDA.v);
    if IsRat(v[5]) then v[5] := v[5]*X^0; fi;
    if IsRat(v[6]) then v[6] := v[6]*X^0; fi;
    if not(IsPolynomial(v[5])) or  not(IsPolynomial(v[6]))
    then Print(" input not a polynomial in X\n");
    else
      if v[6] <> 0*X^0 then
        qr := QuotientRemainder(v[5],v[6]);
        q := qr[1]; 
        m := [[v[1],v[2],v[5]],[v[3],v[4],v[6]]];         
        m :=  ([[0,1],[1,-q]]*X^0) * m;  
        v := [m[1][1],m[1][2],m[2][1],m[2][2],m[1][3],m[2][3]];
        Print(" updated pair a,b =\n ", v[5],", ",v[6],"\n\n");
        Print(" updated quadruple x,y,u,v =\n");
        Print(" ",v[1],", ",v[2],", ", v[3],", ",v[4],"\n");
      else
        Print(" final pair a,b =\n ", v[5],", ",v[6],"\n\n");
        Print(" final quadruple x,y,u,v =\n");
        Print(" ",v[1],", ",v[2],", ", v[3],", ",v[4],"\n");
      fi;
    fi;
    IDA.v := Copy(v);
end;

IDA.c3s3p1df1 := function(f,p) #value of polynomial at p
  if IDA.readXpol(f) then
     if IsRat(p) then
        Print(" ",Value(IDA.Xpol,p),"\n"); 
     else Print(" ",p," is not rational.\n");
          Print(" Evaluate at a rational point please.\n");
     fi;
  fi;
end;


IDA.c3s4p1df1 := function(f) #test if f is irreducible
  local q, qr, m; 
  if IDA.readXpol(f) then
      q := Factors(IDA.Xpol);
      Print(" ", IDA.Xpol);
      if Length(q) > 1 then
         Print(" is reducible,\n");
         Print(" ",q[1]," is a factor.\n");
      else
         Print(" is irreducible.\n");
      fi;
  fi;
end;


IDA.c3s4p1lm1 := function(f,p)  #the product of all distinct linear factors in Z/pZ
  local ans, i;  
  if IDA.readXpol(f) and IDA.readprime(p) then
       ans := 1*X^0;
       for i in [0..p-1] do
         if Value(IDA.Xpol,i) mod p = 0 then ans := ans * (X-i); fi;
       od;
       Print(" ",ans,"\n");
  fi;
end;


IDA.c3s4p3th1 := function(f) #stepwise gcd computation
  if IDA.readXpol(f) then
     IDA.printset(Set(Factors(IDA.Xpol)),1,0); Print("\n");
  fi;
end;

IDA.shiftrec := function(sl,gl,k) #giving recurrence results up to degree k of register sequence
                         #sl = coeffs shift polynomial s0, s1,....sn-1
                         #gl =  coeffs register polynomial g0,...gn-1
   local ans, i, n, l;
   n := Length(sl);
   if k<n then ans := gl[k+1];
   else
      for l in [n..k] do 
          ans := 0;
          for i in [1..n] do 
              ans := ans + sl[n-i+1]*gl[l-i+1];
          od; 
          gl[l+1] := ans;
      od;
   fi;
   return(gl);
end;

IDA.shiftrecstep := function(sl,gl) #giving recurrence results up to degree k of register sequence
                         #sl = coeffs shift polynomial s0, s1,....sn-1
                         #gl =  results up to degree k-1
   local ans, i, n, k;
   n := Length(sl);
   k := Length(gl);
   ans := 0;
   for i in [1..n] do 
       ans := ans + sl[n-i+1]*gl[k-i+1];
   od; 
   gl[k+1] := ans;
   return(gl);
end;


IDA.c3s5p1df1i := function(s,g) #input shift polynomial s and register poly g
                               #output next value at each click . Initialize
  if IDA.readXpol(s) and IDA.readlst(g,1000,0) then
     IDA.lsts := IDA.pol2coeffs(s);
     if Length(g) <> Degree(s)+1 then
        Print(" Please make sure that\n");
        Print(" ",g," has length equal to degree(s) = ",Degree(s),"\n");
        IDA.lstg := IDA.NullVec(Degree(s)+1);
     else
        IDA.lstg := Copy(g);
        Print("\n The shift register is loaded with\n ",g,"\n");
     fi;
  fi;
end;


IDA.c3s5p1df1r := function() #input shift polynomial s and register poly g
                             #output old sequence+next value at each click. Run
   IDA.lstg := Copy(IDA.shiftrecstep(IDA.lsts,IDA.lstg));
   Print("\n ");
   IDA.printset(IDA.lstg,2,2);
   Print("\n");
end;


IDA.shiftpol := function(sl,gl,k) #giving polynomial up to degree k of register sequence
                         #sl = coeffs shift polynomial s0, s1,....sn-1
                         #gl =  coeffs register polynomial g0,...gn-1
   local ans, i, n, l, h, f, t;
   Print(" g = ",Polynomial(Rationals, gl),"\n");
   Print(" s = ",Polynomial(Rationals, sl),"\n");
   f := 0*X^0;
   n := Length(sl);
   for l in [1..n-1] do for i in [1..l] do 
       f := f - sl[n-i+1]*gl[l-i+1]*X^l;
   od; od;
   f := f+ Polynomial(Rationals,gl);
   Print(" f = ",f,"\n");
   t := Polynomial(Rationals, Reversed(sl))*X;
   Print(" t = ",t,"\n");
   ans := X^0;
   h := X^0;
   for i in [1..k] do h := h*t; ans := ans + h; od;
   return(ans*f);
end;

IDA.c3s5p2th1 := function(s,g,k) #input shift polynomial s and register poly g
                               #output next value at each click . Initialize
  if IDA.readXpol(s) and IDA.readlst(g,1000,0) and IDA.readintmin(k,100,0) then
     if Length(g) <> Degree(s)+1 then
        Print(" Please make sure that\n");
        Print(" ",g," has length equal to degree(s) = ",Degree(s),"\n");
        IDA.lstg := IDA.NullVec(Degree(s)+1);
     else
        Print("\n ",IDA.shiftpol(IDA.pol2coeffs(s),g,k+1) mod X^(k+1),"\n");
     fi;
  fi;
end;

IDA.c3s5p3ft1 := function(s) #input shift polynomial s 
                             #output the corresponding transition matrix
  local n;
  if IDA.readXpol(s) then
     n := Degree(s)+1;
     Print("\n");
     IDA.printmat(IDA.companion(X^n-s),3);
  fi;
end;


IDA.shiftperiod := function(s,p) #giving the period of matrix of register sequence
                                 #s = rat poly s0+s1X + ... + s_{n-1}X^(n-1)
                                 #characteristic field of coeffs
   local mm, n;
   n := Degree(s)+1;
   mm := IDA.companion(X^n-s)*Z(p)^0;
   return(Order(GeneralLinearGroup(n,p),mm));
end;


IDA.c3s5p3th1 := function(s,p) #input shift polynomial s  over Z/pZ
                               #output the minimum polynomial and period
  if IDA.readXpol(s) and IDA.readprime(p) then
     if Value(s,0) mod p = 0 then
        Print(" The constant term of s should be nonzero mod ",p,"\n");
     else
        Print("\n The minimum polynomial of A is\n ", X^(Degree(s)+1)-s,"\n");
        Print("\n The order of A is ",IDA.shiftperiod(s,p),"\n");
     fi;
  fi;
end;




IDA.c4s1p1df1 := function(v) #congruence of v[1] and v[2] modulo v[3]
  local v1,v2,v3;
  if IDA.readXpol(v[1]) then v1 := IDA.Xpol;
    if IDA.readXpol(v[2]) then v2 := IDA.Xpol;
      if IDA.readXpol(v[3]) then v3 := IDA.Xpol;
         if QuotientRemainder(v1-v2,v3)[2]=0*X^0
         then  Print(" ",v1," is congruent to ",v2," modulo ",v3,"\n");
         else  Print(" ",v1," is not congruent to ",v2," modulo ",v3,"\n\n");
               Print(" as ",v3," does not divide ",v1-v2,"\n");
         fi;
      fi;
    fi;
  fi;
end;


IDA.c4s1ja1 := function(d) # read input polynomial d
  IDA.readXpol(d); IDA.num := 0;
  Print(" We are now working modulo ",d,"\n");
end;


IDA.c4s1ja2 := function() # print next X^i mod d
  IDA.num := IDA.num + 1;
  Print(" X^",IDA.num," mod (",IDA.Xpol,") = ",PowerMod(X,IDA.num,IDA.Xpol),"\n");
end;


IDA.c4s1p3th1 := function(f,g) #remainder of division of f by g
  local ff, gg, qr;
  if IDA.readXpol(f) then ff := IDA.Xpol;
    if IDA.readXpol(g) then gg := IDA.Xpol;
       if gg=0*X^0 then qr := [ff,gg];
       else 
          qr :=  QuotientRemainder(ff,gg);
       fi;
       Print(" ",qr[2],"\n");
    fi;
  fi;
end;

IDA.c4s2p1df1 := function(v,op) #mod product/sum/inverse v2 mod v3
  local v1, v2, v3, hlp; 
  if IDA.readXpol(v[1]) then v1 := IDA.Xpol;
    if IDA.readXpol(v[2]) then v2 := IDA.Xpol;
      if IDA.readXpol(v[3]) then v3 := IDA.Xpol;
         if op=0 then #prod
           Print(" ",(v1*v2) mod v3,"\n");
         elif op=1 then #sum
           Print(" ",(v1+v2) mod v3,"\n");
         elif op=2 then #inverse
            hlp := IDA.extgcdp([v2,v3]);
            if Degree(hlp[3]) > 0 then
               Print(" ",v2," is not invertible mod ",v3,"\n");
            else Print(" ",hlp[1] mod v3,"\n");
            fi;
         else #quotient
            hlp := IDA.extgcdp([v2,v3]);
            if Degree(hlp[3]) > 0 then
               Print(" ",v2," is not invertible mod ",v3,"\n");
            else Print(" ",(v1*hlp[1]) mod v3,"\n");
            fi;
         fi;
      fi;
    fi;
  fi;
end;

IDA.c4s3p1th1 := function(f,n,op) #evaluate the Taylor series of cos(f)
                                  # to order n
  local f0, ff;
  if IDA.readXpol(f) and IDA.readintmin(n,30,-1) then
     ff := IDA.Xpol;
     f0 := Value(ff,0);
     if op=0 then
          if f0 <> 0 then
             Print("Sorry, f(x) = ",f0," <> 0  at x = 0,\n");
          else      
             Print(Value(IDA.cos(n),ff) mod X^n,"\n");
          fi;
     elif op=1 then
          if f0 <> 0 then
             Print("Sorry, f(x) = ",f0," <> 0  at x = 0,\n");
          else      
             Print(Value(IDA.sin(n),ff) mod X^n,"\n");
          fi;
     elif op=2 then
          if f0 <> 0 then
             Print("Sorry, f(x) = ",f0," <> 0  at x = 0,\n");
          else      
             Print(Value(IDA.exp(n),ff) mod X^n,"\n");
          fi;
     elif op=3 then
          if f0 <>0 then 
             Print("Sorry, f(x) = ",f0," <> 0  at x = 0,\n");
          else
             Print(Value(IDA.logonemin(n),ff) mod X^n,"\n");
          fi;
     else
          if f0 = 0 then
             Print("Sorry, 1/f(x) not defined at x = 0 as f(0) = 0,\n");
          else      
             Print(IDA.polinvXn(ff,n) mod X^n,"\n");
          fi;
     fi;
  fi;
end;

IDA.pol2coeffsl := function(f,l) #return l+1 first coefficients of polynomial
   local i,hlp,clst;
   clst := []; 
   for i in [0..l] do hlp := Value(f,0);
          Add(clst,hlp);
          f := Derivative(f)/(i+1);
   od;
   return(clst);
end;

IDA.pol2coeffsm2 := function(f,l) #return l+1 first coefficients of polynomial mod 2
   local i, j, clst,ff,xx;
   clst := IDA.NullVec(l+1);
   ff := f;
   for i in [0..l] do j := l-i;
     if j = Degree(ff) then ff := ff-Indeterminate(GF(2))^(j); clst[j+1] := 1;
     else clst[j+1] := 0;
     fi;
   od;
   return(clst);
end;



IDA.pol2coeffsl := function(f,l) #give list of coefficients up to coeff of X^l
  local ans, ff, lc, fld, i, j,n,xx;
  fld := f.baseRing;
  ff := Copy(f);
  ans := List([1..l+1], xx -> fld.zero);
  n := Degree(ff);
   while n>=0 do
     lc := LeadingCoefficient(ff);
     ff := ff-lc*Indeterminate(fld)^n;
     if n <= l then  ans[n+1] := lc;
     fi;
     n := Degree(ff);
   od;
  return(ans);
end;



IDA.tpol2coeffs := function(f,l) #return l+1 first Taylor coefficients of polynomial
                                 #integral version
   local i,hlp,clst;
   clst := []; 
   for i in [0..l] do hlp := Value(f,0);
          Add(clst,hlp);
          f := Derivative(f);
   od;
   return(clst);
end;

IDA.tcoeffs2pol := function(fji,xx,yy) # from double array to polynomial integral version
                                       #inverse of IDA.tpol2coeffs
  local i, j, ans;
  ans := 0*z;
  for j in [1..Length(fji)] do
    for i in [1..Length(fji[j])] do
     ans := ans + (fji[j][i]/(Factorial(i-1)*Factorial(j-1)))*xx^(i-1)*yy^(j-1);
    od;
  od;
  return(ans);
end;



IDA.coeffs2pol := function(fji,xx,yy) # from double array to polynomial integral version
                                       #inverse of IDA.pol2coeffs
  local i, j, ans;
  ans := 0*z;
  for j in [1..Length(fji)] do
    for i in [1..Length(fji[j])] do
     ans := ans + fji[j][i]*xx^(i-1)*yy^(j-1);
    od;
  od;
  return(ans);
end;

IDA.pol2ratm2 := function(f) #returns the corresponding rational poly
                             # of the polynomial f mod 2
   local i,ans;
   ans := 0*X;
   i := Degree(f);
   while i>-1 do 
       f := f-Indeterminate(GF(2))^i; ans := ans + X^i;
       i := Degree(f);
   od;
   return(ans);
end;


IDA.c4s2p4th1 := function(d,f) #from poly f in R[X]/(d) to matrix wrt 1, X, ..., X^n-1
  local ans, i, n, ff, dd;
  if IDA.readXpol(d) then dd := IDA.Xpol;
     if IDA.readXpol(f) then ff := IDA.Xpol;
        n := Degree(dd);
        ans := NullMat(n,n);
        for i in [1..n] do
           ans[i] := IDA.pol2coeffsl((ff*X^(i-1)) mod dd,n-1);
        od;
        Print("\n");
        IDA.printmat(TransposedMat(ans),3);
        Print("\n ");
        Print("its determinant is ", DeterminantMat(ans),"\n");
     fi;
  fi;
end;


IDA.c4s2p5th1 := function(d,m) #matrix of projection 
                               #g -> g mod d :Q[X]_<m -> Q[X]_<n
                               # wrt 1, X, ..., X^n-1
  local dl, ans, i, n;
  if IDA.readXpol(d) then dl := IDA.Xpol;
      if IDA.readintmin(m,30,0)  then  
         n := Degree(dl);
         ans := NullMat(m,n);
         for i in [1..m] do
             ans[i] := IDA.pol2coeffsl(PowerMod(X,i-1,dl),n-1);
         od;
         Print("\n");
         IDA.printmat(TransposedMat(ans),2);
         Print("\n ");
      fi;
  fi;
end;



IDA.c4s4p2th1 := function(d,p) #all about inv elts in Z/p[X]/(d) up to scalar mults
local dl, i,n, fcts,l;
if IDA.readprime(p) then
   if IDA.readXpol(d) then dl := IDA.Xpol;
       dl := IDA.MakeFFEPol(dl,p);
       n := Degree(dl); fcts := Factors(dl);
       if Length(fcts) = 1 
       then  Print(" ",d," is irreducible in Z/",p,"Z[X], so\n");
             Print(" all nonzero elements are invertible\n");
       else fcts := Set(fcts); l := Length(fcts);
             Print(" The irreducible factors of ",d," are:\n ");
             for i in [1..l] do 
                  Print("  ",IDA.MakeRatPol(fcts[i],p),",  ");
                  if i= (0 mod 3) then Print("\n"); fi;
             od;
             Print("\n so an element is invertible iff\n");
             Print(" it is not a multiple of any of these.\n\n");
       fi;
   fi;
fi;
end;

IDA.c4s4p2co1 := function(d,p,f) #find inverse of f in Z/p[X]/(d)
local hlp, dl, fl,n;
 if IDA.readprime(p) then
   if IDA.readXpol(d) then dl := IDA.Xpol;
     if IDA.readXpol(f) then fl := IDA.Xpol;
       dl := IDA.MakeFFEPol(dl,p);       fl := IDA.MakeFFEPol(fl,p);
       n := Degree(dl); 
       hlp := IDA.extgcdpmod([fl,dl],p);
       if Degree(hlp[3]) > 0 then
            Print(" ",f," is not invertible mod ",d,"\n");
       else Print(" 1/(",f,") = ", IDA.MakeRatPol(hlp[1] mod dl,p),"\n");
            Print(" in Z/",p,"Z[X]/(",d,")\n");
       fi;
     fi;
   fi;
 fi;
end;

IDA.c4s4ja := function(f,g,op) #arithmetic for two elts of F2^n
  local ans, n, ff, gg, fl, gl, fp, gp, hp, hh, d, xx;
  if IDA.readbinword(f) then ff := Copy(IDA.binword);
     if IDA.readbinword(g) then gg := Copy(IDA.binword);
       n := Length(f);
       if n <> Length(g) then
         Print(" f and g should have equal length\n");
       else
         d := Polynomial(GF(2),MinPol(GF(2^n),Z(2^n)));
         fp := Polynomial(GF(2),ff);
         gp := Polynomial(GF(2),gg);
         if op = 1 then hp := fp+gp;
         elif op =2 then   hp := (fp*gp) mod d;
         else if gp = 0*Indeterminate(GF(2)) then Print(" Cannot divide by 0\n"); 
              else hp := IDA.extgcdpmod([gp,d],2)[1]; 
                   hp := (fp * gp) mod d;
              fi;
         fi;  
         ans := IDA.pol2coeffsm2(hp,n-1);
         hp := "";
         for xx in ans do Append(hp,String(xx)); od;
         Print(" ",hp,"\n");
      fi;
    fi;
  fi;
end;

IDA.c4s5p1th1 := function(d,p,f) #find period of f in Z/p[X]/(d)
local hlp, dl, fl,n,i;
 if IDA.readprime(p) then
   if IDA.readXpol(d) then dl := IDA.Xpol;
     if IDA.readXpol(f) then fl := IDA.Xpol;
       dl := IDA.MakeFFEPol(dl,p);       fl := IDA.MakeFFEPol(fl,p);
       n := Degree(dl); 
       hlp := IDA.extgcdpmod([fl,dl],p);
       if Degree(hlp[3]) > 0 then
            Print(" ",f," is not invertible mod ",d,"\n");
       else i := 1; hlp := fl mod dl; 
          while not( hlp = Indeterminate(GF(p))^0) do
                i := i+1; hlp := (hlp*fl) mod dl;
          od;
          Print("\n period: ",i,"\n");
          Print("\n 1/(",f,") = (",f,")^",i-1);
          Print(" = ",IDA.MakeRatPol(PowerMod(fl,i-1,dl),p),"\n");
       fi;
     fi;
   fi;
 fi;
end;



IDA.c4s5p1ft1 := function(p,dg)  #input dg and prime p output irr pol of degree dg over GF(p)
  local ff;
  if IDA.readprime(p) then
    if IDA.readintmin(dg, LogInt(65500,p),0) then
        ff := Polynomial(GF(p),MinPol(GF(p^dg),Z(p^dg)));
        Print(IDA.MakeRatPol(ff,p),"\n");
    fi;
  fi;
end;



IDA.c4s5p2ft1 := function(d,p)  #input irr. pol d over GF(p), output pri elt
  local ff, dd;
  if IDA.readprime(p) then
    if IDA.readXpol(d) then 
       dd := Copy(IDA.Xpol);
       dd := IDA.MakeFFEPol(dd,p); 
       ff := Factors(dd);
       if Length(ff)>1 then  
          Print(" Sorry, polynomial f = ",IDA.MakeRatPol(dd,p)," is reducible.\n");
       else 
          Print(" ",IDA.MakeRatPol(IDA.FindPriPol(dd,p),p),"\n");
       fi;
    fi;
  fi;
end;


IDA.c4s5ja := function(p,dg)  #input degree dg over GF(p), output add table
  local q, i, j, ct, hlp, fnd;
  if IDA.readprime(p)  and IDA.readintmin(dg,LogInt(65500,p),0) then
        q := p^dg; #Print(q,"\n");
        if q>27 then 
           Print(" Sorry, field of size ",q,", too big; keep it of size at most 27.\n");
        else 
          Print(" +");
          for i in [1..q-1] do Print(" ",IDA.albe[i]); od; Print("\n");
          for i in [1..q-1] do Print(" ",IDA.albe[i]);
           for j in [1..q-1] do hlp := Z(q)^i+Z(q)^j;
             fnd := false; ct := 0;
               while not(fnd) and ct<q do 
                 ct := ct+1; 
                 if hlp = Z(q)^ct then Print(" ",IDA.albe[ct]); fnd := true; fi;
               od; 
               if not(fnd) then Print(String(0,2)); fi;
           od; Print("\n");
          od; Print("\n");
        fi;
  fi;
end;


IDA.c4s6p1df1 := function(s, flg)  #input string s and flag flg,
                                   #output encoding according to recipee flg
 local l, q, r, i, j, ct, hlp, ans, ch;
 if IDA.readstring(s) then
   Print("\n ");
   if flg = 1 then ans := [];
          for i in s do Append(ans,[i,i]); od; 
          Print(" ",ans,"\n");
   elif flg = 2 then hlp := 0;
      i := 0; l := Length(s);
      r := l mod 7; q := Int(l/7); ans :=[];
      for j in [0..q-1] do 
        hlp := 0;
        for i in [1..7] do ct := 7*j+i;
          ch := s[ct];
          if not(ch in IDA.albecap) and not(ch = '0')
           then Print(ch, " is a nondigit character, treated as zero\n");
             ch := '0';
          fi;
          hlp := (hlp + IDA.na2int([ch],36)) mod 36;
          Add(ans,s[ct]);
        od;
        Add(ans,IDA.convert(hlp,36));
      od;
      hlp := 0;
      for i in [1..r] do ct := 7*q+i;
          ch := s[ct];
          if not((ch in IDA.albecap) or ch = '0') 
          then Print(ch," is not a valid character, treated as zero\n");
             ch := '0';
          fi;
          hlp := (hlp + IDA.na2int([ch],36)*i) mod 36;
          Add(ans,s[ct]);
      od;
      if r>0 then
        for i in [r+1..7] do Add(ans,' '); od;
        Add(ans,IDA.convert(hlp,36));
      fi;
      Print(ans,"\n");
   elif flg = 3 then hlp := 0;
      i := 0; l := Length(s);
      if not(l=9) then
            Print(" Sorry, ",l," is not the right length for ISBN\n");
            Print(" need length ",9," here\n");
      else
          hlp := 0; ans := [];
          for i in [1..9] do
            ch := s[i];
            if not(ch in Set(IDA.albecap))  and not(ch = '0')
            then Print(ch , " is a nonvalid character, treated as zero\n");
               ch := '0';
            fi;
            hlp := (hlp + IDA.na2int([ch],11)*i) mod 11;
            Add(ans,s[i]);
          od;
          ct := IDA.convert(hlp,11);
          if ct = 'A' then ct := 'X'; fi;
          Add(ans,ct);
          Print(ans,"\n");
      fi;
   else Print(" Sorry, flag ",flg," unknown.\n");
   fi;
 fi;
end;


IDA.c4s6p2df1 := function(p,m)  #input matrix m over GF(p), output dim of row space
local k, n, v, b,hlp;
if IDA.readprime(p) then
   if IDA.readmat(m) then
        hlp := DimensionsMat(m);
        n := hlp[2];
        v := RowSpace(GF(p), m*Z(p)^0);
        b := Base(v);
        k := Length(b);
        Print("\n k = ",k,"\n");
  fi;
fi;
end;

IDA.c4s6p2df2 := function(p,m)  #input matrix m over GF(p), 
                                #output dim of row space and minimal distance
local k, c0, n, v, b, hlp, md, cc, wt, mv;
 if IDA.readprime(p) then
   if IDA.readmat(m) then   
        hlp := DimensionsMat(m);
        n := hlp[2]; md := n;
        if p^n>1000 then Print(" Sorry,please keep p^dim(m) = ",p^n," smaller than 1000.\n");
        else
          v := RowSpace(GF(p), m*Z(p)^0);
          b := Base(v);
          mv := b[1];
          k := Length(b);
          c0 := IDA.NullVec(k);
          cc := Copy(c0); cc[k] := 1;
          while cc <> c0 do 
             hlp := [cc*Z(p)^0] * b;
             hlp := hlp[1];
             wt := IDA.Weight(hlp,p,n);
            if wt < md then md := wt; mv := hlp; fi;
            cc := IDA.NextVec(cc,p,k);
          od;
          Print("\n (n,k,d) = (",n,",",k,",",md,")\n");
#         Print("\n vector of minimal distance to 0:\n");
#         hlp := [mv*Z(p)^0] * b;
#         Print("    ",hlp[1],"\n");
        fi;
    fi;
 fi;
end;

IDA.c4s6p3df1i := function(n)  #factor X^n-1 
 local lst, i;
 if IDA.readintmin(n,100,0) then
     lst := List(Set(Factors(Indeterminate(GF(2))^n-Z(2)^0)),IDA.pol2ratm2);
     for i in [1..Length(lst)] do
        Print("\n ",String(i,3),": ",lst[i],"\n");
     od;
 fi;
end;


IDA.c4s6p3df1 := function(n,k,bch)
                             #input natural number n, factor no. k of X^n-1 factorization
                             #dim of row space and minimal distance
                             #if bch=1 also bch bound is given
local ff, g, gg, i, kk, cycn, m, bchb, x2;
  if IDA.readintmin(n,100,0) and IDA.readintmin(k,100,0) then
      cycn := Indeterminate(GF(2))^n-Z(2)^0;
      ff := Factors(cycn);
      if not(k in [1..Length(ff)]) then
        Print("\n Sorry, ",k," is not a valid number\n");
      fi;
      g := ff[k]; gg := g;
      kk := n-Degree(g);
      m := NullMat(kk,n);
      for i in [0.. kk-1] do
        gg  := (g*Indeterminate(GF(2))^i) mod cycn;
        m[i+1] := IDA.pol2coeffsm2(gg,n-1);
      od;
#      Print(" The code is generated by the rows of the matrix\n");
#      IDA.printmat(m,1);
#      Print("\n Its parameters are:\n");
      if bch=1 then
        x2 := Indeterminate(GF(2));
        bchb := 1;
        while Value(g,x2^bchb) = 0*x2 do bchb := bchb+1; od;
        Print(" the BCH bound is ",bchb,".\n");
      fi;
      IDA.c4s6p2df2(2,m);
  fi;
end;



IDA.c4s6p4th1p := function(n,k)  #describe k-th factor g of X^n-1
                                 #and decoding poly h=(X^n-1)/g
                                 #g,h stored in global vars 
                                 #IDA.codeg and IDA.codeh
local ff, i, cycn, m;
  if IDA.readintmin(n,100,0) and IDA.readintmin(k,100,0) then
      cycn := Indeterminate(GF(2))^n-Z(2)^0;
      ff := Factors(cycn);
      if not(k in [1..Length(ff)]) then
        Print("\n Sorry, ",k," is not a valid number\n");
      else
        IDA.codeg := ff[k]; IDA.codeh := cycn/IDA.codeg;
        Print("\n g = ",IDA.pol2ratm2(IDA.codeg),"\n");
        Print("\n h = ",IDA.pol2ratm2(IDA.codeh),"\n");
      fi;
  fi;
end;


IDA.c4s6p4th1c := function(w) #encode w using IDA.codeg and IDA.codeh
 local ans, i, cycn, m, g, k, n, ww, xx;
 if IDA.readbinword(w) then ww := Copy(IDA.binword);
  if ww <> 0 then 
    g := IDA.codeg; n := Degree(g)+Degree(IDA.codeh);
    cycn := Z(2)*(Indeterminate(GF(2))^n-1);
    k := n-Degree(g); 
    if g*IDA.codeh <> cycn then 
       Print("\ Sorry, g and h are not in phase\n");
    elif k <> Length(ww) then  
        Print("\ Sorry, input string does not have length ",k,"\n");
    else
      m := NullMat(k,n);
      for i in [0..k-1] do
        g  := (IDA.codeg*(Indeterminate(GF(2))^i)) mod cycn;
        m[i+1] := IDA.pol2coeffsm2(g,n-1);
      od;
      ans := List( ww*m, xx -> xx mod 2); 
      Print("\n ");
      for i in ans do Print(i); od;
      Print(".\n");
    fi;
  fi;
 fi;
end;

IDA.c4s6p4th1d := function(c) #decode c using IDA.codeg and IDA.codeh
  local ans, i, cycn, h, k, n, cc, ccp;
  if IDA.readbinword(c) then cc := Copy(IDA.binword);
   if cc <> 0 then
    h := IDA.codeh; n := Degree(IDA.codeg)+Degree(h);
    cycn := Z(2)*(Indeterminate(GF(2))^n-1);
    k := n- Degree(IDA.codeg); 
    if IDA.codeg*h <> cycn then 
       Print("\ Sorry, g and h are not in phase\n");
    elif n <> Length(cc) then  
        Print("\ Sorry, input string does not have length ",n,"\n");
    else
      ccp := Polynomial(GF(2),cc);
      ccp := ccp * h;
      if (ccp mod (Indeterminate(GF(2))^n-Z(2))) <> 0*Z(2)*Indeterminate(GF(2))^0 then 
        Print("\n the input ",c," is not a code word,");
        Print(" but most likely"); 
      fi;
      ans := IDA.pol2coeffsm2(ccp mod Indeterminate(GF(2))^n,k-1);
      Print("\n ");
      for i in ans do Print(i); od;
      Print(".\n");
    fi;
   fi;
  fi;
end;


IDA.c5s1p1df1 := function(sa)  #f injective?
  local m, n, i, j;
  if IDA.readlst(sa,6,0) then
    if  Length(Set(sa)) = Length(sa) then
        Print(" The function ",sa," is injective.\n");
    else
        for i in [1..5] do 
            for j in [i+1..5] do
                if sa[i] = sa[j] then m := i; n := j;  fi;
            od;
        od;
        Print(" The function ",sa," is not injective,\n");
        Print(" as ",m," and ",n," have the same image.\n");
    fi;
  fi;
end;


IDA.permprodl := function(pi,sigma) #product of perms pi and sigma 
                                    #pi and sigma in list form of same length
local ans, i;
  ans := [];
  for i in sigma do Add(ans,pi[i]); od;
  return(ans);
end;

IDA.c5s1p2df1 := function(g,h)  #product of g and h in list form
 if IDA.readprmlst(g) and IDA.readprmlst(h) then 
    if  Length(g) = Length(h) then
        Print(" ",IDA.permprodl(g,h),"\n"); 
    else
        Print(" Sorry, g, h should have the same length.\n");
    fi;
 fi;
end;


IDA.c5s1p3th1 := function(n)  #order of Sn, some elements
 local i, lst, hlp;
 if IDA.readintmin(n,40,0) then
    hlp := Factorial(n);
    Print(" Order: ",hlp,"\n\n"); 
    lst := Copy([1..n]);
    if n>4 then  Print(" The alphabetically first 10 elements:\n"); hlp := 10;
    else  Print(" The elements:\n"); 
    fi;
    for i in [1..hlp] do
        Print(" ",lst,"\n"); lst := IDA.NextPerm(lst);
    od;
 fi;
end;

IDA.c5s2p1df1 := function(gelt)  #fixed pts and support.
 local n, i, lstf, lsts, hlp;
 if IDA.readprm(gelt) then
   lstf := []; lsts := [];
   IDA.grpelt := ListPerm(IDA.grpelt);
   n := Length(IDA.grpelt);
   for i in [1..n] do 
     if IDA.grpelt[i] = i then Add(lstf,i); else Add(lsts,i); fi;
   od;
   Print(" Fixed point set: ", lstf,"\n\n");
   Print(" Support: ", lsts,"\n");
 fi;
end;

IDA.c5s2p2df1 := function(cyc)  #input permutation cyc in disjoint cycles form, 
                                #output permutation in list form
 if IDA.readprmcyc(cyc) then
   Print(" ", List(cyc),"\n\n");
 fi;
end;

IDA.c5s2p3pr1 := function(perm)  #input permutation in list form,
                                 #output permutation in disjoint cycles form
 if IDA.readprmlst(perm) then
   Print(" ", PermList(perm),"\n\n");
 fi;
end;

IDA.c5s2p3df1 := function(perm)  #input permutation in list form, output cycle structure
 local ans;
 if IDA.readprmlst(perm) then
   ans := CycleLengths(IDA.grpelt,[1..Maximum(perm)]);
   Sort(ans);
   Print(" The disjoint cycles form of the permutation is\n");
   Print(" ",List(perm),",\n so its cycle structure is\n");
   ans :=  Reversed(ans);
   Print(" ");
   IDA.printset(ans,10,2);
   Print("\n\n");
 fi;
end;


IDA.c5s2p4lm1 := function(g,h)  #input permutations g, h, output ghg^-1
 local gg, hh, ans; 
 if IDA.readprm(g) then     gg := Copy(IDA.grpelt);
   if IDA.readprm(h) then   hh := Copy(IDA.grpelt);
      ans := hh*gg*hh^(-1);
      Print(" in disjoint cycles form:\n ", ans ,"\n");
      Print(" in list form:\n ", List(ans) ,"\n");
   fi;
 fi;
end;

IDA.noofcycstr := function(gg,m) #number of permutations with given cycle structure
  local ans, i, l, ct, prod, setsize, ki;
    prod := Reversed(CycleLengths(gg,[1..m]));
    ans := 1;  setsize := m; #was Length(List(gg));
    i := 1; l := Length(prod); 
    while i<=l do ct := i;  ki := prod[i];
      while ct<=l and ki = prod[ct] do
         ct := ct + 1;
         ans := ans * Binomial(setsize,ki)*Factorial(ki-1);
         setsize := setsize-ki; 
      od;
      ans := ans/Factorial(ct-i);
      i := ct; 
    od;
  return(ans);
end;

IDA.c5s2p4pr1 := function(n, perm)  #input a permutation in Sn, 
                                    #output the number of permutations in Sn
                                    #with same cycle structure
 if IDA.readintmin(n,100,0) and IDA.readprm(perm) then
   if n <  PermGroupOps.LargestMovedPoint(Group(IDA.grpelt)) then
      Print(" Sorry,\n the largest moved point ");
      Print(PermGroupOps.LargestMovedPoint(Group(IDA.grpelt)),"\n");
      Print(" exceeds n = ",n,"\n");
   else
      Print(" ",IDA.noofcycstr(IDA.grpelt,n),"\n");
   fi;
 fi;
end;


IDA.lperm2cyc := function(sig) #turn list sig into a product of 2 cycles
local n, p, yy, s;
  s := sig;
  p := []; n := Length(s);
  while n>0 do
    if s[n] <> n then
      Add(p, [n,s[n]]);
      yy := 1; 
      while s[yy] <> n do yy := yy+1;   od;
      s[yy] := s[n];
    fi;
    n := n-1;
  od;
  return(p);
end;


IDA.c5s2p5th1 := function(g)  #input a permutation,
                              #output product of 2-cycles
 local gg, p, i;
 if IDA.readprm(g) then gg := Copy(IDA.grpelt);
     p := IDA.lperm2cyc(List(gg));  Print(" "); 
     for i in [1.. Length(p)] do 
        Print("(",p[i][1],",",p[i][2],")");
        if (i mod 7) = 0 then Print("\n "); fi;
     od;
     Print("\n");
 fi;
end;

IDA.lperm3cyc := function(sig) #turn list sig into a product of 3 cycles
local n, p, p2, a, b, ii;
  p := []; 
  p2 := Reversed(IDA.lperm2cyc(sig));
  n := Length(p2);
  while n>0 do
     ii := Intersection(p2[n-1],p2[n]);
     if Size(ii)  = 1 then 
       a := Set(p2[n-1]); RemoveSet(a,ii[1]);
       b := Set(p2[n]); RemoveSet(b,ii[1]);
       Add(p, [a[1],b[1],ii[1]]);
     elif Size(ii) = 0 then
       Append(p, [[p2[n-1][1],p2[n-1][2],p2[n][1]],[p2[n-1][2],p2[n][1],p2[n][2]]]);
     fi;
     n := n-2;
  od;
  return(p);
end;

IDA.c5s3p1df1 := function(p)  #sign of a permutation
  if IDA.readprm(p) then Print(" ",SignPerm(IDA.grpelt),"\n"); fi;
end;


IDA.c5s3p2co1 := function(p)  #writing permutation p as a product of disjoint cycles
                              #and computing the sign
                              #see IDA.lperm2cyc and 525th1 for other possibilities
 local ans, hlp, m, i, pp;
 if IDA.readprm(p) then
    pp := Copy(IDA.grpelt); 
    if pp = () then Print("\ sgn(g) = sgn(identity) = ",1,"\n");
    else
       hlp := List(Orbits(Group(pp),[1..Maximum(List(pp))]),Length);
       Print("\ sgn(g) = sgn(",pp,") = "); ans := 1;
       for i in [1..Length(hlp)] do 
           if hlp[i] <> 1 then 
              m := (-1)^((hlp[i]+1) mod 2);
              if m=1 then Print("(1)"); else Print("(-1)"); fi; 
              if (i mod 7) = 0 then Print("\n");fi;
              ans := ans * m;
           fi;
       od; Print(" = ", String(ans,3),"\n");
    fi;
 fi;
end;

IDA.c5s3p3th1 := function(n)  #order of An, some elements
 local i, lst, hlp;
 if IDA.readintmin(n,100,0) then
    if n=1 then hlp := 1; else  hlp := Factorial(n)/2; fi;
    Print(" Order: ",hlp,"\n\n"); 
    lst := Copy([1..n]);
    if n>4 then  Print(" The alphabetically first 10 elements:\n"); hlp := 10;
    else  Print(" The elements:\n"); 
    fi;
    for i in [1..hlp-1] do
        Print(" ",lst,"\n"); lst := IDA.NextPerm(lst);
        while SignPerm(PermList(lst)) = -1 do lst := IDA.NextPerm(lst); od;
    od;
    Print(" ",lst,"\n");
 fi;
end;


IDA.c5s3p4th1 := function(prm)  #input a permutation prm, 
                                #output product of 3-cycles
 local gg, p, i, ok;
 if IDA.readprm(prm) then
    gg := Copy(IDA.grpelt); 
    if SignPerm(gg) = -1 then
      Print("\n The input permutation is odd, sorry.\n");
      Print("\n Multiply by (1,2) to get an even permutation.\n");
    else
      p := IDA.lperm3cyc(List(gg));  Print(" "); 
      for i in [1..Length(p)] do 
         Print("(",p[i][1],",",p[i][2],",",p[i][3],")");
         if (i mod 5) = 0 then Print("\n "); fi;
      od;
      Print("\n");
    fi;
 fi;
end;


IDA.catalancheck := function(str)
 local ct, a, b, ok, i, n;
 a := str[1];
 n := Length(str);
 i := 1; ok := true; ct := 0;
 #look for second char
 while i <= n and str[i] = a do i := i+1; ct := ct+1; od;
 b := str[i]; ct := ct-1;
 while i < n and ok and ct >= 0 do 
   i := i+1;
   if str[i] <> a then 
      if str[i]<>b then ok := false; 
         Print(" more than 2 characters in string\n"); return(false);
      else ct := ct-1;
      fi;
   else ct := ct+1;
   fi;
 od;
 if ct <> 0 then ok := false;
    Print(" string not balanced\n"); return(false);
 fi;
 return(true);
end;

IDA.assop := function(fji) # input poly-mat in x,y in Z[x][y][z]
                         # output yes/no associative operation on ZxZ
  local fxy, fxfyz, ffxyz, fyz;
  #lhs
  Print(" computing f(x,f(y,z))\n");
  fyz := IDA.coeffs2pol(fji,y,z);
  fxfyz := IDA.coeffs2pol(fji,x,fyz);
  Print(" = ");
  if IDA.readxyzpol(fxfyz) then
     IDA.printxyzpol(IDA.xyzpol,"x","y","z");
  fi;
  Print("\n\n");
  #rhs
  Print(" computing f(f(x,y),z)\n");
  fxy := IDA.coeffs2pol(fji,x,y);
  ffxyz := IDA.coeffs2pol(fji,fxy,z);
  Print(" = ");
  if IDA.readxyzpol(ffxyz) then
     IDA.printxyzpol(IDA.xyzpol,"x","y","z");
  fi;
  Print("\n\n");
  Print("f(x,f(y,z)) =?= f(f(x,y),z): ", fxfyz = ffxyz,"\n");
end;

IDA.c6s1p2df1 := function(f) #test associativity for a polynomial map ZxZ -> Z
  if IDA.readxypol(f) then IDA.assop(IDA.xypol); fi;
end;


IDA.c6s1p3df1 := function(a,b) #composition in Mn
  local l, i;
  if IDA.readlst(a,1000,0) and IDA.readlst(b,1000,0) then l := Length(a);
     if l = Length(b) then 
        if Maximum(a) <= l and Maximum(b) <= l then
           Print(" [");
           for i in [1..l-1] do Print(a[b[i]],","); 
           od;
           Print(a[b[l]],"]\n"); 
        else   
           Print(" Sorry, a and b should not contain components greater than n = ",l,"\n");
        fi;
     else Print(" The lengths of a and b differ\n");
     fi;
  fi;
end;

IDA.commop := function(fji) # input poly in x,y in Z[x][y][z]
                            # output yes/no commutative operation on ZxZ
  local fxy, fyx, fxi;
  #rhs
  fxy := Value(IDA.coeffs2pol(fji,x,y),0*Indeterminate(Rx));
  Print(" f(x,y)\n");
  Print(" = "); IDA.printxypol(fji,"x","y"); Print("\n\n");
  #lhs
  Print("computing f(y,x)\n");
  fyx := Value(IDA.coeffs2pol(fji,y,x),0*Indeterminate(Rx));
  Print(" = "); IDA.printxypol(fji,"y","x"); Print("\n\n");
  Print("f(y,x) =?= f(x,y): ", fyx = fxy,"\n");
end;



IDA.c6s1p5df1 := function(f) #given polynomial in Z[x,y] check if it defines
                             #a commutative binary operation
  if IDA.readxypol(f) then IDA.commop(IDA.xypol); fi;
end;


IDA.c6s2p3df1r := function(str) #add a newly produced balanced bracketing of 
                                #given length
 local ans, i, j, k, h, hlp;
 if IDA.readstring(str) then
   if IDA.catlength <> Length(str) then 
     Print(" element does not have the required length\n");
   else
     if IDA.catalancheck(str) then
      if str in IDA.catbatch then
        Print(" This element is already known\n "); 
      else Add(IDA.catbatch,str);
         Print(" added ", str," to the list, \n");
         h := Length(IDA.catbatch);
         Print(" that makes ",h," element");
         if h>1 then Print("s");fi; Print("\n");
         if h = IDA.catno then
            Print(" Congratulations!! You found them all\n");
         else
           Print(" Still ", IDA.catno-h," more to find\n");
         fi;
      fi;
     fi;
   fi;
 fi;
end;

IDA.catalanno := function(n) return(Binomial(2*n,n)/(n+1));
end;

IDA.c6s2p3df1n := function(n)
  local a,b,str,ans,i,j,k,h;
  if IDA.readintmin(n,20,0) then
    if (n mod 2) = 0 then
      IDA.catbatch := [];
      IDA.catlength := n;
      IDA.catno := IDA.catalanno(n/2);
      Print(" There are ",IDA.catno," elements of length ",IDA.catlength,"\n");
      Print(" Can you find them all??\n");
    else
      Print(" There are no elements of odd length.\n");
    fi;
  fi;
end;


IDA.c6s2p4df1 := function(lst) #given a permutation in list form determine its image on pairs
  local ans, g, i,j,k,n,l,ct;
  if IDA.readlst(lst,100,0) and IDA.readprm(lst) then 
     g := Copy(IDA.grpelt);
     n := Length(lst);
     ans := [];
     ct := 0;
     for i in [1..n] do for j in [i+1..n] do
           ct := ct+1;
           k := OnPairs([i,j],g);
           if k[1] > k[2] then l := k[2];k[2] := k[1];k[1] := l;fi;
           ans[((j-1)^2-(j-1))/2 + i] := ((k[2]-1)^2-(k[2]-1))/2 + k[1];
     od; od;
     Print(" ",ans,"\n");
     Print(" here the points are numbered as follows\n");
     for i in [1..n] do for j in [i+1..n] do
         Print(" ",((j-1)^2-(j-1))/2 + i,": ",[i,j],"\n");
      od; od;
  fi;
end;

IDA.submonoid := function(lst,flg) #given a list of maps in Mn in list form, determine 
                                   #if flg =0 the submonoid it generates
                                   #if flg =1 also the invertible elements 
                                   #          of the submonoid it generates
                                   #if flg =2 whether  the submonoid is a group
  local ans, i, n, ln, lc, pows, new, hlp, nf, e, h, nnew, ni, xx;
  if IsList(lst) then
       ln := Length(lst);
       if ln = 0 then Print(" {e}\n");
       else n := Length(lst[1]);
         nf := true;
         #check if all elts have same length
         i := 0; e := List([1..n], xx -> xx);
         while nf and i<ln do i := i+1;
           hlp := lst[i];
           if IDA.readlst(hlp,n+1,0) then
              if Length(lst[i]) <> n then nf := false;
                 Print(" Can't handle the input:\n");
                 Print(" the ",i,"-th map has length\n");
                 Print(" different from the previous one\n");
              fi;
           else nf := false;
           fi;
         od;
         if nf then
           #start creating the full set of elements of the submonoid
           #in pows
           ni := 0;
           pows := Set([e]); #<p><I>S</I> := {<I>e</I>}; 
           new := Set(Copy(lst));
           AddSet(new,e);   # N = D;
           lc := 0;
           while Length(new) >0 do # N is not empty 
               lc := lc +1;
               Print(" ",lc,"-th while loop pass:\n");
               for xx in new do Print(" ",xx);
                   if flg>0 then 
                       if  Length(Set(xx)) = n then
                       Print(", invertible with inverse ",PermList(xx)^(-1)); 
                       ni := ni+1;
                       fi;
                   fi;
                   Print("\n");
               od;
               Append(pows,new); # S := S cup N;
               pows := Set(pows);
               #buildup cup_{x in D} xN
               nnew := [];  hlp := [];
               for h in lst do 
                 for xx in new do
                   #compute x h
                   hlp := List([1..n], i -> h[xx[i]]);
                   Add(nnew,hlp);
                 od;
               od;
               Append(new,nnew);
               new := Set(new);
               for xx in pows do RemoveSet(new,xx); od;
               # N = cup_{x in D} xN\S;
           od;
           Print(" Size = ",Length(pows),"\n");
           if flg>0 then Print(" of which ", ni," are invertible\n"); fi;
           if flg=2 then 
              if Length(pows) = ni then
                 Print(" so the submonoid is a group\n");
              else 
                 Print(" so the submonoid is not a group\n"); 
              fi;
           fi;
         fi;
     fi;
  else Print(" Sorry, ",lst," is not a list\n");
  fi;
end;

IDA.c6s2p5th1 := function(lst) #given a list of maps in Mn in list form, determine 
                               #the submonoid it generates
  IDA.submonoid(lst,0);
end;

IDA.c6s2p5th2 := function(lst) #given a map in Mn in list form determine 
                               #the cyclic submonoid it generates
  local ans, g, i, k, n, l, pows, new, hlp, nfnd, nf, e;
  if IDA.readlst(lst,40,0) and IDA.readlst(lst,Length(lst)+1,0) then
       n := Length(lst);
       nf := true;
       i := 0; e := [];
       while nf and i<n do i := i+1; e[i] := i;
         if lst[i]>n then nf := false;
            Print(" Can't handle the input:\n");
            Print(" the ",i,"-th component is bigger than the length\n");
         fi;
       od;
       if nf then
         nfnd := true;
         k := 0; l := 0;
         new := Copy(e); 
         hlp := [];
         pows := [e];
         while nfnd do
           #make next elt, called new
           for i in [1..n] do hlp[i] := new[lst[i]]; od;
           new := Copy(hlp);
           #search if it is already in the list
           i := 0;
           g := Length(pows);
           while nfnd and  i<g do 
              i := i+1;
              if pows[i] = hlp then k := i-1; l := Length(pows)-k; 
                   nfnd := false;
              fi; 
           od;
           #continue with new added
           Add(pows,new);
         od;
         Print(" k,n = ",k,",",l,"\n");
       fi;
  fi;
end;



IDA.c6s3p2th2 := function(lst) #given a list of maps in Mn in list form, determine 
                               #the invertible elements of the submonoid it generates
  IDA.submonoid(lst,1);                                
end;


IDA.c6s3p1df1 := function(lst) #given map in M_n decide if invertible.
  local ans,i;
  if IDA.readprmlst(lst) then 
        ans := [];
        for i in [1..Length(lst)] do
           ans[lst[i]] := i; 
        od;
        Print(" The map is invertible with inverse ",ans,"\n");
  else  Print(" Hence not invertible\n");
  fi;
end;


IDA.c6s3p3df1 := function(q) #Euler indicator
   local ans,i; 
   if IDA.readintmin(q,1000,0) then
     Print(" The list of numbers\n");
     Print(" less than or equal to ",q,"\n and prime to it is: \n\n");
     ans := []; i := 0; 
     while i < q do i := i+1;
        if Gcd(i,q) = 1 then Add(ans,i) ; fi;
     od;
     Print(" ",ans,"\n\n");
     Print(" so the Euler indicator is \n");
     Print(" ",IDA.Euler(q),"\n");
   fi;
end;


IDA.c6s4p1df1 := function(lst) #given a list of maps in Mn in list form, determine 
                               #whether the submonoid it generates is a group
  IDA.submonoid(lst,2);
end;

IDA.c6s4p2df1 := function(a)  #given a list of permutations
                              #determine order of group generated by them
  if IDA.readgrp(a) then Print("\n ");Print(Size(IDA.grp)); Print("\n");
  fi;
end;


IDA.c6s4p3th2 := function(h,k) #intersection of two groups
  local hh, kk;
  if IDA.readgrp(h) then
     hh := IDA.grp;
     if IDA.readgrp(k) then
        kk := IDA.grp;
        Print(" ");
        IDA.printset(Intersection(Elements(hh),Elements(kk)),10,0);
        Print("\n");
     fi;
  fi;
end;

IDA.c6s4p4th1 := function(hlst,prm) #given lst of elements in S5
                                    #determine  prm=0: centralizer, 
                                    #           prm=1: normalizer,
                                    #           prm=2: centre
 local g, m;
 if IDA.readgrp(hlst) then
    if IDA.m <= 6 then
       if prm = 0 then Print(" Centralizer = \n");
         IDA.printset(Elements(Centralizer(SymmetricGroup(5),IDA.grp)),4,0);
       elif prm = 1 then 
                      Print(" Normalizer = \n");
         IDA.printset(Elements(Normalizer(SymmetricGroup(5),IDA.grp)),4,0);
       else #prm=2 
                      Print(" Centre = \n");
         IDA.printset(Elements(Centre(IDA.grp)),4,0);
       fi;
    else Print(" Sorry, degree should be less than 7.\n");
    fi;
 fi;
end;

IDA.c6s5p1df1 := function(p)  #order of permutation p
  if IDA.readprm(p) then
     Print(" ",Size(Group(IDA.grpelt)),"\n");
  fi;
end;

IDA.c6s5p2th2 := function(m)  #analysis of elements in Cm
  local ans, i, j, f, xx;
  if IDA.readintmin(m,10^10,0) then
     ans := [];
     f := DivisorsInt(m);
     for xx in f do ans[xx] := []; od;
     for xx in [0..m-1] do
       Add(ans[m/Gcd(xx,m)],xx);
     od;
     for xx in f do
       Print(" elements of order ",xx,": ",ans[xx],"\n");
     od;
  fi;
end;

IDA.c6s6p1df1 := function(gg,hh)  #left cosets of h in g
  local h, ans, i, ok, l, hl, g;
  ok := true;
  if IDA.readgrp(gg) then
    g := IDA.grp;
    if IsList(hh) then
    i := 0;
    l := Length(hh);
    hl := [];
    while ok and i<l do
          i := i+1; ok := IDA.readprm(hh[i]); 
          if ok then hl[i] := Copy(IDA.grpelt); fi;
    od;    
    for i in [1..l] do
        if not(hl[i] in g) then 
           Print(" Sorry, ",i,"-th generator of H not in G\n"); 
           ok := false;
        fi;
    od;
    if ok then 
      h := Subgroup(g, hl);
      if Size(g)> 100*Size(h) then Print(" There are more than 100 cosets...\n");
                                   Print(" try a smaller example\n");
      else 
        ans := LeftCosets(g,h); 
        for i in ans do
          Print(" ",Random(i),"H\n");
        od;
      fi;
    fi;
  fi;
 fi;
end;

IDA.c6s6p2th1 := function(lst,m) #determine the order of mul grp gen by lst in Z/m
 local ok, h, ans, i, j, k, im, gens, pows, new, nnew, xx, hlp;
 im := [];
 gens := [1];
 if IDA.readintmin(m,1000,1) and IDA.readlst(lst,m,-1) then
   ok := true;
   i := 0;
   while ok and i< Length(lst) do
     i := i+1; h := lst[i] mod m;
     if Gcd(h,m) <> 1 then
        Print(" ",i,"-th element of the sequence is not invertible mod ",m,"\n");
        ok := false;
     else Add(gens, h);
     fi;
   od;
   if ok then
           #start creating the full set of elements of the submonoid
           #in pows
           pows := Set([1]); # S = {e} 
           new := Set(Copy(gens));   # N = D
           while Length(new) >0 do # N is not empty 
               Append(pows,new); # S := S cup N
               pows := Set(pows);
               #buildup cup_{x in D} xN
               nnew := [];  hlp := [];
               for h in gens do 
                 for xx in new do
                   #compute x h
                   hlp := (xx*h) mod m;
                   Add(nnew,hlp);
                 od;
               od;
               Append(new,nnew);
               new := Set(new);
               for xx in pows do RemoveSet(new,xx); od;
               # N = cup_{x in D} xN\S
           od;
           Print(" Order of H = ",Length(pows),"\n");
           Print(" divides\n");
           Print(" Order of G = ",IDA.Euler(m),"\n");
   fi;
 fi;
end;

IDA.c6s6p2co1 := function(hh) #order of permutation hh
 if IDA.readprm(hh) then
   Print(" ",Size(Group(IDA.grpelt)),"\n");
 fi;
end;


IDA.normalsubgrp := function(glst,vs)  #given gens glst  for subgroup
                                       #if vs = 0 then Alt5, 
                                       #find non-normalizing elt for corr subgroup g
  local g, h, l, hlp, t, ok, m, gelts, d, hlp2, f;
  if IDA.readgrp(glst) then 
    t := Length(glst); hlp := []; m := 1;
    ok := true; 
    for l in glst do
      if ok and IDA.readprm(l) then
         if not(IsPerm(l)) then l := PermList(l); fi;
         if vs = 0 and SignPerm(l) = -1 then
            Print(" Sorry, only even permutations allowed as input\n");
            ok := false;
         else
            Add(hlp,l); 
            m := Maximum([m,PermGroupOps.LargestMovedPoint(Group(l))]);
         fi;
      else ok := false;
      fi;
    od;
    if ok and t>0 then
       if vs=0 then
         g := AlternatingGroup(5);
       else
         g := SymmetricGroup(m);
       fi;
       h := Subgroup(g,hlp);
       if vs=0 and m>5 then Print(" Sorry, permutations should be on {1,...,5}\n");
       elif  vs=0 and Size(h) = 60 then Print(" you have input the full A_5\n");
       else
          hlp2 := Elements(Normalizer(g,h));
          gelts := Copy(Elements(g));
          for d in hlp2 do RemoveSet(gelts,d); od;
          if Length(gelts) = 0 then 
            l := Size(h); 
            f := Factorial(m);
            if l = f then 
               Print(" H = S",m," so H is normal in S",m,"\n"); 
            elif 2*l = f then
               Print(" H = A",m," so H is normal in S",m,"\n"); 
            else
               Print(" H is a normal subgroup of S",m," of size ",l,"\n"); 
            fi;
          else
            d := Random(gelts);
            Print(" for g  = ",d," we have\n");
            Print("     gH =  ",Elements(RightCoset(h,d)),"\n");
            Print("     Hg =  ",Elements(LeftCoset(h,d)),"\n");
            if vs>0 then Print(" so H is not normal in S",m,"\n"); fi;
          fi;
       fi;
    fi;
  fi;
end;

IDA.c6s6p3th1 := function(lst) #test if permutation subgroup generated by lst is normal in Sm
  IDA.normalsubgrp(lst,1);
end;

#chapter 7

IDA.distr := function(mu,pl) # testing mu(x,pl(y,z)) =  pl(mu(x,y),mu(x,z));
  local muxy, plxy, plyz, muxplyz, muxy, muxz, plmuxymuxz;
  #lhs
  Print("computing mu(x,pl(y,z))\n");
  plyz := IDA.coeffs2pol(pl,y,z);
  muxplyz := IDA.coeffs2pol(mu,x,plyz);
  Print(" = ",muxplyz,"\n\n");
  #rhs
  Print("computing pl(mu(x,y),mu(x,z))\n");
  muxy := IDA.coeffs2pol(mu,x,y);
  muxz := IDA.coeffs2pol(mu,x,z);
  plmuxymuxz := IDA.coeffs2pol(pl,muxy,muxz);
  Print(" = ",plmuxymuxz,"\n\n");
  Print("mu(x,pl(y,z)) =?= pl(mu(x,y),mu(x,z)): ", muxplyz = plmuxymuxz,"\n");
end;

IDA.c7s1p1df1 := function(f,g) #test distributivity
  local ff, gg;
  if IDA.readxypol(f) then
     ff := Copy(IDA.xypol);
     if IDA.readxypol(g) then
       gg := Copy(IDA.xypol);
       IDA.distr(ff,gg);
     fi;
  fi;
end;

IDA.c7s1p3th1 := function(q)  #Euler indicator
  if IDA.readintmin(q,10^10,0) then
     Print(" ",IDA.Euler(q),"\n");
  fi;
end;

IDA.c7s1ja := function(q) #Multiplication table for (Z/m)^*
 local ans,i,j,sz;
 if IDA.readintmin(q,10000,0) then 
     sz := 3; if q >100 then sz := 4; fi;
     ans := IDA.Eulerelts(q);
     Print("\n");
     for i in ans do 
       for j in ans do
          Print(String((i*j) mod q,sz));
       od; Print("\n");
       Print("\n");
     od;
 fi;
end;

IDA.c7s1p4df1 := function(m)  #given square matrix m, determine minimum polynomial
                              #and inverse
  local h, p, v, ans, mi;
  if IDA.readmat(m) then
     h := DimensionsMat(m);
     if h[1] <> h[2] then Print(" matrix is not square\n");
     else Print(" The minimum polynomial of A is:\n");
          p := IDA.minpoly(m);
          Print(" ",p,"\n");
          Print(" So there is a morphism f : S -> R[X]/(",p,")\n");
          v := [X,p];
          ans := IDA.extgcdp(v);
          if ans[3] <> 1*X^0 then Print(" cannot invert A, sorry\n"); Print(" gcd=d",ans,"\n");
          else ans := ans[1];
            Print(" In S, the inverse of X is ", ans,"\n");
            Print(" so the inverse of A is  f^(-1)(",ans,") =\n");
            mi := Value(ans,m);
            IDA.printmat(mi,4);
         fi;
     fi;
  fi;
end;



IDA.ordemodm := function(g,h,m) #order of mult elt of Z/m modulo subgroup h
  local ans, gg;
  gg := g mod m; ans := 1;
  while not(gg in h) do
         gg := (gg * g) mod m; ans := ans+1;
  od;
  return(ans);
end;


IDA.prodmodm := function(lst,h,m) #all prods of elts of lst with powers of h mod m
 local ans, la, lb, i;
   ans := Copy(lst);
   la := Length(ans);
   AddSet(ans,h);
   lb := Length(ans);
   while lb>la do
       for i in ans do AddSet(ans,(i*h) mod m); od;
       la:= lb;
       lb := Length(ans);
   od;
   return(ans);
end;

IDA.c7s2p1th2 := function(m)  #given a natural number m, determine (Z/m)^*
  local ans, elt, newgelts, helts, i, mi, maxord, hlp, xx, cosetreps, l;
  if IDA.readintmin(m,10^10,0) then
     cosetreps := IDA.Eulerelts(m);
     ans := [];
     helts := Set([1]);
     RemoveSet(cosetreps,1);
     while Length(cosetreps)>0 do
        #search for elt of maximal h-order
#        Print("start with cosetreps  = ",cosetreps, "\n"); 
        maxord := 0;
        for elt in cosetreps do
            hlp := IDA.ordemodm(elt,helts,m);
            if hlp>maxord then 
               mi := elt; maxord := hlp; #Print("new maxord = ",maxord,"\n");
            fi;
        od;
        hlp := List(helts, xx -> (xx*mi) mod m);
        for i in hlp do if IDA.ordemodm(i,[1],m) = maxord then mi := i; fi; od;
        AddSet(ans,[mi,maxord]);
        #create new h;
        helts := IDA.prodmodm(helts,mi,m);
        #create new cosetreps
        newgelts := [];
        for elt in cosetreps do
          hlp := List(helts, xx -> (xx*elt) mod m);
          AddSet(newgelts,Minimum(hlp));
        od;
        cosetreps := Copy(newgelts);
        RemoveSet(cosetreps,1);
     od;
     Print(" The group of invertible elements in Z/",m,"Z is:\n");
     l := Length(ans);
     if l=0 then Print(" trivial\n");
     else 
       for i in [1..l-1] do
            Print(" C",ans[i][2]," x");
       od;           Print(" C",ans[Length(ans)][2],", ");
       Print("\n with generators ");
       for i in [1..l-1] do
            Print(" ",ans[i][1],", ");
       od;          Print(" ",ans[Length(ans)][1],".\n");
     fi;
  fi;
end;


IDA.c7s2p3th1 := function(f)  #read in polynomial f in x and y,  then display expanded
  if IDA.readxypol(f) then
    IDA.printxypol(IDA.xypol,"x","y");
  fi;
end;


IDA.c7s3p1df1 := function(m)  #read in a matrix m
                              #if invertible give inverse and say nonzero divisor
                              #if not invertible give b with bm = 0
  local i, dt, ans, h, dh;
  if IDA.readsqmat(m) then
    dt := Determinant(m);
    if dt = 0 then
      h := NullspaceMat(m);
      dh := DimensionsMat(h)[1];
      for i in [dh+1..IDA.dim] do Add(h,Copy(h[1])); od;
      Print(" The matrix is a zero divisor since B =\n\n");
      IDA.printmat(h,3);
      Print(" satisfies BA = 0\n");
    else
      Print(" The matrix has determinant ",dt,",\n");
      Print(" so it is invertible,\n");
      Print(" whence not a zero divisor.\n");
    fi;      
  fi;
end;


IDA.c7s3p4df1 := function(q,d) # find elements of subfield GF(p^d) of GF(q) 
  local p, i, f, g, a, m;
  if IDA.readprimepow(q) then  
    p := Factors(q);
    a := Length(p);
    p := p[1];
    if IDA.readintmin(d,LogInt(q,p)+1,0) then
       if (a mod d)  <> 0 then Print(" Sorry, ",d," does not divide ",a,",\n");
                            Print(" the exponent of ",q," as a power of ",p,"\n");
       else
          f :=  Polynomial(GF(p),MinPol(GF(q),Z(q))); 
          Print(" We work in the field\n");
          Print(" Z/",p,"Z[X]/(",IDA.MakeRatPol(f,p),")\n\n");
          g :=  IDA.FindPriPol(f,p); #Print("g = ",g,"\n"); 
          Print(" The elements of the subfield of order ",p^d," are:\n");
          Print(" 0,\n 1, \n");
          m := (q-1)/(p^d-1);
          for i in [1..p^d-3] do 
                Print(" ", IDA.MakeRatPol(((g^(m*i)) mod f),p),",\n");
          od; 
          Print(" ", IDA.MakeRatPol(((g^(m*(p^d-2))) mod f),p),".\n");
          Print("\n");
       fi;
    fi;
  fi;
end;


IDA.c7s3p5th1 := function(f,g,f1,g1,param) # do computations in Quotient field
  local p, i, ff, gg, ff1, gg1, a, m, t, n, h;
  if IDA.readXpol(f) then  
    ff := Copy(IDA.Xpol);
    if IDA.readXpol(g) then
       gg := Copy(IDA.Xpol);
       if gg = 0*X then Print(" f/g not defined as g = 0\n");
       else
         if IDA.readXpol(f1) then  
            ff1 := Copy(IDA.Xpol);
            if IDA.readXpol(g1) then
               gg1 := Copy(IDA.Xpol);
               if gg1 = 0*X then Print(" f1/g1 not defined as g1 = 0\n");
               else
                 if param=1 then
                   t := ff+ff1;
                   n := gg*gg1;
                   h := Gcd(t,n);
                   t := t/h;
                   n := n/h;
                   Print(" the sum is (",t,")/(",n,")\n");
                 elif param=5 then
                   if ff1 = 0*X then Print(" Division not defined as f1=0\n");
                   else
                     t := ff*gg1;
                     n := gg*ff1;
                     h := Gcd(t,n);
                     t := t/h;
                     n := n/h;
                     Print(" the quotient is (",t,")/(",n,")\n");
                   fi;
                 elif param=2 then
                   t := ff-ff1;
                   n := gg*gg1;
                   h := Gcd(t,n);
                   t := t/h;
                   n := n/h;
                   Print(" the difference is (",t,")/(",n,")\n");
                 elif param=4 then
                   t := ff*ff1;
                   n := gg*gg1;
                   h := Gcd(t,n);
                   t := t/h;
                   n := n/h;
                   Print(" the product is (",t,")/(",n,")\n");
                 elif param=6 then
                   if ff1 = 0*X then Print(" f1=0, so not invertible\n");
                   else
                     t := ff*gg1;
                     n := gg*ff1;
                     h := Gcd(t,n);
                     t := t/h;
                     n := n/h;
                     Print(" the quotient is (",t,")/(",n,")\n");
                   fi;
                 elif param=3 then
                     t := ff*gg1;
                     n := gg*ff1;
                     if t=n then Print("(",ff,")/(",gg,") = (",ff1,")/(",gg1,") \n ");
                     else  Print("(",ff,")/(",gg,") is not equal to (",ff1,")/(",gg1,") \n ");
                     fi;
                 fi;
              fi;
           fi;
        fi;
      fi;
    fi;
  fi;
end;



IDA.c7s4p2th1 := function(d,f) #matrix of mult by f in Q[X]/(d)
  local ans, i, j, h, n, ff, dd;
  if IDA.readXpol(d) then dd := Copy(IDA.Xpol);
#     if not(IsIrreducible(d)) then Print(" Sorry, ",d," is reducible,\n");
#        ans := Factors(d); Print(" e.g., it has factors ",ans[1],", ",ans[2],".\n");
#        Print(" Hence Q[X]/(d) is not a field\n");      
#     elif 
      if IDA.readXpol(f) then 
          ff := Copy(IDA.Xpol) mod d;
          n := Degree(dd);
          ans := [];
          for i in [1..n] do
            ans[i] := IDA.pol2coeffsl((f*X^(i-1)) mod d,n-1);
          od;
          IDA.printmat(TransposedMat(ans),4);
     fi;
 fi;
end;

IDA.c7s4p3lm1 := function(f) #linear factors of f in Q[X]
  local ans, i, l, h, n, ff, dd;
  if IDA.readXpol(f) then ff := Copy(IDA.Xpol);
     h := Factors(ff); i := 1;
     ans := []; l := Length(h);
     while i <= l and Degree(h[i]) = 1 do
           AddSet(ans, -(IDA.pol2coeffsl(h[i],1)[1]));
           i := i+1;
     od;
     if Length(ans) = 0 then Print(" f has no linear factors,\n");
        Print(" and hence no zeros in Q either.\n");
     else
        Print(" Zeros of f:\n ");
        for i in ans do Print(i,", "); od;
        Print("\n");
        Print(" in other words,\n ");
        for i in ans do Print("(",X-i,")"); od;
        Print(" divides f\n");
     fi;
 fi;
end;

IDA.c7s4p5df1 := function(p,q,r)  #read in sqrt p + sqrt q + r and determine min poly
  local ans,m,i,j,hlp,lc;
  if IDA.readint(p) and IDA.readint(q) and IDA.readint(r) then
      m := [[0,1,1,r],
            [2,2*r,2*r,p+q+r^2],
            [6*r,p+3*q+3*r^2,3*p+q+3*r^2,3*p*r+3*q*r+r^3],
            [4*p+4*q+12*r^2,4*p*r+4*r^3+12*q*r,4*q*r+4*r^3+12*p*r,
              6*p*q+6*p*r^2+6*q*r^2+p^2+q^2+r^4]];
    hlp := SolutionMat(m,[0,0,0,-1]);
#    Print(" ",SolutionMat(m,[0,0,0,1]),"\n");
    hlp := X^0 + X * Polynomial(Rationals,hlp);
    hlp := hlp/LeadingCoefficient(hlp);
    Print(" ",hlp,"\n");
 fi;
end;






IDA.pspoly := function(f,g,w) #given irreducible polys f,g
                               #make poly for sum/product of a root of each
                               #according as w=0/1
  local ans, a,b,ab,fg,h1,h2;
  a := IDA.companion(f);
  b := IDA.companion(g);
  if w=1 then
    ab := KroneckerProduct(a,b);
  else #should have w=0
    h1 := IdentityMat(Degree(f));
    h2 := IdentityMat(Degree(g));
    ab := KroneckerProduct(a,h2) + KroneckerProduct(h1,b);
  fi;
  return(IDA.minpoly(ab));
end;




IDA.c7s4p5th1 := function(f,g,w)  #given f and g determine 
                                  #poly for sum/product of a root of each
                                  #according as w=0/1
    local ff, gg;
    if IDA.readXpol(f) then
       ff := Copy(IDA.Xpol);
       if IDA.readXpol(g) then
          gg := Copy(IDA.Xpol);
          if Degree(gg)*Degree(ff) >16 then
             Print(" Degrees of the input polynomials too big\n");
             Print(" Try lower dergree polynomials.\n");
          else
             Print(" The minimum polynomial of a");
             if w=0 then Print("+");
             else # w=1 
                w := 1; Print("*"); 
             fi;
             Print("b is\n ",IDA.pspoly(ff,gg,w),"\n");
          fi;
       fi;
    fi;
end;


IDA.c7s5p4df1 := function(f)  #read in Gaussian integer, determine its factors
    if IsGaussInt(f) then
       Print(" ("); 
       IDA.printgauss( Factors(GaussianIntegers,f)[1]); 
       Print(")(Z+ZI)\n");
    else Print(" Input f = ",f," is not a Gaussian integer\n");
    fi;
end;

IDA.c7s6p2th1 := function(f)  #read in Gaussian integer, determine its residue class ring
    local a, b, c, h, m, i, g, ff, ml;
    if IsGaussInt(f) then
      if IsInt(f*I) then ff := f*I; else ff := f; fi;
      if IsInt(ff) then ff := AbsInt(ff);
         if ff = 1 then
              Print("f is invertible,\n");
              Print(" so the residue class ring is not defined\n");
         else
              Print(" R = Z/",ff,"Z+Z/",ff,"Zi\n");
              if IsPrime(ff) then
                 if (ff mod 4) = 1 then
                    a := PrimitiveRootMod(ff); a := a^((ff-1)/4) mod ff;
                    Print(" R has zero divisors:\n ");
                    Print(" (",a,"-I)(",a,"+I) = 0.\n\n");
                 elif ff=2 then Print(" R is isomorphic to Z/2Z x Z/2Z\n");
                    Print(" R has zero divisors:\n ");
                    Print(" (",1,"+I)(",1,"+I) = 0.\n\n");
                 else  Print(" R is a field of order ",ff^2,".\n");
                       Print(" R is isomorphic to Z/",ff,"Z[X]/(X^2+1).\n");
                 fi;
              else  Print(" R has zero divisors:\n ");
                    a := Factors(ff);
                    Print(" ",a[1],"*",a[2]," = 0.\n\n");
              fi;
          fi;
      else h := Conjugates(ff);
           m := h[1]*h[2];
           Print(" the smallest integer in (f) is (");
           IDA.printgauss(h[1]);Print(")*("); IDA.printgauss(h[2]); Print(") = ",m,".\n");
           a := (h[1]+h[2])/2;
           b := -(h[1]-h[2])*I/2;
           if a<b then ml := I; c := a; a := -b; b := c; fi;
           g := IDA.extgcd([b,m]);
           Print(" ",g[2],"*",m,"*I+",g[1],"*("); IDA.printgauss(a+b*I);Print(") = ");
           IDA.printgauss(g[1]*a+g[3]*I);Print("\n");
           Print(" So in R we have ");
           a := g[1]*a;
           b := g[3];
           if AbsInt(b)<>1 then Print(AbsInt(b),"*"); fi;
           Print("I = ",(-SignInt(b)*a) mod m ,".\n"); 
           Print(" R = Z/",m,"Z");
           if AbsInt(b)>1 then Print("+Z/",b,"Zi"); fi;
           Print("\n");
           h := Factors(ff);
           if  Length(h)>1 then
                 Print(" R has zero divisors:\n ");
                 Print(" (");
                 IDA.printgauss(h[1]);
                 Print(")(");
                 c := h[2];
                 for i in [3..Length(h)] do c := c*h[i]; od;
                 IDA.printgauss(c);
                 Print(") = 0.\n\n");
           else Print(" R is a field of order ",m,".\n\n");
           fi;
      fi;
    else Print(" Input f = ",f," is not a Gaussian integer\n");
    fi;
end;



IDA.c7s7p2th1 := function(q) #write out powers of X
  local p, i, f, g, h, sz;
  if IDA.readprimepow(q) then  
    p := Factors(q); p := p[1];
    f :=  Polynomial(GF(p),MinPol(GF(q),Z(q))); 
    Print(" We work modulo the irreducible\n");
    Print(" polynomial ",IDA.MakeRatPol(f,p),"\n\n");
    g :=  IDA.FindPriPol(f,p); #Print("g = ",g,"\n"); 
    h := Indeterminate(GF(p))^0; #Print("h = ",h,"\n"); 
    if q < 100 then sz := 2; fi;
    if q < 10 then sz := 1; fi;
    for i in [0..q-2] do 
       Print(" X^",String(i,sz)," =  ", IDA.MakeRatPol(h mod f,p),"\n");
       h := (h*g) mod f;
    od; Print("\n");
  fi;
end;

IDA.c7s7p3th1 := function(q) #an irreducible polynomial over GF(p) of degree log_p(q)
  if IDA.readprimepow(q) then
    Print(IDA.MakeRatPol(Polynomial(GF(q), MinPol(GF(q),Z(q))),q),"\n");
  fi;
end;


IDA.c7s7p4th1 := function(n) #Hadamard matrix construction
 local q, ans;  
 if IDA.readintmin(n,300,0) then
   ans := NullMat(n,n); 
   if n=1 then ans[1][1] := 1; IDA.printHadmat(ans,true); 
   elif n=2 then ans[1][1] := 1; ans[1][2] := 1; 
                ans[2][1] := -1; ans[2][2] := 1;
                IDA.printHadmat(ans,true) ;
   elif (n mod 4) <> 0 then Print("no Hadamard matrix of this dim\n"); 
   elif (n mod 8 ) = 0 or n=4 then 
                IDA.printHadmat(IDA.tensor(IDA.Had(n/2),IDA.Had(2)),true);
   else         q := n-1;
                if (q mod 4) = 3 and IsPrimePowerInt(q) then
                    #Print("in q mod 4 =3 case");
                    IDA.printHadmat(IDA.paley_skew(q),true);
                else
                    q := n/2-1;
                    if (q mod 4) = 1  and IsPrimePowerInt(q) then
                        #Print("in q mod 4 =1 case");
                        IDA.printHadmat(IDA.paley_sym(q),true);
                    else
                        Print("sorry, no construction available for dimension ",n,"\n");
                    fi;
                fi;
   fi;
 fi;
end;

#chapter 8

IDA.LeesUit := function(g,lst)
  local ans, h;
  ans := ();
  for h in lst do
    if h>0 then ans :=  g.generators[h] * ans;   
    else ans :=  (g.generators[-h]^(-1)) * ans; 
    fi;
  od;
  return(ans);
end;

IDA.schreierelts := function(g,hlst,d,n) 
           #construct a schreiertree for h = <hlst> with root d
           #a list of lists, representing Schreier elts.
           #hlst is a list of elts of g each given 
           #as a list of g.generators, 
           # n :=   PermGroupOps.LargestMovedPoint(g);
  local ans, elt, news, i, j , h, strhold;
  ans := IDA.NullVec(n);
  ans[d] := []; 
  strhold := Set([d]); news := true;
  while news do news := false;
    for i in strhold do
      for h in hlst do
         elt := Copy(h); 
         j := i^(IDA.LeesUit(g,elt));
         if ans[j] = 0 then
            Append(elt,ans[i]);
            ans[j] := elt;
            news := true;
            Add(strhold,j);
         fi;
      od;
    od;
  od;
  return(ans);
end;

IDA.schreier := function(g,d) #construct a schreiertree for g with root d
     local yy, n;
     n :=  PermGroupOps.LargestMovedPoint(g);
     return(IDA.schreierelts(g,List([1..Length(g.generators)],yy -> [yy]),d,n));
end;

IDA.MinReversed := function(lst)
  local ans, i, n;
  ans := []; n := Length(lst);
  for i in [1..n] do Add(ans,(-1)*lst[n-i+1]); od;
  return(ans);
end;

IDA.cleanuph := function(g,lst) #remove from lst all redundant elts for generating
    local ans, pans, prms, i, xx;
    ans := []; pans := []; 
    prms := List(lst,xx -> IDA.LeesUit(g,xx));
    for i in [1..Length(prms)] do
          if not(prms[i] in Subgroup(g,pans))
          then Add(pans,prms[i]);
               Add(ans,lst[i]);
          fi;
    od;
    return(ans);
end;


IDA.freegrpshorten := function(lst) #normalize a list representing an elt
                                    #from the free group
   local answ, hlp, i, notr;
   if Length(lst) > 0 then
      notr := true;
      answ := Copy(lst);
      while notr do 
         notr := false; hlp := Copy(answ); answ := []; i := 1; 
         while i < Length(hlp)  do 
#         Print("l(hlp): ",Length(hlp),"\n");
            if (hlp[i]+hlp[i+1]) = 0 then
                 i := i+2; notr := true;
            else  Add(answ,hlp[i]); i := i+1;
            fi;
         od;       
         if i=Length(hlp) then Add(answ,hlp[i]); fi;
#         Print("l(answ): ",Length(answ),"\n");
      od;
      return(answ);
    fi;
    return([]);
end;



IDA.stab := function(g,hlst,d,n) 
  # produce elements generating the stabilizer in h of d
  # in terms of a list of elts given as products of gens of g
  #hlst is also given as a list of elts given as products of gens of g
  local ans, b, st, i, h, hlp;
  st := IDA.schreierelts(g,hlst,d,n);
  ans := []; 
  for h in hlst do
    b := IDA.freegrpshorten(h);  
    for i in [1..n]
      do  
         if st[i]<>0 then 
            hlp := IDA.MinReversed(st[i^(IDA.LeesUit(g,b))]);
            Append(hlp,h);
            Append(hlp,st[i]); 
            Add(ans,IDA.freegrpshorten(hlp)); 
         fi;
    od;
  od;
  return(IDA.cleanuph(g,ans));
end;

          
IDA.sterk := function(g,elt) # given elt of g write it as prod of gens
  local ans, b, hlst, bi, j, n, yy, elm, s;
  n :=   PermGroupOps.LargestMovedPoint(g);
  b := Base(g); elm := Copy(elt); 
  hlst := List([1..Length(g.generators)], yy -> [yy]); 
  ans := [];
    for bi in b do
      s := IDA.schreierelts(g,hlst,bi,n);
      j := bi^elm;
      if s[j] = 0 then #Print("error: ",elt," not in ",g,"\n");  
         return(0); 
      fi;
      Append(ans, s[j]);
      elm := elm * IDA.LeesUit(g,s[j])^(-1);
      if elm = () then 
                 return(IDA.freegrpshorten(ans)); fi;
      hlst := IDA.stab(g,hlst,bi,n);
    od;
  return(0);
end;

IDA.modpin1p := function(n,p) #number mod p in [1..p]
  local h;  h := n mod p;
  if h = 0 then return(p);
  else return(h);
  fi;
end;


IDA.c8s1p1df1 := function(m,p) #read in 2x2 matrix over GF(p)
                               #give if invertible permutation on nonzero vectors
  local i,j,prmlst; 
  prmlst := [];
  if IDA.readmat(m) and IDA.readprime(p) and IDA.readintmin(p,11,0) then
    for j in [1..p-1] do
      for i in [1..p] do
        prmlst[i+p*(j-1)] := IDA.modpin1p(m[1][1]*i+m[1][2]*j,p) + 
                             p * (IDA.modpin1p(m[2][1]*i+m[2][2]*j,p) -1);
      od;
    od;
    # j = p
    for i in [1..p-1] do
      prmlst[i+p*(p-1)] := IDA.modpin1p(m[1][1]*i,p) + 
                             p * (IDA.modpin1p(m[2][1]*i,p) -1);
    od;
    if (DeterminantMat(m)) mod p = 0 then
    Print(" ", m," not invertible, so the map is not a permutation\n");
    fi;
    Print(" in list form: ",prmlst,"\n");
    Print(" in disjoint cycles form: ",PermList(prmlst),"\n\n");
    Print(" numbering of the nonzero vectors:\n");
    for j in [1..p-1] do
      for i in [1..p] do
        Print(" ",i+p*(j-1),": ", [(i mod p),j],"\n");
      od;
    od;
    # j = p
    for i in [1..p-1] do
        Print(" ",i+p*(p-1),": ", [i,0],"\n");
    od;
  fi;
end;


IDA.c8s1p2pr1 := function(prm, cyc) #read in a permutation and a cycle structure
                                    #return conjugation by permutation
                                    #on cycles of given structure.
  local i, i0, j, g, ct, fstelt, nf, nn, orb, ans, hlp, n; 
  if IDA.readprmlst(prm) and IDA.readlst(cyc,100,0) then
    hlp := 0; for i in cyc do hlp := hlp + i; od;
    n := Length(prm);
    if hlp = n then
      g := PermList(prm);
      #make first permutation of given cycle structure
      fstelt := []; ct := 0;
      for i in [1..Length(cyc)] do
         i0 := ct+1;
         for j in [1..(cyc[i]-1)] do
            ct := ct+1;
            fstelt[ct] := ct+1;
         od; 
         ct := ct+1; fstelt[ct] := i0;
      od;
  #    n := PermGroupOps.LargestMovedPoint(Group(g));
      orb := Elements(ConjugacyClass(SymmetricGroup(n),PermList(fstelt)));
      nn := Length(orb);
      ans := Elements([1..nn]);
      for i in [1..nn] do
        hlp := g^(-1)*orb[i]*g;
        j := 0; nf := true;
        while j <= nn and nf do j := j+1;
          if orb[j] = hlp then nf := false; ans[i] := j;
          fi;
        od; # Print(i," ", orb[i]," ", hlp," ",j,"\n");
      od;
      Print(" ",PermList(ans),"\n\n");
      Print(" Numbering of the points:\n");
      for i in [1..nn] do Print(" ",i,": ",orb[i],"\n"); od;
    else Print(" Please make sure that the length of the permutation\n");
       Print(" equals the sum of components of the cycle structure\n");
    fi;
  fi;
end;

IDA.c8s1p2th1 := function(glst) #input list of gens of g in listform 
                                #output centre of the group
 local i, hlp; 
 if IDA.readgrp(glst) then
    hlp := Centre(IDA.grp);
    if  Length(hlp.generators) = 0 then
      Print("The center of G is the trivial group\n");
    else
      for i in hlp.generators do Print(" ");
         IDA.printgrpelt(IDA.sterk(IDA.grp,i));
         Print(" =  ",ListPerm(i),"\n");
      od;
      Print("\n");
    fi;
 fi;
end;



IDA.c8s2p1df1 := function(glst) #orbits of grp g
 local m, i, lst, hlp; 
 if IDA.readgrp(glst) then
    lst := IDA.grp.generators;
    m := 1; 
    for i in lst do 
        hlp := ListPerm(i); Add(hlp,m); m := Maximum(hlp); 
    od;
    hlp := Orbits(IDA.grp,[1..m]); Print("\n");
    for i in [1..Length(hlp)] do Print(" ",i,": ",hlp[i],"\n"); od;
 fi;
end;


IDA.c8s2p1al1i := function(glst,d) #orbit of d in a group as explicit algorithm initialize
 local m; 
 if IDA.readgrp(glst) and IDA.readintmin(d,IDA.m+1,0) then
    m := Length(IDA.grpelts);
    IDA.bool := true;
    IDA.orbit := Set([d]);
    IDA.lastfound :=  Set([d]);
    IDA.bool := true;
    Print(" Start with B = ",IDA.grpelts,"\n"); 
    Print(" x = ",d,"\n");
    Print(" Orbit = ",IDA.orbit,"\n");
    Print(" LastFound = ",IDA.lastfound,"\n");
 fi;
end;

IDA.c8s2p1al1r := function() #orbits of grp g as explicit algorithm run
 local m, i; 
 if Size(IDA.lastfound) <> 0 then
   #make New
   IDA.new := Set([]);
   for i in IDA.grpelts do 
     for m in IDA.lastfound do
       AddSet(IDA.new,m^i);
     od;
   od;
   for m in IDA.orbit do
     RemoveSet(IDA.new,m);
   od;
   Print(" New = ", IDA.new,"\n");
   #update Orbit
   Append(IDA.orbit,IDA.new);
   IDA.orbit := Set(IDA.orbit);
   Print(" Orbit = ",IDA.orbit,"\n");
   Print(" LastFound = ",IDA.lastfound,"\n");
   #update LastFound
   IDA.lastfound := Copy(IDA.new);
 else
   Print(" New is empty, so we are done.\n The result is\n");
   Print(" Orbit = ",IDA.orbit,"\n");
 fi;
end;

IDA.c8s2p2df1 := function(glst,d) #input permutation grp g and point x
                               # output stabilizer elt wise
 local i, ans; 
 if IDA.readgrp(glst) and IDA.readintmin(d,100,0) then
   ans := Elements(Stabilizer(IDA.grp,d));
   for i in ans do
     Print(" ", i," = ");
     IDA.printgrpelt(IDA.sterk(IDA.grp,i));
     Print("\n");
   od;
 fi;
end;


IDA.c8s2p2th1 := function(glst,h) #input g 
                                  #output correspondence G/H and 
                                  #permutation set
 local i, j, k, mm, ans, nf, hlp, hh, l, c, t, rps, hlst, g, done; 
 if IDA.readgrp(glst) then
    hlst := [];
    g := IDA.grp;
    mm := Length(IDA.grp.generators)+1;
    done := false;
    if IsList(h) then
      for i in h do 
          if not(done) and  IDA.readlst(i,mm,-mm) then 
             Add(hlst,IDA.LeesUit(IDA.grp,i)); 
          else done := true;
          fi;
      od;
      if not(done) then
        hh := Subgroup(g,hlst);
        c := Cosets(g,hh);
        l := Length(c);
        t := Length(g.generators);
        rps := [];
        ans := NullMat(t,l);
        for j in [1..l] do rps[j] := Elements(c[j])[1]; od;
        for i in [1..t] do
           for j in [1..l] do
              hlp := rps[j] *  g.generators[i];
              nf := true; k := 0;
              while nf do
                 k := k+1;
                 if hlp in c[k] then nf := false; fi;
                 if k> l then Print("error in 822\n"); return(0); fi;
              od;
              ans[i][j] := k;
           od;
        od;
        for i in [1..t] do
            Print("g_",i,": ", ans[i],"\n");
        od;
        Print("Numbering of the elements of G/H:\n");
        for j in [1..l] do
           IDA.printgrpelt(IDA.sterk(g,rps[j]));
           Print("H =  ",ListPerm(rps[j]),"H\n");
        od;
        Print("\n");
      fi;  
   fi;  
 fi;
end;


IDA.c8s2p3th1 := function(glst,d)  #from X to G/H
  local n, H, i, hlst, yy, s, g;
  if IDA.readgrp(glst) and IDA.readintmin(d,100,0) then 
    g := IDA.grp;
    n := IDA.m;
    H := Stabilizer(g,d);
    hlst := List([1..Length(g.generators)], yy -> [yy]); 
    s := IDA.schreierelts(g,hlst,d,n);
    Print("\n");
    for i in [1..n] do
       if s[i] <> 0 then
          Print(" ");IDA.printgrpelt(s[i]); Print("H = ",IDA.LeesUit(g,s[i]), "H <-> ");
          Print(i,"\n");
       fi;
    od;
  fi;
  Print("\n");
end;



IDA.c8s3p1df1 := function(glst) #basis for grp g
 if IDA.readgrp(glst) then  Print(Base(IDA.grp),"\n"); fi;
end;


IDA.c8s3p1th1 := function(glst) #basis for group and order computation
 local ans, i, j, fcts, b, l, hlp, h, g;
 if IDA.readgrp(glst) then
    g := IDA.grp;
    b := Base(g);
    l := Length(b); h := g; fcts := []; 
    for i in [1..l] do
       hlp := Length(Orbit(h,b[i])); Add(fcts,hlp);
       Print(" The order of G"); if i>1 then Print("_["); fi;
       for j in [1..i-2] do Print(b[j],","); od; 
       if i>1 then Print(b[i-1],"]"); fi;
       Print("(",b[i],") is ", hlp,"\n");
       h := Stabilizer(h,b[i]); 
    od;
    Print(" The order of G_[");
    for j in [1..l-1] do Print(b[j],","); od; Print(b[l],"] is ", 1,"\n");
    Print("\n So the order of G is ");
    l := Length(fcts);
    for i in [1..l-1] do Print(fcts[i]," * "); od;
    Print(fcts[l]," = ", Size(g),".\n");
 fi;
end;



IDA.c8s3p2df1 := function(glst,d) #schreier tree for grp g and root d
  local t,N,b,M,a,B,T,l,g; 
  if IDA.readgrp(glst) and IDA.readintmin(d,IDA.m+1,0) then 
    g := IDA.grp;
    B :=  g.generators; l := Length(B);
    T := Set([d]); M := [d]; N := Set([d]);
    while Length(N)>0 do
      N := [];
      for b in B do 
        for a in M do t := a^b;
          if not(t in T) then AddSet(N,t); AddSet(T,t);
            Print(" [",a,",",b,";",t,"]\n");
          fi;
        od;
      od;
      M := N;
    od;
  fi;
end;



IDA.c8s3p2al1 := function(glst,d)  #schreier tree for a permutation group with root d
                                   #with schreier words
  local i, ans, g;
  if IDA.readintmin(d,100,0) and IDA.readgrp(glst) then 
    g := IDA.grp;
    ans := IDA.schreier(g,d);
    for i in [1..Length(ans)] do
       if ans[i]<>0 then
         Print(" ",i,": ");
         IDA.printgrpelt(ans[i]); Print(" = ",IDA.LeesUit(g,ans[i]),"\n");
       fi;
    od;
  fi;
end;



IDA.c8s3p3al1 := function(glst,pt) #stabilizer of point in permutation group
 local h, sh, so; 
 if IDA.readgrp(glst) and IDA.readintmin(pt,IDA.m,0) then
    h := Stabilizer(IDA.grp,pt);
    Print(" The stabilizer is generated by \n");
    IDA.printset(h.generators,2,0); Print("\n\n");
    sh := Size(h);
    Print(" The order of the stabilizer is ",sh,";\n");
    so := Size(Orbit(IDA.grp,pt));
    Print(" the size of the orbit containing ",pt," is ",so,",\n");
    Print(" so the order of G is ",sh,"*",so," = ",sh*so,".\n");
 fi;
end;


IDA.c8s3p3th1 := function(glst,d) #stabilizer for group g and schreier words
  local n, yy, ans, hlst, i, g;
  if IDA.readgrp(glst) and IDA.readintmin(d,10^10,0)
  then 
    g := IDA.grp;
    n := PermGroupOps.LargestMovedPoint(g);
    if d <= n then
       hlst := List([1..Length(g.generators)], yy -> [yy]); 
        ans := IDA.stab(g,hlst,d,n);
        if Length(ans) > 0 then
           for i in ans do 
             Print("\n "); IDA.printgrpelt(i);
           od;
           Print("\n\n In permutations:");
           for i in ans do 
             Print("\n ");  Print(IDA.LeesUit(g,i));
           od;
        else Print("(trivial group)");      
        fi;
        Print("\n");
    fi;
  fi;
end;

IDA.c8s4p1df1 := function(q) #permutation corr to x->x^p
   local p, ans, i;
   if IDA.readprimepow(q) then
     p := Factors(q); p := p[1];
     ans := [];
     for i in [1..q-1] do
       ans[i] := (i*p) mod (q-1);
       if ans[i] = 0 then ans[i] := q-1; fi;
     od;
     Print(" ",PermList(ans),"\n");
   fi;
end;

IDA.pair2num := function(v,n) #  v edge turn into number, n a big number patch for mystab 
    local vv,h ;
    vv := Copy(v);
    Sort(vv);
    return(vv[1]+vv[2]*n);
end;

IDA.num2pair := function(a,n) #  turn number into pair,  n a big number  patch for mystab 
  local ans;
  ans := [];
  ans[1] := a mod n;
  ans[2] := (a-ans[1])/n;
  return(ans);
end;

IDA.pair2nums := function(v,n) #  turns list of edges into numbers,  patch for mystab 
    local d;
    return(List(v,d -> IDA.pair2num(d,n)));
end;

IDA.num2pairs := function(a,n) #  turn list of numbers into pairs,   patch for mystab 
    local d;
    return(List(a,d -> IDA.num2pair(d,n)));
end;


IDA.mystab := function ( G, d, opr ,n) #copy of GroupOps.Stabilizer for purpose 
                                      #of action on sets of unordered pairs
    local  stb, orb, rep, gen, pnt, img, sch, setn, orbn, pntn, imgn, dn;
        dn := IDA.pair2nums(d,n); Sort(dn);
        orb := [IDA.num2pairs(dn,n)]; orbn := [dn];  
        setn := Copy(orbn); 
        rep := [ G.identity ];
        stb := Subgroup( Parent( G ), [  ] );
        for pntn  in orbn  do
            for gen  in G.generators  do
                pnt := IDA.num2pairs(pntn,n); 
                img := opr( pnt, gen );
                imgn := IDA.pair2nums(img,n); Sort(imgn);
                img :=  IDA.num2pairs(imgn,n);
                if not imgn in setn  then
                    Add( orbn, imgn );
                    Add( orb, img );
                    AddSet( setn, imgn );
                    Add( rep, rep[Position( orb, pnt )] * gen );
                else
                    sch := rep[Position( orb, pnt )] * gen 
                      / rep[Position( orb, img )];
                    if not sch in stb  then
                        stb := Closure( stb, sch );
                    fi;
                fi;
            od;
        od;
    return stb;
end;



IDA.c8s4p1th1 := function(es,m) #given edge set es of a graph on m pts determine aut group
 local esi, ans, i, mm, ok, h;
 mm := 0;
 if IDA.readintmin(m,7,0) then 
   if IsList(es) then
     #turn es into esi, a list of sets and determine max node
     esi :=[]; ok := true;
     for i in [1..Length(es)] do
       h := es[i];
       if IsList(h) and Length(h) = 2 then
         Add(esi,Set(h)); 
         mm := Maximum([mm,h[1],h[2]]);
       else ok := false; Print("Sorry, the ",i,"-th component is not an edge\n");
       fi;
     od;
     if ok then
       if mm>m then 
          Print(" Sorry, in the edges, point numbers occur\n");
          Print(" which are higher than ",m,"\n");
       else
          ans := Group(IDA.mystab(SymmetricGroup(m),Set(esi),IDA.onedgeset,100));
          Print(" The group has order ", Size(ans),"\n");
          Print(" and is generated by\n ");
          IDA.printset(ans.generators,2,0);Print("\n");
       fi;
     fi;
   else Print(" Sorry, ",es," is not a list\n");
   fi;
 fi;
end;


IDA.c8s5p1pr1 := function(glst)  #given gens for subgroup Alt5, 
                                 #find non-normalizing elt for corr subgroup g
  IDA.normalsubgrp(glst,0);
end;


IDA.rewriteDn := function(hlp,n) #the rewrite routine for word in Dn
   local i,j, ii, ans, ans2, ok, carepl, modn, hlp, d, hlst;
   ans := Copy(hlp); ans2 := [];
   ok := true;
   carepl := [];
   for i in [1..n-1] do Add(carepl,2); od;
   Add(carepl,1);
   while ok do
     ok := false;
     i := 0;
     while i < Length(ans)-1 do
       i := i+1;
       if ans[i] = 1 then
          ans2 := List([1..i-1], d -> ans[d]);
          if ans[i+1] = 2 then
             ok := true;
             Append(ans2,carepl);
          fi;
          Append(ans2,List([i+2..Length(ans)], d-> ans[d]));
          ans := Copy(ans2);
       fi;
     od;
   od;
   modn := true;
   i := 0;
   while modn  and i<Length(ans) do
     i := i+1;
     if ans[i] = 1 then modn := false; fi;
   od;
   if modn then 
     ii := (i mod n);
   else
     i := i-1; ii := i mod n;
   fi;
   ans2 := [];
   for j in [1..ii] do Add(ans2,2); od;
   ii := (Length(ans)-i) mod 2;
   if ii=1 then Add(ans2,1); fi;
   return(ans2);
end;

IDA.c8s6p1df1 := function(str,n) #given word str in Dn rewrite to normalized word
  local hlp, i, hs, ok;
  if IDA.readint(n) then
    hlp := [];
    ok := true;
    i := 0;
    if IDA.readstring(str) then
     while ok and i< Length(str) do
        i := i+1;
        if str[i] = 'a' then Add(hlp,1); 
        elif str[i] = 'c' then Add(hlp,2);
        else Print(" the ",i,"-th letter is neither a nor c\n");
             ok := false;
       fi;
     od;
     if ok then
        hlp := IDA.rewriteDn(hlp,n);
        hs := "";
        for i in hlp do
          if i = 1 then Add(hs,'a'); else Add(hs,'c'); fi;
        od;
        if Length(hs) = 0 then      Print(" (trivial element)\n");
        else                        Print(" ",hs,"\n");
        fi;
     fi;
    fi;
  fi;
end;

IDA.c8s6p1lm1 := function(glst,p)  #find an element of order p in group
 local h, sz, hlp, g, n;
 if IDA.readprime(p) and IDA.readgrp(glst) then
    g := IDA.grp;
    n := PermGroupOps.LargestMovedPoint(g);
    h := Centre(SylowSubgroup(g,p)); sz := Size(h);
    if sz = 1 then 
       Print(" Sorry, ",p," does not divide ",Size(g),", the order of G\n");
    else hlp := Copy(h.generators[1]); sz := Order(g,hlp);
       hlp := hlp^(sz/p);
       Print(" ",hlp);
       if n<8 then Print(" = ");
                   IDA.printgrpelt(IDA.sterk(g,hlp));
       fi;
       Print("\n");
    fi;
 fi;
end;


IDA.grplstord := function(n) #number the groups of given order
    local ans,i,j,k, h,hlp,fn;
    hlp := "Z/"; Append(hlp,String(n));Add(hlp,'Z');
    ans := [hlp];
    fn := Factors(n);
    if n=1 then return(["(trivial group)"]);
    elif IsPrime(n) then 
       return(ans);
    elif Length(fn) = 2 and fn[1] = 2 and fn[2] <> 2 then
       hlp := "D"; Append(hlp,String(fn[2]));
       Add(ans,hlp);
    elif n=4 then
       hlp := "Z/"; Append(hlp,String(2));Add(hlp,'Z');
       Append(hlp,"xZ/"); Append(hlp,String(2));Add(hlp,'Z');
       Add(ans,hlp);
    elif n=8 then
       hlp := "Z/"; Append(hlp,String(4));Add(hlp,'Z');
       Append(hlp,"xZ/"); Append(hlp,String(2));Add(hlp,'Z');
       Add(ans,hlp);
       hlp := "Z/"; Append(hlp,String(2));Add(hlp,'Z');
       Append(hlp,"xZ/"); Append(hlp,String(2));Add(hlp,'Z');
       Append(hlp,"xZ/"); Append(hlp,String(2));Add(hlp,'Z');
       Add(ans,hlp);
       Add(ans,"D4"); Add(ans,"Q8");
    elif n=9 then
       hlp := "Z/"; Append(hlp,String(3));Add(hlp,'Z');
       Append(hlp,"xZ/"); Append(hlp,String(3));Add(hlp,'Z');
       Add(ans,hlp);
    elif n=12 then
       hlp := "Z/"; Append(hlp,String(6));Add(hlp,'Z');
       Append(hlp,"xZ/"); Append(hlp,String(2));Add(hlp,'Z');
       Add(ans,hlp);
       Add(ans,"D6");
       Add(ans,"D3xZ/2Z");
       Add(ans,"A4");
       Add(ans,"Q12");
    else
       return(0);
    fi;
    return(ans);
end;


IDA.permgens := function(gs,k,n) #aid to IDA.c8s6p2th1r, give perm repr for group k of order n
  local i, j, ans, hlp, ok;
  if k=1 then 
     hlp := [];
     for i in [2..n] do Add(hlp,i); od;
     Add(hlp,1);
     return([PermList(hlp)]);
  elif gs[1] ='A' then
     return(AlternatingGroup(n).generators);
  elif gs[1] ='D' and Length(gs) < 4 then
     hlp := [];
     for i in [2..n] do Add(hlp,i); od;
     Add(hlp,1);
     ans := [PermList(hlp)];
     hlp := [];
     for i in [1..n] do Add(hlp,n-i+1); od;
     Add(ans,PermList(hlp));
     return(ans);
  elif gs = "Q8" then
    return([(1,3,2,4)(5,7,6,8),(1,5,2,6)(3,8,4,7)]);
  elif gs = "Q12" then 
    return([(1,4,7,10),(2,5,8,11),(3,6,9,12),
             (1,2,3)(4,6,5)(7,8,9)(10,12,11)]);
  elif n=4 and k=2 then 
    return([(1,2),(3,4)]);
  elif n=8 and k=2 then 
    return([(1,2,3,4),(5,6)]);
  elif n=8 and k=3 then 
    return([(1,2),(3,4),(5,6)]);
  elif n=9 and k=2 then 
    return([(1,2,3),(4,5,6)]);
  elif gs = "Z/6ZxZ/2Z"  then 
    return([(1,2,3,4,5,6),(7,8)]);
  elif gs = "D3xZ/2Z" then
    return([(1,2,3),(2,3),(7,8)]);
  else return(0);
  fi;
end;




IDA.c8s6p2th1 := function(n) #list groups of order n and generating perms
   local h, i, hlp, gs, k;
   if IDA.readintmin(n,13,0) then
       hlp := IDA.grplstord(n);
          for k in [1.. Length(hlp)] do
             gs := hlp[k];
             Print(" ",gs,": ");
             h := IDA.permgens(gs,k,n);
             if h = 0 then 
                Print(" Sorry, can't handle this group\n");
             else
                  Print(h[1],";\n");
                for i in [2..Length(h)-1] do
                  Print("     ",h[i],";\n");
                od;
                  Print("     ",h[Length(h)],".\n");
            fi;
          od;
   fi;
end;



IDA.2x2x2cube := function(prm)
  Print(" It may take a while to find the group element....\n");
  Print(" ");
  IDA.printgrpelt(IDA.sterk(IDA.2x2x2cubegrp,prm));
  Print("\n");
end;

