DirectSumCartanMat:=DirectSumMat;

SimpleReflexionMatrices:=mat->CoxeterGroup(mat).matgens;

Rootsystem:=mat->CoxeterGroup(mat).roots;

PermRepresentationRoots:=function(mats,roots)
  return List(roots*mats,SortingPerm)/SortingPerm(roots);end;

Weyl:=CoxeterGroup;

PermWeylWord:=PermCoxeterWord;

WeylWordPerm:=CoxeterWord;

WeylLengthPerm:=CoxeterLength;

ReducedWeylWord:=ReducedCoxeterWord;

LongestWeylWord:=LongestCoxeterWord;

WeylReflections:=W->List(Reflections(W),x->CoxeterWord(W,x));

WeylRightCosetRepresentatives:=function(W,I,J)
    return List(ReducedRightCosetRepresentatives(
                   ReflectionSubgroup(W,W.rootInclusion{I}),
                   ReflectionSubgroup(W,W.rootInclusion{J})),
                   x->CoxeterWord(W,x));
end;

WeylCosetPermRepresentation:=function(W,I)
  return PermCosetsSubgroup(W,ReflectionSubgroup(W,W.rootInclusion{I})); 
end;

WeylElements:=CoxeterWords;

WeylConjugacyClasses:=CoxeterConjugacyClasses;

WeylMueMat:=KLMueMat;

KLCoefficient:=KazhdanLusztigCoefficient;

WeylClassPolynomials:=function(arg)
  Print("#W does not exist any more, use\n");
  Print("#W 'HeckeClassPolynomials(arg)'\n");
end;

CharHeckeRepresentation:=CharRepresentationWords;

HeckeCharTable:=function(arg)
  Print("#W does not exist any more, use\n");
  Print("#W 'CharTable(Hecke(CoxeterGroup(arg)))'\n");
end;

HeckeFusion:=function(arg)
  Print("#W does not exist any more, use specializations and see\n");
  Print("#W 'InductionTable'\n");
end;

HeckePowermap:=function(arg)
  Print("#W does not exist any more, use specializations and see\n");
  Print("#W 'Character tables for Coxeter groups'\n");
end;

HeckeCharTableDirectProduct:=function(arg)
  Print("#W does not exist any more, just use\n");
  Print("#W 'CharTable(Hecke(CoxeterGroup(arg)))'\n");
end;

HeckeScalarProducts:=function(arg)
  Print("#W does not exist any more, use specializations and work with\n");
  Print("#W 'CharTable(Hecke(CoxeterGroup(arg)))'\n");
end;

HeckeReducedChar:=function(arg)
  Print("#W does not exist any more, use specializations and work with\n");
  Print("#W 'CharTable(Hecke(CoxeterGroup(arg)))'\n");
end;

#############################################################################
##
#F  ParametersCentralizers( <W> ) . . parameters for the conjugacy classes of
##  centralizers  of  semisimple elements  in a  Chevalley group with a given
##  Coxeter group
##
##  'ParametersCentralizers' returns a  list   of   pairs  which parametrizes 
##  the  conjugacy classes  of  centralizers  of  semisimple  elements  in  a 
##  Chevalley group with Coxeter group <W>. Each pair consists of a subset 
##  which contains fundamental roots or the highest root in the root system of 
##  <W>, and an element in the normalizer in <W> of the subgroup generated by 
##  the  reflections along the roots in the given subset. 
## 
ParametersCentralizers := function ( W )
    local  closure, x, n, t, te, W1, i, j, k, cp;
    closure := function ( W, l )
          local  i, j, n, r, nn, x, p;
          if l = [  ]  then
              return [  ];
          fi;
          r := W.roots;
          n := List( l, function ( i )
                  return r[i];
              end );
          n := Set( Concatenation( n, -1 * n ) );
          nn := Copy( l );
          for i  in l  do
              if i > W.N  then
                  Add( nn, i - W.N );
              else
                  Add( nn, i + W.N );
              fi;
          od;
          for i  in n  do
              for j  in n  do
                  x := i + j;
                  p := Position( r, x );
                  if p <> false and not x in n  then
                      Add( n, x );
                      Add( nn, p );
                      if not -1 * x in n  then
                          Add( n, -1 * x );
                          if p > W.N  then
                              Add( nn, p - W.N );
                          else
                              Add( nn, p + W.N );
                          fi;
                      fi;
                  fi;
              od;
          od;
          Sort( nn );
          return nn;
      end;
    te := Combinations( [ 1 .. W.semisimpleRank ] );
    Sort( te, function ( i, j )
          if Length( i ) = Length( j )  then
              return i <= j;
          else
              return Length( i ) < Length( j );
          fi;
      end );
    W1 := Group( W.generators, () );
    t := [  ];
    n := 0;
    for i  in te  do
        if ForAll( t, function ( j )
                  return Size( i ) <> Size( j ) 
                    or PermGroupOps.RepresentativeSet( W1, j, i ) = false;
              end )  then
            Add( t, i );
            n := n + 1;
        fi;
    od;
    for i  in te  do
        if i <> [ 1 .. W.semisimpleRank ]  then
            j := Concatenation( i, [ 2*W.N ] );
            if ForAll( t, function ( k )
                      return Size( k ) <> Size( j ) 
                        or PermGroupOps.RepresentativeSet( W1, j, k ) = false;
                  end )  then
                Add( t, j );
                n := n + 1;
            fi;
        fi;
    od;
    Sort( t, function ( i, j )
          return IsSubset( closure( W, j ), closure( W, i ) );
      end );
    InfoChevie( "#I  Number of Psi's = ", n, "\c" );
    n := 0;
    cp := [  ];
    for i  in t  do
        x := ConjugacyClasses( PermGroupOps.StabilizerSet( W1, i ) );
        n := n + Length( x );
        InfoChevie( "\n#I  ", Length( x ), " conjugacy classes " );
        Add( cp, List( x, function ( j )
                return CoxeterWord( W, j.representative );
            end ) );
    od;
    InfoChevie( "\n", "#I  Number of Pairs = ", n, "" );
    t := List( [ 1 .. Length( t ) ], function ( i )
            return List( cp[i], function ( j )
                    return [ t[i], j ];
                end );
        end );
    InfoChevie( "\n" );
    return Iterated( t, Concatenation );
end;

