#############################################################################
##
#A  ctcychck.g                   CHEVIE library                  Gunter Malle
##
#A  $Id: ctcychck.g,v 1.1 1997/01/21 13:46:27 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This is a preliminary file containing character tables of some
##  exceptional cyclotomic Hecke algebras.
##


##########################################################################
##
#F  Hecke( <G>, <para> ) . . . Hecke algebra for complex reflection groups
##
##  'Hecke' returns the cyclotomic Hecke algebra corresponding to the
##  complex reflection group <G>, with parameters <para>.
##
CycHeckeOps:=OperationsRecord("CycHeckeOps");
CycHeckeOps.Print:=function(CH)
  Print("Hecke(",ComplexReflectionGroup(CH),",",CH.parameter,")");
end;

CycHeckeOps.CharTable:=function(CH)
  local Name;
  Name:=ComplexReflectionGroup(CH).name;
  if Name="G4" then
    return HeckeCharTableG4(CH.parameter);
  elif Name="G5" then
    return HeckeCharTableG5(CH.parameter);
  elif Name="G6" then
    return HeckeCharTableG6(CH.parameter);
  elif Name="G8" then
    return HeckeCharTableG8(CH.parameter);
  elif Name="G9" then
    return HeckeCharTableG9(CH.parameter);
  elif Name="G12" then
    return HeckeCharTableG12(CH.parameter);
  elif Name="G25" then
    return HeckeCharTableG25(CH.parameter);
  elif Length(Name)>4 and Name{[Length(Name)-4..Length(Name)]}=",1,1)" then
    return HeckeCharTableCyclic(ComplexReflectionGroup(CH).degrees[1],
                                                            CH.parameter);
  else
    Error("not yet implemented\n");
  fi;
end;

CycHeckeOps.SchurElements:=H->CharTable(H).schurelements;

ComplexGroupOps.Hecke:=function(G,para)
  local un;
  if IsList(para) then
    un:=para[1]^0;
  else
    un:=para^0;
  fi;
  return rec(complexGroup:=G,isGroup:=true,isDomain:=true,
	     parameter:=para,unit:=un,operations:=CycHeckeOps); 
end;

ComplexGroupOps.Group:=H->H.complexGroup;

##########################################################################
##
#F  HeckeCharTableCyclic( <m>, <para> )  . . . . . . . . . . . . . . . .
##  . . . . character table of the cyclotomic Hecke algebra of cyclic type
##
##
HeckeCharTableCyclic:=function(m,para)
  local i, p;
  if IsList(para) then
    p:= para; 
  else
    for i in [1..m] do p:=Concatenation([para],List([1..m-1],i->E(m)^i)); od;
  fi;
  return rec(name:=ConcatenationString("H(Z(",String(m),"))"), 
      identifier:=ConcatenationString("H(Z(",String(m),"))"), 
      size:=m, parameter:=List([1..m],i->p[i]),
      dim:=1, degrees:=[m], reflchar:=2, reflclasses:=[2],
      classtext:=List([1..m],i->List([1..i-1],j->1)),
      orders:=List([0..m-1],i->m/Gcd(i,m)),
      centralizers:=List([0..m-1],i->m), classes:=List([0..m-1],i->1),
      powermap:=[],
      irreducibles:=List([1..m],i->List([0..m-1],j->p[i]^j)),
      schurelements:=List([1..m],
            i->Product(List(Concatenation([1..i-1],[i+1..m]),
                  j->(p[i]-p[j])/p[j]))),
      irredinfo:=List([0..m-1],  i-> rec( charname :=
            ConcatenationString("phi_{1,",String(i),"}"))),
      operations:=CharTableOps);
end;

##########################################################################
##
#F HeckeCharTableG4( <para> )  . . . . . . . . . . . Shephard-Todd type G4
##
## returns the character table of type G4 in the Shephard-Todd 
## classification. The variable <para> is a single value or a list of
## three parameters.
##
HeckeCharTableG4:=function(para)
  local u1,u2,u3;
  if IsList(para) then
    u1:=para[1];  u2:=para[2];  u3:=para[3];
  else
    u1:=para;     u2:=E(3);     u3:=E(3)^2;
  fi;
  return rec( name:="H(G4)", identifier:="H(G4)", parameter:=[u1,u2,u3], 
  size:=24,
  dim:=2, degrees:=[4,6], reflchar:=4, reflclasses:=[3],
  classtext:= [[],[1,2,1,2,1,2],[1],[1,1],[1,2,1],[1,2],[1,2,1,2,1,2,1,2,1,2]],
#    classnames:=[],
  orders:=[1,2,3,3,4,6,6], centralizers:=[24,24,6,6,4,6,6],
  classes:=[1,1,4,4,6,4,4], powermap:=[,[1,1,4,3,2,3,4], [1,2,1,1,5,2,2]],
  irreducibles:= [
    [1,u1^6,u1,u1^2,u1^3,u1^2,u1^10],
    [1,u2^6,u2,u2^2,u2^3,u2^2,u2^10],
    [1,u3^6,u3,u3^2,u3^3,u3^2,u3^10],
    [2,-2*u1^3*u2^3,u1+u2,u1^2+u2^2,0,u1*u2,u1^5*u2^5],
    [2,-2*u1^3*u3^3,u1+u3,u1^2+u3^2,0,u1*u3,u1^5*u3^5],
    [2,-2*u2^3*u3^3,u2+u3,u2^2+u3^2,0,u2*u3,u2^5*u3^5],
    [3,3*u1^2*u2^2*u3^2,u1+u2+u3,u1^2+u2^2+u3^2,-u1*u2*u3,0,0]],
  schurelements:=[
   (u1^2+u2*u3)*(u1-u3)*(u1^2-u1*u3+u3^2)*(u1-u2)*(u1^2-u1*u2+u2^2)/u2^4/u3^4,
   (u1*u3+u2^2)*(u2-u3)*(u2^2-u2*u3+u3^2)*(u2-u1)*(u1^2-u1*u2+u2^2)/u1^4/u3^4,
   (u2-u3)*(u2^2-u2*u3+u3^2)*(u1-u3)*(u1^2-u1*u3+u3^2)*(u1*u2+u3^2)/u1^4/u2^4,
   -1/u3^4/u2/u1*(u1*u2+u3^2)*(u1-u3)*(u2-u3)*(u1^2-u1*u2+u2^2),
   (u1*u3+u2^2)*(u1-u2)*(u1^2-u1*u3+u3^2)*(u2-u3)/u3/u1/u2^4,
   -(u1^2+u2*u3)*(u2^2-u2*u3+u3^2)*(-u3+u1)*(u1-u2)/u2/u1^4/u3,
   (u1*u2+u3^2)*(u1*u3+u2^2)*(u1^2+u2*u3)/u1^2/u3^2/u2^2],
  irredinfo:=[ rec( charname := "phi_{1,0}" ), rec(
      charname := "phi_{1,4}" ), rec( charname := "phi_{1,8}" ), rec(
      charname := "phi_{2,1}" ), rec( charname := "phi_{2,3}" ), rec(
      charname := "phi_{2,5}" ), rec( charname := "phi_{3,2}" ) ],
  operations:=CharTableOps); 
end;

##########################################################################
##
#F HeckeCharTableG5( <para> )  . . . . . . . . . . . Shephard-Todd type G5
##
## returns the character table of type G5 in the Shephard-Todd 
## classification. The variable <para> is a single value or a list of
## six parameters.
##
HeckeCharTableG5:=function(para)
  local u1,u2,u3,v1,v2,v3;
  if IsList(para) then
    u1:=para[1]; u2:=para[2]; u3:=para[3];v1:=para[4];v2:=para[5];v3:=para[6];
  else
    u1:=para;    u2:=E(9);    u3:=E(9)^2;  v1:=para;    v2:=E(9);  v3:=E(9)^2;
  fi;
  return rec( name:="H(G5)", identifier:="H(G5)", 
  parameter:=[u1^3,u2^3,u3^3,v1^3,v2^3,v3^3], 
  size:=72,
  dim:=2, degrees:=[6,12], reflchar:=10, reflclasses:=[5,7],
  classtext:= [[],"??"],
#    classnames:=[],
  orders:=[1,2,3,3,3,3,3,3,3,3,4,6,6,6,6,6,6,6,6,12,12],
  centralizers:=[72,72,72,72,18,18,18,18,18,18,12,72,72,18,18,18,18,18,18,12,12],
  classes:=[1,1,1,1,4,4,4,4,4,4,6,1,1,4,4,4,4,4,4,6,6],
  powermap:=[,[1,1,4,3,6,5,8,7,10,9,2,3,4,9,10,7,8,5,6,12,13],
              [1,2,1,1,1,1,1,1,1,1,11,2,2,2,2,2,2,2,2,11,11]],
  irreducibles:= [
  [1,u1^18*v1^18,u1^12*v1^12,u1^24*v1^24,u1^3,u1^6,v1^3,v1^6,u1^12*v1^15,
 u1^15*v1^12,u1^9*v1^9,u1^6*v1^6,u1^30*v1^30,u1^6*v1^12,u1^12*v1^6,u1^9*v1^6,
 u1^18*v1^21,u1^6*v1^9,u1^21*v1^18,u1^3*v1^3,u1^15*v1^15],
  [1,u1^18*v2^18,u1^12*v2^12,u1^24*v2^24,u1^3,u1^6,v2^3,v2^6,u1^12*v2^15,
 u1^15*v2^12,u1^9*v2^9,u1^6*v2^6,u1^30*v2^30,u1^6*v2^12,u1^12*v2^6,u1^9*v2^6,
 u1^18*v2^21,u1^6*v2^9,u1^21*v2^18,u1^3*v2^3,u1^15*v2^15],
  [1,u1^18*v3^18,u1^12*v3^12,u1^24*v3^24,u1^3,u1^6,v3^3,v3^6,u1^12*v3^15,
 u1^15*v3^12,u1^9*v3^9,u1^6*v3^6,u1^30*v3^30,u1^6*v3^12,u1^12*v3^6,u1^9*v3^6,
 u1^18*v3^21,u1^6*v3^9,u1^21*v3^18,u1^3*v3^3,u1^15*v3^15],
  [1,u2^18*v1^18,u2^12*v1^12,u2^24*v1^24,u2^3,u2^6,v1^3,v1^6,u2^12*v1^15,
 u2^15*v1^12,u2^9*v1^9,u2^6*v1^6,u2^30*v1^30,u2^6*v1^12,u2^12*v1^6,u2^9*v1^6,
 u2^18*v1^21,u2^6*v1^9,u2^21*v1^18,u2^3*v1^3,u2^15*v1^15],
  [1,u2^18*v2^18,u2^12*v2^12,u2^24*v2^24,u2^3,u2^6,v2^3,v2^6,u2^12*v2^15,
 u2^15*v2^12,u2^9*v2^9,u2^6*v2^6,u2^30*v2^30,u2^6*v2^12,u2^12*v2^6,u2^9*v2^6,
 u2^18*v2^21,u2^6*v2^9,u2^21*v2^18,u2^3*v2^3,u2^15*v2^15],
  [1,u2^18*v3^18,u2^12*v3^12,u2^24*v3^24,u2^3,u2^6,v3^3,v3^6,u2^12*v3^15,
 u2^15*v3^12,u2^9*v3^9,u2^6*v3^6,u2^30*v3^30,u2^6*v3^12,u2^12*v3^6,u2^9*v3^6,
 u2^18*v3^21,u2^6*v3^9,u2^21*v3^18,u2^3*v3^3,u2^15*v3^15],
  [1,u3^18*v1^18,u3^12*v1^12,u3^24*v1^24,u3^3,u3^6,v1^3,v1^6,u3^12*v1^15,
 u3^15*v1^12,u3^9*v1^9,u3^6*v1^6,u3^30*v1^30,u3^6*v1^12,u3^12*v1^6,u3^9*v1^6,
 u3^18*v1^21,u3^6*v1^9,u3^21*v1^18,u3^3*v1^3,u3^15*v1^15],
  [1,u3^18*v2^18,u3^12*v2^12,u3^24*v2^24,u3^3,u3^6,v2^3,v2^6,u3^12*v2^15,
 u3^15*v2^12,u3^9*v2^9,u3^6*v2^6,u3^30*v2^30,u3^6*v2^12,u3^12*v2^6,u3^9*v2^6,
 u3^18*v2^21,u3^6*v2^9,u3^21*v2^18,u3^3*v2^3,u3^15*v2^15],
  [1,u3^18*v3^18,u3^12*v3^12,u3^24*v3^24,u3^3,u3^6,v3^3,v3^6,u3^12*v3^15,
 u3^15*v3^12,u3^9*v3^9,u3^6*v3^6,u3^30*v3^30,u3^6*v3^12,u3^12*v3^6,u3^9*v3^6,
 u3^18*v3^21,u3^6*v3^9,u3^21*v3^18,u3^3*v3^3,u3^15*v3^15],
  [2,-2*u1^9*v1^9*u2^9*v2^9,2*u1^6*v1^6*u2^6*v2^6,2*u1^12*v1^12*u2^12*v2^12,
 u1^3+u2^3,u1^6+u2^6,v1^3+v2^3,v1^6+v2^6,u1^6*v1^6*u2^6*v2^6*(v1^3+v2^3),
 u1^6*v1^6*u2^6*v2^6*(u1^3+u2^3),0,-2*u1^3*v1^3*u2^3*v2^3,
 -2*u1^15*v1^15*u2^15*v2^15,-u1^3*v1^3*u2^3*v2^3*(v1^6+v2^6),
 -u1^3*v1^3*u2^3*v2^3*(u1^6+u2^6),-u1^3*v1^3*u2^3*v2^3*(u1^3+u2^3),
 -u1^9*v1^9*u2^9*v2^9*(v1^3+v2^3),-u1^3*v1^3*u2^3*v2^3*(v1^3+v2^3),
 -u1^9*v1^9*u2^9*v2^9*(u1^3+u2^3),0,0],
  [2,-2*u1^9*v1^9*u2^9*v3^9,2*u1^6*v1^6*u2^6*v3^6,2*u1^12*v1^12*u2^12*v3^12,
 u1^3+u2^3,u1^6+u2^6,v1^3+v3^3,v1^6+v3^6,u1^6*v1^6*u2^6*v3^6*(v1^3+v3^3),
 u1^6*v1^6*u2^6*v3^6*(u1^3+u2^3),0,-2*u1^3*v1^3*u2^3*v3^3,
 -2*u1^15*v1^15*u2^15*v3^15,-u1^3*v1^3*u2^3*v3^3*(v1^6+v3^6),
 -u1^3*v1^3*u2^3*v3^3*(u1^6+u2^6),-u1^3*v1^3*u2^3*v3^3*(u1^3+u2^3),
 -u1^9*v1^9*u2^9*v3^9*(v1^3+v3^3),-u1^3*v1^3*u2^3*v3^3*(v1^3+v3^3),
 -u1^9*v1^9*u2^9*v3^9*(u1^3+u2^3),0,0],
  [2,-2*u1^9*v2^9*u2^9*v3^9,2*u1^6*v2^6*u2^6*v3^6,2*u1^12*v2^12*u2^12*v3^12,
 u1^3+u2^3,u1^6+u2^6,v2^3+v3^3,v2^6+v3^6,u1^6*v2^6*u2^6*v3^6*(v2^3+v3^3),
 u1^6*v2^6*u2^6*v3^6*(u1^3+u2^3),0,-2*u1^3*v2^3*u2^3*v3^3,
 -2*u1^15*v2^15*u2^15*v3^15,-u1^3*v2^3*u2^3*v3^3*(v2^6+v3^6),
 -u1^3*v2^3*u2^3*v3^3*(u1^6+u2^6),-u1^3*v2^3*u2^3*v3^3*(u1^3+u2^3),
 -u1^9*v2^9*u2^9*v3^9*(v2^3+v3^3),-u1^3*v2^3*u2^3*v3^3*(v2^3+v3^3),
 -u1^9*v2^9*u2^9*v3^9*(u1^3+u2^3),0,0],
  [2,-2*u1^9*v1^9*u3^9*v2^9,2*u1^6*v1^6*u3^6*v2^6,2*u1^12*v1^12*u3^12*v2^12,
 u1^3+u3^3,u1^6+u3^6,v1^3+v2^3,v1^6+v2^6,u1^6*v1^6*u3^6*v2^6*(v1^3+v2^3),
 u1^6*v1^6*u3^6*v2^6*(u1^3+u3^3),0,-2*u1^3*v1^3*u3^3*v2^3,
 -2*u1^15*v1^15*u3^15*v2^15,-u1^3*v1^3*u3^3*v2^3*(v1^6+v2^6),
 -u1^3*v1^3*u3^3*v2^3*(u1^6+u3^6),-u1^3*v1^3*u3^3*v2^3*(u1^3+u3^3),
 -u1^9*v1^9*u3^9*v2^9*(v1^3+v2^3),-u1^3*v1^3*u3^3*v2^3*(v1^3+v2^3),
 -u1^9*v1^9*u3^9*v2^9*(u1^3+u3^3),0,0],
  [2,-2*u1^9*v1^9*u3^9*v3^9,2*u1^6*v1^6*u3^6*v3^6,2*u1^12*v1^12*u3^12*v3^12,
 u1^3+u3^3,u1^6+u3^6,v1^3+v3^3,v1^6+v3^6,u1^6*v1^6*u3^6*v3^6*(v1^3+v3^3),
 u1^6*v1^6*u3^6*v3^6*(u1^3+u3^3),0,-2*u1^3*v1^3*u3^3*v3^3,
 -2*u1^15*v1^15*u3^15*v3^15,-u1^3*v1^3*u3^3*v3^3*(v1^6+v3^6),
 -u1^3*v1^3*u3^3*v3^3*(u1^6+u3^6),-u1^3*v1^3*u3^3*v3^3*(u1^3+u3^3),
 -u1^9*v1^9*u3^9*v3^9*(v1^3+v3^3),-u1^3*v1^3*u3^3*v3^3*(v1^3+v3^3),
 -u1^9*v1^9*u3^9*v3^9*(u1^3+u3^3),0,0],
  [2,-2*u1^9*v2^9*u3^9*v3^9,2*u1^6*v2^6*u3^6*v3^6,2*u1^12*v2^12*u3^12*v3^12,
 u1^3+u3^3,u1^6+u3^6,v2^3+v3^3,v2^6+v3^6,u1^6*v2^6*u3^6*v3^6*(v2^3+v3^3),
 u1^6*v2^6*u3^6*v3^6*(u1^3+u3^3),0,-2*u1^3*v2^3*u3^3*v3^3,
 -2*u1^15*v2^15*u3^15*v3^15,-u1^3*v2^3*u3^3*v3^3*(v2^6+v3^6),
 -u1^3*v2^3*u3^3*v3^3*(u1^6+u3^6),-u1^3*v2^3*u3^3*v3^3*(u1^3+u3^3),
 -u1^9*v2^9*u3^9*v3^9*(v2^3+v3^3),-u1^3*v2^3*u3^3*v3^3*(v2^3+v3^3),
 -u1^9*v2^9*u3^9*v3^9*(u1^3+u3^3),0,0],
  [2,-2*u2^9*v1^9*u3^9*v2^9,2*u2^6*v1^6*u3^6*v2^6,2*u2^12*v1^12*u3^12*v2^12,
 u2^3+u3^3,u2^6+u3^6,v1^3+v2^3,v1^6+v2^6,u2^6*v1^6*u3^6*v2^6*(v1^3+v2^3),
 u2^6*v1^6*u3^6*v2^6*(u2^3+u3^3),0,-2*u2^3*v1^3*u3^3*v2^3,
 -2*u2^15*v1^15*u3^15*v2^15,-u2^3*v1^3*u3^3*v2^3*(v1^6+v2^6),
 -u2^3*v1^3*u3^3*v2^3*(u2^6+u3^6),-u2^3*v1^3*u3^3*v2^3*(u2^3+u3^3),
 -u2^9*v1^9*u3^9*v2^9*(v1^3+v2^3),-u2^3*v1^3*u3^3*v2^3*(v1^3+v2^3),
 -u2^9*v1^9*u3^9*v2^9*(u2^3+u3^3),0,0],
  [2,-2*u2^9*v1^9*u3^9*v3^9,2*u2^6*v1^6*u3^6*v3^6,2*u2^12*v1^12*u3^12*v3^12,
 u2^3+u3^3,u2^6+u3^6,v1^3+v3^3,v1^6+v3^6,u2^6*v1^6*u3^6*v3^6*(v1^3+v3^3),
 u2^6*v1^6*u3^6*v3^6*(u2^3+u3^3),0,-2*u2^3*v1^3*u3^3*v3^3,
 -2*u2^15*v1^15*u3^15*v3^15,-u2^3*v1^3*u3^3*v3^3*(v1^6+v3^6),
 -u2^3*v1^3*u3^3*v3^3*(u2^6+u3^6),-u2^3*v1^3*u3^3*v3^3*(u2^3+u3^3),
 -u2^9*v1^9*u3^9*v3^9*(v1^3+v3^3),-u2^3*v1^3*u3^3*v3^3*(v1^3+v3^3),
 -u2^9*v1^9*u3^9*v3^9*(u2^3+u3^3),0,0],
  [2,-2*u2^9*v2^9*u3^9*v3^9,2*u2^6*v2^6*u3^6*v3^6,2*u2^12*v2^12*u3^12*v3^12,
 u2^3+u3^3,u2^6+u3^6,v2^3+v3^3,v2^6+v3^6,u2^6*v2^6*u3^6*v3^6*(v2^3+v3^3),
 u2^6*v2^6*u3^6*v3^6*(u2^3+u3^3),0,-2*u2^3*v2^3*u3^3*v3^3,
 -2*u2^15*v2^15*u3^15*v3^15,-u2^3*v2^3*u3^3*v3^3*(v2^6+v3^6),
 -u2^3*v2^3*u3^3*v3^3*(u2^6+u3^6),-u2^3*v2^3*u3^3*v3^3*(u2^3+u3^3),
 -u2^9*v2^9*u3^9*v3^9*(v2^3+v3^3),-u2^3*v2^3*u3^3*v3^3*(v2^3+v3^3),
 -u2^9*v2^9*u3^9*v3^9*(u2^3+u3^3),0,0],
  [3,3*u1^6*u2^6*u3^6*v1^6*v2^6*v3^6,3*u1^4*u2^4*u3^4*v1^4*v2^4*v3^4,
 3*u1^8*u2^8*u3^8*v1^8*v2^8*v3^8,u3^3+u1^3+u2^3,u3^6+u1^6+u2^6,v1^3+v2^3+v3^3,
 v1^6+v2^6+v3^6,u1^4*u2^4*u3^4*v1^4*v2^4*v3^4*(v1^3+v2^3+v3^3),
 u1^4*u2^4*u3^4*v1^4*v2^4*v3^4*(u3^3+u1^3+u2^3),-u2^3*u3^3*v1^3*v3^3*u1^3*v2^3,
 3*u1^2*u2^2*u3^2*v1^2*v2^2*v3^2,3*u1^10*u2^10*u3^10*v1^10*v2^10*v3^10,
 u1^2*u2^2*u3^2*v1^2*v2^2*v3^2*(v1^6+v2^6+v3^6),
 u1^2*u2^2*u3^2*v1^2*v2^2*v3^2*(u3^6+u1^6+u2^6),
 u1^2*u2^2*u3^2*v1^2*v2^2*v3^2*(u3^3+u1^3+u2^3),
 u1^6*u2^6*u3^6*v1^6*v2^6*v3^6*(v3^3+v1^3+v2^3),
 u1^2*u2^2*u3^2*v1^2*v2^2*v3^2*(v1^3+v2^3+v3^3),
 u1^6*u2^6*u3^6*v1^6*v2^6*v3^6*(u3^3+u1^3+u2^3),
 -u1*u2*u3*v1*v2*v3,-u1^5*u2^5*u3^5*v1^5*v2^5*v3^5],
  [3,3*u3^6*v1^6*u1^6*v2^6*u2^6*v3^6,3*E(3)^2*v3^4*u2^4*v2^4*u1^4*v1^4*u3^4,
 3*E(3)*v3^8*u2^8*v2^8*u1^8*v1^8*u3^8,u3^3+u1^3+u2^3,u3^6+u1^6+u2^6,v1^3+v2^3+v3^3,
 v1^6+v2^6+v3^6,E(3)^2*(v2^3+v1^3+v3^3)*v3^4*v2^4*v1^4*u2^4*u3^4*u1^4,
 E(3)^2*u1^4*u3^4*v3^4*v2^4*v1^4*u2^4*(u3^3+u1^3+u2^3),
 -u1^3*u2^3*u3^3*v1^3*v2^3*v3^3,3*E(3)*v3^2*u2^2*v2^2*u1^2*v1^2*u3^2,
 3*E(3)^2*v3^10*v2^10*v1^10*u3^10*u2^10*u1^10,
 E(3)*v3^2*u2^2*v2^2*u1^2*v1^2*u3^2*(v1^6+v2^6+v3^6),
 E(3)*v3^2*v2^2*v1^2*u2^2*u3^2*u1^2*(u2^6+u3^6+u1^6),
 E(3)*v3^2*u2^2*v2^2*u1^2*v1^2*u3^2*(u3^3+u1^3+u2^3),
 v3^6*v2^6*v1^6*u2^6*u1^6*u3^6*(v3^3+v1^3+v2^3),
 E(3)*v3^2*v2^2*v1^2*u2^2*u3^2*u1^2*(v2^3+v1^3+v3^3),
 v3^6*v2^6*v1^6*u2^6*u1^6*u3^6*(u3^3+u1^3+u2^3),
 -E(3)^2*u3*v1*u2*v3*u1*v2,-E(3)*u1^5*u2^5*u3^5*v1^5*v2^5*v3^5],
  [3,3*u3^6*v1^6*u1^6*v2^6*u2^6*v3^6,3*E(3)*v3^4*u2^4*v2^4*u1^4*v1^4*u3^4,
 3*E(3)^2*v3^8*u2^8*v2^8*u1^8*v1^8*u3^8,u3^3+u1^3+u2^3,u3^6+u1^6+u2^6,
 v1^3+v2^3+v3^3,v1^6+v2^6+v3^6,E(3)*(v2^3+v1^3+v3^3)*v3^4*v2^4*v1^4*u2^4*u3^4*u1^4,
 E(3)*u1^4*u3^4*v3^4*v2^4*v1^4*u2^4*(u3^3+u1^3+u2^3),
 -u1^3*u2^3*u3^3*v1^3*v2^3*v3^3,3*E(3)^2*v3^2*u2^2*v2^2*u1^2*v1^2*u3^2,
 3*E(3)*v3^10*v2^10*v1^10*u3^10*u2^10*u1^10,
 E(3)^2*v3^2*u2^2*v2^2*u1^2*v1^2*u3^2*(v1^6+v2^6+v3^6),
 E(3)^2*v3^2*v2^2*v1^2*u2^2*u3^2*u1^2*(u2^6+u3^6+u1^6),
 E(3)^2*v3^2*u2^2*v2^2*u1^2*v1^2*u3^2*(u3^3+u1^3+u2^3),
 v3^6*v2^6*v1^6*u2^6*u1^6*u3^6*(v3^3+v1^3+v2^3),
 E(3)^2*v3^2*v2^2*v1^2*u2^2*u3^2*u1^2*(v2^3+v1^3+v3^3),
 v3^6*v2^6*v1^6*u2^6*u1^6*u3^6*(u3^3+u1^3+u2^3),
 -E(3)*u3*v1*u2*v3*u1*v2,-E(3)^2*u1^5*u2^5*u3^5*v1^5*v2^5*v3^5]],
  schurelements:=[
 (v1^3-v2^3)*(u1^3*v1^3+u3^3*v2^3)*(u2^3*v2^3+u1^3*v1^3)
 *(u2^3*u3^3*v2^3*v3^3+u1^6*v1^6)*(v1^3-v3^3)*(u1^3-u3^3)*(u1^3-u2^3)
 *(u1^3*v1^3+u3^3*v3^3)*(u1^3*v1^3+u2^3*v3^3)/u2^12/u3^12/v2^12/v3^12,
 (v2^3-v1^3)*(u1^3*v2^3+u3^3*v1^3)*(u2^3*v1^3+u1^3*v2^3)
 *(u2^3*u3^3*v1^3*v3^3+u1^6*v2^6)*(v2^3-v3^3)*(u1^3-u3^3)*(u1^3-u2^3)
 *(u1^3*v2^3+u3^3*v3^3)*(u1^3*v2^3+u2^3*v3^3)/u2^12/u3^12/v1^12/v3^12,
 (v3^3-v2^3)*(u1^3*v3^3+u3^3*v2^3)*(u2^3*v2^3+u1^3*v3^3)
 *(u2^3*u3^3*v2^3*v1^3+u1^6*v3^6)*(v3^3-v1^3)*(u1^3-u3^3)*(u1^3-u2^3)
 *(u1^3*v3^3+u3^3*v1^3)*(u1^3*v3^3+u2^3*v1^3)/u2^12/u3^12/v1^12/v2^12,
 (v1^3-v2^3)*(u2^3*v1^3+u3^3*v2^3)*(u2^3*v1^3+u1^3*v2^3)
 *(u1^3*u3^3*v2^3*v3^3+u2^6*v1^6)*(v1^3-v3^3)*(u2^3-u3^3)*(u2^3-u1^3)
 *(u2^3*v1^3+u3^3*v3^3)*(u1^3*v3^3+u2^3*v1^3)/u1^12/u3^12/v2^12/v3^12,
 (v2^3-v1^3)*(u2^3*v2^3+u3^3*v1^3)*(u2^3*v2^3+u1^3*v1^3)
 *(u1^3*u3^3*v1^3*v3^3+u2^6*v2^6)*(v2^3-v3^3)*(u2^3-u3^3)*(u2^3-u1^3)
 *(u2^3*v2^3+u3^3*v3^3)*(u2^3*v2^3+u1^3*v3^3)/u1^12/u3^12/v1^12/v3^12,
 (v3^3-v2^3)*(u2^3*v3^3+u3^3*v2^3)*(u1^3*v2^3+u2^3*v3^3)
 *(u1^3*u3^3*v2^3*v1^3+u2^6*v3^6)*(v3^3-v1^3)*(u2^3-u3^3)*(u2^3-u1^3)
 *(u2^3*v3^3+u3^3*v1^3)*(u1^3*v1^3+u2^3*v3^3)/u1^12/u3^12/v1^12/v2^12,
 (v1^3-v2^3)*(u1^3*v2^3+u3^3*v1^3)*(u2^3*v2^3+u3^3*v1^3)
 *(u2^3*u1^3*v2^3*v3^3+u3^6*v1^6)*(v1^3-v3^3)*(u3^3-u1^3)*(u3^3-u2^3)
 *(u1^3*v3^3+u3^3*v1^3)*(u2^3*v3^3+u3^3*v1^3)/u1^12/u2^12/v2^12/v3^12,
 (v2^3-v1^3)*(u1^3*v1^3+u3^3*v2^3)*(u2^3*v1^3+u3^3*v2^3)
 *(u2^3*u1^3*v1^3*v3^3+u3^6*v2^6)*(v2^3-v3^3)*(u3^3-u1^3)*(u3^3-u2^3)
 *(u1^3*v3^3+u3^3*v2^3)*(u2^3*v3^3+u3^3*v2^3)/u1^12/u2^12/v1^12/v3^12,
 (v3^3-v2^3)*(u1^3*v2^3+u3^3*v3^3)*(u2^3*v2^3+u3^3*v3^3)
 *(u2^3*u1^3*v2^3*v1^3+u3^6*v3^6)*(v3^3-v1^3)*(u3^3-u1^3)*(u3^3-u2^3)
 *(u1^3*v1^3+u3^3*v3^3)*(u2^3*v1^3+u3^3*v3^3)/u1^12/u2^12/v1^12/v2^12,
 -(u2^3*v1^3+u1^3*v2^3)*(u2^3*v2^3+u1^3*v1^3)*(v2^3-v3^3)
 *(u2^3*u1^3*v2^3*v1^3+u3^6*v3^6)*(v1^3-v3^3)*(u2^3-u3^3)*(u1^3-u3^3)
 /u1^3/u2^3/u3^12/v1^3/v2^3/v3^12,
 -(u1^3*v3^3+u2^3*v1^3)*(u1^3*v1^3+u2^3*v3^3)*(v3^3-v2^3)
 *(u2^3*u1^3*v1^3*v3^3+u3^6*v2^6)*(v1^3-v2^3)*(u2^3-u3^3)*(u1^3-u3^3)
 /u1^3/u2^3/u3^12/v1^3/v2^12/v3^3,
 -(u1^3*v2^3+u2^3*v3^3)*(u2^3*v2^3+u1^3*v3^3)*(v2^3-v1^3)
 *(u2^3*u1^3*v2^3*v3^3+u3^6*v1^6)*(v3^3-v1^3)*(u2^3-u3^3)*(u1^3-u3^3)
 /u1^3/u2^3/u3^12/v1^12/v2^3/v3^3,
 -(u1^3*v2^3+u3^3*v1^3)*(u1^3*v1^3+u3^3*v2^3)*(v2^3-v3^3)
 *(u1^3*u3^3*v2^3*v1^3+u2^6*v3^6)*(v1^3-v3^3)*(u3^3-u2^3)*(u1^3-u2^3)
 /u1^3/u2^12/u3^3/v1^3/v2^3/v3^12,
 -(u1^3*v3^3+u3^3*v1^3)*(u1^3*v1^3+u3^3*v3^3)*(v3^3-v2^3)
 *(u1^3*u3^3*v1^3*v3^3+u2^6*v2^6)*(v1^3-v2^3)*(u3^3-u2^3)*(u1^3-u2^3)
 /u1^3/u2^12/u3^3/v1^3/v2^12/v3^3,
 -(u1^3*v2^3+u3^3*v3^3)*(u1^3*v3^3+u3^3*v2^3)*(v2^3-v1^3)
 *(u1^3*u3^3*v2^3*v3^3+u2^6*v1^6)*(v3^3-v1^3)*(u3^3-u2^3)*(u1^3-u2^3)
 /u1^3/u2^12/u3^3/v1^12/v2^3/v3^3,
 -(u2^3*v2^3+u3^3*v1^3)*(u2^3*v1^3+u3^3*v2^3)*(v2^3-v3^3)
 *(u2^3*u3^3*v2^3*v1^3+u1^6*v3^6)*(v1^3-v3^3)*(u3^3-u1^3)*(u2^3-u1^3)
 /u1^12/u2^3/u3^3/v1^3/v2^3/v3^12,
 -(u2^3*v3^3+u3^3*v1^3)*(u2^3*v1^3+u3^3*v3^3)*(v3^3-v2^3)
 *(u2^3*u3^3*v1^3*v3^3+u1^6*v2^6)*(v1^3-v2^3)*(u3^3-u1^3)*(u2^3-u1^3)
 /u1^12/u2^3/u3^3/v1^3/v2^12/v3^3,
 -(u2^3*v2^3+u3^3*v3^3)*(u2^3*v3^3+u3^3*v2^3)*(v2^3-v1^3)
 *(u2^3*u3^3*v2^3*v3^3+u1^6*v1^6)*(v3^3-v1^3)*(u3^3-u1^3)*(u2^3-u1^3)
 /u1^12/u2^3/u3^3/v1^12/v2^3/v3^3,
 3*(u1*u2*u3*v1*v2*v3+u2^3*v3^3)*(u1*u2*u3*v1*v2*v3+u1^3*v3^3)
 *(u1*u2*u3*v1*v2*v3+u3^3*v1^3)*(u1*u2*u3*v1*v2*v3+u2^3*v1^3)
 *(u1*u2*u3*v1*v2*v3+u1^3*v1^3)*(u1*u2*u3*v1*v2*v3+u3^3*v3^3)
 *(u3^3*v2^3+u1*u2*u3*v1*v2*v3)*(u1^3*v2^3+u1*u2*u3*v1*v2*v3)
 *(u2^3*v2^3+u1*u2*u3*v1*v2*v3)/u1^9/u2^9/u3^9/v1^9/v2^9/v3^9,
 3*(E(3)^2*u1*u2*u3*v1*v2*v3+u2^3*v3^3)*(E(3)^2*u1*u2*u3*v1*v2*v3+u1^3*v3^3)
 *(E(3)^2*u1*u2*u3*v1*v2*v3+u3^3*v1^3)*(E(3)^2*u1*u2*u3*v1*v2*v3+u2^3*v1^3)
 *(E(3)^2*u1*u2*u3*v1*v2*v3+u1^3*v1^3)*(E(3)^2*u1*u2*u3*v1*v2*v3+u3^3*v3^3)
 *(u3^3*v2^3+E(3)^2*u1*u2*u3*v1*v2*v3)*(u1^3*v2^3+E(3)^2*u1*u2*u3*v1*v2*v3)
 *(u2^3*v2^3+E(3)^2*u1*u2*u3*v1*v2*v3)/u1^9/u2^9/u3^9/v1^9/v2^9/v3^9,
 3*(E(3)*u1*u2*u3*v1*v2*v3+u2^3*v3^3)*(E(3)*u1*u2*u3*v1*v2*v3+u1^3*v3^3)
 *(E(3)*u1*u2*u3*v1*v2*v3+u3^3*v1^3)*(E(3)*u1*u2*u3*v1*v2*v3+u2^3*v1^3)
 *(E(3)*u1*u2*u3*v1*v2*v3+u1^3*v1^3)*(E(3)*u1*u2*u3*v1*v2*v3+u3^3*v3^3)
 *(u3^3*v2^3+E(3)*u1*u2*u3*v1*v2*v3)*(u1^3*v2^3+E(3)*u1*u2*u3*v1*v2*v3)
 *(u2^3*v2^3+E(3)*u1*u2*u3*v1*v2*v3)/u1^9/u2^9/u3^9/v1^9/v2^9/v3^9],
  irredinfo:=[ rec( charname := "phi_{1,0}" ), rec(
      charname := "phi_{1,4}'" ), rec( charname := "phi_{1,8}'" ), rec(
      charname := "phi_{1,4}''" ), rec( charname := "phi_{1,8}''" ), rec(
      charname := "phi_{1,12}'" ), rec( charname := "phi_{1,8}'''" ), rec(
      charname := "phi_{1,12}''" ), rec( charname := "phi_{1,16}" ), rec(
      charname := "phi_{2,1}" ), rec( charname := "phi_{2,3}'" ), rec(
      charname := "phi_{2,5}'" ), rec( charname := "phi_{2,3}''" ), rec(
      charname := "phi_{2,5}''" ), rec( charname := "phi_{2,7}'" ), rec(
      charname := "phi_{2,5}'''" ), rec( charname := "phi_{2,7}''" ), rec(
      charname := "phi_{2,9}" ), rec( charname := "phi_{3,2}" ), rec(
      charname := "phi_{3,4}" ), rec( charname := "phi_{3,6}" ) ],
  operations:=CharTableOps); 
end;

##########################################################################
##
#F HeckeCharTableG6( <para> )  . . . . . . . . . . . Shephard-Todd type G6
##
## returns the character table of type G6 in the Shephard-Todd 
## classification. The variable <para> is a single value or a list of
## five parameters.
##
HeckeCharTableG6:=function(para)
  local u1,u2,u3,v1,v2;
  if IsList(para) then
    u1:=para[1];  u2:=para[2];  u3:=para[3];  v1:=para[4];  v2:=para[5];
  else
    u1:=para;     u2:=E(3)^2;     u3:=E(3);   v1:=para;     v2:=E(4);
  fi;
  return rec( name:="H(G6)", identifier:="H(G6)",
   parameter:=[u1^2,u2^2,u3^2,v1^2,v2^2], size:=48,
  dim:=2, degrees:=[4,12], reflchar:=7, reflclasses:=[4,3],
  classtext:= [[],[1,2,1,2,1,2,1,2,1,2,1,2],[2],[1],[1,1],[1,2,1,2,1,2],
   [1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2],[1,2,1,2,1],[1,2,1,2],
   [1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2],[1,2],[1,2,1,2,1,2,1,2,1,2],
   [1,2,1,2,1,2,1,2,1,2,1,2,1,2],[1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2]],
#    classnames:=[],
  orders:=[1,2,2,3,3,4,4,4,6,6,12,12,12,12],
  centralizers:=[48,48,8,12,12,48,48,8,12,12,12,12,12,12],
  classes:=[1,1,6,4,4,1,1,6,4,4,4,4,4,4], 
  powermap:=[,[1,1,1,5,4,2,2,2,4,5,9,10,9,10], [1,2,3,1,1,7,6,8,2,2,6,6,7,7]],
  irreducibles:= [
  [1,u1^12*v1^12,v1^2,u1^2,u1^4,u1^6*v1^6,u1^18*v1^18,u1^6*v1^4,u1^4*v1^4,
 u1^20*v1^20,u1^2*v1^2,u1^10*v1^10,u1^14*v1^14,u1^22*v1^22],
  [1,u2^12*v1^12,v1^2,u2^2,u2^4,u2^6*v1^6,u2^18*v1^18,u2^6*v1^4,u2^4*v1^4,
 u2^20*v1^20,u2^2*v1^2,u2^10*v1^10,u2^14*v1^14,u2^22*v1^22],
  [1,u3^12*v1^12,v1^2,u3^2,u3^4,u3^6*v1^6,u3^18*v1^18,u3^6*v1^4,u3^4*v1^4,
 u3^20*v1^20,u3^2*v1^2,u3^10*v1^10,u3^14*v1^14,u3^22*v1^22],
  [1,u1^12*v2^12,v2^2,u1^2,u1^4,u1^6*v2^6,u1^18*v2^18,u1^6*v2^4,u1^4*v2^4,
 u1^20*v2^20,u1^2*v2^2,u1^10*v2^10,u1^14*v2^14,u1^22*v2^22],
  [1,u2^12*v2^12,v2^2,u2^2,u2^4,u2^6*v2^6,u2^18*v2^18,u2^6*v2^4,u2^4*v2^4,
 u2^20*v2^20,u2^2*v2^2,u2^10*v2^10,u2^14*v2^14,u2^22*v2^22],
  [1,u3^12*v2^12,v2^2,u3^2,u3^4,u3^6*v2^6,u3^18*v2^18,u3^6*v2^4,u3^4*v2^4,
 u3^20*v2^20,u3^2*v2^2,u3^10*v2^10,u3^14*v2^14,u3^22*v2^22],
  [2,2*u1^6*v1^6*u2^6*v2^6,v1^2+v2^2,u1^2+u2^2,u1^4+u2^4,
 -2*u1^3*v1^3*u2^3*v2^3,-2*u1^9*v1^9*u2^9*v2^9,-u1^3*v1*u2^3*v2*(v1^2+v2^2),
 -u1^2*v1^2*u2^2*v2^2,-u1^10*v1^10*u2^10*v2^10,u1*v1*u2*v2,u1^5*v1^5*u2^5*v2^5,
 u1^7*v1^7*u2^7*v2^7,u1^11*v1^11*u2^11*v2^11],
  [2,2*u1^6*v1^6*u2^6*v2^6,v1^2+v2^2,u1^2+u2^2,u1^4+u2^4,
 2*u1^3*v1^3*u2^3*v2^3,2*u1^9*v1^9*u2^9*v2^9,u1^3*v1*u2^3*v2*(v1^2+v2^2),
 -u1^2*v1^2*u2^2*v2^2,-u1^10*v1^10*u2^10*v2^10,-u1*v1*u2*v2,
 -u1^5*v1^5*u2^5*v2^5,-u1^7*v1^7*u2^7*v2^7,-u1^11*v1^11*u2^11*v2^11],
  [2,2*u1^6*v1^6*u3^6*v2^6,v1^2+v2^2,u1^2+u3^2,u1^4+u3^4,
 -2*u1^3*v1^3*u3^3*v2^3,-2*u1^9*v1^9*u3^9*v2^9,-u1^3*v1*u3^3*v2*(v1^2+v2^2),
 -u1^2*v1^2*u3^2*v2^2,-u1^10*v1^10*u3^10*v2^10,u1*v1*u3*v2,u1^5*v1^5*u3^5*v2^5,
 u1^7*v1^7*u3^7*v2^7,u1^11*v1^11*u3^11*v2^11],
  [2,2*u1^6*v1^6*u3^6*v2^6,v1^2+v2^2,u1^2+u3^2,u1^4+u3^4,
 2*u1^3*v1^3*u3^3*v2^3,2*u1^9*v1^9*u3^9*v2^9,u1^3*v1*u3^3*v2*(v1^2+v2^2),
 -u1^2*v1^2*u3^2*v2^2,-u1^10*v1^10*u3^10*v2^10,-u1*v1*u3*v2,
 -u1^5*v1^5*u3^5*v2^5,-u1^7*v1^7*u3^7*v2^7,-u1^11*v1^11*u3^11*v2^11],
  [2,2*u2^6*v1^6*u3^6*v2^6,v1^2+v2^2,u2^2+u3^2,u2^4+u3^4,
 -2*u2^3*v1^3*u3^3*v2^3,-2*u2^9*v1^9*u3^9*v2^9,-u2^3*v1*u3^3*v2*(v1^2+v2^2),
 -u2^2*v1^2*u3^2*v2^2,-u2^10*v1^10*u3^10*v2^10,u2*v1*u3*v2,u2^5*v1^5*u3^5*v2^5,
 u2^7*v1^7*u3^7*v2^7,u2^11*v1^11*u3^11*v2^11],
  [2,2*u2^6*v1^6*u3^6*v2^6,v1^2+v2^2,u2^2+u3^2,u2^4+u3^4,
 2*u2^3*v1^3*u3^3*v2^3,2*u2^9*v1^9*u3^9*v2^9,u2^3*v1*u3^3*v2*(v1^2+v2^2),
 -u2^2*v1^2*u3^2*v2^2,-u2^10*v1^10*u3^10*v2^10,-u2*v1*u3*v2,
 -u2^5*v1^5*u3^5*v2^5,-u2^7*v1^7*u3^7*v2^7,-u2^11*v1^11*u3^11*v2^11],
  [3,3*u1^4*v1^8*u3^4*v2^4*u2^4,2*v1^2+v2^2,u1^2+u2^2+u3^2,u1^4+u2^4+u3^4,
 3*u1^2*v1^4*u3^2*v2^2*u2^2,3*u1^6*v1^12*u3^6*v2^6*u2^6,
 u2^2*u1^2*u3^2*v1^2*(2*v2^2+v1^2),0,0,0,0,0,0],
  [3,3*u1^4*v2^8*u3^4*v1^4*u2^4,2*v2^2+v1^2,u1^2+u2^2+u3^2,u1^4+u2^4+u3^4,
 3*u1^2*v2^4*u3^2*v1^2*u2^2,3*u1^6*v2^12*u3^6*v1^6*u2^6,
 u2^2*u1^2*u3^2*v2^2*(2*v1^2+v2^2),0,0,0,0,0,0]],
  schurelements:=[
 (-v1^2*u1^4+v2^2*u2^2*u3^2)*(v2^4*u3^4+v1^2*u1^2*v2^2*u3^2+v1^4*u1^4)
 *(v2^4*u2^4+v1^4*u1^4+v1^2*u1^2*v2^2*u2^2)*(u3^2-u1^2)*(u2^2-u1^2)
 *(v2^2-v1^2)/v2^12/u2^8/u3^8,
 (-v1^2*u2^4+v2^2*u1^2*u3^2)*(v2^4*u3^4+v1^2*u2^2*v2^2*u3^2+v1^4*u2^4)
 *(v2^4*u1^4+v1^4*u2^4+v1^2*u1^2*v2^2*u2^2)*(u2^2-u3^2)*(u2^2-u1^2)
 *(v2^2-v1^2)/v2^12/u1^8/u3^8,
 -(-u3^4*v1^2+v2^2*u1^2*u2^2)*(v2^4*u2^4+v1^2*u2^2*v2^2*u3^2+u3^4*v1^4)
 *(v2^4*u1^4+u3^4*v1^4+v1^2*u1^2*v2^2*u3^2)*(u2^2-u3^2)*(u3^2-u1^2)
 *(v2^2-v1^2)/v2^12/u1^8/u2^8,
 (v2^2*u1^4-v1^2*u2^2*u3^2)*(v2^4*u1^4+u3^4*v1^4+v1^2*u1^2*v2^2*u3^2)
 *(v2^4*u1^4+v1^4*u2^4+v1^2*u1^2*v2^2*u2^2)*(u3^2-u1^2)*(u2^2-u1^2)
 *(v2^2-v1^2)/v1^12/u2^8/u3^8,
 (v2^2*u2^4-v1^2*u1^2*u3^2)*(v2^4*u2^4+v1^2*u2^2*v2^2*u3^2+u3^4*v1^4)
 *(v2^4*u2^4+v1^4*u1^4+v1^2*u1^2*v2^2*u2^2)*(u2^2-u3^2)*(u2^2-u1^2)
 *(v2^2-v1^2)/v1^12/u1^8/u3^8,
 -(v2^2*u3^4-v1^2*u1^2*u2^2)*(v2^4*u3^4+v1^2*u2^2*v2^2*u3^2+v1^4*u2^4)
 *(v2^4*u3^4+v1^2*u1^2*v2^2*u3^2+v1^4*u1^4)*(u2^2-u3^2)*(u3^2-u1^2)
 *(v2^2-v1^2)/v1^12/u1^8/u2^8,
 2*(u2^2-u3^2)*(u3^2-u1^2)*(v1^2*u2^2-v1*u1*v2*u2+v2^2*u1^2)
 *(v2^2*u2^2-v1*u1*v2*u2+v1^2*u1^2)*(v1*u1*u2+v2*u3^2)*(v2*u1*u2+v1*u3^2)
 /v1^3/v2^3/u1^2/u2^2/u3^8,
 2*(u2^2-u3^2)*(u3^2-u1^2)*(v1^2*u2^2+v2^2*u1^2+v1*u1*v2*u2)
 *(v2^2*u2^2+v1^2*u1^2+v1*u1*v2*u2)*(v2*u3^2-v1*u1*u2)*(v1*u3^2-v2*u1*u2)
 /v1^3/v2^3/u1^2/u2^2/u3^8,
 -2*(u2^2-u3^2)*(u2^2-u1^2)*(v1^2*u3^2-v1*u1*v2*u3+v2^2*u1^2)
 *(v2^2*u3^2-v1*u1*v2*u3+v1^2*u1^2)*(v1*u1*u3+v2*u2^2)*(v2*u1*u3+v1*u2^2)
 /v1^3/v2^3/u1^2/u3^2/u2^8,
 -2*(u2^2-u3^2)*(u2^2-u1^2)*(v1^2*u3^2+v2^2*u1^2+v1*u1*v2*u3)
 *(v2^2*u3^2+v1^2*u1^2+v1*u1*v2*u3)*(v2*u2^2-v1*u1*u3)*(v1*u2^2-v2*u1*u3)
 /v1^3/v2^3/u1^2/u3^2/u2^8,
 -2*(u3^2-u1^2)*(u2^2-u1^2)*(v1^2*u3^2-v1*u2*v2*u3+v2^2*u2^2)
 *(v2^2*u3^2-v1*u2*v2*u3+v1^2*u2^2)*(v1*u2*u3+v2*u1^2)*(v2*u2*u3+v1*u1^2)
 /v1^3/v2^3/u2^2/u3^2/u1^8,
 -2*(u3^2-u1^2)*(u2^2-u1^2)*(v1^2*u3^2+v2^2*u2^2+v1*u2*v2*u3)
 *(v2^2*u3^2+v1^2*u2^2+v1*u2*v2*u3)*(v2*u1^2-v1*u2*u3)*(v1*u1^2-v2*u2*u3)
 /v1^3/v2^3/u2^2/u3^2/u1^8,
 (v2^2-v1^2)*(u3^4*v1^2-v2^2*u1^2*u2^2)*(-v1^2*u1^4+v2^2*u2^2*u3^2)
 *(-v1^2*u2^4+v2^2*u1^2*u3^2)/v1^2/v2^6/u2^4/u1^4/u3^4,
 -(v2^2-v1^2)*(v2^2*u3^4-v1^2*u1^2*u2^2)*(-v2^2*u1^4+v1^2*u2^2*u3^2)
 *(-v2^2*u2^4+v1^2*u1^2*u3^2)/v1^6/u3^4/u2^4/v2^2/u1^4],
  irredinfo:=[ rec( charname := "phi_{1,0}" ), rec(
      charname := "phi_{1,4}" ), rec( charname := "phi_{1,8}" ), rec(
      charname := "phi_{1,6}" ), rec( charname := "phi_{1,10}" ), rec(
      charname := "phi_{1,14}" ), rec( charname := "phi_{2,1}" ), rec(
      charname := "phi_{2,3}'" ), rec( charname := "phi_{2,5}'" ), rec(
      charname := "phi_{2,3}''" ), rec( charname := "phi_{2,5}''" ), rec(
      charname := "phi_{2,7}" ), rec( charname := "phi_{3,2}" ), rec(
      charname := "phi_{3,4}" ) ],
  operations:=CharTableOps); 
end;

##########################################################################
##
#F HeckeCharTableG8( <para> )  . . . . . . . . . . . Shephard-Todd type G8
##
## returns the character table of type G8 in the Shephard-Todd 
## classification. The variable <para> is a single value or a list of
## four parameters.
##
HeckeCharTableG8:=function(para)
  local u1,u2,u3,u4;
  if IsList(para) then
    u1:=para[1];  u2:=para[2];  u3:=para[3];  u4:=para[4];
  else
    u1:=para;     u2:=E(8);     u3:=E(4);     u4:=E(8)^7;
  fi;
  return rec( name:="H(G8)", identifier:="H(G8)",
  parameter:=[u1^2,u2^2,u3^2,u4^2], size:=96,
  dim:=2, degrees:=[8,12], reflchar:=5, reflclasses:=[7],
  classtext:= [[],[1,2,1,2,1,2,1,2,1,2,1,2],[1,1],[1,2,1,2,1,2,1,2],
   [1,2,1,2,1,2],[1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2],[1],[1,1,1],
   [1,1,2,2],[2,1,1,2,1,1,1],[1,2,2,2,1,1,2,2,2],[1,2,1,2],[1,2,1],
    [1,2,1,1,2,1,1,2,1],[1,2],[1,2,1,2,1,2,1,2,1,2,1,2,1,2]],
#    classnames:=[],
  orders:=[1,2,2,3,4,4,4,4,4,4,4,6,8,8,12,12],
  centralizers:=[96,96,16,12,96,96,16,16,16,16,16,12,8,8,12,12],
  classes:=[1,1,6,8,1,1,6,6,6,6,6,8,12,12,8,8], 
  powermap:=[, [ 1,1,1,4,2,2,3,3,2,3,3,4,5,6,12,12],
                 [1,2,3,1,6,5,8,7,9,11,10,2,14,13,5,6]],
  irreducibles:= [
  [1,u1^24,u1^4,u1^16,u1^12,u1^36,u1^2,u1^6,u1^16,u1^14,u1^26,u1^8,u1^6,u1^18,
 u1^4,u1^28],
  [1,u2^24,u2^4,u2^16,u2^12,u2^36,u2^2,u2^6,u2^16,u2^14,u2^26,u2^8,u2^6,u2^18,
 u2^4,u2^28],
  [1,u3^24,u3^4,u3^16,u3^12,u3^36,u3^2,u3^6,u3^16,u3^14,u3^26,u3^8,u3^6,u3^18,
 u3^4,u3^28],
  [1,u4^24,u4^4,u4^16,u4^12,u4^36,u4^2,u4^6,u4^16,u4^14,u4^26,u4^8,u4^6,u4^18,
 u4^4,u4^28],
  [2,2*u1^12*u2^12,u1^4+u2^4,-u1^8*u2^8,-2*u1^6*u2^6,-2*u1^18*u2^18,u1^2+u2^2,
 u1^6+u2^6,-u1^6*u2^6*(u1^4+u2^4),-u1^6*u2^6*(u1^2+u2^2),u1^12*u2^12*(u1^2+u2^2),
 -u1^4*u2^4,0,0,u1^2*u2^2,u1^14*u2^14],
  [2,2*u1^12*u3^12,u1^4+u3^4,-u1^8*u3^8,-2*u1^6*u3^6,-2*u1^18*u3^18,u1^2+u3^2,
 u1^6+u3^6,-u1^6*u3^6*(u1^4+u3^4),-u1^6*u3^6*(u1^2+u3^2),u1^12*u3^12*(u1^2+u3^2),
 -u1^4*u3^4,0,0,u1^2*u3^2,u1^14*u3^14],
  [2,2*u1^12*u4^12,u1^4+u4^4,-u1^8*u4^8,-2*u1^6*u4^6,-2*u1^18*u4^18,u1^2+u4^2,
 u1^6+u4^6,-u1^6*u4^6*(u1^4+u4^4),-u1^6*u4^6*(u1^2+u4^2),u1^12*u4^12*(u1^2+u4^2),
 -u1^4*u4^4,0,0,u1^2*u4^2,u1^14*u4^14],
  [2,2*u2^12*u3^12,u2^4+u3^4,-u2^8*u3^8,-2*u2^6*u3^6,-2*u2^18*u3^18,u2^2+u3^2,
 u2^6+u3^6,-u2^6*u3^6*(u2^4+u3^4),-u2^6*u3^6*(u2^2+u3^2),u2^12*u3^12*(u2^2+u3^2),
 -u2^4*u3^4,0,0,u2^2*u3^2,u2^14*u3^14],
  [2,2*u2^12*u4^12,u2^4+u4^4,-u2^8*u4^8,-2*u2^6*u4^6,-2*u2^18*u4^18,u2^2+u4^2,
 u2^6+u4^6,-u2^6*u4^6*(u2^4+u4^4),-u2^6*u4^6*(u2^2+u4^2),u2^12*u4^12*(u2^2+u4^2),
 -u2^4*u4^4,0,0,u2^2*u4^2,u2^14*u4^14],
  [2,2*u3^12*u4^12,u3^4+u4^4,-u3^8*u4^8,-2*u3^6*u4^6,-2*u3^18*u4^18,u3^2+u4^2,
 u3^6+u4^6,-u3^6*u4^6*(u3^4+u4^4),-u3^6*u4^6*(u3^2+u4^2),u3^12*u4^12*(u3^2+u4^2),
 -u3^4*u4^4,0,0,u3^2*u4^2,u3^14*u4^14],
  [3,3*u1^8*u2^8*u3^8,u1^4+u2^4+u3^4,0,3*u1^4*u2^4*u3^4,3*u1^12*u2^12*u3^12,
 u1^2+u2^2+u3^2,u1^6+u2^6+u3^6,u1^4*u2^4*u3^4*(u1^4+u2^4+u3^4),
 u1^4*u2^4*u3^4*(u1^2+u2^2+u3^2),u1^8*u2^8*u3^8*(u1^2+u2^2+u3^2),0,
 -u1^2*u2^2*u3^2,-u1^6*u2^6*u3^6,0,0],
  [3,3*u1^8*u2^8*u4^8,u1^4+u2^4+u4^4,0,3*u1^4*u2^4*u4^4,3*u1^12*u2^12*u4^12,
 u1^2+u2^2+u4^2,u1^6+u2^6+u4^6,u1^4*u2^4*u4^4*(u1^4+u2^4+u4^4),
 u1^4*u2^4*u4^4*(u1^2+u2^2+u4^2),u1^8*u2^8*u4^8*(u1^2+u2^2+u4^2),0,
 -u1^2*u2^2*u4^2,-u1^6*u2^6*u4^6,0,0],
  [3,3*u1^8*u3^8*u4^8,u1^4+u3^4+u4^4,0,3*u1^4*u3^4*u4^4,3*u1^12*u3^12*u4^12,
 u1^2+u3^2+u4^2,u1^6+u3^6+u4^6,u1^4*u3^4*u4^4*(u1^4+u3^4+u4^4),
 u1^4*u3^4*u4^4*(u1^2+u3^2+u4^2),u1^8*u3^8*u4^8*(u1^2+u3^2+u4^2),0,
 -u1^2*u3^2*u4^2,-u1^6*u3^6*u4^6,0,0],
  [3,3*u2^8*u3^8*u4^8,u2^4+u3^4+u4^4,0,3*u2^4*u3^4*u4^4,3*u2^12*u3^12*u4^12,
 u2^2+u3^2+u4^2,u2^6+u3^6+u4^6,u2^4*u3^4*u4^4*(u2^4+u3^4+u4^4),
 u2^4*u3^4*u4^4*(u2^2+u3^2+u4^2),u2^8*u3^8*u4^8*(u2^2+u3^2+u4^2),0,
 -u2^2*u3^2*u4^2,-u2^6*u3^6*u4^6,0,0],
  [4,4*u3^6*u4^6*u2^6*u1^6,u4^4+u1^4+u2^4+u3^4,u1^4*u2^4*u4^4*u3^4,
 4*u3^3*u4^3*u2^3*u1^3,4*u1^9*u2^9*u4^9*u3^9,u4^2+u1^2+u2^2+u3^2,
 u4^6+u1^6+u2^6+u3^6,u3^3*u4^3*u2^3*u1^3*(u4^4+u1^4+u2^4+u3^4),
 u3^3*u4^3*u2^3*u1^3*(u4^2+u1^2+u2^2+u3^2),
 u3^6*u4^6*u2^6*u1^6*(u4^2+u1^2+u2^2+u3^2),u4^2*u2^2*u1^2*u3^2,0,0,u1*u4*u3*u2,
 u1^7*u2^7*u4^7*u3^7],
  [4,4*u3^6*u4^6*u2^6*u1^6,u4^4+u1^4+u2^4+u3^4,u1^4*u2^4*u4^4*u3^4,
 -4*u3^3*u4^3*u2^3*u1^3,-4*u1^9*u2^9*u4^9*u3^9,u4^2+u1^2+u2^2+u3^2,
 u4^6+u1^6+u2^6+u3^6,-u3^3*u4^3*u2^3*u1^3*(u4^4+u1^4+u2^4+u3^4),
 -u3^3*u4^3*u2^3*u1^3*(u4^2+u1^2+u2^2+u3^2),
 u3^6*u4^6*u2^6*u1^6*(u4^2+u1^2+u2^2+u3^2),u4^2*u2^2*u1^2*u3^2,0,0,-u1*u4*u3*u2,
 -u1^7*u2^7*u4^7*u3^7]],
  schurelements:=[
 (u2^2-u1^2)*(u3^2-u1^2)*(u4^2-u1^2)*(u2^4-u1^2*u2^2+u1^4)
 *(u3^4-u1^2*u3^2+u1^4)*(u1^4+u2^2*u3^2)*(u4^4-u1^2*u4^2+u1^4)
 *(u1^4+u2^2*u4^2)*(u1^4+u3^2*u4^2)*(-u1^6+u2^2*u3^2*u4^2)/u2^12/u3^12/u4^12,
 (u2^2-u3^2)*(u4^2-u2^2)*(u2^2-u1^2)*(u3^4-u2^2*u3^2+u2^4)
 *(u4^4-u2^2*u4^2+u2^4)*(u2^4+u3^2*u4^2)*(u2^4-u1^2*u2^2+u1^4)
 *(u2^4+u1^2*u3^2)*(u2^4+u1^2*u4^2)*(-u2^6+u1^2*u3^2*u4^2)/u1^12/u3^12/u4^12,
 (-u3^6+u1^2*u2^2*u4^2)*(u3^4+u2^2*u4^2)*(u3^4+u1^2*u4^2)*(u3^4+u1^2*u2^2)
 *(u4^4-u3^2*u4^2+u3^4)*(u3^4-u2^2*u3^2+u2^4)*(u3^4-u1^2*u3^2+u1^4)
 *(u4^2-u3^2)*(u2^2-u3^2)*(u1^2-u3^2)/u4^12/u2^12/u1^12,
 (u4^2-u2^2)*(u4^2-u3^2)*(u4^2-u1^2)*(u4^4-u2^2*u4^2+u2^4)
 *(u4^4-u3^2*u4^2+u3^4)*(u4^4+u2^2*u3^2)*(u4^4-u1^2*u4^2+u1^4)
 *(u4^4+u1^2*u2^2)*(u4^4+u1^2*u3^2)*(u4^6-u1^2*u2^2*u3^2)/u1^12/u2^12/u3^12,
 (u2^4-u1^2*u2^2+u1^4)*(u3^4+u1^2*u2^2)*(u3^2-u1^2)*(u3^2-u2^2)
 *(u4^4+u1^2*u2^2)*(-u4^2+u1^2)*(u4^2-u2^2)
 *(u3^4*u4^4+u1^2*u2^2*u3^2*u4^2+u1^4*u2^4)/u3^12/u4^12/u2^2/u1^2,
 -(u2^4+u1^2*u3^2)*(-u2^2+u1^2)*(u3^4-u1^2*u3^2+u1^4)*(u3^2-u2^2)
 *(u4^4+u1^2*u3^2)*(-u4^2+u1^2)*(-u4^2+u3^2)
 *(u2^4*u4^4+u1^2*u2^2*u3^2*u4^2+u3^4*u1^4)/u2^12/u4^12/u3^2/u1^2,
 -(u2^4+u1^2*u4^2)*(-u2^2+u1^2)*(u3^4+u1^2*u4^2)*(u3^2-u1^2)
 *(u4^4-u1^2*u4^2+u1^4)*(u4^2-u2^2)*(-u4^2+u3^2)
 *(u3^4*u2^4+u1^2*u2^2*u3^2*u4^2+u1^4*u4^4)/u3^12/u2^12/u1^2/u4^2,
 -(u1^4+u2^2*u3^2)*(-u2^2+u1^2)*(u3^2-u1^2)*(u3^4-u2^2*u3^2+u2^4)
 *(u4^4+u2^2*u3^2)*(u4^2-u2^2)*(-u4^2+u3^2)
 *(u3^4*u2^4+u1^2*u2^2*u3^2*u4^2+u1^4*u4^4)/u1^12/u4^12/u3^2/u2^2,
 -(u1^4+u2^2*u4^2)*(-u2^2+u1^2)*(u3^4+u2^2*u4^2)*(u3^2-u2^2)
 *(u4^4-u2^2*u4^2+u2^4)*(-u4^2+u1^2)*(-u4^2+u3^2)
 *(u2^4*u4^4+u1^2*u2^2*u3^2*u4^2+u3^4*u1^4)/u3^12/u1^12/u4^2/u2^2,
 (u1^4+u3^2*u4^2)*(u2^4+u3^2*u4^2)*(u3^2-u1^2)*(u3^2-u2^2)*(-u4^2+u1^2)
 *(u4^2-u2^2)*(u4^4-u3^2*u4^2+u3^4)*(u3^4*u4^4+u1^2*u2^2*u3^2*u4^2+u1^4*u2^4)
 /u2^12/u1^12/u4^2/u3^2,
 (u2^4+u1^2*u3^2)*(u3^4+u1^2*u2^2)*(u1^4+u2^2*u3^2)*(u4^6-u1^2*u2^2*u3^2)
 *(u4^2-u2^2)*(u4^2-u3^2)*(u4^2-u1^2)/u4^12/u3^4/u2^4/u1^4,
 -(u2^4+u1^2*u4^2)*(u4^4+u1^2*u2^2)*(u1^4+u2^2*u4^2)*(-u3^6+u1^2*u2^2*u4^2)
 *(u2^2-u3^2)*(u4^2-u3^2)*(u3^2-u1^2)/u3^12/u4^4/u2^4/u1^4,
 (u3^4+u1^2*u4^2)*(u4^4+u1^2*u3^2)*(u1^4+u3^2*u4^2)*(-u2^6+u1^2*u3^2*u4^2)
 *(u2^2-u3^2)*(u4^2-u2^2)*(u2^2-u1^2)/u2^12/u4^4/u3^4/u1^4,
 (u3^4+u2^2*u4^2)*(u4^4+u2^2*u3^2)*(u2^4+u3^2*u4^2)*(-u1^6+u2^2*u3^2*u4^2)
 *(u3^2-u1^2)*(u4^2-u1^2)*(u2^2-u1^2)/u1^12/u4^4/u3^4/u2^4,
-2*(u3*u1*u2-u4^3)*(u4*u3*u2-u1^3)*(u4*u1*u2-u3^3)*(u2^3-u3*u1*u4)
 *(u1^2*u3^2-u3*u4*u1*u2+u2^2*u4^2)*(u1^2*u4^2-u3*u4*u1*u2+u2^2*u3^2)
 *(u1^2*u2^2-u3*u4*u1*u2+u3^2*u4^2)/u1^6/u2^6/u3^6/u4^6,
 -2*(u3*u1*u2+u4^3)*(u4*u1*u2+u3^3)*(u2^3+u3*u1*u4)*(u4*u3*u2+u1^3)
 *(u1^2*u2^2+u3*u4*u1*u2+u3^2*u4^2)*(u1^2*u3^2+u3*u4*u1*u2+u2^2*u4^2)
 *(u1^2*u4^2+u3*u4*u1*u2+u2^2*u3^2)/u1^6/u2^6/u3^6/u4^6],
  irredinfo:=[ rec( charname := "phi_{1,0}" ), rec(
      charname := "phi_{1,6}" ), rec( charname := "phi_{1,12}" ), rec(
      charname := "phi_{1,18}" ), rec( charname := "phi_{2,1}" ), rec(
      charname := "phi_{2,4}" ), rec( charname := "phi_{2,7}'" ), rec(
      charname := "phi_{2,7}''" ), rec( charname := "phi_{2,10}" ), rec(
      charname := "phi_{2,13}" ), rec( charname := "phi_{3,2}" ), rec(
      charname := "phi_{3,4}" ), rec( charname := "phi_{3,6}" ), rec(
      charname := "phi_{3,8}" ), rec( charname := "phi_{4,3}" ), rec(
      charname := "phi_{4,5}" ) ],
  operations:=CharTableOps); 
end;


##########################################################################
##
#F HeckeCharTableG9( <para> )  . . . . . . . . . . . Shephard-Todd type G9
##
## returns the character table of type G9 in the Shephard-Todd 
## classification. The variable <para> is a single value or a list of
## six parameters.
##
HeckeCharTableG9:=function(para)
  local u1,u2,u3,u4,v1,v2;
  if IsList(para) then
    u1:=para[1]; u2:=para[2]; u3:=para[3]; u4:=para[4];v1:=para[5];v2:=para[6];
  else
    u1:=para;    u2:=E(16);   u3:=E(16)^2; u4:=E(16)^3; v1:=para^2;  v2:=E(4);
  fi;
  return rec( name:="H(G9)", identifier:="H(G9)",
   parameter:=[u1^4,u2^4,u3^4,u4^4,v1^2,v2^2],
  size:=192, dim:=2, degrees:=[8,24], reflchar:=9, reflclasses:=[8,4],
  classtext:= ["???"],
#    classnames:=[],
  orders:=[1,2,2,2,3,4,4,4,4,4,4,4,4,6,8,8,8,8,8,8,8,8,8,8,8,8,12,12,24,24,24,24],
  centralizers:=[192,192,32,16,24,192,192,32,32,32,32,32,16,24,192,192,192,192,
   32,32,32,32,32,32,16,16,24,24,24,24,24,24],
  classes:=[1,1,6,12,8,1,1,6,6,6,6,6,12,8,1,1,1,1,6,6,6,6,6,6,12,12,8,8,8,8,8,8],
  powermap:=[,
    [1,1,1,1,5,2,2,3,3,2,3,3,2,5,6,7,6,7,10,10,6,7,10,10,6,7,14,14,27,27,28,28],
    [1,2,3,4,1,7,6,9,8,10,12,11,13,2,16,15,18,17,20,19,22,21,23,24,26,25,6,7,15,
     17,18,16]],
  irreducibles:=[
  [1,u1^48*v1^24,u1^8,v1^2,u1^32*v1^16,u1^24*v1^12,u1^72*v1^36,u1^4,u1^12,
 u1^32*v1^12,u1^28*v1^12,u1^52*v1^24,v1^14*u1^24,u1^16*v1^8,u1^12*v1^6,
 u1^36*v1^18,u1^60*v1^30,u1^84*v1^42,u1^24*v1^6,u1^40*v1^18,u1^20*v1^6,
 u1^44*v1^18,u1^16*v1^6,u1^64*v1^30,v1^8*u1^12,v1^20*u1^36,u1^8*v1^4,u1^56*v1^28,
 u1^4*v1^2,u1^20*v1^10,u1^28*v1^14,u1^44*v1^22],
  [1,u1^48*v2^24,u1^8,v2^2,u1^32*v2^16,u1^24*v2^12,u1^72*v2^36,u1^4,u1^12,
 u1^32*v2^12,u1^28*v2^12,u1^52*v2^24,v2^14*u1^24,u1^16*v2^8,u1^12*v2^6,
 u1^36*v2^18,u1^60*v2^30,u1^84*v2^42,u1^24*v2^6,u1^40*v2^18,u1^20*v2^6,
 u1^44*v2^18,u1^16*v2^6,u1^64*v2^30,v2^8*u1^12,v2^20*u1^36,u1^8*v2^4,u1^56*v2^28,
 u1^4*v2^2,u1^20*v2^10,u1^28*v2^14,u1^44*v2^22],
  [1,u2^48*v1^24,u2^8,v1^2,u2^32*v1^16,u2^24*v1^12,u2^72*v1^36,u2^4,u2^12,
 u2^32*v1^12,u2^28*v1^12,u2^52*v1^24,v1^14*u2^24,u2^16*v1^8,u2^12*v1^6,
 u2^36*v1^18,u2^60*v1^30,u2^84*v1^42,u2^24*v1^6,u2^40*v1^18,u2^20*v1^6,
 u2^44*v1^18,u2^16*v1^6,u2^64*v1^30,v1^8*u2^12,v1^20*u2^36,u2^8*v1^4,u2^56*v1^28,
 u2^4*v1^2,u2^20*v1^10,u2^28*v1^14,u2^44*v1^22],
  [1,u2^48*v2^24,u2^8,v2^2,u2^32*v2^16,u2^24*v2^12,u2^72*v2^36,u2^4,u2^12,
 u2^32*v2^12,u2^28*v2^12,u2^52*v2^24,v2^14*u2^24,u2^16*v2^8,u2^12*v2^6,
 u2^36*v2^18,u2^60*v2^30,u2^84*v2^42,u2^24*v2^6,u2^40*v2^18,u2^20*v2^6,
 u2^44*v2^18,u2^16*v2^6,u2^64*v2^30,v2^8*u2^12,v2^20*u2^36,u2^8*v2^4,u2^56*v2^28,
 u2^4*v2^2,u2^20*v2^10,u2^28*v2^14,u2^44*v2^22],
  [1,u3^48*v1^24,u3^8,v1^2,u3^32*v1^16,u3^24*v1^12,u3^72*v1^36,u3^4,u3^12,
 u3^32*v1^12,u3^28*v1^12,u3^52*v1^24,v1^14*u3^24,u3^16*v1^8,u3^12*v1^6,
 u3^36*v1^18,u3^60*v1^30,u3^84*v1^42,u3^24*v1^6,u3^40*v1^18,u3^20*v1^6,
 u3^44*v1^18,u3^16*v1^6,u3^64*v1^30,v1^8*u3^12,v1^20*u3^36,u3^8*v1^4,u3^56*v1^28,
 u3^4*v1^2,u3^20*v1^10,u3^28*v1^14,u3^44*v1^22],
  [1,u3^48*v2^24,u3^8,v2^2,u3^32*v2^16,u3^24*v2^12,u3^72*v2^36,u3^4,u3^12,
 u3^32*v2^12,u3^28*v2^12,u3^52*v2^24,v2^14*u3^24,u3^16*v2^8,u3^12*v2^6,
 u3^36*v2^18,u3^60*v2^30,u3^84*v2^42,u3^24*v2^6,u3^40*v2^18,u3^20*v2^6,
 u3^44*v2^18,u3^16*v2^6,u3^64*v2^30,v2^8*u3^12,v2^20*u3^36,u3^8*v2^4,u3^56*v2^28,
 u3^4*v2^2,u3^20*v2^10,u3^28*v2^14,u3^44*v2^22],
  [1,u4^48*v1^24,u4^8,v1^2,u4^32*v1^16,u4^24*v1^12,u4^72*v1^36,u4^4,u4^12,
 u4^32*v1^12,u4^28*v1^12,u4^52*v1^24,v1^14*u4^24,u4^16*v1^8,u4^12*v1^6,
 u4^36*v1^18,u4^60*v1^30,u4^84*v1^42,u4^24*v1^6,u4^40*v1^18,u4^20*v1^6,
 u4^44*v1^18,u4^16*v1^6,u4^64*v1^30,v1^8*u4^12,v1^20*u4^36,u4^8*v1^4,u4^56*v1^28,
 u4^4*v1^2,u4^20*v1^10,u4^28*v1^14,u4^44*v1^22],
  [1,u4^48*v2^24,u4^8,v2^2,u4^32*v2^16,u4^24*v2^12,u4^72*v2^36,u4^4,u4^12,
 u4^32*v2^12,u4^28*v2^12,u4^52*v2^24,v2^14*u4^24,u4^16*v2^8,u4^12*v2^6,
 u4^36*v2^18,u4^60*v2^30,u4^84*v2^42,u4^24*v2^6,u4^40*v2^18,u4^20*v2^6,
 u4^44*v2^18,u4^16*v2^6,u4^64*v2^30,v2^8*u4^12,v2^20*u4^36,u4^8*v2^4,u4^56*v2^28,
 u4^4*v2^2,u4^20*v2^10,u4^28*v2^14,u4^44*v2^22],
  [2,2*u1^24*v1^12*v2^12*u2^24,u1^8+u2^8,v1^2+v2^2,-u1^16*v1^8*v2^8*u2^16,
 2*u1^12*v1^6*v2^6*u2^12,2*u1^36*v1^18*v2^18*u2^36,u1^4+u2^4,u1^12+u2^12,
 u1^12*v1^6*v2^6*u2^12*(u1^8+u2^8),u1^12*v1^6*v2^6*u2^12*(u1^4+u2^4),
 u1^24*v1^12*v2^12*u2^24*(u1^4+u2^4),u1^12*v1^6*v2^6*u2^12*(v1^2+v2^2),
 -u1^8*v1^4*v2^4*u2^8,2*u1^6*v1^3*v2^3*u2^6,2*u1^18*v1^9*v2^9*u2^18,
 2*u1^30*v1^15*v2^15*u2^30,2*u1^42*v1^21*v2^21*u2^42,
 u1^6*v1^3*v2^3*u2^6*(u1^12+u2^12),u1^18*v1^9*v2^9*u2^18*(u1^4+u2^4),
 u1^6*v1^3*v2^3*u2^6*(u1^8+u2^8),u1^18*v1^9*v2^9*u2^18*(u1^8+u2^8),
 u1^6*v1^3*v2^3*u2^6*(u1^4+u2^4),u1^30*v1^15*v2^15*u2^30*(u1^4+u2^4),
 u1^6*v1^3*v2^3*u2^6*(v1^2+v2^2),u1^18*v1^9*v2^9*u2^18*(v1^2+v2^2),
 -u1^4*v1^2*u2^4*v2^2,-u1^28*v1^14*v2^14*u2^28,-v2*u1^2*u2^2*v1,
 -u1^10*v1^5*v2^5*u2^10,-u1^14*v1^7*v2^7*u2^14,-u1^22*v1^11*v2^11*u2^22],
  [2,2*u1^24*v1^12*v2^12*u2^24,u1^8+u2^8,v1^2+v2^2,-u1^16*v1^8*v2^8*u2^16,
 2*u1^12*v1^6*v2^6*u2^12,2*u1^36*v1^18*v2^18*u2^36,u1^4+u2^4,u1^12+u2^12,
 u1^12*v1^6*v2^6*u2^12*(u1^8+u2^8),u1^12*v1^6*v2^6*u2^12*(u1^4+u2^4),
 u1^24*v1^12*v2^12*u2^24*(u1^4+u2^4),u1^12*v1^6*v2^6*u2^12*(v1^2+v2^2),
 -u1^8*v1^4*v2^4*u2^8,-2*u1^6*v1^3*v2^3*u2^6,-2*u1^18*v1^9*v2^9*u2^18,
 -2*u1^30*v1^15*v2^15*u2^30,-2*u1^42*v1^21*v2^21*u2^42,
 -u1^6*v1^3*v2^3*u2^6*(u1^12+u2^12),-u1^18*v1^9*v2^9*u2^18*(u1^4+u2^4),
 -u1^6*v1^3*v2^3*u2^6*(u1^8+u2^8),-u1^18*v1^9*v2^9*u2^18*(u1^8+u2^8),
 -u1^6*v1^3*v2^3*u2^6*(u1^4+u2^4),-u1^30*v1^15*v2^15*u2^30*(u1^4+u2^4),
 -u1^6*v1^3*v2^3*u2^6*(v1^2+v2^2),-u1^18*v1^9*v2^9*u2^18*(v1^2+v2^2),
 -u1^4*v1^2*u2^4*v2^2,-u1^28*v1^14*v2^14*u2^28,v2*u1^2*u2^2*v1,
 u1^10*v1^5*v2^5*u2^10,u1^14*v1^7*v2^7*u2^14,u1^22*v1^11*v2^11*u2^22],
  [2,2*u1^24*v1^12*v2^12*u3^24,u1^8+u3^8,v1^2+v2^2,-u1^16*v1^8*v2^8*u3^16,
 2*u1^12*v1^6*v2^6*u3^12,2*u1^36*v1^18*v2^18*u3^36,u1^4+u3^4,u1^12+u3^12,
 u1^12*v1^6*v2^6*u3^12*(u1^8+u3^8),u1^12*v1^6*v2^6*u3^12*(u1^4+u3^4),
 u1^24*v1^12*v2^12*u3^24*(u1^4+u3^4),u1^12*v1^6*v2^6*u3^12*(v1^2+v2^2),
 -u1^8*v1^4*v2^4*u3^8,2*u1^6*v1^3*v2^3*u3^6,2*u1^18*v1^9*v2^9*u3^18,
 2*u1^30*v1^15*v2^15*u3^30,2*u1^42*v1^21*v2^21*u3^42,
 u1^6*v1^3*v2^3*u3^6*(u1^12+u3^12),u1^18*v1^9*v2^9*u3^18*(u1^4+u3^4),
 u1^6*v1^3*v2^3*u3^6*(u1^8+u3^8),u1^18*v1^9*v2^9*u3^18*(u1^8+u3^8),
 u1^6*v1^3*v2^3*u3^6*(u1^4+u3^4),u1^30*v1^15*v2^15*u3^30*(u1^4+u3^4),
 u1^6*v1^3*v2^3*u3^6*(v1^2+v2^2),u1^18*v1^9*v2^9*u3^18*(v1^2+v2^2),
 -u1^4*v1^2*u3^4*v2^2,-u1^28*v1^14*v2^14*u3^28,-v2*u1^2*u3^2*v1,
 -u1^10*v1^5*v2^5*u3^10,-u1^14*v1^7*v2^7*u3^14,-u1^22*v1^11*v2^11*u3^22],
  [2,2*u1^24*v1^12*v2^12*u3^24,u1^8+u3^8,v1^2+v2^2,-u1^16*v1^8*v2^8*u3^16,
 2*u1^12*v1^6*v2^6*u3^12,2*u1^36*v1^18*v2^18*u3^36,u1^4+u3^4,u1^12+u3^12,
 u1^12*v1^6*v2^6*u3^12*(u1^8+u3^8),u1^12*v1^6*v2^6*u3^12*(u1^4+u3^4),
 u1^24*v1^12*v2^12*u3^24*(u1^4+u3^4),u1^12*v1^6*v2^6*u3^12*(v1^2+v2^2),
 -u1^8*v1^4*v2^4*u3^8,-2*u1^6*v1^3*v2^3*u3^6,-2*u1^18*v1^9*v2^9*u3^18,
 -2*u1^30*v1^15*v2^15*u3^30,-2*u1^42*v1^21*v2^21*u3^42,
 -u1^6*v1^3*v2^3*u3^6*(u1^12+u3^12),-u1^18*v1^9*v2^9*u3^18*(u1^4+u3^4),
 -u1^6*v1^3*v2^3*u3^6*(u1^8+u3^8),-u1^18*v1^9*v2^9*u3^18*(u1^8+u3^8),
 -u1^6*v1^3*v2^3*u3^6*(u1^4+u3^4),-u1^30*v1^15*v2^15*u3^30*(u1^4+u3^4),
 -u1^6*v1^3*v2^3*u3^6*(v1^2+v2^2),-u1^18*v1^9*v2^9*u3^18*(v1^2+v2^2),
 -u1^4*v1^2*u3^4*v2^2,-u1^28*v1^14*v2^14*u3^28,v2*u1^2*u3^2*v1,
 u1^10*v1^5*v2^5*u3^10,u1^14*v1^7*v2^7*u3^14,u1^22*v1^11*v2^11*u3^22],
  [2,2*u1^24*v1^12*v2^12*u4^24,u1^8+u4^8,v1^2+v2^2,-u1^16*v1^8*v2^8*u4^16,
 2*u1^12*v1^6*v2^6*u4^12,2*u1^36*v1^18*v2^18*u4^36,u1^4+u4^4,u1^12+u4^12,
 u1^12*v1^6*v2^6*u4^12*(u1^8+u4^8),u1^12*v1^6*v2^6*u4^12*(u1^4+u4^4),
 u1^24*v1^12*v2^12*u4^24*(u1^4+u4^4),u1^12*v1^6*v2^6*u4^12*(v1^2+v2^2),
 -u1^8*v1^4*v2^4*u4^8,2*u1^6*v1^3*v2^3*u4^6,2*u1^18*v1^9*v2^9*u4^18,
 2*u1^30*v1^15*v2^15*u4^30,2*u1^42*v1^21*v2^21*u4^42,
 u1^6*v1^3*v2^3*u4^6*(u1^12+u4^12),u1^18*v1^9*v2^9*u4^18*(u1^4+u4^4),
 u1^6*v1^3*v2^3*u4^6*(u1^8+u4^8),u1^18*v1^9*v2^9*u4^18*(u1^8+u4^8),
 u1^6*v1^3*v2^3*u4^6*(u1^4+u4^4),u1^30*v1^15*v2^15*u4^30*(u1^4+u4^4),
 u1^6*v1^3*v2^3*u4^6*(v1^2+v2^2),u1^18*v1^9*v2^9*u4^18*(v1^2+v2^2),
 -u1^4*v1^2*u4^4*v2^2,-u1^28*v1^14*v2^14*u4^28,-v2*u1^2*u4^2*v1,
 -u1^10*v1^5*v2^5*u4^10,-u1^14*v1^7*v2^7*u4^14,-u1^22*v1^11*v2^11*u4^22],
  [2,2*u1^24*v1^12*v2^12*u4^24,u1^8+u4^8,v1^2+v2^2,-u1^16*v1^8*v2^8*u4^16,
 2*u1^12*v1^6*v2^6*u4^12,2*u1^36*v1^18*v2^18*u4^36,u1^4+u4^4,u1^12+u4^12,
 u1^12*v1^6*v2^6*u4^12*(u1^8+u4^8),u1^12*v1^6*v2^6*u4^12*(u1^4+u4^4),
 u1^24*v1^12*v2^12*u4^24*(u1^4+u4^4),u1^12*v1^6*v2^6*u4^12*(v1^2+v2^2),
 -u1^8*v1^4*v2^4*u4^8,-2*u1^6*v1^3*v2^3*u4^6,-2*u1^18*v1^9*v2^9*u4^18,
 -2*u1^30*v1^15*v2^15*u4^30,-2*u1^42*v1^21*v2^21*u4^42,
 -u1^6*v1^3*v2^3*u4^6*(u1^12+u4^12),-u1^18*v1^9*v2^9*u4^18*(u1^4+u4^4),
 -u1^6*v1^3*v2^3*u4^6*(u1^8+u4^8),-u1^18*v1^9*v2^9*u4^18*(u1^8+u4^8),
 -u1^6*v1^3*v2^3*u4^6*(u1^4+u4^4),-u1^30*v1^15*v2^15*u4^30*(u1^4+u4^4),
 -u1^6*v1^3*v2^3*u4^6*(v1^2+v2^2),-u1^18*v1^9*v2^9*u4^18*(v1^2+v2^2),
 -u1^4*v1^2*u4^4*v2^2,-u1^28*v1^14*v2^14*u4^28,v2*u1^2*u4^2*v1,
 u1^10*v1^5*v2^5*u4^10,u1^14*v1^7*v2^7*u4^14,u1^22*v1^11*v2^11*u4^22],
  [2,2*u2^24*v1^12*v2^12*u3^24,u2^8+u3^8,v1^2+v2^2,-u2^16*v1^8*v2^8*u3^16,
 2*u2^12*v1^6*v2^6*u3^12,2*u2^36*v1^18*v2^18*u3^36,u2^4+u3^4,u2^12+u3^12,
 u2^12*v1^6*v2^6*u3^12*(u2^8+u3^8),u2^12*v1^6*v2^6*u3^12*(u2^4+u3^4),
 u2^24*v1^12*v2^12*u3^24*(u2^4+u3^4),u2^12*v1^6*v2^6*u3^12*(v1^2+v2^2),
 -u2^8*v1^4*v2^4*u3^8,2*u2^6*v1^3*v2^3*u3^6,2*u2^18*v1^9*v2^9*u3^18,
 2*u2^30*v1^15*v2^15*u3^30,2*u2^42*v1^21*v2^21*u3^42,
 u2^6*v1^3*v2^3*u3^6*(u2^12+u3^12),u2^18*v1^9*v2^9*u3^18*(u2^4+u3^4),
 u2^6*v1^3*v2^3*u3^6*(u2^8+u3^8),u2^18*v1^9*v2^9*u3^18*(u2^8+u3^8),
 u2^6*v1^3*v2^3*u3^6*(u2^4+u3^4),u2^30*v1^15*v2^15*u3^30*(u2^4+u3^4),
 u2^6*v1^3*v2^3*u3^6*(v1^2+v2^2),u2^18*v1^9*v2^9*u3^18*(v1^2+v2^2),
 -u2^4*v1^2*u3^4*v2^2,-u2^28*v1^14*v2^14*u3^28,-v2*u2^2*u3^2*v1,
 -u2^10*v1^5*v2^5*u3^10,-u2^14*v1^7*v2^7*u3^14,-u2^22*v1^11*v2^11*u3^22],
  [2,2*u2^24*v1^12*v2^12*u3^24,u2^8+u3^8,v1^2+v2^2,-u2^16*v1^8*v2^8*u3^16,
 2*u2^12*v1^6*v2^6*u3^12,2*u2^36*v1^18*v2^18*u3^36,u2^4+u3^4,u2^12+u3^12,
 u2^12*v1^6*v2^6*u3^12*(u2^8+u3^8),u2^12*v1^6*v2^6*u3^12*(u2^4+u3^4),
 u2^24*v1^12*v2^12*u3^24*(u2^4+u3^4),u2^12*v1^6*v2^6*u3^12*(v1^2+v2^2),
 -u2^8*v1^4*v2^4*u3^8,-2*u2^6*v1^3*v2^3*u3^6,-2*u2^18*v1^9*v2^9*u3^18,
 -2*u2^30*v1^15*v2^15*u3^30,-2*u2^42*v1^21*v2^21*u3^42,
 -u2^6*v1^3*v2^3*u3^6*(u2^12+u3^12),-u2^18*v1^9*v2^9*u3^18*(u2^4+u3^4),
 -u2^6*v1^3*v2^3*u3^6*(u2^8+u3^8),-u2^18*v1^9*v2^9*u3^18*(u2^8+u3^8),
 -u2^6*v1^3*v2^3*u3^6*(u2^4+u3^4),-u2^30*v1^15*v2^15*u3^30*(u2^4+u3^4),
 -u2^6*v1^3*v2^3*u3^6*(v1^2+v2^2),-u2^18*v1^9*v2^9*u3^18*(v1^2+v2^2),
 -u2^4*v1^2*u3^4*v2^2,-u2^28*v1^14*v2^14*u3^28,v2*u2^2*u3^2*v1,
 u2^10*v1^5*v2^5*u3^10,u2^14*v1^7*v2^7*u3^14,u2^22*v1^11*v2^11*u3^22],
  [2,2*u2^24*v1^12*v2^12*u4^24,u2^8+u4^8,v1^2+v2^2,-u2^16*v1^8*v2^8*u4^16,
 2*u2^12*v1^6*v2^6*u4^12,2*u2^36*v1^18*v2^18*u4^36,u2^4+u4^4,u2^12+u4^12,
 u2^12*v1^6*v2^6*u4^12*(u2^8+u4^8),u2^12*v1^6*v2^6*u4^12*(u2^4+u4^4),
 u2^24*v1^12*v2^12*u4^24*(u2^4+u4^4),u2^12*v1^6*v2^6*u4^12*(v1^2+v2^2),
 -u2^8*v1^4*v2^4*u4^8,2*u2^6*v1^3*v2^3*u4^6,2*u2^18*v1^9*v2^9*u4^18,
 2*u2^30*v1^15*v2^15*u4^30,2*u2^42*v1^21*v2^21*u4^42,
 u2^6*v1^3*v2^3*u4^6*(u2^12+u4^12),u2^18*v1^9*v2^9*u4^18*(u2^4+u4^4),
 u2^6*v1^3*v2^3*u4^6*(u2^8+u4^8),u2^18*v1^9*v2^9*u4^18*(u2^8+u4^8),
 u2^6*v1^3*v2^3*u4^6*(u2^4+u4^4),u2^30*v1^15*v2^15*u4^30*(u2^4+u4^4),
 u2^6*v1^3*v2^3*u4^6*(v1^2+v2^2),u2^18*v1^9*v2^9*u4^18*(v1^2+v2^2),
 -u2^4*v1^2*u4^4*v2^2,-u2^28*v1^14*v2^14*u4^28,-v2*u2^2*u4^2*v1,
 -u2^10*v1^5*v2^5*u4^10,-u2^14*v1^7*v2^7*u4^14,-u2^22*v1^11*v2^11*u4^22],
  [2,2*u2^24*v1^12*v2^12*u4^24,u2^8+u4^8,v1^2+v2^2,-u2^16*v1^8*v2^8*u4^16,
 2*u2^12*v1^6*v2^6*u4^12,2*u2^36*v1^18*v2^18*u4^36,u2^4+u4^4,u2^12+u4^12,
 u2^12*v1^6*v2^6*u4^12*(u2^8+u4^8),u2^12*v1^6*v2^6*u4^12*(u2^4+u4^4),
 u2^24*v1^12*v2^12*u4^24*(u2^4+u4^4),u2^12*v1^6*v2^6*u4^12*(v1^2+v2^2),
 -u2^8*v1^4*v2^4*u4^8,-2*u2^6*v1^3*v2^3*u4^6,-2*u2^18*v1^9*v2^9*u4^18,
 -2*u2^30*v1^15*v2^15*u4^30,-2*u2^42*v1^21*v2^21*u4^42,
 -u2^6*v1^3*v2^3*u4^6*(u2^12+u4^12),-u2^18*v1^9*v2^9*u4^18*(u2^4+u4^4),
 -u2^6*v1^3*v2^3*u4^6*(u2^8+u4^8),-u2^18*v1^9*v2^9*u4^18*(u2^8+u4^8),
 -u2^6*v1^3*v2^3*u4^6*(u2^4+u4^4),-u2^30*v1^15*v2^15*u4^30*(u2^4+u4^4),
 -u2^6*v1^3*v2^3*u4^6*(v1^2+v2^2),-u2^18*v1^9*v2^9*u4^18*(v1^2+v2^2),
 -u2^4*v1^2*u4^4*v2^2,-u2^28*v1^14*v2^14*u4^28,v2*u2^2*u4^2*v1,
 u2^10*v1^5*v2^5*u4^10,u2^14*v1^7*v2^7*u4^14,u2^22*v1^11*v2^11*u4^22],
  [2,2*u3^24*v1^12*v2^12*u4^24,u3^8+u4^8,v1^2+v2^2,-u3^16*v1^8*v2^8*u4^16,
 2*u3^12*v1^6*v2^6*u4^12,2*u3^36*v1^18*v2^18*u4^36,u3^4+u4^4,u3^12+u4^12,
 u3^12*v1^6*v2^6*u4^12*(u3^8+u4^8),u3^12*v1^6*v2^6*u4^12*(u3^4+u4^4),
 u3^24*v1^12*v2^12*u4^24*(u3^4+u4^4),u3^12*v1^6*v2^6*u4^12*(v1^2+v2^2),
 -u3^8*v1^4*v2^4*u4^8,2*u3^6*v1^3*v2^3*u4^6,2*u3^18*v1^9*v2^9*u4^18,
 2*u3^30*v1^15*v2^15*u4^30,2*u3^42*v1^21*v2^21*u4^42,
 u3^6*v1^3*v2^3*u4^6*(u3^12+u4^12),u3^18*v1^9*v2^9*u4^18*(u3^4+u4^4),
 u3^6*v1^3*v2^3*u4^6*(u3^8+u4^8),u3^18*v1^9*v2^9*u4^18*(u3^8+u4^8),
 u3^6*v1^3*v2^3*u4^6*(u3^4+u4^4),u3^30*v1^15*v2^15*u4^30*(u3^4+u4^4),
 u3^6*v1^3*v2^3*u4^6*(v1^2+v2^2),u3^18*v1^9*v2^9*u4^18*(v1^2+v2^2),
 -u3^4*v1^2*u4^4*v2^2,-u3^28*v1^14*v2^14*u4^28,-v2*u3^2*u4^2*v1,
 -u3^10*v1^5*v2^5*u4^10,-u3^14*v1^7*v2^7*u4^14,-u3^22*v1^11*v2^11*u4^22],
  [2,2*u3^24*v1^12*v2^12*u4^24,u3^8+u4^8,v1^2+v2^2,-u3^16*v1^8*v2^8*u4^16,
 2*u3^12*v1^6*v2^6*u4^12,2*u3^36*v1^18*v2^18*u4^36,u3^4+u4^4,u3^12+u4^12,
 u3^12*v1^6*v2^6*u4^12*(u3^8+u4^8),u3^12*v1^6*v2^6*u4^12*(u3^4+u4^4),
 u3^24*v1^12*v2^12*u4^24*(u3^4+u4^4),u3^12*v1^6*v2^6*u4^12*(v1^2+v2^2),
 -u3^8*v1^4*v2^4*u4^8,-2*u3^6*v1^3*v2^3*u4^6,-2*u3^18*v1^9*v2^9*u4^18,
 -2*u3^30*v1^15*v2^15*u4^30,-2*u3^42*v1^21*v2^21*u4^42,
 -u3^6*v1^3*v2^3*u4^6*(u3^12+u4^12),-u3^18*v1^9*v2^9*u4^18*(u3^4+u4^4),
 -u3^6*v1^3*v2^3*u4^6*(u3^8+u4^8),-u3^18*v1^9*v2^9*u4^18*(u3^8+u4^8),
 -u3^6*v1^3*v2^3*u4^6*(u3^4+u4^4),-u3^30*v1^15*v2^15*u4^30*(u3^4+u4^4),
 -u3^6*v1^3*v2^3*u4^6*(v1^2+v2^2),-u3^18*v1^9*v2^9*u4^18*(v1^2+v2^2),
 -u3^4*v1^2*u4^4*v2^2,-u3^28*v1^14*v2^14*u4^28,v2*u3^2*u4^2*v1,
 u3^10*v1^5*v2^5*u4^10,u3^14*v1^7*v2^7*u4^14,u3^22*v1^11*v2^11*u4^22],
  [3,3*v2^8*u1^16*v1^16*u3^16*u2^16,u1^8+u2^8+u3^8,v2^2+2*v1^2,0,
 3*v2^4*u1^8*v1^8*u3^8*u2^8,3*v2^12*u1^24*v1^24*u3^24*u2^24,u1^4+u2^4+u3^4,
 u1^12+u2^12+u3^12,v2^4*u1^8*v1^8*u3^8*u2^8*(u1^8+u2^8+u3^8),
 v2^4*u1^8*v1^8*u3^8*u2^8*(u1^4+u2^4+u3^4),
 v2^8*u1^16*v1^16*u3^16*u2^16*(u1^4+u2^4+u3^4),
 v2^4*u1^8*v1^8*u3^8*u2^8*(v2^2+2*v1^2),0,3*v2^2*u1^4*v1^4*u3^4*u2^4,
 3*v2^6*u1^12*v1^12*u3^12*u2^12,3*v2^10*u1^20*v1^20*u3^20*u2^20,
 3*v2^14*u1^28*v1^28*u3^28*u2^28,v2^2*u1^4*v1^4*u3^4*u2^4*(u1^12+u2^12+u3^12),
 v2^6*u1^12*v1^12*u3^12*u2^12*(u1^4+u2^4+u3^4),
 v2^2*u1^4*v1^4*u3^4*u2^4*(u1^8+u2^8+u3^8),
 v2^6*u1^12*v1^12*u3^12*u2^12*(u1^8+u2^8+u3^8),
 v2^2*u1^4*v1^4*u3^4*u2^4*(u1^4+u2^4+u3^4),
 v2^10*u1^20*v1^20*u3^20*u2^20*(u1^4+u2^4+u3^4),
 v2^2*u1^4*v1^4*u3^4*u2^4*(v2^2+2*v1^2),
 v2^6*u1^12*v1^12*u3^12*u2^12*(v2^2+2*v1^2),0,0,0,0,0,0],
  [3,3*v1^8*u1^16*v2^16*u3^16*u2^16,u1^8+u2^8+u3^8,v1^2+2*v2^2,0,
 3*v1^4*u1^8*v2^8*u3^8*u2^8,3*v1^12*u1^24*v2^24*u3^24*u2^24,u1^4+u2^4+u3^4,
 u1^12+u2^12+u3^12,v1^4*u1^8*v2^8*u3^8*u2^8*(u1^8+u2^8+u3^8),
 v1^4*u1^8*v2^8*u3^8*u2^8*(u1^4+u2^4+u3^4),
 v1^8*u1^16*v2^16*u3^16*u2^16*(u1^4+u2^4+u3^4),
 v1^4*u1^8*v2^8*u3^8*u2^8*(v1^2+2*v2^2),0,3*v1^2*u1^4*v2^4*u3^4*u2^4,
 3*v1^6*u1^12*v2^12*u3^12*u2^12,3*v1^10*u1^20*v2^20*u3^20*u2^20,
 3*v1^14*u1^28*v2^28*u3^28*u2^28,v1^2*u1^4*v2^4*u3^4*u2^4*(u1^12+u2^12+u3^12),
 v1^6*u1^12*v2^12*u3^12*u2^12*(u1^4+u2^4+u3^4),
 v1^2*u1^4*v2^4*u3^4*u2^4*(u1^8+u2^8+u3^8),
 v1^6*u1^12*v2^12*u3^12*u2^12*(u1^8+u2^8+u3^8),
 v1^2*u1^4*v2^4*u3^4*u2^4*(u1^4+u2^4+u3^4),
 v1^10*u1^20*v2^20*u3^20*u2^20*(u1^4+u2^4+u3^4),
 v1^2*u1^4*v2^4*u3^4*u2^4*(v1^2+2*v2^2),
 v1^6*u1^12*v2^12*u3^12*u2^12*(v1^2+2*v2^2),0,0,0,0,0,0],
  [3,3*v2^8*u1^16*v1^16*u4^16*u2^16,u1^8+u2^8+u4^8,v2^2+2*v1^2,0,
 3*v2^4*u1^8*v1^8*u4^8*u2^8,3*v2^12*u1^24*v1^24*u4^24*u2^24,u1^4+u2^4+u4^4,
 u1^12+u2^12+u4^12,v2^4*u1^8*v1^8*u4^8*u2^8*(u1^8+u2^8+u4^8),
 v2^4*u1^8*v1^8*u4^8*u2^8*(u1^4+u2^4+u4^4),
 v2^8*u1^16*v1^16*u4^16*u2^16*(u1^4+u2^4+u4^4),
 v2^4*u1^8*v1^8*u4^8*u2^8*(v2^2+2*v1^2),0,3*v2^2*u1^4*v1^4*u4^4*u2^4,
 3*v2^6*u1^12*v1^12*u4^12*u2^12,3*v2^10*u1^20*v1^20*u4^20*u2^20,
 3*v2^14*u1^28*v1^28*u4^28*u2^28,v2^2*u1^4*v1^4*u4^4*u2^4*(u1^12+u2^12+u4^12),
 v2^6*u1^12*v1^12*u4^12*u2^12*(u1^4+u2^4+u4^4),
 v2^2*u1^4*v1^4*u4^4*u2^4*(u1^8+u2^8+u4^8),
 v2^6*u1^12*v1^12*u4^12*u2^12*(u1^8+u2^8+u4^8),
 v2^2*u1^4*v1^4*u4^4*u2^4*(u1^4+u2^4+u4^4),
 v2^10*u1^20*v1^20*u4^20*u2^20*(u1^4+u2^4+u4^4),
 v2^2*u1^4*v1^4*u4^4*u2^4*(v2^2+2*v1^2),
 v2^6*u1^12*v1^12*u4^12*u2^12*(v2^2+2*v1^2),0,0,0,0,0,0],
  [3,3*v1^8*u1^16*v2^16*u4^16*u2^16,u1^8+u2^8+u4^8,v1^2+2*v2^2,0,
 3*v1^4*u1^8*v2^8*u4^8*u2^8,3*v1^12*u1^24*v2^24*u4^24*u2^24,u1^4+u2^4+u4^4,
 u1^12+u2^12+u4^12,v1^4*u1^8*v2^8*u4^8*u2^8*(u1^8+u2^8+u4^8),
 v1^4*u1^8*v2^8*u4^8*u2^8*(u1^4+u2^4+u4^4),
 v1^8*u1^16*v2^16*u4^16*u2^16*(u1^4+u2^4+u4^4),
 v1^4*u1^8*v2^8*u4^8*u2^8*(v1^2+2*v2^2),0,3*v1^2*u1^4*v2^4*u4^4*u2^4,
 3*v1^6*u1^12*v2^12*u4^12*u2^12,3*v1^10*u1^20*v2^20*u4^20*u2^20,
 3*v1^14*u1^28*v2^28*u4^28*u2^28,v1^2*u1^4*v2^4*u4^4*u2^4*(u1^12+u2^12+u4^12),
 v1^6*u1^12*v2^12*u4^12*u2^12*(u1^4+u2^4+u4^4),
 v1^2*u1^4*v2^4*u4^4*u2^4*(u1^8+u2^8+u4^8),
 v1^6*u1^12*v2^12*u4^12*u2^12*(u1^8+u2^8+u4^8),
 v1^2*u1^4*v2^4*u4^4*u2^4*(u1^4+u2^4+u4^4),
 v1^10*u1^20*v2^20*u4^20*u2^20*(u1^4+u2^4+u4^4),
 v1^2*u1^4*v2^4*u4^4*u2^4*(v1^2+2*v2^2),
 v1^6*u1^12*v2^12*u4^12*u2^12*(v1^2+2*v2^2),0,0,0,0,0,0],
  [3,3*v2^8*u1^16*v1^16*u4^16*u3^16,u1^8+u3^8+u4^8,v2^2+2*v1^2,0,
 3*v2^4*u1^8*v1^8*u4^8*u3^8,3*v2^12*u1^24*v1^24*u4^24*u3^24,u1^4+u3^4+u4^4,
 u1^12+u3^12+u4^12,v2^4*u1^8*v1^8*u4^8*u3^8*(u1^8+u3^8+u4^8),
 v2^4*u1^8*v1^8*u4^8*u3^8*(u1^4+u3^4+u4^4),
 v2^8*u1^16*v1^16*u4^16*u3^16*(u1^4+u3^4+u4^4),
 v2^4*u1^8*v1^8*u4^8*u3^8*(v2^2+2*v1^2),0,3*v2^2*u1^4*v1^4*u4^4*u3^4,
 3*v2^6*u1^12*v1^12*u4^12*u3^12,3*v2^10*u1^20*v1^20*u4^20*u3^20,
 3*v2^14*u1^28*v1^28*u4^28*u3^28,v2^2*u1^4*v1^4*u4^4*u3^4*(u1^12+u3^12+u4^12),
 v2^6*u1^12*v1^12*u4^12*u3^12*(u1^4+u3^4+u4^4),
 v2^2*u1^4*v1^4*u4^4*u3^4*(u1^8+u3^8+u4^8),
 v2^6*u1^12*v1^12*u4^12*u3^12*(u1^8+u3^8+u4^8),
 v2^2*u1^4*v1^4*u4^4*u3^4*(u1^4+u3^4+u4^4),
 v2^10*u1^20*v1^20*u4^20*u3^20*(u1^4+u3^4+u4^4),
 v2^2*u1^4*v1^4*u4^4*u3^4*(v2^2+2*v1^2),
 v2^6*u1^12*v1^12*u4^12*u3^12*(v2^2+2*v1^2),0,0,0,0,0,0],
  [3,3*v1^8*u1^16*v2^16*u4^16*u3^16,u1^8+u3^8+u4^8,v1^2+2*v2^2,0,
 3*v1^4*u1^8*v2^8*u4^8*u3^8,3*v1^12*u1^24*v2^24*u4^24*u3^24,u1^4+u3^4+u4^4,
 u1^12+u3^12+u4^12,v1^4*u1^8*v2^8*u4^8*u3^8*(u1^8+u3^8+u4^8),
 v1^4*u1^8*v2^8*u4^8*u3^8*(u1^4+u3^4+u4^4),
 v1^8*u1^16*v2^16*u4^16*u3^16*(u1^4+u3^4+u4^4),
 v1^4*u1^8*v2^8*u4^8*u3^8*(v1^2+2*v2^2),0,3*v1^2*u1^4*v2^4*u4^4*u3^4,
 3*v1^6*u1^12*v2^12*u4^12*u3^12,3*v1^10*u1^20*v2^20*u4^20*u3^20,
 3*v1^14*u1^28*v2^28*u4^28*u3^28,v1^2*u1^4*v2^4*u4^4*u3^4*(u1^12+u3^12+u4^12),
 v1^6*u1^12*v2^12*u4^12*u3^12*(u1^4+u3^4+u4^4),
 v1^2*u1^4*v2^4*u4^4*u3^4*(u1^8+u3^8+u4^8),
 v1^6*u1^12*v2^12*u4^12*u3^12*(u1^8+u3^8+u4^8),
 v1^2*u1^4*v2^4*u4^4*u3^4*(u1^4+u3^4+u4^4),
 v1^10*u1^20*v2^20*u4^20*u3^20*(u1^4+u3^4+u4^4),
 v1^2*u1^4*v2^4*u4^4*u3^4*(v1^2+2*v2^2),
 v1^6*u1^12*v2^12*u4^12*u3^12*(v1^2+2*v2^2),0,0,0,0,0,0],
  [3,3*v2^8*u2^16*v1^16*u4^16*u3^16,u2^8+u3^8+u4^8,v2^2+2*v1^2,0,
 3*v2^4*u2^8*v1^8*u4^8*u3^8,3*v2^12*u2^24*v1^24*u4^24*u3^24,u2^4+u3^4+u4^4,
 u2^12+u3^12+u4^12,v2^4*u2^8*v1^8*u4^8*u3^8*(u2^8+u3^8+u4^8),
 v2^4*u2^8*v1^8*u4^8*u3^8*(u2^4+u3^4+u4^4),
 v2^8*u2^16*v1^16*u4^16*u3^16*(u2^4+u3^4+u4^4),
 v2^4*u2^8*v1^8*u4^8*u3^8*(v2^2+2*v1^2),0,3*v2^2*u2^4*v1^4*u4^4*u3^4,
 3*v2^6*u2^12*v1^12*u4^12*u3^12,3*v2^10*u2^20*v1^20*u4^20*u3^20,
 3*v2^14*u2^28*v1^28*u4^28*u3^28,v2^2*u2^4*v1^4*u4^4*u3^4*(u2^12+u3^12+u4^12),
 v2^6*u2^12*v1^12*u4^12*u3^12*(u2^4+u3^4+u4^4),
 v2^2*u2^4*v1^4*u4^4*u3^4*(u2^8+u3^8+u4^8),
 v2^6*u2^12*v1^12*u4^12*u3^12*(u2^8+u3^8+u4^8),
 v2^2*u2^4*v1^4*u4^4*u3^4*(u2^4+u3^4+u4^4),
 v2^10*u2^20*v1^20*u4^20*u3^20*(u2^4+u3^4+u4^4),
 v2^2*u2^4*v1^4*u4^4*u3^4*(v2^2+2*v1^2),
 v2^6*u2^12*v1^12*u4^12*u3^12*(v2^2+2*v1^2),0,0,0,0,0,0],
  [3,3*v1^8*u2^16*v2^16*u4^16*u3^16,u2^8+u3^8+u4^8,v1^2+2*v2^2,0,
 3*v1^4*u2^8*v2^8*u4^8*u3^8,3*v1^12*u2^24*v2^24*u4^24*u3^24,u2^4+u3^4+u4^4,
 u2^12+u3^12+u4^12,v1^4*u2^8*v2^8*u4^8*u3^8*(u2^8+u3^8+u4^8),
 v1^4*u2^8*v2^8*u4^8*u3^8*(u2^4+u3^4+u4^4),
 v1^8*u2^16*v2^16*u4^16*u3^16*(u2^4+u3^4+u4^4),
 v1^4*u2^8*v2^8*u4^8*u3^8*(v1^2+2*v2^2),0,3*v1^2*u2^4*v2^4*u4^4*u3^4,
 3*v1^6*u2^12*v2^12*u4^12*u3^12,3*v1^10*u2^20*v2^20*u4^20*u3^20,
 3*v1^14*u2^28*v2^28*u4^28*u3^28,v1^2*u2^4*v2^4*u4^4*u3^4*(u2^12+u3^12+u4^12),
 v1^6*u2^12*v2^12*u4^12*u3^12*(u2^4+u3^4+u4^4),
 v1^2*u2^4*v2^4*u4^4*u3^4*(u2^8+u3^8+u4^8),
 v1^6*u2^12*v2^12*u4^12*u3^12*(u2^8+u3^8+u4^8),
 v1^2*u2^4*v2^4*u4^4*u3^4*(u2^4+u3^4+u4^4),
 v1^10*u2^20*v2^20*u4^20*u3^20*(u2^4+u3^4+u4^4),
 v1^2*u2^4*v2^4*u4^4*u3^4*(v1^2+2*v2^2),
 v1^6*u2^12*v2^12*u4^12*u3^12*(v1^2+2*v2^2),0,0,0,0,0,0],
  [4,4*u3^12*v1^12*u2^12*u1^12*v2^12*u4^12,u1^8+u2^8+u3^8+u4^8,2*v1^2+2*v2^2,
 u4^8*v2^8*u1^8*u2^8*v1^8*u3^8,4*u3^6*v1^6*u2^6*u1^6*v2^6*u4^6,
 4*u3^18*v1^18*u2^18*u1^18*v2^18*u4^18,u1^4+u2^4+u3^4+u4^4,
 u1^12+u2^12+u3^12+u4^12,u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(u1^8+u2^8+u3^8+u4^8),
 u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(u1^4+u2^4+u3^4+u4^4),
 u3^12*v1^12*u2^12*u1^12*v2^12*u4^12*(u1^4+u2^4+u3^4+u4^4),
 2*u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(v1^2+v2^2),u4^4*v2^4*u1^4*u2^4*v1^4*u3^4,
 4*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3,4*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9,
 4*u3^15*v1^15*u2^15*u1^15*v2^15*u4^15,4*u3^21*v1^21*u2^21*u1^21*v2^21*u4^21,
 u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^12+u2^12+u3^12+u4^12),
 u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(u1^4+u2^4+u3^4+u4^4),
 u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^8+u2^8+u3^8+u4^8),
 u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(u1^8+u2^8+u3^8+u4^8),
 u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^4+u2^4+u3^4+u4^4),
 u3^15*v1^15*u2^15*u1^15*v2^15*u4^15*(u1^4+u2^4+u3^4+u4^4),
 2*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(v1^2+v2^2),
 2*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(v1^2+v2^2),u4^2*u3^2*u2^2*v2^2*v1^2*u1^2,
 u4^14*v2^14*u1^14*u2^14*v1^14*u3^14,v2*u4*u2*u3*u1*v1,
 u4^5*v2^5*u1^5*u2^5*v1^5*u3^5,u4^7*v2^7*u1^7*u2^7*v1^7*u3^7,
 u4^11*v2^11*u1^11*u2^11*v1^11*u3^11],
  [4,4*u3^12*v1^12*u2^12*u1^12*v2^12*u4^12,u1^8+u2^8+u3^8+u4^8,2*v1^2+2*v2^2,
 u4^8*v2^8*u1^8*u2^8*v1^8*u3^8,4*u3^6*v1^6*u2^6*u1^6*v2^6*u4^6,
 4*u3^18*v1^18*u2^18*u1^18*v2^18*u4^18,u1^4+u2^4+u3^4+u4^4,
 u1^12+u2^12+u3^12+u4^12,u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(u1^8+u2^8+u3^8+u4^8),
 u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(u1^4+u2^4+u3^4+u4^4),
 u3^12*v1^12*u2^12*u1^12*v2^12*u4^12*(u1^4+u2^4+u3^4+u4^4),
 2*u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(v1^2+v2^2),u4^4*v2^4*u1^4*u2^4*v1^4*u3^4,
 -4*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3,-4*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9,
 -4*u3^15*v1^15*u2^15*u1^15*v2^15*u4^15,-4*u3^21*v1^21*u2^21*u1^21*v2^21*u4^21,
 -u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^12+u2^12+u3^12+u4^12),
 -u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(u1^4+u2^4+u3^4+u4^4),
 -u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^8+u2^8+u3^8+u4^8),
 -u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(u1^8+u2^8+u3^8+u4^8),
 -u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^4+u2^4+u3^4+u4^4),
 -u3^15*v1^15*u2^15*u1^15*v2^15*u4^15*(u1^4+u2^4+u3^4+u4^4),
 -2*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(v1^2+v2^2),
 -2*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(v1^2+v2^2),u4^2*u3^2*u2^2*v2^2*v1^2*u1^2,
 u4^14*v2^14*u1^14*u2^14*v1^14*u3^14,-u4*v2*u2*u3*u1*v1,
 -u4^5*v2^5*u1^5*u2^5*v1^5*u3^5,-u4^7*v2^7*u1^7*u2^7*v1^7*u3^7,
 -u4^11*v2^11*u1^11*u2^11*v1^11*u3^11],
  [4,4*u3^12*v1^12*u2^12*u1^12*v2^12*u4^12,u1^8+u2^8+u3^8+u4^8,2*v1^2+2*v2^2,
 u4^8*v2^8*u1^8*u2^8*v1^8*u3^8,-4*u3^6*v1^6*u2^6*u1^6*v2^6*u4^6,
 -4*u3^18*v1^18*u2^18*u1^18*v2^18*u4^18,u1^4+u2^4+u3^4+u4^4,
 u1^12+u2^12+u3^12+u4^12,-u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(u1^8+u2^8+u3^8+u4^8),
 -u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(u1^4+u2^4+u3^4+u4^4),
 u3^12*v1^12*u2^12*u1^12*v2^12*u4^12*(u1^4+u2^4+u3^4+u4^4),
 -2*u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(v1^2+v2^2),u4^4*v2^4*u1^4*u2^4*v1^4*u3^4,
 -4*E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3,4*E(4)*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9,
 -4*E(4)*u3^15*v1^15*u2^15*u1^15*v2^15*u4^15,
 4*E(4)*u3^21*v1^21*u2^21*u1^21*v2^21*u4^21,
 -E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^12+u2^12+u3^12+u4^12),
 E(4)*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(u1^4+u2^4+u3^4+u4^4),
 -E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^8+u2^8+u3^8+u4^8),
 E(4)*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(u1^8+u2^8+u3^8+u4^8),
 -E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^4+u2^4+u3^4+u4^4),
 -E(4)*u3^15*v1^15*u2^15*u1^15*v2^15*u4^15*(u1^4+u2^4+u3^4+u4^4),
 -2*E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(v1^2+v2^2),
 2*E(4)*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(v1^2+v2^2),-u4^2*u3^2*u2^2*v2^2*v1^2*u1^2,
 -u4^14*v2^14*u1^14*u2^14*v1^14*u3^14,E(4)*u4*v2*u2*u3*u1*v1,
 E(4)*u4^5*v2^5*u1^5*u2^5*v1^5*u3^5,-E(4)*u4^7*v2^7*u1^7*u2^7*v1^7*u3^7,
 -E(4)*u4^11*v2^11*u1^11*u2^11*v1^11*u3^11],
  [4,4*u3^12*v1^12*u2^12*u1^12*v2^12*u4^12,u1^8+u2^8+u3^8+u4^8,2*v1^2+2*v2^2,
 u4^8*v2^8*u1^8*u2^8*v1^8*u3^8,-4*u3^6*v1^6*u2^6*u1^6*v2^6*u4^6,
 -4*u3^18*v1^18*u2^18*u1^18*v2^18*u4^18,u1^4+u2^4+u3^4+u4^4,
 u1^12+u2^12+u3^12+u4^12,-u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(u1^8+u2^8+u3^8+u4^8),
 -u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(u1^4+u2^4+u3^4+u4^4),
 u3^12*v1^12*u2^12*u1^12*v2^12*u4^12*(u1^4+u2^4+u3^4+u4^4),
 -2*u3^6*v1^6*u2^6*u1^6*v2^6*u4^6*(v1^2+v2^2),u4^4*v2^4*u1^4*u2^4*v1^4*u3^4,
 4*E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3,-4*E(4)*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9,
 4*E(4)*u3^15*v1^15*u2^15*u1^15*v2^15*u4^15,
 -4*E(4)*u3^21*v1^21*u2^21*u1^21*v2^21*u4^21,
 E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^12+u2^12+u3^12+u4^12),
 -E(4)*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(u1^4+u2^4+u3^4+u4^4),
 E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^8+u2^8+u3^8+u4^8),
 -E(4)*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(u1^8+u2^8+u3^8+u4^8),
 E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(u1^4+u2^4+u3^4+u4^4),
 E(4)*u3^15*v1^15*u2^15*u1^15*v2^15*u4^15*(u1^4+u2^4+u3^4+u4^4),
 2*E(4)*u3^3*v1^3*u2^3*u1^3*v2^3*u4^3*(v1^2+v2^2),
 -2*E(4)*u3^9*v1^9*u2^9*u1^9*v2^9*u4^9*(v1^2+v2^2),-u4^2*u3^2*u2^2*v2^2*v1^2*u1^2,
 -u4^14*v2^14*u1^14*u2^14*v1^14*u3^14,-E(4)*u4*v2*u2*u3*u1*v1,
 -E(4)*u4^5*v2^5*u1^5*u2^5*v1^5*u3^5,E(4)*u4^7*v2^7*u1^7*u2^7*v1^7*u3^7,
 E(4)*u4^11*v2^11*u1^11*u2^11*v1^11*u3^11]],
  schurelements:=[
 (u1^4-u2^4)*(u1^4-u3^4)*(u1^4-u4^4)*(v1^2-v2^2)*(v2^4*u2^8+v1^2*u1^4*v2^2*u2^4
 +v1^4*u1^8)*(v2^4*u3^8+v1^2*u1^4*v2^2*u3^4+v1^4*u1^8)*(v1^2*u1^8-v2^2*u2^4*u3
 ^4)*(v2^4*u4^8+v1^2*u1^4*v2^2*u4^4+v1^4*u1^8)*(v1^2*u1^8-v2^2*u2^4*u4^4)*(v1^2
 *u1^8-v2^2*u3^4*u4^4)*(v1^4*u1^12-v2^4*u2^4*u3^4*u4^4)/v2^24/u2^24/u3^24/u4^24,
 (u1^4-u2^4)*(u1^4-u3^4)*(u1^4-u4^4)*(v2^2-v1^2)*(v1^4*u2^8+v2^2*u1^4*v1^2*u2^4
 +v2^4*u1^8)*(v1^4*u3^8+v2^2*u1^4*v1^2*u3^4+v2^4*u1^8)*(v2^2*u1^8-v1^2*u2^4*u3
 ^4)*(v1^4*u4^8+v2^2*u1^4*v1^2*u4^4+v2^4*u1^8)*(v2^2*u1^8-v1^2*u2^4*u4^4)*(v2^2
 *u1^8-v1^2*u3^4*u4^4)*(v2^4*u1^12-v1^4*u2^4*u3^4*u4^4)/v1^24/u2^24/u3^24/u4^24,
 (u2^4-u1^4)*(u2^4-u3^4)*(u2^4-u4^4)*(v1^2-v2^2)*(v2^4*u1^8+v1^2*u2^4*v2^2*u1^4
 +v1^4*u2^8)*(v2^4*u3^8+v1^2*u2^4*v2^2*u3^4+v1^4*u2^8)*(v1^2*u2^8-v2^2*u1^4*u3
 ^4)*(v2^4*u4^8+v1^2*u2^4*v2^2*u4^4+v1^4*u2^8)*(v1^2*u2^8-v2^2*u1^4*u4^4)*(v1^2
 *u2^8-v2^2*u3^4*u4^4)*(v1^4*u2^12-v2^4*u1^4*u3^4*u4^4)/v2^24/u1^24/u3^24/u4^24,
 (u2^4-u1^4)*(u2^4-u3^4)*(u2^4-u4^4)*(v2^2-v1^2)*(v1^4*u1^8+v2^2*u2^4*v1^2*u1^4
 +v2^4*u2^8)*(v1^4*u3^8+v2^2*u2^4*v1^2*u3^4+v2^4*u2^8)*(v2^2*u2^8-v1^2*u1^4*u3
 ^4)*(v1^4*u4^8+v2^2*u2^4*v1^2*u4^4+v2^4*u2^8)*(v2^2*u2^8-v1^2*u1^4*u4^4)*(v2^2
 *u2^8-v1^2*u3^4*u4^4)*(v2^4*u2^12-v1^4*u1^4*u3^4*u4^4)/v1^24/u1^24/u3^24/u4^24,
 (u3^4-u1^4)*(u3^4-u2^4)*(u3^4-u4^4)*(v1^2-v2^2)*(v2^4*u1^8+v1^2*u3^4*v2^2*u1^4
 +v1^4*u3^8)*(v2^4*u2^8+v1^2*u3^4*v2^2*u2^4+v1^4*u3^8)*(v1^2*u3^8-v2^2*u1^4*u2
 ^4)*(v2^4*u4^8+v1^2*u3^4*v2^2*u4^4+v1^4*u3^8)*(v1^2*u3^8-v2^2*u1^4*u4^4)*(v1^2
 *u3^8-v2^2*u2^4*u4^4)*(v1^4*u3^12-v2^4*u1^4*u2^4*u4^4)/v2^24/u1^24/u2^24/u4^24,
 (u3^4-u1^4)*(u3^4-u2^4)*(u3^4-u4^4)*(v2^2-v1^2)*(v1^4*u1^8+v2^2*u3^4*v1^2*u1^4
 +v2^4*u3^8)*(v1^4*u2^8+v2^2*u3^4*v1^2*u2^4+v2^4*u3^8)*(v2^2*u3^8-v1^2*u1^4*u2
 ^4)*(v1^4*u4^8+v2^2*u3^4*v1^2*u4^4+v2^4*u3^8)*(v2^2*u3^8-v1^2*u1^4*u4^4)*(v2^2
 *u3^8-v1^2*u2^4*u4^4)*(v2^4*u3^12-v1^4*u1^4*u2^4*u4^4)/v1^24/u1^24/u2^24/u4^24,
 (u4^4-u1^4)*(u4^4-u2^4)*(u4^4-u3^4)*(v1^2-v2^2)*(v2^4*u1^8+v1^2*u4^4*v2^2*u1^4
 +v1^4*u4^8)*(v2^4*u2^8+v1^2*u4^4*v2^2*u2^4+v1^4*u4^8)*(v1^2*u4^8-v2^2*u1^4*u2
 ^4)*(v2^4*u3^8+v1^2*u4^4*v2^2*u3^4+v1^4*u4^8)*(v1^2*u4^8-v2^2*u1^4*u3^4)*(v1^2
 *u4^8-v2^2*u2^4*u3^4)*(v1^4*u4^12-v2^4*u1^4*u2^4*u3^4)/v2^24/u1^24/u2^24/u3^24,
 (u4^4-u1^4)*(u4^4-u2^4)*(u4^4-u3^4)*(v2^2-v1^2)*(v1^4*u1^8+v2^2*u4^4*v1^2*u1^4
 +v2^4*u4^8)*(v1^4*u2^8+v2^2*u4^4*v1^2*u2^4+v2^4*u4^8)*(v2^2*u4^8-v1^2*u1^4*u2
 ^4)*(v1^4*u3^8+v2^2*u4^4*v1^2*u3^4+v2^4*u4^8)*(v2^2*u4^8-v1^2*u1^4*u3^4)*(v2^2
 *u4^8-v1^2*u2^4*u3^4)*(v2^4*u4^12-v1^4*u1^4*u2^4*u3^4)/v1^24/u1^24/u2^24/u3^24,
 -2/u4^24/u3^24/u2^4/u1^4/v2^4/v1^4*(u3^8*u4^8+u1^4*u2^4*u3^4*u4^4+u1^8*u2^8)*(
 v1*u4^4-u1^2*v2*u2^2)*(-u1^2*v2*u2^2+v1*u3^4)*(-v1*u2^2*u1^2+v2*u4^4)*(-v1*u2^2
 *u1^2+v2*u3^4)*(v1^2*u2^4+v1*u1^2*v2*u2^2+u1^4*v2^2)*(v2^2*u2^4+v1*u1^2*v2*u2^2
 +v1^2*u1^4)*(u4^4-u2^4)*(u4^4-u1^4)*(u3^4-u2^4)*(u3^4-u1^4),
 -2/u4^24/u3^24/u2^4/u1^4/v2^4/v1^4*(u3^8*u4^8+u1^4*u2^4*u3^4*u4^4+u1^8*u2^8)*(
 v1*u4^4+u1^2*v2*u2^2)*(u1^2*v2*u2^2+v1*u3^4)*(v1*u2^2*u1^2+v2*u4^4)*(v1*u2^2*u1
 ^2+v2*u3^4)*(v1^2*u2^4-v1*u1^2*v2*u2^2+u1^4*v2^2)*(v2^2*u2^4-v1*u1^2*v2*u2^2+v1
 ^2*u1^4)*(u4^4-u2^4)*(u4^4-u1^4)*(u3^4-u2^4)*(u3^4-u1^4),
 -2/u4^24/u2^24/u3^4/u1^4/v2^4/v1^4*(u2^8*u4^8+u1^4*u2^4*u3^4*u4^4+u1^8*u3^8)*(
 v1*u4^4-u1^2*v2*u3^2)*(-u1^2*v2*u3^2+v1*u2^4)*(-v1*u1^2*u3^2+v2*u4^4)*(-v1*u1^2
 *u3^2+v2*u2^4)*(v1^2*u3^4+v1*u1^2*v2*u3^2+u1^4*v2^2)*(v2^2*u3^4+v1*u1^2*v2*u3^2
 +v1^2*u1^4)*(u3^4-u4^4)*(u4^4-u1^4)*(u3^4-u2^4)*(u2^4-u1^4),
 -2/u4^24/u2^24/u3^4/u1^4/v2^4/v1^4*(u2^8*u4^8+u1^4*u2^4*u3^4*u4^4+u1^8*u3^8)*(
 v1*u4^4+u1^2*v2*u3^2)*(u1^2*v2*u3^2+v1*u2^4)*(v1*u1^2*u3^2+v2*u4^4)*(v1*u1^2*u3
 ^2+v2*u2^4)*(v1^2*u3^4-v1*u1^2*v2*u3^2+u1^4*v2^2)*(v2^2*u3^4-v1*u1^2*v2*u3^2+v1
 ^2*u1^4)*(u3^4-u4^4)*(u4^4-u1^4)*(u3^4-u2^4)*(u2^4-u1^4),
 2/u3^24/u2^24/u4^4/u1^4/v2^4/v1^4*(u3^8*u2^8+u1^4*u2^4*u3^4*u4^4+u1^8*u4^8)*(-
 v2*u1^2*u4^2+v1*u3^4)*(-v2*u1^2*u4^2+v1*u2^4)*(-v1*u1^2*u4^2+v2*u3^4)*(-v1*u1^2
 *u4^2+v2*u2^4)*(v1^2*u4^4+u1^4*v2^2+v1*v2*u1^2*u4^2)*(v2^2*u4^4+v1*v2*u1^2*u4^2
 +v1^2*u1^4)*(u3^4-u4^4)*(u3^4-u1^4)*(u4^4-u2^4)*(u2^4-u1^4),
 2/u3^24/u2^24/u4^4/u1^4/v2^4/v1^4*(u3^8*u2^8+u1^4*u2^4*u3^4*u4^4+u1^8*u4^8)*(v2
 *u1^2*u4^2+v1*u3^4)*(v2*u1^2*u4^2+v1*u2^4)*(v1*u1^2*u4^2+v2*u3^4)*(v1*u1^2*u4^2
 +v2*u2^4)*(v1^2*u4^4+u1^4*v2^2-v1*v2*u1^2*u4^2)*(v2^2*u4^4-v1*v2*u1^2*u4^2+v1^2
 *u1^4)*(u3^4-u4^4)*(u3^4-u1^4)*(u4^4-u2^4)*(u2^4-u1^4),
 2/u4^24/u1^24/u2^4/u3^4/v2^4/v1^4*(u3^8*u2^8+u1^4*u2^4*u3^4*u4^4+u1^8*u4^8)*(v1
 *u4^4-v2*u2^2*u3^2)*(-v2*u2^2*u3^2+v1*u1^4)*(-v1*u3^2*u2^2+v2*u4^4)*(-v1*u3^2*
 u2^2+v2*u1^4)*(v1^2*u2^4+v1*u2^2*u3^2*v2+v2^2*u3^4)*(v1^2*u3^4+v1*u2^2*u3^2*v2+
 v2^2*u2^4)*(u4^4-u2^4)*(u3^4-u4^4)*(u2^4-u1^4)*(u3^4-u1^4),
 2/u4^24/u1^24/u2^4/u3^4/v2^4/v1^4*(u3^8*u2^8+u1^4*u2^4*u3^4*u4^4+u1^8*u4^8)*(v1
 *u4^4+v2*u2^2*u3^2)*(v2*u2^2*u3^2+v1*u1^4)*(v1*u3^2*u2^2+v2*u4^4)*(v1*u3^2*u2^2
 +v2*u1^4)*(v1^2*u2^4-v1*u2^2*u3^2*v2+v2^2*u3^4)*(v2^2*u2^4-v1*u2^2*u3^2*v2+v1^2
 *u3^4)*(u4^4-u2^4)*(u3^4-u4^4)*(u2^4-u1^4)*(u3^4-u1^4),
 -2/u3^24/u1^24/u4^4/u2^4/v2^4/v1^4*(u2^8*u4^8+u1^4*u2^4*u3^4*u4^4+u1^8*u3^8)*(-
 v2*u2^2*u4^2+v1*u3^4)*(-v2*u2^2*u4^2+v1*u1^4)*(-v1*u2^2*u4^2+v2*u3^4)*(-v1*u2^2
 *u4^2+v2*u1^4)*(v1^2*u4^4+v1*u2^2*v2*u4^2+v2^2*u2^4)*(v2^2*u4^4+v1*u2^2*v2*u4^2
 +v1^2*u2^4)*(u3^4-u4^4)*(u3^4-u2^4)*(u4^4-u1^4)*(u2^4-u1^4),
 -2/u3^24/u1^24/u4^4/u2^4/v2^4/v1^4*(u2^8*u4^8+u1^4*u2^4*u3^4*u4^4+u1^8*u3^8)*(
 v2*u2^2*u4^2+v1*u3^4)*(v2*u2^2*u4^2+v1*u1^4)*(v1*u2^2*u4^2+v2*u3^4)*(v1*u2^2*u4
 ^2+v2*u1^4)*(v1^2*u4^4-v1*u2^2*v2*u4^2+v2^2*u2^4)*(v2^2*u4^4-v1*u2^2*v2*u4^2+v1
 ^2*u2^4)*(u3^4-u4^4)*(u3^4-u2^4)*(u4^4-u1^4)*(u2^4-u1^4),
 -2/u2^24/u1^24/u4^4/u3^4/v2^4/v1^4*(u3^8*u4^8+u1^4*u2^4*u3^4*u4^4+u1^8*u2^8)*(-
 v2*u3^2*u4^2+v1*u2^4)*(-v2*u3^2*u4^2+v1*u1^4)*(-v1*u3^2*u4^2+v2*u2^4)*(-v1*u3^2
 *u4^2+v2*u1^4)*(v1^2*u4^4+v2^2*u3^4+v1*u3^2*u4^2*v2)*(v2^2*u4^4+v1*u3^2*u4^2*v2
 +v1^2*u3^4)*(u4^4-u2^4)*(u3^4-u2^4)*(u4^4-u1^4)*(u3^4-u1^4),
 -2/u2^24/u1^24/u4^4/u3^4/v2^4/v1^4*(u3^8*u4^8+u1^4*u2^4*u3^4*u4^4+u1^8*u2^8)*(
 v2*u3^2*u4^2+v1*u2^4)*(v2*u3^2*u4^2+v1*u1^4)*(v1*u3^2*u4^2+v2*u2^4)*(v1*u3^2*u4
 ^2+v2*u1^4)*(v1^2*u4^4+v2^2*u3^4-v1*u3^2*u4^2*v2)*(v2^2*u4^4-v1*u3^2*u4^2*v2+v1
 ^2*u3^4)*(u4^4-u2^4)*(u3^4-u2^4)*(u4^4-u1^4)*(u3^4-u1^4),
 -(v2^2-v1^2)*(u1^4*v2^2*u3^4-v1^2*u2^8)*(v2^2*u1^4*u2^4-v1^2*u3^8)*
 (v2^2*u2^4*u3^4-v1^2*u1^8)*(v2^4*u4^12-v1^4*u1^4*u2^4*u3^4)*(u4^4-u2^4)*
 (u4^4-u3^4)*(u4^4-u1^4)/u4^24/u3^8/u2^8/u1^8/v2^10/v1^2,
 -(v1^2-v2^2)*(v1^2*u1^4*u3^4-v2^2*u2^8)*(v1^2*u1^4*u2^4-v2^2*u3^8)*
 (v1^2*u2^4*u3^4-u1^8*v2^2)*(v1^4*u4^12-v2^4*u1^4*u2^4*u3^4)*(u4^4-u2^4)*
 (u4^4-u3^4)*(u4^4-u1^4)/u4^24/u3^8/u2^8/u1^8/v1^10/v2^2,
 -(v2^2-v1^2)*(u1^4*v2^2*u4^4-v1^2*u2^8)*(v2^2*u1^4*u2^4-v1^2*u4^8)*
 (v2^2*u2^4*u4^4-v1^2*u1^8)*(v2^4*u3^12-v1^4*u1^4*u4^4*u2^4)*(u3^4-u2^4)*
 (u3^4-u4^4)*(u3^4-u1^4)/u3^24/u4^8/u2^8/u1^8/v2^10/v1^2,
 -(v1^2-v2^2)*(v1^2*u1^4*u4^4-v2^2*u2^8)*(v1^2*u1^4*u2^4-v2^2*u4^8)*
 (v1^2*u2^4*u4^4-u1^8*v2^2)*(v1^4*u3^12-v2^4*u1^4*u2^4*u4^4)*(u3^4-u2^4)*
 (u3^4-u4^4)*(u3^4-u1^4)/u3^24/u4^8/u2^8/u1^8/v1^10/v2^2,
 -(v2^2-v1^2)*(u1^4*v2^2*u4^4-v1^2*u3^8)*(u1^4*v2^2*u3^4-v1^2*u4^8)*
 (v2^2*u3^4*u4^4-v1^2*u1^8)*(v2^4*u2^12-v1^4*u1^4*u3^4*u4^4)*(u2^4-u3^4)*
 (u2^4-u4^4)*(u2^4-u1^4)/u2^24/u4^8/u3^8/u1^8/v2^10/v1^2,
 -(v1^2-v2^2)*(v1^2*u1^4*u4^4-v2^2*u3^8)*(v1^2*u1^4*u3^4-v2^2*u4^8)*
 (v1^2*u3^4*u4^4-u1^8*v2^2)*(v1^4*u2^12-v2^4*u1^4*u3^4*u4^4)*(u2^4-u3^4)*
 (u2^4-u4^4)*(u2^4-u1^4)/u2^24/u4^8/u3^8/u1^8/v1^10/v2^2,
 -(v2^2-v1^2)*(v2^2*u2^4*u4^4-v1^2*u3^8)*(v2^2*u2^4*u3^4-v1^2*u4^8)*
 (v2^2*u3^4*u4^4-v1^2*u2^8)*(u1^12*v2^4-v1^4*u2^4*u3^4*u4^4)*(u1^4-u3^4)*
 (u1^4-u4^4)*(u1^4-u2^4)/u1^24/u4^8/u3^8/u2^8/v2^10/v1^2,
 -(v1^2-v2^2)*(v1^2*u2^4*u4^4-v2^2*u3^8)*(v1^2*u2^4*u3^4-v2^2*u4^8)*
 (v1^2*u3^4*u4^4-v2^2*u2^8)*(v1^4*u1^12-v2^4*u2^4*u3^4*u4^4)*(u1^4-u3^4)*
 (u1^4-u4^4)*(u1^4-u2^4)/u1^24/u4^8/u3^8/u2^8/v1^10/v2^2,
 -4*(v1*u1^3-v2*u2*u3*u4)*(v1*u2^3-v2*u1*u3*u4)*(v1*u3^3-v2*u2*u1*u4)*
 (v1*u4^3-v2*u1*u2*u3)*(v2*u1^3-v1*u2*u3*u4)*(v2*u2^3-v1*u1*u3*u4)*
 (v2*u3^3-v1*u2*u1*u4)*(v2*u4^3-v1*u2*u3*u1)*(u1^4*u2^4+u3^2*u4^2*u1^2*u2^2
 +u3^4*u4^4)*(u1^4*u3^4+u3^2*u4^2*u1^2*u2^2+u2^4*u4^4)*
 (u1^4*u4^4+u3^2*u4^2*u1^2*u2^2+u2^4*u3^4)/v1^4/v2^4/u1^12/u2^12/u3^12/u4^12,
 -4*(v1*u1^3+v2*u2*u3*u4)*(v1*u2^3+v2*u1*u3*u4)*(v1*u3^3+v2*u2*u1*u4)*
 (v1*u4^3+v2*u1*u2*u3)*(v2*u1^3+v1*u2*u3*u4)*(v2*u2^3+v1*u1*u3*u4)*
 (v2*u3^3+v1*u2*u1*u4)*(v2*u4^3+v1*u2*u3*u1)*(u1^4*u2^4+u3^2*u4^2*u1^2*u2^2
 +u3^4*u4^4)*(u1^4*u3^4+u3^2*u4^2*u1^2*u2^2+u2^4*u4^4)*
 (u1^4*u4^4+u3^2*u4^2*u1^2*u2^2+u2^4*u3^4)/v1^4/v2^4/u1^12/u2^12/u3^12/u4^12,
 4*(v1*u1^3-E(4)*v2*u2*u3*u4)*(v1*u2^3-E(4)*v2*u1*u3*u4)*(v1*u3^3-E(4)*v2*u2*
 u1*u4)*(v1*u4^3-E(4)*v2*u2*u3*u1)*(v2*u1^3-E(4)*v1*u2*u3*u4)*(v2*u2^3-E(4)*v1*
 u1*u3*u4)*(v2*u3^3-E(4)*v1*u2*u1*u4)*(v2*u4^3-E(4)*v1*u2*u3*u1)*(u1^4*u2^4-
 u3^2*u4^2*u1^2*u2^2+u3^4*u4^4)*(u1^4*u3^4-u3^2*u4^2*u1^2*u2^2+u2^4*u4^4)*
 (u1^4*u4^4-u3^2*u4^2*u1^2*u2^2+u2^4*u3^4)/v1^4/v2^4/u1^12/u2^12/u3^12/u4^12,
 4*(v1*u1^3+E(4)*v2*u2*u3*u4)*(v1*u2^3+E(4)*v2*u1*u3*u4)*(v1*u3^3+E(4)*v2*u2*
 u1*u4)*(v1*u4^3+E(4)*v2*u2*u3*u1)*(v2*u1^3+E(4)*v1*u2*u3*u4)*(v2*u2^3+E(4)*v1*
 u1*u3*u4)*(v2*u3^3+E(4)*v1*u2*u1*u4)*(v2*u4^3+E(4)*v1*u2*u3*u1)*(u1^4*u2^4-
 u3^2*u4^2*u1^2*u2^2+u3^4*u4^4)*(u1^4*u3^4-u3^2*u4^2*u1^2*u2^2+u2^4*u4^4)*
 (u1^4*u4^4-u3^2*u4^2*u1^2*u2^2+u2^4*u3^4)/v1^4/v2^4/u1^12/u2^12/u3^12/u4^12],
  irredinfo:=[ rec( charname := "phi_{1,0}" ), rec(
      charname := "phi_{1,12}'" ), rec( charname := "phi_{1,6}" ), rec(
      charname := "phi_{1,18}'" ), rec( charname := "phi_{1,12}''" ), rec(
      charname := "phi_{1,24}" ), rec( charname := "phi_{1,18}''" ), rec(
      charname := "phi_{1,30}" ), rec( charname := "phi_{2,1}" ), rec(
      charname := "phi_{2,5}" ), rec( charname := "phi_{2,4}" ), rec(
      charname := "phi_{2,8}" ), rec( charname := "phi_{2,7}'" ), rec(
      charname := "phi_{2,11}'" ), rec( charname := "phi_{2,7}''" ), rec(
      charname := "phi_{2,11}''" ), rec( charname := "phi_{2,10}" ), rec(
      charname := "phi_{2,14}" ), rec( charname := "phi_{2,13}" ), rec(
      charname := "phi_{2,17}" ), rec( charname := "phi_{3,2}" ), rec(
      charname := "phi_{3,6}'" ), rec( charname := "phi_{3,4}" ), rec(
      charname := "phi_{3,8}'" ), rec( charname := "phi_{3,6}''" ), rec(
      charname := "phi_{3,10}" ), rec( charname := "phi_{3,8}''" ), rec(
      charname := "phi_{3,12}" ), rec( charname := "phi_{4,7}" ), rec(
      charname := "phi_{4,3}" ), rec( charname := "phi_{4,5}" ), rec(
      charname := "phi_{4,9}" ) ],
  operations:=CharTableOps); 
end;


##########################################################################
##
#F HeckeCharTableG12( <para> )  . . . . . . . . . . Shephard-Todd type G12
##
## returns the character table of type G12 in the Shephard-Todd 
## classification. The variable <para> is a single value or a list of
## two parameters.
##
HeckeCharTableG12:=function(para)
  local u1,u2;
  if IsList(para) then
    u1:=para[1];  u2:=para[2];
  else
    u1:=para;     u2:=E(4);
  fi;
  return rec( name:="H(G12)", identifier:="H(G12)",
  parameter:=[u1^2,u2^2], size:=48,
  dim:=2, degrees:=[6,8], reflchar:=4, reflclasses:=[3],
  classtext:= ["??"],
#    classnames:=[],
  orders:=[1,2,2,3,4,6,8,8],
  centralizers:=[48,48,4,6,8,6,8,8],
  classes:=[1,1,12,8,6,8,6,6],
  powermap:=[,[1,1,1,4,2,4,5,5], [1,2,3,1,5,2,7,8]],
  irreducibles:= [
  [1,u1^24,u1^2,u1^8,u1^12,u1^4,u1^6,u1^30],
  [1,u2^24,u2^2,u2^8,u2^12,u2^4,u2^6,u2^30],
  [2,2*u2^12*u1^12,u1^2+u2^2,-u2^4*u1^4,-2*u2^6*u1^6,u2^2*u1^2,0,0],
  [2,-2*u2^12*u1^12,u2^2+u1^2,3*u2^4*u1^4-2*u1^3*u2^5*(E(8)+E(8)^7)
 -2*(E(8)+E(8)^7)*u2^3*u1^5+2*u1^2*u2^6+2*u1^6*u2^2,0,
 1/2*(E(8)+E(8)^7)*(-(E(8)+E(8)^7)*u2*u1+2*u2^2+2*u1^2)*u2*u1,
 (E(8)+E(8)^7)*u2^3*u1^3,-u2^15*u1^15*(E(8)+E(8)^7)],
  [2,-2*u1^12*u2^12,u2^2+u1^2,3*u2^4*u1^4+2*u2^5*u1^3*(E(8)+E(8)^7)
 +2*u2^3*(E(8)+E(8)^7)*u1^5+2*u2^6*u1^2+2*u1^6*u2^2,0,
 -1/2*(E(8)+E(8)^7)*(2*u2^2+(E(8)+E(8)^7)*u2*u1+2*u1^2)*u2*u1,
 -u2^3*(E(8)+E(8)^7)*u1^3,u1^15*u2^15*(E(8)+E(8)^7)],
  [3,3*u1^16*u2^8,2*u1^2+u2^2,u1^4*(u1^4-u2^4),-u1^8*u2^4,u1^2*(u2^2+u1^2),
 u2^2*u1^4,u1^20*u2^10],
  [3,3*u2^16*u1^8,2*u2^2+u1^2,u2^4*(u2^4-u1^4),-u2^8*u1^4,u2^2*(u2^2+u1^2),
 u2^4*u1^2,u2^20*u1^10],
  [4,-4*u1^12*u2^12,2*u1^2+2*u2^2,-u1^2*u2^2*(2*u1^4+3*u2^2*u1^2+2*u2^4),0,
 u1^2*u2^2,0,0]]*u1^0,
  schurelements:=[
   (u1-u2)^2*(u1+u2)^2*(u2^4-u2^2*u1^2+u1^4)*(u1^8-u2^4*u1^4+u2^8)
   *(u1^4+u2^4)^2/u2^24,
   (u1-u2)^2*(u1+u2)^2*(u2^4-u2^2*u1^2+u1^4)*(u1^8-u2^4*u1^4+u2^8)
   *(u1^4+u2^4)^2/u1^24,
   -12*(u1^4-(E(8)+E(8)^7)*u2*u1^3+u2^2*u1^2-(E(8)+E(8)^7)*u2^3*u1+u2^4)
   *(u2^2-(E(8)+E(8)^7)*u2*u1+u1^2)^2/u1^4/u2^4,
   -12*(u1^4+(E(8)+E(8)^7)*u2*u1^3+u2^2*u1^2+(E(8)+E(8)^7)*u2^3*u1+u2^4)
   *(u2^2+(E(8)+E(8)^7)*u2*u1+u1^2)^2/u1^4/u2^4,
   2*(u2^4-u2^2*u1^2+u1^4)*(u1-u2)^2*(u1+u2)^2/u2^4/u1^4,
   -(u1-u2)^2*(u1+u2)^2*(u1^4+u2^4)^2/u1^2/u2^10,
   -(u1-u2)^2*(u1+u2)^2*(u1^4+u2^4)^2/u1^10/u2^2,
   3/u2^4/u1^4*(u1^4+u2^4)^2],
  irredinfo:=[ rec( charname := "phi_{1,0}" ), rec(
      charname := "phi_{1,12}" ), rec( charname := "phi_{2,4}" ), rec(
      charname := "phi_{2,1}" ), rec( charname := "phi_{2,5}" ), rec(
      charname := "phi_{3,2}" ), rec( charname := "phi_{3,6}" ), rec(
      charname := "phi_{4,3}" ) ],
  operations:=CharTableOps); 
end;


##########################################################################
##
#F HeckeCharTableG25( <para> )  . . . . . . . . . . Shephard-Todd type G25
##
## returns the character table of type G25 in the Shephard-Todd 
## classification. The variable <para> is a single value or a list of
## three parameters.
##
HeckeCharTableG25:=function(para)
  local u1,u2,u3;
  if IsList(para) then
    u1:=para[1];  u2:=para[2];  u3:=para[3];
  else
    u1:=para;     u2:=E(3);     u3:=E(3)^2;
  fi;
  return rec( name:="H(G25)", identifier:="H(G25)",
   parameter:=[u1,u2,u3], size:=648,
  dim:=3, degrees:=[6,9,12], reflchar:=11, reflclasses:=[5],
  classtext:= ["??"],
#    classnames:=[],
  orders:=[1,2,3,3,3,3,3,3,3,3,3,4,6,6,6,6,6,6,6,6,9,9,12,12],
  centralizers:=[648,72,648,648,54,54,54,54,54,54,27,12,72,72,18,18,18,18,18,18,
      9,9,12,12],
  classes:=[1,9,1,1,12,12,12,12,12,12,24,54,9,9,36,36,36,36,36,36,72,72,54,54],
  powermap:=[,[1,1,4,3,6,5,8,7,10,9,11,2,3,4,5,6,9,10,8,7,22,21,13,14],
      [1,2,1,1,1,1,1,1,1,1,1,12,2,2,2,2,2,2,2,2,3,4,12,12]],
  irreducibles:= [
  [1,u1^18,u1^12,u1^24,u1,u1^2,u1^14,u1^25,u1^13,u1^26,u1^3,u1^9,u1^6,u1^30,u1^2,
 u1^10,u1^26,u1^22,u1^14,u1^34,u1^4,u1^8,u1^3,u1^15],
  [1,u2^18,u2^12,u2^24,u2,u2^2,u2^14,u2^25,u2^13,u2^26,u2^3,u2^9,u2^6,u2^30,u2^2,
 u2^10,u2^26,u2^22,u2^14,u2^34,u2^4,u2^8,u2^3,u2^15],
  [1,u3^18,u3^12,u3^24,u3,u3^2,u3^14,u3^25,u3^13,u3^26,u3^3,u3^9,u3^6,u3^30,u3^2,
 u3^10,u3^26,u3^22,u3^14,u3^34,u3^4,u3^8,u3^3,u3^15],
  [2,-2*u1^9*u2^9,2*u1^6*u2^6,2*u1^12*u2^12,u1+u2,u1^2+u2^2,u1^6*u2^6*(u1^2+u2^2),
 u1^12*u2^12*(u1+u2),u1^6*u2^6*(u1+u2),u1^12*u2^12*(u1^2+u2^2),u1^3+u2^3,0,
 -2*u1^3*u2^3,-2*u1^15*u2^15,u1*u2,u1^5*u2^5,u1^13*u2^13,u1^11*u2^11,u1^7*u2^7,
 u1^17*u2^17,-u1^2*u2^2,-u1^4*u2^4,0,0],
  [2,-2*u1^9*u3^9,2*u1^6*u3^6,2*u1^12*u3^12,u1+u3,u1^2+u3^2,u1^6*u3^6*(u1^2+u3^2),
 u1^12*u3^12*(u1+u3),u1^6*u3^6*(u1+u3),u1^12*u3^12*(u1^2+u3^2),u1^3+u3^3,0,
 -2*u1^3*u3^3,-2*u1^15*u3^15,u1*u3,u1^5*u3^5,u1^13*u3^13,u1^11*u3^11,u1^7*u3^7,
 u1^17*u3^17,-u1^2*u3^2,-u1^4*u3^4,0,0],
  [2,-2*u2^9*u3^9,2*u2^6*u3^6,2*u2^12*u3^12,u2+u3,u2^2+u3^2,u2^6*u3^6*(u2^2+u3^2),
 u2^12*u3^12*(u2+u3),u2^6*u3^6*(u2+u3),u2^12*u3^12*(u2^2+u3^2),u2^3+u3^3,0,
 -2*u2^3*u3^3,-2*u2^15*u3^15,u2*u3,u2^5*u3^5,u2^13*u3^13,u2^11*u3^11,u2^7*u3^7,
 u2^17*u3^17,-u2^2*u3^2,-u2^4*u3^4,0,0],
  [3,3*u3^6*u1^6*u2^6,3*u3^4*u1^4*u2^4,3*u3^8*u1^8*u2^8,u3+u1+u2,u3^2+u1^2+u2^2,
 u3^4*u1^4*u2^4*(u3^2+u1^2+u2^2),u1^8*u3^8*u2^8*(u3+u1+u2),
 u1^4*u3^4*u2^4*(u3+u1+u2),u3^8*u1^8*u2^8*(u3^2+u1^2+u2^2),u3^3+u1^3+u2^3,
 -u3^3*u1^3*u2^3,3*u3^2*u1^2*u2^2,3*u3^10*u1^10*u2^10,0,0,0,0,0,0,0,0,
 -u3*u1*u2,-u3^5*u1^5*u2^5],
  [3,-u2^12*u1^6,3*u2^8*u1^4,3*u2^16*u1^8,u1+2*u2,u1^2+2*u2^2,
 u2^8*u1^4*(u1^2+2*u2^2),u1^8*u2^16*(u1+2*u2),u1^4*u2^8*(u1+2*u2),
 u2^16*u1^8*(u1^2+2*u2^2),(u1^2+u1*u2+u2^2)*u2,u1^3*u2^6,-u1^2*u2^4,
 -u2^20*u1^10,u2*(u1+u2),u2^5*(u1^5+u2^5),u1^8*u2^17*(u1+u2),
 u1^4*u2^13*(u1^5+u2^5),u1^4*u2^9*(u1+u2),u1^8*u2^21*(u1^5+u2^5),0,0,
 u1*u2^2,u1^5*u2^10],
  [3,-u3^12*u1^6,3*u3^8*u1^4,3*u3^16*u1^8,u1+2*u3,u1^2+2*u3^2,
 u3^8*u1^4*(u1^2+2*u3^2),u1^8*u3^16*(u1+2*u3),u1^4*u3^8*(u1+2*u3),
 u3^16*u1^8*(u1^2+2*u3^2),(u1^2+u1*u3+u3^2)*u3,u1^3*u3^6,-u1^2*u3^4,
 -u3^20*u1^10,u3*(u1+u3),u3^5*(u1^5+u3^5),u1^8*u3^17*(u1+u3),
 u1^4*u3^13*(u1^5+u3^5),u1^4*u3^9*(u1+u3),u1^8*u3^21*(u1^5+u3^5),0,0,
 u1*u3^2,u1^5*u3^10],
  [3,-u3^12*u2^6,3*u3^8*u2^4,3*u3^16*u2^8,u2+2*u3,u2^2+2*u3^2,
 u3^8*u2^4*(u2^2+2*u3^2),u2^8*u3^16*(u2+2*u3),u2^4*u3^8*(u2+2*u3),
 u3^16*u2^8*(u2^2+2*u3^2),(u2^2+u2*u3+u3^2)*u3,u2^3*u3^6,-u2^2*u3^4,
 -u3^20*u2^10,u3*(u2+u3),u3^5*(u2^5+u3^5),u2^8*u3^17*(u2+u3),
 u2^4*u3^13*(u2^5+u3^5),u2^4*u3^9*(u2+u3),u2^8*u3^21*(u2^5+u3^5),0,0,
 u2*u3^2,u2^5*u3^10],
  [3,-u1^12*u2^6,3*u1^8*u2^4,3*u1^16*u2^8,u2+2*u1,u2^2+2*u1^2,
 u1^8*u2^4*(u2^2+2*u1^2),u2^8*u1^16*(u2+2*u1),u2^4*u1^8*(u2+2*u1),
 u1^16*u2^8*(u2^2+2*u1^2),(u2^2+u2*u1+u1^2)*u1,u2^3*u1^6,-u2^2*u1^4,
 -u1^20*u2^10,u1*(u2+u1),u1^5*(u2^5+u1^5),u2^8*u1^17*(u2+u1),
 u2^4*u1^13*(u2^5+u1^5),u2^4*u1^9*(u2+u1),u2^8*u1^21*(u2^5+u1^5),0,0,
 u2*u1^2,u2^5*u1^10],
  [3,-u1^12*u3^6,3*u1^8*u3^4,3*u1^16*u3^8,u3+2*u1,u3^2+2*u1^2,
 u1^8*u3^4*(u3^2+2*u1^2),u3^8*u1^16*(u3+2*u1),u3^4*u1^8*(u3+2*u1),
 u1^16*u3^8*(u3^2+2*u1^2),(u3^2+u3*u1+u1^2)*u1,u3^3*u1^6,-u3^2*u1^4,
 -u1^20*u3^10,u1*(u3+u1),u1^5*(u3^5+u1^5),u3^8*u1^17*(u3+u1),
 u3^4*u1^13*(u3^5+u1^5),u3^4*u1^9*(u3+u1),u3^8*u1^21*(u3^5+u1^5),0,0,
 u3*u1^2,u3^5*u1^10],
  [3,-u2^12*u3^6,3*u2^8*u3^4,3*u2^16*u3^8,u3+2*u2,u3^2+2*u2^2,
 u2^8*u3^4*(u3^2+2*u2^2),u3^8*u2^16*(u3+2*u2),u3^4*u2^8*(u3+2*u2),
 u2^16*u3^8*(u3^2+2*u2^2),(u3^2+u3*u2+u2^2)*u2,u3^3*u2^6,-u3^2*u2^4,
 -u2^20*u3^10,u2*(u3+u2),u2^5*(u3^5+u2^5),u3^8*u2^17*(u3+u2),
 u3^4*u2^13*(u3^5+u2^5),u3^4*u2^9*(u3+u2),u3^8*u2^21*(u3^5+u2^5),0,0,
 u3*u2^2,u3^5*u2^10],
  [6,2*u3^3*u2^9*u1^6,6*u3^2*u1^4*u2^6,6*u3^4*u1^8*u2^12,2*u1+3*u2+u3,
 2*u1^2+3*u2^2+u3^2,u3^2*u1^4*u2^6*(2*u1^2+3*u2^2+u3^2),
 u1^8*u3^4*u2^12*(2*u1+3*u2+u3),u1^4*u2^6*u3^2*(2*u1+3*u2+u3),
 u3^4*u1^8*u2^12*(2*u1^2+3*u2^2+u3^2),u1^3+u1^2*u2+u1*u2^2+u2*u3^2+u3*u2^2+u2^3,
 0,2*u2^3*u3*u1^2,2*u3^5*u1^10*u2^15,u2*(u1+u2),u2^5*(u1^5+u2^5),
 u1^8*u2^13*u3^4*(u1+u2),u1^4*u2^11*u3^2*(u1^5+u2^5),u1^4*u3^2*u2^7*(u1+u2),
 u1^8*u2^17*u3^4*(u1^5+u2^5),0,0,0,0],
  [6,2*u2^3*u3^9*u1^6,6*u2^2*u1^4*u3^6,6*u2^4*u1^8*u3^12,2*u1+3*u3+u2,
 2*u1^2+3*u3^2+u2^2,u2^2*u1^4*u3^6*(2*u1^2+3*u3^2+u2^2),
 u1^8*u2^4*u3^12*(2*u1+3*u3+u2),u1^4*u3^6*u2^2*(2*u1+3*u3+u2),
 u2^4*u1^8*u3^12*(2*u1^2+3*u3^2+u2^2),u1^3+u1^2*u3+u1*u3^2+u3*u2^2+u2*u3^2+u3^3,
 0,2*u3^3*u2*u1^2,2*u2^5*u1^10*u3^15,u3*(u1+u3),u3^5*(u1^5+u3^5),
 u1^8*u3^13*u2^4*(u1+u3),u1^4*u3^11*u2^2*(u1^5+u3^5),u1^4*u2^2*u3^7*(u1+u3),
 u1^8*u3^17*u2^4*(u1^5+u3^5),0,0,0,0],
  [6,2*u1^3*u3^9*u2^6,6*u1^2*u2^4*u3^6,6*u1^4*u2^8*u3^12,2*u2+3*u3+u1,
 2*u2^2+3*u3^2+u1^2,u1^2*u2^4*u3^6*(2*u2^2+3*u3^2+u1^2),
 u2^8*u1^4*u3^12*(2*u2+3*u3+u1),u2^4*u3^6*u1^2*(2*u2+3*u3+u1),
 u1^4*u2^8*u3^12*(2*u2^2+3*u3^2+u1^2),u2^3+u2^2*u3+u2*u3^2+u3*u1^2+u1*u3^2+u3^3,
 0,2*u3^3*u1*u2^2,2*u1^5*u2^10*u3^15,u3*(u2+u3),u3^5*(u2^5+u3^5),
 u2^8*u3^13*u1^4*(u2+u3),u2^4*u3^11*u1^2*(u2^5+u3^5),u2^4*u1^2*u3^7*(u2+u3),
 u2^8*u3^17*u1^4*(u2^5+u3^5),0,0,0,0],
  [6,2*u1^3*u2^9*u3^6,6*u1^2*u3^4*u2^6,6*u1^4*u3^8*u2^12,2*u3+3*u2+u1,
 2*u3^2+3*u2^2+u1^2,u1^2*u3^4*u2^6*(2*u3^2+3*u2^2+u1^2),
 u3^8*u1^4*u2^12*(2*u3+3*u2+u1),u3^4*u2^6*u1^2*(2*u3+3*u2+u1),
 u1^4*u3^8*u2^12*(2*u3^2+3*u2^2+u1^2),u3^3+u3^2*u2+u3*u2^2+u2*u1^2+u1*u2^2+u2^3,
 0,2*u2^3*u1*u3^2,2*u1^5*u3^10*u2^15,u2*(u3+u2),u2^5*(u3^5+u2^5),
 u3^8*u2^13*u1^4*(u3+u2),u3^4*u2^11*u1^2*(u3^5+u2^5),u3^4*u1^2*u2^7*(u3+u2),
 u3^8*u2^17*u1^4*(u3^5+u2^5),0,0,0,0],
  [6,2*u3^3*u1^9*u2^6,6*u3^2*u2^4*u1^6,6*u3^4*u2^8*u1^12,2*u2+3*u1+u3,
 2*u2^2+3*u1^2+u3^2,u3^2*u2^4*u1^6*(2*u2^2+3*u1^2+u3^2),
 u2^8*u3^4*u1^12*(2*u2+3*u1+u3),u2^4*u1^6*u3^2*(2*u2+3*u1+u3),
 u3^4*u2^8*u1^12*(2*u2^2+3*u1^2+u3^2),u2^3+u2^2*u1+u2*u1^2+u1*u3^2+u3*u1^2+u1^3,
 0,2*u1^3*u3*u2^2,2*u3^5*u2^10*u1^15,u1*(u2+u1),u1^5*(u2^5+u1^5),
 u2^8*u1^13*u3^4*(u2+u1),u2^4*u1^11*u3^2*(u2^5+u1^5),u2^4*u3^2*u1^7*(u2+u1),
 u2^8*u1^17*u3^4*(u2^5+u1^5),0,0,0,0],
  [6,2*u2^3*u1^9*u3^6,6*u2^2*u3^4*u1^6,6*u2^4*u3^8*u1^12,2*u3+3*u1+u2,
 2*u3^2+3*u1^2+u2^2,u2^2*u3^4*u1^6*(2*u3^2+3*u1^2+u2^2),
 u3^8*u2^4*u1^12*(2*u3+3*u1+u2),u3^4*u1^6*u2^2*(2*u3+3*u1+u2),
 u2^4*u3^8*u1^12*(2*u3^2+3*u1^2+u2^2),u3^3+u3^2*u1+u3*u1^2+u1*u2^2+u2*u1^2+u1^3,
 0,2*u1^3*u2*u3^2,2*u2^5*u3^10*u1^15,u1*(u3+u1),u1^5*(u3^5+u1^5),
 u3^8*u1^13*u2^4*(u3+u1),u3^4*u1^11*u2^2*(u3^5+u1^5),u3^4*u2^2*u1^7*(u3+u1),
 u3^8*u1^17*u2^4*(u3^5+u1^5),0,0,0,0],
  [8,0,8*u1^6*u2^3*u3^3,8*u1^12*u2^6*u3^6,4*u1+2*u2+2*u3,4*u1^2+2*u2^2+2*u3^2,
 2*u1^6*u2^3*u3^3*(2*u1^2+u2^2+u3^2),2*u2^6*u1^12*u3^6*(u3+2*u1+u2),
 2*u2^3*u1^6*u3^3*(u3+2*u1+u2),2*u1^12*u2^6*u3^6*(2*u1^2+u2^2+u3^2),
 u1*u2^2+u3*u2^2+u3^2*u2+u1^2*u2+u3*u1^2+2*u1^3+u3^2*u1,0,0,0,u1*(u1+u2+u3),
 u1^5*(u3^5+u2^5+u1^5),u2^6*u1^13*u3^6*(u1+u2+u3),
 u2^3*u3^3*u1^11*(u3^5+u2^5+u1^5),u2^3*u3^3*u1^7*(u1+u2+u3),
 u2^6*u3^6*u1^17*(u3^5+u2^5+u1^5),-u2*u3*u1^2,-u2^2*u3^2*u1^4,0,0],
  [8,0,8*u2^6*u1^3*u3^3,8*u2^12*u1^6*u3^6,4*u2+2*u1+2*u3,4*u2^2+2*u1^2+2*u3^2,
 2*u2^6*u1^3*u3^3*(2*u2^2+u1^2+u3^2),2*u1^6*u2^12*u3^6*(u3+2*u2+u1),
 2*u1^3*u2^6*u3^3*(u3+2*u2+u1),2*u2^12*u1^6*u3^6*(2*u2^2+u1^2+u3^2),
 u2*u1^2+u3*u1^2+u3^2*u1+u2^2*u1+u3*u2^2+2*u2^3+u3^2*u2,0,0,0,u2*(u2+u1+u3),
 u2^5*(u3^5+u1^5+u2^5),u1^6*u2^13*u3^6*(u2+u1+u3),
 u1^3*u3^3*u2^11*(u3^5+u1^5+u2^5),u1^3*u3^3*u2^7*(u2+u1+u3),
 u1^6*u3^6*u2^17*(u3^5+u1^5+u2^5),-u1*u3*u2^2,-u1^2*u3^2*u2^4,0,0],
  [8,0,8*u3^6*u1^3*u2^3,8*u3^12*u1^6*u2^6,4*u3+2*u1+2*u2,4*u3^2+2*u1^2+2*u2^2,
 2*u3^6*u1^3*u2^3*(2*u3^2+u1^2+u2^2),2*u1^6*u3^12*u2^6*(u2+2*u3+u1),
 2*u1^3*u3^6*u2^3*(u2+2*u3+u1),2*u3^12*u1^6*u2^6*(2*u3^2+u1^2+u2^2),
 u3*u1^2+u2*u1^2+u2^2*u1+u3^2*u1+u2*u3^2+2*u3^3+u2^2*u3,0,0,0,u3*(u3+u1+u2),
 u3^5*(u2^5+u1^5+u3^5),u1^6*u3^13*u2^6*(u3+u1+u2),
 u1^3*u2^3*u3^11*(u2^5+u1^5+u3^5),u1^3*u2^3*u3^7*(u3+u1+u2),
 u1^6*u2^6*u3^17*(u2^5+u1^5+u3^5),-u1*u2*u3^2,-u1^2*u2^2*u3^4,0,0]

],
  irredinfo:=[ rec( charname := "phi_{1,0}" ), rec(
      charname := "phi_{1,12}" ), rec( charname := "phi_{1,24}" ), rec(
      charname := "phi_{2,3}" ), rec( charname := "phi_{2,9}" ), rec(
      charname := "phi_{2,15}" ), rec( charname := "phi_{3,6}" ), rec(
      charname := "phi_{3,5}'" ), rec( charname := "phi_{3,13}'" ), rec(
      charname := "phi_{3,17}" ), rec( charname := "phi_{3,1}" ), rec(
      charname := "phi_{3,5}''" ), rec( charname := "phi_{3,13}''" ), rec(
      charname := "phi_{6,4}'" ), rec( charname := "phi_{6,8}'" ), rec(
      charname := "phi_{6,10}" ), rec( charname := "phi_{6,8}''" ), rec(
      charname := "phi_{6,2}" ), rec( charname := "phi_{6,4}''" ), rec(
      charname := "phi_{8,3}" ), rec( charname := "phi_{8,6}" ), rec(
      charname := "phi_{8,9}" ), rec( charname := "phi_{9,?}" ), rec(
      charname := "phi_{9,?}" ) ],
  operations:=CharTableOps); 
end;
