#############################################################################
##
#A  weyl2e6.g             CHEVIE library                        Frank Luebeck
##
#A  $Id: weyl2e6.g,v 1.1 1997/01/21 13:46:45 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##

CHEVIE.2E6:=rec();

CHEVIE.2E6.PositionId:=function() return 1; end;
 
CHEVIE.2E6.PositionSgn:=function() return 2; end;
 
CHEVIE.2E6.PositionRefl:=function() return 4; end;


# elements of minimal length
##  # to find shortest representatives:
##  w:=CoxeterGroup("E",6);
##  els:=List(ConjugacyClasses(w),Elements)*LongestCoxeterElement(w);;
##  short:=[];
##  len:=List(els,l->List(l,x->CoxeterLength(w,x)));;
##  for i in [1..Length(len)] do
##    Add(short,els[i][Position(len[i],Minimum(len[i]))]);
##  od;
##  short:=List(short,x->CoxeterWord(w,x));

#CHEVIE.2E6.classtext:=[[1,2,3,1,4,2,3,1,4,3,5,4,2,3,1,4,3,5,4,2,6,5,4,2,
#  3,1,4,3,5,4,2,6,5,4,3,1],[],[3,4,3,5,4,3],
#  [1,2,4,3,1,5,4,3,6,5,4,3],
#  [1,2,3,1,4,3,1,5,4,3,1,6,5,4,3,1],
#  [1,2,4,2,3,1,4,3,5,4,3,1,6,5],
#  [1,4,2,3,1,4,3,5,4,2,3,1,4,6,5,4,3,1],[1,2],
#  [1,2,3,4,3,5,4,3],
#  [1,4,2,5,4,2,3,1,6,5,4,2,3,1,4,5],[2,4],[1,5],
#  [5,4],[1,2,5,4],[1,2,3,1,4,3],
#  [1,3,1,4,3,1,5,4,3,1,6,5,4,3,1],[2],[1],
#  [2,3,4,3,5,4,3],[1,3,4,3,5,4,3],[1,3,1,4,3],
#  [1,2,5],[2,5,4],[1,5,4],[1,2,4]];

# "good"
CHEVIE.2E6.classtext:=[[1,2,3,1,4,2,3,1,4,3,5,4,2,3,1,4,3,5,4,2,6,5,4,2,
     3,1,4,3,5,4,2,6,5,4,3,1],
  [],[3,4,3,5,4,3],
  [1,2,4,3,1,5,4,3,6,5,4,3],
  [1,2,3,1,4,3,1,5,4,3,1,6,5,4,3,1],
  [2,3,4,2,3,4,6,5,4,2,3,4,5,6],
  [1,4,2,3,1,4,3,5,4,2,3,1,4,6,5,4,3,1],[1,2],
  [4,5,4,2,3,1,4,5],
  [4,2,5,4,2,3,4,5,6,5,4,2,3,4,5,6],[2,4],[1,5],
  [5,4],[1,2,5,4],[1,2,3,1,4,3],
  [1,3,1,4,3,1,5,4,3,1,6,5,4,3,1],[2],[1],
  [2,3,4,3,5,4,3],[1,3,4,3,5,4,3],[1,3,1,4,3],
  [1,2,5],[2,5,4],[1,5,4],[1,2,4]];

CHEVIE.2E6.classnames:=[ " ", "4A_1", "2A_1", "3A_2", "A_2", "2A_2", "D_4(a_1)", 
  "A_3+A_1", "A_4", "E_6(a_2)", "D_4", "A_5+A_1", "A_2+2A_1", 
  "E_6(a_1)", "E_6", "A_1", "3A_1", "A_3+2A_1", "A_3", "A_2+A_1", 
  "2A_2+A_1", "A_5", "D_5", "A_4+A_1", "D_5(a_1)" ];

#how to make a .charname from a .charparam
CHEVIE.2E6.CharName:=x->String(Concatenation("phi_{",String(x[1]),
                                        ",",String(x[2]),"}"));

CHEVIE.2E6.CharParams:=function()
  return [[ 1, 0 ], [ 1, 36 ], [ 10, 9 ], [ 6, 1 ], [ 6, 25 ],
  [ 20, 10 ], [ 15, 5 ], [ 15, 17 ], [ 15, 4 ], [ 15, 16 ], [ 20, 2 ],
  [ 20, 20 ], [ 24, 6 ], [ 24, 12 ], [ 30, 3 ], [ 30, 15 ], [ 60, 8 ],
  [ 80, 7 ], [ 90, 8 ], [ 60, 5 ], [ 60, 11 ], [ 64, 4 ], [ 64, 13 ],
  [ 81, 6 ], [ 81, 10 ] ];
end;

CHEVIE.2E6.frame:=
[ "1_p", "1_p'", "10_s", "6_p", "6_p'", "20_s", "15_p", "15_p'", "15_q",
  "15_q'", "20_p", "20_p'", "24_p", "24_p'", "30_p", "30_p'", "60_s", "80_s",
  "90_s", "60_p", "60_p'", "64_p", "64_p'", "81_p", "81_p'" ];

CHEVIE.2E6.cyclestructure:=[ [  ], [ 36 ], [ 30 ], [ , 24 ], [ , 20 ], 
  [ , 22 ], [ ,, 18 ], [ 5,, 15 ], 
  [ ,,, 14 ], [ ,,,, 12 ], [ 6,,,, 10 ], [ 3,,,, 11 ], [ 6, 4,,, 8 ], 
  [ ,,,,,,, 8 ], [ ,,,,,,,,,, 6 ], 
  [ 21 ], [ 35 ], [ 6,, 15 ], [ 4,, 15 ], 
  [ 3, 8,,, 6 ], [ 3, 10,,, 6 ], [ 2,,,, 11 ], [ ,,,,,, 9 ], 
  [ 1,,, 6,,,,, 4 ], [ ,, 3,, 2,,,,,, 4 ] ];

CHEVIE.2E6.generators:=
  [ ( 1,37)( 3, 7)( 9,12)(13,17)(15,18)(19,22)(21,23)(24,26)(25,27)(28,30)
    (31,33)(39,43)(45,48)(49,53)(51,54)(55,58)(57,59)(60,62)(61,63)(64,66)
    (67,69), ( 2,38)( 4, 8)
    ( 9,13)(10,14)(12,17)(15,19)(16,20)(18,22)(21,25)
    (23,27)(35,36)(40,44)(45,49)(46,50)(48,53)(51,55)(52,56)(54,58)(57,61)
    (59,63)(71,72), ( 1, 7)
    ( 3,39)( 4, 9)( 8,13)(10,15)(14,19)(16,21)(20,25)
    (26,29)(30,32)(33,34)(37,43)(40,45)(44,49)(46,51)(50,55)(52,57)(56,61)
    (62,65)(66,68)(69,70), ( 2, 8)
    ( 3, 9)( 4,40)( 5,10)( 7,12)(11,16)(19,24)
    (22,26)(25,28)(27,30)(34,35)(38,44)(39,45)(41,46)(43,48)(47,52)(55,60)
    (58,62)(61,64)(63,66)(70,71), 
    ( 4,10)( 5,41)( 6,11)( 8,14)( 9,15)(12,18)
    (13,19)(17,22)(28,31)(30,33)(32,34)(40,46)(42,47)(44,50)(45,51)(48,54)
    (49,55)(53,58)(64,67)(66,69)
    (68,70), ( 5,11)( 6,42)(10,16)(14,20)(15,21)
    (18,23)(19,25)(22,27)
    (24,28)(26,30)(29,32)(41,47)(46,52)(50,56)(51,57)
    (54,59)(55,61)(58,63)(60,64)(62,66)(65,68) ];

CHEVIE.2E6.phi:=(1,42)(2,38)(3,41)(4,40)(5,39)(6,37)
  (7,47)(8,44)(9,46)(10,45)(11,43)(12,52)(13,50)(14,49)(15,51)(16,48)
  (17,56)(18,57)(19,55)(20,53)(21,54)(22,61)
  (23,59)(24,60)(25,58)(26,64)(27,63)(28,62)
  (29,67)(30,66)(31,65)(32,69)(33,68)(34,70)(35,71)(36,72);

CHEVIE.2E6.cartan:=[ [ 2, 0, -1, 0, 0, 0 ], [ 0, 2, 0, -1, 0, 0 ], 
  [ -1, 0, 2, -1, 0, 0 ], [ 0, -1, -1, 2, -1, 0 ], [ 0, 0, 0, -1, 2, -1 ], 
  [ 0, 0, 0, 0, -1, 2 ] ];

CHEVIE.2E6.powermap:=[];
CHEVIE.2E6.orders:=[];
CHEVIE.2E6.centralizers:=[ 51840, 1152, 192, 648, 216, 108, 96, 16, 10, 72, 36,
  36, 24, 9, 12, 1440, 96, 96, 32, 36, 36, 12, 8, 10, 12 ];

CHEVIE.2E6.classes:=[ 1, 45, 270, 80, 240, 480, 540, 3240, 5184, 720, 1440, 1440,
  2160, 5760, 4320, 36, 540, 540, 1620, 1440, 1440, 4320, 6480, 5184, 4320 ];

CHEVIE.2E6.vpolheckeirreducibles:=
[ [ [ [ 1 ], 72 ], [ [ 1 ], 0 ], [ [ 1 ], 12 ], [ [ 1 ], 24 ], [ [ 1 ], 32 ], 
      [ [ 1 ], 28 ], [ [ 1 ], 36 ], [ [ 1 ], 4 ], [ [ 1 ], 16 ], 
      [ [ 1 ], 32 ], [ [ 1 ], 4 ], [ [ 1 ], 4 ], [ [ 1 ], 4 ], [ [ 1 ], 8 ], 
      [ [ 1 ], 12 ], [ [ 1 ], 30 ], [ [ 1 ], 2 ], [ [ 1 ], 2 ], 
      [ [ 1 ], 14 ], [ [ 1 ], 14 ], [ [ 1 ], 10 ], [ [ 1 ], 6 ], 
      [ [ 1 ], 6 ], [ [ 1 ], 6 ], [ [ 1 ], 6 ] ], 
  [ [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ -1 ], 0 ] ], 
  [ [ [ -10 ], 36 ], [ [ 6 ], 0 ], [ [ -3, 0, 4, 0, -3 ], 4 ], 
      [ [ -1 ], 12 ], [ [ -1, 0, 0, 0, 4, 0, 0, 0, -1 ], 12 ], 
      [ [ -1, 0, -2, 0, -1 ], 12 ], [ [ -2 ], 18 ], [ [ 2, 0, -2, 0, 2 ], 0 ],
      [ [  ], 0 ], [ [ 3 ], 16 ], [ [ 1, 0, -2, 0, 1 ], 0 ], 
      [ [ 1, 0, -2, 0, 1 ], 0 ], [ [ -2 ], 2 ], [ [ -1 ], 4 ], [ [ 1 ], 6 ], 
      [ [ 5, 0, 0, 0, 0, 0, -5 ], 12 ], [ [ -3, 0, 3 ], 0 ], 
      [ [ -3, 0, 3 ], 0 ], [ [ -1, 0, 1 ], 6 ], 
      [ [ 1, 0, -2, 0, 2, 0, -1 ], 4 ], [ [ 2, 0, -2 ], 4 ], 
      [ [ -1, 0, 1, 0, -1, 0, 1 ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 1, 0, -1, 0, 1 ], 0 ] ], 
  [ [ [ -6 ], 60 ], [ [ 2 ], 0 ], [ [ -3, 0, 0, 0, 1 ], 8 ], [ [ 3 ], 20 ], 
      [ [ -4, 0, 1 ], 26 ], [ [ -2, 0, 2 ], 22 ], [ [ -2 ], 30 ], 
      [ [ -1, 0, 1 ], 2 ], [ [ -1 ], 12 ], [ [ -2, 0, 1 ], 26 ], 
      [ [ -1 ], 2 ], [ [ 2 ], 4 ], [ [ 1 ], 4 ], [ [  ], 0 ], [ [ 1 ], 10 ], 
      [ [ -5, 0, 0, 0, 0, 0, 1 ], 24 ], [ [ -1, 0, 1 ], 0 ], [ [ 2 ], 2 ], 
      [ [ -2 ], 10 ], [ [ -2, 0, 0, 0, 1 ], 10 ], [ [ 1, 0, 1 ], 8 ], 
      [ [ -1, 0, 1 ], 4 ], [ [  ], 0 ], [ [ 1 ], 6 ], [ [ -1 ], 4 ] ], 
  [ [ [ -6 ], 12 ], [ [ 2 ], 0 ], [ [ 1, 0, 0, 0, -3 ], 0 ], [ [ 3 ], 4 ], 
      [ [ 1, 0, -4 ], 4 ], [ [ 2, 0, -2 ], 4 ], [ [ -2 ], 6 ], 
      [ [ 1, 0, -1 ], 0 ], [ [ -1 ], 4 ], [ [ 1, 0, -2 ], 4 ], [ [ -1 ], 2 ], 
      [ [ 2 ], 0 ], [ [ 1 ], 0 ], [ [  ], 0 ], [ [ 1 ], 2 ], 
      [ [ -1, 0, 0, 0, 0, 0, 5 ], 0 ], [ [ -1, 0, 1 ], 0 ], [ [ -2 ], 0 ], 
      [ [ 2 ], 4 ], [ [ -1, 0, 0, 0, 2 ], 0 ], [ [ -1, 0, -1 ], 0 ], 
      [ [ -1, 0, 1 ], 0 ], [ [  ], 0 ], [ [ -1 ], 0 ], [ [ 1 ], 2 ] ], 
  [ [ [ -20 ], 36 ], [ [ -4 ], 0 ], 
      [ [ -1, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, -1 ], 0 ], [ [ 7 ], 12 ], 
      [ [ -4, 0, 6, 0, -4 ], 14 ], [ [ 2, 0, -6, 0, 2 ], 12 ], 
      [ [ -4 ], 18 ], [ [ -1, 0, 2, 0, -1 ], 0 ], [ [  ], 0 ], 
      [ [ -2, 0, 3, 0, -2 ], 14 ], [ [ 2 ], 2 ], [ [ 2 ], 2 ], 
      [ [ -1, 0, 0, 0, -1 ], 0 ], [ [ 1 ], 4 ], [ [ -1 ], 6 ], 
      [ [ -10, 0, 0, 0, 0, 0, 10 ], 12 ], [ [ 2, 0, -2 ], 0 ], 
      [ [ 2, 0, -2 ], 0 ], [ [ -2, 0, 0, 0, 0, 0, 2 ], 4 ], 
      [ [ 1, 0, -1 ], 6 ], [ [ -1, 0, 1 ], 4 ], [ [ -1, 0, 1 ], 2 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ -1, 0, 1 ], 2 ] ], 
  [ [ [ -15 ], 48 ], [ [ 1 ], 0 ], [ [ -3, 0, 0, 0, 3, 0, 0, 0, 1 ], 4 ], 
      [ [ -6 ], 16 ], [ [ -6, 0, 4, 0, -1 ], 20 ], 
      [ [ -1, 0, 4, 0, -3 ], 16 ], [ [ -3 ], 24 ], [ [ 1 ], 4 ], [ [  ], 0 ], 
      [ [ -3, 0, 2, 0, -1 ], 20 ], [ [ -1, 0, 0, 0, 2 ], 0 ], 
      [ [ -1, 0, -1 ], 2 ], [ [ 1 ], 4 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -10, 0, 0, 0, 0, 0, 5 ], 18 ], [ [ 1, 0, 2 ], 0 ], [ [ -1 ], 0 ], 
      [ [ -1, 0, -1, 0, 0, 0, 0, 0, 1 ], 6 ], [ [ -1, 0, 0, 0, 2 ], 6 ], 
      [ [ -1, 0, -1 ], 6 ], [ [  ], 0 ], [ [ 1 ], 6 ], [ [  ], 0 ], 
      [ [ -1, 0, -1, 0, 1 ], 2 ] ], 
  [ [ [ -15 ], 24 ], [ [ 1 ], 0 ], [ [ 1, 0, 0, 0, 3, 0, 0, 0, -3 ], 0 ], 
      [ [ -6 ], 8 ], [ [ -1, 0, 4, 0, -6 ], 8 ], [ [ -3, 0, 4, 0, -1 ], 8 ], 
      [ [ -3 ], 12 ], [ [ 1 ], 0 ], [ [  ], 0 ], [ [ -1, 0, 2, 0, -3 ], 8 ], 
      [ [ 2, 0, 0, 0, -1 ], 0 ], [ [ -1, 0, -1 ], 0 ], [ [ 1 ], 0 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ -5, 0, 0, 0, 0, 0, 10 ], 6 ], 
      [ [ -2, 0, -1 ], 0 ], [ [ 1 ], 2 ], 
      [ [ -1, 0, 0, 0, 0, 0, 1, 0, 1 ], 0 ], [ [ -2, 0, 0, 0, 1 ], 4 ], 
      [ [ 1, 0, 1 ], 2 ], [ [  ], 0 ], [ [ -1 ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 1, 0, 1 ], 0 ] ], 
  [ [ [ -15 ], 48 ], [ [ -7 ], 0 ], [ [ -4, 0, 3, 0, 0, 0, -2 ], 6 ], 
      [ [ 3 ], 16 ], [ [ 4, 0, -4 ], 20 ], [ [ -4, 0, 1 ], 18 ], 
      [ [ 1 ], 24 ], [ [ -1, 0, 3, 0, -3 ], 0 ], [ [  ], 0 ], 
      [ [ 1, 0, -2 ], 20 ], [ [ 3, 0, -1 ], 2 ], [ [ 2, 0, -3 ], 2 ], 
      [ [ 2, 0, -2 ], 2 ], [ [  ], 0 ], [ [ 1 ], 8 ], 
      [ [ 5, 0, -9, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1 ], 18 ], 
      [ [ 3, 0, -4 ], 0 ], [ [ 2, 0, -5 ], 0 ], [ [ 1, 0, -2, 0, 2 ], 6 ], 
      [ [ -2, 0, 1, 0, 0, 0, -1 ], 8 ], [ [ 2, 0, 0, 0, -1 ], 6 ], 
      [ [ -1, 0, 2, 0, -2 ], 2 ], [ [ 1 ], 4 ], [ [ 1, 0, -1 ], 4 ], 
      [ [ -1, 0, 2, 0, -1 ], 2 ] ], 
  [ [ [ -15 ], 24 ], [ [ -7 ], 0 ], [ [ -2, 0, 0, 0, 3, 0, -4 ], 0 ], 
      [ [ 3 ], 8 ], [ [ -4, 0, 4 ], 10 ], [ [ 1, 0, -4 ], 8 ], [ [ 1 ], 12 ], 
      [ [ -3, 0, 3, 0, -1 ], 0 ], [ [  ], 0 ], [ [ -2, 0, 1 ], 10 ], 
      [ [ -1, 0, 3 ], 0 ], [ [ -3, 0, 2 ], 0 ], [ [ -2, 0, 2 ], 0 ], 
      [ [  ], 0 ], [ [ 1 ], 4 ], 
      [ [ 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, -5 ], 0 ], [ [ 4, 0, -3 ], 0 ], 
      [ [ 5, 0, -2 ], 0 ], [ [ -2, 0, 2, 0, -1 ], 4 ], 
      [ [ 1, 0, 0, 0, -1, 0, 2 ], 0 ], [ [ 1, 0, 0, 0, -2 ], 0 ], 
      [ [ 2, 0, -2, 0, 1 ], 0 ], [ [ -1 ], 2 ], [ [ 1, 0, -1 ], 0 ], 
      [ [ 1, 0, -2, 0, 1 ], 0 ] ], 
  [ [ [ 20 ], 54 ], [ [ 4 ], 0 ], [ [ 2, 0, 0, 0, 0, 0, 2 ], 6 ], 
      [ [ 2 ], 18 ], [ [ 4, 0, 0, 0, 1 ], 22 ], [ [ -2, 0, 1 ], 20 ], 
      [ [  ], 0 ], [ [ -2, 0, 2 ], 2 ], [ [  ], 0 ], [ [ -2 ], 24 ], 
      [ [ -1, 0, 2 ], 2 ], [ [ -1, 0, 2 ], 2 ], [ [ -1, 0, 2 ], 2 ], 
      [ [ -1 ], 6 ], [ [  ], 0 ], [ [ 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 20 ],
      [ [ -1, 0, 3 ], 0 ], [ [ -1, 0, 3 ], 0 ], 
      [ [ 1, 0, 0, 0, 0, 0, 1 ], 8 ], [ [ 1 ], 14 ], [ [ 1 ], 10 ], 
      [ [ -2, 0, 1 ], 4 ], [ [ -1, 0, 1 ], 4 ], [ [ -1, 0, 1 ], 4 ], 
      [ [ -2, 0, 1 ], 4 ] ], 
  [ [ [ 20 ], 18 ], [ [ 4 ], 0 ], [ [ 2, 0, 0, 0, 0, 0, 2 ], 0 ], 
      [ [ 2 ], 6 ], [ [ 1, 0, 0, 0, 4 ], 6 ], [ [ 1, 0, -2 ], 6 ], 
      [ [  ], 0 ], [ [ 2, 0, -2 ], 0 ], [ [  ], 0 ], [ [ -2 ], 8 ], 
      [ [ 2, 0, -1 ], 0 ], [ [ 2, 0, -1 ], 0 ], [ [ 2, 0, -1 ], 0 ], 
      [ [ -1 ], 2 ], [ [  ], 0 ], [ [ -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -9 ], 0 ]
        , [ [ -3, 0, 1 ], 0 ], [ [ -3, 0, 1 ], 0 ], 
      [ [ -1, 0, 0, 0, 0, 0, -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], 
      [ [ -1, 0, 2 ], 0 ], [ [ -1, 0, 1 ], 0 ], [ [ -1, 0, 1 ], 0 ], 
      [ [ -1, 0, 2 ], 0 ] ], 
  [ [ [ 24 ], 42 ], [ [ 8 ], 0 ], [ [ -6, 0, 4, 0, 0, 0, 0, 0, 2 ], 4 ], 
      [ [ 6 ], 14 ], [ [ 1, 0, 0, 0, 2, 0, -4, 0, 1 ], 14 ], 
      [ [ 2, 0, -2, 0, 3 ], 14 ], [ [  ], 0 ], [ [ 1, 0, -4, 0, 3 ], 0 ], 
      [ [ -1 ], 10 ], [ [ 1, 0, 0, 0, 1 ], 18 ], [ [ -2, 0, 4 ], 2 ], 
      [ [ 1, 0, -3, 0, 1 ], 0 ], [ [ -2, 0, 2 ], 2 ], [ [  ], 0 ], 
      [ [  ], 0 ], [ [ 5, 0, 0, 0, 0, 0, -10, 0, 9 ], 12 ], 
      [ [ -2, 0, 6 ], 0 ], [ [ -4, 0, 4 ], 0 ], 
      [ [ -1, 0, 0, 0, 0, 0, 0, 0, 1 ], 6 ], [ [ 1, 0, -3 ], 4 ], 
      [ [ 2, 0, -1 ], 4 ], [ [ 2, 0, -2, 0, 1 ], 2 ], [ [ -1, 0, 1 ], 4 ], 
      [ [ -1 ], 4 ], [ [ 1, 0, -3, 0, 2 ], 2 ] ], 
  [ [ [ 24 ], 30 ], [ [ 8 ], 0 ], [ [ 2, 0, 0, 0, 0, 0, 4, 0, -6 ], 0 ], 
      [ [ 6 ], 10 ], [ [ 1, 0, -4, 0, 2, 0, 0, 0, 1 ], 10 ], 
      [ [ 3, 0, -2, 0, 2 ], 10 ], [ [  ], 0 ], [ [ 3, 0, -4, 0, 1 ], 0 ], 
      [ [ -1 ], 6 ], [ [ 1, 0, 0, 0, 1 ], 10 ], [ [ 4, 0, -2 ], 0 ], 
      [ [ 1, 0, -3, 0, 1 ], 0 ], [ [ 2, 0, -2 ], 0 ], [ [  ], 0 ], 
      [ [  ], 0 ], [ [ -9, 0, 10, 0, 0, 0, 0, 0, -5 ], 10 ], 
      [ [ -6, 0, 2 ], 0 ], [ [ -4, 0, 4 ], 0 ], 
      [ [ -1, 0, 0, 0, 0, 0, 0, 0, 1 ], 0 ], [ [ 3, 0, -1 ], 8 ], 
      [ [ 1, 0, -2 ], 4 ], [ [ -1, 0, 2, 0, -2 ], 0 ], [ [ -1, 0, 1 ], 0 ], 
      [ [ 1 ], 2 ], [ [ -2, 0, 3, 0, -1 ], 0 ] ], 
  [ [ [ -30 ], 48 ], [ [ 10 ], 0 ], [ [ -3, 0, 4, 0, -6, 0, 0, 0, 3 ], 4 ], 
      [ [ -3 ], 16 ], [ [ -2, 0, 0, 0, -1 ], 20 ], 
      [ [ -1, 0, 0, 0, -2 ], 16 ], [ [ 2 ], 24 ], [ [ 1, 0, -5, 0, 4 ], 0 ], 
      [ [  ], 0 ], [ [ 2, 0, 0, 0, -1 ], 20 ], [ [ 1, 0, -3, 0, 3 ], 0 ], 
      [ [ -3, 0, 4 ], 2 ], [ [ -2, 0, 3 ], 2 ], [ [  ], 0 ], [ [ -1 ], 8 ], 
      [ [ -15, 0, 9, 0, 0, 0, -5, 0, 0, 0, 0, 0, 1 ], 18 ], 
      [ [ -4, 0, 6 ], 0 ], [ [ -3, 0, 7 ], 0 ], 
      [ [ 1, 0, -2, 0, 0, 0, 1 ], 8 ], [ [ -1, 0, 2, 0, -3, 0, 0, 0, 1 ], 6 ],
      [ [ -3, 0, 1, 0, 1 ], 6 ], [ [ 1, 0, -4, 0, 2 ], 2 ], 
      [ [ -1, 0, 1 ], 4 ], [ [ -1, 0, 1 ], 4 ], [ [ 2, 0, -3, 0, 2 ], 2 ] ], 
  [ [ [ -30 ], 24 ], [ [ 10 ], 0 ], [ [ 3, 0, 0, 0, -6, 0, 4, 0, -3 ], 0 ], 
      [ [ -3 ], 8 ], [ [ -1, 0, 0, 0, -2 ], 8 ], [ [ -2, 0, 0, 0, -1 ], 8 ], 
      [ [ 2 ], 12 ], [ [ 4, 0, -5, 0, 1 ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, 2 ], 8 ], [ [ 3, 0, -3, 0, 1 ], 0 ], 
      [ [ 4, 0, -3 ], 0 ], [ [ 3, 0, -2 ], 0 ], [ [  ], 0 ], [ [ -1 ], 4 ], 
      [ [ -1, 0, 0, 0, 0, 0, 5, 0, 0, 0, -9, 0, 15 ], 0 ], 
      [ [ -6, 0, 4 ], 0 ], [ [ -7, 0, 3 ], 0 ], 
      [ [ -1, 0, 0, 0, 2, 0, -1 ], 0 ], [ [ -1, 0, 0, 0, 3, 0, -2, 0, 1 ], 0 ]
        , [ [ -1, 0, -1, 0, 3 ], 0 ], [ [ -2, 0, 4, 0, -1 ], 0 ], 
      [ [ -1, 0, 1 ], 0 ], [ [ -1, 0, 1 ], 0 ], [ [ -2, 0, 3, 0, -2 ], 0 ] ], 
  [ [ [ -60 ], 36 ], [ [ -12 ], 0 ], 
      [ [ -1, 0, 0, 0, 3, 0, -8, 0, 3, 0, 0, 0, -1 ], 0 ], [ [ 3 ], 12 ], 
      [ [ 1, 0, 0, 0, 4, 0, 0, 0, 1 ], 12 ], [ [ 1, 0, -2, 0, 1 ], 12 ], 
      [ [ -4 ], 18 ], [ [ -3, 0, 6, 0, -3 ], 0 ], [ [  ], 0 ], [ [ 3 ], 16 ], 
      [ [ -2, 0, 4, 0, -2 ], 0 ], [ [ -2, 0, 4, 0, -2 ], 0 ], 
      [ [ -1, 0, 4, 0, -1 ], 0 ], [ [  ], 0 ], [ [ -1 ], 6 ], 
      [ [ 9, 0, -5, 0, 0, 0, 0, 0, 5, 0, -9 ], 10 ], [ [ 6, 0, -6 ], 0 ], 
      [ [ 6, 0, -6 ], 0 ], [ [ 2, 0, -2 ], 6 ], 
      [ [ -1, 0, 2, 0, -2, 0, 1 ], 4 ], [ [ -2, 0, 2 ], 4 ], 
      [ [ 1, 0, -3, 0, 3, 0, -1 ], 0 ], [ [ -1, 0, 1 ], 2 ], 
      [ [ -1, 0, 1 ], 2 ], [ [ 1, 0, -3, 0, 3, 0, -1 ], 0 ] ], 
  [ [ [ -80 ], 36 ], [ [ 16 ], 0 ], 
      [ [ 2, 0, 0, 0, -6, 0, 8, 0, -6, 0, 0, 0, 2 ], 0 ], [ [ 10 ], 12 ], 
      [ [ 1, 0, -4, 0, 10, 0, -4, 0, 1 ], 12 ], [ [ 3, 0, -8, 0, 3 ], 12 ], 
      [ [  ], 0 ], [ [ 4, 0, -8, 0, 4 ], 0 ], [ [  ], 0 ], 
      [ [ -2, 0, 2, 0, -2 ], 14 ], [ [ 2, 0, -6, 0, 2 ], 0 ], 
      [ [ 2, 0, -6, 0, 2 ], 0 ], [ [ 2, 0, -4, 0, 2 ], 0 ], [ [ 1 ], 4 ], 
      [ [  ], 0 ], [ [ -9, 0, 15, 0, 0, 0, 0, 0, -15, 0, 9 ], 10 ], 
      [ [ -8, 0, 8 ], 0 ], [ [ -8, 0, 8 ], 0 ], 
      [ [ 2, 0, -2, 0, 2, 0, -2 ], 4 ], [ [ 1, 0, -3, 0, 3, 0, -1 ], 4 ], 
      [ [ 3, 0, -3 ], 4 ], [ [ -1, 0, 4, 0, -4, 0, 1 ], 0 ], 
      [ [ 1, 0, -1 ], 2 ], [ [ 1, 0, -1 ], 2 ], 
      [ [ -1, 0, 4, 0, -4, 0, 1 ], 0 ] ], 
  [ [ [ -90 ], 36 ], [ [ 6 ], 0 ], [ [ 1, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 1 ]
            , 0 ], [ [ -9 ], 12 ], [ [ -1, 0, 4, 0, -6, 0, 4, 0, -1 ], 12 ], 
      [ [ -3, 0, 6, 0, -3 ], 12 ], [ [ -2 ], 18 ], [ [ 1, 0, -4, 0, 1 ], 0 ], 
      [ [  ], 0 ], [ [ 2, 0, -1, 0, 2 ], 14 ], [ [ 1, 0, -2, 0, 1 ], 0 ], 
      [ [ 1, 0, -2, 0, 1 ], 0 ], [ [ 1, 0, -2, 0, 1 ], 0 ], [ [  ], 0 ], 
      [ [ 1 ], 6 ], [ [ -9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9 ], 10 ], 
      [ [ -3, 0, 3 ], 0 ], [ [ -3, 0, 3 ], 0 ], [ [ -1, 0, 1 ], 6 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ 2, 0, -2 ], 2 ], [ [ 1, 0, -1 ], 2 ], 
      [ [ 1, 0, -1 ], 2 ], [ [ 2, 0, -2 ], 2 ] ], 
  [ [ [ -60 ], 42 ], [ [ 4 ], 0 ], [ [ 2, 0, -6 ], 6 ], [ [ -6 ], 14 ], 
      [ [ 4, 0, -4, 0, 4, 0, -1 ], 16 ], [ [ -1, 0, 6, 0, -2 ], 14 ], 
      [ [  ], 0 ], [ [ 1, 0, -2, 0, 1 ], 0 ], [ [  ], 0 ], 
      [ [ -4, 0, 2 ], 18 ], [ [ 2, 0, -1 ], 0 ], [ [ -1, 0, 2 ], 2 ], 
      [ [ -1 ], 2 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -5, 0, 0, 0, 0, 0, -5 ], 18 ], [ [ -3, 0, 1 ], 0 ], 
      [ [ -1, 0, 3 ], 0 ], [ [ 1, 0, 1 ], 6 ], [ [ 2, 0, -3 ], 8 ], 
      [ [ -2, 0, 1 ], 6 ], [ [ 1, 0, -1, 0, 1 ], 2 ], [ [  ], 0 ], 
      [ [  ], 0 ], [ [ -1, 0, 1, 0, -1 ], 0 ] ], 
  [ [ [ -60 ], 30 ], [ [ 4 ], 0 ], [ [ -6, 0, 2 ], 4 ], [ [ -6 ], 10 ], 
      [ [ -1, 0, 4, 0, -4, 0, 4 ], 10 ], [ [ -2, 0, 6, 0, -1 ], 10 ], 
      [ [  ], 0 ], [ [ 1, 0, -2, 0, 1 ], 0 ], [ [  ], 0 ], 
      [ [ 2, 0, -4 ], 12 ], [ [ -1, 0, 2 ], 2 ], [ [ 2, 0, -1 ], 0 ], 
      [ [ -1 ], 2 ], [ [  ], 0 ], [ [  ], 0 ], [ [ 5, 0, 0, 0, 0, 0, 5 ], 6 ],
      [ [ -1, 0, 3 ], 0 ], [ [ -3, 0, 1 ], 0 ], [ [ -1, 0, -1 ], 6 ], 
      [ [ 3, 0, -2 ], 4 ], [ [ -1, 0, 2 ], 2 ], [ [ -1, 0, 1, 0, -1 ], 0 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ 1, 0, -1, 0, 1 ], 2 ] ], 
  [ [ [ 64 ], 45 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -8 ], 15 ], 
      [ [ 4, 0, -2, 0, 4, 0, -2 ], 17 ], [ [ -2, 0, 4, 0, -4 ], 15 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ -1 ], 9 ], [ [ -1, 0, 2, 0, -1 ], 19 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [ 1 ], 5 ], [ [  ], 0 ], 
      [ [ 16 ], 15 ], [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, -1 ], 5 ], [ [ -2 ], 5 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ 1 ], 3 ], [ [  ], 0 ] ], 
  [ [ [ -64 ], 27 ], [ [  ], 0 ], [ [  ], 0 ], [ [ 8 ], 9 ], 
      [ [ 2, 0, -4, 0, 2, 0, -4 ], 9 ], [ [ 4, 0, -4, 0, 2 ], 9 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [ 1 ], 7 ], [ [ 1, 0, -2, 0, 1 ], 9 ], 
      [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -1 ], 3 ], [ [  ], 0 ], 
      [ [ 16 ], 15 ], [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -1, 0, 0, 0, -1 ], 5 ], [ [ -2 ], 5 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ 1 ], 3 ], [ [  ], 0 ] ], 
  [ [ [ 81 ], 40 ], [ [ 9 ], 0 ], [ [ 1, 0, 0, 0, 0, 0, 4, 0, -9, 0, 0, 0, 1 ]
            , 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -3 ], 20 ], 
      [ [ 2, 0, -5, 0, 2 ], 0 ], [ [ 1 ], 8 ], [ [  ], 0 ], 
      [ [ 3, 0, -3 ], 0 ], [ [ -3, 0, 3 ], 2 ], [ [ 1, 0, -2, 0, 1 ], 0 ], 
      [ [  ], 0 ], [ [  ], 0 ], 
      [ [ 10, 0, 0, 0, 0, 0, -5, 0, 9, 0, 0, 0, -5 ], 12 ], 
      [ [ -6, 0, 3 ], 0 ], [ [ -3, 0, 6 ], 0 ], [ [ 1, 0, -2 ], 8 ], 
      [ [ 3, 0, -3 ], 8 ], [ [ 1, 0, -2, 0, 1 ], 4 ], 
      [ [ 2, 0, -3, 0, 1 ], 2 ], [ [ 1 ], 2 ], [ [ -1 ], 4 ], 
      [ [ -1, 0, 3, 0, -2 ], 0 ] ], 
  [ [ [ 81 ], 32 ], [ [ 9 ], 0 ], [ [ 1, 0, 0, 0, -9, 0, 4, 0, 0, 0, 0, 0, 1 ]
            , 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -3 ], 16 ], 
      [ [ 2, 0, -5, 0, 2 ], 0 ], [ [ 1 ], 8 ], [ [  ], 0 ], 
      [ [ -3, 0, 3 ], 2 ], [ [ 3, 0, -3 ], 0 ], [ [ 1, 0, -2, 0, 1 ], 0 ], 
      [ [  ], 0 ], [ [  ], 0 ], 
      [ [ 5, 0, 0, 0, -9, 0, 5, 0, 0, 0, 0, 0, -10 ], 6 ], 
      [ [ -3, 0, 6 ], 0 ], [ [ -6, 0, 3 ], 0 ], [ [ 2, 0, -1 ], 4 ], 
      [ [ 3, 0, -3 ], 4 ], [ [ -1, 0, 2, 0, -1 ], 2 ], 
      [ [ -1, 0, 3, 0, -2 ], 0 ], [ [ -1 ], 4 ], [ [ 1 ], 2 ], 
      [ [ 2, 0, -3, 0, 1 ], 2 ] ] ];

#############################################################################
##
#F  CHEVIE.2E6.ClassParam( <w> ) . . . . . . . . . . . class parameter of w
##  
##  given an element w  of a Coxeter group W of type E_6  as word in  standard
##  generators, 'CHEVIE.2E6.ClassParam' returns the classparam of its 
##  conjugacy class.
##
CHEVIE.2E6.ClassParam:=function(w)
  local x;
  if w=[] then return " ";fi;
  x:=Product(CHEVIE.2E6.generators{w})*CHEVIE.2E6.phi;
  return CHEVIE.2E6.classparams[Position(CHEVIE.2E6.cyclestructure,
                             CycleStructurePerm(x))];
end;

#############################################################################
##
#F CHEVIE.2E6.CharTable( <l> ) outer character table of CoxeterGroup("E",6).2
##  
##  This function returns the part of the character table of 
##  CoxeterGroup("E",6).2 on the outer classes of CoxeterGroup("E",6). For 
##  each character of CoxeterGroup("E",6) there are two extensions  to the 
##  whole group. 'CHEVIE.2E6.CharTable' gives the  values  of the  
##  *preferred* extensions defined  in [CS,17.2 (b)].
##  
CHEVIE.2E6.CharTable:=function()
  local tbl, aphisign, i;
  
  tbl:=CoxeterCharTableIrred("E",[1..6]);
  
  tbl.identifier:="W(^2E6)";
  
  Unbind(tbl.powermap);
  Unbind(tbl.orders);
  
  # Some characters of W(E_6)*w_0 will be changed by sign according to
  # the preferred extension, see [Lusztig-book, 4.1 and 4.11] and
  # [CS, 17.2(b)]
  aphisign:=[1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,
             1,1,1,-1,-1,-1,-1,-1,-1,-1,1,-1,1,1];
  
  for i in [1..Length(tbl.irreducibles)] do
    if aphisign[i]=-1 then
      tbl.irreducibles[i]:=-tbl.irreducibles[i];
    fi;
  od;
  
  tbl.classtext:= CHEVIE.2E6.classtext;
  tbl.classnames:=CHEVIE.2E6.classnames;
  tbl.classparam:=CHEVIE.2E6.classnames;
  
  return tbl;
end;

# The table below was obtained by the following program:
#getHeckeCharTable2E6:=function(sqq)local W,WF,qE,H,tbl,tmp,i,cl,aE;
#  W:=CoxeterGroup("E",6);WF:=CoxeterCoset(W,(1,6)(3,5));
#  aE:=[1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,1,-1,1,1];
#  qE:=HeckeCentralMonomials(Hecke(W,sqq));
## q_E is the square root which deforms to 1 of the eigenvalue of T_{w_0}
## on E which deforms to 1; we have:
##  E~(T_w\phi)=\overline(E(T_{w^-1w_0}))q_E (trivial extension)
##  E~(T_w\phi)=a_E\overline(E(T_{w^-1w_0}))q_E (preferred extension)
## where \overline means q->q^-1
#  H:=Hecke(W,sqq^-2);
#  tbl:=ShallowCopy(CharTable(H));
#  tbl.classtext:=CHEVIE.2E6.classtext;
#  tbl.classnames:=CHEVIE.2E6.classnames;
#  tbl.classparam:=CHEVIE.2E6.classparams;
#  tbl.identifier:="H(^2E6)";
#  cl:=List(tbl.classtext,x->PermCoxeterWord (W,x)*LongestCoxeterElement(W));
#  tbl.irreducibles:=TransposedMat(List(cl,x->HeckeCharValues(Basis(H,"T")(x))));
#  for i in [1..Length(tbl.irreducibles)] do
#    tbl.irreducibles[i]:=qE[i]*aE[i]*tbl.irreducibles[i];
#  od;
#  return tbl;
#end;

CHEVIE.2E6.HeckeCharTable:=function(q)return rec(
  identifier:="H(^2E6)",
  text:="origin: Jean Michel, June 1996",
  parameter:=[ q^2, q^2, q^2, q^2, q^2, q^2],
  sqrtParameter:=[ q, q, q, q, q, q],
  size:=51840,
  cartan:=CHEVIE.2E6.cartan,
  classtext:= CHEVIE.2E6.classtext,
  classnames:=CHEVIE.2E6.classnames,
  classparam:=CHEVIE.2E6.classnames,
  classes:=CHEVIE.2E6.classes,
  centralizers:=CHEVIE.2E6.centralizers,
  irreducibles:=List(CHEVIE.2E6.vpolheckeirreducibles,
                     i->List(i,j->FastValue(j,q))),
  irredinfo:=List(CHEVIE.2E6.CharParams(),x->
                       rec(charparam:=x,charname:=CHEVIE.2E6.CharName(x))),
  operations:=CharTableOps);
end;

CHEVIE.2E6.phifactors:=[1,-1,1,1,-1,1];
