#############################################################################
##
#A  weyl3d4.g            CHEVIE library                           Jean Michel
##
#A  $Id: weyl3d4.g,v 1.1 1997/01/21 13:46:46 gap Exp $
##
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains information about the coset W.F where W is
##  the group D4:   2      and F is (1,2,4).
##                1-3-4
##  
##  The HeckeCharTable is obtained as follows:
##  If G is the Hecke algebra F4 1-2>3-4 with 
##   parameters                  q q 1 1
##  then the orbit of the reflection 2 of G under F=43 is the reflections
##  [2,9,16] and the subgroup [1,2,9,16] with F is isomorphic to W with F
##  (the isomorphism maps [1->3,2->1,9->2,16->4]).
##  
##  The class names come from F.Lubeck's tables.
##  

CHEVIE.3D4:=rec();

CHEVIE.3D4.PositionId:=function() return 1; end;

CHEVIE.3D4.PositionSgn:=function() return 2; end;

CHEVIE.3D4.PositionRefl:=function() return 5; end;


# elements of minimal length
CHEVIE.3D4.classtext:=[ [ 1 ], [  ], [ 1, 2, 3, 1, 2, 3 ], [ 3 ], [ 1, 3 ], 
  [ 1, 2, 3, 1, 2, 4, 3, 2 ], [ 1, 2, 3, 2 ] ];

CHEVIE.3D4.classnames:=["C_3","~A_2","C_3+A_1","~A_2+A_1",
  "F_4","~A_2+A_2","F_4(a_1)"];

CHEVIE.3D4.cyclestructure:=[ [ 2,,,, 3 ], [ , 6 ], [ 3,,,, 3 ], [ 3, 2,,, 2 ],
  [ ,,,,,,,,,, 2 ],[ , 8 ], [ ,,,, 4 ] ];

CHEVIE.3D4.generators:=
  [ ( 1,13)( 3, 5)( 6, 8)( 7, 9)(10,11)(15,17)(18,20)(19,21)(22,23), 
    ( 2,14)( 3, 6)( 5, 8)( 7,10)( 9,11)(15,18)(17,20)(19,22)(21,23), 
    ( 1, 5)( 2, 6)( 3,15)( 4, 7)(11,12)(13,17)(14,18)(16,19)(23,24), 
    ( 3, 7)( 4,16)( 5, 9)( 6,10)( 8,11)(15,19)(17,21)(18,22)(20,23) ];

CHEVIE.3D4.phi:=( 1, 2, 4)( 5, 6, 7)( 8,10, 9)(13,14,16)(17,18,19)(20,22,21);

CHEVIE.3D4.CharParams:=function()
  return [[[],[4]],[[],[1,1,1,1]],[[],[2,2]],
  [[1,1],[2]],[[1],[3]],[[1],[1,1,1]],[[1],[2,1]]];
end;

CHEVIE.3D4.CharName:=DoublePartitionToString;

CHEVIE.3D4.cartan:=[[2,0,-1,0],[ 0, 2, -1, 0 ],[ -1, -1, 2, -1 ],[0,0,-1, 2 ]];

CHEVIE.3D4.vpolheckeirreducibles:=
[ [ [ [ 1 ], 2 ], [ [ 1 ], 2 ], [ [ 1 ], 4 ], [ [ 1 ], 2 ], [ [ 1 ], 2 ], 
      [ [ 1 ], 8 ], [ [ 1 ], 4 ] ], 
  [ [ [ -1 ], 2 ], [ [ 1 ], 2 ], [ [ 1 ], 4 ], [ [ -1 ], 2 ], [ [ 1 ], 2 ], 
      [ [ 1 ], 8 ], [ [ 1 ], 4 ] ], 
  [ [ [  ], 0 ], [ [ 2 ], 2 ], [ [ 2 ], 4 ], [ [  ], 0 ], [ [ -1 ], 2 ], 
      [ [ -1 ], 8 ], [ [ -1 ], 4 ] ], 
  [ [ [  ], 0 ], [ [ 1, -2, 1 ], 0 ], [ [  ], 0 ], [ [ -1, 0, 1 ], 0 ], 
      [ [ -1 ], 1 ], [ [ 3 ], 4 ], [ [ 3 ], 2 ] ], 
  [ [ [ 1 ], 2 ], [ [ -1, 2 ], 1 ], [ [ -1 ], 3 ], [ [ -1 ], 1 ], 
      [ [  ], 0 ], [ [ -2 ], 6 ], [ [ 2 ], 3 ] ], 
  [ [ [ -1 ], 2 ], [ [ -1, 2 ], 1 ], [ [ -1 ], 3 ], [ [ 1 ], 1 ], 
      [ [  ], 0 ], [ [ -2 ], 6 ], [ [ 2 ], 3 ] ], 
  [ [ [  ], 0 ], [ [ -2, 4 ], 1 ], [ [ -2 ], 3 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ 2 ], 6 ], [ [ -2 ], 3 ] ] ];

#############################################################################
##
#F  CHEVIE.3D4.ClassParam( <w> )  . . . . . . . . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type D_4 as word in standard
##  generators, 'CHEVIE.3D4.ClassParam' returns the classparam of its 
##  F-conjugacy class under the nontrivial F action permuting the generators 
##  1->2->4->1.
##
CHEVIE.3D4.ClassParam:=function(w)local x;
  if w=[] then x:=();
  else x:=Product(CHEVIE.3D4.generators{w});
  fi;
  return CHEVIE.3D4.classparams[Position(CHEVIE.3D4.cyclestructure,
                                CycleStructurePerm(x*CHEVIE.3D4.phi))];
end;

###########################################################################
##
#F  CHEVIE.3D4.HeckeCharTable( <q> )  . . . . . . . . . . . . . . . . . . . .
##  . . . . . . . . . . .  character table of the Hecke algebra of type 3D4
##
##  'CHEVIE.3D4.HeckeCharTable' returns the character table of the Hecke algebra
##  of type  3D4  with  parameter  q.
##
CHEVIE.3D4.HeckeCharTable:=function(q)return rec(
  identifier:="H(3D4)", 
  parameter:=[q,q,q,q],
  sqrtparameter:=[],
  cartan:=CHEVIE.3D4.cartan,
  size:=192, 
  classtext:=CHEVIE.3D4.classtext,
  classnames:=CHEVIE.3D4.classnames,
  classparam:=CHEVIE.3D4.classnames,
  orders:=[ 6, 3, 6, 6, 12, 3, 6 ], 
  centralizers:=[4, 12, 12, 4, 4, 24, 24],
  classes:=[ 48, 16, 16, 48, 48, 8, 8 ],
  irreducibles:=List(CHEVIE.3D4.vpolheckeirreducibles,
                     i->List(i,j->FastValue(j,q))),
  irredinfo:=List(CHEVIE.3D4.CharParams(),x->rec(charparam:=x,
                             charname:=CHEVIE.3D4.CharName(x))),
  operations:=CharTableOps);
end;

CHEVIE.3D4.phifactors:=[1,E(3),E(3)^2,1];
