#############################################################################
##
#A  weyle7.g                   CHEVIE library                    Meinolf Geck
##
#A  $Id: weyle7.g,v 1.1 1997/01/21 13:46:51 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains the character table of the Hecke algebras of type E7.
##

CHEVIE.E7:=rec();

CHEVIE.E7.classtext:=
[ [ ], [ 7, 6, 7, 5, 6, 7, 4, 5, 6, 7, 2, 4, 5, 6, 7, 3, 4, 5, 6, 7, 
  2, 4, 5, 6, 3, 4, 5, 2, 4, 3 ], [ 5, 4, 5, 2, 4, 5, 3, 4, 5, 2, 4, 3 ], 
  [ 7, 5 ], [ 7, 5, 2, 3 ], [ 7, 6 ], 
  [ 6, 5, 6, 4, 5, 6, 2, 4, 3, 4, 5, 6, 2, 4, 5, 3, 1, 3, 4, 5, 2, 4, 3, 
      1 ], [ 7, 6, 4, 2 ], [ 5, 4, 5, 2, 4, 3 ], [ 7, 5, 6, 2 ], 
  [ 7, 5, 4, 5, 2, 4, 5, 3, 4, 5, 2, 4, 3, 1 ], 
  [ 7, 6, 7, 5, 6, 4, 5, 2, 4, 5, 3, 4, 5, 2, 4, 3 ], [ 7, 5, 6, 3 ], 
  [ 7, 6, 5, 4 ], [ 7, 6, 5, 4, 5, 2, 4, 5, 3, 4, 5, 2, 4, 3 ], 
  [ 5, 4, 2, 3 ], [ 1, 2, 3, 1, 5, 4, 6, 5, 4, 2, 3, 4 ], [ 7, 6, 4, 1 ], 
  [ 7, 6, 7, 5, 6, 4, 5, 2, 4, 3 ], 
  [ 1, 2, 3, 4, 2, 3, 4, 6, 5, 4, 2, 3, 4, 5 ], [ 7, 5, 2, 6, 4, 1 ], 
  [ 7, 6, 5, 4, 3, 1 ], [ 7, 5, 2, 3, 4, 1 ], [ 3, 4, 2, 3, 4, 7, 6, 5 ],
  [ 6, 5, 4, 5, 2, 4, 3, 1 ], [ 7, 6, 5, 4, 2, 3 ], [ 7, 5, 6, 2, 3, 1 ], 
  [ 7, 5, 4, 5, 2, 4, 3, 1 ], [ 6, 4, 1, 5, 3, 2 ], [ 7, 6, 4, 2, 3, 1 ], 
  [ 7, 6, 7, 5, 6, 7, 4, 5, 6, 7, 2, 4, 5, 6, 7, 3, 4, 5, 6, 7, 2, 4, 5, 
      6, 3, 4, 5, 2, 4, 3, 1, 3, 4, 5, 6, 7, 2, 4, 5, 6, 3, 4, 5, 2, 4, 
      3, 1, 3, 4, 5, 6, 7, 2, 4, 5, 6, 3, 4, 5, 2, 4, 3, 1 ], [ 7 ], 
  [ 7, 5, 2 ], [ 7, 5, 4, 5, 2, 4, 5, 3, 4, 5, 2, 4, 3 ], [ 7, 5, 3 ], 
  [ 7, 6, 7, 5, 6, 7, 4, 5, 6, 7, 2, 4, 5, 6, 7, 3, 4, 5, 6, 7, 2, 4, 5, 
      6, 3, 4, 5, 2, 4, 3, 1 ], 
  [ 7, 6, 7, 5, 6, 7, 4, 5, 6, 2, 4, 3, 4, 5, 2, 4, 3, 1, 3, 4, 2 ], 
  [ 7, 6, 7, 5, 6, 4, 5, 6, 2, 4, 5, 6, 3, 4, 5, 6, 1, 3, 4, 5, 2, 4, 3 ],
  [ 7, 6, 7, 5, 6, 7, 4, 5, 6, 7, 2, 4, 5, 6, 7, 3, 4, 5, 6, 7, 2, 4, 5, 
      6, 3, 1, 3, 4, 5, 2, 4, 3, 1 ], 
  [ 6, 5, 4, 5, 2, 4, 5, 3, 4, 5, 2, 4, 3 ], [ 7, 5, 6 ], 
  [ 7, 5, 4, 5, 2, 4, 3 ], [ 7, 5, 6, 2, 3 ], 
  [ 7, 6, 5, 4, 5, 2, 4, 5, 3, 4, 5, 2, 4, 3, 1 ], [ 7, 6, 4 ], 
  [ 7, 5, 2, 3, 1 ], 
  [ 7, 6, 5, 6, 4, 5, 6, 2, 4, 3, 4, 5, 6, 2, 4, 5, 3, 1, 3, 4, 5, 2, 4, 
      3, 1 ], [ 7, 5, 4, 2, 3 ], [ 7, 6, 4, 2, 1 ], [ 7, 5, 2, 6, 4 ], 
  [ 7, 5, 3, 6, 4 ], [ 7, 6, 5, 4, 5, 2, 4, 3, 1 ], [ 6, 5, 4, 2, 3 ], 
  [ 7, 6, 7, 5, 6, 4, 5, 2, 4, 5, 3, 4, 5, 2, 4, 3, 1 ], 
  [ 7, 6, 5, 4, 2, 3, 1 ], [ 7, 5, 6, 4, 1 ], [ 3, 4, 2, 3, 4, 6, 5 ],
  [ 7, 5, 6, 3, 1 ], [ 7, 6, 7, 5, 6, 4, 5, 2, 4, 3, 1 ], 
  [ 2, 4, 2, 3, 5, 4, 2, 7, 6, 5, 4, 3, 1 ] ];

CHEVIE.E7.classnames:=
[ " ", "6A_1", "4A_1''", "2A_1", "4A_1'", "A_2", "3A_2", "2A_2", "D_4(a_1)", 
  "A_3+A_1'", "A_3+3A_1", "D_4(a_1)+2A_1", "A_3+A_1''", "A_4", 
  "D_4+2A_1", "D_4", "E_6(a_2)", "A_2+2A_1", "D_6(a_2)", "A_5+A_1''", 
  "A_5+A_1'", "A_6", "D_5+A_1", "D_6(a_1)", "E_6(a_1)", "D_6", 
  "A_3+A_2+A_1", "D_5(a_1)+A_1", "E_6", "A_4+A_2", "7A_1", "A_1", 
  "3A_1'", "5A_1", "3A_1''", "D_4+3A_1", "E_7(a_4)", "D_6(a_2)+A_1", 
  "2A_3+A_1", "A_3+2A_1''", "A_3", "D_4(a_1)+A_1", "A_3+2A_1'", 
  "D_6+A_1", "A_2+A_1", "A_2+3A_1", "A_5+A_2", "D_4+A_1", 
  "2A_2+A_1", "A_5'", "A_5''", "E_7(a_1)", "D_5", "A_7", "E_7", 
  "A_4+A_1", "D_5(a_1)", "A_3+A_2", "E_7(a_2)", "E_7(a_3)" ];

#how to make a .charname from a .charparam
CHEVIE.E7.CharName:=x->String(Concatenation("phi_{",String(x[1]),
                                        ",",String(x[2]),"}"));

CHEVIE.E7.CharParams:=function()
  return [ [ 1, 0], [ 1, 63], [ 7, 46], [ 7, 1],  [ 15, 28],
  [ 15, 7],  [ 21, 6], [ 21, 33], [ 21, 36], [ 21, 3],  [ 27, 2],
  [ 27, 37], [ 35, 22], [ 35, 13], [ 35, 4], [ 35, 31], [ 56, 30],
  [ 56, 3],  [ 70, 18], [ 70, 9],  [ 84, 12], [ 84, 15],  [ 105, 26],
  [ 105, 5],  [ 105, 6], [ 105, 21], [ 105, 12], [ 105, 15], [ 120, 4],
  [ 120, 25], [ 168, 6], [ 168, 21], [ 189, 10], [ 189, 17], [ 189, 22],
  [ 189, 5],  [ 189, 20], [ 189, 7],  [ 210, 6], [ 210, 21], [ 210, 10],
  [ 210, 13], [ 216, 16], [ 216, 9],  [ 280, 18], [ 280, 9],  [ 280, 8],
  [ 280, 17], [ 315, 16], [ 315, 7],  [ 336, 14], [ 336, 11], [ 378, 14],
  [ 378, 9],  [ 405, 8], [ 405, 15],  [ 420, 10], [ 420, 13],  [ 512, 12],
  [ 512, 11] ];
end;

CHEVIE.E7.frame:=
[ "1_a", "1_a'", "7_a", "7_a'", "15_a", "15_a'", "21_a", "21_a'", "21_b", 
  "21_b'", "27_a", "27_a'", "35_a", "35_a'", "35_b", "35_b'", "56_a", 
  "56_a'", "70_a", "70_a'", "84_a", "84_a'", "105_a", "105_a'", "105_b", 
  "105_b'", "105_c", "105_c'", "120_a", "120_a'", "168_a", "168_a'", "189_a", 
  "189_a'", "189_b", "189_b'", "189_c", "189_c'", "210_a", "210_a'", "210_b", 
  "210_b'", "216_a", "216_a'", "280_a", "280_a'", "280_b", "280_b'", "315_a", 
  "315_a'", "336_a", "336_a'", "378_a", "378_a'", "405_a", "405_a'", "420_a", 
  "420_a'", "512_a", "512_a'" ];

CHEVIE.E7.cyclestructure:=[[],[62],[[60],[51]],[50],[[60],[59]],[,32],
    [,42],[,40],[,,30],[7,,25],[13,,25],[2,,30],
    [11,,25],[,,,24],[14,,,,16],[12,,,,16],[,2,,,20],
    [14,8,,,12],[2,,,,20],[[3,2,,,19],[,6,,,17]],
    [[3,2,,,19],[2,2,,,19]],[,,,,,18],[3,,,,,,15],
    [,,1,,,,15],[,,,,,,,14],[2,,,,,,,,12],[1,4,7,,2,,,,,,6],
    [1,,7,,4,,,,,,6],[,2,,,,,,,,,10],[,2,,6,,,,,,,,,,6],
    [63],[33],[51],[61],[59],[15,,,,16],[,,,,21],
    [3,,,,20],[3,,30],[[12,,25],[7,,25]],[6,,25],
    [1,,30],[[12,,25],[11,,25]],[3,,,,,,,,12],[9,16,,,8],
    [15,8,,,12],[,8,,,17],[13,,,,16],[3,20,,,10],
    [,6,,,17],[2,2,,,19],[,,,,,,,,,,,,9],[2,,,,,,15],
    [1,,1,,,,15],[,,,,,,,,,,,,,,,,7],[3,,,12,,,,,6],
    [,,7,,4,,,,,,6],[,4,7,,2,,,,,,6],[,,,,1,,,,,,10],
           [,,,,1,,,,3,,,,,,,,,,,,,,,,,,,,3]];

CHEVIE.E7.generators:=[(1,64)(3,8)(10,14)(15,20)(17,21)(22,26)(24,27)(28,32)
    (29,33)(31,34)(35,38)(36,39)(40,43)(41,44)(45,48)(49,52)
    (62,63)(66,71)(73,77)(78,83)(80,84)(85,89)(87,90)(91,95)
    (92,96)(94,97)(98,101)(99,102)(103,106)(104,107)(108,111)(112,115)
    (125,126),(2,65)(4,9)(10,15)(11,16)(14,20)(17,22)(18,23)
    (21,26)(24,29)(25,30)(27,33)(31,36)(34,39)(50,53)(54,56)
    (57,58)(59,60)(67,72)(73,78)(74,79)(77,83)(80,85)(81,86)
    (84,89)(87,92)(88,93)(90,96)(94,99)(97,102)(113,116)(117,119)
    (120,121)(122,123),(1,8)(3,66)(4,10)(9,15)(11,17)(16,22)
    (18,24)(23,29)(25,31)(30,36)(32,37)(38,42)(43,46)(44,47)
    (48,51)(52,55)(61,62)(64,71)(67,73)(72,78)(74,80)(79,85)
    (81,87)(86,92)(88,94)(93,99)(95,100)(101,105)(106,109)(107,110)
    (111,114)(115,118)(124,125),(2,9)(3,10)(4,67)(5,11)(8,14)
    (12,18)(19,25)(22,28)(26,32)(29,35)(33,38)(36,41)(39,44)
    (46,50)(51,54)(55,57)(60,61)(65,72)(66,73)(68,74)(71,77)
    (75,81)(82,88)(85,91)(89,95)(92,98)(96,101)(99,104)(102,107)
    (109,113)(114,117)(118,120)(123,124),(4,11)(5,68)(6,12)(9,16)
    (10,17)(13,19)(14,21)(15,22)(20,26)(35,40)(38,43)(41,45)
    (42,46)(44,48)(47,51)(57,59)(58,60)(67,74)(69,75)(72,79)
    (73,80)(76,82)(77,84)(78,85)(83,89)(98,103)(101,106)(104,108)
    (105,109)(107,111)(110,114)(120,122)(121,123),
    (5,12)(6,69)(7,13)(11,18)(16,23)(17,24)(21,27)(22,29)
    (26,33)(28,35)(32,38)(37,42)(45,49)(48,52)(51,55)(54,57)
    (56,58)(68,75)(70,76)(74,81)(79,86)(80,87)(84,90)(85,92)
    (89,96)(91,98)(95,101)(100,105)(108,112)(111,115)(114,118)(117,120)
    (119,121),(6,13)(7,70)(12,19)(18,25)(23,30)(24,31)(27,34)
    (29,36)(33,39)(35,41)(38,44)(40,45)(42,47)(43,48)(46,51)
    (50,54)(53,56)(69,76)(75,82)(81,88)(86,93)(87,94)(90,97)
    (92,99)(96,102)(98,104)(101,107)(103,108)(105,110)(106,111)(109,114)
    (113,117)(116,119)];

CHEVIE.E7.cartan:=[ [ 2, 0, -1, 0, 0, 0, 0 ], [ 0, 2, 0, -1, 0, 0, 0 ], 
      [ -1, 0, 2, -1, 0, 0, 0 ], [ 0, -1, -1, 2, -1, 0, 0 ], 
      [ 0, 0, 0, -1, 2, -1, 0 ], [ 0, 0, 0, 0, -1, 2, -1 ], 
      [ 0, 0, 0, 0, 0, -1, 2 ] ];

CHEVIE.E7.powermap:=
[ , [ 1, 1, 1, 1, 1, 6, 7, 8, 3, 4, 4, 3, 4, 14, 6, 6, 7, 6, 8, 8, 8, 22, 9, 
      12, 25, 14, 18, 18, 17, 30, 1, 1, 1, 1, 1, 6, 7, 8, 3, 4, 4, 3, 4, 14, 
      6, 6, 7, 6, 8, 8, 8, 22, 9, 12, 25, 14, 18, 18, 17, 30 ], 
  [ 1, 2, 3, 4, 5, 1, 1, 1, 9, 10, 11, 12, 13, 14, 2, 3, 3, 4, 2, 3, 5, 22, 
      23, 24, 7, 26, 10, 11, 9, 14, 31, 32, 33, 34, 35, 31, 31, 31, 39, 40, 
      41, 42, 43, 44, 32, 33, 33, 34, 32, 33, 35, 52, 53, 54, 37, 56, 40, 41, 
      39, 44 ],, 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 1, 15, 16, 17, 18, 19, 20, 21, 
      22, 23, 24, 25, 2, 27, 28, 29, 6, 31, 32, 33, 34, 35, 36, 37, 38, 39, 
      40, 41, 42, 43, 31, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 32, 57, 
      58, 59, 36 ],, 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 1, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 31, 53, 54, 55, 56, 
      57, 58, 59, 60 ] ];

CHEVIE.E7.orders:=
[ 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 5, 6, 6, 6, 6, 6, 6, 6, 7, 8, 8, 9, 
  10, 12, 12, 12, 15, 2, 2, 2, 2, 2, 6, 6, 6, 4, 4, 4, 4, 4, 10, 6, 6, 6, 6, 
  6, 6, 6, 14, 8, 8, 18, 10, 12, 12, 12, 30 ];

CHEVIE.E7.centralizers:=
[ 2903040, 46080, 9216, 3072, 768, 4320, 1296, 216, 768, 384, 384, 256, 64, 
  60, 288, 288, 144, 96, 72, 72, 24, 14, 32, 32, 18, 20, 48, 48, 24, 30, 
  2903040, 46080, 9216, 3072, 768, 4320, 1296, 216, 768, 384, 384, 256, 64, 
  60, 288, 288, 144, 96, 72, 72, 24, 14, 32, 32, 18, 20, 48, 48, 24, 30];

CHEVIE.E7.classes:=
[ 1, 63, 315, 945, 3780, 672, 2240, 13440, 3780, 7560, 7560, 
  11340, 45360, 48384, 10080, 10080, 20160, 30240, 40320, 40320, 120960, 
  207360, 90720, 90720, 161280, 145152, 60480, 60480, 120960, 96768, 1, 63, 
  315, 945, 3780, 672, 2240, 13440, 3780, 7560, 7560, 11340, 45360, 48384, 
  10080, 10080, 20160, 30240, 40320, 40320, 120960, 207360, 90720, 90720, 
  161280, 145152, 60480, 60480, 120960, 96768 ];

CHEVIE.E7.PositionId:=function() return 1; end;

CHEVIE.E7.PositionSgn:=function() return 2; end;

CHEVIE.E7.PositionRefl:=function() return 4; end;

CHEVIE.E7.vpolheckeirreducibles:=
[[[[1],0],[[1],60],[[1],24],[[1],4],[[1],8],
  [[1],4],[[1],48],[[1],8],[[1],12],[[1],8],
  [[1],28],[[1],32],[[1],8],[[1],8],
  [[1],28],[[1],8],[[1],24],[[1],8],
  [[1],20],[[1],28],[[1],12],[[1],12],
  [[1],12],[[1],16],[[1],16],[[1],12],
  [[1],12],[[1],16],[[1],12],[[1],12],
  [[1],126],[[1],2],[[1],6],[[1],26],
  [[1],6],[[1],62],[[1],42],[[1],46],
  [[1],66],[[1],26],[[1],6],[[1],14],
  [[1],10],[[1],30],[[1],6],[[1],10],
  [[1],50],[[1],10],[[1],10],[[1],10],
  [[1],10],[[1],18],[[1],10],[[1],34],
  [[1],14],[[1],10],[[1],14],[[1],10],
  [[1],22],[[1],26]],
  [[[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
  [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
  [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
  [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
  [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
  [[1],0],[[1],0],[[1],0],[[1],0],[[1],0],
  [[-1],0],[[-1],0],[[-1],0],[[-1],0],
  [[-1],0],[[-1],0],[[-1],0],[[-1],0],
  [[-1],0],[[-1],0],[[-1],0],[[-1],0],
  [[-1],0],[[-1],0],[[-1],0],[[-1],0],
  [[-1],0],[[-1],0],[[-1],0],[[-1],0],
  [[-1],0],[[-1],0],[[-1],0],[[-1],0],
  [[-1],0],[[-1],0],[[-1],0],[[-1],0],
  [[-1],0],[[-1],0]],
  [[[7],0],[[1,0,0,0,0,0,0,0,0,0,-6],0],
  [[3,0,0,0,0,0,-4],0],[[5,0,-2],0],
  [[3,0,-4],0],[[5,0,-1],0],
  [[1,0,0,0,0,0,0,0,-3],0],[[3,0,-2],0],
  [[3],0],[[3,0,-2],0],[[1,0,-1,0,0,0,-3],0],
  [[1,0,0,0,0,0,-2],0],[[3,0,-2],0],
  [[3,0,-1],0],[[1,0,0,0,0,0,-3],0],
  [[3,0,-1],0],[[1,0,0,0,1],0],[[3,0,-3],0],
  [[1],0],[[1,0,0,0,0,0,-2],0],[[1,0,-2],0],
  [[1,0,-1],0],[[1,0,-2],0],[[1],0],[[1],0],
  [[1,0,-1],0],[[1,0,-3],0],[[1,0,-1],0],
  [[1,0,-1],0],[[1,0,-2],0],[[7],18],
  [[-6,0,1],0],[[-4,0,3],0],
  [[-2,0,1,0,0,0,4],0],[[-4,0,3],0],
  [[-1,0,0,0,5],6],[[-2],6],[[-1,0,2],6],
  [[3],10],[[-2,0,0,0,0,0,3],0],[[-4,0,1],0],
  [[-2,0,1],0],[[-2,0,3],0],[[2],6],
  [[-4,0,2],0],[[-2,0,4],0],[[2],8],
  [[-2,0,2],0],[[-2,0,3],0],[[-2,0,1],0],
  [[-2,0,1],0],[[],0],[[-2,0,1],0],[[1],6],
  [[1],2],[[-2,0,2],0],[[-2],0],[[-2,0,2],0],
  [[],0],[[-1],4]],
  [[[7],0],[[-6,0,0,0,0,0,0,0,0,0,1],50],
  [[-4,0,0,0,0,0,3],18],[[-2,0,5],2],
  [[-4,0,3],6],[[-1,0,5],2],
  [[-3,0,0,0,0,0,0,0,1],40],[[-2,0,3],6],
  [[3],12],[[-2,0,3],6],[[-3,0,0,0,-1,0,1],22],
  [[-2,0,0,0,0,0,1],26],[[-2,0,3],6],
  [[-1,0,3],6],[[-3,0,0,0,0,0,1],22],
  [[-1,0,3],6],[[1,0,0,0,1],20],[[-3,0,3],6],
  [[1],20],[[-2,0,0,0,0,0,1],22],[[-2,0,1],10],
  [[-1,0,1],10],[[-2,0,1],10],[[1],16],
  [[1],16],[[-1,0,1],10],[[-3,0,1],10],
  [[-1,0,1],14],[[-1,0,1],10],[[-2,0,1],10],
  [[-7],108],[[-1,0,6],0],[[-3,0,4],4],
  [[-4,0,0,0,-1,0,2],20],[[-3,0,4],4],
  [[-5,0,0,0,1],52],[[2],36],[[-2,0,1],38],
  [[-3],56],[[-3,0,0,0,0,0,2],20],[[-1,0,4],4],
  [[-1,0,2],12],[[-3,0,2],8],[[-2],24],
  [[-2,0,4],4],[[-4,0,2],8],[[-2],42],
  [[-2,0,2],8],[[-3,0,2],8],[[-1,0,2],8],
  [[-1,0,2],8],[[],0],[[-1,0,2],8],[[-1],28],
  [[-1],12],[[-2,0,2],8],[[2],14],[[-2,0,2],8],
  [[],0],[[1],22]],
  [[[15],0],[[-10,0,0,0,0,0,5],18],
  [[-4,0,9,0,0,0,2],6],[[7,0,-6,0,2],0],
  [[3,0,-7,0,3,0,-1,0,1],0],[[5,0,-5],0],
  [[-3],16],[[3,0,-2,0,2],0],[[-3,0,2],4],
  [[1,0,-4],0],[[-1,0,3,0,-1],6],
  [[2,0,-1,0,2],10],[[2,0,-2,0,1],0],
  [[1,0,-1],0],[[-1,0,1,0,0,0,-2],6],
  [[-1,0,-1],2],[[1],8],[[3,0,-4,0,2,0,-1],0],
  [[-1,0,2],6],[[1],8],[[-1],2],[[1],0],
  [[1],6],[[-1],6],[[],0],[[],0],
  [[1,0,-2,0,1],0],[[-1,0,0,0,-1],4],[[-1],4],
  [[1,0,-1],0],[[15],42],[[-10,0,5],0],
  [[-4,0,9,0,0,0,2],0],[[4,0,-6,0,3,0,0,0,2],6],
  [[-5,0,6,0,-3,0,1],0],[[5,0,0,0,-5],18],
  [[-3],14],[[-1,0,4],14],[[-3,0,2],22],
  [[1,0,-4],6],[[-2,0,3],0],[[2,0,-1,0,2],4],
  [[-1,0,3,0,-1],0],[[],0],[[-4,0,4,0,-2],0],
  [[-2,0,4,0,-3,0,0,0,-1],0],[[2,0,-1],16],
  [[1,0,0,0,-1],2],[[-2,0,3,0,-1,0,1],0],
  [[1],2],[[-1],0],[[1],6],[[1],4],
  [[-1],12],[[],0],[[-1,0,1],0],[[1,0,-1],4],
  [[-2,0,1,0,-1],0],[[-1],8],[[],0]],
  [[[15],0],[[5,0,0,0,0,0,-10],36],
  [[2,0,0,0,9,0,-4],12],[[2,0,-6,0,7],0],
  [[1,0,-1,0,3,0,-7,0,3],0],[[-5,0,5],2],
  [[-3],32],[[2,0,-2,0,3],4],[[2,0,-3],6],
  [[-4,0,1],6],[[-1,0,3,0,-1],18],
  [[2,0,-1,0,2],18],[[1,0,-2,0,2],4],
  [[-1,0,1],6],[[-2,0,0,0,1,0,-1],16],
  [[-1,0,-1],4],[[1],16],[[-1,0,2,0,-4,0,3],2],
  [[2,0,-1],12],[[1],20],[[-1],10],[[1],12],
  [[1],6],[[-1],10],[[],0],[[],0],
  [[1,0,-2,0,1],8],[[-1,0,0,0,-1],8],[[-1],8],
  [[-1,0,1],10],[[-15],84],[[-5,0,10],0],
  [[-2,0,0,0,-9,0,4],0],
  [[-2,0,0,0,-3,0,6,0,-4],12],
  [[-1,0,3,0,-6,0,5],0],[[5,0,0,0,-5],40],
  [[3],28],[[-4,0,1],30],[[-2,0,3],42],
  [[4,0,-1],18],[[-3,0,2],4],[[-2,0,1,0,-2],6],
  [[1,0,-3,0,1],6],[[],0],[[2,0,-4,0,4],2],
  [[1,0,0,0,3,0,-4,0,2],2],[[1,0,-2],32],
  [[1,0,0,0,-1],4],[[-1,0,1,0,-3,0,2],4],
  [[-1],8],[[1],10],[[-1],12],[[-1],6],
  [[1],22],[[],0],[[-1,0,1],8],[[1,0,-1],8],
  [[1,0,-1,0,2],6],[[1],14],[[],0]],
  [[[21],0],[[15,0,0,0,0,0,0,0,0,0,-6],40],
  [[6,0,0,0,0,0,-12,0,0,0,0,0,3],12],
  [[1,0,-10,0,10],0],[[6,0,-12,0,3],4],
  [[1,0,-5,0,10],0],[[6,0,0,0,0,0,0,0,-3],32],
  [[3,0,-6,0,3],4],[[2,0,0,0,0,0,3],6],
  [[2,0,-6,0,3],4],[[3,0,0,0,4,0,-3,0,0,0,-1],16]
  ,[[1,0,2,0,0,0,-2],20],[[2,0,-6,0,3],4],
  [[1,0,-3,0,3],4],[[3,0,0,0,0,0,-3],16],
  [[-3,0,3],6],[[2,0,0,0,1],16],
  [[4,0,-9,0,3],4],[[],0],[[1,0,0,0,1,0,-2],16]
  ,[[2,0,-2],8],[[1,0,-1],8],[[1,0,-2],8],
  [[1],10],[[],0],[[-1],10],[[5,0,-3],8],
  [[1,0,0,0,-1],10],[[-1],10],[[3,0,-2],8],
  [[21],90],[[-6,0,15],0],[[3,0,-12,0,6],2],
  [[6,0,0,0,4,0,-8,0,0,0,-2,0,1],14],
  [[3,0,-12,0,6],2],[[10,0,0,0,-5,0,0,0,1],42],
  [[3],30],[[1,0,-2,0,1],30],[[3,0,2],46],
  [[3,0,0,0,1,0,-6,0,0,0,0,0,1],14],
  [[1,0,-4,0,6],2],[[2,0,0,0,-2,0,1],8],
  [[4,0,-6,0,1],6],[[1],18],[[2,0,-8,0,6],2],
  [[7,0,-8,0,1],6],[[3],34],[[1,0,-4,0,1],6],
  [[5,0,-6,0,1],6],[[1,0,-2,0,1],6],
  [[1,0,-2,0,1],6],[[],0],[[-2,0,1],8],
  [[1],24],[[],0],[[2,0,-4,0,1],6],
  [[1,0,0,0,0,0,1],8],[[3,0,-4,0,1],6],
  [[-1],16],[[1],18]],
  [[[21],0],[[-6,0,0,0,0,0,0,0,0,0,15],10],
  [[3,0,0,0,0,0,-12,0,0,0,0,0,6],0],
  [[10,0,-10,0,1],0],[[3,0,-12,0,6],0],
  [[10,0,-5,0,1],0],[[-3,0,0,0,0,0,0,0,6],8],
  [[3,0,-6,0,3],0],[[3,0,0,0,0,0,2],0],
  [[3,0,-6,0,2],0],[[-1,0,0,0,-3,0,4,0,0,0,3],2],
  [[-2,0,0,0,2,0,1],6],[[3,0,-6,0,2],0],
  [[3,0,-3,0,1],0],[[-3,0,0,0,0,0,3],6],
  [[3,0,-3],0],[[1,0,0,0,2],4],
  [[3,0,-9,0,4],0],[[],0],[[-2,0,1,0,0,0,1],6],
  [[-2,0,2],2],[[-1,0,1],2],[[-2,0,1],2],
  [[1],6],[[],0],[[-1],2],[[-3,0,5],2],
  [[-1,0,0,0,1],2],[[-1],2],[[-2,0,3],2],
  [[-21],36],[[-15,0,6],0],[[-6,0,12,0,-3],0],
  [[-1,0,2,0,0,0,8,0,-4,0,0,0,-6],0],
  [[-6,0,12,0,-3],0],[[-1,0,0,0,5,0,0,0,-10],12],
  [[-3],12],[[-1,0,2,0,-1],12],[[-2,0,-3],18],
  [[-1,0,0,0,0,0,6,0,-1,0,0,0,-3],0],
  [[-6,0,4,0,-1],0],[[-1,0,2,0,0,0,-2],0],
  [[-1,0,6,0,-4],0],[[-1],12],[[-6,0,8,0,-2],0],
  [[-1,0,8,0,-7],0],[[-3],16],[[-1,0,4,0,-1],0],
  [[-1,0,6,0,-5],0],[[-1,0,2,0,-1],0],
  [[-1,0,2,0,-1],0],[[],0],[[-1,0,2],0],
  [[-1],10],[[],0],[[-1,0,4,0,-2],0],
  [[-1,0,0,0,0,0,-1],0],[[-1,0,4,0,-3],0],
  [[1],6],[[-1],8]],
  [[[21],0],[[-6,0,5,0,0,0,0,0,-10],10],
  [[4,0,0,0,0,0,-8,0,9],0],[[12,0,-8,0,1],0],
  [[6,0,-11,0,3,0,-1],0],[[11,0,-5],0],
  [[1,0,0,0,0,0,0,0,0,0,0,0,2],0],
  [[5,0,-6,0,1],0],[[4,0,0,0,-3],0],
  [[4,0,-7],0],[[1,0,-1,0,0,0,-4,0,3,0,-2],0],
  [[-2,0,1,0,2],6],[[5,0,-5,0,1],0],
  [[4,0,-3],0],[[-4,0,2],6],[[4,0,-2],0],
  [[1,0,0,0,0,0,-2],0],[[6,0,-7,0,3],0],
  [[-1,0,-1],4],[[1,0,0,0,0,0,-1,0,2],0],
  [[1,0,-2,0,1],0],[[1,0,-1],0],[[1,0,-2],0],
  [[-1],4],[[1,0,0,0,-1],0],[[-1],2],
  [[2,0,-4,0,2],0],[[1,0,-1,0,-1,0,1],0],
  [[1],0],[[2,0,-2,0,1],0],[[21],30],
  [[-16,0,5],0],[[-8,0,12,0,0,0,1],0],
  [[-2,0,2,0,0,0,8,0,-6,0,3],0],
  [[-9,0,9,0,-3],0],[[1,0,0,0,0,0,0,0,5],10],
  [[3],10],[[2,0,-2],10],[[1],18],
  [[-2,0,0,0,0,0,4,0,-5],0],[[-7,0,4],0],
  [[-2,0,2,0,2,0,-1],0],[[-3,0,6,0,-2],0],
  [[1],6],[[-8,0,7,0,-1],0],
  [[-4,0,8,0,-3,0,1],0],[[1,0,-2],10],
  [[-2,0,4],0],[[-4,0,5,0,-3],0],[[-1,0,3],0],
  [[-2,0,2],0],[[],0],[[-2,0,1],0],[[-1],10],
  [[],0],[[-3,0,3,0,-1],0],[[-2,0,0,0,2],0],
  [[-3,0,4,0,-1],0],[[1],6],[[1],6]],
  [[[21],0],[[-10,0,0,0,0,0,5,0,-6],42],
  [[9,0,-8,0,0,0,0,0,4],16],[[1,0,-8,0,12],0],
  [[-1,0,3,0,-11,0,6],2],[[-5,0,11],2],
  [[2,0,0,0,0,0,0,0,0,0,0,0,1],36],
  [[1,0,-6,0,5],4],[[-3,0,0,0,4],8],
  [[-7,0,4],6],[[-2,0,3,0,-4,0,0,0,-1,0,1],18],
  [[2,0,1,0,-2],22],[[1,0,-5,0,5],4],
  [[-3,0,4],6],[[2,0,-4],20],[[-2,0,4],6],
  [[-2,0,0,0,0,0,1],18],[[3,0,-7,0,6],4],
  [[-1,0,-1],14],[[2,0,-1,0,0,0,0,0,1],20],
  [[1,0,-2,0,1],8],[[-1,0,1],10],[[-2,0,1],10],
  [[-1],12],[[-1,0,0,0,1],12],[[-1],10],
  [[2,0,-4,0,2],8],[[1,0,-1,0,-1,0,1],10],
  [[1],12],[[1,0,-2,0,2],8],[[-21],96],
  [[-5,0,16],0],[[-1,0,0,0,-12,0,8],0],
  [[-3,0,6,0,-8,0,0,0,-2,0,2],16],
  [[3,0,-9,0,9],2],[[-5,0,0,0,0,0,0,0,-1],44],
  [[-3],32],[[2,0,-2],34],[[-1],48],
  [[5,0,-4,0,0,0,0,0,2],18],[[-4,0,7],4],
  [[1,0,-2,0,-2,0,2],8],[[2,0,-6,0,3],6],
  [[-1],24],[[1,0,-7,0,8],2],
  [[-1,0,3,0,-8,0,4],4],[[2,0,-1],38],
  [[-4,0,2],8],[[3,0,-5,0,4],6],[[-3,0,1],8],
  [[-2,0,2],8],[[],0],[[-1,0,2],8],[[1],24],
  [[],0],[[1,0,-3,0,3],6],[[-2,0,0,0,2],10],
  [[1,0,-4,0,3],6],[[-1],16],[[-1],20]],
  [[[27],0],
  [[15,0,0,0,5,0,-6,0,0,0,0,0,0,0,0,0,1],44],
  [[9,0,-12,0,0,0,0,0,6],16],[[1,0,-10,0,16],0],
  [[6,0,-12,0,9],4],[[-6,0,15],2],
  [[2,0,0,0,-3,0,0,0,0,0,0,0,1],36],
  [[1,0,-8,0,7],4],[[-3,0,0,0,6],8],
  [[1,0,-7,0,7],4],[[8,0,-4,0,0,0,-1,0,2],20],
  [[-2,0,0,0,0,0,1],26],[[1,0,-7,0,7],4],
  [[-4,0,6],6],[[5,0,-3,0,0,0,0,0,1],20],
  [[-3,0,6],6],[[-2,0,1,0,0,0,1],18],
  [[3,0,-10,0,8],4],[[-1,0,0,0,1],16],
  [[2,0,-3,0,0,0,0,0,1],20],[[1,0,-3,0,2],8],
  [[-2,0,1],10],[[1,0,-2,0,2],8],
  [[-2,0,0,0,1],12],[[-1,0,0,0,1],12],
  [[-1,0,1],10],[[3,0,-5,0,3],8],
  [[-2,0,-1,0,2],12],[[-1,0,1],10],
  [[1,0,-4,0,2],8],[[27],98],[[-6,0,21],0],
  [[3,0,-12,0,12],2],[[13,0,-8,0,0,0,-2,0,4],18],
  [[3,0,-12,0,12],2],[[9],46],[[],0],[[],0],
  [[3],50],[[5,0,-7,0,0,0,0,0,3],18],
  [[-5,0,10],4],[[-3,0,-2,0,4],10],
  [[3,0,-7,0,5],6],[[2],22],[[1,0,-9,0,11],2],
  [[6,0,-9,0,6],6],[[],0],[[1,0,-4,0,4],6],
  [[3,0,-8,0,5],6],[[-3,0,3],8],[[-3,0,3],8],
  [[-1],14],[[-2,0,3],8],[[-1],26],[[],0],
  [[1,0,-5,0,4],6],[[-2,0,0,0,3],10],
  [[1,0,-6,0,4],6],[[],0],[[-1],20]],
  [[[27],0],
  [[1,0,0,0,0,0,0,0,0,0,-6,0,5,0,0,0,15],0],
  [[6,0,0,0,0,0,-12,0,9],0],[[16,0,-10,0,1],0],
  [[9,0,-12,0,6],0],[[15,0,-6],0],
  [[1,0,0,0,0,0,0,0,-3,0,0,0,2],0],
  [[7,0,-8,0,1],0],[[6,0,0,0,-3],0],
  [[7,0,-7,0,1],0],[[2,0,-1,0,0,0,-4,0,8],0],
  [[1,0,0,0,0,0,-2],0],[[7,0,-7,0,1],0],
  [[6,0,-4],0],[[1,0,0,0,0,0,-3,0,5],0],
  [[6,0,-3],0],[[1,0,0,0,1,0,-2],0],
  [[8,0,-10,0,3],0],[[1,0,0,0,-1],0],
  [[1,0,0,0,0,0,-3,0,2],0],[[2,0,-3,0,1],0],
  [[1,0,-2],0],[[2,0,-2,0,1],0],
  [[1,0,0,0,-2],0],[[1,0,0,0,-1],0],
  [[1,0,-1],0],[[3,0,-5,0,3],0],
  [[2,0,-1,0,-2],0],[[1,0,-1],0],
  [[2,0,-4,0,1],0],[[-27],28],[[-21,0,6],0],
  [[-12,0,12,0,-3],0],[[-4,0,2,0,0,0,8,0,-13],0],
  [[-12,0,12,0,-3],0],[[-9],16],[[],0],[[],0],
  [[-3],16],[[-3,0,0,0,0,0,7,0,-5],0],
  [[-10,0,5],0],[[-4,0,2,0,3],0],
  [[-5,0,7,0,-3],0],[[-2],8],[[-11,0,9,0,-1],0],
  [[-6,0,9,0,-6],0],[[],0],[[-4,0,4,0,-1],0],
  [[-5,0,8,0,-3],0],[[-3,0,3],0],[[-3,0,3],0],
  [[1],4],[[-3,0,2],0],[[1],8],[[],0],
  [[-4,0,5,0,-1],0],[[-3,0,0,0,2],0],
  [[-4,0,6,0,-1],0],[[],0],[[1],6]],
  [[[35],0],[[15,0,0,0,0,0,0,0,0,0,-20],20],
  [[1,0,0,0,0,0,-12,0,0,0,0,0,18,0,0,0,0,0,-4],0],
  [[10,0,-20,0,5],0],[[1,0,-12,0,18,0,-4],0],
  [[10,0,-10,0,5],0],[[6,0,0,0,0,0,0,0,-7],16],
  [[1,0,-6,0,9,0,-2],0],[[1,0,0,0,0,0,6],0],
  [[1,0,-6,0,6,0,-2],0],
  [[4,0,-1,0,3,0,-6,0,0,0,-1],8],
  [[2,0,1,0,0,0,-4],10],[[1,0,-6,0,6,0,-2],0],
  [[1,0,-3,0,3,0,-1],0],
  [[-1,0,3,0,0,0,0,0,-1],10],
  [[1,0,-3,0,0,0,-1],0],[[2,0,0,0,1],8],
  [[1,0,-9,0,12,0,-3],0],[[-2],10],
  [[1,0,0,0,1,0,-2],8],[[2,0,-2],4],
  [[1,0,-1],4],[[1],4],[[1],6],[[-1],8],
  [[],0],[[5,0,-6],4],[[1,0,-2],6],[[1],6],
  [[3,0,-3],4],[[35],54],[[-20,0,15],0],
  [[-4,0,18,0,-12,0,1],0],
  [[1,0,0,0,4,0,-8,0,0,0,-12,0,6,0,0,0,4],2],
  [[-4,0,18,0,-12,0,1],0],
  [[5,0,0,0,-10,0,0,0,10],22],[[-1],18],
  [[1,0,2,0,-1],18],[[6,0,1],28],
  [[3,0,-2,0,0,0,-6,0,3,0,0,0,1],6],
  [[-4,0,6,0,-4,0,1],0],[[1,0,0,0,-4,0,2],2],
  [[3,0,-8,0,4],2],[[],0],
  [[-4,0,12,0,-8,0,1],0],[[4,0,-14,0,7],2],
  [[1,0,0,0,0,0,2],18],[[2,0,-2,0,1],2],
  [[3,0,-10,0,5],2],[[1,0,-2,0,1],2],
  [[1,0,-2,0,1],2],[[],0],[[1],2],[[1],16],
  [[-1],6],[[2,0,-4,0,2],2],[[-2,0,1],6],
  [[2,0,-6,0,3],2],[[1],10],[[],0]],
  [[[35],0],[[-20,0,0,0,0,0,0,0,0,0,15],30],
  [[-4,0,0,0,0,0,18,0,0,0,0,0,-12,0,0,0,0,0,1],6],
  [[5,0,-20,0,10],0],[[-4,0,18,0,-12,0,1],2],
  [[5,0,-10,0,10],0],[[-7,0,0,0,0,0,0,0,6],24],
  [[-2,0,9,0,-6,0,1],2],[[6,0,0,0,0,0,1],6],
  [[-2,0,6,0,-6,0,1],2],
  [[-1,0,0,0,-6,0,3,0,-1,0,4],10],
  [[-4,0,0,0,1,0,2],16],[[-2,0,6,0,-6,0,1],2],
  [[-1,0,3,0,-3,0,1],2],
  [[-1,0,0,0,0,0,3,0,-1],10],
  [[-1,0,0,0,-3,0,1],2],[[1,0,0,0,2],12],
  [[-3,0,12,0,-9,0,1],2],[[-2],10],
  [[-2,0,1,0,0,0,1],14],[[-2,0,2],6],
  [[-1,0,1],6],[[1],8],[[1],10],[[-1],8],
  [[],0],[[-6,0,5],6],[[-2,0,1],8],[[1],6],
  [[-3,0,3],6],[[-35],72],[[-15,0,20],0],
  [[-1,0,12,0,-18,0,4],0],
  [[-4,0,0,0,-6,0,12,0,0,0,8,0,-4,0,0,0,-1],8],
  [[-1,0,12,0,-18,0,4],0],
  [[-10,0,0,0,10,0,0,0,-5],32],[[1],24],
  [[1,0,-2,0,-1],24],[[-1,0,-6],36],
  [[-1,0,0,0,-3,0,6,0,0,0,2,0,-3],8],
  [[-1,0,4,0,-6,0,4],0],[[-2,0,4,0,0,0,-1],6],
  [[-4,0,8,0,-3],4],[[],0],
  [[-1,0,8,0,-12,0,4],0],[[-7,0,14,0,-4],4],
  [[-2,0,0,0,0,0,-1],26],[[-1,0,2,0,-2],4],
  [[-5,0,10,0,-3],4],[[-1,0,2,0,-1],4],
  [[-1,0,2,0,-1],4],[[],0],[[-1],8],[[-1],18],
  [[1],8],[[-2,0,4,0,-2],4],[[-1,0,2],6],
  [[-3,0,6,0,-2],4],[[-1],12],[[],0]],
  [[[35],0],
  [[9,0,-10,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
  40],[[2,0,0,0,18,0,-12,0,0,0,0,0,3],12],
  [[3,0,-14,0,18],0],[[-3,0,9,0,-13,0,10],2],
  [[-10,0,15],2],[[-3,0,0,0,2],32],
  [[3,0,-8,0,7],4],[[2,0,-6,0,0,0,3],6],
  [[3,0,-5,0,7],4],[[-3,0,7,0,-4,0,0,0,0,0,1],18]
  ,[[-1,0,4,0,-1,0,0,0,0,0,0,0,1],20],
  [[2,0,-7,0,6],4],[[-4,0,4],6],
  [[3,0,-1,0,0,0,0,0,1],20],[[-1,0,-3,0,3],4],
  [[1,0,-2],16],[[-1,0,5,0,-11,0,8],2],
  [[-1,0,0,0,0,0,1],14],[[3,0,-1],20],
  [[-2,0,2],10],[[-1,0,1],10],[[-1,0,-1,0,1],8],
  [[1,0,-1,0,0,0,1],10],[[-1],12],
  [[-1,0,0,0,1],8],[[-1,0,2,0,-5,0,3],6],
  [[2,0,-2,0,0,0,1],10],[[-1],8],
  [[1,0,-3,0,2],8],[[35],90],[[-10,0,25],0],
  [[9,0,-12,0,14],2],
  [[2,0,-6,0,16,0,-8,0,0,0,0,0,3],14],
  [[-1,0,6,0,-15,0,13],0],[[5],46],[[-1],30],
  [[2],32],[[-3,0,2],46],
  [[9,0,-5,0,0,0,0,0,1],18],[[-7,0,8],4],
  [[4,0,-4,0,0,0,3],8],[[-1,0,3,0,-6,0,5],4],
  [[],0],[[3,0,-11,0,11],2],
  [[-3,0,6,0,-10,0,6],4],[[-1],34],[[-2,0,3],8],
  [[-1,0,4,0,-8,0,5],4],[[-1,0,3],8],
  [[-2,0,2],8],[[],0],[[-1,0,-1,0,1],6],
  [[1],24],[[-1],10],[[1,0,-4,0,3],6],
  [[1,0,-3,0,0,0,1],8],[[2,0,-5,0,4],6],
  [[-1],16],[[],0]],
  [[[35],0],[[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,
  -10,0,9],0],
  [[3,0,0,0,0,0,-12,0,18,0,0,0,2],0],
  [[18,0,-14,0,3],0],[[10,0,-13,0,9,0,-3],0],
  [[15,0,-10],0],[[2,0,0,0,-3],12],
  [[7,0,-8,0,3],0],[[3,0,0,0,-6,0,2],0],
  [[7,0,-5,0,3],0],[[1,0,0,0,0,0,-4,0,7,0,-3],0],
  [[1,0,0,0,0,0,0,0,-1,0,4,0,-1],0],
  [[6,0,-7,0,2],0],[[4,0,-4],0],
  [[1,0,0,0,0,0,-1,0,3],0],[[3,0,-3,0,-1],0],
  [[-2,0,1],6],[[8,0,-11,0,5,0,-1],0],
  [[1,0,0,0,0,0,-1],0],[[-1,0,3],6],
  [[2,0,-2],0],[[1,0,-1],0],[[1,0,-1,0,-1],0],
  [[1,0,0,0,-1,0,1],0],[[-1],4],
  [[1,0,0,0,-1],0],[[3,0,-5,0,2,0,-1],0],
  [[1,0,0,0,-2,0,2],0],[[-1],4],
  [[2,0,-3,0,1],0],[[-35],36],[[-25,0,10],0],
  [[-14,0,12,0,-9],0],
  [[-3,0,0,0,0,0,8,0,-16,0,6,0,-2],0],
  [[-13,0,15,0,-6,0,1],0],[[-5],16],[[1],12],
  [[-2],14],[[-2,0,3],18],
  [[-1,0,0,0,0,0,5,0,-9],0],[[-8,0,7],0],
  [[-3,0,0,0,4,0,-4],0],[[-5,0,6,0,-3,0,1],0],
  [[],0],[[-11,0,11,0,-3],0],
  [[-6,0,10,0,-6,0,3],0],[[1],16],[[-3,0,2],0],
  [[-5,0,8,0,-4,0,1],0],[[-3,0,1],0],
  [[-2,0,2],0],[[],0],[[-1,0,1,0,1],0],
  [[-1],10],[[1],4],[[-3,0,4,0,-1],0],
  [[-1,0,0,0,3,0,-1],0],[[-4,0,5,0,-2],0],
  [[1],6],[[],0]],
  [[[56],0],[[1,0,0,0,0,0,0,0,0,0,-6,0,0,0,0,0,15,
  0,-10,0,-24],0],
  [[6,0,0,0,0,0,-24,0,18,0,0,0,-8],0],
  [[28,0,-24,0,4],0],[[13,0,-25,0,15,0,-3],0],
  [[25,0,-15,0,1],0],[[-3,0,0,0,2,0,0,0,3],8],
  [[10,0,-14,0,6],0],[[6,0,0,0,-6],0],
  [[10,0,-11,0,5],0],
  [[1,0,-1,0,0,0,-7,0,9,0,-3,0,-3],0],
  [[1,0,0,0,0,0,-2,0,-1,0,2],0],
  [[9,0,-13,0,4],0],[[7,0,-7,0,1],0],
  [[1,0,0,0,0,0,-4,0,3,0,0,0,-3],0],
  [[6,0,-6,0,1],0],[[1,0,-2,0,-1],4],
  [[11,0,-20,0,9,0,-1],0],[[1,0,0,0,0,0,-1],0],
  [[-3,0,2,0,0,0,-1],6],[[2,0,-4,0,2],0],
  [[1,0,-2,0,1],0],[[1,0,-3,0,2],0],
  [[1,0,0,0,-1],0],[[-1],4],[[1,0,-1,0,1],0],
  [[3,0,-8,0,7,0,-1],0],[[1,0,-1,0,-2,0,1],0],
  [[-1,0,1],2],[[2,0,-5,0,4],0],[[56],36],
  [[-40,0,16],0],[[-20,0,24,0,-12],0],
  [[-4,0,2,0,0,0,16,0,-20,0,6,0,8],0],
  [[-19,0,27,0,-9,0,1],0],
  [[1,0,0,0,0,0,0,0,10],12],[[2],12],
  [[1,0,0,0,1],12],[[],0],
  [[-2,0,0,0,0,0,11,0,-8,0,0,0,3],0],
  [[-14,0,11,0,-1],0],[[-4,0,2,0,4,0,-2],0],
  [[-6,0,12,0,-7,0,1],0],[[1],12],
  [[-17,0,19,0,-5],0],[[-7,0,18,0,-13,0,3],0],
  [[-2],16],[[-4,0,6,0,-3],0],
  [[-6,0,14,0,-9,0,1],0],[[-4,0,3,0,-1],0],
  [[-3,0,4,0,-1],0],[[],0],[[-2,0,3,0,-1],0],
  [[],0],[[-1],4],[[-4,0,8,0,-3],0],
  [[-2,0,0,0,3],0],[[-5,0,9,0,-5],0],[[],0],
  [[1],8]],
  [[[56],0],[[-24,0,-10,0,15,0,0,0,0,0,-6,0,0,0,0,0,
  0,0,0,0,1],40],
  [[-8,0,0,0,18,0,-24,0,0,0,0,0,6],12],
  [[4,0,-24,0,28],0],[[-3,0,15,0,-25,0,13],2],
  [[1,0,-15,0,25],0],[[3,0,0,0,2,0,0,0,-3],32],
  [[6,0,-14,0,10],4],[[-6,0,0,0,6],8],
  [[5,0,-11,0,10],4],
  [[-3,0,-3,0,9,0,-7,0,0,0,-1,0,1],16],
  [[2,0,-1,0,-2,0,0,0,0,0,1],22],
  [[4,0,-13,0,9],4],[[1,0,-7,0,7],4],
  [[-3,0,0,0,3,0,-4,0,0,0,0,0,1],16],
  [[1,0,-6,0,6],4],[[-1,0,-2,0,1],16],
  [[-1,0,9,0,-20,0,11],2],[[-1,0,0,0,0,0,1],14],
  [[-1,0,0,0,2,0,-3],16],[[2,0,-4,0,2],8],
  [[1,0,-2,0,1],8],[[2,0,-3,0,1],8],
  [[-1,0,0,0,1],12],[[-1],12],[[1,0,-1,0,1],8],
  [[-1,0,7,0,-8,0,3],6],[[1,0,-2,0,-1,0,1],10],
  [[1,0,-1],8],[[4,0,-5,0,2],8],[[-56],90],
  [[-16,0,40],0],[[12,0,-24,0,20],2],
  [[-8,0,-6,0,20,0,-16,0,0,0,-2,0,4],14],
  [[-1,0,9,0,-27,0,19],0],
  [[-10,0,0,0,0,0,0,0,-1],42],[[-2],30],
  [[-1,0,0,0,-1],30],[[],0],
  [[-3,0,0,0,8,0,-11,0,0,0,0,0,2],14],
  [[1,0,-11,0,14],2],[[2,0,-4,0,-2,0,4],8],
  [[-1,0,7,0,-12,0,6],4],[[-1],18],
  [[5,0,-19,0,17],2],[[-3,0,13,0,-18,0,7],4],
  [[2],34],[[3,0,-6,0,4],6],
  [[-1,0,9,0,-14,0,6],4],[[1,0,-3,0,4],6],
  [[1,0,-4,0,3],6],[[],0],[[1,0,-3,0,2],6],
  [[],0],[[1],10],[[3,0,-8,0,4],6],
  [[-3,0,0,0,2],10],[[5,0,-9,0,5],6],[[],0],
  [[-1],18]],
  [[[70],0],[[-10,0,0,0,0,0,0,0,-30,0,30],18],
  [[-8,0,18,0,0,0,-20],6],[[24,0,-32,0,14],0],
  [[10,0,-21,0,21,0,-15,0,3],0],[[15,0,-25,0,5],0],
  [[6,0,0,0,1],20],[[5,0,-10,0,9,0,-4,0,1],0],
  [[-6,0,8],4],[[4,0,-6,0,7,0,-3],0],
  [[-1,0,4,0,0,0,-6,0,8,0,-3],6],
  [[2,0,0,0,-2,0,2],10],[[3,0,-8,0,6,0,-3],0],
  [[1,0,-3,0,2],0],[[-1,0,0,0,0,0,-3,0,3],6],
  [[-2,0,1],2],[[2,0,-3],10],
  [[7,0,-14,0,15,0,-7,0,2],0],[[-1],6],
  [[-3,0,3,0,-1],12],[[1],0],[[],0],[[],0],
  [[],0],[[1],8],[[],0],
  [[2,0,-3,0,3,0,-3,0,1,0,-1],0],
  [[-1,0,1,0,-1],4],[[-1],6],
  [[1,0,-1,0,1,0,-1],0],[[70],54],[[-40,0,30],0],
  [[-16,0,24,0,-24,0,6],0],
  [[8,0,-12,0,6,0,12,0,-8],6],
  [[-15,0,27,0,-21,0,7],0],
  [[1,0,0,0,0,0,0,0,5,0,-16,0,5],18],[[7],18],
  [[3,0,-4,0,2],18],[[2],30],
  [[1,0,-4,0,0,0,11,0,-6],6],[[-4,0,11,0,-5],0],
  [[4,0,-6,0,4],4],[[-3,0,5,0,-6,0,4,0,-2],0],
  [[],0],[[-10,0,19,0,-13,0,3],0],
  [[-5,0,11,0,-13,0,10,0,-5,0,1],0],[[-2,0,1],20],
  [[2,0,0,0,1],2],[[-4,0,7,0,-9,0,6,0,-2,0,1],0],
  [[-1],0],[[1],2],[[],0],[[],0],[[],0],
  [[1],6],[[-1,0,2,0,-2,0,1],0],[[1,0,-2],4],
  [[-2,0,4,0,-4,0,2,0,-1],0],[[-1],10],[[],0]],
  [[[70],0],[[30,0,-30,0,0,0,0,0,0,0,-10],32],
  [[-20,0,0,0,18,0,-8],12],[[14,0,-32,0,24],0],
  [[3,0,-15,0,21,0,-21,0,10],0],[[5,0,-25,0,15],0],
  [[1,0,0,0,6],24],[[1,0,-4,0,9,0,-10,0,5],0],
  [[8,0,-6],6],[[-3,0,7,0,-6,0,4],2],
  [[-3,0,8,0,-6,0,0,0,4,0,-1],12],
  [[2,0,-2,0,0,0,2],16],[[-3,0,6,0,-8,0,3],2],
  [[2,0,-3,0,1],4],[[3,0,-3,0,0,0,0,0,-1],14],
  [[1,0,-2],4],[[-3,0,2],12],
  [[2,0,-7,0,15,0,-14,0,7],0],[[-1],14],
  [[-1,0,3,0,-3],12],[[1],12],[[],0],[[],0],
  [[],0],[[1],8],[[],0],
  [[-1,0,1,0,-3,0,3,0,-3,0,2],2],
  [[-1,0,1,0,-1],8],[[-1],6],
  [[-1,0,1,0,-1,0,1],6],[[-70],72],
  [[-30,0,40],0],[[-6,0,24,0,-24,0,16],0],
  [[8,0,-12,0,-6,0,12,0,-8],12],
  [[-7,0,21,0,-27,0,15],0],
  [[-5,0,16,0,-5,0,0,0,0,0,0,0,-1],32],[[-7],24],
  [[-2,0,4,0,-3],24],[[-2],36],
  [[6,0,-11,0,0,0,4,0,-1],12],[[5,0,-11,0,4],2],
  [[-4,0,6,0,-4],6],[[2,0,-4,0,6,0,-5,0,3],2],
  [[],0],[[-3,0,13,0,-19,0,10],0],
  [[-1,0,5,0,-10,0,13,0,-11,0,5],0],[[-1,0,2],28],
  [[-1,0,0,0,-2],4],
  [[-1,0,2,0,-6,0,9,0,-7,0,4],0],[[1],10],
  [[-1],8],[[],0],[[],0],[[],0],[[-1],8],
  [[-1,0,2,0,-2,0,1],4],[[2,0,-1],8],
  [[1,0,-2,0,4,0,-4,0,2],2],[[1],12],[[],0]],
  [[[84],0],
  [[5,0,0,0,0,0,-40,0,30,0,0,0,0,0,0,0,9],24],
  [[9,0,0,0,-8,0,0,0,18,0,0,0,0,0,0,0,1],8],
  [[20,0,-40,0,24],0],[[4,0,-22,0,30,0,-18,0,10],0]
  ,[[10,0,-30,0,14],0],[[-3,0,0,0,6],24],
  [[3,0,-6,0,13,0,-10,0,3],0],
  [[-3,0,12,0,-6,0,0,0,1],4],
  [[-7,0,9,0,-5,0,3],2],
  [[-1,0,-2,0,5,0,-5,0,0,0,3],10],
  [[-1,0,2,0,2,0,0,0,-1,0,2],12],
  [[1,0,-5,0,9,0,-7,0,2],0],[[-1,0,3,0,-3],2],
  [[1,0,0,0,-2,0,2,0,-3],8],[[1,0,0,0,1],4],
  [[-3,0,2],12],[[3,0,-13,0,18,0,-15,0,5],0],
  [[2,0,-1],8],[[-1,0,2,0,-3,0,1],12],[[1],4],
  [[],0],[[1,0,-1],6],[[-1,0,0,0,1],6],
  [[],0],[[-1],8],
  [[-2,0,4,0,-4,0,3,0,-2,0,1],2],
  [[1,0,-2,0,2,0,-1],6],[[1],6],
  [[-1,0,1,0,-1,0,1,0,-1],2],[[84],66],
  [[-40,0,44],0],[[-8,0,36,0,-24,0,16],0],
  [[-6,0,3,0,4,0,-4,0,-6,0,12,0,0,0,0,0,0,0,1],8],
  [[-10,0,30,0,-30,0,14],0],[[10,0,-16],30],
  [[3],22],[[1,0,0,0,2],22],[[4],36],
  [[-1,0,0,0,5,0,-7,0,0,0,3],8],
  [[-1,0,9,0,-11,0,3],0],
  [[2,0,-5,0,10,0,-4,0,0,0,1],4],
  [[4,0,-8,0,6,0,-4,0,2],2],[[-1],18],
  [[-6,0,18,0,-22,0,8],0],
  [[-1,0,9,0,-16,0,15,0,-9,0,4],0],
  [[-2,0,0,0,1],26],[[-2,0,-1,0,0,0,1],4],
  [[-1,0,6,0,-9,0,10,0,-7,0,2],0],[[-1],4],
  [[1],6],[[],0],[[1,0,-1],4],[[],0],
  [[],0],[[1,0,-2,0,2,0,-2],2],
  [[-2,0,3,0,-1],6],
  [[-1,0,2,0,-4,0,5,0,-3,0,1],0],[[1],12],
  [[-1],14]],
  [[[84],0],[[9,0,0,0,0,0,0,0,30,0,-40,0,0,0,0,0,5],
  20],[[1,0,0,0,0,0,0,0,18,0,0,0,-8,0,0,0,9],0]
  ,[[24,0,-40,0,20],0],
  [[10,0,-18,0,30,0,-22,0,4],0],
  [[14,0,-30,0,10],0],[[6,0,0,0,-3],20],
  [[3,0,-10,0,13,0,-6,0,3],0],
  [[1,0,0,0,-6,0,12,0,-3],0],
  [[3,0,-5,0,9,0,-7],0],
  [[3,0,0,0,-5,0,5,0,-2,0,-1],8],
  [[2,0,-1,0,0,0,2,0,2,0,-1],10],
  [[2,0,-7,0,9,0,-5,0,1],0],[[-3,0,3,0,-1],2],
  [[-3,0,2,0,-2,0,0,0,1],12],[[1,0,0,0,1],0],
  [[2,0,-3],10],[[5,0,-15,0,18,0,-13,0,3],0],
  [[-1,0,2],10],[[1,0,-3,0,2,0,-1],10],[[1],8],
  [[],0],[[-1,0,1],4],[[1,0,0,0,-1],6],
  [[],0],[[-1],4],
  [[1,0,-2,0,3,0,-4,0,4,0,-2],0],
  [[-1,0,2,0,-2,0,1],4],[[1],6],
  [[-1,0,1,0,-1,0,1,0,-1],2],[[-84],60],
  [[-44,0,40],0],[[-16,0,24,0,-36,0,8],0],
  [[-1,0,0,0,0,0,0,0,-12,0,6,0,4,0,-4,0,-3,0,6],0],
  [[-14,0,30,0,-30,0,10],0],[[16,0,-10],30],
  [[-3],20],[[-2,0,0,0,-1],20],[[-4],30],
  [[-3,0,0,0,7,0,-5,0,0,0,1],8],
  [[-3,0,11,0,-9,0,1],0],
  [[-1,0,0,0,4,0,-10,0,5,0,-2],0],
  [[-2,0,4,0,-6,0,8,0,-4],0],[[1],12],
  [[-8,0,22,0,-18,0,6],0],
  [[-4,0,9,0,-15,0,16,0,-9,0,1],0],
  [[-1,0,0,0,2],20],[[-1,0,0,0,1,0,2],0],
  [[-2,0,7,0,-10,0,9,0,-6,0,1],0],[[1],6],
  [[-1],4],[[],0],[[1,0,-1],4],[[],0],
  [[],0],[[2,0,-2,0,2,0,-1],2],
  [[1,0,-3,0,2],4],[[-1,0,3,0,-5,0,4,0,-2,0,1],0]
  ,[[-1],10],[[1],12]],
  [[[105],0],[[-6,0,5,0,0,0,15,0,0,0,-9,0,0,0,-40],
  10],[[8,0,0,0,0,0,-36,0,27,0,0,0,2],0],
  [[45,0,-50,0,10],0],[[17,0,-44,0,36,0,-8],0],
  [[40,0,-30,0,5],0],
  [[-3,0,0,0,2,0,0,0,6,0,-8],8],
  [[11,0,-26,0,14,0,-2],0],[[8,0,0,0,-9,0,6],0],
  [[11,0,-22,0,11,0,-1],0],
  [[1,0,-1,0,0,0,-7,0,13,0,-6,0,-2,0,-3],0],
  [[-2,0,0,0,2,0,1],6],[[11,0,-22,0,11,0,-1],0],
  [[8,0,-12,0,4],0],[[-3,0,6,0,0,0,-2],6],
  [[8,0,-9,0,2],0],[[1,0,-2,0,2],4],
  [[14,0,-34,0,23,0,-4],0],[[-1,0,0,0,2],4],
  [[-3,0,3,0,0,0,1],6],[[1,0,-4,0,5,0,-1],0],
  [[-2,0,2],2],[[1,0,-3,0,3],0],[[-2,0,1],4],
  [[-1,0,1],4],[[-1,0,1],2],
  [[2,0,-10,0,13,0,-6],0],
  [[1,0,-1,0,-2,0,4,0,-1],0],[[-1],2],
  [[1,0,-6,0,7,0,-2],0],[[105],42],
  [[-70,0,35],0],[[-28,0,51,0,-24,0,2],0],
  [[-4,0,4,0,0,0,20,0,-34,0,9,0,4,0,6],0],
  [[-28,0,51,0,-24,0,2],0],
  [[-1,0,0,0,0,0,0,0,0,0,16],14],[[-3],14],
  [[-2,0,0,0,-1],14],[[3,0,2],22],
  [[-2,0,0,0,0,0,14,0,-12,0,0,0,-1],0],
  [[-20,0,20,0,-5],0],[[-4,0,4,0,6,0,-7,0,2],0],
  [[-6,0,18,0,-17,0,4],0],[[],0],
  [[-24,0,37,0,-13,0,1],0],[[-8,0,27,0,-29,0,11],0]
  ,[[-1,0,0,0,2],14],[[-4,0,9,0,-6],0],
  [[-6,0,21,0,-20,0,6],0],[[-2,0,6,0,-3],0],
  [[-2,0,6,0,-3],0],[[],0],[[-2,0,4,0,-1],0],
  [[-1],12],[[],0],[[-4,0,11,0,-8,0,1],0],
  [[-2,0,0,0,4,0,-3],0],[[-4,0,14,0,-11,0,2],0],
  [[-1],8],[[],0]],
  [[[105],0],[[-40,0,0,0,-9,0,0,0,15,0,0,0,5,0,-6],
  36],[[2,0,0,0,27,0,-36,0,0,0,0,0,8],12],
  [[10,0,-50,0,45],0],[[-8,0,36,0,-44,0,17],2],
  [[5,0,-30,0,40],0],
  [[-8,0,6,0,0,0,2,0,0,0,-3],30],
  [[-2,0,14,0,-26,0,11],2],[[6,0,-9,0,0,0,8],6],
  [[-1,0,11,0,-22,0,11],2],
  [[-3,0,-2,0,-6,0,13,0,-7,0,0,0,-1,0,1],14],
  [[1,0,2,0,0,0,-2],20],[[-1,0,11,0,-22,0,11],2],
  [[4,0,-12,0,8],4],[[-2,0,0,0,6,0,-3],16],
  [[2,0,-9,0,8],4],[[2,0,-2,0,1],16],
  [[-4,0,23,0,-34,0,14],2],[[2,0,0,0,-1],12],
  [[1,0,0,0,3,0,-3],16],[[-1,0,5,0,-4,0,1],6],
  [[2,0,-2],8],[[3,0,-3,0,1],8],[[1,0,-2],10],
  [[1,0,-1],10],[[1,0,-1],8],
  [[-6,0,13,0,-10,0,2],6],
  [[-1,0,4,0,-2,0,-1,0,1],8],[[-1],10],
  [[-2,0,7,0,-6,0,1],6],[[-105],84],
  [[-35,0,70],0],[[-2,0,24,0,-51,0,28],0],
  [[-6,0,-4,0,-9,0,34,0,-20,0,0,0,-4,0,4],12],
  [[-2,0,24,0,-51,0,28],0],
  [[-16,0,0,0,0,0,0,0,0,0,1],38],[[3],28],
  [[1,0,0,0,2],28],[[-2,0,-3],42],
  [[1,0,0,0,12,0,-14,0,0,0,0,0,2],14],
  [[5,0,-20,0,20],2],[[-2,0,7,0,-6,0,-4,0,4],6],
  [[-4,0,17,0,-18,0,6],4],[[],0],
  [[-1,0,13,0,-37,0,24],0],[[-11,0,29,0,-27,0,8],4]
  ,[[-2,0,0,0,1],32],[[6,0,-9,0,4],6],
  [[-6,0,20,0,-21,0,6],4],[[3,0,-6,0,2],6],
  [[3,0,-6,0,2],6],[[],0],[[1,0,-4,0,2],6],
  [[1],22],[[],0],[[-1,0,8,0,-11,0,4],4],
  [[3,0,-4,0,0,0,2],8],[[-2,0,11,0,-14,0,4],4],
  [[1],14],[[],0]],
  [[[105],0],[[-30,0,50,0,0,0,0,0,-10,0,15],34],
  [[-20,0,0,0,36,0,-24,0,0,0,0,0,1],12],
  [[16,0,-48,0,41],0],[[4,0,-13,0,33,0,-39,0,16],0]
  ,[[5,0,-35,0,30],0],[[6],28],
  [[-4,0,14,0,-18,0,11],2],[[8,0,-12,0,0,0,1],6],
  [[-2,0,9,0,-17,0,7],2],
  [[-3,0,6,0,-5,0,-4,0,8,0,-5],12],
  [[-2,0,-2,0,2,0,-1],18],[[-2,0,10,0,-15,0,8],2],
  [[3,0,-7,0,4],4],[[3,0,-2,0,0,0,4,0,-1],14],
  [[1,0,-6,0,1],4],[[2],14],
  [[1,0,-8,0,21,0,-27,0,13],0],[[2,0,-1],12],
  [[1,0,-3,0,0,0,1],14],[[2,0,-2,0,1],8],
  [[-1,0,1],10],[[-1],10],[[-1],12],[[],0],
  [[],0],[[1,0,-4,0,8,0,-8,0,3],4],
  [[-1,0,3,0,-2],8],[[],0],
  [[-1,0,3,0,-4,0,2],6],[[105],78],
  [[-40,0,65],0],[[-8,0,24,0,-48,0,25],0],
  [[12,0,-8,0,-12,0,32,0,-16,0,0,0,0,0,1],12],
  [[-7,0,27,0,-45,0,26],0],
  [[-16,0,15,0,0,0,0,0,0,0,1],36],[[6],26],
  [[2,0,-2,0,3],26],[[-3],42],
  [[3,0,-11,0,0,0,11,0,-6],12],[[5,0,-19,0,11],2],
  [[-4,0,8,0,-8,0,0,0,1],6],
  [[1,0,-4,0,12,0,-13,0,5],2],[[],0],
  [[-2,0,17,0,-31,0,20],0],
  [[-1,0,3,0,-13,0,22,0,-23,0,8],0],
  [[1,0,0,0,1],30],[[3,0,-4,0,1],6],
  [[2,0,-7,0,15,0,-16,0,7],2],[[1,0,-3,0,1],6],
  [[1,0,-2,0,2],6],[[],0],[[-1],8],[[-1],22],
  [[],0],[[-1,0,4,0,-6,0,3],4],[[3,0,-3],8],
  [[-3,0,7,0,-9,0,5],4],[[],0],[[],0]],
  [[[105],0],[[15,0,-10,0,0,0,0,0,50,0,-30],16],
  [[1,0,0,0,0,0,-24,0,36,0,0,0,-20],0],
  [[41,0,-48,0,16],0],[[16,0,-39,0,33,0,-13,0,4],0]
  ,[[30,0,-35,0,5],0],[[6],20],
  [[11,0,-18,0,14,0,-4],0],[[1,0,0,0,-12,0,8],0],
  [[7,0,-17,0,9,0,-2],0],
  [[-5,0,8,0,-4,0,-5,0,6,0,-3],6],
  [[-1,0,2,0,-2,0,-2],8],[[8,0,-15,0,10,0,-2],0],
  [[4,0,-7,0,3],0],[[-1,0,4,0,0,0,-2,0,3],6],
  [[1,0,-6,0,1],0],[[2],10],
  [[13,0,-27,0,21,0,-8,0,1],0],[[-1,0,2],6],
  [[1,0,0,0,-3,0,1],8],[[1,0,-2,0,2],0],
  [[1,0,-1],0],[[-1],2],[[-1],4],[[],0],
  [[],0],[[3,0,-8,0,8,0,-4,0,1],0],
  [[-2,0,3,0,-1],4],[[],0],
  [[2,0,-4,0,3,0,-1],0],[[-105],48],
  [[-65,0,40],0],[[-25,0,48,0,-24,0,8],0],
  [[-1,0,0,0,0,0,16,0,-32,0,12,0,8,0,-12],0],
  [[-26,0,45,0,-27,0,7],0],
  [[-1,0,0,0,0,0,0,0,-15,0,16],16],[[-6],16],
  [[-3,0,2,0,-2],16],[[3],24],
  [[6,0,-11,0,0,0,11,0,-3],6],[[-11,0,19,0,-5],0],
  [[-1,0,0,0,8,0,-8,0,4],0],
  [[-5,0,13,0,-12,0,4,0,-1],0],[[],0],
  [[-20,0,31,0,-17,0,2],0],
  [[-8,0,23,0,-22,0,13,0,-3,0,1],0],
  [[-1,0,0,0,-1],16],[[-1,0,4,0,-3],0],
  [[-7,0,16,0,-15,0,7,0,-2],0],[[-1,0,3,0,-1],0],
  [[-2,0,2,0,-1],0],[[],0],[[1],2],[[1],12],
  [[],0],[[-3,0,6,0,-4,0,1],0],[[3,0,-3],4],
  [[-5,0,9,0,-7,0,3],0],[[],0],[[],0]],
  [[[105],0],
  [[10,0,0,0,0,0,-40,0,45,0,0,0,0,0,0,0,0,0,-10],24
  ],
  [[1,0,0,0,0,0,0,0,18,0,0,0,-8,0,0,0,18,0,-12],0],
  [[23,0,-54,0,28],0],[[4,0,-25,0,39,0,-31,0,6],0],
  [[15,0,-35,0,20],0],[[6],20],
  [[1,0,-10,0,20,0,-12,0,4],0],
  [[1,0,0,0,-6,0,8,0,-6],0],
  [[-9,0,15,0,-7,0,4],2],
  [[-2,0,-1,0,4,0,0,0,-4,0,2],10],
  [[-2,0,0,0,1,0,0,0,0,0,2],12],
  [[1,0,-7,0,14,0,-11,0,2],0],
  [[-3,0,6,0,-4,0,1],2],[[2,0,1,0,0,0,0,0,-1],14]
  ,[[1,0,0,0,4,0,-3],0],[[2],10],
  [[3,0,-14,0,28,0,-21,0,4],0],
  [[1,0,-1,0,0,0,-1],8],[[1,0,-2],10],
  [[1,0,-2,0,1,0,-1],4],[[-1,0,1],6],[[1],8],
  [[-1],8],[[],0],[[],0],
  [[-1,0,4,0,-8,0,8,0,-3],2],[[2,0,-2,0,2],6],
  [[],0],[[1,0,-4,0,4,0,-1],4],[[105],66],
  [[-50,0,55],0],[[-8,0,45,0,-36,0,16],0],
  [[1,0,0,0,0,0,-6,0,12,0,4,0,-4,0,-12,0,10,0,-8],2
  ],[[-11,0,36,0,-45,0,13],0],
  [[5,0,-16,0,10,0,0,0,0,0,0,0,1],30],[[6],22],
  [[3,0,-2,0,2],22],[[-3],34],
  [[-2,0,1,0,4,0,-2,0,-1,0,4,0,-1],8],
  [[-3,0,12,0,-15,0,5],0],
  [[1,0,2,0,-8,0,8,0,-2],2],
  [[4,0,-11,0,12,0,-7,0,1],2],[[],0],
  [[-6,0,26,0,-28,0,10],0],
  [[-1,0,9,0,-19,0,26,0,-14,0,1],0],
  [[1,0,0,0,1],22],[[1,0,-2,0,3,0,-2],2],
  [[-1,0,4,0,-14,0,18,0,-9,0,1],0],
  [[-3,0,1,0,0,0,1],4],[[-2,0,2,0,-1],4],
  [[],0],[[1],6],[[-1],18],[[],0],
  [[1,0,-4,0,6,0,-3],2],[[1,0,-2,0,2,0,-1],4],
  [[2,0,-7,0,10,0,-4,0,1],2],[[],0],[[],0]],
  [[[105],0],
  [[-10,0,0,0,0,0,0,0,0,0,45,0,-40,0,0,0,0,0,10],18
  ],
  [[-12,0,18,0,0,0,-8,0,0,0,18,0,0,0,0,0,0,0,1],6],
  [[28,0,-54,0,23],0],[[6,0,-31,0,39,0,-25,0,4],0],
  [[20,0,-35,0,15],0],[[6],28],
  [[4,0,-12,0,20,0,-10,0,1],0],
  [[-6,0,8,0,-6,0,0,0,1],4],
  [[4,0,-7,0,15,0,-9],0],
  [[2,0,-4,0,0,0,4,0,-1,0,-2],8],
  [[2,0,0,0,0,0,1,0,0,0,-2],10],
  [[2,0,-11,0,14,0,-7,0,1],0],
  [[1,0,-4,0,6,0,-3],0],[[-1,0,0,0,0,0,1,0,2],6],
  [[-3,0,4,0,0,0,1],2],[[2],14],
  [[4,0,-21,0,28,0,-14,0,3],0],
  [[-1,0,0,0,-1,0,1],6],[[-2,0,1],16],
  [[-1,0,1,0,-2,0,1],2],[[1,0,-1],4],[[1],4],
  [[-1],8],[[],0],[[],0],
  [[-3,0,8,0,-8,0,4,0,-1],2],[[2,0,-2,0,2],6],
  [[],0],[[-1,0,4,0,-4,0,1],2],[[-105],60],
  [[-55,0,50],0],[[-16,0,36,0,-45,0,8],0],
  [[8,0,-10,0,12,0,4,0,-4,0,-12,0,6,0,0,0,0,0,-1],6
  ],[[-13,0,45,0,-36,0,11],0],
  [[-1,0,0,0,0,0,0,0,-10,0,16,0,-5],20],[[-6],20],
  [[-2,0,2,0,-3],20],[[3],32],
  [[1,0,-4,0,1,0,2,0,-4,0,-1,0,2],6],
  [[-5,0,15,0,-12,0,3],0],
  [[2,0,-8,0,8,0,-2,0,-1],4],
  [[-1,0,7,0,-12,0,11,0,-4],0],[[],0],
  [[-10,0,28,0,-26,0,6],0],
  [[-1,0,14,0,-26,0,19,0,-9,0,1],0],
  [[-1,0,0,0,-1],24],[[2,0,-3,0,2,0,-1],2],
  [[-1,0,9,0,-18,0,14,0,-4,0,1],0],
  [[-1,0,0,0,-1,0,3],0],[[1,0,-2,0,2],2],
  [[],0],[[-1],4],[[1],16],[[],0],
  [[3,0,-6,0,4,0,-1],2],[[1,0,-2,0,2,0,-1],4],
  [[-1,0,4,0,-10,0,7,0,-2],0],[[],0],[[],0]],
  [[[120],0],
  [[45,0,0,0,-9,0,-10,0,15,0,0,0,5,0,-6],36],
  [[-12,0,0,0,36,0,-40,0,0,0,0,0,8],12],
  [[12,0,-56,0,52],0],[[1,0,-9,0,39,0,-51,0,20],0],
  [[5,0,-35,0,45],0],
  [[-8,0,3,0,0,0,2,0,0,0,-3],30],
  [[-2,0,16,0,-28,0,14],2],[[4,0,-12,0,0,0,8],6],
  [[-1,0,11,0,-26,0,12],2],
  [[3,0,-2,0,-5,0,16,0,-8,0,0,0,-1,0,1],14],
  [[-2,0,0,0,4,0,0,0,-2],18],
  [[-1,0,12,0,-24,0,13],2],[[4,0,-13,0,9],4],
  [[5,0,-4],20],[[3,0,-10,0,8],4],
  [[-1,0,-2,0,1],16],[[-5,0,25,0,-38,0,17],2],
  [[-1,0,-1],14],[[-1,0,0,0,2,0,-3],16],
  [[-1,0,5,0,-5,0,1],6],[[2,0,-2,0,1],8],
  [[-1,0,3,0,-3,0,1],6],[[2,0,-2],10],
  [[1,0,-1],10],[[1,0,-1],8],
  [[-6,0,14,0,-12,0,3],6],[[4,0,-3,0,-1,0,1],10],
  [[1,0,-1],8],[[-2,0,7,0,-7,0,2],6],[[120],84],
  [[-40,0,80],0],[[-4,0,24,0,-60,0,32],0],
  [[8,0,-4,0,-12,0,40,0,-24,0,0,0,-4,0,4],12],
  [[-3,0,27,0,-57,0,33],0],
  [[16,0,-5,0,0,0,5,0,0,0,-1],38],[[-6],28],
  [[-1,0,4,0,-3],28],[[],0],
  [[-5,0,0,0,14,0,-15,0,0,0,0,0,2],14],
  [[5,0,-23,0,22],2],[[8,0,-8,0,-4,0,4],8],
  [[-4,0,18,0,-21,0,7],4],[[],0],
  [[-1,0,15,0,-41,0,28],0],
  [[1,0,-11,0,32,0,-31,0,10],2],[[-3,0,2,0,-1],32],
  [[-1,0,6,0,-10,0,4],4],[[-7,0,21,0,-24,0,8],4],
  [[3,0,-7,0,2],6],[[3,0,-6,0,3],6],[[1],12],
  [[2,0,-4,0,2],6],[[],0],[[],0],
  [[-1,0,8,0,-12,0,5],4],[[2,0,-5,0,0,0,2],8],
  [[-2,0,12,0,-15,0,6],4],[[],0],[[],0]],
  [[[120],0],
  [[-6,0,5,0,0,0,15,0,-10,0,-9,0,0,0,45],10],
  [[8,0,0,0,0,0,-40,0,36,0,0,0,-12],0],
  [[52,0,-56,0,12],0],[[20,0,-51,0,39,0,-9,0,1],0],
  [[45,0,-35,0,5],0],
  [[-3,0,0,0,2,0,0,0,3,0,-8],8],
  [[14,0,-28,0,16,0,-2],0],[[8,0,0,0,-12,0,4],0],
  [[12,0,-26,0,11,0,-1],0],
  [[1,0,-1,0,0,0,-8,0,16,0,-5,0,-2,0,3],0],
  [[-2,0,0,0,4,0,0,0,-2],6],
  [[13,0,-24,0,12,0,-1],0],[[9,0,-13,0,4],0],
  [[-4,0,5],6],[[8,0,-10,0,3],0],
  [[1,0,-2,0,-1],4],[[17,0,-38,0,25,0,-5],0],
  [[-1,0,-1],4],[[-3,0,2,0,0,0,-1],6],
  [[1,0,-5,0,5,0,-1],0],[[1,0,-2,0,2],0],
  [[1,0,-3,0,3,0,-1],0],[[-2,0,2],4],
  [[-1,0,1],4],[[-1,0,1],2],
  [[3,0,-12,0,14,0,-6],0],[[1,0,-1,0,-3,0,4],0],
  [[-1,0,1],2],[[2,0,-7,0,7,0,-2],0],[[-120],42],
  [[-80,0,40],0],[[-32,0,60,0,-24,0,4],0],
  [[-4,0,4,0,0,0,24,0,-40,0,12,0,4,0,-8],0],
  [[-33,0,57,0,-27,0,3],0],
  [[1,0,0,0,-5,0,0,0,5,0,-16],14],[[6],14],
  [[3,0,-4,0,1],14],[[],0],
  [[-2,0,0,0,0,0,15,0,-14,0,0,0,5],0],
  [[-22,0,23,0,-5],0],[[-4,0,4,0,8,0,-8],0],
  [[-7,0,21,0,-18,0,4],0],[[],0],
  [[-28,0,41,0,-15,0,1],0],
  [[-10,0,31,0,-32,0,11,0,-1],0],[[1,0,-2,0,3],14],
  [[-4,0,10,0,-6,0,1],0],[[-8,0,24,0,-21,0,7],0],
  [[-2,0,7,0,-3],0],[[-3,0,6,0,-3],0],[[-1],6],
  [[-2,0,4,0,-2],0],[[],0],[[],0],
  [[-5,0,12,0,-8,0,1],0],[[-2,0,0,0,5,0,-2],0],
  [[-6,0,15,0,-12,0,2],0],[[],0],[[],0]],
  [[[168],0],
  [[30,0,0,0,5,0,0,0,-15,0,0,0,15,0,0,0,5],32],
  [[-20,0,0,0,54,0,-32,0,0,0,0,0,6],12],
  [[24,0,-80,0,64],0],[[2,0,-24,0,60,0,-56,0,26],0]
  ,[[10,0,-54,0,50],0],
  [[12,0,-8,0,0,0,0,0,2],28],
  [[1,0,-6,0,23,0,-34,0,13],0],
  [[12,0,-18,0,0,0,6],6],[[-4,0,18,0,-26,0,12],2],
  [[5,0,-10,0,-6,0,15,0,-5,0,0,0,0,0,1],14],
  [[2,0,-2,0,-2,0,2],16],[[-4,0,18,0,-26,0,12],2],
  [[6,0,-14,0,6],4],[[-8,0,0,0,6],16],
  [[4,0,-8,0,6],4],[[4,0,0,0,-2],14],
  [[1,0,-13,0,38,0,-43,0,19],0],[[2,0,0,0,-1],12],
  [[1,0,-4,0,1,0,2,0,-1],14],
  [[-2,0,3,0,-3,0,1],6],[[1,0,-1],8],
  [[-1,0,1,0,-1,0,1],6],[[2,0,-2],10],
  [[1,0,-1],10],[[],0],
  [[3,0,-10,0,13,0,-10,0,4],4],
  [[-2,0,5,0,-4,0,0,0,1],8],[[],0],
  [[1,0,-3,0,6,0,-5,0,2],4],[[168],78],
  [[-64,0,104],0],[[-8,0,48,0,-72,0,40],0],
  [[4,0,-16,0,-18,0,52,0,-16,0,0,0,-2,0,4],12],
  [[-8,0,48,0,-72,0,40],0],
  [[5,0,0,0,5,0,0,0,-5,0,0,0,1],34],[[6],26],
  [[1,0,-6,0,2],26],[[],0],
  [[3,0,-12,0,0,0,17,0,-9,0,0,0,0,0,1],12],
  [[10,0,-30,0,20],2],[[-4,0,14,0,-12,0,-2,0,4],6],
  [[1,0,-11,0,21,0,-19,0,8],2],[[-2],18],
  [[-4,0,26,0,-54,0,30],0],
  [[5,0,-25,0,40,0,-31,0,13],2],[[4,0,-2],30],
  [[-2,0,6,0,-6,0,4],4],
  [[3,0,-14,0,27,0,-24,0,9],2],[[3,0,-5,0,1],6],
  [[3,0,-5,0,1],6],[[],0],[[1,0,-2,0,1],6],
  [[],0],[[],0],[[-3,0,9,0,-10,0,4],4],
  [[5,0,-6,0,0,0,1],8],
  [[1,0,-5,0,14,0,-15,0,5],2],[[],0],[[1],16]],
  [[[168],0],
  [[5,0,0,0,15,0,0,0,-15,0,0,0,5,0,0,0,30],12],
  [[6,0,0,0,0,0,-32,0,54,0,0,0,-20],0],
  [[64,0,-80,0,24],0],[[26,0,-56,0,60,0,-24,0,2],0]
  ,[[50,0,-54,0,10],0],
  [[2,0,0,0,0,0,-8,0,12],12],
  [[13,0,-34,0,23,0,-6,0,1],0],
  [[6,0,0,0,-18,0,12],0],[[12,0,-26,0,18,0,-4],0],
  [[1,0,0,0,0,0,-5,0,15,0,-6,0,-10,0,5],0],
  [[2,0,-2,0,-2,0,2],10],[[12,0,-26,0,18,0,-4],0],
  [[6,0,-14,0,6],0],[[6,0,0,0,-8],8],
  [[6,0,-8,0,4],0],[[-2,0,0,0,4],6],
  [[19,0,-43,0,38,0,-13,0,1],0],[[-1,0,0,0,2],4],
  [[-1,0,2,0,1,0,-4,0,1],6],[[1,0,-3,0,3,0,-2],0]
  ,[[-1,0,1],2],[[1,0,-1,0,1,0,-1],0],
  [[-2,0,2],4],[[-1,0,1],4],[[],0],
  [[4,0,-10,0,13,0,-10,0,3],0],
  [[1,0,0,0,-4,0,5,0,-2],0],[[],0],
  [[2,0,-5,0,6,0,-3,0,1],0],[[-168],48],
  [[-104,0,64],0],[[-40,0,72,0,-48,0,8],0],
  [[-4,0,2,0,0,0,16,0,-52,0,18,0,16,0,-4],0],
  [[-40,0,72,0,-48,0,8],0],
  [[-1,0,0,0,5,0,0,0,-5,0,0,0,-5],16],[[-6],16],
  [[-2,0,6,0,-1],16],[[],0],
  [[-1,0,0,0,0,0,9,0,-17,0,0,0,12,0,-3],0],
  [[-20,0,30,0,-10],0],[[-4,0,2,0,12,0,-14,0,4],0],
  [[-8,0,19,0,-21,0,11,0,-1],0],[[2],12],
  [[-30,0,54,0,-26,0,4],0],
  [[-13,0,31,0,-40,0,25,0,-5],0],[[2,0,-4],18],
  [[-4,0,6,0,-6,0,2],0],
  [[-9,0,24,0,-27,0,14,0,-3],0],[[-1,0,5,0,-3],0],
  [[-1,0,5,0,-3],0],[[],0],[[-1,0,2,0,-1],0],
  [[],0],[[],0],[[-4,0,10,0,-9,0,3],0],
  [[-1,0,0,0,6,0,-5],0],
  [[-5,0,15,0,-14,0,5,0,-1],0],[[],0],[[-1],10]]
  ,
  [[[189],0],[[45,0,-20,0,45,0,0,0,-40,0,0,0,-9],28],
  [[-12,0,9,0,0,0,6,0,0,0,27,0,-36,0,0,0,0,0,3],6],
  [[34,0,-100,0,55],0],
  [[3,0,-36,0,78,0,-60,0,12],0],
  [[24,0,-60,0,45],0],[[2,0,0,0,0,0,-8,0,6],24],
  [[1,0,-14,0,37,0,-30,0,6],0],
  [[-3,0,18,0,-9,0,0,0,3],4],
  [[1,0,-10,0,28,0,-24,0,6],0],
  [[1,0,-1,0,3,0,1,0,1,0,-7,0,6,0,-3],8],
  [[-2,0,0,0,1,0,2],16],
  [[1,0,-10,0,28,0,-24,0,6],0],
  [[-4,0,12,0,-12,0,3],2],
  [[-1,0,0,0,0,0,-2,0,-1,0,1],10],
  [[-3,0,6,0,-9,0,3],2],[[-2,0,0,0,2],12],
  [[2,0,-22,0,54,0,-42,0,9],0],[[-2,0,2],10],
  [[-1,0,0,0,0,0,0,0,1],12],[[1,0,-5,0,5,0,-1],4]
  ,[[-2,0,2],6],[[-2,0,2,0,-1],6],
  [[-2,0,1],8],[[-1,0,1],8],[[1],8],
  [[7,0,-18,0,17,0,-5],4],[[1,0,-5,0,5],6],
  [[],0],[[2,0,-9,0,8,0,-2],4],[[189],70],
  [[-84,0,105],0],[[-12,0,66,0,-84,0,27],0],
  [[4,0,-8,0,9,0,-8,0,-2,0,-18,0,29,0,-16,0,0,0,-2,
  0,1],6],[[-12,0,66,0,-84,0,27],0],
  [[9],30],[[],0],[[],0],[[6,0,3],36],
  [[-2,0,0,0,-1,0,2,0,0,0,9,0,-7],8],
  [[-4,0,20,0,-30,0,15],0],
  [[-11,0,16,0,-3,0,-2,0,1],6],
  [[4,0,-19,0,29,0,-15,0,2],2],[[-1],14],
  [[-8,0,42,0,-58,0,21],0],
  [[9,0,-39,0,51,0,-27,0,3],2],[[],0],
  [[1,0,-4,0,9,0,-6,0,1],2],
  [[5,0,-26,0,37,0,-18,0,2],2],[[-3,0,6,0,-3],4],
  [[-3,0,6,0,-3],4],[[],0],[[-1,0,2,0,-2],4],
  [[-1],20],[[],0],[[1,0,-8,0,14,0,-7,0,1],2],
  [[-3,0,6,0,-2],6],[[2,0,-13,0,21,0,-10,0,1],2],
  [[],0],[[-1],14]],
  [[[189],0],[[-9,0,0,0,-40,0,0,0,45,0,-20,0,45],20],
  [[3,0,0,0,0,0,-36,0,27,0,0,0,6,0,0,0,9,0,-12],0],
  [[55,0,-100,0,34],0],
  [[12,0,-60,0,78,0,-36,0,3],0],
  [[45,0,-60,0,24],0],[[6,0,-8,0,0,0,0,0,2],16],
  [[6,0,-30,0,37,0,-14,0,1],0],
  [[3,0,0,0,-9,0,18,0,-3],0],
  [[6,0,-24,0,28,0,-10,0,1],0],
  [[-3,0,6,0,-7,0,1,0,1,0,3,0,-1,0,1],6],
  [[2,0,1,0,0,0,-2],10],
  [[6,0,-24,0,28,0,-10,0,1],0],
  [[3,0,-12,0,12,0,-4],0],
  [[1,0,-1,0,-2,0,0,0,0,0,-1],8],
  [[3,0,-9,0,6,0,-3],0],[[2,0,0,0,-2],8],
  [[9,0,-42,0,54,0,-22,0,2],0],[[2,0,-2],8],
  [[1,0,0,0,0,0,0,0,-1],8],[[-1,0,5,0,-5,0,1],2],
  [[2,0,-2],4],[[-1,0,2,0,-2],2],[[1,0,-2],6],
  [[1,0,-1],6],[[1],4],[[-5,0,17,0,-18,0,7],2],
  [[5,0,-5,0,1],6],[[],0],[[-2,0,8,0,-9,0,2],2]
  ,[[-189],56],[[-105,0,84],0],
  [[-27,0,84,0,-66,0,12],0],
  [[-1,0,2,0,0,0,16,0,-29,0,18,0,2,0,8,0,-9,0,8,0,
  -4],0],[[-27,0,84,0,-66,0,12],0],
  [[-9],32],[[],0],[[],0],[[-3,0,-6],28],
  [[7,0,-9,0,0,0,-2,0,1,0,0,0,2],6],
  [[-15,0,30,0,-20,0,4],0],
  [[-1,0,2,0,3,0,-16,0,11],0],
  [[-2,0,15,0,-29,0,19,0,-4],0],[[1],16],
  [[-21,0,58,0,-42,0,8],0],
  [[-3,0,27,0,-51,0,39,0,-9],0],[[],0],
  [[-1,0,6,0,-9,0,4,0,-1],0],
  [[-2,0,18,0,-37,0,26,0,-5],0],[[3,0,-6,0,3],2],
  [[3,0,-6,0,3],2],[[],0],[[2,0,-2,0,1],2],
  [[1],14],[[],0],[[-1,0,7,0,-14,0,8,0,-1],0],
  [[2,0,-6,0,3],4],[[-1,0,10,0,-21,0,13,0,-2],0],
  [[],0],[[1],12]],
  [[[189],0],[[-6,0,0,0,0,0,15,0,-20,0,-15,0,0,0,5,0,
  -30],10],
  [[6,0,0,0,0,0,-48,0,63,0,0,0,-24],0],
  [[76,0,-88,0,25],0],[[30,0,-72,0,60,0,-24,0,3],0]
  ,[[60,0,-60,0,9],0],[[2,0,0,0,0,0,-8,0,6],12],
  [[19,0,-38,0,25,0,-6],0],[[6,0,0,0,-21,0,12],0],
  [[16,0,-31,0,19,0,-3],0],
  [[1,0,0,0,0,0,-9,0,18,0,-9,0,-8,0,8],0],
  [[-2,0,-1,0,6,0,-2,0,-4],6],
  [[16,0,-31,0,19,0,-3],0],[[9,0,-16,0,6],0],
  [[-5,0,4,0,0,0,-5,0,3],6],[[6,0,-12,0,3],0],
  [[-2,0,0,0,2],6],[[24,0,-52,0,40,0,-12,0,1],0],
  [[-2,0,2],6],[[-1,0,3,0,0,0,-3,0,1],6],
  [[2,0,-5,0,4,0,-1],0],[[1,0,-2,0,1],0],
  [[1,0,-2,0,2],0],[[-1,0,2],4],[[-1,0,1],4],
  [[-1],2],[[5,0,-15,0,17,0,-8,0,2],0],
  [[1,0,0,0,-4,0,6,0,-2],0],[[],0],
  [[3,0,-8,0,7,0,-3],0],[[189],46],
  [[-120,0,69],0],[[-48,0,84,0,-48,0,9],0],
  [[-4,0,2,0,0,0,32,0,-52,0,27,0,16,0,-8],0],
  [[-48,0,84,0,-48,0,9],0],[[9],22],[[],0],
  [[],0],[[-3],26],
  [[-1,0,0,0,0,0,14,0,-22,0,0,0,13,0,-3],0],
  [[-25,0,35,0,-9],0],[[-4,0,2,0,12,0,-17,0,4],0],
  [[-10,0,26,0,-23,0,9,0,-1],0],[[-1],14],
  [[-38,0,60,0,-28,0,3],0],
  [[-15,0,42,0,-45,0,21,0,-6],0],[[],0],
  [[-4,0,10,0,-6,0,1],0],
  [[-12,0,31,0,-30,0,13,0,-2],0],[[-3,0,6,0,-3],0],
  [[-3,0,6,0,-3],0],[[],0],[[-1,0,3,0,-1],0],
  [[1],14],[[],0],[[-6,0,13,0,-10,0,2],0],
  [[-1,0,0,0,7,0,-5],0],[[-8,0,19,0,-15,0,5],0],
  [[],0],[[-1],10]],
  [[[189],0],[[-30,0,5,0,0,0,-15,0,-20,0,15,0,0,0,0,
  0,-6],34],
  [[-24,0,0,0,63,0,-48,0,0,0,0,0,6],12],
  [[25,0,-88,0,76],0],[[3,0,-24,0,60,0,-72,0,30],0]
  ,[[9,0,-60,0,60],0],[[6,0,-8,0,0,0,0,0,2],28],
  [[-6,0,25,0,-38,0,19],2],[[12,0,-21,0,0,0,6],6],
  [[-3,0,19,0,-31,0,16],2],
  [[8,0,-8,0,-9,0,18,0,-9,0,0,0,0,0,1],14],
  [[-4,0,-2,0,6,0,-1,0,-2],18],
  [[-3,0,19,0,-31,0,16],2],[[6,0,-16,0,9],4],
  [[3,0,-5,0,0,0,4,0,-5],14],[[3,0,-12,0,6],4],
  [[2,0,0,0,-2],14],[[1,0,-12,0,40,0,-52,0,24],0],
  [[2,0,-2],12],[[1,0,-3,0,0,0,3,0,-1],14],
  [[-1,0,4,0,-5,0,2],6],[[1,0,-2,0,1],8],
  [[2,0,-2,0,1],8],[[2,0,-1],10],[[1,0,-1],10],
  [[-1],10],[[2,0,-8,0,17,0,-15,0,5],4],
  [[-2,0,6,0,-4,0,0,0,1],8],[[],0],
  [[-3,0,7,0,-8,0,3],6],[[-189],80],
  [[-69,0,120],0],[[-9,0,48,0,-84,0,48],0],
  [[8,0,-16,0,-27,0,52,0,-32,0,0,0,-2,0,4],12],
  [[-9,0,48,0,-84,0,48],0],[[-9],40],[[],0],
  [[],0],[[3],40],
  [[3,0,-13,0,0,0,22,0,-14,0,0,0,0,0,1],12],
  [[9,0,-35,0,25],2],[[-4,0,17,0,-12,0,-2,0,4],6],
  [[1,0,-9,0,23,0,-26,0,10],2],[[1],16],
  [[-3,0,28,0,-60,0,38],0],
  [[6,0,-21,0,45,0,-42,0,15],2],[[],0],
  [[-1,0,6,0,-10,0,4],4],
  [[2,0,-13,0,30,0,-31,0,12],2],[[3,0,-6,0,3],6],
  [[3,0,-6,0,3],6],[[],0],[[1,0,-3,0,1],6],
  [[-1],20],[[],0],[[-2,0,10,0,-13,0,6],4],
  [[5,0,-7,0,0,0,1],8],[[-5,0,15,0,-19,0,8],4],
  [[],0],[[1],16]],
  [[[189],0],[[5,0,0,0,0,0,-10,0,-9,0,0,0,15,0,0,0,
  0,0,-40],12],
  [[6,0,0,0,0,0,-36,0,54,0,0,0,-12,0,0,0,9],0],
  [[67,0,-94,0,28],0],[[21,0,-69,0,69,0,-27,0,3],0]
  ,[[54,0,-60,0,15],0],[[2,0,0,0,0,0,-8,0,6],12]
  ,[[12,0,-36,0,31,0,-8,0,1],0],
  [[6,0,0,0,-18,0,12,0,-3],0],
  [[9,0,-33,0,22,0,-4,0,1],0],
  [[-1,0,0,0,-5,0,13,0,-8,0,-3,0,4,0,0,0,-1],2],
  [[1,0,4,0,-2,0,-2],8],[[11,0,-29,0,23,0,-6],0],
  [[6,0,-15,0,9,0,-1],0],
  [[-1,0,3,0,0,0,-2,0,2,0,1],6],[[6,0,-9,0,6],0],
  [[-2,0,0,0,2],6],[[17,0,-48,0,47,0,-16,0,1],0],
  [[-1,0,-1,0,3,0,-1],4],[[-1,0,2,0,1,0,-2],6],
  [[-3,0,6,0,-3],2],[[-1,0,2,0,-1],2],
  [[-2,0,2,0,-1],2],[[-1,0,2],4],[[-1,0,1],4],
  [[1],4],[[2,0,-10,0,18,0,-13,0,4],0],
  [[-1,0,-3,0,6,0,-3],2],[[],0],
  [[1,0,-5,0,8,0,-6,0,1],0],[[189],50],
  [[-114,0,75],0],[[-36,0,93,0,-48,0,12],0],
  [[-2,0,4,0,0,0,20,0,-46,0,24,0,8,0,-4,0,-6,0,3],0
  ],[[-39,0,84,0,-57,0,9],0],[[9],30],[[],0],
  [[],0],[[-3],26],
  [[-1,0,0,0,0,0,9,0,-17,0,1,0,6,0,-2,0,-1],0],
  [[-21,0,33,0,-14,0,1],0],
  [[-2,0,4,0,10,0,-16,0,6,0,-1],0],
  [[-5,0,22,0,-28,0,12,0,-2],0],[[-1],10],
  [[-30,0,61,0,-33,0,5],0],
  [[-9,0,36,0,-48,0,30,0,-6],0],[[],0],
  [[-2,0,9,0,-8,0,2],0],
  [[-7,0,25,0,-34,0,19,0,-3],0],[[6,0,-6],2],
  [[-1,0,5,0,-5,0,1],0],[[],0],
  [[-1,0,2,0,-2],0],[[1],14],[[],0],
  [[-3,0,11,0,-12,0,5],0],
  [[-1,0,0,0,6,0,-5,0,1],0],
  [[-4,0,15,0,-19,0,8,0,-1],0],[[],0],[[-1],10]]
  ,
  [[[189],0],[[-40,0,0,0,0,0,15,0,0,0,-9,0,-10,0,0,0,
  0,0,5],30],
  [[9,0,0,0,-12,0,0,0,54,0,-36,0,0,0,0,0,6],8],
  [[28,0,-94,0,67],0],[[3,0,-27,0,69,0,-69,0,21],0]
  ,[[15,0,-60,0,54],0],[[6,0,-8,0,0,0,0,0,2],28]
  ,[[1,0,-8,0,31,0,-36,0,12],0],
  [[-3,0,12,0,-18,0,0,0,6],4],
  [[1,0,-4,0,22,0,-33,0,9],0],
  [[-1,0,0,0,4,0,-3,0,-8,0,13,0,-5,0,0,0,-1],10],
  [[-2,0,-2,0,4,0,1],18],[[-6,0,23,0,-29,0,11],2],
  [[-1,0,9,0,-15,0,6],2],
  [[1,0,2,0,-2,0,0,0,3,0,-1],12],
  [[6,0,-9,0,6],4],[[2,0,0,0,-2],14],
  [[1,0,-16,0,47,0,-48,0,17],0],
  [[-1,0,3,0,-1,0,-1],10],[[-2,0,1,0,2,0,-1],16],
  [[-3,0,6,0,-3],6],[[-1,0,2,0,-1],6],
  [[-1,0,2,0,-2],6],[[2,0,-1],10],[[1,0,-1],10],
  [[1],8],[[4,0,-13,0,18,0,-10,0,2],4],
  [[-3,0,6,0,-3,0,-1],8],[[],0],
  [[1,0,-6,0,8,0,-5,0,1],4],[[-189],76],
  [[-75,0,114],0],[[-12,0,48,0,-93,0,36],0],
  [[-3,0,6,0,4,0,-8,0,-24,0,46,0,-20,0,0,0,-4,0,2],
  8],[[-9,0,57,0,-84,0,39],0],[[-9],32],
  [[],0],[[],0],[[3],40],
  [[1,0,2,0,-6,0,-1,0,17,0,-9,0,0,0,0,0,1],10],
  [[-1,0,14,0,-33,0,21],0],
  [[1,0,-6,0,16,0,-10,0,-4,0,2],4],
  [[2,0,-12,0,28,0,-22,0,5],2],[[1],20],
  [[-5,0,33,0,-61,0,30],0],
  [[6,0,-30,0,48,0,-36,0,9],2],[[],0],
  [[-2,0,8,0,-9,0,2],4],
  [[3,0,-19,0,34,0,-25,0,7],2],[[6,0,-6],6],
  [[-1,0,5,0,-5,0,1],4],[[],0],
  [[2,0,-2,0,1],6],[[-1],20],[[],0],
  [[-5,0,12,0,-11,0,3],4],
  [[-1,0,5,0,-6,0,0,0,1],6],
  [[1,0,-8,0,19,0,-15,0,4],2],[[],0],[[1],16]],
  [[[210],0],
  [[45,0,0,0,15,0,0,0,-9,0,-10,0,15,0,0,0,0,0,-6],
  32],
  [[9,0,0,0,-12,0,0,0,54,0,-56,0,0,0,0,0,7],8],
  [[28,0,-104,0,78],0],
  [[2,0,-27,0,75,0,-81,0,25],0],
  [[15,0,-65,0,65],0],[[-8,0,9,0,0,0,2],30],
  [[-8,0,34,0,-42,0,16],2],
  [[-3,0,12,0,-18,0,0,0,7],4],
  [[-5,0,26,0,-34,0,15],2],
  [[1,0,4,0,-2,0,-10,0,18,0,-8,0,0,0,-1],12],
  [[1,0,-2,0,-2,0,4,0,-1,0,-2],16],
  [[-5,0,25,0,-36,0,14],2],[[-1,0,10,0,-18,0,9],2],
  [[1,0,0,0,-2,0,0,0,4,0,-4],12],
  [[6,0,-14,0,7],4],[[1,0,-2],16],
  [[1,0,-14,0,51,0,-59,0,20],0],[[3,0,-1],12],
  [[3,0,-1],20],[[-3,0,7,0,-5,0,1],6],
  [[-1,0,3,0,-2],6],[[-1,0,4,0,-3],6],
  [[-1,0,2,0,-1],8],[[1,0,-1],10],[[1,0,-1],8],
  [[2,0,-14,0,23,0,-14,0,2],4],
  [[-3,0,6,0,-3,0,-1],8],[[1],8],
  [[-6,0,12,0,-7,0,1],6],[[210],78],
  [[-80,0,130],0],[[-8,0,60,0,-96,0,46],0],
  [[9,0,4,0,-8,0,-24,0,54,0,-32,0,0,0,-4,0,3],10],
  [[-9,0,57,0,-99,0,45],0],[[10,0,0,0,5],34],
  [[3],26],[[-2,0,2],28],[[-2],42],
  [[1,0,2,0,-4,0,-1,0,19,0,-16,0,0,0,0,0,1],10],
  [[-1,0,14,0,-38,0,27],0],
  [[-7,0,16,0,-10,0,-4,0,3],6],
  [[1,0,-13,0,31,0,-28,0,7],2],[[],0],
  [[-4,0,35,0,-69,0,37],0],
  [[5,0,-28,0,57,0,-45,0,10],2],[[-2,0,1],32],
  [[-2,0,10,0,-12,0,3],4],
  [[2,0,-17,0,41,0,-32,0,8],2],
  [[-1,0,6,0,-6,0,3],4],[[-1,0,6,0,-7,0,2],4],
  [[],0],[[3,0,-4,0,1],6],[[],0],[[],0],
  [[-4,0,15,0,-15,0,4],4],
  [[-1,0,5,0,-6,0,0,0,1],6],
  [[-8,0,22,0,-20,0,5],4],[[1],14],[[],0]],
  [[[210],0],
  [[-6,0,0,0,0,0,15,0,-10,0,-9,0,0,0,15,0,0,0,45],
  10],
  [[7,0,0,0,0,0,-56,0,54,0,0,0,-12,0,0,0,9],0],
  [[78,0,-104,0,28],0],
  [[25,0,-81,0,75,0,-27,0,2],0],
  [[65,0,-65,0,15],0],[[2,0,0,0,9,0,-8],12],
  [[16,0,-42,0,34,0,-8],0],
  [[7,0,0,0,-18,0,12,0,-3],0],
  [[15,0,-34,0,26,0,-5],0],
  [[-1,0,0,0,-8,0,18,0,-10,0,-2,0,4,0,1],2],
  [[-2,0,-1,0,4,0,-2,0,-2,0,1],6],
  [[14,0,-36,0,25,0,-5],0],[[9,0,-18,0,10,0,-1],0],
  [[-4,0,4,0,0,0,-2,0,0,0,1],6],
  [[7,0,-14,0,6],0],[[-2,0,1],6],
  [[20,0,-59,0,51,0,-14,0,1],0],[[-1,0,3],6],
  [[-1,0,3],6],[[1,0,-5,0,7,0,-3],0],
  [[-2,0,3,0,-1],2],[[-3,0,4,0,-1],2],
  [[-1,0,2,0,-1],4],[[-1,0,1],4],[[-1,0,1],2],
  [[2,0,-14,0,23,0,-14,0,2],0],
  [[-1,0,-3,0,6,0,-3],2],[[1],4],
  [[1,0,-7,0,12,0,-6],0],[[-210],48],
  [[-130,0,80],0],[[-46,0,96,0,-60,0,8],0],
  [[-3,0,4,0,0,0,32,0,-54,0,24,0,8,0,-4,0,-9],0],
  [[-45,0,99,0,-57,0,9],0],[[-5,0,0,0,-10],24],
  [[-3],16],[[-2,0,2],16],[[2],24],
  [[-1,0,0,0,0,0,16,0,-19,0,1,0,4,0,-2,0,-1],0],
  [[-27,0,38,0,-14,0,1],0],
  [[-3,0,4,0,10,0,-16,0,7],0],
  [[-7,0,28,0,-31,0,13,0,-1],0],[[],0],
  [[-37,0,69,0,-35,0,4],0],
  [[-10,0,45,0,-57,0,28,0,-5],0],[[-1,0,2],16],
  [[-3,0,12,0,-10,0,2],0],
  [[-8,0,32,0,-41,0,17,0,-2],0],
  [[-3,0,6,0,-6,0,1],0],[[-2,0,7,0,-6,0,1],0],
  [[],0],[[-1,0,4,0,-3],0],[[],0],[[],0],
  [[-4,0,15,0,-15,0,4],0],
  [[-1,0,0,0,6,0,-5,0,1],0],
  [[-5,0,20,0,-22,0,8],0],[[-1],8],[[],0]],
  [[[210],0],[[-30,0,30,0,-40,0,30,0,-30,0,50],26],
  [[-4,0,18,0,0,0,-52,0,0,0,36,0,-12],6],
  [[50,0,-100,0,60],0],
  [[15,0,-46,0,72,0,-58,0,19],0],
  [[25,0,-75,0,35],0],[[-12,0,0,0,6],24],
  [[5,0,-18,0,31,0,-24,0,9],0],[[-6,0,24,0,-12],4],
  [[3,0,-11,0,22,0,-20,0,4],0],
  [[1,0,0,0,-11,0,19,0,-13,0,-1,0,4,0,-1],8],
  [[-2,0,4,0,-2,0,-2],14],
  [[2,0,-13,0,22,0,-18,0,5],0],
  [[-3,0,8,0,-6,0,1],2],
  [[-3,0,8,0,-5,0,0,0,1],12],[[-1,0,5,0,-3],2],
  [[-4,0,2],12],[[8,0,-30,0,47,0,-37,0,13],0],
  [[-1,0,2],10],[[-1,0,5,0,-3],12],
  [[-1,0,1,0,-1],6],[[],0],[[],0],[[],0],
  [[],0],[[],0],
  [[1,0,-3,0,7,0,-10,0,10,0,-6,0,2],0],
  [[2,0,-3,0,3,0,-1],6],[[],0],
  [[-1,0,2,0,-3,0,3,0,-2,0,1],2],[[210],66],
  [[-100,0,110],0],[[-28,0,66,0,-84,0,32],0],
  [[4,0,-12,0,6,0,28,0,-24,0,-12,0,28,0,-8],6],
  [[-26,0,72,0,-78,0,34],0],
  [[-5,0,0,0,-15,0,0,0,5],30],[[-6],22],
  [[-2,0,6,0,-1],22],[[6],34],
  [[-1,0,0,0,19,0,-24,0,0,0,5,0,-1],8],
  [[-3,0,22,0,-28,0,7],0],[[4,0,-14,0,16,0,-8],4],
  [[-2,0,7,0,-16,0,19,0,-13,0,3],0],[[],0],
  [[-14,0,47,0,-53,0,21],0],
  [[-5,0,19,0,-36,0,41,0,-26,0,8],0],[[2,0,-4],24],
  [[1,0,-2,0,4,0,-2],2],
  [[-3,0,12,0,-23,0,26,0,-17,0,6],0],[[2,0,-1],6],
  [[-1,0,1,0,-1],4],[[],0],[[],0],[[],0],
  [[],0],[[2,0,-5,0,6,0,-4,0,1],2],
  [[-3,0,5,0,-1],6],
  [[-1,0,5,0,-10,0,12,0,-8,0,3],0],[[],0],
  [[],0]],
  [[[210],0],[[50,0,-30,0,30,0,-40,0,30,0,-30],24],
  [[-12,0,36,0,0,0,-52,0,0,0,18,0,-4],6],
  [[60,0,-100,0,50],0],
  [[19,0,-58,0,72,0,-46,0,15],0],
  [[35,0,-75,0,25],0],[[6,0,0,0,-12],20],
  [[9,0,-24,0,31,0,-18,0,5],0],[[-12,0,24,0,-6],4],
  [[4,0,-20,0,22,0,-11,0,3],0],
  [[-1,0,4,0,-1,0,-13,0,19,0,-11,0,0,0,1],6],
  [[-2,0,-2,0,4,0,-2],12],
  [[5,0,-18,0,22,0,-13,0,2],0],
  [[1,0,-6,0,8,0,-3],0],[[1,0,0,0,-5,0,8,0,-3],8]
  ,[[-3,0,5,0,-1],2],[[2,0,-4],10],
  [[13,0,-37,0,47,0,-30,0,8],0],[[2,0,-1],8],
  [[-3,0,5,0,-1],12],[[-1,0,1,0,-1],2],[[],0],
  [[],0],[[],0],[[],0],[[],0],
  [[2,0,-6,0,10,0,-10,0,7,0,-3,0,1],0],
  [[-1,0,3,0,-3,0,2],4],[[],0],
  [[1,0,-2,0,3,0,-3,0,2,0,-1],0],[[-210],60],
  [[-110,0,100],0],[[-32,0,84,0,-66,0,28],0],
  [[8,0,-28,0,12,0,24,0,-28,0,-6,0,12,0,-4],6],
  [[-34,0,78,0,-72,0,26],0],
  [[-5,0,0,0,15,0,0,0,5],24],[[6],20],
  [[1,0,-6,0,2],20],[[-6],32],
  [[1,0,-5,0,0,0,24,0,-19,0,0,0,1],6],
  [[-7,0,28,0,-22,0,3],0],[[8,0,-16,0,14,0,-4],4],
  [[-3,0,13,0,-19,0,16,0,-7,0,2],0],[[],0],
  [[-21,0,53,0,-47,0,14],0],
  [[-8,0,26,0,-41,0,36,0,-19,0,5],0],[[4,0,-2],24],
  [[2,0,-4,0,2,0,-1],2],
  [[-6,0,17,0,-26,0,23,0,-12,0,3],0],[[1,0,-2],2],
  [[1,0,-1,0,1],2],[[],0],[[],0],[[],0],
  [[],0],[[-1,0,4,0,-6,0,5,0,-2],0],
  [[1,0,-5,0,3],4],
  [[-3,0,8,0,-12,0,10,0,-5,0,1],0],[[],0],
  [[],0]],
  [[[216],0],[[-10,0,0,0,0,0,10,0,-30,0,0,0,-24,0,30],
  18],[[-24,0,54,0,0,0,-24,0,0,0,18],6],
  [[68,0,-104,0,44],0],
  [[21,0,-69,0,75,0,-39,0,12],0],
  [[45,0,-75,0,21],0],[[-3,0,0,0,6,0,0,0,-3],16],
  [[12,0,-30,0,32,0,-16,0,2],0],
  [[-18,0,24,0,-6],4],[[6,0,-27,0,23,0,-8,0,2],0],
  [[-2,0,9,0,-5,0,-6,0,13,0,-5,0,-1,0,1],6],
  [[2,0,-2,0,-2,0,2],10],
  [[8,0,-23,0,24,0,-10,0,1],0],
  [[3,0,-9,0,9,0,-2],0],
  [[-1,0,2,0,-1,0,-4,0,5,0,-3,0,-1],6],
  [[-6,0,3],2],[[1,0,2,0,-3],8],
  [[16,0,-45,0,49,0,-26,0,5],0],[[-1,0,4,0,-3],6],
  [[1,0,0,0,-3,0,3,0,-1],8],[[-2,0,3,0,-1],2],
  [[-1],2],[[1,0,-1],6],[[],0],[[],0],
  [[1],6],[[2,0,-9,0,14,0,-11,0,5,0,-2],0],
  [[-2,0,5,0,-4,0,2],4],[[-1,0,1],4],
  [[1,0,-4,0,5,0,-3,0,2],0],[[216],56],
  [[-120,0,96],0],[[-36,0,96,0,-60,0,24],0],
  [[16,0,-38,0,24,0,12,0,-12,0,-6,0,12],6],
  [[-39,0,87,0,-69,0,21],0],[[-9],32],[[],0],
  [[],0],[[],0],
  [[3,0,-13,0,1,0,15,0,-10,0,-1,0,1],6],
  [[-12,0,33,0,-19,0,2],0],[[10,0,-20,0,14,0,-4],4]
  ,[[-4,0,18,0,-24,0,14,0,-5,0,1],0],[[1],16],
  [[-27,0,59,0,-45,0,10],0],
  [[-9,0,33,0,-48,0,33,0,-15,0,3],0],[[],0],
  [[4,0,-5],2],[[-7,0,23,0,-30,0,22,0,-9,0,1],0],
  [[3,0,-3],2],[[-1,0,2,0,-2,0,1],0],[[-1],8],
  [[1,0,-1],4],[[],0],[[],0],
  [[-2,0,7,0,-8,0,5,0,-1],0],[[3,0,-7,0,3],4],
  [[-4,0,12,0,-14,0,10,0,-3],0],[[],0],[[1],12]]
  ,
  [[[216],0],[[30,0,-24,0,0,0,-30,0,10,0,0,0,0,0,-10],
  28],[[18,0,0,0,-24,0,0,0,54,0,-24],8],
  [[44,0,-104,0,68],0],
  [[12,0,-39,0,75,0,-69,0,21],0],
  [[21,0,-75,0,45],0],[[-3,0,0,0,6,0,0,0,-3],24],
  [[2,0,-16,0,32,0,-30,0,12],0],
  [[-6,0,24,0,-18],4],[[2,0,-8,0,23,0,-27,0,6],0],
  [[1,0,-1,0,-5,0,13,0,-6,0,-5,0,9,0,-2],8],
  [[2,0,-2,0,-2,0,2],16],
  [[1,0,-10,0,24,0,-23,0,8],0],
  [[-2,0,9,0,-9,0,3],2],
  [[-1,0,-3,0,5,0,-4,0,-1,0,2,0,-1],10],
  [[3,0,-6],4],[[-3,0,2,0,1],12],
  [[5,0,-26,0,49,0,-45,0,16],0],[[-3,0,4,0,-1],10],
  [[-1,0,3,0,-3,0,0,0,1],12],[[-1,0,3,0,-2],6],
  [[-1],10],[[-1,0,1],4],[[],0],[[],0],
  [[1],6],[[-2,0,5,0,-11,0,14,0,-9,0,2],2],
  [[2,0,-4,0,5,0,-2],6],[[1,0,-1],6],
  [[2,0,-3,0,5,0,-4,0,1],4],[[-216],70],
  [[-96,0,120],0],[[-24,0,60,0,-96,0,36],0],
  [[-12,0,6,0,12,0,-12,0,-24,0,38,0,-16],8],
  [[-21,0,69,0,-87,0,39],0],[[9],30],[[],0],
  [[],0],[[],0],
  [[-1,0,1,0,10,0,-15,0,-1,0,13,0,-3],8],
  [[-2,0,19,0,-33,0,12],0],[[4,0,-14,0,20,0,-10],4]
  ,[[-1,0,5,0,-14,0,24,0,-18,0,4],0],[[-1],14],
  [[-10,0,45,0,-59,0,27],0],
  [[-3,0,15,0,-33,0,48,0,-33,0,9],0],[[],0],
  [[5,0,-4],6],[[-1,0,9,0,-22,0,30,0,-23,0,7],0],
  [[3,0,-3],6],[[-1,0,2,0,-2,0,1],4],[[1],10],
  [[1,0,-1],4],[[],0],[[],0],
  [[1,0,-5,0,8,0,-7,0,2],2],[[-3,0,7,0,-3],6],
  [[3,0,-10,0,14,0,-12,0,4],2],[[],0],[[-1],14]]
  ,
  [[[280],0],[[15,0,0,0,-9,0,0,0,5,0,0,0,45,0,-96],
  16],
  [[4,0,0,0,0,0,-56,0,54,0,0,0,-20,0,0,0,18,0,-8],0
  ],[[88,0,-144,0,48],0],
  [[24,0,-90,0,114,0,-46,0,6],0],
  [[70,0,-90,0,30],0],[[9,0,-8,0,0,0,0,0,9],16],
  [[13,0,-46,0,51,0,-18,0,1],0],
  [[4,0,0,0,-18,0,20,0,-6],0],
  [[12,0,-36,0,38,0,-14],0],
  [[-4,0,15,0,-9,0,-4,0,4,0,-1,0,-1],6],
  [[-1,0,2,0,0,0,-2,0,1],8],
  [[11,0,-38,0,38,0,-12,0,1],0],
  [[6,0,-18,0,16,0,-4],0],
  [[4,0,-1,0,-2,0,2,0,0,0,-1],8],
  [[4,0,-14,0,10,0,-2],0],[[1,0,0,0,-3],8],
  [[17,0,-67,0,74,0,-29,0,3],0],[[2,0,-3],8],
  [[1,0,0,0,-1,0,2,0,-1],8],[[-3,0,7,0,-6,0,1],2]
  ,[[-1,0,3,0,-2],2],[[-1,0,4,0,-3],2],
  [[-1,0,2,0,-1],4],[[1],6],[[1,0,-1],4],
  [[1,0,-10,0,26,0,-24,0,7],0],
  [[-2,0,6,0,-5,0,1],4],[[1,0,-1],4],
  [[-5,0,13,0,-10,0,2],2],[[280],54],
  [[-160,0,120],0],[[-48,0,120,0,-96,0,16],0],
  [[-2,0,2,0,0,0,24,0,-62,0,24,0,12,0,-8,0,-12,0,14],
  0],[[-46,0,126,0,-90,0,18],0],
  [[1,0,0,0,-5,0,0,0,15,0,-16,0,15],18],[[10],18],
  [[4,0,-6,0,3],18],[[],0],
  [[12,0,-15,0,1,0,6,0,-4,0,-1,0,1],6],
  [[-24,0,46,0,-26,0,4],0],
  [[-2,0,2,0,10,0,-20,0,12,0,-2],0],
  [[-5,0,25,0,-41,0,25,0,-4],0],[[],0],
  [[-36,0,86,0,-58,0,10],0],
  [[-8,0,43,0,-77,0,50,0,-11,0,1],0],
  [[1,0,-2,0,1,0,-2],18],[[-2,0,8,0,-14,0,6],0],
  [[-5,0,32,0,-53,0,32,0,-7],0],
  [[-1,0,5,0,-7,0,4],0],[[-1,0,5,0,-8,0,3],0],
  [[],0],[[3,0,-4,0,1],2],[[],0],[[1],6],
  [[-2,0,13,0,-19,0,9,0,-1],0],[[4,0,-7,0,3],4],
  [[-3,0,18,0,-29,0,16,0,-2],0],[[],0],[[],0]],
  [[[280],0],
  [[-96,0,45,0,0,0,5,0,0,0,-9,0,0,0,15],30],
  [[-8,0,18,0,0,0,-20,0,0,0,54,0,-56,0,0,0,0,0,4],6
  ],[[48,0,-144,0,88],0],
  [[6,0,-46,0,114,0,-90,0,24],0],
  [[30,0,-90,0,70],0],[[9,0,0,0,0,0,-8,0,9],24],
  [[1,0,-18,0,51,0,-46,0,13],0],
  [[-6,0,20,0,-18,0,0,0,4],4],
  [[-14,0,38,0,-36,0,12],2],
  [[-1,0,-1,0,4,0,-4,0,-9,0,15,0,-4],10],
  [[1,0,-2,0,0,0,2,0,-1],16],
  [[1,0,-12,0,38,0,-38,0,11],0],
  [[-4,0,16,0,-18,0,6],2],
  [[-1,0,0,0,2,0,-2,0,-1,0,4],10],
  [[-2,0,10,0,-14,0,4],2],[[-3,0,0,0,1],12],
  [[3,0,-29,0,74,0,-67,0,17],0],[[-3,0,2],10],
  [[-1,0,2,0,-1,0,0,0,1],12],
  [[1,0,-6,0,7,0,-3],4],[[-2,0,3,0,-1],6],
  [[-3,0,4,0,-1],6],[[-1,0,2,0,-1],8],[[1],10],
  [[-1,0,1],6],[[7,0,-24,0,26,0,-10,0,1],4],
  [[1,0,-5,0,6,0,-2],6],[[-1,0,1],6],
  [[2,0,-10,0,13,0,-5],4],[[-280],72],
  [[-120,0,160],0],[[-16,0,96,0,-120,0,48],0],
  [[-14,0,12,0,8,0,-12,0,-24,0,62,0,-24,0,0,0,-2,0,2]
  ,8],[[-18,0,90,0,-126,0,46],0],
  [[-15,0,16,0,-15,0,0,0,5,0,0,0,-1],32],
  [[-10],24],[[-3,0,6,0,-4],24],[[],0],
  [[-1,0,1,0,4,0,-6,0,-1,0,15,0,-12],8],
  [[-4,0,26,0,-46,0,24],0],
  [[2,0,-12,0,20,0,-10,0,-2,0,2],4],
  [[4,0,-25,0,41,0,-25,0,5],2],[[],0],
  [[-10,0,58,0,-86,0,36],0],
  [[-1,0,11,0,-50,0,77,0,-43,0,8],0],
  [[2,0,-1,0,2,0,-1],26],[[-6,0,14,0,-8,0,2],4],
  [[7,0,-32,0,53,0,-32,0,5],2],
  [[-4,0,7,0,-5,0,1],4],[[-3,0,8,0,-5,0,1],4],
  [[],0],[[-1,0,4,0,-3],4],[[],0],[[-1],8],
  [[1,0,-9,0,19,0,-13,0,2],2],[[-3,0,7,0,-4],6],
  [[2,0,-16,0,29,0,-18,0,3],2],[[],0],[[],0]],
  [[[280],0],
  [[-24,0,75,0,-30,0,5,0,0,0,9,0,-10,0,15],30],
  [[18,0,0,0,-28,0,0,0,72,0,-40,0,0,0,0,0,2],8],
  [[52,0,-136,0,92],0],
  [[9,0,-53,0,99,0,-87,0,32],0],
  [[25,0,-95,0,65],0],[[-3,0,0,0,6,0,-8,0,-3],24],
  [[2,0,-18,0,42,0,-44,0,16],0],
  [[-6,0,28,0,-24,0,0,0,2],4],
  [[-13,0,33,0,-30,0,14],2],
  [[-1,0,-4,0,12,0,-10,0,-9,0,13,0,-5],10],
  [[3,0,-4,0,-2,0,4,0,-1],16],
  [[1,0,-11,0,32,0,-34,0,12],0],
  [[-2,0,12,0,-15,0,5],2],
  [[-1,0,0,0,5,0,-5,0,-1,0,4,0,-1],10],
  [[5,0,-10,0,2],4],[[-3,0,2,0,1],12],
  [[5,0,-30,0,65,0,-63,0,22],0],[[-3,0,2,0,-1],10],
  [[-1,0,3,0,-3,0,0,0,1],12],
  [[1,0,-2,0,3,0,-3,0,1],4],[[1,0,-1],8],
  [[1,0,0,0,-1],6],[[-1,0,2,0,-1],8],[[1],10],
  [[1,0,-1],6],[[-1,0,8,0,-15,0,19,0,-13,0,3],2],
  [[1,0,-6,0,7,0,-3],6],[[1,0,-1],6],
  [[2,0,-5,0,8,0,-6,0,1],4],[[280],72],
  [[-120,0,160],0],[[-20,0,96,0,-108,0,56],0],
  [[-6,0,12,0,12,0,-16,0,-30,0,58,0,-24,0,0,0,0,0,2],
  8],[[-23,0,87,0,-117,0,53],0],
  [[-15,0,16,0,-5,0,0,0,0,0,0,0,-1],32],[[-8],24],
  [[-2,0,4,0,-4],24],[[],0],
  [[-1,0,1,0,10,0,-17,0,-1,0,19,0,-7],8],
  [[-2,0,23,0,-45,0,20],0],
  [[2,0,-16,0,26,0,-14,0,0,0,2],4],
  [[6,0,-21,0,31,0,-24,0,8],2],[[],0],
  [[-11,0,55,0,-81,0,38],0],
  [[-2,0,16,0,-46,0,62,0,-46,0,13],0],
  [[-1,0,2,0,-1],28],[[-3,0,6,0,-6,0,2],4],
  [[-1,0,9,0,-28,0,42,0,-33,0,9],0],
  [[-2,0,3,0,-3,0,2],4],[[-1,0,4,0,-4,0,1],4],
  [[],0],[[1,0,0,0,-1],4],[[],0],[[1],8],
  [[1,0,-6,0,13,0,-11,0,3],2],[[-3,0,9,0,-5],6],
  [[3,0,-12,0,21,0,-18,0,5],2],[[],0],[[],0]],
  [[[280],0],
  [[15,0,-10,0,9,0,0,0,5,0,-30,0,75,0,-24],16],
  [[2,0,0,0,0,0,-40,0,72,0,0,0,-28,0,0,0,18],0],
  [[92,0,-136,0,52],0],
  [[32,0,-87,0,99,0,-53,0,9],0],
  [[65,0,-95,0,25],0],[[-3,0,-8,0,6,0,0,0,-3],16],
  [[16,0,-44,0,42,0,-18,0,2],0],
  [[2,0,0,0,-24,0,28,0,-6],0],
  [[14,0,-30,0,33,0,-13],0],
  [[-5,0,13,0,-9,0,-10,0,12,0,-4,0,-1],6],
  [[-1,0,4,0,-2,0,-4,0,3],8],
  [[12,0,-34,0,32,0,-11,0,1],0],
  [[5,0,-15,0,12,0,-2],0],
  [[-1,0,4,0,-1,0,-5,0,5,0,0,0,-1],6],
  [[2,0,-10,0,5],0],[[1,0,2,0,-3],8],
  [[22,0,-63,0,65,0,-30,0,5],0],[[-1,0,2,0,-3],6],
  [[1,0,0,0,-3,0,3,0,-1],8],
  [[1,0,-3,0,3,0,-2,0,1],0],[[-1,0,1],2],
  [[-1,0,0,0,1],2],[[-1,0,2,0,-1],4],[[1],6],
  [[-1,0,1],4],[[3,0,-13,0,19,0,-15,0,8,0,-1],0],
  [[-3,0,7,0,-6,0,1],4],[[-1,0,1],4],
  [[1,0,-6,0,8,0,-5,0,2],0],[[-280],54],
  [[-160,0,120],0],[[-56,0,108,0,-96,0,20],0],
  [[-2,0,0,0,0,0,24,0,-58,0,30,0,16,0,-12,0,-12,0,6],
  0],[[-53,0,117,0,-87,0,23],0],
  [[1,0,0,0,0,0,0,0,5,0,-16,0,15],18],[[8],18],
  [[4,0,-4,0,2],18],[[],0],
  [[7,0,-19,0,1,0,17,0,-10,0,-1,0,1],6],
  [[-20,0,45,0,-23,0,2],0],
  [[-2,0,0,0,14,0,-26,0,16,0,-2],0],
  [[-8,0,24,0,-31,0,21,0,-6],0],[[],0],
  [[-38,0,81,0,-55,0,11],0],
  [[-13,0,46,0,-62,0,46,0,-16,0,2],0],
  [[1,0,-2,0,1],18],[[-2,0,6,0,-6,0,3],0],
  [[-9,0,33,0,-42,0,28,0,-9,0,1],0],
  [[-2,0,3,0,-3,0,2],0],[[-1,0,4,0,-4,0,1],0],
  [[],0],[[1,0,0,0,-1],2],[[],0],[[-1],6],
  [[-3,0,11,0,-13,0,6,0,-1],0],[[5,0,-9,0,3],4],
  [[-5,0,18,0,-21,0,12,0,-3],0],[[],0],[[],0]],
  [[[315],0],
  [[15,0,-10,0,-24,0,0,0,5,0,-30,0,75,0,-76],16],
  [[3,0,0,0,0,0,-52,0,72,0,0,0,-58,0,0,0,18,0,-4],0
  ],[[102,0,-156,0,57],0],
  [[33,0,-99,0,117,0,-57,0,9],0],
  [[75,0,-105,0,30],0],[[3,0,-8,0,6,0,0,0,-10],16],
  [[17,0,-50,0,51,0,-20,0,2],0],
  [[3,0,0,0,-24,0,22,0,-6],0],
  [[15,0,-36,0,39,0,-15],0],
  [[-5,0,15,0,-8,0,-13,0,18,0,-4],6],
  [[-1,0,2,0,-1,0,-4,0,7],8],
  [[13,0,-40,0,38,0,-13,0,1],0],
  [[6,0,-18,0,15,0,-3],0],
  [[-1,0,4,0,0,0,-8,0,5],6],
  [[3,0,-13,0,11,0,-1],0],[[-1,0,2,0,2],8],
  [[23,0,-72,0,77,0,-33,0,5],0],[[-1,0,2,0,-1],6],
  [[-2,0,1,0,1],12],[[1,0,-3,0,5,0,-4,0,1],0],
  [[-1,0,2,0,-1],2],[[-1,0,3,0,-3],2],
  [[-1,0,1,0,-1],4],[[1,0,-1],6],[[1,0,-1],4],
  [[3,0,-13,0,24,0,-21,0,8,0,-1],0],
  [[-3,0,6,0,-4,0,1],4],[[1],4],
  [[1,0,-6,0,11,0,-8,0,2],0],[[315],54],
  [[-180,0,135],0],[[-60,0,126,0,-108,0,21],0],
  [[-2,0,1,0,0,0,28,0,-66,0,30,0,36,0,-22,0,-12,0,10]
  ,0],[[-57,0,135,0,-99,0,24],0],
  [[-1,0,0,0,5,0,0,0,-15,0,16,0,-5],18],[[-9],18],
  [[-3,0,6,0,-3],18],[[-6,0,1],28],
  [[10,0,-17,0,1,0,23,0,-13,0,-1],6],
  [[-24,0,51,0,-27,0,3],0],
  [[-2,0,1,0,14,0,-22,0,14,0,-2],0],
  [[-8,0,27,0,-39,0,25,0,-6],0],[[],0],
  [[-42,0,93,0,-63,0,12],0],
  [[-13,0,50,0,-76,0,53,0,-16,0,2],0],
  [[2,0,-1,0,2],20],[[-2,0,8,0,-12,0,6],0],
  [[-9,0,36,0,-52,0,33,0,-9,0,1],0],
  [[-2,0,4,0,-5,0,3],0],[[-1,0,5,0,-6,0,2],0],
  [[],0],[[2,0,-4,0,1],2],[[-1],16],[[],0],
  [[-3,0,13,0,-17,0,8,0,-1],0],[[5,0,-7,0,2],4],
  [[-5,0,20,0,-27,0,15,0,-3],0],[[1],10],[[],0]]
  ,
  [[[315],0],[[-76,0,75,0,-30,0,5,0,0,0,-24,0,-10,0,15
  ],30],
  [[-4,0,18,0,0,0,-58,0,0,0,72,0,-52,0,0,0,0,0,3],6
  ],[[57,0,-156,0,102],0],
  [[9,0,-57,0,117,0,-99,0,33],0],
  [[30,0,-105,0,75],0],[[-10,0,0,0,6,0,-8,0,3],24],
  [[2,0,-20,0,51,0,-50,0,17],0],
  [[-6,0,22,0,-24,0,0,0,3],4],
  [[-15,0,39,0,-36,0,15],2],
  [[-4,0,18,0,-13,0,-8,0,15,0,-5],12],
  [[7,0,-4,0,-1,0,2,0,-1],16],
  [[1,0,-13,0,38,0,-40,0,13],0],
  [[-3,0,15,0,-18,0,6],2],
  [[5,0,-8,0,0,0,4,0,-1],14],
  [[-1,0,11,0,-13,0,3],2],[[2,0,2,0,-1],12],
  [[5,0,-33,0,77,0,-72,0,23],0],[[-1,0,2,0,-1],10],
  [[1,0,1,0,-2],12],[[1,0,-4,0,5,0,-3,0,1],4],
  [[-1,0,2,0,-1],6],[[-3,0,3,0,-1],6],
  [[-1,0,1,0,-1],8],[[-1,0,1],8],[[-1,0,1],6],
  [[-1,0,8,0,-21,0,24,0,-13,0,3],2],
  [[1,0,-4,0,6,0,-3],6],[[1],8],
  [[2,0,-8,0,11,0,-6,0,1],4],[[-315],72],
  [[-135,0,180],0],[[-21,0,108,0,-126,0,60],0],
  [[-10,0,12,0,22,0,-36,0,-30,0,66,0,-28,0,0,0,-1,0,2
  ],8],[[-24,0,99,0,-135,0,57],0],
  [[5,0,-16,0,15,0,0,0,-5,0,0,0,1],32],[[9],24],
  [[3,0,-6,0,3],24],[[-1,0,6],36],
  [[1,0,13,0,-23,0,-1,0,17,0,-10],10],
  [[-3,0,27,0,-51,0,24],0],
  [[2,0,-14,0,22,0,-14,0,-1,0,2],4],
  [[6,0,-25,0,39,0,-27,0,8],2],[[],0],
  [[-12,0,63,0,-93,0,42],0],
  [[-2,0,16,0,-53,0,76,0,-50,0,13],0],
  [[-2,0,1,0,-2],26],[[-6,0,12,0,-8,0,2],4],
  [[-1,0,9,0,-33,0,52,0,-36,0,9],0],
  [[-3,0,5,0,-4,0,2],4],[[-2,0,6,0,-5,0,1],4],
  [[],0],[[-1,0,4,0,-2],4],[[1],18],[[],0],
  [[1,0,-8,0,17,0,-13,0,3],2],[[-2,0,7,0,-5],6],
  [[3,0,-15,0,27,0,-20,0,5],2],[[-1],12],[[],0]]
  ,
  [[[336],0],[[15,0,0,0,15,0,0,0,45,0,-96,0,45,0,0,0,
  -40],20],
  [[2,0,0,0,0,0,-40,0,54,0,0,0,-12,0,0,0,36,0,-24],
  0],[[88,0,-176,0,72],0],
  [[18,0,-94,0,138,0,-74,0,12],0],
  [[66,0,-110,0,50],0],[[-8,0,0,0,0,0,2],18],
  [[8,0,-44,0,64,0,-32,0,4],0],
  [[2,0,0,0,-18,0,28,0,-12],0],
  [[6,0,-36,0,48,0,-22,0,4],0],
  [[-1,0,9,0,-8,0,0,0,5,0,-1,0,-6,0,2],6],
  [[2,0,-2,0,-2,0,2],10],
  [[7,0,-34,0,48,0,-24,0,3],0],
  [[3,0,-15,0,21,0,-9,0,1],0],
  [[1,0,-1,0,1,0,2,0,-1,0,-1,0,1],8],
  [[2,0,-10,0,12,0,-6],0],[[-2],12],
  [[13,0,-63,0,94,0,-49,0,7],0],[[3,0,-3,0,2],8],
  [[-1,0,0,0,-1],12],[[-1,0,6,0,-8,0,3],2],
  [[2,0,-3,0,1],4],[[2,0,-3,0,1],4],
  [[2,0,-2],6],[[1,0,-1],6],[[-1],6],
  [[-6,0,23,0,-31,0,16,0,-2],2],
  [[-1,0,6,0,-8,0,3],4],[[],0],
  [[-2,0,10,0,-14,0,7],2],[[336],60],
  [[-176,0,160],0],[[-40,0,144,0,-120,0,32],0],
  [[2,0,0,0,16,0,-48,0,30,0,0,0,-12,0,-24,0,28,0,-8],
  2],[[-42,0,138,0,-126,0,30],0],
  [[-5,0,16,0,-10,0,0,0,5],28],[[-6],20],
  [[-3,0,4,0,-1],20],[[],0],
  [[5,0,-12,0,2,0,5,0,-3,0,-2,0,6,0,-1],6],
  [[-18,0,48,0,-40,0,10],0],
  [[2,0,8,0,-26,0,20,0,-4],2],
  [[-2,0,20,0,-45,0,37,0,-11,0,1],0],[[1],12],
  [[-30,0,94,0,-82,0,20],0],
  [[-5,0,37,0,-84,0,73,0,-25,0,2],0],
  [[-1,0,2,0,-3],20],[[6,0,-12,0,10,0,-2],2],
  [[-3,0,25,0,-57,0,51,0,-15,0,1],0],
  [[3,0,-9,0,5,0,-1],2],[[3,0,-8,0,6,0,-1],2],
  [[],0],[[1,0,-3,0,2],2],[[],0],[[],0],
  [[-1,0,8,0,-20,0,16,0,-4],0],
  [[3,0,-8,0,6,0,-1],4],
  [[-1,0,13,0,-31,0,26,0,-7],0],[[],0],[[1],12]]
  ,
  [[[336],0],[[-40,0,0,0,45,0,-96,0,45,0,0,0,15,0,0,
  0,15],24],
  [[-24,0,36,0,0,0,-12,0,0,0,54,0,-40,0,0,0,0,0,2],
  6],[[72,0,-176,0,88],0],
  [[12,0,-74,0,138,0,-94,0,18],0],
  [[50,0,-110,0,66],0],[[2,0,0,0,0,0,-8],24],
  [[4,0,-32,0,64,0,-44,0,8],0],
  [[-12,0,28,0,-18,0,0,0,2],4],
  [[4,0,-22,0,48,0,-36,0,6],0],
  [[2,0,-6,0,-1,0,5,0,0,0,-8,0,9,0,-1],8],
  [[2,0,-2,0,-2,0,2],16],
  [[3,0,-24,0,48,0,-34,0,7],0],
  [[1,0,-9,0,21,0,-15,0,3],0],
  [[1,0,-1,0,-1,0,2,0,1,0,-1,0,1],8],
  [[-6,0,12,0,-10,0,2],2],[[-2],12],
  [[7,0,-49,0,94,0,-63,0,13],0],[[2,0,-3,0,3],8],
  [[-1,0,0,0,-1],12],[[3,0,-8,0,6,0,-1],4],
  [[1,0,-3,0,2],4],[[1,0,-3,0,2],4],
  [[-2,0,2],8],[[-1,0,1],8],[[-1],6],
  [[-2,0,16,0,-31,0,23,0,-6],2],
  [[3,0,-8,0,6,0,-1],6],[[],0],
  [[7,0,-14,0,10,0,-2],4],[[-336],66],
  [[-160,0,176],0],[[-32,0,120,0,-144,0,40],0],
  [[8,0,-28,0,24,0,12,0,0,0,-30,0,48,0,-16,0,0,0,-2],
  6],[[-30,0,126,0,-138,0,42],0],
  [[-5,0,0,0,10,0,-16,0,5],26],[[6],22],
  [[1,0,-4,0,3],22],[[],0],
  [[1,0,-6,0,2,0,3,0,-5,0,-2,0,12,0,-5],6],
  [[-10,0,40,0,-48,0,18],0],
  [[4,0,-20,0,26,0,-8,0,-2],4],
  [[-1,0,11,0,-37,0,45,0,-20,0,2],0],[[-1],18],
  [[-20,0,82,0,-94,0,30],0],
  [[-2,0,25,0,-73,0,84,0,-37,0,5],0],
  [[3,0,-2,0,1],26],[[2,0,-10,0,12,0,-6],2],
  [[-1,0,15,0,-51,0,57,0,-25,0,3],0],
  [[1,0,-5,0,9,0,-3],2],[[1,0,-6,0,8,0,-3],2],
  [[],0],[[-2,0,3,0,-1],4],[[],0],[[],0],
  [[4,0,-16,0,20,0,-8,0,1],2],
  [[1,0,-6,0,8,0,-3],4],
  [[7,0,-26,0,31,0,-13,0,1],2],[[],0],[[-1],14]]
  ,
  [[[378],0],[[-15,0,0,0,5,0,-30,0,75,0,-80,0,45,0,-30
  ],20],
  [[3,0,0,0,0,0,-36,0,72,0,0,0,-60,0,0,0,27,0,-12],
  0],[[110,0,-188,0,80],0],
  [[33,0,-108,0,138,0,-84,0,15],0],
  [[75,0,-129,0,45],0],[[-8,0,12,0,0,0,-4],18],
  [[14,0,-52,0,62,0,-30,0,6],0],
  [[3,0,0,0,-24,0,36,0,-9],0],
  [[11,0,-38,0,47,0,-21,0,3],0],
  [[-4,0,8,0,-7,0,-15,0,25,0,-5,0,-1,0,1],6],
  [[2,0,-2,0,-4,0,4,0,-2],10],
  [[11,0,-38,0,47,0,-21,0,3],0],
  [[3,0,-17,0,18,0,-6],0],[[1,0,0,0,-8,0,10],8],
  [[3,0,-9,0,12,0,-3],0],[[4,0,-4],10],
  [[22,0,-74,0,93,0,-51,0,9],0],[[2,0,-2],8],
  [[1,0,-5,0,5,0,-1],10],[[-2,0,4,0,-4,0,2],2],
  [[1,0,-1],4],[[-1,0,1,0,-1,0,1],2],
  [[2,0,-2],6],[[1,0,-1],6],[[],0],
  [[2,0,-12,0,22,0,-24,0,15,0,-4],0],
  [[-2,0,7,0,-8,0,2],4],[[],0],
  [[1,0,-4,0,9,0,-9,0,5,0,-1],0],[[378],58],
  [[-204,0,174],0],[[-60,0,150,0,-132,0,36],0],
  [[-2,0,1,0,0,0,20,0,-52,0,36,0,36,0,-24,0,-18,0,13,
  0,-8],0],[[-60,0,150,0,-132,0,36],0],
  [[-9],26],[[],0],[[],0],[[6],30],
  [[5,0,-14,0,0,0,27,0,-18,0,0,0,2],6],
  [[-20,0,55,0,-39,0,6],0],
  [[-2,0,1,0,12,0,-32,0,22,0,-3],0],
  [[-6,0,26,0,-41,0,34,0,-12,0,1],0],[[-2],14],
  [[-40,0,105,0,-83,0,21],0],
  [[-12,0,51,0,-81,0,72,0,-30,0,3],0],[[],0],
  [[-2,0,6,0,-10,0,7,0,-2],0],
  [[-8,0,34,0,-56,0,46,0,-18,0,2],0],
  [[3,0,-6,0,3],2],[[3,0,-6,0,3],2],[[],0],
  [[1,0,-2,0,1],2],[[],0],[[],0],
  [[-2,0,10,0,-17,0,12,0,-3],0],[[4,0,-10,0,5],4],
  [[-4,0,17,0,-29,0,21,0,-7,0,1],0],[[],0],
  [[1],12]],
  [[[378],0],[[-30,0,45,0,-80,0,75,0,-30,0,5,0,0,0,-15
  ],26],
  [[-12,0,27,0,0,0,-60,0,0,0,72,0,-36,0,0,0,0,0,3],
  6],[[80,0,-188,0,110],0],
  [[15,0,-84,0,138,0,-108,0,33],0],
  [[45,0,-129,0,75],0],[[-4,0,0,0,12,0,-8],24],
  [[6,0,-30,0,62,0,-52,0,14],0],
  [[-9,0,36,0,-24,0,0,0,3],4],
  [[3,0,-21,0,47,0,-38,0,11],0],
  [[1,0,-1,0,-5,0,25,0,-15,0,-7,0,8,0,-4],8],
  [[-2,0,4,0,-4,0,-2,0,2],14],
  [[3,0,-21,0,47,0,-38,0,11],0],
  [[-6,0,18,0,-17,0,3],2],[[10,0,-8,0,0,0,1],14],
  [[-3,0,12,0,-9,0,3],2],[[-4,0,4],12],
  [[9,0,-51,0,93,0,-74,0,22],0],[[-2,0,2],10],
  [[-1,0,5,0,-5,0,1],12],[[2,0,-4,0,4,0,-2],4],
  [[-1,0,1],6],[[1,0,-1,0,1,0,-1],4],
  [[-2,0,2],8],[[-1,0,1],8],[[],0],
  [[-4,0,15,0,-24,0,22,0,-12,0,2],2],
  [[2,0,-8,0,7,0,-2],6],[[],0],
  [[-1,0,5,0,-9,0,9,0,-4,0,1],2],[[-378],68],
  [[-174,0,204],0],[[-36,0,132,0,-150,0,60],0],
  [[8,0,-13,0,18,0,24,0,-36,0,-36,0,52,0,-20,0,0,0,
  -1,0,2],6],[[-36,0,132,0,-150,0,60],0],
  [[9],36],[[],0],[[],0],[[-6],36],
  [[-2,0,0,0,18,0,-27,0,0,0,14,0,-5],8],
  [[-6,0,39,0,-55,0,20],0],
  [[3,0,-22,0,32,0,-12,0,-1,0,2],4],
  [[-1,0,12,0,-34,0,41,0,-26,0,6],0],[[2],16],
  [[-21,0,83,0,-105,0,40],0],
  [[-3,0,30,0,-72,0,81,0,-51,0,12],0],[[],0],
  [[2,0,-7,0,10,0,-6,0,2],2],
  [[-2,0,18,0,-46,0,56,0,-34,0,8],0],
  [[-3,0,6,0,-3],4],[[-3,0,6,0,-3],4],[[],0],
  [[-1,0,2,0,-1],4],[[],0],[[],0],
  [[3,0,-12,0,17,0,-10,0,2],2],[[-5,0,10,0,-4],6],
  [[-1,0,7,0,-21,0,29,0,-17,0,4],0],[[],0],
  [[-1],14]],
  [[[405],0],[[75,0,-76,0,45,0,-30,0,50,0,0,0,-9,0,-10
  ],28],
  [[-12,0,27,0,0,0,-66,0,0,0,81,0,-60,0,0,0,0,0,3],
  6],[[78,0,-204,0,123],0],
  [[15,0,-75,0,153,0,-129,0,33],0],
  [[45,0,-135,0,90],0],[[-1,0,0,0,6,0,-8,0,3],24],
  [[3,0,-30,0,69,0,-60,0,18],0],
  [[-9,0,30,0,-27,0,0,0,3],4],
  [[3,0,-18,0,51,0,-51,0,12],0],
  [[-2,0,-8,0,20,0,-11,0,-10,0,13,0,-5],10],
  [[8,0,-6,0,-1,0,4],16],
  [[2,0,-20,0,52,0,-47,0,14],0],
  [[-6,0,21,0,-21,0,6],2],
  [[-3,0,5,0,-2,0,0,0,1,0,-1],12],
  [[-3,0,15,0,-15,0,3],2],[[-1,0,2,0,-1],12],
  [[7,0,-48,0,103,0,-87,0,25],0],
  [[-1,0,2,0,-1],10],[[3,0,-3],14],
  [[1,0,-6,0,8,0,-3],4],[[-2,0,2,0,-1],6],
  [[1,0,-3,0,4,0,-1],4],[[-2,0,3],8],
  [[-1,0,1],8],[[-1,0,1],6],
  [[-2,0,12,0,-29,0,31,0,-14,0,2],2],
  [[1,0,-7,0,8,0,-2],6],[[-1,0,1],6],
  [[4,0,-12,0,13,0,-6,0,1],4],[[405],70],
  [[-180,0,225],0],[[-36,0,126,0,-180,0,63],0],
  [[4,0,-20,0,15,0,36,0,-30,0,-42,0,67,0,-32,0,0,0,
  -2,0,1],6],[[-33,0,135,0,-171,0,66],0],
  [[],0],[[],0],[[],0],[[-6,0,3],36],
  [[-1,0,1,0,15,0,-25,0,-1,0,18,0,-10],8],
  [[-6,0,39,0,-63,0,27],0],
  [[4,0,-17,0,32,0,-13,0,-2,0,1],4],
  [[-1,0,9,0,-33,0,53,0,-33,0,6],0],[[],0],
  [[-18,0,87,0,-117,0,48],0],
  [[-3,0,24,0,-72,0,99,0,-60,0,12],0],[[],0],
  [[1,0,-8,0,16,0,-10,0,1],2],
  [[-1,0,14,0,-48,0,67,0,-41,0,9],0],
  [[-3,0,9,0,-6],4],[[-4,0,8,0,-5,0,1],4],
  [[-1],10],[[-2,0,5,0,-2],4],[[1],20],[[],0],
  [[2,0,-13,0,22,0,-14,0,3],2],[[-4,0,9,0,-5],6],
  [[5,0,-23,0,35,0,-22,0,5],2],[[],0],[[],0]],
  [[[405],0],
  [[-10,0,-9,0,0,0,50,0,-30,0,45,0,-76,0,75],18],
  [[3,0,0,0,0,0,-60,0,81,0,0,0,-66,0,0,0,27,0,-12],
  0],[[123,0,-204,0,78],0],
  [[33,0,-129,0,153,0,-75,0,15],0],
  [[90,0,-135,0,45],0],[[3,0,-8,0,6,0,0,0,-1],16],
  [[18,0,-60,0,69,0,-30,0,3],0],
  [[3,0,0,0,-27,0,30,0,-9],0],
  [[12,0,-51,0,51,0,-18,0,3],0],
  [[-5,0,13,0,-10,0,-11,0,20,0,-8,0,-2],6],
  [[4,0,-1,0,-6,0,8],10],
  [[14,0,-47,0,52,0,-20,0,2],0],
  [[6,0,-21,0,21,0,-6],0],
  [[-1,0,1,0,0,0,-2,0,5,0,-3],6],
  [[3,0,-15,0,15,0,-3],0],[[-1,0,2,0,-1],8],
  [[25,0,-87,0,103,0,-48,0,7],0],[[-1,0,2,0,-1],6],
  [[-3,0,3],12],[[-3,0,8,0,-6,0,1],2],
  [[-1,0,2,0,-2],2],[[-1,0,4,0,-3,0,1],2],
  [[3,0,-2],6],[[1,0,-1],6],[[1,0,-1],4],
  [[2,0,-14,0,31,0,-29,0,12,0,-2],0],
  [[-2,0,8,0,-7,0,1],4],[[1,0,-1],4],
  [[1,0,-6,0,13,0,-12,0,4],0],[[-405],56],
  [[-225,0,180],0],[[-63,0,180,0,-126,0,36],0],
  [[-1,0,2,0,0,0,32,0,-67,0,42,0,30,0,-36,0,-15,0,20,
  0,-4],0],[[-66,0,171,0,-135,0,33],0],
  [[],0],[[],0],[[],0],[[-3,0,6],28],
  [[10,0,-18,0,1,0,25,0,-15,0,-1,0,1],6],
  [[-27,0,63,0,-39,0,6],0],
  [[-1,0,2,0,13,0,-32,0,17,0,-4],0],
  [[-6,0,33,0,-53,0,33,0,-9,0,1],0],[[],0],
  [[-48,0,117,0,-87,0,18],0],
  [[-12,0,60,0,-99,0,72,0,-24,0,3],0],[[],0],
  [[-1,0,10,0,-16,0,8,0,-1],0],
  [[-9,0,41,0,-67,0,48,0,-14,0,1],0],
  [[6,0,-9,0,3],2],[[-1,0,5,0,-8,0,4],0],
  [[1],8],[[2,0,-5,0,2],2],[[-1],14],[[],0],
  [[-3,0,14,0,-22,0,13,0,-2],0],[[5,0,-9,0,4],4],
  [[-5,0,22,0,-35,0,23,0,-5],0],[[],0],[[],0]],
  [[[420],0],
  [[45,0,0,0,45,0,-136,0,75,0,0,0,15,0,0,0,-24],24],
  [[-24,0,45,0,0,0,-52,0,0,0,72,0,-40,0,0,0,0,0,3],
  6],[[92,0,-216,0,112],0],
  [[16,0,-96,0,168,0,-112,0,28],0],
  [[60,0,-140,0,80],0],[[-1,0,0,0,6,0,-8],24],
  [[7,0,-38,0,77,0,-54,0,11],0],
  [[-15,0,32,0,-24,0,0,0,3],4],
  [[4,0,-29,0,57,0,-41,0,9],0],
  [[2,0,-5,0,-3,0,16,0,-11,0,-8,0,10,0,-1],8],
  [[-1,0,-2,0,4,0,-2,0,-3],12],
  [[4,0,-29,0,57,0,-41,0,9],0],
  [[1,0,-10,0,24,0,-18,0,3],0],
  [[-1,0,1,0,4,0,-8,0,-1,0,1],10],
  [[-6,0,17,0,-10,0,3],2],[[-1,0,2],12],
  [[10,0,-62,0,112,0,-78,0,18],0],[[-4,0,3],10],
  [[2,0,-2,0,1],14],[[4,0,-8,0,6,0,-1],4],
  [[1,0,-3,0,2],4],[[1,0,-4,0,3],4],
  [[1,0,-2,0,1],6],[[-1,0,1],8],[[-1,0,1],6],
  [[-4,0,20,0,-35,0,26,0,-8,0,1],2],
  [[4,0,-8,0,6,0,-2],6],[[-1],6],
  [[-1,0,8,0,-15,0,11,0,-3],2],[[420],66],
  [[-200,0,220],0],[[-40,0,156,0,-168,0,56],0],
  [[8,0,-34,0,27,0,16,0,-36,0,-36,0,60,0,-16,0,0,0,
  -2,0,1],6],[[-40,0,156,0,-168,0,56],0],
  [[5,0,0,0,0,0,0,0,-5],26],[[-3],22],
  [[4,0,-1],24],[[-4],36],
  [[1,0,-5,0,2,0,14,0,-18,0,-2,0,13,0,-5],6],
  [[-11,0,49,0,-59,0,21],0],
  [[6,0,-25,0,28,0,-12,0,-2,0,1],4],
  [[-1,0,15,0,-45,0,51,0,-24,0,4],0],[[],0],
  [[-26,0,100,0,-116,0,38],0],
  [[-3,0,34,0,-89,0,99,0,-46,0,9],0],[[-1,0,2],26],
  [[2,0,-12,0,15,0,-6,0,1],2],
  [[-2,0,21,0,-60,0,67,0,-32,0,5],0],
  [[1,0,-6,0,9,0,-3],2],[[1,0,-6,0,9,0,-3],2],
  [[],0],[[-3,0,4,0,-1],4],[[],0],[[],0],
  [[5,0,-18,0,22,0,-10,0,1],2],
  [[1,0,-6,0,9,0,-4],4],
  [[-1,0,9,0,-30,0,36,0,-16,0,2],0],[[-1],12],
  [[],0]],
  [[[420],0],[[-24,0,0,0,15,0,0,0,75,0,-136,0,45,0,0,
  0,45],20],
  [[3,0,0,0,0,0,-40,0,72,0,0,0,-52,0,0,0,45,0,-24],
  0],[[112,0,-216,0,92],0],
  [[28,0,-112,0,168,0,-96,0,16],0],
  [[80,0,-140,0,60],0],[[-8,0,6,0,0,0,-1],18],
  [[11,0,-54,0,77,0,-38,0,7],0],
  [[3,0,0,0,-24,0,32,0,-15],0],
  [[9,0,-41,0,57,0,-29,0,4],0],
  [[-1,0,10,0,-8,0,-11,0,16,0,-3,0,-5,0,2],6],
  [[-3,0,-2,0,4,0,-2,0,-1],12],
  [[9,0,-41,0,57,0,-29,0,4],0],
  [[3,0,-18,0,24,0,-10,0,1],0],
  [[1,0,-1,0,-8,0,4,0,1,0,-1],8],
  [[3,0,-10,0,17,0,-6],0],[[2,0,-1],10],
  [[18,0,-78,0,112,0,-62,0,10],0],[[3,0,-4],8],
  [[1,0,-2,0,2],10],[[-1,0,6,0,-8,0,4],2],
  [[2,0,-3,0,1],4],[[3,0,-4,0,1],4],
  [[1,0,-2,0,1],6],[[1,0,-1],6],[[1,0,-1],4],
  [[1,0,-8,0,26,0,-35,0,20,0,-4],0],
  [[-2,0,6,0,-8,0,4],4],[[-1],6],
  [[-3,0,11,0,-15,0,8,0,-1],2],[[-420],60],
  [[-220,0,200],0],[[-56,0,168,0,-156,0,40],0],
  [[-1,0,2,0,0,0,16,0,-60,0,36,0,36,0,-16,0,-27,0,34,
  0,-8],0],[[-56,0,168,0,-156,0,40],0],
  [[5,0,0,0,0,0,0,0,-5],28],[[3],20],
  [[1,0,-4],20],[[4],30],
  [[5,0,-13,0,2,0,18,0,-14,0,-2,0,5,0,-1],6],
  [[-21,0,59,0,-49,0,11],0],
  [[-1,0,2,0,12,0,-28,0,25,0,-6],0],
  [[-4,0,24,0,-51,0,45,0,-15,0,1],0],[[],0],
  [[-38,0,116,0,-100,0,26],0],
  [[-9,0,46,0,-99,0,89,0,-34,0,3],0],[[-2,0,1],22],
  [[-1,0,6,0,-15,0,12,0,-2],0],
  [[-5,0,32,0,-67,0,60,0,-21,0,2],0],
  [[3,0,-9,0,6,0,-1],2],[[3,0,-9,0,6,0,-1],2],
  [[],0],[[1,0,-4,0,3],2],[[],0],[[],0],
  [[-1,0,10,0,-22,0,18,0,-5],0],
  [[4,0,-9,0,6,0,-1],4],
  [[-2,0,16,0,-36,0,30,0,-9,0,1],0],[[1],10],
  [[],0]],
  [[[512],0],[[5,0,-30,0,75,0,-100,0,75,0,-30,0,5],24]
  ,[[-32,0,72,0,0,0,-80,0,0,0,72,0,-32],6],
  [[128,0,-256,0,128],0],
  [[32,0,-128,0,192,0,-128,0,32],0],
  [[80,0,-176,0,80],0],[[6,0,0,0,-4,0,0,0,6],20],
  [[12,0,-56,0,84,0,-56,0,12],0],
  [[-24,0,48,0,-24],4],[[8,0,-40,0,64,0,-40,0,8],0]
  ,[[-1,0,6,0,-6,0,-14,0,30,0,-14,0,-6,0,6,0,-1],6
  ],[[-1,0,-4,0,10,0,-4,0,-1],12],
  [[8,0,-40,0,64,0,-40,0,8],0],
  [[2,0,-14,0,26,0,-14,0,2],0],
  [[1,0,-1,0,-5,0,10,0,-5,0,-1,0,1],8],
  [[-8,0,16,0,-8],2],[[2,0,-4,0,2],10],
  [[20,0,-84,0,128,0,-84,0,20],0],[[2,0,-4,0,2],8],
  [[-3,0,6,0,-3],12],[[-1,0,4,0,-6,0,4,0,-1],2],
  [[1,0,-1,0,1],4],[[1,0,-2,0,1],4],
  [[1,0,-2,0,1],6],[[-1],8],[[],0],
  [[1,0,-9,0,25,0,-34,0,25,0,-9,0,1],0],
  [[-1,0,6,0,-10,0,6,0,-1],4],[[],0],
  [[-3,0,9,0,-13,0,9,0,-3],2],[[512],63],
  [[-256,0,256],0],[[-64,0,192,0,-192,0,64],0],
  [[16,0,-52,0,36,0,40,0,-40,0,-36,0,52,0,-16],6],
  [[-64,0,192,0,-192,0,64],0],
  [[-5,0,0,0,5,0,-16,0,5,0,0,0,-5],25],[[8],21],
  [[2,0,-8,0,2],21],[[],0],
  [[2,0,-10,0,2,0,30,0,-30,0,-2,0,10,0,-2],6],
  [[-16,0,64,0,-64,0,16],0],
  [[12,0,-36,0,36,0,-12],4],
  [[-4,0,24,0,-52,0,52,0,-24,0,4],0],[[2],15],
  [[-40,0,128,0,-128,0,40],0],
  [[-10,0,52,0,-106,0,106,0,-52,0,10],0],
  [[-2,0,4,0,-2],23],[[4,0,-12,0,12,0,-4],2],
  [[-6,0,34,0,-70,0,70,0,-34,0,6],0],
  [[2,0,-6,0,6,0,-2],2],[[2,0,-6,0,6,0,-2],2],
  [[1],9],[[-2,0,2],4],[[],0],[[-1],7],
  [[-1,0,8,0,-20,0,20,0,-8,0,1],0],
  [[2,0,-10,0,10,0,-2],4],
  [[-2,0,16,0,-34,0,34,0,-16,0,2],0],[[],0],
  [[-1],13]],
  [[[512],0],[[5,0,-30,0,75,0,-100,0,75,0,-30,0,5],24]
  ,[[-32,0,72,0,0,0,-80,0,0,0,72,0,-32],6],
  [[128,0,-256,0,128],0],
  [[32,0,-128,0,192,0,-128,0,32],0],
  [[80,0,-176,0,80],0],[[6,0,0,0,-4,0,0,0,6],20],
  [[12,0,-56,0,84,0,-56,0,12],0],
  [[-24,0,48,0,-24],4],[[8,0,-40,0,64,0,-40,0,8],0]
  ,[[-1,0,6,0,-6,0,-14,0,30,0,-14,0,-6,0,6,0,-1],6
  ],[[-1,0,-4,0,10,0,-4,0,-1],12],
  [[8,0,-40,0,64,0,-40,0,8],0],
  [[2,0,-14,0,26,0,-14,0,2],0],
  [[1,0,-1,0,-5,0,10,0,-5,0,-1,0,1],8],
  [[-8,0,16,0,-8],2],[[2,0,-4,0,2],10],
  [[20,0,-84,0,128,0,-84,0,20],0],[[2,0,-4,0,2],8],
  [[-3,0,6,0,-3],12],[[-1,0,4,0,-6,0,4,0,-1],2],
  [[1,0,-1,0,1],4],[[1,0,-2,0,1],4],
  [[1,0,-2,0,1],6],[[-1],8],[[],0],
  [[1,0,-9,0,25,0,-34,0,25,0,-9,0,1],0],
  [[-1,0,6,0,-10,0,6,0,-1],4],[[],0],
  [[-3,0,9,0,-13,0,9,0,-3],2],[[-512],63],
  [[-256,0,256],0],[[-64,0,192,0,-192,0,64],0],
  [[16,0,-52,0,36,0,40,0,-40,0,-36,0,52,0,-16],6],
  [[-64,0,192,0,-192,0,64],0],
  [[5,0,0,0,-5,0,16,0,-5,0,0,0,5],25],[[-8],21],
  [[-2,0,8,0,-2],21],[[],0],
  [[2,0,-10,0,2,0,30,0,-30,0,-2,0,10,0,-2],6],
  [[-16,0,64,0,-64,0,16],0],
  [[12,0,-36,0,36,0,-12],4],
  [[-4,0,24,0,-52,0,52,0,-24,0,4],0],[[-2],15],
  [[-40,0,128,0,-128,0,40],0],
  [[-10,0,52,0,-106,0,106,0,-52,0,10],0],
  [[2,0,-4,0,2],23],[[4,0,-12,0,12,0,-4],2],
  [[-6,0,34,0,-70,0,70,0,-34,0,6],0],
  [[2,0,-6,0,6,0,-2],2],[[2,0,-6,0,6,0,-2],2],
  [[-1],9],[[-2,0,2],4],[[],0],[[1],7],
  [[-1,0,8,0,-20,0,20,0,-8,0,1],0],
  [[2,0,-10,0,10,0,-2],4],
  [[-2,0,16,0,-34,0,34,0,-16,0,2],0],[[],0],
  [[1],13]]];

CHEVIE.E7.longestperm:=
  (  1, 64)(  2, 65)(  3, 66)(  4, 67)(  5, 68)(  6, 69)(  7, 70)(  8, 71)
  (  9, 72)( 10, 73)( 11, 74)( 12, 75)( 13, 76)( 14, 77)( 15, 78)( 16, 79)
  ( 17, 80)( 18, 81)( 19, 82)( 20, 83)( 21, 84)( 22, 85)( 23, 86)( 24, 87)
  ( 25, 88)( 26, 89)( 27, 90)( 28, 91)( 29, 92)( 30, 93)( 31, 94)( 32, 95)
  ( 33, 96)( 34, 97)( 35, 98)( 36, 99)( 37,100)( 38,101)( 39,102)( 40,103)
  ( 41,104)( 42,105)( 43,106)( 44,107)( 45,108)( 46,109)( 47,110)( 48,111)
  ( 49,112)( 50,113)( 51,114)( 52,115)( 53,116)( 54,117)( 55,118)( 56,119)
  ( 57,120)( 58,121)( 59,122)( 60,123)( 61,124)( 62,125)( 63,126);

CHEVIE.E7.vcycpolschurelms:=
[ [ [ 0, 0, 7, 3, 2, 1, 3, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -63, 0, 7, 3, 2, 1, 3, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -46, 0, 7, 3, 2, 1, 3, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -1, 0, 7, 3, 2, 1, 3, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -25, 0, 7, 3, 2, 0, 3, 1 ], 2 ], [ [ -4, 0, 7, 3, 2, 0, 3, 1 ], 2 ], 
  [ [ -3, 0, 7, 3, 2, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -30, 0, 7, 3, 2, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -36, 0, 7, 3, 2, 1, 3, 0, 1, 0, 1, 0, 1 ], 1 ], 
  [ [ -3, 0, 7, 3, 2, 1, 3, 0, 1, 0, 1, 0, 1 ], 1 ], 
  [ [ -2, 0, 7, 1, 2, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -37, 0, 7, 1, 2, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -16, 0, 7, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ -7, 0, 7, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ -3, 0, 7, 3, 2, 0, 3, 0, 0, 1, 1 ], 2 ], 
  [ [ -30, 0, 7, 3, 2, 0, 3, 0, 0, 1, 1 ], 2 ], 
  [ [ -30, 0, 3, 3, 2, 1, 1, 0, 1, 1, 0, 0, 1 ], 2 ], 
  [ [ -3, 0, 3, 3, 2, 1, 1, 0, 1, 1, 0, 0, 1 ], 2 ], 
  [ [ -16, 0, 7, 3, 2, 0, 3 ], 3 ], [ [ -7, 0, 7, 3, 2, 0, 3 ], 3 ], 
  [ [ -10, 0, 7, 3, 0, 1, 3 ], 2 ], [ [ -13, 0, 7, 3, 0, 1, 3 ], 2 ], 
  [ [ -25, 0, 7, 3, 2, 0, 3, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -4, 0, 7, 3, 2, 0, 3, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -6, 0, 7, 3, 2, 0, 3, 0, 1 ], 1 ], 
  [ [ -21, 0, 7, 3, 2, 0, 3, 0, 1 ], 1 ], 
  [ [ -12, 0, 7, 3, 2, 0, 3, 0, 1 ], 1 ], 
  [ [ -15, 0, 7, 3, 2, 0, 3, 0, 1 ], 1 ], 
  [ [ -4, 0, 3, 3, 2, 0, 1, 1, 1, 0, 0, 0, 1 ], 2 ], 
  [ [ -25, 0, 3, 3, 2, 0, 1, 1, 1, 0, 0, 0, 1 ], 2 ], 
  [ [ -6, 0, 7, 3, 0, 1, 3, 0, 0, 0, 1 ], 1 ], 
  [ [ -21, 0, 7, 3, 0, 1, 3, 0, 0, 0, 1 ], 1 ], 
  [ [ -8, 0, 7, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -15, 0, 7, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -22, 0, 7, 1, 2, 1, 1, 0, 1, 0, 1 ], 1 ], 
  [ [ -5, 0, 7, 1, 2, 1, 1, 0, 1, 0, 1 ], 1 ], 
  [ [ -20, 0, 7, 1, 2, 1, 1, 0, 1, 0, 1 ], 1 ], 
  [ [ -7, 0, 7, 1, 2, 1, 1, 0, 1, 0, 1 ], 1 ], 
  [ [ -6, 0, 7, 3, 2, 0, 3, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -21, 0, 7, 3, 2, 0, 3, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -10, 0, 7, 3, 2, 0, 3 ], 1 ], [ [ -13, 0, 7, 3, 2, 0, 3 ], 1 ], 
  [ [ -15, 0, 3, 1, 2, 1, 0, 1, 1 ], 2 ], 
  [ [ -8, 0, 3, 1, 2, 1, 0, 1, 1 ], 2 ], 
  [ [ -16, 0, 7, 3, 0, 0, 3, 0, 0, 0, 0, 0, 1 ], 3 ], 
  [ [ -7, 0, 7, 3, 0, 0, 3, 0, 0, 0, 0, 0, 1 ], 3 ], 
  [ [ -7, 0, 3, 3, 2, 0, 0, 0, 1, 1 ], 2 ], 
  [ [ -16, 0, 3, 3, 2, 0, 0, 0, 1, 1 ], 2 ], 
  [ [ -16, 0, 7, 0, 2, 0, 3, 0, 0, 1 ], 6 ], 
  [ [ -7, 0, 7, 0, 2, 0, 3, 0, 0, 1 ], 6 ], 
  [ [ -13, 0, 3, 3, 2, 1, 1, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -10, 0, 3, 3, 2, 1, 1, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -14, 0, 7, 1, 2, 1, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -9, 0, 7, 1, 2, 1, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -8, 0, 7, 0, 2, 0, 1, 1, 0, 0, 1 ], 2 ], 
  [ [ -15, 0, 7, 0, 2, 0, 1, 1, 0, 0, 1 ], 2 ], 
  [ [ -10, 0, 7, 3, 0, 0, 3, 0, 0, 0, 1 ], 2 ], 
  [ [ -13, 0, 7, 3, 0, 0, 3, 0, 0, 0, 1 ], 2 ], 
  [ [ -11, 0, 0, 3, 0, 1, 0, 1, 0, 1 ], 2 ], 
  [ [ -11, 0, 0, 3, 0, 1, 0, 1, 0, 1 ], 2 ] ];

CHEVIE.E7.vpolfakedegrees:=
[ [ [ 1 ], 0 ], [ [ 1 ], 63 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 46 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 2, 0, 1, 0, 1, 0, 1, 0, 
          1, 0, 0, 0, 1 ], 28 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 2, 0, 1, 0, 1, 0, 1, 0, 
          1, 0, 0, 0, 1 ], 7 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 1, 0, 1, 0, 
          1 ], 6 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 1, 0, 1, 0, 
          1 ], 33 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 1, 0, 1, 0, 
          1 ], 36 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 2, 0, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 1, 0, 1, 0, 
          1 ], 3 ], 
  [ [ 1, 0, 1, 0, 2, 0, 2, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 2, 0, 2, 0, 1, 0, 
          1 ], 2 ], 
  [ [ 1, 0, 1, 0, 2, 0, 2, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 2, 0, 2, 0, 1, 0, 
          1 ], 37 ], 
  [ [ 1, 0, 1, 0, 2, 0, 2, 0, 3, 0, 3, 0, 4, 0, 3, 0, 4, 0, 3, 0, 3, 0, 2, 0, 
          2, 0, 1, 0, 1 ], 22 ], 
  [ [ 1, 0, 1, 0, 2, 0, 2, 0, 3, 0, 3, 0, 4, 0, 3, 0, 4, 0, 3, 0, 3, 0, 2, 0, 
          2, 0, 1, 0, 1 ], 13 ], 
  [ [ 1, 0, 1, 0, 2, 0, 2, 0, 3, 0, 3, 0, 4, 0, 3, 0, 4, 0, 3, 0, 3, 0, 2, 0, 
          2, 0, 1, 0, 1 ], 4 ], 
  [ [ 1, 0, 1, 0, 2, 0, 2, 0, 3, 0, 3, 0, 4, 0, 3, 0, 4, 0, 3, 0, 3, 0, 2, 0, 
          2, 0, 1, 0, 1 ], 31 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 6, 0, 6, 0, 6, 0, 5, 0, 4, 0, 
          3, 0, 2, 0, 1, 0, 1 ], 30 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 6, 0, 6, 0, 6, 0, 5, 0, 4, 0, 
          3, 0, 2, 0, 1, 0, 1 ], 3 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 3, 0, 4, 0, 6, 0, 6, 0, 6, 0, 8, 0, 6, 0, 6, 0, 
          6, 0, 4, 0, 3, 0, 3, 0, 1, 0, 1, 0, 1 ], 18 ], 
  [ [ 1, 0, 1, 0, 1, 0, 3, 0, 3, 0, 4, 0, 6, 0, 6, 0, 6, 0, 8, 0, 6, 0, 6, 0, 
          6, 0, 4, 0, 3, 0, 3, 0, 1, 0, 1, 0, 1 ], 9 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 7, 0, 7, 0, 8, 0, 8, 0, 8, 0, 7, 0, 
          7, 0, 5, 0, 4, 0, 3, 0, 2, 0, 1, 0, 1 ], 12 ], 
  [ [ 1, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 7, 0, 7, 0, 8, 0, 8, 0, 8, 0, 7, 0, 
          7, 0, 5, 0, 4, 0, 3, 0, 2, 0, 1, 0, 1 ], 15 ], 
  [ [ 1, 0, 2, 0, 3, 0, 5, 0, 7, 0, 8, 0, 10, 0, 11, 0, 11, 0, 11, 0, 10, 0, 
          8, 0, 7, 0, 5, 0, 3, 0, 2, 0, 1 ], 26 ], 
  [ [ 1, 0, 2, 0, 3, 0, 5, 0, 7, 0, 8, 0, 10, 0, 11, 0, 11, 0, 11, 0, 10, 0, 
          8, 0, 7, 0, 5, 0, 3, 0, 2, 0, 1 ], 5 ], 
  [ [ 1, 0, 1, 0, 2, 0, 4, 0, 5, 0, 6, 0, 9, 0, 9, 0, 10, 0, 11, 0, 10, 0, 9, 
          0, 9, 0, 6, 0, 5, 0, 4, 0, 2, 0, 1, 0, 1 ], 6 ], 
  [ [ 1, 0, 1, 0, 2, 0, 4, 0, 5, 0, 6, 0, 9, 0, 9, 0, 10, 0, 11, 0, 10, 0, 9, 
          0, 9, 0, 6, 0, 5, 0, 4, 0, 2, 0, 1, 0, 1 ], 21 ], 
  [ [ 1, 0, 1, 0, 2, 0, 4, 0, 5, 0, 6, 0, 9, 0, 9, 0, 10, 0, 11, 0, 10, 0, 9, 
          0, 9, 0, 6, 0, 5, 0, 4, 0, 2, 0, 1, 0, 1 ], 12 ], 
  [ [ 1, 0, 1, 0, 2, 0, 4, 0, 5, 0, 6, 0, 9, 0, 9, 0, 10, 0, 11, 0, 10, 0, 9, 
          0, 9, 0, 6, 0, 5, 0, 4, 0, 2, 0, 1, 0, 1 ], 15 ], 
  [ [ 1, 0, 1, 0, 3, 0, 5, 0, 6, 0, 9, 0, 11, 0, 11, 0, 13, 0, 13, 0, 11, 0, 
          11, 0, 9, 0, 6, 0, 5, 0, 3, 0, 1, 0, 1 ], 4 ], 
  [ [ 1, 0, 1, 0, 3, 0, 5, 0, 6, 0, 9, 0, 11, 0, 11, 0, 13, 0, 13, 0, 11, 0, 
          11, 0, 9, 0, 6, 0, 5, 0, 3, 0, 1, 0, 1 ], 25 ], 
  [ [ 1, 0, 2, 0, 3, 0, 6, 0, 8, 0, 10, 0, 14, 0, 15, 0, 16, 0, 18, 0, 16, 0, 
          15, 0, 14, 0, 10, 0, 8, 0, 6, 0, 3, 0, 2, 0, 1 ], 6 ], 
  [ [ 1, 0, 2, 0, 3, 0, 6, 0, 8, 0, 10, 0, 14, 0, 15, 0, 16, 0, 18, 0, 16, 0, 
          15, 0, 14, 0, 10, 0, 8, 0, 6, 0, 3, 0, 2, 0, 1 ], 21 ], 
  [ [ 1, 0, 2, 0, 4, 0, 6, 0, 9, 0, 12, 0, 15, 0, 17, 0, 19, 0, 19, 0, 19, 0, 
          17, 0, 15, 0, 12, 0, 9, 0, 6, 0, 4, 0, 2, 0, 1 ], 10 ], 
  [ [ 1, 0, 2, 0, 4, 0, 6, 0, 9, 0, 12, 0, 15, 0, 17, 0, 19, 0, 19, 0, 19, 0, 
          17, 0, 15, 0, 12, 0, 9, 0, 6, 0, 4, 0, 2, 0, 1 ], 17 ], 
  [ [ 1, 0, 2, 0, 4, 0, 6, 0, 9, 0, 12, 0, 15, 0, 17, 0, 19, 0, 19, 0, 19, 0, 
          17, 0, 15, 0, 12, 0, 9, 0, 6, 0, 4, 0, 2, 0, 1 ], 22 ], 
  [ [ 1, 0, 2, 0, 4, 0, 6, 0, 9, 0, 12, 0, 15, 0, 17, 0, 19, 0, 19, 0, 19, 0, 
          17, 0, 15, 0, 12, 0, 9, 0, 6, 0, 4, 0, 2, 0, 1 ], 5 ], 
  [ [ 1, 0, 2, 0, 4, 0, 6, 0, 9, 0, 12, 0, 15, 0, 17, 0, 19, 0, 19, 0, 19, 0, 
          17, 0, 15, 0, 12, 0, 9, 0, 6, 0, 4, 0, 2, 0, 1 ], 20 ], 
  [ [ 1, 0, 2, 0, 4, 0, 6, 0, 9, 0, 12, 0, 15, 0, 17, 0, 19, 0, 19, 0, 19, 0, 
          17, 0, 15, 0, 12, 0, 9, 0, 6, 0, 4, 0, 2, 0, 1 ], 7 ], 
  [ [ 1, 0, 2, 0, 4, 0, 7, 0, 10, 0, 13, 0, 17, 0, 19, 0, 21, 0, 22, 0, 21, 
          0, 19, 0, 17, 0, 13, 0, 10, 0, 7, 0, 4, 0, 2, 0, 1 ], 6 ], 
  [ [ 1, 0, 2, 0, 4, 0, 7, 0, 10, 0, 13, 0, 17, 0, 19, 0, 21, 0, 22, 0, 21, 
          0, 19, 0, 17, 0, 13, 0, 10, 0, 7, 0, 4, 0, 2, 0, 1 ], 21 ], 
  [ [ 1, 0, 1, 0, 3, 0, 5, 0, 7, 0, 10, 0, 14, 0, 15, 0, 19, 0, 20, 0, 20, 0, 
          20, 0, 19, 0, 15, 0, 14, 0, 10, 0, 7, 0, 5, 0, 3, 0, 1, 0, 1 ], 10 ]
    , 
  [ [ 1, 0, 1, 0, 3, 0, 5, 0, 7, 0, 10, 0, 14, 0, 15, 0, 19, 0, 20, 0, 20, 0, 
          20, 0, 19, 0, 15, 0, 14, 0, 10, 0, 7, 0, 5, 0, 3, 0, 1, 0, 1 ], 13 ]
    , 
  [ [ 1, 0, 2, 0, 4, 0, 6, 0, 9, 0, 12, 0, 15, 0, 18, 0, 20, 0, 21, 0, 21, 0, 
          20, 0, 18, 0, 15, 0, 12, 0, 9, 0, 6, 0, 4, 0, 2, 0, 1 ], 16 ], 
  [ [ 1, 0, 2, 0, 4, 0, 6, 0, 9, 0, 12, 0, 15, 0, 18, 0, 20, 0, 21, 0, 21, 0, 
          20, 0, 18, 0, 15, 0, 12, 0, 9, 0, 6, 0, 4, 0, 2, 0, 1 ], 9 ], 
  [ [ 2, 0, 3, 0, 5, 0, 10, 0, 13, 0, 17, 0, 23, 0, 25, 0, 27, 0, 30, 0, 27, 
          0, 25, 0, 23, 0, 17, 0, 13, 0, 10, 0, 5, 0, 3, 0, 2 ], 18 ], 
  [ [ 2, 0, 3, 0, 5, 0, 10, 0, 13, 0, 17, 0, 23, 0, 25, 0, 27, 0, 30, 0, 27, 
          0, 25, 0, 23, 0, 17, 0, 13, 0, 10, 0, 5, 0, 3, 0, 2 ], 9 ], 
  [ [ 1, 0, 3, 0, 4, 0, 8, 0, 12, 0, 15, 0, 20, 0, 24, 0, 25, 0, 28, 0, 28, 
          0, 25, 0, 24, 0, 20, 0, 15, 0, 12, 0, 8, 0, 4, 0, 3, 0, 1 ], 8 ], 
  [ [ 1, 0, 3, 0, 4, 0, 8, 0, 12, 0, 15, 0, 20, 0, 24, 0, 25, 0, 28, 0, 28, 
          0, 25, 0, 24, 0, 20, 0, 15, 0, 12, 0, 8, 0, 4, 0, 3, 0, 1 ], 17 ], 
  [ [ 1, 0, 1, 0, 4, 0, 7, 0, 10, 0, 15, 0, 21, 0, 23, 0, 29, 0, 31, 0, 31, 
          0, 31, 0, 29, 0, 23, 0, 21, 0, 15, 0, 10, 0, 7, 0, 4, 0, 1, 0, 1 ], 
      16 ], 
  [ [ 1, 0, 1, 0, 4, 0, 7, 0, 10, 0, 15, 0, 21, 0, 23, 0, 29, 0, 31, 0, 31, 
          0, 31, 0, 29, 0, 23, 0, 21, 0, 15, 0, 10, 0, 7, 0, 4, 0, 1, 0, 1 ], 
      7 ], 
  [ [ 1, 0, 3, 0, 5, 0, 9, 0, 14, 0, 18, 0, 24, 0, 29, 0, 31, 0, 34, 0, 34, 
          0, 31, 0, 29, 0, 24, 0, 18, 0, 14, 0, 9, 0, 5, 0, 3, 0, 1 ], 14 ], 
  [ [ 1, 0, 3, 0, 5, 0, 9, 0, 14, 0, 18, 0, 24, 0, 29, 0, 31, 0, 34, 0, 34, 
          0, 31, 0, 29, 0, 24, 0, 18, 0, 14, 0, 9, 0, 5, 0, 3, 0, 1 ], 11 ], 
  [ [ 1, 0, 2, 0, 5, 0, 8, 0, 13, 0, 18, 0, 24, 0, 29, 0, 34, 0, 36, 0, 38, 
          0, 36, 0, 34, 0, 29, 0, 24, 0, 18, 0, 13, 0, 8, 0, 5, 0, 2, 0, 1 ], 
      14 ], 
  [ [ 1, 0, 2, 0, 5, 0, 8, 0, 13, 0, 18, 0, 24, 0, 29, 0, 34, 0, 36, 0, 38, 
          0, 36, 0, 34, 0, 29, 0, 24, 0, 18, 0, 13, 0, 8, 0, 5, 0, 2, 0, 1 ], 
      9 ], 
  [ [ 1, 0, 2, 0, 5, 0, 8, 0, 14, 0, 19, 0, 26, 0, 31, 0, 37, 0, 39, 0, 41, 
          0, 39, 0, 37, 0, 31, 0, 26, 0, 19, 0, 14, 0, 8, 0, 5, 0, 2, 0, 1 ], 
      8 ], 
  [ [ 1, 0, 2, 0, 5, 0, 8, 0, 14, 0, 19, 0, 26, 0, 31, 0, 37, 0, 39, 0, 41, 
          0, 39, 0, 37, 0, 31, 0, 26, 0, 19, 0, 14, 0, 8, 0, 5, 0, 2, 0, 1 ], 
      15 ], 
  [ [ 1, 0, 2, 0, 5, 0, 9, 0, 14, 0, 20, 0, 27, 0, 32, 0, 38, 0, 41, 0, 42, 
          0, 41, 0, 38, 0, 32, 0, 27, 0, 20, 0, 14, 0, 9, 0, 5, 0, 2, 0, 1 ], 
      10 ], 
  [ [ 1, 0, 2, 0, 5, 0, 9, 0, 14, 0, 20, 0, 27, 0, 32, 0, 38, 0, 41, 0, 42, 
          0, 41, 0, 38, 0, 32, 0, 27, 0, 20, 0, 14, 0, 9, 0, 5, 0, 2, 0, 1 ], 
      13 ], 
  [ [ 2, 0, 4, 0, 7, 0, 13, 0, 19, 0, 26, 0, 35, 0, 41, 0, 46, 0, 51, 0, 50, 
          0, 48, 0, 45, 0, 37, 0, 30, 0, 24, 0, 15, 0, 10, 0, 6, 0, 2, 0, 1 ],
      12 ], 
  [ [ 1, 0, 2, 0, 6, 0, 10, 0, 15, 0, 24, 0, 30, 0, 37, 0, 45, 0, 48, 0, 50, 
          0, 51, 0, 46, 0, 41, 0, 35, 0, 26, 0, 19, 0, 13, 0, 7, 0, 4, 0, 2 ],
      11 ] ];

#############################################################################
##
#F  CHEVIE.E7.ClassParam( <w> )  . . . . . . . . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type E_7  as word in  standard
##  generators, 'CHEVIE.E7.ClassParam' returns the classparam of its conjugacy
##  class.
##
CHEVIE.E7.ClassParam:=function(w)
  local x, exc, str;
  if w=[] then return " ";fi;
  exc:=[ [ 3, 2,,, 19 ], [ 12,, 25 ], [ 60 ] ];
  x:=Product(CHEVIE.E7.generators{w});
  str:=CycleStructurePerm(x);
  if str in exc then
    str:=[str,CycleStructurePerm(x*CHEVIE.E7.longestperm)];
  fi;
  return CHEVIE.E7.classparams[Position(CHEVIE.E7.cyclestructure,str)];
end;

###########################################################################
##
#F CHEVIE.E7.HeckeCharTable( <v> ) character table of the Hecke algebra of type E7
##
## Note: the parameter for the Hecke algebra is <v>^2.
##       the character table is obtained by v->1 .
##
CHEVIE.E7.HeckeCharTable:=v->rec(
  identifier:="H(E7)",
  text := "origin: Meinolf Geck, July 1992",
  cartan:=CHEVIE.E7.cartan, 
  parameter := [ v^2, v^2, v^2, v^2, v^2, v^2, v^2 ], 
  size := 2903040,
  powermap:=CHEVIE.E7.powermap, 
  classtext := CHEVIE.E7.classtext,
  classnames := CHEVIE.E7.classnames,
  classparam := CHEVIE.E7.classnames,
  orders := CHEVIE.E7.orders, 
  centralizers := CHEVIE.E7.centralizers, 
  classes := CHEVIE.E7.classes,
  irreducibles:=List(CHEVIE.E7.vpolheckeirreducibles,
                     i->List(i,j->FastValue(j,v))),
  irredinfo:=List(CHEVIE.E7.CharParams(),x->
                       rec(charparam:=x,charname:=CHEVIE.E7.CharName(x))),
  operations := CharTableOps ); 
