#############################################################################
##
#A  weylf.g                     CHEVIE library                   Meinolf Geck
##
#A  $Id: weylf.g,v 1.1 1997/01/21 13:46:58 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains the character table of the Hecke algebra of type F4.
##

CHEVIE.F4:=rec();

CHEVIE.F4.classtext:=
[ [  ], [ 1, 2, 1, 3, 2, 1, 3, 2, 3, 4, 3, 2, 1, 3, 2, 3, 4, 3, 2, 1, 3, 
   2, 3, 4 ], [ 2, 3, 2, 3 ], [ 2, 1 ], [ 2, 3, 2, 3, 4, 3, 2, 1, 3, 4 ], 
  [ 3, 2, 4, 3, 2, 1, 3, 2, 4, 3, 2, 1 ], [ 4, 3 ], 
  [ 1, 2, 1, 4, 3, 2, 1, 3, 2, 3 ], 
  [ 3, 2, 1, 4, 3, 2, 1, 3, 2, 3, 4, 3, 2, 1, 3, 2 ], 
  [ 3, 2, 4, 3, 2, 1, 3, 2 ], [ 4, 3, 2, 1 ], [ 1 ], 
  [ 2, 3, 2, 3, 4, 3, 2, 3, 4 ], [ 1, 4, 3 ], [ 4, 3, 2 ], 
  [ 2, 3, 2, 1, 3 ], [ 3 ], [ 1, 2, 1, 3, 2, 1, 3, 2, 3 ], [ 2, 1, 4 ], 
  [ 3, 2, 1 ], [ 2, 4, 3, 2, 3 ], [ 1, 3 ], [ 3, 2 ], 
      [ 2, 3, 2, 3, 4, 3, 2, 1, 3, 2, 4, 3, 2, 1 ], [ 2, 4, 3, 2, 1, 3 ] ];

CHEVIE.F4.classnames:=[" ","4A_1","2A_1","A_2","D_4","D_4(a_1)","~A_2","C_3+A_1",
  "A_2+~A_2", "F_4(a_1)", "F_4", "A_1", "3A_1", "~A_2+A_1", "C_3",
  "A_3", "~A_1", "2A_1+~A_1", "A_2+~A_1", "B_3", "B_2+A_1",
  "A_1+~A_1", "B_2", "A_3+~A_1", "B_4"];

#how to make a .charname from a .charparam
CHEVIE.F4.CharName:= function(x)local s;
  s:=Concatenation("phi_{",String(x[1]),",",String(x[2]),"}");
  if Length(x)=3 then Append(s,x[3]);fi;
  return String(s);
end;

CHEVIE.F4.CharParams:=function()
  return [ [1,0], [1,12,"''"], [1,12,"'"], [1,24], [2,4,"''"], [2,16,"'"],
  [2,4,"'"], [2,16,"''"], [4,8], [9,2], [9,6,"''"], [9,6,"'"], [9,10],
  [6,6,"'"], [6,6,"''"], [12,4], [4,1], [4,7,"''"], [4,7,"'"], [4,13],
  [8,3,"''"], [8,9,"'"], [8,3,"'"], [8,9,"''"], [16,5]];
end;

# indices for the names of the characters in Kondo's table, 
# see [Carter-book,p.413]:
#CHEVIE.F4.kondo:=[[1,1],[1,2],[1,3],[1,4],[2,1],[2,2],[2,3],[2,4],[4],[9,1],
# [9,2],[9,3],[9,4],[6,1],[6,2],[12],[4,1],[4,2],[4,3],[4,4],[8,1],
# [8,2],[8,3],[8,4],[16]];
CHEVIE.F4.kondo:=[ "1_1","1_2","1_3","1_4","2_1","2_2","2_3","2_4",
  "4_1","9_1","9_2","9_3","9_4","6_1","6_2","12","4_2","4_3","4_4","4_5",
  "8_1", "8_2","8_3","8_4","16"];

CHEVIE.F4.cyclestructure:=[[[],[]],[[12],[12]],[[10],[10]],
  [[,8],[,6]],[[,,,,4],[3,,,,3]],[[,,6],[,,6]],
  [[,6],[,8]],[[3,,,,3],[,,,,4]],[[,8],[,8]],
  [[,,,,4],[,,,,4]],[[,,,,,,,,,,2],[,,,,,,,,,,2]],
  [[9],[6]],[[11],[12]],[[3,2,,,2],[,4,,,2]],
  [[2,,,,3],[,,,,4]],[[2,,5],[1,,5]],[[6],[9]],
  [[12],[11]],[[,4,,,2],[3,2,,,2]],
  [[,,,,4],[2,,,,3]],[[1,,5],[2,,5]],[[11],[11]],
  [[,,5],[,,5]],[[2,,5],[2,,5]], [[,,,,,,3],[,,,,,,3]]];

CHEVIE.F4.generators:=
[(1,25)(2,5)(6,8)(9,11)(10,12)(13,15)(16,18)(23,24)(26,29)(30,32)
  (33,35)(34,36)(37,39)(40,42)(47,48),(1,5)(2,26)(3,6)(7,10)(11,14)
  (15,17)(18,20)(22,23)(25,29)(27,30)(31,34)(35,38)(39,41)(42,44)(46,47),
  (2,9)(3,27)(4,7)(5,11)(10,13)(12,15)(17,19)(20,22)(26,33)(28,31)
  (29,35)(34,37)(36,39)(41,43)(44,46),(3,7)(4,28)(6,10)(8,12)(9,16)
  (11,18)(14,20)(19,21)(27,31)(30,34)(32,36)(33,40)(35,42)(38,44)(43,45)];

CHEVIE.F4.orbits:= [ [ 1, 25, 5, 29, 2, 11, 26, 35, 
  9, 14, 18, 33, 38, 42, 16, 20, 40, 44, 22, 46, 23, 47, 24, 48 ], 
  [ 3, 6, 27, 7, 8, 10, 30, 31, 4, 12, 13, 32, 34, 28, 15, 36, 37, 17, 39, 
  19, 41, 21, 43, 45 ] ];

CHEVIE.F4.cartan:=[ [ 2, -1, 0, 0 ], [ -1, 2, -1, 0 ], [ 0, -2, 2, -1 ], 
        [ 0, 0, -1, 2 ] ];

CHEVIE.F4.powermap:=[ , [ 1, 1, 1, 4, 4, 2, 7, 7, 9, 9, 10, 1, 1, 
  7, 7, 3, 1, 1, 4, 4, 3, 1, 3, 3, 6 ], 
  [ 1, 2, 3, 1, 2, 6, 1, 2, 1, 2, 6, 12, 13, 12, 13, 16, 17, 18, 17, 
  18, 21, 22, 23, 24, 25 ] ];

CHEVIE.F4.orders:=[ 1, 2, 2, 3, 6, 4, 3, 6, 3, 6, 12, 2, 2, 6, 6, 4, 2, 2, 6,
  6, 4, 2, 4, 4, 8 ];

CHEVIE.F4.centralizers:=[ 1152, 1152, 64, 36, 36, 96, 36, 36, 72, 72, 12, 96, 96, 
  12, 12, 16, 96, 96, 12, 12, 16, 16, 32, 32, 8 ];

CHEVIE.F4.classes:=[ 1, 1, 18, 32, 32, 12, 32, 32, 16, 16, 96, 12, 12, 96, 96,
  72, 12, 12, 96, 96, 72, 72, 36, 36, 144 ];

CHEVIE.F4.PositionId:=function() return 1; end;

CHEVIE.F4.PositionSgn:=function() return 4; end;

CHEVIE.F4.PositionRefl:=function() return 17; end;

CHEVIE.F4.vpolfakedegrees:=
[ [ [ 1 ], 0 ], [ [ 1 ], 12 ], [ [ 1 ], 12 ], [ [ 1 ], 24 ], 
  [ [ 1, 0, 0, 0, 1 ], 4 ], [ [ 1, 0, 0, 0, 1 ], 16 ], 
  [ [ 1, 0, 0, 0, 1 ], 4 ], [ [ 1, 0, 0, 0, 1 ], 16 ], 
  [ [ 1, 0, 0, 0, 2, 0, 0, 0, 1 ], 8 ], 
  [ [ 1, 0, 1, 0, 2, 0, 1, 0, 2, 0, 1, 0, 1 ], 2 ], 
  [ [ 1, 0, 1, 0, 2, 0, 1, 0, 2, 0, 1, 0, 1 ], 6 ], 
  [ [ 1, 0, 1, 0, 2, 0, 1, 0, 2, 0, 1, 0, 1 ], 6 ], 
  [ [ 1, 0, 1, 0, 2, 0, 1, 0, 2, 0, 1, 0, 1 ], 10 ], 
  [ [ 1, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, 0, 1 ], 6 ], 
  [ [ 1, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, 0, 1 ], 6 ], 
  [ [ 1, 0, 0, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 0, 0, 0, 1 ], 4 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1 ], 7 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1 ], 7 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1 ], 13 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 1, 0, 1 ], 3 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 1, 0, 1 ], 9 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 1, 0, 1 ], 3 ], 
  [ [ 1, 0, 1, 0, 1, 0, 2, 0, 1, 0, 1, 0, 1 ], 9 ], 
  [ [ 1, 0, 2, 0, 2, 0, 3, 0, 3, 0, 2, 0, 2, 0, 1 ], 5 ] ];

CHEVIE.F4.chara:=[ 0, 4, 4, 24, 1, 13, 1, 13, 4, 2, 4, 4, 10, 4, 4, 4, 1, 4,
  4, 13, 3, 9, 3, 9, 4 ];

CHEVIE.F4.charA:=[ 0, 20, 20, 24, 11, 23, 11, 23, 20, 14, 20, 20, 22, 20, 20,
  20, 11, 20, 20, 23, 15, 21, 15, 21, 20 ];

#############################################################################
##
#F  CHEVIE.F4.ClassParam( <w> )  . . . . . . . . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type F_4  as word in  standard
##  generators, 'CHEVIE.F4.ClassParam' returns the classparam of its conjugacy
##  class.
##
CHEVIE.F4.ClassParam:=function(w)local x;
  if w=[] then return " ";fi;
  x:=Product(CHEVIE.F4.generators{w});
  return CHEVIE.F4.classparams[Position(CHEVIE.F4.cyclestructure,
    [CycleStructurePerm(RestrictedPerm(x,CHEVIE.F4.orbits[1])),
     CycleStructurePerm(RestrictedPerm(x,CHEVIE.F4.orbits[2]))])];
end;

###########################################################################
##
#F  CHEVIE.F4.HeckeCharTable( <para> )  . . . . . . . . . . . . . . . . . . .
##  . . . . . . . . . . . . character table of the Hecke algebra of type F4
##
##  'CHEVIE.F4.HeckeCharTable' returns the character table of the Hecke algebra
##  of type F4 with  parameters  given  by  a  list  <para>.  If <para> is a 
##  single constant  not  a  list  then  all  parameters are  assumed to be 
##  equal. 
##
##  Note:  the  parameters  for  the  Hecke  algebra are the same as  those
##  given by <para>.
##
CHEVIE.F4.HeckeCharTable:=function(arg)local u,v,c;
  u:=arg[1];
  if Length(arg)=1 then v:=u;
  else v:=arg[2];
  fi;
  return rec( 
  identifier := "H(F4)", 
  text := "origin: Meinolf Geck, April 1992",
  parameter := [ u ,u ,v ,v ],
  cartan:=CHEVIE.F4.cartan, 
  size := 1152, 
  powermap:=CHEVIE.F4.powermap, 
  classtext := CHEVIE.F4.classtext,
  classnames := CHEVIE.F4.classnames,
  classparam := CHEVIE.F4.classnames,
  orders := CHEVIE.F4.orders, 
  centralizers := CHEVIE.F4.centralizers, 
  classes := CHEVIE.F4.classes,
  irreducibles := [
  [1, v^12*u^12, v^2*u^2, u^2, v^6*u^4, u^6*v^6, v^2, v^4*u^6, v^8
  *u^8, v^4*u^4, v^2*u^2, u, v^6*u^3, u*v^2, u*v^2, v^2*u^3, v, v^3*u
  ^6, u^2*v, u^2*v, v^3*u^2, u*v, u*v, v^7*u^7, v^3*u^3],
  [1, u^12, u^2, u^2, u^4, u^6, 1, u^6, u^8, u^4, u^2, u, u^3, u, u, u
  ^3, -1, -u^6, -u^2, -u^2, -u^2, -u, -u, -u^7, -u^3],
  [1, v^12, v^2, 1, v^6, v^6, v^2, v^4, v^8, v^4, v^2, -1, -v^6, -v^2
  , -v^2, -v^2, v, v^3, v, v, v^3, -v, -v, -v^7, -v^3],
  [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
    -1, 1, 1, 1, 1],
  [2, 2*v^6*u^12, u^2+v^2*u^2, 2*u^2, 2*v^3*u^4, 2*v^3*u^6, -v, -v^2*u
  ^6, -v^4*u^8, -v^2*u^4, -u^2*v, 2*u, 2*v^3*u^3, -u*v, -u*v, v^2*u^3+u
  ^3, v-1, v^3*u^6-u^6, u^2*v-u^2, u^2*v-u^2, 0, u*v-u, u*v-u, v^4*u^7-
  v^3*u^7, 0],
  [2, 2*v^6, v^2+1, 2, 2*v^3, 2*v^3, -v, -v^2, -v^4, -v^2, -v, -2, -2*v^3
  , v, v, -1-v^2, v-1, -1+v^3, v-1, v-1, 0, 1-v, 1-v, v^3-v^4, 0],
  [2, 2*v^12*u^6, v^2+v^2*u^2, -u, -v^6*u^2, 2*v^6*u^3, 2*v^2, 2*v^4*u
  ^3, -v^8*u^4, -v^4*u^2, -u*v^2, -1+u, -v^6+v^6*u^3, -v^2+u*v^2, -v^
  2+u*v^2, 0, 2*v, 2*v^3*u^3, -u*v, -u*v, v^3+v^3*u^2, -v+u*v, -v+u*v, -v^
  7*u^3+v^7*u^4, 0],
  [2, 2*u^6, u^2+1, -u, -u^2, 2*u^3, 2, 2*u^3, -u^4, -u^2, -u, -1+u, u^3-
  1, -1+u, -1+u, 0, -2, -2*u^3, u, u, -u^2-1, -u+1, -u+1, -u^4+u^3, 0],
  [4, 4*u^6*v^6, v^2+v^2*u^2+u^2+1, -2*u, -2*v^3*u^2, 4*v^3*u^3, -2*v, 
  -2*v^2*u^3, v^4*u^4, v^2*u^2, u*v, 2*u-2, -2*v^3+2*v^3*u^3, v-u*v, v-u
  *v, 0, 2*v-2, 2*v^3*u^3-2*u^3, -u*v+u, -u*v+u, 0, u*v-v+1-u, u*v-v+1-u, -v^
  4*u^3+v^4*u^4-v^3*u^4+v^3*u^3, 0],
  [9, 9*v^8*u^8, 3*v^2*u^2-4*u*v+u^2+v^2, -3*u+3*u^2, 0, -3*v^4*u^4, 3*v
  ^2-3*v, 0, 0, 0, 0, 6*u-3, v^6*u^3+2*v^3*u^3-3*v^4*u^2+3*v^4*u, 2*u*v^
  2-2*u*v-v^2+v, u*v^2-u*v, v^2*u^3-2*u^2*v, 6*v-3, v^3*u^6+2*v^3*u^3-3*
  v^2*u^4+3*u^4*v, 2*u^2*v-u^2-2*u*v+u, u^2*v-u*v, -2*u*v^2+v^3*u^2, 4*u
  *v-2*u-2*v+1, 3*u*v-u-v, v^4*u^5-v^5*u^5+v^5*u^4, -v^2*u^2],
  [9, 9*v^4*u^8, v^2*u^2+1-4*u*v+3*u^2, -3*u+3*u^2, 0, -3*v^2*u^4, 3-3*v
  , 0, 0, 0, 0, 6*u-3, -3*v^2*u^2+2*v^3*u^3+3*u*v^2+u^3, 2*u-2*u*v-1+v, -u*
  v+u, u^3-2*u^2*v, -6+3*v, 3*u^4*v-3*v^2*u^4-u^6-2*u^3, u^2*v-2*u^2-u*v
  +2*u, u-u^2, -u^2+2*u*v, -4*u+2*u*v+2-v, -3*u+u*v+1, -v^3*u^5+v^2*u^5-v^
  2*u^4, u^2*v],
  [9, 9*v^8*u^4, 1+v^2*u^2-4*u*v+3*v^2, -3*u+3, 0, -3*v^4*u^2, 3*v^2-3*v
  , 0, 0, 0, 0, -6+3*u, 3*v^4*u-2*v^3-3*v^4*u^2-v^6, -2*v^2+2*v+u*v^2-u*v
  , -v^2+v, -v^2+2*u*v, 6*v-3, -3*v^2*u^2+3*u^2*v+v^3+2*v^3*u^3, 2*v-1-2*
  u*v+u, v-u*v, -2*u*v^2+v^3, -4*v+2+2*u*v-u, -3*v+1+u*v, v^5*u^2-v^4*u^2-v
  ^5*u^3, u*v^2],
  [9, 9*v^4*u^4, 3-4*u*v+u^2+v^2, -3*u+3, 0, -3*v^2*u^2, 3-3*v, 0, 0, 0, 0
  , -6+3*u, -1+3*u*v^2-3*v^2*u^2-2*v^3, -u*v+u-2+2*v, v-1, -1+2*u*v, -6+3*v, 
  -1+3*u^2*v-2*u^3-3*v^2*u^2, -u*v+2*u+v-2, -1+u, -1+2*u*v, 4-2*v+u*v-2*u, 3-
  v-u, v^3*u^2-v^2*u^2+v^2*u^3, -u*v],
  [6, 6*u^6*v^6, u^2-4*u*v+v^2, 1-2*u+u^2, v^2*u^2+v^4*u^2-2*v^3*u^2, 
  2*v^3*u^3, 1+v^2-2*v, v^2*u^2-2*v^2*u^3+v^2*u^4, 3*v^4*u^4, 3*v^2*u
  ^2, -u*v, -3+3*u, -3*v^2*u^2+3*v^4*u, u*v^2-u*v+v-1, 0, u*v-u^2*v, -3+3*v
  , -3*v^2*u^2+3*u^4*v, u^2*v-u*v+u-1, 0, -u*v^2+u*v, -u+2*u*v-v+2, -v-u, -v
  ^4*u^3-v^3*u^4, 0],
  [6, 6*u^6*v^6, -4*u*v+v^2*u^2+1, 1-2*u+u^2, v^2*u^2+v^4*u^2-2*v^3*u^
  2, 2*v^3*u^3, 1+v^2-2*v, v^2*u^2-2*v^2*u^3+v^2*u^4, 3*v^4*u^4, 3*v^
  2*u^2, -u*v, -3+3*u, 3*u*v^2-3*v^4*u^2, -v^2+v-u*v+u, 0, u*v-u^2*v, -3+3*
  v, -3*v^2*u^4+3*u^2*v, -u^2-u*v+u+v, 0, -u*v^2+u*v, -2*u+u*v-2*v+1, u*v+1
  , v^4*u^4+v^3*u^3, 0],
  [12, 12*u^6*v^6, 1+v^2*u^2-8*u*v+u^2+v^2, 2*u^2-4*u+2, 2*v^3*u^2-v^4*
  u^2-v^2*u^2, 4*v^3*u^3, 2-4*v+2*v^2, 2*v^2*u^3-v^2*u^4-v^2*u^2, -3*
  v^4*u^4, -3*v^2*u^2, u*v, -6+6*u, -3*v^2*u^2+3*u*v^2-3*v^4*u^2+3*v^4*
  u, -2*u*v+u+u*v^2-v^2+2*v-1, 0, 2*u*v-2*u^2*v, -6+6*v, -3*v^2*u^2+3*u^2*v
  -3*v^2*u^4+3*u^4*v, u^2*v-u^2-2*u*v+2*u+v-1, 0, -2*u*v^2+2*u*v, 3-3*u-3*v
  +3*u*v, u*v-v+1-u, -v^4*u^3+v^4*u^4-v^3*u^4+v^3*u^3, 0],
  [4, -4*v^9*u^9, 2*v^2*u^2-2*u*v, 2*u^2-u, -2*v^4*u^3+v^5*u^3, 0, 2*v^
  2-v, v^3*u^5-2*v^3*u^4, -2*u^6*v^6, 2*v^3*u^3, 0, 3*u-1, -3*v^4*u^2+v
  ^6*u^3, -u*v+u*v^2-v^2, u*v^2, v^2*u^3-u^2*v, 3*v-1, v^3*u^6-3*v^2*u
  ^4, -u^2+u^2*v-u*v, u^2*v, -u*v^2+v^3*u^2, 2*u*v-u-v, 2*u*v, -2*v^5*u^
  5, 0],
  [4, -4*v^3*u^9, 2*u^2-2*u*v, 2*u^2-u, u^3*v-2*v^2*u^3, 0, -v+2, -2*u^4*
  v+u^5*v, -2*v^2*u^6, 2*u^3*v, 0, 3*u-1, u^3-3*v^2*u^2, -u*v+u-1, u, u^3
  -u^2*v, -3+v, -u^6+3*u^4*v, u^2*v-u^2+u, -u^2, -u^2+u*v, u*v-2*u+1, -2*u
  , 2*v^2*u^5, 0],
  [4, -4*u^3*v^9, -2*u*v+2*v^2, 2-u, v^5*u-2*v^4*u, 0, 2*v^2-v, -2*v^3*u^
  2+v^3*u, -2*v^6*u^2, 2*v^3*u, 0, -3+u, 3*v^4*u-v^6, u*v^2-v^2+v, -v^2
  , -v^2+u*v, 3*v-1, v^3-3*v^2*u^2, -u*v+v-1, v, -u*v^2+v^3, u*v+1-2*v, -2*
  v, 2*v^5*u^2, 0],
  [4, -4*v^3*u^3, 2-2*u*v, 2-u, -2*u*v^2+u*v, 0, -v+2, u*v-2*u^2*v, -2*v^2*u
  ^2, 2*u*v, 0, -3+u, 3*u*v^2-1, v-1+u, -1, -1+u*v, -3+v, -1+3*u^2*v, v-1+u, -
  1, -1+u*v, 2-v-u, 2, -2*v^2*u^2, 0],
  [8, -8*v^6*u^9, 2*v^2*u^2-4*u*v+2*u^2, 4*u^2-2*u, -v^4*u^3-v^2*u^3, 0
  , -3*v+1+v^2, 2*v^2*u^4-v^2*u^5, 2*v^4*u^6, -2*v^2*u^3, 0, 6*u-2, 2*v
  ^3*u^3-3*v^4*u^2-3*v^2*u^2, u*v^2-2*u*v+v+u, -u*v, v^2*u^3-2*u^2*v+u
  ^3, 4*v-4, -u^6+v^3*u^6-3*v^2*u^4+3*u^4*v, 2*u^2*v-u*v-2*u^2+u, u^2*v
  -u^2, -u*v^2+u*v, 3*u*v-v-3*u+1, 2*u*v-2*u, 0, 0],
  [8, -8*v^6*u^3, 2*v^2-4*u*v+2, 4-2*u, -v^4*u-u*v^2, 0, -3*v+1+v^2, 2*v^2
  *u^2-u*v^2, 2*v^4*u^2, -2*u*v^2, 0, -6+2*u, -2*v^3+3*u*v^2+3*v^4*u, -u*
  v-1-v^2+2*v, v, 2*u*v-1-v^2, 4*v-4, v^3-3*v^2*u^2+3*u^2*v-1, -u*v+u-2+2*v
  , v-1, -u*v^2+u*v, u*v-u-3*v+3, 2-2*v, 0, 0],
  [8, -8*v^9*u^6, 2*v^2*u^2-4*u*v+2*v^2, -3*u+1+u^2, -v^5*u^2+2*v^4*u^2
  , 0, -2*v+4*v^2, -v^3*u^4-v^3*u^2, 2*v^6*u^4, -2*v^3*u^2, 0, -4+4*u, v
  ^6*u^3-3*v^4*u^2+3*v^4*u-v^6, -u*v+2*u*v^2+v-2*v^2, -v^2+u*v^2, u*v-u
  ^2*v, 6*v-2, 2*v^3*u^3-3*v^2*u^4-3*v^2*u^2, u^2*v+u-2*u*v+v, -u*v, v^3
  *u^2-2*u*v^2+v^3, 3*u*v-u-3*v+1, -2*v+2*u*v, 0, 0],
  [8, -8*v^3*u^6, 2*u^2-4*u*v+2, -3*u+1+u^2, -u^2*v+2*v^2*u^2, 0, -2*v+4, 
  -u^4*v-u^2*v, 2*v^2*u^4, -2*u^2*v, 0, -4+4*u, u^3-3*v^2*u^2+3*u*v^2-1
  , -u*v+2*u+v-2, -1+u, u*v-u^2*v, -6+2*v, -2*u^3+3*u^2*v+3*u^4*v, -u^2-u*v+
  2*u-1, u, -u^2+2*u*v-1, -3*u+u*v-v+3, -2*u+2, 0, 0],
  [16, -16*u^6*v^6, 2+2*v^2*u^2-8*u*v+2*v^2+2*u^2, -6*u+2*u^2+2, v^4*u^2
  +v^2*u^2, 0, 2*v^2-6*v+2, v^2*u^4+v^2*u^2, -2*v^4*u^4, 2*v^2*u^2, 0
  , -8+8*u, -3*v^2*u^2+3*u*v^2-2*v^3+2*v^3*u^3-3*v^4*u^2+3*v^4*u, u*v^2
  -3*u*v-v^2+3*v-1+u, v-u*v, 2*u*v-2*u^2*v, -8+8*v, 3*u^2*v-3*v^2*u^2-2*u^3
  +2*v^3*u^3-3*v^2*u^4+3*u^4*v, -3*u*v+3*u+u^2*v+v-1-u^2, -u*v+u, -2*u*v^
  2+2*u*v, 4-4*v+4*u*v-4*u, -2*v+2*u*v+2-2*u, 0, 0]]*v^0, 
  irredinfo:=List(CHEVIE.F4.CharParams(),x->
                       rec(charparam:=x,charname:=CHEVIE.F4.CharName(x))),
  operations := CharTableOps);
end;

CHEVIE.F4.SchurElements:=
[ function(u,v)return (u+1)*(u^2+u+1)*(v+1)*(v^2+v+1)*(u^2*v+1)*(u^2*v^2+1)*
                      (u*v^2+1)*(u^2*v^2-u*v+1)*(u*v+1)^2;end,
  function(u,v)return (u+v)^2*(u^2-u*v+v^2)*(u^2+v^2)*(u+v^2)*(u^2+v)*(u+1)*
                      (u^2+u+1)*(v+1)*(v^2+v+1)/v^12;end,
  function(u,v)return (u+v)^2*(u^2-u*v+v^2)*(u^2+v^2)*(u+v^2)*(u^2+v)*(u+1)*
                      (u^2+u+1)*(v+1)*(v^2+v+1)/u^12;end,
  function(u,v)return (u+1)*(u^2+u+1)*(v+1)*(v^2+v+1)*(u^2*v+1)*(u^2*v^2+1)*
                      (u*v^2+1)*(u^2*v^2-u*v+1)*(u*v+1)^2/u^12/v^12;end,
  function(u,v)return (u+1)^2*(u^2+u+1)*(v^2+v+1)*(u*v+1)*(u^2*v+1)*(u^2-u+1)*
                      (u+v)*(u^2+v)/v^3;end,
  function(u,v)return (u+1)^2*(u^2+u+1)*(v^2+v+1)*(u*v+1)*(u^2*v+1)*(u^2-u+1)*
                      (u+v)*(u^2+v)/v^3/u^12;end,
  function(u,v)return (u^2+u+1)*(v+1)^2*(v^2+v+1)*(u*v+1)*(u*v^2+1)*(v^2-v+1)*
                      (u+v)*(u+v^2)/u^3;end,
  function(u,v)return (u^2+u+1)*(v+1)^2*(v^2+v+1)*(u*v+1)*(u*v^2+1)*(v^2-v+1)*
                      (u+v)*(u+v^2)/u^3/v^12;end,
  function(u,v)return 2*(u^2+u+1)*(v^2+v+1)*(u*v+1)^2*(u+v)^2/u^3/v^3;end,
  function(u,v)return (u^2+v)*(u+v^2)*(u+1)*(v+1)*(u^2*v^2+1)*
                      (u*v+1)^2/u^2/v^2;end,
  function(u,v)return (u^2+v^2)*(u+v)^2*(u+1)*(v+1)*(u^2*v+1)*
                      (u*v^2+1)/u^2/v^6;end,
  function(u,v)return (u^2+v^2)*(u+v)^2*(u+1)*(v+1)*(u^2*v+1)*
                      (u*v^2+1)/u^6/v^2;end,
  function(u,v)return (u^2+v)*(u+v^2)*(u+1)*(v+1)*(u^2*v^2+1)*
                      (u*v+1)^2/u^6/v^6;end,
  function(u,v)return 3*(u+1)^2*(v+1)^2*(u*v+1)^2*(u^2-u*v+v^2)/u^3/v^3;end,
  function(u,v)return 3*(u+1)^2*(v+1)^2*(u^2*v^2-u*v+1)*(u+v)^2/u^3/v^3;end,
  function(u,v)return 6*(u*v+1)^2*(v^2-v+1)*(u^2-u+1)*(u+v)^2/u^3/v^3;end,
  function(u,v)return (u+v)*(u+1)*(u^2+u+1)*(v+1)*(v^2+v+1)*(u^2*v^2-u*v+1)*
                      (u*v+1)^2/u/v;end,
  function(u,v)return (u+1)*(u^2+u+1)*(v+1)*(v^2+v+1)*(u*v+1)*(u+v)^2*
                      (u^2-u*v+v^2)/u/v^7;end,
  function(u,v)return (u+1)*(u^2+u+1)*(v+1)*(v^2+v+1)*(u*v+1)*(u+v)^2*
                      (u^2-u*v+v^2)/v/u^7;end,
  function(u,v)return (u+v)*(u+1)*(u^2+u+1)*(v+1)*(v^2+v+1)*(u^2*v^2-u*v+1)*
                      (u*v+1)^2/u^7/v^7;end,
  function(u,v)return (u+v^2)*(u+1)^2*(u^2-u+1)*(u^2+u+1)*(v^2+v+1)*
                      (u*v^2+1)/u/v^3;end,
  function(u,v)return (u+v^2)*(u+1)^2*(u^2-u+1)*(u^2+u+1)*(v^2+v+1)*
                      (u*v^2+1)/v^3/u^7;end,
  function(u,v)return (u^2+v)*(v+1)^2*(v^2-v+1)*(u^2+u+1)*(v^2+v+1)*
                      (u^2*v+1)/u^3/v;end,
  function(u,v)return (u^2+v)*(v+1)^2*(v^2-v+1)*(u^2+u+1)*(v^2+v+1)*
                      (u^2*v+1)/u^3/v^7;end,
  function(u,v)return 2*(u^2+u+1)*(v^2+v+1)*(u^2*v^2+1)*(u^2+v^2)/u^3/v^3;end];

#############################################################################
##
#F  CHEVIE.F4.SchurElement( <phi>, <u>, <v>) . . .  Schur elements for type F4
##
##  'CHEVIE.F4.SchurElements' returns the constants arising  from  the  Schur
##  relations for  the  irreducible  characters  <phi> of  the  Hecke
##  of type  F4  with parameters  u, v.  If v is omitted  it is assumed
##  to be equal to u.
##
##  The  constant  corresponding  to  phi  is  defined  to  be P/D   where
##  P is the Poincare    polynomial and D  is the generic degree of  phi.
##
CHEVIE.F4.SchurElement:=function(arg)
  if Length(arg)=2 then arg[3]:=arg[1];fi;
  return CHEVIE.F4.SchurElements[Position(CHEVIE.F4.CharParams(),
                                              arg[1])](arg[2],arg[3]);
end;
