###############################################################################
##
##  dispatch.g  GLISSANDO ver 1.0  Christof Noebauer   1995, 1996
##                                                       
##
#############################################################################
##  Dispatchers of functions for both nearrings and semigroups
#############################################################################
##
#############################################################################
##
#F  DisplayCayleyTable( <D> ). . .nicely print a Cayley table of a domain <D> 
##
##  Dispatcher function for printing a Cayley table of <D>.
##  Works for <D> = a semigroup or a group or a nearring.
##
DisplayCayleyTable := function( D )
  if IsGroup( D ) or IsNearring( D ) or IsSemigroup( D ) then
    D.operations.DisplayTable( D ); 
  else
    Error( "Usage: DisplayCayleyTable( <D> ) where <D> must be a semigroup",
           " or a group\nor a nearring" );
  fi;
end;

#############################################################################
##
#F  Identity( <D> ). . . . . . . . . . . . . compute identity of a domain <D>
##
##  Dispatcher function to compute the identity of a domain <D> where <D> is
##  a nearring or a semigroup.
##
Identity := function( D )
  
  if not ( IsTransformationSemigroup( D ) or IsNearring( D ) ) then
    Error( "Usage: Identity( <D> ) where <D> must be a",
           " nearring or a\ntransformation semigroup" );
  fi;

  if not IsBound( D.identity ) then
    D.identity := D.operations.Identity( D );
  fi;

  return D.identity;
end;

#############################################################################
##
#F  IsCommutative( <D> ) . . . . . . . . . test commutativity of a domain <D>
##
##  Dispatcher function to test if a domain <D> is commutative where <D> is
##  a nearring or a semigroup.
##
IsCommutative := function( D )
  
  if not ( IsTransformationSemigroup( D ) or IsNearring( D ) ) then
    Error( "Usage: IsCommutative( <D> ) where <D> must be a",
           " nearring or a\ntransformation semigroup" );
  fi;

  if not IsBound( D.isCommutative ) then
    D.isCommutative := D.operations.IsCommutative( D );
  fi;

  return D.isCommutative;
end;

