/* ========================== C MeatAxe =============================
   Standard basis.

   (C) Copyright 1994 Michael Ringe, Lehrstuhl D fuer Mathematik,
   RWTH Aachen, Germany  <mringe@tiffy.math.rwth-aachen.de>
   This program is free software; see the file COPYING for details.
   ================================================================== */


/* $Id: zsbasis.c,v 1.1.1.1 1996/12/11 12:40:15 werner Exp $
 *
 * $Log: zsbasis.c,v $
 * Revision 1.1.1.1  1996/12/11 12:40:15  werner
 * Preparing 3.4.4 for release
 *
 * Revision 1.1  1994/05/18  10:06:40  mringe
 * Initial revision
 *
 * Revision 1.1  1994/05/18  10:06:40  mringe
 * Initial revision
 *
 */


#include <stdlib.h>
#include "meataxe.h"


int zsbasis(seed,nseed,ngen,gen,space,piv,basis)
PTR seed;
long nseed;
int ngen;
PTR *gen;
PTR space;
long *piv;
PTR basis;

{
    long i, k, seedcount;
    PTR xi, yi, xk, yk;
    FEL f;
    int igen;

    /* Initialize
       ---------- */
    if (zfindpiv(seed,&f) == 0) MTXFAIL(ERR_BADARG,-1);
    zmoverow(space,seed);
    zmoverow(basis,seed);
    i = 1; xi = space; yi = basis;
    k = 1; xk = space; yk = basis;
    seedcount = 1;
    igen = -1;

    while (1)
    {
	/* Clean and check if we got a new vector
	   -------------------------------------- */
	zcleanrow(xk,space,k-1,piv);
	if ((piv[k] = zfindpiv(xk,&f)) != 0)
	{
	    if (k++ == znoc) break;		/* Finished */
	    zadvance(&xk,(long)1);
	    zadvance(&yk,(long)1);
	}

	/* Apply the next generator
	   ------------------------ */
	if (++igen >= ngen)	/* Done, proceed with next vector */
	{
	    igen = 0;
	    if (++i >= k)	/* Take next seed vector */
	    {
		if (seedcount >= nseed) break;
		++seedcount;
		zadvance(&seed,(long)1);
		zmoverow(yk,seed);
		zmoverow(xk,seed);
		continue;
	    }
	    zadvance(&xi,(long)1);
	    zadvance(&yi,(long)1);
	}
	zmaprow(yi,gen[igen],znoc,yk);
	zmoverow(xk,yk);
    }
    if (k <= znoc) return 2;		/* Failed */
    if (seedcount > 1) return 1;	/* Used more than one vector */
    return 0;				/* Success */
}


